# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.function_set import FunctionSet


class AbstractInterpolatedVelocityField(FunctionSet):
    r"""
    AbstractInterpolatedVelocityField - An abstract class for
     obtaining the interpolated velocity values at a point
    
    Superclass: FunctionSet
    
    AbstractInterpolatedVelocityField acts as a continuous velocity
    field
     by performing cell interpolation on the underlying DataSet (or in
    the
     case of CompositeInterpolatedVelocityField,
     CompositeDataSets). This is an abstract sub-class of
    FunctionSet,
     number_of_independent_variables = 4 (x,y,z,t) and number_of_functions = 3
     (u,v,w). With a brute-force scheme, every time an evaluation is
     performed, the target cell containing point (x,y,z) needs to be
    found by
     calling find_cell(); however AbstractInterpolatedVelocityField
    uses
     locators to accelerate this operation via an instance of
     FindCellStrategy. Even with the use of locators, the cost of the
    find
     cell operation can be large, hence this class performs local caching
    to
     reduce the number of invocations of find_cell(). As a result, this
    class
     is not thread safe as it contains local state (such as the cache
     information). Writing a threaded operations requires separate
    instances of
     AbstractInterpolatedVelocityField for each thread.
    
    
     For CompositeInterpolatedVelocityField with CLOSEST_POINT
    strategy,
     level #0 begins with intra-cell caching.
     Specifically if the previous cell is valid and the next point is
    still in
     it ( i.e., Cell::EvaluatePosition() returns 1, coupled with newly
    created
     parametric coordinates & weights ), the function values can be
    interpolated
     and only Cell::EvaluatePosition() is invoked. If this fails, then
    level #1
     follows by inter-cell search for the target cell that contains the
    next point.
     By an inter-cell search, the previous cell provides an important
    clue or serves
     as an immediate neighbor to aid in locating the target cell via
    PointSet::
     find_cell(). If this still fails, a global cell location / search is
    invoked via
     FindCellStrategy. Finally, if this operation fails, the
    streamline is
     considered terminated.
    
    
     Note the particular find cell strategy employed can affect the
    behavior
     of this class. If the strategy involved using a point locator (e.g.,
     StaticPointLocator or PointLocator via ClosestPointStrategy
    or
     ClosestNPointsStrategy) the performance of the class improves to
    the
     detriment of robustness. Using a cell locator (e.g.,
    StaticCellLocator
     or CellLocator via CellLocatorStrategy) improves robustness at
    some
     cost to performance. Originally, these different behaviors (i.e.,
    using
     different locators) was codified into different subclasses of
     AbstractInterpolatedVelocityField.
    
    
     Note that topologically structured classes such as ImageData and
     RectilinearGrid are able to provide fast robust cell location.
    Hence
     the specified find cell strategy is only applicable to subclasses of
     PointSet (such as UnstructuredGrid).
    
    @warning
     AbstractInterpolatedVelocityField is not thread safe. A new
    instance
     should be created by each thread.
    
    @sa
     CompositeInterpolatedVelocityField
    AMRInterpolatedVelocityField
     GenericInterpolatedVelocityField
    CachingInterpolatedVelocityField
     TemporalInterpolatedVelocityField FunctionSet StreamTracer
     FindCellStrategy
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkAbstractInterpolatedVelocityField, obj, update, **traits)
    
    caching = traits.Bool(True, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the caching flag. If this flag is turned ON, there are
        two levels of caching for when the strategy is CLOSEST_POINT and
        one level of caching when the strategy is CELL_LOCATOR. Otherwise
        a global cell location is always invoked for evaluating the
        function values at any point.
        """
    )

    def _caching_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetCaching,
                        self.caching)

    def _get_find_cell_strategy(self):
        return wrap_vtk(self._vtk_obj.GetFindCellStrategy())
    def _set_find_cell_strategy(self, arg):
        old_val = self._get_find_cell_strategy()
        self._wrap_call(self._vtk_obj.SetFindCellStrategy,
                        deref_vtk(arg))
        self.trait_property_changed('find_cell_strategy', old_val, arg)
    find_cell_strategy = traits.Property(_get_find_cell_strategy, _set_find_cell_strategy, desc=\
        r"""
        
        """
    )

    force_surface_tangent_vector = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        If set to true, the first three point of the cell will be used to
        compute a normal to the cell, this normal will then be removed
        from the vorticity so the resulting vector in tangent to the
        cell.
        """
    )

    def _force_surface_tangent_vector_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetForceSurfaceTangentVector,
                        self.force_surface_tangent_vector)

    last_cell_id = traits.Int(-1, enter_set=True, auto_set=False, desc=\
        r"""
        
        """
    )

    def _last_cell_id_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLastCellId,
                        self.last_cell_id)

    normalize_vector = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the flag indicating vector post-normalization (following
        vector interpolation). Vector post-normalization is required to
        avoid the 'curve-overshooting' problem (caused by high velocity
        magnitude) that occurs when Cell-Length is used as the step size
        unit (particularly the Minimum step size unit). Furthermore, it
        is required by RK45 to achieve, as expected, high numerical
        accuracy (or high smoothness of flow lines) through adaptive step
        sizing. Note this operation is performed (when normalize_vector
        TRUE) right after vector interpolation such that the differing
        amount of contribution of each node (of a cell) to the resulting
        direction of the interpolated vector, due to the possibly
        significantly-differing velocity magnitude values at the nodes
        (which is the case with large cells), can be reflected as is.
        Also note that this flag needs to be turned to FALSE after
        InitialValueProblemSolver:: compute_next_step() as subsequent
        operations, e.g., vorticity computation, may need non-normalized
        vectors.
        """
    )

    def _normalize_vector_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetNormalizeVector,
                        self.normalize_vector)

    surface_dataset = traits.Bool(False, enter_set=True, auto_set=False, desc=\
        r"""
        If set to true, cell within tolerance factor will always be
        found, except for edges.
        """
    )

    def _surface_dataset_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetSurfaceDataset,
                        self.surface_dataset)

    def _get_cache_hit(self):
        return self._vtk_obj.GetCacheHit()
    cache_hit = traits.Property(_get_cache_hit, desc=\
        r"""
        Get the caching statistics. cache_hit refers to the number of
        level #0 cache hits while cache_miss is the number of level #0
        cache misses.
        """
    )

    def _get_cache_miss(self):
        return self._vtk_obj.GetCacheMiss()
    cache_miss = traits.Property(_get_cache_miss, desc=\
        r"""
        
        """
    )

    def _get_initialization_state(self):
        return self._vtk_obj.GetInitializationState()
    initialization_state = traits.Property(_get_initialization_state, desc=\
        r"""
        
        """
    )

    def _get_last_data_set(self):
        return wrap_vtk(self._vtk_obj.GetLastDataSet())
    last_data_set = traits.Property(_get_last_data_set, desc=\
        r"""
        
        """
    )

    def get_last_local_coordinates(self, *args):
        """
        get_last_local_coordinates(self, pcoords:[float, float, float])
            -> int
        C++: int get_last_local_coordinates(double pcoords[3])"""
        ret = self._wrap_call(self._vtk_obj.GetLastLocalCoordinates, *args)
        return ret

    def get_last_weights(self, *args):
        """
        get_last_weights(self, w:[float, ...]) -> int
        C++: int get_last_weights(double *w)
        Get the interpolation weights cached from last evaluation. Return
        1 if the cached cell is valid and 0 otherwise.
        """
        ret = self._wrap_call(self._vtk_obj.GetLastWeights, *args)
        return ret

    def _get_vectors_selection(self):
        return self._vtk_obj.GetVectorsSelection()
    vectors_selection = traits.Property(_get_vectors_selection, desc=\
        r"""
        Get/Set the name of a specified vector array. By default it is
        nullptr, with the active vector array for use.
        """
    )

    def _get_vectors_type(self):
        return self._vtk_obj.GetVectorsType()
    vectors_type = traits.Property(_get_vectors_type, desc=\
        r"""
        
        """
    )

    def clear_last_cell_id(self):
        """
        clear_last_cell_id(self) -> None
        C++: void clear_last_cell_id()
        Set the last cell id to -1 to incur a global cell search for the
        next point.
        """
        ret = self._vtk_obj.ClearLastCellId()
        return ret
        

    def copy_parameters(self, *args):
        """
        copy_parameters(self, from_:AbstractInterpolatedVelocityField)
            -> None
        C++: virtual void copy_parameters(
            AbstractInterpolatedVelocityField *from)
        Copy essential parameters between instances of this class. This
        generally is used to copy from instance prototype to another, or
        to copy interpolators between thread instances.  Sub-classes can
        contribute to the parameter copying process via chaining.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.CopyParameters, *my_args)
        return ret

    def initialize(self, *args):
        """
        initialize(self, compDS:CompositeDataSet, initStrategy:int=...)
             -> None
        C++: virtual void initialize(CompositeDataSet *compDS,
            int initStrategy=INITIALIZE_ALL_DATASETS)
        The Initialize() method is used to build and cache supporting
        structures (such as locators) which are used when operating on
        the interpolated velocity field. This method is needed mainly to
        deal with thread safety issues; i.e., these supporting structures
        must be built at the right time to avoid race conditions.
        Currently this method is used by StreamTracer (and related
        classes) which process composite datasets (in the future other
        dataset types may be supported). Also, a initialization strategy
        can be specified which controls how the initialization process
        functions (this is a API placeholder for the future). Note that
        some subclasses may override the initialize method (via
        self_initialize()) because they have special methods of setting up
        the interpolated velocity field.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.Initialize, *my_args)
        return ret

    def select_vectors(self, *args):
        """
        select_vectors(self, fieldAssociation:int, fieldName:str) -> None
        C++: void select_vectors(int fieldAssociation,
            const char *fieldName)
        the association type (see DataObject::FieldAssociations) and
        the name of the velocity data field
        """
        ret = self._wrap_call(self._vtk_obj.SelectVectors, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('caching', 'GetCaching'),
    ('force_surface_tangent_vector', 'GetForceSurfaceTangentVector'),
    ('last_cell_id', 'GetLastCellId'), ('normalize_vector',
    'GetNormalizeVector'), ('surface_dataset', 'GetSurfaceDataset'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'caching',
    'force_surface_tangent_vector', 'last_cell_id', 'normalize_vector',
    'object_name', 'surface_dataset'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(AbstractInterpolatedVelocityField, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit AbstractInterpolatedVelocityField properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['caching', 'force_surface_tangent_vector',
            'last_cell_id', 'normalize_vector', 'object_name',
            'surface_dataset']),
            title='Edit AbstractInterpolatedVelocityField properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit AbstractInterpolatedVelocityField properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

