/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import sun.misc.SoftCache;

public class ObjectStreamClass
implements Serializable {
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static final long serialVersionUID = -6120832682080437368L;
    private static final ObjectStreamField[] serialPersistentFields = NO_FIELDS;
    private static final SoftCache localDescs = new SoftCache(10);
    private static final SoftCache reflectors = new SoftCache(10);
    private Class cl;
    private String name;
    private volatile Long suid;
    private boolean isProxy;
    private boolean serializable;
    private boolean externalizable;
    private boolean hasWriteObjectData;
    private boolean hasBlockExternalData = true;
    private ClassNotFoundException resolveEx;
    private InvalidClassException deserializeEx;
    private InvalidClassException defaultSerializeEx;
    private ObjectStreamField[] fields;
    private int primDataSize;
    private int numObjFields;
    private FieldReflector fieldRefl;
    private volatile ClassDataSlot[] dataLayout;
    private Method writeObjectMethod;
    private Method readObjectMethod;
    private Method readObjectNoDataMethod;
    private Method writeReplaceMethod;
    private Method readResolveMethod;
    private ObjectStreamClass localDesc;
    private ObjectStreamClass superDesc;
    private Class initClass;
    static /* synthetic */ Class class$java$io$ObjectOutputStream;
    static /* synthetic */ Class class$java$io$ObjectInputStream;
    static /* synthetic */ Class class$java$lang$Object;

    private static native void initNative();

    private static native void getFieldIDs(ObjectStreamField[] var0, long[] var1, long[] var2);

    public static ObjectStreamClass lookup(Class clazz) {
        return ObjectStreamClass.lookup(clazz, false);
    }

    public String getName() {
        return this.name;
    }

    public long getSerialVersionUID() {
        if (this.suid == null) {
            this.suid = (Long)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return new Long(ObjectStreamClass.computeDefaultSUID(ObjectStreamClass.this.cl));
                }
            });
        }
        return this.suid;
    }

    public Class forClass() {
        return this.cl;
    }

    public ObjectStreamField[] getFields() {
        return this.getFields(true);
    }

    public ObjectStreamField getField(String string) {
        return this.getField(string, null);
    }

    public String toString() {
        return this.name + ": static final long serialVersionUID = " + this.getSerialVersionUID() + "L;";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ObjectStreamClass lookup(Class clazz, boolean bl) {
        Object object;
        if (!bl && !Serializable.class.isAssignableFrom(clazz)) {
            return null;
        }
        EntryFuture entryFuture = null;
        SoftCache softCache = localDescs;
        synchronized (softCache) {
            object = localDescs.get(clazz);
            if (object == null) {
                entryFuture = new EntryFuture();
                localDescs.put(clazz, entryFuture);
            }
        }
        if (object instanceof ObjectStreamClass) {
            return (ObjectStreamClass)object;
        }
        if (object instanceof EntryFuture) {
            object = ((EntryFuture)object).get();
        } else if (object == null) {
            try {
                object = new ObjectStreamClass(clazz);
            }
            catch (Throwable throwable) {
                object = throwable;
            }
            entryFuture.set(object);
            softCache = localDescs;
            synchronized (softCache) {
                localDescs.put(clazz, object);
            }
        }
        if (object instanceof ObjectStreamClass) {
            return (ObjectStreamClass)object;
        }
        if (object instanceof RuntimeException) {
            throw (RuntimeException)object;
        }
        if (object instanceof Error) {
            throw (Error)object;
        }
        throw new InternalError("unexpected entry: " + object);
    }

    private ObjectStreamClass(final Class clazz) {
        this.cl = clazz;
        this.name = clazz.getName();
        this.isProxy = Proxy.isProxyClass(clazz);
        this.serializable = Serializable.class.isAssignableFrom(clazz);
        this.externalizable = Externalizable.class.isAssignableFrom(clazz);
        Class clazz2 = clazz.getSuperclass();
        this.superDesc = clazz2 != null ? ObjectStreamClass.lookup(clazz2, false) : null;
        this.localDesc = this;
        if (this.serializable) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ObjectStreamClass.this.suid = ObjectStreamClass.getDeclaredSUID(clazz);
                    ObjectStreamClass.access$502(ObjectStreamClass.this, ObjectStreamClass.getSerialFields(clazz));
                    ObjectStreamClass.this.computeFieldOffsets();
                    if (ObjectStreamClass.this.externalizable) {
                        ObjectStreamClass.this.initClass = clazz;
                    } else {
                        ObjectStreamClass.this.initClass = ObjectStreamClass.getSerializableInitClass(clazz);
                        ObjectStreamClass.this.writeObjectMethod = ObjectStreamClass.getPrivateMethod(clazz, "writeObject", new Class[]{class$java$io$ObjectOutputStream == null ? (class$java$io$ObjectOutputStream = ObjectStreamClass.class$("java.io.ObjectOutputStream")) : class$java$io$ObjectOutputStream}, Void.TYPE);
                        ObjectStreamClass.this.readObjectMethod = ObjectStreamClass.getPrivateMethod(clazz, "readObject", new Class[]{class$java$io$ObjectInputStream == null ? (class$java$io$ObjectInputStream = ObjectStreamClass.class$("java.io.ObjectInputStream")) : class$java$io$ObjectInputStream}, Void.TYPE);
                        ObjectStreamClass.this.readObjectNoDataMethod = ObjectStreamClass.getPrivateMethod(clazz, "readObjectNoData", new Class[0], Void.TYPE);
                        ObjectStreamClass.this.hasWriteObjectData = ObjectStreamClass.this.writeObjectMethod != null;
                    }
                    ObjectStreamClass.this.writeReplaceMethod = ObjectStreamClass.getInheritableMethod(clazz, "writeReplace", new Class[]{}, class$java$lang$Object == null ? (class$java$lang$Object = ObjectStreamClass.class$("java.lang.Object")) : class$java$lang$Object);
                    ObjectStreamClass.this.readResolveMethod = ObjectStreamClass.getInheritableMethod(clazz, "readResolve", new Class[]{}, class$java$lang$Object == null ? (class$java$lang$Object = ObjectStreamClass.class$("java.lang.Object")) : class$java$lang$Object);
                    return null;
                }
            });
        } else {
            this.suid = new Long(0L);
            this.fields = NO_FIELDS;
        }
        try {
            this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this);
        }
        catch (InvalidClassException invalidClassException) {
            throw new InternalError();
        }
        if (this.initClass == null) {
            this.deserializeEx = new InvalidClassException(this.name, "no valid constructor");
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (this.fields[i].getField() != null) continue;
            this.defaultSerializeEx = new InvalidClassException(this.name, "unmatched serializable field(s) declared");
        }
    }

    ObjectStreamClass() {
    }

    void initProxy(Class clazz, ClassNotFoundException classNotFoundException, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        this.cl = clazz;
        this.resolveEx = classNotFoundException;
        this.superDesc = objectStreamClass;
        this.isProxy = true;
        this.serializable = true;
        this.suid = new Long(0L);
        this.fields = NO_FIELDS;
        if (clazz != null) {
            this.localDesc = ObjectStreamClass.lookup(clazz, true);
            if (!this.localDesc.isProxy) {
                throw new InvalidClassException("cannot bind proxy descriptor to a non-proxy class");
            }
            this.name = this.localDesc.name;
            this.externalizable = this.localDesc.externalizable;
            this.initClass = this.localDesc.initClass;
            this.writeReplaceMethod = this.localDesc.writeReplaceMethod;
            this.readResolveMethod = this.localDesc.readResolveMethod;
            this.deserializeEx = this.localDesc.deserializeEx;
        }
        this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this.localDesc);
    }

    void initNonProxy(ObjectStreamClass objectStreamClass, Class clazz, ClassNotFoundException classNotFoundException, ObjectStreamClass objectStreamClass2) throws InvalidClassException {
        this.cl = clazz;
        this.resolveEx = classNotFoundException;
        this.superDesc = objectStreamClass2;
        this.name = objectStreamClass.name;
        this.suid = new Long(objectStreamClass.getSerialVersionUID());
        this.isProxy = false;
        this.serializable = objectStreamClass.serializable;
        this.externalizable = objectStreamClass.externalizable;
        this.hasBlockExternalData = objectStreamClass.hasBlockExternalData;
        this.hasWriteObjectData = objectStreamClass.hasWriteObjectData;
        this.fields = objectStreamClass.fields;
        this.primDataSize = objectStreamClass.primDataSize;
        this.numObjFields = objectStreamClass.numObjFields;
        if (clazz != null) {
            this.localDesc = ObjectStreamClass.lookup(clazz, true);
            if (this.localDesc.isProxy) {
                throw new InvalidClassException("cannot bind non-proxy descriptor to a proxy class");
            }
            if (this.serializable == this.localDesc.serializable && !clazz.isArray() && this.suid.longValue() != this.localDesc.getSerialVersionUID()) {
                throw new InvalidClassException(this.localDesc.name, "local class incompatible: stream classdesc serialVersionUID = " + this.suid + ", local class serialVersionUID = " + this.localDesc.getSerialVersionUID());
            }
            if (!ObjectStreamClass.classNamesEqual(this.name, this.localDesc.name)) {
                throw new InvalidClassException(this.localDesc.name, "local class name incompatible with stream class name \"" + this.name + "\"");
            }
            if (this.serializable == this.localDesc.serializable && this.externalizable != this.localDesc.externalizable) {
                throw new InvalidClassException(this.localDesc.name, "Serializable incompatible with Externalizable");
            }
            if (this.serializable != this.localDesc.serializable || this.externalizable != this.localDesc.externalizable || !this.serializable && !this.externalizable) {
                this.deserializeEx = new InvalidClassException(this.localDesc.name, "class invalid for deserialization");
            }
            this.initClass = this.localDesc.initClass;
            this.writeObjectMethod = this.localDesc.writeObjectMethod;
            this.readObjectMethod = this.localDesc.readObjectMethod;
            this.readObjectNoDataMethod = this.localDesc.readObjectNoDataMethod;
            this.writeReplaceMethod = this.localDesc.writeReplaceMethod;
            this.readResolveMethod = this.localDesc.readResolveMethod;
            if (this.deserializeEx == null) {
                this.deserializeEx = this.localDesc.deserializeEx;
            }
        }
        this.fieldRefl = ObjectStreamClass.getReflector(this.fields, this.localDesc);
        this.fields = this.fieldRefl.getFields();
    }

    void readNonProxy(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.name = objectInputStream.readUTF();
        this.suid = new Long(objectInputStream.readLong());
        this.isProxy = false;
        byte by = objectInputStream.readByte();
        this.externalizable = (by & 4) != 0;
        this.serializable = this.externalizable || (by & 2) != 0;
        this.hasWriteObjectData = (by & 1) != 0;
        this.hasBlockExternalData = (by & 8) != 0;
        int n = objectInputStream.readShort();
        this.fields = n > 0 ? new ObjectStreamField[n] : NO_FIELDS;
        for (int i = 0; i < n; ++i) {
            char c = (char)objectInputStream.readByte();
            String string = objectInputStream.readUTF();
            String string2 = c == 'L' || c == '[' ? objectInputStream.readTypeString() : new String(new char[]{c});
            this.fields[i] = new ObjectStreamField(string, string2, false);
        }
        this.computeFieldOffsets();
    }

    void writeNonProxy(ObjectOutputStream objectOutputStream) throws IOException {
        int n;
        objectOutputStream.writeUTF(this.name);
        objectOutputStream.writeLong(this.getSerialVersionUID());
        int n2 = 0;
        if (this.externalizable) {
            n2 = (byte)(n2 | 4);
            n = objectOutputStream.getProtocolVersion();
            if (n != 1) {
                n2 = (byte)(n2 | 8);
            }
        } else if (this.serializable) {
            n2 = (byte)(n2 | 2);
        }
        if (this.hasWriteObjectData) {
            n2 = (byte)(n2 | 1);
        }
        objectOutputStream.writeByte(n2);
        objectOutputStream.writeShort(this.fields.length);
        for (n = 0; n < this.fields.length; ++n) {
            ObjectStreamField objectStreamField = this.fields[n];
            objectOutputStream.writeByte(objectStreamField.getTypeCode());
            objectOutputStream.writeUTF(objectStreamField.getName());
            if (objectStreamField.isPrimitive()) continue;
            objectOutputStream.writeTypeString(objectStreamField.getTypeString());
        }
    }

    ClassNotFoundException getResolveException() {
        return this.resolveEx;
    }

    void checkDeserialize() throws InvalidClassException {
        if (this.deserializeEx != null) {
            throw this.deserializeEx;
        }
    }

    void checkDefaultSerialize() throws InvalidClassException {
        if (this.defaultSerializeEx != null) {
            throw this.defaultSerializeEx;
        }
    }

    ObjectStreamClass getSuperDesc() {
        return this.superDesc;
    }

    ObjectStreamClass getLocalDesc() {
        return this.localDesc;
    }

    ObjectStreamField[] getFields(boolean bl) {
        return bl ? (ObjectStreamField[])this.fields.clone() : this.fields;
    }

    ObjectStreamField getField(String string, Class clazz) {
        for (int i = 0; i < this.fields.length; ++i) {
            Class clazz2;
            ObjectStreamField objectStreamField = this.fields[i];
            if (!objectStreamField.getName().equals(string)) continue;
            if (clazz == null) {
                return objectStreamField;
            }
            Class clazz3 = class$java$lang$Object == null ? ObjectStreamClass.class$("java.lang.Object") : class$java$lang$Object;
            if (!(clazz == clazz3 ? !objectStreamField.isPrimitive() : (clazz2 = objectStreamField.getType()) != null && clazz.isAssignableFrom(clazz2))) continue;
            return objectStreamField;
        }
        return null;
    }

    boolean isProxy() {
        return this.isProxy;
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    boolean isSerializable() {
        return this.serializable;
    }

    boolean hasBlockExternalData() {
        return this.hasBlockExternalData;
    }

    boolean hasWriteObjectData() {
        return this.hasWriteObjectData;
    }

    boolean isInstantiable() {
        return this.initClass != null;
    }

    boolean hasWriteObjectMethod() {
        return this.writeObjectMethod != null;
    }

    boolean hasReadObjectMethod() {
        return this.readObjectMethod != null;
    }

    boolean hasReadObjectNoDataMethod() {
        return this.readObjectNoDataMethod != null;
    }

    boolean hasWriteReplaceMethod() {
        return this.writeReplaceMethod != null;
    }

    boolean hasReadResolveMethod() {
        return this.readResolveMethod != null;
    }

    Object newInstance() throws InstantiationException, InvocationTargetException, UnsupportedOperationException, IllegalAccessException {
        if (this.initClass != null) {
            return ObjectInputStream.allocateNewObject(this.cl, this.initClass);
        }
        throw new UnsupportedOperationException();
    }

    void invokeWriteObject(Object object, ObjectOutputStream objectOutputStream) throws IOException, UnsupportedOperationException {
        if (this.writeObjectMethod != null) {
            try {
                this.writeObjectMethod.invoke(object, new Object[]{objectOutputStream});
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                ObjectStreamClass.throwMiscException(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    void invokeReadObject(Object object, ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, UnsupportedOperationException {
        if (this.readObjectMethod != null) {
            try {
                this.readObjectMethod.invoke(object, new Object[]{objectInputStream});
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)throwable;
                }
                if (throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                ObjectStreamClass.throwMiscException(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    void invokeReadObjectNoData(Object object) throws IOException, UnsupportedOperationException {
        if (this.readObjectNoDataMethod != null) {
            try {
                this.readObjectNoDataMethod.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ObjectStreamException) {
                    throw (ObjectStreamException)throwable;
                }
                ObjectStreamClass.throwMiscException(throwable);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError();
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    Object invokeWriteReplace(Object object) throws IOException, UnsupportedOperationException {
        if (this.writeReplaceMethod != null) {
            try {
                return this.writeReplaceMethod.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ObjectStreamException) {
                    throw (ObjectStreamException)throwable;
                }
                ObjectStreamClass.throwMiscException(throwable);
                throw new InternalError();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError();
            }
        }
        throw new UnsupportedOperationException();
    }

    Object invokeReadResolve(Object object) throws IOException, UnsupportedOperationException {
        if (this.readResolveMethod != null) {
            try {
                return this.readResolveMethod.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof ObjectStreamException) {
                    throw (ObjectStreamException)throwable;
                }
                ObjectStreamClass.throwMiscException(throwable);
                throw new InternalError();
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError();
            }
        }
        throw new UnsupportedOperationException();
    }

    ClassDataSlot[] getClassDataLayout() throws InvalidClassException {
        if (this.dataLayout == null) {
            this.dataLayout = this.getClassDataLayout0();
        }
        return this.dataLayout;
    }

    private ClassDataSlot[] getClassDataLayout0() throws InvalidClassException {
        Class clazz;
        ArrayList arrayList = new ArrayList();
        Class clazz2 = this.cl;
        for (clazz = this.cl; clazz != null && (class$java$io$Serializable == null ? ObjectStreamClass.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(clazz); clazz = clazz.getSuperclass()) {
        }
        Serializable serializable = this;
        while (serializable != null) {
            Class clazz3;
            String string = ((ObjectStreamClass)serializable).cl != null ? ((ObjectStreamClass)serializable).cl.getName() : ((ObjectStreamClass)serializable).name;
            Class clazz4 = null;
            for (clazz3 = clazz2; clazz3 != clazz; clazz3 = clazz3.getSuperclass()) {
                if (!string.equals(clazz3.getName())) continue;
                clazz4 = clazz3;
                break;
            }
            if (clazz4 != null) {
                for (clazz3 = clazz2; clazz3 != clazz4; clazz3 = clazz3.getSuperclass()) {
                    arrayList.add(new ClassDataSlot(ObjectStreamClass.lookup(clazz3, true), false));
                }
                clazz2 = clazz4.getSuperclass();
            }
            arrayList.add(new ClassDataSlot(super.getVariantFor(clazz4), true));
            serializable = ((ObjectStreamClass)serializable).superDesc;
        }
        for (serializable = clazz2; serializable != clazz; serializable = ((Class)serializable).getSuperclass()) {
            arrayList.add(new ClassDataSlot(ObjectStreamClass.lookup((Class)serializable, true), false));
        }
        Collections.reverse(arrayList);
        return (ClassDataSlot[])arrayList.toArray(new ClassDataSlot[arrayList.size()]);
    }

    int getPrimDataSize() {
        return this.primDataSize;
    }

    int getNumObjFields() {
        return this.numObjFields;
    }

    void getPrimFieldValues(Object object, byte[] byArray) {
        this.fieldRefl.getPrimFieldValues(object, byArray);
    }

    void setPrimFieldValues(Object object, byte[] byArray) {
        this.fieldRefl.setPrimFieldValues(object, byArray);
    }

    void getObjFieldValues(Object object, Object[] objectArray) {
        this.fieldRefl.getObjFieldValues(object, objectArray);
    }

    void setObjFieldValues(Object object, Object[] objectArray) {
        this.fieldRefl.setObjFieldValues(object, objectArray);
    }

    private void computeFieldOffsets() {
        this.primDataSize = 0;
        this.numObjFields = 0;
        block7: for (int i = 0; i < this.fields.length; ++i) {
            ObjectStreamField objectStreamField = this.fields[i];
            switch (objectStreamField.getTypeCode()) {
                case 'B': 
                case 'Z': {
                    objectStreamField.setOffset(this.primDataSize++);
                    continue block7;
                }
                case 'C': 
                case 'S': {
                    objectStreamField.setOffset(this.primDataSize);
                    this.primDataSize += 2;
                    continue block7;
                }
                case 'F': 
                case 'I': {
                    objectStreamField.setOffset(this.primDataSize);
                    this.primDataSize += 4;
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    objectStreamField.setOffset(this.primDataSize);
                    this.primDataSize += 8;
                    continue block7;
                }
                case 'L': 
                case '[': {
                    objectStreamField.setOffset(this.numObjFields++);
                    continue block7;
                }
                default: {
                    throw new InternalError();
                }
            }
        }
    }

    private ObjectStreamClass getVariantFor(Class clazz) throws InvalidClassException {
        if (this.cl == clazz) {
            return this;
        }
        ObjectStreamClass objectStreamClass = new ObjectStreamClass();
        if (this.isProxy) {
            objectStreamClass.initProxy(clazz, null, this.superDesc);
        } else {
            objectStreamClass.initNonProxy(this, clazz, null, this.superDesc);
        }
        return objectStreamClass;
    }

    private static Class getSerializableInitClass(Class clazz) {
        Class clazz2 = clazz;
        while ((class$java$io$Serializable == null ? ObjectStreamClass.class$("java.io.Serializable") : class$java$io$Serializable).isAssignableFrom(clazz2)) {
            if ((clazz2 = clazz2.getSuperclass()) != null) continue;
            return null;
        }
        return clazz2;
    }

    private static Method getInheritableMethod(Class clazz, String string, Class[] classArray, Class clazz2) {
        Class clazz3;
        Method method = null;
        for (clazz3 = clazz; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            try {
                method = clazz3.getDeclaredMethod(string, classArray);
                break;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                continue;
            }
        }
        if (method == null || method.getReturnType() != clazz2) {
            return null;
        }
        method.setAccessible(true);
        int n = method.getModifiers();
        if ((n & 0x408) != 0) {
            return null;
        }
        if ((n & 5) != 0) {
            return method;
        }
        if ((n & 2) != 0) {
            return clazz == clazz3 ? method : null;
        }
        return ObjectStreamClass.packageEquals(clazz, clazz3) ? method : null;
    }

    private static Method getPrivateMethod(Class clazz, String string, Class[] classArray, Class clazz2) {
        try {
            Method method = clazz.getDeclaredMethod(string, classArray);
            method.setAccessible(true);
            int n = method.getModifiers();
            return method.getReturnType() == clazz2 && (n & 8) == 0 && (n & 2) != 0 ? method : null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    private static boolean packageEquals(Class clazz, Class clazz2) {
        Package package_;
        Package package_2 = clazz.getPackage();
        return package_2 == (package_ = clazz2.getPackage()) || package_2 != null && package_2.equals(package_);
    }

    private static boolean classNamesEqual(String string, String string2) {
        string = string.substring(string.lastIndexOf(46) + 1);
        string2 = string2.substring(string2.lastIndexOf(46) + 1);
        return string.equals(string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getClassSignature(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        while (clazz.isArray()) {
            stringBuffer.append('[');
            clazz = clazz.getComponentType();
        }
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                stringBuffer.append('I');
                return stringBuffer.toString();
            } else if (clazz == Byte.TYPE) {
                stringBuffer.append('B');
                return stringBuffer.toString();
            } else if (clazz == Long.TYPE) {
                stringBuffer.append('J');
                return stringBuffer.toString();
            } else if (clazz == Float.TYPE) {
                stringBuffer.append('F');
                return stringBuffer.toString();
            } else if (clazz == Double.TYPE) {
                stringBuffer.append('D');
                return stringBuffer.toString();
            } else if (clazz == Short.TYPE) {
                stringBuffer.append('S');
                return stringBuffer.toString();
            } else if (clazz == Character.TYPE) {
                stringBuffer.append('C');
                return stringBuffer.toString();
            } else if (clazz == Boolean.TYPE) {
                stringBuffer.append('Z');
                return stringBuffer.toString();
            } else {
                if (clazz != Void.TYPE) throw new InternalError();
                stringBuffer.append('V');
            }
            return stringBuffer.toString();
        } else {
            stringBuffer.append('L' + clazz.getName().replace('.', '/') + ';');
        }
        return stringBuffer.toString();
    }

    private static String getMethodSignature(Class[] classArray, Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append(ObjectStreamClass.getClassSignature(classArray[i]));
        }
        stringBuffer.append(')');
        stringBuffer.append(ObjectStreamClass.getClassSignature(clazz));
        return stringBuffer.toString();
    }

    private static void throwMiscException(Throwable throwable) throws IOException {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        IOException iOException = new IOException("unexpected exception type : " + throwable);
        throw iOException;
    }

    private static ObjectStreamField[] getSerialFields(Class clazz) {
        Object[] objectArray;
        if (Serializable.class.isAssignableFrom(clazz) && !Externalizable.class.isAssignableFrom(clazz) && !Proxy.isProxyClass(clazz) && !clazz.isInterface()) {
            objectArray = ObjectStreamClass.getDeclaredSerialFields(clazz);
            if (objectArray == null) {
                objectArray = ObjectStreamClass.getDefaultSerialFields(clazz);
            }
            Arrays.sort(objectArray);
        } else {
            objectArray = NO_FIELDS;
        }
        return objectArray;
    }

    private static ObjectStreamField[] getDeclaredSerialFields(Class clazz) {
        int n;
        ObjectStreamField[] objectStreamFieldArray;
        ObjectStreamField[] objectStreamFieldArray2 = null;
        try {
            objectStreamFieldArray = clazz.getDeclaredField("serialPersistentFields");
            n = 26;
            if ((objectStreamFieldArray.getModifiers() & n) == n) {
                objectStreamFieldArray.setAccessible(true);
                objectStreamFieldArray2 = (ObjectStreamField[])objectStreamFieldArray.get(null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (objectStreamFieldArray2 == null) {
            return null;
        }
        if (objectStreamFieldArray2.length == 0) {
            return NO_FIELDS;
        }
        objectStreamFieldArray = new ObjectStreamField[objectStreamFieldArray2.length];
        for (n = 0; n < objectStreamFieldArray2.length; ++n) {
            ObjectStreamField objectStreamField = objectStreamFieldArray2[n];
            try {
                Field field = clazz.getDeclaredField(objectStreamField.getName());
                if (field.getType() == objectStreamField.getType() && (field.getModifiers() & 8) == 0) {
                    objectStreamFieldArray[n] = new ObjectStreamField(field, objectStreamField.isUnshared(), true);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (objectStreamFieldArray[n] != null) continue;
            objectStreamFieldArray[n] = new ObjectStreamField(objectStreamField.getName(), objectStreamField.getType(), objectStreamField.isUnshared());
        }
        return objectStreamFieldArray;
    }

    private static ObjectStreamField[] getDefaultSerialFields(Class clazz) {
        int n;
        Field[] fieldArray = clazz.getDeclaredFields();
        ArrayList arrayList = new ArrayList();
        int n2 = 136;
        for (n = 0; n < fieldArray.length; ++n) {
            if ((fieldArray[n].getModifiers() & n2) != 0) continue;
            arrayList.add(new ObjectStreamField(fieldArray[n], false, true));
        }
        n = arrayList.size();
        return n == 0 ? NO_FIELDS : (ObjectStreamField[])arrayList.toArray(new ObjectStreamField[n]);
    }

    private static Long getDeclaredSUID(Class clazz) {
        try {
            Field field = clazz.getDeclaredField("serialVersionUID");
            int n = 24;
            if ((field.getModifiers() & n) == n) {
                field.setAccessible(true);
                return new Long(field.getLong(null));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static long computeDefaultSUID(Class clazz) {
        if (!Serializable.class.isAssignableFrom(clazz) || Proxy.isProxyClass(clazz)) {
            return 0L;
        }
        try {
            int n;
            int n2;
            Object[] objectArray;
            int n3;
            Object[] objectArray2;
            Object[] objectArray3;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n4 = clazz.getModifiers() & 0x611;
            Method[] methodArray = clazz.getDeclaredMethods();
            if ((n4 & 0x200) != 0) {
                n4 = methodArray.length > 0 ? n4 | 0x400 : n4 & 0xFFFFFBFF;
            }
            dataOutputStream.writeInt(n4);
            if (!clazz.isArray()) {
                objectArray3 = clazz.getInterfaces();
                objectArray2 = new String[objectArray3.length];
                for (n3 = 0; n3 < objectArray3.length; ++n3) {
                    objectArray2[n3] = ((Class)objectArray3[n3]).getName();
                }
                Arrays.sort(objectArray2);
                for (n3 = 0; n3 < objectArray2.length; ++n3) {
                    dataOutputStream.writeUTF((String)objectArray2[n3]);
                }
            }
            objectArray3 = clazz.getDeclaredFields();
            objectArray2 = new MemberSignature[objectArray3.length];
            for (n3 = 0; n3 < objectArray3.length; ++n3) {
                objectArray2[n3] = new MemberSignature((Field)objectArray3[n3]);
            }
            Arrays.sort(objectArray2, new Comparator(){

                public int compare(Object object, Object object2) {
                    String string = ((MemberSignature)object).name;
                    String string2 = ((MemberSignature)object2).name;
                    return string.compareTo(string2);
                }
            });
            for (n3 = 0; n3 < objectArray2.length; ++n3) {
                objectArray = objectArray2[n3];
                n2 = objectArray.member.getModifiers();
                if ((n2 & 2) != 0 && (n2 & 0x88) != 0) continue;
                dataOutputStream.writeUTF(objectArray.name);
                dataOutputStream.writeInt(n2);
                dataOutputStream.writeUTF(objectArray.signature);
            }
            if (ObjectStreamClass.hasStaticInitializer(clazz)) {
                dataOutputStream.writeUTF("<clinit>");
                dataOutputStream.writeInt(8);
                dataOutputStream.writeUTF("()V");
            }
            Constructor[] constructorArray = clazz.getDeclaredConstructors();
            objectArray = new MemberSignature[constructorArray.length];
            for (n2 = 0; n2 < constructorArray.length; ++n2) {
                objectArray[n2] = new MemberSignature(constructorArray[n2]);
            }
            Arrays.sort(objectArray, new Comparator(){

                public int compare(Object object, Object object2) {
                    String string = ((MemberSignature)object).signature;
                    String string2 = ((MemberSignature)object2).signature;
                    return string.compareTo(string2);
                }
            });
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                Object object = objectArray[n2];
                int n5 = ((MemberSignature)object).member.getModifiers();
                if ((n5 & 2) != 0) continue;
                dataOutputStream.writeUTF("<init>");
                dataOutputStream.writeInt(n5);
                dataOutputStream.writeUTF(((MemberSignature)object).signature.replace('/', '.'));
            }
            Object[] objectArray4 = new MemberSignature[methodArray.length];
            for (n = 0; n < methodArray.length; ++n) {
                objectArray4[n] = new MemberSignature(methodArray[n]);
            }
            Arrays.sort(objectArray4, new Comparator(){

                public int compare(Object object, Object object2) {
                    MemberSignature memberSignature = (MemberSignature)object;
                    MemberSignature memberSignature2 = (MemberSignature)object2;
                    int n = memberSignature.name.compareTo(memberSignature2.name);
                    if (n == 0) {
                        n = memberSignature.signature.compareTo(memberSignature2.signature);
                    }
                    return n;
                }
            });
            for (n = 0; n < objectArray4.length; ++n) {
                Object object = objectArray4[n];
                int n6 = ((MemberSignature)object).member.getModifiers();
                if ((n6 & 2) != 0) continue;
                dataOutputStream.writeUTF(((MemberSignature)object).name);
                dataOutputStream.writeInt(n6);
                dataOutputStream.writeUTF(((MemberSignature)object).signature.replace('/', '.'));
            }
            dataOutputStream.flush();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            byte[] byArray = messageDigest.digest(byteArrayOutputStream.toByteArray());
            long l = 0L;
            for (int i = Math.min(byArray.length, 8) - 1; i >= 0; --i) {
                l = l << 8 | (long)(byArray[i] & 0xFF);
            }
            return l;
        }
        catch (IOException iOException) {
            throw new InternalError();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
    }

    private static native boolean hasStaticInitializer(Class var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FieldReflector getReflector(ObjectStreamField[] objectStreamFieldArray, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        Object object;
        Class clazz = objectStreamClass != null && objectStreamFieldArray.length > 0 ? objectStreamClass.cl : null;
        FieldReflectorKey fieldReflectorKey = new FieldReflectorKey(clazz, objectStreamFieldArray);
        EntryFuture entryFuture = null;
        SoftCache softCache = reflectors;
        synchronized (softCache) {
            object = reflectors.get(fieldReflectorKey);
            if (object == null) {
                entryFuture = new EntryFuture();
                reflectors.put(fieldReflectorKey, entryFuture);
            }
        }
        if (object instanceof FieldReflector) {
            return (FieldReflector)object;
        }
        if (object instanceof EntryFuture) {
            object = ((EntryFuture)object).get();
        } else if (object == null) {
            try {
                object = new FieldReflector(ObjectStreamClass.matchFields(objectStreamFieldArray, objectStreamClass));
            }
            catch (Throwable throwable) {
                object = throwable;
            }
            entryFuture.set(object);
            softCache = reflectors;
            synchronized (softCache) {
                reflectors.put(fieldReflectorKey, object);
            }
        }
        if (object instanceof FieldReflector) {
            return (FieldReflector)object;
        }
        if (object instanceof InvalidClassException) {
            throw (InvalidClassException)object;
        }
        if (object instanceof RuntimeException) {
            throw (RuntimeException)object;
        }
        if (object instanceof Error) {
            throw (Error)object;
        }
        throw new InternalError("unexpected entry: " + object);
    }

    private static ObjectStreamField[] matchFields(ObjectStreamField[] objectStreamFieldArray, ObjectStreamClass objectStreamClass) throws InvalidClassException {
        ObjectStreamField[] objectStreamFieldArray2 = objectStreamClass != null ? objectStreamClass.fields : NO_FIELDS;
        ObjectStreamField[] objectStreamFieldArray3 = new ObjectStreamField[objectStreamFieldArray.length];
        for (int i = 0; i < objectStreamFieldArray.length; ++i) {
            ObjectStreamField objectStreamField = objectStreamFieldArray[i];
            ObjectStreamField objectStreamField2 = null;
            for (int j = 0; j < objectStreamFieldArray2.length; ++j) {
                ObjectStreamField objectStreamField3 = objectStreamFieldArray2[j];
                if (!objectStreamField.getName().equals(objectStreamField3.getName())) continue;
                if ((objectStreamField.isPrimitive() || objectStreamField3.isPrimitive()) && objectStreamField.getTypeCode() != objectStreamField3.getTypeCode()) {
                    throw new InvalidClassException(objectStreamClass.name, "incompatible types for field " + objectStreamField.getName());
                }
                objectStreamField2 = objectStreamField3.getField() != null ? new ObjectStreamField(objectStreamField3.getField(), objectStreamField3.isUnshared(), false) : new ObjectStreamField(objectStreamField3.getName(), objectStreamField3.getSignature(), objectStreamField3.isUnshared());
            }
            if (objectStreamField2 == null) {
                objectStreamField2 = new ObjectStreamField(objectStreamField.getName(), objectStreamField.getSignature(), false);
            }
            objectStreamField2.setOffset(objectStreamField.getOffset());
            objectStreamFieldArray3[i] = objectStreamField2;
        }
        return objectStreamFieldArray3;
    }

    static /* synthetic */ ObjectStreamField[] access$502(ObjectStreamClass objectStreamClass, ObjectStreamField[] objectStreamFieldArray) {
        objectStreamClass.fields = objectStreamFieldArray;
        return objectStreamFieldArray;
    }

    static {
        ObjectStreamClass.initNative();
    }

    private static class FieldReflectorKey {
        private final Class cl;
        private final String sigs;
        private final int hash;

        FieldReflectorKey(Class clazz, ObjectStreamField[] objectStreamFieldArray) {
            this.cl = clazz;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < objectStreamFieldArray.length; ++i) {
                ObjectStreamField objectStreamField = objectStreamFieldArray[i];
                stringBuffer.append(objectStreamField.getName()).append(objectStreamField.getSignature());
            }
            this.sigs = stringBuffer.toString();
            this.hash = System.identityHashCode(clazz) + this.sigs.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (!(object instanceof FieldReflectorKey)) {
                return false;
            }
            FieldReflectorKey fieldReflectorKey = (FieldReflectorKey)object;
            return this.cl == fieldReflectorKey.cl && this.sigs.equals(fieldReflectorKey.sigs);
        }
    }

    private static class FieldReflector {
        private final ObjectStreamField[] fields;
        private final int numPrimFields;
        private long[] primFieldIDs;
        private long[] objFieldIDs;
        private final int[] offsets;
        private final char[] typeCodes;
        private final Class[] types;

        FieldReflector(ObjectStreamField[] objectStreamFieldArray) {
            this.fields = objectStreamFieldArray;
            int n = objectStreamFieldArray.length;
            this.offsets = new int[n];
            this.typeCodes = new char[n];
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < n; ++i) {
                ObjectStreamField objectStreamField = objectStreamFieldArray[i];
                Field field = objectStreamField.getField();
                this.offsets[i] = objectStreamField.getOffset();
                this.typeCodes[i] = objectStreamField.getTypeCode();
                if (objectStreamField.isPrimitive()) continue;
                arrayList.add(field != null ? field.getType() : null);
            }
            this.types = (Class[])arrayList.toArray(new Class[arrayList.size()]);
            this.numPrimFields = n - this.types.length;
            this.primFieldIDs = new long[this.numPrimFields];
            this.objFieldIDs = new long[this.types.length];
            ObjectStreamClass.getFieldIDs(objectStreamFieldArray, this.primFieldIDs, this.objFieldIDs);
        }

        ObjectStreamField[] getFields() {
            return this.fields;
        }

        void getPrimFieldValues(Object object, byte[] byArray) {
            if (object == null) {
                throw new NullPointerException();
            }
            ObjectOutputStream.getPrimitiveFieldValues(object, this.primFieldIDs, this.typeCodes, byArray);
        }

        void setPrimFieldValues(Object object, byte[] byArray) {
            if (object == null) {
                throw new NullPointerException();
            }
            ObjectInputStream.setPrimitiveFieldValues(object, this.primFieldIDs, this.typeCodes, byArray);
        }

        void getObjFieldValues(Object object, Object[] objectArray) {
            if (object == null) {
                throw new NullPointerException();
            }
            block3: for (int i = this.numPrimFields; i < this.fields.length; ++i) {
                switch (this.typeCodes[i]) {
                    case 'L': 
                    case '[': {
                        objectArray[this.offsets[i]] = ObjectOutputStream.getObjectFieldValue(object, this.objFieldIDs[i - this.numPrimFields]);
                        continue block3;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        void setObjFieldValues(Object object, Object[] objectArray) {
            if (object == null) {
                throw new NullPointerException();
            }
            block3: for (int i = this.numPrimFields; i < this.fields.length; ++i) {
                if (this.objFieldIDs[i - this.numPrimFields] == 0L) continue;
                switch (this.typeCodes[i]) {
                    case 'L': 
                    case '[': {
                        Object object2 = objectArray[this.offsets[i]];
                        if (object2 != null && !this.types[i - this.numPrimFields].isInstance(object2)) {
                            Field field = this.fields[i].getField();
                            throw new ClassCastException("cannot assign instance of " + object2.getClass().getName() + " to field " + field.getDeclaringClass().getName() + "." + field.getName() + " of type " + field.getType().getName() + " in instance of " + object.getClass().getName());
                        }
                        ObjectInputStream.setObjectFieldValue(object, this.objFieldIDs[i - this.numPrimFields], this.types[i - this.numPrimFields], object2);
                        continue block3;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }
    }

    private static class MemberSignature {
        public final Member member;
        public final String name;
        public final String signature;

        public MemberSignature(Field field) {
            this.member = field;
            this.name = field.getName();
            this.signature = ObjectStreamClass.getClassSignature(field.getType());
        }

        public MemberSignature(Constructor constructor) {
            this.member = constructor;
            this.name = constructor.getName();
            this.signature = ObjectStreamClass.getMethodSignature(constructor.getParameterTypes(), Void.TYPE);
        }

        public MemberSignature(Method method) {
            this.member = method;
            this.name = method.getName();
            this.signature = ObjectStreamClass.getMethodSignature(method.getParameterTypes(), method.getReturnType());
        }
    }

    static class ClassDataSlot {
        final ObjectStreamClass desc;
        final boolean hasData;

        ClassDataSlot(ObjectStreamClass objectStreamClass, boolean bl) {
            this.desc = objectStreamClass;
            this.hasData = bl;
        }
    }

    private static class EntryFuture {
        private static final Object unset = new Object();
        private Object entry = unset;

        private EntryFuture() {
        }

        synchronized void set(Object object) {
            if (this.entry != unset) {
                throw new IllegalStateException();
            }
            this.entry = object;
            this.notifyAll();
        }

        synchronized Object get() {
            boolean bl = false;
            while (this.entry == unset) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                }
            }
            if (bl) {
                AccessController.doPrivileged(new PrivilegedAction(this){
                    private final /* synthetic */ EntryFuture this$0;
                    {
                        this.this$0 = entryFuture;
                    }

                    public Object run() {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                });
            }
            return this.entry;
        }
    }
}

