/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.reporting.html;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;

public class JavaToHtml {
    private static final Collection javaKeywords;
    private static final Collection javaPrimitiveLiterals;
    private static final Collection javaPrimitiveTypes;
    private int state = 3;

    private static String escapeEntity(char character) {
        if (character == '&') {
            return "&amp;";
        }
        if (character == '<') {
            return "&lt;";
        }
        if (character == '>') {
            return "&gt;";
        }
        if (character == '\t') {
            return "        ";
        }
        return new Character(character).toString();
    }

    public String process(String text) {
        if (text == null) {
            throw new IllegalArgumentException("\"text\" can not be null.");
        }
        StringBuffer ret = new StringBuffer();
        int begin = 0;
        int end = text.indexOf(10, begin);
        int nextCR = text.indexOf(13, begin);
        if (nextCR != -1 && (end == -1 || nextCR < end)) {
            end = nextCR;
        }
        while (end != -1) {
            ret.append(this.processLine(text.substring(begin, end)) + "<br/>");
            if (end + 1 < text.length() && (text.charAt(end + 1) == '\n' || text.charAt(end + 1) == '\r')) {
                ret.append(text.substring(end, end + 1));
                begin = end + 2;
            } else {
                ret.append(text.charAt(end));
                begin = end + 1;
            }
            end = text.indexOf(10, begin);
            nextCR = text.indexOf(13, begin);
            if (nextCR == -1 || end != -1 && nextCR >= end) continue;
            end = nextCR;
        }
        ret.append(this.processLine(text.substring(begin)));
        return ret.toString();
    }

    private String processLine(String line) {
        if (line == null) {
            throw new IllegalArgumentException("\"line\" can not be null.");
        }
        if (line.indexOf(10) != -1 || line.indexOf(13) != -1) {
            throw new IllegalArgumentException("\"line\" can not contain newline or carriage return characters.");
        }
        StringBuffer ret = new StringBuffer();
        int currentIndex = 0;
        while (currentIndex != line.length()) {
            if (this.state == 3) {
                if (currentIndex + 2 < line.length() && line.substring(currentIndex, currentIndex + 3).equals("/**")) {
                    this.state = 0;
                    continue;
                }
                if (currentIndex + 1 < line.length() && line.substring(currentIndex, currentIndex + 2).equals("/*")) {
                    this.state = 1;
                    continue;
                }
                if (currentIndex + 1 < line.length() && line.substring(currentIndex, currentIndex + 2).equals("//")) {
                    this.state = 2;
                    continue;
                }
                if (Character.isJavaIdentifierStart(line.charAt(currentIndex))) {
                    this.state = 4;
                    continue;
                }
                if (line.charAt(currentIndex) == '\'') {
                    this.state = 9;
                    continue;
                }
                if (line.charAt(currentIndex) == '\"') {
                    this.state = 8;
                    continue;
                }
                ret.append(JavaToHtml.escapeEntity(line.charAt(currentIndex++)));
                continue;
            }
            if (this.state == 1 || this.state == 0) {
                ret.append("<span class=\"comment\">");
                while (!(currentIndex == line.length() || currentIndex + 1 < line.length() && line.substring(currentIndex, currentIndex + 2).equals("*/"))) {
                    ret.append(JavaToHtml.escapeEntity(line.charAt(currentIndex++)));
                }
                if (currentIndex == line.length()) {
                    ret.append("</span>");
                    continue;
                }
                ret.append("*/</span>");
                this.state = 3;
                currentIndex += 2;
                continue;
            }
            if (this.state == 2) {
                ret.append("<span class=\"comment\">");
                while (currentIndex != line.length()) {
                    ret.append(JavaToHtml.escapeEntity(line.charAt(currentIndex++)));
                }
                ret.append("</span>");
                this.state = 3;
                continue;
            }
            if (this.state == 4) {
                StringBuffer tmp = new StringBuffer();
                do {
                    tmp.append(line.charAt(currentIndex++));
                } while (currentIndex != line.length() && Character.isJavaIdentifierPart(line.charAt(currentIndex)));
                if (javaKeywords.contains(tmp.toString())) {
                    ret.append("<span class=\"keyword\">" + tmp + "</span>");
                } else if (javaPrimitiveLiterals.contains(tmp.toString())) {
                    ret.append("<span class=\"keyword\">" + tmp + "</span>");
                } else if (javaPrimitiveTypes.contains(tmp.toString())) {
                    ret.append("<span class=\"keyword\">" + tmp + "</span>");
                } else {
                    ret.append((Object)tmp);
                }
                if (tmp.toString().equals("import")) {
                    this.state = 5;
                    continue;
                }
                if (tmp.toString().equals("package")) {
                    this.state = 6;
                    continue;
                }
                this.state = 3;
                continue;
            }
            if (this.state == 5) {
                ret.append(JavaToHtml.escapeEntity(line.charAt(currentIndex++)));
                this.state = 3;
                continue;
            }
            if (this.state == 6) {
                ret.append(JavaToHtml.escapeEntity(line.charAt(currentIndex++)));
                this.state = 3;
                continue;
            }
            if (this.state == 8) {
                ret.append("<span class=\"string\">");
                do {
                    ret.append(JavaToHtml.escapeEntity(line.charAt(currentIndex++)));
                } while (currentIndex != line.length() && (line.charAt(currentIndex) != '\"' || line.charAt(currentIndex - 1) == '\\' && line.charAt(currentIndex - 2) != '\\'));
                if (currentIndex == line.length()) {
                    ret.append("</span>");
                    continue;
                }
                ret.append("\"</span>");
                this.state = 3;
                ++currentIndex;
                continue;
            }
            if (this.state == 9) {
                ret.append("<span class=\"string\">");
                do {
                    ret.append(JavaToHtml.escapeEntity(line.charAt(currentIndex++)));
                } while (currentIndex != line.length() && (line.charAt(currentIndex) != '\'' || line.charAt(currentIndex - 1) == '\\' && line.charAt(currentIndex - 2) != '\\'));
                if (currentIndex == line.length()) {
                    ret.append("</span>");
                    continue;
                }
                ret.append("'</span>");
                this.state = 3;
                ++currentIndex;
                continue;
            }
            ret.append(JavaToHtml.escapeEntity(line.charAt(currentIndex++)));
        }
        return ret.toString();
    }

    public void reset() {
        this.state = 3;
    }

    static {
        String[] javaKeywordsArray = new String[]{"abstract", "assert", "break", "case", "catch", "class", "const", "continue", "default", "do", "else", "extends", "final", "finally", "for", "goto", "if", "interface", "implements", "import", "instanceof", "native", "new", "package", "private", "protected", "public", "return", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "volatile", "while"};
        String[] javaPrimitiveTypesArray = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "void"};
        String[] javaPrimitiveLiteralsArray = new String[]{"false", "null", "true"};
        javaKeywords = new HashSet<String>(Arrays.asList(javaKeywordsArray));
        javaPrimitiveTypes = new HashSet<String>(Arrays.asList(javaPrimitiveTypesArray));
        javaPrimitiveLiterals = new HashSet<String>(Arrays.asList(javaPrimitiveLiteralsArray));
    }

    public static abstract class State {
        public static final int COMMENT_JAVADOC = 0;
        public static final int COMMENT_MULTI = 1;
        public static final int COMMENT_SINGLE = 2;
        public static final int DEFAULT = 3;
        public static final int KEYWORD = 4;
        public static final int IMPORT_NAME = 5;
        public static final int PACKAGE_NAME = 6;
        public static final int QUOTE_DOUBLE = 8;
        public static final int QUOTE_SINGLE = 9;
    }
}

