/* ----- mGnP/ed25519, derived from supercop/crypto_mGnP/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <lib25519.h>
#include "lib25519_test.h"

#define fail ((ok = 0),printf)
static const char *mGnP_ed25519_checksums[] = {
  "dc80be44fb0d482c5ae430779e76fe612c53fcd9e5847254bf27ab34e90745f4",
  "9e1a3b7015c8fdb12763fd88494f5bfe9e2565ead4d3407d5ecf7ff6ca24c1d0",
} ;

static void (*crypto_mGnP)(unsigned char *,const unsigned char *,const unsigned char *,const unsigned char *);
#define crypto_mGnP_MBYTES lib25519_mGnP_ed25519_MBYTES
#define crypto_mGnP_NBYTES lib25519_mGnP_ed25519_NBYTES
#define crypto_mGnP_PBYTES lib25519_mGnP_ed25519_PBYTES
#define crypto_mGnP_OUTPUTBYTES lib25519_mGnP_ed25519_OUTPUTBYTES

static void *storage_mGnP_ed25519_Q;
static unsigned char *test_mGnP_ed25519_Q;
static void *storage_mGnP_ed25519_m;
static unsigned char *test_mGnP_ed25519_m;
static void *storage_mGnP_ed25519_n;
static unsigned char *test_mGnP_ed25519_n;
static void *storage_mGnP_ed25519_P;
static unsigned char *test_mGnP_ed25519_P;
static void *storage_mGnP_ed25519_Q2;
static unsigned char *test_mGnP_ed25519_Q2;
static void *storage_mGnP_ed25519_m2;
static unsigned char *test_mGnP_ed25519_m2;
static void *storage_mGnP_ed25519_n2;
static unsigned char *test_mGnP_ed25519_n2;
static void *storage_mGnP_ed25519_P2;
static unsigned char *test_mGnP_ed25519_P2;

#define precomputed_mGnP_ed25519_NUM 453

static const unsigned char precomputed_mGnP_ed25519_Q_0[] = {193,20,31,22,66,224,234,80,225,166,208,110,185,170,33,13,42,170,37,31,162,113,128,119,198,205,250,123,183,207,66,236,0};
static const unsigned char precomputed_mGnP_ed25519_m_0[] = {224,135,14,17,150,165,131,191,160,179,224,178,234,183,171,20,151,112,40,238,215,61,53,84,208,28,30,103,95,140,84,209};
static const unsigned char precomputed_mGnP_ed25519_n_0[] = {10,143,232,22,159,195,90,177,170,55,106,207,146,159,0,90,100,75,5,116,95,64,95,139,118,51,233,68,49,9,56,116,173,6,210,199,68,82,3,67,188,180,196,29,248,93,109,239,95,170,254,173,250,15,113,183,142,24,153,174,149,19,53,209};
static const unsigned char precomputed_mGnP_ed25519_P_0[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_1[] = {239,212,209,8,125,39,38,41,94,189,180,94,193,163,130,175,142,228,76,49,248,193,255,202,155,95,140,198,38,12,125,85,0};
static const unsigned char precomputed_mGnP_ed25519_m_1[] = {78,64,12,16,211,36,206,251,165,39,152,226,219,206,5,210,37,186,123,49,239,249,65,170,191,244,78,72,66,168,159,60};
static const unsigned char precomputed_mGnP_ed25519_n_1[] = {147,166,155,108,84,238,173,228,212,61,200,159,5,20,138,201,108,43,242,173,100,71,240,92,219,123,154,10,24,229,36,173,252,162,4,55,146,220,234,252,72,199,58,95,44,234,48,84,67,100,240,82,17,226,194,127,186,209,79,255,50,135,240,210};
static const unsigned char precomputed_mGnP_ed25519_P_1[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_2[] = {55,62,88,224,26,74,175,40,62,4,120,230,61,96,198,36,123,205,4,104,84,86,86,127,219,32,148,226,161,23,102,170,0};
static const unsigned char precomputed_mGnP_ed25519_m_2[] = {65,178,251,62,244,59,49,41,66,147,53,227,142,111,248,204,4,194,178,1,198,173,145,105,221,2,69,247,223,200,147,39};
static const unsigned char precomputed_mGnP_ed25519_n_2[] = {135,20,231,42,210,124,195,244,59,203,227,211,33,7,39,164,238,148,46,28,52,235,215,193,76,127,220,55,140,54,67,220,22,228,26,93,13,73,3,92,245,148,86,97,242,13,10,188,167,143,128,61,94,190,187,222,134,83,107,67,2,18,139,129};
static const unsigned char precomputed_mGnP_ed25519_P_2[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_3[] = {107,224,24,189,33,29,232,2,162,186,95,183,1,220,227,240,212,2,3,115,73,34,232,59,29,52,104,48,138,100,168,7,0};
static const unsigned char precomputed_mGnP_ed25519_m_3[] = {96,154,68,253,117,168,110,149,206,46,4,114,0,15,189,95,68,173,57,32,121,250,25,129,13,74,155,200,176,155,84,147};
static const unsigned char precomputed_mGnP_ed25519_n_3[] = {93,23,40,225,110,159,207,34,135,141,181,194,198,68,38,219,47,212,6,165,191,255,1,237,217,130,20,80,230,148,245,159,125,85,148,114,170,197,206,208,77,111,33,137,46,51,197,213,243,60,209,171,162,116,249,228,65,73,159,247,19,55,15,135};
static const unsigned char precomputed_mGnP_ed25519_P_3[] = {3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_4[] = {31,253,125,101,135,126,126,76,190,193,95,50,18,196,29,41,215,190,147,142,86,228,65,24,220,35,222,83,116,163,20,189,0};
static const unsigned char precomputed_mGnP_ed25519_m_4[] = {135,164,96,150,65,255,150,117,20,160,209,216,115,150,240,103,114,178,158,183,81,223,81,71,186,99,201,241,63,107,80,181};
static const unsigned char precomputed_mGnP_ed25519_n_4[] = {41,17,182,121,130,2,128,100,186,37,92,212,243,161,29,169,240,87,29,215,17,83,82,46,14,65,118,45,46,238,62,63,214,169,56,252,83,151,1,86,240,77,253,94,159,30,47,229,36,111,103,143,146,81,98,197,144,247,230,66,9,129,144,192};
static const unsigned char precomputed_mGnP_ed25519_P_4[] = {4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_5[] = {243,15,115,147,232,219,192,154,21,238,149,1,185,144,3,64,115,243,5,204,208,176,175,41,80,203,104,37,114,91,56,35,0};
static const unsigned char precomputed_mGnP_ed25519_m_5[] = {40,198,180,56,7,46,177,116,244,230,243,39,186,199,131,56,93,231,171,247,190,216,228,148,76,101,139,44,166,158,197,63};
static const unsigned char precomputed_mGnP_ed25519_n_5[] = {144,66,204,78,248,67,198,192,211,26,54,67,65,7,97,103,231,132,200,149,160,233,139,56,33,97,196,143,112,216,26,21,6,217,42,39,247,244,199,183,11,24,190,187,12,160,153,89,205,247,218,239,225,11,28,153,254,134,144,184,87,217,185,134};
static const unsigned char precomputed_mGnP_ed25519_P_5[] = {5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_6[] = {172,182,182,78,25,22,62,39,198,223,99,189,255,52,241,97,195,181,245,66,20,227,79,115,28,186,88,10,3,240,179,224,0};
static const unsigned char precomputed_mGnP_ed25519_m_6[] = {185,129,137,49,182,163,45,164,52,45,158,110,241,87,158,78,47,131,88,69,5,27,141,209,80,53,111,130,41,153,19,249};
static const unsigned char precomputed_mGnP_ed25519_n_6[] = {141,174,82,207,98,133,57,165,52,92,254,252,28,236,233,248,40,11,35,100,222,189,129,137,38,98,167,13,1,28,127,189,76,91,239,98,181,20,191,58,164,44,188,230,127,178,135,107,218,32,240,145,87,73,87,57,78,105,138,111,219,16,224,213};
static const unsigned char precomputed_mGnP_ed25519_P_6[] = {6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_7[] = {62,104,105,88,128,13,255,31,4,177,175,220,184,45,120,237,99,88,147,176,117,206,134,181,197,33,182,172,43,24,216,224,0};
static const unsigned char precomputed_mGnP_ed25519_m_7[] = {222,81,100,34,85,252,179,241,247,165,190,25,214,31,237,181,34,80,174,90,14,211,251,22,37,139,233,203,91,152,186,195};
static const unsigned char precomputed_mGnP_ed25519_n_7[] = {71,153,68,94,14,197,196,216,63,57,251,150,148,206,84,33,0,164,206,176,4,171,98,35,27,44,245,1,231,38,217,156,93,238,240,189,216,12,19,43,251,206,170,29,6,176,124,203,238,85,36,95,172,122,49,215,14,83,91,12,189,154,252,184};
static const unsigned char precomputed_mGnP_ed25519_P_7[] = {7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_8[] = {36,217,83,145,174,217,124,120,161,163,60,166,133,73,218,76,115,10,1,225,148,53,222,179,249,147,201,35,226,121,230,13,0};
static const unsigned char precomputed_mGnP_ed25519_m_8[] = {31,220,101,111,190,159,95,88,202,97,113,215,243,48,175,182,70,32,191,205,217,168,95,154,144,77,134,194,154,250,81,155};
static const unsigned char precomputed_mGnP_ed25519_n_8[] = {90,6,74,119,127,156,235,106,1,29,234,104,229,15,167,252,87,147,213,55,222,44,109,86,64,246,182,208,55,101,230,230,182,152,129,113,41,240,23,16,243,89,164,203,74,253,19,7,176,238,180,109,222,250,236,128,140,240,238,165,138,37,199,35};
static const unsigned char precomputed_mGnP_ed25519_P_8[] = {8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_9[] = {218,160,114,157,113,239,46,33,164,162,215,160,65,155,241,51,107,60,133,236,25,115,104,102,157,175,184,77,194,185,123,87,0};
static const unsigned char precomputed_mGnP_ed25519_m_9[] = {194,225,139,187,217,246,76,169,82,71,14,242,243,66,223,18,107,162,8,79,205,43,135,179,184,253,172,176,78,229,15,62};
static const unsigned char precomputed_mGnP_ed25519_n_9[] = {15,175,136,25,173,216,247,254,165,79,208,96,254,123,37,204,130,108,204,9,129,148,77,223,95,178,154,217,216,125,76,35,209,243,90,173,83,238,65,9,208,67,134,145,250,132,113,253,8,146,106,225,79,112,52,4,220,90,243,9,73,50,109,89};
static const unsigned char precomputed_mGnP_ed25519_P_9[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_10[] = {215,18,28,155,4,191,122,36,53,143,209,22,121,185,137,113,183,218,156,83,150,28,58,43,202,4,0,59,210,69,177,23,0};
static const unsigned char precomputed_mGnP_ed25519_m_10[] = {34,218,17,71,209,47,96,134,121,56,232,65,155,248,19,205,226,134,69,225,156,9,101,153,255,139,4,30,155,90,116,58};
static const unsigned char precomputed_mGnP_ed25519_n_10[] = {235,176,174,149,75,199,68,1,201,234,123,129,6,9,227,35,35,126,129,27,142,189,44,26,84,69,68,111,60,148,159,174,214,231,53,132,141,15,99,88,127,218,158,8,24,7,232,0,252,97,65,87,79,214,187,222,189,249,68,221,37,20,102,101};
static const unsigned char precomputed_mGnP_ed25519_P_10[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_11[] = {15,85,186,179,54,59,138,71,36,152,81,185,49,161,155,253,201,12,186,201,124,43,173,68,103,18,84,216,189,3,91,30,0};
static const unsigned char precomputed_mGnP_ed25519_m_11[] = {22,153,156,234,207,199,232,81,16,19,228,112,122,41,92,192,16,162,133,98,37,244,69,112,26,172,30,5,37,165,204,230};
static const unsigned char precomputed_mGnP_ed25519_n_11[] = {150,118,227,102,87,244,124,54,111,91,155,132,44,128,231,182,122,177,10,208,143,169,242,102,108,238,212,252,38,246,120,170,18,174,198,21,83,5,111,189,210,27,234,40,154,135,198,169,2,109,123,110,78,145,218,255,153,60,155,160,232,60,225,51};
static const unsigned char precomputed_mGnP_ed25519_P_11[] = {11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_12[] = {189,165,144,177,33,155,200,169,68,113,243,73,187,247,153,192,74,26,254,232,14,126,200,148,143,100,214,124,84,85,5,196,0};
static const unsigned char precomputed_mGnP_ed25519_m_12[] = {36,66,86,84,86,197,40,125,132,245,33,52,48,239,178,198,91,139,125,206,183,122,2,164,113,158,66,45,153,160,112,103};
static const unsigned char precomputed_mGnP_ed25519_n_12[] = {33,88,211,34,64,90,213,27,84,221,9,15,164,245,4,190,208,93,209,167,109,177,162,57,122,24,213,252,246,133,4,93,115,121,215,144,192,207,191,139,250,134,27,206,38,245,246,248,242,209,147,92,22,208,167,140,239,100,181,72,124,253,189,86};
static const unsigned char precomputed_mGnP_ed25519_P_12[] = {12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_13[] = {177,6,89,157,63,159,208,220,103,251,34,240,243,60,133,94,159,15,174,173,92,53,169,217,72,217,127,178,7,200,66,108,0};
static const unsigned char precomputed_mGnP_ed25519_m_13[] = {24,132,96,205,123,135,225,41,44,33,190,36,39,71,205,22,140,220,198,241,211,206,242,157,27,150,13,37,0,176,208,62};
static const unsigned char precomputed_mGnP_ed25519_n_13[] = {23,42,9,168,149,67,225,68,221,92,5,101,135,205,220,233,113,229,93,28,11,14,240,8,223,244,78,233,61,201,117,195,203,239,136,244,145,213,179,193,69,248,238,30,49,168,84,223,122,219,155,116,77,182,16,144,221,148,18,214,220,87,145,76};
static const unsigned char precomputed_mGnP_ed25519_P_13[] = {13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_14[] = {200,218,238,202,246,181,95,139,167,63,121,155,154,33,125,40,65,81,42,170,163,12,128,110,223,77,176,79,105,118,186,253,0};
static const unsigned char precomputed_mGnP_ed25519_m_14[] = {44,188,140,157,177,222,198,151,186,133,190,196,200,213,82,156,26,166,170,132,16,223,221,220,136,134,131,241,243,150,13,145};
static const unsigned char precomputed_mGnP_ed25519_n_14[] = {172,37,236,32,17,202,10,98,43,251,179,124,92,172,152,16,151,116,16,0,95,217,219,130,228,74,231,241,234,71,130,228,213,107,205,33,28,54,95,81,39,43,202,247,49,81,34,157,110,184,9,52,255,196,125,211,33,77,87,17,72,142,79,252};
static const unsigned char precomputed_mGnP_ed25519_P_14[] = {14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_15[] = {236,93,106,16,60,173,90,181,193,160,13,14,253,63,252,27,19,171,35,102,98,249,245,250,37,95,13,113,55,125,247,179,0};
static const unsigned char precomputed_mGnP_ed25519_m_15[] = {105,212,6,187,154,227,199,215,80,21,209,32,148,252,203,4,192,151,119,104,250,202,161,192,157,206,130,103,205,92,139,45};
static const unsigned char precomputed_mGnP_ed25519_n_15[] = {150,233,194,54,155,39,49,154,32,100,23,54,135,243,66,176,95,170,253,9,95,198,10,76,179,116,65,226,19,206,61,75,77,112,16,76,136,128,23,122,221,125,73,98,246,231,76,233,174,115,158,61,171,210,129,114,15,96,52,53,26,148,183,9};
static const unsigned char precomputed_mGnP_ed25519_P_15[] = {15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_16[] = {21,53,251,238,252,219,189,16,63,238,20,219,129,77,8,52,75,60,4,184,215,235,138,142,75,206,183,127,188,3,19,109,0};
static const unsigned char precomputed_mGnP_ed25519_m_16[] = {156,17,157,240,57,162,195,58,179,230,62,129,75,129,255,9,135,33,13,190,41,64,156,38,253,96,126,84,190,220,91,137};
static const unsigned char precomputed_mGnP_ed25519_n_16[] = {1,143,5,254,141,156,221,179,170,95,175,24,168,198,50,141,40,141,32,92,12,134,72,244,206,168,15,127,61,195,218,47,91,195,156,203,55,154,54,162,249,75,142,211,86,147,206,68,140,105,78,111,152,248,124,160,206,127,231,186,177,199,207,112};
static const unsigned char precomputed_mGnP_ed25519_P_16[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_17[] = {104,145,19,16,233,184,221,87,79,192,223,49,15,182,132,34,180,180,33,122,1,117,180,158,225,242,80,206,107,78,59,83,0};
static const unsigned char precomputed_mGnP_ed25519_m_17[] = {95,111,137,168,162,7,8,4,43,143,176,35,153,139,8,1,245,26,140,172,113,166,180,251,39,253,81,250,21,118,118,126};
static const unsigned char precomputed_mGnP_ed25519_n_17[] = {254,164,41,191,208,165,189,79,230,205,190,82,12,194,86,16,71,124,103,109,196,160,233,80,201,247,78,6,128,160,247,26,142,186,213,16,245,185,19,114,215,8,4,117,242,89,19,10,213,30,196,23,229,242,94,14,6,170,152,46,82,221,251,67};
static const unsigned char precomputed_mGnP_ed25519_P_17[] = {17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_18[] = {60,113,37,3,202,241,247,44,54,115,117,67,243,43,170,197,26,34,207,51,98,51,204,54,181,252,211,107,106,231,22,55,0};
static const unsigned char precomputed_mGnP_ed25519_m_18[] = {90,184,253,66,136,55,247,4,239,11,97,152,17,76,22,16,251,98,6,240,97,78,87,187,98,67,131,181,5,226,41,195};
static const unsigned char precomputed_mGnP_ed25519_n_18[] = {61,92,137,6,34,150,107,7,148,8,26,254,197,74,65,243,54,162,117,165,219,103,164,127,89,179,183,219,27,53,147,25,10,38,203,255,194,23,25,140,203,74,249,111,52,86,86,190,135,255,169,111,205,74,26,59,164,156,81,61,76,226,91,26};
static const unsigned char precomputed_mGnP_ed25519_P_18[] = {18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_19[] = {218,77,138,8,52,211,187,12,118,234,240,239,195,152,92,96,223,76,137,6,253,192,37,144,100,76,186,107,176,55,85,247,0};
static const unsigned char precomputed_mGnP_ed25519_m_19[] = {170,235,102,12,200,238,165,23,13,235,59,201,106,179,213,215,174,1,241,163,149,102,208,87,87,19,208,64,185,199,62,181};
static const unsigned char precomputed_mGnP_ed25519_n_19[] = {209,181,234,189,149,207,147,30,22,222,107,103,214,26,164,77,88,58,47,239,253,86,139,110,77,111,173,118,110,20,112,202,175,156,148,52,75,142,201,81,76,20,186,168,209,123,131,251,1,86,6,53,198,185,99,153,86,26,54,75,63,85,72,191};
static const unsigned char precomputed_mGnP_ed25519_P_19[] = {19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_20[] = {24,85,179,137,39,191,189,162,202,35,169,187,29,201,116,49,239,233,68,57,75,237,56,237,66,16,223,28,30,143,117,106,0};
static const unsigned char precomputed_mGnP_ed25519_m_20[] = {9,194,170,132,65,64,96,19,188,39,234,139,61,160,10,194,167,249,122,23,54,22,83,2,183,23,124,59,200,94,44,96};
static const unsigned char precomputed_mGnP_ed25519_n_20[] = {88,135,198,15,244,0,249,143,217,131,124,180,16,33,34,49,215,207,124,219,214,53,141,227,151,126,198,246,133,28,50,250,56,141,31,212,164,209,181,184,95,14,174,138,21,246,106,156,163,37,102,129,23,47,37,80,22,69,80,122,157,251,86,30};
static const unsigned char precomputed_mGnP_ed25519_P_20[] = {20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_21[] = {172,217,171,30,110,128,229,186,14,247,12,249,185,158,249,162,172,37,224,59,12,85,83,159,221,126,198,249,221,176,176,201,0};
static const unsigned char precomputed_mGnP_ed25519_m_21[] = {104,156,133,242,202,230,100,133,22,28,163,155,114,236,3,202,131,1,120,186,192,240,136,224,97,66,121,104,20,173,107,33};
static const unsigned char precomputed_mGnP_ed25519_n_21[] = {48,217,101,122,57,119,101,209,130,108,197,155,238,104,206,51,22,218,238,190,53,39,187,244,231,124,68,104,139,195,67,219,243,216,33,240,183,234,182,105,60,149,175,107,20,122,140,73,158,248,112,201,31,228,106,106,228,97,199,226,96,78,147,27};
static const unsigned char precomputed_mGnP_ed25519_P_21[] = {21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_22[] = {202,97,44,50,136,124,132,199,192,148,9,31,216,168,18,23,195,214,1,160,248,207,238,145,34,71,174,25,110,9,104,128,0};
static const unsigned char precomputed_mGnP_ed25519_m_22[] = {240,40,179,155,15,30,160,15,110,229,206,44,247,187,190,51,231,225,215,92,119,232,90,39,154,246,108,225,11,76,156,11};
static const unsigned char precomputed_mGnP_ed25519_n_22[] = {140,120,134,114,131,143,42,140,252,3,175,149,95,183,156,36,188,7,6,139,251,109,180,137,230,203,209,217,190,232,138,140,122,179,225,11,72,8,203,76,204,66,198,132,76,251,205,81,146,23,190,232,214,33,239,122,129,52,213,53,203,53,74,240};
static const unsigned char precomputed_mGnP_ed25519_P_22[] = {22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_23[] = {42,175,159,17,84,17,216,59,200,90,90,140,55,107,154,70,233,62,180,32,59,23,139,192,76,231,83,162,187,130,234,51,0};
static const unsigned char precomputed_mGnP_ed25519_m_23[] = {59,189,252,71,108,218,131,67,53,196,149,41,201,185,96,21,80,84,204,138,251,123,41,46,233,66,113,44,154,57,252,220};
static const unsigned char precomputed_mGnP_ed25519_n_23[] = {110,202,34,214,68,131,135,9,183,1,213,132,43,143,152,213,63,182,240,165,137,185,240,166,52,161,34,224,212,192,141,194,182,83,90,119,43,4,31,98,1,121,111,19,17,20,177,60,56,18,69,77,123,43,49,45,76,180,177,95,216,79,67,90};
static const unsigned char precomputed_mGnP_ed25519_P_23[] = {23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_24[] = {229,252,98,104,214,93,46,189,70,61,31,182,9,80,169,26,123,205,82,111,118,102,239,192,12,184,220,83,122,171,92,231,0};
static const unsigned char precomputed_mGnP_ed25519_m_24[] = {81,53,84,178,203,206,244,186,175,55,117,173,89,238,189,253,22,197,35,30,246,116,139,247,48,79,125,60,92,148,235,202};
static const unsigned char precomputed_mGnP_ed25519_n_24[] = {94,114,246,10,223,63,165,241,29,40,236,6,152,3,235,220,215,250,44,5,138,4,33,165,167,220,232,66,25,216,153,16,59,188,45,87,94,254,250,80,19,138,250,120,81,159,185,6,32,29,128,122,153,242,245,231,223,89,3,95,129,73,70,70};
static const unsigned char precomputed_mGnP_ed25519_P_24[] = {24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_25[] = {84,75,38,86,84,117,13,29,151,24,80,21,25,89,25,32,205,134,170,105,36,113,194,148,178,184,173,16,139,168,33,43,0};
static const unsigned char precomputed_mGnP_ed25519_m_25[] = {205,123,216,129,99,250,189,75,237,203,41,24,82,134,106,23,12,188,23,53,47,192,184,89,108,187,185,44,219,154,156,42};
static const unsigned char precomputed_mGnP_ed25519_n_25[] = {21,171,10,249,206,3,219,18,98,31,194,170,128,250,202,80,18,38,221,51,13,162,100,127,78,124,28,71,207,187,93,131,127,101,159,116,164,65,165,172,222,79,77,78,234,50,153,126,172,118,197,231,236,136,11,27,244,132,85,222,43,37,106,25};
static const unsigned char precomputed_mGnP_ed25519_P_25[] = {25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_26[] = {67,171,250,206,251,11,201,48,202,162,189,211,63,128,226,36,143,62,132,190,101,147,174,76,208,185,81,61,220,19,68,102,0};
static const unsigned char precomputed_mGnP_ed25519_m_26[] = {159,201,96,249,184,41,137,82,196,84,139,138,16,92,187,74,129,234,39,56,79,232,94,116,175,28,57,86,69,106,171,103};
static const unsigned char precomputed_mGnP_ed25519_n_26[] = {39,101,117,76,150,173,138,245,65,161,98,236,22,91,73,63,24,156,252,184,36,227,177,5,0,134,13,114,93,124,212,208,242,208,255,202,204,131,139,163,109,193,136,28,175,58,163,110,245,94,181,67,96,137,56,91,182,114,159,225,33,245,253,243};
static const unsigned char precomputed_mGnP_ed25519_P_26[] = {26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_27[] = {71,164,27,141,7,85,148,122,157,184,159,42,226,65,201,137,250,129,124,104,39,250,175,186,127,192,172,189,173,240,51,207,0};
static const unsigned char precomputed_mGnP_ed25519_m_27[] = {6,115,24,244,136,17,223,94,14,127,120,116,74,16,130,217,246,22,90,66,152,3,78,42,128,109,17,165,217,41,114,113};
static const unsigned char precomputed_mGnP_ed25519_n_27[] = {90,124,101,194,183,238,181,83,64,18,104,46,48,40,106,115,138,244,44,41,232,106,71,225,252,7,127,157,160,222,17,112,79,219,131,178,82,214,173,64,191,121,255,99,95,119,142,17,32,59,7,172,192,95,146,156,51,88,191,85,45,192,102,155};
static const unsigned char precomputed_mGnP_ed25519_P_27[] = {27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_28[] = {213,3,201,50,183,32,237,188,33,37,139,137,250,76,159,166,57,190,10,236,250,160,21,49,216,160,143,15,209,235,186,153,0};
static const unsigned char precomputed_mGnP_ed25519_m_28[] = {213,169,196,107,214,153,170,23,104,45,78,143,73,113,67,82,255,216,217,103,124,108,171,209,146,176,15,64,182,153,235,90};
static const unsigned char precomputed_mGnP_ed25519_n_28[] = {17,150,128,217,168,128,47,247,30,95,29,206,129,58,69,125,59,22,61,167,37,208,16,255,70,217,223,193,113,21,174,72,13,164,239,78,193,219,76,177,155,114,220,240,67,15,115,249,191,223,10,87,138,253,161,245,51,60,138,158,179,188,214,150};
static const unsigned char precomputed_mGnP_ed25519_P_28[] = {28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_29[] = {207,70,74,84,108,201,112,207,197,30,35,32,255,145,252,198,242,10,24,11,0,25,123,89,186,187,120,52,145,109,160,39,1};
static const unsigned char precomputed_mGnP_ed25519_m_29[] = {248,241,234,149,182,116,91,240,203,29,127,212,156,65,59,135,54,233,190,26,191,113,109,106,183,54,148,34,201,198,232,11};
static const unsigned char precomputed_mGnP_ed25519_n_29[] = {125,122,129,99,100,83,139,36,25,5,105,72,13,43,91,126,141,101,191,77,185,233,220,215,15,251,101,193,196,190,118,214,105,175,85,105,171,190,207,109,138,54,234,178,190,119,76,2,157,88,43,114,50,8,190,211,201,169,66,81,198,224,176,131};
static const unsigned char precomputed_mGnP_ed25519_P_29[] = {29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_30[] = {102,62,185,27,136,36,225,54,217,146,46,69,87,248,199,31,218,148,52,41,250,110,21,12,16,48,208,245,191,46,232,150,0};
static const unsigned char precomputed_mGnP_ed25519_m_30[] = {17,227,78,205,14,234,160,142,238,92,207,103,109,40,48,141,24,155,115,88,85,46,9,238,170,187,94,231,197,40,82,90};
static const unsigned char precomputed_mGnP_ed25519_n_30[] = {56,216,82,248,119,166,33,241,123,179,233,82,89,98,112,99,121,211,21,156,115,10,143,113,133,77,137,117,39,24,218,156,167,24,137,58,26,142,62,129,127,13,218,216,36,47,77,174,140,91,197,132,71,81,173,55,201,207,137,208,50,198,75,121};
static const unsigned char precomputed_mGnP_ed25519_P_30[] = {30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_31[] = {115,4,8,153,144,34,13,70,176,166,73,136,245,197,230,207,156,233,120,86,135,113,171,109,230,136,173,95,134,17,45,86,0};
static const unsigned char precomputed_mGnP_ed25519_m_31[] = {243,11,222,138,209,83,183,37,113,136,111,115,213,8,99,118,163,178,52,32,173,35,236,141,131,35,72,167,114,225,103,160};
static const unsigned char precomputed_mGnP_ed25519_n_31[] = {19,56,52,249,87,122,96,42,253,25,106,245,140,45,164,36,6,251,174,59,47,126,231,88,212,250,165,87,194,73,86,129,150,193,246,5,82,135,157,255,209,102,224,159,194,65,124,21,138,10,19,58,26,170,28,214,150,125,86,31,192,166,162,13};
static const unsigned char precomputed_mGnP_ed25519_P_31[] = {31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_32[] = {247,100,145,199,12,157,94,212,196,149,181,92,183,129,63,148,17,225,141,190,150,16,49,111,24,209,126,46,209,157,216,81,0};
static const unsigned char precomputed_mGnP_ed25519_m_32[] = {23,23,23,249,255,10,120,189,135,172,128,58,82,119,223,133,221,221,238,94,194,236,247,186,53,150,141,127,171,215,144,232};
static const unsigned char precomputed_mGnP_ed25519_n_32[] = {92,59,126,154,0,251,5,55,215,202,252,87,40,88,129,21,81,254,46,239,97,29,231,56,141,26,174,74,148,24,113,141,157,196,170,47,140,135,187,68,109,4,86,159,174,69,152,160,121,208,36,87,255,32,191,43,135,246,72,21,35,188,66,83};
static const unsigned char precomputed_mGnP_ed25519_P_32[] = {133,160,158,72,186,1,91,246,75,247,188,75,16,198,93,128,164,113,55,55,220,92,49,210,31,166,134,94,97,102,5,0};
static const unsigned char precomputed_mGnP_ed25519_Q_33[] = {135,223,68,75,225,224,171,218,194,215,94,44,44,230,188,134,166,236,26,42,244,255,23,106,155,119,58,238,28,146,223,52,1};
static const unsigned char precomputed_mGnP_ed25519_m_33[] = {166,202,6,51,186,210,4,174,40,143,237,94,98,245,25,39,135,185,139,203,125,129,247,79,41,2,157,237,93,102,165,12};
static const unsigned char precomputed_mGnP_ed25519_n_33[] = {1,238,24,201,178,207,86,169,146,84,111,162,109,24,110,131,5,51,117,137,71,24,150,115,227,241,102,182,109,239,124,8,155,236,6,124,168,25,192,21,241,104,61,120,160,244,51,112,79,53,44,151,241,171,145,102,42,112,109,19,171,140,66,73};
static const unsigned char precomputed_mGnP_ed25519_P_33[] = {126,9,112,146,235,66,90,188,88,90,224,136,228,242,98,43,140,84,144,235,92,61,104,8,151,8,170,19,74,101,26,0};
static const unsigned char precomputed_mGnP_ed25519_Q_34[] = {121,233,37,176,6,139,215,0,20,81,159,70,184,202,89,182,176,171,14,107,188,59,75,128,28,119,29,32,162,222,94,106,0};
static const unsigned char precomputed_mGnP_ed25519_m_34[] = {146,163,235,3,55,145,127,30,39,42,69,29,68,253,30,68,0,252,241,178,241,138,49,140,14,70,48,103,40,7,68,84};
static const unsigned char precomputed_mGnP_ed25519_n_34[] = {205,98,205,214,3,231,180,57,35,75,138,12,167,197,146,43,74,187,145,167,196,234,222,216,9,96,136,127,126,162,73,114,132,236,77,215,31,104,197,78,128,1,95,21,155,213,119,117,238,102,187,73,233,69,134,98,47,110,112,52,40,80,54,124};
static const unsigned char precomputed_mGnP_ed25519_P_34[] = {224,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,0};
static const unsigned char precomputed_mGnP_ed25519_Q_35[] = {176,31,35,125,139,63,38,58,105,40,48,98,119,210,112,7,29,105,79,198,94,40,97,1,214,19,28,236,246,58,96,137,0};
static const unsigned char precomputed_mGnP_ed25519_m_35[] = {210,115,123,137,154,23,15,78,52,47,71,159,22,50,129,84,23,66,250,68,205,164,157,114,71,74,7,78,240,105,39,95};
static const unsigned char precomputed_mGnP_ed25519_n_35[] = {188,116,138,97,71,249,140,175,239,220,21,154,43,131,216,23,68,28,80,241,44,193,208,135,158,76,75,116,236,247,72,234,233,6,33,114,50,179,202,234,54,60,172,89,38,215,130,118,233,82,126,130,147,248,179,246,120,89,69,159,142,239,147,188};
static const unsigned char precomputed_mGnP_ed25519_P_35[] = {78,153,126,111,141,111,252,5,83,158,51,138,15,154,98,2,177,156,85,136,224,97,247,104,153,151,213,108,44,80,209,2};
static const unsigned char precomputed_mGnP_ed25519_Q_36[] = {65,116,102,140,80,101,108,148,65,135,63,241,188,126,246,182,165,206,235,171,202,191,58,105,36,157,55,236,200,3,170,136,0};
static const unsigned char precomputed_mGnP_ed25519_m_36[] = {217,80,89,164,141,226,21,142,135,217,95,139,92,193,100,112,55,7,110,43,70,184,20,116,5,34,62,238,13,44,149,250};
static const unsigned char precomputed_mGnP_ed25519_n_36[] = {103,139,183,239,241,21,120,151,88,78,62,118,66,185,196,63,15,140,180,214,205,94,37,121,106,27,55,166,158,130,222,208,248,83,62,222,189,177,112,171,4,1,165,137,237,217,215,61,45,100,215,78,190,109,90,230,80,71,182,203,28,14,106,173};
static const unsigned char precomputed_mGnP_ed25519_P_36[] = {38,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,5};
static const unsigned char precomputed_mGnP_ed25519_Q_37[] = {49,30,57,168,151,93,61,109,78,11,35,40,175,184,60,156,2,4,19,195,251,124,28,137,180,227,154,16,231,36,156,32,0};
static const unsigned char precomputed_mGnP_ed25519_m_37[] = {68,87,194,243,34,95,180,188,4,205,131,73,224,90,220,36,174,245,235,76,55,195,156,232,148,35,133,223,73,183,122,140};
static const unsigned char precomputed_mGnP_ed25519_n_37[] = {185,248,163,215,145,159,175,165,82,103,249,107,23,189,102,135,148,108,75,211,131,15,33,198,91,0,102,42,8,46,246,9,130,149,254,204,10,91,157,255,143,72,237,181,199,65,213,48,112,73,22,236,56,142,224,202,11,180,123,1,211,158,161,65};
static const unsigned char precomputed_mGnP_ed25519_P_37[] = {216,108,32,196,179,96,94,68,67,2,255,92,49,186,224,159,180,48,192,50,147,246,46,195,68,43,166,22,8,46,100,7};
static const unsigned char precomputed_mGnP_ed25519_Q_38[] = {209,194,45,74,228,198,222,120,85,129,55,68,190,66,75,250,110,49,195,163,27,138,80,152,62,235,61,12,62,210,194,95,0};
static const unsigned char precomputed_mGnP_ed25519_m_38[] = {241,55,251,132,82,181,45,42,245,135,135,208,208,48,1,161,182,60,98,163,19,153,215,113,190,244,61,216,158,21,37,144};
static const unsigned char precomputed_mGnP_ed25519_n_38[] = {47,15,230,227,13,90,96,35,140,105,106,70,116,197,143,167,9,109,203,19,223,155,165,59,119,49,6,25,122,191,220,21,128,229,59,104,230,254,193,95,107,237,5,135,181,216,215,55,254,26,31,153,2,2,35,248,120,37,234,5,215,137,132,218};
static const unsigned char precomputed_mGnP_ed25519_P_38[] = {57,219,28,111,68,228,27,79,57,195,231,19,30,185,73,83,121,159,249,151,252,104,182,48,163,51,251,217,35,68,59,15};
static const unsigned char precomputed_mGnP_ed25519_Q_39[] = {37,42,141,79,143,206,32,113,33,250,56,118,114,47,255,34,120,45,148,45,39,200,112,55,236,171,106,39,149,138,170,19,0};
static const unsigned char precomputed_mGnP_ed25519_m_39[] = {64,132,11,216,163,104,20,120,97,148,243,4,197,113,248,13,105,128,92,102,90,86,162,39,96,163,75,133,150,0,162,27};
static const unsigned char precomputed_mGnP_ed25519_n_39[] = {246,34,116,39,99,140,255,153,195,41,170,28,71,22,190,16,63,79,145,179,149,163,220,222,55,84,177,126,4,138,30,63,94,16,130,152,114,48,9,134,115,152,62,85,36,232,246,108,111,81,120,195,130,9,107,112,76,251,247,19,21,65,160,218};
static const unsigned char precomputed_mGnP_ed25519_P_39[] = {236,63,241,36,166,68,105,38,186,89,59,208,14,4,117,182,224,197,36,94,214,86,73,144,201,200,124,44,114,135,210,18};
static const unsigned char precomputed_mGnP_ed25519_Q_40[] = {94,11,111,55,202,45,7,20,114,142,84,135,129,234,54,228,229,87,148,60,156,205,122,126,58,171,5,65,240,38,65,150,0};
static const unsigned char precomputed_mGnP_ed25519_m_40[] = {143,184,247,252,72,182,232,65,2,72,224,250,7,139,16,127,146,198,233,2,137,25,174,121,46,248,250,254,130,86,79,93};
static const unsigned char precomputed_mGnP_ed25519_n_40[] = {209,72,178,230,20,215,145,110,143,247,56,70,201,212,128,5,137,31,25,120,120,76,214,153,88,203,124,109,149,206,147,98,244,58,178,38,238,97,143,50,202,191,57,38,177,9,79,109,36,124,171,154,250,50,98,101,215,94,165,209,123,204,195,213};
static const unsigned char precomputed_mGnP_ed25519_P_40[] = {131,196,183,157,143,181,189,1,175,102,45,100,112,127,96,148,29,133,197,254,108,223,64,228,78,218,154,119,172,195,122,20};
static const unsigned char precomputed_mGnP_ed25519_Q_41[] = {161,18,114,212,74,182,224,14,205,231,130,28,0,244,89,29,89,230,182,63,15,139,205,166,39,231,62,141,101,106,32,241,0};
static const unsigned char precomputed_mGnP_ed25519_m_41[] = {72,58,202,217,106,65,115,47,56,165,160,168,183,3,60,167,223,32,103,255,44,14,92,146,102,250,108,94,58,6,27,10};
static const unsigned char precomputed_mGnP_ed25519_n_41[] = {18,225,198,22,94,21,180,89,23,104,204,234,30,204,255,118,162,114,187,206,255,78,144,100,33,53,155,146,124,149,68,115,19,229,197,26,2,175,238,213,184,123,127,69,175,149,174,250,253,189,14,139,177,144,174,228,241,189,181,41,119,91,53,111};
static const unsigned char precomputed_mGnP_ed25519_P_41[] = {210,186,161,55,8,56,251,114,246,167,32,187,114,36,90,87,225,135,97,195,100,30,70,140,91,62,25,23,39,4,151,20};
static const unsigned char precomputed_mGnP_ed25519_Q_42[] = {85,74,198,40,127,105,178,33,172,143,174,12,203,69,54,100,169,70,251,247,94,213,36,48,163,228,6,249,24,26,36,66,0};
static const unsigned char precomputed_mGnP_ed25519_m_42[] = {206,239,7,45,75,56,204,143,232,81,132,76,20,191,142,90,49,100,171,207,80,205,152,180,137,25,1,132,25,33,4,98};
static const unsigned char precomputed_mGnP_ed25519_n_42[] = {46,26,240,66,138,195,250,142,71,88,160,222,73,200,98,51,151,29,73,75,66,13,192,84,52,205,9,119,16,180,144,5,40,251,117,212,110,187,37,34,86,224,120,225,19,249,109,184,167,248,115,141,185,93,196,29,2,24,0,223,159,61,192,54};
static const unsigned char precomputed_mGnP_ed25519_P_42[] = {36,145,108,107,202,212,204,240,212,7,88,47,196,61,65,201,118,189,125,61,219,34,22,53,62,0,98,1,168,122,87,26};
static const unsigned char precomputed_mGnP_ed25519_Q_43[] = {50,148,146,153,8,194,122,97,124,86,244,62,98,5,174,209,161,216,141,183,236,5,126,189,102,203,102,129,68,92,27,36,0};
static const unsigned char precomputed_mGnP_ed25519_m_43[] = {223,216,45,133,29,28,215,158,234,156,213,203,239,190,61,129,3,61,212,175,176,234,137,228,210,219,218,104,101,132,214,246};
static const unsigned char precomputed_mGnP_ed25519_n_43[] = {8,236,140,201,126,170,97,174,65,143,160,31,105,145,254,249,239,247,198,171,216,199,2,207,52,26,79,27,97,84,46,236,230,49,43,196,156,35,236,8,37,189,236,121,130,80,228,7,67,9,20,186,194,160,230,86,33,234,210,123,243,203,193,181};
static const unsigned char precomputed_mGnP_ed25519_P_43[] = {122,28,92,77,125,237,195,230,62,33,8,41,109,183,82,24,187,193,165,119,212,177,27,181,161,51,180,157,140,73,39,28};
static const unsigned char precomputed_mGnP_ed25519_Q_44[] = {222,120,50,224,107,165,97,25,148,20,191,53,96,241,49,81,129,181,93,40,67,175,133,247,115,145,121,84,75,223,160,22,0};
static const unsigned char precomputed_mGnP_ed25519_m_44[] = {250,67,5,139,43,25,135,247,84,211,166,230,180,243,82,215,206,96,50,193,31,96,166,142,208,203,147,166,254,249,44,45};
static const unsigned char precomputed_mGnP_ed25519_n_44[] = {87,107,190,196,97,156,216,66,194,137,211,85,203,147,39,218,148,52,16,253,196,201,151,86,74,19,196,88,132,135,71,131,49,3,180,92,110,225,11,102,167,84,59,180,63,114,16,25,68,51,133,28,120,91,22,134,93,202,231,219,252,59,111,102};
static const unsigned char precomputed_mGnP_ed25519_P_44[] = {40,88,214,103,129,21,75,153,249,2,125,196,106,194,160,240,125,135,250,100,100,169,68,112,20,135,90,176,29,90,59,28};
static const unsigned char precomputed_mGnP_ed25519_Q_45[] = {66,48,108,158,122,44,152,103,229,32,221,2,152,228,177,66,227,222,32,71,175,145,178,185,127,147,228,14,41,157,192,110,0};
static const unsigned char precomputed_mGnP_ed25519_m_45[] = {46,207,118,166,175,165,16,232,250,232,93,251,204,224,6,208,100,36,135,247,17,193,204,110,126,205,113,131,190,51,103,214};
static const unsigned char precomputed_mGnP_ed25519_n_45[] = {143,110,124,194,173,221,193,10,195,164,161,136,165,156,121,153,4,39,5,125,191,68,45,160,222,56,238,189,99,26,138,178,105,230,188,191,155,117,215,155,219,221,251,237,144,47,11,9,91,56,75,80,24,135,203,36,187,16,67,25,18,16,38,83};
static const unsigned char precomputed_mGnP_ed25519_P_45[] = {84,98,59,221,196,58,205,222,193,212,5,15,125,194,15,151,226,134,6,28,104,129,10,154,232,189,228,19,219,62,250,28};
static const unsigned char precomputed_mGnP_ed25519_Q_46[] = {126,136,17,40,84,115,4,255,31,54,129,120,86,20,190,40,19,144,1,55,84,140,181,64,238,166,69,132,190,8,210,91,0};
static const unsigned char precomputed_mGnP_ed25519_m_46[] = {170,107,5,217,141,132,107,17,134,193,106,217,239,7,58,230,49,178,43,35,159,234,25,147,178,121,33,190,158,14,218,120};
static const unsigned char precomputed_mGnP_ed25519_n_46[] = {232,105,232,199,154,126,83,35,27,82,168,211,14,64,56,254,143,144,82,123,145,124,110,113,79,185,55,104,247,157,241,149,119,66,70,55,120,105,214,47,182,208,1,82,126,135,171,219,207,179,179,40,210,139,206,160,229,99,5,144,153,142,187,126};
static const unsigned char precomputed_mGnP_ed25519_P_46[] = {190,29,39,95,90,208,83,102,202,66,104,169,222,136,104,211,11,169,221,5,219,246,37,64,231,183,79,157,51,91,215,31};
static const unsigned char precomputed_mGnP_ed25519_Q_47[] = {8,208,145,188,93,39,126,145,138,44,142,5,201,209,18,218,146,22,137,12,24,119,61,219,201,172,42,123,153,63,159,229,0};
static const unsigned char precomputed_mGnP_ed25519_m_47[] = {107,78,39,225,76,227,118,123,0,129,248,249,234,57,152,24,81,250,97,25,113,97,107,172,96,9,73,106,150,136,57,164};
static const unsigned char precomputed_mGnP_ed25519_n_47[] = {17,231,205,49,59,70,180,67,189,31,128,177,166,167,178,3,178,161,239,40,62,173,156,115,88,151,228,188,47,26,32,100,17,89,238,249,24,217,233,123,194,129,208,87,73,243,39,117,231,235,219,8,246,162,4,202,197,159,167,167,62,31,9,233};
static const unsigned char precomputed_mGnP_ed25519_P_47[] = {121,143,86,97,2,235,73,184,161,214,123,238,227,125,254,83,105,132,81,226,170,103,169,131,3,239,243,66,130,162,245,31};
static const unsigned char precomputed_mGnP_ed25519_Q_48[] = {49,41,251,71,131,78,87,0,35,53,209,64,135,218,91,95,129,70,119,42,123,5,187,50,164,230,137,80,91,88,197,65,0};
static const unsigned char precomputed_mGnP_ed25519_m_48[] = {3,60,64,15,31,214,116,195,218,43,231,226,105,110,21,134,13,234,154,44,231,179,120,94,129,160,28,163,111,217,2,140};
static const unsigned char precomputed_mGnP_ed25519_n_48[] = {182,109,139,182,15,163,98,14,196,185,37,149,212,38,55,81,47,254,2,12,24,147,85,196,47,45,238,213,68,94,219,14,2,122,53,145,21,235,190,196,52,142,208,86,249,228,67,177,47,231,192,248,46,123,227,218,151,233,55,197,238,73,171,149};
static const unsigned char precomputed_mGnP_ed25519_P_48[] = {73,5,247,160,82,142,177,165,227,112,105,120,156,113,65,250,51,182,120,221,241,74,127,117,108,20,238,116,190,67,140,33};
static const unsigned char precomputed_mGnP_ed25519_Q_49[] = {93,97,70,22,148,27,117,184,152,192,112,222,247,231,147,169,177,158,219,64,38,33,3,126,16,133,167,62,76,118,149,225,0};
static const unsigned char precomputed_mGnP_ed25519_m_49[] = {64,40,108,149,22,25,59,138,149,195,70,113,58,105,68,121,39,188,163,188,106,65,154,198,157,222,180,173,75,94,76,21};
static const unsigned char precomputed_mGnP_ed25519_n_49[] = {45,180,112,92,129,43,151,225,144,14,34,15,232,218,73,62,35,95,69,132,122,90,168,137,151,55,31,53,58,166,175,20,236,201,98,242,253,41,104,75,220,195,163,148,149,138,255,68,58,57,251,211,194,124,91,217,137,227,243,152,93,169,4,143};
static const unsigned char precomputed_mGnP_ed25519_P_49[] = {195,197,239,216,169,17,254,69,106,234,207,109,125,91,219,86,176,172,130,149,239,188,156,126,148,254,169,106,106,151,164,33};
static const unsigned char precomputed_mGnP_ed25519_Q_50[] = {141,190,90,236,73,144,189,50,207,184,82,102,249,93,67,78,231,203,228,18,251,139,68,150,78,182,8,252,105,29,13,62,1};
static const unsigned char precomputed_mGnP_ed25519_m_50[] = {122,221,70,145,164,237,217,51,55,195,210,30,170,18,195,122,6,60,190,21,22,202,218,140,114,175,126,238,77,162,149,2};
static const unsigned char precomputed_mGnP_ed25519_n_50[] = {6,33,23,10,26,80,237,36,18,228,168,55,20,224,12,251,52,93,102,175,46,38,130,66,85,168,195,126,219,95,31,250,41,143,145,41,242,7,30,14,166,249,252,202,138,243,40,41,103,89,133,9,7,154,65,32,36,241,21,247,149,99,48,78};
static const unsigned char precomputed_mGnP_ed25519_P_50[] = {199,107,6,14,106,204,173,171,172,197,195,135,208,242,65,105,184,65,3,53,248,19,42,24,130,222,59,132,6,169,41,35};
static const unsigned char precomputed_mGnP_ed25519_Q_51[] = {111,13,65,39,150,200,200,58,253,154,76,160,106,59,207,119,201,160,208,28,180,32,67,90,242,69,105,34,120,70,142,0,0};
static const unsigned char precomputed_mGnP_ed25519_m_51[] = {152,220,75,52,124,232,213,35,4,214,177,235,213,216,159,240,218,18,61,19,82,69,154,230,47,232,108,229,115,202,67,109};
static const unsigned char precomputed_mGnP_ed25519_n_51[] = {12,122,212,72,89,7,115,202,14,103,9,206,168,142,171,226,178,194,102,85,242,217,133,247,215,163,57,66,134,162,128,55,150,78,152,125,249,175,116,36,94,222,227,140,151,98,214,105,16,27,174,6,39,131,229,238,79,22,164,132,116,169,228,53};
static const unsigned char precomputed_mGnP_ed25519_P_51[] = {65,151,24,239,64,74,239,193,174,29,224,191,212,221,134,157,51,195,248,49,107,37,99,200,22,128,125,206,250,81,111,35};
static const unsigned char precomputed_mGnP_ed25519_Q_52[] = {42,245,168,171,149,209,9,91,24,87,52,230,85,220,126,222,69,163,48,98,130,181,12,218,98,234,7,90,112,192,83,84,0};
static const unsigned char precomputed_mGnP_ed25519_m_52[] = {107,68,95,175,251,249,69,249,156,187,187,33,165,98,72,250,38,189,236,179,56,2,209,131,160,110,99,41,255,184,127,55};
static const unsigned char precomputed_mGnP_ed25519_n_52[] = {167,144,75,53,222,44,55,245,157,236,178,243,115,16,42,19,67,135,216,102,10,46,170,2,38,209,56,120,133,195,226,33,16,74,229,77,87,20,8,1,251,98,145,193,27,214,178,137,143,198,152,51,195,208,131,149,108,136,24,232,185,205,104,134};
static const unsigned char precomputed_mGnP_ed25519_P_52[] = {177,247,0,177,3,171,57,137,155,38,125,194,25,247,245,140,155,229,0,42,239,191,97,152,75,172,202,145,101,17,214,38};
static const unsigned char precomputed_mGnP_ed25519_Q_53[] = {17,231,125,108,129,151,180,104,115,140,118,188,144,92,45,254,71,110,57,130,124,241,213,81,99,32,170,84,123,93,141,43,0};
static const unsigned char precomputed_mGnP_ed25519_m_53[] = {244,76,29,67,84,149,0,177,39,7,38,58,223,25,63,7,24,14,52,41,218,252,69,216,245,25,118,227,42,228,143,76};
static const unsigned char precomputed_mGnP_ed25519_n_53[] = {138,28,146,113,188,179,69,142,119,229,56,30,161,55,58,62,7,147,2,57,106,26,90,239,87,66,162,158,50,129,220,81,146,120,64,148,251,253,133,152,224,222,52,228,200,15,62,120,55,81,4,255,145,176,130,32,118,0,181,42,174,147,43,226};
static const unsigned char precomputed_mGnP_ed25519_P_53[] = {223,216,44,45,181,10,83,110,84,6,126,6,109,2,206,245,142,111,78,106,228,46,208,250,97,79,18,205,28,200,77,39};
static const unsigned char precomputed_mGnP_ed25519_Q_54[] = {229,74,103,141,63,20,223,15,26,155,169,69,200,113,14,92,38,237,104,218,218,104,178,25,83,167,233,61,65,154,210,83,0};
static const unsigned char precomputed_mGnP_ed25519_m_54[] = {187,212,9,183,225,165,169,197,130,23,30,202,74,74,247,229,108,218,26,168,40,192,123,146,169,10,84,28,13,20,67,75};
static const unsigned char precomputed_mGnP_ed25519_n_54[] = {149,235,116,39,243,177,18,254,191,231,41,248,7,175,92,105,250,7,15,162,9,226,135,151,137,179,198,112,3,98,225,69,94,166,251,233,249,153,32,145,244,187,33,182,59,177,133,50,20,20,131,162,244,55,242,214,70,180,32,9,134,182,98,212};
static const unsigned char precomputed_mGnP_ed25519_P_54[] = {87,139,29,60,28,115,112,14,34,56,78,44,30,181,221,106,70,70,179,41,26,78,163,211,121,60,160,133,169,94,159,40};
static const unsigned char precomputed_mGnP_ed25519_Q_55[] = {90,138,186,229,58,42,128,65,199,105,59,121,35,54,61,204,217,100,17,70,6,214,39,14,21,239,40,82,237,202,222,50,0};
static const unsigned char precomputed_mGnP_ed25519_m_55[] = {9,106,247,3,83,87,111,18,167,253,145,203,37,197,185,197,63,49,99,158,211,90,119,134,30,211,230,117,84,82,16,13};
static const unsigned char precomputed_mGnP_ed25519_n_55[] = {217,158,60,158,190,171,81,71,128,188,253,169,75,30,174,243,43,217,32,202,50,146,106,104,92,27,8,110,74,223,196,249,2,57,96,6,99,80,156,142,151,76,182,59,128,208,167,85,190,161,246,201,209,196,144,238,201,241,109,119,41,46,136,40};
static const unsigned char precomputed_mGnP_ed25519_P_55[] = {214,29,37,12,25,50,23,234,30,104,146,137,133,26,147,2,192,156,213,212,0,107,225,220,7,156,137,47,109,121,65,41};
static const unsigned char precomputed_mGnP_ed25519_Q_56[] = {62,27,45,160,250,34,184,215,198,155,193,87,104,14,35,226,242,60,127,75,153,5,171,26,217,244,133,116,119,59,122,224,0};
static const unsigned char precomputed_mGnP_ed25519_m_56[] = {36,156,85,102,129,162,247,33,30,168,166,69,59,172,115,168,87,199,144,147,25,145,145,66,30,247,226,24,236,210,19,232};
static const unsigned char precomputed_mGnP_ed25519_n_56[] = {73,104,197,39,157,212,237,220,182,159,36,63,41,92,133,198,51,225,162,143,170,97,109,149,68,186,217,112,83,45,60,44,152,0,47,108,196,102,109,215,38,169,48,49,8,132,135,30,226,95,25,45,183,84,47,95,149,107,145,155,58,99,225,60};
static const unsigned char precomputed_mGnP_ed25519_P_56[] = {71,115,11,40,71,121,222,157,200,253,37,88,149,201,189,228,121,103,16,216,209,224,15,179,45,249,173,154,254,86,129,44};
static const unsigned char precomputed_mGnP_ed25519_Q_57[] = {224,173,93,72,16,1,131,58,212,4,34,59,155,108,195,82,176,62,23,140,160,161,48,199,199,13,65,232,203,20,241,221,0};
static const unsigned char precomputed_mGnP_ed25519_m_57[] = {162,8,33,200,237,112,120,68,185,134,234,24,136,19,241,200,239,8,170,157,33,133,24,179,43,198,40,151,209,152,43,127};
static const unsigned char precomputed_mGnP_ed25519_n_57[] = {46,132,157,149,28,171,1,116,2,246,39,18,3,88,224,201,137,119,1,73,118,171,176,238,134,199,69,246,22,73,194,9,52,65,218,0,182,109,11,40,186,18,14,166,14,168,135,89,12,194,21,233,76,255,102,185,18,248,125,134,5,26,193,111};
static const unsigned char precomputed_mGnP_ed25519_P_57[] = {196,228,176,109,8,132,104,21,146,247,171,74,172,171,187,80,178,223,34,193,250,46,71,23,171,214,1,6,110,17,210,44};
static const unsigned char precomputed_mGnP_ed25519_Q_58[] = {121,121,155,104,4,104,124,156,77,161,185,126,48,59,140,173,178,0,150,126,64,242,216,1,115,7,145,52,66,77,156,86,0};
static const unsigned char precomputed_mGnP_ed25519_m_58[] = {239,112,136,141,239,134,110,247,137,41,45,95,13,123,64,184,132,209,0,188,149,124,58,209,41,147,104,188,67,188,231,108};
static const unsigned char precomputed_mGnP_ed25519_n_58[] = {198,18,97,51,91,148,134,249,207,239,215,238,12,100,25,107,94,139,141,5,163,2,75,59,6,194,250,215,206,41,200,142,163,33,108,161,111,101,201,234,145,158,254,43,221,162,229,27,227,150,69,229,129,100,197,63,22,57,190,227,111,218,33,225};
static const unsigned char precomputed_mGnP_ed25519_P_58[] = {180,197,177,2,16,210,146,58,7,75,243,35,76,11,100,180,162,152,182,121,119,109,163,254,48,36,81,97,128,102,147,45};
static const unsigned char precomputed_mGnP_ed25519_Q_59[] = {247,153,138,3,58,73,75,192,37,157,100,207,10,101,23,28,114,69,175,230,212,83,196,230,180,191,226,237,61,243,46,146,0};
static const unsigned char precomputed_mGnP_ed25519_m_59[] = {16,117,126,29,176,36,4,104,39,137,174,35,224,159,30,217,88,230,203,37,59,174,76,203,202,232,170,86,146,179,85,120};
static const unsigned char precomputed_mGnP_ed25519_n_59[] = {80,163,246,209,93,216,64,181,217,120,113,111,219,245,18,167,158,39,50,10,226,149,110,234,110,122,8,31,81,193,135,57,218,23,88,247,26,21,94,121,123,76,209,198,23,50,96,187,96,154,149,108,130,184,154,77,218,29,178,189,197,211,176,204};
static const unsigned char precomputed_mGnP_ed25519_P_59[] = {186,70,250,82,228,40,43,83,55,31,133,225,239,143,160,226,23,225,58,252,207,202,116,81,178,20,150,89,14,164,65,48};
static const unsigned char precomputed_mGnP_ed25519_Q_60[] = {230,176,124,10,70,122,91,26,159,37,95,221,50,227,72,169,204,99,70,93,221,132,169,222,129,233,176,129,30,203,152,229,0};
static const unsigned char precomputed_mGnP_ed25519_m_60[] = {168,252,129,57,167,239,52,226,8,19,35,166,207,237,31,255,30,67,105,228,102,140,10,161,161,65,129,177,45,52,207,215};
static const unsigned char precomputed_mGnP_ed25519_n_60[] = {207,134,58,218,92,203,35,189,218,41,119,12,225,183,6,187,23,133,153,88,224,160,195,214,98,59,215,16,201,229,196,217,61,77,0,251,133,36,95,82,48,42,48,57,65,3,166,127,150,134,28,248,67,226,39,65,77,68,114,224,104,213,212,94};
static const unsigned char precomputed_mGnP_ed25519_P_60[] = {2,164,39,56,19,10,255,33,76,226,219,91,174,27,185,47,165,171,243,223,243,221,75,112,196,245,103,21,248,247,187,48};
static const unsigned char precomputed_mGnP_ed25519_Q_61[] = {15,120,33,48,159,194,147,183,215,54,156,119,133,208,196,214,5,129,145,152,127,18,10,144,224,219,225,100,242,108,101,79,0};
static const unsigned char precomputed_mGnP_ed25519_m_61[] = {226,102,135,157,218,1,165,137,166,39,235,168,202,200,223,13,239,184,253,140,248,77,118,116,192,222,193,171,187,173,146,145};
static const unsigned char precomputed_mGnP_ed25519_n_61[] = {207,8,48,72,168,20,225,25,8,111,84,209,102,109,22,218,223,62,148,208,60,173,26,232,114,35,200,74,167,192,14,134,196,39,248,114,169,92,3,252,80,9,158,239,247,105,117,160,101,205,18,77,188,39,134,131,167,56,184,162,177,153,114,197};
static const unsigned char precomputed_mGnP_ed25519_P_61[] = {142,244,68,150,222,150,211,254,205,215,68,178,88,52,152,26,145,14,101,206,18,159,199,146,23,90,210,210,151,118,130,49};
static const unsigned char precomputed_mGnP_ed25519_Q_62[] = {167,1,29,49,129,245,249,183,143,251,188,150,151,209,115,166,165,118,250,183,26,57,79,21,85,191,65,166,191,201,178,226,0};
static const unsigned char precomputed_mGnP_ed25519_m_62[] = {25,220,47,212,47,127,98,191,89,110,122,214,72,141,108,205,69,68,229,103,10,76,14,86,44,57,114,6,111,187,215,114};
static const unsigned char precomputed_mGnP_ed25519_n_62[] = {109,71,57,149,94,78,221,191,81,0,100,200,45,146,158,166,111,88,103,255,189,142,59,201,173,20,95,74,90,254,216,236,78,221,19,59,143,67,110,33,179,234,32,228,148,38,213,110,27,29,234,231,246,136,84,178,219,74,209,188,189,176,224,101};
static const unsigned char precomputed_mGnP_ed25519_P_62[] = {18,235,145,30,130,228,169,214,15,240,202,250,202,187,97,240,114,203,81,230,53,178,128,21,204,150,37,113,166,164,179,50};
static const unsigned char precomputed_mGnP_ed25519_Q_63[] = {107,196,164,146,171,4,159,15,144,166,186,207,125,135,194,226,253,160,150,86,164,112,100,13,238,66,203,120,66,83,101,16,0};
static const unsigned char precomputed_mGnP_ed25519_m_63[] = {86,59,0,2,72,23,188,253,134,220,248,36,208,73,205,107,166,226,25,105,133,206,181,124,204,164,57,77,188,109,207,118};
static const unsigned char precomputed_mGnP_ed25519_n_63[] = {115,141,238,54,85,98,1,129,151,40,32,27,183,86,149,152,101,203,23,213,14,111,11,100,185,192,97,249,221,42,249,79,32,254,53,43,140,216,196,85,118,26,230,67,134,214,148,24,206,238,182,98,2,90,254,4,254,40,151,117,160,80,236,82};
static const unsigned char precomputed_mGnP_ed25519_P_63[] = {167,210,150,114,229,201,82,81,135,160,75,243,98,1,199,26,226,39,106,107,128,163,31,11,162,59,146,125,231,88,224,50};
static const unsigned char precomputed_mGnP_ed25519_Q_64[] = {148,82,13,175,152,167,145,182,128,172,189,135,197,63,174,66,64,205,75,214,54,139,19,139,198,56,15,78,222,158,119,249,0};
static const unsigned char precomputed_mGnP_ed25519_m_64[] = {243,184,217,100,254,29,178,240,239,135,70,162,239,138,146,6,138,29,148,72,184,160,38,114,148,228,18,128,153,11,224,174};
static const unsigned char precomputed_mGnP_ed25519_n_64[] = {18,129,251,148,77,204,30,131,168,167,96,115,177,137,22,219,100,8,163,226,182,95,183,98,181,172,184,70,251,45,179,3,217,225,52,50,225,179,184,64,156,18,62,149,186,56,50,10,239,193,105,183,241,32,232,35,30,93,244,229,115,48,46,227};
static const unsigned char precomputed_mGnP_ed25519_P_64[] = {68,2,91,26,217,254,139,221,39,73,184,210,146,164,44,78,184,255,112,208,54,162,56,50,153,18,172,159,67,102,122,53};
static const unsigned char precomputed_mGnP_ed25519_Q_65[] = {19,162,43,187,208,101,241,158,117,177,24,253,210,184,160,154,65,106,173,236,158,48,208,201,155,121,139,213,47,180,224,184,0};
static const unsigned char precomputed_mGnP_ed25519_m_65[] = {131,168,29,187,246,140,99,94,109,254,15,212,72,65,93,22,101,1,49,47,37,211,77,145,134,207,71,76,253,174,193,181};
static const unsigned char precomputed_mGnP_ed25519_n_65[] = {124,18,76,202,170,211,50,76,30,5,28,181,68,26,116,212,246,166,117,23,112,233,70,209,49,152,132,73,66,249,220,92,96,51,160,53,216,47,125,104,101,26,242,194,75,194,186,36,40,131,180,128,219,102,250,214,75,13,222,41,246,193,226,24};
static const unsigned char precomputed_mGnP_ed25519_P_65[] = {233,12,172,112,192,147,166,147,39,59,151,90,81,96,95,114,142,243,50,253,200,25,171,89,32,91,82,78,239,132,13,55};
static const unsigned char precomputed_mGnP_ed25519_Q_66[] = {83,172,167,145,216,247,82,113,240,244,220,85,56,113,45,184,111,149,176,83,223,154,213,203,140,88,116,202,237,145,52,40,0};
static const unsigned char precomputed_mGnP_ed25519_m_66[] = {69,53,136,190,232,87,98,174,206,191,165,216,171,225,227,134,100,47,142,248,62,46,203,65,5,199,81,60,79,53,59,241};
static const unsigned char precomputed_mGnP_ed25519_n_66[] = {171,28,213,215,22,73,53,11,140,211,214,91,126,37,79,220,83,168,110,246,39,47,186,10,41,233,95,172,153,167,100,117,29,243,103,230,179,72,161,255,83,38,96,164,88,248,59,100,169,189,173,108,196,150,252,140,210,67,188,101,46,203,199,169};
static const unsigned char precomputed_mGnP_ed25519_P_66[] = {225,110,19,97,81,243,92,255,202,187,153,206,129,100,141,62,48,57,186,217,143,9,134,162,123,112,179,197,253,176,56,55};
static const unsigned char precomputed_mGnP_ed25519_Q_67[] = {124,253,128,117,41,108,29,202,23,254,170,169,212,118,185,180,24,221,61,137,66,235,22,4,231,117,103,40,99,39,154,204,0};
static const unsigned char precomputed_mGnP_ed25519_m_67[] = {181,197,14,3,82,56,91,173,34,65,93,208,45,196,167,35,106,53,92,85,2,69,144,149,93,6,53,246,2,232,207,42};
static const unsigned char precomputed_mGnP_ed25519_n_67[] = {191,159,171,96,193,210,197,160,187,253,180,224,115,132,3,149,241,226,218,117,165,255,78,238,8,47,155,159,153,239,154,250,152,121,79,178,74,24,209,187,174,123,168,207,173,40,224,173,105,81,11,106,153,183,53,17,135,221,246,185,137,124,118,185};
static const unsigned char precomputed_mGnP_ed25519_P_67[] = {15,38,156,170,214,169,239,180,234,147,218,70,196,3,211,71,186,238,99,62,246,134,37,6,124,5,211,28,220,130,237,55};
static const unsigned char precomputed_mGnP_ed25519_Q_68[] = {226,73,19,152,162,95,45,105,186,66,128,221,228,182,93,245,203,202,137,236,71,232,124,86,133,157,97,208,174,116,30,46,0};
static const unsigned char precomputed_mGnP_ed25519_m_68[] = {51,88,59,2,201,75,73,134,79,197,103,135,71,43,170,214,193,5,43,187,93,2,38,44,119,204,54,181,222,212,7,84};
static const unsigned char precomputed_mGnP_ed25519_n_68[] = {156,173,28,172,87,15,241,153,52,29,164,76,244,93,32,104,16,190,9,234,71,238,190,62,97,241,221,48,131,50,38,102,125,56,79,194,147,69,151,241,248,151,81,210,215,69,67,174,216,20,168,196,153,95,23,54,246,177,62,156,211,97,227,208};
static const unsigned char precomputed_mGnP_ed25519_P_68[] = {217,49,191,136,255,92,143,239,180,251,18,245,222,109,34,183,41,127,73,5,254,225,153,68,176,43,208,43,10,220,95,57};
static const unsigned char precomputed_mGnP_ed25519_Q_69[] = {89,91,180,113,206,71,1,178,50,154,24,136,73,99,156,64,182,251,10,198,168,83,118,93,115,243,72,233,101,7,107,15,0};
static const unsigned char precomputed_mGnP_ed25519_m_69[] = {47,170,80,5,220,151,138,196,1,111,19,189,219,114,204,255,134,95,57,60,177,219,76,239,129,186,115,216,207,221,177,97};
static const unsigned char precomputed_mGnP_ed25519_n_69[] = {39,84,203,200,33,78,183,157,46,66,214,77,164,219,139,211,134,101,46,254,6,120,47,37,125,220,250,149,26,183,50,167,33,117,49,198,184,6,86,46,111,34,77,97,77,84,190,47,42,160,189,56,82,128,236,77,70,150,113,184,39,24,191,143};
static const unsigned char precomputed_mGnP_ed25519_P_69[] = {63,122,67,230,107,240,216,213,10,9,110,222,86,94,177,229,180,235,177,107,114,124,213,49,118,214,35,68,243,102,62,61};
static const unsigned char precomputed_mGnP_ed25519_Q_70[] = {206,79,49,233,164,205,90,99,13,239,177,207,94,255,194,154,53,19,68,90,101,199,68,154,65,52,161,101,75,123,113,118,0};
static const unsigned char precomputed_mGnP_ed25519_m_70[] = {168,204,42,11,125,101,255,202,37,162,68,168,66,20,42,231,15,235,235,69,216,65,137,29,243,17,78,106,125,55,130,206};
static const unsigned char precomputed_mGnP_ed25519_n_70[] = {47,170,80,43,120,140,181,105,110,231,224,90,247,148,168,19,226,45,151,94,93,17,150,1,29,133,88,104,190,220,142,192,70,26,220,242,35,216,89,233,166,213,42,183,151,188,7,169,118,20,216,56,155,119,62,224,130,131,49,252,47,189,126,119};
static const unsigned char precomputed_mGnP_ed25519_P_70[] = {205,131,228,181,108,197,210,92,220,69,217,99,14,236,103,11,254,178,143,176,74,17,223,84,177,112,113,45,60,168,63,64};
static const unsigned char precomputed_mGnP_ed25519_Q_71[] = {154,151,24,243,94,113,28,51,166,188,104,255,208,182,208,212,240,164,80,252,97,69,24,105,246,109,51,205,41,200,108,76,0};
static const unsigned char precomputed_mGnP_ed25519_m_71[] = {232,62,105,117,172,202,149,71,156,226,84,158,85,1,3,99,52,53,170,156,54,133,250,249,82,238,123,66,210,200,148,227};
static const unsigned char precomputed_mGnP_ed25519_n_71[] = {36,235,101,95,31,236,177,136,189,133,164,188,53,192,178,103,124,168,159,19,96,80,49,222,52,119,170,189,73,57,219,72,226,167,225,15,253,196,110,252,65,171,116,57,164,14,232,57,40,2,153,228,42,14,206,119,181,23,49,253,131,8,33,182};
static const unsigned char precomputed_mGnP_ed25519_P_71[] = {121,78,107,39,56,46,163,237,221,7,132,223,157,121,249,154,234,72,89,68,193,136,205,145,28,153,97,230,101,230,232,64};
static const unsigned char precomputed_mGnP_ed25519_Q_72[] = {64,121,48,83,161,68,2,245,86,175,96,187,75,222,98,16,240,73,208,21,162,145,211,100,214,231,219,203,43,223,214,40,0};
static const unsigned char precomputed_mGnP_ed25519_m_72[] = {213,21,80,94,117,75,174,79,26,21,25,31,34,159,199,155,50,245,59,194,11,133,223,27,124,188,163,165,42,66,149,141};
static const unsigned char precomputed_mGnP_ed25519_n_72[] = {5,108,97,54,96,230,153,71,106,3,218,125,149,5,159,154,188,196,147,252,223,103,80,72,97,34,170,120,214,169,223,121,88,115,195,128,71,143,28,196,152,172,55,216,147,195,255,226,165,41,228,153,106,97,147,239,247,194,126,221,97,186,201,88};
static const unsigned char precomputed_mGnP_ed25519_P_72[] = {45,143,42,61,151,228,197,167,52,156,175,209,21,74,32,108,56,62,136,106,141,11,89,252,59,187,76,76,65,62,245,64};
static const unsigned char precomputed_mGnP_ed25519_Q_73[] = {52,133,105,67,134,132,43,116,176,162,111,127,16,102,221,138,121,248,38,220,141,30,25,139,133,85,49,186,179,60,71,15,0};
static const unsigned char precomputed_mGnP_ed25519_m_73[] = {125,164,137,67,133,155,45,50,163,76,109,132,112,54,60,115,59,20,89,156,73,106,13,179,48,32,251,143,176,64,66,221};
static const unsigned char precomputed_mGnP_ed25519_n_73[] = {173,81,213,70,32,139,78,30,36,177,96,197,184,233,228,128,44,216,189,182,26,215,81,164,17,36,48,68,173,6,44,48,207,136,1,93,25,9,79,36,73,209,228,55,76,108,199,65,33,138,112,94,78,144,184,158,25,110,136,139,255,238,174,203};
static const unsigned char precomputed_mGnP_ed25519_P_73[] = {145,208,46,32,13,252,228,53,6,139,4,78,173,242,164,13,67,207,6,60,77,204,46,193,43,88,175,225,13,16,72,65};
static const unsigned char precomputed_mGnP_ed25519_Q_74[] = {70,229,176,18,106,251,184,129,253,195,114,250,19,172,48,77,36,29,55,91,130,203,238,115,24,195,58,198,142,248,40,167,0};
static const unsigned char precomputed_mGnP_ed25519_m_74[] = {106,51,20,116,2,106,118,224,97,162,241,129,66,163,0,251,71,95,239,139,109,241,58,219,210,235,154,10,19,19,141,123};
static const unsigned char precomputed_mGnP_ed25519_n_74[] = {25,92,130,161,236,117,229,84,64,240,225,48,70,103,223,159,230,71,15,105,105,41,180,175,44,115,42,184,102,59,184,173,253,148,214,131,34,144,14,204,119,126,146,245,16,224,108,83,95,213,24,2,166,206,169,47,250,179,57,19,71,196,67,68};
static const unsigned char precomputed_mGnP_ed25519_P_74[] = {182,18,95,224,137,137,7,82,75,21,206,108,134,232,116,54,130,23,101,9,173,169,33,221,66,72,237,193,236,175,21,68};
static const unsigned char precomputed_mGnP_ed25519_Q_75[] = {112,164,82,139,97,62,130,10,27,55,125,252,142,110,128,95,47,2,61,232,184,197,48,6,104,16,155,171,223,192,89,35,0};
static const unsigned char precomputed_mGnP_ed25519_m_75[] = {76,46,148,134,27,146,178,213,128,114,239,156,159,128,150,41,144,70,48,114,70,67,51,110,71,229,144,230,74,200,166,215};
static const unsigned char precomputed_mGnP_ed25519_n_75[] = {205,81,237,151,104,62,56,197,209,59,65,52,112,97,217,204,169,47,111,146,67,238,180,49,158,239,158,236,107,97,6,180,144,119,192,185,131,10,38,173,206,202,243,229,243,136,186,48,7,27,192,18,81,51,166,80,161,29,66,9,2,236,235,42};
static const unsigned char precomputed_mGnP_ed25519_P_75[] = {90,151,55,119,99,172,162,93,193,113,7,114,197,167,118,93,81,212,200,116,11,244,13,131,119,104,212,16,145,200,237,69};
static const unsigned char precomputed_mGnP_ed25519_Q_76[] = {190,208,247,211,155,59,75,157,179,250,254,252,189,215,31,67,131,3,63,236,249,194,189,213,208,109,108,138,209,69,193,248,1};
static const unsigned char precomputed_mGnP_ed25519_m_76[] = {205,131,253,72,145,232,38,205,159,8,207,144,84,249,21,115,31,124,139,206,142,38,128,2,147,116,78,29,37,160,129,11};
static const unsigned char precomputed_mGnP_ed25519_n_76[] = {27,250,68,106,69,135,8,17,92,199,244,83,21,216,247,255,86,57,236,57,224,220,208,165,121,215,67,40,95,51,225,220,202,83,249,38,68,60,47,197,186,102,92,212,229,254,220,180,37,38,171,126,2,188,211,212,13,40,161,91,133,187,103,105};
static const unsigned char precomputed_mGnP_ed25519_P_76[] = {52,237,196,85,30,241,2,205,246,153,11,186,199,15,81,101,179,37,191,166,164,177,249,254,245,193,141,16,27,12,7,71};
static const unsigned char precomputed_mGnP_ed25519_Q_77[] = {195,212,248,226,74,37,57,179,228,212,149,3,56,29,169,51,207,220,254,199,57,150,214,28,90,235,253,21,171,157,55,249,1};
static const unsigned char precomputed_mGnP_ed25519_m_77[] = {96,151,31,137,24,112,150,195,145,38,26,220,52,42,60,74,60,61,115,209,131,131,11,217,189,194,65,222,80,117,95,10};
static const unsigned char precomputed_mGnP_ed25519_n_77[] = {68,100,155,89,237,22,117,100,171,79,170,41,63,92,46,112,139,137,142,58,0,252,236,128,197,81,87,255,243,19,14,239,221,172,114,234,5,101,79,179,30,234,65,160,52,161,130,228,98,4,17,21,122,29,225,182,203,80,106,195,219,72,57,143};
static const unsigned char precomputed_mGnP_ed25519_P_77[] = {100,38,244,188,137,70,78,230,162,25,214,6,142,134,54,150,147,230,43,93,36,46,210,188,247,179,32,157,207,140,12,71};
static const unsigned char precomputed_mGnP_ed25519_Q_78[] = {255,165,59,4,252,157,248,120,243,44,253,180,197,252,185,108,117,207,103,140,135,24,128,142,70,140,155,225,189,22,211,36,0};
static const unsigned char precomputed_mGnP_ed25519_m_78[] = {245,201,0,64,196,72,44,155,190,144,4,1,69,209,190,214,34,145,212,174,132,231,129,10,247,141,156,121,18,42,31,159};
static const unsigned char precomputed_mGnP_ed25519_n_78[] = {5,18,113,52,85,89,174,185,54,255,162,123,102,134,49,39,238,106,194,35,48,102,63,116,156,76,125,146,5,61,164,198,226,170,114,23,222,230,16,236,102,139,45,131,159,4,92,99,153,140,130,53,217,58,252,173,245,129,161,208,226,246,241,250};
static const unsigned char precomputed_mGnP_ed25519_P_78[] = {103,147,223,167,47,28,51,206,134,23,84,253,66,253,110,157,218,220,83,83,161,249,85,144,43,247,67,184,116,36,66,74};
static const unsigned char precomputed_mGnP_ed25519_Q_79[] = {181,191,220,203,233,160,210,206,1,145,86,245,157,81,209,216,149,236,44,74,147,78,240,173,11,181,37,82,115,76,250,5,0};
static const unsigned char precomputed_mGnP_ed25519_m_79[] = {219,20,222,204,237,101,236,30,241,105,252,86,94,187,66,70,99,27,64,64,93,121,251,110,188,136,215,46,80,124,221,237};
static const unsigned char precomputed_mGnP_ed25519_n_79[] = {9,12,65,92,141,211,51,205,191,85,91,214,242,128,113,167,208,193,195,194,76,94,16,80,148,201,194,60,160,50,148,138,190,45,25,232,16,186,242,210,75,143,170,134,144,125,136,61,220,192,4,229,131,231,82,65,56,28,240,99,178,130,216,108};
static const unsigned char precomputed_mGnP_ed25519_P_79[] = {128,225,254,112,11,214,173,199,112,250,76,43,159,253,110,117,105,22,167,152,221,165,163,11,235,207,217,79,112,132,194,74};
static const unsigned char precomputed_mGnP_ed25519_Q_80[] = {29,1,186,38,166,25,107,94,126,203,3,182,237,28,134,27,16,62,100,83,118,66,155,243,241,233,189,95,149,230,247,8,0};
static const unsigned char precomputed_mGnP_ed25519_m_80[] = {226,43,170,250,230,36,5,208,250,219,166,16,189,100,48,198,218,233,52,81,24,60,154,82,141,11,187,41,38,155,59,253};
static const unsigned char precomputed_mGnP_ed25519_n_80[] = {253,161,124,49,71,104,59,14,197,58,198,3,2,180,47,226,99,120,236,127,124,70,207,143,67,95,114,76,127,32,28,44,104,87,126,75,17,171,252,168,0,253,235,98,144,101,42,59,225,71,173,225,1,109,188,181,249,238,159,238,24,163,114,165};
static const unsigned char precomputed_mGnP_ed25519_P_80[] = {36,104,163,116,124,109,81,96,141,238,89,230,234,59,182,21,202,187,196,154,32,78,218,111,43,79,206,50,58,105,205,74};
static const unsigned char precomputed_mGnP_ed25519_Q_81[] = {210,159,87,255,96,17,153,83,14,98,77,176,147,132,97,224,31,145,85,54,10,224,74,103,64,188,22,226,110,163,107,22,0};
static const unsigned char precomputed_mGnP_ed25519_m_81[] = {13,166,217,76,35,11,140,70,25,175,208,170,163,100,113,144,234,212,165,224,185,131,99,236,54,101,218,224,236,200,206,116};
static const unsigned char precomputed_mGnP_ed25519_n_81[] = {14,83,99,227,44,181,29,117,72,145,85,163,141,92,245,239,109,203,235,168,5,73,104,218,22,191,168,158,156,24,209,55,214,194,242,49,85,209,110,94,40,245,48,38,243,15,29,227,208,171,133,13,238,76,135,185,87,221,62,219,240,247,160,54};
static const unsigned char precomputed_mGnP_ed25519_P_81[] = {208,242,110,90,72,140,78,17,11,232,22,29,211,15,115,42,91,210,250,111,137,68,115,53,37,13,223,153,64,187,214,79};
static const unsigned char precomputed_mGnP_ed25519_Q_82[] = {76,173,220,109,186,95,116,216,62,108,230,81,64,143,201,53,239,88,186,253,201,3,109,8,244,1,169,220,102,71,189,27,0};
static const unsigned char precomputed_mGnP_ed25519_m_82[] = {97,27,44,210,100,246,162,191,36,182,233,119,62,224,118,46,208,57,111,67,86,29,30,2,244,150,80,249,36,221,172,176};
static const unsigned char precomputed_mGnP_ed25519_n_82[] = {172,153,23,5,217,225,127,61,47,82,197,188,253,153,164,97,162,236,180,19,239,25,226,201,149,189,143,114,47,107,105,219,185,247,176,74,193,250,225,174,112,4,127,255,190,119,184,209,125,215,115,20,98,65,254,71,229,81,27,147,227,74,20,18};
static const unsigned char precomputed_mGnP_ed25519_P_82[] = {103,146,179,33,108,99,169,165,255,105,248,67,103,183,62,212,155,30,0,215,242,229,230,102,119,48,128,159,187,25,225,79};
static const unsigned char precomputed_mGnP_ed25519_Q_83[] = {96,133,226,52,201,79,156,205,252,142,87,98,60,169,195,153,147,125,204,131,160,247,241,74,201,95,36,22,21,79,107,21,0};
static const unsigned char precomputed_mGnP_ed25519_m_83[] = {172,148,59,148,242,32,5,108,246,237,156,51,71,55,106,173,223,35,246,194,152,131,24,170,9,249,97,247,188,131,126,194};
static const unsigned char precomputed_mGnP_ed25519_n_83[] = {242,202,119,59,130,110,137,56,89,31,116,119,219,183,56,32,180,116,34,189,6,115,215,155,96,238,116,199,113,122,93,131,94,173,130,210,198,43,214,250,162,161,197,203,112,254,189,184,9,208,250,210,253,124,82,98,153,70,131,95,24,53,181,97};
static const unsigned char precomputed_mGnP_ed25519_P_83[] = {103,70,152,180,184,0,206,31,156,181,59,146,75,251,253,210,202,235,151,165,221,1,0,48,246,42,167,193,126,17,72,80};
static const unsigned char precomputed_mGnP_ed25519_Q_84[] = {54,166,52,180,65,207,217,247,52,226,216,255,155,219,159,105,29,230,137,236,98,63,73,251,131,97,220,106,65,87,20,168,0};
static const unsigned char precomputed_mGnP_ed25519_m_84[] = {226,1,9,4,145,114,92,183,14,187,130,148,34,53,4,22,2,15,85,11,195,110,60,39,137,55,109,0,174,43,139,243};
static const unsigned char precomputed_mGnP_ed25519_n_84[] = {31,169,161,54,171,247,212,8,187,222,193,175,219,74,22,216,213,218,142,161,8,231,122,76,221,89,106,46,32,156,185,120,46,0,115,96,217,143,199,87,215,149,160,44,209,69,96,114,95,76,77,110,153,90,109,223,146,230,246,121,111,243,45,253};
static const unsigned char precomputed_mGnP_ed25519_P_84[] = {29,249,54,71,143,91,3,152,41,66,231,43,195,76,148,132,237,52,126,153,4,43,248,35,68,10,40,98,122,17,1,82};
static const unsigned char precomputed_mGnP_ed25519_Q_85[] = {208,150,155,48,210,67,120,151,4,173,240,229,117,12,18,63,155,67,118,183,250,105,93,194,145,86,138,3,225,124,7,141,0};
static const unsigned char precomputed_mGnP_ed25519_m_85[] = {51,101,159,49,0,222,246,249,145,81,79,191,217,180,122,137,157,223,123,85,141,209,24,74,145,147,124,120,76,94,15,29};
static const unsigned char precomputed_mGnP_ed25519_n_85[] = {178,133,155,88,53,191,29,127,62,85,109,89,223,233,197,21,105,108,224,145,93,218,129,60,82,123,205,224,228,190,206,214,252,92,251,143,224,54,68,121,104,120,164,222,173,116,18,40,120,170,43,199,187,155,61,115,175,28,156,175,194,231,133,90};
static const unsigned char precomputed_mGnP_ed25519_P_85[] = {221,28,66,103,33,110,75,113,187,134,110,164,119,237,103,137,146,195,72,82,183,130,227,165,61,111,248,242,216,34,43,83};
static const unsigned char precomputed_mGnP_ed25519_Q_86[] = {149,26,45,113,116,70,47,95,51,219,222,12,204,90,132,194,176,93,201,200,185,65,215,195,57,34,228,110,202,47,169,25,0};
static const unsigned char precomputed_mGnP_ed25519_m_86[] = {174,84,241,21,156,12,46,24,245,84,16,220,182,182,72,88,23,90,159,65,196,187,75,150,35,18,188,54,81,30,45,122};
static const unsigned char precomputed_mGnP_ed25519_n_86[] = {44,165,20,253,169,77,142,157,138,235,8,94,82,83,62,210,235,215,108,179,141,177,3,124,163,205,152,244,131,193,92,18,76,60,107,104,50,27,144,43,67,213,13,113,142,125,231,12,17,23,105,136,224,231,134,72,79,100,244,252,152,175,224,52};
static const unsigned char precomputed_mGnP_ed25519_P_86[] = {8,95,214,196,190,247,191,203,167,220,91,68,19,123,144,2,144,245,250,107,3,96,231,241,243,86,193,203,135,228,31,85};
static const unsigned char precomputed_mGnP_ed25519_Q_87[] = {241,16,21,139,214,66,244,12,211,67,9,249,78,225,166,176,197,33,255,175,81,20,190,3,98,36,164,96,8,82,42,195,0};
static const unsigned char precomputed_mGnP_ed25519_m_87[] = {31,142,135,193,1,215,238,172,244,14,164,230,69,5,133,47,94,175,138,108,184,157,66,8,230,7,51,212,47,35,8,242};
static const unsigned char precomputed_mGnP_ed25519_n_87[] = {254,197,187,189,154,165,185,64,65,167,17,132,24,37,18,119,134,132,121,123,222,30,202,74,154,91,234,221,35,20,242,254,171,167,145,65,128,175,176,37,130,67,254,175,74,102,254,42,202,141,143,171,83,189,17,152,74,105,97,217,218,49,210,231};
static const unsigned char precomputed_mGnP_ed25519_P_87[] = {95,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,87};
static const unsigned char precomputed_mGnP_ed25519_Q_88[] = {10,146,230,112,13,84,206,28,164,135,218,74,29,232,232,2,109,110,199,116,213,135,33,100,37,73,119,232,73,241,147,212,0};
static const unsigned char precomputed_mGnP_ed25519_m_88[] = {142,237,160,93,232,126,192,35,11,164,19,150,213,194,81,41,176,182,223,40,50,8,239,15,145,243,39,254,159,27,81,67};
static const unsigned char precomputed_mGnP_ed25519_n_88[] = {134,108,81,3,119,194,231,152,100,83,182,196,215,22,208,169,104,64,123,46,179,85,122,29,155,186,142,125,248,89,0,22,66,223,190,131,176,180,65,24,193,247,10,41,165,189,25,254,132,59,62,29,147,133,45,167,82,20,151,49,6,17,227,129};
static const unsigned char precomputed_mGnP_ed25519_P_88[] = {29,182,217,36,219,194,226,80,102,180,84,3,108,168,134,207,11,172,66,128,227,162,187,36,19,1,127,120,57,109,178,87};
static const unsigned char precomputed_mGnP_ed25519_Q_89[] = {108,70,18,238,34,153,50,10,20,64,101,210,204,188,154,173,222,179,182,223,153,116,154,157,128,200,164,200,36,106,141,54,0};
static const unsigned char precomputed_mGnP_ed25519_m_89[] = {213,41,111,56,14,157,182,65,98,218,184,232,244,236,124,43,245,69,210,154,29,107,247,30,59,177,116,16,210,176,213,99};
static const unsigned char precomputed_mGnP_ed25519_n_89[] = {87,155,98,90,210,82,97,43,159,197,38,198,21,82,107,135,235,221,17,97,36,230,11,233,101,8,25,119,191,149,49,12,25,105,236,105,178,6,201,247,242,140,70,143,220,127,91,119,254,64,244,26,109,166,136,95,87,154,7,78,223,244,173,19};
static const unsigned char precomputed_mGnP_ed25519_P_89[] = {87,173,12,84,130,4,224,15,255,165,110,22,255,93,102,224,201,159,218,22,129,106,106,100,37,117,25,252,193,223,118,88};
static const unsigned char precomputed_mGnP_ed25519_Q_90[] = {245,171,111,80,134,249,172,93,28,33,1,185,246,12,244,174,120,46,65,202,57,96,255,211,85,76,201,80,218,16,240,69,0};
static const unsigned char precomputed_mGnP_ed25519_m_90[] = {120,189,78,19,31,201,127,145,42,44,95,214,209,131,134,42,146,165,137,201,14,3,54,93,229,178,234,38,225,184,168,178};
static const unsigned char precomputed_mGnP_ed25519_n_90[] = {14,37,56,41,228,116,185,166,177,208,177,165,162,226,107,3,239,160,144,3,38,230,115,97,148,42,230,176,187,143,23,230,100,129,106,199,208,185,75,48,58,38,69,150,168,87,4,184,148,90,121,45,9,219,76,35,44,218,157,164,196,190,196,207};
static const unsigned char precomputed_mGnP_ed25519_P_90[] = {50,218,214,158,75,153,232,238,246,90,195,93,68,97,229,252,238,232,229,49,117,154,108,77,181,165,23,48,119,20,9,94};
static const unsigned char precomputed_mGnP_ed25519_Q_91[] = {242,85,168,64,59,31,74,217,247,26,172,63,140,87,91,217,142,210,135,30,245,129,254,32,163,57,109,218,179,210,181,153,0};
static const unsigned char precomputed_mGnP_ed25519_m_91[] = {91,244,98,112,241,189,229,178,62,171,51,94,144,103,129,164,115,59,204,8,207,121,185,66,99,59,183,82,29,183,203,91};
static const unsigned char precomputed_mGnP_ed25519_n_91[] = {131,248,154,140,112,176,222,235,17,13,162,238,64,211,140,42,85,113,189,251,49,107,0,90,215,201,120,243,70,243,59,211,238,100,220,142,116,151,196,254,222,197,228,6,253,202,78,29,40,33,238,117,198,49,200,154,52,62,91,51,255,239,155,205};
static const unsigned char precomputed_mGnP_ed25519_P_91[] = {33,158,135,215,170,85,89,178,199,10,178,241,198,171,131,3,255,209,83,204,190,12,196,245,219,115,188,16,200,207,179,98};
static const unsigned char precomputed_mGnP_ed25519_Q_92[] = {118,173,18,240,139,31,58,166,73,214,236,231,203,65,140,213,148,241,218,146,249,73,69,26,34,16,222,28,172,17,27,228,0};
static const unsigned char precomputed_mGnP_ed25519_m_92[] = {138,3,228,82,184,177,246,115,161,210,89,153,80,152,89,7,216,143,182,131,237,72,201,179,69,41,160,95,111,198,148,242};
static const unsigned char precomputed_mGnP_ed25519_n_92[] = {147,73,122,2,95,222,165,110,175,206,207,47,253,44,217,108,30,169,73,186,41,203,82,161,102,26,65,133,38,34,137,83,200,91,97,68,208,113,240,95,29,242,101,128,144,28,60,216,135,56,140,21,170,202,169,236,237,76,141,90,191,136,39,191};
static const unsigned char precomputed_mGnP_ed25519_P_92[] = {54,129,203,31,182,210,103,149,201,84,239,1,4,173,95,59,164,114,126,8,140,177,48,18,5,0,77,93,8,226,19,103};
static const unsigned char precomputed_mGnP_ed25519_Q_93[] = {201,203,49,247,94,189,26,226,146,64,224,110,217,106,165,142,108,225,107,89,114,234,161,25,244,151,106,205,7,190,246,52,0};
static const unsigned char precomputed_mGnP_ed25519_m_93[] = {251,69,208,40,183,154,92,138,213,240,233,57,155,57,134,55,171,172,70,233,22,23,12,11,6,228,64,154,139,59,217,77};
static const unsigned char precomputed_mGnP_ed25519_n_93[] = {220,175,73,29,205,206,167,28,179,132,245,123,143,223,3,136,251,241,221,41,186,168,59,237,171,29,129,9,175,123,236,177,19,228,89,50,222,96,116,152,27,196,158,9,27,56,102,96,223,93,76,190,146,218,222,63,87,87,152,56,193,112,226,251};
static const unsigned char precomputed_mGnP_ed25519_P_93[] = {213,105,89,54,151,2,93,204,228,177,220,135,151,91,75,114,81,144,186,151,76,179,156,47,245,18,103,71,82,115,76,107};
static const unsigned char precomputed_mGnP_ed25519_Q_94[] = {255,19,90,217,255,0,128,224,20,1,148,40,83,205,84,84,165,62,37,174,124,85,38,53,40,252,196,125,97,149,110,171,0};
static const unsigned char precomputed_mGnP_ed25519_m_94[] = {36,30,18,116,136,206,195,223,24,156,63,44,105,195,239,5,109,24,17,95,193,236,220,50,199,103,162,62,118,6,143,227};
static const unsigned char precomputed_mGnP_ed25519_n_94[] = {246,224,71,2,195,14,113,180,222,135,88,91,238,96,197,2,190,130,168,100,78,29,71,97,6,145,58,134,227,215,72,130,105,47,88,65,239,8,115,104,251,185,63,143,112,49,43,249,184,75,115,36,202,55,39,168,225,111,238,206,31,209,144,33};
static const unsigned char precomputed_mGnP_ed25519_P_94[] = {210,76,135,163,211,65,145,20,82,211,212,126,203,80,22,158,160,58,151,101,216,149,170,224,51,231,7,192,105,11,100,107};
static const unsigned char precomputed_mGnP_ed25519_Q_95[] = {211,180,113,95,215,200,92,227,150,31,167,198,135,86,173,162,80,27,232,101,211,160,248,110,159,133,107,211,168,58,106,151,0};
static const unsigned char precomputed_mGnP_ed25519_m_95[] = {113,13,201,84,66,144,100,125,30,146,212,189,210,38,19,118,187,32,170,213,209,232,157,106,249,47,167,90,228,215,135,240};
static const unsigned char precomputed_mGnP_ed25519_n_95[] = {74,98,159,204,117,5,76,155,155,147,199,171,41,188,89,171,183,232,72,54,53,41,3,55,54,85,165,131,82,186,96,49,75,134,166,9,107,132,76,106,175,42,185,149,18,108,199,67,164,185,242,128,248,153,98,74,89,220,179,54,149,231,149,219};
static const unsigned char precomputed_mGnP_ed25519_P_95[] = {249,39,38,36,232,230,206,127,84,51,49,159,243,150,75,230,222,245,87,204,175,97,107,179,146,240,206,238,89,157,153,108};
static const unsigned char precomputed_mGnP_ed25519_Q_96[] = {103,197,24,44,169,145,191,232,180,145,83,223,37,90,49,228,95,244,186,197,248,216,89,17,31,148,158,193,22,104,51,47,0};
static const unsigned char precomputed_mGnP_ed25519_m_96[] = {252,28,157,173,147,227,165,169,62,81,24,242,78,114,91,135,215,151,45,7,12,41,201,232,174,84,116,243,75,57,216,131};
static const unsigned char precomputed_mGnP_ed25519_n_96[] = {4,145,9,42,171,194,229,233,52,88,190,228,190,222,68,135,168,48,69,210,70,143,23,36,154,38,179,236,10,15,223,239,152,92,179,6,5,245,84,85,193,76,111,196,186,250,156,161,160,188,47,212,209,18,14,250,45,252,43,70,20,159,165,12};
static const unsigned char precomputed_mGnP_ed25519_P_96[] = {60,165,126,144,74,35,167,121,71,123,75,252,34,112,32,138,190,164,37,251,92,56,21,215,208,217,97,205,165,45,185,108};
static const unsigned char precomputed_mGnP_ed25519_Q_97[] = {116,206,157,129,17,137,64,12,112,19,56,150,93,252,205,252,49,86,59,188,154,131,254,222,0,121,150,28,165,255,247,137,0};
static const unsigned char precomputed_mGnP_ed25519_m_97[] = {77,119,217,151,138,214,35,150,192,254,164,19,76,179,37,162,125,188,249,9,252,150,98,209,144,163,36,40,58,244,92,66};
static const unsigned char precomputed_mGnP_ed25519_n_97[] = {143,220,233,112,70,65,20,178,104,91,248,35,197,179,99,206,155,6,112,142,226,37,148,83,137,228,122,249,59,82,102,193,193,49,237,227,63,215,117,69,146,114,83,65,143,21,5,52,100,70,166,94,254,162,124,57,31,146,107,250,220,46,48,210};
static const unsigned char precomputed_mGnP_ed25519_P_97[] = {78,154,192,104,2,2,81,141,207,192,101,46,36,183,197,24,154,29,122,177,62,241,220,250,177,110,114,197,242,199,41,112};
static const unsigned char precomputed_mGnP_ed25519_Q_98[] = {120,103,31,230,182,239,69,236,65,16,9,114,175,98,139,133,70,51,150,24,202,31,137,78,106,125,160,250,107,220,7,150,0};
static const unsigned char precomputed_mGnP_ed25519_m_98[] = {38,6,220,211,85,41,183,164,57,2,213,162,187,73,18,247,191,91,241,192,118,216,51,196,83,195,0,117,148,146,160,228};
static const unsigned char precomputed_mGnP_ed25519_n_98[] = {74,141,73,135,168,17,244,91,161,53,237,232,131,49,58,140,175,5,83,120,7,252,173,85,105,72,6,191,42,232,59,223,158,23,3,230,174,75,253,35,123,213,53,144,58,1,85,66,226,96,140,65,43,249,98,144,82,30,231,90,191,93,71,30};
static const unsigned char precomputed_mGnP_ed25519_P_98[] = {215,112,3,150,147,250,141,106,5,182,204,42,223,25,43,127,93,204,144,57,219,152,192,236,42,0,172,170,34,163,162,112};
static const unsigned char precomputed_mGnP_ed25519_Q_99[] = {20,34,70,138,6,117,245,37,186,76,131,83,174,95,215,192,24,253,109,124,102,52,251,210,167,98,46,54,121,111,62,63,0};
static const unsigned char precomputed_mGnP_ed25519_m_99[] = {164,93,230,155,71,186,139,79,185,170,33,158,49,249,72,90,134,123,155,133,208,45,253,132,221,197,89,127,49,113,152,85};
static const unsigned char precomputed_mGnP_ed25519_n_99[] = {129,85,99,153,177,59,85,81,226,56,208,148,88,67,123,80,15,94,23,3,82,63,140,147,82,140,206,46,70,173,245,128,19,50,242,204,219,11,213,204,74,211,115,68,181,248,47,19,63,219,165,115,83,60,229,179,107,92,15,90,251,1,214,89};
static const unsigned char precomputed_mGnP_ed25519_P_99[] = {28,108,193,36,56,188,232,222,209,69,152,221,56,98,101,247,22,253,219,116,84,194,12,86,14,193,79,74,18,213,192,112};
static const unsigned char precomputed_mGnP_ed25519_Q_100[] = {55,88,87,251,10,197,49,177,238,221,225,75,124,110,119,127,168,72,234,68,102,17,32,167,101,52,50,174,6,161,4,125,0};
static const unsigned char precomputed_mGnP_ed25519_m_100[] = {114,139,40,87,137,10,94,45,68,210,159,149,9,152,81,115,240,212,32,71,249,129,125,242,129,109,74,133,220,29,205,174};
static const unsigned char precomputed_mGnP_ed25519_n_100[] = {158,112,251,126,223,141,246,49,88,113,153,160,233,47,203,41,142,154,140,113,26,112,157,145,128,179,240,229,240,246,24,169,229,227,250,38,11,33,107,89,147,0,47,169,188,36,30,43,24,69,162,171,228,133,233,125,250,180,166,62,128,194,126,96};
static const unsigned char precomputed_mGnP_ed25519_P_100[] = {113,168,202,225,174,241,105,63,76,244,7,153,70,8,140,238,63,59,110,110,8,78,147,119,241,98,69,40,35,48,237,113};
static const unsigned char precomputed_mGnP_ed25519_Q_101[] = {7,62,151,237,172,86,187,58,29,196,83,25,157,21,213,201,228,225,228,158,187,235,59,119,233,220,142,248,96,19,79,65,0};
static const unsigned char precomputed_mGnP_ed25519_m_101[] = {90,90,250,202,123,157,139,60,81,30,109,201,231,145,80,120,119,138,56,218,20,81,240,182,171,33,147,64,111,27,225,240};
static const unsigned char precomputed_mGnP_ed25519_n_101[] = {138,42,16,151,1,40,58,88,213,38,245,200,208,98,206,130,79,146,26,34,1,217,50,82,233,167,231,28,45,11,99,115,179,247,196,134,32,240,171,128,40,153,248,49,10,16,27,192,169,65,191,183,199,98,106,207,36,102,45,217,190,37,36,238};
static const unsigned char precomputed_mGnP_ed25519_P_101[] = {63,24,82,104,230,229,60,65,45,199,150,19,78,9,16,25,94,21,229,57,134,215,65,160,213,176,158,236,37,61,42,114};
static const unsigned char precomputed_mGnP_ed25519_Q_102[] = {107,43,89,86,247,102,229,131,249,152,25,245,66,71,250,216,38,159,91,238,127,109,121,59,102,44,253,208,87,116,141,0,0};
static const unsigned char precomputed_mGnP_ed25519_m_102[] = {46,115,7,34,147,20,153,141,216,185,30,60,9,251,166,16,119,83,248,198,102,219,9,121,88,162,7,172,191,223,66,110};
static const unsigned char precomputed_mGnP_ed25519_n_102[] = {21,150,103,39,221,112,136,105,246,247,204,108,186,236,220,63,170,42,46,125,212,155,47,207,238,206,60,94,15,184,197,4,79,109,101,66,111,109,79,21,205,192,230,222,197,161,222,176,189,230,149,121,46,176,213,209,174,154,6,201,67,57,103,99};
static const unsigned char precomputed_mGnP_ed25519_P_102[] = {136,141,166,125,172,46,107,241,28,17,176,185,50,174,195,232,68,142,198,30,162,192,132,24,159,163,8,179,67,215,113,116};
static const unsigned char precomputed_mGnP_ed25519_Q_103[] = {8,17,192,63,50,158,168,102,129,177,21,70,78,37,56,138,173,12,163,34,76,192,35,118,10,70,17,163,254,193,176,205,0};
static const unsigned char precomputed_mGnP_ed25519_m_103[] = {113,98,137,30,106,13,22,133,131,248,96,106,126,130,13,1,123,66,105,10,144,146,14,199,143,253,64,177,18,207,119,200};
static const unsigned char precomputed_mGnP_ed25519_n_103[] = {130,175,197,155,124,136,216,18,174,47,139,133,153,146,17,228,25,161,188,150,173,246,13,160,152,73,117,229,116,238,111,88,76,218,152,72,58,172,238,80,4,124,50,251,104,73,51,147,167,117,86,38,138,62,215,71,148,116,10,120,92,150,236,95};
static const unsigned char precomputed_mGnP_ed25519_P_103[] = {15,212,111,12,27,25,213,247,143,250,231,170,223,124,55,203,221,72,232,246,227,201,223,174,76,9,234,163,228,146,211,116};
static const unsigned char precomputed_mGnP_ed25519_Q_104[] = {200,9,16,33,63,225,14,34,183,215,65,22,65,3,89,181,80,108,26,189,159,229,64,48,180,69,121,133,123,149,199,34,0};
static const unsigned char precomputed_mGnP_ed25519_m_104[] = {113,138,250,102,7,28,175,209,255,148,203,157,106,6,99,249,32,200,190,201,194,1,216,45,236,97,122,13,136,242,46,235};
static const unsigned char precomputed_mGnP_ed25519_n_104[] = {114,133,254,32,147,11,3,1,50,26,49,60,5,138,113,0,94,146,31,25,104,44,31,253,61,242,172,110,149,26,239,55,84,238,117,164,133,112,55,77,211,31,70,229,1,78,70,186,8,248,35,34,95,36,74,206,160,83,135,240,170,57,142,221};
static const unsigned char precomputed_mGnP_ed25519_P_104[] = {189,129,176,12,94,42,9,222,24,87,94,100,15,11,204,157,195,143,17,33,3,187,44,41,61,147,60,52,244,226,78,118};
static const unsigned char precomputed_mGnP_ed25519_Q_105[] = {125,132,107,105,210,208,156,202,80,157,75,72,33,40,179,247,181,210,161,224,233,119,166,69,19,110,19,208,31,102,50,171,0};
static const unsigned char precomputed_mGnP_ed25519_m_105[] = {184,205,249,85,69,156,209,39,132,167,194,51,124,132,36,136,16,11,193,58,175,41,58,190,23,12,100,38,198,250,140,100};
static const unsigned char precomputed_mGnP_ed25519_n_105[] = {80,174,98,51,244,50,158,117,14,244,195,248,114,15,97,217,20,109,92,78,245,138,66,236,51,109,9,60,72,218,47,162,107,112,33,41,15,76,203,16,255,101,110,247,107,175,190,159,130,142,233,105,116,175,194,181,75,224,199,79,124,21,35,178};
static const unsigned char precomputed_mGnP_ed25519_P_105[] = {7,15,29,158,249,45,243,86,149,240,67,227,182,187,29,165,226,107,4,189,241,76,230,17,194,202,244,253,216,151,180,121};
static const unsigned char precomputed_mGnP_ed25519_Q_106[] = {5,204,97,195,120,117,198,174,183,127,170,92,124,133,192,69,27,67,54,19,70,138,109,209,94,200,113,215,86,185,245,228,0};
static const unsigned char precomputed_mGnP_ed25519_m_106[] = {205,55,168,59,148,135,133,56,182,243,202,2,24,39,123,29,222,246,255,155,251,54,182,239,119,2,180,173,55,125,195,19};
static const unsigned char precomputed_mGnP_ed25519_n_106[] = {77,57,194,150,238,157,124,237,1,254,44,245,240,8,208,95,191,202,22,155,240,53,183,46,243,194,74,102,35,94,156,26,77,135,20,216,132,81,57,37,224,145,20,53,103,183,51,56,219,169,13,160,242,188,27,208,243,66,111,244,46,63,194,138};
static const unsigned char precomputed_mGnP_ed25519_P_106[] = {199,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,122};
static const unsigned char precomputed_mGnP_ed25519_Q_107[] = {255,24,95,153,139,29,46,0,231,218,135,243,163,160,101,196,133,223,78,170,96,117,27,56,180,88,152,216,149,114,207,202,0};
static const unsigned char precomputed_mGnP_ed25519_m_107[] = {215,117,246,213,246,237,2,157,18,144,98,97,197,169,76,70,240,219,206,187,13,17,162,159,236,193,63,39,37,206,100,61};
static const unsigned char precomputed_mGnP_ed25519_n_107[] = {234,155,226,137,69,255,33,70,196,5,120,205,168,123,71,192,21,153,96,54,8,71,93,159,31,251,163,140,119,23,32,116,99,123,163,25,42,210,206,163,164,244,220,228,233,192,209,55,44,116,103,121,167,166,35,85,82,242,197,79,214,8,149,131};
static const unsigned char precomputed_mGnP_ed25519_P_107[] = {109,157,174,111,128,130,186,160,252,179,9,224,135,223,178,38,180,195,3,142,101,113,183,205,46,227,81,238,31,115,191,126};
static const unsigned char precomputed_mGnP_ed25519_Q_108[] = {54,27,212,85,95,160,199,90,116,104,191,57,45,222,41,22,219,99,245,78,12,56,14,255,120,13,0,164,3,106,209,162,0};
static const unsigned char precomputed_mGnP_ed25519_m_108[] = {218,1,181,54,252,151,52,152,98,63,246,185,37,238,12,143,156,96,244,238,21,34,170,19,207,32,98,52,33,222,38,213};
static const unsigned char precomputed_mGnP_ed25519_n_108[] = {21,125,219,61,204,220,120,132,102,255,45,210,98,218,200,234,68,166,172,116,127,222,173,41,33,165,248,254,239,193,117,164,145,194,24,200,207,90,38,14,143,254,93,8,60,7,122,182,224,203,254,183,179,21,5,242,253,131,189,37,40,77,180,194};
static const unsigned char precomputed_mGnP_ed25519_P_108[] = {224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_109[] = {189,230,15,155,214,237,120,15,10,176,36,34,170,194,156,204,227,221,126,68,79,6,196,101,43,32,153,35,120,182,190,189,0};
static const unsigned char precomputed_mGnP_ed25519_m_109[] = {70,223,44,90,4,250,128,197,248,164,182,24,249,255,220,227,0,244,98,187,128,88,7,191,115,110,174,40,40,29,9,111};
static const unsigned char precomputed_mGnP_ed25519_n_109[] = {93,174,39,41,49,250,206,29,88,137,212,1,37,79,193,89,47,189,207,132,63,172,81,199,203,192,60,47,90,213,51,136,207,114,110,249,208,160,70,37,51,200,204,218,40,245,32,69,111,229,3,92,234,37,127,112,229,167,195,196,77,222,120,27};
static const unsigned char precomputed_mGnP_ed25519_P_109[] = {225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_110[] = {20,68,46,35,213,144,84,147,26,72,49,234,68,118,158,193,190,126,115,230,76,226,28,234,240,18,177,207,39,74,242,177,0};
static const unsigned char precomputed_mGnP_ed25519_m_110[] = {62,53,166,132,145,59,229,236,211,144,10,30,189,189,52,128,0,227,17,175,9,172,123,126,249,165,101,153,77,93,39,71};
static const unsigned char precomputed_mGnP_ed25519_n_110[] = {97,20,118,126,153,175,217,148,123,242,202,27,73,230,131,223,215,148,122,144,9,196,65,98,45,131,181,22,187,200,158,249,123,32,157,44,197,138,235,192,62,137,10,122,137,40,252,238,57,141,210,166,44,141,27,8,25,200,142,200,112,118,183,164};
static const unsigned char precomputed_mGnP_ed25519_P_110[] = {226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_111[] = {231,152,158,248,99,125,191,99,51,241,205,255,198,147,204,11,12,6,50,123,146,75,15,144,32,199,62,23,143,193,187,67,0};
static const unsigned char precomputed_mGnP_ed25519_m_111[] = {38,212,103,81,24,150,223,127,173,168,132,82,161,40,166,201,84,19,243,68,128,25,98,97,180,77,89,203,132,236,127,31};
static const unsigned char precomputed_mGnP_ed25519_n_111[] = {242,164,31,199,237,100,217,1,180,22,30,65,15,163,172,107,142,202,228,15,59,216,147,90,216,38,199,228,65,137,104,66,145,2,169,83,166,228,88,146,118,203,38,112,36,56,224,109,164,160,159,54,235,86,53,192,29,85,11,27,192,136,152,172};
static const unsigned char precomputed_mGnP_ed25519_P_111[] = {227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_112[] = {112,182,218,230,100,12,144,223,152,5,48,247,181,187,16,2,204,27,69,12,242,149,142,220,93,19,184,9,224,114,165,200,0};
static const unsigned char precomputed_mGnP_ed25519_m_112[] = {47,7,194,66,215,22,125,132,254,8,136,209,110,119,183,15,50,221,82,247,231,156,69,97,239,254,138,143,148,180,26,255};
static const unsigned char precomputed_mGnP_ed25519_n_112[] = {147,70,227,102,142,17,16,254,6,103,253,142,77,105,251,249,252,87,148,142,236,180,205,102,77,173,224,198,125,238,27,47,34,99,15,62,237,11,36,123,179,186,185,188,41,197,16,235,129,53,16,221,152,8,252,42,85,65,183,43,215,39,245,129};
static const unsigned char precomputed_mGnP_ed25519_P_112[] = {228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_113[] = {32,108,149,172,24,17,19,69,247,138,153,110,171,166,206,10,22,39,218,22,221,31,7,102,185,31,78,170,181,109,151,133,0};
static const unsigned char precomputed_mGnP_ed25519_m_113[] = {145,15,103,67,163,205,50,247,78,68,63,114,67,47,13,26,78,135,133,39,213,85,42,125,173,45,134,206,239,19,83,103};
static const unsigned char precomputed_mGnP_ed25519_n_113[] = {171,152,80,207,160,59,203,100,143,138,131,218,171,184,52,92,235,180,238,198,30,215,176,135,143,176,180,157,187,154,179,157,113,226,109,79,58,96,237,67,218,123,180,139,7,13,164,175,81,20,38,57,77,48,250,131,167,123,11,161,178,173,182,182};
static const unsigned char precomputed_mGnP_ed25519_P_113[] = {229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_114[] = {176,103,204,52,144,92,167,238,89,64,214,119,85,215,38,88,233,146,72,8,52,198,251,149,92,88,200,88,43,233,191,141,0};
static const unsigned char precomputed_mGnP_ed25519_m_114[] = {138,111,241,12,122,61,26,127,140,24,94,206,131,172,201,79,10,248,203,208,75,181,29,119,23,244,8,132,247,127,227,128};
static const unsigned char precomputed_mGnP_ed25519_n_114[] = {219,65,110,116,62,16,178,220,181,77,80,11,0,139,206,28,193,144,188,153,254,195,132,180,232,2,54,78,228,115,99,91,115,1,109,0,184,222,68,251,13,152,98,53,210,74,171,186,124,64,129,142,50,237,19,242,132,35,232,71,114,132,233,63};
static const unsigned char precomputed_mGnP_ed25519_P_114[] = {230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_115[] = {158,9,173,207,212,76,100,39,39,219,190,56,199,130,209,91,34,3,73,180,50,202,129,131,138,97,82,224,209,20,83,134,0};
static const unsigned char precomputed_mGnP_ed25519_m_115[] = {221,205,93,150,194,205,101,59,79,122,150,89,32,0,6,186,149,69,231,223,72,89,241,207,58,37,233,14,189,244,235,131};
static const unsigned char precomputed_mGnP_ed25519_n_115[] = {75,41,73,9,199,94,27,224,112,69,95,166,54,86,63,37,188,7,185,72,104,235,111,79,198,208,207,184,48,216,26,174,147,87,226,227,88,254,247,0,222,196,0,3,192,109,158,72,51,219,126,63,133,208,119,202,175,105,62,162,65,37,42,130};
static const unsigned char precomputed_mGnP_ed25519_P_115[] = {231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_116[] = {140,118,145,18,189,236,122,204,159,143,57,252,100,127,144,220,198,52,207,154,7,68,82,239,173,38,39,248,215,63,245,65,0};
static const unsigned char precomputed_mGnP_ed25519_m_116[] = {130,233,7,163,52,220,24,227,159,123,50,0,133,180,114,210,41,176,151,60,92,29,204,46,187,101,234,31,71,47,47,129};
static const unsigned char precomputed_mGnP_ed25519_n_116[] = {50,126,23,109,68,133,155,156,217,22,172,193,197,218,203,124,110,224,27,158,253,165,85,246,215,147,103,85,206,79,154,253,116,179,4,146,59,30,241,81,13,6,31,108,84,52,151,235,99,84,250,201,56,152,5,36,103,118,89,114,180,22,134,78};
static const unsigned char precomputed_mGnP_ed25519_P_116[] = {232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_117[] = {134,80,198,26,66,229,227,41,64,199,143,187,214,39,86,56,189,72,68,79,15,227,135,136,209,208,9,83,113,91,41,188,0};
static const unsigned char precomputed_mGnP_ed25519_m_117[] = {110,52,33,49,248,96,63,242,162,221,98,187,212,225,224,140,14,96,122,134,110,44,32,218,2,162,251,77,216,177,216,120};
static const unsigned char precomputed_mGnP_ed25519_n_117[] = {142,126,137,185,25,177,75,128,148,113,60,167,96,8,18,210,7,108,237,156,73,11,211,136,38,138,216,62,251,46,223,117,21,13,150,60,125,198,29,45,27,191,67,75,148,105,101,144,203,102,50,158,167,211,52,186,24,113,11,46,142,97,115,192};
static const unsigned char precomputed_mGnP_ed25519_P_117[] = {233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_118[] = {78,134,217,103,144,107,124,56,91,147,41,235,238,163,23,169,129,90,233,229,226,160,226,79,227,84,172,155,126,28,81,89,0};
static const unsigned char precomputed_mGnP_ed25519_m_118[] = {243,181,103,66,169,7,112,247,209,251,8,96,169,84,233,184,215,59,27,80,183,237,207,100,2,38,112,71,40,118,115,101};
static const unsigned char precomputed_mGnP_ed25519_n_118[] = {34,63,4,211,143,33,185,22,179,151,163,78,97,139,95,91,38,71,136,133,152,116,65,153,136,182,217,62,211,45,45,252,25,229,171,245,105,176,166,96,246,131,195,153,211,188,184,67,34,30,34,14,171,89,146,23,248,146,231,119,22,84,236,84};
static const unsigned char precomputed_mGnP_ed25519_P_118[] = {234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_119[] = {191,187,120,44,116,84,59,130,25,178,28,141,111,36,175,99,101,231,32,62,158,108,202,68,140,28,225,37,148,36,106,246,0};
static const unsigned char precomputed_mGnP_ed25519_m_119[] = {121,34,242,188,194,159,16,197,45,147,252,179,183,6,144,95,100,159,12,220,225,156,58,249,0,7,253,54,76,222,222,41};
static const unsigned char precomputed_mGnP_ed25519_n_119[] = {156,15,101,160,27,154,0,29,232,217,28,97,41,113,136,34,64,85,55,204,33,92,254,236,180,158,223,98,20,161,74,68,12,1,191,176,209,16,117,165,246,52,187,70,182,232,216,200,132,246,36,228,158,157,170,27,84,171,154,99,53,111,131,53};
static const unsigned char precomputed_mGnP_ed25519_P_119[] = {235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_120[] = {104,165,206,237,111,169,182,158,80,219,96,26,198,139,230,201,74,238,211,251,12,2,12,86,157,243,215,146,188,27,20,212,0};
static const unsigned char precomputed_mGnP_ed25519_m_120[] = {201,252,102,219,33,221,121,59,44,112,155,31,220,167,88,179,32,40,180,64,241,132,96,111,28,171,50,163,236,94,108,140};
static const unsigned char precomputed_mGnP_ed25519_n_120[] = {249,71,115,69,194,249,255,217,170,125,182,152,125,249,110,88,229,164,199,87,120,65,103,92,13,239,101,199,159,96,89,199,161,43,154,79,109,157,147,233,59,85,200,235,61,191,35,83,206,83,55,100,165,112,186,73,73,75,30,155,252,228,192,1};
static const unsigned char precomputed_mGnP_ed25519_P_120[] = {236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_121[] = {62,99,61,185,77,186,42,211,64,182,27,209,75,169,210,207,112,138,220,172,38,202,145,28,42,49,201,238,99,138,176,66,0};
static const unsigned char precomputed_mGnP_ed25519_m_121[] = {229,180,104,21,93,201,20,238,29,107,169,121,148,43,155,189,232,171,189,88,95,254,43,211,196,55,176,119,252,215,100,69};
static const unsigned char precomputed_mGnP_ed25519_n_121[] = {132,20,96,140,203,126,73,214,76,213,255,168,133,59,96,217,133,58,186,38,145,128,95,206,208,245,244,69,141,110,230,24,62,152,34,241,218,160,178,75,23,39,241,187,57,125,139,186,17,82,209,56,117,69,226,214,165,129,158,84,83,177,140,154};
static const unsigned char precomputed_mGnP_ed25519_P_121[] = {237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_122[] = {255,128,95,36,155,42,108,241,68,206,24,93,254,14,251,124,65,209,252,42,155,254,194,221,187,227,180,196,102,15,192,200,0};
static const unsigned char precomputed_mGnP_ed25519_m_122[] = {79,218,103,24,20,143,160,145,65,56,59,164,143,216,45,120,41,81,242,255,69,193,159,48,33,32,238,107,233,173,176,7};
static const unsigned char precomputed_mGnP_ed25519_n_122[] = {126,120,194,48,184,7,192,50,190,200,30,215,218,34,0,122,189,219,42,155,53,200,224,178,38,180,52,244,81,124,23,140,38,212,37,214,71,234,75,111,239,174,50,200,248,170,208,80,81,77,61,13,198,213,2,156,78,182,123,51,179,195,102,252};
static const unsigned char precomputed_mGnP_ed25519_P_122[] = {238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_123[] = {71,124,174,113,113,200,75,165,71,238,138,181,147,104,175,96,79,165,53,47,91,89,224,94,91,30,4,255,207,155,107,131,0};
static const unsigned char precomputed_mGnP_ed25519_m_123[] = {38,72,166,226,178,225,201,209,210,249,249,232,157,67,191,138,36,168,1,8,90,6,181,141,229,132,181,82,220,84,18,255};
static const unsigned char precomputed_mGnP_ed25519_n_123[] = {37,70,218,208,202,82,62,107,232,177,221,100,3,187,8,203,52,104,20,140,243,136,123,2,61,224,209,127,0,28,208,95,193,78,187,35,178,68,2,156,252,191,244,161,60,38,254,144,137,172,125,237,218,113,86,192,159,50,108,186,238,238,69,37};
static const unsigned char precomputed_mGnP_ed25519_P_123[] = {239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_124[] = {192,199,166,23,122,9,41,147,126,255,96,11,123,70,188,210,117,13,21,115,75,145,7,149,34,24,87,236,81,212,105,123,0};
static const unsigned char precomputed_mGnP_ed25519_m_124[] = {28,59,168,15,251,0,231,52,217,208,36,127,117,28,86,155,82,181,137,175,22,232,25,56,78,56,242,254,207,108,167,15};
static const unsigned char precomputed_mGnP_ed25519_n_124[] = {62,144,245,240,117,132,213,140,77,73,23,236,201,57,99,168,240,204,80,148,141,41,76,154,192,216,173,247,41,218,181,72,41,200,40,243,180,255,30,228,93,51,177,174,225,244,121,84,217,112,98,40,50,171,80,244,81,87,239,121,22,145,27,25};
static const unsigned char precomputed_mGnP_ed25519_P_124[] = {240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_125[] = {95,57,218,46,33,122,19,132,187,143,62,23,141,219,208,93,173,20,245,7,145,198,127,96,189,169,123,183,109,174,142,24,0};
static const unsigned char precomputed_mGnP_ed25519_m_125[] = {248,37,158,253,175,78,16,243,160,22,175,192,5,12,129,56,64,204,7,7,113,188,177,175,250,252,13,243,226,10,231,139};
static const unsigned char precomputed_mGnP_ed25519_n_125[] = {219,15,136,27,168,13,9,69,74,111,181,89,54,13,194,227,207,84,119,193,156,232,65,5,141,188,93,217,33,167,111,178,94,67,128,105,183,27,31,177,159,164,108,48,2,206,135,126,141,219,71,22,169,115,83,66,149,51,229,20,174,14,142,16};
static const unsigned char precomputed_mGnP_ed25519_P_125[] = {241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_126[] = {24,220,23,138,41,174,187,235,127,134,105,202,13,154,221,103,5,175,154,27,87,88,230,85,253,27,9,118,123,97,123,139,0};
static const unsigned char precomputed_mGnP_ed25519_m_126[] = {197,58,34,193,150,71,33,215,232,25,162,67,103,152,59,70,160,158,46,89,5,223,149,169,91,155,137,172,124,244,105,198};
static const unsigned char precomputed_mGnP_ed25519_n_126[] = {92,87,209,72,136,101,148,139,72,243,226,126,204,107,10,214,69,0,212,237,8,218,240,10,253,251,170,43,164,132,95,206,233,106,113,169,135,32,165,203,185,135,75,3,200,198,246,57,193,251,161,134,116,0,200,173,162,197,64,80,226,64,123,116};
static const unsigned char precomputed_mGnP_ed25519_P_126[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_127[] = {6,127,154,241,105,197,73,207,78,140,216,10,209,0,1,111,198,43,91,22,202,85,111,148,153,235,217,179,224,18,139,175,0};
static const unsigned char precomputed_mGnP_ed25519_m_127[] = {3,7,72,202,244,59,15,254,212,94,21,34,136,185,243,88,11,168,83,36,244,45,245,3,101,36,133,174,54,114,138,56};
static const unsigned char precomputed_mGnP_ed25519_n_127[] = {154,226,188,29,207,58,204,67,145,231,224,17,151,250,114,162,123,26,164,26,65,123,220,195,44,141,164,96,195,118,235,198,2,196,237,0,26,10,86,68,69,126,113,56,70,80,189,220,168,160,90,212,34,208,171,3,84,176,189,89,151,69,125,243};
static const unsigned char precomputed_mGnP_ed25519_P_127[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_128[] = {114,185,212,101,17,176,14,73,225,55,117,235,124,78,245,62,227,93,182,113,87,123,236,48,21,16,86,42,56,29,43,230,0};
static const unsigned char precomputed_mGnP_ed25519_m_128[] = {72,123,50,27,246,69,107,134,96,47,239,50,125,29,99,167,45,240,138,156,226,51,95,101,31,48,217,44,161,52,211,164};
static const unsigned char precomputed_mGnP_ed25519_n_128[] = {11,14,17,45,30,238,85,17,20,107,199,8,34,71,135,138,191,23,213,148,8,95,218,250,40,112,59,222,222,73,247,2,120,124,83,103,25,77,98,165,139,15,217,217,35,234,11,248,95,23,222,39,179,33,208,102,43,77,194,146,161,160,21,20};
static const unsigned char precomputed_mGnP_ed25519_P_128[] = {244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_129[] = {68,53,138,202,55,37,154,26,169,237,166,137,47,227,201,78,52,83,158,203,239,50,51,26,229,77,29,187,41,153,116,172,0};
static const unsigned char precomputed_mGnP_ed25519_m_129[] = {93,254,143,54,95,125,60,214,254,8,21,3,63,72,214,18,81,55,127,38,185,226,77,7,168,97,53,40,91,122,18,12};
static const unsigned char precomputed_mGnP_ed25519_n_129[] = {200,215,62,177,19,93,74,25,59,141,5,38,241,150,196,120,6,77,139,250,160,117,2,206,193,252,73,96,185,58,207,49,139,149,148,59,230,62,172,184,158,178,172,89,111,211,170,38,150,127,124,253,71,41,169,5,138,244,59,247,153,144,50,40};
static const unsigned char precomputed_mGnP_ed25519_P_129[] = {245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_130[] = {199,163,182,225,35,57,239,34,221,184,129,24,114,207,139,77,157,40,230,186,60,247,92,230,171,160,97,212,32,105,204,6,0};
static const unsigned char precomputed_mGnP_ed25519_m_130[] = {213,154,141,90,176,37,247,205,253,210,188,33,45,151,186,153,45,100,97,160,23,48,56,46,147,55,73,60,97,64,248,19};
static const unsigned char precomputed_mGnP_ed25519_n_130[] = {153,140,159,212,25,196,204,88,54,129,130,91,134,137,42,225,128,76,19,119,225,29,255,139,62,47,34,74,144,252,100,114,197,138,83,172,189,181,135,99,174,155,187,74,2,245,80,242,82,170,135,76,151,227,244,198,125,234,115,199,146,228,179,43};
static const unsigned char precomputed_mGnP_ed25519_P_130[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_131[] = {28,48,13,170,57,220,199,222,31,116,43,138,243,164,133,78,30,134,195,235,16,115,49,235,223,176,216,229,227,159,80,162,0};
static const unsigned char precomputed_mGnP_ed25519_m_131[] = {140,168,60,159,14,114,223,4,225,222,119,83,228,211,81,118,216,25,221,194,34,170,69,18,79,65,227,3,39,182,147,186};
static const unsigned char precomputed_mGnP_ed25519_n_131[] = {243,206,191,204,135,200,231,168,195,105,221,106,16,144,125,2,40,255,145,167,203,231,87,98,234,90,120,209,218,233,247,94,132,130,71,83,59,229,88,30,137,188,191,46,227,176,171,4,242,120,56,174,250,102,90,154,194,143,176,183,59,66,234,173};
static const unsigned char precomputed_mGnP_ed25519_P_131[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_132[] = {77,231,65,175,171,54,11,105,191,213,248,116,225,246,165,83,134,23,165,231,13,129,111,80,127,44,64,244,235,34,216,56,0};
static const unsigned char precomputed_mGnP_ed25519_m_132[] = {68,226,24,51,172,200,67,147,24,9,208,89,94,123,224,22,210,51,7,176,192,54,162,195,206,114,132,106,51,62,174,4};
static const unsigned char precomputed_mGnP_ed25519_n_132[] = {36,169,122,77,218,37,200,41,226,195,191,84,67,165,228,227,170,182,200,178,203,105,26,66,36,253,31,13,75,236,197,209,88,4,213,186,125,202,128,63,69,59,237,226,35,19,82,182,17,100,9,129,226,40,198,134,161,45,211,34,94,152,211,51};
static const unsigned char precomputed_mGnP_ed25519_P_132[] = {248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_133[] = {116,219,203,77,47,170,20,249,30,225,2,105,203,150,213,232,245,243,199,78,218,56,198,32,163,96,187,178,187,111,233,59,0};
static const unsigned char precomputed_mGnP_ed25519_m_133[] = {51,4,150,24,156,115,10,217,237,112,56,74,8,43,181,247,41,68,144,184,103,137,86,16,72,24,122,103,59,199,114,229};
static const unsigned char precomputed_mGnP_ed25519_n_133[] = {196,115,91,214,46,252,212,148,31,147,239,114,151,170,2,159,7,185,136,190,197,144,151,12,73,162,160,201,61,54,1,133,71,190,4,31,188,238,252,59,22,42,38,137,217,28,62,128,18,128,192,197,254,185,8,172,192,144,155,192,169,1,214,81};
static const unsigned char precomputed_mGnP_ed25519_P_133[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_134[] = {12,149,25,189,53,59,73,57,118,143,16,122,232,76,20,173,233,105,35,44,198,170,87,24,44,121,34,191,243,120,39,192,0};
static const unsigned char precomputed_mGnP_ed25519_m_134[] = {17,243,81,216,195,86,121,33,21,227,34,79,11,222,119,175,210,215,229,234,133,79,156,93,225,219,232,75,231,166,112,243};
static const unsigned char precomputed_mGnP_ed25519_n_134[] = {185,12,54,180,225,175,58,55,101,237,77,148,67,47,135,55,31,83,209,139,166,204,23,241,53,172,177,83,33,52,67,142,229,13,126,195,254,81,235,153,225,173,50,164,59,65,189,207,158,88,94,52,60,141,6,157,230,31,108,203,254,118,70,176};
static const unsigned char precomputed_mGnP_ed25519_P_134[] = {250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_135[] = {183,133,90,205,224,187,120,46,193,197,200,18,55,182,2,19,163,111,83,210,101,6,34,219,91,242,86,82,69,240,95,183,0};
static const unsigned char precomputed_mGnP_ed25519_m_135[] = {146,241,160,254,50,216,130,196,35,63,60,4,197,133,153,15,77,15,252,120,52,190,145,170,227,189,18,37,46,156,173,128};
static const unsigned char precomputed_mGnP_ed25519_n_135[] = {246,252,167,11,132,100,239,88,196,58,112,53,254,54,67,8,139,37,207,110,168,206,239,203,98,36,40,36,118,205,124,198,60,99,131,250,134,111,69,56,152,0,101,83,95,111,123,210,234,208,164,232,218,93,155,114,89,197,56,11,147,211,188,208};
static const unsigned char precomputed_mGnP_ed25519_P_135[] = {251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_136[] = {3,193,235,82,80,166,219,203,130,123,255,154,163,102,180,121,172,4,45,161,154,164,146,203,130,92,197,6,229,183,104,232,0};
static const unsigned char precomputed_mGnP_ed25519_m_136[] = {161,238,243,109,189,85,176,198,244,242,19,141,186,32,20,135,254,117,53,198,153,13,84,56,54,88,11,78,73,250,181,246};
static const unsigned char precomputed_mGnP_ed25519_n_136[] = {251,213,16,229,248,198,61,233,97,47,192,26,243,146,204,117,74,82,111,195,63,56,111,146,0,238,185,116,46,46,14,151,40,52,88,179,70,240,165,41,135,182,209,11,5,29,61,180,3,110,163,85,133,187,51,81,239,221,88,104,88,59,201,97};
static const unsigned char precomputed_mGnP_ed25519_P_136[] = {252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_137[] = {17,131,117,98,52,166,242,131,110,136,225,67,241,27,174,176,210,247,252,96,94,40,234,112,134,11,22,19,82,54,123,235,0};
static const unsigned char precomputed_mGnP_ed25519_m_137[] = {52,171,180,223,196,42,90,89,7,121,70,171,201,106,54,179,77,138,200,154,181,202,246,145,185,98,229,43,190,25,230,150};
static const unsigned char precomputed_mGnP_ed25519_n_137[] = {11,124,191,250,55,47,167,194,24,93,13,15,87,98,181,59,123,225,1,12,31,154,167,244,254,134,119,175,79,146,82,214,35,74,251,94,78,155,85,181,144,232,104,58,219,12,86,101,229,212,163,3,217,251,69,47,15,116,73,18,100,201,57,5};
static const unsigned char precomputed_mGnP_ed25519_P_137[] = {253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_138[] = {89,48,120,174,189,168,67,136,147,144,24,102,140,217,245,111,175,180,8,120,97,18,106,164,203,202,109,5,149,151,154,185,0};
static const unsigned char precomputed_mGnP_ed25519_m_138[] = {78,117,172,73,218,81,228,218,222,33,38,62,66,119,154,4,233,228,19,153,196,193,23,65,192,105,188,231,123,2,106,205};
static const unsigned char precomputed_mGnP_ed25519_n_138[] = {183,16,219,162,152,244,143,43,223,189,102,1,213,94,213,253,55,28,46,129,32,47,118,224,84,71,251,52,110,130,214,224,25,206,45,253,66,185,19,27,91,146,218,211,0,113,230,198,170,16,210,69,220,65,144,230,168,200,3,81,124,153,135,9};
static const unsigned char precomputed_mGnP_ed25519_P_138[] = {254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_139[] = {95,26,214,180,169,50,120,33,235,33,135,9,24,42,105,156,222,214,42,58,71,126,68,38,96,160,234,53,96,81,218,235,0};
static const unsigned char precomputed_mGnP_ed25519_m_139[] = {231,13,250,132,75,39,138,183,123,251,102,111,37,112,23,151,89,10,178,195,103,11,118,84,6,239,107,246,197,211,104,175};
static const unsigned char precomputed_mGnP_ed25519_n_139[] = {36,83,95,248,54,143,3,115,74,74,171,42,20,9,200,127,193,223,224,181,150,192,94,87,251,10,125,222,79,185,34,103,113,20,117,217,211,132,0,51,111,147,115,58,252,248,238,187,249,161,36,220,139,70,33,231,247,227,220,153,77,231,147,132};
static const unsigned char precomputed_mGnP_ed25519_P_139[] = {255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,127};
static const unsigned char precomputed_mGnP_ed25519_Q_140[] = {8,241,97,132,151,205,153,98,62,32,240,186,229,71,248,54,98,52,11,46,138,223,98,9,203,105,170,64,169,144,14,248,0};
static const unsigned char precomputed_mGnP_ed25519_m_140[] = {155,102,23,199,192,166,244,154,235,65,17,146,86,51,183,205,199,47,206,60,87,184,13,94,29,53,190,119,14,161,172,163};
static const unsigned char precomputed_mGnP_ed25519_n_140[] = {76,202,187,29,91,51,169,133,58,65,199,57,145,14,151,26,195,181,199,84,51,129,160,90,34,233,76,220,234,69,215,150,43,128,25,152,141,24,192,164,11,179,181,95,171,76,123,4,237,242,129,178,86,28,150,19,39,123,20,196,110,200,170,91};
static const unsigned char precomputed_mGnP_ed25519_P_140[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_141[] = {71,254,121,172,26,226,43,20,59,222,179,97,129,67,69,100,170,14,39,29,53,70,38,149,106,111,216,22,214,129,19,50,0};
static const unsigned char precomputed_mGnP_ed25519_m_141[] = {89,96,23,38,74,48,18,170,81,175,188,105,128,163,77,192,248,18,213,205,19,44,148,62,66,142,150,239,44,229,27,91};
static const unsigned char precomputed_mGnP_ed25519_n_141[] = {88,179,237,23,194,217,190,229,11,50,236,30,39,37,36,251,101,246,242,165,174,255,68,9,27,222,15,129,165,2,214,211,14,159,31,255,6,218,238,38,0,198,92,133,63,216,32,19,123,104,130,250,220,248,210,242,234,222,9,113,50,170,64,137};
static const unsigned char precomputed_mGnP_ed25519_P_141[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_142[] = {58,22,218,58,46,250,154,56,84,211,162,130,30,66,231,90,37,37,113,141,77,65,231,184,112,84,152,40,240,199,220,109,0};
static const unsigned char precomputed_mGnP_ed25519_m_142[] = {195,102,104,54,168,254,140,128,242,147,202,110,177,159,31,204,164,25,182,159,143,52,206,20,4,230,125,198,20,111,88,204};
static const unsigned char precomputed_mGnP_ed25519_n_142[] = {100,189,217,77,137,55,180,156,207,118,196,189,180,22,7,173,65,143,22,133,140,120,182,163,60,93,46,28,26,222,51,216,233,67,183,233,169,150,129,178,159,188,60,193,232,53,200,207,133,53,105,158,249,149,93,220,94,85,165,167,222,98,32,239};
static const unsigned char precomputed_mGnP_ed25519_P_142[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_143[] = {229,29,91,95,230,172,180,94,111,43,153,238,158,66,21,110,153,171,251,243,51,236,238,162,136,169,65,99,39,105,26,244,0};
static const unsigned char precomputed_mGnP_ed25519_m_143[] = {254,89,36,214,241,246,56,119,140,28,69,130,105,224,22,171,24,18,62,30,59,0,85,204,165,236,37,0,110,71,156,47};
static const unsigned char precomputed_mGnP_ed25519_n_143[] = {117,185,93,209,248,186,91,228,93,128,96,166,196,170,182,97,73,65,25,166,11,30,33,153,228,54,194,52,209,219,46,130,144,245,189,159,86,72,47,43,160,219,151,51,91,107,101,98,10,108,10,136,100,103,57,241,10,139,55,111,171,139,4,54};
static const unsigned char precomputed_mGnP_ed25519_P_143[] = {3,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_144[] = {42,154,181,199,6,43,244,102,32,254,229,151,112,171,65,44,224,58,97,19,227,236,166,230,56,183,27,177,78,54,12,45,0};
static const unsigned char precomputed_mGnP_ed25519_m_144[] = {22,249,40,206,42,144,158,71,234,159,248,207,225,0,32,235,223,228,231,8,97,71,51,59,157,216,49,207,30,47,24,122};
static const unsigned char precomputed_mGnP_ed25519_n_144[] = {54,220,72,155,95,58,203,179,110,46,188,123,239,115,28,112,45,95,176,186,253,170,95,63,38,6,118,246,228,19,46,186,41,178,242,169,60,73,75,111,88,127,215,64,208,115,255,239,125,172,32,36,121,122,8,86,133,236,128,61,56,97,174,173};
static const unsigned char precomputed_mGnP_ed25519_P_144[] = {4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_145[] = {53,183,37,164,130,100,28,213,40,148,71,208,23,49,203,73,144,205,63,92,192,89,221,71,160,71,243,113,228,166,23,7,0};
static const unsigned char precomputed_mGnP_ed25519_m_145[] = {124,87,184,135,160,92,168,83,146,230,153,2,159,192,228,81,201,209,183,137,124,160,214,58,7,136,75,50,39,115,70,132};
static const unsigned char precomputed_mGnP_ed25519_n_145[] = {227,247,86,247,12,45,120,98,208,224,17,233,8,243,31,90,181,172,32,96,200,3,22,222,68,220,187,211,173,24,215,67,8,152,226,191,53,85,191,150,116,49,221,62,161,252,212,135,194,92,214,232,16,120,29,20,97,44,12,98,186,194,132,75};
static const unsigned char precomputed_mGnP_ed25519_P_145[] = {5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_146[] = {196,187,46,107,131,239,107,108,70,83,225,30,69,139,115,178,7,79,61,53,254,226,168,224,141,101,195,124,82,57,180,144,0};
static const unsigned char precomputed_mGnP_ed25519_m_146[] = {111,199,12,204,196,123,37,14,141,105,183,246,232,99,231,247,200,141,135,196,145,113,185,153,230,139,11,175,212,133,134,132};
static const unsigned char precomputed_mGnP_ed25519_n_146[] = {153,43,111,197,124,94,28,132,69,196,96,222,13,238,114,63,94,180,20,222,146,195,163,124,166,127,118,157,186,240,168,57,31,6,129,60,18,115,72,138,105,73,229,47,142,200,224,185,10,43,142,137,130,205,86,169,2,89,192,48,199,75,136,243};
static const unsigned char precomputed_mGnP_ed25519_P_146[] = {6,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_147[] = {164,45,65,239,131,91,209,132,251,220,19,236,251,255,42,141,199,39,55,21,196,206,212,1,130,81,215,163,29,31,191,189,0};
static const unsigned char precomputed_mGnP_ed25519_m_147[] = {156,117,133,41,95,71,126,238,232,146,193,214,128,163,162,225,240,211,142,64,146,17,105,240,211,185,37,28,155,196,137,118};
static const unsigned char precomputed_mGnP_ed25519_n_147[] = {160,249,35,44,202,191,26,249,137,131,149,41,154,66,186,69,184,114,147,164,80,100,182,34,28,92,143,150,130,9,197,181,237,234,60,246,16,151,163,109,95,111,166,155,39,80,54,174,144,56,250,63,91,48,45,251,66,113,54,127,43,108,62,20};
static const unsigned char precomputed_mGnP_ed25519_P_147[] = {7,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_148[] = {155,185,177,145,56,110,246,62,7,227,190,186,160,36,126,241,82,87,168,123,203,131,246,166,246,105,239,67,219,213,42,121,0};
static const unsigned char precomputed_mGnP_ed25519_m_148[] = {107,2,211,135,126,94,215,112,219,124,11,113,77,147,87,239,43,167,84,168,79,216,224,175,96,229,178,109,37,172,41,137};
static const unsigned char precomputed_mGnP_ed25519_n_148[] = {251,216,249,198,18,41,64,152,167,16,62,209,201,188,206,161,225,230,21,45,192,221,78,7,105,63,162,51,188,193,31,116,99,131,142,64,232,73,107,159,164,128,122,28,221,171,202,132,40,186,17,151,155,28,22,122,75,210,123,100,22,177,164,48};
static const unsigned char precomputed_mGnP_ed25519_P_148[] = {8,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_149[] = {222,79,171,162,9,243,141,33,197,62,62,217,119,110,176,50,100,89,159,237,228,99,30,46,174,37,238,201,47,97,144,77,0};
static const unsigned char precomputed_mGnP_ed25519_m_149[] = {223,200,236,126,192,41,104,138,209,216,187,230,190,26,163,137,253,40,199,41,185,77,158,35,208,221,62,74,24,99,43,150};
static const unsigned char precomputed_mGnP_ed25519_n_149[] = {248,141,181,24,87,11,64,14,25,177,140,68,183,105,43,137,19,176,152,211,224,104,221,177,66,21,241,69,206,105,57,67,127,114,255,36,97,176,160,157,215,33,59,72,24,134,132,53,205,129,87,45,53,48,74,90,54,5,55,65,173,171,32,119};
static const unsigned char precomputed_mGnP_ed25519_P_149[] = {9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_150[] = {61,229,205,97,254,155,235,98,129,166,180,47,176,52,24,219,139,33,118,198,152,129,196,250,218,71,4,169,38,204,169,252,0};
static const unsigned char precomputed_mGnP_ed25519_m_150[] = {188,29,3,170,231,52,8,38,178,138,154,156,21,147,38,159,168,182,66,70,53,110,28,193,22,87,26,82,129,216,192,211};
static const unsigned char precomputed_mGnP_ed25519_n_150[] = {221,154,88,128,7,144,112,61,149,0,181,220,82,202,13,95,246,246,73,183,36,19,56,232,1,218,237,33,108,155,112,176,104,133,243,216,107,172,57,94,207,88,46,236,252,61,153,85,76,194,212,16,169,152,50,247,158,70,75,106,168,187,33,77};
static const unsigned char precomputed_mGnP_ed25519_P_150[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_151[] = {84,60,226,93,55,50,198,219,139,144,57,250,189,155,243,228,138,127,217,137,51,34,175,116,163,114,71,27,4,113,8,150,0};
static const unsigned char precomputed_mGnP_ed25519_m_151[] = {160,208,75,19,73,39,30,188,136,179,50,130,85,78,98,246,222,0,94,198,6,20,4,40,7,211,44,255,179,129,179,179};
static const unsigned char precomputed_mGnP_ed25519_n_151[] = {99,2,3,195,220,173,199,182,30,20,153,205,161,117,213,51,222,198,195,5,134,30,28,78,127,159,55,20,75,106,68,233,47,77,60,142,189,127,56,12,53,243,96,130,42,9,3,177,204,126,164,145,47,41,228,26,57,233,105,240,201,90,13,250};
static const unsigned char precomputed_mGnP_ed25519_P_151[] = {11,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_152[] = {172,20,123,108,148,102,186,89,194,53,169,189,51,152,114,124,204,59,186,9,134,107,123,150,49,52,132,185,203,123,136,23,0};
static const unsigned char precomputed_mGnP_ed25519_m_152[] = {112,181,180,93,129,108,32,122,171,196,84,89,167,78,233,221,80,77,79,94,218,112,74,80,130,150,216,101,167,229,52,186};
static const unsigned char precomputed_mGnP_ed25519_n_152[] = {229,116,196,134,23,234,184,3,140,145,214,199,29,238,117,212,229,115,218,78,183,248,226,148,154,198,24,134,100,239,52,84,2,249,206,65,238,148,85,28,151,116,191,202,201,20,91,31,228,91,244,142,52,247,84,17,47,177,143,212,205,255,68,41};
static const unsigned char precomputed_mGnP_ed25519_P_152[] = {12,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_153[] = {252,174,110,147,150,114,141,212,103,252,204,100,120,178,89,146,225,64,218,205,154,196,157,163,8,235,7,220,65,159,111,126,0};
static const unsigned char precomputed_mGnP_ed25519_m_153[] = {8,112,197,13,236,156,115,226,147,155,184,9,110,102,229,64,221,17,118,189,98,164,17,82,124,72,106,232,214,11,103,235};
static const unsigned char precomputed_mGnP_ed25519_n_153[] = {118,30,204,118,134,252,66,184,96,30,223,212,8,9,115,186,80,100,235,145,149,140,143,83,206,3,121,16,112,134,160,244,8,127,199,103,224,180,196,237,105,208,140,46,222,137,121,181,60,8,104,88,132,61,75,134,159,27,33,216,202,163,7,162};
static const unsigned char precomputed_mGnP_ed25519_P_153[] = {13,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_154[] = {115,191,92,79,27,34,234,71,173,17,26,226,138,2,173,24,175,181,255,35,149,21,84,244,225,92,63,192,227,107,31,75,0};
static const unsigned char precomputed_mGnP_ed25519_m_154[] = {246,11,85,52,221,169,40,242,154,70,94,159,119,26,112,181,8,0,13,172,227,227,199,205,150,202,222,5,11,162,24,30};
static const unsigned char precomputed_mGnP_ed25519_n_154[] = {165,235,193,25,52,195,98,12,65,45,138,167,91,222,49,136,151,38,131,83,11,168,124,121,5,11,11,65,119,218,248,136,235,50,174,156,3,159,240,139,124,172,18,133,52,119,156,9,154,158,169,105,241,202,54,245,56,176,19,37,67,80,235,221};
static const unsigned char precomputed_mGnP_ed25519_P_154[] = {14,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_155[] = {66,212,59,97,232,251,10,32,205,47,158,20,164,123,62,218,241,179,190,9,243,126,211,215,240,207,35,66,78,220,188,109,0};
static const unsigned char precomputed_mGnP_ed25519_m_155[] = {47,113,147,43,53,91,216,12,102,100,175,21,204,204,113,83,228,89,229,134,110,19,224,241,47,94,111,180,117,97,27,193};
static const unsigned char precomputed_mGnP_ed25519_n_155[] = {32,21,151,73,16,125,194,46,0,7,28,209,109,182,0,117,2,81,211,236,228,58,113,197,235,80,40,96,238,104,184,71,45,241,65,22,40,157,192,9,102,178,226,205,61,169,240,16,29,119,251,177,66,176,15,8,226,10,138,149,234,207,94,164};
static const unsigned char precomputed_mGnP_ed25519_P_155[] = {15,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_156[] = {169,208,153,159,119,139,209,205,27,148,13,159,44,107,42,208,84,245,51,200,225,13,27,30,196,224,150,202,28,25,198,131,0};
static const unsigned char precomputed_mGnP_ed25519_m_156[] = {96,38,80,131,232,234,123,13,191,167,174,112,114,248,11,106,123,4,175,164,0,1,145,32,243,241,78,170,18,196,177,36};
static const unsigned char precomputed_mGnP_ed25519_n_156[] = {204,13,37,89,196,32,191,222,115,219,238,109,253,20,122,93,213,116,186,131,104,97,203,45,60,41,61,174,120,114,25,158,131,139,132,41,110,52,76,48,107,2,223,241,89,41,51,117,187,138,71,65,61,63,164,69,193,148,50,56,118,203,240,105};
static const unsigned char precomputed_mGnP_ed25519_P_156[] = {16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_157[] = {82,218,112,210,39,143,249,187,111,26,168,224,208,105,170,24,138,122,89,31,166,180,243,151,33,242,80,115,4,74,252,72,0};
static const unsigned char precomputed_mGnP_ed25519_m_157[] = {230,10,252,165,184,146,174,57,12,236,103,52,227,205,225,2,80,7,83,107,234,88,46,14,251,220,150,233,225,196,76,6};
static const unsigned char precomputed_mGnP_ed25519_n_157[] = {182,187,177,54,239,215,245,223,85,18,152,157,1,43,114,84,142,38,201,11,147,197,148,169,239,33,250,29,146,7,57,20,103,141,252,9,89,60,113,97,107,94,94,15,254,91,81,183,212,24,2,210,43,230,148,12,202,201,82,201,122,108,171,132};
static const unsigned char precomputed_mGnP_ed25519_P_157[] = {17,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_158[] = {100,51,23,48,217,96,93,253,69,253,170,112,170,189,149,41,28,121,238,73,197,28,81,12,225,43,97,174,222,62,35,79,0};
static const unsigned char precomputed_mGnP_ed25519_m_158[] = {19,244,183,24,81,51,61,208,84,223,232,30,99,126,66,217,212,254,247,99,221,65,88,113,188,178,111,182,118,89,223,145};
static const unsigned char precomputed_mGnP_ed25519_n_158[] = {66,77,237,65,197,138,200,205,254,235,9,180,85,34,232,209,201,78,136,208,212,122,218,222,100,227,97,166,56,127,173,161,233,228,9,232,223,141,214,216,104,175,173,9,79,114,135,99,49,10,230,158,184,141,133,85,111,36,174,34,195,205,31,140};
static const unsigned char precomputed_mGnP_ed25519_P_158[] = {18,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_159[] = {204,76,252,214,59,238,164,106,236,158,77,84,78,111,232,107,229,15,22,205,75,111,200,152,217,33,248,157,82,108,214,29,0};
static const unsigned char precomputed_mGnP_ed25519_m_159[] = {160,235,191,217,224,240,150,77,15,182,207,97,168,98,10,82,167,169,152,173,113,127,200,107,156,238,18,81,101,170,126,223};
static const unsigned char precomputed_mGnP_ed25519_n_159[] = {132,59,218,205,170,175,214,177,88,249,91,100,66,97,121,19,41,50,71,197,33,63,112,192,56,18,1,251,132,74,131,232,204,203,47,126,73,34,251,137,5,223,107,210,80,245,33,187,193,10,23,51,229,129,243,64,193,228,134,209,119,71,148,239};
static const unsigned char precomputed_mGnP_ed25519_P_159[] = {19,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_160[] = {162,7,104,250,204,252,190,118,11,79,0,230,238,0,135,193,107,216,152,99,250,141,250,108,75,176,156,244,180,114,225,171,0};
static const unsigned char precomputed_mGnP_ed25519_m_160[] = {165,51,142,202,198,239,102,147,241,93,202,74,205,152,54,118,55,38,253,190,39,96,189,133,126,66,72,109,247,105,244,44};
static const unsigned char precomputed_mGnP_ed25519_n_160[] = {29,67,8,153,36,13,74,59,216,43,248,161,200,33,90,5,107,45,147,235,213,219,218,53,112,216,99,18,177,221,129,51,212,203,161,123,84,215,163,151,111,127,66,110,227,142,50,229,161,109,172,140,232,5,127,199,79,10,77,103,237,156,158,0};
static const unsigned char precomputed_mGnP_ed25519_P_160[] = {20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_161[] = {113,142,3,188,224,225,64,16,42,75,164,117,63,185,157,176,168,16,26,62,172,46,186,197,113,146,221,227,160,222,40,3,0};
static const unsigned char precomputed_mGnP_ed25519_m_161[] = {240,162,102,147,127,59,128,59,244,44,158,25,221,102,174,197,45,157,139,209,127,211,130,113,81,246,7,156,84,192,22,133};
static const unsigned char precomputed_mGnP_ed25519_n_161[] = {173,162,28,26,11,157,125,204,43,26,126,60,56,145,15,33,9,30,90,42,60,1,229,23,135,183,89,9,100,76,200,4,226,136,220,15,73,232,112,66,72,87,13,102,220,38,237,197,224,156,237,50,133,74,226,45,91,7,237,210,114,251,232,43};
static const unsigned char precomputed_mGnP_ed25519_P_161[] = {21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_162[] = {145,204,129,76,111,90,122,151,18,62,83,41,50,222,93,73,33,103,240,182,178,62,145,226,135,111,76,85,164,30,207,121,0};
static const unsigned char precomputed_mGnP_ed25519_m_162[] = {28,46,130,193,202,163,47,174,225,30,11,208,198,7,207,50,99,49,38,60,200,71,20,221,119,36,166,13,93,208,16,181};
static const unsigned char precomputed_mGnP_ed25519_n_162[] = {12,115,70,29,125,246,44,220,151,73,32,10,62,32,79,103,54,121,100,190,64,38,136,97,158,30,120,212,167,112,20,85,7,87,211,152,63,103,244,211,147,136,159,205,30,116,121,170,116,129,95,223,23,77,203,46,144,82,61,179,39,248,69,137};
static const unsigned char precomputed_mGnP_ed25519_P_162[] = {22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_163[] = {253,32,158,246,185,200,100,75,108,192,60,202,95,140,115,57,96,43,23,116,184,233,40,41,57,74,163,161,78,130,250,47,0};
static const unsigned char precomputed_mGnP_ed25519_m_163[] = {21,252,132,23,198,46,209,43,118,183,229,167,179,36,202,45,178,179,234,85,114,210,20,180,57,242,35,30,91,186,217,53};
static const unsigned char precomputed_mGnP_ed25519_n_163[] = {154,85,85,105,211,163,45,61,71,233,173,140,215,243,163,106,48,3,60,7,141,5,155,230,215,206,168,91,232,5,1,4,16,242,16,96,144,54,227,46,118,202,31,24,159,192,131,32,139,72,170,229,167,187,253,41,251,50,21,160,122,214,65,227};
static const unsigned char precomputed_mGnP_ed25519_P_163[] = {23,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_164[] = {143,137,99,37,83,232,154,92,209,108,156,13,53,131,249,129,3,131,162,58,46,162,43,60,54,138,180,147,66,74,168,159,0};
static const unsigned char precomputed_mGnP_ed25519_m_164[] = {217,154,50,174,119,220,81,93,56,206,191,121,115,228,21,155,153,111,214,121,250,146,186,201,44,99,80,199,67,135,109,200};
static const unsigned char precomputed_mGnP_ed25519_n_164[] = {42,33,41,87,29,24,162,76,73,2,83,172,51,169,55,101,234,186,137,163,174,23,251,67,57,14,145,70,176,51,70,170,222,45,198,126,186,112,26,29,191,135,162,247,234,31,58,210,204,189,132,156,58,155,48,54,155,13,137,109,22,199,106,66};
static const unsigned char precomputed_mGnP_ed25519_P_164[] = {24,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_165[] = {17,50,68,66,138,207,255,176,109,34,252,145,38,125,70,58,228,133,74,228,78,31,243,33,120,161,61,117,114,49,229,112,0};
static const unsigned char precomputed_mGnP_ed25519_m_165[] = {108,85,197,23,0,146,163,41,131,216,153,90,138,83,121,145,122,214,87,0,238,111,131,11,166,213,98,201,108,28,213,50};
static const unsigned char precomputed_mGnP_ed25519_n_165[] = {247,136,49,153,189,83,10,217,251,127,245,109,26,46,11,176,63,224,12,35,161,182,36,173,112,59,33,132,180,102,119,163,25,113,100,151,44,113,101,75,110,104,82,54,233,254,100,171,185,251,84,252,5,132,147,104,205,158,36,219,74,123,145,21};
static const unsigned char precomputed_mGnP_ed25519_P_165[] = {25,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_166[] = {180,42,203,20,96,93,224,34,43,104,178,173,192,206,15,51,30,225,185,223,31,164,25,79,78,186,18,242,210,84,185,88,1};
static const unsigned char precomputed_mGnP_ed25519_m_166[] = {242,239,41,230,99,54,191,16,145,212,236,93,191,231,213,119,116,87,22,55,58,135,154,243,22,221,145,203,82,43,83,5};
static const unsigned char precomputed_mGnP_ed25519_n_166[] = {19,36,190,25,114,215,98,134,222,168,25,114,83,145,96,235,91,71,182,120,241,89,162,208,150,190,203,217,88,202,180,60,21,252,82,236,49,84,143,147,86,36,162,52,136,59,194,178,216,99,248,32,168,123,81,51,229,44,94,15,17,129,111,2};
static const unsigned char precomputed_mGnP_ed25519_P_166[] = {26,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_167[] = {170,248,231,87,169,14,107,153,250,229,207,222,36,155,164,10,88,78,83,89,106,65,173,153,200,142,163,8,96,10,80,158,0};
static const unsigned char precomputed_mGnP_ed25519_m_167[] = {178,130,247,226,166,48,237,238,3,164,133,169,180,88,16,193,118,236,39,248,119,184,95,42,223,124,228,113,30,237,235,98};
static const unsigned char precomputed_mGnP_ed25519_n_167[] = {116,151,250,118,177,206,21,141,3,105,144,214,63,102,14,250,229,198,110,138,120,9,190,187,197,149,38,78,138,152,184,15,21,120,190,85,155,232,133,183,191,109,66,92,134,201,199,39,68,11,113,76,25,85,187,59,100,82,244,186,61,70,144,110};
static const unsigned char precomputed_mGnP_ed25519_P_167[] = {27,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_168[] = {103,160,252,150,179,149,236,129,119,38,138,37,37,61,76,152,141,116,252,242,118,196,190,168,252,45,3,117,99,98,180,11,0};
static const unsigned char precomputed_mGnP_ed25519_m_168[] = {189,54,209,143,47,160,4,194,38,248,182,90,132,251,104,159,19,242,31,195,191,197,242,255,145,69,128,25,237,163,98,210};
static const unsigned char precomputed_mGnP_ed25519_n_168[] = {107,2,249,219,140,92,102,202,46,194,113,169,205,140,151,0,209,19,233,139,214,42,249,55,22,171,155,148,72,189,99,250,232,12,114,79,92,165,232,7,59,32,209,101,4,95,160,79,204,54,182,1,5,119,214,108,128,156,232,69,237,146,12,241};
static const unsigned char precomputed_mGnP_ed25519_P_168[] = {28,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_169[] = {197,180,25,226,65,174,162,231,187,190,128,89,124,246,161,158,26,201,118,220,187,143,118,194,50,141,24,167,56,49,122,77,0};
static const unsigned char precomputed_mGnP_ed25519_m_169[] = {111,54,10,14,78,211,115,205,175,156,64,100,98,214,247,122,229,100,175,149,85,129,119,135,165,86,223,219,43,155,43,35};
static const unsigned char precomputed_mGnP_ed25519_n_169[] = {158,99,162,55,241,2,75,213,95,62,244,209,51,229,83,7,87,93,67,144,125,206,162,81,74,155,157,114,224,50,198,207,47,206,22,122,186,138,88,128,142,138,26,152,148,2,29,171,83,108,184,56,186,120,205,105,149,39,151,208,160,162,107,69};
static const unsigned char precomputed_mGnP_ed25519_P_169[] = {29,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_170[] = {28,192,229,46,163,226,32,247,83,76,190,145,182,169,223,116,30,109,154,149,79,230,170,41,192,71,73,33,172,225,239,79,0};
static const unsigned char precomputed_mGnP_ed25519_m_170[] = {202,151,192,65,202,80,25,118,217,109,51,204,194,2,236,165,102,25,64,237,1,242,131,171,81,133,111,153,125,108,43,67};
static const unsigned char precomputed_mGnP_ed25519_n_170[] = {193,177,241,237,126,49,37,33,237,48,114,223,39,11,29,227,182,131,221,141,139,162,29,186,31,1,56,216,134,59,201,119,89,137,216,108,165,135,237,174,154,14,127,250,131,172,164,111,63,23,1,237,66,82,9,105,39,134,115,103,252,137,180,199};
static const unsigned char precomputed_mGnP_ed25519_P_170[] = {30,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_171[] = {19,96,218,16,8,153,11,135,6,183,147,120,154,80,131,229,181,210,188,110,137,145,179,196,34,39,193,71,253,183,166,95,0};
static const unsigned char precomputed_mGnP_ed25519_m_171[] = {49,142,164,146,62,226,62,144,123,156,207,117,100,23,102,80,206,33,212,113,89,248,243,32,157,3,20,119,145,24,85,159};
static const unsigned char precomputed_mGnP_ed25519_n_171[] = {184,114,80,10,35,136,114,124,58,192,72,100,242,16,121,218,140,92,253,16,139,36,211,74,35,27,46,34,204,100,101,10,240,91,50,91,125,103,155,71,145,171,122,14,77,183,41,48,36,33,211,241,186,57,47,2,92,103,20,248,85,57,84,32};
static const unsigned char precomputed_mGnP_ed25519_P_171[] = {31,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_Q_172[] = {235,100,123,252,248,96,118,43,67,163,70,32,242,185,195,186,42,16,54,80,42,69,218,6,61,27,173,116,54,146,193,34,0};
static const unsigned char precomputed_mGnP_ed25519_m_172[] = {195,232,151,76,162,145,99,161,33,145,188,135,199,139,239,188,47,126,204,229,198,121,73,152,243,9,164,30,21,132,75,130};
static const unsigned char precomputed_mGnP_ed25519_n_172[] = {244,10,229,211,252,107,78,240,231,180,218,76,80,54,53,12,254,201,210,161,240,221,201,95,5,191,179,76,76,102,164,56,60,4,216,238,157,230,239,102,13,104,214,92,81,175,211,98,209,28,33,110,106,166,248,210,249,115,96,152,113,253,95,15};
static const unsigned char precomputed_mGnP_ed25519_P_172[] = {15,202,72,65,134,59,164,90,150,30,251,86,17,92,90,253,247,183,247,41,145,35,193,117,17,136,192,98,245,81,100,128};
static const unsigned char precomputed_mGnP_ed25519_Q_173[] = {164,204,77,160,107,164,249,130,209,67,217,113,228,212,19,207,242,104,198,209,177,230,207,233,16,14,169,46,87,3,152,31,0};
static const unsigned char precomputed_mGnP_ed25519_m_173[] = {37,94,141,104,131,132,69,129,106,250,215,87,168,145,0,2,17,239,75,243,63,23,161,229,110,53,6,133,39,4,83,163};
static const unsigned char precomputed_mGnP_ed25519_n_173[] = {24,99,151,252,42,59,152,60,26,237,225,70,225,126,142,145,101,68,179,222,117,225,113,152,43,116,205,191,223,47,41,214,49,91,83,200,100,197,232,119,236,180,159,211,192,221,68,235,102,194,200,109,165,240,86,140,7,228,81,216,116,249,248,223};
static const unsigned char precomputed_mGnP_ed25519_P_173[] = {205,235,122,124,59,65,184,174,22,86,227,250,241,159,196,106,218,9,141,235,156,50,177,253,134,98,5,22,95,73,184,128};
static const unsigned char precomputed_mGnP_ed25519_Q_174[] = {195,161,158,212,169,55,66,22,247,245,255,251,146,34,248,154,58,167,3,112,124,165,182,183,175,199,225,5,196,12,88,118,0};
static const unsigned char precomputed_mGnP_ed25519_m_174[] = {73,44,13,40,152,232,103,106,176,96,32,125,170,206,121,184,103,214,45,230,55,190,103,160,114,77,86,209,101,127,244,206};
static const unsigned char precomputed_mGnP_ed25519_n_174[] = {14,97,227,130,153,248,7,102,216,47,118,132,11,91,226,43,105,244,164,113,226,92,23,216,176,127,239,202,40,83,43,186,59,105,148,114,175,162,130,17,12,214,78,214,218,41,118,67,130,158,184,166,100,184,15,93,64,25,232,111,158,154,46,92};
static const unsigned char precomputed_mGnP_ed25519_P_174[] = {134,45,86,6,135,126,106,53,88,197,149,226,163,37,202,21,175,21,54,79,124,201,81,251,29,168,112,67,85,215,214,133};
static const unsigned char precomputed_mGnP_ed25519_Q_175[] = {29,133,75,26,14,7,216,176,177,131,46,232,245,191,123,162,132,179,215,23,121,95,90,50,80,87,7,200,243,156,66,217,0};
static const unsigned char precomputed_mGnP_ed25519_m_175[] = {153,46,76,236,244,71,99,131,120,2,139,85,67,152,71,110,218,197,59,36,230,190,102,104,199,166,239,111,20,243,38,226};
static const unsigned char precomputed_mGnP_ed25519_n_175[] = {195,107,215,90,182,12,98,121,242,164,61,56,35,249,163,115,1,235,1,250,255,111,96,109,166,141,112,133,56,15,238,62,168,127,101,253,104,26,155,232,151,46,169,114,148,72,5,82,229,0,30,150,224,89,201,14,108,118,222,146,208,152,40,220};
static const unsigned char precomputed_mGnP_ed25519_P_175[] = {19,232,149,143,194,178,39,176,69,195,244,137,242,239,152,240,213,223,172,5,211,198,51,57,177,56,2,136,109,83,252,133};
static const unsigned char precomputed_mGnP_ed25519_Q_176[] = {242,1,23,67,30,255,234,221,144,234,121,206,183,149,3,95,203,9,78,198,131,117,137,10,161,154,90,24,136,210,244,198,0};
static const unsigned char precomputed_mGnP_ed25519_m_176[] = {124,243,110,210,132,174,49,249,236,4,181,60,143,152,10,22,240,83,230,136,193,10,112,60,124,145,249,70,248,205,246,113};
static const unsigned char precomputed_mGnP_ed25519_n_176[] = {200,96,110,104,129,251,200,226,242,179,128,100,82,32,223,4,107,208,161,4,113,249,149,130,149,18,24,168,115,129,68,27,213,126,16,187,250,249,131,233,84,103,240,249,86,241,144,205,148,60,62,188,46,132,44,198,250,16,9,159,104,109,75,162};
static const unsigned char precomputed_mGnP_ed25519_P_176[] = {169,110,86,37,132,219,71,97,245,248,1,116,176,11,9,146,76,167,15,128,12,4,150,39,207,94,13,180,150,216,139,134};
static const unsigned char precomputed_mGnP_ed25519_Q_177[] = {140,127,232,127,42,139,245,211,115,49,137,247,0,14,121,94,246,77,162,229,60,112,210,155,106,1,132,89,228,25,169,62,0};
static const unsigned char precomputed_mGnP_ed25519_m_177[] = {234,98,3,217,93,185,21,30,164,65,164,167,143,22,5,167,209,0,198,178,15,236,190,150,149,144,158,93,132,187,108,200};
static const unsigned char precomputed_mGnP_ed25519_n_177[] = {193,159,235,1,222,80,8,184,5,128,208,161,28,100,77,189,87,16,99,63,44,221,28,134,242,14,35,66,119,212,231,148,120,47,210,71,145,13,200,242,192,126,33,238,169,233,0,192,161,49,75,229,219,100,220,90,63,206,61,218,44,98,27,199};
static const unsigned char precomputed_mGnP_ed25519_P_177[] = {27,94,32,221,185,253,205,81,16,106,160,71,66,193,172,50,128,123,150,24,2,205,204,28,35,232,42,182,24,139,247,134};
static const unsigned char precomputed_mGnP_ed25519_Q_178[] = {152,145,26,162,12,22,19,131,144,45,225,129,138,147,212,143,183,147,150,225,139,229,99,49,51,204,204,97,23,187,209,176,0};
static const unsigned char precomputed_mGnP_ed25519_m_178[] = {130,56,54,245,188,111,198,213,126,118,218,165,113,68,120,37,230,59,183,192,200,214,107,34,124,155,60,179,79,223,151,216};
static const unsigned char precomputed_mGnP_ed25519_n_178[] = {209,9,193,4,25,223,169,185,117,168,255,229,240,209,237,2,249,190,116,134,32,200,105,153,79,166,218,127,124,218,99,115,72,28,9,188,72,205,118,184,123,252,66,172,186,35,8,81,160,253,38,25,29,233,232,243,95,147,90,19,89,221,152,162};
static const unsigned char precomputed_mGnP_ed25519_P_178[] = {42,253,187,252,134,95,243,186,16,181,187,15,255,28,206,0,110,241,40,76,23,47,234,133,198,158,33,31,179,145,23,135};
static const unsigned char precomputed_mGnP_ed25519_Q_179[] = {1,198,186,155,42,13,193,149,240,112,73,41,220,134,236,255,26,218,110,116,134,123,141,115,44,224,219,46,115,212,245,15,0};
static const unsigned char precomputed_mGnP_ed25519_m_179[] = {156,20,27,90,74,232,173,207,13,170,101,80,142,193,249,255,73,20,38,37,73,19,95,43,232,94,54,243,219,68,28,73};
static const unsigned char precomputed_mGnP_ed25519_n_179[] = {81,146,157,56,150,177,73,108,252,13,230,157,197,135,33,88,149,49,228,195,42,160,0,227,82,226,130,203,245,167,182,42,178,190,116,255,209,53,11,196,244,171,88,211,35,48,159,6,170,195,142,43,69,0,233,227,2,144,69,10,67,43,98,208};
static const unsigned char precomputed_mGnP_ed25519_P_179[] = {41,109,180,132,253,90,130,59,68,248,72,68,176,181,63,184,171,140,214,99,65,91,214,4,160,17,215,177,76,55,164,136};
static const unsigned char precomputed_mGnP_ed25519_Q_180[] = {225,41,205,108,217,212,116,206,149,104,183,105,139,86,70,92,199,5,97,113,145,73,158,167,223,176,161,213,200,134,233,155,0};
static const unsigned char precomputed_mGnP_ed25519_m_180[] = {152,163,124,136,53,192,127,80,131,23,138,235,108,202,119,198,241,159,219,254,4,81,193,81,66,123,128,151,128,48,3,36};
static const unsigned char precomputed_mGnP_ed25519_n_180[] = {36,56,24,86,54,151,71,174,155,73,66,71,234,233,161,52,93,48,34,80,17,82,131,16,46,248,249,172,84,4,82,78,12,54,192,44,187,186,251,148,42,94,163,126,165,24,194,201,2,214,12,43,169,71,240,129,112,72,167,240,158,172,39,168};
static const unsigned char precomputed_mGnP_ed25519_P_180[] = {89,176,33,129,176,6,44,214,190,23,39,124,63,9,188,121,108,239,97,239,34,189,0,153,47,119,0,160,146,111,87,139};
static const unsigned char precomputed_mGnP_ed25519_Q_181[] = {224,87,175,131,73,104,125,235,12,179,232,8,65,24,22,185,74,178,78,123,189,161,115,179,122,19,210,58,105,52,34,184,0};
static const unsigned char precomputed_mGnP_ed25519_m_181[] = {211,96,75,255,137,21,14,100,24,14,33,56,129,81,78,43,88,109,233,15,148,120,100,141,221,183,155,226,16,31,181,132};
static const unsigned char precomputed_mGnP_ed25519_n_181[] = {99,178,22,182,239,234,125,35,159,66,171,186,209,123,118,224,11,69,254,146,107,161,56,136,71,75,17,219,44,126,113,84,220,7,99,191,3,101,201,193,193,6,212,177,205,203,254,216,210,35,105,209,45,49,207,62,95,44,107,113,194,79,20,225};
static const unsigned char precomputed_mGnP_ed25519_P_181[] = {11,46,34,224,225,54,132,37,50,225,50,181,111,149,20,28,55,237,157,88,182,35,146,71,255,20,62,22,131,72,123,143};
static const unsigned char precomputed_mGnP_ed25519_Q_182[] = {178,52,25,199,90,86,164,55,188,96,66,234,37,235,245,156,179,116,31,108,118,11,114,193,69,161,163,240,131,70,136,41,0};
static const unsigned char precomputed_mGnP_ed25519_m_182[] = {141,45,246,246,188,182,105,33,128,157,122,29,61,146,77,154,125,189,77,73,81,115,223,253,185,168,243,135,242,240,239,184};
static const unsigned char precomputed_mGnP_ed25519_n_182[] = {100,34,38,128,128,148,254,65,214,132,178,41,238,240,90,10,17,143,198,197,127,206,215,12,123,206,208,30,14,246,99,19,139,203,193,68,22,254,140,202,15,216,91,204,191,170,12,14,46,97,122,125,22,76,58,193,107,144,150,183,171,79,182,223};
static const unsigned char precomputed_mGnP_ed25519_P_182[] = {175,8,2,207,88,111,14,41,6,241,193,250,227,210,71,27,173,58,211,40,158,235,38,41,77,191,164,39,149,115,145,143};
static const unsigned char precomputed_mGnP_ed25519_Q_183[] = {85,46,68,184,32,39,85,215,14,37,191,242,205,247,233,219,40,252,20,2,124,192,230,205,143,154,50,107,179,132,174,56,0};
static const unsigned char precomputed_mGnP_ed25519_m_183[] = {158,146,191,162,204,181,50,56,48,226,130,120,250,218,86,233,91,137,2,185,61,143,39,50,147,107,191,240,83,214,22,207};
static const unsigned char precomputed_mGnP_ed25519_n_183[] = {123,72,158,227,26,114,128,145,114,68,47,169,122,114,45,115,87,210,162,128,220,156,134,207,8,103,188,98,239,180,254,130,196,161,55,120,29,135,185,193,225,234,124,3,228,184,67,6,45,223,97,196,103,184,255,55,226,251,195,5,13,174,71,84};
static const unsigned char precomputed_mGnP_ed25519_P_183[] = {158,63,163,2,209,61,243,101,255,215,205,118,14,128,144,81,227,196,193,155,244,96,139,47,49,229,71,152,32,158,96,144};
static const unsigned char precomputed_mGnP_ed25519_Q_184[] = {9,243,61,41,221,46,28,109,249,126,189,32,63,44,91,250,250,148,190,216,153,35,38,255,98,58,31,14,16,207,218,103,0};
static const unsigned char precomputed_mGnP_ed25519_m_184[] = {59,251,84,103,98,154,125,192,56,201,233,20,46,178,154,234,126,33,140,10,186,222,170,92,237,0,240,68,157,106,204,178};
static const unsigned char precomputed_mGnP_ed25519_n_184[] = {148,247,18,61,196,62,30,231,88,78,138,216,177,42,241,63,36,190,179,75,129,243,6,37,45,250,164,109,113,2,80,168,4,229,102,60,163,187,60,236,98,148,209,31,111,132,149,132,98,55,213,26,196,250,93,204,246,208,5,130,119,150,237,197};
static const unsigned char precomputed_mGnP_ed25519_P_184[] = {168,222,62,78,165,5,144,178,39,48,36,112,244,186,178,129,204,219,85,212,107,36,99,166,133,109,125,246,2,134,254,145};
static const unsigned char precomputed_mGnP_ed25519_Q_185[] = {119,41,16,238,183,228,113,21,134,7,19,136,104,62,44,43,195,214,140,138,66,115,132,164,66,130,164,51,9,221,14,112,0};
static const unsigned char precomputed_mGnP_ed25519_m_185[] = {199,156,190,42,58,161,239,118,15,62,111,87,135,186,83,208,3,228,46,31,122,89,119,123,144,177,212,173,174,114,100,27};
static const unsigned char precomputed_mGnP_ed25519_n_185[] = {148,90,102,253,3,231,219,57,125,134,201,70,150,175,163,102,241,146,106,178,238,63,181,137,67,40,129,51,253,221,199,233,19,221,19,131,184,129,26,59,38,254,200,9,188,237,193,190,42,174,242,77,47,208,79,121,97,115,65,38,182,138,226,43};
static const unsigned char precomputed_mGnP_ed25519_P_185[] = {161,164,99,189,12,125,22,108,64,69,81,70,238,147,169,129,39,21,125,46,182,24,184,237,48,87,82,210,76,63,69,148};
static const unsigned char precomputed_mGnP_ed25519_Q_186[] = {57,83,133,85,54,122,202,157,26,71,227,204,227,96,115,93,121,66,204,30,215,212,168,81,140,220,209,99,94,205,66,188,0};
static const unsigned char precomputed_mGnP_ed25519_m_186[] = {79,238,157,90,203,90,165,174,241,38,214,142,130,134,216,20,47,138,16,195,22,178,206,125,129,222,150,231,194,231,138,32};
static const unsigned char precomputed_mGnP_ed25519_n_186[] = {55,25,138,113,191,122,65,36,56,90,159,163,98,107,207,121,24,48,142,145,223,185,233,87,56,78,188,238,2,109,63,154,77,199,116,1,13,114,68,196,150,185,202,51,89,115,148,219,37,146,244,48,186,76,173,85,236,119,131,63,54,231,136,137};
static const unsigned char precomputed_mGnP_ed25519_P_186[] = {170,162,42,35,41,84,42,97,251,71,156,129,94,24,92,143,122,46,126,93,23,192,112,188,136,198,130,139,213,202,223,148};
static const unsigned char precomputed_mGnP_ed25519_Q_187[] = {85,131,34,39,133,3,77,93,255,199,226,43,87,0,11,50,186,31,208,244,85,75,227,216,11,153,16,168,54,170,62,156,0};
static const unsigned char precomputed_mGnP_ed25519_m_187[] = {193,9,36,103,143,12,208,9,127,231,115,229,220,192,102,1,204,36,255,216,71,206,160,151,96,141,33,76,119,112,167,199};
static const unsigned char precomputed_mGnP_ed25519_n_187[] = {229,131,107,164,150,112,180,120,32,75,164,171,35,123,110,80,117,178,73,46,51,96,30,168,211,198,50,132,26,115,135,129,184,89,121,248,151,151,143,14,144,214,173,222,21,107,49,172,33,65,126,226,9,74,180,71,119,42,205,75,241,44,96,53};
static const unsigned char precomputed_mGnP_ed25519_P_187[] = {168,98,236,26,122,57,204,10,102,3,57,100,14,248,246,86,160,155,93,84,30,194,127,129,10,213,18,36,220,243,182,150};
static const unsigned char precomputed_mGnP_ed25519_Q_188[] = {108,187,90,43,9,35,178,142,161,240,55,101,92,85,180,233,170,4,58,82,212,95,36,102,168,64,179,218,64,185,249,136,0};
static const unsigned char precomputed_mGnP_ed25519_m_188[] = {220,238,240,224,77,239,227,208,119,21,64,171,42,248,111,64,105,107,246,14,46,131,174,71,253,108,83,150,158,65,55,186};
static const unsigned char precomputed_mGnP_ed25519_n_188[] = {208,89,187,110,197,252,151,175,29,94,45,218,31,104,26,128,77,159,195,43,218,180,225,217,4,135,104,20,211,127,82,188,104,211,47,248,34,95,33,236,210,135,114,82,191,137,29,21,78,89,193,8,24,232,65,184,191,182,226,187,89,74,156,159};
static const unsigned char precomputed_mGnP_ed25519_P_188[] = {62,72,157,122,56,223,50,242,126,141,3,69,108,245,176,206,48,10,150,154,125,43,80,183,144,157,16,85,100,144,208,153};
static const unsigned char precomputed_mGnP_ed25519_Q_189[] = {176,147,15,138,8,9,139,54,188,247,58,123,226,190,104,64,29,197,33,9,7,87,21,20,96,196,204,99,39,238,94,156,0};
static const unsigned char precomputed_mGnP_ed25519_m_189[] = {58,240,72,28,153,158,220,55,75,191,212,68,176,59,15,242,205,57,166,34,162,99,199,96,99,32,138,155,184,191,86,3};
static const unsigned char precomputed_mGnP_ed25519_n_189[] = {74,60,135,0,80,192,192,50,162,223,119,229,210,135,96,124,210,3,163,224,85,110,133,142,78,5,175,47,21,205,161,68,36,95,3,69,167,236,25,15,11,228,96,68,49,127,100,173,171,51,158,53,158,147,195,4,52,71,36,22,15,102,245,229};
static const unsigned char precomputed_mGnP_ed25519_P_189[] = {59,3,54,152,124,140,187,237,103,170,221,75,236,125,70,49,81,201,224,116,6,46,3,154,33,29,120,202,38,178,124,155};
static const unsigned char precomputed_mGnP_ed25519_Q_190[] = {20,242,117,252,25,179,45,243,102,34,226,222,49,157,239,97,35,44,139,16,7,90,75,80,49,51,157,128,31,106,210,185,0};
static const unsigned char precomputed_mGnP_ed25519_m_190[] = {124,6,37,20,96,197,6,85,182,201,142,200,147,132,130,101,254,163,19,178,64,197,44,166,22,162,117,108,117,95,155,49};
static const unsigned char precomputed_mGnP_ed25519_n_190[] = {33,141,131,2,245,139,100,221,114,7,48,126,162,9,43,8,71,145,203,42,25,229,22,188,130,248,90,97,237,96,173,36,137,106,174,68,47,188,161,60,31,103,235,172,182,173,252,187,25,195,118,79,227,33,72,154,241,207,78,167,157,255,124,135};
static const unsigned char precomputed_mGnP_ed25519_P_190[] = {197,131,97,219,129,218,22,217,9,209,249,57,140,173,163,106,113,34,131,143,175,83,178,28,7,22,221,212,49,225,175,159};
static const unsigned char precomputed_mGnP_ed25519_Q_191[] = {192,52,89,109,71,234,255,195,139,173,95,153,38,119,131,232,225,73,89,113,228,62,41,166,9,21,53,83,211,226,171,120,1};
static const unsigned char precomputed_mGnP_ed25519_m_191[] = {141,86,122,119,60,122,213,130,193,20,57,29,232,125,102,222,86,71,9,47,30,205,228,174,244,210,235,190,160,87,211,6};
static const unsigned char precomputed_mGnP_ed25519_n_191[] = {132,255,233,216,109,244,132,116,3,114,150,129,0,115,45,125,4,109,51,48,74,217,61,218,127,65,93,242,100,153,184,159,53,247,158,48,94,155,222,31,105,222,39,214,93,215,30,152,16,254,147,6,235,220,167,252,207,32,234,45,78,214,218,142};
static const unsigned char precomputed_mGnP_ed25519_P_191[] = {162,32,69,38,74,213,90,104,72,3,18,57,109,49,55,243,64,172,152,80,15,123,12,201,235,19,76,9,208,93,0,166};
static const unsigned char precomputed_mGnP_ed25519_Q_192[] = {82,108,228,253,226,128,19,98,172,63,94,238,167,19,62,163,143,33,126,13,127,153,70,102,66,163,232,249,109,196,106,142,0};
static const unsigned char precomputed_mGnP_ed25519_m_192[] = {228,173,160,207,15,99,90,53,230,205,56,82,46,27,135,50,85,223,225,33,235,210,236,200,64,181,250,51,22,199,254,134};
static const unsigned char precomputed_mGnP_ed25519_n_192[] = {41,105,47,26,224,127,209,84,173,217,44,126,201,17,27,227,176,212,218,21,15,1,13,217,204,97,236,50,10,5,177,251,44,77,121,228,54,24,5,52,139,254,233,72,223,171,151,57,160,31,0,240,114,85,15,99,96,84,71,155,129,221,172,196};
static const unsigned char precomputed_mGnP_ed25519_P_192[] = {116,224,121,163,115,49,221,231,34,23,75,55,170,41,248,219,64,30,172,12,14,12,22,73,85,92,239,84,238,225,137,167};
static const unsigned char precomputed_mGnP_ed25519_Q_193[] = {65,18,167,198,136,217,142,219,197,159,173,15,141,124,121,224,244,194,232,205,129,65,213,26,17,197,194,215,24,230,183,159,0};
static const unsigned char precomputed_mGnP_ed25519_m_193[] = {180,184,62,178,121,127,7,25,26,3,139,41,241,80,230,188,37,13,226,78,176,244,106,164,27,189,65,234,78,228,93,106};
static const unsigned char precomputed_mGnP_ed25519_n_193[] = {186,230,120,240,153,228,255,40,111,24,10,201,119,19,195,4,179,96,15,159,140,227,27,158,80,83,68,142,234,17,66,132,144,91,82,156,114,74,80,204,203,129,128,178,174,140,208,126,115,70,26,102,110,215,68,163,112,71,200,95,124,2,35,53};
static const unsigned char precomputed_mGnP_ed25519_P_193[] = {187,129,32,77,78,44,152,80,61,210,244,23,155,18,159,123,75,11,180,226,234,33,106,228,99,10,71,36,196,124,186,168};
static const unsigned char precomputed_mGnP_ed25519_Q_194[] = {180,153,173,48,95,67,84,30,93,52,3,136,190,168,74,195,211,232,146,202,169,24,76,61,238,37,31,234,223,213,0,89,0};
static const unsigned char precomputed_mGnP_ed25519_m_194[] = {198,70,188,140,74,171,33,84,87,219,111,244,215,205,34,59,113,14,120,80,198,100,30,15,25,226,70,113,220,235,84,134};
static const unsigned char precomputed_mGnP_ed25519_n_194[] = {64,3,111,151,32,171,146,43,9,222,61,190,16,220,45,182,70,21,254,219,108,238,98,62,171,197,65,106,177,204,196,23,112,8,217,134,114,100,196,255,212,160,129,98,179,56,57,156,170,105,54,213,211,13,64,249,193,204,111,154,142,31,107,147};
static const unsigned char precomputed_mGnP_ed25519_P_194[] = {33,135,173,176,8,63,68,129,123,108,150,228,3,1,207,219,61,134,80,166,211,205,62,43,251,80,230,122,84,229,174,170};
static const unsigned char precomputed_mGnP_ed25519_Q_195[] = {202,165,120,117,22,86,74,86,42,94,98,255,206,37,2,35,223,183,125,67,52,172,84,145,249,32,83,201,229,223,96,58,0};
static const unsigned char precomputed_mGnP_ed25519_m_195[] = {212,237,195,194,92,132,197,140,100,225,231,151,5,248,169,228,226,135,188,247,4,135,67,43,61,221,64,77,255,8,118,85};
static const unsigned char precomputed_mGnP_ed25519_n_195[] = {117,92,12,66,198,142,243,156,235,73,160,92,74,29,71,247,87,106,69,13,137,237,191,5,116,40,185,67,158,43,97,171,231,143,212,235,34,189,110,14,103,111,181,110,17,100,179,122,236,88,140,8,195,41,86,46,44,64,79,136,177,240,171,232};
static const unsigned char precomputed_mGnP_ed25519_P_195[] = {192,162,3,203,98,171,180,1,119,178,173,156,44,204,12,246,1,20,24,143,6,228,102,249,59,211,209,107,144,228,91,171};
static const unsigned char precomputed_mGnP_ed25519_Q_196[] = {252,149,85,217,212,247,232,213,144,197,71,191,222,89,29,96,101,121,15,12,140,126,159,130,216,149,56,127,205,179,255,42,0};
static const unsigned char precomputed_mGnP_ed25519_m_196[] = {178,169,70,238,131,11,221,12,29,237,145,89,232,116,200,36,117,129,85,147,100,139,146,119,77,213,128,156,202,72,29,235};
static const unsigned char precomputed_mGnP_ed25519_n_196[] = {181,106,32,120,51,1,41,131,131,28,250,13,43,95,134,224,107,41,190,248,24,24,221,9,51,40,26,78,216,99,97,157,26,141,178,222,219,206,48,87,48,171,23,21,170,228,1,123,135,197,36,180,89,58,255,39,197,250,92,153,87,159,174,42};
static const unsigned char precomputed_mGnP_ed25519_P_196[] = {214,214,220,104,206,133,2,160,149,204,55,98,82,188,149,15,156,46,142,39,255,210,231,206,119,101,85,249,61,71,105,171};
static const unsigned char precomputed_mGnP_ed25519_Q_197[] = {253,124,193,98,4,18,41,163,123,41,18,189,233,126,188,187,68,144,108,131,84,61,128,51,89,113,59,241,74,77,95,34,0};
static const unsigned char precomputed_mGnP_ed25519_m_197[] = {164,208,126,148,99,158,148,96,166,241,57,130,179,39,75,7,76,32,1,171,136,59,181,42,136,7,14,106,166,158,197,42};
static const unsigned char precomputed_mGnP_ed25519_n_197[] = {147,83,86,182,164,153,7,102,179,135,151,29,181,229,35,237,37,135,214,186,200,214,38,170,161,48,177,151,214,138,4,77,16,61,196,109,124,37,168,148,196,135,171,183,248,148,207,235,178,249,42,49,201,67,131,251,59,229,250,114,138,218,51,74};
static const unsigned char precomputed_mGnP_ed25519_P_197[] = {203,39,31,0,55,163,112,132,197,100,203,59,48,241,40,44,149,91,114,205,194,202,152,164,241,115,85,14,215,8,63,179};
static const unsigned char precomputed_mGnP_ed25519_Q_198[] = {188,29,254,226,86,215,157,94,245,37,243,238,40,143,25,94,21,253,188,156,53,228,75,108,131,54,57,155,48,211,213,129,0};
static const unsigned char precomputed_mGnP_ed25519_m_198[] = {18,195,222,170,175,239,59,22,4,186,46,204,165,223,74,37,15,241,173,241,239,154,13,197,12,176,110,32,101,142,129,245};
static const unsigned char precomputed_mGnP_ed25519_n_198[] = {163,46,165,194,103,59,155,215,196,39,160,145,73,73,65,54,105,217,191,223,4,177,130,60,33,179,143,227,129,115,82,50,80,114,232,55,114,250,173,196,191,60,103,35,46,37,80,139,184,157,140,102,87,47,109,103,222,36,190,207,103,170,14,62};
static const unsigned char precomputed_mGnP_ed25519_P_198[] = {50,174,127,41,66,118,225,92,168,54,126,229,107,137,0,209,170,175,233,44,66,199,138,179,129,180,92,2,191,35,1,180};
static const unsigned char precomputed_mGnP_ed25519_Q_199[] = {209,34,147,218,189,70,178,72,40,129,67,159,66,200,19,63,72,79,152,135,124,35,56,168,164,223,207,22,252,93,111,64,0};
static const unsigned char precomputed_mGnP_ed25519_m_199[] = {43,59,249,123,246,175,123,89,65,162,161,96,155,25,255,16,134,170,210,155,231,15,243,200,57,247,116,192,97,125,253,221};
static const unsigned char precomputed_mGnP_ed25519_n_199[] = {125,133,43,156,71,142,210,18,147,227,231,103,155,97,182,54,14,217,87,44,22,205,195,103,84,111,163,115,38,179,110,123,65,71,196,248,12,128,175,250,188,211,214,219,50,44,227,25,38,114,33,4,184,192,234,43,200,185,191,59,81,205,194,186};
static const unsigned char precomputed_mGnP_ed25519_P_199[] = {133,87,197,21,1,127,223,75,81,227,105,50,176,135,246,243,135,36,218,220,216,101,27,75,222,163,174,73,160,3,113,181};
static const unsigned char precomputed_mGnP_ed25519_Q_200[] = {93,76,193,194,54,30,117,98,14,53,17,169,170,27,204,4,157,228,41,224,171,146,185,161,70,199,87,15,161,183,240,201,0};
static const unsigned char precomputed_mGnP_ed25519_m_200[] = {202,72,127,124,38,170,0,105,181,101,184,154,28,101,200,201,166,164,159,154,215,40,114,152,97,169,183,127,53,113,250,138};
static const unsigned char precomputed_mGnP_ed25519_n_200[] = {182,217,112,132,144,80,215,11,17,135,111,56,195,9,127,152,242,219,220,8,79,66,69,138,23,144,142,198,170,4,182,204,168,107,213,58,255,102,213,98,79,232,244,234,202,116,55,119,2,109,229,136,94,84,145,68,134,90,219,162,100,161,241,58};
static const unsigned char precomputed_mGnP_ed25519_P_200[] = {169,250,39,98,67,83,7,88,248,188,130,125,154,194,114,112,26,221,139,207,155,50,237,29,19,134,110,13,212,8,68,182};
static const unsigned char precomputed_mGnP_ed25519_Q_201[] = {61,103,197,180,235,223,40,225,115,79,9,17,37,200,186,138,126,90,206,172,135,235,5,78,243,216,63,167,186,125,13,227,0};
static const unsigned char precomputed_mGnP_ed25519_m_201[] = {8,227,84,252,204,238,151,122,104,169,44,212,117,51,82,215,199,139,131,149,172,233,189,90,4,4,113,109,50,57,43,209};
static const unsigned char precomputed_mGnP_ed25519_n_201[] = {77,185,124,132,110,182,163,171,9,84,195,224,241,33,166,104,200,224,124,220,2,247,253,229,90,195,241,39,166,111,133,137,242,191,77,90,113,187,235,206,143,55,212,30,21,239,1,14,72,135,145,26,117,125,110,156,230,234,121,79,149,226,239,171};
static const unsigned char precomputed_mGnP_ed25519_P_201[] = {231,97,91,239,176,88,194,117,73,15,124,25,71,53,206,155,65,82,141,200,198,213,236,155,199,186,144,197,94,36,72,185};
static const unsigned char precomputed_mGnP_ed25519_Q_202[] = {178,50,149,29,111,242,184,196,63,52,27,241,10,33,85,253,53,225,66,169,232,210,116,220,191,158,106,223,113,13,239,23,0};
static const unsigned char precomputed_mGnP_ed25519_m_202[] = {67,253,248,98,89,200,80,121,28,193,177,14,38,129,3,7,60,235,253,0,175,120,57,228,29,229,233,129,31,148,81,241};
static const unsigned char precomputed_mGnP_ed25519_n_202[] = {154,127,88,106,16,99,113,32,174,106,175,6,245,4,4,99,2,17,112,93,69,171,61,104,72,12,204,134,230,100,40,91,202,185,10,220,74,101,181,17,160,86,229,113,147,187,82,37,83,116,10,89,31,251,13,153,120,113,4,255,70,172,141,164};
static const unsigned char precomputed_mGnP_ed25519_P_202[] = {82,164,31,126,105,247,223,71,7,119,74,46,203,243,129,215,184,44,218,12,105,81,114,135,162,240,192,229,122,11,238,186};
static const unsigned char precomputed_mGnP_ed25519_Q_203[] = {227,250,49,27,215,124,198,231,252,72,129,179,12,77,154,82,38,161,85,154,254,197,77,116,127,154,184,117,48,43,32,60,0};
static const unsigned char precomputed_mGnP_ed25519_m_203[] = {16,101,119,175,245,176,204,87,4,9,55,228,150,126,151,38,169,104,89,186,32,137,54,35,81,117,253,17,85,227,94,151};
static const unsigned char precomputed_mGnP_ed25519_n_203[] = {172,255,143,238,161,97,77,184,85,133,183,232,13,188,173,62,199,86,201,254,104,100,0,190,36,73,234,185,109,127,219,108,168,41,215,154,74,226,247,220,204,143,29,5,239,189,107,112,131,31,122,60,201,207,233,90,185,11,94,169,219,143,109,75};
static const unsigned char precomputed_mGnP_ed25519_P_203[] = {68,107,89,151,178,8,165,126,190,185,3,102,128,110,169,106,207,22,232,197,118,195,230,143,170,73,134,183,173,15,40,188};
static const unsigned char precomputed_mGnP_ed25519_Q_204[] = {162,168,183,171,141,199,160,230,69,138,6,31,77,19,221,73,161,80,198,208,166,13,140,104,184,208,145,20,174,145,219,6,0};
static const unsigned char precomputed_mGnP_ed25519_m_204[] = {133,241,102,186,12,199,81,252,133,136,150,140,61,151,106,53,6,167,174,145,224,109,159,22,112,252,227,82,152,31,223,58};
static const unsigned char precomputed_mGnP_ed25519_n_204[] = {221,8,203,31,191,214,102,172,167,210,182,29,237,249,238,113,17,25,179,31,88,185,11,73,156,126,136,35,12,33,78,53,13,6,245,177,142,47,101,115,218,78,116,95,24,179,205,230,151,235,122,13,141,172,222,80,246,16,83,63,67,121,14,254};
static const unsigned char precomputed_mGnP_ed25519_P_204[] = {185,152,154,170,236,246,115,238,74,219,239,56,100,83,37,163,50,33,189,75,224,75,190,203,72,137,112,104,220,239,104,193};
static const unsigned char precomputed_mGnP_ed25519_Q_205[] = {130,227,156,88,100,152,79,46,54,66,60,198,45,98,139,132,108,44,137,25,30,167,75,44,44,112,224,15,7,12,108,208,0};
static const unsigned char precomputed_mGnP_ed25519_m_205[] = {92,237,199,133,245,117,54,115,211,97,22,14,239,203,90,78,137,77,209,184,7,164,181,231,101,204,254,108,185,9,161,57};
static const unsigned char precomputed_mGnP_ed25519_n_205[] = {229,194,241,187,240,85,31,241,8,27,107,112,42,149,42,151,219,112,226,18,75,29,170,89,62,10,193,103,162,22,62,77,174,176,188,253,200,208,45,252,80,228,248,154,93,110,32,136,109,206,120,81,121,123,182,54,234,227,20,185,8,33,94,231};
static const unsigned char precomputed_mGnP_ed25519_P_205[] = {59,214,195,53,132,229,207,187,49,198,64,174,162,142,160,26,20,185,105,4,177,178,190,21,28,215,211,7,3,121,39,198};
static const unsigned char precomputed_mGnP_ed25519_Q_206[] = {223,99,10,15,80,12,136,175,186,78,202,203,77,55,128,186,46,141,153,129,90,46,50,209,92,83,37,17,97,71,174,136,0};
static const unsigned char precomputed_mGnP_ed25519_m_206[] = {63,180,53,184,238,9,40,253,14,178,214,69,60,215,136,36,40,193,172,123,7,100,78,142,65,87,16,224,129,187,219,184};
static const unsigned char precomputed_mGnP_ed25519_n_206[] = {217,14,58,211,26,112,231,63,85,116,31,223,128,20,132,12,6,254,94,119,98,235,63,237,17,243,208,6,12,84,71,2,205,184,206,58,57,54,51,191,45,116,206,86,216,46,230,36,16,85,148,158,218,117,188,30,107,51,44,97,46,191,11,217};
static const unsigned char precomputed_mGnP_ed25519_P_206[] = {165,1,85,204,92,195,160,51,144,94,25,60,59,220,190,189,53,83,239,30,122,38,249,5,158,236,141,178,225,14,167,203};
static const unsigned char precomputed_mGnP_ed25519_Q_207[] = {7,226,229,121,219,1,69,163,157,234,153,155,116,164,105,100,204,236,238,68,221,194,115,28,120,91,129,20,12,129,194,204,0};
static const unsigned char precomputed_mGnP_ed25519_m_207[] = {138,18,134,249,243,115,255,231,69,235,212,107,231,147,203,186,225,11,7,67,241,119,47,123,101,169,147,82,121,57,148,240};
static const unsigned char precomputed_mGnP_ed25519_n_207[] = {80,152,218,3,109,117,203,246,7,252,99,27,24,236,82,18,96,197,225,175,239,50,105,124,160,51,41,226,16,152,79,208,149,67,40,177,146,49,68,201,224,235,131,213,120,75,13,254,155,42,183,146,87,23,28,234,118,245,203,112,150,115,29,60};
static const unsigned char precomputed_mGnP_ed25519_P_207[] = {88,81,251,2,207,106,39,128,151,6,28,147,198,137,136,250,160,252,133,169,145,168,218,72,34,12,204,148,17,234,154,208};
static const unsigned char precomputed_mGnP_ed25519_Q_208[] = {146,185,22,158,22,156,200,222,72,243,18,73,154,74,6,38,187,161,199,209,251,39,188,210,166,238,217,23,208,29,115,93,0};
static const unsigned char precomputed_mGnP_ed25519_m_208[] = {213,243,50,107,60,244,9,158,7,115,0,111,230,81,225,52,104,52,52,238,9,8,69,105,149,116,164,41,29,185,137,226};
static const unsigned char precomputed_mGnP_ed25519_n_208[] = {185,77,77,223,206,157,10,7,169,243,7,4,37,167,233,252,178,151,25,104,174,148,140,23,136,13,4,72,206,131,226,44,165,215,100,196,134,13,153,146,165,167,171,8,128,76,42,49,119,133,245,90,223,84,49,97,220,27,142,208,157,23,251,194};
static const unsigned char precomputed_mGnP_ed25519_P_208[] = {238,225,222,190,117,211,58,162,19,55,118,168,14,229,79,71,244,82,123,68,109,97,137,130,38,14,102,255,34,118,243,213};
static const unsigned char precomputed_mGnP_ed25519_Q_209[] = {220,20,252,235,233,155,5,174,46,223,217,163,86,123,197,228,116,137,70,218,144,179,140,238,49,184,97,96,222,242,172,41,0};
static const unsigned char precomputed_mGnP_ed25519_m_209[] = {255,163,130,223,111,130,158,202,61,207,126,239,83,125,118,42,168,207,92,167,47,201,47,170,129,190,65,236,220,232,197,170};
static const unsigned char precomputed_mGnP_ed25519_n_209[] = {219,140,78,5,84,69,165,203,45,58,107,145,62,194,32,73,189,116,185,110,20,199,99,31,58,66,197,229,75,200,197,133,51,219,54,78,128,93,6,137,77,14,100,66,151,134,27,213,90,198,96,39,242,22,42,105,60,94,117,244,79,199,39,161};
static const unsigned char precomputed_mGnP_ed25519_P_209[] = {116,42,148,68,23,204,156,70,174,248,50,174,62,189,211,94,76,60,4,17,71,103,132,33,105,19,78,144,215,223,83,214};
static const unsigned char precomputed_mGnP_ed25519_Q_210[] = {87,180,129,206,116,98,229,165,211,57,20,123,16,172,247,177,38,34,77,129,141,13,104,4,71,78,221,151,64,9,227,207,0};
static const unsigned char precomputed_mGnP_ed25519_m_210[] = {23,233,44,178,192,138,73,162,245,196,85,166,115,141,81,169,35,85,119,147,187,30,175,175,40,157,50,206,7,191,226,83};
static const unsigned char precomputed_mGnP_ed25519_n_210[] = {28,91,39,252,22,160,118,163,11,72,96,252,116,64,205,238,72,240,240,22,11,153,192,231,2,239,53,153,22,220,62,204,240,160,29,153,159,38,228,198,68,93,76,198,24,101,236,248,78,188,254,32,91,220,229,199,244,102,218,119,129,235,57,137};
static const unsigned char precomputed_mGnP_ed25519_P_210[] = {76,156,149,188,163,80,140,36,177,208,177,85,156,131,239,91,4,68,92,196,88,28,142,134,216,34,78,221,208,159,17,215};
static const unsigned char precomputed_mGnP_ed25519_Q_211[] = {138,83,62,171,164,228,152,62,149,33,204,90,73,129,157,187,205,251,174,188,1,90,163,25,164,67,106,197,228,67,103,131,0};
static const unsigned char precomputed_mGnP_ed25519_m_211[] = {226,55,127,198,136,90,204,69,180,89,226,77,183,200,95,195,170,140,56,51,251,18,103,97,230,20,97,255,108,242,37,43};
static const unsigned char precomputed_mGnP_ed25519_n_211[] = {8,215,69,175,190,91,61,154,122,188,236,45,218,42,35,188,55,59,206,194,92,29,27,241,147,4,140,121,93,96,72,23,67,229,224,219,230,60,46,25,83,233,159,20,124,204,145,179,136,202,51,245,64,167,192,22,154,38,117,172,168,176,210,57};
static const unsigned char precomputed_mGnP_ed25519_P_211[] = {139,202,181,227,103,99,103,9,81,107,188,27,164,116,79,159,216,139,8,179,208,79,37,87,110,212,142,176,25,99,210,216};
static const unsigned char precomputed_mGnP_ed25519_Q_212[] = {82,112,12,96,103,197,179,28,20,128,39,136,107,88,132,43,184,43,41,231,251,31,57,16,215,194,190,240,131,101,34,18,0};
static const unsigned char precomputed_mGnP_ed25519_m_212[] = {60,184,1,127,200,237,122,0,75,120,156,32,103,183,126,127,110,87,232,66,143,31,42,240,25,35,151,123,162,236,175,33};
static const unsigned char precomputed_mGnP_ed25519_n_212[] = {202,107,222,180,137,7,69,200,180,223,7,81,238,34,136,201,102,255,182,134,7,211,86,125,129,28,211,148,95,129,130,150,71,209,35,245,22,222,127,230,30,247,203,16,172,109,220,77,159,21,82,130,183,252,154,90,82,173,0,56,177,146,219,119};
static const unsigned char precomputed_mGnP_ed25519_P_212[] = {81,92,255,221,73,228,142,1,185,168,93,221,226,119,29,193,48,71,4,77,84,27,95,120,52,51,217,35,88,133,26,217};
static const unsigned char precomputed_mGnP_ed25519_Q_213[] = {228,191,234,206,207,194,2,143,218,110,155,104,57,184,134,79,67,238,190,112,250,40,246,2,130,207,114,57,33,127,128,171,0};
static const unsigned char precomputed_mGnP_ed25519_m_213[] = {252,201,68,1,94,213,176,96,2,5,141,152,116,97,229,211,48,91,19,106,57,152,28,37,95,100,130,157,229,50,118,70};
static const unsigned char precomputed_mGnP_ed25519_n_213[] = {18,225,215,0,251,197,98,192,148,176,44,68,37,77,147,79,188,61,22,146,140,204,205,95,240,3,105,182,83,84,13,206,185,123,112,245,253,240,35,197,155,190,163,197,206,193,131,44,95,34,255,100,122,58,49,171,31,125,147,252,246,218,178,147};
static const unsigned char precomputed_mGnP_ed25519_P_213[] = {182,156,86,236,201,64,95,215,117,54,216,131,185,176,83,160,222,174,131,178,241,17,60,108,57,200,140,182,155,46,54,217};
static const unsigned char precomputed_mGnP_ed25519_Q_214[] = {161,90,36,53,141,110,156,20,122,51,220,124,82,170,27,230,90,141,81,51,162,61,186,105,188,105,136,219,9,177,190,179,0};
static const unsigned char precomputed_mGnP_ed25519_m_214[] = {231,103,184,78,230,219,176,248,252,214,4,7,7,239,191,143,194,135,129,145,126,111,51,60,106,158,31,202,165,20,18,34};
static const unsigned char precomputed_mGnP_ed25519_n_214[] = {201,21,201,17,52,212,38,10,80,238,68,212,119,216,232,160,210,104,42,253,106,146,9,88,32,160,158,31,20,188,219,182,234,248,46,122,182,168,15,131,53,235,93,37,45,153,220,116,100,158,219,241,173,119,107,56,88,119,138,220,121,57,125,79};
static const unsigned char precomputed_mGnP_ed25519_P_214[] = {9,188,121,142,101,162,29,184,100,78,137,159,37,111,57,77,113,60,16,102,124,242,102,127,172,96,14,134,139,214,140,217};
static const unsigned char precomputed_mGnP_ed25519_Q_215[] = {3,94,55,1,159,2,144,103,7,54,238,41,106,185,84,26,82,215,247,0,224,206,147,124,2,12,94,9,220,41,21,113,0};
static const unsigned char precomputed_mGnP_ed25519_m_215[] = {11,246,230,84,240,242,160,187,249,208,38,128,61,151,57,85,111,124,235,186,87,72,100,114,45,9,151,119,75,247,171,180};
static const unsigned char precomputed_mGnP_ed25519_n_215[] = {63,227,207,135,56,61,10,92,82,205,66,150,195,234,161,81,162,85,218,182,11,108,144,35,109,57,149,115,58,207,172,254,138,212,231,103,182,143,6,242,123,120,24,229,87,76,167,155,164,139,187,71,195,9,5,101,228,204,87,22,154,16,54,177};
static const unsigned char precomputed_mGnP_ed25519_P_215[] = {68,49,61,40,119,1,237,10,222,249,20,18,173,202,76,112,101,244,115,26,3,110,95,3,175,58,158,206,228,224,69,221};
static const unsigned char precomputed_mGnP_ed25519_Q_216[] = {199,3,164,43,140,80,61,67,252,2,205,9,88,166,121,232,198,78,113,232,151,210,14,135,34,187,162,208,75,178,124,54,0};
static const unsigned char precomputed_mGnP_ed25519_m_216[] = {123,199,124,5,85,143,214,64,217,18,43,45,39,204,217,159,39,33,185,196,241,171,236,125,5,200,88,8,181,152,19,169};
static const unsigned char precomputed_mGnP_ed25519_n_216[] = {62,130,84,46,185,146,127,149,43,141,48,244,117,214,138,57,135,203,144,143,94,209,36,20,74,86,231,91,173,66,241,61,210,244,108,105,88,64,122,99,134,100,4,95,145,136,161,125,33,27,26,97,161,64,197,221,179,89,70,47,8,240,87,9};
static const unsigned char precomputed_mGnP_ed25519_P_216[] = {110,231,191,231,185,198,135,152,226,160,157,20,180,236,4,95,104,20,220,153,68,77,224,29,125,241,106,176,102,3,108,222};
static const unsigned char precomputed_mGnP_ed25519_Q_217[] = {144,167,68,89,193,115,3,57,150,193,215,228,142,146,187,195,182,13,35,165,206,236,185,148,20,101,65,138,166,145,41,67,0};
static const unsigned char precomputed_mGnP_ed25519_m_217[] = {86,12,0,74,231,236,29,181,68,80,19,137,173,200,54,76,103,209,118,93,159,195,175,8,143,147,18,55,200,169,181,54};
static const unsigned char precomputed_mGnP_ed25519_n_217[] = {131,82,74,109,156,216,73,104,21,80,164,21,153,27,202,143,174,42,126,131,9,141,217,137,171,0,152,112,129,50,131,16,245,163,226,243,52,54,254,196,82,132,209,45,219,75,21,180,6,90,82,50,215,82,182,139,148,29,205,6,145,73,225,7};
static const unsigned char precomputed_mGnP_ed25519_P_217[] = {175,196,110,247,30,28,103,111,47,204,216,96,129,4,55,151,114,121,86,203,7,249,208,248,173,147,50,247,229,196,88,225};
static const unsigned char precomputed_mGnP_ed25519_Q_218[] = {35,35,205,103,235,11,200,107,209,181,106,171,31,196,94,21,223,44,28,147,190,168,239,128,144,166,158,53,21,239,235,184,0};
static const unsigned char precomputed_mGnP_ed25519_m_218[] = {6,247,211,213,81,14,215,159,197,217,252,9,154,173,148,202,237,181,85,184,174,224,147,172,252,91,177,23,13,234,53,143};
static const unsigned char precomputed_mGnP_ed25519_n_218[] = {31,189,85,46,120,235,185,72,86,83,2,215,60,148,244,67,107,25,76,57,202,254,11,161,74,42,255,169,144,160,54,4,211,1,215,88,162,156,178,237,119,118,189,215,55,225,90,162,87,208,220,144,204,80,149,117,241,15,10,156,237,9,189,95};
static const unsigned char precomputed_mGnP_ed25519_P_218[] = {25,77,245,209,222,132,188,180,142,57,37,51,8,156,72,189,163,170,90,15,141,174,226,219,255,181,243,35,175,126,96,225};
static const unsigned char precomputed_mGnP_ed25519_Q_219[] = {210,175,83,242,204,216,185,214,0,117,34,62,223,145,219,10,120,30,212,212,149,103,66,7,172,52,103,245,174,61,248,82,0};
static const unsigned char precomputed_mGnP_ed25519_m_219[] = {32,196,186,12,241,6,125,112,184,252,58,3,243,4,108,132,27,11,79,253,187,157,30,89,207,110,210,33,90,120,30,75};
static const unsigned char precomputed_mGnP_ed25519_n_219[] = {22,233,36,77,152,106,18,224,247,125,69,231,202,47,119,217,150,135,56,107,123,4,174,152,140,30,253,77,231,132,105,60,153,33,183,79,194,42,38,161,60,132,35,58,5,86,33,209,26,6,56,94,250,147,122,235,254,107,219,253,149,199,223,171};
static const unsigned char precomputed_mGnP_ed25519_P_219[] = {170,98,56,164,72,174,110,232,61,139,156,208,254,101,181,175,151,86,215,57,110,193,214,63,2,135,171,215,210,20,245,225};
static const unsigned char precomputed_mGnP_ed25519_Q_220[] = {25,244,154,144,157,199,133,159,60,157,193,240,22,84,206,193,141,203,216,178,252,141,52,226,8,6,210,29,113,16,148,225,0};
static const unsigned char precomputed_mGnP_ed25519_m_220[] = {39,42,223,58,176,69,139,186,25,114,20,183,79,51,25,171,2,105,216,149,80,167,230,200,136,24,132,97,62,16,78,234};
static const unsigned char precomputed_mGnP_ed25519_n_220[] = {217,205,183,237,25,111,74,88,56,26,133,189,95,232,97,113,181,7,143,135,12,24,91,202,201,20,3,151,164,169,240,244,16,241,203,83,68,68,233,172,42,155,91,17,209,163,186,226,120,93,0,78,127,48,119,65,91,35,158,246,42,25,166,253};
static const unsigned char precomputed_mGnP_ed25519_P_220[] = {31,197,166,74,131,146,196,77,31,22,233,128,227,240,166,28,119,63,127,132,247,126,126,16,126,5,253,115,3,239,206,226};
static const unsigned char precomputed_mGnP_ed25519_Q_221[] = {23,191,194,22,148,166,227,27,30,97,0,222,234,91,50,29,121,36,234,116,245,144,249,101,95,120,5,35,198,48,3,15,0};
static const unsigned char precomputed_mGnP_ed25519_m_221[] = {222,49,39,101,35,154,168,68,8,225,127,249,6,101,78,4,80,95,130,20,2,99,92,153,167,132,117,241,233,40,139,29};
static const unsigned char precomputed_mGnP_ed25519_n_221[] = {70,8,121,86,214,95,183,13,153,166,125,182,114,171,19,193,183,197,254,10,250,30,11,136,24,87,161,150,41,229,128,235,0,81,246,60,155,8,159,20,167,67,169,116,5,159,168,8,95,78,159,24,213,188,233,219,154,230,86,221,148,186,250,8};
static const unsigned char precomputed_mGnP_ed25519_P_221[] = {69,106,177,228,109,125,112,168,162,247,211,94,144,52,79,60,108,23,19,11,146,34,37,84,243,205,47,160,105,187,209,226};
static const unsigned char precomputed_mGnP_ed25519_Q_222[] = {41,83,21,146,88,185,198,30,244,178,108,215,138,32,1,207,175,165,94,241,7,236,67,24,124,136,86,143,226,183,83,203,0};
static const unsigned char precomputed_mGnP_ed25519_m_222[] = {246,160,115,111,198,158,68,163,34,223,48,251,101,74,106,194,183,87,72,172,184,172,81,60,154,18,43,87,243,126,73,229};
static const unsigned char precomputed_mGnP_ed25519_n_222[] = {80,52,175,207,226,66,13,172,73,22,94,170,255,85,169,173,30,24,71,217,175,44,235,120,86,118,114,244,226,83,20,57,66,54,73,222,143,185,53,148,239,249,254,134,56,192,199,213,240,58,192,222,160,150,136,108,212,5,196,23,97,125,214,137};
static const unsigned char precomputed_mGnP_ed25519_P_222[] = {28,171,209,216,175,254,199,10,151,151,156,191,38,110,76,81,57,13,152,95,69,12,16,242,120,100,70,152,131,35,11,227};
static const unsigned char precomputed_mGnP_ed25519_Q_223[] = {251,74,33,48,141,14,131,64,221,144,162,40,157,123,205,79,188,203,169,171,127,135,65,62,70,57,68,207,173,140,150,124,0};
static const unsigned char precomputed_mGnP_ed25519_m_223[] = {204,119,228,209,134,144,69,104,82,98,196,54,140,244,56,111,248,203,155,115,246,117,66,247,45,220,137,74,153,164,144,139};
static const unsigned char precomputed_mGnP_ed25519_n_223[] = {34,28,32,188,19,79,105,28,217,120,58,105,155,5,240,84,212,112,53,96,181,196,75,226,194,255,39,52,228,133,93,15,248,125,74,175,65,110,142,200,240,85,203,228,180,175,14,241,111,51,170,182,38,79,199,122,159,197,215,128,222,203,173,33};
static const unsigned char precomputed_mGnP_ed25519_P_223[] = {81,189,38,89,68,73,35,175,82,161,183,179,3,172,11,122,32,165,68,13,82,166,61,232,24,57,169,104,75,75,179,230};
static const unsigned char precomputed_mGnP_ed25519_Q_224[] = {175,33,162,150,85,64,145,43,28,221,190,87,193,114,108,146,36,17,119,159,90,246,246,53,193,236,185,28,173,102,235,161,0};
static const unsigned char precomputed_mGnP_ed25519_m_224[] = {227,61,146,44,172,31,134,175,146,53,17,9,125,16,118,214,228,146,117,65,219,185,235,194,182,37,197,33,198,43,18,153};
static const unsigned char precomputed_mGnP_ed25519_n_224[] = {196,30,2,236,127,231,171,72,102,24,135,192,165,170,12,166,204,36,198,108,63,144,18,82,69,6,138,133,44,235,18,208,22,44,99,173,218,140,152,55,58,37,152,44,209,123,127,131,251,112,55,207,124,155,176,92,143,119,26,216,46,126,46,54};
static const unsigned char precomputed_mGnP_ed25519_P_224[] = {182,145,235,22,179,180,64,250,107,114,83,50,154,212,240,27,181,88,189,14,124,230,164,117,193,3,21,221,168,253,50,231};
static const unsigned char precomputed_mGnP_ed25519_Q_225[] = {59,36,194,168,201,220,196,70,67,10,222,249,45,198,10,44,106,250,35,112,163,206,167,154,189,93,76,44,66,228,100,161,1};
static const unsigned char precomputed_mGnP_ed25519_m_225[] = {99,161,87,12,20,66,189,241,16,138,226,166,105,111,71,39,253,156,198,223,3,208,49,126,63,86,51,21,153,90,166,3};
static const unsigned char precomputed_mGnP_ed25519_n_225[] = {168,126,130,120,92,49,253,62,221,48,72,21,60,167,54,196,57,7,79,167,208,175,156,24,174,178,119,212,168,242,112,57,7,235,20,34,19,227,213,81,48,203,64,68,240,212,189,49,219,226,149,140,165,28,65,199,164,251,223,206,28,32,92,143};
static const unsigned char precomputed_mGnP_ed25519_P_225[] = {176,79,79,215,176,10,153,157,240,165,119,165,163,42,33,167,29,129,169,168,188,121,206,135,66,47,164,94,59,253,205,235};
static const unsigned char precomputed_mGnP_ed25519_Q_226[] = {114,9,49,40,212,23,179,75,28,102,210,160,169,223,176,133,248,104,224,175,49,117,118,125,157,123,64,213,142,31,130,12,0};
static const unsigned char precomputed_mGnP_ed25519_m_226[] = {213,64,225,91,125,166,169,4,65,235,235,140,70,125,121,115,191,49,102,71,47,65,250,176,10,180,167,42,250,56,27,108};
static const unsigned char precomputed_mGnP_ed25519_n_226[] = {32,237,46,139,216,17,186,119,137,188,111,30,163,114,226,156,254,153,239,143,41,207,153,238,164,36,2,181,143,158,85,221,35,16,234,159,168,85,19,209,22,179,139,212,109,44,109,147,212,24,24,50,12,75,225,83,204,169,96,65,136,48,218,118};
static const unsigned char precomputed_mGnP_ed25519_P_226[] = {99,157,130,192,144,139,60,72,218,187,135,117,63,67,39,238,21,141,213,107,239,19,161,86,49,187,57,169,167,46,50,237};
static const unsigned char precomputed_mGnP_ed25519_Q_227[] = {42,171,2,7,246,166,55,178,44,119,67,67,62,24,56,206,211,215,209,199,5,51,88,121,55,84,165,31,100,239,175,84,0};
static const unsigned char precomputed_mGnP_ed25519_m_227[] = {179,170,4,90,121,97,71,167,146,73,173,136,244,210,168,186,220,147,232,58,80,93,177,158,126,22,125,38,94,94,158,242};
static const unsigned char precomputed_mGnP_ed25519_n_227[] = {40,218,149,81,94,146,168,65,8,150,28,186,227,251,74,223,107,69,146,38,73,140,219,28,123,123,1,99,159,13,238,223,76,207,86,54,169,68,1,60,248,46,83,162,220,123,16,128,128,64,135,132,25,101,247,241,63,134,234,24,53,35,136,28};
static const unsigned char precomputed_mGnP_ed25519_P_227[] = {180,23,106,112,61,77,216,79,186,60,11,118,13,16,103,15,42,32,83,250,44,57,204,198,78,199,253,119,146,172,3,250};
static const unsigned char precomputed_mGnP_ed25519_Q_228[] = {10,185,192,100,193,13,22,66,210,15,216,17,10,70,195,98,40,7,58,200,188,174,82,233,74,33,211,12,91,242,52,126,0};
static const unsigned char precomputed_mGnP_ed25519_m_228[] = {214,24,55,9,125,6,44,252,139,242,66,214,108,97,249,86,198,34,156,157,135,140,93,18,185,75,70,233,41,186,56,251};
static const unsigned char precomputed_mGnP_ed25519_n_228[] = {100,70,73,202,65,63,221,64,142,253,30,183,0,213,125,11,230,49,141,197,253,168,167,64,45,16,171,246,235,202,89,176,109,91,178,1,197,94,3,225,36,7,224,202,116,120,225,226,192,121,201,200,144,232,117,207,27,11,52,172,181,18,151,85};
static const unsigned char precomputed_mGnP_ed25519_P_228[] = {246,62,201,197,215,170,104,159,210,158,46,56,180,16,88,31,190,213,165,127,255,80,20,248,96,9,223,108,60,26,11,250};
static const unsigned char precomputed_mGnP_ed25519_Q_229[] = {156,2,163,240,192,93,137,199,248,250,21,15,159,122,156,90,25,108,170,247,81,138,7,189,83,66,214,106,240,54,66,232,0};
static const unsigned char precomputed_mGnP_ed25519_m_229[] = {126,108,4,175,196,149,87,41,92,161,48,162,107,127,253,179,38,16,101,26,161,179,212,185,156,157,51,219,249,64,218,20};
static const unsigned char precomputed_mGnP_ed25519_n_229[] = {110,247,15,160,173,143,29,98,33,158,214,211,230,168,51,179,145,82,220,48,245,5,198,43,47,201,75,89,228,209,17,151,241,122,221,103,29,248,111,175,79,217,162,187,15,167,147,226,223,86,177,86,7,173,206,35,128,178,93,205,187,4,85,40};
static const unsigned char precomputed_mGnP_ed25519_P_229[] = {239,19,109,220,255,224,30,59,97,20,253,177,54,40,172,36,207,251,146,132,101,137,195,105,75,155,185,156,11,234,91,250};
static const unsigned char precomputed_mGnP_ed25519_Q_230[] = {236,18,162,230,26,28,181,47,92,243,181,213,140,35,191,229,20,250,118,64,147,146,108,21,29,13,151,245,187,145,214,73,0};
static const unsigned char precomputed_mGnP_ed25519_m_230[] = {40,243,177,97,188,241,248,61,5,108,47,235,75,145,155,217,156,130,27,131,172,88,72,55,28,249,68,69,56,62,118,238};
static const unsigned char precomputed_mGnP_ed25519_n_230[] = {35,193,250,135,44,212,74,90,178,24,47,120,195,50,130,58,229,154,2,218,140,49,213,66,67,234,54,142,204,49,56,108,25,51,207,130,229,86,34,57,207,89,195,93,220,53,16,181,100,230,242,57,198,36,184,105,66,205,149,116,122,15,86,176};
static const unsigned char precomputed_mGnP_ed25519_P_230[] = {29,21,207,61,161,253,57,233,159,131,233,236,31,111,26,48,33,50,187,28,71,206,175,59,55,143,249,117,160,119,245,250};
static const unsigned char precomputed_mGnP_ed25519_Q_231[] = {190,68,204,69,229,214,239,30,153,193,35,157,226,239,225,120,25,174,74,29,238,136,100,124,106,17,82,226,73,187,211,20,0};
static const unsigned char precomputed_mGnP_ed25519_m_231[] = {3,163,97,215,119,68,20,21,129,249,34,94,134,211,106,245,154,180,36,99,138,5,93,83,179,231,30,60,45,187,159,208};
static const unsigned char precomputed_mGnP_ed25519_n_231[] = {252,25,214,248,57,106,26,57,18,120,222,88,72,128,132,203,29,69,199,252,48,93,125,1,226,150,251,33,50,255,234,35,74,147,172,144,12,110,118,181,157,163,182,254,217,106,13,224,164,143,82,231,240,9,150,120,29,31,145,112,206,59,232,74};
static const unsigned char precomputed_mGnP_ed25519_P_231[] = {150,161,67,40,164,154,114,122,147,65,34,174,195,86,255,45,139,28,69,231,240,129,82,161,24,231,190,9,96,57,113,251};
static const unsigned char precomputed_mGnP_ed25519_Q_232[] = {190,35,37,39,77,143,53,98,17,237,222,54,77,242,166,57,115,92,236,44,62,174,237,140,239,65,248,104,41,65,30,111,0};
static const unsigned char precomputed_mGnP_ed25519_m_232[] = {228,238,53,22,156,231,245,246,48,215,205,22,222,15,161,187,214,191,149,51,96,105,137,17,146,235,94,118,198,201,185,192};
static const unsigned char precomputed_mGnP_ed25519_n_232[] = {57,174,130,202,195,172,162,247,173,6,57,143,182,197,132,91,223,68,7,202,151,153,250,41,88,173,42,138,54,202,153,211,63,246,223,21,179,154,98,63,80,108,19,237,3,65,249,81,165,42,229,63,186,211,221,213,144,94,164,101,52,81,198,248};
static const unsigned char precomputed_mGnP_ed25519_P_232[] = {192,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_233[] = {232,234,160,8,92,243,54,161,222,76,228,225,185,75,37,106,124,0,79,153,141,102,6,216,92,150,89,140,43,118,196,64,0};
static const unsigned char precomputed_mGnP_ed25519_m_233[] = {181,92,130,12,107,166,241,91,64,73,252,9,166,113,49,27,189,205,145,18,118,188,2,170,249,41,224,232,84,215,87,195};
static const unsigned char precomputed_mGnP_ed25519_n_233[] = {57,43,110,221,229,5,165,60,106,201,77,88,176,136,76,239,133,43,87,58,151,113,79,102,226,110,140,151,150,137,202,175,67,74,235,68,53,104,66,75,105,252,96,247,81,210,1,223,164,52,140,13,225,162,49,161,104,73,126,44,39,55,180,184};
static const unsigned char precomputed_mGnP_ed25519_P_233[] = {193,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_234[] = {197,121,33,225,12,194,117,115,248,227,67,153,25,61,94,204,79,105,91,104,224,16,84,203,177,138,189,233,131,254,10,98,0};
static const unsigned char precomputed_mGnP_ed25519_m_234[] = {44,164,82,238,42,239,82,245,14,133,17,109,18,202,163,118,251,231,230,215,28,83,32,103,178,44,254,232,175,63,248,249};
static const unsigned char precomputed_mGnP_ed25519_n_234[] = {145,240,119,47,131,242,187,0,64,208,92,64,100,202,11,239,173,98,30,150,208,137,115,168,117,73,229,69,36,178,252,67,140,197,81,52,223,122,155,215,201,71,77,239,177,66,142,27,119,38,50,164,62,63,185,32,8,26,235,132,52,242,176,6};
static const unsigned char precomputed_mGnP_ed25519_P_234[] = {194,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_235[] = {208,77,232,76,135,123,240,130,253,231,215,253,203,127,129,57,238,35,69,224,221,210,15,154,221,69,170,14,189,225,193,70,0};
static const unsigned char precomputed_mGnP_ed25519_m_235[] = {139,122,221,214,126,124,228,76,144,138,1,132,158,140,119,178,27,38,40,141,119,220,240,248,16,154,13,150,209,39,47,98};
static const unsigned char precomputed_mGnP_ed25519_n_235[] = {98,91,204,191,253,254,221,229,8,163,12,51,234,1,55,251,20,245,103,148,119,39,58,170,107,90,148,161,130,109,101,197,48,109,231,228,52,215,129,98,42,74,224,200,154,108,220,84,68,176,41,64,10,16,235,190,31,20,187,81,85,17,147,160};
static const unsigned char precomputed_mGnP_ed25519_P_235[] = {195,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_236[] = {71,165,71,49,221,111,50,150,144,109,166,113,59,147,170,5,96,2,14,67,19,6,230,43,156,217,111,37,7,21,9,42,0};
static const unsigned char precomputed_mGnP_ed25519_m_236[] = {172,103,65,171,227,157,83,82,218,213,148,215,246,22,151,218,205,67,54,92,30,212,77,199,62,164,100,32,23,211,138,230};
static const unsigned char precomputed_mGnP_ed25519_n_236[] = {174,103,43,172,245,59,42,159,77,22,126,7,135,239,60,159,232,253,153,233,13,246,80,195,227,202,10,117,182,87,70,27,61,71,242,34,107,44,27,115,107,136,18,51,180,126,116,247,143,226,97,250,165,6,100,229,35,26,5,74,201,89,179,163};
static const unsigned char precomputed_mGnP_ed25519_P_236[] = {196,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_237[] = {62,210,131,16,27,120,66,42,7,217,158,191,234,49,8,252,214,229,103,30,142,26,165,222,165,248,29,3,152,44,160,231,0};
static const unsigned char precomputed_mGnP_ed25519_m_237[] = {97,171,134,102,99,61,106,216,114,100,117,206,206,171,81,16,241,114,38,89,92,115,141,66,218,15,30,224,90,249,106,91};
static const unsigned char precomputed_mGnP_ed25519_n_237[] = {45,209,204,223,89,219,38,253,214,42,25,169,12,132,117,18,33,16,208,207,25,208,254,178,24,28,124,111,56,208,174,181,233,231,1,70,30,147,131,105,128,87,105,109,183,14,13,107,192,61,124,183,193,113,88,188,165,49,165,32,143,108,62,228};
static const unsigned char precomputed_mGnP_ed25519_P_237[] = {197,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_238[] = {155,44,143,156,178,35,187,10,204,170,176,150,171,225,64,69,227,179,174,96,238,148,144,58,55,48,94,69,238,147,29,74,0};
static const unsigned char precomputed_mGnP_ed25519_m_238[] = {138,103,203,238,58,207,32,253,113,254,133,92,65,11,230,73,120,229,13,85,221,53,245,247,238,169,66,213,202,234,231,147};
static const unsigned char precomputed_mGnP_ed25519_n_238[] = {231,156,170,159,6,15,151,219,172,83,236,248,154,9,17,84,215,157,163,110,158,125,184,79,76,45,179,87,35,181,76,200,153,224,184,50,241,178,66,117,138,203,119,219,135,57,121,49,232,67,145,171,225,71,166,239,238,42,107,197,154,90,173,236};
static const unsigned char precomputed_mGnP_ed25519_P_238[] = {198,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_239[] = {164,200,251,80,141,175,165,46,168,58,119,86,99,254,16,153,98,6,35,244,121,39,59,73,239,253,210,184,79,71,53,158,0};
static const unsigned char precomputed_mGnP_ed25519_m_239[] = {218,76,66,170,147,200,170,75,155,167,10,189,170,22,196,241,106,132,209,227,203,150,31,48,178,164,201,92,81,104,106,167};
static const unsigned char precomputed_mGnP_ed25519_n_239[] = {50,247,253,97,73,246,90,67,42,143,253,50,38,9,230,53,186,232,66,247,94,143,45,168,207,37,4,228,119,244,115,12,238,165,59,212,215,125,9,184,64,144,19,122,151,36,172,160,129,76,53,223,121,31,78,234,176,100,182,26,134,211,242,154};
static const unsigned char precomputed_mGnP_ed25519_P_239[] = {199,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_240[] = {24,108,121,29,123,18,89,201,0,22,250,171,43,248,34,210,128,201,131,183,216,30,158,106,204,43,145,12,36,222,113,78,0};
static const unsigned char precomputed_mGnP_ed25519_m_240[] = {243,143,194,112,28,67,41,87,79,10,168,107,26,139,151,78,8,189,78,124,194,145,154,253,244,136,170,29,25,64,53,192};
static const unsigned char precomputed_mGnP_ed25519_n_240[] = {30,101,15,157,189,172,165,131,240,34,215,194,23,151,0,228,250,214,203,172,245,110,23,66,130,171,80,80,17,46,113,145,157,148,51,135,124,34,189,88,10,197,201,138,33,47,32,165,44,91,6,63,68,103,40,69,104,82,53,109,142,9,50,142};
static const unsigned char precomputed_mGnP_ed25519_P_240[] = {200,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_241[] = {132,157,198,91,20,211,87,216,89,127,89,41,118,214,90,146,63,11,117,208,85,87,142,53,171,87,129,97,66,122,132,222,0};
static const unsigned char precomputed_mGnP_ed25519_m_241[] = {174,18,122,54,137,79,164,228,135,9,84,83,151,25,211,186,141,111,71,235,102,253,20,165,184,13,78,40,164,177,50,231};
static const unsigned char precomputed_mGnP_ed25519_n_241[] = {208,55,1,142,177,235,117,146,32,1,150,1,42,245,168,187,122,149,231,1,100,59,219,132,208,25,115,168,77,66,168,135,122,123,100,86,182,153,24,208,130,205,229,210,171,213,103,99,116,89,14,237,182,89,68,34,94,119,157,158,167,227,146,7};
static const unsigned char precomputed_mGnP_ed25519_P_241[] = {201,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_242[] = {80,85,196,250,69,253,94,223,32,90,241,226,45,250,73,99,141,188,4,112,61,32,75,42,156,75,140,2,246,159,66,25,0};
static const unsigned char precomputed_mGnP_ed25519_m_242[] = {30,17,120,242,0,80,77,49,66,107,5,112,128,154,240,198,176,213,128,140,56,203,186,135,28,0,71,111,105,18,237,80};
static const unsigned char precomputed_mGnP_ed25519_n_242[] = {174,19,225,239,99,235,171,67,252,203,111,89,70,191,78,160,67,207,89,45,97,65,157,181,192,71,30,17,157,88,250,157,72,233,119,250,17,155,185,245,6,29,195,231,179,75,99,105,120,180,238,22,108,23,209,64,68,191,196,202,222,102,113,91};
static const unsigned char precomputed_mGnP_ed25519_P_242[] = {202,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_243[] = {79,245,189,181,161,97,113,252,200,68,132,187,222,179,160,96,166,154,242,93,125,45,222,205,189,185,51,126,111,128,252,91,0};
static const unsigned char precomputed_mGnP_ed25519_m_243[] = {29,187,15,26,40,78,231,104,185,76,15,244,127,88,247,237,242,244,38,132,203,0,133,252,9,118,49,187,235,23,191,253};
static const unsigned char precomputed_mGnP_ed25519_n_243[] = {223,49,126,77,20,195,177,169,138,58,93,60,156,173,246,233,210,113,14,106,67,65,140,135,8,90,113,120,71,78,34,183,245,238,77,36,212,207,135,141,84,181,82,66,214,76,198,248,174,127,112,28,75,105,80,150,56,158,105,196,41,92,26,38};
static const unsigned char precomputed_mGnP_ed25519_P_243[] = {203,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_244[] = {225,241,204,216,255,203,85,53,148,16,104,88,19,180,44,163,88,64,122,170,181,223,80,170,111,21,224,11,156,76,6,181,0};
static const unsigned char precomputed_mGnP_ed25519_m_244[] = {124,24,168,235,35,244,248,20,181,139,58,235,120,77,155,34,172,199,90,85,50,139,80,200,252,210,57,192,114,15,82,109};
static const unsigned char precomputed_mGnP_ed25519_n_244[] = {16,229,152,52,91,209,227,123,46,97,82,249,78,206,57,87,41,214,101,205,226,127,54,24,235,212,228,60,244,83,88,234,159,252,118,223,17,234,9,2,161,13,8,169,17,46,229,242,145,175,90,30,26,125,209,30,65,127,25,89,58,121,55,174};
static const unsigned char precomputed_mGnP_ed25519_P_244[] = {204,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_245[] = {198,247,142,219,73,90,65,222,13,74,42,233,166,233,50,193,57,255,128,222,34,192,93,92,71,213,58,112,52,152,118,64,0};
static const unsigned char precomputed_mGnP_ed25519_m_245[] = {184,173,65,165,231,90,124,51,54,198,158,186,67,210,230,142,102,80,73,246,77,253,26,213,180,129,220,199,200,228,251,149};
static const unsigned char precomputed_mGnP_ed25519_n_245[] = {21,231,105,231,44,71,76,74,203,41,174,117,239,113,119,38,152,16,98,124,223,129,88,212,30,25,45,96,14,107,224,80,22,170,235,84,18,247,111,83,218,61,155,108,29,234,51,234,241,183,145,134,199,148,53,82,192,172,153,114,30,6,148,76};
static const unsigned char precomputed_mGnP_ed25519_P_245[] = {205,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_246[] = {66,204,116,163,189,198,214,73,223,140,42,159,2,82,125,14,78,4,176,152,193,86,58,229,176,33,212,84,47,93,221,103,0};
static const unsigned char precomputed_mGnP_ed25519_m_246[] = {16,252,233,198,84,113,59,241,120,91,52,99,140,159,193,65,155,74,156,25,234,87,108,152,137,47,5,147,102,156,95,73};
static const unsigned char precomputed_mGnP_ed25519_n_246[] = {148,2,167,106,31,108,121,135,161,188,115,241,153,172,42,97,175,5,48,2,14,186,111,167,215,20,4,168,179,193,8,68,189,12,52,139,205,215,253,164,41,234,118,169,183,62,120,117,2,54,189,83,88,230,43,250,157,170,172,75,128,19,225,134};
static const unsigned char precomputed_mGnP_ed25519_P_246[] = {206,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_247[] = {112,12,82,45,212,169,254,58,217,11,206,128,137,26,186,245,188,198,101,145,76,62,42,170,160,75,242,45,245,192,31,11,0};
static const unsigned char precomputed_mGnP_ed25519_m_247[] = {175,203,195,215,186,181,148,98,57,226,154,204,141,235,79,124,53,47,53,177,65,45,1,181,238,48,18,68,167,27,91,207};
static const unsigned char precomputed_mGnP_ed25519_n_247[] = {23,235,7,102,40,138,93,190,228,0,160,65,16,41,89,206,240,6,32,182,151,228,184,3,84,222,243,46,137,238,116,31,178,33,32,23,167,25,46,128,40,149,188,218,205,142,131,142,127,55,55,162,174,155,179,198,195,188,173,179,130,111,91,229};
static const unsigned char precomputed_mGnP_ed25519_P_247[] = {207,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_248[] = {16,97,169,139,87,198,116,75,23,241,99,82,210,232,198,16,136,14,156,247,110,104,8,30,113,250,112,93,145,44,155,36,1};
static const unsigned char precomputed_mGnP_ed25519_m_248[] = {11,56,76,200,39,233,184,108,16,95,39,1,57,0,40,252,19,59,66,111,175,151,176,139,226,84,251,126,98,194,178,5};
static const unsigned char precomputed_mGnP_ed25519_n_248[] = {189,128,246,208,219,162,86,50,58,105,113,118,28,126,174,187,81,99,143,98,250,31,26,77,200,23,196,8,39,110,79,171,168,79,93,108,199,246,186,213,81,156,243,35,231,15,180,80,234,113,190,248,218,112,200,196,196,235,231,213,113,91,107,131};
static const unsigned char precomputed_mGnP_ed25519_P_248[] = {208,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_249[] = {82,235,197,221,58,177,215,157,160,234,29,145,15,243,176,121,23,123,138,235,49,161,65,147,194,57,120,231,192,34,212,68,0};
static const unsigned char precomputed_mGnP_ed25519_m_249[] = {252,149,250,226,164,51,189,101,173,248,254,3,87,210,36,92,239,206,135,75,169,112,79,17,50,45,78,210,141,42,243,185};
static const unsigned char precomputed_mGnP_ed25519_n_249[] = {216,6,153,30,119,43,161,143,94,58,213,122,144,21,151,19,4,44,53,14,85,183,83,79,109,61,243,213,28,172,137,215,193,2,233,184,170,220,117,4,244,190,250,31,51,111,87,177,114,42,214,113,118,233,43,85,244,240,114,168,109,85,31,168};
static const unsigned char precomputed_mGnP_ed25519_P_249[] = {209,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_250[] = {63,58,168,61,54,143,174,251,141,222,44,163,212,255,42,27,173,48,233,60,1,33,174,138,112,38,5,8,242,170,27,130,0};
static const unsigned char precomputed_mGnP_ed25519_m_250[] = {36,24,246,0,84,54,230,80,131,5,222,167,36,217,241,205,175,145,15,50,150,96,88,16,86,226,122,75,40,22,22,136};
static const unsigned char precomputed_mGnP_ed25519_n_250[] = {31,105,14,223,25,63,94,242,23,113,182,211,84,176,99,225,13,233,177,228,149,57,187,47,37,92,13,148,39,223,160,127,20,45,128,210,91,79,144,17,28,151,37,78,221,193,78,89,148,190,222,32,209,187,210,216,32,246,200,72,245,135,82,242};
static const unsigned char precomputed_mGnP_ed25519_P_250[] = {210,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_251[] = {128,182,122,216,4,148,92,90,129,15,121,127,190,243,189,221,252,246,92,37,158,73,228,104,74,159,201,89,55,110,120,16,0};
static const unsigned char precomputed_mGnP_ed25519_m_251[] = {241,182,198,252,143,228,121,7,130,249,24,56,134,195,183,225,168,127,1,173,65,155,154,136,43,165,105,154,254,176,132,208};
static const unsigned char precomputed_mGnP_ed25519_n_251[] = {118,153,217,101,129,47,177,126,188,230,81,218,164,92,44,14,195,41,25,86,148,100,240,82,110,248,52,153,142,137,134,189,80,81,135,189,238,82,172,91,114,183,37,205,3,172,97,248,202,83,44,46,103,87,110,40,40,62,75,176,254,225,89,222};
static const unsigned char precomputed_mGnP_ed25519_P_251[] = {211,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_252[] = {58,156,110,9,80,101,157,77,247,119,74,79,172,89,124,84,44,158,234,83,137,44,158,74,29,240,253,241,176,203,241,145,0};
static const unsigned char precomputed_mGnP_ed25519_m_252[] = {153,218,128,83,221,40,239,133,220,187,215,210,136,151,3,51,222,219,225,100,207,89,54,211,116,0,100,123,154,46,66,102};
static const unsigned char precomputed_mGnP_ed25519_n_252[] = {64,236,220,69,109,44,49,144,204,200,200,199,235,251,164,226,249,127,149,49,40,154,206,80,155,116,18,46,71,32,57,154,226,140,228,12,9,103,96,21,72,31,131,227,186,72,107,236,12,246,153,155,158,172,74,5,38,140,238,227,139,90,212,9};
static const unsigned char precomputed_mGnP_ed25519_P_252[] = {212,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_253[] = {215,138,169,142,137,200,172,15,131,147,146,165,8,215,97,182,80,240,186,243,172,2,78,236,187,192,20,182,199,20,123,92,0};
static const unsigned char precomputed_mGnP_ed25519_m_253[] = {24,152,129,206,15,18,77,228,176,74,181,191,156,18,76,181,246,18,78,36,89,226,252,247,204,90,79,122,159,255,177,143};
static const unsigned char precomputed_mGnP_ed25519_n_253[] = {32,4,111,207,85,246,33,102,204,70,209,221,97,120,208,86,232,185,48,34,195,39,26,175,103,31,143,20,91,122,41,11,59,184,191,206,96,246,86,73,149,30,49,83,131,132,188,124,156,207,216,43,246,117,200,16,201,88,144,134,177,185,46,158};
static const unsigned char precomputed_mGnP_ed25519_P_253[] = {213,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_254[] = {20,203,245,30,250,36,252,204,38,57,201,16,83,133,239,160,45,188,186,205,129,245,35,9,194,178,149,81,66,148,242,205,0};
static const unsigned char precomputed_mGnP_ed25519_m_254[] = {145,222,2,114,39,87,28,15,121,166,195,84,159,44,198,181,141,139,39,189,164,210,106,16,158,207,193,98,89,68,48,152};
static const unsigned char precomputed_mGnP_ed25519_n_254[] = {82,46,166,167,200,0,30,35,158,165,198,238,150,104,23,94,99,48,179,164,77,240,111,212,123,234,130,242,49,104,7,149,165,248,79,102,204,252,84,245,116,24,132,193,65,242,46,166,245,250,85,16,13,163,69,69,251,148,127,16,246,87,138,52};
static const unsigned char precomputed_mGnP_ed25519_P_254[] = {214,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_255[] = {13,88,203,40,233,19,57,252,246,231,216,85,148,0,35,17,209,216,176,56,182,7,24,221,84,118,200,186,135,102,193,67,0};
static const unsigned char precomputed_mGnP_ed25519_m_255[] = {43,27,215,159,148,76,159,27,121,254,242,220,133,91,183,126,82,176,131,64,30,51,52,218,44,223,4,37,120,32,101,84};
static const unsigned char precomputed_mGnP_ed25519_n_255[] = {245,232,216,44,174,188,125,199,173,57,11,111,151,62,201,81,205,223,144,222,94,222,15,93,232,144,125,0,32,56,219,222,112,216,220,250,160,134,102,53,154,189,36,219,124,117,185,36,207,101,14,94,98,220,255,38,81,148,34,132,248,85,125,128};
static const unsigned char precomputed_mGnP_ed25519_P_255[] = {215,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_256[] = {30,164,131,247,247,116,113,65,227,89,53,151,189,111,118,64,152,104,161,222,191,243,211,115,28,70,80,35,196,65,57,135,0};
static const unsigned char precomputed_mGnP_ed25519_m_256[] = {168,111,137,210,250,183,89,128,123,86,82,128,94,40,140,35,245,24,247,137,161,147,69,223,177,97,248,183,65,153,234,53};
static const unsigned char precomputed_mGnP_ed25519_n_256[] = {67,47,45,242,30,144,209,112,1,187,205,86,147,211,120,233,198,113,232,115,148,89,195,176,225,118,223,224,217,35,55,249,115,108,134,237,66,90,149,171,118,11,148,112,125,169,59,79,147,187,64,51,52,64,127,224,184,185,122,155,228,40,164,223};
static const unsigned char precomputed_mGnP_ed25519_P_256[] = {216,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_257[] = {181,240,55,244,182,164,166,157,89,89,224,13,231,191,223,132,125,225,80,109,168,42,231,163,96,226,93,231,204,228,128,135,0};
static const unsigned char precomputed_mGnP_ed25519_m_257[] = {140,134,234,252,248,114,253,216,18,237,27,115,63,240,65,42,121,139,206,24,45,47,3,43,92,156,6,254,168,31,219,172};
static const unsigned char precomputed_mGnP_ed25519_n_257[] = {200,211,214,156,145,122,173,119,182,126,153,4,40,74,164,53,177,7,66,35,92,168,88,106,159,134,228,151,134,71,153,182,186,88,138,179,93,199,8,98,119,7,106,211,37,203,207,86,199,19,79,0,88,106,105,129,108,14,79,238,248,5,80,80};
static const unsigned char precomputed_mGnP_ed25519_P_257[] = {217,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_258[] = {53,232,219,238,243,176,146,221,153,68,43,106,117,194,171,138,125,48,71,72,99,69,30,94,235,154,148,136,36,99,104,179,0};
static const unsigned char precomputed_mGnP_ed25519_m_258[] = {221,229,215,242,40,207,209,209,204,234,50,253,80,68,121,90,14,153,108,255,41,7,228,99,81,75,131,146,191,76,158,122};
static const unsigned char precomputed_mGnP_ed25519_n_258[] = {56,173,245,95,27,126,171,66,235,98,248,209,43,65,104,112,157,175,85,51,13,148,253,199,70,215,129,7,246,107,181,56,165,165,5,159,249,74,29,113,186,89,236,255,9,117,207,104,154,223,187,153,107,46,218,219,195,120,35,22,254,247,134,99};
static const unsigned char precomputed_mGnP_ed25519_P_258[] = {218,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_259[] = {235,96,246,82,173,40,188,73,224,49,96,139,37,47,220,209,94,213,139,58,253,178,92,43,76,149,252,114,140,55,90,166,0};
static const unsigned char precomputed_mGnP_ed25519_m_259[] = {122,151,17,172,100,37,239,70,0,69,96,171,213,9,80,15,60,174,145,99,253,210,79,202,86,70,153,151,83,62,232,223};
static const unsigned char precomputed_mGnP_ed25519_n_259[] = {189,181,92,6,239,201,182,204,32,105,23,226,16,116,125,76,98,61,8,66,187,236,63,102,158,143,109,160,178,182,103,160,135,179,2,130,66,182,17,162,203,77,124,210,89,56,131,202,235,234,109,179,143,176,35,243,54,29,24,139,201,18,237,88};
static const unsigned char precomputed_mGnP_ed25519_P_259[] = {219,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_260[] = {94,102,18,22,192,243,176,241,136,198,106,204,0,221,136,33,211,181,112,41,14,159,144,225,48,160,171,63,108,131,79,77,0};
static const unsigned char precomputed_mGnP_ed25519_m_260[] = {55,169,184,243,37,158,140,197,152,61,37,149,246,232,177,126,135,238,8,6,119,194,84,33,232,236,167,245,200,118,128,75};
static const unsigned char precomputed_mGnP_ed25519_n_260[] = {47,109,230,83,88,70,102,154,204,198,0,84,63,148,162,108,9,89,191,157,97,181,14,200,117,186,233,213,157,65,227,78,110,11,177,52,29,2,75,110,138,46,225,145,75,133,47,209,242,117,255,255,252,188,228,133,4,222,178,164,86,36,245,198};
static const unsigned char precomputed_mGnP_ed25519_P_260[] = {220,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_261[] = {58,198,253,34,117,240,205,250,186,31,242,221,186,254,182,188,93,213,61,5,78,6,211,226,20,55,76,163,127,223,196,107,0};
static const unsigned char precomputed_mGnP_ed25519_m_261[] = {86,163,214,52,251,144,171,195,41,30,200,28,193,28,78,255,174,100,115,190,128,246,65,10,221,12,246,156,86,194,202,243};
static const unsigned char precomputed_mGnP_ed25519_n_261[] = {129,248,69,248,183,248,157,253,233,226,209,179,189,228,232,209,217,64,45,47,74,13,85,106,173,132,33,236,212,215,45,180,167,215,181,179,217,185,19,193,170,13,141,244,133,23,21,71,241,249,66,148,36,121,145,218,247,151,181,219,79,156,23,40};
static const unsigned char precomputed_mGnP_ed25519_P_261[] = {221,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_262[] = {163,111,57,221,35,61,216,135,132,215,209,146,150,248,156,247,115,24,23,73,135,76,204,16,72,169,204,68,219,26,6,2,0};
static const unsigned char precomputed_mGnP_ed25519_m_262[] = {225,161,48,213,170,114,180,124,103,36,171,175,33,166,187,184,14,1,99,127,177,99,4,42,48,28,230,109,116,68,30,163};
static const unsigned char precomputed_mGnP_ed25519_n_262[] = {44,123,136,223,244,234,123,211,24,156,210,126,139,9,183,115,176,190,238,35,83,96,2,121,91,161,77,178,178,236,30,91,27,15,60,157,45,80,101,11,50,156,209,165,20,52,105,81,240,42,76,124,123,199,97,168,4,71,117,249,227,34,132,159};
static const unsigned char precomputed_mGnP_ed25519_P_262[] = {222,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_263[] = {183,66,185,25,239,245,38,189,205,145,87,151,18,213,63,161,228,156,38,71,243,84,20,100,89,79,80,3,191,12,19,211,0};
static const unsigned char precomputed_mGnP_ed25519_m_263[] = {165,52,39,93,78,59,6,153,160,81,240,187,231,139,4,129,75,228,32,162,167,85,25,223,49,132,8,116,7,24,192,102};
static const unsigned char precomputed_mGnP_ed25519_n_263[] = {129,40,162,240,217,149,138,189,149,115,86,75,224,32,173,199,101,252,194,198,87,87,192,145,176,119,125,31,227,189,168,101,193,177,49,70,121,74,159,99,243,142,201,51,76,184,70,17,223,4,145,136,19,173,255,108,83,42,255,32,107,138,8,193};
static const unsigned char precomputed_mGnP_ed25519_P_263[] = {223,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_264[] = {165,219,225,130,241,216,20,249,198,112,215,14,248,238,170,91,39,90,22,212,201,131,179,180,170,69,0,42,221,92,41,169,0};
static const unsigned char precomputed_mGnP_ed25519_m_264[] = {46,148,250,208,189,152,75,183,204,6,16,128,254,109,52,228,5,81,136,243,3,122,122,221,7,94,117,161,224,170,133,29};
static const unsigned char precomputed_mGnP_ed25519_n_264[] = {134,188,248,120,169,48,214,35,17,119,219,34,27,50,165,117,122,172,5,49,174,46,233,69,206,193,80,111,42,254,209,15,253,226,36,248,212,21,209,87,114,201,240,89,141,236,15,144,59,96,26,225,24,206,218,208,240,135,96,36,5,227,22,233};
static const unsigned char precomputed_mGnP_ed25519_P_264[] = {224,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_265[] = {55,125,223,79,223,218,60,45,178,50,199,200,81,45,119,47,167,168,153,237,46,42,30,149,37,40,26,2,153,137,177,34,0};
static const unsigned char precomputed_mGnP_ed25519_m_265[] = {95,111,47,84,205,185,39,87,160,182,233,31,237,137,13,112,138,12,184,191,86,244,144,225,35,228,147,188,173,213,23,203};
static const unsigned char precomputed_mGnP_ed25519_n_265[] = {101,27,214,108,4,187,138,220,26,139,245,139,219,119,132,37,220,220,230,161,190,141,105,50,213,227,128,165,194,65,215,211,228,159,51,70,194,236,131,100,21,149,22,88,162,103,48,114,59,10,214,67,180,167,35,240,33,119,236,127,244,78,159,28};
static const unsigned char precomputed_mGnP_ed25519_P_265[] = {225,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_266[] = {204,33,182,22,8,190,85,19,220,2,226,71,40,81,44,37,125,44,206,33,223,144,166,187,16,226,44,156,218,108,156,123,0};
static const unsigned char precomputed_mGnP_ed25519_m_266[] = {175,227,218,66,9,208,36,171,143,181,29,176,110,193,223,115,204,115,239,203,52,231,131,159,183,83,63,94,44,215,133,36};
static const unsigned char precomputed_mGnP_ed25519_n_266[] = {35,38,75,24,211,130,48,144,88,83,131,116,15,172,178,196,43,69,5,35,132,4,130,173,229,212,169,129,156,237,44,244,190,167,232,241,227,6,43,105,9,110,95,116,27,124,217,76,48,217,210,197,191,27,64,187,38,54,172,60,56,69,126,178};
static const unsigned char precomputed_mGnP_ed25519_P_266[] = {226,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_267[] = {166,122,8,143,42,117,138,63,36,139,187,206,236,142,227,185,3,61,136,203,15,51,50,231,95,228,132,248,151,153,63,31,0};
static const unsigned char precomputed_mGnP_ed25519_m_267[] = {181,235,77,84,62,214,225,51,188,235,72,170,33,62,154,79,102,112,52,173,82,136,13,219,93,96,72,119,13,237,224,79};
static const unsigned char precomputed_mGnP_ed25519_n_267[] = {49,61,210,7,14,203,122,127,119,177,137,151,91,75,127,60,157,14,156,209,185,246,113,25,18,163,172,236,163,181,21,243,72,100,164,133,98,118,95,161,6,86,171,68,240,92,116,195,251,51,83,65,121,131,87,235,244,187,72,241,145,166,51,246};
static const unsigned char precomputed_mGnP_ed25519_P_267[] = {227,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_268[] = {78,242,158,211,160,131,27,233,103,49,9,112,16,229,48,104,77,40,209,207,239,30,45,27,222,105,206,190,136,219,42,23,0};
static const unsigned char precomputed_mGnP_ed25519_m_268[] = {113,149,145,243,232,230,95,252,71,104,200,245,125,159,212,207,97,47,159,131,155,173,74,53,107,236,232,82,73,27,199,63};
static const unsigned char precomputed_mGnP_ed25519_n_268[] = {19,162,2,69,139,248,156,7,129,189,185,25,222,6,87,162,160,117,154,50,1,194,226,5,191,216,13,43,75,10,32,250,93,255,36,162,156,254,184,204,142,93,212,87,170,194,27,223,99,127,115,99,61,90,18,68,46,105,65,65,49,23,73,158};
static const unsigned char precomputed_mGnP_ed25519_P_268[] = {228,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_269[] = {237,229,192,81,87,9,130,26,161,245,219,222,206,58,23,3,243,174,188,121,160,141,71,157,10,195,226,30,34,75,201,10,0};
static const unsigned char precomputed_mGnP_ed25519_m_269[] = {207,19,204,239,132,44,140,132,200,231,165,25,90,62,214,117,141,189,42,41,237,77,225,118,83,172,11,215,202,201,229,23};
static const unsigned char precomputed_mGnP_ed25519_n_269[] = {124,217,192,174,189,193,52,54,60,134,142,225,134,255,36,169,138,206,7,203,6,164,252,59,111,166,254,82,222,195,79,137,65,38,187,207,126,224,170,85,204,159,88,119,101,187,127,230,64,183,229,223,244,6,56,221,81,129,236,151,242,144,103,42};
static const unsigned char precomputed_mGnP_ed25519_P_269[] = {229,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_270[] = {176,97,9,153,67,111,171,114,173,68,120,211,72,254,38,96,85,87,171,114,78,251,20,75,159,198,75,140,95,17,118,212,0};
static const unsigned char precomputed_mGnP_ed25519_m_270[] = {142,30,103,204,72,0,222,221,2,191,37,61,7,65,157,144,160,75,105,100,158,172,57,116,130,20,91,136,129,72,245,250};
static const unsigned char precomputed_mGnP_ed25519_n_270[] = {33,129,143,2,249,251,225,11,174,252,165,33,192,176,15,171,36,73,213,173,22,80,10,168,119,84,118,124,22,77,97,228,136,42,21,21,100,104,11,72,51,145,146,177,90,187,220,126,127,8,246,191,61,131,154,76,117,206,62,59,119,27,95,13};
static const unsigned char precomputed_mGnP_ed25519_P_270[] = {230,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_271[] = {136,249,48,195,129,239,39,161,236,232,216,19,100,140,145,176,180,236,182,89,203,6,234,216,163,51,6,61,98,108,131,118,0};
static const unsigned char precomputed_mGnP_ed25519_m_271[] = {213,115,0,117,26,114,244,5,197,99,241,112,41,252,14,213,139,22,213,72,38,163,179,233,73,15,130,255,13,42,116,132};
static const unsigned char precomputed_mGnP_ed25519_n_271[] = {169,191,221,149,202,54,122,116,198,40,77,146,201,86,54,122,88,193,253,112,198,116,199,49,150,1,252,63,165,195,227,187,45,84,216,250,101,72,136,138,38,108,205,124,27,96,31,125,224,229,163,216,175,27,147,83,229,46,182,69,82,135,111,118};
static const unsigned char precomputed_mGnP_ed25519_P_271[] = {231,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_272[] = {67,87,57,116,116,249,148,221,183,132,186,23,217,11,73,43,223,179,222,93,191,98,211,97,182,117,125,89,254,244,248,13,1};
static const unsigned char precomputed_mGnP_ed25519_m_272[] = {120,13,69,168,234,93,233,214,97,126,196,35,107,205,65,251,207,128,150,60,126,204,62,185,21,145,89,224,56,192,56,2};
static const unsigned char precomputed_mGnP_ed25519_n_272[] = {75,158,212,141,137,190,224,221,12,153,133,233,245,166,234,98,184,40,75,43,52,19,235,80,127,84,180,190,77,141,112,153,213,157,66,234,105,110,240,0,95,7,229,90,19,8,20,7,202,247,235,10,219,190,149,14,36,243,171,213,117,190,50,78};
static const unsigned char precomputed_mGnP_ed25519_P_272[] = {232,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_273[] = {211,139,150,109,86,70,72,151,207,75,55,46,162,8,210,112,204,206,242,170,250,148,64,34,201,28,13,226,90,190,10,249,0};
static const unsigned char precomputed_mGnP_ed25519_m_273[] = {11,23,92,200,69,154,13,208,17,59,124,150,82,160,225,29,61,169,102,154,209,1,111,218,49,167,100,118,158,81,105,203};
static const unsigned char precomputed_mGnP_ed25519_n_273[] = {189,66,146,82,5,114,244,103,117,13,48,75,158,218,203,94,17,174,97,122,100,121,211,83,177,65,68,21,96,191,213,17,92,166,156,131,214,155,70,220,221,119,166,204,66,156,3,159,86,136,182,31,74,119,173,88,124,163,152,125,145,116,38,150};
static const unsigned char precomputed_mGnP_ed25519_P_273[] = {233,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_274[] = {136,26,115,219,117,102,216,214,244,64,153,135,212,60,252,222,13,39,35,251,129,234,95,134,218,118,219,0,233,5,92,106,0};
static const unsigned char precomputed_mGnP_ed25519_m_274[] = {86,159,255,54,92,50,218,208,163,225,98,177,16,96,85,8,249,78,38,10,36,79,189,127,36,90,204,8,55,8,14,155};
static const unsigned char precomputed_mGnP_ed25519_n_274[] = {72,63,98,38,139,127,159,104,215,84,142,36,127,95,2,1,118,40,65,37,20,124,68,211,100,163,188,222,107,215,155,201,113,95,171,130,39,56,193,5,172,21,74,105,106,223,0,109,68,233,89,189,177,207,63,97,41,221,79,6,227,244,245,33};
static const unsigned char precomputed_mGnP_ed25519_P_274[] = {234,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_275[] = {134,254,137,2,121,41,135,55,92,56,69,83,138,47,193,90,191,212,92,218,214,171,237,23,226,188,60,231,223,53,231,116,0};
static const unsigned char precomputed_mGnP_ed25519_m_275[] = {96,171,211,51,104,100,182,78,125,47,84,9,74,42,206,87,228,217,189,118,24,185,133,21,28,51,34,126,250,159,146,132};
static const unsigned char precomputed_mGnP_ed25519_n_275[] = {207,225,224,157,112,58,16,87,103,236,241,29,43,244,87,185,87,34,228,55,86,60,121,242,251,74,10,133,243,121,125,247,29,14,201,51,124,3,134,118,99,12,81,122,2,54,231,200,255,97,45,187,154,248,44,146,86,176,21,148,14,49,167,87};
static const unsigned char precomputed_mGnP_ed25519_P_275[] = {235,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_276[] = {54,96,25,43,27,132,7,162,55,220,219,111,178,72,204,56,43,183,191,220,148,105,38,34,224,119,207,37,58,141,100,68,0};
static const unsigned char precomputed_mGnP_ed25519_m_276[] = {101,230,20,254,146,255,150,59,64,252,80,203,38,102,122,53,167,219,107,255,216,150,33,9,85,64,144,183,41,153,158,162};
static const unsigned char precomputed_mGnP_ed25519_n_276[] = {21,216,177,199,208,3,237,231,3,126,123,31,99,44,123,141,15,177,53,254,16,86,44,118,192,132,202,171,68,124,145,6,7,49,39,28,58,142,158,91,233,47,105,13,56,134,225,82,160,110,240,239,246,91,50,123,16,165,224,27,71,18,105,113};
static const unsigned char precomputed_mGnP_ed25519_P_276[] = {236,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_277[] = {53,231,56,245,72,21,108,139,108,44,215,172,190,110,98,122,250,215,63,116,161,183,16,229,87,25,6,27,81,142,11,129,0};
static const unsigned char precomputed_mGnP_ed25519_m_277[] = {129,204,0,103,37,49,76,190,57,124,179,139,40,81,188,168,211,122,127,18,107,190,117,76,197,153,253,239,111,102,46,69};
static const unsigned char precomputed_mGnP_ed25519_n_277[] = {154,175,84,83,42,230,253,145,200,52,105,36,90,27,157,80,11,58,52,223,50,75,229,112,132,115,226,5,186,48,195,17,28,246,224,192,217,111,163,77,223,122,173,2,202,57,173,150,11,31,255,251,107,67,10,81,230,38,254,236,109,240,52,140};
static const unsigned char precomputed_mGnP_ed25519_P_277[] = {237,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_278[] = {3,203,78,167,128,154,162,210,153,240,140,63,244,149,81,158,109,30,237,245,254,163,231,130,4,66,58,238,116,179,115,246,0};
static const unsigned char precomputed_mGnP_ed25519_m_278[] = {172,100,182,63,39,106,10,197,225,72,198,150,53,185,80,185,247,173,14,43,46,29,237,229,109,210,219,66,94,159,41,26};
static const unsigned char precomputed_mGnP_ed25519_n_278[] = {49,244,52,80,227,54,170,35,197,1,233,41,136,85,162,107,220,66,197,94,125,69,2,81,177,20,213,234,132,176,40,128,151,224,57,205,16,5,10,207,116,187,222,170,85,112,172,154,133,219,197,27,18,209,241,126,165,22,53,86,59,124,253,127};
static const unsigned char precomputed_mGnP_ed25519_P_278[] = {238,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_279[] = {60,10,175,169,0,186,208,193,137,123,201,33,242,223,46,162,79,125,186,79,39,45,52,82,187,224,47,244,157,4,241,195,0};
static const unsigned char precomputed_mGnP_ed25519_m_279[] = {74,103,13,128,72,204,163,212,17,51,33,236,204,86,242,181,10,216,139,69,199,205,255,234,168,178,48,131,161,54,146,94};
static const unsigned char precomputed_mGnP_ed25519_n_279[] = {120,124,213,155,64,247,233,28,34,0,236,124,71,120,181,162,221,17,21,147,26,63,95,130,214,251,206,250,248,120,84,179,61,60,114,197,47,61,83,196,68,201,36,139,96,23,46,140,229,175,118,185,14,248,81,137,176,34,223,109,52,39,1,45};
static const unsigned char precomputed_mGnP_ed25519_P_279[] = {239,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_280[] = {60,79,47,167,252,76,163,21,137,191,70,129,147,50,123,113,28,210,21,215,212,101,239,129,40,173,131,208,251,65,222,232,0};
static const unsigned char precomputed_mGnP_ed25519_m_280[] = {64,161,115,156,111,54,131,33,226,199,189,243,58,166,42,26,253,26,0,241,127,211,145,229,157,199,156,143,220,220,166,179};
static const unsigned char precomputed_mGnP_ed25519_n_280[] = {247,60,8,85,13,168,100,104,208,78,233,253,181,241,126,39,88,192,183,247,20,206,92,27,181,225,173,197,207,60,225,188,36,121,246,132,242,171,68,137,74,188,232,3,236,199,223,129,9,66,239,179,130,214,81,80,189,11,159,14,19,71,28,102};
static const unsigned char precomputed_mGnP_ed25519_P_280[] = {240,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_281[] = {89,241,213,216,184,40,215,87,146,40,142,10,226,213,5,158,47,20,108,165,101,58,13,171,100,73,192,41,97,197,128,103,0};
static const unsigned char precomputed_mGnP_ed25519_m_281[] = {78,162,175,206,131,204,167,156,2,153,94,154,37,27,43,2,176,113,63,111,154,37,198,104,138,215,32,33,82,39,242,203};
static const unsigned char precomputed_mGnP_ed25519_n_281[] = {173,2,26,76,99,98,143,145,20,160,224,76,67,34,238,93,156,132,46,85,86,209,216,131,24,158,17,234,107,146,7,160,169,127,23,125,94,190,194,15,233,243,211,240,4,54,255,178,1,111,60,124,224,198,62,215,246,246,91,75,186,3,40,116};
static const unsigned char precomputed_mGnP_ed25519_P_281[] = {241,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_282[] = {29,238,164,66,136,242,54,17,255,198,96,229,117,62,102,155,10,114,128,61,191,193,214,127,18,15,166,70,9,219,253,113,0};
static const unsigned char precomputed_mGnP_ed25519_m_282[] = {116,99,254,150,49,123,185,158,242,173,16,216,185,49,48,183,178,191,115,136,201,48,191,234,163,230,146,209,117,15,175,77};
static const unsigned char precomputed_mGnP_ed25519_n_282[] = {181,230,0,6,52,90,138,97,30,36,17,66,143,124,185,40,91,122,144,32,83,130,70,247,95,125,210,63,85,144,93,94,41,15,84,112,190,32,201,11,90,33,38,20,83,12,42,209,15,176,27,15,0,145,236,140,175,55,140,83,26,240,222,185};
static const unsigned char precomputed_mGnP_ed25519_P_282[] = {242,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_283[] = {53,189,247,61,203,45,14,87,114,118,252,12,250,197,145,211,11,93,150,183,253,46,254,19,58,244,122,25,130,56,244,8,0};
static const unsigned char precomputed_mGnP_ed25519_m_283[] = {58,228,62,86,9,65,13,42,210,44,64,77,33,171,36,202,93,38,102,253,210,77,233,110,219,30,72,193,225,173,48,168};
static const unsigned char precomputed_mGnP_ed25519_n_283[] = {23,155,225,234,242,251,40,70,86,15,1,144,6,248,79,239,77,228,153,113,105,42,141,9,96,172,148,172,92,61,106,11,213,155,162,158,236,26,34,223,128,39,195,130,9,212,51,184,81,187,111,21,180,168,128,34,5,254,234,143,66,19,156,58};
static const unsigned char precomputed_mGnP_ed25519_P_283[] = {243,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_284[] = {17,2,251,49,204,212,35,49,191,249,162,49,28,115,151,75,167,96,167,189,35,54,94,58,53,156,106,205,79,187,53,155,0};
static const unsigned char precomputed_mGnP_ed25519_m_284[] = {212,189,103,25,15,170,171,46,17,50,135,224,107,111,67,136,179,190,113,87,203,146,150,131,160,157,243,188,47,120,114,205};
static const unsigned char precomputed_mGnP_ed25519_n_284[] = {152,111,109,47,40,127,35,30,131,10,52,91,29,219,13,158,44,102,85,89,178,216,212,69,226,230,182,178,89,90,37,251,12,144,12,50,94,154,197,173,236,183,3,48,58,140,78,109,186,195,125,197,189,135,125,243,40,41,83,15,186,55,218,196};
static const unsigned char precomputed_mGnP_ed25519_P_284[] = {244,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_285[] = {244,56,191,72,237,248,0,47,107,22,170,34,188,62,206,59,180,170,169,95,88,227,4,144,110,188,110,94,112,193,12,46,0};
static const unsigned char precomputed_mGnP_ed25519_m_285[] = {239,151,238,247,79,152,138,220,169,255,214,47,220,62,231,79,64,2,216,126,132,198,245,57,249,248,32,140,233,232,32,184};
static const unsigned char precomputed_mGnP_ed25519_n_285[] = {116,171,220,41,71,93,211,173,236,54,245,165,118,169,19,29,41,82,28,18,128,109,222,48,77,216,177,123,213,176,177,65,146,230,85,115,58,95,180,5,63,133,226,125,224,219,206,220,171,170,255,23,109,87,168,13,224,101,141,40,89,202,135,74};
static const unsigned char precomputed_mGnP_ed25519_P_285[] = {245,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_286[] = {104,158,120,157,33,210,119,66,141,15,254,232,22,15,224,24,159,178,181,254,14,110,84,12,230,253,111,118,224,129,192,162,0};
static const unsigned char precomputed_mGnP_ed25519_m_286[] = {3,198,63,166,195,50,19,182,180,126,247,51,49,209,2,73,230,252,71,105,236,54,107,2,3,212,80,52,107,5,160,38};
static const unsigned char precomputed_mGnP_ed25519_n_286[] = {31,165,231,132,226,216,117,89,158,21,111,163,122,68,229,19,45,121,69,116,187,238,153,214,62,43,16,19,115,177,176,19,109,197,89,42,165,73,6,240,205,204,152,137,190,197,99,78,196,197,32,75,149,147,115,11,10,84,182,116,71,95,149,163};
static const unsigned char precomputed_mGnP_ed25519_P_286[] = {246,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_287[] = {212,137,249,139,67,192,231,21,2,180,67,155,210,2,252,226,120,49,189,33,62,12,178,41,3,193,209,115,171,44,22,34,0};
static const unsigned char precomputed_mGnP_ed25519_m_287[] = {151,204,245,111,240,77,190,230,82,25,203,14,168,240,196,54,68,37,6,12,118,223,17,2,211,196,100,160,41,7,101,198};
static const unsigned char precomputed_mGnP_ed25519_n_287[] = {93,4,129,147,199,144,87,228,143,218,222,104,250,231,147,88,60,200,82,14,65,57,232,160,77,209,36,86,218,164,12,90,106,52,80,4,223,251,245,186,110,24,150,26,87,147,44,184,247,73,247,109,199,39,50,128,21,33,91,90,170,194,152,66};
static const unsigned char precomputed_mGnP_ed25519_P_287[] = {247,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_288[] = {142,198,90,148,77,241,97,195,74,13,4,181,21,94,158,83,132,89,8,19,35,237,160,240,47,170,138,38,183,18,214,146,0};
static const unsigned char precomputed_mGnP_ed25519_m_288[] = {83,14,13,106,241,31,216,224,6,182,171,64,52,39,40,109,170,44,121,74,151,68,62,20,64,32,248,30,118,56,35,171};
static const unsigned char precomputed_mGnP_ed25519_n_288[] = {55,117,164,78,252,232,15,132,117,2,12,106,207,128,62,101,231,116,105,24,45,44,187,245,111,65,230,78,133,235,207,77,74,208,107,149,117,162,114,54,152,173,135,248,26,38,72,8,80,239,38,168,105,181,81,120,134,230,113,79,249,128,187,30};
static const unsigned char precomputed_mGnP_ed25519_P_288[] = {248,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_289[] = {172,15,32,44,236,230,214,84,177,194,24,202,68,196,118,57,44,52,216,28,225,33,46,83,144,248,137,53,235,249,146,41,0};
static const unsigned char precomputed_mGnP_ed25519_m_289[] = {243,188,31,185,17,240,54,212,163,67,198,61,222,2,85,54,166,202,127,228,53,12,19,122,27,29,7,249,10,239,74,236};
static const unsigned char precomputed_mGnP_ed25519_n_289[] = {116,134,97,169,66,106,96,56,232,85,195,216,46,214,27,156,136,4,84,62,4,92,15,166,254,33,128,38,117,119,110,21,18,76,177,97,85,144,159,87,38,134,252,5,188,128,142,104,239,134,110,182,208,125,24,161,70,27,246,154,92,76,1,129};
static const unsigned char precomputed_mGnP_ed25519_P_289[] = {249,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_290[] = {219,205,196,118,109,104,75,78,200,3,75,44,254,230,51,80,31,14,173,152,215,202,5,103,99,226,91,52,95,151,213,202,0};
static const unsigned char precomputed_mGnP_ed25519_m_290[] = {234,109,51,8,136,219,239,115,219,249,36,254,195,18,13,70,207,128,185,164,30,115,89,195,208,236,142,179,88,33,15,105};
static const unsigned char precomputed_mGnP_ed25519_n_290[] = {108,101,49,157,164,169,12,88,137,28,178,88,234,220,23,144,52,193,94,120,185,171,221,105,253,232,67,110,141,101,171,170,49,127,140,120,133,63,166,154,140,24,210,116,69,58,67,254,148,203,99,196,212,189,213,249,255,208,115,247,53,133,170,58};
static const unsigned char precomputed_mGnP_ed25519_P_290[] = {250,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_291[] = {237,35,252,175,254,29,232,172,91,234,16,211,50,233,181,191,113,32,237,206,87,200,254,247,233,218,5,41,11,42,87,138,0};
static const unsigned char precomputed_mGnP_ed25519_m_291[] = {23,120,210,21,148,60,20,226,88,46,209,237,37,207,43,116,233,163,91,72,126,74,215,234,147,242,235,62,60,221,121,139};
static const unsigned char precomputed_mGnP_ed25519_n_291[] = {160,156,230,140,208,124,253,30,145,232,143,76,168,28,99,207,180,221,55,93,175,71,194,175,181,130,147,124,25,54,157,128,9,95,0,186,170,126,120,135,211,212,41,52,230,87,39,93,34,241,79,192,187,66,74,133,197,215,235,4,14,176,91,52};
static const unsigned char precomputed_mGnP_ed25519_P_291[] = {251,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_292[] = {39,161,48,124,76,218,214,65,32,126,189,231,202,109,66,122,200,93,34,124,69,75,190,129,121,172,22,192,95,222,179,248,0};
static const unsigned char precomputed_mGnP_ed25519_m_292[] = {146,23,158,50,64,109,29,147,48,98,56,178,131,27,155,87,213,203,41,119,183,94,210,243,120,135,204,49,165,252,31,35};
static const unsigned char precomputed_mGnP_ed25519_n_292[] = {14,7,215,232,122,60,209,240,119,149,95,185,71,34,29,103,114,150,160,49,179,190,49,146,64,76,161,144,197,6,53,160,185,25,221,46,8,47,209,70,83,158,224,34,248,201,200,253,121,97,61,40,214,7,79,232,173,222,198,33,236,99,59,239};
static const unsigned char precomputed_mGnP_ed25519_P_292[] = {252,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_293[] = {217,12,215,20,215,223,157,220,51,105,90,33,120,40,65,127,70,244,99,78,221,4,185,221,238,250,27,208,59,2,139,154,0};
static const unsigned char precomputed_mGnP_ed25519_m_293[] = {83,142,151,19,250,223,214,60,236,144,84,103,70,105,63,79,88,197,91,77,185,55,133,57,163,89,118,102,44,46,170,139};
static const unsigned char precomputed_mGnP_ed25519_n_293[] = {243,85,150,0,71,155,114,72,65,230,62,199,161,253,217,37,97,127,92,176,105,24,232,82,69,209,234,38,254,74,98,156,222,241,47,69,60,223,111,170,134,154,100,71,99,211,237,46,128,239,243,149,242,167,7,2,5,255,247,136,182,182,131,113};
static const unsigned char precomputed_mGnP_ed25519_P_293[] = {253,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_294[] = {55,52,233,241,230,34,83,143,171,246,229,9,87,25,223,156,228,254,160,36,210,216,64,162,53,172,93,148,121,146,43,192,0};
static const unsigned char precomputed_mGnP_ed25519_m_294[] = {202,92,186,239,64,49,62,145,125,247,207,31,29,46,157,64,157,13,253,250,12,19,246,187,141,251,220,47,41,179,255,134};
static const unsigned char precomputed_mGnP_ed25519_n_294[] = {167,136,179,133,24,29,48,11,41,59,249,73,213,30,93,160,198,94,54,164,174,130,96,199,241,221,205,155,218,153,252,168,209,123,112,66,176,104,202,91,184,70,194,61,170,119,255,96,211,186,189,115,247,0,185,13,26,82,181,39,129,144,89,18};
static const unsigned char precomputed_mGnP_ed25519_P_294[] = {254,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_295[] = {196,167,30,14,10,153,90,181,217,188,78,128,150,244,152,92,114,29,57,166,244,129,224,156,117,7,73,57,154,122,217,142,0};
static const unsigned char precomputed_mGnP_ed25519_m_295[] = {197,80,193,251,165,120,253,208,180,2,67,53,203,150,206,128,20,252,176,106,75,228,244,8,77,227,1,56,87,246,37,55};
static const unsigned char precomputed_mGnP_ed25519_n_295[] = {239,149,210,115,125,206,136,50,210,170,17,201,206,70,125,86,2,60,17,164,151,184,47,18,49,108,254,19,81,128,139,255,51,187,18,139,210,31,98,114,203,11,54,165,159,42,68,141,204,103,71,8,201,179,120,95,109,254,163,166,17,196,171,120};
static const unsigned char precomputed_mGnP_ed25519_P_295[] = {255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255};
static const unsigned char precomputed_mGnP_ed25519_Q_296[] = {44,17,5,243,14,116,35,189,106,235,187,90,163,130,102,84,98,235,183,48,0,84,13,228,202,82,64,192,217,235,254,90,1};
static const unsigned char precomputed_mGnP_ed25519_m_296[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_n_296[] = {44,183,123,252,220,112,230,38,97,156,179,226,109,106,97,129,166,186,7,23,235,103,36,114,135,184,23,23,44,83,151,85,14,121,52,122,90,27,35,145,228,60,66,110,250,48,218,205,205,150,23,231,204,87,47,165,27,245,247,27,66,128,204,155};
static const unsigned char precomputed_mGnP_ed25519_P_296[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_297[] = {125,148,91,223,153,201,60,155,110,18,122,250,175,202,132,24,226,253,137,178,79,19,144,39,151,169,122,70,73,230,198,45,1};
static const unsigned char precomputed_mGnP_ed25519_m_297[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_n_297[] = {53,37,62,47,148,57,194,227,7,15,47,52,109,201,230,184,173,64,249,234,71,93,229,54,108,63,151,3,27,64,198,33,106,113,13,8,8,43,200,120,11,107,79,170,182,164,193,202,78,78,250,25,223,245,138,245,22,101,96,13,114,245,53,118};
static const unsigned char precomputed_mGnP_ed25519_P_297[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_298[] = {240,20,151,82,156,223,39,19,131,65,88,136,255,184,176,42,217,70,51,130,83,9,143,194,4,251,103,102,133,26,76,141,1};
static const unsigned char precomputed_mGnP_ed25519_m_298[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_n_298[] = {135,171,221,169,164,163,154,89,163,251,160,219,4,113,192,175,150,219,84,116,107,217,153,25,119,16,66,148,40,240,103,128,58,255,214,156,217,207,194,19,162,57,230,0,49,223,217,108,15,113,135,168,14,73,124,228,119,129,90,145,22,149,242,207};
static const unsigned char precomputed_mGnP_ed25519_P_298[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_299[] = {251,98,125,147,146,54,37,27,230,2,80,106,139,155,246,208,145,58,147,247,87,236,24,21,28,132,22,46,141,107,58,10,1};
static const unsigned char precomputed_mGnP_ed25519_m_299[] = {235,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_mGnP_ed25519_n_299[] = {201,72,150,7,241,51,16,117,198,44,36,204,86,54,20,14,44,142,95,204,148,46,198,107,36,127,87,94,42,171,60,125,52,175,3,110,167,9,121,239,90,229,246,79,207,133,18,130,200,33,53,154,230,226,17,158,218,242,155,145,123,102,166,146};
static const unsigned char precomputed_mGnP_ed25519_P_299[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_300[] = {61,135,30,168,179,157,221,230,0,41,246,221,162,152,124,17,88,96,116,40,49,196,102,85,232,121,243,62,99,247,148,35,1};
static const unsigned char precomputed_mGnP_ed25519_m_300[] = {236,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_mGnP_ed25519_n_300[] = {59,24,87,186,197,111,43,119,184,236,82,245,124,70,20,49,192,252,241,98,91,156,234,107,72,253,127,55,40,67,175,195,37,152,90,120,94,66,14,11,123,117,89,38,211,91,65,21,68,15,46,252,87,83,207,196,146,19,107,175,175,208,205,206};
static const unsigned char precomputed_mGnP_ed25519_P_300[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_301[] = {145,111,200,31,44,143,139,105,250,170,39,69,148,156,22,190,107,142,166,152,64,39,3,231,52,23,18,16,166,118,118,90,0};
static const unsigned char precomputed_mGnP_ed25519_m_301[] = {237,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_mGnP_ed25519_n_301[] = {16,17,176,101,163,50,211,155,10,105,124,200,74,228,159,69,67,205,130,26,37,2,175,114,146,40,115,44,204,73,192,207,201,238,193,153,117,42,136,52,129,118,6,57,225,155,166,110,181,105,204,169,163,141,14,12,148,187,180,23,212,247,248,204};
static const unsigned char precomputed_mGnP_ed25519_P_301[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_302[] = {76,84,78,210,37,75,244,108,245,154,178,180,166,203,31,107,138,113,1,119,47,52,27,142,229,70,9,187,72,89,56,49,0};
static const unsigned char precomputed_mGnP_ed25519_m_302[] = {238,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_mGnP_ed25519_n_302[] = {71,70,112,189,61,249,226,103,119,81,55,193,235,102,173,41,178,203,101,252,118,255,186,122,134,233,126,46,145,199,231,87,185,31,80,252,226,127,40,172,117,114,250,165,20,69,67,59,11,71,107,46,146,142,87,103,136,42,62,211,52,136,231,235};
static const unsigned char precomputed_mGnP_ed25519_P_302[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_303[] = {142,251,32,76,1,36,120,255,116,38,168,25,161,157,2,54,134,36,101,100,141,149,203,253,247,10,125,34,4,214,93,113,0};
static const unsigned char precomputed_mGnP_ed25519_m_303[] = {239,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16};
static const unsigned char precomputed_mGnP_ed25519_n_303[] = {92,186,91,229,142,102,241,162,229,102,202,23,227,216,28,169,73,184,253,26,58,96,11,90,101,81,198,214,229,126,102,149,11,55,229,57,31,95,193,137,175,238,106,210,144,143,245,30,223,172,58,171,122,209,147,35,202,220,24,128,106,131,157,134};
static const unsigned char precomputed_mGnP_ed25519_P_303[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_304[] = {110,165,144,122,238,139,107,215,61,195,98,203,213,87,64,232,106,254,181,231,46,132,11,206,198,143,136,25,82,250,221,22,0};
static const unsigned char precomputed_mGnP_ed25519_m_304[] = {216,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_mGnP_ed25519_n_304[] = {183,165,249,6,25,14,24,81,209,126,139,87,46,69,203,192,186,25,74,52,101,37,40,51,26,209,20,205,30,185,249,80,225,243,143,106,108,99,171,79,224,165,146,164,245,0,204,243,36,137,151,219,170,228,223,70,250,153,247,73,74,255,104,40};
static const unsigned char precomputed_mGnP_ed25519_P_304[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_305[] = {19,156,134,235,126,190,11,5,225,2,41,163,245,207,23,200,30,239,38,59,102,173,216,196,87,111,242,196,0,229,246,200,0};
static const unsigned char precomputed_mGnP_ed25519_m_305[] = {217,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_mGnP_ed25519_n_305[] = {34,6,139,221,152,8,143,132,167,173,123,204,96,50,167,139,147,135,145,236,2,174,125,120,40,130,202,43,173,206,189,64,30,61,20,61,241,232,152,100,37,94,180,74,156,30,83,33,217,176,186,194,47,125,63,210,168,64,235,231,11,246,8,218};
static const unsigned char precomputed_mGnP_ed25519_P_305[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_306[] = {22,108,142,74,86,189,140,68,10,130,141,192,12,59,33,152,75,121,252,151,180,180,161,223,37,212,235,147,111,147,249,225,0};
static const unsigned char precomputed_mGnP_ed25519_m_306[] = {218,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_mGnP_ed25519_n_306[] = {136,12,119,186,31,200,77,54,218,46,120,55,79,161,192,25,125,186,34,204,187,161,120,167,15,65,164,224,206,147,188,71,37,173,225,208,174,60,250,69,152,179,137,145,153,0,137,160,56,121,243,230,196,3,57,12,170,230,157,77,68,125,20,175};
static const unsigned char precomputed_mGnP_ed25519_P_306[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_307[] = {196,211,118,205,0,71,125,122,97,137,50,247,211,201,200,219,169,248,95,173,13,54,133,74,104,206,4,250,168,104,136,52,0};
static const unsigned char precomputed_mGnP_ed25519_m_307[] = {219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_mGnP_ed25519_n_307[] = {214,74,66,22,9,188,113,131,5,55,192,208,227,24,249,60,243,115,101,254,133,98,210,15,170,210,26,118,187,244,90,254,183,250,23,178,175,130,35,137,254,166,230,143,201,32,31,155,128,87,200,209,164,121,57,152,3,16,124,157,28,186,91,60};
static const unsigned char precomputed_mGnP_ed25519_P_307[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_308[] = {181,139,201,60,58,135,163,190,31,55,133,151,2,209,69,11,194,5,148,128,39,93,249,171,158,96,2,242,81,124,237,9,0};
static const unsigned char precomputed_mGnP_ed25519_m_308[] = {220,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32};
static const unsigned char precomputed_mGnP_ed25519_n_308[] = {232,217,149,40,251,197,92,97,37,169,175,76,159,222,112,10,18,215,229,39,72,57,116,51,43,126,180,160,69,50,17,160,207,229,63,19,210,78,242,209,186,68,53,48,189,21,60,180,74,128,104,110,121,156,98,192,107,70,21,66,243,13,31,6};
static const unsigned char precomputed_mGnP_ed25519_P_308[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_309[] = {247,0,169,141,199,163,136,79,74,162,2,44,212,2,155,131,201,39,62,164,225,37,213,85,208,61,182,57,165,151,29,164,0};
static const unsigned char precomputed_mGnP_ed25519_m_309[] = {197,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_mGnP_ed25519_n_309[] = {91,49,238,2,98,0,236,119,135,218,202,177,9,120,151,217,226,34,16,71,112,168,11,133,240,199,74,14,177,115,211,174,34,50,138,238,103,36,244,136,42,159,151,110,74,81,166,19,143,255,186,49,164,97,249,163,136,61,63,163,156,93,169,62};
static const unsigned char precomputed_mGnP_ed25519_P_309[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_310[] = {169,7,33,75,22,162,82,106,14,167,37,103,235,188,161,139,34,203,3,185,81,154,141,226,21,27,173,219,68,188,37,30,0};
static const unsigned char precomputed_mGnP_ed25519_m_310[] = {198,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_mGnP_ed25519_n_310[] = {31,128,135,220,89,29,198,45,153,253,66,171,202,139,22,121,10,232,41,249,252,230,112,128,77,67,235,245,215,46,52,103,28,211,57,124,197,131,93,47,183,76,55,197,155,61,14,251,66,152,33,231,178,232,39,196,106,55,240,156,170,171,170,67};
static const unsigned char precomputed_mGnP_ed25519_P_310[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_311[] = {92,125,44,181,81,185,182,110,204,208,209,48,103,193,55,133,163,10,159,4,232,223,162,161,208,111,10,247,24,99,8,82,0};
static const unsigned char precomputed_mGnP_ed25519_m_311[] = {199,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_mGnP_ed25519_n_311[] = {244,136,58,161,45,199,39,133,70,147,33,116,222,252,8,92,26,162,184,199,166,51,227,99,110,145,114,185,122,88,159,78,169,51,149,82,160,203,19,46,3,189,141,224,168,211,99,51,18,97,236,161,57,30,192,36,129,218,152,165,192,186,192,84};
static const unsigned char precomputed_mGnP_ed25519_P_311[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_312[] = {180,88,129,167,183,83,153,252,186,230,255,211,246,183,169,165,232,236,91,82,111,143,165,1,6,208,42,47,252,106,161,85,0};
static const unsigned char precomputed_mGnP_ed25519_m_312[] = {200,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_mGnP_ed25519_n_312[] = {221,43,217,181,107,94,231,245,81,139,114,166,95,34,125,236,224,179,241,125,15,65,35,130,26,217,204,138,23,41,75,237,71,148,60,153,116,3,124,61,254,20,142,24,221,105,240,82,164,49,181,240,114,71,99,178,195,64,219,16,189,234,187,49};
static const unsigned char precomputed_mGnP_ed25519_P_312[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_313[] = {72,84,58,168,164,171,219,193,241,254,96,126,74,59,32,48,180,110,112,246,44,69,219,200,13,96,193,79,24,194,159,201,0};
static const unsigned char precomputed_mGnP_ed25519_m_313[] = {201,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48};
static const unsigned char precomputed_mGnP_ed25519_n_313[] = {23,217,10,132,79,32,111,154,130,199,232,12,95,93,251,179,177,164,233,94,145,148,225,94,203,205,252,225,45,252,220,80,98,122,174,146,76,75,217,244,179,70,206,214,65,104,112,71,156,191,241,45,7,251,3,168,188,27,36,215,94,169,1,52};
static const unsigned char precomputed_mGnP_ed25519_P_313[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_314[] = {132,185,122,66,237,0,216,167,4,89,27,80,40,65,10,75,59,167,140,169,194,81,98,122,98,159,118,191,129,10,243,119,0};
static const unsigned char precomputed_mGnP_ed25519_m_314[] = {178,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_mGnP_ed25519_n_314[] = {83,73,96,96,81,137,174,175,201,89,8,14,51,142,180,168,191,201,176,253,175,128,63,184,16,100,227,192,140,158,227,59,125,167,178,250,119,204,134,233,182,204,34,10,27,226,170,79,125,254,17,214,246,121,102,218,139,251,39,32,222,199,179,219};
static const unsigned char precomputed_mGnP_ed25519_P_314[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_315[] = {145,211,114,94,154,103,103,227,189,122,227,169,149,200,57,78,76,96,9,254,168,139,187,208,178,122,8,38,13,202,28,41,0};
static const unsigned char precomputed_mGnP_ed25519_m_315[] = {179,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_mGnP_ed25519_n_315[] = {130,111,176,230,202,71,25,157,70,66,57,144,48,137,68,121,163,246,229,247,125,71,150,154,119,87,84,191,232,198,150,0,59,245,34,204,103,233,3,85,250,148,100,90,126,247,44,177,109,195,115,55,125,138,242,45,105,92,36,107,190,22,127,198};
static const unsigned char precomputed_mGnP_ed25519_P_315[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_316[] = {233,166,245,105,109,67,122,68,225,255,35,81,216,44,29,126,26,102,76,149,179,8,88,111,42,246,214,170,25,250,204,142,0};
static const unsigned char precomputed_mGnP_ed25519_m_316[] = {180,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_mGnP_ed25519_n_316[] = {5,27,94,67,156,137,28,208,42,231,22,27,30,97,150,47,77,79,99,108,37,21,30,234,20,64,41,157,239,48,180,65,182,255,182,45,35,21,35,248,7,115,206,250,189,122,238,67,51,182,90,118,87,54,178,97,196,195,121,235,81,119,101,0};
static const unsigned char precomputed_mGnP_ed25519_P_316[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_317[] = {18,197,157,39,130,197,224,164,81,107,101,200,42,6,106,204,211,179,199,105,224,205,231,111,248,79,175,89,177,71,46,4,0};
static const unsigned char precomputed_mGnP_ed25519_m_317[] = {181,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_mGnP_ed25519_n_317[] = {160,8,74,241,171,79,118,180,232,122,192,144,70,116,213,11,168,172,12,64,78,8,63,248,10,237,13,228,34,13,119,178,62,169,102,38,255,186,13,80,197,16,5,45,43,33,8,203,34,74,99,71,194,111,252,188,11,10,142,102,167,119,250,103};
static const unsigned char precomputed_mGnP_ed25519_P_317[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_318[] = {189,178,166,64,103,104,249,173,2,56,220,111,64,32,248,162,185,138,126,94,134,158,133,174,143,229,190,14,230,178,227,150,0};
static const unsigned char precomputed_mGnP_ed25519_m_318[] = {182,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64};
static const unsigned char precomputed_mGnP_ed25519_n_318[] = {213,229,158,73,58,153,203,229,84,106,17,74,193,223,162,36,177,61,223,213,9,87,62,139,101,247,128,53,74,21,142,44,184,7,69,165,235,111,177,93,58,198,15,124,104,140,99,134,188,114,248,219,191,186,229,213,102,203,197,255,13,220,120,225};
static const unsigned char precomputed_mGnP_ed25519_P_318[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_319[] = {58,38,9,251,215,67,35,222,155,181,169,68,188,180,71,180,157,139,126,59,133,227,78,27,81,135,64,130,6,222,245,253,0};
static const unsigned char precomputed_mGnP_ed25519_m_319[] = {159,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_mGnP_ed25519_n_319[] = {106,134,48,45,197,11,74,217,81,184,157,238,192,211,93,144,87,193,146,175,14,220,93,86,151,179,133,111,186,75,250,136,199,167,12,0,103,40,207,12,1,11,125,67,13,35,128,148,221,111,11,184,35,38,147,200,157,219,82,76,175,107,36,232};
static const unsigned char precomputed_mGnP_ed25519_P_319[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_320[] = {146,183,70,152,99,224,17,8,151,98,16,27,215,90,17,53,186,221,46,130,61,215,24,160,204,59,35,149,180,156,35,207,0};
static const unsigned char precomputed_mGnP_ed25519_m_320[] = {160,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_mGnP_ed25519_n_320[] = {169,152,51,152,200,212,26,135,97,97,231,240,96,74,226,98,106,199,51,182,182,3,8,23,247,207,184,102,232,49,5,226,53,201,116,45,48,77,11,110,102,4,77,232,25,227,143,182,31,21,104,51,215,230,191,101,37,126,167,1,237,182,222,28};
static const unsigned char precomputed_mGnP_ed25519_P_320[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_321[] = {124,77,118,44,133,202,246,122,137,139,47,53,109,93,12,183,103,186,110,43,17,229,102,209,19,206,43,81,31,60,165,238,0};
static const unsigned char precomputed_mGnP_ed25519_m_321[] = {161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_mGnP_ed25519_n_321[] = {33,97,218,5,186,84,79,7,214,55,68,39,107,179,140,49,72,147,97,84,30,98,156,209,205,148,113,111,84,163,235,47,251,20,69,176,112,153,6,58,26,131,54,33,81,69,42,76,25,208,228,71,87,169,25,167,252,51,112,43,103,50,221,18};
static const unsigned char precomputed_mGnP_ed25519_P_321[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_322[] = {215,122,85,84,245,17,180,81,187,47,7,30,188,105,26,91,195,239,251,54,222,249,217,61,132,147,144,94,178,81,240,219,0};
static const unsigned char precomputed_mGnP_ed25519_m_322[] = {162,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_mGnP_ed25519_n_322[] = {9,171,48,246,207,159,173,245,48,120,164,54,103,205,201,106,65,178,70,16,127,225,10,154,159,92,211,57,6,82,3,170,118,25,236,146,138,3,125,77,19,164,211,87,203,124,70,34,146,105,195,171,178,167,157,230,249,12,244,63,129,15,200,44};
static const unsigned char precomputed_mGnP_ed25519_P_322[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_323[] = {235,46,88,203,236,205,14,150,63,172,40,3,151,227,158,207,182,126,205,31,179,42,173,176,134,108,219,122,21,61,240,88,0};
static const unsigned char precomputed_mGnP_ed25519_m_323[] = {163,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80};
static const unsigned char precomputed_mGnP_ed25519_n_323[] = {155,209,109,240,170,31,134,225,217,73,124,14,156,209,214,222,81,153,135,153,217,52,68,87,74,223,44,207,92,245,32,242,236,117,3,63,133,13,181,62,63,78,192,158,192,89,253,62,197,110,235,126,71,57,121,255,122,174,73,13,13,241,207,173};
static const unsigned char precomputed_mGnP_ed25519_P_323[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_324[] = {235,113,68,219,223,158,1,63,248,118,188,21,16,43,208,0,229,104,181,243,223,246,205,81,53,201,140,46,64,76,139,232,0};
static const unsigned char precomputed_mGnP_ed25519_m_324[] = {140,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_mGnP_ed25519_n_324[] = {239,116,126,127,85,130,165,209,168,210,28,253,119,136,89,76,220,242,152,217,34,208,122,206,172,32,173,214,13,114,128,85,27,112,178,175,119,215,15,194,39,248,192,86,42,107,67,88,208,212,118,27,92,186,220,185,255,245,148,30,62,249,207,161};
static const unsigned char precomputed_mGnP_ed25519_P_324[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_325[] = {212,50,80,203,50,18,244,86,255,178,208,183,37,170,139,20,110,4,0,101,231,84,20,190,233,106,95,175,140,196,4,11,0};
static const unsigned char precomputed_mGnP_ed25519_m_325[] = {141,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_mGnP_ed25519_n_325[] = {35,238,83,97,210,209,186,236,62,39,173,168,237,32,31,43,157,190,46,124,96,142,224,46,137,115,193,149,144,239,181,42,125,8,149,251,7,120,30,31,218,51,43,111,171,171,236,78,82,145,147,131,125,122,245,45,132,23,231,171,114,34,171,120};
static const unsigned char precomputed_mGnP_ed25519_P_325[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_326[] = {90,203,157,13,157,160,72,116,32,145,125,71,221,24,236,191,135,4,102,82,46,177,109,120,240,239,54,152,75,6,185,132,0};
static const unsigned char precomputed_mGnP_ed25519_m_326[] = {142,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_mGnP_ed25519_n_326[] = {123,245,145,41,166,71,131,252,165,84,241,5,1,20,116,95,57,247,71,88,87,62,16,201,67,46,253,19,98,218,135,128,10,219,52,102,197,78,102,147,182,14,243,200,193,23,110,24,215,168,100,37,114,206,249,117,80,251,185,147,148,147,110,148};
static const unsigned char precomputed_mGnP_ed25519_P_326[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_327[] = {81,247,93,195,186,245,109,224,12,40,242,198,14,144,77,23,185,214,32,215,146,236,121,255,194,146,164,152,209,1,76,248,0};
static const unsigned char precomputed_mGnP_ed25519_m_327[] = {143,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_mGnP_ed25519_n_327[] = {111,163,82,17,146,181,41,3,243,151,31,229,198,92,141,153,133,215,17,130,100,242,12,218,248,42,90,31,112,185,49,173,186,141,104,161,115,218,222,168,48,169,238,88,44,228,207,43,30,105,67,210,208,142,192,190,64,177,136,72,111,124,174,112};
static const unsigned char precomputed_mGnP_ed25519_P_327[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_328[] = {188,27,57,198,143,249,2,41,176,80,179,22,135,206,140,247,37,89,124,162,195,166,220,40,84,54,46,61,203,235,156,152,0};
static const unsigned char precomputed_mGnP_ed25519_m_328[] = {144,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96};
static const unsigned char precomputed_mGnP_ed25519_n_328[] = {189,2,145,5,203,165,188,69,95,163,13,167,3,60,65,144,184,206,159,13,31,171,252,156,16,194,103,198,79,244,255,142,250,187,6,26,54,43,41,144,183,182,185,103,34,227,181,211,157,49,192,163,184,133,72,217,255,216,132,13,170,37,102,125};
static const unsigned char precomputed_mGnP_ed25519_P_328[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_329[] = {119,0,167,175,73,140,3,11,189,120,177,231,6,5,150,153,111,165,232,220,87,46,10,172,3,112,172,181,218,97,104,65,0};
static const unsigned char precomputed_mGnP_ed25519_m_329[] = {121,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_mGnP_ed25519_n_329[] = {51,255,134,18,23,255,242,126,243,48,113,68,8,16,239,230,209,173,121,125,108,192,170,118,51,231,243,186,175,3,84,154,141,40,25,124,198,82,188,47,164,171,116,142,147,226,199,20,170,126,164,166,173,74,61,18,69,245,61,232,106,121,146,143};
static const unsigned char precomputed_mGnP_ed25519_P_329[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_330[] = {133,47,94,200,127,16,103,193,238,205,61,223,132,224,34,200,143,144,114,41,54,188,198,44,84,174,9,156,211,150,43,213,0};
static const unsigned char precomputed_mGnP_ed25519_m_330[] = {122,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_mGnP_ed25519_n_330[] = {155,73,5,159,11,242,211,154,225,185,149,87,66,68,156,148,109,170,73,167,40,162,104,254,63,194,14,116,239,250,169,189,184,211,146,158,10,52,98,98,137,60,62,42,9,243,101,218,102,218,201,27,156,204,218,179,127,56,9,55,28,52,238,213};
static const unsigned char precomputed_mGnP_ed25519_P_330[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_331[] = {7,205,105,24,239,71,151,233,241,27,244,26,174,71,108,235,207,206,8,224,146,131,111,19,142,9,198,9,177,41,113,28,0};
static const unsigned char precomputed_mGnP_ed25519_m_331[] = {123,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_mGnP_ed25519_n_331[] = {142,239,232,5,88,221,175,162,123,109,50,203,71,155,38,95,248,253,216,214,91,55,240,68,183,208,194,137,217,3,231,123,162,224,122,109,0,106,255,124,30,11,107,141,217,208,144,53,250,230,93,98,166,212,251,177,125,73,170,161,13,57,146,165};
static const unsigned char precomputed_mGnP_ed25519_P_331[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_332[] = {251,33,84,63,77,9,185,195,3,214,146,249,246,58,87,253,252,13,110,47,98,97,97,91,200,81,154,17,166,10,110,0,0};
static const unsigned char precomputed_mGnP_ed25519_m_332[] = {124,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_mGnP_ed25519_n_332[] = {155,164,0,58,39,26,147,254,133,93,92,48,130,207,60,6,233,204,157,168,148,35,227,210,205,46,20,132,89,229,15,7,66,199,72,197,141,217,26,113,89,64,17,220,254,131,60,149,101,138,88,250,37,180,175,99,122,122,9,192,99,25,46,63};
static const unsigned char precomputed_mGnP_ed25519_P_332[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_333[] = {227,53,173,36,84,118,95,94,214,97,173,182,239,34,45,172,54,1,36,139,70,75,29,234,117,239,120,125,211,75,228,80,0};
static const unsigned char precomputed_mGnP_ed25519_m_333[] = {125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112};
static const unsigned char precomputed_mGnP_ed25519_n_333[] = {40,60,234,41,90,192,188,24,197,154,115,232,49,194,227,145,15,136,148,240,223,253,82,44,232,45,190,231,244,78,202,90,181,185,212,201,120,216,211,129,194,15,156,164,134,166,214,58,114,234,42,62,129,201,213,107,214,12,150,202,2,254,210,45};
static const unsigned char precomputed_mGnP_ed25519_P_333[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_334[] = {228,28,36,245,125,243,215,211,114,120,139,164,184,196,106,3,245,114,74,135,17,197,91,169,165,69,142,49,203,193,120,78,0};
static const unsigned char precomputed_mGnP_ed25519_m_334[] = {102,159,174,231,210,24,147,192,178,230,188,23,245,206,247,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_n_334[] = {13,252,126,55,152,99,2,217,145,26,173,220,250,69,153,51,131,184,23,208,68,125,146,181,212,83,225,172,127,156,34,34,27,159,94,110,157,20,25,232,124,17,95,3,246,75,47,124,64,106,49,25,64,12,230,236,100,223,163,86,206,238,97,108};
static const unsigned char precomputed_mGnP_ed25519_P_334[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_335[] = {191,9,216,18,117,238,71,215,33,49,87,89,154,177,68,244,190,80,26,9,102,71,34,146,86,88,71,193,189,70,137,236,0};
static const unsigned char precomputed_mGnP_ed25519_m_335[] = {103,159,174,231,210,24,147,192,178,230,188,23,245,206,247,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_n_335[] = {177,144,22,245,236,153,147,168,226,29,183,70,74,246,156,70,126,8,177,69,51,35,134,72,134,85,248,109,24,89,162,204,117,12,171,169,94,67,128,1,122,140,199,97,203,56,90,67,241,144,55,176,77,113,154,118,242,9,99,237,182,148,195,18};
static const unsigned char precomputed_mGnP_ed25519_P_335[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_336[] = {110,139,248,71,35,223,29,67,237,208,34,79,41,118,188,185,86,214,171,248,244,170,106,63,62,22,28,30,124,182,162,201,0};
static const unsigned char precomputed_mGnP_ed25519_m_336[] = {104,159,174,231,210,24,147,192,178,230,188,23,245,206,247,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_n_336[] = {249,78,160,157,57,88,101,3,43,82,91,111,125,75,197,87,124,23,126,211,78,15,142,108,65,176,92,91,61,20,189,98,106,153,188,169,164,29,107,185,189,37,213,38,199,152,203,48,122,107,79,47,29,65,249,57,65,39,89,239,80,104,12,203};
static const unsigned char precomputed_mGnP_ed25519_P_336[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_337[] = {219,64,213,52,124,37,226,29,229,50,162,200,46,170,119,26,95,189,176,116,114,89,249,90,102,40,214,218,51,209,9,6,0};
static const unsigned char precomputed_mGnP_ed25519_m_337[] = {105,159,174,231,210,24,147,192,178,230,188,23,245,206,247,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_n_337[] = {226,75,177,82,13,243,166,236,91,202,112,253,204,8,177,78,251,176,58,141,204,240,65,246,151,63,181,143,50,178,204,198,57,13,81,24,213,122,63,86,12,16,29,181,239,56,206,253,234,157,185,61,62,71,216,44,150,114,253,249,54,199,60,203};
static const unsigned char precomputed_mGnP_ed25519_P_337[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_338[] = {224,236,49,166,102,5,231,70,198,51,43,93,87,131,246,97,172,21,0,20,175,44,158,93,205,90,228,77,17,55,55,106,0};
static const unsigned char precomputed_mGnP_ed25519_m_338[] = {106,159,174,231,210,24,147,192,178,230,188,23,245,206,247,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128};
static const unsigned char precomputed_mGnP_ed25519_n_338[] = {47,205,253,217,113,222,229,39,102,159,189,155,85,40,213,158,91,121,204,59,197,173,36,245,142,79,69,133,232,23,152,94,69,177,59,126,233,150,25,65,34,156,14,119,160,89,34,201,218,249,146,236,78,83,170,157,119,44,155,246,234,71,50,230};
static const unsigned char precomputed_mGnP_ed25519_P_338[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_339[] = {44,4,170,208,102,190,245,244,75,66,189,63,118,196,203,20,18,66,242,226,213,192,2,70,157,36,226,32,122,207,170,180,0};
static const unsigned char precomputed_mGnP_ed25519_m_339[] = {83,115,164,68,237,123,165,24,137,131,180,186,211,200,214,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_mGnP_ed25519_n_339[] = {53,173,77,198,54,205,192,100,237,19,100,213,125,142,248,202,226,225,63,239,211,154,163,62,253,19,106,185,151,53,52,115,203,233,161,113,220,177,44,34,170,119,116,105,87,73,254,71,109,255,196,206,110,178,212,198,161,154,1,70,176,223,101,191};
static const unsigned char precomputed_mGnP_ed25519_P_339[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_340[] = {224,94,201,150,232,112,183,146,255,138,134,238,99,88,158,182,61,177,227,14,17,91,158,174,48,176,173,5,205,239,230,170,0};
static const unsigned char precomputed_mGnP_ed25519_m_340[] = {84,115,164,68,237,123,165,24,137,131,180,186,211,200,214,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_mGnP_ed25519_n_340[] = {82,246,106,134,160,89,219,146,142,18,74,49,130,60,181,60,207,126,242,60,176,139,135,53,65,110,12,97,128,255,11,75,159,9,137,129,117,115,123,196,21,179,99,174,233,50,184,28,130,213,143,128,182,15,58,220,10,113,187,227,194,166,135,88};
static const unsigned char precomputed_mGnP_ed25519_P_340[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_341[] = {213,91,138,174,165,239,154,58,220,159,225,44,36,155,243,133,233,254,115,155,116,217,156,168,151,64,1,186,141,135,154,150,0};
static const unsigned char precomputed_mGnP_ed25519_m_341[] = {85,115,164,68,237,123,165,24,137,131,180,186,211,200,214,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_mGnP_ed25519_n_341[] = {49,221,118,84,30,0,75,45,3,171,131,185,182,74,226,185,70,12,84,167,134,141,199,39,99,199,8,52,232,77,2,9,240,78,112,238,107,183,98,190,39,74,210,234,171,147,164,25,27,160,164,218,27,242,72,8,150,110,51,79,163,198,40,98};
static const unsigned char precomputed_mGnP_ed25519_P_341[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_342[] = {143,84,85,128,217,159,207,201,36,86,110,46,7,233,187,133,135,215,47,222,53,66,202,120,15,144,32,102,69,94,137,124,0};
static const unsigned char precomputed_mGnP_ed25519_m_342[] = {86,115,164,68,237,123,165,24,137,131,180,186,211,200,214,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_mGnP_ed25519_n_342[] = {247,168,137,173,170,10,227,83,74,20,183,235,68,13,64,166,7,181,253,160,56,43,134,244,43,87,121,10,233,208,240,178,122,247,103,172,144,76,21,97,20,93,5,196,188,143,229,204,157,63,4,77,77,168,171,141,218,102,124,170,30,166,95,8};
static const unsigned char precomputed_mGnP_ed25519_P_342[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_343[] = {42,95,236,32,166,111,161,65,195,233,122,226,79,173,78,182,174,201,22,137,86,159,15,168,140,220,231,33,130,110,236,154,0};
static const unsigned char precomputed_mGnP_ed25519_m_343[] = {87,115,164,68,237,123,165,24,137,131,180,186,211,200,214,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144};
static const unsigned char precomputed_mGnP_ed25519_n_343[] = {51,98,239,173,208,3,63,174,158,136,208,217,227,36,70,101,176,204,39,70,243,82,93,108,115,134,21,239,98,137,214,160,203,228,22,213,231,207,19,231,28,1,59,22,183,17,216,169,114,17,147,213,217,121,190,72,3,14,124,69,60,206,171,160};
static const unsigned char precomputed_mGnP_ed25519_P_343[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_344[] = {107,87,183,201,49,107,199,199,120,7,144,175,111,118,154,130,87,250,252,78,151,145,242,65,175,147,72,83,179,171,205,96,0};
static const unsigned char precomputed_mGnP_ed25519_m_344[] = {64,71,154,161,7,223,183,112,95,32,172,93,178,194,181,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_mGnP_ed25519_n_344[] = {111,7,226,59,200,106,221,190,36,201,2,146,219,147,218,137,32,91,187,72,6,219,229,115,97,107,173,64,142,123,122,28,72,31,205,226,40,250,40,247,33,64,84,180,36,69,46,97,0,35,23,194,158,5,144,203,45,168,162,166,236,41,70,207};
static const unsigned char precomputed_mGnP_ed25519_P_344[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_345[] = {161,13,241,12,129,212,31,40,34,220,87,101,255,166,72,62,179,116,133,235,254,165,112,146,19,252,121,167,196,154,105,111,0};
static const unsigned char precomputed_mGnP_ed25519_m_345[] = {65,71,154,161,7,223,183,112,95,32,172,93,178,194,181,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_mGnP_ed25519_n_345[] = {129,61,72,222,141,150,85,26,170,207,228,33,137,105,16,211,115,34,58,71,73,171,169,216,125,252,129,40,15,31,21,56,18,106,176,33,49,216,109,26,212,73,79,97,81,86,43,30,174,64,80,179,0,188,155,79,138,11,153,13,110,213,237,175};
static const unsigned char precomputed_mGnP_ed25519_P_345[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_346[] = {167,124,86,39,65,240,122,226,141,151,207,80,9,245,53,222,21,98,85,75,198,174,215,78,157,252,30,254,60,94,248,176,0};
static const unsigned char precomputed_mGnP_ed25519_m_346[] = {66,71,154,161,7,223,183,112,95,32,172,93,178,194,181,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_mGnP_ed25519_n_346[] = {209,17,79,33,55,134,253,134,147,83,199,14,59,11,168,14,45,16,196,36,119,135,77,8,152,218,98,55,254,81,228,13,142,231,35,236,110,25,108,160,153,128,164,186,155,251,29,14,107,1,253,202,46,61,94,246,170,134,222,25,65,95,110,101};
static const unsigned char precomputed_mGnP_ed25519_P_346[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_347[] = {151,68,13,33,225,23,167,125,73,96,183,15,14,216,217,95,88,58,211,122,40,119,232,228,61,42,119,13,148,61,167,198,0};
static const unsigned char precomputed_mGnP_ed25519_m_347[] = {67,71,154,161,7,223,183,112,95,32,172,93,178,194,181,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_mGnP_ed25519_n_347[] = {101,157,162,172,19,142,30,114,118,182,40,14,162,159,49,44,237,36,92,186,190,254,57,15,83,64,23,218,155,211,181,90,66,190,54,97,241,235,22,55,108,186,211,197,4,120,126,121,90,89,204,123,204,240,211,103,213,92,67,62,105,84,173,146};
static const unsigned char precomputed_mGnP_ed25519_P_347[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_348[] = {29,64,140,55,144,149,55,224,198,63,92,7,69,0,136,45,24,82,104,57,30,55,41,199,235,124,194,82,223,72,100,8,0};
static const unsigned char precomputed_mGnP_ed25519_m_348[] = {68,71,154,161,7,223,183,112,95,32,172,93,178,194,181,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160};
static const unsigned char precomputed_mGnP_ed25519_n_348[] = {238,251,68,84,101,205,149,174,128,1,40,159,141,164,14,133,156,32,18,136,178,28,0,146,244,168,55,110,43,153,61,215,119,142,206,230,28,183,69,202,197,101,212,43,22,142,147,224,136,152,12,199,23,44,56,115,1,125,240,114,162,199,184,95};
static const unsigned char precomputed_mGnP_ed25519_P_348[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_349[] = {60,130,153,73,59,48,191,202,61,200,238,142,199,112,33,88,165,116,158,3,69,72,76,186,160,50,231,109,135,145,83,218,0};
static const unsigned char precomputed_mGnP_ed25519_m_349[] = {45,27,144,254,33,66,202,200,53,189,163,0,145,188,148,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_mGnP_ed25519_n_349[] = {242,150,2,165,84,34,81,8,107,135,249,24,79,154,79,242,142,110,145,130,59,36,231,78,120,121,247,237,195,230,16,196,224,217,107,40,16,36,125,111,132,223,231,226,34,125,55,68,99,110,239,95,86,175,195,254,245,196,111,140,180,70,254,130};
static const unsigned char precomputed_mGnP_ed25519_P_349[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_350[] = {144,78,239,149,207,245,233,27,9,216,167,214,66,192,209,118,136,88,74,211,70,66,246,4,68,236,183,74,245,108,31,4,0};
static const unsigned char precomputed_mGnP_ed25519_m_350[] = {46,27,144,254,33,66,202,200,53,189,163,0,145,188,148,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_mGnP_ed25519_n_350[] = {192,231,21,241,26,139,85,34,175,61,240,104,52,214,36,95,53,53,232,102,99,41,63,229,28,252,196,85,59,124,125,95,173,80,173,154,6,108,7,182,232,234,69,67,84,41,216,71,133,181,134,11,247,212,15,241,136,48,230,39,217,106,173,224};
static const unsigned char precomputed_mGnP_ed25519_P_350[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_351[] = {113,134,181,67,145,81,155,62,247,142,132,150,217,31,154,56,50,145,22,135,5,110,55,214,116,148,183,50,119,158,31,222,0};
static const unsigned char precomputed_mGnP_ed25519_m_351[] = {47,27,144,254,33,66,202,200,53,189,163,0,145,188,148,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_mGnP_ed25519_n_351[] = {164,8,208,190,45,234,120,146,85,80,227,72,167,241,209,116,240,80,133,225,76,59,241,30,148,151,24,15,175,16,118,111,96,92,126,22,249,175,208,198,196,211,195,18,224,150,140,90,67,109,80,204,136,198,215,63,244,252,74,255,236,216,224,60};
static const unsigned char precomputed_mGnP_ed25519_P_351[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_352[] = {184,206,207,102,188,77,48,17,171,189,214,230,91,159,166,170,12,59,148,222,7,211,64,77,189,48,209,121,221,92,124,194,0};
static const unsigned char precomputed_mGnP_ed25519_m_352[] = {48,27,144,254,33,66,202,200,53,189,163,0,145,188,148,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_mGnP_ed25519_n_352[] = {143,68,129,48,186,217,28,124,178,53,148,75,164,38,16,58,21,177,97,27,228,98,104,59,49,159,154,179,23,145,191,190,9,36,90,228,173,33,59,159,119,198,226,45,207,50,27,103,113,137,240,67,50,59,251,147,91,134,239,122,166,37,6,136};
static const unsigned char precomputed_mGnP_ed25519_P_352[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_353[] = {2,22,252,88,25,172,72,12,102,252,174,2,150,229,83,32,193,245,184,31,197,69,112,148,56,125,251,193,35,192,191,204,0};
static const unsigned char precomputed_mGnP_ed25519_m_353[] = {49,27,144,254,33,66,202,200,53,189,163,0,145,188,148,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176};
static const unsigned char precomputed_mGnP_ed25519_n_353[] = {67,93,192,31,207,9,240,174,18,59,30,165,76,64,27,40,112,70,105,99,119,62,225,154,99,73,179,3,33,249,21,14,128,197,37,106,10,254,154,218,74,131,249,114,165,34,233,63,117,174,15,152,99,36,7,51,167,130,163,73,67,146,171,151};
static const unsigned char precomputed_mGnP_ed25519_P_353[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_354[] = {104,13,88,37,195,21,231,139,128,98,10,254,229,228,227,179,97,39,143,162,161,231,172,42,183,52,101,79,202,160,89,121,0};
static const unsigned char precomputed_mGnP_ed25519_m_354[] = {26,239,133,91,60,165,220,32,12,90,155,163,111,182,115,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_mGnP_ed25519_n_354[] = {192,3,32,202,44,212,135,27,253,102,83,247,102,120,34,9,97,46,96,214,13,46,146,219,117,109,182,22,239,16,44,217,92,157,26,91,29,83,156,90,75,141,187,14,145,91,234,237,9,156,69,145,68,148,151,19,235,236,106,207,245,145,180,2};
static const unsigned char precomputed_mGnP_ed25519_P_354[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_355[] = {69,151,42,251,202,228,228,125,8,58,250,246,177,174,98,45,124,79,242,90,217,154,158,221,94,53,40,74,188,172,239,152,0};
static const unsigned char precomputed_mGnP_ed25519_m_355[] = {27,239,133,91,60,165,220,32,12,90,155,163,111,182,115,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_mGnP_ed25519_n_355[] = {226,165,78,202,22,237,69,208,177,172,157,176,242,23,192,161,196,251,94,197,97,117,202,166,52,98,47,79,216,39,200,18,60,69,180,214,173,120,179,84,141,113,248,106,39,93,176,49,167,77,71,67,59,63,143,241,135,14,89,72,107,213,59,220};
static const unsigned char precomputed_mGnP_ed25519_P_355[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_356[] = {250,85,60,241,217,74,206,98,165,230,29,217,181,135,195,211,87,224,78,136,112,130,25,241,55,181,127,93,217,26,192,144,0};
static const unsigned char precomputed_mGnP_ed25519_m_356[] = {28,239,133,91,60,165,220,32,12,90,155,163,111,182,115,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_mGnP_ed25519_n_356[] = {98,9,78,12,22,50,70,109,92,255,65,81,205,129,89,30,144,247,160,216,103,106,119,11,167,55,101,207,183,94,94,241,20,138,73,41,70,20,70,42,95,186,118,151,177,240,148,227,203,3,216,217,152,182,91,61,192,210,188,176,8,24,101,18};
static const unsigned char precomputed_mGnP_ed25519_P_356[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_357[] = {24,80,228,12,222,181,124,77,167,65,183,88,53,93,144,100,31,172,179,152,175,236,84,148,228,245,66,85,24,219,169,242,0};
static const unsigned char precomputed_mGnP_ed25519_m_357[] = {29,239,133,91,60,165,220,32,12,90,155,163,111,182,115,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_mGnP_ed25519_n_357[] = {198,200,36,153,137,8,120,18,160,122,245,42,251,253,233,221,37,193,116,162,95,6,178,147,131,14,177,225,198,95,43,155,150,3,107,158,159,46,183,60,242,103,124,114,225,255,183,3,123,39,200,121,183,249,209,124,12,131,123,51,228,148,113,111};
static const unsigned char precomputed_mGnP_ed25519_P_357[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_358[] = {85,84,92,43,87,234,27,209,249,104,158,59,224,86,8,14,19,207,155,13,44,228,243,199,246,130,81,97,196,198,0,246,0};
static const unsigned char precomputed_mGnP_ed25519_m_358[] = {30,239,133,91,60,165,220,32,12,90,155,163,111,182,115,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192};
static const unsigned char precomputed_mGnP_ed25519_n_358[] = {122,4,92,214,25,28,246,55,44,13,231,113,24,72,149,92,51,68,240,203,18,0,70,173,78,32,167,134,92,104,199,99,82,80,25,88,90,89,60,254,168,86,220,244,249,64,247,100,86,186,152,178,81,255,159,104,33,37,222,251,64,229,139,118};
static const unsigned char precomputed_mGnP_ed25519_P_358[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_359[] = {220,58,109,151,43,113,175,178,120,58,144,99,30,177,249,150,108,223,248,5,249,213,201,227,33,135,216,126,21,162,181,247,0};
static const unsigned char precomputed_mGnP_ed25519_m_359[] = {7,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_mGnP_ed25519_n_359[] = {47,49,114,144,183,90,3,119,112,4,154,218,207,102,224,224,86,245,150,229,96,192,55,236,83,40,157,15,160,43,91,98,196,18,31,124,241,123,162,0,217,21,216,227,37,98,181,138,188,215,227,71,188,45,92,189,125,39,165,196,195,29,56,134};
static const unsigned char precomputed_mGnP_ed25519_P_359[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_360[] = {59,113,209,87,0,114,69,108,186,170,64,212,204,154,151,181,37,66,159,146,19,170,98,120,8,92,115,47,44,196,188,193,0};
static const unsigned char precomputed_mGnP_ed25519_m_360[] = {8,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_mGnP_ed25519_n_360[] = {30,241,146,172,103,176,178,250,28,84,107,190,117,45,113,248,38,195,142,117,188,59,90,202,12,50,59,150,8,127,46,10,0,98,116,164,225,118,172,253,66,13,56,184,43,136,53,215,42,201,123,82,137,196,84,207,167,173,115,7,46,234,24,169};
static const unsigned char precomputed_mGnP_ed25519_P_360[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_361[] = {56,222,22,7,140,75,23,172,124,105,178,2,253,153,81,25,221,109,33,161,188,96,237,198,252,52,207,193,129,206,151,178,0};
static const unsigned char precomputed_mGnP_ed25519_m_361[] = {9,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_mGnP_ed25519_n_361[] = {183,36,145,194,227,6,73,124,85,195,22,159,211,254,202,239,31,42,106,158,131,168,241,112,0,55,53,252,134,211,45,163,92,154,38,220,231,25,189,227,198,135,116,24,89,99,191,214,75,10,239,12,6,239,249,130,236,20,105,4,171,9,171,180};
static const unsigned char precomputed_mGnP_ed25519_P_361[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_362[] = {245,90,130,145,190,19,210,241,183,105,167,186,18,80,140,252,82,200,120,107,39,121,218,146,127,28,68,251,140,239,80,160,0};
static const unsigned char precomputed_mGnP_ed25519_m_362[] = {10,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_mGnP_ed25519_n_362[] = {252,105,66,142,48,138,13,125,229,34,10,52,33,36,178,168,209,198,250,99,118,213,133,59,112,228,72,58,83,34,125,99,248,182,162,8,173,237,39,252,41,107,173,253,175,1,243,205,54,4,227,49,243,158,54,75,166,50,71,242,32,128,43,56};
static const unsigned char precomputed_mGnP_ed25519_P_362[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_363[] = {230,64,205,67,11,110,247,200,27,87,233,239,74,186,255,214,252,39,63,152,177,149,118,58,151,48,198,17,68,26,108,30,0};
static const unsigned char precomputed_mGnP_ed25519_m_363[] = {11,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208};
static const unsigned char precomputed_mGnP_ed25519_n_363[] = {53,147,135,177,56,1,28,187,128,77,129,190,18,233,246,140,50,211,214,50,177,167,193,3,188,27,3,22,64,173,196,50,62,90,20,17,140,22,89,249,172,52,186,93,83,192,156,55,240,229,143,59,81,187,250,154,176,113,8,121,57,16,209,229};
static const unsigned char precomputed_mGnP_ed25519_P_363[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_364[] = {202,151,34,53,207,196,154,190,166,130,14,133,165,215,149,7,57,61,102,204,141,162,227,119,127,43,251,98,211,215,101,171,0};
static const unsigned char precomputed_mGnP_ed25519_m_364[] = {244,150,113,21,113,107,1,209,184,147,138,233,44,170,49,36,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_mGnP_ed25519_n_364[] = {115,157,44,194,143,197,141,255,115,244,100,98,189,188,176,3,245,227,18,1,123,25,153,126,152,12,80,95,178,190,166,105,130,18,233,201,16,143,63,81,204,37,60,1,223,64,181,69,58,142,3,230,100,21,114,9,108,69,172,65,19,116,43,141};
static const unsigned char precomputed_mGnP_ed25519_P_364[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_365[] = {93,31,135,74,199,245,79,232,9,198,24,117,107,129,92,233,221,106,52,219,152,205,77,52,40,146,180,3,119,117,193,132,0};
static const unsigned char precomputed_mGnP_ed25519_m_365[] = {245,150,113,21,113,107,1,209,184,147,138,233,44,170,49,36,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_mGnP_ed25519_n_365[] = {178,68,121,209,110,66,188,205,118,78,254,215,133,224,197,187,172,27,152,154,45,18,223,187,86,114,32,234,234,79,13,15,168,176,248,171,122,69,31,47,39,32,118,114,73,112,126,164,115,136,34,36,217,160,141,8,62,125,156,237,246,185,76,56};
static const unsigned char precomputed_mGnP_ed25519_P_365[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_366[] = {155,121,125,129,139,85,185,112,47,147,237,162,29,203,7,225,108,226,253,61,13,173,157,234,164,50,234,95,198,101,27,60,0};
static const unsigned char precomputed_mGnP_ed25519_m_366[] = {246,150,113,21,113,107,1,209,184,147,138,233,44,170,49,36,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_mGnP_ed25519_n_366[] = {240,255,27,241,38,250,76,228,158,7,147,221,248,113,166,106,246,42,149,165,56,70,159,192,228,40,109,4,11,192,66,0,150,39,18,29,185,189,242,126,208,78,24,182,9,196,97,88,132,231,62,86,159,121,87,203,23,245,191,3,38,74,1,191};
static const unsigned char precomputed_mGnP_ed25519_P_366[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_367[] = {69,238,166,105,199,142,16,249,181,164,72,236,90,157,207,57,120,88,150,30,205,35,172,221,202,122,111,32,76,68,26,77,0};
static const unsigned char precomputed_mGnP_ed25519_m_367[] = {247,150,113,21,113,107,1,209,184,147,138,233,44,170,49,36,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_mGnP_ed25519_n_367[] = {153,135,153,14,56,81,112,25,105,144,201,54,149,227,71,108,165,69,42,37,221,40,119,233,21,121,69,29,72,8,90,241,61,133,7,196,188,243,146,217,27,5,169,165,39,252,4,61,30,248,195,193,222,228,125,190,52,136,10,142,25,142,107,237};
static const unsigned char precomputed_mGnP_ed25519_P_367[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_368[] = {120,55,129,150,171,221,57,132,17,173,121,224,193,44,123,202,215,106,38,191,111,213,183,125,109,67,178,68,77,133,11,97,0};
static const unsigned char precomputed_mGnP_ed25519_m_368[] = {248,150,113,21,113,107,1,209,184,147,138,233,44,170,49,36,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224};
static const unsigned char precomputed_mGnP_ed25519_n_368[] = {48,5,107,58,208,171,249,81,154,62,223,87,244,189,219,53,205,20,169,78,214,244,241,95,188,168,10,113,165,206,250,170,52,0,214,38,175,25,185,172,86,29,221,50,106,91,251,113,252,3,71,130,17,171,229,225,224,240,177,246,240,196,81,225};
static const unsigned char precomputed_mGnP_ed25519_P_368[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_369[] = {134,125,245,139,125,0,197,206,69,129,139,74,83,32,220,218,176,138,121,153,229,115,77,163,236,65,51,193,191,167,205,250,0};
static const unsigned char precomputed_mGnP_ed25519_m_369[] = {225,106,103,114,139,206,19,41,143,48,130,140,11,164,16,57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_mGnP_ed25519_n_369[] = {33,141,171,29,83,96,74,60,127,75,23,102,142,180,122,239,151,68,217,225,60,67,113,22,34,165,46,215,59,107,90,51,96,57,235,150,252,246,20,58,157,199,253,208,84,82,21,160,135,79,71,226,160,154,21,141,207,48,154,98,227,104,42,239};
static const unsigned char precomputed_mGnP_ed25519_P_369[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_370[] = {13,78,25,148,182,155,109,162,69,119,72,230,195,6,76,68,199,38,131,89,138,16,81,166,1,190,159,212,11,208,35,3,0};
static const unsigned char precomputed_mGnP_ed25519_m_370[] = {226,106,103,114,139,206,19,41,143,48,130,140,11,164,16,57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_mGnP_ed25519_n_370[] = {36,132,131,161,6,44,29,171,56,19,123,216,248,2,24,156,199,90,205,235,85,197,174,120,168,157,201,226,109,140,163,26,133,171,111,70,3,234,111,13,180,161,107,87,111,166,135,177,141,217,148,51,254,186,133,191,73,32,123,177,71,102,109,44};
static const unsigned char precomputed_mGnP_ed25519_P_370[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_371[] = {179,140,107,211,6,6,235,171,118,81,191,228,162,81,12,19,14,133,38,182,201,17,68,5,90,81,84,149,232,2,224,22,0};
static const unsigned char precomputed_mGnP_ed25519_m_371[] = {227,106,103,114,139,206,19,41,143,48,130,140,11,164,16,57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_mGnP_ed25519_n_371[] = {131,11,253,0,145,245,180,242,40,201,7,4,79,35,114,208,205,57,67,154,232,69,11,36,44,6,180,171,58,76,160,253,103,171,128,120,83,178,220,182,8,122,246,240,138,94,209,37,147,44,6,106,189,209,179,242,138,241,254,39,86,126,213,74};
static const unsigned char precomputed_mGnP_ed25519_P_371[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_372[] = {132,106,115,155,226,23,148,224,146,74,252,171,21,76,245,69,99,243,72,223,170,179,206,180,108,210,114,237,230,178,96,131,0};
static const unsigned char precomputed_mGnP_ed25519_m_372[] = {228,106,103,114,139,206,19,41,143,48,130,140,11,164,16,57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_mGnP_ed25519_n_372[] = {60,100,129,116,104,189,53,213,124,61,79,238,202,162,13,175,145,170,76,90,153,56,142,208,59,242,142,187,246,148,66,1,189,127,207,75,215,223,206,162,82,192,70,135,92,14,242,205,88,96,36,128,158,230,202,9,97,7,174,69,91,170,130,86};
static const unsigned char precomputed_mGnP_ed25519_P_372[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_373[] = {67,194,96,229,135,188,65,167,43,191,227,113,111,232,3,224,217,59,30,130,195,72,124,79,204,253,189,68,254,60,231,93,0};
static const unsigned char precomputed_mGnP_ed25519_m_373[] = {229,106,103,114,139,206,19,41,143,48,130,140,11,164,16,57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240};
static const unsigned char precomputed_mGnP_ed25519_n_373[] = {210,201,20,91,78,203,250,194,97,138,185,65,190,198,76,249,191,142,203,115,244,13,29,213,165,128,55,102,107,173,175,44,62,162,1,28,138,130,144,175,12,200,166,112,31,102,255,223,32,107,88,58,114,85,249,15,63,218,244,184,91,170,160,81};
static const unsigned char precomputed_mGnP_ed25519_P_373[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_374[] = {92,111,73,233,73,142,111,101,20,178,65,247,174,103,94,136,141,209,1,232,53,8,247,243,123,78,71,198,23,217,209,43,0};
static const unsigned char precomputed_mGnP_ed25519_m_374[] = {50,247,98,124,67,204,221,248,209,165,188,179,170,154,165,66,87,155,135,247,105,66,110,206,78,244,28,55,223,142,122,245};
static const unsigned char precomputed_mGnP_ed25519_n_374[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_374[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_375[] = {43,113,162,143,27,176,99,38,101,141,114,160,94,218,15,22,16,175,80,180,140,105,47,249,199,82,201,105,226,104,164,240,0};
static const unsigned char precomputed_mGnP_ed25519_m_375[] = {199,80,145,57,100,121,211,94,66,204,192,98,233,188,192,147,187,160,198,149,184,22,79,48,25,112,233,137,39,40,109,151};
static const unsigned char precomputed_mGnP_ed25519_n_375[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_375[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_376[] = {89,56,92,193,152,78,214,137,95,200,200,33,221,170,214,136,145,104,210,101,250,7,27,0,74,156,189,244,189,165,206,52,0};
static const unsigned char precomputed_mGnP_ed25519_m_376[] = {38,51,73,253,25,129,134,224,136,101,17,183,140,209,92,230,117,177,115,225,215,64,109,239,74,79,80,16,159,118,78,70};
static const unsigned char precomputed_mGnP_ed25519_n_376[] = {2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_376[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_377[] = {193,95,6,55,181,117,11,254,167,23,186,229,63,192,201,145,239,223,92,72,203,138,233,165,185,6,197,220,133,119,165,232,0};
static const unsigned char precomputed_mGnP_ed25519_m_377[] = {207,225,129,22,78,143,67,62,115,106,79,68,74,23,203,163,26,45,12,144,7,126,220,2,5,215,161,85,179,220,64,118};
static const unsigned char precomputed_mGnP_ed25519_n_377[] = {235,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_377[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_378[] = {197,131,130,136,241,231,68,243,47,93,142,114,56,221,219,231,30,210,244,146,93,98,56,59,238,66,127,99,99,128,239,236,0};
static const unsigned char precomputed_mGnP_ed25519_m_378[] = {143,143,26,149,89,167,83,31,99,155,20,230,251,58,16,10,159,151,255,168,239,127,216,141,63,151,167,91,107,105,190,204};
static const unsigned char precomputed_mGnP_ed25519_n_378[] = {236,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_378[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_379[] = {191,87,227,71,138,15,154,235,175,232,113,10,130,211,21,203,51,40,117,128,206,35,97,21,72,178,73,109,235,67,96,72,0};
static const unsigned char precomputed_mGnP_ed25519_m_379[] = {203,173,5,225,170,220,72,5,48,247,162,199,91,222,56,69,42,137,62,212,222,2,247,45,118,159,45,118,98,169,80,177};
static const unsigned char precomputed_mGnP_ed25519_n_379[] = {237,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_379[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_380[] = {131,212,171,36,16,149,185,0,135,90,49,184,201,172,245,156,114,161,90,135,23,202,193,34,25,46,217,168,224,5,141,82,0};
static const unsigned char precomputed_mGnP_ed25519_m_380[] = {50,38,100,17,163,75,209,175,7,113,155,30,230,56,114,123,89,174,82,136,109,163,208,116,196,111,94,236,102,234,200,254};
static const unsigned char precomputed_mGnP_ed25519_n_380[] = {238,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_380[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_381[] = {193,115,85,106,111,221,254,165,113,201,16,163,171,169,24,61,116,253,85,11,138,48,75,164,15,177,6,92,151,184,123,127,0};
static const unsigned char precomputed_mGnP_ed25519_m_381[] = {219,122,149,107,99,68,92,215,255,10,135,64,237,29,223,151,162,91,214,55,75,98,105,237,97,156,190,21,169,95,219,246};
static const unsigned char precomputed_mGnP_ed25519_n_381[] = {239,211,245,92,26,99,18,88,214,156,247,162,222,249,222,20,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_381[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_382[] = {67,24,60,142,158,194,215,0,144,100,179,117,195,226,171,165,7,133,229,136,23,86,248,75,222,107,126,192,51,148,124,186,0};
static const unsigned char precomputed_mGnP_ed25519_m_382[] = {133,229,77,66,2,162,48,32,154,115,112,182,77,118,116,76,35,213,17,59,252,53,65,188,20,131,128,155,16,161,69,50};
static const unsigned char precomputed_mGnP_ed25519_n_382[] = {216,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_382[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_383[] = {51,150,201,232,148,35,83,167,251,25,29,68,153,121,44,214,95,203,157,162,234,132,10,73,187,173,10,92,101,166,73,205,0};
static const unsigned char precomputed_mGnP_ed25519_m_383[] = {236,86,14,162,74,11,78,194,38,123,210,23,142,221,110,70,17,186,188,130,186,154,32,218,122,184,85,232,161,136,237,47};
static const unsigned char precomputed_mGnP_ed25519_n_383[] = {217,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_383[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_384[] = {57,17,126,156,117,24,26,132,180,69,128,29,179,228,8,245,110,149,136,120,180,75,206,54,154,127,247,168,229,50,10,27,1};
static const unsigned char precomputed_mGnP_ed25519_m_384[] = {221,85,115,26,126,40,239,29,93,138,5,86,167,130,212,18,238,116,116,139,91,12,114,106,169,97,190,73,234,174,129,8};
static const unsigned char precomputed_mGnP_ed25519_n_384[] = {218,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_384[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_385[] = {55,57,174,109,248,87,105,123,243,188,211,254,196,140,25,4,197,171,189,165,126,219,156,255,202,165,29,58,208,102,150,214,0};
static const unsigned char precomputed_mGnP_ed25519_m_385[] = {80,109,109,181,208,203,231,56,75,158,218,172,27,188,6,112,209,117,149,238,2,230,232,134,117,252,240,39,54,183,81,20};
static const unsigned char precomputed_mGnP_ed25519_n_385[] = {219,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_385[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_386[] = {160,185,162,19,77,208,102,189,88,75,193,241,35,243,137,103,36,188,141,236,144,84,131,108,130,33,11,121,26,159,219,36,1};
static const unsigned char precomputed_mGnP_ed25519_m_386[] = {3,81,105,1,61,71,43,50,136,142,81,144,185,21,171,124,165,159,134,240,227,71,130,32,250,115,117,52,149,166,185,1};
static const unsigned char precomputed_mGnP_ed25519_n_386[] = {220,167,235,185,52,198,36,176,172,57,239,69,189,243,189,41,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,32,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_386[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_387[] = {85,41,235,155,11,83,177,80,121,28,91,26,118,229,182,177,177,139,168,186,5,183,219,190,8,121,70,68,169,144,77,159,0};
static const unsigned char precomputed_mGnP_ed25519_m_387[] = {178,140,16,174,161,83,105,65,112,89,123,35,208,213,110,220,183,176,228,171,146,1,48,158,21,194,161,241,209,134,45,150};
static const unsigned char precomputed_mGnP_ed25519_n_387[] = {197,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_387[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_388[] = {173,230,69,55,143,97,61,182,36,10,43,59,148,50,33,144,235,77,53,16,158,188,1,123,151,90,43,163,59,255,193,11,0};
static const unsigned char precomputed_mGnP_ed25519_m_388[] = {22,192,122,10,159,17,132,226,79,39,32,139,39,19,142,152,201,222,228,74,183,247,32,94,12,208,5,234,237,22,214,223};
static const unsigned char precomputed_mGnP_ed25519_n_388[] = {198,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_388[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_389[] = {53,194,119,188,166,34,194,231,71,106,82,213,108,90,46,120,25,165,184,237,200,94,81,133,230,101,164,178,65,47,254,161,0};
static const unsigned char precomputed_mGnP_ed25519_m_389[] = {136,255,210,49,149,125,54,245,134,128,132,253,24,76,223,136,3,51,240,76,161,205,38,166,162,119,166,20,0,66,217,140};
static const unsigned char precomputed_mGnP_ed25519_n_389[] = {199,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_389[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_390[] = {11,35,121,102,35,193,18,24,192,127,100,212,6,183,52,109,209,123,6,11,75,95,242,26,88,48,22,58,73,18,241,88,0};
static const unsigned char precomputed_mGnP_ed25519_m_390[] = {7,150,213,243,14,198,34,76,161,85,199,153,43,159,241,223,125,255,149,229,129,138,199,232,139,228,212,75,87,165,63,231};
static const unsigned char precomputed_mGnP_ed25519_n_390[] = {200,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_390[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_391[] = {205,77,173,183,97,161,72,21,169,221,203,90,86,251,218,197,182,47,210,209,137,226,64,24,73,111,98,218,163,213,109,27,0};
static const unsigned char precomputed_mGnP_ed25519_m_391[] = {247,159,60,71,236,187,184,178,255,54,212,66,217,120,243,191,178,43,173,246,173,67,135,15,173,163,25,170,189,134,18,206};
static const unsigned char precomputed_mGnP_ed25519_n_391[] = {201,123,225,22,79,41,55,8,131,214,230,232,155,237,156,62,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,48,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_391[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_392[] = {84,212,56,170,67,12,212,250,250,176,38,213,171,69,178,145,143,198,27,180,156,184,43,249,135,105,218,127,168,183,254,212,0};
static const unsigned char precomputed_mGnP_ed25519_m_392[] = {44,180,35,154,7,80,216,223,203,245,123,183,155,73,217,51,136,62,220,160,204,254,181,236,113,150,172,66,50,123,198,129};
static const unsigned char precomputed_mGnP_ed25519_n_392[] = {178,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_392[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_393[] = {227,63,27,164,16,117,79,205,65,124,139,168,19,142,173,199,143,221,1,245,44,69,25,144,36,175,165,251,111,46,65,160,0};
static const unsigned char precomputed_mGnP_ed25519_m_393[] = {31,43,66,200,145,35,9,60,94,69,34,40,241,197,187,52,193,1,144,59,208,137,119,37,193,93,242,70,98,212,136,148};
static const unsigned char precomputed_mGnP_ed25519_n_393[] = {179,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_393[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_394[] = {217,26,152,92,14,142,43,99,247,14,146,140,100,248,104,61,134,101,216,218,124,143,61,163,8,94,71,136,74,122,165,78,0};
static const unsigned char precomputed_mGnP_ed25519_m_394[] = {140,57,86,79,204,177,197,92,68,95,243,160,104,39,40,204,190,202,47,186,185,167,122,221,183,213,83,59,52,224,127,161};
static const unsigned char precomputed_mGnP_ed25519_n_394[] = {180,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_394[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_395[] = {106,251,118,70,209,84,59,48,9,6,168,6,24,138,11,139,13,126,6,60,51,146,168,117,219,97,194,60,40,249,65,105,0};
static const unsigned char precomputed_mGnP_ed25519_m_395[] = {99,96,119,144,25,24,92,67,231,199,167,135,25,149,232,112,52,208,120,6,179,143,31,227,130,93,5,25,60,131,150,62};
static const unsigned char precomputed_mGnP_ed25519_n_395[] = {181,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_395[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_396[] = {252,89,218,3,30,102,86,183,132,87,18,197,4,215,77,56,202,238,31,155,212,158,19,58,138,17,139,181,94,221,9,199,0};
static const unsigned char precomputed_mGnP_ed25519_m_396[] = {151,58,22,113,38,153,67,59,3,178,208,145,145,212,14,206,79,32,244,156,231,173,26,150,208,144,167,51,14,235,0,136};
static const unsigned char precomputed_mGnP_ed25519_n_396[] = {182,79,215,115,105,140,73,96,89,115,222,139,122,231,123,83,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,64,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_396[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_397[] = {77,83,12,101,216,9,174,206,222,250,193,106,192,225,13,108,226,97,226,252,126,62,213,20,19,161,170,21,120,163,98,229,0};
static const unsigned char precomputed_mGnP_ed25519_m_397[] = {37,77,235,222,0,49,80,159,230,217,196,55,135,17,181,41,21,141,192,57,197,143,229,13,126,189,110,126,72,33,109,156};
static const unsigned char precomputed_mGnP_ed25519_n_397[] = {159,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_397[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_398[] = {92,139,4,122,179,64,4,41,101,143,233,68,52,183,242,114,196,153,24,121,248,105,33,102,218,164,91,242,246,98,60,183,0};
static const unsigned char precomputed_mGnP_ed25519_m_398[] = {105,129,189,232,233,65,53,212,88,101,152,62,50,244,218,143,3,184,151,35,126,241,195,108,171,194,187,152,176,108,235,178};
static const unsigned char precomputed_mGnP_ed25519_n_398[] = {160,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_398[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_399[] = {102,62,150,163,178,29,70,247,183,36,38,181,101,186,253,189,48,57,46,66,237,185,191,221,114,46,22,85,223,199,107,43,0};
static const unsigned char precomputed_mGnP_ed25519_m_399[] = {59,30,114,237,166,31,87,58,92,157,233,84,117,233,177,202,70,65,57,195,30,166,182,149,153,222,117,70,200,26,123,16};
static const unsigned char precomputed_mGnP_ed25519_n_399[] = {161,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_399[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_400[] = {220,66,142,134,197,190,19,60,223,57,208,34,173,111,6,236,243,76,211,22,156,210,232,246,56,253,173,191,250,245,188,242,0};
static const unsigned char precomputed_mGnP_ed25519_m_400[] = {128,104,203,124,234,142,36,185,56,244,121,47,130,59,86,182,216,246,9,230,25,55,88,129,51,134,144,69,83,207,213,54};
static const unsigned char precomputed_mGnP_ed25519_n_400[] = {162,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_400[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_401[] = {189,194,44,42,253,202,220,45,41,176,161,180,52,88,24,135,24,126,149,230,51,247,130,154,197,49,202,166,109,58,106,104,0};
static const unsigned char precomputed_mGnP_ed25519_m_401[] = {140,167,94,78,152,191,235,206,55,116,156,116,118,29,56,164,155,119,192,47,185,8,49,207,232,134,51,21,0,122,37,41};
static const unsigned char precomputed_mGnP_ed25519_n_401[] = {163,35,205,208,131,239,91,184,47,16,214,46,89,225,90,104,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,80,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_401[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_402[] = {143,49,184,94,164,189,147,102,207,142,147,2,195,121,83,109,38,216,80,240,72,184,189,62,88,91,52,144,144,230,28,18,0};
static const unsigned char precomputed_mGnP_ed25519_m_402[] = {99,93,96,152,17,198,47,118,62,236,136,5,96,202,97,95,150,55,161,108,241,73,106,45,147,71,224,227,192,152,132,59};
static const unsigned char precomputed_mGnP_ed25519_n_402[] = {140,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_402[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_403[] = {179,121,199,184,79,219,38,17,246,241,114,109,218,57,208,65,80,152,68,246,18,91,239,146,77,42,119,222,57,213,35,90,0};
static const unsigned char precomputed_mGnP_ed25519_m_403[] = {50,166,234,225,34,229,255,15,178,22,84,61,132,70,42,102,87,63,242,238,211,141,0,11,76,110,61,26,143,249,90,146};
static const unsigned char precomputed_mGnP_ed25519_n_403[] = {141,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_403[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_404[] = {192,55,197,97,88,67,73,231,202,36,46,22,238,185,214,23,1,212,234,34,114,85,197,191,38,60,6,144,217,226,94,34,0};
static const unsigned char precomputed_mGnP_ed25519_m_404[] = {32,144,214,166,58,254,157,90,160,187,105,254,248,223,140,97,77,59,42,155,14,128,232,92,79,232,63,19,120,123,106,218};
static const unsigned char precomputed_mGnP_ed25519_n_404[] = {142,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_404[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_405[] = {81,153,105,29,112,168,184,97,206,162,64,218,240,172,240,222,161,127,102,195,79,192,144,140,59,109,210,15,178,174,135,249,0};
static const unsigned char precomputed_mGnP_ed25519_m_405[] = {6,61,72,1,135,22,241,176,105,221,28,249,12,18,2,104,147,67,252,86,198,147,138,188,129,83,30,213,219,62,254,132};
static const unsigned char precomputed_mGnP_ed25519_n_405[] = {143,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_405[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_406[] = {212,34,0,27,170,123,138,62,30,39,77,89,83,252,58,29,246,66,12,73,164,166,37,13,131,1,57,252,159,145,109,140,0};
static const unsigned char precomputed_mGnP_ed25519_m_406[] = {192,249,60,81,169,130,20,17,72,107,212,6,121,135,232,73,184,255,9,121,216,243,10,56,16,31,6,58,22,156,50,137};
static const unsigned char precomputed_mGnP_ed25519_n_406[] = {144,247,194,45,158,82,110,16,6,173,205,209,55,219,57,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,96,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_406[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_407[] = {109,96,57,191,128,166,207,198,146,5,102,168,39,145,142,122,44,49,234,239,249,236,208,71,25,20,229,66,125,125,117,121,1};
static const unsigned char precomputed_mGnP_ed25519_m_407[] = {94,227,199,98,192,50,96,173,60,19,245,111,89,25,251,29,18,46,10,109,142,191,78,7,167,238,177,8,59,236,127,5};
static const unsigned char precomputed_mGnP_ed25519_n_407[] = {121,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_407[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_408[] = {139,49,174,184,131,138,111,1,112,29,219,133,72,43,115,199,26,253,88,66,156,118,111,50,233,167,195,112,186,132,203,128,0};
static const unsigned char precomputed_mGnP_ed25519_m_408[] = {255,132,240,211,207,145,87,205,47,232,98,219,80,114,27,146,140,251,184,248,119,17,140,31,139,118,188,127,219,205,235,157};
static const unsigned char precomputed_mGnP_ed25519_n_408[] = {122,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_408[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_409[] = {122,39,67,45,33,119,129,55,107,45,121,229,233,133,94,149,63,31,248,100,204,61,93,66,142,181,226,162,104,35,136,27,0};
static const unsigned char precomputed_mGnP_ed25519_m_409[] = {210,208,151,164,197,204,95,119,156,254,92,185,39,36,166,20,146,226,170,92,208,2,36,21,154,201,118,244,54,8,139,67};
static const unsigned char precomputed_mGnP_ed25519_n_409[] = {123,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_409[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_410[] = {66,238,205,20,186,85,219,78,26,148,41,85,205,167,9,66,199,0,183,154,231,65,193,252,46,118,41,15,103,6,136,188,0};
static const unsigned char precomputed_mGnP_ed25519_m_410[] = {233,9,29,35,13,184,111,142,181,11,8,67,172,39,110,183,146,236,102,139,246,201,130,162,213,136,175,163,80,232,165,149};
static const unsigned char precomputed_mGnP_ed25519_n_410[] = {124,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_410[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_411[] = {1,178,191,249,169,12,71,147,193,128,126,87,14,254,127,179,240,245,55,24,132,179,153,50,153,121,121,252,69,82,69,17,0};
static const unsigned char precomputed_mGnP_ed25519_m_411[] = {173,199,98,81,82,60,221,55,213,55,38,63,153,168,53,102,152,228,20,193,103,58,107,112,126,92,50,143,249,118,68,216};
static const unsigned char precomputed_mGnP_ed25519_n_411[] = {125,203,184,138,184,181,128,104,220,73,197,116,22,213,24,146,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,112,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_411[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_412[] = {31,48,154,117,119,23,111,150,139,102,229,169,127,51,95,197,180,84,3,245,91,6,43,194,90,209,50,37,211,85,179,19,1};
static const unsigned char precomputed_mGnP_ed25519_m_412[] = {39,60,76,87,192,84,166,117,217,108,218,19,97,46,177,222,89,179,54,158,115,21,48,132,36,136,97,218,98,60,78,1};
static const unsigned char precomputed_mGnP_ed25519_n_412[] = {102,159,174,231,210,24,147,192,178,230,188,23,245,206,247,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_412[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_413[] = {193,252,195,46,223,4,1,99,12,32,167,226,128,233,215,229,159,202,105,64,28,66,151,62,151,199,252,43,48,136,9,116,0};
static const unsigned char precomputed_mGnP_ed25519_m_413[] = {81,222,52,66,249,232,218,206,70,254,174,91,91,100,24,114,248,103,20,56,101,255,9,230,81,128,64,65,234,153,141,19};
static const unsigned char precomputed_mGnP_ed25519_n_413[] = {103,159,174,231,210,24,147,192,178,230,188,23,245,206,247,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_413[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_414[] = {244,124,164,37,184,116,50,48,106,21,224,238,117,43,73,138,174,60,7,183,227,54,132,2,29,151,73,153,60,28,236,222,0};
static const unsigned char precomputed_mGnP_ed25519_m_414[] = {99,132,115,213,182,7,130,71,29,90,224,218,150,39,153,192,138,31,157,32,177,211,108,168,101,99,124,239,217,25,92,203};
static const unsigned char precomputed_mGnP_ed25519_n_414[] = {104,159,174,231,210,24,147,192,178,230,188,23,245,206,247,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_414[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_415[] = {206,72,241,216,93,103,32,179,157,46,147,196,231,173,253,135,162,249,237,190,184,204,32,255,228,102,232,96,142,26,33,151,0};
static const unsigned char precomputed_mGnP_ed25519_m_415[] = {15,122,180,2,9,44,176,195,159,204,115,41,45,249,187,140,5,56,176,31,163,185,121,195,112,76,251,9,221,170,244,80};
static const unsigned char precomputed_mGnP_ed25519_n_415[] = {105,159,174,231,210,24,147,192,178,230,188,23,245,206,247,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_415[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_416[] = {73,57,183,92,248,126,190,127,79,46,210,216,111,55,200,14,133,63,197,38,64,45,70,33,206,208,20,46,98,34,230,206,0};
static const unsigned char precomputed_mGnP_ed25519_m_416[] = {136,98,123,97,76,16,179,239,13,107,189,181,195,213,60,84,118,130,156,8,217,64,253,127,91,44,26,196,21,89,108,45};
static const unsigned char precomputed_mGnP_ed25519_n_416[] = {106,159,174,231,210,24,147,192,178,230,188,23,245,206,247,166,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_416[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_417[] = {192,67,243,29,87,20,183,153,155,144,13,217,8,250,132,164,221,167,144,25,56,179,189,218,38,172,92,212,224,46,132,6,0};
static const unsigned char precomputed_mGnP_ed25519_m_417[] = {28,22,165,161,239,141,73,106,233,25,70,192,88,244,42,98,169,49,165,32,210,238,219,34,200,105,88,95,54,158,58,140};
static const unsigned char precomputed_mGnP_ed25519_n_417[] = {83,115,164,68,237,123,165,24,137,131,180,186,211,200,214,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_417[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_418[] = {64,137,248,177,99,62,163,121,95,37,168,249,209,243,229,210,175,50,8,59,156,246,24,202,165,63,139,7,176,163,39,74,0};
static const unsigned char precomputed_mGnP_ed25519_m_418[] = {215,192,143,58,239,126,237,20,206,72,197,232,182,25,0,45,52,86,193,159,30,191,251,167,232,208,46,9,89,101,231,212};
static const unsigned char precomputed_mGnP_ed25519_n_418[] = {84,115,164,68,237,123,165,24,137,131,180,186,211,200,214,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_418[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_419[] = {89,32,224,78,213,190,81,214,33,217,136,201,8,249,222,30,36,93,248,113,102,9,54,167,120,214,225,233,134,218,234,38,0};
static const unsigned char precomputed_mGnP_ed25519_m_419[] = {129,162,95,148,199,73,194,97,79,203,249,61,232,181,40,131,140,222,20,135,8,212,187,62,168,161,11,136,114,136,122,140};
static const unsigned char precomputed_mGnP_ed25519_n_419[] = {85,115,164,68,237,123,165,24,137,131,180,186,211,200,214,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_419[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_420[] = {109,23,152,137,75,50,45,172,208,149,96,184,20,135,24,127,253,38,251,18,9,199,149,105,113,223,220,5,217,150,201,219,0};
static const unsigned char precomputed_mGnP_ed25519_m_420[] = {145,234,29,155,101,52,70,142,75,2,170,91,5,134,84,229,6,95,225,60,96,223,224,118,63,233,241,116,211,40,75,168};
static const unsigned char precomputed_mGnP_ed25519_n_420[] = {86,115,164,68,237,123,165,24,137,131,180,186,211,200,214,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_420[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_421[] = {181,73,241,121,77,117,161,186,111,87,90,229,8,83,98,255,247,211,195,58,182,230,99,55,83,155,231,64,247,193,59,140,0};
static const unsigned char precomputed_mGnP_ed25519_m_421[] = {113,36,146,59,141,19,162,38,46,52,237,194,93,253,133,10,194,173,153,155,48,23,51,4,132,226,51,144,232,38,165,60};
static const unsigned char precomputed_mGnP_ed25519_n_421[] = {87,115,164,68,237,123,165,24,137,131,180,186,211,200,214,187,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_421[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_422[] = {66,4,105,102,148,236,87,97,148,215,173,135,174,138,13,68,133,51,136,133,186,182,231,141,107,139,235,119,82,245,105,170,0};
static const unsigned char precomputed_mGnP_ed25519_m_422[] = {6,40,82,117,144,41,251,52,60,131,12,54,5,140,177,190,117,184,35,40,199,103,135,39,106,254,91,189,60,248,98,228};
static const unsigned char precomputed_mGnP_ed25519_n_422[] = {64,71,154,161,7,223,183,112,95,32,172,93,178,194,181,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_422[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_423[] = {48,226,10,54,55,100,32,69,129,149,205,194,3,125,121,155,74,131,197,230,108,161,157,137,194,100,167,36,229,33,165,193,1};
static const unsigned char precomputed_mGnP_ed25519_m_423[] = {28,169,114,16,51,167,220,35,197,162,191,32,72,101,2,103,75,193,5,210,18,204,227,130,169,93,179,227,96,170,253,6};
static const unsigned char precomputed_mGnP_ed25519_n_423[] = {65,71,154,161,7,223,183,112,95,32,172,93,178,194,181,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_423[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_424[] = {231,8,246,164,143,148,161,253,65,71,108,202,141,60,199,147,139,242,33,186,72,20,60,155,159,158,83,99,5,22,178,51,0};
static const unsigned char precomputed_mGnP_ed25519_m_424[] = {100,47,31,235,31,23,113,235,193,136,124,242,213,243,53,20,117,154,99,37,198,84,90,73,121,48,87,38,160,5,7,252};
static const unsigned char precomputed_mGnP_ed25519_n_424[] = {66,71,154,161,7,223,183,112,95,32,172,93,178,194,181,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_424[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_425[] = {10,16,175,143,245,180,168,201,222,130,16,192,166,131,197,131,186,40,101,209,165,211,149,141,70,90,69,35,25,11,0,71,0};
static const unsigned char precomputed_mGnP_ed25519_m_425[] = {170,70,206,205,152,109,165,61,210,11,41,86,14,2,83,88,108,128,184,103,0,11,231,38,161,109,112,158,211,124,176,113};
static const unsigned char precomputed_mGnP_ed25519_n_425[] = {67,71,154,161,7,223,183,112,95,32,172,93,178,194,181,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_425[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_426[] = {49,14,135,194,64,118,131,71,147,86,240,36,0,84,236,181,248,160,78,34,92,15,251,220,52,205,35,173,32,26,254,221,0};
static const unsigned char precomputed_mGnP_ed25519_m_426[] = {230,16,12,191,217,110,63,224,23,76,95,88,44,220,85,148,205,195,226,4,45,223,179,51,118,243,195,114,144,10,141,162};
static const unsigned char precomputed_mGnP_ed25519_n_426[] = {68,71,154,161,7,223,183,112,95,32,172,93,178,194,181,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_426[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_427[] = {151,81,241,90,254,97,188,51,22,99,35,0,98,252,185,81,238,169,87,218,14,233,144,180,188,167,179,95,68,10,239,80,0};
static const unsigned char precomputed_mGnP_ed25519_m_427[] = {176,164,164,245,120,197,156,178,86,202,84,187,34,7,143,222,14,143,0,126,205,24,76,107,132,216,65,139,41,215,167,228};
static const unsigned char precomputed_mGnP_ed25519_n_427[] = {45,27,144,254,33,66,202,200,53,189,163,0,145,188,148,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_427[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_428[] = {199,12,217,16,33,40,150,157,102,254,145,11,225,147,203,111,108,241,153,203,75,126,212,241,7,87,184,133,130,43,207,206,0};
static const unsigned char precomputed_mGnP_ed25519_m_428[] = {8,167,78,91,212,5,58,231,156,236,156,222,129,97,87,137,123,99,106,70,149,27,223,149,240,121,81,100,13,206,28,242};
static const unsigned char precomputed_mGnP_ed25519_n_428[] = {46,27,144,254,33,66,202,200,53,189,163,0,145,188,148,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_428[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_429[] = {57,2,35,2,249,117,84,252,10,193,101,253,18,253,200,152,220,184,158,208,139,93,243,130,242,126,155,10,38,199,17,95,0};
static const unsigned char precomputed_mGnP_ed25519_m_429[] = {101,181,126,15,202,29,46,224,217,159,46,57,148,234,216,83,66,239,207,210,103,117,139,244,229,106,133,232,160,138,24,121};
static const unsigned char precomputed_mGnP_ed25519_n_429[] = {47,27,144,254,33,66,202,200,53,189,163,0,145,188,148,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_429[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_430[] = {52,192,15,192,93,12,221,74,117,58,250,69,235,168,67,105,167,2,18,0,86,57,40,64,153,37,128,2,245,153,241,246,0};
static const unsigned char precomputed_mGnP_ed25519_m_430[] = {100,66,147,234,214,28,28,240,14,101,245,90,142,103,58,181,228,202,131,240,78,140,116,47,150,234,49,127,72,103,80,224};
static const unsigned char precomputed_mGnP_ed25519_n_430[] = {48,27,144,254,33,66,202,200,53,189,163,0,145,188,148,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_430[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_431[] = {20,108,223,255,216,229,185,3,199,87,125,205,22,142,1,178,191,104,41,27,180,29,223,142,177,10,98,131,88,46,171,0,1};
static const unsigned char precomputed_mGnP_ed25519_m_431[] = {2,14,111,222,146,80,86,116,169,243,114,174,43,169,214,21,112,86,120,144,232,236,118,144,218,37,56,146,239,106,140,2};
static const unsigned char precomputed_mGnP_ed25519_n_431[] = {49,27,144,254,33,66,202,200,53,189,163,0,145,188,148,229,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,176,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_431[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_432[] = {220,142,170,70,232,30,214,33,169,132,215,116,251,58,20,181,93,168,134,141,27,143,153,254,37,169,41,206,134,165,202,135,0};
static const unsigned char precomputed_mGnP_ed25519_m_432[] = {147,149,67,253,234,99,236,222,19,235,90,6,170,177,147,72,114,156,132,186,209,148,65,198,254,196,180,169,82,168,134,121};
static const unsigned char precomputed_mGnP_ed25519_n_432[] = {26,239,133,91,60,165,220,32,12,90,155,163,111,182,115,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_432[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_433[] = {32,164,96,155,169,210,102,177,169,25,253,176,2,87,94,20,37,151,42,209,0,179,204,144,79,229,124,109,207,223,220,210,0};
static const unsigned char precomputed_mGnP_ed25519_m_433[] = {213,133,197,14,160,79,236,192,222,250,208,58,99,212,112,182,112,189,148,125,115,113,102,92,82,234,136,172,19,53,121,244};
static const unsigned char precomputed_mGnP_ed25519_n_433[] = {27,239,133,91,60,165,220,32,12,90,155,163,111,182,115,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_433[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_434[] = {173,217,144,241,67,183,157,124,112,42,195,91,35,203,123,26,101,7,88,81,97,239,4,144,128,10,124,83,19,189,88,180,0};
static const unsigned char precomputed_mGnP_ed25519_m_434[] = {89,220,44,248,163,151,31,162,75,79,110,60,200,78,72,147,113,147,211,61,112,105,234,102,250,173,150,180,175,92,106,237};
static const unsigned char precomputed_mGnP_ed25519_n_434[] = {28,239,133,91,60,165,220,32,12,90,155,163,111,182,115,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_434[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_435[] = {59,124,118,135,29,160,108,37,109,53,62,118,190,110,247,210,124,89,43,111,156,56,255,186,1,112,8,220,149,239,157,124,0};
static const unsigned char precomputed_mGnP_ed25519_m_435[] = {33,226,15,227,96,114,57,238,60,151,18,31,134,54,122,41,51,29,210,109,220,87,44,30,159,173,196,45,2,134,215,97};
static const unsigned char precomputed_mGnP_ed25519_n_435[] = {29,239,133,91,60,165,220,32,12,90,155,163,111,182,115,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_435[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_436[] = {137,86,52,37,120,11,30,74,8,75,233,212,226,242,151,94,222,128,160,61,168,174,186,31,115,152,24,153,223,149,27,216,1};
static const unsigned char precomputed_mGnP_ed25519_m_436[] = {97,102,149,173,172,66,165,6,96,35,166,63,184,140,9,147,126,34,183,200,13,196,15,162,166,169,164,23,115,131,185,11};
static const unsigned char precomputed_mGnP_ed25519_n_436[] = {30,239,133,91,60,165,220,32,12,90,155,163,111,182,115,250,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,192,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_436[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_437[] = {14,167,103,118,72,150,128,186,28,35,218,23,117,191,99,222,202,154,121,19,165,7,119,154,147,6,55,13,48,21,149,250,0};
static const unsigned char precomputed_mGnP_ed25519_m_437[] = {10,90,241,102,235,255,64,98,219,112,34,114,108,126,107,227,183,53,238,192,39,1,193,200,158,42,89,165,226,225,33,194};
static const unsigned char precomputed_mGnP_ed25519_n_437[] = {7,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_437[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_438[] = {119,151,223,244,98,123,1,159,97,84,22,210,81,2,174,157,19,142,200,52,82,205,202,164,122,240,209,243,39,79,186,124,0};
static const unsigned char precomputed_mGnP_ed25519_m_438[] = {237,73,159,211,126,107,188,227,76,134,90,77,105,34,227,200,119,76,224,107,123,28,253,10,1,109,151,99,48,185,5,253};
static const unsigned char precomputed_mGnP_ed25519_n_438[] = {8,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_438[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_439[] = {89,92,5,28,30,66,60,187,55,73,29,166,205,118,199,24,151,109,229,2,106,212,73,7,142,164,196,236,47,57,146,177,0};
static const unsigned char precomputed_mGnP_ed25519_m_439[] = {180,94,48,143,229,8,26,255,31,189,107,202,103,218,104,248,145,121,235,152,107,20,39,95,122,36,254,110,42,183,236,203};
static const unsigned char precomputed_mGnP_ed25519_n_439[] = {9,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_439[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_440[] = {20,201,161,43,60,94,246,136,130,93,58,117,247,8,239,119,154,255,96,228,236,148,172,125,62,154,27,195,186,255,36,170,0};
static const unsigned char precomputed_mGnP_ed25519_m_440[] = {233,197,40,79,78,143,213,1,1,110,128,177,128,194,188,171,22,249,50,109,38,92,161,78,80,177,149,169,211,130,146,47};
static const unsigned char precomputed_mGnP_ed25519_n_440[] = {10,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_440[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_441[] = {127,41,102,29,76,221,143,28,75,49,249,247,240,118,25,61,145,119,89,238,174,152,226,189,182,202,240,53,11,179,26,199,0};
static const unsigned char precomputed_mGnP_ed25519_m_441[] = {204,214,183,19,199,253,75,211,29,221,48,28,194,116,216,83,217,241,10,151,36,149,115,167,188,48,11,38,99,176,161,52};
static const unsigned char precomputed_mGnP_ed25519_n_441[] = {11,195,123,184,86,8,239,120,226,246,146,70,78,176,82,15,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,208,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_441[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_442[] = {135,249,172,252,232,177,128,137,229,250,248,226,60,73,76,188,207,60,220,221,124,108,27,4,162,186,132,202,182,200,190,54,0};
static const unsigned char precomputed_mGnP_ed25519_m_442[] = {27,132,165,245,134,148,241,185,242,229,18,16,135,90,99,75,136,215,240,224,43,204,224,57,160,217,207,126,249,77,209,249};
static const unsigned char precomputed_mGnP_ed25519_n_442[] = {244,150,113,21,113,107,1,209,184,147,138,233,44,170,49,36,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_442[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_443[] = {29,24,157,199,123,1,108,145,211,213,86,40,150,133,201,220,108,164,179,230,22,209,10,170,111,30,147,180,76,156,13,182,0};
static const unsigned char precomputed_mGnP_ed25519_m_443[] = {67,62,31,1,158,158,28,200,121,17,134,7,244,93,62,241,176,126,12,88,58,171,206,119,24,67,209,169,232,106,203,39};
static const unsigned char precomputed_mGnP_ed25519_n_443[] = {245,150,113,21,113,107,1,209,184,147,138,233,44,170,49,36,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_443[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_444[] = {229,237,148,21,59,195,201,18,37,134,153,193,144,197,124,157,71,129,106,76,130,106,247,30,87,247,201,44,101,236,57,243,0};
static const unsigned char precomputed_mGnP_ed25519_m_444[] = {247,125,106,221,240,122,104,215,76,78,240,21,167,68,180,80,118,45,209,46,175,43,172,86,121,232,19,150,71,16,225,109};
static const unsigned char precomputed_mGnP_ed25519_n_444[] = {246,150,113,21,113,107,1,209,184,147,138,233,44,170,49,36,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_444[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_445[] = {215,218,67,211,52,195,64,168,41,141,69,138,2,3,230,204,180,13,103,90,139,30,145,90,21,240,62,186,4,1,151,118,1};
static const unsigned char precomputed_mGnP_ed25519_m_445[] = {169,234,215,22,220,141,118,156,255,73,18,109,61,34,162,66,227,208,251,226,174,163,39,177,86,25,140,98,103,130,153,12};
static const unsigned char precomputed_mGnP_ed25519_n_445[] = {247,150,113,21,113,107,1,209,184,147,138,233,44,170,49,36,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_445[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_446[] = {249,122,140,8,101,24,105,169,158,64,151,121,147,201,152,242,112,137,24,226,240,1,247,125,153,44,235,179,132,2,244,175,0};
static const unsigned char precomputed_mGnP_ed25519_m_446[] = {177,110,244,29,255,64,176,62,10,94,6,171,191,248,16,172,46,49,93,91,238,106,67,76,85,155,46,10,40,194,168,216};
static const unsigned char precomputed_mGnP_ed25519_n_446[] = {248,150,113,21,113,107,1,209,184,147,138,233,44,170,49,36,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,224,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_446[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_447[] = {122,177,205,145,4,155,33,123,126,121,162,79,192,162,130,212,168,2,246,36,34,171,13,172,134,144,254,104,202,165,88,235,0};
static const unsigned char precomputed_mGnP_ed25519_m_447[] = {128,94,94,142,196,61,23,216,182,30,160,1,79,145,66,177,240,142,3,135,163,17,10,236,11,142,19,22,239,52,226,107};
static const unsigned char precomputed_mGnP_ed25519_n_447[] = {225,106,103,114,139,206,19,41,143,48,130,140,11,164,16,57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_447[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_448[] = {59,86,63,78,51,23,240,169,120,46,127,14,117,221,154,163,237,5,177,128,37,86,92,179,218,84,83,102,233,138,40,218,0};
static const unsigned char precomputed_mGnP_ed25519_m_448[] = {112,126,34,147,36,143,34,215,193,236,52,52,17,107,81,234,174,194,32,77,177,17,184,87,237,195,134,234,142,5,138,39};
static const unsigned char precomputed_mGnP_ed25519_n_448[] = {226,106,103,114,139,206,19,41,143,48,130,140,11,164,16,57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_448[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_449[] = {73,135,161,184,160,248,51,147,132,56,183,127,61,223,130,165,198,229,84,155,139,37,194,49,238,63,169,167,86,158,12,47,0};
static const unsigned char precomputed_mGnP_ed25519_m_449[] = {69,234,246,175,219,94,153,99,185,47,95,141,8,47,61,121,17,247,59,130,80,193,174,142,104,71,86,204,76,30,11,218};
static const unsigned char precomputed_mGnP_ed25519_n_449[] = {227,106,103,114,139,206,19,41,143,48,130,140,11,164,16,57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_449[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_450[] = {44,52,124,109,175,6,234,48,243,213,212,218,71,240,227,54,37,208,220,13,20,192,205,3,123,140,45,252,79,177,225,68,0};
static const unsigned char precomputed_mGnP_ed25519_m_450[] = {78,36,103,246,70,203,240,103,8,189,190,34,70,115,108,103,200,160,107,193,157,135,164,97,208,118,177,36,21,166,249,252};
static const unsigned char precomputed_mGnP_ed25519_n_450[] = {228,106,103,114,139,206,19,41,143,48,130,140,11,164,16,57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_450[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_451[] = {216,122,150,35,191,132,40,252,28,184,201,186,85,92,93,152,202,244,117,42,206,16,31,75,199,72,100,157,145,204,9,77,0};
static const unsigned char precomputed_mGnP_ed25519_m_451[] = {87,248,19,224,227,4,250,150,47,56,3,75,250,167,205,124,78,36,168,39,143,153,206,6,64,49,168,1,32,37,240,158};
static const unsigned char precomputed_mGnP_ed25519_n_451[] = {229,106,103,114,139,206,19,41,143,48,130,140,11,164,16,57,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,240,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_451[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_Q_452[] = {1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1};
static const unsigned char precomputed_mGnP_ed25519_m_452[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_n_452[] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
static const unsigned char precomputed_mGnP_ed25519_P_452[] = {10,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

static const struct {
  const unsigned char *Q;
  long long Qsize;
  const unsigned char *m;
  long long msize;
  const unsigned char *n;
  long long nsize;
  const unsigned char *P;
  long long Psize;
} precomputed_mGnP_ed25519[precomputed_mGnP_ed25519_NUM] = {
  {
    precomputed_mGnP_ed25519_Q_0,33,
    precomputed_mGnP_ed25519_m_0,32,
    precomputed_mGnP_ed25519_n_0,64,
    precomputed_mGnP_ed25519_P_0,32,
  },
  {
    precomputed_mGnP_ed25519_Q_1,33,
    precomputed_mGnP_ed25519_m_1,32,
    precomputed_mGnP_ed25519_n_1,64,
    precomputed_mGnP_ed25519_P_1,32,
  },
  {
    precomputed_mGnP_ed25519_Q_2,33,
    precomputed_mGnP_ed25519_m_2,32,
    precomputed_mGnP_ed25519_n_2,64,
    precomputed_mGnP_ed25519_P_2,32,
  },
  {
    precomputed_mGnP_ed25519_Q_3,33,
    precomputed_mGnP_ed25519_m_3,32,
    precomputed_mGnP_ed25519_n_3,64,
    precomputed_mGnP_ed25519_P_3,32,
  },
  {
    precomputed_mGnP_ed25519_Q_4,33,
    precomputed_mGnP_ed25519_m_4,32,
    precomputed_mGnP_ed25519_n_4,64,
    precomputed_mGnP_ed25519_P_4,32,
  },
  {
    precomputed_mGnP_ed25519_Q_5,33,
    precomputed_mGnP_ed25519_m_5,32,
    precomputed_mGnP_ed25519_n_5,64,
    precomputed_mGnP_ed25519_P_5,32,
  },
  {
    precomputed_mGnP_ed25519_Q_6,33,
    precomputed_mGnP_ed25519_m_6,32,
    precomputed_mGnP_ed25519_n_6,64,
    precomputed_mGnP_ed25519_P_6,32,
  },
  {
    precomputed_mGnP_ed25519_Q_7,33,
    precomputed_mGnP_ed25519_m_7,32,
    precomputed_mGnP_ed25519_n_7,64,
    precomputed_mGnP_ed25519_P_7,32,
  },
  {
    precomputed_mGnP_ed25519_Q_8,33,
    precomputed_mGnP_ed25519_m_8,32,
    precomputed_mGnP_ed25519_n_8,64,
    precomputed_mGnP_ed25519_P_8,32,
  },
  {
    precomputed_mGnP_ed25519_Q_9,33,
    precomputed_mGnP_ed25519_m_9,32,
    precomputed_mGnP_ed25519_n_9,64,
    precomputed_mGnP_ed25519_P_9,32,
  },
  {
    precomputed_mGnP_ed25519_Q_10,33,
    precomputed_mGnP_ed25519_m_10,32,
    precomputed_mGnP_ed25519_n_10,64,
    precomputed_mGnP_ed25519_P_10,32,
  },
  {
    precomputed_mGnP_ed25519_Q_11,33,
    precomputed_mGnP_ed25519_m_11,32,
    precomputed_mGnP_ed25519_n_11,64,
    precomputed_mGnP_ed25519_P_11,32,
  },
  {
    precomputed_mGnP_ed25519_Q_12,33,
    precomputed_mGnP_ed25519_m_12,32,
    precomputed_mGnP_ed25519_n_12,64,
    precomputed_mGnP_ed25519_P_12,32,
  },
  {
    precomputed_mGnP_ed25519_Q_13,33,
    precomputed_mGnP_ed25519_m_13,32,
    precomputed_mGnP_ed25519_n_13,64,
    precomputed_mGnP_ed25519_P_13,32,
  },
  {
    precomputed_mGnP_ed25519_Q_14,33,
    precomputed_mGnP_ed25519_m_14,32,
    precomputed_mGnP_ed25519_n_14,64,
    precomputed_mGnP_ed25519_P_14,32,
  },
  {
    precomputed_mGnP_ed25519_Q_15,33,
    precomputed_mGnP_ed25519_m_15,32,
    precomputed_mGnP_ed25519_n_15,64,
    precomputed_mGnP_ed25519_P_15,32,
  },
  {
    precomputed_mGnP_ed25519_Q_16,33,
    precomputed_mGnP_ed25519_m_16,32,
    precomputed_mGnP_ed25519_n_16,64,
    precomputed_mGnP_ed25519_P_16,32,
  },
  {
    precomputed_mGnP_ed25519_Q_17,33,
    precomputed_mGnP_ed25519_m_17,32,
    precomputed_mGnP_ed25519_n_17,64,
    precomputed_mGnP_ed25519_P_17,32,
  },
  {
    precomputed_mGnP_ed25519_Q_18,33,
    precomputed_mGnP_ed25519_m_18,32,
    precomputed_mGnP_ed25519_n_18,64,
    precomputed_mGnP_ed25519_P_18,32,
  },
  {
    precomputed_mGnP_ed25519_Q_19,33,
    precomputed_mGnP_ed25519_m_19,32,
    precomputed_mGnP_ed25519_n_19,64,
    precomputed_mGnP_ed25519_P_19,32,
  },
  {
    precomputed_mGnP_ed25519_Q_20,33,
    precomputed_mGnP_ed25519_m_20,32,
    precomputed_mGnP_ed25519_n_20,64,
    precomputed_mGnP_ed25519_P_20,32,
  },
  {
    precomputed_mGnP_ed25519_Q_21,33,
    precomputed_mGnP_ed25519_m_21,32,
    precomputed_mGnP_ed25519_n_21,64,
    precomputed_mGnP_ed25519_P_21,32,
  },
  {
    precomputed_mGnP_ed25519_Q_22,33,
    precomputed_mGnP_ed25519_m_22,32,
    precomputed_mGnP_ed25519_n_22,64,
    precomputed_mGnP_ed25519_P_22,32,
  },
  {
    precomputed_mGnP_ed25519_Q_23,33,
    precomputed_mGnP_ed25519_m_23,32,
    precomputed_mGnP_ed25519_n_23,64,
    precomputed_mGnP_ed25519_P_23,32,
  },
  {
    precomputed_mGnP_ed25519_Q_24,33,
    precomputed_mGnP_ed25519_m_24,32,
    precomputed_mGnP_ed25519_n_24,64,
    precomputed_mGnP_ed25519_P_24,32,
  },
  {
    precomputed_mGnP_ed25519_Q_25,33,
    precomputed_mGnP_ed25519_m_25,32,
    precomputed_mGnP_ed25519_n_25,64,
    precomputed_mGnP_ed25519_P_25,32,
  },
  {
    precomputed_mGnP_ed25519_Q_26,33,
    precomputed_mGnP_ed25519_m_26,32,
    precomputed_mGnP_ed25519_n_26,64,
    precomputed_mGnP_ed25519_P_26,32,
  },
  {
    precomputed_mGnP_ed25519_Q_27,33,
    precomputed_mGnP_ed25519_m_27,32,
    precomputed_mGnP_ed25519_n_27,64,
    precomputed_mGnP_ed25519_P_27,32,
  },
  {
    precomputed_mGnP_ed25519_Q_28,33,
    precomputed_mGnP_ed25519_m_28,32,
    precomputed_mGnP_ed25519_n_28,64,
    precomputed_mGnP_ed25519_P_28,32,
  },
  {
    precomputed_mGnP_ed25519_Q_29,33,
    precomputed_mGnP_ed25519_m_29,32,
    precomputed_mGnP_ed25519_n_29,64,
    precomputed_mGnP_ed25519_P_29,32,
  },
  {
    precomputed_mGnP_ed25519_Q_30,33,
    precomputed_mGnP_ed25519_m_30,32,
    precomputed_mGnP_ed25519_n_30,64,
    precomputed_mGnP_ed25519_P_30,32,
  },
  {
    precomputed_mGnP_ed25519_Q_31,33,
    precomputed_mGnP_ed25519_m_31,32,
    precomputed_mGnP_ed25519_n_31,64,
    precomputed_mGnP_ed25519_P_31,32,
  },
  {
    precomputed_mGnP_ed25519_Q_32,33,
    precomputed_mGnP_ed25519_m_32,32,
    precomputed_mGnP_ed25519_n_32,64,
    precomputed_mGnP_ed25519_P_32,32,
  },
  {
    precomputed_mGnP_ed25519_Q_33,33,
    precomputed_mGnP_ed25519_m_33,32,
    precomputed_mGnP_ed25519_n_33,64,
    precomputed_mGnP_ed25519_P_33,32,
  },
  {
    precomputed_mGnP_ed25519_Q_34,33,
    precomputed_mGnP_ed25519_m_34,32,
    precomputed_mGnP_ed25519_n_34,64,
    precomputed_mGnP_ed25519_P_34,32,
  },
  {
    precomputed_mGnP_ed25519_Q_35,33,
    precomputed_mGnP_ed25519_m_35,32,
    precomputed_mGnP_ed25519_n_35,64,
    precomputed_mGnP_ed25519_P_35,32,
  },
  {
    precomputed_mGnP_ed25519_Q_36,33,
    precomputed_mGnP_ed25519_m_36,32,
    precomputed_mGnP_ed25519_n_36,64,
    precomputed_mGnP_ed25519_P_36,32,
  },
  {
    precomputed_mGnP_ed25519_Q_37,33,
    precomputed_mGnP_ed25519_m_37,32,
    precomputed_mGnP_ed25519_n_37,64,
    precomputed_mGnP_ed25519_P_37,32,
  },
  {
    precomputed_mGnP_ed25519_Q_38,33,
    precomputed_mGnP_ed25519_m_38,32,
    precomputed_mGnP_ed25519_n_38,64,
    precomputed_mGnP_ed25519_P_38,32,
  },
  {
    precomputed_mGnP_ed25519_Q_39,33,
    precomputed_mGnP_ed25519_m_39,32,
    precomputed_mGnP_ed25519_n_39,64,
    precomputed_mGnP_ed25519_P_39,32,
  },
  {
    precomputed_mGnP_ed25519_Q_40,33,
    precomputed_mGnP_ed25519_m_40,32,
    precomputed_mGnP_ed25519_n_40,64,
    precomputed_mGnP_ed25519_P_40,32,
  },
  {
    precomputed_mGnP_ed25519_Q_41,33,
    precomputed_mGnP_ed25519_m_41,32,
    precomputed_mGnP_ed25519_n_41,64,
    precomputed_mGnP_ed25519_P_41,32,
  },
  {
    precomputed_mGnP_ed25519_Q_42,33,
    precomputed_mGnP_ed25519_m_42,32,
    precomputed_mGnP_ed25519_n_42,64,
    precomputed_mGnP_ed25519_P_42,32,
  },
  {
    precomputed_mGnP_ed25519_Q_43,33,
    precomputed_mGnP_ed25519_m_43,32,
    precomputed_mGnP_ed25519_n_43,64,
    precomputed_mGnP_ed25519_P_43,32,
  },
  {
    precomputed_mGnP_ed25519_Q_44,33,
    precomputed_mGnP_ed25519_m_44,32,
    precomputed_mGnP_ed25519_n_44,64,
    precomputed_mGnP_ed25519_P_44,32,
  },
  {
    precomputed_mGnP_ed25519_Q_45,33,
    precomputed_mGnP_ed25519_m_45,32,
    precomputed_mGnP_ed25519_n_45,64,
    precomputed_mGnP_ed25519_P_45,32,
  },
  {
    precomputed_mGnP_ed25519_Q_46,33,
    precomputed_mGnP_ed25519_m_46,32,
    precomputed_mGnP_ed25519_n_46,64,
    precomputed_mGnP_ed25519_P_46,32,
  },
  {
    precomputed_mGnP_ed25519_Q_47,33,
    precomputed_mGnP_ed25519_m_47,32,
    precomputed_mGnP_ed25519_n_47,64,
    precomputed_mGnP_ed25519_P_47,32,
  },
  {
    precomputed_mGnP_ed25519_Q_48,33,
    precomputed_mGnP_ed25519_m_48,32,
    precomputed_mGnP_ed25519_n_48,64,
    precomputed_mGnP_ed25519_P_48,32,
  },
  {
    precomputed_mGnP_ed25519_Q_49,33,
    precomputed_mGnP_ed25519_m_49,32,
    precomputed_mGnP_ed25519_n_49,64,
    precomputed_mGnP_ed25519_P_49,32,
  },
  {
    precomputed_mGnP_ed25519_Q_50,33,
    precomputed_mGnP_ed25519_m_50,32,
    precomputed_mGnP_ed25519_n_50,64,
    precomputed_mGnP_ed25519_P_50,32,
  },
  {
    precomputed_mGnP_ed25519_Q_51,33,
    precomputed_mGnP_ed25519_m_51,32,
    precomputed_mGnP_ed25519_n_51,64,
    precomputed_mGnP_ed25519_P_51,32,
  },
  {
    precomputed_mGnP_ed25519_Q_52,33,
    precomputed_mGnP_ed25519_m_52,32,
    precomputed_mGnP_ed25519_n_52,64,
    precomputed_mGnP_ed25519_P_52,32,
  },
  {
    precomputed_mGnP_ed25519_Q_53,33,
    precomputed_mGnP_ed25519_m_53,32,
    precomputed_mGnP_ed25519_n_53,64,
    precomputed_mGnP_ed25519_P_53,32,
  },
  {
    precomputed_mGnP_ed25519_Q_54,33,
    precomputed_mGnP_ed25519_m_54,32,
    precomputed_mGnP_ed25519_n_54,64,
    precomputed_mGnP_ed25519_P_54,32,
  },
  {
    precomputed_mGnP_ed25519_Q_55,33,
    precomputed_mGnP_ed25519_m_55,32,
    precomputed_mGnP_ed25519_n_55,64,
    precomputed_mGnP_ed25519_P_55,32,
  },
  {
    precomputed_mGnP_ed25519_Q_56,33,
    precomputed_mGnP_ed25519_m_56,32,
    precomputed_mGnP_ed25519_n_56,64,
    precomputed_mGnP_ed25519_P_56,32,
  },
  {
    precomputed_mGnP_ed25519_Q_57,33,
    precomputed_mGnP_ed25519_m_57,32,
    precomputed_mGnP_ed25519_n_57,64,
    precomputed_mGnP_ed25519_P_57,32,
  },
  {
    precomputed_mGnP_ed25519_Q_58,33,
    precomputed_mGnP_ed25519_m_58,32,
    precomputed_mGnP_ed25519_n_58,64,
    precomputed_mGnP_ed25519_P_58,32,
  },
  {
    precomputed_mGnP_ed25519_Q_59,33,
    precomputed_mGnP_ed25519_m_59,32,
    precomputed_mGnP_ed25519_n_59,64,
    precomputed_mGnP_ed25519_P_59,32,
  },
  {
    precomputed_mGnP_ed25519_Q_60,33,
    precomputed_mGnP_ed25519_m_60,32,
    precomputed_mGnP_ed25519_n_60,64,
    precomputed_mGnP_ed25519_P_60,32,
  },
  {
    precomputed_mGnP_ed25519_Q_61,33,
    precomputed_mGnP_ed25519_m_61,32,
    precomputed_mGnP_ed25519_n_61,64,
    precomputed_mGnP_ed25519_P_61,32,
  },
  {
    precomputed_mGnP_ed25519_Q_62,33,
    precomputed_mGnP_ed25519_m_62,32,
    precomputed_mGnP_ed25519_n_62,64,
    precomputed_mGnP_ed25519_P_62,32,
  },
  {
    precomputed_mGnP_ed25519_Q_63,33,
    precomputed_mGnP_ed25519_m_63,32,
    precomputed_mGnP_ed25519_n_63,64,
    precomputed_mGnP_ed25519_P_63,32,
  },
  {
    precomputed_mGnP_ed25519_Q_64,33,
    precomputed_mGnP_ed25519_m_64,32,
    precomputed_mGnP_ed25519_n_64,64,
    precomputed_mGnP_ed25519_P_64,32,
  },
  {
    precomputed_mGnP_ed25519_Q_65,33,
    precomputed_mGnP_ed25519_m_65,32,
    precomputed_mGnP_ed25519_n_65,64,
    precomputed_mGnP_ed25519_P_65,32,
  },
  {
    precomputed_mGnP_ed25519_Q_66,33,
    precomputed_mGnP_ed25519_m_66,32,
    precomputed_mGnP_ed25519_n_66,64,
    precomputed_mGnP_ed25519_P_66,32,
  },
  {
    precomputed_mGnP_ed25519_Q_67,33,
    precomputed_mGnP_ed25519_m_67,32,
    precomputed_mGnP_ed25519_n_67,64,
    precomputed_mGnP_ed25519_P_67,32,
  },
  {
    precomputed_mGnP_ed25519_Q_68,33,
    precomputed_mGnP_ed25519_m_68,32,
    precomputed_mGnP_ed25519_n_68,64,
    precomputed_mGnP_ed25519_P_68,32,
  },
  {
    precomputed_mGnP_ed25519_Q_69,33,
    precomputed_mGnP_ed25519_m_69,32,
    precomputed_mGnP_ed25519_n_69,64,
    precomputed_mGnP_ed25519_P_69,32,
  },
  {
    precomputed_mGnP_ed25519_Q_70,33,
    precomputed_mGnP_ed25519_m_70,32,
    precomputed_mGnP_ed25519_n_70,64,
    precomputed_mGnP_ed25519_P_70,32,
  },
  {
    precomputed_mGnP_ed25519_Q_71,33,
    precomputed_mGnP_ed25519_m_71,32,
    precomputed_mGnP_ed25519_n_71,64,
    precomputed_mGnP_ed25519_P_71,32,
  },
  {
    precomputed_mGnP_ed25519_Q_72,33,
    precomputed_mGnP_ed25519_m_72,32,
    precomputed_mGnP_ed25519_n_72,64,
    precomputed_mGnP_ed25519_P_72,32,
  },
  {
    precomputed_mGnP_ed25519_Q_73,33,
    precomputed_mGnP_ed25519_m_73,32,
    precomputed_mGnP_ed25519_n_73,64,
    precomputed_mGnP_ed25519_P_73,32,
  },
  {
    precomputed_mGnP_ed25519_Q_74,33,
    precomputed_mGnP_ed25519_m_74,32,
    precomputed_mGnP_ed25519_n_74,64,
    precomputed_mGnP_ed25519_P_74,32,
  },
  {
    precomputed_mGnP_ed25519_Q_75,33,
    precomputed_mGnP_ed25519_m_75,32,
    precomputed_mGnP_ed25519_n_75,64,
    precomputed_mGnP_ed25519_P_75,32,
  },
  {
    precomputed_mGnP_ed25519_Q_76,33,
    precomputed_mGnP_ed25519_m_76,32,
    precomputed_mGnP_ed25519_n_76,64,
    precomputed_mGnP_ed25519_P_76,32,
  },
  {
    precomputed_mGnP_ed25519_Q_77,33,
    precomputed_mGnP_ed25519_m_77,32,
    precomputed_mGnP_ed25519_n_77,64,
    precomputed_mGnP_ed25519_P_77,32,
  },
  {
    precomputed_mGnP_ed25519_Q_78,33,
    precomputed_mGnP_ed25519_m_78,32,
    precomputed_mGnP_ed25519_n_78,64,
    precomputed_mGnP_ed25519_P_78,32,
  },
  {
    precomputed_mGnP_ed25519_Q_79,33,
    precomputed_mGnP_ed25519_m_79,32,
    precomputed_mGnP_ed25519_n_79,64,
    precomputed_mGnP_ed25519_P_79,32,
  },
  {
    precomputed_mGnP_ed25519_Q_80,33,
    precomputed_mGnP_ed25519_m_80,32,
    precomputed_mGnP_ed25519_n_80,64,
    precomputed_mGnP_ed25519_P_80,32,
  },
  {
    precomputed_mGnP_ed25519_Q_81,33,
    precomputed_mGnP_ed25519_m_81,32,
    precomputed_mGnP_ed25519_n_81,64,
    precomputed_mGnP_ed25519_P_81,32,
  },
  {
    precomputed_mGnP_ed25519_Q_82,33,
    precomputed_mGnP_ed25519_m_82,32,
    precomputed_mGnP_ed25519_n_82,64,
    precomputed_mGnP_ed25519_P_82,32,
  },
  {
    precomputed_mGnP_ed25519_Q_83,33,
    precomputed_mGnP_ed25519_m_83,32,
    precomputed_mGnP_ed25519_n_83,64,
    precomputed_mGnP_ed25519_P_83,32,
  },
  {
    precomputed_mGnP_ed25519_Q_84,33,
    precomputed_mGnP_ed25519_m_84,32,
    precomputed_mGnP_ed25519_n_84,64,
    precomputed_mGnP_ed25519_P_84,32,
  },
  {
    precomputed_mGnP_ed25519_Q_85,33,
    precomputed_mGnP_ed25519_m_85,32,
    precomputed_mGnP_ed25519_n_85,64,
    precomputed_mGnP_ed25519_P_85,32,
  },
  {
    precomputed_mGnP_ed25519_Q_86,33,
    precomputed_mGnP_ed25519_m_86,32,
    precomputed_mGnP_ed25519_n_86,64,
    precomputed_mGnP_ed25519_P_86,32,
  },
  {
    precomputed_mGnP_ed25519_Q_87,33,
    precomputed_mGnP_ed25519_m_87,32,
    precomputed_mGnP_ed25519_n_87,64,
    precomputed_mGnP_ed25519_P_87,32,
  },
  {
    precomputed_mGnP_ed25519_Q_88,33,
    precomputed_mGnP_ed25519_m_88,32,
    precomputed_mGnP_ed25519_n_88,64,
    precomputed_mGnP_ed25519_P_88,32,
  },
  {
    precomputed_mGnP_ed25519_Q_89,33,
    precomputed_mGnP_ed25519_m_89,32,
    precomputed_mGnP_ed25519_n_89,64,
    precomputed_mGnP_ed25519_P_89,32,
  },
  {
    precomputed_mGnP_ed25519_Q_90,33,
    precomputed_mGnP_ed25519_m_90,32,
    precomputed_mGnP_ed25519_n_90,64,
    precomputed_mGnP_ed25519_P_90,32,
  },
  {
    precomputed_mGnP_ed25519_Q_91,33,
    precomputed_mGnP_ed25519_m_91,32,
    precomputed_mGnP_ed25519_n_91,64,
    precomputed_mGnP_ed25519_P_91,32,
  },
  {
    precomputed_mGnP_ed25519_Q_92,33,
    precomputed_mGnP_ed25519_m_92,32,
    precomputed_mGnP_ed25519_n_92,64,
    precomputed_mGnP_ed25519_P_92,32,
  },
  {
    precomputed_mGnP_ed25519_Q_93,33,
    precomputed_mGnP_ed25519_m_93,32,
    precomputed_mGnP_ed25519_n_93,64,
    precomputed_mGnP_ed25519_P_93,32,
  },
  {
    precomputed_mGnP_ed25519_Q_94,33,
    precomputed_mGnP_ed25519_m_94,32,
    precomputed_mGnP_ed25519_n_94,64,
    precomputed_mGnP_ed25519_P_94,32,
  },
  {
    precomputed_mGnP_ed25519_Q_95,33,
    precomputed_mGnP_ed25519_m_95,32,
    precomputed_mGnP_ed25519_n_95,64,
    precomputed_mGnP_ed25519_P_95,32,
  },
  {
    precomputed_mGnP_ed25519_Q_96,33,
    precomputed_mGnP_ed25519_m_96,32,
    precomputed_mGnP_ed25519_n_96,64,
    precomputed_mGnP_ed25519_P_96,32,
  },
  {
    precomputed_mGnP_ed25519_Q_97,33,
    precomputed_mGnP_ed25519_m_97,32,
    precomputed_mGnP_ed25519_n_97,64,
    precomputed_mGnP_ed25519_P_97,32,
  },
  {
    precomputed_mGnP_ed25519_Q_98,33,
    precomputed_mGnP_ed25519_m_98,32,
    precomputed_mGnP_ed25519_n_98,64,
    precomputed_mGnP_ed25519_P_98,32,
  },
  {
    precomputed_mGnP_ed25519_Q_99,33,
    precomputed_mGnP_ed25519_m_99,32,
    precomputed_mGnP_ed25519_n_99,64,
    precomputed_mGnP_ed25519_P_99,32,
  },
  {
    precomputed_mGnP_ed25519_Q_100,33,
    precomputed_mGnP_ed25519_m_100,32,
    precomputed_mGnP_ed25519_n_100,64,
    precomputed_mGnP_ed25519_P_100,32,
  },
  {
    precomputed_mGnP_ed25519_Q_101,33,
    precomputed_mGnP_ed25519_m_101,32,
    precomputed_mGnP_ed25519_n_101,64,
    precomputed_mGnP_ed25519_P_101,32,
  },
  {
    precomputed_mGnP_ed25519_Q_102,33,
    precomputed_mGnP_ed25519_m_102,32,
    precomputed_mGnP_ed25519_n_102,64,
    precomputed_mGnP_ed25519_P_102,32,
  },
  {
    precomputed_mGnP_ed25519_Q_103,33,
    precomputed_mGnP_ed25519_m_103,32,
    precomputed_mGnP_ed25519_n_103,64,
    precomputed_mGnP_ed25519_P_103,32,
  },
  {
    precomputed_mGnP_ed25519_Q_104,33,
    precomputed_mGnP_ed25519_m_104,32,
    precomputed_mGnP_ed25519_n_104,64,
    precomputed_mGnP_ed25519_P_104,32,
  },
  {
    precomputed_mGnP_ed25519_Q_105,33,
    precomputed_mGnP_ed25519_m_105,32,
    precomputed_mGnP_ed25519_n_105,64,
    precomputed_mGnP_ed25519_P_105,32,
  },
  {
    precomputed_mGnP_ed25519_Q_106,33,
    precomputed_mGnP_ed25519_m_106,32,
    precomputed_mGnP_ed25519_n_106,64,
    precomputed_mGnP_ed25519_P_106,32,
  },
  {
    precomputed_mGnP_ed25519_Q_107,33,
    precomputed_mGnP_ed25519_m_107,32,
    precomputed_mGnP_ed25519_n_107,64,
    precomputed_mGnP_ed25519_P_107,32,
  },
  {
    precomputed_mGnP_ed25519_Q_108,33,
    precomputed_mGnP_ed25519_m_108,32,
    precomputed_mGnP_ed25519_n_108,64,
    precomputed_mGnP_ed25519_P_108,32,
  },
  {
    precomputed_mGnP_ed25519_Q_109,33,
    precomputed_mGnP_ed25519_m_109,32,
    precomputed_mGnP_ed25519_n_109,64,
    precomputed_mGnP_ed25519_P_109,32,
  },
  {
    precomputed_mGnP_ed25519_Q_110,33,
    precomputed_mGnP_ed25519_m_110,32,
    precomputed_mGnP_ed25519_n_110,64,
    precomputed_mGnP_ed25519_P_110,32,
  },
  {
    precomputed_mGnP_ed25519_Q_111,33,
    precomputed_mGnP_ed25519_m_111,32,
    precomputed_mGnP_ed25519_n_111,64,
    precomputed_mGnP_ed25519_P_111,32,
  },
  {
    precomputed_mGnP_ed25519_Q_112,33,
    precomputed_mGnP_ed25519_m_112,32,
    precomputed_mGnP_ed25519_n_112,64,
    precomputed_mGnP_ed25519_P_112,32,
  },
  {
    precomputed_mGnP_ed25519_Q_113,33,
    precomputed_mGnP_ed25519_m_113,32,
    precomputed_mGnP_ed25519_n_113,64,
    precomputed_mGnP_ed25519_P_113,32,
  },
  {
    precomputed_mGnP_ed25519_Q_114,33,
    precomputed_mGnP_ed25519_m_114,32,
    precomputed_mGnP_ed25519_n_114,64,
    precomputed_mGnP_ed25519_P_114,32,
  },
  {
    precomputed_mGnP_ed25519_Q_115,33,
    precomputed_mGnP_ed25519_m_115,32,
    precomputed_mGnP_ed25519_n_115,64,
    precomputed_mGnP_ed25519_P_115,32,
  },
  {
    precomputed_mGnP_ed25519_Q_116,33,
    precomputed_mGnP_ed25519_m_116,32,
    precomputed_mGnP_ed25519_n_116,64,
    precomputed_mGnP_ed25519_P_116,32,
  },
  {
    precomputed_mGnP_ed25519_Q_117,33,
    precomputed_mGnP_ed25519_m_117,32,
    precomputed_mGnP_ed25519_n_117,64,
    precomputed_mGnP_ed25519_P_117,32,
  },
  {
    precomputed_mGnP_ed25519_Q_118,33,
    precomputed_mGnP_ed25519_m_118,32,
    precomputed_mGnP_ed25519_n_118,64,
    precomputed_mGnP_ed25519_P_118,32,
  },
  {
    precomputed_mGnP_ed25519_Q_119,33,
    precomputed_mGnP_ed25519_m_119,32,
    precomputed_mGnP_ed25519_n_119,64,
    precomputed_mGnP_ed25519_P_119,32,
  },
  {
    precomputed_mGnP_ed25519_Q_120,33,
    precomputed_mGnP_ed25519_m_120,32,
    precomputed_mGnP_ed25519_n_120,64,
    precomputed_mGnP_ed25519_P_120,32,
  },
  {
    precomputed_mGnP_ed25519_Q_121,33,
    precomputed_mGnP_ed25519_m_121,32,
    precomputed_mGnP_ed25519_n_121,64,
    precomputed_mGnP_ed25519_P_121,32,
  },
  {
    precomputed_mGnP_ed25519_Q_122,33,
    precomputed_mGnP_ed25519_m_122,32,
    precomputed_mGnP_ed25519_n_122,64,
    precomputed_mGnP_ed25519_P_122,32,
  },
  {
    precomputed_mGnP_ed25519_Q_123,33,
    precomputed_mGnP_ed25519_m_123,32,
    precomputed_mGnP_ed25519_n_123,64,
    precomputed_mGnP_ed25519_P_123,32,
  },
  {
    precomputed_mGnP_ed25519_Q_124,33,
    precomputed_mGnP_ed25519_m_124,32,
    precomputed_mGnP_ed25519_n_124,64,
    precomputed_mGnP_ed25519_P_124,32,
  },
  {
    precomputed_mGnP_ed25519_Q_125,33,
    precomputed_mGnP_ed25519_m_125,32,
    precomputed_mGnP_ed25519_n_125,64,
    precomputed_mGnP_ed25519_P_125,32,
  },
  {
    precomputed_mGnP_ed25519_Q_126,33,
    precomputed_mGnP_ed25519_m_126,32,
    precomputed_mGnP_ed25519_n_126,64,
    precomputed_mGnP_ed25519_P_126,32,
  },
  {
    precomputed_mGnP_ed25519_Q_127,33,
    precomputed_mGnP_ed25519_m_127,32,
    precomputed_mGnP_ed25519_n_127,64,
    precomputed_mGnP_ed25519_P_127,32,
  },
  {
    precomputed_mGnP_ed25519_Q_128,33,
    precomputed_mGnP_ed25519_m_128,32,
    precomputed_mGnP_ed25519_n_128,64,
    precomputed_mGnP_ed25519_P_128,32,
  },
  {
    precomputed_mGnP_ed25519_Q_129,33,
    precomputed_mGnP_ed25519_m_129,32,
    precomputed_mGnP_ed25519_n_129,64,
    precomputed_mGnP_ed25519_P_129,32,
  },
  {
    precomputed_mGnP_ed25519_Q_130,33,
    precomputed_mGnP_ed25519_m_130,32,
    precomputed_mGnP_ed25519_n_130,64,
    precomputed_mGnP_ed25519_P_130,32,
  },
  {
    precomputed_mGnP_ed25519_Q_131,33,
    precomputed_mGnP_ed25519_m_131,32,
    precomputed_mGnP_ed25519_n_131,64,
    precomputed_mGnP_ed25519_P_131,32,
  },
  {
    precomputed_mGnP_ed25519_Q_132,33,
    precomputed_mGnP_ed25519_m_132,32,
    precomputed_mGnP_ed25519_n_132,64,
    precomputed_mGnP_ed25519_P_132,32,
  },
  {
    precomputed_mGnP_ed25519_Q_133,33,
    precomputed_mGnP_ed25519_m_133,32,
    precomputed_mGnP_ed25519_n_133,64,
    precomputed_mGnP_ed25519_P_133,32,
  },
  {
    precomputed_mGnP_ed25519_Q_134,33,
    precomputed_mGnP_ed25519_m_134,32,
    precomputed_mGnP_ed25519_n_134,64,
    precomputed_mGnP_ed25519_P_134,32,
  },
  {
    precomputed_mGnP_ed25519_Q_135,33,
    precomputed_mGnP_ed25519_m_135,32,
    precomputed_mGnP_ed25519_n_135,64,
    precomputed_mGnP_ed25519_P_135,32,
  },
  {
    precomputed_mGnP_ed25519_Q_136,33,
    precomputed_mGnP_ed25519_m_136,32,
    precomputed_mGnP_ed25519_n_136,64,
    precomputed_mGnP_ed25519_P_136,32,
  },
  {
    precomputed_mGnP_ed25519_Q_137,33,
    precomputed_mGnP_ed25519_m_137,32,
    precomputed_mGnP_ed25519_n_137,64,
    precomputed_mGnP_ed25519_P_137,32,
  },
  {
    precomputed_mGnP_ed25519_Q_138,33,
    precomputed_mGnP_ed25519_m_138,32,
    precomputed_mGnP_ed25519_n_138,64,
    precomputed_mGnP_ed25519_P_138,32,
  },
  {
    precomputed_mGnP_ed25519_Q_139,33,
    precomputed_mGnP_ed25519_m_139,32,
    precomputed_mGnP_ed25519_n_139,64,
    precomputed_mGnP_ed25519_P_139,32,
  },
  {
    precomputed_mGnP_ed25519_Q_140,33,
    precomputed_mGnP_ed25519_m_140,32,
    precomputed_mGnP_ed25519_n_140,64,
    precomputed_mGnP_ed25519_P_140,32,
  },
  {
    precomputed_mGnP_ed25519_Q_141,33,
    precomputed_mGnP_ed25519_m_141,32,
    precomputed_mGnP_ed25519_n_141,64,
    precomputed_mGnP_ed25519_P_141,32,
  },
  {
    precomputed_mGnP_ed25519_Q_142,33,
    precomputed_mGnP_ed25519_m_142,32,
    precomputed_mGnP_ed25519_n_142,64,
    precomputed_mGnP_ed25519_P_142,32,
  },
  {
    precomputed_mGnP_ed25519_Q_143,33,
    precomputed_mGnP_ed25519_m_143,32,
    precomputed_mGnP_ed25519_n_143,64,
    precomputed_mGnP_ed25519_P_143,32,
  },
  {
    precomputed_mGnP_ed25519_Q_144,33,
    precomputed_mGnP_ed25519_m_144,32,
    precomputed_mGnP_ed25519_n_144,64,
    precomputed_mGnP_ed25519_P_144,32,
  },
  {
    precomputed_mGnP_ed25519_Q_145,33,
    precomputed_mGnP_ed25519_m_145,32,
    precomputed_mGnP_ed25519_n_145,64,
    precomputed_mGnP_ed25519_P_145,32,
  },
  {
    precomputed_mGnP_ed25519_Q_146,33,
    precomputed_mGnP_ed25519_m_146,32,
    precomputed_mGnP_ed25519_n_146,64,
    precomputed_mGnP_ed25519_P_146,32,
  },
  {
    precomputed_mGnP_ed25519_Q_147,33,
    precomputed_mGnP_ed25519_m_147,32,
    precomputed_mGnP_ed25519_n_147,64,
    precomputed_mGnP_ed25519_P_147,32,
  },
  {
    precomputed_mGnP_ed25519_Q_148,33,
    precomputed_mGnP_ed25519_m_148,32,
    precomputed_mGnP_ed25519_n_148,64,
    precomputed_mGnP_ed25519_P_148,32,
  },
  {
    precomputed_mGnP_ed25519_Q_149,33,
    precomputed_mGnP_ed25519_m_149,32,
    precomputed_mGnP_ed25519_n_149,64,
    precomputed_mGnP_ed25519_P_149,32,
  },
  {
    precomputed_mGnP_ed25519_Q_150,33,
    precomputed_mGnP_ed25519_m_150,32,
    precomputed_mGnP_ed25519_n_150,64,
    precomputed_mGnP_ed25519_P_150,32,
  },
  {
    precomputed_mGnP_ed25519_Q_151,33,
    precomputed_mGnP_ed25519_m_151,32,
    precomputed_mGnP_ed25519_n_151,64,
    precomputed_mGnP_ed25519_P_151,32,
  },
  {
    precomputed_mGnP_ed25519_Q_152,33,
    precomputed_mGnP_ed25519_m_152,32,
    precomputed_mGnP_ed25519_n_152,64,
    precomputed_mGnP_ed25519_P_152,32,
  },
  {
    precomputed_mGnP_ed25519_Q_153,33,
    precomputed_mGnP_ed25519_m_153,32,
    precomputed_mGnP_ed25519_n_153,64,
    precomputed_mGnP_ed25519_P_153,32,
  },
  {
    precomputed_mGnP_ed25519_Q_154,33,
    precomputed_mGnP_ed25519_m_154,32,
    precomputed_mGnP_ed25519_n_154,64,
    precomputed_mGnP_ed25519_P_154,32,
  },
  {
    precomputed_mGnP_ed25519_Q_155,33,
    precomputed_mGnP_ed25519_m_155,32,
    precomputed_mGnP_ed25519_n_155,64,
    precomputed_mGnP_ed25519_P_155,32,
  },
  {
    precomputed_mGnP_ed25519_Q_156,33,
    precomputed_mGnP_ed25519_m_156,32,
    precomputed_mGnP_ed25519_n_156,64,
    precomputed_mGnP_ed25519_P_156,32,
  },
  {
    precomputed_mGnP_ed25519_Q_157,33,
    precomputed_mGnP_ed25519_m_157,32,
    precomputed_mGnP_ed25519_n_157,64,
    precomputed_mGnP_ed25519_P_157,32,
  },
  {
    precomputed_mGnP_ed25519_Q_158,33,
    precomputed_mGnP_ed25519_m_158,32,
    precomputed_mGnP_ed25519_n_158,64,
    precomputed_mGnP_ed25519_P_158,32,
  },
  {
    precomputed_mGnP_ed25519_Q_159,33,
    precomputed_mGnP_ed25519_m_159,32,
    precomputed_mGnP_ed25519_n_159,64,
    precomputed_mGnP_ed25519_P_159,32,
  },
  {
    precomputed_mGnP_ed25519_Q_160,33,
    precomputed_mGnP_ed25519_m_160,32,
    precomputed_mGnP_ed25519_n_160,64,
    precomputed_mGnP_ed25519_P_160,32,
  },
  {
    precomputed_mGnP_ed25519_Q_161,33,
    precomputed_mGnP_ed25519_m_161,32,
    precomputed_mGnP_ed25519_n_161,64,
    precomputed_mGnP_ed25519_P_161,32,
  },
  {
    precomputed_mGnP_ed25519_Q_162,33,
    precomputed_mGnP_ed25519_m_162,32,
    precomputed_mGnP_ed25519_n_162,64,
    precomputed_mGnP_ed25519_P_162,32,
  },
  {
    precomputed_mGnP_ed25519_Q_163,33,
    precomputed_mGnP_ed25519_m_163,32,
    precomputed_mGnP_ed25519_n_163,64,
    precomputed_mGnP_ed25519_P_163,32,
  },
  {
    precomputed_mGnP_ed25519_Q_164,33,
    precomputed_mGnP_ed25519_m_164,32,
    precomputed_mGnP_ed25519_n_164,64,
    precomputed_mGnP_ed25519_P_164,32,
  },
  {
    precomputed_mGnP_ed25519_Q_165,33,
    precomputed_mGnP_ed25519_m_165,32,
    precomputed_mGnP_ed25519_n_165,64,
    precomputed_mGnP_ed25519_P_165,32,
  },
  {
    precomputed_mGnP_ed25519_Q_166,33,
    precomputed_mGnP_ed25519_m_166,32,
    precomputed_mGnP_ed25519_n_166,64,
    precomputed_mGnP_ed25519_P_166,32,
  },
  {
    precomputed_mGnP_ed25519_Q_167,33,
    precomputed_mGnP_ed25519_m_167,32,
    precomputed_mGnP_ed25519_n_167,64,
    precomputed_mGnP_ed25519_P_167,32,
  },
  {
    precomputed_mGnP_ed25519_Q_168,33,
    precomputed_mGnP_ed25519_m_168,32,
    precomputed_mGnP_ed25519_n_168,64,
    precomputed_mGnP_ed25519_P_168,32,
  },
  {
    precomputed_mGnP_ed25519_Q_169,33,
    precomputed_mGnP_ed25519_m_169,32,
    precomputed_mGnP_ed25519_n_169,64,
    precomputed_mGnP_ed25519_P_169,32,
  },
  {
    precomputed_mGnP_ed25519_Q_170,33,
    precomputed_mGnP_ed25519_m_170,32,
    precomputed_mGnP_ed25519_n_170,64,
    precomputed_mGnP_ed25519_P_170,32,
  },
  {
    precomputed_mGnP_ed25519_Q_171,33,
    precomputed_mGnP_ed25519_m_171,32,
    precomputed_mGnP_ed25519_n_171,64,
    precomputed_mGnP_ed25519_P_171,32,
  },
  {
    precomputed_mGnP_ed25519_Q_172,33,
    precomputed_mGnP_ed25519_m_172,32,
    precomputed_mGnP_ed25519_n_172,64,
    precomputed_mGnP_ed25519_P_172,32,
  },
  {
    precomputed_mGnP_ed25519_Q_173,33,
    precomputed_mGnP_ed25519_m_173,32,
    precomputed_mGnP_ed25519_n_173,64,
    precomputed_mGnP_ed25519_P_173,32,
  },
  {
    precomputed_mGnP_ed25519_Q_174,33,
    precomputed_mGnP_ed25519_m_174,32,
    precomputed_mGnP_ed25519_n_174,64,
    precomputed_mGnP_ed25519_P_174,32,
  },
  {
    precomputed_mGnP_ed25519_Q_175,33,
    precomputed_mGnP_ed25519_m_175,32,
    precomputed_mGnP_ed25519_n_175,64,
    precomputed_mGnP_ed25519_P_175,32,
  },
  {
    precomputed_mGnP_ed25519_Q_176,33,
    precomputed_mGnP_ed25519_m_176,32,
    precomputed_mGnP_ed25519_n_176,64,
    precomputed_mGnP_ed25519_P_176,32,
  },
  {
    precomputed_mGnP_ed25519_Q_177,33,
    precomputed_mGnP_ed25519_m_177,32,
    precomputed_mGnP_ed25519_n_177,64,
    precomputed_mGnP_ed25519_P_177,32,
  },
  {
    precomputed_mGnP_ed25519_Q_178,33,
    precomputed_mGnP_ed25519_m_178,32,
    precomputed_mGnP_ed25519_n_178,64,
    precomputed_mGnP_ed25519_P_178,32,
  },
  {
    precomputed_mGnP_ed25519_Q_179,33,
    precomputed_mGnP_ed25519_m_179,32,
    precomputed_mGnP_ed25519_n_179,64,
    precomputed_mGnP_ed25519_P_179,32,
  },
  {
    precomputed_mGnP_ed25519_Q_180,33,
    precomputed_mGnP_ed25519_m_180,32,
    precomputed_mGnP_ed25519_n_180,64,
    precomputed_mGnP_ed25519_P_180,32,
  },
  {
    precomputed_mGnP_ed25519_Q_181,33,
    precomputed_mGnP_ed25519_m_181,32,
    precomputed_mGnP_ed25519_n_181,64,
    precomputed_mGnP_ed25519_P_181,32,
  },
  {
    precomputed_mGnP_ed25519_Q_182,33,
    precomputed_mGnP_ed25519_m_182,32,
    precomputed_mGnP_ed25519_n_182,64,
    precomputed_mGnP_ed25519_P_182,32,
  },
  {
    precomputed_mGnP_ed25519_Q_183,33,
    precomputed_mGnP_ed25519_m_183,32,
    precomputed_mGnP_ed25519_n_183,64,
    precomputed_mGnP_ed25519_P_183,32,
  },
  {
    precomputed_mGnP_ed25519_Q_184,33,
    precomputed_mGnP_ed25519_m_184,32,
    precomputed_mGnP_ed25519_n_184,64,
    precomputed_mGnP_ed25519_P_184,32,
  },
  {
    precomputed_mGnP_ed25519_Q_185,33,
    precomputed_mGnP_ed25519_m_185,32,
    precomputed_mGnP_ed25519_n_185,64,
    precomputed_mGnP_ed25519_P_185,32,
  },
  {
    precomputed_mGnP_ed25519_Q_186,33,
    precomputed_mGnP_ed25519_m_186,32,
    precomputed_mGnP_ed25519_n_186,64,
    precomputed_mGnP_ed25519_P_186,32,
  },
  {
    precomputed_mGnP_ed25519_Q_187,33,
    precomputed_mGnP_ed25519_m_187,32,
    precomputed_mGnP_ed25519_n_187,64,
    precomputed_mGnP_ed25519_P_187,32,
  },
  {
    precomputed_mGnP_ed25519_Q_188,33,
    precomputed_mGnP_ed25519_m_188,32,
    precomputed_mGnP_ed25519_n_188,64,
    precomputed_mGnP_ed25519_P_188,32,
  },
  {
    precomputed_mGnP_ed25519_Q_189,33,
    precomputed_mGnP_ed25519_m_189,32,
    precomputed_mGnP_ed25519_n_189,64,
    precomputed_mGnP_ed25519_P_189,32,
  },
  {
    precomputed_mGnP_ed25519_Q_190,33,
    precomputed_mGnP_ed25519_m_190,32,
    precomputed_mGnP_ed25519_n_190,64,
    precomputed_mGnP_ed25519_P_190,32,
  },
  {
    precomputed_mGnP_ed25519_Q_191,33,
    precomputed_mGnP_ed25519_m_191,32,
    precomputed_mGnP_ed25519_n_191,64,
    precomputed_mGnP_ed25519_P_191,32,
  },
  {
    precomputed_mGnP_ed25519_Q_192,33,
    precomputed_mGnP_ed25519_m_192,32,
    precomputed_mGnP_ed25519_n_192,64,
    precomputed_mGnP_ed25519_P_192,32,
  },
  {
    precomputed_mGnP_ed25519_Q_193,33,
    precomputed_mGnP_ed25519_m_193,32,
    precomputed_mGnP_ed25519_n_193,64,
    precomputed_mGnP_ed25519_P_193,32,
  },
  {
    precomputed_mGnP_ed25519_Q_194,33,
    precomputed_mGnP_ed25519_m_194,32,
    precomputed_mGnP_ed25519_n_194,64,
    precomputed_mGnP_ed25519_P_194,32,
  },
  {
    precomputed_mGnP_ed25519_Q_195,33,
    precomputed_mGnP_ed25519_m_195,32,
    precomputed_mGnP_ed25519_n_195,64,
    precomputed_mGnP_ed25519_P_195,32,
  },
  {
    precomputed_mGnP_ed25519_Q_196,33,
    precomputed_mGnP_ed25519_m_196,32,
    precomputed_mGnP_ed25519_n_196,64,
    precomputed_mGnP_ed25519_P_196,32,
  },
  {
    precomputed_mGnP_ed25519_Q_197,33,
    precomputed_mGnP_ed25519_m_197,32,
    precomputed_mGnP_ed25519_n_197,64,
    precomputed_mGnP_ed25519_P_197,32,
  },
  {
    precomputed_mGnP_ed25519_Q_198,33,
    precomputed_mGnP_ed25519_m_198,32,
    precomputed_mGnP_ed25519_n_198,64,
    precomputed_mGnP_ed25519_P_198,32,
  },
  {
    precomputed_mGnP_ed25519_Q_199,33,
    precomputed_mGnP_ed25519_m_199,32,
    precomputed_mGnP_ed25519_n_199,64,
    precomputed_mGnP_ed25519_P_199,32,
  },
  {
    precomputed_mGnP_ed25519_Q_200,33,
    precomputed_mGnP_ed25519_m_200,32,
    precomputed_mGnP_ed25519_n_200,64,
    precomputed_mGnP_ed25519_P_200,32,
  },
  {
    precomputed_mGnP_ed25519_Q_201,33,
    precomputed_mGnP_ed25519_m_201,32,
    precomputed_mGnP_ed25519_n_201,64,
    precomputed_mGnP_ed25519_P_201,32,
  },
  {
    precomputed_mGnP_ed25519_Q_202,33,
    precomputed_mGnP_ed25519_m_202,32,
    precomputed_mGnP_ed25519_n_202,64,
    precomputed_mGnP_ed25519_P_202,32,
  },
  {
    precomputed_mGnP_ed25519_Q_203,33,
    precomputed_mGnP_ed25519_m_203,32,
    precomputed_mGnP_ed25519_n_203,64,
    precomputed_mGnP_ed25519_P_203,32,
  },
  {
    precomputed_mGnP_ed25519_Q_204,33,
    precomputed_mGnP_ed25519_m_204,32,
    precomputed_mGnP_ed25519_n_204,64,
    precomputed_mGnP_ed25519_P_204,32,
  },
  {
    precomputed_mGnP_ed25519_Q_205,33,
    precomputed_mGnP_ed25519_m_205,32,
    precomputed_mGnP_ed25519_n_205,64,
    precomputed_mGnP_ed25519_P_205,32,
  },
  {
    precomputed_mGnP_ed25519_Q_206,33,
    precomputed_mGnP_ed25519_m_206,32,
    precomputed_mGnP_ed25519_n_206,64,
    precomputed_mGnP_ed25519_P_206,32,
  },
  {
    precomputed_mGnP_ed25519_Q_207,33,
    precomputed_mGnP_ed25519_m_207,32,
    precomputed_mGnP_ed25519_n_207,64,
    precomputed_mGnP_ed25519_P_207,32,
  },
  {
    precomputed_mGnP_ed25519_Q_208,33,
    precomputed_mGnP_ed25519_m_208,32,
    precomputed_mGnP_ed25519_n_208,64,
    precomputed_mGnP_ed25519_P_208,32,
  },
  {
    precomputed_mGnP_ed25519_Q_209,33,
    precomputed_mGnP_ed25519_m_209,32,
    precomputed_mGnP_ed25519_n_209,64,
    precomputed_mGnP_ed25519_P_209,32,
  },
  {
    precomputed_mGnP_ed25519_Q_210,33,
    precomputed_mGnP_ed25519_m_210,32,
    precomputed_mGnP_ed25519_n_210,64,
    precomputed_mGnP_ed25519_P_210,32,
  },
  {
    precomputed_mGnP_ed25519_Q_211,33,
    precomputed_mGnP_ed25519_m_211,32,
    precomputed_mGnP_ed25519_n_211,64,
    precomputed_mGnP_ed25519_P_211,32,
  },
  {
    precomputed_mGnP_ed25519_Q_212,33,
    precomputed_mGnP_ed25519_m_212,32,
    precomputed_mGnP_ed25519_n_212,64,
    precomputed_mGnP_ed25519_P_212,32,
  },
  {
    precomputed_mGnP_ed25519_Q_213,33,
    precomputed_mGnP_ed25519_m_213,32,
    precomputed_mGnP_ed25519_n_213,64,
    precomputed_mGnP_ed25519_P_213,32,
  },
  {
    precomputed_mGnP_ed25519_Q_214,33,
    precomputed_mGnP_ed25519_m_214,32,
    precomputed_mGnP_ed25519_n_214,64,
    precomputed_mGnP_ed25519_P_214,32,
  },
  {
    precomputed_mGnP_ed25519_Q_215,33,
    precomputed_mGnP_ed25519_m_215,32,
    precomputed_mGnP_ed25519_n_215,64,
    precomputed_mGnP_ed25519_P_215,32,
  },
  {
    precomputed_mGnP_ed25519_Q_216,33,
    precomputed_mGnP_ed25519_m_216,32,
    precomputed_mGnP_ed25519_n_216,64,
    precomputed_mGnP_ed25519_P_216,32,
  },
  {
    precomputed_mGnP_ed25519_Q_217,33,
    precomputed_mGnP_ed25519_m_217,32,
    precomputed_mGnP_ed25519_n_217,64,
    precomputed_mGnP_ed25519_P_217,32,
  },
  {
    precomputed_mGnP_ed25519_Q_218,33,
    precomputed_mGnP_ed25519_m_218,32,
    precomputed_mGnP_ed25519_n_218,64,
    precomputed_mGnP_ed25519_P_218,32,
  },
  {
    precomputed_mGnP_ed25519_Q_219,33,
    precomputed_mGnP_ed25519_m_219,32,
    precomputed_mGnP_ed25519_n_219,64,
    precomputed_mGnP_ed25519_P_219,32,
  },
  {
    precomputed_mGnP_ed25519_Q_220,33,
    precomputed_mGnP_ed25519_m_220,32,
    precomputed_mGnP_ed25519_n_220,64,
    precomputed_mGnP_ed25519_P_220,32,
  },
  {
    precomputed_mGnP_ed25519_Q_221,33,
    precomputed_mGnP_ed25519_m_221,32,
    precomputed_mGnP_ed25519_n_221,64,
    precomputed_mGnP_ed25519_P_221,32,
  },
  {
    precomputed_mGnP_ed25519_Q_222,33,
    precomputed_mGnP_ed25519_m_222,32,
    precomputed_mGnP_ed25519_n_222,64,
    precomputed_mGnP_ed25519_P_222,32,
  },
  {
    precomputed_mGnP_ed25519_Q_223,33,
    precomputed_mGnP_ed25519_m_223,32,
    precomputed_mGnP_ed25519_n_223,64,
    precomputed_mGnP_ed25519_P_223,32,
  },
  {
    precomputed_mGnP_ed25519_Q_224,33,
    precomputed_mGnP_ed25519_m_224,32,
    precomputed_mGnP_ed25519_n_224,64,
    precomputed_mGnP_ed25519_P_224,32,
  },
  {
    precomputed_mGnP_ed25519_Q_225,33,
    precomputed_mGnP_ed25519_m_225,32,
    precomputed_mGnP_ed25519_n_225,64,
    precomputed_mGnP_ed25519_P_225,32,
  },
  {
    precomputed_mGnP_ed25519_Q_226,33,
    precomputed_mGnP_ed25519_m_226,32,
    precomputed_mGnP_ed25519_n_226,64,
    precomputed_mGnP_ed25519_P_226,32,
  },
  {
    precomputed_mGnP_ed25519_Q_227,33,
    precomputed_mGnP_ed25519_m_227,32,
    precomputed_mGnP_ed25519_n_227,64,
    precomputed_mGnP_ed25519_P_227,32,
  },
  {
    precomputed_mGnP_ed25519_Q_228,33,
    precomputed_mGnP_ed25519_m_228,32,
    precomputed_mGnP_ed25519_n_228,64,
    precomputed_mGnP_ed25519_P_228,32,
  },
  {
    precomputed_mGnP_ed25519_Q_229,33,
    precomputed_mGnP_ed25519_m_229,32,
    precomputed_mGnP_ed25519_n_229,64,
    precomputed_mGnP_ed25519_P_229,32,
  },
  {
    precomputed_mGnP_ed25519_Q_230,33,
    precomputed_mGnP_ed25519_m_230,32,
    precomputed_mGnP_ed25519_n_230,64,
    precomputed_mGnP_ed25519_P_230,32,
  },
  {
    precomputed_mGnP_ed25519_Q_231,33,
    precomputed_mGnP_ed25519_m_231,32,
    precomputed_mGnP_ed25519_n_231,64,
    precomputed_mGnP_ed25519_P_231,32,
  },
  {
    precomputed_mGnP_ed25519_Q_232,33,
    precomputed_mGnP_ed25519_m_232,32,
    precomputed_mGnP_ed25519_n_232,64,
    precomputed_mGnP_ed25519_P_232,32,
  },
  {
    precomputed_mGnP_ed25519_Q_233,33,
    precomputed_mGnP_ed25519_m_233,32,
    precomputed_mGnP_ed25519_n_233,64,
    precomputed_mGnP_ed25519_P_233,32,
  },
  {
    precomputed_mGnP_ed25519_Q_234,33,
    precomputed_mGnP_ed25519_m_234,32,
    precomputed_mGnP_ed25519_n_234,64,
    precomputed_mGnP_ed25519_P_234,32,
  },
  {
    precomputed_mGnP_ed25519_Q_235,33,
    precomputed_mGnP_ed25519_m_235,32,
    precomputed_mGnP_ed25519_n_235,64,
    precomputed_mGnP_ed25519_P_235,32,
  },
  {
    precomputed_mGnP_ed25519_Q_236,33,
    precomputed_mGnP_ed25519_m_236,32,
    precomputed_mGnP_ed25519_n_236,64,
    precomputed_mGnP_ed25519_P_236,32,
  },
  {
    precomputed_mGnP_ed25519_Q_237,33,
    precomputed_mGnP_ed25519_m_237,32,
    precomputed_mGnP_ed25519_n_237,64,
    precomputed_mGnP_ed25519_P_237,32,
  },
  {
    precomputed_mGnP_ed25519_Q_238,33,
    precomputed_mGnP_ed25519_m_238,32,
    precomputed_mGnP_ed25519_n_238,64,
    precomputed_mGnP_ed25519_P_238,32,
  },
  {
    precomputed_mGnP_ed25519_Q_239,33,
    precomputed_mGnP_ed25519_m_239,32,
    precomputed_mGnP_ed25519_n_239,64,
    precomputed_mGnP_ed25519_P_239,32,
  },
  {
    precomputed_mGnP_ed25519_Q_240,33,
    precomputed_mGnP_ed25519_m_240,32,
    precomputed_mGnP_ed25519_n_240,64,
    precomputed_mGnP_ed25519_P_240,32,
  },
  {
    precomputed_mGnP_ed25519_Q_241,33,
    precomputed_mGnP_ed25519_m_241,32,
    precomputed_mGnP_ed25519_n_241,64,
    precomputed_mGnP_ed25519_P_241,32,
  },
  {
    precomputed_mGnP_ed25519_Q_242,33,
    precomputed_mGnP_ed25519_m_242,32,
    precomputed_mGnP_ed25519_n_242,64,
    precomputed_mGnP_ed25519_P_242,32,
  },
  {
    precomputed_mGnP_ed25519_Q_243,33,
    precomputed_mGnP_ed25519_m_243,32,
    precomputed_mGnP_ed25519_n_243,64,
    precomputed_mGnP_ed25519_P_243,32,
  },
  {
    precomputed_mGnP_ed25519_Q_244,33,
    precomputed_mGnP_ed25519_m_244,32,
    precomputed_mGnP_ed25519_n_244,64,
    precomputed_mGnP_ed25519_P_244,32,
  },
  {
    precomputed_mGnP_ed25519_Q_245,33,
    precomputed_mGnP_ed25519_m_245,32,
    precomputed_mGnP_ed25519_n_245,64,
    precomputed_mGnP_ed25519_P_245,32,
  },
  {
    precomputed_mGnP_ed25519_Q_246,33,
    precomputed_mGnP_ed25519_m_246,32,
    precomputed_mGnP_ed25519_n_246,64,
    precomputed_mGnP_ed25519_P_246,32,
  },
  {
    precomputed_mGnP_ed25519_Q_247,33,
    precomputed_mGnP_ed25519_m_247,32,
    precomputed_mGnP_ed25519_n_247,64,
    precomputed_mGnP_ed25519_P_247,32,
  },
  {
    precomputed_mGnP_ed25519_Q_248,33,
    precomputed_mGnP_ed25519_m_248,32,
    precomputed_mGnP_ed25519_n_248,64,
    precomputed_mGnP_ed25519_P_248,32,
  },
  {
    precomputed_mGnP_ed25519_Q_249,33,
    precomputed_mGnP_ed25519_m_249,32,
    precomputed_mGnP_ed25519_n_249,64,
    precomputed_mGnP_ed25519_P_249,32,
  },
  {
    precomputed_mGnP_ed25519_Q_250,33,
    precomputed_mGnP_ed25519_m_250,32,
    precomputed_mGnP_ed25519_n_250,64,
    precomputed_mGnP_ed25519_P_250,32,
  },
  {
    precomputed_mGnP_ed25519_Q_251,33,
    precomputed_mGnP_ed25519_m_251,32,
    precomputed_mGnP_ed25519_n_251,64,
    precomputed_mGnP_ed25519_P_251,32,
  },
  {
    precomputed_mGnP_ed25519_Q_252,33,
    precomputed_mGnP_ed25519_m_252,32,
    precomputed_mGnP_ed25519_n_252,64,
    precomputed_mGnP_ed25519_P_252,32,
  },
  {
    precomputed_mGnP_ed25519_Q_253,33,
    precomputed_mGnP_ed25519_m_253,32,
    precomputed_mGnP_ed25519_n_253,64,
    precomputed_mGnP_ed25519_P_253,32,
  },
  {
    precomputed_mGnP_ed25519_Q_254,33,
    precomputed_mGnP_ed25519_m_254,32,
    precomputed_mGnP_ed25519_n_254,64,
    precomputed_mGnP_ed25519_P_254,32,
  },
  {
    precomputed_mGnP_ed25519_Q_255,33,
    precomputed_mGnP_ed25519_m_255,32,
    precomputed_mGnP_ed25519_n_255,64,
    precomputed_mGnP_ed25519_P_255,32,
  },
  {
    precomputed_mGnP_ed25519_Q_256,33,
    precomputed_mGnP_ed25519_m_256,32,
    precomputed_mGnP_ed25519_n_256,64,
    precomputed_mGnP_ed25519_P_256,32,
  },
  {
    precomputed_mGnP_ed25519_Q_257,33,
    precomputed_mGnP_ed25519_m_257,32,
    precomputed_mGnP_ed25519_n_257,64,
    precomputed_mGnP_ed25519_P_257,32,
  },
  {
    precomputed_mGnP_ed25519_Q_258,33,
    precomputed_mGnP_ed25519_m_258,32,
    precomputed_mGnP_ed25519_n_258,64,
    precomputed_mGnP_ed25519_P_258,32,
  },
  {
    precomputed_mGnP_ed25519_Q_259,33,
    precomputed_mGnP_ed25519_m_259,32,
    precomputed_mGnP_ed25519_n_259,64,
    precomputed_mGnP_ed25519_P_259,32,
  },
  {
    precomputed_mGnP_ed25519_Q_260,33,
    precomputed_mGnP_ed25519_m_260,32,
    precomputed_mGnP_ed25519_n_260,64,
    precomputed_mGnP_ed25519_P_260,32,
  },
  {
    precomputed_mGnP_ed25519_Q_261,33,
    precomputed_mGnP_ed25519_m_261,32,
    precomputed_mGnP_ed25519_n_261,64,
    precomputed_mGnP_ed25519_P_261,32,
  },
  {
    precomputed_mGnP_ed25519_Q_262,33,
    precomputed_mGnP_ed25519_m_262,32,
    precomputed_mGnP_ed25519_n_262,64,
    precomputed_mGnP_ed25519_P_262,32,
  },
  {
    precomputed_mGnP_ed25519_Q_263,33,
    precomputed_mGnP_ed25519_m_263,32,
    precomputed_mGnP_ed25519_n_263,64,
    precomputed_mGnP_ed25519_P_263,32,
  },
  {
    precomputed_mGnP_ed25519_Q_264,33,
    precomputed_mGnP_ed25519_m_264,32,
    precomputed_mGnP_ed25519_n_264,64,
    precomputed_mGnP_ed25519_P_264,32,
  },
  {
    precomputed_mGnP_ed25519_Q_265,33,
    precomputed_mGnP_ed25519_m_265,32,
    precomputed_mGnP_ed25519_n_265,64,
    precomputed_mGnP_ed25519_P_265,32,
  },
  {
    precomputed_mGnP_ed25519_Q_266,33,
    precomputed_mGnP_ed25519_m_266,32,
    precomputed_mGnP_ed25519_n_266,64,
    precomputed_mGnP_ed25519_P_266,32,
  },
  {
    precomputed_mGnP_ed25519_Q_267,33,
    precomputed_mGnP_ed25519_m_267,32,
    precomputed_mGnP_ed25519_n_267,64,
    precomputed_mGnP_ed25519_P_267,32,
  },
  {
    precomputed_mGnP_ed25519_Q_268,33,
    precomputed_mGnP_ed25519_m_268,32,
    precomputed_mGnP_ed25519_n_268,64,
    precomputed_mGnP_ed25519_P_268,32,
  },
  {
    precomputed_mGnP_ed25519_Q_269,33,
    precomputed_mGnP_ed25519_m_269,32,
    precomputed_mGnP_ed25519_n_269,64,
    precomputed_mGnP_ed25519_P_269,32,
  },
  {
    precomputed_mGnP_ed25519_Q_270,33,
    precomputed_mGnP_ed25519_m_270,32,
    precomputed_mGnP_ed25519_n_270,64,
    precomputed_mGnP_ed25519_P_270,32,
  },
  {
    precomputed_mGnP_ed25519_Q_271,33,
    precomputed_mGnP_ed25519_m_271,32,
    precomputed_mGnP_ed25519_n_271,64,
    precomputed_mGnP_ed25519_P_271,32,
  },
  {
    precomputed_mGnP_ed25519_Q_272,33,
    precomputed_mGnP_ed25519_m_272,32,
    precomputed_mGnP_ed25519_n_272,64,
    precomputed_mGnP_ed25519_P_272,32,
  },
  {
    precomputed_mGnP_ed25519_Q_273,33,
    precomputed_mGnP_ed25519_m_273,32,
    precomputed_mGnP_ed25519_n_273,64,
    precomputed_mGnP_ed25519_P_273,32,
  },
  {
    precomputed_mGnP_ed25519_Q_274,33,
    precomputed_mGnP_ed25519_m_274,32,
    precomputed_mGnP_ed25519_n_274,64,
    precomputed_mGnP_ed25519_P_274,32,
  },
  {
    precomputed_mGnP_ed25519_Q_275,33,
    precomputed_mGnP_ed25519_m_275,32,
    precomputed_mGnP_ed25519_n_275,64,
    precomputed_mGnP_ed25519_P_275,32,
  },
  {
    precomputed_mGnP_ed25519_Q_276,33,
    precomputed_mGnP_ed25519_m_276,32,
    precomputed_mGnP_ed25519_n_276,64,
    precomputed_mGnP_ed25519_P_276,32,
  },
  {
    precomputed_mGnP_ed25519_Q_277,33,
    precomputed_mGnP_ed25519_m_277,32,
    precomputed_mGnP_ed25519_n_277,64,
    precomputed_mGnP_ed25519_P_277,32,
  },
  {
    precomputed_mGnP_ed25519_Q_278,33,
    precomputed_mGnP_ed25519_m_278,32,
    precomputed_mGnP_ed25519_n_278,64,
    precomputed_mGnP_ed25519_P_278,32,
  },
  {
    precomputed_mGnP_ed25519_Q_279,33,
    precomputed_mGnP_ed25519_m_279,32,
    precomputed_mGnP_ed25519_n_279,64,
    precomputed_mGnP_ed25519_P_279,32,
  },
  {
    precomputed_mGnP_ed25519_Q_280,33,
    precomputed_mGnP_ed25519_m_280,32,
    precomputed_mGnP_ed25519_n_280,64,
    precomputed_mGnP_ed25519_P_280,32,
  },
  {
    precomputed_mGnP_ed25519_Q_281,33,
    precomputed_mGnP_ed25519_m_281,32,
    precomputed_mGnP_ed25519_n_281,64,
    precomputed_mGnP_ed25519_P_281,32,
  },
  {
    precomputed_mGnP_ed25519_Q_282,33,
    precomputed_mGnP_ed25519_m_282,32,
    precomputed_mGnP_ed25519_n_282,64,
    precomputed_mGnP_ed25519_P_282,32,
  },
  {
    precomputed_mGnP_ed25519_Q_283,33,
    precomputed_mGnP_ed25519_m_283,32,
    precomputed_mGnP_ed25519_n_283,64,
    precomputed_mGnP_ed25519_P_283,32,
  },
  {
    precomputed_mGnP_ed25519_Q_284,33,
    precomputed_mGnP_ed25519_m_284,32,
    precomputed_mGnP_ed25519_n_284,64,
    precomputed_mGnP_ed25519_P_284,32,
  },
  {
    precomputed_mGnP_ed25519_Q_285,33,
    precomputed_mGnP_ed25519_m_285,32,
    precomputed_mGnP_ed25519_n_285,64,
    precomputed_mGnP_ed25519_P_285,32,
  },
  {
    precomputed_mGnP_ed25519_Q_286,33,
    precomputed_mGnP_ed25519_m_286,32,
    precomputed_mGnP_ed25519_n_286,64,
    precomputed_mGnP_ed25519_P_286,32,
  },
  {
    precomputed_mGnP_ed25519_Q_287,33,
    precomputed_mGnP_ed25519_m_287,32,
    precomputed_mGnP_ed25519_n_287,64,
    precomputed_mGnP_ed25519_P_287,32,
  },
  {
    precomputed_mGnP_ed25519_Q_288,33,
    precomputed_mGnP_ed25519_m_288,32,
    precomputed_mGnP_ed25519_n_288,64,
    precomputed_mGnP_ed25519_P_288,32,
  },
  {
    precomputed_mGnP_ed25519_Q_289,33,
    precomputed_mGnP_ed25519_m_289,32,
    precomputed_mGnP_ed25519_n_289,64,
    precomputed_mGnP_ed25519_P_289,32,
  },
  {
    precomputed_mGnP_ed25519_Q_290,33,
    precomputed_mGnP_ed25519_m_290,32,
    precomputed_mGnP_ed25519_n_290,64,
    precomputed_mGnP_ed25519_P_290,32,
  },
  {
    precomputed_mGnP_ed25519_Q_291,33,
    precomputed_mGnP_ed25519_m_291,32,
    precomputed_mGnP_ed25519_n_291,64,
    precomputed_mGnP_ed25519_P_291,32,
  },
  {
    precomputed_mGnP_ed25519_Q_292,33,
    precomputed_mGnP_ed25519_m_292,32,
    precomputed_mGnP_ed25519_n_292,64,
    precomputed_mGnP_ed25519_P_292,32,
  },
  {
    precomputed_mGnP_ed25519_Q_293,33,
    precomputed_mGnP_ed25519_m_293,32,
    precomputed_mGnP_ed25519_n_293,64,
    precomputed_mGnP_ed25519_P_293,32,
  },
  {
    precomputed_mGnP_ed25519_Q_294,33,
    precomputed_mGnP_ed25519_m_294,32,
    precomputed_mGnP_ed25519_n_294,64,
    precomputed_mGnP_ed25519_P_294,32,
  },
  {
    precomputed_mGnP_ed25519_Q_295,33,
    precomputed_mGnP_ed25519_m_295,32,
    precomputed_mGnP_ed25519_n_295,64,
    precomputed_mGnP_ed25519_P_295,32,
  },
  {
    precomputed_mGnP_ed25519_Q_296,33,
    precomputed_mGnP_ed25519_m_296,32,
    precomputed_mGnP_ed25519_n_296,64,
    precomputed_mGnP_ed25519_P_296,32,
  },
  {
    precomputed_mGnP_ed25519_Q_297,33,
    precomputed_mGnP_ed25519_m_297,32,
    precomputed_mGnP_ed25519_n_297,64,
    precomputed_mGnP_ed25519_P_297,32,
  },
  {
    precomputed_mGnP_ed25519_Q_298,33,
    precomputed_mGnP_ed25519_m_298,32,
    precomputed_mGnP_ed25519_n_298,64,
    precomputed_mGnP_ed25519_P_298,32,
  },
  {
    precomputed_mGnP_ed25519_Q_299,33,
    precomputed_mGnP_ed25519_m_299,32,
    precomputed_mGnP_ed25519_n_299,64,
    precomputed_mGnP_ed25519_P_299,32,
  },
  {
    precomputed_mGnP_ed25519_Q_300,33,
    precomputed_mGnP_ed25519_m_300,32,
    precomputed_mGnP_ed25519_n_300,64,
    precomputed_mGnP_ed25519_P_300,32,
  },
  {
    precomputed_mGnP_ed25519_Q_301,33,
    precomputed_mGnP_ed25519_m_301,32,
    precomputed_mGnP_ed25519_n_301,64,
    precomputed_mGnP_ed25519_P_301,32,
  },
  {
    precomputed_mGnP_ed25519_Q_302,33,
    precomputed_mGnP_ed25519_m_302,32,
    precomputed_mGnP_ed25519_n_302,64,
    precomputed_mGnP_ed25519_P_302,32,
  },
  {
    precomputed_mGnP_ed25519_Q_303,33,
    precomputed_mGnP_ed25519_m_303,32,
    precomputed_mGnP_ed25519_n_303,64,
    precomputed_mGnP_ed25519_P_303,32,
  },
  {
    precomputed_mGnP_ed25519_Q_304,33,
    precomputed_mGnP_ed25519_m_304,32,
    precomputed_mGnP_ed25519_n_304,64,
    precomputed_mGnP_ed25519_P_304,32,
  },
  {
    precomputed_mGnP_ed25519_Q_305,33,
    precomputed_mGnP_ed25519_m_305,32,
    precomputed_mGnP_ed25519_n_305,64,
    precomputed_mGnP_ed25519_P_305,32,
  },
  {
    precomputed_mGnP_ed25519_Q_306,33,
    precomputed_mGnP_ed25519_m_306,32,
    precomputed_mGnP_ed25519_n_306,64,
    precomputed_mGnP_ed25519_P_306,32,
  },
  {
    precomputed_mGnP_ed25519_Q_307,33,
    precomputed_mGnP_ed25519_m_307,32,
    precomputed_mGnP_ed25519_n_307,64,
    precomputed_mGnP_ed25519_P_307,32,
  },
  {
    precomputed_mGnP_ed25519_Q_308,33,
    precomputed_mGnP_ed25519_m_308,32,
    precomputed_mGnP_ed25519_n_308,64,
    precomputed_mGnP_ed25519_P_308,32,
  },
  {
    precomputed_mGnP_ed25519_Q_309,33,
    precomputed_mGnP_ed25519_m_309,32,
    precomputed_mGnP_ed25519_n_309,64,
    precomputed_mGnP_ed25519_P_309,32,
  },
  {
    precomputed_mGnP_ed25519_Q_310,33,
    precomputed_mGnP_ed25519_m_310,32,
    precomputed_mGnP_ed25519_n_310,64,
    precomputed_mGnP_ed25519_P_310,32,
  },
  {
    precomputed_mGnP_ed25519_Q_311,33,
    precomputed_mGnP_ed25519_m_311,32,
    precomputed_mGnP_ed25519_n_311,64,
    precomputed_mGnP_ed25519_P_311,32,
  },
  {
    precomputed_mGnP_ed25519_Q_312,33,
    precomputed_mGnP_ed25519_m_312,32,
    precomputed_mGnP_ed25519_n_312,64,
    precomputed_mGnP_ed25519_P_312,32,
  },
  {
    precomputed_mGnP_ed25519_Q_313,33,
    precomputed_mGnP_ed25519_m_313,32,
    precomputed_mGnP_ed25519_n_313,64,
    precomputed_mGnP_ed25519_P_313,32,
  },
  {
    precomputed_mGnP_ed25519_Q_314,33,
    precomputed_mGnP_ed25519_m_314,32,
    precomputed_mGnP_ed25519_n_314,64,
    precomputed_mGnP_ed25519_P_314,32,
  },
  {
    precomputed_mGnP_ed25519_Q_315,33,
    precomputed_mGnP_ed25519_m_315,32,
    precomputed_mGnP_ed25519_n_315,64,
    precomputed_mGnP_ed25519_P_315,32,
  },
  {
    precomputed_mGnP_ed25519_Q_316,33,
    precomputed_mGnP_ed25519_m_316,32,
    precomputed_mGnP_ed25519_n_316,64,
    precomputed_mGnP_ed25519_P_316,32,
  },
  {
    precomputed_mGnP_ed25519_Q_317,33,
    precomputed_mGnP_ed25519_m_317,32,
    precomputed_mGnP_ed25519_n_317,64,
    precomputed_mGnP_ed25519_P_317,32,
  },
  {
    precomputed_mGnP_ed25519_Q_318,33,
    precomputed_mGnP_ed25519_m_318,32,
    precomputed_mGnP_ed25519_n_318,64,
    precomputed_mGnP_ed25519_P_318,32,
  },
  {
    precomputed_mGnP_ed25519_Q_319,33,
    precomputed_mGnP_ed25519_m_319,32,
    precomputed_mGnP_ed25519_n_319,64,
    precomputed_mGnP_ed25519_P_319,32,
  },
  {
    precomputed_mGnP_ed25519_Q_320,33,
    precomputed_mGnP_ed25519_m_320,32,
    precomputed_mGnP_ed25519_n_320,64,
    precomputed_mGnP_ed25519_P_320,32,
  },
  {
    precomputed_mGnP_ed25519_Q_321,33,
    precomputed_mGnP_ed25519_m_321,32,
    precomputed_mGnP_ed25519_n_321,64,
    precomputed_mGnP_ed25519_P_321,32,
  },
  {
    precomputed_mGnP_ed25519_Q_322,33,
    precomputed_mGnP_ed25519_m_322,32,
    precomputed_mGnP_ed25519_n_322,64,
    precomputed_mGnP_ed25519_P_322,32,
  },
  {
    precomputed_mGnP_ed25519_Q_323,33,
    precomputed_mGnP_ed25519_m_323,32,
    precomputed_mGnP_ed25519_n_323,64,
    precomputed_mGnP_ed25519_P_323,32,
  },
  {
    precomputed_mGnP_ed25519_Q_324,33,
    precomputed_mGnP_ed25519_m_324,32,
    precomputed_mGnP_ed25519_n_324,64,
    precomputed_mGnP_ed25519_P_324,32,
  },
  {
    precomputed_mGnP_ed25519_Q_325,33,
    precomputed_mGnP_ed25519_m_325,32,
    precomputed_mGnP_ed25519_n_325,64,
    precomputed_mGnP_ed25519_P_325,32,
  },
  {
    precomputed_mGnP_ed25519_Q_326,33,
    precomputed_mGnP_ed25519_m_326,32,
    precomputed_mGnP_ed25519_n_326,64,
    precomputed_mGnP_ed25519_P_326,32,
  },
  {
    precomputed_mGnP_ed25519_Q_327,33,
    precomputed_mGnP_ed25519_m_327,32,
    precomputed_mGnP_ed25519_n_327,64,
    precomputed_mGnP_ed25519_P_327,32,
  },
  {
    precomputed_mGnP_ed25519_Q_328,33,
    precomputed_mGnP_ed25519_m_328,32,
    precomputed_mGnP_ed25519_n_328,64,
    precomputed_mGnP_ed25519_P_328,32,
  },
  {
    precomputed_mGnP_ed25519_Q_329,33,
    precomputed_mGnP_ed25519_m_329,32,
    precomputed_mGnP_ed25519_n_329,64,
    precomputed_mGnP_ed25519_P_329,32,
  },
  {
    precomputed_mGnP_ed25519_Q_330,33,
    precomputed_mGnP_ed25519_m_330,32,
    precomputed_mGnP_ed25519_n_330,64,
    precomputed_mGnP_ed25519_P_330,32,
  },
  {
    precomputed_mGnP_ed25519_Q_331,33,
    precomputed_mGnP_ed25519_m_331,32,
    precomputed_mGnP_ed25519_n_331,64,
    precomputed_mGnP_ed25519_P_331,32,
  },
  {
    precomputed_mGnP_ed25519_Q_332,33,
    precomputed_mGnP_ed25519_m_332,32,
    precomputed_mGnP_ed25519_n_332,64,
    precomputed_mGnP_ed25519_P_332,32,
  },
  {
    precomputed_mGnP_ed25519_Q_333,33,
    precomputed_mGnP_ed25519_m_333,32,
    precomputed_mGnP_ed25519_n_333,64,
    precomputed_mGnP_ed25519_P_333,32,
  },
  {
    precomputed_mGnP_ed25519_Q_334,33,
    precomputed_mGnP_ed25519_m_334,32,
    precomputed_mGnP_ed25519_n_334,64,
    precomputed_mGnP_ed25519_P_334,32,
  },
  {
    precomputed_mGnP_ed25519_Q_335,33,
    precomputed_mGnP_ed25519_m_335,32,
    precomputed_mGnP_ed25519_n_335,64,
    precomputed_mGnP_ed25519_P_335,32,
  },
  {
    precomputed_mGnP_ed25519_Q_336,33,
    precomputed_mGnP_ed25519_m_336,32,
    precomputed_mGnP_ed25519_n_336,64,
    precomputed_mGnP_ed25519_P_336,32,
  },
  {
    precomputed_mGnP_ed25519_Q_337,33,
    precomputed_mGnP_ed25519_m_337,32,
    precomputed_mGnP_ed25519_n_337,64,
    precomputed_mGnP_ed25519_P_337,32,
  },
  {
    precomputed_mGnP_ed25519_Q_338,33,
    precomputed_mGnP_ed25519_m_338,32,
    precomputed_mGnP_ed25519_n_338,64,
    precomputed_mGnP_ed25519_P_338,32,
  },
  {
    precomputed_mGnP_ed25519_Q_339,33,
    precomputed_mGnP_ed25519_m_339,32,
    precomputed_mGnP_ed25519_n_339,64,
    precomputed_mGnP_ed25519_P_339,32,
  },
  {
    precomputed_mGnP_ed25519_Q_340,33,
    precomputed_mGnP_ed25519_m_340,32,
    precomputed_mGnP_ed25519_n_340,64,
    precomputed_mGnP_ed25519_P_340,32,
  },
  {
    precomputed_mGnP_ed25519_Q_341,33,
    precomputed_mGnP_ed25519_m_341,32,
    precomputed_mGnP_ed25519_n_341,64,
    precomputed_mGnP_ed25519_P_341,32,
  },
  {
    precomputed_mGnP_ed25519_Q_342,33,
    precomputed_mGnP_ed25519_m_342,32,
    precomputed_mGnP_ed25519_n_342,64,
    precomputed_mGnP_ed25519_P_342,32,
  },
  {
    precomputed_mGnP_ed25519_Q_343,33,
    precomputed_mGnP_ed25519_m_343,32,
    precomputed_mGnP_ed25519_n_343,64,
    precomputed_mGnP_ed25519_P_343,32,
  },
  {
    precomputed_mGnP_ed25519_Q_344,33,
    precomputed_mGnP_ed25519_m_344,32,
    precomputed_mGnP_ed25519_n_344,64,
    precomputed_mGnP_ed25519_P_344,32,
  },
  {
    precomputed_mGnP_ed25519_Q_345,33,
    precomputed_mGnP_ed25519_m_345,32,
    precomputed_mGnP_ed25519_n_345,64,
    precomputed_mGnP_ed25519_P_345,32,
  },
  {
    precomputed_mGnP_ed25519_Q_346,33,
    precomputed_mGnP_ed25519_m_346,32,
    precomputed_mGnP_ed25519_n_346,64,
    precomputed_mGnP_ed25519_P_346,32,
  },
  {
    precomputed_mGnP_ed25519_Q_347,33,
    precomputed_mGnP_ed25519_m_347,32,
    precomputed_mGnP_ed25519_n_347,64,
    precomputed_mGnP_ed25519_P_347,32,
  },
  {
    precomputed_mGnP_ed25519_Q_348,33,
    precomputed_mGnP_ed25519_m_348,32,
    precomputed_mGnP_ed25519_n_348,64,
    precomputed_mGnP_ed25519_P_348,32,
  },
  {
    precomputed_mGnP_ed25519_Q_349,33,
    precomputed_mGnP_ed25519_m_349,32,
    precomputed_mGnP_ed25519_n_349,64,
    precomputed_mGnP_ed25519_P_349,32,
  },
  {
    precomputed_mGnP_ed25519_Q_350,33,
    precomputed_mGnP_ed25519_m_350,32,
    precomputed_mGnP_ed25519_n_350,64,
    precomputed_mGnP_ed25519_P_350,32,
  },
  {
    precomputed_mGnP_ed25519_Q_351,33,
    precomputed_mGnP_ed25519_m_351,32,
    precomputed_mGnP_ed25519_n_351,64,
    precomputed_mGnP_ed25519_P_351,32,
  },
  {
    precomputed_mGnP_ed25519_Q_352,33,
    precomputed_mGnP_ed25519_m_352,32,
    precomputed_mGnP_ed25519_n_352,64,
    precomputed_mGnP_ed25519_P_352,32,
  },
  {
    precomputed_mGnP_ed25519_Q_353,33,
    precomputed_mGnP_ed25519_m_353,32,
    precomputed_mGnP_ed25519_n_353,64,
    precomputed_mGnP_ed25519_P_353,32,
  },
  {
    precomputed_mGnP_ed25519_Q_354,33,
    precomputed_mGnP_ed25519_m_354,32,
    precomputed_mGnP_ed25519_n_354,64,
    precomputed_mGnP_ed25519_P_354,32,
  },
  {
    precomputed_mGnP_ed25519_Q_355,33,
    precomputed_mGnP_ed25519_m_355,32,
    precomputed_mGnP_ed25519_n_355,64,
    precomputed_mGnP_ed25519_P_355,32,
  },
  {
    precomputed_mGnP_ed25519_Q_356,33,
    precomputed_mGnP_ed25519_m_356,32,
    precomputed_mGnP_ed25519_n_356,64,
    precomputed_mGnP_ed25519_P_356,32,
  },
  {
    precomputed_mGnP_ed25519_Q_357,33,
    precomputed_mGnP_ed25519_m_357,32,
    precomputed_mGnP_ed25519_n_357,64,
    precomputed_mGnP_ed25519_P_357,32,
  },
  {
    precomputed_mGnP_ed25519_Q_358,33,
    precomputed_mGnP_ed25519_m_358,32,
    precomputed_mGnP_ed25519_n_358,64,
    precomputed_mGnP_ed25519_P_358,32,
  },
  {
    precomputed_mGnP_ed25519_Q_359,33,
    precomputed_mGnP_ed25519_m_359,32,
    precomputed_mGnP_ed25519_n_359,64,
    precomputed_mGnP_ed25519_P_359,32,
  },
  {
    precomputed_mGnP_ed25519_Q_360,33,
    precomputed_mGnP_ed25519_m_360,32,
    precomputed_mGnP_ed25519_n_360,64,
    precomputed_mGnP_ed25519_P_360,32,
  },
  {
    precomputed_mGnP_ed25519_Q_361,33,
    precomputed_mGnP_ed25519_m_361,32,
    precomputed_mGnP_ed25519_n_361,64,
    precomputed_mGnP_ed25519_P_361,32,
  },
  {
    precomputed_mGnP_ed25519_Q_362,33,
    precomputed_mGnP_ed25519_m_362,32,
    precomputed_mGnP_ed25519_n_362,64,
    precomputed_mGnP_ed25519_P_362,32,
  },
  {
    precomputed_mGnP_ed25519_Q_363,33,
    precomputed_mGnP_ed25519_m_363,32,
    precomputed_mGnP_ed25519_n_363,64,
    precomputed_mGnP_ed25519_P_363,32,
  },
  {
    precomputed_mGnP_ed25519_Q_364,33,
    precomputed_mGnP_ed25519_m_364,32,
    precomputed_mGnP_ed25519_n_364,64,
    precomputed_mGnP_ed25519_P_364,32,
  },
  {
    precomputed_mGnP_ed25519_Q_365,33,
    precomputed_mGnP_ed25519_m_365,32,
    precomputed_mGnP_ed25519_n_365,64,
    precomputed_mGnP_ed25519_P_365,32,
  },
  {
    precomputed_mGnP_ed25519_Q_366,33,
    precomputed_mGnP_ed25519_m_366,32,
    precomputed_mGnP_ed25519_n_366,64,
    precomputed_mGnP_ed25519_P_366,32,
  },
  {
    precomputed_mGnP_ed25519_Q_367,33,
    precomputed_mGnP_ed25519_m_367,32,
    precomputed_mGnP_ed25519_n_367,64,
    precomputed_mGnP_ed25519_P_367,32,
  },
  {
    precomputed_mGnP_ed25519_Q_368,33,
    precomputed_mGnP_ed25519_m_368,32,
    precomputed_mGnP_ed25519_n_368,64,
    precomputed_mGnP_ed25519_P_368,32,
  },
  {
    precomputed_mGnP_ed25519_Q_369,33,
    precomputed_mGnP_ed25519_m_369,32,
    precomputed_mGnP_ed25519_n_369,64,
    precomputed_mGnP_ed25519_P_369,32,
  },
  {
    precomputed_mGnP_ed25519_Q_370,33,
    precomputed_mGnP_ed25519_m_370,32,
    precomputed_mGnP_ed25519_n_370,64,
    precomputed_mGnP_ed25519_P_370,32,
  },
  {
    precomputed_mGnP_ed25519_Q_371,33,
    precomputed_mGnP_ed25519_m_371,32,
    precomputed_mGnP_ed25519_n_371,64,
    precomputed_mGnP_ed25519_P_371,32,
  },
  {
    precomputed_mGnP_ed25519_Q_372,33,
    precomputed_mGnP_ed25519_m_372,32,
    precomputed_mGnP_ed25519_n_372,64,
    precomputed_mGnP_ed25519_P_372,32,
  },
  {
    precomputed_mGnP_ed25519_Q_373,33,
    precomputed_mGnP_ed25519_m_373,32,
    precomputed_mGnP_ed25519_n_373,64,
    precomputed_mGnP_ed25519_P_373,32,
  },
  {
    precomputed_mGnP_ed25519_Q_374,33,
    precomputed_mGnP_ed25519_m_374,32,
    precomputed_mGnP_ed25519_n_374,64,
    precomputed_mGnP_ed25519_P_374,32,
  },
  {
    precomputed_mGnP_ed25519_Q_375,33,
    precomputed_mGnP_ed25519_m_375,32,
    precomputed_mGnP_ed25519_n_375,64,
    precomputed_mGnP_ed25519_P_375,32,
  },
  {
    precomputed_mGnP_ed25519_Q_376,33,
    precomputed_mGnP_ed25519_m_376,32,
    precomputed_mGnP_ed25519_n_376,64,
    precomputed_mGnP_ed25519_P_376,32,
  },
  {
    precomputed_mGnP_ed25519_Q_377,33,
    precomputed_mGnP_ed25519_m_377,32,
    precomputed_mGnP_ed25519_n_377,64,
    precomputed_mGnP_ed25519_P_377,32,
  },
  {
    precomputed_mGnP_ed25519_Q_378,33,
    precomputed_mGnP_ed25519_m_378,32,
    precomputed_mGnP_ed25519_n_378,64,
    precomputed_mGnP_ed25519_P_378,32,
  },
  {
    precomputed_mGnP_ed25519_Q_379,33,
    precomputed_mGnP_ed25519_m_379,32,
    precomputed_mGnP_ed25519_n_379,64,
    precomputed_mGnP_ed25519_P_379,32,
  },
  {
    precomputed_mGnP_ed25519_Q_380,33,
    precomputed_mGnP_ed25519_m_380,32,
    precomputed_mGnP_ed25519_n_380,64,
    precomputed_mGnP_ed25519_P_380,32,
  },
  {
    precomputed_mGnP_ed25519_Q_381,33,
    precomputed_mGnP_ed25519_m_381,32,
    precomputed_mGnP_ed25519_n_381,64,
    precomputed_mGnP_ed25519_P_381,32,
  },
  {
    precomputed_mGnP_ed25519_Q_382,33,
    precomputed_mGnP_ed25519_m_382,32,
    precomputed_mGnP_ed25519_n_382,64,
    precomputed_mGnP_ed25519_P_382,32,
  },
  {
    precomputed_mGnP_ed25519_Q_383,33,
    precomputed_mGnP_ed25519_m_383,32,
    precomputed_mGnP_ed25519_n_383,64,
    precomputed_mGnP_ed25519_P_383,32,
  },
  {
    precomputed_mGnP_ed25519_Q_384,33,
    precomputed_mGnP_ed25519_m_384,32,
    precomputed_mGnP_ed25519_n_384,64,
    precomputed_mGnP_ed25519_P_384,32,
  },
  {
    precomputed_mGnP_ed25519_Q_385,33,
    precomputed_mGnP_ed25519_m_385,32,
    precomputed_mGnP_ed25519_n_385,64,
    precomputed_mGnP_ed25519_P_385,32,
  },
  {
    precomputed_mGnP_ed25519_Q_386,33,
    precomputed_mGnP_ed25519_m_386,32,
    precomputed_mGnP_ed25519_n_386,64,
    precomputed_mGnP_ed25519_P_386,32,
  },
  {
    precomputed_mGnP_ed25519_Q_387,33,
    precomputed_mGnP_ed25519_m_387,32,
    precomputed_mGnP_ed25519_n_387,64,
    precomputed_mGnP_ed25519_P_387,32,
  },
  {
    precomputed_mGnP_ed25519_Q_388,33,
    precomputed_mGnP_ed25519_m_388,32,
    precomputed_mGnP_ed25519_n_388,64,
    precomputed_mGnP_ed25519_P_388,32,
  },
  {
    precomputed_mGnP_ed25519_Q_389,33,
    precomputed_mGnP_ed25519_m_389,32,
    precomputed_mGnP_ed25519_n_389,64,
    precomputed_mGnP_ed25519_P_389,32,
  },
  {
    precomputed_mGnP_ed25519_Q_390,33,
    precomputed_mGnP_ed25519_m_390,32,
    precomputed_mGnP_ed25519_n_390,64,
    precomputed_mGnP_ed25519_P_390,32,
  },
  {
    precomputed_mGnP_ed25519_Q_391,33,
    precomputed_mGnP_ed25519_m_391,32,
    precomputed_mGnP_ed25519_n_391,64,
    precomputed_mGnP_ed25519_P_391,32,
  },
  {
    precomputed_mGnP_ed25519_Q_392,33,
    precomputed_mGnP_ed25519_m_392,32,
    precomputed_mGnP_ed25519_n_392,64,
    precomputed_mGnP_ed25519_P_392,32,
  },
  {
    precomputed_mGnP_ed25519_Q_393,33,
    precomputed_mGnP_ed25519_m_393,32,
    precomputed_mGnP_ed25519_n_393,64,
    precomputed_mGnP_ed25519_P_393,32,
  },
  {
    precomputed_mGnP_ed25519_Q_394,33,
    precomputed_mGnP_ed25519_m_394,32,
    precomputed_mGnP_ed25519_n_394,64,
    precomputed_mGnP_ed25519_P_394,32,
  },
  {
    precomputed_mGnP_ed25519_Q_395,33,
    precomputed_mGnP_ed25519_m_395,32,
    precomputed_mGnP_ed25519_n_395,64,
    precomputed_mGnP_ed25519_P_395,32,
  },
  {
    precomputed_mGnP_ed25519_Q_396,33,
    precomputed_mGnP_ed25519_m_396,32,
    precomputed_mGnP_ed25519_n_396,64,
    precomputed_mGnP_ed25519_P_396,32,
  },
  {
    precomputed_mGnP_ed25519_Q_397,33,
    precomputed_mGnP_ed25519_m_397,32,
    precomputed_mGnP_ed25519_n_397,64,
    precomputed_mGnP_ed25519_P_397,32,
  },
  {
    precomputed_mGnP_ed25519_Q_398,33,
    precomputed_mGnP_ed25519_m_398,32,
    precomputed_mGnP_ed25519_n_398,64,
    precomputed_mGnP_ed25519_P_398,32,
  },
  {
    precomputed_mGnP_ed25519_Q_399,33,
    precomputed_mGnP_ed25519_m_399,32,
    precomputed_mGnP_ed25519_n_399,64,
    precomputed_mGnP_ed25519_P_399,32,
  },
  {
    precomputed_mGnP_ed25519_Q_400,33,
    precomputed_mGnP_ed25519_m_400,32,
    precomputed_mGnP_ed25519_n_400,64,
    precomputed_mGnP_ed25519_P_400,32,
  },
  {
    precomputed_mGnP_ed25519_Q_401,33,
    precomputed_mGnP_ed25519_m_401,32,
    precomputed_mGnP_ed25519_n_401,64,
    precomputed_mGnP_ed25519_P_401,32,
  },
  {
    precomputed_mGnP_ed25519_Q_402,33,
    precomputed_mGnP_ed25519_m_402,32,
    precomputed_mGnP_ed25519_n_402,64,
    precomputed_mGnP_ed25519_P_402,32,
  },
  {
    precomputed_mGnP_ed25519_Q_403,33,
    precomputed_mGnP_ed25519_m_403,32,
    precomputed_mGnP_ed25519_n_403,64,
    precomputed_mGnP_ed25519_P_403,32,
  },
  {
    precomputed_mGnP_ed25519_Q_404,33,
    precomputed_mGnP_ed25519_m_404,32,
    precomputed_mGnP_ed25519_n_404,64,
    precomputed_mGnP_ed25519_P_404,32,
  },
  {
    precomputed_mGnP_ed25519_Q_405,33,
    precomputed_mGnP_ed25519_m_405,32,
    precomputed_mGnP_ed25519_n_405,64,
    precomputed_mGnP_ed25519_P_405,32,
  },
  {
    precomputed_mGnP_ed25519_Q_406,33,
    precomputed_mGnP_ed25519_m_406,32,
    precomputed_mGnP_ed25519_n_406,64,
    precomputed_mGnP_ed25519_P_406,32,
  },
  {
    precomputed_mGnP_ed25519_Q_407,33,
    precomputed_mGnP_ed25519_m_407,32,
    precomputed_mGnP_ed25519_n_407,64,
    precomputed_mGnP_ed25519_P_407,32,
  },
  {
    precomputed_mGnP_ed25519_Q_408,33,
    precomputed_mGnP_ed25519_m_408,32,
    precomputed_mGnP_ed25519_n_408,64,
    precomputed_mGnP_ed25519_P_408,32,
  },
  {
    precomputed_mGnP_ed25519_Q_409,33,
    precomputed_mGnP_ed25519_m_409,32,
    precomputed_mGnP_ed25519_n_409,64,
    precomputed_mGnP_ed25519_P_409,32,
  },
  {
    precomputed_mGnP_ed25519_Q_410,33,
    precomputed_mGnP_ed25519_m_410,32,
    precomputed_mGnP_ed25519_n_410,64,
    precomputed_mGnP_ed25519_P_410,32,
  },
  {
    precomputed_mGnP_ed25519_Q_411,33,
    precomputed_mGnP_ed25519_m_411,32,
    precomputed_mGnP_ed25519_n_411,64,
    precomputed_mGnP_ed25519_P_411,32,
  },
  {
    precomputed_mGnP_ed25519_Q_412,33,
    precomputed_mGnP_ed25519_m_412,32,
    precomputed_mGnP_ed25519_n_412,64,
    precomputed_mGnP_ed25519_P_412,32,
  },
  {
    precomputed_mGnP_ed25519_Q_413,33,
    precomputed_mGnP_ed25519_m_413,32,
    precomputed_mGnP_ed25519_n_413,64,
    precomputed_mGnP_ed25519_P_413,32,
  },
  {
    precomputed_mGnP_ed25519_Q_414,33,
    precomputed_mGnP_ed25519_m_414,32,
    precomputed_mGnP_ed25519_n_414,64,
    precomputed_mGnP_ed25519_P_414,32,
  },
  {
    precomputed_mGnP_ed25519_Q_415,33,
    precomputed_mGnP_ed25519_m_415,32,
    precomputed_mGnP_ed25519_n_415,64,
    precomputed_mGnP_ed25519_P_415,32,
  },
  {
    precomputed_mGnP_ed25519_Q_416,33,
    precomputed_mGnP_ed25519_m_416,32,
    precomputed_mGnP_ed25519_n_416,64,
    precomputed_mGnP_ed25519_P_416,32,
  },
  {
    precomputed_mGnP_ed25519_Q_417,33,
    precomputed_mGnP_ed25519_m_417,32,
    precomputed_mGnP_ed25519_n_417,64,
    precomputed_mGnP_ed25519_P_417,32,
  },
  {
    precomputed_mGnP_ed25519_Q_418,33,
    precomputed_mGnP_ed25519_m_418,32,
    precomputed_mGnP_ed25519_n_418,64,
    precomputed_mGnP_ed25519_P_418,32,
  },
  {
    precomputed_mGnP_ed25519_Q_419,33,
    precomputed_mGnP_ed25519_m_419,32,
    precomputed_mGnP_ed25519_n_419,64,
    precomputed_mGnP_ed25519_P_419,32,
  },
  {
    precomputed_mGnP_ed25519_Q_420,33,
    precomputed_mGnP_ed25519_m_420,32,
    precomputed_mGnP_ed25519_n_420,64,
    precomputed_mGnP_ed25519_P_420,32,
  },
  {
    precomputed_mGnP_ed25519_Q_421,33,
    precomputed_mGnP_ed25519_m_421,32,
    precomputed_mGnP_ed25519_n_421,64,
    precomputed_mGnP_ed25519_P_421,32,
  },
  {
    precomputed_mGnP_ed25519_Q_422,33,
    precomputed_mGnP_ed25519_m_422,32,
    precomputed_mGnP_ed25519_n_422,64,
    precomputed_mGnP_ed25519_P_422,32,
  },
  {
    precomputed_mGnP_ed25519_Q_423,33,
    precomputed_mGnP_ed25519_m_423,32,
    precomputed_mGnP_ed25519_n_423,64,
    precomputed_mGnP_ed25519_P_423,32,
  },
  {
    precomputed_mGnP_ed25519_Q_424,33,
    precomputed_mGnP_ed25519_m_424,32,
    precomputed_mGnP_ed25519_n_424,64,
    precomputed_mGnP_ed25519_P_424,32,
  },
  {
    precomputed_mGnP_ed25519_Q_425,33,
    precomputed_mGnP_ed25519_m_425,32,
    precomputed_mGnP_ed25519_n_425,64,
    precomputed_mGnP_ed25519_P_425,32,
  },
  {
    precomputed_mGnP_ed25519_Q_426,33,
    precomputed_mGnP_ed25519_m_426,32,
    precomputed_mGnP_ed25519_n_426,64,
    precomputed_mGnP_ed25519_P_426,32,
  },
  {
    precomputed_mGnP_ed25519_Q_427,33,
    precomputed_mGnP_ed25519_m_427,32,
    precomputed_mGnP_ed25519_n_427,64,
    precomputed_mGnP_ed25519_P_427,32,
  },
  {
    precomputed_mGnP_ed25519_Q_428,33,
    precomputed_mGnP_ed25519_m_428,32,
    precomputed_mGnP_ed25519_n_428,64,
    precomputed_mGnP_ed25519_P_428,32,
  },
  {
    precomputed_mGnP_ed25519_Q_429,33,
    precomputed_mGnP_ed25519_m_429,32,
    precomputed_mGnP_ed25519_n_429,64,
    precomputed_mGnP_ed25519_P_429,32,
  },
  {
    precomputed_mGnP_ed25519_Q_430,33,
    precomputed_mGnP_ed25519_m_430,32,
    precomputed_mGnP_ed25519_n_430,64,
    precomputed_mGnP_ed25519_P_430,32,
  },
  {
    precomputed_mGnP_ed25519_Q_431,33,
    precomputed_mGnP_ed25519_m_431,32,
    precomputed_mGnP_ed25519_n_431,64,
    precomputed_mGnP_ed25519_P_431,32,
  },
  {
    precomputed_mGnP_ed25519_Q_432,33,
    precomputed_mGnP_ed25519_m_432,32,
    precomputed_mGnP_ed25519_n_432,64,
    precomputed_mGnP_ed25519_P_432,32,
  },
  {
    precomputed_mGnP_ed25519_Q_433,33,
    precomputed_mGnP_ed25519_m_433,32,
    precomputed_mGnP_ed25519_n_433,64,
    precomputed_mGnP_ed25519_P_433,32,
  },
  {
    precomputed_mGnP_ed25519_Q_434,33,
    precomputed_mGnP_ed25519_m_434,32,
    precomputed_mGnP_ed25519_n_434,64,
    precomputed_mGnP_ed25519_P_434,32,
  },
  {
    precomputed_mGnP_ed25519_Q_435,33,
    precomputed_mGnP_ed25519_m_435,32,
    precomputed_mGnP_ed25519_n_435,64,
    precomputed_mGnP_ed25519_P_435,32,
  },
  {
    precomputed_mGnP_ed25519_Q_436,33,
    precomputed_mGnP_ed25519_m_436,32,
    precomputed_mGnP_ed25519_n_436,64,
    precomputed_mGnP_ed25519_P_436,32,
  },
  {
    precomputed_mGnP_ed25519_Q_437,33,
    precomputed_mGnP_ed25519_m_437,32,
    precomputed_mGnP_ed25519_n_437,64,
    precomputed_mGnP_ed25519_P_437,32,
  },
  {
    precomputed_mGnP_ed25519_Q_438,33,
    precomputed_mGnP_ed25519_m_438,32,
    precomputed_mGnP_ed25519_n_438,64,
    precomputed_mGnP_ed25519_P_438,32,
  },
  {
    precomputed_mGnP_ed25519_Q_439,33,
    precomputed_mGnP_ed25519_m_439,32,
    precomputed_mGnP_ed25519_n_439,64,
    precomputed_mGnP_ed25519_P_439,32,
  },
  {
    precomputed_mGnP_ed25519_Q_440,33,
    precomputed_mGnP_ed25519_m_440,32,
    precomputed_mGnP_ed25519_n_440,64,
    precomputed_mGnP_ed25519_P_440,32,
  },
  {
    precomputed_mGnP_ed25519_Q_441,33,
    precomputed_mGnP_ed25519_m_441,32,
    precomputed_mGnP_ed25519_n_441,64,
    precomputed_mGnP_ed25519_P_441,32,
  },
  {
    precomputed_mGnP_ed25519_Q_442,33,
    precomputed_mGnP_ed25519_m_442,32,
    precomputed_mGnP_ed25519_n_442,64,
    precomputed_mGnP_ed25519_P_442,32,
  },
  {
    precomputed_mGnP_ed25519_Q_443,33,
    precomputed_mGnP_ed25519_m_443,32,
    precomputed_mGnP_ed25519_n_443,64,
    precomputed_mGnP_ed25519_P_443,32,
  },
  {
    precomputed_mGnP_ed25519_Q_444,33,
    precomputed_mGnP_ed25519_m_444,32,
    precomputed_mGnP_ed25519_n_444,64,
    precomputed_mGnP_ed25519_P_444,32,
  },
  {
    precomputed_mGnP_ed25519_Q_445,33,
    precomputed_mGnP_ed25519_m_445,32,
    precomputed_mGnP_ed25519_n_445,64,
    precomputed_mGnP_ed25519_P_445,32,
  },
  {
    precomputed_mGnP_ed25519_Q_446,33,
    precomputed_mGnP_ed25519_m_446,32,
    precomputed_mGnP_ed25519_n_446,64,
    precomputed_mGnP_ed25519_P_446,32,
  },
  {
    precomputed_mGnP_ed25519_Q_447,33,
    precomputed_mGnP_ed25519_m_447,32,
    precomputed_mGnP_ed25519_n_447,64,
    precomputed_mGnP_ed25519_P_447,32,
  },
  {
    precomputed_mGnP_ed25519_Q_448,33,
    precomputed_mGnP_ed25519_m_448,32,
    precomputed_mGnP_ed25519_n_448,64,
    precomputed_mGnP_ed25519_P_448,32,
  },
  {
    precomputed_mGnP_ed25519_Q_449,33,
    precomputed_mGnP_ed25519_m_449,32,
    precomputed_mGnP_ed25519_n_449,64,
    precomputed_mGnP_ed25519_P_449,32,
  },
  {
    precomputed_mGnP_ed25519_Q_450,33,
    precomputed_mGnP_ed25519_m_450,32,
    precomputed_mGnP_ed25519_n_450,64,
    precomputed_mGnP_ed25519_P_450,32,
  },
  {
    precomputed_mGnP_ed25519_Q_451,33,
    precomputed_mGnP_ed25519_m_451,32,
    precomputed_mGnP_ed25519_n_451,64,
    precomputed_mGnP_ed25519_P_451,32,
  },
  {
    precomputed_mGnP_ed25519_Q_452,33,
    precomputed_mGnP_ed25519_m_452,32,
    precomputed_mGnP_ed25519_n_452,64,
    precomputed_mGnP_ed25519_P_452,32,
  },
} ;

static void test_mGnP_ed25519_impl(long long impl)
{
  unsigned char *Q = test_mGnP_ed25519_Q;
  unsigned char *m = test_mGnP_ed25519_m;
  unsigned char *n = test_mGnP_ed25519_n;
  unsigned char *P = test_mGnP_ed25519_P;
  unsigned char *Q2 = test_mGnP_ed25519_Q2;
  unsigned char *m2 = test_mGnP_ed25519_m2;
  unsigned char *n2 = test_mGnP_ed25519_n2;
  unsigned char *P2 = test_mGnP_ed25519_P2;
  long long Qlen = crypto_mGnP_OUTPUTBYTES;
  long long mlen = crypto_mGnP_MBYTES;
  long long nlen = crypto_mGnP_NBYTES;
  long long Plen = crypto_mGnP_PBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,lib25519_dispatch_mGnP_ed25519_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_mGnP = lib25519_dispatch_mGnP_ed25519(impl);
    printf("mGnP_ed25519 %lld implementation %s compiler %s\n",impl,lib25519_dispatch_mGnP_ed25519_implementation(impl),lib25519_dispatch_mGnP_ed25519_compiler(impl));
  } else {
    crypto_mGnP = lib25519_mGnP_ed25519;
    printf("mGnP_ed25519 selected implementation %s compiler %s\n",lib25519_mGnP_ed25519_implementation(),lib25519_mGnP_ed25519_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 1024 : 128;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {

      output_prepare(Q2,Q,Qlen);
      input_prepare(m2,m,mlen);
      input_prepare(n2,n,nlen);
      input_prepare(P2,P,Plen);
      public(m,mlen);
      public(n,nlen);
      public(P,Plen);
      crypto_mGnP(Q,m,n,P);
      public(m,mlen);
      public(n,nlen);
      public(P,Plen);
      public(Q,Qlen);
      checksum(Q,Qlen);
      output_compare(Q2,Q,Qlen,"crypto_mGnP");
      input_compare(m2,m,mlen,"crypto_mGnP");
      input_compare(n2,n,nlen,"crypto_mGnP");
      input_compare(P2,P,Plen,"crypto_mGnP");

      double_canary(Q2,Q,Qlen);
      double_canary(m2,m,mlen);
      double_canary(n2,n,nlen);
      double_canary(P2,P,Plen);
      public(m2,mlen);
      public(n2,nlen);
      public(P2,Plen);
      crypto_mGnP(Q2,m2,n2,P2);
      public(m2,mlen);
      public(n2,nlen);
      public(P2,Plen);
      public(Q2,Qlen);
      if (memcmp(Q2,Q,Qlen) != 0) fail("failure: crypto_mGnP is nondeterministic\n");

      double_canary(Q2,Q,Qlen);
      double_canary(m2,m,mlen);
      double_canary(n2,n,nlen);
      double_canary(P2,P,Plen);
      public(m2,mlen);
      public(n,nlen);
      public(P,Plen);
      crypto_mGnP(m2,m2,n,P);
      public(m2,Qlen);
      public(n,nlen);
      public(P,Plen);
      if (memcmp(m2,Q,Qlen) != 0) fail("failure: crypto_mGnP does not handle m=Q overlap\n");
      memcpy(m2,m,mlen);
      public(m,mlen);
      public(n2,nlen);
      public(P,Plen);
      crypto_mGnP(n2,m,n2,P);
      public(n2,Qlen);
      public(m,mlen);
      public(P,Plen);
      if (memcmp(n2,Q,Qlen) != 0) fail("failure: crypto_mGnP does not handle n=Q overlap\n");
      memcpy(n2,n,nlen);
      public(m,mlen);
      public(n,nlen);
      public(P2,Plen);
      crypto_mGnP(P2,m,n,P2);
      public(P2,Qlen);
      public(m,mlen);
      public(n,nlen);
      if (memcmp(P2,Q,Qlen) != 0) fail("failure: crypto_mGnP does not handle P=Q overlap\n");
      memcpy(P2,P,Plen);
    }
    checksum_expected(mGnP_ed25519_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_mGnP_ed25519_NUM;++precomp) {
    output_prepare(Q2,Q,precomputed_mGnP_ed25519[precomp].Qsize);
    input_prepare(m2,m,precomputed_mGnP_ed25519[precomp].msize);
    memcpy(m,precomputed_mGnP_ed25519[precomp].m,precomputed_mGnP_ed25519[precomp].msize);
    memcpy(m2,precomputed_mGnP_ed25519[precomp].m,precomputed_mGnP_ed25519[precomp].msize);
    input_prepare(n2,n,precomputed_mGnP_ed25519[precomp].nsize);
    memcpy(n,precomputed_mGnP_ed25519[precomp].n,precomputed_mGnP_ed25519[precomp].nsize);
    memcpy(n2,precomputed_mGnP_ed25519[precomp].n,precomputed_mGnP_ed25519[precomp].nsize);
    input_prepare(P2,P,precomputed_mGnP_ed25519[precomp].Psize);
    memcpy(P,precomputed_mGnP_ed25519[precomp].P,precomputed_mGnP_ed25519[precomp].Psize);
    memcpy(P2,precomputed_mGnP_ed25519[precomp].P,precomputed_mGnP_ed25519[precomp].Psize);
    crypto_mGnP(Q,m,n,P);
    if (memcmp(Q,precomputed_mGnP_ed25519[precomp].Q,precomputed_mGnP_ed25519[precomp].Qsize)) {
      fail("failure: crypto_mGnP fails precomputed test vectors\n");
      printf("expected Q: ");
      for (long long pos = 0;pos < precomputed_mGnP_ed25519[precomp].Qsize;++pos) printf("%02x",precomputed_mGnP_ed25519[precomp].Q[pos]);
      printf("\n");
      printf("received Q: ");
      for (long long pos = 0;pos < precomputed_mGnP_ed25519[precomp].Qsize;++pos) printf("%02x",Q[pos]);
      printf("\n");
    }
    output_compare(Q2,Q,precomputed_mGnP_ed25519[precomp].Qsize,"crypto_mGnP");
    input_compare(m2,m,precomputed_mGnP_ed25519[precomp].msize,"crypto_mGnP");
    input_compare(n2,n,precomputed_mGnP_ed25519[precomp].nsize,"crypto_mGnP");
    input_compare(P2,P,precomputed_mGnP_ed25519[precomp].Psize,"crypto_mGnP");
  }
}

void test_mGnP_ed25519(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"mGnP")) return;
  if (targetp && strcmp(targetp,"ed25519")) return;
  storage_mGnP_ed25519_Q = callocplus(crypto_mGnP_OUTPUTBYTES);
  test_mGnP_ed25519_Q = aligned(storage_mGnP_ed25519_Q,crypto_mGnP_OUTPUTBYTES);
  if (crypto_mGnP_OUTPUTBYTES > maxalloc) maxalloc = crypto_mGnP_OUTPUTBYTES;
  storage_mGnP_ed25519_m = callocplus(crypto_mGnP_MBYTES+crypto_mGnP_OUTPUTBYTES);
  test_mGnP_ed25519_m = aligned(storage_mGnP_ed25519_m,crypto_mGnP_MBYTES+crypto_mGnP_OUTPUTBYTES);
  if (crypto_mGnP_MBYTES+crypto_mGnP_OUTPUTBYTES > maxalloc) maxalloc = crypto_mGnP_MBYTES+crypto_mGnP_OUTPUTBYTES;
  storage_mGnP_ed25519_n = callocplus(crypto_mGnP_NBYTES+crypto_mGnP_OUTPUTBYTES);
  test_mGnP_ed25519_n = aligned(storage_mGnP_ed25519_n,crypto_mGnP_NBYTES+crypto_mGnP_OUTPUTBYTES);
  if (crypto_mGnP_NBYTES+crypto_mGnP_OUTPUTBYTES > maxalloc) maxalloc = crypto_mGnP_NBYTES+crypto_mGnP_OUTPUTBYTES;
  storage_mGnP_ed25519_P = callocplus(crypto_mGnP_PBYTES+crypto_mGnP_OUTPUTBYTES);
  test_mGnP_ed25519_P = aligned(storage_mGnP_ed25519_P,crypto_mGnP_PBYTES+crypto_mGnP_OUTPUTBYTES);
  if (crypto_mGnP_PBYTES+crypto_mGnP_OUTPUTBYTES > maxalloc) maxalloc = crypto_mGnP_PBYTES+crypto_mGnP_OUTPUTBYTES;
  storage_mGnP_ed25519_Q2 = callocplus(maxalloc);
  test_mGnP_ed25519_Q2 = aligned(storage_mGnP_ed25519_Q2,crypto_mGnP_OUTPUTBYTES);
  storage_mGnP_ed25519_m2 = callocplus(maxalloc);
  test_mGnP_ed25519_m2 = aligned(storage_mGnP_ed25519_m2,crypto_mGnP_MBYTES+crypto_mGnP_OUTPUTBYTES);
  storage_mGnP_ed25519_n2 = callocplus(maxalloc);
  test_mGnP_ed25519_n2 = aligned(storage_mGnP_ed25519_n2,crypto_mGnP_NBYTES+crypto_mGnP_OUTPUTBYTES);
  storage_mGnP_ed25519_P2 = callocplus(maxalloc);
  test_mGnP_ed25519_P2 = aligned(storage_mGnP_ed25519_P2,crypto_mGnP_PBYTES+crypto_mGnP_OUTPUTBYTES);

  for (long long offset = 0;offset < 2;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("mGnP_ed25519 offset %lld\n",offset);
    for (long long impl = -1;impl < lib25519_numimpl_mGnP_ed25519();++impl)
      forked(test_mGnP_ed25519_impl,impl);
    ++test_mGnP_ed25519_Q;
    ++test_mGnP_ed25519_m;
    ++test_mGnP_ed25519_n;
    ++test_mGnP_ed25519_P;
    ++test_mGnP_ed25519_Q2;
    ++test_mGnP_ed25519_m2;
    ++test_mGnP_ed25519_n2;
    ++test_mGnP_ed25519_P2;
  }
  free(storage_mGnP_ed25519_P2);
  free(storage_mGnP_ed25519_n2);
  free(storage_mGnP_ed25519_m2);
  free(storage_mGnP_ed25519_Q2);
  free(storage_mGnP_ed25519_P);
  free(storage_mGnP_ed25519_n);
  free(storage_mGnP_ed25519_m);
  free(storage_mGnP_ed25519_Q);
}
#undef crypto_mGnP_MBYTES
#undef crypto_mGnP_NBYTES
#undef crypto_mGnP_PBYTES
#undef crypto_mGnP_OUTPUTBYTES

