package latexDraw.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.Serializable;

import javax.swing.Icon;

/** 
 * This class defines an icon in a JButton.<br>
 * <br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 * <br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.<br>
 * <br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 * <br>
 * 01/20/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class ButtonIcon implements Icon, Serializable
{
	private static final long serialVersionUID = 1L;

	/** The colour of the icon */
	private Color color;
	
	/** The colour of the borders of the icon */
	public final static Color EDGE = Color.BLACK;
	
	/** The width of the icon */
	public final static int WIDTH = 11;
	
	/** he height of the icon */
	public final static int HEIGHT = 11;
	
	
	/**
	 * The constructor using a colour.
	 * @param color The colour of the icon.
	 */
	public ButtonIcon(Color color)
	{
		if(color==null)
			throw new IllegalArgumentException();
		
		this.color = color;
	}
	
	
	
	
	/**
	 * This method allows to paint the icon in the graphics g.
	 */
	public void paintIcon(Component c, Graphics g, int x, int y) 
	{		
		Graphics2D g2 = (Graphics2D) g;
    	
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
		
		Color former = g2.getColor();
		g2.setColor(EDGE); 
		g2.fillRect(x, y, getIconWidth(), getIconHeight());
	 	
		g2.setColor(color); 
		g2.fillRect(x+2, y+2, getIconWidth()-4, getIconHeight()-4); 
	 	
		g2.setColor(former);
	}

	

	/**
	 * Allows to get the colour of the interior of the icon
	 * @return The colour of the interior of the icon
	 */
	public synchronized Color getColor() 
	{ 
		return color; 
	}
	
	
	
	
	/**
	 * Allows to set the colour of the interior of the icon
	 * @param c The new Colour of the interior of the icon
	 */
	public synchronized void setColor(Color c) 
	{ 
		if(c==null)
			throw new IllegalArgumentException();
		
		color = c; 
	}




	/**
	 * Allows to get the width of the icon
	 */
	public int getIconWidth() 
	{
		return WIDTH;
	}



	/**
	 * Allows to get the height of the icon
	 */
	public int getIconHeight() 
	{
		return HEIGHT;
	}
}
