/**************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
* This program is free software; you can redistribute it and/or           *
* modify it either under the terms of the GNU Lesser General Public       *
* License version 3 as published by the Free Software Foundation          *
* (the "LGPL") or, at your option, any later version.                     *
* If you do not alter this notice, a recipient may use your version       *
* of this file under the LGPL.                                            *
*                                                                         *
* You should have received a copy of the LGPL along with this library     *
* in the file COPYING; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                         *
* This software is distributed on an "AS IS" basis, WITHOUT WARRANTY      *
* OF ANY KIND, either express or implied. See the LGPL for                *
* the specific language governing rights and limitations.                 *
**************************************************************************/

#include "xml_parser.h"

char* welcome_token_exchange_parser(char* xml_to_parse)
{
    // <auth type="token-welcome-exchange">
    // <token>JLKJLKJDS</token></auth>
    int size = strlen(xml_to_parse);
    printf("Xml to parse size : %d xml : %s \n",
           size, xml_to_parse);

    xmlNode *cur_node;
    xmlChar *token;

    xmlDocPtr xml_doc;
    xml_doc = xmlParseMemory (xml_to_parse,
                              strlen(xml_to_parse));
    if (xml_doc == NULL)
        fprintf (stderr, "%s:%d Token parser error.\n",
                 __FILE__, __LINE__);

    /*Get the root element node */
    xmlNode *root = NULL;
    root = xmlDocGetRootElement(xml_doc);

    if( !root ||
        !root->name ||
        xmlStrcmp(root->name,(xmlChar*)"auth") ) {
        xmlFreeDoc(xml_doc);
        return 0;
    }

    for(cur_node = root->children; cur_node != NULL;
        cur_node = cur_node->next) {
        if ( cur_node->type == XML_ELEMENT_NODE  &&
             !xmlStrcmp(cur_node->name,
                        (const xmlChar *) "token" ))
        {
            printf("Element: %s \n", cur_node->name);
            token = xmlNodeGetContent(cur_node);
            if(token)
                printf("TOKEN: %s\n", token);
            else {
                /*free the document */
                xmlFreeDoc(xml_doc);

                /*
               *Free the global variables that may
               *have been allocated by the parser.
               */
                xmlCleanupParser();
                return 0;
            }
        }
    }

    /*free the document */
    xmlFreeDoc(xml_doc);

    /*
     *Free the global variables that may
     *have been allocated by the parser.
     */
    xmlCleanupParser();
    return (char *)token;
}

char* authentification_status_parser(char* xml_to_parse)
{
    // <auth type="encryption-status">
    // <status>suceeded</status></auth>
    int size = strlen(xml_to_parse);
    printf("Xml to parse size : %d xml : %s \n",
           size, xml_to_parse);

    xmlNode *cur_node;
    xmlChar *status;

    xmlDocPtr xml_doc;
    xml_doc = xmlParseMemory (xml_to_parse,
                              strlen(xml_to_parse));
    if (xml_doc == NULL)
        fprintf (stderr, "%s:%d Status parser error.\n",
                 __FILE__, __LINE__);


    /*Get the root element node */
    xmlNode *root = NULL;
    root = xmlDocGetRootElement(xml_doc);

    if( !root ||
        !root->name ||
        xmlStrcmp(root->name,(xmlChar*)"auth") ) {
        xmlFreeDoc(xml_doc);
        return 0;
    }

    for(cur_node = root->children; cur_node != NULL;
        cur_node = cur_node->next) {
        if ( cur_node->type == XML_ELEMENT_NODE  &&
             !xmlStrcmp(cur_node->name,
                        (const xmlChar *) "status" ) ) {
            printf("Element: %s \n", cur_node->name);
            status = xmlNodeGetContent(cur_node);
            if(status)
                printf("STATUS: %s\n", status);
            else {
                /*free the document */
                xmlFreeDoc(xml_doc);

                /*
               *Free the global variables that may
               *have been allocated by the parser.
               */
                xmlCleanupParser();
                return 0;
            }
        }
    }

    /*free the document */
    xmlFreeDoc(xml_doc);

    /*
     *Free the global variables that may
     *have been allocated by the parser.
     */
    xmlCleanupParser();
    return (char *)status;
}

char* key_exchange_parser(char* xml_to_parse)
{
    // <auth type="key-exchange"><key>
    // dqsdqsdmqskdlkqsdlkqji</key></auth>
    int size = strlen(xml_to_parse);
    printf("Xml to parse size : %d xml : %s \n",
           size, xml_to_parse);

    xmlNode *cur_node;
    xmlChar *token;

    xmlDocPtr xml_doc;
    xml_doc = xmlParseMemory (xml_to_parse,
                              strlen(xml_to_parse));
    if (xml_doc == NULL)
        fprintf (stderr, "%s:%d key exchange parser error.\n",
                 __FILE__, __LINE__);

    /*Get the root element node */
    xmlNode *root = NULL;
    root = xmlDocGetRootElement(xml_doc);

    if( !root ||
        !root->name ||
        xmlStrcmp(root->name,(xmlChar*)"auth") ) {
        xmlFreeDoc(xml_doc);
        return 0;
    }

    for(cur_node = root->children; cur_node != NULL;
        cur_node = cur_node->next) {
        if ( cur_node->type == XML_ELEMENT_NODE  &&
             !xmlStrcmp(cur_node->name,
                        (const xmlChar *) "key" )) {
            printf("Element: %s \n", cur_node->name);
            token = xmlNodeGetContent(cur_node);
            if(token)
                printf("Key : %s\n", token);
            else {
                /*free the document */
                xmlFreeDoc(xml_doc);

                /*
               *Free the global variables that may
               *have been allocated by the parser.
               */
                xmlCleanupParser();
                return 0;
            }
        }
    }
    /*free the document */
    xmlFreeDoc(xml_doc);

    /*
     *Free the global variables that may
     *have been allocated by the parser.
     */
    xmlCleanupParser();
    return (char *)token;
}

char* password_exchange_parser(char* xml_to_parse)
{
    // <auth type="password"><hash>[password +
    // Token hash]</hash></auth>
    int size = strlen(xml_to_parse);
    printf("Xml to parse size : %d xml : %s \n",
           size, xml_to_parse);

    xmlNode *cur_node;
    xmlChar *token;

    xmlDocPtr xml_doc;
    xml_doc = xmlParseMemory (xml_to_parse,
                              strlen(xml_to_parse));
    if (xml_doc == NULL)
        fprintf (stderr, "%s:%d hash exchange parser error.\n",
                 __FILE__, __LINE__);

    /*Get the root element node */
    xmlNode *root = NULL;
    root = xmlDocGetRootElement(xml_doc);

    if( !root ||
        !root->name ||
        xmlStrcmp(root->name,(xmlChar*)"auth") ) {
        xmlFreeDoc(xml_doc);
        return 0;
    }

    for(cur_node = root->children; cur_node != NULL;
        cur_node = cur_node->next)
    {
        if ( cur_node->type == XML_ELEMENT_NODE  &&
             !xmlStrcmp(cur_node->name,
                        (const xmlChar *) "hash" ) )
        {
            printf("Element: %s \n", cur_node->name);
            token = xmlNodeGetContent(cur_node);
            if(token)
                printf("hash : %s\n", token);
            else {
                /*free the document */
                xmlFreeDoc(xml_doc);

                /*
               *Free the global variables that may
               *have been allocated by the parser.
               */
                xmlCleanupParser();
                return 0;
            }
        }
    }

    /*free the document */
    xmlFreeDoc(xml_doc);

    /*
     *Free the global variables that may
     *have been allocated by the parser.
     */
    xmlCleanupParser();
    return (char *)token;
}

AES_WRAPPER* aes_key_exchange_parser(char* xml_to_parse)
{
    // aes-key-sharing : <auth><k>key</k></auth>
    int size = strlen(xml_to_parse);
    printf("Xml to parse size : %d xml : %s \n",
           size, xml_to_parse);
    AES_WRAPPER *wrapper = new AES_WRAPPER();
    xmlNode *cur_node;
    xmlChar *aes_key;

    xmlDocPtr xml_doc;
    xml_doc = xmlParseMemory (xml_to_parse,
                              strlen(xml_to_parse));
    if (xml_doc == NULL)
        fprintf (stderr, "%s:%d AES key exchange parser error.\n",
                 __FILE__, __LINE__);

    /*Get the root element node */
    xmlNode *root = NULL;
    root = xmlDocGetRootElement(xml_doc);

    if( !root ||
        !root->name ||
        xmlStrcmp(root->name,(xmlChar*)"auth") ) {
        xmlFreeDoc(xml_doc);
        return 0;
    }

    for(cur_node = root->children; cur_node != NULL;
        cur_node = cur_node->next)
    {
        if ( cur_node->type == XML_ELEMENT_NODE  &&
             !xmlStrcmp(cur_node->name,
                        (const xmlChar *) "k" ) )  {
            aes_key = xmlNodeGetContent(cur_node);
            if(aes_key)  {
                wrapper->key = (char*) aes_key;
            }
            else {
                /*free the document */
                xmlFreeDoc(xml_doc);

                /*
               *Free the global variables that may
               *have been allocated by the parser.
               */
                xmlCleanupParser();
                return 0;
            }
        }
    }

    /*free the document */
    xmlFreeDoc(xml_doc);

    /*
     *Free the global variables that may
     *have been allocated by the parser.
     */
    xmlCleanupParser();
    return wrapper;
}
