Business Processes - Icinga Web 2 module
========================================

If you want to visualize and monitor hierarchical business processes based on
any or all objects monitored by Icinga, the Icinga Web 2 business process
module is the way to go.

[![Tile View](doc/screenshot/00_preview/0005_preview-smaller-tile-view.png)](doc/13-Web-Components-Tile-Renderer.md)
[![Tree View](doc/screenshot/00_preview/0006_preview-smaller-tree-view.png)](doc/14-Web-Components-Tree-Renderer.md)
[![Dashboard](doc/screenshot/00_preview/0007_preview-smallerbusinessprocesses-on-dashboard.png)](doc/16-Add-To-Dashboard.md)

Want to create custom process-based dashboards? Trigger notifications at
process or sub-process level? Provide a quick top-level view for thousands of
components on a single screen? That's what this module has been designed for!

You're running a huge cloud, want to get rid of the monitoring noise triggered
by your auto-scaling platform but still want to have detailed information just
a couple of clicks away in case you need them? You will love this little module!

[![Build Status](https://travis-ci.org/Icinga/icingaweb2-module-businessprocess.svg?branch=master)](https://travis-ci.org/Icinga/icingaweb2-module-businessprocess)

Documentation
-------------

### Basics
* [Installation](doc/01-Installation.md)
* [Getting Started](doc/02-Getting-Started.md)
* [Create your first process node](doc/03-Create-your-first-process-node.md)

### Web Components
* [Breadcrumb](doc/12-Web-Components-Breadcrumb.md)
* [Tile Renderer](doc/13-Web-Components-Tile-Renderer.md)
* [Tree Renderer](doc/14-Web-Components-Tree-Renderer.md)
* [Show Processes on a Dashboard](doc/16-Add-To-Dashboard.md)

### Storage
* [Store your Configuration](doc/21-Store-Config.md)
* [Upload an existing Configuration](doc/22-Upload-Config.md)

### Monitoring
* [~~Discover the CLI~~](doc/31-Discover-the-CLI.md)
* [~~Create related Service Checks~~](doc/32-Create-Service-Checks.md)

### Business Impact
* [~~Apply Simulations~~](doc/41-Simulations.md)
* [~~Show Business Impact~~](doc/42-Business-Impact.md)

### The Project
* [Project History](doc/81-History.md)
* [Changelog](doc/82-Changelog.md)
* [Contributing](doc/84-Contributing.md)
