// Copyright 2021-2022 Ian Jackson and contributors to Hippotat
// SPDX-License-Identifier: GPL-3.0-or-later WITH LicenseRef-Hippotat-OpenSSL-Exception
// There is NO WARRANTY.

//! Hippotat - proc macros
//!
//! This crate is an internal detail of hippotat.
//! It does not adhere to semver.

#![allow(clippy::style)]

#![allow(clippy::expect_fun_call)]
#![allow(clippy::map_flatten)]
#![allow(clippy::single_char_pattern)]

use syn::LitStr;
use quote::quote;

#[proc_macro]
pub fn into_crlfs(input: proc_macro::TokenStream) -> proc_macro::TokenStream {
  let input: proc_macro2::TokenStream = input.into();
  let token: LitStr = syn::parse2(input).expect("expected literal");
  let input = token.value();
  let output = input.split_inclusive('\n')
    .map(|s| s.trim_start_matches(&[' ','\t'][..]))
    .map(|s| match s.strip_suffix("\n") {
      None => [s, ""],
      Some(l) => [l, "\r\n"],
    })
    .flatten()
    .collect::<String>();
  //dbg!(&output);
  let output = LitStr::new(&output, token.span());
  let output = quote!(#output);
  output.into()
}
