{- This module was generated from data in the Kate syntax
   highlighting file javadoc.xml, version 1.05, by Alfredo Luiz Foltran Fialho (alfoltran@ig.com.br) -}

module Text.Highlighting.Kate.Syntax.Javadoc
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Html
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)

-- | Full name of language.
syntaxName :: String
syntaxName = "Javadoc"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = ""

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Javadoc","Start")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("Javadoc","Start") -> return ()
      ("Javadoc","FindJavadoc") -> return ()
      ("Javadoc","JavadocFSar") -> return ()
      ("Javadoc","Javadocar") -> return ()
      ("Javadoc","JavadocParam") -> (popContext) >> pEndLine
      ("Javadoc","InlineTagar") -> return ()
      ("Javadoc","LiteralTagar") -> return ()
      ("Javadoc","SeeTag") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)


regex_'28'21'7c'5c'3f'29 = compileRegex True "(!|\\?)"
regex_'28'5c'2e'5cs'2a'24'29 = compileRegex True "(\\.\\s*$)"
regex_'28'5c'2e'5cs'29'28'3f'21'5b'5cda'2dz'5d'29 = compileRegex True "(\\.\\s)(?![\\da-z])"
regex_'5c'2a'2a'5cs'2a'28'3f'3d'40'28author'7cdeprecated'7cexception'7cparam'7creturn'7csee'7cserial'7cserialData'7cserialField'7csince'7cthrows'7cversion'29'28'5cs'7c'24'29'29 = compileRegex True "\\**\\s*(?=@(author|deprecated|exception|param|return|see|serial|serialData|serialField|since|throws|version)(\\s|$))"
regex_'5c'2a'2b'28'3f'21'2f'29 = compileRegex True "\\*+(?!/)"
regex_'5cS'2a'28'3f'3d'5c'2a'2f'29 = compileRegex True "\\S*(?=\\*/)"
regex_'5cS'2a'28'5cs'7c'24'29 = compileRegex True "\\S*(\\s|$)"

parseRules ("Javadoc","Start") =
  (((parseRules ("Javadoc","FindJavadoc")))
   <|>
   (currentContext >>= \x -> guard (x == ("Javadoc","Start")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Javadoc","FindJavadoc") =
  (((pString False "/**/" >>= withAttribute CommentTok))
   <|>
   ((pString False "/**" >>= withAttribute CommentTok) >>~ pushContext ("Javadoc","JavadocFSar"))
   <|>
   (currentContext >>= \x -> guard (x == ("Javadoc","FindJavadoc")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Javadoc","JavadocFSar") =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'28'21'7c'5c'3f'29 >>= withAttribute CommentTok) >>~ pushContext ("Javadoc","Javadocar"))
   <|>
   ((pRegExpr regex_'28'5c'2e'5cs'2a'24'29 >>= withAttribute CommentTok) >>~ pushContext ("Javadoc","Javadocar"))
   <|>
   ((pRegExpr regex_'28'5c'2e'5cs'29'28'3f'21'5b'5cda'2dz'5d'29 >>= withAttribute CommentTok) >>~ pushContext ("Javadoc","Javadocar"))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'5c'2a'2a'5cs'2a'28'3f'3d'40'28author'7cdeprecated'7cexception'7cparam'7creturn'7csee'7cserial'7cserialData'7cserialField'7csince'7cthrows'7cversion'29'28'5cs'7c'24'29'29 >>= withAttribute CommentTok) >>~ pushContext ("Javadoc","Javadocar"))
   <|>
   ((pString False "{@code " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","LiteralTagar"))
   <|>
   ((pString False "{@code " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","LiteralTagar"))
   <|>
   ((pString False "{@docRoot}" >>= withAttribute KeywordTok))
   <|>
   ((pString False "{@inheritDoc}" >>= withAttribute KeywordTok))
   <|>
   ((pString False "{@link " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","InlineTagar"))
   <|>
   ((pString False "{@link " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","InlineTagar"))
   <|>
   ((pString False "{@linkplain " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","InlineTagar"))
   <|>
   ((pString False "{@linkplain " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","InlineTagar"))
   <|>
   ((pString False "{@literal " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","LiteralTagar"))
   <|>
   ((pString False "{@literal " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","LiteralTagar"))
   <|>
   ((pString False "{@value}" >>= withAttribute KeywordTok))
   <|>
   ((pString False "{@value " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","InlineTagar"))
   <|>
   ((pString False "{@value " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","InlineTagar"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Html.parseExpression (Just ("HTML","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Javadoc","JavadocFSar")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Javadoc","Javadocar") =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext >> popContext))
   <|>
   ((pFirstNonSpace >> pRegExpr regex_'5c'2a'2b'28'3f'21'2f'29 >>= withAttribute CommentTok))
   <|>
   ((pString False "@author " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@deprecated " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@exception " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","JavadocParam"))
   <|>
   ((pString False "@param " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","JavadocParam"))
   <|>
   ((pString False "@return " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@see " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","SeeTag"))
   <|>
   ((pString False "@serial " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@serialData " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@serialField " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@since " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@throws " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","JavadocParam"))
   <|>
   ((pString False "@version " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@author " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@deprecated " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@exception " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","JavadocParam"))
   <|>
   ((pString False "@param " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","JavadocParam"))
   <|>
   ((pString False "@return " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@see " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","SeeTag"))
   <|>
   ((pString False "@serial " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@serialData " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@serialField " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@since " >>= withAttribute KeywordTok))
   <|>
   ((pString False "@throws " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","JavadocParam"))
   <|>
   ((pString False "@version " >>= withAttribute KeywordTok))
   <|>
   ((pString False "{@code " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","LiteralTagar"))
   <|>
   ((pString False "{@code " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","LiteralTagar"))
   <|>
   ((pString False "{@docRoot}" >>= withAttribute KeywordTok))
   <|>
   ((pString False "{@inheritDoc}" >>= withAttribute KeywordTok))
   <|>
   ((pString False "{@link " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","InlineTagar"))
   <|>
   ((pString False "{@link " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","InlineTagar"))
   <|>
   ((pString False "{@linkplain " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","InlineTagar"))
   <|>
   ((pString False "{@linkplain " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","InlineTagar"))
   <|>
   ((pString False "{@literal " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","LiteralTagar"))
   <|>
   ((pString False "{@literal " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","LiteralTagar"))
   <|>
   ((pString False "{@value}" >>= withAttribute KeywordTok))
   <|>
   ((pString False "{@value " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","InlineTagar"))
   <|>
   ((pString False "{@value " >>= withAttribute KeywordTok) >>~ pushContext ("Javadoc","InlineTagar"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Html.parseExpression (Just ("HTML","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Javadoc","Javadocar")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Javadoc","JavadocParam") =
  (((pDetectSpaces >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'5cS'2a'28'3f'3d'5c'2a'2f'29 >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pRegExpr regex_'5cS'2a'28'5cs'7c'24'29 >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Javadoc","JavadocParam")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Javadoc","InlineTagar") =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Html.parseExpression (Just ("HTML","")) >>= ((withAttribute KeywordTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Javadoc","InlineTagar")) >> pDefault >>= withAttribute KeywordTok))

parseRules ("Javadoc","LiteralTagar") =
  (((pDetectChar False '}' >>= withAttribute KeywordTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext >> popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Javadoc","LiteralTagar")) >> pDefault >>= withAttribute KeywordTok))

parseRules ("Javadoc","SeeTag") =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext >> popContext >> popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Html.parseExpression (Just ("HTML","")) >>= ((withAttribute KeywordTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Javadoc","SeeTag")) >> pDefault >>= withAttribute KeywordTok))

parseRules ("HTML", _) = Text.Highlighting.Kate.Syntax.Html.parseExpression Nothing

parseRules x = parseRules ("Javadoc","Start") <|> fail ("Unknown context" ++ show x)
