/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.tag.html;

import org.dbdoclet.xiphias.dom.NodeImpl;
import org.dbdoclet.xiphias.dom.TextImpl;


public class Fieldset extends ReplaceElement {

    private static final String tag = "fieldset";

    public Fieldset() {

        setNodeName(tag);
        setFormatType(FORMAT_BLOCK);
    }

    @Override
	public void closed() {

        NodeImpl child = getFirstChild();

        if (!(child instanceof Legend)) {
            insertChild(0, new Legend().appendChild(new TextImpl("Legend")));
        }
    }
}
