/*
Copyright (C) 2002  The PARI group.

This file is part of the GP2C package.

PARI/GP is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation. It is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY WHATSOEVER.

Check the License for details. You should have received a copy of it, along
with the package; see the file 'COPYING'. If not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA. */

int debug_stack;

typedef struct
{
  long offset;
  int n;
  int alloc;
  size_t size;
} stack;

void **stack_base(stack *s);
void stack_init(stack *s, int size, void **data);
int  stack_new(stack *s);
void stack_pop(stack *s);
void stack_pop_safe(stack *s, int n);
void stack_push(stack *s, stack *t);
void stack_replace(stack *s, stack *t);
void stack_push_int(stack *s, int val);
int stack_has_int(stack *s, int val);
void stack_remove_int(stack *s, int val);
void stack_int_sort(stack *s);
void stack_int_merge(stack *s, stack *t);

