// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// The configuration for a Slack channel that you added for your Amazon Web
// Services account.
type SlackChannelConfiguration struct {

	// The channel ID in Slack. This ID identifies a channel within a Slack workspace.
	//
	// This member is required.
	ChannelId *string

	// The team ID in Slack. This ID uniquely identifies a Slack workspace, such as
	// T012ABCDEFG .
	//
	// This member is required.
	TeamId *string

	// The name of the Slack channel that you configured with the Amazon Web Services
	// Support App for your Amazon Web Services account.
	ChannelName *string

	// The Amazon Resource Name (ARN) of an IAM role that you want to use to perform
	// operations on Amazon Web Services. For more information, see Managing access to
	// the Amazon Web Services Support App (https://docs.aws.amazon.com/awssupport/latest/user/support-app-permissions.html)
	// in the Amazon Web Services Support User Guide.
	ChannelRoleArn *string

	// Whether you want to get notified when a support case has a new correspondence.
	NotifyOnAddCorrespondenceToCase *bool

	// The case severity for a support case that you want to receive notifications.
	NotifyOnCaseSeverity NotificationSeverityLevel

	// Whether you want to get notified when a support case is created or reopened.
	NotifyOnCreateOrReopenCase *bool

	// Whether you want to get notified when a support case is resolved.
	NotifyOnResolveCase *bool

	noSmithyDocumentSerde
}

// The configuration for a Slack workspace that you added to an Amazon Web
// Services account.
type SlackWorkspaceConfiguration struct {

	// The team ID in Slack. This ID uniquely identifies a Slack workspace, such as
	// T012ABCDEFG .
	//
	// This member is required.
	TeamId *string

	// Whether to allow member accounts to authorize Slack workspaces. Member accounts
	// must be part of an organization in Organizations.
	AllowOrganizationMemberAccount *bool

	// The name of the Slack workspace.
	TeamName *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
