-- ==============================================================
-- GNUmed database schema change script
--
-- License: GPL v2 or later
-- Author: karsten.hilbert@gmx.net
-- 
-- ==============================================================
\set ON_ERROR_STOP 1

-- --------------------------------------------------------------
\unset ON_ERROR_STOP
drop table staging.icpc cascade;
\set ON_ERROR_STOP 1

create table staging.icpc (
	COMPONENT integer,
 	description text,
 	SHORT text,
 	icd_10 text,
 	CRIT text,
 	INCL text,
 	EXCL text,
 	CONS text,
 	NOTE text,
 	icpc integer,					-- a flag whether ICPC2 or not, always 1
 	CODE text
);

-- --------------------------------------------------------------
-- insert staging data
delete from staging.icpc;

INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (NULL,'GENERAL/UNSPECIFIED',NULL,NULL,NULL,NULL,NULL,NULL,'In this classification, ''general'' or ''multiple'' refers to three or more body sites or systems.  Conditions affecting one or two sites should be coded to the appropriate sites.',1,'A');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PAIN GENERAL/MULTIPLE SITES','PAIN GENERAL/MULTIPLE SITES','R52',NULL,'chronic general pain, multiple aches','unspecified pain A29',NULL,NULL,1,'A01');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CHILLS','CHILLS','R50, R68.8',NULL,'rigors, shivers','fever A03',NULL,NULL,1,'A02');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEVER','FEVER','R50',NULL,'pyrexia','fever with rash A76; heat exhaustion/stroke A88',NULL,NULL,1,'A03');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'WEAKNESS/TIREDNESS GENERAL','WEAKNESS/TIREDNESS GENERAL','G93.3, R53',NULL,'chronic fatigue syndrome, exhaustion, fatigue, lassitude, lethargy, postviral fatigue','malaise/feeling ill A05; drowsy A29; heat exhaustion A88; jet lag A88; somnolence P06',NULL,NULL,1,'A04');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEELING ILL','FEELING ILL','R53',NULL,'malaise','senescence/senility P05; cachexia T08; malnutrition T91',NULL,NULL,1,'A05');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FAINTING/SYNCOPE','FAINTING/SYNCOPE','R55',NULL,'blackout, collapse, vasovagal attack','coma A07; feeling faint/giddiness/dizziness N17',NULL,NULL,1,'A06');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'COMA','COMA','R40',NULL,'stupor','syncope A06',NULL,NULL,1,'A07');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SWELLING','SWELLING','R68.8',NULL,'lump, mass NOS','enlarged lymph gland B02; oedema K07; swelling joint L20; swelling breast X19, Y16',NULL,NULL,1,'A08');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SWEATING PROBLEM','SWEATING PROBLEM','R61',NULL,'hyperhydrosis, night sweats, perspiration problem','sweat gland disease S92',NULL,NULL,1,'A09');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'BLEEDING/HAEMORRHAGE NOS','BLEEDING/HAEMORRHAGE NOS','R58',NULL,NULL,NULL,NULL,NULL,1,'A10');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CHEST PAIN NOS','CHEST PAIN NOS','R07.3, R07.4',NULL,NULL,'pain attributed to heart K01; pain attributed to chest wall L04; pain attributed to respiratory system R01',NULL,NULL,1,'A11');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'transferred to A92',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A12');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CONCERN ABOUT/FEAR OF MEDICAL TREATMENT','CONCERN/FEAR MEDICAL TREATMENT','Z71.1',NULL,'concern about/fear of the consequences of drug/medical treatment','adverse effect of drug A85; complication of medical/surgical treatment A87',NULL,NULL,1,'A13');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'included with D01',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A14');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'included with A16',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A15');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'IRRITABLE INFANT','IRRITABLE INFANT','R68.1',NULL,'excessively crying/restless infant','infantile colic D01; restless child/adult P04',NULL,NULL,1,'A16');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'included with A16',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'A17');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CONCERN ABOUT APPEARANCE','CONCERN ABOUT APPEARANCE','R46.8',NULL,NULL,'concern about appearance of ears H15; concern about appearance in pregnancy W21; concern about appearance of breasts X22',NULL,NULL,1,'A18');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'EUTHANASIA REQUEST/DISCUSSION','EUTHANASIA REQUEST/DISCUSSION','Z71.8',NULL,NULL,NULL,NULL,NULL,1,'A20');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'RISK FACTOR FOR MALIGNANCY','RISK FACTOR FOR MALIGNANCY','Z80, Z85',NULL,'personal/family history of malignancy, past treatment, other risk factor for malignancy',NULL,NULL,NULL,1,'A21');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'RISK FACTOR NOS','RISK FACTOR NOS','Z20, Z23, Z24, Z25, Z26, Z27, Z28, Z29, Z72.0, Z72.1, Z72.2, Z72.3, Z72.4, Z72.5, Z73.2, Z81, Z82.0, Z82.1, Z82.2, Z82.5, Z82.6, Z82.7, Z82.8, Z83, Z84, Z86.0, Z86.1, Z86.2, Z86.3, Z86.4, Z86.5, Z86.6, Z87, Z88, Z91, Z92',NULL,'contact with infectious disease, personal/family history, previous episode, other risk factor for other disease','risk factor for malignancy A21; risk factor for cardiovascular disease K22',NULL,NULL,1,'A23');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF DEATH/DYING','FEAR OF DEATH/DYING','Z71.1',NULL,NULL,NULL,NULL,NULL,1,'A25');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF CANCER NOS','FEAR OF CANCER NOS','Z71.1','concern about/fear of cancer not related to a specific chapter in a patient without the disease/until the diagnosis is proven',NULL,'if the patient has cancer, code the disease',NULL,NULL,1,'A26');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF OTHER DISEASE NOS','FEAR OF OTHER DISEASE NOS','Z71.1','concern about/fear of an other disease not related to a specific chapter in a patient without the disease/until the diagnosis is proven',NULL,'fear of cancer NOS A26; if the patient has the disease, code the disease',NULL,NULL,1,'A27');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LIMITED FUNCTION/DISABILITY NOS','LIMITED FUNCTION/DISABILITY NOS','Z73.6, Z74, Z93.8, Z93.9, Z99.0, Z99.3, Z99.8, Z99.9','limitation of function/disability not related to a problem in any other chapter',NULL,'falls A29',NULL,'The COOP/WONCA Charts are suitable for documenting the patient''s functional status (see Chapter 8).',1,'A28');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'GENERAL SYMPTOM/COMPLAINT OTHER','GENERAL SYMPTOM/COMPLAINT OTHER','F45.3, F45.4, F45.8, F45.9, R68.0, R68.8',NULL,'clumsiness, drowsy, falls, unspecified pain',NULL,NULL,NULL,1,'A29');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation complete','Medical examin/health eval complete',NULL,NULL,NULL,NULL,NULL,NULL,1,'A30');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation partial','Medical examin/health eval partial',NULL,NULL,NULL,NULL,NULL,NULL,1,'A31');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Sensitivity test','Sensitivity test',NULL,NULL,NULL,NULL,NULL,NULL,1,'A32');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Microbiological/immunological test','Microbiological/immunological test',NULL,NULL,NULL,NULL,NULL,NULL,1,'A33');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Blood test','Blood test',NULL,NULL,NULL,NULL,NULL,NULL,1,'A34');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Urine test','Urine test',NULL,NULL,NULL,NULL,NULL,NULL,1,'A35');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Faeces test','Faeces test',NULL,NULL,NULL,NULL,NULL,NULL,1,'A36');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Histological/exfoliative cytology','Histological/exfoliative cytology',NULL,NULL,NULL,NULL,NULL,NULL,1,'A37');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other laboratory test NEC','Other laboratory test NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'A38');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Physical function test','Physical function test',NULL,NULL,NULL,NULL,NULL,NULL,1,'A39');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic endoscopy','Diagnostic endoscopy',NULL,NULL,NULL,NULL,NULL,NULL,1,'A40');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic radiology/imaging','Diagnostic radiology/imaging',NULL,NULL,NULL,NULL,NULL,NULL,1,'A41');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Electrical tracing','Electrical tracing',NULL,NULL,NULL,NULL,NULL,NULL,1,'A42');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other diagnostic procedure','Other diagnostic procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'A43');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Preventive immunization/medication','Preventive immunization/medication',NULL,NULL,NULL,NULL,NULL,NULL,1,'A44');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Observation/health education/advice/diet','Observ/health educat/advice/diet',NULL,NULL,NULL,NULL,NULL,NULL,1,'A45');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with primary care provider','Consultation primary care provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'A46');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Clarification/discussion of patient''s RFE/demand','Clarification/discussion RFE/demand',NULL,NULL,NULL,NULL,NULL,NULL,1,'A48');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other preventive procedure','Other preventive procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'A49');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Medication/prescription/renewal/injection','Medication/prescr/renewal/inject',NULL,NULL,NULL,NULL,NULL,NULL,1,'A50');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Incision/drainage/flushing/aspiration/removal body fluid (excl. catheterisation - 53)\n
 (excl. catheterisation - 53)','I&D/flush/aspiration (excl cath -53)',NULL,NULL,NULL,NULL,NULL,NULL,1,'A51');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Excision/removal tissue/biopsy/destruction/debridement/cauterization','Exc/remov/biopsy/destruc/debrid/caut',NULL,NULL,NULL,NULL,NULL,NULL,1,'A52');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Instrumentation/catheterization/intubation/dilation','Instrument/catheter/intubate/dilate',NULL,NULL,NULL,NULL,NULL,NULL,1,'A53');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Repair/fixation-suture/cast/prosthetic device (apply/remove)','Repair/fix-suture/cast/prosth device',NULL,NULL,NULL,NULL,NULL,NULL,1,'A54');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Local injection/infiltration','Local injection/infiltration',NULL,NULL,NULL,NULL,NULL,NULL,1,'A55');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Dressing/pressure/compression/tamponade','Dressing/pressure/compress/tamponade',NULL,NULL,NULL,NULL,NULL,NULL,1,'A56');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Physical medicine/rehabilitation','Physical medicine/rehabilitation',NULL,NULL,NULL,NULL,NULL,NULL,1,'A57');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Therapeutic counselling/listening','Therapeutic counselling/listening',NULL,NULL,NULL,NULL,NULL,NULL,1,'A58');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Other therapeutic procedure/minor surgery NEC','Other therap proced/minor surg NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'A59');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result test/procedure','Result test/procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'A60');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result examination/test/record/letter from other provider','Result exam/test/lett oth provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'A61');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (5,'Administrative procedure','Administrative procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'A62');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Follow-up encounter unspecified','Follow-up encounter unspecified',NULL,NULL,NULL,NULL,NULL,NULL,1,'A63');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by provider','Encounter/prob initiated by provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'A64');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by other than patient/provider','Enc/prob init by other than pt/prov',NULL,NULL,NULL,NULL,NULL,NULL,1,'A65');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to other provider/nurse/therapist/social worker','Referral to non-MD provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'A66');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to physician/specialist/clinic/hospital','Referral to MD/specialist/clin/hosp',NULL,NULL,NULL,NULL,NULL,NULL,1,'A67');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other referral NEC','Other referral NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'A68');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other reason for encounter NEC','Other reason for encounter NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'A69');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'TUBERCULOSIS','TUBERCULOSIS','A15, A16, A17, A18, A19, B90','conversion to a positive tuberculin skin test; or demonstration of Mycobacterium tuberculosis on microscopy or culture; or characteristic chest X-ray appearance; or characteristic histological appearance on biopsy','tuberculosis infection of any body site, late effect of tuberculosis',NULL,'fever A03; cough R05',NULL,1,'A70');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MEASLES','MEASLES','B05','prodrome with injected conjunctivae, fever, and cough; plus white specks on a red base in the mucous membranes of the cheek (Koplik''s spots), or confluent maculopapular eruption spreading over the face and body, or an atypical exanthem in a partially immune person during an epidemic of measles; or serological evidence of acute measles','complications of measles',NULL,'fever A03; other viral exanthem A76; generalized rash S07',NULL,1,'A71');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CHICKENPOX','CHICKENPOX','B01','a vesicular exanthem which appears in successive crops, with the lesions evolving rapidly from superficial papules to vesicles and eventually to scabs','complications of chickenpox','herpes zoster S70','fever A03; other viral exanthem A76; generalized rash S07',NULL,1,'A72');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALARIA','MALARIA','B50, B51, B52, B53, B54','intermittent fever with chills and rigors in resident of/recent  visitor to a malarial region; or demonstration of malarial parasite forms in the peripheral blood','complications of malaria',NULL,'fever A03',NULL,1,'A73');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'RUBELLA','RUBELLA','B06','an acute exanthem with enlarged lymph nodes, most often suboccipital and post-auricular, with a macular rash on the face, spreading to the trunk and proximal portions of the limbs; or serological evidence of rubella infection','complications of rubella, congenital rubella','roseola infantum A76','fever A03; other viral exanthem A76; generalized rash S07',NULL,1,'A74');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'INFECTIOUS MONONUCLEOSIS','INFECTIOUS MONONUCLEOSIS','B27','inflammation of the tonsils/pharynx with lymphadenopathy not confined to the anterior cervical nodes, and either atypical lymphocytes on blood smear or splenomegaly; or abnormal heterophile antibody titre or Epstein-Barr virus titre','glandular fever, M. Pfeiffer',NULL,'fever A03; enlarged lymph nodes B02; acute upper respiratory tract infection R74',NULL,1,'A75');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'VIRAL EXANTHEM OTHER','VIRAL EXANTHEM OTHER','A88.0, B03, B04, B08.0, B08.2, B08.3, B08.4, B08.8, B09',NULL,'fever with rash, fifth disease, roseola infantum','diseases specified in A71, A72, A74, A75',NULL,NULL,1,'A76');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'VIRAL DISEASE OTHER/NOS','VIRAL DISEASE OTHER/NOS','A82, A90, A91, A92, A93, A94, A95, A96, A98, A99, B00.7, B25, B33.0, B33.1, B33.3, B33.8, B34, B97',NULL,'adenovirus, cowpox, Coxsackie diseases, dengue fever, hand foot and mouth disease, Ross River fever','other viral exanthem A76; influenza R80',NULL,NULL,1,'A77');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'INFECTIOUS DISEASE OTHER/NOS','INFECTIOUS DISEASE OTHER/NOS','A20, A21, A22, A23, A24, A25, A26, A27, A28, A30, A31, A32, A38, A39.1, A39.2, A39.3, A39.4, A39.8, A39.9, A40, A41, A42, A43, A44, A48.0, A48.2, A48.3, A48.4, A48.8, A49, A59.8, A59.9, A64, A68, A69.2, A69.8, A69.9, A70, A74.8, A74.9, A75, A77, A78, A79, B37.7, B37.8, B37.9, B38, B39, B40, B41, B42, B43, B45, B46, B47, B48, B49, B55, B56, B57, B58.8, B58.9, B59, B60, B64, B89, B92, B94.8, B94.9, B95, B96, B99',NULL,'brucellosis, infection unspecified site, Lyme disease, mycoplasma, Q fever; rickettsial disease, scarlet fever, sexually transmitted disease NOS, thrush NOS, toxoplasmosis','meningococcal meningitis N71',NULL,NULL,1,'A78');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANCY NOS','MALIGNANCY NOS','C38.1, C38.2, C38.3, C38.8, C45.7, C45.9, C46.7, C46.8, C46.9, C76, C78, C79, C80, C97, D09.7, D09.9','histological evidence of malignancy','secondary/metastatic neoplasm when primary site is unknown, carcinomatosis (unknown primary)',NULL,'disease/condition of unspecified nature/site A99',NULL,1,'A79');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'TRAUMA/INJURY NOS','TRAUMA/INJURY NOS','S11, S15, S21, S25, S26, S27, S35, S37.9, S38.1, S38.3, S39, S45, S55, S65, S75, S85, S95, T09, T14.5, T14.7, T14.8, T14.9, T28.4, T28.9',NULL,'road traffic accident','multiple trauma A81; late effect of trauma A82',NULL,NULL,1,'A80');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MULTIPLE TRAUMA/INJURIES','MULTIPLE TRAUMA/INJURIES','S31.7, S36.7, S36.8, S36.9, S37.7, S37.8, S39, T00, T01, T02, T03, T04, T05, T06.5, T06.8, T07, T29',NULL,'multiple internal injuries NOS',NULL,NULL,'In this classification ''general'' or ''multiple'' refers to three or more body sites or systems. Conditions affecting one or two sites should be coded to these sites.',1,'A81');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SECONDARY EFFECT OF TRAUMA','SECONDARY EFFECT OF TRAUMA','T79.0, T79.1, T79.2, T79.4, T79.5, T79.7, T79.8, T79.9, T90, T91, T92, T93, T94, T95, T96, T97, T98',NULL,'deformity/scarring resulting from previous injury, old amputation','effects related to specific body systems: code to system chapter; psychological effects of trauma/acute stress reaction P02; post-traumatic stress disorder P82; wound infection S11; scar of skin S99',NULL,NULL,1,'A82');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'POISONING BY MEDICAL AGENT','POISONING BY MEDICAL AGENT','T36, T37, T38, T39, T40, T41, T42, T43, T44, T45, T46, T47, T48, T49, T50','toxicity/impairment produced by accidental/deliberate overdose of an agent which has remedial properties in its usual dosage','toxic effect of overdose medical agent','medication abuse P18; suicide attempt P77; insulin coma T87',NULL,NULL,1,'A84');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ADVERSE EFFECT MEDICAL AGENT','ADVERSE EFFECT MEDICAL AGENT','D61.1, D64.2, G44.4, I95.2, L27.0, L27.1','symptom/complaint attributed to the proper use of medication, rather than due to disease or injury','side effect/allergy/anaphylaxis due to medication in proper dose','poisoning by medical agent A84; reaction to immunization/transfusion A87; Parkinsonism N87; medication abuse P18; contact dermatitis S88; insulin coma T87; analgesic nephropathy U88',NULL,'May also code the nature of the adverse effect',1,'A85');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'TOXIC EFFECT NON-MEDICINAL SUBSTANCE','TOXIC EFFECT NON-MEDICINAL SUBSTANCE','D61.2, D64.2, T51, T52, T53, T54, T55, T56, T57, T58, T59, T60, T61, T62, T63, T64, T65',NULL,'general/local toxic effect carbon monoxide, industrial materials, lead, poisonous animals/insects/plants/snakes','poisoning/adverse effect medical agent A84, A85; chronic/acute alcohol abuse P15, P16; tobacco abuse P17; medication abuse P18; drug abuse P19; respiratory toxic effects R99; non-toxic bites S12, S13; external chemical burns S14; contact dermatitis S88',NULL,NULL,1,'A86');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'COMPLICATION OF MEDICAL TREATMENT','COMPLICATION OF MEDICAL TREATMENT','E89, G97, H95, I97, J95, K91.0, K91.3, M96, N99, O29, O74, O86.0, O89, O90.0, O90.1, O90.2, T80, T81, T86, T87, T88','an unexpected disorder resulting from surgical/medical/X-ray treatment/other medical management','anaesthetic shock, immunization/transfusion reaction, post-operative infection/haemorrhage/wound disruption, problems due to radiation for diagnosis/treatment','poisoning by medical agent A84; adverse effects of medication A85; other hernia abdominalis D91; hypoglycaemia T87',NULL,NULL,1,'A87');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ADVERSE EFFECT PHYSICAL FACTOR','ADVERSE EFFECT PHYSICAL FACTOR','T33, T34, T35, T66, T67, T68, T69, T70.2, T70.3, T70.4, T70.8, T70.9, T71, T73, T75, T78.8, T78.9',NULL,'adverse effect cold/heat/lightning/motion/pressure/radiation, chilblains, drowning, jet lag','effect of medical radiation A87; snowblindness F79; effect of alcohol P15, P16; effect of tobacco P17; burn due to radiation S14; sunburn S80',NULL,NULL,1,'A88');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'EFFECT PROSTHETIC DEVICE','EFFECT PROSTHETIC DEVICE','K91.4, T82, T83, T84, T85, Z43, Z44, Z45, Z46.1, Z46.2, Z46.3, Z46.4, Z46.5, Z46.6, Z46.7, Z46.8, Z46.9, Z95, Z96, Z97',NULL,'discomfort/handicap/pain/limitation of function resulting from the fitting/wearing of a device for supplying/amending deficiencies: catheter, colostomy, gastrostomy, heart valve, joint replacement, organ transplant, pacemaker','effect denture/false teeth D19',NULL,NULL,1,'A89');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONGENITAL ANOMALY NOS/MULTIPLE','CONGENITAL ANOMALY NOS/MULTIPLE','Q85, Q86, Q87, Q89.3, Q89.4, Q89.7, Q89.9, Q90, Q91, Q92, Q93, Q95, Q96, Q97, Q98, Q99',NULL,'Down''s syndrome, Marfan''s syndrome, other chromosome abnormality, neurofibromatosis','anomaly related to a specific body system to be coded to system chapter; congenital rubella A74',NULL,NULL,1,'A90');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ABNORMAL RESULT INVESTIGATION NOS','ABNORMAL RESULT INVESTIGATION NOS','R73, R74, R76, R77, R78, R79, R83, R84, R85, R86, R87, R89, R90, R91, R92, R93, R94','abnormal result not attributed to known disease','abnormal unexplained pathology/imaging test, electrolyte disorder, hyperglycaemia','unexplained abnormal white cells B84; other haematological abnormality B99; vitamin/nutritional deficiency T91; abnormal urine test U98; abnormal cervix smear X86',NULL,NULL,1,'A91');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ALLERGY/ALLERGIC REACTION NOS','ALLERGY/ALLERGIC REACTION NOS','T78.0, T78.1, T78.2, T78.3, T78.4',NULL,'allergic oedema, anaphylactic shock, angioneurotic oedema, food allergy','allergy resulting from medication A85; allergic rhinitis R97; urticaria S98',NULL,NULL,1,'A92');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PREMATURE NEWBORN','PREMATURE NEWBORN','P07','livebirth under 37 weeks'' gestation',NULL,NULL,NULL,NULL,1,'A93');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PERINATAL MORBIDITY OTHER','PERINATAL MORBIDITY OTHER','P00, P01, P02, P03, P04, P05, P08, P10, P11, P12, P13, P14, P15, P20, P21, P22, P23, P24, P25, P26, P27, P28, P29, P35, P36, P37, P38, P39, P50, P51, P52, P53, P54, P55, P56, P57, P58, P59, P60, P61, P70, P71, P72, P74, P75, P76, P77, P78, P80, P81, P83, P90, P91, P92, P93, P94, P96','morbidity originating in utero or within 7 days of birth',NULL,'congenital condition A90; premature newborn A93; failure to thrive T10',NULL,NULL,1,'A94');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PERINATAL MORTALITY','PERINATAL MORTALITY','P95, R95','death in utero or within 7 days of birth',NULL,NULL,NULL,NULL,1,'A95');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'DEATH','DEATH','R95, R96, R98, R99',NULL,NULL,'perinatal death A95',NULL,NULL,1,'A96');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'NO DISEASE','NO DISEASE','Z00, Z02',NULL,'no illness/disease dealt with at encounter','health maintenance/preventive medicine A98',NULL,'Sometimes a patient has a reason for encounter which the family doctor cannot interpret as a  diagnosis within the domain of family practice. In these cases the FP/GP will use the code A97, indicating that the patient''s reason for encounter refers to something the FP/GP cannot professionally respond to, except by explaining that this is the case.',1,'A97');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HEALTH MAINTENANCE/PREVENTIVE MEDICINE','HEALTH MAINT/PREVENTIVE MEDICINE','Z01, Z10, Z11, Z12, Z13, Z40, Z70',NULL,'medical procedure/counselling with a primary/secondary preventive purpose, including genetic counseling','no disease A97',NULL,NULL,1,'A98');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'DISEASE/CONDITION OF UNSPECIFIED NATURE/SITE','DISEASE/CONDITION UNSPECNATURE/SITE','D15.7, D15.9, D36.7, D36.9, R69, Z03, Z04, Z08, Z09, Z22, Z41, Z42, Z47, Z48, Z49, Z50, Z51, Z52, Z53, Z54, Z71.0, Z71.2, Z71.3, Z71.4, Z71.5, Z71.6, Z71.7, Z71.8, Z71.9, Z76, Z90.0, Z90.8, Z94.8, Z94.9, Z98.8',NULL,'disease carrier NOS, surveillance of ongoing problem NOS',NULL,NULL,NULL,1,'A99');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (NULL,'BLOOD/BLOOD FORMING ORGANS/IMMUNE MECHANISM',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'B');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LYMPH GLAND(S) ENLARGED/PAINFUL','LYMPH GLAND(S) ENLARGED/PAINFUL','R59',NULL,'lymphadenopathy with/without pain/tenderness, other symptom/complaint lymph gland(s)','acute lymphadenitis B70; chronic/non-specific lymphadenitis B71',NULL,NULL,1,'B02');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'included with B02',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'B03');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'BLOOD SYMPTOM/COMPLAINT','BLOOD SYMPTOM/COMPLAINT','R68.8',NULL,NULL,'anaemia B82; pallor S08',NULL,NULL,1,'B04');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF AIDS/HIV','FEAR OF AIDS/HIV','Z71.1','concern about/fear of AIDS/HIV in a patient without the disease/until the diagnosis is proven',NULL,'if the patient has the disease, code the disease',NULL,NULL,1,'B25');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF BLOOD/LYMPH DISEASE OTHER','FEAR BLOOD/LYMPH DISEASE OTHER','Z71.1','concern about/fear of other blood/lymph disease in a patient without the disease/until the diagnosis is proven',NULL,'fear of cancer blood/lymph B26; if the patient has the disease, code the disease',NULL,NULL,1,'B27');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LIMITED FUNCTION/DISABILITY (B)','LIMITED FUNCTION/DISABILITY (B)','Z73.6','limitation of function/disability due to a problem of blood/blood forming organs/immune mechanism','disability due to bleeding disorders',NULL,NULL,'The COOP/WONCA Charts are suitable for documenting the patient''s functional status (see Chapter 8).',1,'B28');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SYMPTOM/COMPLAINT LYMPH/IMMUNE MECHANISM OTHER','SYMPT/COMPLT LYMPH/IMMUNE MECH OTHER','R68.8',NULL,NULL,'splenomegaly B87',NULL,NULL,1,'B29');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation complete','Medical examin/health eval complete',NULL,NULL,NULL,NULL,NULL,NULL,1,'B30');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation partial','Medical examin/health eval partial',NULL,NULL,NULL,NULL,NULL,NULL,1,'B31');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Sensitivity test','Sensitivity test',NULL,NULL,NULL,NULL,NULL,NULL,1,'B32');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Microbiological/immunological test','Microbiological/immunological test',NULL,NULL,NULL,NULL,NULL,NULL,1,'B33');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Blood test','Blood test',NULL,NULL,NULL,NULL,NULL,NULL,1,'B34');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Urine test','Urine test',NULL,NULL,NULL,NULL,NULL,NULL,1,'B35');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Faeces test','Faeces test',NULL,NULL,NULL,NULL,NULL,NULL,1,'B36');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Histological/exfoliative cytology','Histological/exfoliative cytology',NULL,NULL,NULL,NULL,NULL,NULL,1,'B37');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other laboratory test NEC','Other laboratory test NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'B38');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Physical function test','Physical function test',NULL,NULL,NULL,NULL,NULL,NULL,1,'B39');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic endoscopy','Diagnostic endoscopy',NULL,NULL,NULL,NULL,NULL,NULL,1,'B40');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic radiology/imaging','Diagnostic radiology/imaging',NULL,NULL,NULL,NULL,NULL,NULL,1,'B41');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Electrical tracing','Electrical tracing',NULL,NULL,NULL,NULL,NULL,NULL,1,'B42');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other diagnostic procedure','Other diagnostic procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'B43');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Preventive immunization/medication','Preventive immunization/medication',NULL,NULL,NULL,NULL,NULL,NULL,1,'B44');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Observation/health education/advice/diet','Observ/health educat/advice/diet',NULL,NULL,NULL,NULL,NULL,NULL,1,'B45');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with primary care provider','Consultation primary care provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'B46');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with specialist','Consultation with specialist',NULL,NULL,NULL,NULL,NULL,NULL,1,'B47');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Clarification/discussion of patient''s RFE/demand','Clarification/discussion RFE/demand',NULL,NULL,NULL,NULL,NULL,NULL,1,'B48');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other preventive procedure','Other preventive procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'B49');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Medication/prescription/renewal/injection','Medication/prescr/renewal/inject',NULL,NULL,NULL,NULL,NULL,NULL,1,'B50');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Incision/drainage/flushing/aspiration/removal body fluid (excl. catheterisation - 53)\n
 (excl. catheterisation - 53)','I&D/flush/aspiration (excl cath -53)',NULL,NULL,NULL,NULL,NULL,NULL,1,'B51');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Excision/removal tissue/biopsy/destruction/debridement/cauterization','Exc/remov/biopsy/destruc/debrid/caut',NULL,NULL,NULL,NULL,NULL,NULL,1,'B52');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Instrumentation/catheterization/intubation/dilation','Instrument/catheter/intubate/dilate',NULL,NULL,NULL,NULL,NULL,NULL,1,'B53');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Repair/fixation-suture/cast/prosthetic device (apply/remove)','Repair/fix-suture/cast/prosth device',NULL,NULL,NULL,NULL,NULL,NULL,1,'B54');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Local injection/infiltration','Local injection/infiltration',NULL,NULL,NULL,NULL,NULL,NULL,1,'B55');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Dressing/pressure/compression/tamponade','Dressing/pressure/compress/tamponade',NULL,NULL,NULL,NULL,NULL,NULL,1,'B56');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Physical medicine/rehabilitation','Physical medicine/rehabilitation',NULL,NULL,NULL,NULL,NULL,NULL,1,'B57');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Therapeutic counselling/listening','Therapeutic counselling/listening',NULL,NULL,NULL,NULL,NULL,NULL,1,'B58');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Other therapeutic procedure/minor surgery NEC','Other therap proced/minor surg NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'B59');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result test/procedure','Result test/procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'B60');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result examination/test/record/letter from other provider','Result exam/test/lett oth provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'B61');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (5,'Administrative procedure','Administrative procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'B62');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Follow-up encounter unspecified','Follow-up encounter unspecified',NULL,NULL,NULL,NULL,NULL,NULL,1,'B63');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by provider','Encounter/prob initiated by provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'B64');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by other than patient/provider','Enc/prob init by other than pt/prov',NULL,NULL,NULL,NULL,NULL,NULL,1,'B65');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to other provider/nurse/therapist/social worker','Referral to non-MD provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'B66');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to physician/specialist/clinic/hospital','Referral to MD/specialist/clin/hosp',NULL,NULL,NULL,NULL,NULL,NULL,1,'B67');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other referral NEC','Other referral NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'B68');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other reason for encounter NEC','Other reason for encounter NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'B69');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'LYMPHADENITIS ACUTE','LYMPHADENITIS ACUTE','L04','one/more inflamed/enlarged and tender/painful lymph nodes in the same anatomical location, of recent onset (less than 6 weeks) and with unknown primary source of infection','abscess of lymph node','chronic/non-specific/mesenteric lymphadenitis B71; acute lymphangitis S76','enlarged lymph node B02',NULL,1,'B70');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'LYMPHADENITIS CHRONIC/NON-SPECIFIC','LYMPHADENITIS CHRONIC/NON-SPECIFIC','I88','enlarged tender lymph nodes present for more than 6 weeks; or demonstration of enlarged inflamed mesenteric lymph nodes by surgery/sonography/lymphography/otherwise','mesenteric lymphadenitis','acute lymphadenitis (except mesenteric) B70; acute lymphangitis  S76','enlarged lymph node B02',NULL,1,'B71');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HODGKIN''S DISEASE/LYMPHOMA','HODGKIN''S DISEASE/LYMPHOMA','C81, C82, C83, C84, C85','characteristic histologic appearance',NULL,NULL,'other malignant neoplasm blood/lymph B74; benign/unspecified neoplasm blood/lymph B75',NULL,1,'B72');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'LEUKAEMIA','LEUKAEMIA','C91, C92, C93, C94, C95','characteristic histologic appearance','all types of leukaemia',NULL,'benign/unspecified neoplasm blood/lymph B75',NULL,1,'B73');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BENIGN/UNSPECIFIED NEOPLASM BLOOD','BENIGN/UNSPECIFIED NEOPLASM BLOOD','D15.0, D36.0, D45, D47',NULL,'benign neoplasm blood, neoplasm blood not specified as benign or malignant/when test is not available; polycythaemia rubra vera',NULL,NULL,NULL,1,'B75');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'RUPTURED SPLEEN TRAUMATIC','RUPTURED SPLEEN TRAUMATIC','S36.0',NULL,NULL,NULL,NULL,NULL,1,'B76');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'INJURY BLOOD/LYMPH/SPLEEN OTHER','INJURY BLOOD/LYMPH/SPLEEN OTHER','T14.9',NULL,NULL,'ruptured spleen traumatic B76',NULL,NULL,1,'B77');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HEREDITARY HAEMOLYTIC ANAEMIA','HEREDITARY HAEMOLYTIC ANAEMIA','D56, D57, D58','characteristic findings by test such as haemoglobin electrophoresis, blood smear, or increased osmotic fragility of red cells','sickle-cell anaemia, sickle cell trait, spherocytosis, thalassaemia',NULL,'other congenital anomaly blood/lymph B79',NULL,1,'B78');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONGENITAL ANOMALY BLOOD/LYMPH OTHER','CONGEN ANOMALY BLOOD/LYMPH OTHER','D61.0, D64.0, D64.4, Q89.0, Q89.8',NULL,'congenital anaemia','hereditary haemolytic anaemia B78; haemophilia B83; haemangioma/lymphangioma S81',NULL,NULL,1,'B79');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'IRON DEFICIENCY ANAEMIA','IRON DEFICIENCY ANAEMIA','D50','decrease in haemoglobin or haematocrit below levels appropriate for age and sex; plus evidence of blood loss, or microcytic hypochromic red cells by appearance or indices in the absence of thalassaemia, or decreased serum iron and increased iron-binding capacity, or decreased serum ferritin, or reduced haemosiderin in bone marrow, or good response to iron administration','anaemia due to blood loss','iron deficiency without anaemia T91','other/unspecified anaemia B82',NULL,1,'B80');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ANAEMIA VIT B12/FOLATE DEFICIENCY','ANAEMIA VIT B12/FOLATE DEFICIENCY','D51, D52','macrocytic anaemia by smear/indices plus decreased vitamin B12/folate level/positive Schilling test','macrocytic anaemia, pernicious anaemia','vit B12 deficiency without anaemia T91',NULL,NULL,1,'B81');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ANAEMIA OTHER/UNSPECIFIED','ANAEMIA OTHER/UNSPECIFIED','D46, D53, D55, D59, D60, D61.3, D61.8, D61.9, D62, D63, D64.1, D64.3, D64.8, D64.9',NULL,'acquired haemolytic anaemia, aplastic anaemia, megaloblastic anaemia NOS, protein deficiency anaemia','iron deficiency anaemia B80; vit B12/folate deficiency anaemia B81; anaemia of pregnancy W84',NULL,NULL,1,'B82');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PURPURA/COAGULATION DEFECT','PURPURA/COAGULATION DEFECT','D65, D66, D67, D68, D69',NULL,'abnormal platelets, haemophilia, thrombocytopenia',NULL,NULL,NULL,1,'B83');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'UNEXPLAINED ABNORMAL WHITE CELLS','UNEXPLAINED ABNORMAL WHITE CELLS','D70, D71, D72, R72',NULL,'unexplained agranulocytosis, unexplained eosinophilia, unexplained leukocytosis, unexplained lymphocytosis, unexplained neutropenia','leukaemia B73',NULL,NULL,1,'B84');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'included with A91',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'B85');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'included with B99',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'B86');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SPLENOMEGALY','SPLENOMEGALY','R16.1, R16.2',NULL,NULL,'hypersplenism B99',NULL,NULL,1,'B87');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HIV-INFECTION/AIDS','HIV-INFECTION/AIDS','B20, B21, B22, B23, B24, R75, Z21','HIV-infection proven in serological test in a patient with/without symptoms',NULL,NULL,NULL,NULL,1,'B90');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BLOOD/LYMPH/SPLEEN DISEASE OTHER','BLOOD/LYMPH/SPLEEN DISEASE OTHER','D73, D74, D75, D76, D77, D80, D81, D82, D83, D84, D86, D89, I89, R70, R71',NULL,'autoimmune disease blood, complement defect, hypersplenism, immunodeficiency disorder, other/unspecified haematological abnormality, raised ESR, red cell abnormality, sarcoidosis, secondary polycythaemia','lymphadenitis B70, B71; primary polycythemia B75; HIV/AIDS B90; lymphoedema K99',NULL,NULL,1,'B99');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (NULL,' DIGESTIVE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'D');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ABDOMINAL PAIN/CRAMPS GENERAL','ABDOMINAL PAIN/CRAMPS GENERAL','R10.0, R10.4',NULL,'abdominal colic, abdominal cramps/discomfort/pain NOS, infant colic','epigastric ache D02; heartburn D03; other localized abdominal pain DO6; dyspepsia/indigestion D07; flatulence/gas/belching D08; biliary colic D98; renal colic U14; dysmenorrhoea X02',NULL,NULL,1,'D01');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ABDOMINAL PAIN EPIGASTRIC','ABDOMINAL PAIN EPIGASTRIC','R10.1',NULL,'epigastric discomfort, fullness, stomach ache/pain','dyspepsia/indigestion D07; flatulence/gas/belching D08',NULL,NULL,1,'D02');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'RECTAL/ANAL PAIN','RECTAL/ANAL PAIN','K59.4, R10.2, R10.3',NULL,'anal spasm, proctalgia fugax','impacted faeces D12',NULL,NULL,1,'D04');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PERIANAL ITCHING','PERIANAL ITCHING','L29.0, L29.3',NULL,'perianal pruritus','pruritus vulvae X16',NULL,NULL,1,'D05');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ABDOMINAL PAIN LOCALIZED OTHER','ABDOMINAL PAIN LOCALIZED OTHER','R10.1, R10.2, R10.3',NULL,'colonic pain','generalized abdominal pain D01; epigastric pain D02; heartburn D03; dyspepsia/indigestion D07; flatulence/gas/belching D08; irritable bowel syndrome D93; biliary colic D98; renal colic U14; dysmenorrhoea X02',NULL,NULL,1,'D06');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'DYSPEPSIA/INDIGESTION','DYSPEPSIA/INDIGESTION','K30',NULL,NULL,'epigastric pain D02; heartburn D03; flatulence/gas/belching D08',NULL,NULL,1,'D07');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FLATULENCE/GAS/BELCHING','FLATULENCE/GAS/BELCHING','R14',NULL,'bloating, eructation, gas pains, gaseous distension, passing wind','dyspepsia/indigestion D07, change in abdominal size D25',NULL,NULL,1,'D08');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'NAUSEA','NAUSEA','R11',NULL,NULL,'feelings of over-eating D02; vomiting D10; alcohol induced nausea P16; loss of appetite T03; nausea in pregnancy WO5',NULL,'code for nausea and vomiting as a diagnosis: D10',1,'D09');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'VOMITING','VOMITING','F50.5, R11',NULL,'emesis, hyperemesis, retching','haematemesis D14; vomiting in pregnancy WO5',NULL,'code for diarrhoea and vomiting as a diagnosis: D11',1,'D10');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'DIARRHOEA','DIARRHOEA','K52.9, K59.1',NULL,'frequent/loose bowel movements, watery stools','melaena D15; change in faeces/bowel movements D18',NULL,NULL,1,'D11');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CONSTIPATION','CONSTIPATION','K56.4, K59.0',NULL,'faecal impaction','ileus D99',NULL,NULL,1,'D12');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'JAUNDICE','JAUNDICE','R17',NULL,'icterus',NULL,NULL,NULL,1,'D13');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'HAEMATEMESIS/VOMITING BLOOD','HAEMATEMESIS/VOMITING BLOOD','K92.0',NULL,NULL,'haemoptysis R24',NULL,NULL,1,'D14');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'MELAENA','MELAENA','K92.1',NULL,'black/tarry stools','fresh blood in stool D16',NULL,NULL,1,'D15');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'RECTAL BLEEDING','RECTAL BLEEDING','K62.5',NULL,'fresh blood in stool','melaena D15',NULL,NULL,1,'D16');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'INCONTINENCE OF BOWEL','INCONTINENCE OF BOWEL','R15',NULL,'faecal incontinence','encopresis P13',NULL,NULL,1,'D17');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CHANGE IN FAECES/BOWEL MOVEMENTS','CHANGE IN FAECES/BOWEL MOVEMENTS','R19.4, R19.5',NULL,NULL,'diarrhoea D11; constipation D12; incontinence of bowel D17',NULL,NULL,1,'D18');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'TEETH/GUM SYMPTOM/COMPLAINT','TEETH/GUM SYMPTOM/COMPLAINT','K00.7',NULL,'denture problem, gingival inflammation/bleeding, teething, toothache','caries D82',NULL,NULL,1,'D19');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'MOUTH/TONGUE/LIP SYMPTOM/COMPLAINT','MOUTH/TONGUE/LIP SYMPTOM/COMPLAINT','K14, R19.6, R68.2',NULL,'bad breath, coated tongue, cracked lips, dribbling, dry mouth, halitosis, sore mouth, swollen lips','dental/gum problem D19; cheilosis D83; disturbance of taste N16; dehydration T11',NULL,NULL,1,'D20');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SWALLOWING PROBLEM','SWALLOWING PROBLEM','R13',NULL,'choking feeling, dysphagia',NULL,NULL,NULL,1,'D21');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'transferred to D96',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'D22');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ABDOMINAL MASS NOS','ABDOMINAL MASS NOS','R19.0',NULL,'lump abdomen','splenomegaly B87; hepatomegaly D23; renal mass U14',NULL,NULL,1,'D24');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ABDOMINAL DISTENSION','ABDOMINAL DISTENSION','R19.0',NULL,'abdominal swelling without mass','flatulence/gas/belching D08; abdominal mass D24; ascites D29',NULL,NULL,1,'D25');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF CANCER OF DIGESTIVE SYSTEM','FEAR OF CANCER OF DIGESTIVE SYSTEM','Z71.1','concern about/fear of cancer of digestive system in a patient without the disease/until the diagnosis is proven',NULL,'if the patient has the disease, code the disease',NULL,NULL,1,'D26');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF  DIGESTIVE DISEASE OTHER','FEAR OF  DIGESTIVE DISEASE OTHER','Z71.1','concern about/fear of other digestive disease in a patient without the disease/until the diagnosis is proven',NULL,'fear of cancer of digestive system D26; if the patient has the disease, code the disease',NULL,NULL,1,'D27');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LIMITED FUNCTION/DISABILITY (D)','LIMITED FUNCTION/DISABILITY (D)','Z73.6, Z93.1, Z93.2, Z93.3, Z93.4','limitation of function/disability due to a digestive problem',NULL,'colostomy/gastrostomy A89; post surgery disorder D99; dumping syndrome D99',NULL,'The COOP/WONCA Charts are suitable for documenting the patient''s functional status (see Chapter 8).',1,'D28');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'DIGESTIVE SYMPTOM/COMPLAINT OTHER','DIGESTIVE SYMPTOM/COMPLAINT OTHER','R18, R19.1, R19.2, R19.3, R19.8',NULL,'ascites, teeth grinding',NULL,NULL,NULL,1,'D29');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation complete','Medical examin/health eval complete',NULL,NULL,NULL,NULL,NULL,NULL,1,'D30');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation partial','Medical examin/health eval partial',NULL,NULL,NULL,NULL,NULL,NULL,1,'D31');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Sensitivity test','Sensitivity test',NULL,NULL,NULL,NULL,NULL,NULL,1,'D32');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Microbiological/immunological test','Microbiological/immunological test',NULL,NULL,NULL,NULL,NULL,NULL,1,'D33');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Blood test','Blood test',NULL,NULL,NULL,NULL,NULL,NULL,1,'D34');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Urine test','Urine test',NULL,NULL,NULL,NULL,NULL,NULL,1,'D35');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Faeces test','Faeces test',NULL,NULL,NULL,NULL,NULL,NULL,1,'D36');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Histological/exfoliative cytology','Histological/exfoliative cytology',NULL,NULL,NULL,NULL,NULL,NULL,1,'D37');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other laboratory test NEC','Other laboratory test NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'D38');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic endoscopy','Diagnostic endoscopy',NULL,NULL,NULL,NULL,NULL,NULL,1,'D40');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic radiology/imaging','Diagnostic radiology/imaging',NULL,NULL,NULL,NULL,NULL,NULL,1,'D41');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Electrical tracing','Electrical tracing',NULL,NULL,NULL,NULL,NULL,NULL,1,'D42');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other diagnostic procedure','Other diagnostic procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'D43');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Preventive immunization/medication','Preventive immunization/medication',NULL,NULL,NULL,NULL,NULL,NULL,1,'D44');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Observation/health education/advice/diet','Observ/health educat/advice/diet',NULL,NULL,NULL,NULL,NULL,NULL,1,'D45');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with primary care provider','Consultation primary care provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'D46');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with specialist','Consultation with specialist',NULL,NULL,NULL,NULL,NULL,NULL,1,'D47');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Clarification/discussion of patient''s RFE/demand','Clarification/discussion RFE/demand',NULL,NULL,NULL,NULL,NULL,NULL,1,'D48');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other preventive procedure','Other preventive procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'D49');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Medication/prescription/renewal/injection','Medication/prescr/renewal/inject',NULL,NULL,NULL,NULL,NULL,NULL,1,'D50');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Incision/drainage/flushing/aspiration/removal body fluid (excl. catheterisation - 53)\n
 (excl. catheterisation - 53)','I&D/flush/aspiration (excl cath -53)',NULL,NULL,NULL,NULL,NULL,NULL,1,'D51');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Excision/removal tissue/biopsy/destruction/debridement/cauterization','Exc/remov/biopsy/destruc/debrid/caut',NULL,NULL,NULL,NULL,NULL,NULL,1,'D52');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Instrumentation/catheterization/intubation/dilation','Instrument/catheter/intubate/dilate',NULL,NULL,NULL,NULL,NULL,NULL,1,'D53');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Repair/fixation-suture/cast/prosthetic device (apply/remove)','Repair/fix-suture/cast/prosth device',NULL,NULL,NULL,NULL,NULL,NULL,1,'D54');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Local injection/infiltration','Local injection/infiltration',NULL,NULL,NULL,NULL,NULL,NULL,1,'D55');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Dressing/pressure/compression/tamponade','Dressing/pressure/compress/tamponade',NULL,NULL,NULL,NULL,NULL,NULL,1,'D56');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Physical medicine/rehabilitation','Physical medicine/rehabilitation',NULL,NULL,NULL,NULL,NULL,NULL,1,'D57');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Therapeutic counselling/listening','Therapeutic counselling/listening',NULL,NULL,NULL,NULL,NULL,NULL,1,'D58');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Other therapeutic procedure/minor surgery NEC','Other therap proced/minor surg NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'D59');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result test/procedure','Result test/procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'D60');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result examination/test/record/letter from other provider','Result exam/test/lett oth provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'D61');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (5,'Administrative procedure','Administrative procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'D62');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Follow-up encounter unspecified','Follow-up encounter unspecified',NULL,NULL,NULL,NULL,NULL,NULL,1,'D63');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by provider','Encounter/prob initiated by provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'D64');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by other than patient/provider','Enc/prob init by other than pt/prov',NULL,NULL,NULL,NULL,NULL,NULL,1,'D65');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to other provider/nurse/therapist/social worker','Referral to non-MD provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'D66');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to physician/specialist/clinic/hospital','Referral to MD/specialist/clin/hosp',NULL,NULL,NULL,NULL,NULL,NULL,1,'D67');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other referral NEC','Other referral NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'D68');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other reason for encounter NEC','Other reason for encounter NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'D69');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'GASTROINTESTINAL INFECTION','GASTROINTESTINAL INFECTION','A00, A01, A02, A03, A04, A05, A06, A07, A08, A09','a symptomatic patient with isolation or serological evidence of pathogenic bacteria, virus, or protozoan from either the stool or from food ingested','gastrointestinal infection/dysentery with specified organisms including campylobacter, giardia, salmonella, shigella, typhoid, cholera','contact with/carrier of infective/parasitic disease A99; gastroenteritis presumed infection D73','gastroenteritis presumed infection D73',NULL,1,'D70');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MUMPS','MUMPS','B26','acute non-suppurative, non-erythematous, diffuse tender inflammation of one or more salivary glands; or acute mumps infection demonstrated by culture or serology; or orchitis in a person exposed to mumps following appropriate incubation period','mumps meningitis/orchitis/pancreatitis',NULL,'swelling A08',NULL,1,'D71');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'VIRAL HEPATITIS','VIRAL HEPATITIS','B15, B16, B17, B18, B19','evidence of viral infection with inflammation of the liver with/without jaundice; or serological evidence of an infection with a hepatitis virus','all hepatitis presumed viral, chronic active hepatitis','hepatitis NOS D97','jaundice D13; hepatomegaly D23',NULL,1,'D72');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'GASTROENTERITIS PRESUMED INFECTION','GASTROENTERITIS PRESUMED INFECTION','A09',NULL,'diarrhoea/vomiting presumed to be infective, dysentery NOS,  food poisoning, gastric flu','irritable bowel syndrome D93; non-infective enteritis and gastroenteritis D94, D99',NULL,NULL,1,'D73');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM STOMACH','MALIGNANT NEOPLASM STOMACH','C16','characteristic histological appearance','carcinoma stomach',NULL,'other malignant digestive neoplasm (when primary site is uncertain) D77; benign/unspecified digestive neoplasm D78',NULL,1,'D74');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM COLON/RECTUM','MALIGNANT NEOPLASM COLON/RECTUM','C18, C19, C20, C21','characteristic histological appearance',NULL,NULL,'other digestive malignant neoplasm (when primary site is uncertain) D77; benign/unspecified digestive neoplasm D78',NULL,1,'D75');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM PANCREAS','MALIGNANT NEOPLASM PANCREAS','C25','characteristic histological appearance','carcinoma pancreas',NULL,'other digestive malignant neoplasm (when primary site is unknown) D77; benign/unspecified digestive neoplasm D78',NULL,1,'D76');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT DIGESTIVE NEOPLASM OTHER/NOS','MALIGNANT DIGESTIVE NEOPL OTHER/NOS','C00, C01, C02, C03, C04, C05, C06, C07, C08, C14.8, C15, C17, C22, C23, C24, C26, C45.1, C46.2, C48',NULL,'all other primary malignancies of digestive system, gallbladder cancer, liver cancer','malignancy of stomach, colon/rectum, pancreas D74-76; secondary malignancy of known site (code to site); secondary malignancy of unknown site A79','benign/unspecified digestive neoplasm D78',NULL,1,'D77');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'NEOPLASM DIGESTIVE SYSTEM BENIGN/UNSPECIFIED','NEOPLASM DIGESTIVE BENIGN/UNSPECIF','D00, D01, D10, D11, D12, D13, D20, D37, D48.3, D48.4, K62.0, K62.1',NULL,'benign digestive neoplasm/digestive neoplasm not specified as benign or malignant/when histology is not available, polyp of stomach, duodenum, colon, rectum',NULL,NULL,NULL,1,'D78');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'FOREIGN BODY DIGESTIVE SYSTEM','FOREIGN BODY DIGESTIVE SYSTEM','T18',NULL,'foreign body swallowed/in digestive tract, including mouth, oesophagus, rectum','foreign body in throat/inhaled R87',NULL,NULL,1,'D79');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'INJURY DIGESTIVE SYSTEM OTHER','INJURY DIGESTIVE SYSTEM OTHER','S00.5, S01.5, S02.5, S03.2, S36.1, S36.2, S36.3, S36.4, S36.5, S36.6, T28.0, T28.1, T28.2, T28.5, T28.6, T28.7',NULL,'injury to abdominal organ, teeth, tongue','multiple organ injuries A81; injury pelvic organs X82, Y80',NULL,NULL,1,'D80');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONGENITAL ANOMALY DIGESTIVE SYSTEM','CONGENITAL ANOMALY DIGESTIVE SYSTEM','Q18, Q35, Q36, Q37, Q38, Q39, Q40, Q41, Q42, Q43, Q44, Q45',NULL,'biliary anomaly, cleft lip/palate, Meckel''s diverticulum, megacolon, Hirschprung''s disease, oesophageal atresia, pyloric stenosis, tongue-tie','haemangioma/lymphangioma S81; congenital metabolic disorder T80',NULL,NULL,1,'D81');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'TEETH/GUM DISEASE','TEETH/GUM DISEASE','K00.0, K00.1, K00.2, K00.3, K00.4, K00.5, K00.6, K00.8, K00.9, K01, K02, K03, K04, K05, K06, K07, K08, K09, K10',NULL,'caries, dental abscess, gingivitis, malocclusion, temporomandibular joint disorder','teething/denture problem D19; injury to teeth/gum D80; Vincent''s angina D83',NULL,NULL,1,'D82');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MOUTH/TONGUE/LIP DISEASE','MOUTH/TONGUE/LIP DISEASE','A69.0, A69.1, B00.2, B37.0, K11, K12, K13, K14',NULL,'aphthous ulcer, cheilosis, glossitis, mucocoele, oral thrush, parotitis, salivary calculus, stomatitis, Vincent''s angina','mumps D71; other injury digestive system D80; herpes simplex S71',NULL,NULL,1,'D83');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'OESOPHAGUS DISEASE','OESOPHAGUS DISEASE','K20, K21, K22, K23',NULL,'achalasia, oesophagial diverticulum, Mallory-Weiss syndrome, oesophagitis, oesophagus ulceration, reflux','cancer of oesophagus D77; hiatus hernia D90; oesophageal varices K99',NULL,NULL,1,'D84');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'DUODENAL ULCER','DUODENAL ULCER','K26','characteristic imaging findings; or characteristic endoscopy findings; or exacerbation of symptoms in a patient with a previously proven duodenal ulcer','bleeding/obstructing/perforated ulcer',NULL,'heartburn D03; dyspepsia/indigestion D07',NULL,1,'D85');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'STOMACH FUNCTION DISORDER','STOMACH FUNCTION DISORDER','K29','disorder of stomach function proven by investigation','acute dilatation stomach, duodenitis, gastritis','gastrointestinal infection D70; gastroenteritis presumed infection D73','abdominal pain D01, D06; epigastric pain D02; heartburn D03; indigestion/dyspepsia D07; gas problems (wind) D08; nausea D09; vomiting D10; oesophagitis D84',NULL,1,'D87');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'APPENDICITIS','APPENDICITIS','K35, K36, K37','objective evidence of inflammation of the appendix, such as demonstrated at operation or pathological examination','appendix abscess/perforation',NULL,'abdominal pain D01, D06; vomiting D10',NULL,1,'D88');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'INGUINAL HERNIA','INGUINAL HERNIA','K40','swelling in the inguinal region and transmitted impulse with cough, or enlargement on straining, or swelling reducible into the abdomen, or intestinal obstruction',NULL,'femoral hernia D91','abdominal mass D24',NULL,1,'D89');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HIATUS HERNIA','HIATUS HERNIA','K44','characteristic findings on imaging/endoscopy/intraluminal pressure studies/surgery','diaphragmatic hernia','oesophagitis/reflux D84','epigastric pain D02; heartburn D03; dyspepsia/indigestion D07',NULL,1,'D90');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ABDOMINAL HERNIA OTHER','ABDOMINAL HERNIA OTHER','K41, K42, K43, K45, K46','demonstration at surgery; or swelling in the specified area and transmitted impulse with cough, or enlargement on straining, or reducible into the abdomen, or intestinal obstruction','femoral/incisional/umbilical/ventral hernia','hiatus inguinalis D89; hiatus hernia D90','abdominal mass D24',NULL,1,'D91');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'DIVERTICULAR DISEASE','DIVERTICULAR DISEASE','K57','imaging demonstration of diverticula; or demonstration of diverticula at surgery; or acute abdominal pain with fever and palpable tender descending/sigmoid colon','diverticulitis/diverticulosis of intestine','Meckel''s diverticulum D81; oesophageal diverticulum D84','abdominal pain D01, D06',NULL,1,'D92');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'IRRITABLE BOWEL SYNDROME','IRRITABLE BOWEL SYNDROME','K58','continuous/intermittent abdominal pain and variable bowel pattern over a period of time; and increased gas, or tender and palpable colon, or history of mucous without blood in stool','mucous colitis, spastic colon','gastrointestinal infection D70; gastroenteritis presumed infection D73; regional enteritis D94; vascular insufficiency of gut, allergic/dietetic/toxic gastroenteritis/colitis D99; psychogenic diarrhoea P75','abdominal pain D01, D06; flatulence D08; diarrhoea D11; constipation D12',NULL,1,'D93');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CHRONIC ENTERITIS/ULCERATIVE COLITIS','CHRONIC ENTERITIS/ULCERATIVE COLITIS','K50, K51, K52.0','characteristic endoscopic/imaging/histological findings','Crohn''s disease, regional enteritis, ulcerative colitis',NULL,'abdominal pain D01, D06; diarrhoea D11; mucus colitis D93',NULL,1,'D94');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ANAL FISSURE/PERIANAL ABSCESS','ANAL FISSURE/PERIANAL ABSCESS','K60, K61',NULL,'anal fistula, ischiorectal abscess','pilonidal abscess S85',NULL,NULL,1,'D95');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'WORMS/OTHER PARASITES','WORMS/OTHER PARASITES','B65, B66, B67, B68, B69, B70, B71, B72, B73, B74, B75, B76, B77, B78, B79, B80, B81, B82, B83','either demonstration of helminth in adult form, larvae, or ova; or positive skin tests; or positive serology','cestodes, creeping eruption, intestinal parasites unspecified, trichiniasis, hydatid disease',NULL,NULL,NULL,1,'D96');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'LIVER DISEASE NOS','LIVER DISEASE NOS','B58.1, B94.2, K70, K71, K72, K73, K74, K75, K76, K77',NULL,'alcohol hepatitis, cirrhosis, fatty liver, hepatitis NOS, liver failure, portal hypertension','viral hepatitis D72; hydatid disease D96',NULL,NULL,1,'D97');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CHOLECYSTITIS/CHOLELITHIASIS','CHOLECYSTITIS/CHOLELITHIASIS','K80, K81, K82, K83, K87.0','- cholecystitis: demonstration of typical pathology by ultrasound \n
   or surgery; or localized right upper quadrant tenderness and\n
   jaundice or fever or history of gall stones; \n
- cholelithiasis: imaging or surgical demonstration of gall stones; \n
- acute biliary colic: acute colicky right upper quadrant \n
  abdominal pain without fever; and jaundice or right upper\n
  quadrant abdominal tenderness, or history of gall stones','biliary colic, cholangitis, gallstones',NULL,'localized abdominal pain D06',NULL,1,'D98');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'DISEASE DIGESTIVE SYSTEM OTHER','DISEASE DIGESTIVE SYSTEM OTHER','K31, K38, K52.1, K52.2, K52.8, K52.9, K55, K56.0, K56.1, K56.2, K56.3, K56.5, K56.6, K56.7, K59.2, K59.3, K59.8, K59.9, K62.2, K62.3, K62.4, K62.6, K62.7, K62.8, K62.9, K63, K65, K66, K67, K85, K86, K87.1, K90, K91.1, K91.2, K91.5, K91.8, K91.9, K92.2, K92.8, K92.9, K93, Z90.3, Z90.4, Z94.4, Z98.0',NULL,'abdominal adhesions, coeliac disease, dumping syndrome, food intolerance, allergic/toxic/dietetic gastroenteropathy, ileus, intestinal obstruction, intussuception, lactose intolerance, malabsorption syndrome, mesenteric vascular disease, pancreatic disease, peritonitis, secondary megacolon, sprue','antibiotic associated colitis A85; malignancy digestive system D74-D77',NULL,NULL,1,'D99');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (NULL,'EYE',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'F');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'EYE PAIN','EYE PAIN','H57.1',NULL,NULL,'abnormal eye sensations F13',NULL,NULL,1,'F01');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'RED EYE','RED EYE','H57.8',NULL,'bloodshot/inflamed eye',NULL,NULL,NULL,1,'F02');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'EYE DISCHARGE','EYE DISCHARGE','H04.2',NULL,'lacrimation, purulent discharge, watery eye',NULL,NULL,NULL,1,'F03');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'VISUAL FLOATERS/SPOTS','VISUAL FLOATERS/SPOTS','H53.8',NULL,'fixed/floating spots in the visual field','other visual disturbance F05',NULL,NULL,1,'F04');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'VISUAL DISTURBANCE OTHER','VISUAL DISTURBANCE OTHER','H53.1, H53.2, H53.3, H53.9, H54.7',NULL,'blurred vision, difficulty reading, diplopia, eye strain, photophobia, scotoma and dazzle when symptoms confined to eyes, temporary blindness NOS, visual loss, weak eyes','blindness one eye F28; snowblindness F79; refractive errors F91; permanent blindness F94; colour/night blindness F99',NULL,NULL,1,'F05');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'EYE SENSATION ABNORMAL','EYE SENSATION ABNORMAL','H57.8',NULL,'burning/dry/itchy eye','eye pain F01',NULL,NULL,1,'F13');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'EYE MOVEMENTS ABNORMAL','EYE MOVEMENTS ABNORMAL','H55',NULL,'abnormal blinking, lazy eye, nystagmus','squint F95; twitching N08; tic of eye P10',NULL,NULL,1,'F14');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'EYE APPEARANCE ABNORMAL','EYE APPEARANCE ABNORMAL','H57.8',NULL,'change eye colour, swollen eye','red eye F02',NULL,NULL,1,'F15');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'EYELID SYMPTOM/COMPLAINT','EYELID SYMPTOM/COMPLAINT','H02.2, H02.3, H02.4, H02.5, H02.6, H02.7',NULL,'ptosis eyelid','inflamed eyelid F72',NULL,NULL,1,'F16');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'GLASSES SYMPTOM/COMPLAINT','GLASSES SYMPTOM/COMPLAINT','Z46.0',NULL,'problems due to spectacles affecting structure, function or sensations of eye(s)','contact lens symptom/complaint F18',NULL,NULL,1,'F17');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CONTACT LENS SYMPTOM/COMPLAINT','CONTACT LENS SYMPTOM/COMPLAINT','Z46.0',NULL,'problems due to contact lens affecting structure, function or sensations of eye(s)',NULL,NULL,NULL,1,'F18');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF EYE DISEASE','FEAR OF EYE DISEASE','Z71.1','concern about/fear of eye disease in a patient without the disease/until the diagnosis is proven','fear of blindness','if the patient has the disease, code the disease',NULL,NULL,1,'F27');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LIMITED FUNCTION/DISABILITY (F)','LIMITED FUNCTION/DISABILITY (F)','H54.4, H54.5, H54.6, Z73.6','limitation of function/disability due to a problem with vision/eye(s)','blindness one eye','blindness F94',NULL,'The COOP/WONCA Charts are suitable for documenting the patient''s functional status (see Chapter 8).',1,'F28');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'EYE SYMPTOM/COMPLAINT OTHER','EYE SYMPTOM/COMPLAINT OTHER','H57.9',NULL,NULL,NULL,NULL,NULL,1,'F29');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation complete','Medical examin/health eval complete',NULL,NULL,NULL,NULL,NULL,NULL,1,'F30');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation partial','Medical examin/health eval partial',NULL,NULL,NULL,NULL,NULL,NULL,1,'F31');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Microbiological/immunological test','Microbiological/immunological test',NULL,NULL,NULL,NULL,NULL,NULL,1,'F33');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Blood test','Blood test',NULL,NULL,NULL,NULL,NULL,NULL,1,'F34');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Urine test','Urine test',NULL,NULL,NULL,NULL,NULL,NULL,1,'F35');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Faeces test','Faeces test',NULL,NULL,NULL,NULL,NULL,NULL,1,'F36');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Histological/exfoliative cytology','Histological/exfoliative cytology',NULL,NULL,NULL,NULL,NULL,NULL,1,'F37');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other laboratory test NEC','Other laboratory test NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'F38');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Physical function test','Physical function test',NULL,NULL,NULL,NULL,NULL,NULL,1,'F39');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic endoscopy','Diagnostic endoscopy',NULL,NULL,NULL,NULL,NULL,NULL,1,'F40');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic radiology/imaging','Diagnostic radiology/imaging',NULL,NULL,NULL,NULL,NULL,NULL,1,'F41');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Electrical tracing','Electrical tracing',NULL,NULL,NULL,NULL,NULL,NULL,1,'F42');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other diagnostic procedure','Other diagnostic procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'F43');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Preventive immunization/medication','Preventive immunization/medication',NULL,NULL,NULL,NULL,NULL,NULL,1,'F44');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Observation/health education/advice/diet','Observ/health educat/advice/diet',NULL,NULL,NULL,NULL,NULL,NULL,1,'F45');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with primary care provider','Consultation primary care provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'F46');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with specialist','Consultation with specialist',NULL,NULL,NULL,NULL,NULL,NULL,1,'F47');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Clarification/discussion of patient''s RFE/demand','Clarification/discussion RFE/demand',NULL,NULL,NULL,NULL,NULL,NULL,1,'F48');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other preventive procedure','Other preventive procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'F49');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Medication/prescription/renewal/injection','Medication/prescr/renewal/inject',NULL,NULL,NULL,NULL,NULL,NULL,1,'F50');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Incision/drainage/flushing/aspiration/removal body fluid (excl. catheterisation - 53)\n
 (excl. catheterisation - 53)','I&D/flush/aspiration (excl cath -53)',NULL,NULL,NULL,NULL,NULL,NULL,1,'F51');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Excision/removal tissue/biopsy/destruction/debridement/cauterization','Exc/remov/biopsy/destruc/debrid/caut',NULL,NULL,NULL,NULL,NULL,NULL,1,'F52');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Instrumentation/catheterization/intubation/dilation','Instrument/catheter/intubate/dilate',NULL,NULL,NULL,NULL,NULL,NULL,1,'F53');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Repair/fixation-suture/cast/prosthetic device (apply/remove)','Repair/fix-suture/cast/prosth device',NULL,NULL,NULL,NULL,NULL,NULL,1,'F54');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Local injection/infiltration','Local injection/infiltration',NULL,NULL,NULL,NULL,NULL,NULL,1,'F55');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Dressing/pressure/compression/tamponade','Dressing/pressure/compress/tamponade',NULL,NULL,NULL,NULL,NULL,NULL,1,'F56');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Physical medicine/rehabilitation','Physical medicine/rehabilitation',NULL,NULL,NULL,NULL,NULL,NULL,1,'F57');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Therapeutic counselling/listening','Therapeutic counselling/listening',NULL,NULL,NULL,NULL,NULL,NULL,1,'F58');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Other therapeutic procedure/minor surgery NEC','Other therap proced/minor surg NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'F59');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result examination/test/record/letter from other provider','Result exam/test/lett oth provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'F61');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (5,'Administrative procedure','Administrative procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'F62');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Follow-up encounter unspecified','Follow-up encounter unspecified',NULL,NULL,NULL,NULL,NULL,NULL,1,'F63');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by provider','Encounter/prob initiated by provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'F64');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by other than patient/provider','Enc/prob init by other than pt/prov',NULL,NULL,NULL,NULL,NULL,NULL,1,'F65');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to other provider/nurse/therapist/social worker','Referral to non-MD provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'F66');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to physician/specialist/clinic/hospital','Referral to MD/specialist/clin/hosp',NULL,NULL,NULL,NULL,NULL,NULL,1,'F67');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other referral NEC','Other referral NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'F68');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other reason for encounter NEC','Other reason for encounter NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'F69');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONJUNCTIVITIS INFECTIOUS','CONJUNCTIVITIS INFECTIOUS','A74.0, B30, H10.0, H10.2, H10.3, H10.4, H10.5, H10.8, H10.9, H13','presumed or proven infectious inflammation of conjunctiva','bacterial/viral conjunctivitis, conjunctivitis NOS','allergic conjunctivitis with/without rhinorrhoea F71; flash burn F79; trachoma F86',NULL,NULL,1,'F70');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONJUNCTIVITIS ALLERGIC','CONJUNCTIVITIS ALLERGIC','H10.1','presumed or proven allergic hyperaemia of conjunctiva, excess watering of eyes, itching/oedema of conjunctiva','allergic conjunctivitis with/without rhinorrhea','bacterial/viral conjunctivitis F70; flashburn F79; trachoma F86',NULL,NULL,1,'F71');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BLEPHARITIS/STYE/CHALAZION','BLEPHARITIS/STYE/CHALAZION','H00, H01','generalized/localized inflammation/swelling of eyelid/tarsal gland','dermatitis/dermatosis of eyelids, eye lid infection, hordeolum, meibomian cyst, tarsal cyst','dacrocystitis F73',NULL,NULL,1,'F72');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'EYE INFECTION/INFLAMMATION OTHER','EYE INFECTION/INFLAMMATION OTHER','B00.5, B58.0, H03, H04.3, H04.4, H05.0, H05.1, H16.1, H16.2, H16.3, H16.4, H16.8, H16.9, H20, H21, H22, H30, H32',NULL,'dacryocystitis, herpes simplex of eye without corneal ulcer, infammation of the orbit, iritis, iridocyclitis, keratitis','measles keratitis A71; corneal ulcer (herpes) F85, trachoma F86; herpes zoster S70',NULL,NULL,1,'F73');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'NEOPLASM OF EYE/ADNEXA','NEOPLASM OF EYE/ADNEXA','C69, D09.2, D31, D48.7',NULL,'benign/malignant neoplasm of eye/adnexa',NULL,NULL,NULL,1,'F74');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONTUSION/HAEMORRHAGE EYE','CONTUSION/HAEMORRHAGE EYE','H11.3, S00.1, S05.1',NULL,'black eye, hyphaema, subconjunctival haemorrhage','corneal ulcer F85',NULL,NULL,1,'F75');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'FOREIGN BODY IN EYE','FOREIGN BODY IN EYE','T15',NULL,NULL,'corneal abrasion F79',NULL,NULL,1,'F76');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'INJURY EYE OTHER','INJURY EYE OTHER','H44.6, H44.7, S00.2, S01.1, S05.0, S05.2, S05.3, S05.4, S05.5, S05.6, S05.7, S05.8, S05.9, T26',NULL,'corneal abrasion, flash burn, snowblindness','contusion/haemorrhage eye F75; foreign body in eye F76',NULL,NULL,1,'F79');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BLOCKED LACRIMAL DUCT OF INFANT','BLOCKED LACRIMAL DUCT OF INFANT','Q10.5','overflow of tears without crying, beginning before the age of three months',NULL,'dacryocystitis F73; blocked lacrimal duct in older person F99',NULL,NULL,1,'F80');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONGENITAL ANOMALY EYE OTHER','CONGENITAL ANOMALY EYE OTHER','Q10.0, Q10.1, Q10.2, Q10.3, Q10.4, Q10.6, Q10.7, Q11, Q12, Q13, Q14, Q15',NULL,NULL,NULL,NULL,NULL,1,'F81');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'DETACHED RETINA','DETACHED RETINA','H33',NULL,NULL,NULL,NULL,NULL,1,'F82');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'RETINOPATHY','RETINOPATHY','H35.0, H35.1, H35.2, H35.4, H36',NULL,'diabetic/hypertensive retinopathy',NULL,NULL,'Double code known causative disease, e.g. diabetes T89, T90 or hypertension K87',1,'F83');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MACULAR DEGENERATION','MACULAR DEGENERATION','H35.3',NULL,NULL,'retinopathy F83',NULL,NULL,1,'F84');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'TRACHOMA','TRACHOMA','A71, B94.0','either proven infection with Chlamydia trachomatis, or typical clinical features including chronic inflammation and hypertrophy of the conjunctiva with formation of yellowish/greyish granules',NULL,NULL,'red eye F02; discharge from eye F03',NULL,1,'F86');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'REFRACTIVE ERROR','REFRACTIVE ERROR','H52','visual deficit correctible with an appropriate lens','astigmatism, hypermetropia, long sightedness, myopia, presbyopia, short sightedness','partial/complete blindness F94',NULL,NULL,1,'F91');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CATARACT','CATARACT','H25, H26, H28','opacity of part/all of the optic lens which reduces/impairs vision',NULL,'congenital cataract F81',NULL,NULL,1,'F92');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'GLAUCOMA','GLAUCOMA','H40, H42',NULL,'raised intraocular pressure','congenital glaucoma F81',NULL,NULL,1,'F93');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BLINDNESS','BLINDNESS','H54.0, H54.1, H54.2, H54.3',NULL,'partial/complete blindness of both eyes','blurred vision/temporary blindness F05; blindness one eye F28; snow blindness F79; refractive errors F91; colour/night blindness F99',NULL,NULL,1,'F94');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'STRABISMUS','STRABISMUS','H49, H50, H51','lack of parallelism of visual axis of the eyes demonstrated at medical examination','cross-eye, squint',NULL,'abnormal eye movement F14',NULL,1,'F95');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'EYE/ADNEXA DISEASE OTHER','EYE/ADNEXA DISEASE OTHER','H02.0, H02.1, H02.8, H02.9, H04.0, H04.1, H04.5, H04.6, H04.8, H04.9, H05.2, H05.3, H05.4, H05.5, H05.8, H05.9, H06, H11.0, H11.1, H11.2, H11.4, H11.8, H11.9, H15, H17, H18, H27, H31, H34, H35.5, H35.6, H35.7, H35.8, H35.9, H43, H44.0, H44.1, H44.2, H44.3, H44.4, H44.5, H44.8, H44.9, H45, H46, H47, H48, H53.0, H53.4, H53.5, H53.6, H57.0, H57.8, H58, H59, Z94.7',NULL,'amblyopia, arcus senilis, colour blindness, corneal opacity, disorder of orbit, ectropion, entropion, episcleritis, ingrowing eyelash, night blindness, papilloedema, pterygium, scleritis',NULL,NULL,NULL,1,'F99');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (NULL,'EAR',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'H');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'EAR PAIN/EARACHE','EAR PAIN/EARACHE','H92.0',NULL,NULL,NULL,NULL,NULL,1,'H01');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'HEARING COMPLAINT','HEARING COMPLAINT','H93.2',NULL,NULL,'deafness one ear H28; deafness both ears H86',NULL,NULL,1,'H02');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'TINNITUS, RINGING/BUZZING EAR','TINNITUS, RINGING/BUZZING EAR','H93.1',NULL,'echo in ear','ears crackling/popping H29',NULL,NULL,1,'H03');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'EAR DISCHARGE','EAR DISCHARGE','H92.1',NULL,NULL,'blood in/from ear H05',NULL,NULL,1,'H04');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'BLEEDING EAR','BLEEDING EAR','H92.2',NULL,'blood in/from ear',NULL,NULL,NULL,1,'H05');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PLUGGED FEELING EAR','PLUGGED FEELING EAR','H93.8',NULL,'blocked ear','excessive ear wax H81',NULL,NULL,1,'H13');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CONCERN WITH APPEARANCE OF EARS','CONCERN WITH APPEARANCE OF EARS','R46.8',NULL,NULL,'bat ears/congenital anomaly ear H80',NULL,NULL,1,'H15');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF EAR DISEASE','FEAR OF EAR DISEASE','Z71.1','concern about/fear of ear disease/deafness in a patient without the disease/until the diagnosis is proven','fear of deafness','in a patient with the disease, code the disease',NULL,NULL,1,'H27');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LIMITED FUNCTION/DISABILITY (H)','LIMITED FUNCTION/DISABILITY (H)','Z73.6','limitation of function/disability due to a problem with ear/hearing','deafness one ear, temporary deafness','presbyacusis H84; acoustic trauma H85; deafness H86; dizziness/vertigo N17',NULL,'The COOP/WONCA Charts are suitable for documenting the patient''s functional status (see Chapter 8).',1,'H28');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'EAR SYMPTOM/COMPLAINT OTHER','EAR SYMPTOM/COMPLAINT OTHER','H93.9',NULL,'ears crackling/popping, itchy ears, pulling at ears','dizziness/loss of balance/vertigo N17',NULL,NULL,1,'H29');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation complete','Medical examin/health eval complete',NULL,NULL,NULL,NULL,NULL,NULL,1,'H30');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation partial','Medical examin/health eval partial',NULL,NULL,NULL,NULL,NULL,NULL,1,'H31');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Microbiological/immunological test','Microbiological/immunological test',NULL,NULL,NULL,NULL,NULL,NULL,1,'H33');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Blood test','Blood test',NULL,NULL,NULL,NULL,NULL,NULL,1,'H34');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Urine test','Urine test',NULL,NULL,NULL,NULL,NULL,NULL,1,'H35');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Faeces test','Faeces test',NULL,NULL,NULL,NULL,NULL,NULL,1,'H36');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Histological/exfoliative cytology','Histological/exfoliative cytology',NULL,NULL,NULL,NULL,NULL,NULL,1,'H37');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other laboratory test NEC','Other laboratory test NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'H38');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Physical function test','Physical function test',NULL,NULL,NULL,NULL,NULL,NULL,1,'H39');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic endoscopy','Diagnostic endoscopy',NULL,NULL,NULL,NULL,NULL,NULL,1,'H40');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic radiology/imaging','Diagnostic radiology/imaging',NULL,NULL,NULL,NULL,NULL,NULL,1,'H41');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Electrical tracing','Electrical tracing',NULL,NULL,NULL,NULL,NULL,NULL,1,'H42');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other diagnostic procedure','Other diagnostic procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'H43');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Preventive immunization/medication','Preventive immunization/medication',NULL,NULL,NULL,NULL,NULL,NULL,1,'H44');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with primary care provider','Consultation primary care provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'H46');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with specialist','Consultation with specialist',NULL,NULL,NULL,NULL,NULL,NULL,1,'H47');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Clarification/discussion of patient''s RFE/demand','Clarification/discussion RFE/demand',NULL,NULL,NULL,NULL,NULL,NULL,1,'H48');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other preventive procedure','Other preventive procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'H49');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Medication/prescription/renewal/injection','Medication/prescr/renewal/inject',NULL,NULL,NULL,NULL,NULL,NULL,1,'H50');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Incision/drainage/flushing/aspiration/removal body fluid (excl. catheterisation - 53)\n
 (excl. catheterisation - 53)','I&D/flush/aspiration (excl cath -53)',NULL,NULL,NULL,NULL,NULL,NULL,1,'H51');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Excision/removal tissue/biopsy/destruction/debridement/cauterization','Exc/remov/biopsy/destruc/debrid/caut',NULL,NULL,NULL,NULL,NULL,NULL,1,'H52');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Instrumentation/catheterization/intubation/dilation','Instrument/catheter/intubate/dilate',NULL,NULL,NULL,NULL,NULL,NULL,1,'H53');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Repair/fixation-suture/cast/prosthetic device (apply/remove)','Repair/fix-suture/cast/prosth device',NULL,NULL,NULL,NULL,NULL,NULL,1,'H54');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Local injection/infiltration','Local injection/infiltration',NULL,NULL,NULL,NULL,NULL,NULL,1,'H55');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Dressing/pressure/compression/tamponade','Dressing/pressure/compress/tamponade',NULL,NULL,NULL,NULL,NULL,NULL,1,'H56');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Physical medicine/rehabilitation','Physical medicine/rehabilitation',NULL,NULL,NULL,NULL,NULL,NULL,1,'H57');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Therapeutic counselling/listening','Therapeutic counselling/listening',NULL,NULL,NULL,NULL,NULL,NULL,1,'H58');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Other therapeutic procedure/minor surgery NEC','Other therap proced/minor surg NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'H59');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result test/procedure','Result test/procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'H60');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result examination/test/record/letter from other provider','Result exam/test/lett oth provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'H61');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (5,'Administrative procedure','Administrative procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'H62');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Follow-up encounter unspecified','Follow-up encounter unspecified',NULL,NULL,NULL,NULL,NULL,NULL,1,'H63');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by provider','Encounter/prob initiated by provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'H64');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by other than patient/provider','Enc/prob init by other than pt/prov',NULL,NULL,NULL,NULL,NULL,NULL,1,'H65');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to other provider/nurse/therapist/social worker','Referral to non-MD provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'H66');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to physician/specialist/clinic/hospital','Referral to MD/specialist/clin/hosp',NULL,NULL,NULL,NULL,NULL,NULL,1,'H67');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other reason for encounter NEC','Other reasons for encounter nec',NULL,NULL,NULL,NULL,NULL,NULL,1,'H69');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'OTITIS EXTERNA','OTITIS EXTERNA','H60, H62','inflammation/desquamation of the external auditory canal','abscess/eczema/furuncle external auditory meatus, swimmer''s ear',NULL,NULL,NULL,1,'H70');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ACUTE OTITIS MEDIA/MYRINGITIS','ACUTE OTITIS MEDIA/MYRINGITIS','H66.0, H66.4, H66.9, H67, H73.0','recent perforation of the tympanic membrane discharging pus; or inflamed and bulging tympanic membrane; or one ear drum more red than the other; or red tympanic membrane, with ear pain; or bullae on the tympanic membrane','acute suppurative otitis media, otitis media NOS, acute tympanitis','serous otitis media H72; chronic otitis media H74','ear pain H01; ear discharge H04',NULL,1,'H71');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SEROUS OTITIS MEDIA','SEROUS OTITIS MEDIA','H65','visible fluid behind the tympanic membrane, without inflammation; or dullness of the tympanic membrane with either retracting, bulging, or with related impairment of hearing','glue ear, otitis media with effusion (OME)','acute otitis media H71; chronic otitis media H74','plugged feeling ear H13; eustachian salpingitis/block H73',NULL,1,'H72');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'EUSTACHIAN SALPINGITIS','EUSTACHIAN SALPINGITIS','H68, H69',NULL,'eustachian block/catarrh/dysfunction','serous otitis media H72','plugged feeling ear H13',NULL,1,'H73');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CHRONIC OTITIS MEDIA','CHRONIC OTITIS MEDIA','H66.1, H66.2, H66.3, H70, H71, H73.1, H75',NULL,'cholesteatoma, chronic suppurative otitis media, mastoiditis','serous otitis media H72',NULL,NULL,1,'H74');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'FOREIGN BODY IN EAR','FOREIGN BODY IN EAR','T16',NULL,NULL,NULL,NULL,NULL,1,'H76');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PERFORATION EAR DRUM','PERFORATION EAR DRUM','H72',NULL,NULL,'perforation ear drum with infection H71, H74; traumatic/pressure rupture ear drum H79',NULL,NULL,1,'H77');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SUPERFICIAL INJURY OF EAR','SUPERFICIAL INJURY OF EAR','S00.4, S00.9, S09.9',NULL,'external meatus/pinna injury','injury of tympanic membrane H79',NULL,NULL,1,'H78');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'EAR INJURY OTHER','EAR INJURY OTHER','S01.3, S09.2, T70.0',NULL,'traumatic/pressure rupture of ear drum',NULL,NULL,NULL,1,'H79');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONGENITAL ANOMALY OF EAR','CONGENITAL ANOMALY OF EAR','Q16, Q17',NULL,'accessory auricle, bat ears','congenital deafness H86',NULL,NULL,1,'H80');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'EXCESSIVE EAR WAX','EXCESSIVE EAR WAX','H61.2','symptom/complaint due to wax in ear canal',NULL,NULL,NULL,NULL,1,'H81');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'VERTIGINOUS SYNDROME','VERTIGINOUS SYNDROME','A88.1, H81, H82, H83.0','true rotational vertigo','benign paroxysmal/positional vertigo, labyrinthitis, Ménière''s disease, vestibular neuronitis',NULL,'vertigo/giddiness/dizziness N17',NULL,1,'H82');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'OTOSCLEROSIS','OTOSCLEROSIS','H80',NULL,NULL,NULL,NULL,NULL,1,'H83');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PRESBYACUSIS','PRESBYACUSIS','H91.1','gradual onset with ageing of symmetrical, bilateral deafness, particularly involving high-frequency sounds',NULL,'deafness  H86','hearing impairment H28; deafness H86',NULL,1,'H84');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ACOUSTIC TRAUMA','ACOUSTIC TRAUMA','H83.3','deafness in the high-frequency range with a definite history of exposure to loud noise','noise deafness','perforation of ear drum H77','hearing impairment H28; deafness H86',NULL,1,'H85');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'DEAFNESS','DEAFNESS','H90, H91.0, H91.2, H91.3, H91.8, H91.9',NULL,'congenital deafness, partial/complete deafness both ears','temporary deafness/deafness one ear H28; otosclerosis H83; presbyacusis H84; noise deafness H85',NULL,NULL,1,'H86');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'EAR/MASTOID DISEASE OTHER','EAR/MASTOID DISEASE OTHER','H61.0, H61.1, H61.3, H61.8, H61.9, H73.8, H73.9, H74, H83.1, H83.2, H83.8, H83.9, H93.0, H93.3, H93.8, H94',NULL,'polyp of middle ear','mastoiditis H74',NULL,NULL,1,'H99');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (NULL,'CIRCULATORY',NULL,NULL,NULL,NULL,NULL,NULL,NULL,1,'K');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'HEART PAIN','HEART PAIN','R07.2',NULL,'pain attributed to the heart','chest pain NOS A11; fear of heart attack K24; angina pectoris K74; chest tightness R29',NULL,NULL,1,'K01');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PRESSURE/TIGHTNESS OF HEART','PRESSURE/TIGHTNESS OF HEART','R07.2',NULL,'heaviness of heart','chest pain NOS A11; fear of heart attack K24; angina pectoris K74; shortness of breath/dyspnoea R02',NULL,NULL,1,'K02');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CARDIOVASCULAR PAIN NOS','CARDIOVASCULAR PAIN NOS','R09.8',NULL,NULL,'pain attributed to the heart K01; claudication K92; migraine N89',NULL,NULL,1,'K03');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PALPITATIONS/AWARENESS OF HEART','PALPITATIONS/AWARENESS OF HEART','R00.0, R00.1, R00.2',NULL,'tachycardia','paroxysmal tachycardia K79',NULL,NULL,1,'K04');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PROMINENT VEINS','PROMINENT VEINS','I78.1, I87.8',NULL,'unusually prominent veins, spider naevus','varicose veins K95; haemangioma S81',NULL,NULL,1,'K06');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SWOLLEN ANKLES/OEDEMA','SWOLLEN ANKLES/OEDEMA','R60',NULL,'dropsy, fluid retention, swollen feet/legs','ankle symptom L16; localized swelling S04',NULL,NULL,1,'K07');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'RISK FACTOR FOR CARDIOVASCULAR DISEASE','RISK FACTOR CARDIOVASCULAR DISEASE','Z82.3, Z82.4, Z86.7',NULL,'personal/family history, previous episode, other risk factor for cardiovascular disease',NULL,NULL,NULL,1,'K22');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF HEART DISEASE','FEAR OF HEART DISEASE','Z71.1','concern about/fear of heart attack/disease in a patient without the disease/untill the diagnosis is proven','fear of heart attack','if patient has the disease, code the disease',NULL,NULL,1,'K24');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF HYPERTENSION','FEAR OF HYPERTENSION','Z71.1','concern about/fear of hypertension in a patient without the disease/until the diagnosis is proven',NULL,'if patient has the disease, code the disease',NULL,NULL,1,'K25');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF CARDIOVASCULAR DISEASE OTHER','FEAR CARDIOVASCULAR DISEASE OTHER','Z71.1','concern about/fear of other disease of the circulatory system in a patient without the disease/until the diagnosis is proven',NULL,'fear of cardiovascular diseases K24, K25; if patient has the disease, code the disease',NULL,NULL,1,'K27');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LIMITED FUNCTION/DISABILITY (K)','LIMITED FUNCTION/DISABILITY (K)','Z73.6','limitation of function/disability due to a cardiovascular problem',NULL,NULL,NULL,'The COOP/WONCA Charts are suitable for documenting the patient''s functional status (see Chapter 8).',1,'K28');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CARDIOVASCULAR SYMPTOM/COMPLAINT OTHER','CARDIOVASCULAR SYMPT/COMPLT OTHER','R03.1, R09.8',NULL,'heart trouble, low blood pressure, weak heart','fluid in chest R82; cyanosis S08',NULL,NULL,1,'K29');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation complete','Medical examin/health eval complete',NULL,NULL,NULL,NULL,NULL,NULL,1,'K30');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation partial','Medical examin/health eval partial',NULL,NULL,NULL,NULL,NULL,NULL,1,'K31');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Sensitivity test','Sensitivity test',NULL,NULL,NULL,NULL,NULL,NULL,1,'K32');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Microbiological/immunological test','Microbiological/immunological test',NULL,NULL,NULL,NULL,NULL,NULL,1,'K33');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Blood test','Blood test',NULL,NULL,NULL,NULL,NULL,NULL,1,'K34');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Urine test','Urine test',NULL,NULL,NULL,NULL,NULL,NULL,1,'K35');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Faeces test','Faeces test',NULL,NULL,NULL,NULL,NULL,NULL,1,'K36');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Histological/exfoliative cytology','Histological/exfoliative cytology',NULL,NULL,NULL,NULL,NULL,NULL,1,'K37');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other laboratory test NEC','Other laboratory test NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'K38');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Physical function test','Physical function test',NULL,NULL,NULL,NULL,NULL,NULL,1,'K39');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic endoscopy','Diagnostic endoscopy',NULL,NULL,NULL,NULL,NULL,NULL,1,'K40');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic radiology/imaging','Diagnostic radiology/imaging',NULL,NULL,NULL,NULL,NULL,NULL,1,'K41');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Electrical tracing','Electrical tracing',NULL,NULL,NULL,NULL,NULL,NULL,1,'K42');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other diagnostic procedure','Other diagnostic procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'K43');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Preventive immunization/medication','Preventive immunization/medication',NULL,NULL,NULL,NULL,NULL,NULL,1,'K44');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Observation/health education/advice/diet','Observ/health educat/advice/diet',NULL,NULL,NULL,NULL,NULL,NULL,1,'K45');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with primary care provider','Consultation primary care provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'K46');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with specialist','Consultation with specialist',NULL,NULL,NULL,NULL,NULL,NULL,1,'K47');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Clarification/discussion of patient''s RFE/demand','Clarification/discussion RFE/demand',NULL,NULL,NULL,NULL,NULL,NULL,1,'K48');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other preventive procedure','Other preventive procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'K49');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Medication/prescription/renewal/injection','Medication/prescr/renewal/inject',NULL,NULL,NULL,NULL,NULL,NULL,1,'K50');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Incision/drainage/flushing/aspiration/removal body fluid (excl. catheterisation - 53)\n
 (excl. catheterisation - 53)','I&D/flush/aspiration (excl cath -53)',NULL,NULL,NULL,NULL,NULL,NULL,1,'K51');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Excision/removal tissue/biopsy/destruction/debridement/cauterization','Exc/remov/biopsy/destruc/debrid/caut',NULL,NULL,NULL,NULL,NULL,NULL,1,'K52');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Instrumentation/catheterization/intubation/dilation','Instrument/catheter/intubate/dilate',NULL,NULL,NULL,NULL,NULL,NULL,1,'K53');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Repair/fixation-suture/cast/prosthetic device (apply/remove)','Repair/fix-suture/cast/prosth device',NULL,NULL,NULL,NULL,NULL,NULL,1,'K54');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Local injection/infiltration','Local injection/infiltration',NULL,NULL,NULL,NULL,NULL,NULL,1,'K55');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Dressing/pressure/compression/tamponade','Dressing/pressure/compress/tamponade',NULL,NULL,NULL,NULL,NULL,NULL,1,'K56');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Physical medicine/rehabilitation','Physical medicine/rehabilitation',NULL,NULL,NULL,NULL,NULL,NULL,1,'K57');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Therapeutic counselling/listening','Therapeutic counselling/listening',NULL,NULL,NULL,NULL,NULL,NULL,1,'K58');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Other therapeutic procedure/minor surgery NEC','Other therap proced/minor surg NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'K59');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result test/procedure','Result test/procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'K60');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result examination/test/record/letter from other provider','Result exam/test/lett oth provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'K61');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (5,'Administrative procedure','Administrative procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'K62');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Follow-up encounter unspecified','Follow-up encounter unspecified',NULL,NULL,NULL,NULL,NULL,NULL,1,'K63');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by provider','Encounter/prob initiated by provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'K64');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by other than patient/provider','Enc/prob init by other than pt/prov',NULL,NULL,NULL,NULL,NULL,NULL,1,'K65');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to other provider/nurse/therapist/social worker','Referral to non-MD provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'K66');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to physician/specialist/clinic/hospital','Referral to MD/specialist/clin/hosp',NULL,NULL,NULL,NULL,NULL,NULL,1,'K67');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other referral NEC','Other referral NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'K68');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other reason for encounter NEC','Other reason for encounter nec',NULL,NULL,NULL,NULL,NULL,NULL,1,'K69');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'INFECTION OF CIRCULATORY SYSTEM','INFECTION OF CIRCULATORY SYSTEM','A39.5, B33.2, B37.6, I30, I32, I33, I38, I39, I40, I41',NULL,'acute/subacute endocarditis, bacterial endocarditis, myocarditis, pericarditis (other than rheumatic)','rheumatic heart disease K71; phlebitis/thrombophlebitis K94; arteritis K99',NULL,NULL,1,'K70');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'RHEUMATIC FEVER/HEART DISEASE','RHEUMATIC FEVER/HEART DISEASE','I00, I01, I02, I05, I06, I07, I09','- For acute rheumatic fever: two major, or one major, and two\n
  minor manifestations, plus evidence of preceding streptococcal\n
  infection; \n
  - major manifestations: migratory polyarthritis; carditis; chorea;\n
    erythema marginatum; subcutaneous nodules of recent onset\n
  - minor manifestations: fever; arthralgia; elevated ESR or \n
    positive C-reactive protein; prolonged P-R interval on ECG\n
- For chronic rheumatic heart disease: either physical findings\n
  consistent with a valve lesion of the heart in a patient with a \n
  history of rheumatic fever; or physical findings consistent with\n
  mitral stenosis, even in the absence of a history of rheumatic \n
  fever, but without any other demonstrable cause','chorea, mitral stenosis',NULL,'heart valve disease K83; other heart disease K84',NULL,1,'K71');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'NEOPLASM CARDIOVASCULAR','NEOPLASM CARDIOVASCULAR','C38.0, C45.2, D15.1, D15.2, D48.7',NULL,'benign/malignant cardiovascular neoplasm','haemangioma S81',NULL,NULL,1,'K72');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONGENITAL ANOMALY CARDIOVASCULAR','CONGENITAL ANOMALY CARDIOVASCULAR','Q20, Q21, Q22, Q23, Q24, Q25, Q26, Q27, Q28',NULL,'atrial/ventricular septal defect, Fallot''s tetralogy, patent ductus arteriosa','haemangioma S81',NULL,NULL,1,'K73');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ISCHAEMIC HEART DISEASE WITH ANGINA','ISCHAEMIC HEART DIS WITH ANGINA','I20, I24','history plus ECG or imaging evidence of old myocardial infarction; or demonstration of myocardial ischaemia by resting or exercise ECG; or investigation evidence of coronary artery narrowing or ventricular aneurysm','angina of effort, angina pectoris, angina with spasm, ischaemic chest pain, unstable angina','ischaemic heart disease without angina K76','heart pain K01',NULL,1,'K74');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ACUTE MYOCARDIAL INFARCTION','ACUTE MYOCARDIAL INFARCTION','I21, I22, I23','chest pain characteristic of myocardial ischaemia, lasting more than l5 minutes, and/or abnormal ST-Tchanges or new Q waves in electrocardiogram or elevation of blood cardiac enzymes','myocardial infarction specified as acute or within 4 weeks (28 days) of onset','old/healed myocardial infarction K74, K76','heart pain KO1, angina pectoris K74, chronic ischaemic heart disease K76','double code K74 or K76 as well',1,'K75');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ISCHAEMIC HEART DISEASE WITHOUT ANGINA','ISCHAEMIC HEART DIS WITHOUT ANGINA','I24, I25','history plus ECG, or imaging evidence of old myocardial infarction; or demonstration of myocardial ischaemia by resting or exercise ECG; or investigation evidence of coronary artery narrowing; or ventricular aneurysm','aneurysm of heart, arteriosclerotic/atherosclerotic heart disease, coronary artery disease, ischaemic cardiomyopathy, old myocardial infarction, silent myocardial ischaemia','ischaemic heart disease with angina K74',NULL,NULL,1,'K76');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HEART FAILURE','HEART FAILURE','I50','multiple signs including dependent oedema, raised jugular venous pressure, hepatomegaly in the absence of liver disease, pulmonary congestion, pleural effusion, enlarged heart.','cardiac asthma, congestive heart failure, heart failure NOS, left ventricular failure, pulmonary oedema, right ventricular failure','cor pulmonale K82',NULL,NULL,1,'K77');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ATRIAL FIBRILLATION/FLUTTER','ATRIAL FIBRILLATION/FLUTTER','I48','characteristic findings by electrocardiogram; or totally irregular heart rate with a pulse deficit',NULL,'paroxysmal tachycardia K79','palpitations K04; abnormal irregular heartbeat K05',NULL,1,'K78');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PAROXYSMAL TACHYCARDIA','PAROXYSMAL TACHYCARDIA','I47','history of recurrent episodes of rapid heart rate (over l40/min) with both abrupt onset and termination','supraventricular/ventricular tachycardia','tachycardia NOS K04; atrial fibrillation K78','palpitations K04; abnormal irregular heartbeat K05',NULL,1,'K79');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CARDIAC ARRHYTHMIA NOS','CARDIAC ARRHYTHMIA NOS','I49','one or more heart beats which occur at times other than the regular beats of the underlying rhythm','atrial/junctional/ventricular premature beats, bradycardia, bigeminy, ectopic beats, extrasystoles, premature beats, sick sinus syndrome, ventricular fibrillation/flutter','paroxysmal tachycardia K79','palpitations KO4, abnormal irregular heartbeat K05',NULL,1,'K80');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HEART/ARTERIAL MURMUR NOS','HEART/ARTERIAL MURMUR NOS','R01',NULL,'cardiac/carotid/renal artery bruit, innocent murmur of childhood','rheumatic heart disease K71; valve disease K83; cerebrovascular disease K90',NULL,NULL,1,'K81');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PULMONARY HEART DISEASE','PULMONARY HEART DISEASE','I27, I28','presence of a chronic disease of the lungs, pulmonary vasculature, or respiratory gas exchange; plus presence of right ventricular enlargement or right heart failure','chronic cor pulmonale, disease of pulmonary vessels, primary pulmonary hypertension','pulmonary embolism K93','right heart failure K77',NULL,1,'K82');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HEART VALVE DISEASE NOS','HEART VALVE DISEASE NOS','I08, I34, I35, I36, I37','absence of criteria for chronic rheumatic heart disease K71; plus evidence of valvular dysfunction by either characteristic heart murmur, or by imaging/echocardiographic evidence of abnormal valve','chronic endocarditis, mitral valve prolapse, non-rheumatic aortic/mitral/pulmonary/tricuspid valve disorder','rheumatic valve disease K71','hypertensive heart disease K87; cardiac murmur NOS K81',NULL,1,'K83');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HEART DISEASE OTHER','HEART DISEASE OTHER','I31, I42, I43, I44, I45, I46, I51, I52, O90.3',NULL,'bundle branch block, cardiac arrest, cardiomegaly, disease of pericardium, cardiomyopathy, heart block, left bundle-branch block, other conduction disorders','cardiac arrhythmia K80',NULL,NULL,1,'K84');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ELEVATED BLOOD PRESSURE','ELEVATED BLOOD PRESSURE','R03.0',NULL,'elevated blood pressure not meeting criteria for K86 and K87, transient/labile hypertension',NULL,NULL,NULL,1,'K85');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HYPERTENSION UNCOMPLICATED','HYPERTENSION UNCOMPLICATED','I10','either two or more readings per encounter, taken at two or more encounters, with blood pressures that average over 95 mm Hg diastolic or over 160 mm Hg systolic in adult patients; or two or more readings at a single encounter with an average diastolic blood pressure of 120 mm Hg or more; plus absence of evidence of secondary involvement of heart, kidney, eye, or brain','essential hypertension, hypertension NOS, idiopathic hypertension','hypertension with complications K87; hypertension in pregnancy W81','elevated blood pressure K85','1:For children, consult appropriate paediatric blood pressure tables \n
2:If secondary hypertension, code also the underlying cause',1,'K86');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HYPERTENSION COMPLICATED','HYPERTENSION COMPLICATED','I11, I12, I13, I15, I67.4','either two or more readings per encounter, taken at two or more encounters, with blood pressures that average over 95 mm Hg diastolic or over 160 mm Hg systolic in adult patients; or two or more readings at a single encounter with an average diastolic blood pressure of 120 mm Hg or more; plus evidence of abnormalities of the heart (enlargement, failure), kidney (albuminuria, azotemia), eye, or the brain attributed to hypertension','malignant hypertension','uncomplicated hypertension K86',NULL,'1:For children, consult appropriate paediatric blood pressure tables \n
2:If secondary hypertension, code also the underlying cause',1,'K87');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'POSTURAL HYPOTENSION','POSTURAL HYPOTENSION','I95.0, I95.1, I95.8, I95.9','signs or symptoms of cerebrovascular insufficiency (dizzines, syncope) on changing from the supine to the upright position; and a fall in mean blood pressure of 15 mm Hg on two or more occasions when changing from the supine to the upright position','idiopathic/orthostatic hypotension','hypotension due to drugs A85','low blood pressure K29',NULL,1,'K88');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'TRANSIENT CEREBRAL ISCHAEMIA','TRANSIENT CEREBRAL ISCHAEMIA','G45','symptoms of transient (less than 24 hours) hypofunction of the brain, with sudden onset, presumed of vascular origin, without sequelae; and with exclusion of migraine/migraine equivalent/ epilepsy','basilar insufficiency, drop attacks, transient ischaemic attack (TIA), transient global amnesia','carotid bruit K81, cerebrovascular accident K90, migraine N89','fainting/syncope A06','double code with K91',1,'K89');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'STROKE/CEREBROVASCULAR ACCIDENT','STROKE/CEREBROVASCULAR ACCIDENT','G46, I60, I61, I62, I63, I64','signs and symptoms of a disturbance of cerebral function, presumed of vascular origin, lasting more than 24 hours or causing death, and within four weeks (28 days) of onset','apoplexy, cerebral embolism/infarction/thrombosis/occlusion/ stenosis/haemorrhage, cerebrovascular accident  (CVA), subarachnoid haemorrhage','transient cerebral ischaemia K89; traumatic intracranial haemorrhage N80',NULL,'double code with K91',1,'K90');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CEREBROVASCULAR DISEASE','CEREBROVASCULAR DISEASE','I65, I66, I67.0, I67.1, I67.2, I67.3, I67.5, I67.6, I67.7, I67.8, I67.9, I68, I69','previous transient cerebral ischaemia/stroke; or investigation evidence of cerebrovascular disease','cerebral aneurysm, sequelae of stroke',NULL,NULL,NULL,1,'K91');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ATHEROSCLEROSIS/PERIPHERAL VASCULAR DISEASE','ATHEROSCLEROSIS/PERIPH VASCULAR DIS','I70, I73, I74, R02',NULL,'arteriosclerosis, arterial embolism/thrombosis/stenosis, atheroma, endarteritis, gangrene, intermittent claudication, limb ischaemia, Raynaud''s syndrome, vasospasm','mesenteric atherosclerosis D99; ophthalmic/retinal  atherosclerosis F99; coronary atherosclerosis  K74 to K76; pulmonary atherosclerosis K82; cerebral atherosclerosis K89, K90; aneurysm K99; renal atherosclerosis U99',NULL,NULL,1,'K92');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PULMONARY EMBOLISM','PULMONARY EMBOLISM','I26','sudden onset of dyspnoea/tachypnoea and either clinical or imaging evidence of pulmonary infarction, or ECG evidence of acute right ventricular strain;','pulmonary (artery/vein) infarction, thromboembolism, thrombosis',NULL,'dyspnoea R02',NULL,1,'K93');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PHLEBITIS/THROMBOPHLEBITIS','PHLEBITIS/THROMBOPHLEBITIS','I80, I81, I82, I87.0',NULL,'superficial/deep vein thrombosis, phlebothrombosis, portal thrombosis','cerebral thrombosis K89, K90',NULL,NULL,1,'K94');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'VARICOSE VEINS OF LEG','VARICOSE VEINS OF LEG','I83.1, I83.9, I87.2, I87.8','presence of dilated superficial veins in lower extremities; or demonstration of valve incompetence of veins','varicose eczema, venous insufficiency, venous stasis','varicose ulcer S97','prominent veins K06',NULL,1,'K95');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HAEMORRHOIDS','HAEMORRHOIDS','I84','visualization of varicosities of the venous plexus of the anus or canal; or tender, painful, blue-coloured localized swelling of acute onset, in the perianal area; or skin tags in the perianal area','internal haemorrhoids with/without complications, perianal haematoma, piles, residual haemorrhoidal skin tag, thrombosed external haemorrhoids, varicose veins of anus/rectum',NULL,'anal pain D04; rectal bleeding D16; anal lump D29',NULL,1,'K96');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CARDIOVASCULAR DISEASE OTHER','CARDIOVASCULAR DISEASE OTHER','I71, I72, I77, I78.0, I78.8, I78.9, I79, I85, I86, I87.1, I87.9, I98, I99, M30, M31, R57, T06.3, Z94.1, Z94.3',NULL,'aortic aneurysm, arteriovenous fistula, arteritis, lymphoedema, oesophageal varices, other aneurysm, polyarteritis nodosa, vasculitis, varicose veins of sites other than lower extremities','chronic/non-specific lymphadenitis B71; cerebral aneurysm K91; gangrene K92',NULL,NULL,1,'K99');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'NECK SYMPTOM/COMPLAINT','NECK SYMPTOM/COMPLAINT','M54.0, M54.2',NULL,'pain attributed to cervical spine/musculoskeletal system','headache N01; pain in face N03',NULL,NULL,1,'L01');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'BACK SYMPTOM/COMPLAINT','BACK SYMPTOM/COMPLAINT','M54.0, M54.6, M54.8, M54.9',NULL,'backache NOS, thoracic back pain','low back pain L03',NULL,NULL,1,'L02');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LOW BACK SYMPTOM/COMPLAINT','LOW BACK SYMPTOM/COMPLAINT','M54.0, M54.5',NULL,'back pain (lumbar/sacroiliac), coccydynia, lumbago, lumbalgia','thoracic back pain L02; sciatica L86',NULL,NULL,1,'L03');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CHEST SYMPTOM/COMPLAINT','CHEST SYMPTOM/COMPLAINT','R29.8',NULL,'chest pain attributed to musculoskeletal system','chest pain NOS A11; pain attributed to the heart K01; painful respiration/pleuritic pain/pleurodynia R01',NULL,NULL,1,'L04');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FLANK/AXILLA SYMPTOM/COMPLAINT','FLANK/AXILLA SYMPTOM/COMPLAINT','R29.8',NULL,'loin pain','kidney symptoms U14',NULL,NULL,1,'L05');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'included with L05',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'L06');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'JAW SYMPTOM/COMPLAINT','JAW SYMPTOM/COMPLAINT','M25.5, R29.8',NULL,'temporomandibular joint symptoms','teeth/gum symptom/complaint D19',NULL,NULL,1,'L07');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SHOULDER SYMPTOM/COMPLAINT','SHOULDER SYMPTOM/COMPLAINT','M25.4, M25.5, M25.6',NULL,NULL,NULL,NULL,NULL,1,'L08');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ARM SYMPTOM/COMPLAINT','ARM SYMPTOM/COMPLAINT','M79.6, R29.8',NULL,NULL,'muscle pain/myalgia L18',NULL,NULL,1,'L09');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ELBOW SYMPTOM/COMPLAINT','ELBOW SYMPTOM/COMPLAINT','M25.4, M25.5, M25.6',NULL,NULL,NULL,NULL,NULL,1,'L10');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'WRIST SYMPTOM/COMPLAINT','WRIST SYMPTOM/COMPLAINT','M25.4, M25.5, M25.6',NULL,NULL,NULL,NULL,NULL,1,'L11');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'HAND/FINGER SYMPTOM/COMPLAINT','HAND/FINGER SYMPTOM/COMPLAINT','M25.4, M25.5, M25.6, R29.8',NULL,NULL,NULL,NULL,NULL,1,'L12');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LEG/THIGH SYMPTOM/COMPLAINT','LEG/THIGH SYMPTOM/COMPLAINT','R25.2, R29.8',NULL,'leg cramps','muscle pain/myalgia L18; restless legs N04',NULL,NULL,1,'L14');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'KNEE SYMPTOM/COMPLAINT','KNEE SYMPTOM/COMPLAINT','M25.4, M25.5, M25.6',NULL,NULL,NULL,NULL,NULL,1,'L15');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ANKLE SYMPTOM/COMPLAINT','ANKLE SYMPTOM/COMPLAINT','M25.4, M25.5, M25.6',NULL,NULL,NULL,NULL,NULL,1,'L16');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FOOT/TOE SYMPTOM/COMPLAINT','FOOT/TOE SYMPTOM/COMPLAINT','M25.4, M25.5, M25.6, M77.4, M77.5, R29.8',NULL,'metatarsalgia',NULL,NULL,NULL,1,'L17');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'MUSCLE PAIN','MUSCLE PAIN','M60.1, M60.2, M60.8, M60.9, M79.0, M79.1, M79.6',NULL,'fibromyalgia, fibrositis, myalgia, rheumatism','pain in spine L01, L02, L03; leg cramps L14',NULL,NULL,1,'L18');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'MUSCLE SYMPTOM/COMPLAINT NOS','MUSCLE SYMPTOM/COMPLAINT NOS','M62.5, M62.6, M79.9',NULL,'atrophy/wasting/weakness of muscle, muscle stiffness/strain','pain in spine L01, L02, L03; leg cramps L14; ''growing pains'' in child L29; restless legs N04',NULL,NULL,1,'L19');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'JOINT SYMPTOM/COMPLAINT NOS','JOINT SYMPTOM/COMPLAINT NOS','M25.4, M25.5, M25.6, M25.8, M25.9',NULL,'arthralgia, effusion/swelling of joint, pain/stiffness/weakness in joint','symptoms/complaints specified in L07, L08, L10-13, L15-17',NULL,NULL,1,'L20');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF CANCER MUSCULOSKELETAL','FEAR OF CANCER MUSCULOSKELETAL','Z71.1','concern about/fear of cancer of musculoskeletal system in a patient without cancer/until the diagnosis is proven',NULL,'if the patient has the disease, code the disease',NULL,NULL,1,'L26');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF MUSCULOSKELETAL DISEASE OTHER','FEAR OF MUSCULOSKELETAL DIS OTHER','Z71.1','concern about/fear of a musculoskeletal disease in a patient without the disease/until the diagnosis is proven',NULL,'fear of musculoskeletal cancer L26; if patient has the disease, code the disease',NULL,NULL,1,'L27');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LIMITED FUNCTION/DISABILITY (L)','LIMITED FUNCTION/DISABILITY (L)','Z73.6','limitation of function/disability due to a musculoskeletal problem',NULL,'falls A29; limping/walking difficulties/gait problems N29',NULL,'The COOP/WONCA Charts are suitable for documenting the patient''s functional status (see Chapter 8).',1,'L28');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation complete','Medical examin/health eval complete',NULL,NULL,NULL,NULL,NULL,NULL,1,'L30');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation partial','Medical examin/health eval partial',NULL,NULL,NULL,NULL,NULL,NULL,1,'L31');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Sensitivity test','Sensitivity test',NULL,NULL,NULL,NULL,NULL,NULL,1,'L32');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Microbiological/immunological test','Microbiological/immunological test',NULL,NULL,NULL,NULL,NULL,NULL,1,'L33');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Blood test','Blood test',NULL,NULL,NULL,NULL,NULL,NULL,1,'L34');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Urine test','Urine test',NULL,NULL,NULL,NULL,NULL,NULL,1,'L35');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Faeces test','Faeces test',NULL,NULL,NULL,NULL,NULL,NULL,1,'L36');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Histological/exfoliative cytology','Histological/exfoliative cytology',NULL,NULL,NULL,NULL,NULL,NULL,1,'L37');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other laboratory test NEC','Other laboratory test NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'L38');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Physical function test','Physical function test',NULL,NULL,NULL,NULL,NULL,NULL,1,'L39');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic endoscopy','Diagnostic endoscopy',NULL,NULL,NULL,NULL,NULL,NULL,1,'L40');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic radiology/imaging','Diagnostic radiology/imaging',NULL,NULL,NULL,NULL,NULL,NULL,1,'L41');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Electrical tracing','Electrical tracing',NULL,NULL,NULL,NULL,NULL,NULL,1,'L42');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other diagnostic procedure','Other diagnostic procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'L43');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Preventive immunization/medication','Preventive immunization/medication',NULL,NULL,NULL,NULL,NULL,NULL,1,'L44');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Observation/health education/advice/diet','Observ/health educat/advice/diet',NULL,NULL,NULL,NULL,NULL,NULL,1,'L45');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with primary care provider','Consultation primary care provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'L46');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with specialist','Consultation with specialist',NULL,NULL,NULL,NULL,NULL,NULL,1,'L47');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Clarification/discussion of patient''s RFE/demand','Clarification/discussion RFE/demand',NULL,NULL,NULL,NULL,NULL,NULL,1,'L48');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other preventive procedure','Other preventive procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'L49');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Medication/prescription/renewal/injection','Medication/prescr/renewal/inject',NULL,NULL,NULL,NULL,NULL,NULL,1,'L50');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Incision/drainage/flushing/aspiration/removal body fluid (excl. catheterisation - 53)\n
 (excl. catheterisation - 53)','I&D/flush/aspiration (excl cath -53)',NULL,NULL,NULL,NULL,NULL,NULL,1,'L51');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Excision/removal tissue/biopsy/destruction/debridement/cauterization','Exc/remov/biopsy/destruc/debrid/caut',NULL,NULL,NULL,NULL,NULL,NULL,1,'L52');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Instrumentation/catheterization/intubation/dilation','Instrument/catheter/intubate/dilate',NULL,NULL,NULL,NULL,NULL,NULL,1,'L53');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Repair/fixation-suture/cast/prosthetic device (apply/remove)','Repair/fix-suture/cast/prosth device',NULL,NULL,NULL,NULL,NULL,NULL,1,'L54');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Local injection/infiltration','Local injection/infiltration',NULL,NULL,NULL,NULL,NULL,NULL,1,'L55');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Dressing/pressure/compression/tamponade','Dressing/pressure/compress/tamponade',NULL,NULL,NULL,NULL,NULL,NULL,1,'L56');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Physical medicine/rehabilitation','Physical medicine/rehabilitation',NULL,NULL,NULL,NULL,NULL,NULL,1,'L57');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Therapeutic counselling/listening','Therapeutic counselling/listening',NULL,NULL,NULL,NULL,NULL,NULL,1,'L58');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Other therapeutic procedure/minor surgery NEC','Other therap proced/minor surg NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'L59');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result test/procedure','Result test/procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'L60');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result examination/test/record/letter from other provider','Result exam/test/lett oth provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'L61');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Follow-up encounter unspecified','Follow-up encounter unspecified',NULL,NULL,NULL,NULL,NULL,NULL,1,'L63');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by provider','Encounter/prob initiated by provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'L64');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by other than patient/provider','Enc/prob init by other than pt/prov',NULL,NULL,NULL,NULL,NULL,NULL,1,'L65');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to other provider/nurse/therapist/social worker','Referral to non-MD provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'L66');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to physician/specialist/clinic/hospital','Referral to MD/specialist/clin/hosp',NULL,NULL,NULL,NULL,NULL,NULL,1,'L67');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other referral NEC','Other referral NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'L68');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other reason for encounter NEC','Other reason for encounter NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'L69');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'INFECTIONS OF MUSCULOSKELETAL SYSTEM','INFECTIONS OF MUSCULOSKELETAL SYSTEM','M00, M01, M46.2, M46.3, M46.4, M46.5, M60.0, M65.0, M65.1, M71.0, M71.1, M86','infections localized in musculoskeletal system','infective tenosynovitis, osteomyelitis, pyogenic arthritis','Reiter''s disease L99; late effect of polio N70',NULL,NULL,1,'L70');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM MUSCULOSKELETAL','MALIGNANT NEOPLASM MUSCULOSKELETAL','C40, C41, C49','characteristic histological appearance','fibrosarcoma, osteosarcoma','secondary neoplasms (code to original site), benign/unspecified musculoskeletal neoplasm L97',NULL,NULL,1,'L71');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'FRACTURE: RADIUS/ULNA','FRACTURE: RADIUS/ULNA','S52','imaging evidence of a fracture; or trauma plus visible/palpable deformity or crepitus involving the bone','Colles'' fracture','pathological fracture L95, L99; non-union L99','arm symptoms L09; musculoskeletal injury NOS L81',NULL,1,'L72');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'FRACTURE: TIBIA/FIBULA','FRACTURE: TIBIA/FIBULA','S82.1, S82.2, S82.3, S82.4, S82.5, S82.6, S82.7, S82.8, S82.9','imaging evidence of a fracture; or trauma plus visible/palpable deformity or crepitus involving the bone','Pott''s fracture','fracture patella L76; pathological fracture L95, L99; non-union L99','leg symptom L14; ankle symptom L16; musculoskeletal injury NOS L81',NULL,1,'L73');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'FRACTURE: HAND/FOOT BONE','FRACTURE: HAND/FOOT BONE','S62, S92','imaging evidence of a fracture; or trauma plus visible/palpable deformity or crepitus involving the bone','fracture carpal/metacarpal bone, fracture phalange hand/foot, fracture tarsal/metatarsal bone','pathological fracture L95, L99; non-union L99','arm symptom L09; leg symptom L14; musculoskeletal injury NOS L81',NULL,1,'L74');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'FRACTURE: FEMUR','FRACTURE: FEMUR','S72','imaging evidence of a fracture; or trauma plus visible/palpable deformity or crepitus involving the bone','fracture neck of femur','pathological fracture L95, L99; non-union L99','leg symptom L14; musculoskeletal injury NOS L81',NULL,1,'L75');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'FRACTURE: OTHER','FRACTURE: OTHER','S02.2, S02.3, S02.4, S02.6, S02.7, S02.8, S02.9, S12, S22, S32, S42, S82.0, T08, T10, T12, T14.2','imaging evidence of a fracture; or trauma plus visible/palpable displacement of the bone surface',NULL,'fractures specified in L72, L73, L74, and L75; pathological fracture L95, L99; non-union L99; skull fracture N80','symptoms in component 1',NULL,1,'L76');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SPRAIN/STRAIN OF KNEE','SPRAIN/STRAIN OF KNEE','S83.4, S83.6','stretch injury of the affected part plus pain aggravated by stretching or tensing the affected structure',NULL,'acute damage of meniscus/internal ligament of knee L96',NULL,NULL,1,'L78');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SPRAIN/STRAIN OF JOINT NOS','SPRAIN/STRAIN OF JOINT NOS','S03.4, S03.5, S13.4, S13.5, S13.6, S23.3, S23.4, S23.5, S33.6, S43.4, S43.5, S43.6, S43.7, S53.2, S53.3, S53.4, S63.3, S63.4, S63.5, S63.6, S63.7, S73.1, S93.2, S93.5, S93.6, T14.3','stretch injury of the affected part plus pain aggravated by stretching or tensing the affected structure','sprain/strain of other joint/ligament, whiplash','sprain/strain ankle L77; sprain/strain knee L78;  back strain L84','symptoms in component 1',NULL,1,'L79');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'DISLOCATION/SUBLUXATION','DISLOCATION/SUBLUXATION','M22.0, M22.1, S03.0, S03.3, S13.0, S13.1, S13.2, S13.3, S23.1, S23.2, S33.1, S33.2, S33.3, S43.0, S43.1, S43.2, S43.3, S53.0, S53.1, S63.0, S63.1, S63.2, S73.0, S83.0, S83.1, S93.0, S93.1, S93.3, T14.3','trauma to the joint plus either imaging evidence of a dislocation/ subluxation, or palpable/visible dislocation deformity','dislocation/subluxation any site, including spine',NULL,'symptoms in component 1','code fracture dislocations to the fracture',1,'L80');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'INJURY MUSCULOSKELETAL NOS','INJURY MUSCULOSKELETAL NOS','M79.5, S09.1, S16, S17, S18, S19, S23.0, S28, S29, S33.0, S33.4, S39, S46, S47, S48, S49, S56, S57, S58, S59, S66, S67, S68, S69, S76, S77, S78, S79, S86, S87, S88, S89, S96, S97, S98, S99, T06.4, T11, T13, T14.6, T14.7',NULL,'deep foreign body, haemarthrosis, traumatic amputation','internal injury of chest/abdomen/pelvis, multiple trauma A81; late effect trauma/deformity/disability/scarring A82; injury teeth D80; injury eardrum H77; traumatic arthropathy L91; non-/malunion of fracture L99; head injury/ concussion/intracranial injury/skull fracture N80; laceration/other injury to nerve N81; insect bite/sting S12; animal bite S13; bruise/contusion S16; laceration/open wound S18',NULL,NULL,1,'L81');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONGENITAL ANOMALY MUSCULOSKELETAL','CONGENITAL ANOMALY MUSCULOSKELETAL','Q65, Q66, Q67, Q68, Q69, Q70, Q71, Q72, Q73, Q74, Q75, Q76, Q77, Q78, Q79',NULL,'bow leg, clubfoot (talipes), congenital dislocation of hip, genu recurvatum, congenital malformation of skull and face, other congenital deformity of the foot','scoliosis L85; pes planus (acquired) L98; spina bifida N85',NULL,NULL,1,'L82');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'NECK SYNDROME','NECK SYNDROME','M43.3, M43.4, M43.6, M47.8, M47.9, M48, M50, M53.0, M53.1',NULL,'syndromes with/without radiation of pain: cervical disc lesion, cervicobrachial syndrome, cervicogenic headache, osteoarthritis of neck, radicular syndrome of upper limbs, spondylosis, torticollis',NULL,NULL,NULL,1,'L83');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BACK SYNDROME WITHOUT RADIATING PAIN','BACK SYNDROME WITHOUT RADIAT PAIN','M43.0, M43.1, M43.5, M46.0, M46.1, M46.8, M46.9, M47.0, M47.8, M47.9, M48, M51, M53.2, M53.3, M53.8, M53.9, S33.5, S33.7','back pain without radiation plus limitation of movement confirmed at medical examination','back strain, collapsed vertebra NOS, facet joint degeneration, osteoarthrosis/osteoarthritis of spine, spondylolisthesis, spondylosis','coccydynia L03; syndrome related to the neck L83; back pain with radiation/sciatica L86; psychogenic backache P75','symptom/complaint back L02; symptom/complaint low back L03',NULL,1,'L84');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ACQUIRED DEFORMITY OF SPINE','ACQUIRED DEFORMITY OF SPINE','M40, M41, M43.8, M43.9',NULL,'kyphoscoliosis, kyphosis, lordosis, scoliosis','congenital deformity L82; ankylosing spondylitis L88; spondylolisthesis L84',NULL,NULL,1,'L85');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BACK SYNDROME WITH RADIATING PAIN','BACK SYNDROME WITH RADIATING PAIN','M47.1, M47.2, M51, M54.3, M54.4','pain in the lumbar/thoracic region of the spine, accompanied by pain radiating to, or a neurological deficit of, an appropriate area; or sciatica, pain radiating down the back of the leg, aggravated by coughing, movement, or posture; or demonstration of a prolapsed lumbar or thoracic disc by appropriate imaging technique, or at surgery','disc prolapse/degeneration, sciatica','cervical disc lesion L83; spondylolisthesis L84; recent back strain L84','back pain L02; low back pain L03','exclude referred pain which is diffuse',1,'L86');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BURSITIS/TENDINITIS/SYNOVITIS NOS','BURSITIS/TENDINITIS/SYNOVITIS NOS','M65.2, M65.3, M65.4, M65.8, M65.9, M67.3, M67.4, M70, M71.2, M71.3, M71.4, M71.5, M71.8, M71.9, M72, M76, M77.0, M77.2, M77.3, M77.8, M77.9',NULL,'bone spurs, calcified tendon, Dupuytren''s contracture, fasciitis, ganglion, synovial cysts, tenosynovitis, trigger finger','bursitis/tendinitis/synovitis of shoulder L92; tennis elbow/lateral epicondylitis L93',NULL,NULL,1,'L87');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'RHEUMATOID/SEROPOSITIVE ARTHRITIS','RHEUMATOID/SEROPOSITIVE ARTHRITIS','M05, M06, M08, M45',NULL,'allied conditions: ankylosing spondylitis, juvenile arthritis','psoriatic arthropathy L99',NULL,NULL,1,'L88');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'OSTEOARTHROSIS OF HIP','OSTEOARTHROSIS OF HIP','M16','either characteristic imaging appearance; or joint disorder of at least 3 months'' duration, with no constitutional symptoms and three or more of the following: intermittent swelling; crepitation; stiffness/limitation of movement; normal ESR, rheumatoid tests, and uric acid; over 40 years of age','osteoarthritis of hip secondary to dysplasia/trauma',NULL,'joint symptom L20; arthritis NOS L91',NULL,1,'L89');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'OSTEOARTHROSIS OF KNEE','OSTEOARTHROSIS OF KNEE','M17','either characteristic imaging appearance; or joint disorder of at least 3 months'' duration, with no constitutional symptoms and three or more of the following: intermittent swelling; crepitation; stiffness/limitation of movement; normal ESR, rheumatoid tests, and uric acid; over 40 years of age','osteoarthritis of knee secondary to dysplasia/trauma',NULL,'joint symptom L20; arthritis NOS L91',NULL,1,'L90');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'OSTEOARTHROSIS OTHER','OSTEOARTHROSIS OTHER','M13, M15, M18, M19','characteristic imaging appearance; or Herberden''s nodes; or joint disorder of at least 3 months'' duration, with no constitutional symptoms and three or more of the following: intermittent swelling; crepitation; stiffness/limitation of movement; normal ESR, rheumatoid tests, and uric acid; over 40 years of age','arthritis NOS, Heberden''s nodes, osteoarthritis, traumatic arthropathy','osteoarthrosis of neck L83; osteoarthrosis of spine L84; osteoarthosis of hip L89; osteoarthrosis of knee L90; osteoarthrosis of shoulder L92','joint symptom L20',NULL,1,'L91');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SHOULDER SYNDROME','SHOULDER SYNDROME','M75','shoulder pain with limitation of movement/local tenderness/crepitus; or periarticular calcification on imaging','bursitis of shoulder, frozen shoulder, osteoarthrosis/synovitis of shoulder, rotator cuff syndrome, tendinitis around shoulder',NULL,NULL,NULL,1,'L92');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'OSTEOCHONDROSIS','OSTEOCHONDROSIS','M42, M91, M92, M93',NULL,'Legg-Calvé-Perthes disease, Osgood-Schlatter disease, osteochondritis dissecans, Scheuermann''s disease, slipped femoral epiphysis',NULL,NULL,NULL,1,'L94');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'OSTEOPOROSIS','OSTEOPOROSIS','M80, M81, M82','characteristic imaging appearance','pathological fractures due to osteoporosis',NULL,NULL,NULL,1,'L95');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ACUTE INTERNAL DAMAGE KNEE','ACUTE INTERNAL DAMAGE KNEE','S83.2, S83.3, S83.5, S83.7','an initial injury which occurred no longer than one month previously and demonstration of ligament/meniscus tear by surgery/arthroscopy/imaging, or by locking/giving way, pain, and swelling of knee','acute damage to meniscus/cruciate ligaments','acute damage to collateral ligaments L78; dislocation of patella L80; chronic internal damage to knee L99','knee symptom L15; sprain of knee L78',NULL,1,'L96');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'NEOPLASM BENIGN/UNSPECIFIED MUSCULOSKELETAL','NEOPLASM BENIGN/UNSPECIF MUSCULOSKEL','D16, D21, D48.0, D48.1',NULL,'benign musculoskeletal neoplasm, musculoskeletal neoplasm not specified as benign or malignant/when histology is not available','malignant musculoskeletal neoplasm L71',NULL,NULL,1,'L97');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ACQUIRED DEFORMITY OF LIMB','ACQUIRED DEFORMITY OF LIMB','M20, M21',NULL,'bunion, genu valgum-varum, hallux valgus/varus, mallet finger, pes planus (flatfoot)','general congenital deformities and anomalies A90; musculoskeletal deformities and anomalies L82',NULL,NULL,1,'L98');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MUSCULOSKELETAL DISEASE OTHER','MUSCULOSKELETAL DISEASE OTHER','M02, M03, M07, M09, M12, M14, M22.2, M22.3, M22.4, M22.8, M22.9, M23, M24, M25.0, M25.1, M25.2, M25.3, M25.7, M25.8, M25.9, M32, M33, M34, M35, M36, M43.2, M49, M54.1, M61, M62.0, M62.1, M62.2, M62.3, M62.4, M62.8, M62.9, M63, M66, M67.0, M67.1, M67.2, M67.8, M67.9, M68, M73, M79.3, M79.4, M79.8, M84, M85, M87, M88, M89, M90, M94, M95, M99, T79.6, Z89, Z94.6, Z98.1',NULL,'arthrodesis, chronic internal derangement of knee, contractures, costochondritis, dermatomyositis, disorder of patella, malunion/ non-union of fracture, myositis, Paget''s disease of bone, panniculitis, pathological fracture N0S, polymyalgia rheumatica, psoriatic arthritis (code also S91), Reiter''s disease, scleroderma, Sjogren''s syndrome, spontaneous rupture tendon, systemic lupus erythematosis','hyperuricemia A91; pathological fracture due to osteoporosis L95; post-polio paralysis N70; post-stroke paralysis N81; gout T92; pseudogout/crystal arthropathy, osteomalacia T99',NULL,NULL,1,'L99');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (NULL,'NEUROLOGICAL','NEUROLOGICAL',NULL,NULL,NULL,NULL,NULL,NULL,1,'N');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'HEADACHE','HEADACHE','G44.3, G44.8, R51',NULL,'post-traumatic headache','cervicogenic headache L83; face pain N03; migraine N89; cluster headache N90; tension headache N95; atypical facial neuralgia N99; sinus pain R09; post-herpetic pain S70',NULL,NULL,1,'N01');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'transferred to N95',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'N02');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PAIN FACE','PAIN FACE','G50.1, R51',NULL,NULL,'toothache D19; headache N01; migraine N89; trigeminal neuralgia N92; sinus pain R09; post herpetic pain S70',NULL,NULL,1,'N03');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'RESTLESS LEGS','RESTLESS LEGS','G25.8',NULL,NULL,'leg cramps L14; intermittent claudication K92',NULL,NULL,1,'N04');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'TINGLING FINGERS/FEET/TOES','TINGLING FINGERS/FEET/TOES','R20.2',NULL,'burning sensation, prickly feeling fingers/feet/toes, paraesthesia','pain/tenderness of skin S01',NULL,NULL,1,'N05');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SENSATION DISTURBANCE OTHER','SENSATION DISTURBANCE OTHER','R20.0, R20.1, R20.3, R20.8',NULL,'anaesthesia, numbness','tingling fingers/feet/toes N05; pain/tenderness of skin S01',NULL,NULL,1,'N06');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CONVULSION/SEIZURE','CONVULSION/SEIZURE','R56',NULL,'febrile convulsion, fit','fainting A06; transient ischaemic attack K89',NULL,NULL,1,'N07');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ABNORMAL INVOLUNTARY MOVEMENTS','ABNORMAL INVOLUNTARY MOVEMENTS','G25.0, G25.1, G25.2, G25.3, G25.4, G25.5, G25.6, G25.8, G25.9, R25.0, R25.1, R25.3, R25.8, R29.0',NULL,'dystonia, jerking, myoclonus, shaking, spasm, tetany, tremor, twitching','chorea K71; cramps L12, L14, L17, L18; restless legs N04; convulsion N07; tic douloureux N92; organic tic N99; psychogenic tic P10',NULL,NULL,1,'N08');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'DISTURBANCE OF SMELL/TASTE','DISTURBANCE OF SMELL/TASTE','R43',NULL,'anosmia','halitosis D20',NULL,NULL,1,'N16');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'VERTIGO/DIZZINESS','VERTIGO/DIZZINESS','R42',NULL,'giddiness, feeling faint/lightheaded, loss of balance, woozy','syncope/blackout A06; motion sickness A88; specific vertiginous syndrome H82',NULL,NULL,1,'N17');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PARALYSIS/WEAKNESS','PARALYSIS/WEAKNESS','G98',NULL,'paresis','general weakness A04',NULL,NULL,1,'N18');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SPEECH DISORDER','SPEECH DISORDER','R47',NULL,'aphasia, dysphasia, dysarthria, slurred speech','stammering/stuttering P10; speech delay P22; hoarseness R23',NULL,NULL,1,'N19');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF CANCER OF NEUROLOGICAL SYSTEM','FEAR CANCER NEUROLOGICAL SYSTEM','Z71.1','concern about/fear of neurological cancer in a patient without the disease/until the diagnosis is proven',NULL,'if patient has the disease, code the disease',NULL,NULL,1,'N26');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF NEUROLOGICAL DISEASE OTHER','FEAR OF NEUROLOGICAL DISEASE OTHER','Z71.1','concern about/fear of other neurological disease in a patient without the disease/until the diagnosis is proven',NULL,'fear of neurological cancer N26; if the patient has the disease, code the disease',NULL,NULL,1,'N27');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'NEUROLOGICAL SYMPTOM/COMPLAINT OTHER','NEUROLOGICAL SYMPT/COMPLT OTHER','M79.2, R26, R27, R29.0, R29.1, R29.2, R29.8',NULL,'ataxia, gait abnormality, limping, meningism',NULL,NULL,NULL,1,'N29');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation complete','Medical examin/health eval complete',NULL,NULL,NULL,NULL,NULL,NULL,1,'N30');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation partial','Medical examin/health eval partial',NULL,NULL,NULL,NULL,NULL,NULL,1,'N31');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Sensitivity test','Sensitivity test',NULL,NULL,NULL,NULL,NULL,NULL,1,'N32');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Microbiological/immunological test','Microbiological/immunological test',NULL,NULL,NULL,NULL,NULL,NULL,1,'N33');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Blood test','Blood test',NULL,NULL,NULL,NULL,NULL,NULL,1,'N34');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Urine test','Urine test',NULL,NULL,NULL,NULL,NULL,NULL,1,'N35');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Faeces test','Faeces test',NULL,NULL,NULL,NULL,NULL,NULL,1,'N36');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Histological/exfoliative cytology','Histological/exfoliative cytology',NULL,NULL,NULL,NULL,NULL,NULL,1,'N37');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other laboratory test NEC','Other laboratory test NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'N38');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Physical function test','Physical function test',NULL,NULL,NULL,NULL,NULL,NULL,1,'N39');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic endoscopy','Diagnostic endoscopy',NULL,NULL,NULL,NULL,NULL,NULL,1,'N40');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic radiology/imaging','Diagnostic radiology/imaging',NULL,NULL,NULL,NULL,NULL,NULL,1,'N41');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Electrical tracing','Electrical tracing',NULL,NULL,NULL,NULL,NULL,NULL,1,'N42');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other diagnostic procedure','Other diagnostic procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'N43');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Preventive immunization/medication','Preventive immunization/medication',NULL,NULL,NULL,NULL,NULL,NULL,1,'N44');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Observation/health education/advice/diet','Observ/health educat/advice/diet',NULL,NULL,NULL,NULL,NULL,NULL,1,'N45');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with primary care provider','Consultation primary care provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'N46');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with specialist','Consultation with specialist',NULL,NULL,NULL,NULL,NULL,NULL,1,'N47');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Clarification/discussion of patient''s RFE/demand','Clarification/discussion RFE/demand',NULL,NULL,NULL,NULL,NULL,NULL,1,'N48');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other preventive procedure','Other preventive procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'N49');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Medication/prescription/renewal/injection','Medication/prescr/renewal/inject',NULL,NULL,NULL,NULL,NULL,NULL,1,'N50');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Incision/drainage/flushing/aspiration/removal body fluid (excl. catheterisation - 53)\n
 (excl. catheterisation - 53)','I&D/flush/aspiration (excl cath -53)',NULL,NULL,NULL,NULL,NULL,NULL,1,'N51');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Excision/removal tissue/biopsy/destruction/debridement/cauterization','Exc/remov/biopsy/destruc/debrid/caut',NULL,NULL,NULL,NULL,NULL,NULL,1,'N52');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Instrumentation/catheterization/intubation/dilation','Instrument/catheter/intubate/dilate',NULL,NULL,NULL,NULL,NULL,NULL,1,'N53');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Repair/fixation-suture/cast/prosthetic device (apply/remove)','Repair/fix-suture/cast/prosth device',NULL,NULL,NULL,NULL,NULL,NULL,1,'N54');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Local injection/infiltration','Local injection/infiltration',NULL,NULL,NULL,NULL,NULL,NULL,1,'N55');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Dressing/pressure/compression/tamponade','Dressing/pressure/compress/tamponade',NULL,NULL,NULL,NULL,NULL,NULL,1,'N56');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Physical medicine/rehabilitation','Physical medicine/rehabilitation',NULL,NULL,NULL,NULL,NULL,NULL,1,'N57');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Therapeutic counselling/listening','Therapeutic counselling/listening',NULL,NULL,NULL,NULL,NULL,NULL,1,'N58');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Other therapeutic procedure/minor surgery NEC','Other therap proced/minor surg NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'N59');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result test/procedure','Result test/procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'N60');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result examination/test/record/letter from other provider','Result exam/test/lett oth provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'N61');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (5,'Administrative procedure','Administrative procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'N62');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Follow-up encounter unspecified','Follow-up encounter unspecified',NULL,NULL,NULL,NULL,NULL,NULL,1,'N63');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by provider','Encounter/prob initiated by provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'N64');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by other than patient/provider','Enc/prob init by other than pt/prov',NULL,NULL,NULL,NULL,NULL,NULL,1,'N65');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to other provider/nurse/therapist/social worker','Referral to non-MD provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'N66');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to physician/specialist/clinic/hospital','Referral to MD/specialist/clin/hosp',NULL,NULL,NULL,NULL,NULL,NULL,1,'N67');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other referral NEC','Other referral NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'N68');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other reason for encounter NEC','Other reason for encounter NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'N69');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'POLIOMYELITIS','POLIOMYELITIS','A80, A85.0, B91',NULL,'late effect of poliomyelitis, post-polio syndrome, other enterovirus infection',NULL,NULL,NULL,1,'N70');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MENINGITIS/ENCEPHALITIS','MENINGITIS/ENCEPHALITIS','A39.0, A83, A84, A85.1, A85.2, A85.8, A86, A87, B00.3, B00.4, B37.5, B58.2, B94.1, G00, G01, G02, G03, G04, G05','an acute febrile illness with abnormal findings in the cerebro-spinal fluid.',NULL,NULL,'fever A03; meningism N29',NULL,1,'N71');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'TETANUS','TETANUS','A33, A34, A35','rigidity, hypertonic contractions or tetanic spasticity and a history of preceding injury',NULL,'tetany N08',NULL,NULL,1,'N72');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'NEUROLOGICAL INFECTION OTHER','NEUROLOGICAL INFECTION OTHER','A81, A88.8, A89, G06, G07, G08, G09',NULL,'cerebral abscess, slow virus infection','poliomyelitis N70; meningitis/encephalitis N71; acute polyneuritis N94',NULL,NULL,1,'N73');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM NERVOUS SYSTEM','MALIGNANT NEOPLASM NERVOUS SYSTEM','C47, C70, C71, C72','characteristic histological appearance',NULL,NULL,'unspecified neoplasm nervous system N76',NULL,1,'N74');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BENIGN NEOPLASM NERVOUS SYSTEM','BENIGN NEOPLASM NERVOUS SYSTEM','D32, D33, D36.1',NULL,'acoustic neuroma, meningioma',NULL,NULL,NULL,1,'N75');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'NEOPLASM NERVOUS SYSTEM UNSPECIFIED','NEOPLASM NERVOUS SYSTEM UNSPECIFIED','D42, D43, D48.2',NULL,'neoplasm nervous system not specified as benign or malignant/when histology is not available','neurofibromatosis A90',NULL,NULL,1,'N76');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HEAD INJURY OTHER','HEAD INJURY OTHER','S02.0, S02.1, S06.1, S06.2, S06.3, S06.4, S06.5, S06.6, S06.7, S06.8, S06.9, S07, S08, S09.0, S09.7, S09.8','trauma to the head, complicated by cerebral damage','cerebral contusion, cerebral injury with/without skull fracture, extradural haematoma, subdural haematoma, traumatic intracranial haemorrhage','concussion N79',NULL,NULL,1,'N80');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'INJURY NERVOUS SYSTEM OTHER','INJURY NERVOUS SYSTEM OTHER','S04, S09.9, S14, S24, S34, S44, S54, S64, S74, S84, S94, T06.0, T06.1, T06.2, T14.4',NULL,'nerve injury, spinal cord injury',NULL,NULL,NULL,1,'N81');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONGENITAL ANOMALY NEUROLOGICAL','CONGENITAL ANOMALY NEUROLOGICAL','Q00, Q01, Q02, Q03, Q04, Q05, Q06, Q07',NULL,'hydrocephalus, spina bifida',NULL,NULL,NULL,1,'N85');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MULTIPLE SCLEROSIS','MULTIPLE SCLEROSIS','G35','exacerbations/remissions of multiple neurological manifestation with deficits/derangements disseminated in both time and site (any combination of neurological signs and symptoms is possible)','disseminated sclerosis',NULL,'other neurological symptoms N29',NULL,1,'N86');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PARKINSONISM','PARKINSONISM','G20, G21, G22','poverty and slowness of voluntary movements, resting tremor improving with active purposeful movement and muscular rigidity','drug induced Parkisonism, paralysis agitans, Parkinson''s disease',NULL,'abnormal involuntary movements N08; disorder of speech N19',NULL,1,'N87');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'EPILEPSY','EPILEPSY','G40, G41','recurrent episodes of sudden altered consciousness, with/without tonic/clonic movements/seizure, plus either eyewitness account of the attack, or characteristic abnormality of electroencephalogram (EEG)','all types of epilepsy: focal seizures, generalized seizures, grand mal, petit mal, status epilepticus',NULL,'convulsion N07; other neurological symptom N29',NULL,1,'N88');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MIGRAINE','MIGRAINE','G43, G44.1','recurrent episodes of headache with three or more of  the following: unilateral headache; nausea/vomiting; aura; other neurological symptoms; family history of migraine','vascular headache with/without aura','cervicogenic headache L83; cluster headache N90; tension headache N95','headache N01',NULL,1,'N89');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CLUSTER HEADACHE','CLUSTER HEADACHE','G44.0','attacks of severe, often excruciating unilateral pain peri-orbitally and/or temporally, occurring up to 8 times a day, sometimes associated with conjunctival injection, lacrimation, nasal congestion, rhinorrhoea, sweating, miosis, ptosis, or eyelid edema. Attacks occur in cluster periods lasting weeks/months, separated by remissions lasting months/years.',NULL,'migraine N89',NULL,NULL,1,'N90');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'FACIAL PARALYSIS/BELL''S PALSY','FACIAL PARALYSIS/BELL''S PALSY','G51, G53','acute onset of unilateral paralysis of muscles of facial expression without sensory loss',NULL,NULL,'paralysis/weakness N18',NULL,1,'N91');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'TRIGEMINAL NEURALGIA','TRIGEMINAL NEURALGIA','G50.0, G50.8, G50.9','unilateral paroxysms of burning facial pain aggravated by touching triggerpoints, blowing nose or yawning, without sensory or motor paralysis','tic douloureux','post-herpetic neuralgia S70','neuralgia NOS N99',NULL,1,'N92');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CARPAL TUNNEL SYNDROME','CARPAL TUNNEL SYNDROME','G56.0','loss/impairment of superficial sensation affecting the thumb, index and middle finger, that may or may not split the ring finger. Dysesthesia and pain worsen usually during the night, and may radiate to the forearm',NULL,NULL,'sensation disturbance N06',NULL,1,'N93');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PERIPHERAL NEURITIS/NEUROPATHY','PERIPHERAL NEURITIS/NEUROPATHY','G54, G55, G56.1, G56.2, G56.3, G56.4, G56.8, G56.9, G57, G58, G59, G60, G61, G62, G63, G64','sensory, reflex and motor changes confined to the territory of individual nerves, sometimes without apparent cause, sometimes secondary to a specific disease, e.g. diabetes','acute infective polyneuropathy, diabetic neuropathy (double code with T89, T90), Guillain-Barre syndrome, nerve lesion, neuropathy, phantom limb','post-herpetic neuropathy S70',NULL,NULL,1,'N94');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'TENSION HEADACHE','TENSION HEADACHE','G44.2','pressing, generalized headache associated with stress and muscle tension with/without increased tenderness of pericranial muscles',NULL,'migraine N89; cluster headache N90','headache N01',NULL,1,'N95');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'NEUROLOGICAL DISEASE OTHER','NEUROLOGICAL DISEASE OTHER','E51.2, G10, G11, G12, G13, G23, G24, G26, G31.0, G31.1, G31.8, G31.9, G32, G36, G37, G52, G70, G71, G72, G73, G80, G81, G82, G83, G90, G91, G92, G93.0, G93.1, G93.2, G93.4, G93.5, G93.6, G93.7, G93.8, G93.9, G94, G95, G96, G98, G99, M79.2, Z98.2',NULL,'cerebral palsy, motor neurone disease, myasthenia gravis, neuralgia NOS','sleep apnoea P06',NULL,NULL,1,'N99');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (NULL,'PSYCHOLOGICAL','PSYCHOLOGICAL',NULL,NULL,NULL,NULL,NULL,NULL,1,'P');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEELING ANXIOUS/NERVOUS/TENSE','FEELING ANXIOUS/NERVOUS/TENSE','R45.0','feelings reported by the patient as an emotional or psychosocial experience not attributed to the presence of a mental disorder. A gradual transition exists from feelings that are unwelcome - but quite normal - and feelings that are so troublesome to the patient that professional help is sought','anxiety NOS, feeling frightened','anxiety disorder P74',NULL,NULL,1,'P01');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ACUTE STRESS REACTION','ACUTE STRESS REACTION','F43.0, F43.2, F43.8, F43.9','a reaction to a stressful life event or significant life change requiring a major adjustment, either as an expected response to the event or as a maladaptive response interfering with daily coping and resulting in impaired social functioning, with recovery within a limited period of time','adjustment disorder, culture shock, feeling stressed/grief/ homesick, immediate post-traumatic stress, shock (psychic)','feeling depressed P03; depressive disorder P76; post-traumatic stress disorder P82',NULL,NULL,1,'P02');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEELING DEPRESSED','FEELING DEPRESSED','R45.2, R45.3','feelings reported by the patient as an emotional or psychological experience not attributed to the presence of a mental disorder. A gradual transition exists from feelings that are unwelcome - but quite normal - and feelings that are so troublesome to the patient that professional help is sought','feeling inadequate, unhappy, worried','low self-esteem P28; depressive disorder P76',NULL,NULL,1,'P03');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEELING/BEHAVING IRRITABLE/ANGRY','FEELING/BEHAVING IRRITABLE/ANGRY','R45.1, R45.4, R45.5, R45.6','feelings reported by the patient as an emotional or psychological experience not attributed to the presence of a mental disorder, or behaviour indicating irritability or anger. A gradual transition exists from feelings or behaviour that are unwelcome - but quite normal - and those that are so troublesome that professional help is sought','agitation NOS, restlessness NOS','overactive child P22; irritability in partner Z13',NULL,NULL,1,'P04');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SENILIITY, FEELING/BEHAVING OLD','SENILITY, FEELING/BEHAVING OLD','R54','feelings reported by the patient as an emotional or psychological experience not attributed to the presence of a mental disorder. A gradual transition exists from feelings that are unwelcome - but quite normal - and feelings that are so troublesome to the patient that professional help is sought','concern with aging, senescence','dementia P70',NULL,NULL,1,'P05');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SLEEP DISTURBANCE','SLEEP DISTURBANCE','F51, G47','sleep disturbance as a diagnosis requires that the sleeping problem forms a major complaint, which, according to both patient and doctor, is not caused by another disorder but is a condition in its own right. Insomnia requires a quantitative or qualitative deficiency of sleep which is unsatisfactory in the patients'' opinion, over a considerable period of time. In hypersomnia excessive daytime sleepiness and sleep attacks exist which limit the patient''s performance','insomnia, nightmares, sleep apnoea, sleepwalking, somnolence','jet lag A88',NULL,NULL,1,'P06');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SEXUAL DESIRE REDUCED','SEXUAL DESIRE REDUCED','F52.0','sexual problems with regard to desire not caused by any organic disorder or disease, but a reflection of the inability of a patient to participate in the sexual relationship s/he wants because of lack of desire, failure of genital response or function','frigidity, loss of libido','non-organic impotence/loss of sexual fulfilment P08; concern with sexual preference P09',NULL,NULL,1,'P07');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SEXUAL FULFILMENT REDUCED','SEXUAL FULFILMENT REDUCED','F52.1, F52.2, F52.3, F52.4, F52.5, F52.6, F52.7, F52.8, F52.9','sexual problems with regard to fulfilment not caused by any organic disorder or disease, but a reflection of the inability of a patient to participate in the sexual relationship s/he wants because of failure of genital response or function, or problems with sexual development','non-organic impotence or dyspareunia, premature ejaculation, vaginismus of psychogenic origin','sexual problems with desire P07; concern with sexual preference P09; vaginismus NOS X04; organic impotence/sexual problems Y07',NULL,NULL,1,'P08');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SEXUAL PREFERENCE CONCERN','SEXUAL PREFERENCE CONCERN','F64, F65, F66','sexual problems with regard to preference not caused by any organic disorder or disease, but a reflection of the inability of a patient to participate in the sexual relationship s/he wants because of problems with sexual identity, preference or orientation',NULL,'reduced sexual desire P07; reduced sexual fulfilment P08',NULL,NULL,1,'P09');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'STAMMERING/STUTTERING/TIC','STAMMERING/STUTTERING/TIC','F95, F98.4, F98.5, F98.6','stammering and stuttering: disorder of speech characterized by frequent repetitions/prolongations of sounds, or by frequent hesitations/pauses disrupting speech',NULL,'tic douloureux N92',NULL,NULL,1,'P10');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'EATING PROBLEM IN CHILD','EATING PROBLEM IN CHILD','F98.2, F98.3',NULL,'feeding problem, problem with eating behaviour of child','anorexia nervosa P86; eating problem in adult T05',NULL,'Problems with behaviour of children are particularly difficult to classify, which is illustrated by the fact that they are distributed over four chapters of ICPC. Whether or not parents present these problems to a GP will reflect their ideas about the gradual differences between normal - though maybe annoying - behaviour, and behaviour that is considered worrying or ''pathological''',1,'P11');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'BEDWETTING/ENURESIS','BEDWETTING/ENURESIS','F98.0','involuntary voiding of urine by day/night not determined to be related to any organic disorder',NULL,'bedwetting due to organic disorder U04',NULL,'Problems with behaviour of children are particularly difficult to classify, which is illustrated by the fact that they are distributed over four chapters of ICPC. Whether or not parents present these problems to a GP will reflect their ideas about the gradual differences between normal - though maybe annoying - behaviour, and behaviour that is considered worrying or ''pathological''',1,'P12');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ENCOPRESIS/BOWEL TRAINING PROBLEM','ENCOPRESIS/BOWEL TRAINING PROBLEM','F98.1','encopresis requires repeated passage of usually well formed faeces in inappropriate places, considered abnormal in relation to age, and not caused by constipation/sphincter control disorder/another disease',NULL,NULL,NULL,NULL,1,'P13');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CHRONIC ALCOHOL ABUSE','CHRONIC ALCOHOL ABUSE','F10.1, F10.2, F10.3, F10.4, F10.5, F10.6, F10.7, F10.8, F10.9, G31.2','a disorder due to the use of alcohol resulting in one or more of the following: harmful use with clinically important damage to health; dependence syndrome; withdrawal state; psychotic disorder','alcohol brain syndrome, alcohol psychosis, alcoholism, delirium tremens',NULL,NULL,'Substance abuse problem definitions should take into account the considerable differences between countries and cultures. A doctor can decide to label an episode as ''chronic alcohol abuse''  without the patient''s agreement, and consequently also without the patient''s  willingness to any medical intervention.',1,'P15');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ACUTE ALCOHOL ABUSE','ACUTE ALCOHOL ABUSE','F10.0','a disorder due to the use of alcohol resulting in acute intoxication, with/without a background of chronic abuse','drunk',NULL,NULL,'A doctor can decide to label an episode as ''acute alcohol abuse'' without the  patient''s agreement, and consequently also without the patient''s  willingness to agree to any medical intervention.',1,'P16');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'TOBACCO ABUSE','TOBACCO ABUSE','F17','a disorder due to the use of tobacco resulting in one or more of the following: acute intoxication; harmful use with clinically important damage to health; dependence syndrome; withdrawal state','smoking problem',NULL,'risk factor NOS A23','Substance abuse problem definitions should take into account the considerable differences between countries and cultures. An alcohol dependent or heroin addicted patient needs medical attention, but the definitions of ''tobacco abuse'' are controversial. A physician can decide to label an episode as ''tobacco abuse'' without the patients agreement, and consequently also without the''patient''s willingness to agree to any medical intervention',1,'P17');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'MEDICATION ABUSE','MEDICATION ABUSE','F13, F19, F55',NULL,'abuse of any prescribed drug',NULL,NULL,'Substance abuse problem definitions should take into account the considerable differences between countries and cultures. Some patients request and use tranquillizers, sleeping tablets, anorectics or laxatives inappropriately and for too long. In these cases physicians can decide to label the episode as ''medicine abuse'' without the patients'' agreement, and consequently also without the patient''s willingness to agree to any medical intervention.',1,'P18');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'DRUG ABUSE','DRUG ABUSE','F11, F12, F13, F14, F15, F16, F18, F19','a disorder due to the use of a dependence producing psychoactive substance, resulting in one or more ofthe following conditions: acute intoxication; harmful use with clinically important damage to health; dependence syndrome; withdrawal state; psychotic disorder','addiction to drug, drug withdrawal',NULL,NULL,'Substance abuse problem definitions should take into account the considerable differences between countries and cultures. An alcohol dependent or heroin addicted patient needs medical attention, but the definitions of ''use of hashish'' are controversial. Doctors can decide to label an episode as ''drug abuse'' without the patient''s agreement, and consequently also without the patient''s willingness to agree to any medical intervention.',1,'P19');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'MEMORY DISTURBANCE','MEMORY DISTURBANCE','R41',NULL,'amnesia, disorientation, disturbance of concentration',NULL,NULL,NULL,1,'P20');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'transferred to P81',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'P21');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CHILD BEHAVIOUR SYMPTOM/COMPLAINT','CHILD BEHAVIOUR SYMPTOM/COMPLAINT','F91, F92, F93, F94, F98.8, F98.9, R62.0',NULL,'delayed milestones, jealousy, overactive child, speech delay, temper tantrum','behaviour symptom/complaint adolescent, adult P23, P80; concern about physical development/growth delay T10',NULL,NULL,1,'P22');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ADOLESCENT BEHAVIOUR SYMPTOM/COMPLAINT','ADOLESCENT BEHAVIOUR SYMPT/COMPL','F91, F92, F94, F98.8, F98.9',NULL,'delinquency','behaviour symptom/complaint child, adult P22, P80, P81',NULL,NULL,1,'P23');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SPECIFIC LEARNING PROBLEM','SPECIFIC LEARNING PROBLEM','F80, F81, F82, F83, R48','specific speech, language and learning problems with onset in childhood, together with an impairment of functions related to biological maturation of the central nervous system, and a steady course over time without spontaneous remissions or relapses, although the deficit may diminish as the child grows older','dyslexia','attention deficit disorder P81; mental retardation P85',NULL,NULL,1,'P24');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PHASE OF LIFE PROBLEM ADULT','PHASE OF LIFE PROBLEM ADULT','Z60.0',NULL,'empty nest syndrome, mid-life crisis, retirement problem','senility, feeling/behaving old P05; menopause X11',NULL,NULL,1,'P25');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF MENTAL DISORDER','FEAR OF MENTAL DISORDER','Z71.1','concern about/fear of mental disease in a patient without the disease/until the diagnosis is proven','concern about mental disease, fear of attempting suicide','if patient has the disease, code the disease',NULL,NULL,1,'P27');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LIMITED FUNCTION/DISABILITY (P)','LIMITED FUNCTION/DISABILITY (P)','Z73.6','limitation of function/disability due to a psychological problem','low self-esteem',NULL,NULL,'The COOP/WONCA Charts are suitable for documenting the patient''s functional status (see Chapter 8).',1,'P28');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PSYCHOLOGICAL SYMPTOM/COMPLAINT OTHER','PSYCHOLOGICAL SYMPT/COMPL OTHER','F50.8, F50.9, F63.3, F98.8, F98.9, R44, R45.7, R45.8, R46.0, R46.1, R46.2, R46.3, R46.4, R46.5, R46.6, R46.7, Z64.2, Z64.3, Z73.0, Z73.1, Z73.3',NULL,'delusions, eating disorders NOS, hallucinations, multiple psychological symptoms/complaints, poor hygiene, strange behaviour, suspiciousness','tension headache N95',NULL,NULL,1,'P29');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation complete','Medical examin/health eval complete',NULL,NULL,NULL,NULL,NULL,NULL,1,'P30');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation partial','Medical examin/health eval partial',NULL,NULL,NULL,NULL,NULL,NULL,1,'P31');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Sensitivity test','Sensitivity test',NULL,NULL,NULL,NULL,NULL,NULL,1,'P32');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Microbiological/immunological test','Microbiological/immunological test',NULL,NULL,NULL,NULL,NULL,NULL,1,'P33');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Blood test','Blood test',NULL,NULL,NULL,NULL,NULL,NULL,1,'P34');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Urine test','Urine test',NULL,NULL,NULL,NULL,NULL,NULL,1,'P35');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Faeces test','Faeces test',NULL,NULL,NULL,NULL,NULL,NULL,1,'P36');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Histological/exfoliative cytology','Histological/exfoliative cytology',NULL,NULL,NULL,NULL,NULL,NULL,1,'P37');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other laboratory test NEC','Other laboratory test NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'P38');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Physical function test','Physical function test',NULL,NULL,NULL,NULL,NULL,NULL,1,'P39');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic endoscopy','Diagnostic endoscopy',NULL,NULL,NULL,NULL,NULL,NULL,1,'P40');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic radiology/imaging','Diagnostic radiology/imaging',NULL,NULL,NULL,NULL,NULL,NULL,1,'P41');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Electrical tracing','Electrical tracing',NULL,NULL,NULL,NULL,NULL,NULL,1,'P42');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other diagnostic procedure','Other diagnostic procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'P43');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Preventive immunization/medication','Preventive immunization/medication',NULL,NULL,NULL,NULL,NULL,NULL,1,'P44');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Observation/health education/advice/diet','Observ/health educat/advice/diet',NULL,NULL,NULL,NULL,NULL,NULL,1,'P45');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with primary care provider','Consultation primary care provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'P46');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with specialist','Consultation with specialist',NULL,NULL,NULL,NULL,NULL,NULL,1,'P47');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Clarification/discussion of patient''s RFE/demand','Clarification/discussion RFE/demand',NULL,NULL,NULL,NULL,NULL,NULL,1,'P48');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other preventive procedure','Other preventive procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'P49');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Medication/prescription/renewal/injection','Medication/prescr/renewal/inject',NULL,NULL,NULL,NULL,NULL,NULL,1,'P50');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Incision/drainage/flushing/aspiration/removal body fluid (excl. catheterisation - 53)\n
 (excl. catheterisation - 53)','I&D/flush/aspiration (excl cath -53)',NULL,NULL,NULL,NULL,NULL,NULL,1,'P51');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Excision/removal tissue/biopsy/destruction/debridement/cauterization','Exc/remov/biopsy/destruc/debrid/caut',NULL,NULL,NULL,NULL,NULL,NULL,1,'P52');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Instrumentation/catheterization/intubation/dilation','Instrument/catheter/intubate/dilate',NULL,NULL,NULL,NULL,NULL,NULL,1,'P53');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Repair/fixation-suture/cast/prosthetic device (apply/remove)','Repair/fix-suture/cast/prosth device',NULL,NULL,NULL,NULL,NULL,NULL,1,'P54');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Local injection/infiltration','Local injection/infiltration',NULL,NULL,NULL,NULL,NULL,NULL,1,'P55');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Dressing/pressure/compression/tamponade','Dressing/pressure/compress/tamponade',NULL,NULL,NULL,NULL,NULL,NULL,1,'P56');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Physical medicine/rehabilitation','Physical medicine/rehabilitation',NULL,NULL,NULL,NULL,NULL,NULL,1,'P57');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Therapeutic counselling/listening','Therapeutic counselling/listening',NULL,NULL,NULL,NULL,NULL,NULL,1,'P58');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Other therapeutic procedure/minor surgery NEC','Other therap proced/minor surg NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'P59');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result test/procedure','Result test/procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'P60');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result examination/test/record/letter from other provider','Result exam/test/lett oth provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'P61');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (5,'Administrative procedure','Administrative procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'P62');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Follow-up encounter unspecified','Follow-up encounter unspecified',NULL,NULL,NULL,NULL,NULL,NULL,1,'P63');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by provider','Encounter/prob initiated by provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'P64');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by other than patient/provider','Enc/prob init by other than pt/prov',NULL,NULL,NULL,NULL,NULL,NULL,1,'P65');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to physician/specialist/clinic/hospital','Referral to MD/specialist/clin/hosp',NULL,NULL,NULL,NULL,NULL,NULL,1,'P67');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other referral NEC','Other referral NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'P68');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other reason for encounter NEC','Other reason for encounter NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'P69');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'DEMENTIA','DEMENTIA','F00, F01, F02, F03, G30','a syndrome due to a disease of the brain, usually of a chronic and/or progressive nature, with clinically significant disturbance of multiple higher cortical functions (memory, thinking, orientation, comprehension), together with intact consciousness','Alzheimer''s disease, senile dementia',NULL,'senility P05; other psychological symptoms P29',NULL,1,'P70');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ORGANIC PSYCHOSIS OTHER','ORGANIC PSYCHOSIS OTHER','F04, F05, F06, F07, F09','organic psychiatric disorders as a diagnosis require psychological syndromes, patterns or behaviour due to organic disease','delirium','psychosis caused by alcohol P15; unspecified psychosis P98',NULL,NULL,1,'P71');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SCHIZOPHRENIA','SCHIZOPHRENIA','F20, F21, F22, F24, F25, F28, F29','fundamental and characteristic distortions of thinking, perception and affect that are inappropriate or blunted (eg. thought-echo, -insertion, -withdrawal, delusional perceptions, hallucinatory voices, delusions of control), together with a clear consciousness and unaffected intellectual capacity.','all types of schizophrenia, paranoia','acute/transient psychosis P98','psychosis NOS P98',NULL,1,'P72');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'AFFECTIVE PSYCHOSIS','AFFECTIVE PSYCHOSIS','F30, F31, F34.0','a fundamental disturbance in affect and mood, alternately being elated and depressed (with/without associated anxiety). In manic disorder mood, energy and activity are simultaneously elevated. In bipolar disease, at least two periods of disturbed mood, shifting from elevated to lowered are observed','bipolar disorder, hypomania, mania, manic depression','depression P76','psychosis NOS P98',NULL,1,'P73');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ANXIETY DISORDER/ANXIETY STATE','ANXIETY DISORDER/ANXIETY STATE','F41.0, F41.1, F41.3, F41.8, F41.9','clinically significant anxiety that is not restricted to any particular environmental situation. It manifests as a panic disorder (recurrent attacks of severe anxiety not restricted to any particular situation, with or without physical symptoms) or as a disorder in which generalized and persistent anxiety, not related to any particular situation, occurs with variable physical symptoms','anxiety neurosis, panic disorder','anxiety with depression P76; anxiety NOS P01','feeling anxious/nervous/tense P01',NULL,1,'P74');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SOMATIZATION DISORDER','SOMATIZATION DISORDER','F44, F45.0, F45.1, F45.2','somatization disorder is characterized by a preoccupation with and repeated presentations of physical symptoms and complaints together with persistent requests for medical investigations in spite of repeated negative findings and reassurances by doctors. For this diagnosis, the presentation of multiple, recurrent and frequently changing physical symptoms presented to the family physician over a period of at least one year is required. Hypochondriacal disorder requires a persistent preoccupation with either the physical appearance or with the possibility of having a serious disease, together with persistent somatic complaints over a period of at least one year, in spite of repeated negative findings and reassurances by doctors','conversion disorder, hypochondriacal disorder, hysteria, pseudocyesis',NULL,NULL,'Somatization is the repeated presentation of physical symptoms and complaints suggesting physical disorders for which no demonstrable organic findings or physiological mechanisms are responsible, and for which there is positive evidence that they are linked to psychological factors while the patient does not experience a sense of controlling the production of these symptoms in dealing with the psychological factors. Physical symptoms and complaints including pain which are presented as if they were due to a physical disorder of a system/organ under autonomic nervous control, or which consist of persistent, severe/distressing pain which cannot be explained by a physiological process/disorder, are coded with a symptom/complaint diagnosis representing the physical aspect, and - if possible - with a code representing the emotional or psychosocial problem with which it is associated. The definition of somatization disorder in ICD-10 (a minimum of 2 years) is too stringent for use in general pract.',1,'P75');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'DEPRESSIVE DISORDER','DEPRESSIVE DISORDER','F32, F33, F34.1, F34.8, F34.9, F38, F39, F41.2, F53.0','fundamental disturbance in affect and mood towards depression. Mood, energy and activity are simultaneously lowered, together with an impaired capacity for enjoyment, interest and concentration. Sleep and appetite are usually disturbed and self-esteem and confidence are decreased','depressive neurosis/psychosis, mixed anxiety and depression, reactive depression, puerperal/postnatal depression','acute stress reaction P02','feeling depressed P03',NULL,1,'P76');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SUICIDE/SUICIDE ATTEMPT','SUICIDE/SUICIDE ATTEMPT','F99',NULL,'suicide gesture, successful attempt (double code with A96)','fear of committing suicide P27',NULL,NULL,1,'P77');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'NEURAESTHENIA/SURMENAGE','NEURAESTHENIA/SURMENAGE','F48.0','increased fatigueability with unpleasant associations, difficulties in concentration and a persistent decrease in performance and coping efficiency; the feeling of physical weakness and exhaustion after mental effort or after a minimal physical effort is often accompanied by muscular pain and an inability to relax',NULL,NULL,'fatigue/postviral fatigue/chronic fatigue syndrome A04',NULL,1,'P78');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PHOBIA/COMPULSIVE DISORDER','PHOBIA/COMPULSIVE DISORDER','F40, F42','phobic anxiety disorder requires outspoken anxiety, evoked only in well defined situations that are not generally considered dangerous: the patient tries to avoid these situations, or endures them with dread. Obsessive compulsive disorder requires distressing and recurrent obsessional thoughts/acts recognized by the patient as his/her own; compulsive stereotyped behaviours are repeated again and again, intended to prevent some objective unlikely event and recognized by the patient as pointless and ineffective',NULL,NULL,NULL,NULL,1,'P79');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PERSONALITY DISORDER','PERSONALITY DISORDER','F60, F61, F62, F63.0, F63.1, F63.2, F63.8, F63.9, F68, F69','persistent and clinically important conditions and behaviour patterns in an individual''s lifestyle and mode of relating to him/herself and others, reflecting significant/extreme deviations from the way an average individual in a given culture perceives, feels and behaves. This pattern is deeply ingrained and longlasting','psychopathy, compensation neurosis, Munchhausen''s syndrome, adult behaviour disorder',NULL,NULL,NULL,1,'P80');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HYPERKINETIC DISORDER','HYPERKINETIC DISORDER','F90','early onset of a lack of persistence in activities requiring cognitive involvement, with a tendency to move from one activity to another without completing any one, with disorganised and ill-regulated behaviour, and excessive activity','attention deficit disorder (ADD), hyperactivity','hyperkinetic disorder with adolescent onset P23; learning disorder P24','overactive child P22',NULL,1,'P81');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'POST-TRAUMATIC STRESS DISORDER','POST-TRAUMATIC STRESS DISORDER','F43.1','a stressful event followed by a major state of distress and disturbance, with a delayed or protracted reaction, flashbacks, nightmares, emotional blunting and anhedonia interfering with social functioning and performance, and including depressed mood, anxiety, worry and feeling unable to cope, persistent over time','persistent adjustment disorder',NULL,'feeling anxious P01; acute stress reaction P02; feeling depressed P03',NULL,1,'P82');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MENTAL RETARDATION','MENTAL RETARDATION','F70, F71, F72, F73, F78, F79','arrested/incomplete development of the mind with impairment of skills during the developmental period, and a low overall level of intelligence, with/without impairment of behaviour.',NULL,'mental retardation due to congenital anomaly A90',NULL,NULL,1,'P85');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ANOREXIA NERVOSA/BULIMIA','ANOREXIA NERVOSA/BULIMIA','F50.0, F50.1, F50.2, F50.3, F50.4','Anorexia nervosa: deliberate weight loss induced and sustained by the patient, associated with an intensive and overvalued dread of fatness and flabbiness of body contures.  \n
Bulimia: repeated bouts of overeating and an excessive preoccupation with body weight, leading to a pattern of overeating followed by induced vomiting or use of purgatives',NULL,NULL,'eating disorder, food refusal P11, P29; feeding problem T04, T05',NULL,1,'P86');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PSYCHOSIS NOS/OTHER','PSYCHOSIS NOS/OTHER','F23, F53.1',NULL,'acute/ transient/reactive/puerperal psychosis',NULL,NULL,NULL,1,'P98');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PSYCHOLOGICAL DISORDERS OTHER','PSYCHOLOGICAL DISORDERS OTHER','F48.1, F48.8, F48.9, F53.8, F53.9, F54, F59, F84, F88, F89, F99',NULL,'autism, neurosis NOS',NULL,NULL,NULL,1,'P99');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (NULL,'RESPIRATORY','RESPIRATORY',NULL,NULL,NULL,NULL,NULL,NULL,1,'R');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PAIN RESPIRATORY SYSTEM','PAIN RESPIRATORY SYSTEM','R07.1',NULL,'painful respiration, pleuritic pain, pleurodynia','chest pain A11; musculoskeletal chest pain L04; nose pain R08; sinus pain R09; sore throat R21; chest tightness R29; pleurisy R82',NULL,NULL,1,'R01');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SHORTNESS OF BREATH/DYSPNOEA','SHORTNESS OF BREATH/DYSPNOEA','R06.0',NULL,'orthopnoea','wheezing R03; stridor R04; hyperventilation R98',NULL,NULL,1,'R02');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'WHEEZING','WHEEZING','R06.2',NULL,'inspiratory wheeze, rhonchi','dyspnoea R02; stridor R04; hyperventilation R98',NULL,NULL,1,'R03');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'BREATHING PROBLEM OTHER','BREATHING PROBLEM OTHER','R06.1, R06.3, R06.5, R06.8',NULL,'abnormal breathing, apnoea, holding breath, respiratory distress, snoring, stridor, tachypnoea','sleep apnoea P06; respiratory pain R01; dyspnoea R02; wheezing R03; cough R05; hyperventilation R98',NULL,NULL,1,'R04');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'COUGH','COUGH','R05',NULL,'cough (dry or moist)','abnormal sputum/phlegm R25',NULL,NULL,1,'R05');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'NOSE BLEED/EPISTAXIS','NOSE BLEED/EPISTAXIS','R04.0',NULL,NULL,NULL,NULL,NULL,1,'R06');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SNEEZING/NASAL CONGESTION','SNEEZING/NASAL CONGESTION','R06.7',NULL,'blocked nose, rhinorrhea, running nose',NULL,NULL,NULL,1,'R07');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'NOSE SYMPTOM/COMPLAINT OTHER','NOSE SYMPTOM/COMPLAINT OTHER','J34.8',NULL,'pain in nose, post-nasal drip, prominent nose, red nose','anosmia N16; epistaxis R06; blocked nose/sneezing R07; complaint of sinuses R09; rhinophyma S99',NULL,NULL,1,'R08');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SINUS SYMPTOM/COMPLAINT','SINUS SYMPTOM/COMPLAINT','J34.8',NULL,'blocked sinus, congested sinus, pain/pressure in sinus','headache N01; face pain N03; nasal congestion R07',NULL,NULL,1,'R09');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'THROAT SYMPTOM/COMPLAINT','THROAT SYMPTOM/COMPLAINT','R07.0, R09.8',NULL,'dry/inflamed/red/sore throat, large tonsils, lump in throat, tonsillar pain','voice symptoms R23; tonsillar hypertrophy R90',NULL,NULL,1,'R21');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'VOICE SYMPTOM/COMPLAINT','VOICE SYMPTOM/COMPLAINT','R49',NULL,'absence of voice, aphonia, hoarseness','neurological disorder of speech N19; stammering/stuttering/tic P10; sore throat R21',NULL,NULL,1,'R23');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'HAEMOPTYSIS','HAEMOPTYSIS','R04.2',NULL,'coughing blood',NULL,NULL,NULL,1,'R24');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SPUTUM/PHLEGM ABNORMAL','SPUTUM/PHLEGM ABNORMAL','R09.3',NULL,NULL,'cough with sputum R05; haemoptysis R24',NULL,NULL,1,'R25');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF CANCER OF RESPIRATORY SYSTEM','FEAR  CANCER  RESPIRATORY SYSTEM','Z71.1','concern about/fear of cancer of respiratory system in a patient without the disease/until the diagnosis is proven',NULL,'if patient has the disease, code the disease',NULL,NULL,1,'R26');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF RESPIRATORY DISEASE OTHER','FEAR OF RESPIRATORY DISEASE OTHER','Z71.1','concern about/fear of other respiratory disease in a patient without the disease/until the diagnosis is proven',NULL,'fear of respiratory cancer R26; if patient has the disease, code the disease',NULL,NULL,1,'R27');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LIMITED FUNCTION/DISABILITY (R)','LIMITED FUNCTION/DISABILITY (R)','Z73.6, Z93.0, Z99.1','limitation of function/disability due to a respiratory problem','disability due to hypoxia, hypercapnia, reduced lung function, respiratory disease, disease of nose/larynx/throat','dyspnoea R02; wheezing R03',NULL,'The COOP/WONCA Charts are suitable for documenting the patient''s functional status (see Chapter 8).',1,'R28');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'RESPIRATORY SYMPTOM/COMPLAINT OTHER','RESPIRATORY SYMPTOM/COMPLAINT OTHER','R04.1, R04.8, R04.9, R06.6, R09.0, R09.2, R09.8',NULL,'chest tightness, fluid on lung, hiccough, lung congestion',NULL,NULL,NULL,1,'R29');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation complete','Medical examin/health eval complete',NULL,NULL,NULL,NULL,NULL,NULL,1,'R30');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation partial','Medical examin/health eval partial',NULL,NULL,NULL,NULL,NULL,NULL,1,'R31');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Sensitivity test','Sensitivity test',NULL,NULL,NULL,NULL,NULL,NULL,1,'R32');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Microbiological/immunological test','Microbiological/immunological test',NULL,NULL,NULL,NULL,NULL,NULL,1,'R33');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Blood test','Blood test',NULL,NULL,NULL,NULL,NULL,NULL,1,'R34');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Urine test','Urine test',NULL,NULL,NULL,NULL,NULL,NULL,1,'R35');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Faeces test','Faeces test',NULL,NULL,NULL,NULL,NULL,NULL,1,'R36');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Histological/exfoliative cytology','Histological/exfoliative cytology',NULL,NULL,NULL,NULL,NULL,NULL,1,'R37');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other laboratory test NEC','Other laboratory test NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'R38');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Physical function test','Physical function test',NULL,NULL,NULL,NULL,NULL,NULL,1,'R39');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic endoscopy','Diagnostic endoscopy',NULL,NULL,NULL,NULL,NULL,NULL,1,'R40');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic radiology/imaging','Diagnostic radiology/imaging',NULL,NULL,NULL,NULL,NULL,NULL,1,'R41');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Electrical tracing','Electrical tracing',NULL,NULL,NULL,NULL,NULL,NULL,1,'R42');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other diagnostic procedure','Other diagnostic procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'R43');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Preventive immunization/medication','Preventive immunization/medication',NULL,NULL,NULL,NULL,NULL,NULL,1,'R44');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Observation/health education/advice/diet','Observ/health educat/advice/diet',NULL,NULL,NULL,NULL,NULL,NULL,1,'R45');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with primary care provider','Consultation primary care provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'R46');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with specialist','Consultation with specialist',NULL,NULL,NULL,NULL,NULL,NULL,1,'R47');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Clarification/discussion of patient''s RFE/demand','Clarification/discussion RFE/demand',NULL,NULL,NULL,NULL,NULL,NULL,1,'R48');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other preventive procedure','Other preventive procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'R49');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Medication/prescription/renewal/injection','Medication/prescr/renewal/inject',NULL,NULL,NULL,NULL,NULL,NULL,1,'R50');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Incision/drainage/flushing/aspiration/removal body fluid (excl. catheterisation - 53)\n
 (excl. catheterisation - 53)','I&D/flush/aspiration (excl cath -53)',NULL,NULL,NULL,NULL,NULL,NULL,1,'R51');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Excision/removal tissue/biopsy/destruction/debridement/cauterization','Exc/remov/biopsy/destruc/debrid/caut',NULL,NULL,NULL,NULL,NULL,NULL,1,'R52');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Instrumentation/catheterization/intubation/dilation','Instrument/catheter/intubate/dilate',NULL,NULL,NULL,NULL,NULL,NULL,1,'R53');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Repair/fixation-suture/cast/prosthetic device (apply/remove)','Repair/fix-suture/cast/prosth device',NULL,NULL,NULL,NULL,NULL,NULL,1,'R54');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Local injection/infiltration','Local injection/infiltration',NULL,NULL,NULL,NULL,NULL,NULL,1,'R55');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Dressing/pressure/compression/tamponade','Dressing/pressure/compress/tamponade',NULL,NULL,NULL,NULL,NULL,NULL,1,'R56');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Physical medicine/rehabilitation','Physical medicine/rehabilitation',NULL,NULL,NULL,NULL,NULL,NULL,1,'R57');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Therapeutic counselling/listening','Therapeutic counselling/listening',NULL,NULL,NULL,NULL,NULL,NULL,1,'R58');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Other therapeutic procedure/minor surgery NEC','Other therap proced/minor surg NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'R59');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result test/procedure','Result test/procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'R60');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result examination/test/record/letter from other provider','Result exam/test/lett oth provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'R61');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (5,'Administrative procedure','Administrative procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'R62');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Follow-up encounter unspecified','Follow-up encounter unspecified',NULL,NULL,NULL,NULL,NULL,NULL,1,'R63');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by provider','Encounter/prob initiated by provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'R64');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by other than patient/provider','Enc/prob init by other than pt/prov',NULL,NULL,NULL,NULL,NULL,NULL,1,'R65');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to other provider/nurse/therapist/social worker','Referral to non-MD provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'R66');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to physician/specialist/clinic/hospital','Referral to MD/specialist/clin/hosp',NULL,NULL,NULL,NULL,NULL,NULL,1,'R67');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other referral NEC','Other referral NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'R68');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other reason for encounter NEC','Other reason for encounter NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'R69');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'deleted, included with A70',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'R70');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'WHOOPING COUGH','WHOOPING COUGH','A37','respiratory infection with a characteristic staccato paroxysmal cough ending with a high-pitched inspiratory whoop; or respiratory infection with cough of at least three weeks duration in contact with known pertussis; or demonstration of Bordetella pertussis or parapertussis','parapertussis, pertussis','croup R77','cough R05; upper respiratory infection R74',NULL,1,'R71');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'STREP THROAT','STREP THROAT','J02.0, J03.0','acute inflammation of the throat, plus demonstration of beta-haemolytic streptococci','proven streptococcal pharyngitis/tonsillitis','scarlet fever A78; erysipelas/strep skin infection S76','tonsillitis R76',NULL,1,'R72');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BOIL/ABSCESS NOSE','BOIL/ABSCESS NOSE','J34.0',NULL,'localized nose infection','acute sinusitis R75',NULL,NULL,1,'R73');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'UPPER RESPIRATORY INFECTION ACUTE','UPPER RESPIRATORY INFECTION ACUTE','B00.2, B08.5, J00, J02.8, J02.9, J06','evidence of acute inflammation of nasal or pharyngeal mucosa with absence of criteria for more specifically defined acute respiratory infection classified in this section','acute rhinitis, coryza, head cold, nasopharyngitis, pharyngitis, URTI/URI','measles A71; infectious mononucleosis A75; viral pharyngoconjunctivitis F70; sinusitis R75; tonsillitis/quinsy R76; laryngitis/croup R77; influenza R80; chronic pharyngitis R83; allergic rhinitis R97',NULL,NULL,1,'R74');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SINUSITIS ACUTE/CHRONIC','SINUSITIS ACUTE/CHRONIC','J01, J32','purulent nasal/post-nasal discharge, or previous medically treated episodes of sinusitis, plus tenderness over one/more sinuses, or deep-seated aching facial pain aggravated by dependency of head, or opacity on transillumination; or imaging evidence of sinusitis; or pus obtained from the sinus','sinusitis affecting any paranasal sinus',NULL,'headache N01; face pain N03; upper respiratory tract infection R74',NULL,1,'R75');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'TONSILLITIS ACUTE','TONSILLITIS ACUTE','J03.8, J03.9, J36','sore throat or fever with reddening of tonsil(s) more than the posterior pharyngeal wall, and either pus on swollen tonsil(s) or enlarged tender regional lymph nodes','peritonsillar abscess, quinsy','infectious mononucleosis A75; strep throat R72; diphtheria R83; hypertrophy/chronic infection of tonsils R90','acute upper respiratory tract infection R74',NULL,1,'R76');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'LARYNGITIS/TRACHEITIS ACUTE','LARYNGITIS/TRACHEITIS ACUTE','J04, J05.0','hoarseness/stridor with/without respiratory distress, or deep dry painful cough (barking in children), and normal chest signs','croup','laryngotracheobronchitis R78; epiglottitis R83','upper respiratory tract infection R74',NULL,1,'R77');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ACUTE BRONCHITIS/BRONCHIOLITIS','ACUTE BRONCHITIS/BRONCHIOLITIS','J20, J21, J22, J40','in children and adults: cough and fever with scattered or generalized abnormal chest signs: wheeze, coarse rales, rhonchi or moist sounds;\n
in infants (bronchiolitis): dyspnoea and hyperinflation','acute lower respiratory infection NOS, bronchitis NOS, chest infection NOS, laryngotracheobronchitis, tracheobronchitis','influenza R80; chronic bronchitis R91; allergic bronchitis R96','wheezing R03; cough R05; upper respiratory tract infection R74',NULL,1,'R78');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CHRONIC BRONCHITIS','CHRONIC BRONCHITIS','J41, J42','cough with sputum on most days for at least 3 months in each of at least 2 years; and scattered rales/rhonchi on auscultation of the chest during these episodes',NULL,'emphysema/chronic obstructive pulmonary (lung, airways) disease R95; bronchiectasis R99','cough R05; abnormal sputum/phlegm R25; bronchitis NOS R78',NULL,1,'R79');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'INFLUENZA','INFLUENZA','J10.1, J10.8, J11.1, J11.8','myalgia and cough without abnormal respiratory physical signs other than inflammation of nasal mucous membrane and throat, plus three or more of the following: sudden onset (within 12 hours); rigors/chills/fever; prostration and weakness; influenza in close contacts; influenza epidemic; or viral culture/serological evidence of influenza virus infection','influenza-like illness, para-influenza','gastric flu D70; influenza pneumonia R81','fever A03; virus infection NOS A77; upper respiratory tract infection R74',NULL,1,'R80');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PNEUMONIA','PNEUMONIA','A48.1, J10.0, J11.0, J12, J13, J14, J15, J16, J17, J18','evidence of pulmonary consolidation','bacterial/viral pneumonia, bronchopneumonia, influenzal pneumonia, Legionnaire''s disease, pneumonitis','aspiration pneumonia R99','cough R05; acute bronchitis R78',NULL,1,'R81');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PLEURISY/PLEURAL EFFUSION','PLEURISY/PLEURAL EFFUSION','J90, J91, J94, R09.1','clinical evidence of pleural exudate; or pleuritic pain accompanied by pleural friction rub; or investigative evidence of inflammatory pleural exudate','pleural inflammatory exudate, pleuritis','tuberculosis A70; pneumonia R81; malignant effusion to be coded to origin of malignancy','pleuritic pain R01',NULL,1,'R82');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'RESPIRATORY INFECTION OTHER','RESPIRATORY INFECTION OTHER','A36, B37.1, B44, B58.3, J05.1, J31, J37, J85, J86',NULL,'chronic nasopharyngitis, chronic pharyngitis, chronic rhinitis NOS, diphtheria, empyema, epiglottitis, fungal respiratory infection, lung abscess, protozoal infection (without pneumonia)','cystic fibrosis T99',NULL,NULL,1,'R83');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM BRONCHUS/LUNG','MALIGNANT NEOPLASM BRONCHUS/LUNG','C33, C34','characteristic histologic appearance','malignancy of trachea/bronchus/lung','malignancy of unknown site A79; a secondary malignancy from known site to be coded to site','unspecified respiratory neoplasm R92',NULL,1,'R84');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM RESPIRATORY OTHER','MALIGNANT NEOPL RESPIRATORY OTHER','C09, C10, C11, C12, C13, C14.0, C14.2, C30.0, C31, C32, C38.4, C39, C45.0','characteristic histologic appearance','malignancy of larynx/mediastinum/nose/pharynx/pleura/sinus, mesothelioma','Hodgkin''s disease B72, malignancy of trachea/bronchus/lung R84','unspecified respiratory neoplasm R92',NULL,1,'R85');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BENIGN NEOPLASM RESPIRATORY','BENIGN NEOPLASM RESPIRATORY','D14, D19','characteristic clinical or histologic appearance',NULL,'unspecified respiratory neoplasm R92; nasal polyp R99','unspecified respiratory neoplasm R92',NULL,1,'R86');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'FOREIGN BODY NOSE/LARYNX/BRONCHUS','FOREIGN BODY NOSE/LARYNX/BRONCHUS','T17','visualization of foreign body directly/endoscopically/using imaging','foreign body in lung','drowning A88; foreign body lodged in oesophagus D79; foreign body in ear H76; aspiration pneumonia R99','other complaint of respiratory system R29',NULL,1,'R87');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'INJURY RESPIRATORY OTHER','INJURY RESPIRATORY OTHER','S00.3, S03.1, S27, T27, T70.1',NULL,'injury/trauma to nose/respiratory system','drowning A88; fractured nose L76; foreign body in respiratory system R87',NULL,NULL,1,'R88');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONGENITAL ANOMALY RESPIRATORY','CONGENITAL ANOMALY RESPIRATORY','Q30, Q31, Q32, Q33, Q34',NULL,'congenital abnormality of nose/pharynx/trachea/larynx/bronchi/lungs/pleura','cleft lip/palate D81; cystic fibrosis T99',NULL,NULL,1,'R89');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HYPERTROPHY TONSILS/ADENOIDS','HYPERTROPHY TONSILS/ADENOIDS','J35',NULL,'chronic tonsillitis','acute tonsillitis R76; allergic rhinitis R97',NULL,NULL,1,'R90');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'moved to R79',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'R91');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'NEOPLASM RESPIRATORY UNSPECIFIED','NEOPLASM RESPIRATORY UNSPECIFIED','D02, D38',NULL,'respiratory neoplasm unspecified as benign or malignant/when histology is not available','secondary neoplasm unknown site A79; malignant respiratory neoplasm R84, R85; benign respiratory neoplasm R86',NULL,NULL,1,'R92');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'deleted, included with R82',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'R93');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CHRONIC OBSTRUCTIVE PULMONARY DISEASE','CHRON OBSTRUCTIVE PULMONARY DISEASE','J43, J44','objective evidence of airway obstruction, not/only partially relieved by bronchodilators','chronic obstructive airways (COAD), lung (COLD), pulmonary (COPD) disease, chronic airways limitation (CAL), emphysema','chronic bronchitis R79; asthma R96; bronchiectasis R99; cystic fibrosis T99','other breathing problem R04',NULL,1,'R95');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ASTHMA','ASTHMA','J45, J46','recurrent episodes of reversible acute bronchial obstruction with wheeze/dry cough; or diagnostic test meeting currently accepted criteria for asthma','reactive airways disease, wheezy bronchitis','bronchiolitis R78; chronic bronchitis R79; emphysema R95','wheezing R03; cough R05',NULL,1,'R96');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ALLERGIC RHINITIS','ALLERGIC RHINITIS','J30',NULL,'hay fever, nasal allergy, vasomotor rhinitis','upper respiratory tract infection R74, chronic rhinitis NOS R83',NULL,NULL,1,'R97');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HYPERVENTILATION SYNDROME','HYPERVENTILATION SYNDROME','R06.4','symptoms related to hyperventilation and relieved by rebreathing expired air',NULL,NULL,'other breathing problem R04',NULL,1,'R98');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'RESPIRATORY DISEASE OTHER','RESPIRATORY DISEASE OTHER','J33, J34.1, J34.2, J34.3, J34.8, J38, J39, J47, J60, J61, J62, J63, J64, J65, J66, J67, J68, J69, J70, J80, J81, J82, J84, J92, J93, J96, J98, J99, Z90.2, Z94.2, Z94.3',NULL,'aspiration pneumonia, bronchiectasis, deviated nasal septum, lung complication of other disease, mediastinal disease, nasal polyp, other disease of larynx; pneumoconiosis, pneumothorax, pneumonitis due to allergy/chemicals/dust/ fumes/mould, pulmonary collapse, respiratory failure',NULL,NULL,NULL,1,'R99');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (NULL,'SKIN','SKIN',NULL,NULL,NULL,NULL,NULL,NULL,1,'S');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PAIN/TENDERNESS OF SKIN','PAIN/TENDERNESS OF SKIN','R20.8, R52',NULL,'burning sensation, painful lesion or rash, soreness','tingling fingers/feet/toes N05; other sensation disturbance N06',NULL,NULL,1,'S01');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PRURITUS','PRURITUS','L29.8, L29.9',NULL,'skin irritation','anogenital pruritus D05; dermatitis artefacta S99; vulval pruritus X16; nipple pruritus X20',NULL,NULL,1,'S02');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'WARTS','WARTS','B07',NULL,'verrucae','molluscum contagiosum S95; genital warts X91, Y76',NULL,NULL,1,'S03');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LUMP/SWELLING LOCALIZED','LUMP/SWELLING LOCALIZED','R22',NULL,'papule','insect bite S12; breast lump X19, Y16',NULL,NULL,1,'S04');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LUMPS/SWELLINGS GENERALIZED','LUMPS/SWELLINGS GENERALIZED','R21',NULL,'papules/lumps/swellings in multiple sites','swollen ankles/oedema K07',NULL,NULL,1,'S05');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'RASH LOCALIZED','RASH LOCALIZED','L53.9, R21',NULL,'blotch, erythema, redness','localized lump/swelling S04',NULL,NULL,1,'S06');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'RASH GENERALIZED','RASH GENERALIZED','L53.9, R21',NULL,'blotches/erythema/redness occurring in multiple sites','other viral exanthem A76; generalized lumps/swellings skin S05',NULL,NULL,1,'S07');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SKIN COLOUR CHANGE','SKIN COLOUR CHANGE','L81.0, L81.1, L81.2, L81.3, R23.0, R23.1, R23.2',NULL,'''circles under eyes'', cyanosis, flushing, freckles, pallor, pigmentation','bruise S16; vitiligo S99',NULL,NULL,1,'S08');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'INFECTED FINGER/TOE','INFECTED FINGER/TOE','L03.0',NULL,'paronychia','post-traumatic infection finger/toe S11; tinea S74; monilia/candida S75',NULL,NULL,1,'S09');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'BOIL/CARBUNCLE','BOIL/CARBUNCLE','L02',NULL,'abscess, folliculitis, furuncle','lymphadenitis B70; perianal boil D95; external auditory meatus H70; boil of nose R73; infected finger/toe S09; wound infection S11; erysipelas S76; pilonidal abscess S85; hydradenitis S92; boil female external genitalia X99; boil male external genitalia Y99',NULL,NULL,1,'S10');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SKIN INFECTION POST-TRAUMATIC','SKIN INFECTION POST-TRAUMATIC','T79.3',NULL,'infected post-traumatic wound/bite','surgical wound infection A87; erysipelas, pyoderma S76; impetigo S84',NULL,NULL,1,'S11');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'INSECT BITE/STING','INSECT BITE/STING','T14.0',NULL,NULL,'toxic effects non-medical substance A86; infected bite S11; scabies S72; pediculosis S73',NULL,NULL,1,'S12');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ANIMAL/HUMAN BITE','ANIMAL/HUMAN BITE','T14.1',NULL,NULL,'toxic effects non-medical substance A86; infected bite S11',NULL,NULL,1,'S13');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'BURN/SCALD','BURN/SCALD','T20, T21, T22, T23, T24, T25, T30, T31, T32',NULL,'burn/scald of all degrees, external chemical burn','sunburn S80',NULL,NULL,1,'S14');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FOREIGN BODY IN SKIN','FOREIGN BODY IN SKIN','T14.0, T14.1',NULL,'foreign body under nail',NULL,NULL,NULL,1,'S15');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'BRUISE/CONTUSION','BRUISE/CONTUSION','S00.0, S00.7, S00.8, S00.9, S10, S20, S30.0, S30.1, S40, S50, S60, S70, S80, S90, T14.0','bruise/contusion with intact skin surface','ecchymosis, haematoma','bruise with broken skin S17',NULL,NULL,1,'S16');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ABRASION/SCRATCH/BLISTER','ABRASION/SCRATCH/BLISTER','S00.0, S00.7, S00.8, S00.9, S10, S20, S30.7, S30.8, S30.9, S40, S50, S60, S70, S80, S90, T14.0',NULL,'bruise if skin broken, graze',NULL,NULL,NULL,1,'S17');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LACERATION/CUT','LACERATION/CUT','S00.0, S00.7, S00.8, S00.9, S01.0, S01.2, S01.4, S01.7, S01.8, S01.9, S11, S21, S31.0, S31.1, S31.8, S41, S51, S61, S71, S81, S91, T14.1',NULL,'laceration/cut of skin/subcutaneous tissues','bite S13',NULL,NULL,1,'S18');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SKIN INJURY OTHER','SKIN INJURY OTHER','S00.0, S00.7, S00.8, S00.9, S10, S20, S30.7, S30.8, S30.9, S40, S50, S60, S70, S80, S90, T14.0',NULL,'avulsion nail, needle stick, puncture','bite S13',NULL,NULL,1,'S19');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CORN/CALLOSITY','CORN/CALLOSITY','L84',NULL,NULL,'hyperkeratosis S80',NULL,NULL,1,'S20');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SKIN TEXTURE SYMPTOM/COMPLAINT','SKIN TEXTURE SYMPTOM/COMPLAINT','R23.4',NULL,'dry skin, peeling, scaling, wrinkles','sweating problem A09; scalp symptom/complaint S24;  ichthyosis S83; sweat gland disease S92; vulval symptom/complaint X10',NULL,NULL,1,'S21');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'NAIL SYMPTOM/COMPLAINT','NAIL SYMPTOM/COMPLAINT','L60.1, L60.4, L60.5, L60.9, L62, R68.3',NULL,'clubbing','paronychia S09, ingrowing nail S94',NULL,NULL,1,'S22');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'HAIR LOSS/BALDNESS','HAIR LOSS/BALDNESS','L63, L64, L65, L66',NULL,'alopecia',NULL,NULL,NULL,1,'S23');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'HAIR/SCALP SYMPTOM/COMPLAINT','HAIR/SCALP SYMPTOM/COMPLAINT','L67, L68',NULL,'dry scalp, hirsutism','trichotillomania P29; folliculitis S10; hair loss/baldness S23; dandruff S86',NULL,NULL,1,'S24');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF CANCER OF SKIN','FEAR OF CANCER OF SKIN','Z71.1','concern about/fear of cancer of skin in a patient without the disease/until the diagnosis is proven',NULL,'if patient has the disease, code the disease',NULL,NULL,1,'S26');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF SKIN DISEASE OTHER','FEAR OF SKIN DISEASE OTHER','Z71.1','concern about/fear of having other skin disease in a patient without the disease/until the diagnosis is proven',NULL,'fear of cancer of skin S26; if patient has the disease, code the disease',NULL,NULL,1,'S27');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LIMITED FUNCTION/DISABILITY (S)','LIMITED FUNCTION/DISABILITY (S)','Z73.6','limitation of function/disability due to a skin problem',NULL,NULL,NULL,'The COOP/WONCA Charts are suitable for documenting the patient''s functional status (see Chapter 8).',1,'S28');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SKIN SYMPTOM/COMPLAINT OTHER','SKIN SYMPTOM/COMPLAINT OTHER','R23.3, R23.8',NULL,'cellulite, petechiae, problems with umbilicus, skin lesion, sore(s)','scar S99',NULL,NULL,1,'S29');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation complete','Medical examin/health eval complete',NULL,NULL,NULL,NULL,NULL,NULL,1,'S30');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation partial','Medical examin/health eval partial',NULL,NULL,NULL,NULL,NULL,NULL,1,'S31');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Sensitivity test','Sensitivity test',NULL,NULL,NULL,NULL,NULL,NULL,1,'S32');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Microbiological/immunological test','Microbiological/immunological test',NULL,NULL,NULL,NULL,NULL,NULL,1,'S33');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Blood test','Blood test',NULL,NULL,NULL,NULL,NULL,NULL,1,'S34');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Urine test','Urine test',NULL,NULL,NULL,NULL,NULL,NULL,1,'S35');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Faeces test','Faeces test',NULL,NULL,NULL,NULL,NULL,NULL,1,'S36');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Histological/exfoliative cytology','Histological/exfoliative cytology',NULL,NULL,NULL,NULL,NULL,NULL,1,'S37');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other laboratory test NEC','Other laboratory test NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'S38');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Physical function test','Physical function test',NULL,NULL,NULL,NULL,NULL,NULL,1,'S39');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic endoscopy','Diagnostic endoscopy',NULL,NULL,NULL,NULL,NULL,NULL,1,'S40');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic radiology/imaging','Diagnostic radiology/imaging',NULL,NULL,NULL,NULL,NULL,NULL,1,'S41');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Electrical tracing','Electrical tracing',NULL,NULL,NULL,NULL,NULL,NULL,1,'S42');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Preventive immunization/medication','Preventive immunization/medication',NULL,NULL,NULL,NULL,NULL,NULL,1,'S44');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Observation/health education/advice/diet','Observ/health educat/advice/diet',NULL,NULL,NULL,NULL,NULL,NULL,1,'S45');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with primary care provider','Consultation primary care provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'S46');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with specialist','Consultation with specialist',NULL,NULL,NULL,NULL,NULL,NULL,1,'S47');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Clarification/discussion of patient''s RFE/demand','Clarification/discussion RFE/demand',NULL,NULL,NULL,NULL,NULL,NULL,1,'S48');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other preventive procedure','Other preventive procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'S49');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Medication/prescription/renewal/injection','Medication/prescr/renewal/inject',NULL,NULL,NULL,NULL,NULL,NULL,1,'S50');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Incision/drainage/flushing/aspiration/removal body fluid (excl. catheterisation - 53)\n
 (excl. catheterisation - 53)','I&D/flush/aspiration (excl cath -53)',NULL,NULL,NULL,NULL,NULL,NULL,1,'S51');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Excision/removal tissue/biopsy/destruction/debridement/cauterization','Exc/remov/biopsy/destruc/debrid/caut',NULL,NULL,NULL,NULL,NULL,NULL,1,'S52');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Instrumentation/catheterization/intubation/dilation','Instrument/catheter/intubate/dilate',NULL,NULL,NULL,NULL,NULL,NULL,1,'S53');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Repair/fixation-suture/cast/prosthetic device (apply/remove)','Repair/fix-suture/cast/prosth device',NULL,NULL,NULL,NULL,NULL,NULL,1,'S54');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Local injection/infiltration','Local injection/infiltration',NULL,NULL,NULL,NULL,NULL,NULL,1,'S55');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Dressing/pressure/compression/tamponade','Dressing/pressure/compress/tamponade',NULL,NULL,NULL,NULL,NULL,NULL,1,'S56');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Physical medicine/rehabilitation','Physical medicine/rehabilitation',NULL,NULL,NULL,NULL,NULL,NULL,1,'S57');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Therapeutic counselling/listening','Therapeutic counselling/listening',NULL,NULL,NULL,NULL,NULL,NULL,1,'S58');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Other therapeutic procedure/minor surgery NEC','Other therap proced/minor surg NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'S59');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result test/procedure','Result test/procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'S60');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result examination/test/record/letter from other provider','Result exam/test/lett oth provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'S61');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (5,'Administrative procedure','Administrative procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'S62');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Follow-up encounter unspecified','Follow-up encounter unspecified',NULL,NULL,NULL,NULL,NULL,NULL,1,'S63');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by provider','Encounter/prob initiated by provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'S64');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by other than patient/provider','Enc/prob init by other than pt/prov',NULL,NULL,NULL,NULL,NULL,NULL,1,'S65');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to other provider/nurse/therapist/social worker','Referral to non-MD provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'S66');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to physician/specialist/clinic/hospital','Referral to MD/specialist/clin/hosp',NULL,NULL,NULL,NULL,NULL,NULL,1,'S67');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other referral NEC','Other referral NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'S68');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other reason for encounter NEC','Other reason for encounter NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'S69');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HERPES ZOSTER','HERPES ZOSTER','B02','grouped vescicular eruptions, unilateral distribution, over area of a single dermatome','post-herpetic neuralgia, shingles, herpes zoster ophthalmicus',NULL,'skin pain S01; rash S06',NULL,1,'S70');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HERPES SIMPLEX','HERPES SIMPLEX','B00.0, B00.1, B00.8, B00.9','vesicles with erythematous base in localised area(s); plus past history of similar lesions, or virological or serological evidence','cold sore, fever blister','herpes simplex of eye without corneal ulcer F73; genital infections X90, Y72','rash S06',NULL,1,'S71');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SCABIES/OTHER ACARIASIS','SCABIES/OTHER ACARIASIS','B86, B88.0, B88.2','intense pruritic skin lesions plus arrays of burrows on sides of palms, fingers, penis or skin folds; or demonstration of parasites or ova in lesions',NULL,NULL,'pruritus S02',NULL,1,'S72');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PEDICULOSIS/SKIN INFESTATION OTHER','PEDICULOSIS/SKIN INFESTATION OTHER','B85, B87, B88.1, B88.3, B88.8, B88.9','demonstration of nits on hair shafts or insects on skin/clothes','fleas, lice, mites, ticks','infected insect bites S11; insect bites S12','pruritus S02; localized rash S06',NULL,1,'S73');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'DERMATOPHYTOSIS','DERMATOPHYTOSIS','B35, B36','pruritic scaly lesions with central clearing and small vesicles at border; or demonstration of fungus','fungal skin infection, onychomycosis, pityriasis versicolor, ringworm, tinea','monilia/candida S75',NULL,NULL,1,'S74');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MONILIASIS/CANDIDIASIS SKIN','MONILIASIS/CANDIDIASIS SKIN','B37.2',NULL,'monilial intertrigo, thrush involving nails/perianal region/skin','oral thrush D83; genital infection X72, Y75',NULL,NULL,1,'S75');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SKIN INFECTION OTHER','SKIN INFECTION OTHER','A46, A66, A67, L03.1, L03.2, L03.3, L03.8, L03.9, L08, L98.0',NULL,'cellulitis, erysipelas, pyoderma, strep skin infection','boil/carbuncle/other localized skin infection S11; impetigo S84; molluscum contagiosum S95; acne S96',NULL,NULL,1,'S76');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM OF SKIN','MALIGNANT NEOPLASM OF SKIN','C43, C44, C46.0, C46.1','characteristic histological appearance','basal cell carcinoma, malignant melanoma, rodent ulcer, squamous cell carcinoma of skin','premalignant lesion of skin S79','other malignant neoplasm (when primary site is uncertain) A79; neoplasm of skin unspecified as benign or malignant/when histology is not available S79',NULL,1,'S77');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'LIPOMA','LIPOMA','D17',NULL,NULL,NULL,NULL,NULL,1,'S78');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'NEOPLASM SKIN BENIGN/UNSPECIFIED','NEOPLASM SKIN BENIGN/UNSPECIFIED','D03, D04, D23, D48.5',NULL,'benign skin neoplasm/skin neoplasm not specified as benign or malignant/when histology is not available, dermoid cyst, premalignant lesion','residual haemorrhoidal skin tag K96; solar keratosis S80; haemangioma S81; mole/pigmented nevus S82; keloid, hyperkeratosis, seborrhoeic/senile warts S99',NULL,NULL,1,'S79');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SOLAR KERATOSIS/SUNBURN','SOLAR KERATOSIS/SUNBURN','L55, L56, L57, L58, L59',NULL,'photosensitivity, radiation skin damage, senile keratosis, solar hyperkeratosis, polymorphous light eruption','skin damage due to man made radiation A87, A88',NULL,NULL,1,'S80');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HAEMANGIOMA/LYMPHANGIOMA','HAEMANGIOMA/LYMPHANGIOMA','D18','vascular or lymphatic tumour, elevated above skin and emptying on pressure','angiomatous birthmark, portwine stain',NULL,'localized swelling S04',NULL,1,'S81');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'NAEVUS/MOLE','NAEVUS/MOLE','D22',NULL,NULL,NULL,NULL,NULL,1,'S82');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONGENITAL SKIN ANOMALY OTHER','CONGENITAL SKIN ANOMALY OTHER','Q80, Q81, Q82, Q84',NULL,'birthmark, ichthyosis','haemangioma/lymphangioma S81',NULL,NULL,1,'S83');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'IMPETIGO','IMPETIGO','L00, L01','spreading skin lesion consisting of macules, vesicles, pustules or crust with underlying raw area','impetigo secondary to other dermatosis',NULL,'other localized skin infection S11',NULL,1,'S84');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PILONIDAL CYST/FISTULA','PILONIDAL CYST/FISTULA','L05',NULL,'pilonidal abscess','dermoid cyst S79',NULL,NULL,1,'S85');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'DERMATITIS SEBORRHOEIC','DERMATITIS SEBORRHOEIC','L21','greasy, scaly lesions with underlying erythema on one or more areas of scalp, face, sternum, interscapular areas, around umbilicus and in body folds, not attributable to other skin disease','cradle cap, dandruff','seborrhoeic warts S99','localized rash S06; generalized rash S07',NULL,1,'S86');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'DERMATITIS/ATOPIC ECZEMA','DERMATITIS/ATOPIC ECZEMA','L20','pruritic exudative lesions with/without lichenification over face and neck, wrists and hands, chest, back of knees and front of elbow','flexural dermatitis, infantile eczema','dermatitis/atopic eczema affecting external auditory meatus H70; allergic dermatitis S88; diaper rash S89','pruritus S02; rash S06, S07',NULL,1,'S87');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'DERMATITIS CONTACT/ALLERGIC','DERMATITIS CONTACT/ALLERGIC','L23, L24, L25, L27.2, L27.8, L27.9, L30.0, L30.3, L30.4, L30.8, L30.9','pruritic erythematous lesions related to exposure to chemical substance','allergic dermatitis, chemical dermatitis, dermatitis NOS, eczema NOS, intertrigo, plant sting, skin allergy','allergy/allergic reaction unspecified A92; contact and other dermatitis of the eyelid F71; contact/other dermatitis of external auditory meatus H70; atopic eczema S87; diaper rash S89; urticaria S98 ; dermatitis artefacta/neurodermatitis S99','pruritus S02; rash S06, S07',NULL,1,'S88');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'DIAPER RASH','DIAPER RASH','L22','dermatitis, primarily of the diaper area and sparing creases',NULL,NULL,NULL,NULL,1,'S89');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PITYRIASIS ROSEA','PITYRIASIS ROSEA','L42','oval, scaly eruptions along skin tension lines of trunk, with a history of a solitary lesion preceeding presenting rash',NULL,NULL,'rash S06, S07',NULL,1,'S90');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PSORIASIS','PSORIASIS','L40','plaques with silvery scales on knees, elbows or scalp and/or stippled/pitted nails',NULL,NULL,NULL,'double code psoriatic arthritis L99',1,'S91');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SWEAT GLAND DISEASE','SWEAT GLAND DISEASE','L30.1, L73.2, L74, L75',NULL,'dyshidrosis, heat rash, hydradenitis, miliaria, pompholyx, prickly heat, sweat rash','hyperhidrosis A09',NULL,NULL,1,'S92');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SEBACEOUS CYST','SEBACEOUS CYST','L72.1',NULL,'wen',NULL,NULL,NULL,1,'S93');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'INGROWING NAIL','INGROWING NAIL','L60.0',NULL,NULL,'paronychia S09',NULL,NULL,1,'S94');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MOLLUSCUM CONTAGIOSUM','MOLLUSCUM CONTAGIOSUM','B08.1',NULL,NULL,NULL,NULL,NULL,1,'S95');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ACNE','ACNE','L70',NULL,'blackheads, comedones, pimples','acne due to medication A85',NULL,NULL,1,'S96');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CHRONIC ULCER SKIN','CHRONIC ULCER SKIN','I83.0, I83.2, L89, L97, L98.4',NULL,'bedsore, decubitus ulcer, pressure sore, varicose ulcer','gangrene K92',NULL,NULL,1,'S97');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'URTICARIA','URTICARIA','L50',NULL,'hives, weals','drug allergy A85; angioedema/allergic oedema A92',NULL,NULL,1,'S98');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SKIN DISEASE OTHER','SKIN DISEASE OTHER','L10, L11, L12, L13, L14, L26, L28, L30.2, L30.5, L41, L43, L44, L45, L51, L52, L53.0, L53.1, L53.2, L53.3, L53.8, L54, L60.2, L60.3, L60.8, L71, L72.0, L72.2, L72.8, L72.9, L73.0, L73.1, L73.8, L73.9, L80, L81.4, L81.5, L81.6, L81.7, L81.8, L81.9, L82, L83, L85, L86, L87, L88, L90, L91, L92, L93, L94, L95, L98.1, L98.2, L98.3, L98.5, L98.6, L98.8, L98.9, L99, Z94.5',NULL,'dermatitis artefacta, discoid lupus erythematosus, erythema multiforme, erythema nodosum, granuloma, granuloma annulare, hyperkeratosis NOS, keloid, keratoacanthoma, lichen planus, neurodermatitis, onychogryphosis, rosacea, rhinophyma, scar, seborrhoeic or senile warts, striae atrophicae, vitiligo',NULL,NULL,NULL,1,'S99');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (NULL,'ENDOCRINE/METABOLIC/NUTRITIONAL','ENDOCRINE/METABOLIC/NUTRITIONAL',NULL,NULL,NULL,NULL,NULL,NULL,1,'T');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'EXCESSIVE THIRST','EXCESSIVE THIRST','R63.1',NULL,'polydipsia',NULL,NULL,NULL,1,'T01');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LOSS OF APPETITE','LOSS OF APPETITE','R63.0',NULL,'anorexia','anorexia nervosa P86',NULL,NULL,1,'T03');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEEDING PROBLEM OF INFANT/CHILD','FEEDING PROBLEM OF INFANT/CHILD','R63.3',NULL,'problem of what and how to eat/feed infant/child','food allergy A92; food intolerance D99; feeding problem/eating disorders with psychological cause P11',NULL,NULL,1,'T04');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEEDING PROBLEM OF ADULT','FEEDING PROBLEM OF ADULT','R63.3',NULL,'problem of what and how to eat/feed adult','food allergy A92; dysphagia D21; food intolerance D99; psychological eating disorders/ food refusal P29; anorexia/bulimia nervosa P86; loss of appetite T03',NULL,NULL,1,'T05');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'deleted, transferred to P86',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'T06');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'WEIGHT GAIN','WEIGHT GAIN','R63.5',NULL,NULL,'obesity T82; overweight T83',NULL,NULL,1,'T07');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'WEIGHT LOSS','WEIGHT LOSS','R63.4, R64',NULL,'cachexia','anorexia nervosa P86',NULL,NULL,1,'T08');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'GROWTH DELAY','GROWTH DELAY','E34.3, R62.8, R62.9',NULL,'failure to thrive, physiological delay growth','delayed milestones P22; learning disorder P24; mental retardation P85; delayed puberty T99',NULL,NULL,1,'T10');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'DEHYDRATION','DEHYDRATION','E86',NULL,'water depletion','salt depletion/electrolyte disturbance T99',NULL,NULL,1,'T11');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'deleted, included with T81',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'T15');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF CANCER OF ENDOCRINE SYSTEM','FEAR OF CANCER OF ENDOCRINE SYSTEM','Z71.1','concern about/fear of cancer of endocrine system in a patient without the disease/until the diagnosis is proven',NULL,'if patient has the disease, code the disease',NULL,NULL,1,'T26');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF ENDOCRINE/METABOLIC DISEASE OTHER','FEAR ENDOCRINE/METABOL DISEASE OTHER','Z71.1','concern about/fear of other endocrine/metabolic/nutritional disease in a patient without the disease/until the diagnosis is proven','fear of diabetes','fear of cancer of endocrine system T26; if patient has the disease, code the disease',NULL,NULL,1,'T27');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LIMITED FUNCTION/DISABILITY (T)','LIMITED FUNCTION/DISABILITY (T)','Z73.6','limited function/disability due to a problem of the endocrine/metabolic/nutritional system',NULL,NULL,NULL,'The COOP/WONCA Charts are suitable for documenting the patient''s functional status (see Chapter 8).',1,'T28');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ENDOCRINE/METABOLIC/NUTRITIONAL SYMPTOM/COMPLAINT OTHER','ENDOCR/METAB/NUTR SYMPT/COMPL OTHER','R63.8',NULL,'specific food craving, underweight','hyperglycemia A91; fluid retention K07',NULL,NULL,1,'T29');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation complete','Medical examin/health eval complete',NULL,NULL,NULL,NULL,NULL,NULL,1,'T30');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation partial','Medical examin/health eval partial',NULL,NULL,NULL,NULL,NULL,NULL,1,'T31');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Sensitivity test','Sensitivity test',NULL,NULL,NULL,NULL,NULL,NULL,1,'T32');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Microbiological/immunological test','Microbiological/immunological test',NULL,NULL,NULL,NULL,NULL,NULL,1,'T33');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Blood test','Blood test',NULL,NULL,NULL,NULL,NULL,NULL,1,'T34');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Urine test','Urine test',NULL,NULL,NULL,NULL,NULL,NULL,1,'T35');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Faeces test','Faeces test',NULL,NULL,NULL,NULL,NULL,NULL,1,'T36');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Histological/exfoliative cytology','Histological/exfoliative cytology',NULL,NULL,NULL,NULL,NULL,NULL,1,'T37');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other laboratory test NEC','Other laboratory test NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'T38');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Physical function test','Physical function test',NULL,NULL,NULL,NULL,NULL,NULL,1,'T39');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic endoscopy','Diagnostic endoscopy',NULL,NULL,NULL,NULL,NULL,NULL,1,'T40');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic radiology/imaging','Diagnostic radiology/imaging',NULL,NULL,NULL,NULL,NULL,NULL,1,'T41');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Electrical tracing','Electrical tracing',NULL,NULL,NULL,NULL,NULL,NULL,1,'T42');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other diagnostic procedure','Other diagnostic procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'T43');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Preventive immunization/medication','Preventive immunization/medication',NULL,NULL,NULL,NULL,NULL,NULL,1,'T44');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Observation/health education/advice/diet','Observ/health educat/advice/diet',NULL,NULL,NULL,NULL,NULL,NULL,1,'T45');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with primary care provider','Consultation primary care provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'T46');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with specialist','Consultation with specialist',NULL,NULL,NULL,NULL,NULL,NULL,1,'T47');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Clarification/discussion of patient''s RFE/demand','Clarification/discussion RFE/demand',NULL,NULL,NULL,NULL,NULL,NULL,1,'T48');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other preventive procedure','Other preventive procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'T49');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Medication/prescription/renewal/injection','Medication/prescr/renewal/inject',NULL,NULL,NULL,NULL,NULL,NULL,1,'T50');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Excision/removal tissue/biopsy/destruction/debridement/cauterization','Exc/remov/biopsy/destruc/debrid/caut',NULL,NULL,NULL,NULL,NULL,NULL,1,'T52');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Instrumentation/catheterization/intubation/dilation','Instrument/catheter/intubate/dilate',NULL,NULL,NULL,NULL,NULL,NULL,1,'T53');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Repair/fixation-suture/cast/prosthetic device (apply/remove)','Repair/fix-suture/cast/prosth device',NULL,NULL,NULL,NULL,NULL,NULL,1,'T54');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Local injection/infiltration','Local injection/infiltration',NULL,NULL,NULL,NULL,NULL,NULL,1,'T55');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Dressing/pressure/compression/tamponade','Dressing/pressure/compress/tamponade',NULL,NULL,NULL,NULL,NULL,NULL,1,'T56');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Physical medicine/rehabilitation','Physical medicine/rehabilitation',NULL,NULL,NULL,NULL,NULL,NULL,1,'T57');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Therapeutic counselling/listening','Therapeutic counselling/listening',NULL,NULL,NULL,NULL,NULL,NULL,1,'T58');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Other therapeutic procedure/minor surgery NEC','Other therap proced/minor surg NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'T59');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result test/procedure','Result test/procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'T60');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result examination/test/record/letter from other provider','Result exam/test/lett oth provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'T61');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (5,'Administrative procedure','Administrative procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'T62');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Follow-up encounter unspecified','Follow-up encounter unspecified',NULL,NULL,NULL,NULL,NULL,NULL,1,'T63');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by other than patient/provider','Enc/prob init by other than pt/prov',NULL,NULL,NULL,NULL,NULL,NULL,1,'T65');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to other provider/nurse/therapist/social worker','Referral to non-MD provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'T66');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to physician/specialist/clinic/hospital','Referral to MD/specialist/clin/hosp',NULL,NULL,NULL,NULL,NULL,NULL,1,'T67');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other referral NEC','Other referral NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'T68');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other reason for encounter NEC','Other reason for encounter NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'T69');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ENDOCRINE INFECTION','ENDOCRINE INFECTION','E06.0',NULL,NULL,'thyroiditis T99',NULL,NULL,1,'T70');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM THYROID','MALIGNANT NEOPLASM THYROID','C73','characteristic histological appearance',NULL,NULL,'other/unspecified endocrine neoplasm T73; goitre T81',NULL,1,'T71');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BENIGN NEOPLASM THYROID','BENIGN NEOPLASM THYROID','D34',NULL,NULL,'other/unspecified endocrine neoplasm T73; goitre T81',NULL,NULL,1,'T72');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'NEOPLASM ENDOCRINE OTHER/UNSPECIFIED','NEOPLASM ENDOCRINE OTHER/UNSPECIFIED','C74, C75, D09.3, D35, D44',NULL,'other endocrine neoplasm/endocrine neoplasm not specified as benign or malignant/when histology is not available',NULL,NULL,NULL,1,'T73');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'THYROGLOSSAL DUCT/CYST','THYROGLOSSAL DUCT/CYST','Q89.2',NULL,NULL,'goitre T81',NULL,NULL,1,'T78');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONGENITAL ANOMALY ENDOCRINE/METABOLIC','CONGEN  ANOMALY ENDOCRINE/METABOLIC','E00, Q89.1, Q89.2',NULL,'cretinism, dwarfism','thyroglossal duct (cyst) T78',NULL,NULL,1,'T80');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'GOITRE','GOITRE','E04',NULL,'non-toxic goitre, thyroid nodule','neoplasm of thyroid gland T71-T73; thyroglossal cyst T78; toxic goitre T85; hypothyroidism T86',NULL,NULL,1,'T81');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'OBESITY','OBESITY','E66','a body mass index greater than 30',NULL,'overweight T83',NULL,NULL,1,'T82');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'OVERWEIGHT','OVERWEIGHT','E66','a body mass index greater than 25 but less than 30',NULL,'obesity T82',NULL,NULL,1,'T83');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HYPERTHYROIDISM/THYROTOXICOSIS','HYPERTHYROIDISM/THYROTOXICOSIS','E05','laboratory evidence of excessive thyroid hormone; or thyroid nodule or goitre plus tremor, weight loss, and rapid pulse (over l00/min at rest) or eye signs (exophthalmos, lid lag, or ophthamoplegia)','Graves disease, toxic goitre','non-toxic goitre T81',NULL,NULL,1,'T85');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HYPOTHYROIDISM/MYXOEDEMA','HYPOTHYROIDISM/MYXOEDEMA','E01, E02, E03','laboratory evidence of diminished thyroid hormone activity and excessive thyroid stimulating hormone; or four or more of the following: weakness/tiredness; mental changes: apathy, poor memory, slowing; voice changes: coarser, deeper slower speech; undue sensitivity to cold; constipation; coarse puffy facial features; cool dry, sallow skin, decreased sweating; peripheral oedema',NULL,'cretinism T80','other complaint of metabolism T29',NULL,1,'T86');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HYPOGLYCAEMIA','HYPOGLYCAEMIA','E15, E16','hypoglycaemia demonstrated by biochemical testing, or characteristic symptoms in a diabetic patient relieved by ingestion or injection of sugar','hyperinsulism, insulin coma',NULL,NULL,NULL,1,'T87');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'deleted, included with T99',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'T88');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'DIABETES NON-INSULIN DEPENDENT','DIABETES NON-INSULIN DEPENDENT','E11, E12, E13, E14','patient not requiring regular ongoing treatment with insulin after diagnosis confirmed by one of the following:(a) the classic symptoms of diabetes, such as polyuria, polydypsia, and rapid weight loss, together with unequivocal elevation of plasma glucose (b) fasting blood glucose levels of 8mmol/l (l40mg/dl) or more on two or more occasions (c) random blood glucose levels of 11mmol/l (200mg/dl) or more on two or more occasions(d) an oral Glucose Tolerance Test (75gm glucose) one value of plasma glucose at between one and two hours of 11mmol/l (200mg/dl) or more and plasma glucose at two hours of 11mol/l (200mg/dl) or more;\n
these WHO-criteria may change over time; also, criteria differences may exist between national health care systems','diabetes NOS, late onset diabetes, type 2 diabetes','drug induced hyperglycaemia A85; hyperglycaemia as isolated finding A91; insulin-dependent diabetes T89; gestational diabetes W85','consider: hyperglycaemia A91; diabetes, insulin dependant T89','1. double code complications such as retinopathy F83, nephropathy U88\n
2. In pregnancy, double code with W84',1,'T90');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'VITAMIN/NUTRITIONAL DEFICIENCY','VITAMIN/NUTRITIONAL DEFICIENCY','E40, E41, E42, E43, E44, E45, E46, E50, E51.1, E51.8, E51.9, E52, E53, E54, E55, E56, E58, E59, E60, E61, E63, E64',NULL,'beri-beri, dietary mineral deficiency, iron deficiency without anaemia, malnutrition, marasmus, scurvy','iron deficiency anaemia B80; pernicious anaemia B81; malabsorption syndrome/sprue D99',NULL,NULL,1,'T91');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'GOUT','GOUT','M10',NULL,NULL,'drug induced gout A85; raised uric acid A91; pseudo-gout/other crystal arthropathy T99',NULL,NULL,1,'T92');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'LIPID DISORDER','LIPID DISORDER','E78',NULL,'abnormality of lipoprotein level, hyperlipidaemia, raised level of cholesterol/triglycerides, xanthoma',NULL,NULL,NULL,1,'T93');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ENDOCRINE/METABOLIC/NUTRITIONAL DISEASE OTHER','ENDOCR/METAB/NUTRIT DISEASE OTHER','E06.1, E06.2, E06.3, E06.4, E06.5, E06.9, E07, E20, E21, E22, E23, E24, E25, E26, E27, E28, E29, E30, E31, E32, E34.0, E34.1, E34.2, E34.4, E34.5, E34.8, E34.9, E35, E65, E67, E68, E70, E71, E72, E73, E74, E75, E76, E77, E79, E80, E83, E84, E85, E87, E88, E90, M11, M83',NULL,'acromegaly, adrenal/ovarian/ pituitary/parathyroid/ testicular/other endocrine dysfunction, amyloidosis, crystal arthropathy, Cushing''s syndrome, cystic fibrosis, diabetes insipidus, Gilbert''s syndrome, hyperaldosteronism, osteomalacia,porphyria, precocious/delayed puberty, pseudo-gout, renal glycosuria, thyroiditis','food allergy A92; food intolerance D99; osteoporosis L95',NULL,NULL,1,'T99');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (NULL,'URINARY SYSTEM','URINARY SYSTEM',NULL,NULL,NULL,NULL,NULL,NULL,1,'U');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'DYSURIA/PAINFUL URINATION','DYSURIA/PAINFUL URINATION','R30',NULL,'burning urination','frequent/urgent urination U02; urethritis U72',NULL,NULL,1,'U01');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'URINARY FREQUENCY/URGENCY','URINARY FREQUENCY/URGENCY','R35',NULL,'nocturia, polyuria',NULL,NULL,NULL,1,'U02');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'INCONTINENCE URINE','INCONTINENCE URINE','N39.3, N39.4, R32',NULL,'enuresis of organic origin, involuntary urination, stress incontinence','urine incontinence of psychogenic origin P12',NULL,NULL,1,'U04');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'URINATION PROBLEMS OTHER','URINATION PROBLEMS OTHER','R34, R39.1',NULL,'anuria, dribbling urine, oliguria','urinary retention U08',NULL,NULL,1,'U05');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'HAEMATURIA','HAEMATURIA','N02, R31','blood in urine proven by macroscopic/microscopic/chemical test','blood in urine',NULL,NULL,NULL,1,'U06');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'URINE SYMPTOM/COMPLAINT OTHER','URINE SYMPTOM/COMPLAINT OTHER','R39.8',NULL,'bad odour of urine, dark urine','abnormal urine test U98',NULL,NULL,1,'U07');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'URINARY RETENTION','URINARY RETENTION','R33',NULL,NULL,NULL,NULL,NULL,1,'U08');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'BLADDER SYMPTOM/COMPLAINT OTHER','BLADDER SYMPTOM/COMPLAINT OTHER','R39.0',NULL,'bladder pain, irritable bladder',NULL,NULL,NULL,1,'U13');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'KIDNEY SYMPTOM/COMPLAINT','KIDNEY SYMPTOM/COMPLAINT','N23',NULL,'kidney pain, kidney trouble, renal colic','loin/flank pain L05',NULL,NULL,1,'U14');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF CANCER OF URINARY SYSTEM','FEAR OF CANCER OF URINARY SYSTEM','Z71.1','concern about/fear of urinary cancer in a patient without the disease/until the diagnosis  is proven',NULL,'if patient has the disease, code the disease',NULL,NULL,1,'U26');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF URINARY DISEASE OTHER','FEAR OF URINARY DISEASE OTHER','Z71.1','concern about/fear of other urinary disease in a patient without the disease/until the diagnosis is proven',NULL,'fear of cancer of urinary system U26; if patient has the disease, code the disease',NULL,NULL,1,'U27');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LIMITED FUNCTION/DISABILITY (U)','LIMITED FUNCTION/DISABILITY (U)','Z73.6, Z93.5, Z93.6, Z99.2','limitation of function/disability due to a urinary problem','renal transplant, slow stream','urinary incontinence U04',NULL,'The COOP/WONCA Charts are suitable for documenting the patient''s functional status (see Chapter 8).',1,'U28');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'URINARY SYMPTOM/COMPLAINT OTHER','URINARY SYMPTOM/COMPLAINT OTHER','R39.8',NULL,NULL,'irritable bladder/bladder pain U13; kidney problems U14',NULL,NULL,1,'U29');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation complete','Medical examin/health eval complete',NULL,NULL,NULL,NULL,NULL,NULL,1,'U30');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation partial','Medical examin/health eval partial',NULL,NULL,NULL,NULL,NULL,NULL,1,'U31');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Sensitivity test','Sensitivity test',NULL,NULL,NULL,NULL,NULL,NULL,1,'U32');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Microbiological/immunological test','Microbiological/immunological test',NULL,NULL,NULL,NULL,NULL,NULL,1,'U33');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Blood test','Blood test',NULL,NULL,NULL,NULL,NULL,NULL,1,'U34');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Urine test','Urine test',NULL,NULL,NULL,NULL,NULL,NULL,1,'U35');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Faeces test','Faeces test',NULL,NULL,NULL,NULL,NULL,NULL,1,'U36');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Histological/exfoliative cytology','Histological/exfoliative cytology',NULL,NULL,NULL,NULL,NULL,NULL,1,'U37');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other laboratory test NEC','Other laboratory test NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'U38');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic endoscopy','Diagnostic endoscopy',NULL,NULL,NULL,NULL,NULL,NULL,1,'U40');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic radiology/imaging','Diagnostic radiology/imaging',NULL,NULL,NULL,NULL,NULL,NULL,1,'U41');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Electrical tracing','Electrical tracing',NULL,NULL,NULL,NULL,NULL,NULL,1,'U42');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other diagnostic procedure','Other diagnostic procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'U43');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Preventive immunization/medication','Preventive immunization/medication',NULL,NULL,NULL,NULL,NULL,NULL,1,'U44');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Observation/health education/advice/diet','Observ/health educat/advice/diet',NULL,NULL,NULL,NULL,NULL,NULL,1,'U45');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with primary care provider','Consultation primary care provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'U46');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with specialist','Consultation with specialist',NULL,NULL,NULL,NULL,NULL,NULL,1,'U47');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Clarification/discussion of patient''s RFE/demand','Clarification/discussion RFE/demand',NULL,NULL,NULL,NULL,NULL,NULL,1,'U48');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other preventive procedure','Other preventive procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'U49');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Medication/prescription/renewal/injection','Medication/prescr/renewal/inject',NULL,NULL,NULL,NULL,NULL,NULL,1,'U50');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Incision/drainage/flushing/aspiration/removal body fluid (excl. catheterisation - 53)\n
 (excl. catheterisation - 53)','I&D/flush/aspiration (excl cath -53)',NULL,NULL,NULL,NULL,NULL,NULL,1,'U51');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Excision/removal tissue/biopsy/destruction/debridement/cauterization','Exc/remov/biopsy/destruc/debrid/caut',NULL,NULL,NULL,NULL,NULL,NULL,1,'U52');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Instrumentation/catheterization/intubation/dilation','Instrument/catheter/intubate/dilate',NULL,NULL,NULL,NULL,NULL,NULL,1,'U53');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Repair/fixation-suture/cast/prosthetic device (apply/remove)','Repair/fix-suture/cast/prosth device',NULL,NULL,NULL,NULL,NULL,NULL,1,'U54');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Local injection/infiltration','Local injection/infiltration',NULL,NULL,NULL,NULL,NULL,NULL,1,'U55');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Dressing/pressure/compression/tamponade','Dressing/pressure/compress/tamponade',NULL,NULL,NULL,NULL,NULL,NULL,1,'U56');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Physical medicine/rehabilitation','Physical medicine/rehabilitation',NULL,NULL,NULL,NULL,NULL,NULL,1,'U57');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Therapeutic counselling/listening','Therapeutic counselling/listening',NULL,NULL,NULL,NULL,NULL,NULL,1,'U58');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Other therapeutic procedure/minor surgery NEC','Other therap proced/minor surg NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'U59');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result test/procedure','Result test/procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'U60');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result examination/test/record/letter from other provider','Result exam/test/lett oth provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'U61');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (5,'Administrative procedure','Administrative procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'U62');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Follow-up encounter unspecified','Follow-up encounter unspecified',NULL,NULL,NULL,NULL,NULL,NULL,1,'U63');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by provider','Encounter/prob initiated by provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'U64');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by other than patient/provider','Enc/prob init by other than pt/prov',NULL,NULL,NULL,NULL,NULL,NULL,1,'U65');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to other provider/nurse/therapist/social worker','Referral to non-MD provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'U66');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to physician/specialist/clinic/hospital','Referral to MD/specialist/clin/hosp',NULL,NULL,NULL,NULL,NULL,NULL,1,'U67');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other referral NEC','Other referral NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'U68');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other reason for encounter NEC','Other reason for encounter NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'U69');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PYELONEPHRITIS/PYELITIS','PYELONEPHRITIS/PYELITIS','N10, N11, N12, N15.1, N15.9','two of  the following: flank pain, renal tenderness, investigation evidence of chronic renal damage; plus clinical or laboratory evidence of urinary tract infection','infection of kidney, renal/perinephric abscess',NULL,'cystitis/other urinary infection U71',NULL,1,'U70');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CYSTITIS/URINARY INFECTION OTHER','CYSTITIS/URINARY INFECTION OTHER','N30, N39.0',NULL,'acute/chronic cystitis (non-venereal), asymptomatic bacteriuria, lower urinary tract infection, urinary tract infection NOS','pyelonephritis U70; urethritis U72; vaginitis X84; balanitis Y75',NULL,'in pregnancy also code W84',1,'U71');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'URETHRITIS','URETHRITIS','A56.2, B37.4, N34','urethral discharge with frequency, burning, pain or urgency on urination without bacteriuria by microscopy or culture; or inflammation of external urinary meatus','chlamydial urethritis, nonspecific urethritis, urethral syndrome, meatitis','gonococcal urethritis female X71; urethritis trichomonal, female X73; gonococcal urethritis male Y71','painful urination U01; frequent/urgent urination U02; irritable bladder U13; urethral discharge X29, Y03',NULL,1,'U72');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM OF KIDNEY','MALIGNANT NEOPLASM OF KIDNEY','C64, C65','characteristic histologic appearance',NULL,NULL,'neoplasm urinary tract NOS U79',NULL,1,'U75');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM OF BLADDER','MALIGNANT NEOPLASM OF BLADDER','C67','characteristic histologic appearance',NULL,NULL,'neoplasm urinary tract NOS U79',NULL,1,'U76');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM URINARY OTHER','MALIGNANT NEOPLASM URINARY OTHER','C66, C68','characteristic histologic appearance','malignant neoplasm ureter, malignant neoplasm urethra','malignant neoplasm prostate Y77','neoplasm urinary tract NOS U79',NULL,1,'U77');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'NEOPLASM URINARY TRACT NOS','NEOPLASM URINARY TRACT NOS','D09.0, D09.1, D41',NULL,'bladder/kidney/ureter/urethra neoplasm NOS','histologically proven urinary tract neoplasms U75, U76, U77, U78',NULL,NULL,1,'U79');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'INJURY URINARY TRACT','INJURY URINARY TRACT','S37.0, S37.1, S37.2, S37.3, T19.0, T19.1, T28.3, T28.8',NULL,'contusion kidney, foreign body in urinary tract',NULL,NULL,NULL,1,'U80');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONGENITAL ANOMALY URINARY TRACT','CONGENITAL ANOMALY URINARY TRACT','Q60, Q61, Q62, Q63, Q64',NULL,'duplex kidney/ureter, congenital polycystic kidney',NULL,NULL,NULL,1,'U85');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'GLOMERULONEPHRITIS/NEPHROSIS','GLOMERULONEPHRITIS/NEPHROSIS','N00, N01, N03, N04, N05, N07, N08, N14, N15.0, N15.8, N16','three or more of the following: hematuria, proteinuria, renal salt and water retention, decreased renal function, persistent urinary sediment abnormalities; or renal biopsy evidence','acute glomerulonephritis, analgesic nephropathy, chronic glomerulo-nephritis, nephritis, nephropathy, nephrosclerosis, nephrotic syndrome','renal failure U99','abnormal urine test result U98; kidney complaint U14',NULL,1,'U88');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ORTHOSTATIC ALBUMINURIA/PROTEINURIA','ORTHOSTATIC ALBUMINURIA/PROTEINURIA','N39.2','albuminuria following ambulation, no albuminuria following overnight recumbency and no evidence of renal disease','postural proteinuria',NULL,'proteinuria NOS U98',NULL,1,'U90');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'URINARY CALCULUS','URINARY CALCULUS','N20, N21, N22','colicky pain and either haematuria or history of urinary stone in the past; or passage of calculus; or imaging evidence of calculus','calculus/stone in bladder/kidney/ureter, urolithiasis',NULL,'blood in urine U06; renal colic U14; other urinary symptom U29; abnormal urine test U98',NULL,1,'U95');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ABNORMAL URINE TEST NOS','ABNORMAL URINE TEST NOS','N39.1, R80, R81, R82',NULL,'glycosuria, proteinuria, pus in urine, pyuria','haematuria/blood in urine U06; orthostatic albuminuria/proteinuria U90',NULL,NULL,1,'U98');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'URINARY DISEASE OTHER','URINARY DISEASE OTHER','N06, N13, N17, N18, N19, N25, N26, N27, N28, N29, N31, N32, N33, N35, N36, N37, N39.8, N39.9, R39.2, T19.8, T19.9, Z90.5, Z90.6, Z94.0',NULL,'bladder diverticulum, hydronephrosis, hypertrophic kidney, obstruction bladder neck, renal failure, urethral caruncle, urethral stricture, ureteric reflux, uraemia',NULL,NULL,NULL,1,'U99');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (NULL,'PREGNANCY, CHILDBEARING, FAMILY PLANNING','PREGNANCY, CHILDBEARING, FAMILY PLAN',NULL,NULL,NULL,NULL,NULL,NULL,1,'W');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'QUESTION OF PREGNANCY','QUESTION OF PREGNANCY','Z32.0',NULL,'delayed menstruation, symptoms suggestive of pregnancy','fear of pregnancy W02, pregnancy confirmed W78, W79',NULL,NULL,1,'W01');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF PREGNANCY','FEAR OF PREGNANCY','Z71.1',NULL,'concern about possibility of unwanted pregnancy','concern/fear if unwanted pregnancy confirmed W79',NULL,NULL,1,'W02');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ANTEPARTUM BLEEDING','ANTEPARTUM BLEEDING','O20, O46',NULL,NULL,'intrapartum hemorrhage W17',NULL,NULL,1,'W03');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PREGNANCY VOMITING/NAUSEA','PREGNANCY VOMITING/NAUSEA','O21',NULL,'hyperemesis, morning sickness in confirmed pregnancy',NULL,NULL,NULL,1,'W05');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CONTRACEPTION POSTCOITAL','CONTRACEPTION POSTCOITAL','Z30.3',NULL,'morning after pill',NULL,NULL,NULL,1,'W10');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CONTRACEPTION ORAL','CONTRACEPTION ORAL','Z30.4',NULL,'family planning in women using oral hormonal therapy',NULL,NULL,NULL,1,'W11');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CONTRACEPTION INTRAUTERINE','CONTRACEPTION INTRAUTERINE','Z30.1, Z30.5',NULL,'family planning using IUD',NULL,NULL,NULL,1,'W12');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'STERILIZATION','STERILIZATION','Z30.2',NULL,'family planning involving female sterilization',NULL,NULL,NULL,1,'W13');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CONTRACEPTION OTHER','CONTRACEPTION OTHER','Z30.0, Z30.8, Z30.9',NULL,'contraception NOS, family planning NOS','genetic counseling A98; oral contraception W11; IUD W12; family planning by female sterilization W13',NULL,NULL,1,'W14');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'INFERTILITY/SUBFERTILITY','INFERTILITY/SUBFERTILITY','N97, Z31','failure to conceive after 2 years of trying','sterility, primary and secondary',NULL,'other symptom/complaint about pregnancy W29',NULL,1,'W15');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'POST-PARTUM SYMPTOM/COMPLAINT OTHER','POST-PARTUM SYMPTOM/COMPLAINT OTHER','O90.9','complaints related to and within six weeks of parturition',NULL,'puerperal depression P76; post-partum bleeding W17; lactation complaints W19; complications of puerperium W96',NULL,NULL,1,'W18');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'BREAST/LACTATION SYMPTOM/COMPLAINT','BREAST/LACTATION SYMPTOM/COMPLAINT','O92.5, O92.6, O92.7',NULL,'galactorrhoea, suppression of lactation, weaning','puerperal mastitis W94; cracked nipples W95',NULL,NULL,1,'W19');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'deleted, included with W19',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'W20');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CONCERN ABOUT BODY IMAGE RELATED TO PREGNANCY','CONCERN WITH BODY IMAGE IN PREGNANCY','R46.8',NULL,NULL,NULL,NULL,NULL,1,'W21');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF COMPLICATIONS OF PREGNANCY','FEAR OF COMPLICATIONS OF PREGNANCY','Z71.1','concern about/fear of complications in a patient without them/until they are proven','fear of congenital anomaly in baby','if patient has the complication, code the complication',NULL,NULL,1,'W27');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LIMITED FUNCTION/DISABILITY (W)','LIMITED FUNCTION/DISABILITY (W)','Z73.6','limitation of function/disability due to or related to pregnancy','pelvic instability',NULL,NULL,'The COOP/WONCA Charts are suitable for documenting the patient''s functional status (see Chapter 8).',1,'W28');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PREGNANCY SYMPTOM/COMPLAINT OTHER','PREGNANCY SYMPTOM/COMPLAINT OTHER','R68.8',NULL,'family planning symptom/complaint',NULL,NULL,NULL,1,'W29');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation partial','Medical examin/health eval partial',NULL,NULL,NULL,NULL,NULL,NULL,1,'W31');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Sensitivity test','Sensitivity test',NULL,NULL,NULL,NULL,NULL,NULL,1,'W32');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Microbiological/immunological test','Microbiological/immunological test',NULL,NULL,NULL,NULL,NULL,NULL,1,'W33');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Blood test','Blood test',NULL,NULL,NULL,NULL,NULL,NULL,1,'W34');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Urine test','Urine test',NULL,NULL,NULL,NULL,NULL,NULL,1,'W35');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Faeces test','Faeces test',NULL,NULL,NULL,NULL,NULL,NULL,1,'W36');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Histological/exfoliative cytology','Histological/exfoliative cytology',NULL,NULL,NULL,NULL,NULL,NULL,1,'W37');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other laboratory test NEC','Other laboratory test NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'W38');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Physical function test','Physical function test',NULL,NULL,NULL,NULL,NULL,NULL,1,'W39');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic endoscopy','Diagnostic endoscopy',NULL,NULL,NULL,NULL,NULL,NULL,1,'W40');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic radiology/imaging','Diagnostic radiology/imaging',NULL,NULL,NULL,NULL,NULL,NULL,1,'W41');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Electrical tracing','Electrical tracing',NULL,NULL,NULL,NULL,NULL,NULL,1,'W42');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other diagnostic procedure','Other diagnostic procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'W43');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Preventive immunization/medication','Preventive immunization/medication',NULL,NULL,NULL,NULL,NULL,NULL,1,'W44');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Observation/health education/advice/diet','Observ/health educat/advice/diet',NULL,NULL,NULL,NULL,NULL,NULL,1,'W45');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with primary care provider','Consultation primary care provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'W46');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with specialist','Consultation with specialist',NULL,NULL,NULL,NULL,NULL,NULL,1,'W47');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Clarification/discussion of patient''s RFE/demand','Clarification/discussion RFE/demand',NULL,NULL,NULL,NULL,NULL,NULL,1,'W48');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other preventive procedure','Other preventive procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'W49');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Medication/prescription/renewal/injection','Medication/prescr/renewal/inject',NULL,NULL,NULL,NULL,NULL,NULL,1,'W50');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Incision/drainage/flushing/aspiration/removal body fluid (excl. catheterisation - 53)\n
 (excl. catheterisation - 53)','I&D/flush/aspiration (excl cath -53)',NULL,NULL,NULL,NULL,NULL,NULL,1,'W51');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Excision/removal tissue/biopsy/destruction/debridement/cauterization','Exc/remov/biopsy/destruc/debrid/caut',NULL,NULL,NULL,NULL,NULL,NULL,1,'W52');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Instrumentation/catheterization/intubation/dilation','Instrument/catheter/intubate/dilate',NULL,NULL,NULL,NULL,NULL,NULL,1,'W53');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Repair/fixation-suture/cast/prosthetic device (apply/remove)','Repair/fix-suture/cast/prosth device',NULL,NULL,NULL,NULL,NULL,NULL,1,'W54');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Local injection/infiltration','Local injection/infiltration',NULL,NULL,NULL,NULL,NULL,NULL,1,'W55');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Dressing/pressure/compression/tamponade','Dressing/pressure/compress/tamponade',NULL,NULL,NULL,NULL,NULL,NULL,1,'W56');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Physical medicine/rehabilitation','Physical medicine/rehabilitation',NULL,NULL,NULL,NULL,NULL,NULL,1,'W57');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Therapeutic counselling/listening','Therapeutic counselling/listening',NULL,NULL,NULL,NULL,NULL,NULL,1,'W58');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Other therapeutic procedure/minor surgery NEC','Other therap proced/minor surg NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'W59');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result test/procedure','Result test/procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'W60');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result examination/test/record/letter from other provider','Result exam/test/lett oth provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'W61');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (5,'Administrative procedure','Administrative procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'W62');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Follow-up encounter unspecified','Follow-up encounter unspecified',NULL,NULL,NULL,NULL,NULL,NULL,1,'W63');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by provider','Encounter/prob initiated by provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'W64');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by other than patient/provider','Enc/prob init by other than pt/prov',NULL,NULL,NULL,NULL,NULL,NULL,1,'W65');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to other provider/nurse/therapist/social worker','Referral to non-MD provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'W66');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to physician/specialist/clinic/hospital','Referral to MD/specialist/clin/hosp',NULL,NULL,NULL,NULL,NULL,NULL,1,'W67');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other referral NEC','Other referral NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'W68');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other reason for encounter NEC','Other reason for encounter NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'W69');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PUERPERAL INFECTION/SEPSIS','PUERPERAL INFECTION/SEPSIS','O85, O86.1, O86.3','infection of birth canal or reproductive organs within 6 weeks of parturition',NULL,'obstetric tetanus N72',NULL,NULL,1,'W70');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'INFECTION COMPLICATING PREGNANCY','INFECTION COMPLICATING PREGNANCY','O23, O41.1, O75.2, O75.3, O86.2, O86.4, O86.8, O98',NULL,NULL,'puerperal infection W70; puerperal mastitis W94',NULL,NULL,1,'W71');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM RELATED TO PREGNANCY','MALIGNANT NEOPL RELATED TO PREGNANCY','C58',NULL,'chorioepithelioma, choriocarcinoma',NULL,NULL,NULL,1,'W72');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BENIGN/UNSPECIFIED NEOPLASM RELATED TO PREGNANCY','BENIGN/UNSPECIF NEOPL RELAT TO PREGN','O01',NULL,'hydatidiform mole',NULL,NULL,NULL,1,'W73');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'INJURY COMPLICATING PREGNANCY','INJURY COMPLICATING PREGNANCY','T14.9',NULL,'results of injury interfering with pregnancy','new injury caused by childbirth W92, W93',NULL,NULL,1,'W75');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONGENITAL ANOMALY COMPLICATING PREGNANCY','CONGEN ANOM COMPLICATING PREGNANCY','O99.8',NULL,'maternal anomaly which could affect pregnancy/childbirth',NULL,NULL,NULL,1,'W76');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'deleted',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'W77');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PREGNANCY','PREGNANCY','Z32.1, Z33, Z34, Z36',NULL,'pregnancy confirmed','unwanted pregnancy W79, ectopic pregnancy W80, high risk pregnancy W84',NULL,NULL,1,'W78');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'UNWANTED PREGNANCY','UNWANTED PREGNANCY','Z32.1',NULL,NULL,NULL,NULL,NULL,1,'W79');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ECTOPIC PREGNANCY','ECTOPIC PREGNANCY','O00','confirmation by ultrasound, laparoscopy, culdoscopy or surgery',NULL,NULL,'antepartum bleeding W03, other symptom/complaint in pregnancy W29',NULL,1,'W80');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'TOXAEMIA OF PREGNANCY','TOXAEMIA OF PREGNANCY','O10, O11, O12, O13, O14, O15, O16',NULL,'eclampsia, hypertension, oedema and proteinuria in pregnancy, pre-eclampsia',NULL,'other symptom/complaint in pregnancy W29',NULL,1,'W81');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ABORTION SPONTANEOUS','ABORTION SPONTANEOUS','O02, O03, O05, O06',NULL,'abortion threatened/complete/incomplete/missed/habitual, miscarriage','antepartum bleeding W03; induced abortion W83; premature contractions after the 28th week of pregnancy W92; foetal death/stillbirth after the 28th week of pregnancy W93',NULL,NULL,1,'W82');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ABORTION INDUCED','ABORTION INDUCED','O04, Z30.3',NULL,'termination of pregnancy, all complications',NULL,NULL,NULL,1,'W83');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PREGNANCY HIGH RISK','PREGNANCY HIGH RISK','O24.0, O24.1, O24.2, O24.3, O24.9, O25, O30, O31, O32, O33, O34, O35, O36, O40, O43, O44, O99.0, O99.1, O99.2, O99.3, O99.4, O99.5, O99.6, O99.7, Z35',NULL,'aged primipara, anaemia of pregnancy, diabetes/other pre-existing chronic disease affecting pregnancy, disproportion, hydramnios, malpresentation, multiple pregnancy, placenta praevia, previous caesarian section, premature labour, small foetus for age','infections complicating pregnancy W71; ectopic pregnancy W80; toxaemia of pregnancy W81; gestational diabetes W85',NULL,NULL,1,'W84');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'GESTATIONAL DIABETES','GESTATIONAL DIABETES','O24.4','fasting plasma glucose over 5.5 mmol/L and/or plasma glucose level greater than 8.0 mmol/L two hours after a 75g oral glucose tolerance test','diabetes manifested during pregnancy','pre-existing diabetes T89,T90','hyperglycaemia A91',NULL,1,'W85');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'UNCOMPLICATED  LABOUR/DELIVERY LIVEBIRTH','UNCOMPL LABOUR/DELIVERY LIVEBIRTH','O80, Z37.0, Z37.9, Z38, Z39',NULL,NULL,NULL,NULL,NULL,1,'W90');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'UNCOMPLICATED LABOUR/DELIVERY STILLBIRTH','UNCOMPL LABOUR/DELIVERY STILLBIRTH','Z37.1, Z37.9',NULL,NULL,NULL,NULL,NULL,1,'W91');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'COMPLICATED LABOUR/DELIVERY LIVEBIRTH','COMPL LABOUR/ DELIVERY LIVEBIRTH','O42, O45, O60, O61, O62, O63, O64, O65, O66, O67, O68, O69, O70, O71, O73, O75.0, O75.1, O75.4, O75.5, O75.6, O75.7, O75.8, O75.9, O81, O82, O83, O84, Z37.2, Z37.5, Z37.9, Z38, Z39',NULL,'livebirth after complicated delivery: assisted extraction, breech delivery, caesarian section, dystocia, induction of labour, injuries caused by childbirth, placenta praevia in delivery, version','post-partum haemorrhage W17, eclampsia W81',NULL,NULL,1,'W92');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'COMPLICATED LABOUR/DELIVERY STILLBIRTH','COMPL LABOUR/DELIVERY STILLBIRTH','O42, O45, O60, O61, O62, O63, O64, O65, O66, O67, O68, O69, O70, O71, O73, O75.0, O75.1, O75.4, O75.5, O75.6, O75.7, O75.8, O75.9, O81, O82, O83, O84, Z37.1, Z37.3, Z37.4, Z37.6, Z37.7, Z37.9',NULL,'stillbirth after complicated delivery: assisted extraction, breech delivery, caesarian section, dystocia, induction of labour, injuries caused by childbirth, placenta praevia in delivery, version','post-partum haemorrhage W17, eclampsia W81',NULL,NULL,1,'W93');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PUERPERAL MASTITIS','PUERPERAL MASTITIS','O91','pain, inflammation of breast within 6 weeks of parturition or while lactating','breast abscess',NULL,'disorders of lactation W19',NULL,1,'W94');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BREAST DISORDER IN PREGNANCY/PUERPERIUM OTHER','BREAST DIS IN PREGN/PUERPERIUM OTHER','O92.0, O92.1, O92.2, O92.3, O92.4',NULL,'breast disorder in puerperium, cracked nipple','disorders of lactation W19; mastitis W94; breast problem not related to pregnancy/lactation X21',NULL,NULL,1,'W95');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'COMPLICATIONS OF PUERPERIUM OTHER','COMPLICATIONS OF PUERPERIUM OTHER','O87, O90.4, O90.8, O90.9',NULL,NULL,'puerperal depression P76; puerperal psychosis P98; puerperal infection W70; toxaemia of pregnancy W81; breast disorder in pregnancy W95',NULL,NULL,1,'W96');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'DISORDER OF PREGNANCY/DELIVERY OTHER','DISORDER OF PREGN/DELIVERY OTHER','O07, O08, O22, O26, O28, O41.0, O41.8, O41.9, O47, O48, O88, O90.5, O95, O96, O97',NULL,NULL,'pseudocyesis P75',NULL,NULL,1,'W99');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (NULL,'FEMALE GENITAL SYSTEM INCLUDING BREAST','FEMALE GENITAL SYSTEM INCL BREAST',NULL,NULL,NULL,NULL,NULL,NULL,1,'X');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'GENITAL PAIN FEMALE','GENITAL PAIN FEMALE','R52',NULL,'pelvic pain, vulval pain','menstrual pain X02; dyspareunia female X04; breast pain female X18',NULL,NULL,1,'X01');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'MENSTRUAL PAIN','MENSTRUAL PAIN','N94.4, N94.5, N94.6',NULL,'dysmenorrhoea',NULL,NULL,NULL,1,'X02');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'INTERMENSTRUAL PAIN','INTERMENSTRUAL PAIN','N94.0',NULL,'Mittelschmerz, ovulation pain',NULL,NULL,NULL,1,'X03');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PAINFUL INTERCOURSE FEMALE','PAINFUL INTERCOURSE FEMALE','N94.1, N94.2',NULL,'female dyspareunia, vaginismus NOS','psychogenic sexual problems P07, P08',NULL,NULL,1,'X04');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'MENSTRUATION ABSENT/SCANTY','MENSTRUATION ABSENT/SCANTY','N91',NULL,'amenorrhoea, delayed/late menses, oligomenorrhoea','question of pregnancy W01; fear of pregnancy W02',NULL,NULL,1,'X05');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'MENSTRUATION EXCESSIVE','MENSTRUATION EXCESSIVE','N92.0, N92.2, N92.4',NULL,'menorrhagia, pubertal bleeding',NULL,NULL,NULL,1,'X06');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'MENSTRUATION IRREGULAR/FREQUENT','MENSTRUATION IRREGULAR/FREQUENT','N92.1, N92.5, N92.6',NULL,'polymenorrhoea','menorrhagia/pubertal bleeding X06',NULL,NULL,1,'X07');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'INTERMENSTRUAL BLEEDING','INTERMENSTRUAL BLEEDING','N92.3, N93.8, N93.9',NULL,'breakthrough bleeding, dysfunctional uterine bleeding, metrorrhagia, ovulation bleeding, spotting','post-menopausal bleeding X12; post-coital bleeding  X13',NULL,NULL,1,'X08');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PREMENSTRUAL SYMPTOM/COMPLAINT','PREMENSTRUAL SYMPTOM/COMPLAINT','N94.9',NULL,NULL,'premenstrual tension syndrome X89',NULL,NULL,1,'X09');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'POSTPONEMENT OF MENSTRUATION','POSTPONEMENT OF MENSTRUATION','Z30.9','postponement of the expected regular menstruation by hormonal treatment',NULL,NULL,NULL,NULL,1,'X10');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'MENOPAUSAL SYMPTOM/COMPLAINT','MENOPAUSAL SYMPTOM/COMPLAINT','N95.1, N95.2, N95.3, N95.8, N95.9',NULL,'atrophic vaginitis, menopause syndrome, symptom/complaint related to menopause, senile vaginitis','postmenopausal bleeding X12',NULL,NULL,1,'X11');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'POSTMENOPAUSAL BLEEDING','POSTMENOPAUSAL BLEEDING','N95.0','vaginal bleeding following either at least six months amenorrhoea or demonstration of menopause by appropriate laboratory test',NULL,NULL,'irregular menstruation X07',NULL,1,'X12');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'POSTCOITAL BLEEDING','POSTCOITAL BLEEDING','N93.0',NULL,'contact bleeding',NULL,NULL,NULL,1,'X13');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'VAGINAL DISCHARGE','VAGINAL DISCHARGE','N89.8',NULL,'fluor vaginalis, leukorrhoea','bleeding X06, X07, X08; atrophic vaginitis X11; gonorrhoea female X71; urogenital candidiasis female X72; urogenital trichomoniasis female X73; chlamydia female X92',NULL,NULL,1,'X14');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'VAGINAL SYMPTOM/COMPLAINT OTHER','VAGINAL SYMPTOM/COMPLAINT OTHER','N89.9',NULL,'dryness','genital pain X01; organic vaginismus X04; atrophic vaginitis X11',NULL,NULL,1,'X15');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'VULVAL SYMPTOM/COMPLAINT','VULVAL SYMPTOM/COMPLAINT','L29.2, N90.9',NULL,'vulval pruritus, vulval dryness','vulval pain X01; abscess vulva X99',NULL,NULL,1,'X16');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PELVIS SYMPTOM/COMPLAINT FEMALE','PELVIS SYMPTOM/COMPLAINT FEMALE','N94.9',NULL,NULL,'genital pain female X01',NULL,NULL,1,'X17');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'BREAST PAIN FEMALE','BREAST PAIN FEMALE','N64.4',NULL,'mastodynia','breast pain in pregnancy/lactation W19',NULL,NULL,1,'X18');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'BREAST LUMP/MASS FEMALE','BREAST LUMP/MASS FEMALE','N63',NULL,'lumpy breasts',NULL,NULL,NULL,1,'X19');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'NIPPLE SYMPTOM/COMPLAINT FEMALE','NIPPLE SYMPTOM/COMPLAINT FEMALE','N64.0, N64.5',NULL,'nipple discharge, nipple fissure, nipple pain/pruritus, nipple retraction','nipple symptom/complaint in pregnancy/lactation W19',NULL,NULL,1,'X20');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'BREAST SYMPTOM/COMPLAINT FEMALE OTHER','BREAST SYMPT/COMPL FEMALE OTHER','N61, N62, N64.3, N64.5, N64.9',NULL,'mastitis (non lactating), mastopathy, galactorrhoea','mastitis (lactating) W94',NULL,NULL,1,'X21');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'CONCERN ABOUT BREAST APPEARANCE FEMALE','CONCERN BREAST APPEARANCE FEMA','R46.8',NULL,NULL,NULL,NULL,NULL,1,'X22');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF SEXUALLY TRANSMITTED DISEASE FEMALE','FEAR SEXUALLY TRANSM DIS FEMALE','Z71.1','concern about/fear of sexually transmitted disease in a patient without the disease/until the diagnosis is proven',NULL,'fear of HIV/AIDS B25; if the patient has the disease, code the disease',NULL,NULL,1,'X23');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF GENITAL CANCER FEMALE','FEAR OF GENITAL CANCER FEMALE','Z71.1','concern about/fear of female genital cancer in a patient without the disease/until the diagnosis is proven',NULL,'if patient has the disease, code the disease',NULL,NULL,1,'X25');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR GENITAL/BREAST DISEASE FEMALE OTHER','FEAR GENITAL/BREAST DIS FEMALE OTHER','Z71.1','concern about/fear of other female genital/breast disease in a patient without the disease/until the diagnosis is proven',NULL,'fear of female genital cancer X25; fear of female breast cancer X26; if patient has the disease, code the disease',NULL,NULL,1,'X27');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LIMITED FUNCTION/DISABILITY (X)','LIMITED FUNCTION/DISABILITY (X)','Z73.6, Z90.7','limitation of function/disability due to a problem of the female genital system (including breast)',NULL,'sexual dysfunction P07, P08; painful intercourse female/ vaginismus X04',NULL,'The COOP/WONCA Charts are suitable for documenting the patient''s functional status (see Chapter 8).',1,'X28');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'GENITAL SYMPTOM/COMPLAINT FEMALE OTHER','GENITAL SYMPT/COMPL FEMALE OTHER','N94.9, R36',NULL,'urethral discharge in female',NULL,NULL,NULL,1,'X29');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation complete','Medical examin/health eval complete',NULL,NULL,NULL,NULL,NULL,NULL,1,'X30');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation partial','Medical examin/health eval partial',NULL,NULL,NULL,NULL,NULL,NULL,1,'X31');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Sensitivity test','Sensitivity test',NULL,NULL,NULL,NULL,NULL,NULL,1,'X32');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Microbiological/immunological test','Microbiological/immunological test',NULL,NULL,NULL,NULL,NULL,NULL,1,'X33');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Blood test','Blood test',NULL,NULL,NULL,NULL,NULL,NULL,1,'X34');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Urine test','Urine test',NULL,NULL,NULL,NULL,NULL,NULL,1,'X35');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Faeces test','Faeces test',NULL,NULL,NULL,NULL,NULL,NULL,1,'X36');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Histological/exfoliative cytology','Histological/exfoliative cytology',NULL,NULL,NULL,NULL,NULL,NULL,1,'X37');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other laboratory test NEC','Other laboratory test NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'X38');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Physical function test','Physical function test',NULL,NULL,NULL,NULL,NULL,NULL,1,'X39');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic endoscopy','Diagnostic endoscopy',NULL,NULL,NULL,NULL,NULL,NULL,1,'X40');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Electrical tracing','Electrical tracing',NULL,NULL,NULL,NULL,NULL,NULL,1,'X42');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other diagnostic procedure','Other diagnostic procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'X43');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Preventive immunization/medication','Preventive immunization/medication',NULL,NULL,NULL,NULL,NULL,NULL,1,'X44');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Observation/health education/advice/diet','Observ/health educat/advice/diet',NULL,NULL,NULL,NULL,NULL,NULL,1,'X45');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with primary care provider','Consultation primary care provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'X46');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with specialist','Consultation with specialist',NULL,NULL,NULL,NULL,NULL,NULL,1,'X47');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Clarification/discussion of patient''s RFE/demand','Clarification/discussion RFE/demand',NULL,NULL,NULL,NULL,NULL,NULL,1,'X48');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other preventive procedure','Other preventive procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'X49');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Medication/prescription/renewal/injection','Medication/prescr/renewal/inject',NULL,NULL,NULL,NULL,NULL,NULL,1,'X50');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Incision/drainage/flushing/aspiration/removal body fluid (excl. catheterisation - 53)\n
 (excl. catheterisation - 53)','I&D/flush/aspiration (excl cath -53)',NULL,NULL,NULL,NULL,NULL,NULL,1,'X51');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Excision/removal tissue/biopsy/destruction/debridement/cauterization','Exc/remov/biopsy/destruc/debrid/caut',NULL,NULL,NULL,NULL,NULL,NULL,1,'X52');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Instrumentation/catheterization/intubation/dilation','Instrument/catheter/intubate/dilate',NULL,NULL,NULL,NULL,NULL,NULL,1,'X53');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Repair/fixation-suture/cast/prosthetic device (apply/remove)','Repair/fix-suture/cast/prosth device',NULL,NULL,NULL,NULL,NULL,NULL,1,'X54');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Local injection/infiltration','Local injection/infiltration',NULL,NULL,NULL,NULL,NULL,NULL,1,'X55');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Dressing/pressure/compression/tamponade','Dressing/pressure/compress/tamponade',NULL,NULL,NULL,NULL,NULL,NULL,1,'X56');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Physical medicine/rehabilitation','Physical medicine/rehabilitation',NULL,NULL,NULL,NULL,NULL,NULL,1,'X57');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Therapeutic counselling/listening','Therapeutic counselling/listening',NULL,NULL,NULL,NULL,NULL,NULL,1,'X58');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Other therapeutic procedure/minor surgery NEC','Other therap proced/minor surg NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'X59');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result test/procedure','Result test/procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'X60');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result examination/test/record/letter from other provider','Result exam/test/lett oth provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'X61');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (5,'Administrative procedure','Administrative procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'X62');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Follow-up encounter unspecified','Follow-up encounter unspecified',NULL,NULL,NULL,NULL,NULL,NULL,1,'X63');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by provider','Encounter/prob initiated by provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'X64');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by other than patient/provider','Enc/prob init by other than pt/prov',NULL,NULL,NULL,NULL,NULL,NULL,1,'X65');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to other provider/nurse/therapist/social worker','Referral to non-MD provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'X66');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to physician/specialist/clinic/hospital','Referral to MD/specialist/clin/hosp',NULL,NULL,NULL,NULL,NULL,NULL,1,'X67');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other referral NEC','Other referral NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'X68');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other reason for encounter NEC','Other reason for encounter NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'X69');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SYPHILIS FEMALE','SYPHILIS FEMALE','A50, A51, A52, A53, A65','demonstration of Treponema pallidum on microscopy, or positive serological test for syphilis','syphilis any site',NULL,NULL,NULL,1,'X70');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'GONORRHOEA FEMALE','GONORRHOEA FEMALE','A54','purulent vaginal discharge in a patient after a contact with a proven case; or gram negative intra-cellular diplococci demonstrated in discharge; or culture of Neisseria gonorrhea','gonorrhea any site',NULL,'urethritis U72; urethral discharge X29',NULL,1,'X71');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'GENITAL CANDIDIASIS FEMALE','GENITAL CANDIDIASIS FEMALE','B37.3, B37.4','inflamed urogenital mucosa or skin with characteristic white adherent exudate; or demonstration of candida','monilial infection of vagina/cervix, thrush',NULL,'vaginal discharge X14; vaginitis X84',NULL,1,'X72');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'GENITAL TRICHOMONIASIS FEMALE','GENITAL TRICHOMONIASIS FEMALE','A59.0','characteristic foul smelling discharge or demonstration of trichomonads on microscopy',NULL,NULL,'vaginal discharge X14; vaginitis X84',NULL,1,'X73');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PELVIC INFLAMMATORY DISEASE','PELVIC INFLAMMATORY DISEASE','N70, N71, N73, N74','lower abdominal pain with marked tenderness of uterus or adnexa by palpation, plus other evidence of inflammation','endometritis, oophoritis, salpingitis','sexually transmitted diseases female X70-X73; chlamydia infection female X92','pelvic congestion syndrome X99',NULL,1,'X74');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM CERVIX','MALIGNANT NEOPLASM CERVIX','C53, D06','characteristic histological appearance','carcinoma-in-situ cervix, cervical intraepithelial neoplasia (CIN) grade 3','abnormal  cervix smear (CIN) grades 1 and 2  X86',NULL,NULL,1,'X75');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM BREAST FEMALE','MALIGNANT NEOPLASM BREAST FEMALE','C50','characteristic histological appearance','carcinoma-in-situ female breast, intraductal carcinoma',NULL,'breast lump X19',NULL,1,'X76');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM GENITAL FEMALE OTHER','MALIGNANT NEOPL GENITAL FEMALE OTHER','C51, C52, C54, C55, C56, C57','characteristic histological appearance','malignancy of adnexae, ovaries, uterus, vagina, vulva','carcinoma-in-situ cervix X75; other female genital carcinoma-in-situ X81','other/unspecified female genital neoplasm X81',NULL,1,'X77');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'FIBROMYOMA UTERUS','FIBROMYOMA UTERUS','D25','enlargement of the uterus not due to pregnancy or malignancy, with single or multiple firm tumours of the uterus','fibroid uterus, fibromyoma of cervix, myoma',NULL,NULL,NULL,1,'X78');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BENIGN NEOPLASM FEMALE GENITAL','BENIGN NEOPLASM FEMALE GENITAL','D26, D27, D28',NULL,NULL,'polyp of cervix X85; physiological cyst of ovary X99',NULL,NULL,1,'X80');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'GENITAL NEOPLASM FEMALE OTHER/UNSPECIFIED','GENITAL NEOPL FEMALE OTHER/UNSPECIF','D05, D07.0, D07.1, D07.2, D07.3, D39, D48.6',NULL,'other carcinoma-in-situ','carcinoma-in-situ cervix X75; endometrial polyp X99',NULL,NULL,1,'X81');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'INJURY GENITAL FEMALE','INJURY GENITAL FEMALE','S30.2, S31.4, S31.5, S37.4, S37.5, S37.6, S38.0, S38.2, T19.2, T19.3, T28.3, T28.8',NULL,'foreign body in vagina, female circumcision','genital injury due to childbirth W92, W93',NULL,NULL,1,'X82');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONGENITAL ANOMALY GENITAL FEMALE','CONGENITAL ANOMALY GENITAL FEMALE','Q50, Q51, Q52, Q56, Q83',NULL,'hermaphrodytism, imperforate hymen','other genetic syndrome A90',NULL,NULL,1,'X83');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'VAGINITIS/VULVITIS NOS','VAGINITIS/VULVITIS NOS','N76, N77',NULL,'vaginosis, gardnerella','atrophic vaginitis X11; genital candidiasis X72; genital trichomoniasis X73',NULL,NULL,1,'X84');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CERVICAL DISEASE NOS','CERVICAL DISEASE NOS','N72, N84.1, N86, N88',NULL,'cervical erosion, cervical leukoplakia, cervicitis, mucous cervical polyp, old laceration of cervix','abnormality of cervix in pregnancy/childbirth/puerperium W77; abnormal cervix smear X86',NULL,NULL,1,'X85');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ABNORMAL CERVIX SMEAR','ABNORMAL CERVIX SMEAR','N87',NULL,'cervical intraepithelial neoplasia (CIN) grades 1 and 2, cervical dysplasia','cervical intraepithelial neoplasia (CIN) grade 3 X75',NULL,NULL,1,'X86');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'UTEROVAGINAL PROLAPSE','UTEROVAGINAL PROLAPSE','N81',NULL,'cystocoele, procidentia, rectocoele','stress incontinence U04',NULL,NULL,1,'X87');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'FIBROCYSTIC DISEASE BREAST','FIBROCYSTIC DISEASE BREAST','N60',NULL,'chronic cystic disease of breast, cystic fibroadenosis of breast, dysplasia of breast, solitary cyst of breast',NULL,NULL,NULL,1,'X88');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PREMENSTRUAL TENSION SYNDROME','PREMENSTRUAL TENSION SYNDROME','N94.3','cyclic occurrence in the menstrual cycle of two or more of  the following: oedema; breast tenderness/swelling; headache; irritability; mood changes',NULL,NULL,'premenstrual symptom X09',NULL,1,'X89');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'GENITAL HERPES FEMALE','GENITAL HERPES FEMALE','A60','small vesicles with characteristic appearance and location which evolve to painful ulcers and scabs','ano-genital herpes simplex female',NULL,NULL,NULL,1,'X90');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CHLAMYDIA INFECTION GENITAL FEMALE','CHLAMYDIA INFECTION GENITAL FEMALE','A56.0, A56.1, A56.3, A56.4, A56.8','proven chlamydial infection',NULL,NULL,NULL,NULL,1,'X92');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'GENITAL DISEASE FEMALE OTHER','GENITAL DISEASE FEMALE OTHER','A55, A57, A58, A63.8, N61, N64.1, N64.2, N64.8, N75, N80, N82, N83, N84.0, N84.2, N84.3, N84.8, N84.9, N85, N89.0, N89.1, N89.2, N89.3, N89.4, N89.5, N89.6, N89.7, N90.0, N90.1, N90.2, N90.3, N90.4, N90.5, N90.6, N90.7, N90.8, N94.8, N94.9, N96, N98, Z90.1, Z90.7',NULL,'Bartholin cyst/abscess, endometriosis, genital tract fistula, pelvic congestion syndrome, physiological ovarian cyst','sexually transmitted disease NOS A78',NULL,NULL,1,'X99');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PAIN IN PENIS','PAIN IN PENIS','N48.9, R52',NULL,NULL,'priapism/painful erection Y08',NULL,NULL,1,'Y01');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PAIN IN TESTIS/SCROTUM','PAIN IN TESTIS/SCROTUM','N50.9, R10.2, R52',NULL,'pain perineum, pain pelvis',NULL,NULL,NULL,1,'Y02');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'URETHRAL DISCHARGE','URETHRAL DISCHARGE','R36',NULL,NULL,NULL,NULL,NULL,1,'Y03');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PENIS SYMPTOM/COMPLAINT OTHER','PENIS SYMPTOM/COMPLAINT OTHER','N48.9',NULL,'foreskin symptom/complaint','pain in penis Y01; painful erection/priapism Y08',NULL,NULL,1,'Y04');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SCROTUM/TESTIS SYMPTOM/COMPLAINT OTHER','SCROTUM/TESTIS SYMPT/COMPL OTHER','L29.1, N50.9',NULL,'lump in testis','pain in testis/scrotum Y02',NULL,NULL,1,'Y05');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PROSTATE SYMPTOM/COMPLAINT','PROSTATE SYMPTOM/COMPLAINT','N42.9',NULL,'prostatism','urinary frequency/urgency U02; urinary retention U08',NULL,NULL,1,'Y06');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'IMPOTENCE NOS','IMPOTENCE NOS','N48.4',NULL,'impotence of organic origin','reduced sexual desire P07; psychogenic impotence/reduced sexual fulfilment P08',NULL,NULL,1,'Y07');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SEXUAL FUNCTION SYMPTOM/COMPLAINT MALE','SEXUAL FUNCTION SYMPT/COMPL MALE','N48.3, N48.9',NULL,'painful erection, priapism','reduced sexual desire P07; psychogenic impotence/reduced sexual fulfilment P08',NULL,NULL,1,'Y08');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'INFERTILITY/SUBFERTILITY MALE','INFERTILITY/SUBFERTILITY MALE','N46','failure of conception after 2 years of trying',NULL,NULL,NULL,NULL,1,'Y10');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'STERILIZATION MALE','STERILIZATION MALE','Z30.2',NULL,'family planning involving male sterilization',NULL,NULL,NULL,1,'Y13');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FAMILY PLANNING MALE OTHER','FAMILY PLANNING MALE OTHER','Z30.0, Z30.8, Z30.9',NULL,'contraception NOS, family planning NOS','genetic counseling A98',NULL,NULL,1,'Y14');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'BREAST SYMPTOM/COMPLAINT MALE','BREAST SYMPTOM/COMPLAINT MALE','N62, N63',NULL,'lump male breast, gynaecomastia','disease of male breast Y99',NULL,NULL,1,'Y16');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF SEXUALLY TRANSMITTED DISEASE MALE','FEAR SEXUALLY TRANSM DISEASE MALE','Z71.1','concern about/fear of venereal disease in a patient without the disease/until the diagnosis is proven',NULL,'fear of HIV/AIDS B25; in a patient with the disease, code the disease',NULL,NULL,1,'Y25');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF GENITAL CANCER MALE','FEAR OF GENITAL CANCER MALE','Z71.1','concern about/fear of cancer in a patient without the disease/until the diagnosis is proven',NULL,'in a patient with the disease, code the disease',NULL,NULL,1,'Y26');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF GENITAL DISEASE MALE OTHER','FEAR OF GENITAL DISEASE MALE OTHER','Z71.1','concern about/fear of other genital disease in a patient without the disease/until the diagnosis is proven',NULL,'fear of sexually transmitted disease Y25; fear of genital cancer Y26; in a patient with the disease, code the disease',NULL,NULL,1,'Y27');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LIMITED FUNCTION/DISABILITY (Y)','LIMITED FUNCTION/DISABILITY (Y)','Z73.6, Z90.7','limitation of function/disability due to a problem of the male genital system (including breast)',NULL,'sexual dysfunction P07, P08; impotence NOS Y07',NULL,'The COOP/WONCA Charts are suitable for documenting the patient''s functional status (see Chapter 8).',1,'Y28');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'GENITAL SYMPTOM/COMPLAINT MALE OTHER','GENITAL SYMPTOM/COMPLAINT MALE OTHER','N50.9',NULL,NULL,NULL,NULL,NULL,1,'Y29');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation complete','Medical examin/health eval complete',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y30');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation partial','Medical examin/health eval partial',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y31');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Sensitivity test','Sensitivity test',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y32');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Microbiological/immunological test','Microbiological/immunological test',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y33');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Blood test','Blood test',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y34');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Urine test','Urine test',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y35');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Faeces test','Faeces test',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y36');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Histological/exfoliative cytology','Histological/exfoliative cytology',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y37');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other laboratory test NEC','Other laboratory test NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y38');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Physical function test','Physical function test',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y39');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic endoscopy','Diagnostic endoscopy',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y40');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic radiology/imaging','Diagnostic radiology/imaging',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y41');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Electrical tracing','Electrical tracing',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y42');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other diagnostic procedure','Other diagnostic procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y43');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Preventive immunization/medication','Preventive immunization/medication',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y44');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Observation/health education/advice/diet','Observ/health educat/advice/diet',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y45');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with primary care provider','Consultation primary care provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y46');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with specialist','Consultation with specialist',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y47');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Clarification/discussion of patient''s RFE/demand','Clarification/discussion RFE/demand',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y48');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other preventive procedure','Other preventive procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y49');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Medication/prescription/renewal/injection','Medication/prescr/renewal/inject',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y50');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Excision/removal tissue/biopsy/destruction/debridement/cauterization','Exc/remov/biopsy/destruc/debrid/caut',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y52');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Instrumentation/catheterization/intubation/dilation','Instrument/catheter/intubate/dilate',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y53');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Repair/fixation-suture/cast/prosthetic device (apply/remove)','Repair/fix-suture/cast/prosth device',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y54');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Local injection/infiltration','Local injection/infiltration',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y55');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Dressing/pressure/compression/tamponade','Dressing/pressure/compress/tamponade',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y56');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Physical medicine/rehabilitation','Physical medicine/rehabilitation',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y57');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Therapeutic counselling/listening','Therapeutic counselling/listening',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y58');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Other therapeutic procedure/minor surgery NEC','Other therap proced/minor surg NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y59');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result test/procedure','Result test/procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y60');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result examination/test/record/letter from other provider','Result exam/test/lett oth provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y61');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (5,'Administrative procedure','Administrative procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y62');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Follow-up encounter unspecified','Follow-up encounter unspecified',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y63');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by provider','Encounter/prob initiated by provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y64');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by other than patient/provider','Enc/prob init by other than pt/prov',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y65');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to other provider/nurse/therapist/social worker','Referral to non-MD provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y66');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to physician/specialist/clinic/hospital','Referral to MD/specialist/clin/hosp',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y67');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other referral NEC','Other referral NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y68');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other reason for encounter NEC','Other reason for encounter NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y69');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SYPHILIS MALE','SYPHILIS MALE','A50, A51, A52, A53, A65','demonstration of Treponema pallidum on microscopy, or positive serological test for syphilis','syphilis any site',NULL,NULL,NULL,1,'Y70');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'GONORRHOEA MALE','GONORRHOEA MALE','A54','urethral or rectal discharge with gram-negative intracellular diplococci demonstrated in a patient after a contact with a proven case, or Neisseria gonorrhoea cultured','gonorrhoea any site',NULL,'urethritis U72; urethral discharge Y03',NULL,1,'Y71');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'GENITAL HERPES MALE','GENITAL HERPES MALE','A60','small vesicles with characteristic appearance and location which evolve to painful ulcers and scabs','anogenital herpes, herpes genitalis male',NULL,NULL,NULL,1,'Y72');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PROSTATITIS/SEMINAL VESICULITIS','PROSTATITIS/SEMINAL VESICULITIS','A59.0, N41, N49.0','tenderness of prostate/seminal vesicles to palpation, and indications of inflammation in urine test',NULL,NULL,NULL,NULL,1,'Y73');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'ORCHITIS/EPIDIDYMITIS','ORCHITIS/EPIDIDYMITIS','N45','both swelling and tenderness of testes/epididymis, and absence of a specific aetiology (mumps, gonococcal, tuberculosis, trauma, or torsion)',NULL,'tuberculosis A70; mumps D71; gonococcal orchitis Y71; torsion of testis Y99','symptoms of testis Y05',NULL,1,'Y74');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BALANITIS','BALANITIS','B37.4, N48.1','signs of inflammation of the prepuce/glans penis','candidiasis glans penis','scabies S72; male syphilis Y70; male gonorrhea Y71; male genital herpes Y72',NULL,NULL,1,'Y75');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONDYLOMATA ACUMINATA MALE','CONDYLOMATA ACUMINATA MALE','A63.0','characteristic appearance of lesions, or characteristic histological appearance','venereal warts, human papilloma virus infection in men',NULL,NULL,NULL,1,'Y76');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM PROSTATE','MALIGNANT NEOPLASM PROSTATE','C61','characteristic histological appearance',NULL,NULL,'benign/unspecified neoplasm male genital Y79',NULL,1,'Y77');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM MALE GENITAL OTHER','MALIGN NEOPL MALE GENITAL OTHER','C50, C60, C62, C63','characteristic histological appearance','carcinoma testis/seminoma, carcinoma male breast',NULL,'benign/unspecified neoplasm male genital Y79',NULL,1,'Y78');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BENIGN/UNSPECIFIED NEOPLASM MALE GENITAL','BENIGN/UNSPECIF NEOPL MALE GENITAL','D07.4, D07.5, D07.6, D24, D29, D40, D48.6',NULL,'benign male genital neoplasm, neoplasm not specified as benign or malignant/when histology is not available, benign neoplasm male breast','prostatic hypertrophy Y85',NULL,NULL,1,'Y79');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'INJURY MALE GENITAL','INJURY MALE GENITAL','S30.2, S31.2, S31.3, S31.5, S38.0, S38.2, T28.3, T28.8',NULL,'circumcision',NULL,NULL,NULL,1,'Y80');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PHIMOSIS/REDUNDANT PREPUCE','PHIMOSIS/REDUNDANT PREPUCE','N47','for redundant prepuce: excessive length of prepuce, with inability to retract over the glans penis; \n
for phimosis: tightness of the prepuce which prevents retraction over the glans penis','paraphimosis',NULL,NULL,NULL,1,'Y81');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HYPOSPADIAS','HYPOSPADIAS','Q54',NULL,NULL,NULL,NULL,NULL,1,'Y82');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'UNDESCENDED TESTICLE','UNDESCENDED TESTICLE','Q53','the testicle has never been observed in the scrotum, and the testicle cannot be manipulated into the scrotum','cryptorchidism','retractile testis Y84',NULL,NULL,1,'Y83');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONGENITAL GENITAL ANOMALY MALE OTHER','CONGENITAL GENITAL ANOM MALE OTHER','Q55, Q56, Q83',NULL,'hermaphroditism, retractile testis',NULL,NULL,NULL,1,'Y84');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BENIGN PROSTATIC HYPERTROPHY','BENIGN PROSTATIC HYPERTROPHY','N40','enlarged, smooth, firm prostate demonstrated by palpation/cystoscopy/imaging, with no evidence of prostatic carcinoma','fibroma, hyperplasia, median bar of prostate, prostatic obstruction, prostatomegaly',NULL,'symptom/complaint about urination U01, U02, U03, U04, U05; retention of urine U08',NULL,1,'Y85');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'HYDROCOELE','HYDROCOELE','N43.0, N43.1, N43.2, N43.3','non-tender fluctuant swelling surrounding testis or spermatic cord with transillumination of the swelling or imaging evidence',NULL,NULL,'symptom/complaint of scrotum/testis other Y05',NULL,1,'Y86');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'GENITAL DISEASE MALE OTHER','GENITAL DISEASE MALE OTHER','A55, A57, A58, A63.8, N42.0, N42.1, N42.2, N42.8, N42.9, N43.4, N44, N48.0, N48.2, N48.5, N48.6, N48.8, N49.1, N49.2, N49.8, N49.9, N50.0, N50.1, N50.8, N50.9, N51, N64.8, Z90.7',NULL,'disease of male breast; epididymal cyst; spermatocoele, torsion of the testis','sexually transmitted disease NOS A78; gynaecomastia Y16; carcinoma male breast Y78',NULL,NULL,1,'Y99');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (NULL,'SOCIAL PROBLEMS','SOCIAL PROBLEMS',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'POVERTY/FINANCIAL PROBLEM','POVERTY/FINANCIAL PROBLEM','Z59.5, Z59.6, Z59.7, Z59.8, Z59.9',NULL,NULL,NULL,NULL,'Problems with living conditions essentially require the patient''s expression of concern about them, with agreement about the existence of the problem and desire for help. Whatever the objective living conditions, patients can consider these as a problem. Labelling these problems requires acknowledgement of absolute differences in living conditions, as well as the individual''s perception.',1,'Z01');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FOOD/WATER PROBLEM','FOOD/WATER PROBLEM','Z58.6, Z59.4',NULL,NULL,NULL,NULL,'Problems with living conditions essentially require the patient''s expression of concern about them, with agreement about the existence of the problem and desire for help. Whatever the objective living conditions, patients can consider these as a problem. Labelling these problems requires acknowledgement of absolute differences in living conditions, as well as the individual''s perception.',1,'Z02');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'HOUSING/NEIGHBOURHOOD PROBLEM','HOUSING/NEIGHBOURHOOD PROBLEM','Z59.0, Z59.1, Z59.2, Z59.3, Z59.8, Z59.9',NULL,NULL,NULL,NULL,'Problems with living conditions essentially require the patient''s expression of concern about them, with agreement about the existence of the problem and desire for help. Whatever the objective living conditions, patients can consider these as a problem. Labelling these problems requires acknowledgement of absolute differences in living conditions, as well as the individual''s perception.',1,'Z03');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SOCIAL CULTURAL PROBLEM','SOCIAL CULTURAL PROBLEM','Z60.1, Z60.2, Z60.3, Z60.4, Z60.5, Z60.8, Z60.9',NULL,'illegitimate pregnancy','unwanted pregnancy W79',NULL,'Problems with living conditions essentially require the patient''s expression of concern about them, with agreement about the existence of the problem and desire for help. Whatever the objective living conditions, patients can consider these as a problem. Labelling these problems requires acknowledgement of absolute differences in living conditions, as well as the individual''s perception.',1,'Z04');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'WORK PROBLEM','WORK PROBLEM','Z56.1, Z56.2, Z56.3, Z56.4, Z56.5, Z56.6, Z56.7, Z57',NULL,NULL,NULL,NULL,'Problems with working conditions essentially require the patient''s expression of concern about them, with agreement about the existence of the problem and desire for help. Whatever the objective working conditions, patients can consider these as a problem.  Labelling these problems requires acknowledgement of absolute differences in working conditions, as well as the individual''s perception.',1,'Z05');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'UNEMPLOYMENT PROBLEM','UNEMPLOYMENT PROBLEM','Z56.0',NULL,NULL,'retirement problem P25',NULL,'Problems with unemployment essentially require the patient''s expression of concern about them, with agreement about the existence of the problem and desire for help. Whatever the objective nature of the unemployment, patients can consider this as a problem. Labelling these problems requires acknowledgement of absolute differences in unemployment, as well as the individual''s perception.',1,'Z06');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'EDUCATION PROBLEM','EDUCATION PROBLEM','Z55',NULL,'illiteracy',NULL,NULL,'Problems with education essentially require the patient''s expression of concern about them, with agreement about the existence of the problem and desire for help. Whatever the objective education status, patients can consider this as a problem. Labelling these problems requires acknowledgement of absolute differences in education, as well as the individual''s perception.',1,'Z07');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SOCIAL WELFARE PROBLEM','SOCIAL WELFARE PROBLEM','Z59.7',NULL,NULL,NULL,NULL,'Problems with social welfare essentially require the patient''s expression of concern about them, with agreement about the existence of the problem and desire for help. Whatever the objective social welfare situation, patients can consider this as a problem. Labelling these problems requires acknowledgement of absolute differences in social welfare, as well as the individual''s perception.',1,'Z08');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LEGAL PROBLEM','LEGAL PROBLEM','Z65.0, Z65.1, Z65.2, Z65.3',NULL,NULL,NULL,NULL,'Problems with legal issues essentially require the patient''s expression of concern about them, with agreement about the existence of the problem and desire for help. Whatever the objective legal issues, patients can consider these as a problem. Labelling these problems requires acknowledgement of absolute differences in legal issues as well as the individual''s perception.',1,'Z09');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'HEALTH CARE SYSTEM PROBLEM','HEALTH CARE SYSTEM PROBLEM','Z64.4, Z75',NULL,NULL,NULL,NULL,'Problems with the health care system essentially require the patient''s expression of concern about them, with agreement about the existence of the problem and desire for help. Whatever the objective health care system, patients can consider this as a problem. Labelling these problems requires acknowledgement of absolute differences in the health care system as well as the individual''s perception.',1,'Z10');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'COMPLIANCE/BEING ILL PROBLEM','COMPLIANCE/BEING ILL PROBLEM','Z75',NULL,'poor compliance',NULL,NULL,'The diagnosis of social problems arising due to being ill requires the patient''s agreement on the existence of the problem and desire for help.',1,'Z11');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'RELATIONSHIP PROBLEM WITH PARTNER','RELATIONSHIP PROBLEM WITH PARTNER','T74.0, T74.3, Z63.0',NULL,'emotional abuse','physical abuse Z25',NULL,'The diagnosis of problems in the relationship between family partners requires the patient''s agreement on the existence of the problem and desire for help.',1,'Z12');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PARTNER''S BEHAVIOUR PROBLEM','PARTNER''S BEHAVIOUR PROBLEM','Z63.0',NULL,'infidelity, physical abuse',NULL,NULL,'The diagnosis of problems arising from the behaviour of a family partner requires the patient''s agreement on the existence of the problem and desire for help.',1,'Z13');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'PARTNER ILLNESS PROBLEM','PARTNER ILLNESS PROBLEM','Z63.6',NULL,NULL,NULL,NULL,'The diagnosis of problems arising from one or both family partners being ill requires the patient''s agreement on the existence of the problem and desire for help.',1,'Z14');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LOSS/DEATH OF PARTNER PROBLEM','LOSS/DEATH OF PARTNER PROBLEM','Z63.4, Z63.5',NULL,'bereavement, divorce, separation',NULL,NULL,'The diagnosis of problems arising from the loss or death of a family partner requires the patient''s agreement on the existence of the problem and desire for help.',1,'Z15');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'RELATIONSHIP PROBLEM WITH CHILD','RELATIONSHIP PROBLEM WITH CHILD','T74.0, T74.3, Z61, Z62, Z63.8',NULL,'child abuse (emotional)','physical abuse Z25',NULL,'The diagnosis of problems in the relationship with a child requires the patient''s agreement on the existence of the problem and desire for help.',1,'Z16');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ILLNESS PROBLEM WITH CHILD','ILLNESS PROBLEM WITH CHILD','Z63.6',NULL,NULL,NULL,NULL,'The diagnosis of problems arising due to a child being ill requires the patient''s agreement on the existence of the problem and desire for help.',1,'Z18');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LOSS/DEATH OF CHILD PROBLEM','LOSS/DEATH OF CHILD PROBLEM','Z63.4',NULL,NULL,NULL,NULL,'The diagnosis of problems arising from the loss or death of a child in the family requires the patient''s agreement on the existence of the problem and desire for help.',1,'Z19');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'RELATIONSHIP PROBLEM PARENT/FAMILY','RELATIONSHIP PROBLEM PARENT/FAMILY','T74.0, Z63.1, Z63.8',NULL,'relationship problem with parent/adult sibling/other family member','relationship problem with partner Z12; relationship problem with child Z16; relationship problem with friend Z24',NULL,'The diagnosis of problems in the relationship between family members requires the patient''s agreement on the existence of the problem and desire for help.',1,'Z20');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ILLNESS PROBLEM PARENT/FAMILY','ILLNESS PROBLEM PARENT/FAMILY','Z63.6, Z63.7',NULL,NULL,'problem with partner being ill Z14',NULL,'The diagnosis of problems arising from the illness of a family member requires the patient''s agreement on the existence of the problem and desire for help.',1,'Z22');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LOSS/DEATH OF PARENT/FAMILY MEMBER PROBLEM','LOSS/DEATH PARENT/FAM MEMB PROBLEM','Z63.4',NULL,NULL,'loss of partner Z15; loss of child Z19',NULL,'The diagnosis of problems arising from the loss or death of a family member requires the patient''s agreement on the existence of the problem and desire for help.',1,'Z23');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'RELATIONSHIP PROBLEM FRIEND','RELATIONSHIP PROBLEM FRIEND','Z63.9',NULL,NULL,'relationship problem with family member Z20',NULL,'The diagnosis of problems in the relationship with friends requires the patient''s agreement on the existence of the problem and desire for help.',1,'Z24');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'ASSAULT/HARMFUL EVENT PROBLEM','ASSAULT/HARMFUL EVENT PROBLEM','T74.1, T74.2, T74.8, T74.9, Z65.4, Z65.5',NULL,'victim of physical abuse, rape, sexual attack','physical problems to be coded in appropriate rubric(s) in other chapters; psychological problems to be coded in Chapter P',NULL,'The diagnosis of social problems arising from assaults and other harmful events requires the patient''s agreement on the existence of the problem and desire for help.',1,'Z25');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF A SOCIAL PROBLEM','FEAR OF A SOCIAL PROBLEM','Z71.1','fear of a social problem in a patient without the problem','concern about/fear of having a social problem','if patient has a social problem, code the problem',NULL,NULL,1,'Z27');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LIMITED  FUNCTION/DISABILITY (Z)','LIMITED FUNCTION/DISABILITY (Z)','Z73.4, Z73.6','limitation of function/disability caused by social problems, including isolation/living alone/loneliness',NULL,NULL,NULL,'The COOP/WONCA Charts are suitable for documenting the patient''s functional status (see Chapter 8).',1,'Z28');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SOCIAL PROBLEM NOS','SOCIAL PROBLEM NOS','Z58.0, Z58.1, Z58.2, Z58.3, Z58.4, Z58.5, Z58.8, Z58.9, Z63.2, Z63.3, Z63.7, Z63.8, Z63.9, Z64.0, Z64.1, Z65.8, Z65.9, Z72.6, Z72.8, Z72.9, Z73.5, Z73.8, Z73.9',NULL,'environmental problems, malingering',NULL,NULL,NULL,1,'Z29');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation complete','Medical examin/health eval complete',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z30');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation partial','Medical examin/health eval partial',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z31');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Sensitivity test','Sensitivity test',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z32');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Microbiological/immunological test','Microbiological/immunological test',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z33');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Blood test','Blood test',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z34');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Urine test','Urine test',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z35');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Faeces test','Faeces test',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z36');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Histological/exfoliative cytology','Histological/exfoliative cytology',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z37');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other laboratory test NEC','Other laboratory test NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z38');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Physical function test','Physical function test',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z39');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic endoscopy','Diagnostic endoscopy',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z40');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic radiology/imaging','Diagnostic radiology/imaging',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z41');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Electrical tracing','Electrical tracing',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z42');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other diagnostic procedure','Other diagnostic procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z43');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Preventive immunization/medication','Preventive immunization/medication',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z44');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Observation/health education/advice/diet','Observ/health educat/advice/diet',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z45');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with primary care provider','Consultation primary care provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z46');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with specialist','Consultation with specialist',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z47');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Clarification/discussion of patient''s RFE/demand','Clarification/discussion RFE/demand',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z48');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Medication/prescription/renewal/injection','Medication/prescr/renewal/inject',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z50');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Incision/drainage/flushing/aspiration/removal body fluid (excl. catheterisation - 53)\n
 (excl. catheterisation - 53)','I&D/flush/aspiration (excl cath -53)',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z51');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Excision/removal tissue/biopsy/destruction/debridement/cauterization','Exc/remov/biopsy/destruc/debrid/caut',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z52');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Instrumentation/catheterization/intubation/dilation','Instrument/catheter/intubate/dilate',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z53');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Repair/fixation-suture/cast/prosthetic device (apply/remove)','Repair/fix-suture/cast/prosth device',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z54');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Local injection/infiltration','Local injection/infiltration',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z55');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Dressing/pressure/compression/tamponade','Dressing/pressure/compress/tamponade',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z56');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Physical medicine/rehabilitation','Physical medicine/rehabilitation',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z57');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Therapeutic counselling/listening','Therapeutic counselling/listening',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z58');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Other therapeutic procedure/minor surgery NEC','Other therap proced/minor surg NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z59');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result test/procedure','Result test/procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z60');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result examination/test/record/letter from other provider','Result exam/test/lett oth provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z61');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (5,'Administrative procedure','Administrative procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z62');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Follow-up encounter unspecified','Follow-up encounter unspecified',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z63');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by provider','Encounter/prob initiated by provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z64');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by other than patient/provider','Enc/prob init by other than pt/prov',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z65');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to other provider/nurse/therapist/social worker','Referral to non-MD provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z66');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to physician/specialist/clinic/hospital','Referral to MD/specialist/clin/hosp',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z67');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other referral NEC','Other referral NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z68');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other reason for encounter NEC','Other reason for encounter NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z69');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'LIMITED FUNCTION/DISABILITY (N)','LIMITED FUNCTION/DISABILITY (N)','Z73.6','limitation of function/disability due to a neurological problem','l',NULL,NULL,'The COOP/WONCA Charts are suitable for documenting the patient''s functional status (see Chapter 8).',1,'N28');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Consultation with specialist','Consultation with specialist',NULL,NULL,NULL,NULL,NULL,NULL,1,'A47');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF CANCER BLOOD/LYMPH','FEAR CANCER BLOOD/LYMPH','Z71.1','concern about/fear of blood/lymph cancer in a patient without the disease/until the diagnosis is proven',NULL,'if the patient has the disease, code the disease',NULL,NULL,1,'B26');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'HEARTBURN','HEARTBURN','R12',NULL,'acidity, waterbrash','epigastric pain D02; dyspepsia/indigestion D07; oesophagitis/reflux D84',NULL,NULL,1,'D03');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'HEPATOMEGALY','HEPATOMEGALY','R16.0, R16.2',NULL,NULL,NULL,NULL,NULL,1,'D23');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Physical function test','Physical function test',NULL,NULL,NULL,NULL,NULL,NULL,1,'D39');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'PEPTIC ULCER OTHER','PEPTIC ULCER OTHER','K25, K27, K28','characteristic imaging/endoscopy findings; or exacerbation of symptoms in a patient with a previously proven ulcer','gastric/gastrojejunal/marginal ulcer, acute erosion','oesophageal ulcer D84; duodenal ulcer D85','heartburn D03; dyspepsia/indigestion D07',NULL,1,'D86');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Sensitivity test','Sensitivity test',NULL,NULL,NULL,NULL,NULL,NULL,1,'F32');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (4,'Result test/procedure','Result test/procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'F60');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CORNEAL ULCER','CORNEAL ULCER','H16.0, H19',NULL,'dendritic ulcer, viral keratitis','corneal abrasion/other eye injury F79',NULL,NULL,1,'F85');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Sensitivity test','Sensitivity test',NULL,NULL,NULL,NULL,NULL,NULL,1,'H32');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Observation/health education/advice/diet','Observ/health educat/advice/diet',NULL,NULL,NULL,NULL,NULL,NULL,1,'H45');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Other referral NEC','Other referral NEC',NULL,NULL,NULL,NULL,NULL,NULL,1,'H68');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'NEOPLASM OF EAR','NEOPLASM OF EAR','C30.1, D48.9',NULL,'benign/malignant neoplasm of ear','polyp ear H99; acoustic neuroma N75',NULL,NULL,1,'H75');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'IRREGULAR HEARTBEAT OTHER','IRREGULAR HEARTBEAT OTHER','R00.8',NULL,NULL,'palpitations K04',NULL,NULL,1,'K05');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (NULL,'MUSCULOSKELETAL','MUSCULOSKELETAL',NULL,NULL,NULL,NULL,NULL,NULL,1,'L');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'HIP SYMPTOM/COMPLAINT','HIP SYMPTOM/COMPLAINT','M25.4, M25.5, M25.6, R29.4',NULL,NULL,NULL,NULL,NULL,1,'L13');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (5,'Administrative procedure','Administrative procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'L62');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'SPRAIN/STRAIN OF ANKLE','SPRAIN/STRAIN OF ANKLE','S93.4','stretch injury of the affected part plus pain aggravated by stretching or tensing the affected structure',NULL,NULL,'ankle symptom L16',NULL,1,'L77');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'TENNIS ELBOW','TENNIS ELBOW','M77.1',NULL,'lateral epicondylitis','other tendinitis L87',NULL,NULL,1,'L93');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'EXCESSIVE APPETITE','EXCESSIVE APPETITE','R63.2',NULL,'overeating, polyphagia','bulimia P86',NULL,NULL,1,'T02');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Incision/drainage/flushing/aspiration/removal body fluid (excl. catheterisation - 53)\n
 (excl. catheterisation - 53)','I&D/flush/aspiration (excl cath -53)',NULL,NULL,NULL,NULL,NULL,NULL,1,'T51');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Encounter/problem initiated by provider','Encounter/prob initiated by provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'T64');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Physical function test','Physical function test',NULL,NULL,NULL,NULL,NULL,NULL,1,'U39');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Medical examination/health evaluation complete','Medical examin/health eval complete',NULL,NULL,NULL,NULL,NULL,NULL,1,'W30');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Diagnostic radiology/imaging','Diagnostic radiology/imaging',NULL,NULL,NULL,NULL,NULL,NULL,1,'X41');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (3,'Incision/drainage/flushing/aspiration/removal body fluid (excl. catheterisation - 53)\n
 (excl. catheterisation - 53)','I&D/flush/aspiration (excl cath -53)',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y51');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'BEHAVIOUR PROBLEM PARENT/FAMILY','BEHAVIOUR PROBLEM PARENT/FAMILY','Z63.1, Z63.9',NULL,NULL,'symptom/complaint behaviour of child P22; symptom/complaint behaviour  adolescent P23; problem with behaviour partner Z13',NULL,'The diagnosis of problems arising from the behaviour of a family member requires the patient''s agreement on the existence of the problem and desire for help.',1,'Z21');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other preventive procedure','Other preventive procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'Z49');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (NULL,'COMPONENT 7 CHAPTER P','COMPONENT 7 CHAPTER P',NULL,NULL,NULL,NULL,NULL,'A mental disorder is a clinically significant psychological syndrome or pattern, with or without an association with stressors (such as disability, increased risk, or an important loss), which cannot be considered an expected response to a particular event, but rather a manifestation of a behavioural, psychological or biological dysfunction.',1,'P7');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'POST-PARTUM BLEEDING','POST-PARTUM BLEEDING','O72','heavy bleeding at or within 6 weeks of parturition',NULL,NULL,'other post-partum complaints W18',NULL,1,'W17');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'MALIGNANT NEOPLASM BLOOD OTHER','MALIGNANT NEOPLASM BLOOD OTHER','C37, C46.3, C77, C88, C90, C96',NULL,'myeloproliferative disease, multiple myeloma','Hodgkin''s disease/lymphoma B72',NULL,NULL,1,'B74');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'DIABETES INSULIN DEPENDENT','DIABETES INSULIN DEPENDENT','E10','patient requiring regular ongoing treatment with insulin after diagnosis confirmed by one of the following:(a) the classic symptoms of diabetes, such as polyuria, polydypsia, and rapid weight loss, together with unequivocal elevation of plasma glucose (b) fasting blood glucose levels of 8mmol/l (l40mg/dl) or more on two or more occasions (c) random blood glucose levels of 11mmol/l (200mg/dl) or more on two or more occasions (d) an oral Glucose Tolerance Test (75gm glucose) with one value of plasma glucose at between one and two hours of 11mmol/l (200mg/dl) or more, and plasma glucose at two hours of 11mol/l (200mg/dl) or more;\n
these WHO-criteria may change over time; also, criteria differences may exist between national health care systems','juvenile onset diabetes, type 1 diabetes','drug induced hyperglycaemia A85; hyperglycaemia as isolated finding A91; non-insulin dependent diabetesT90; gestational diabetes W85','hyperglycaemia A91; diabetes, non-insulin dependent T90','1.double code complications such as retinopathy F83, nephropathy U88\n
2. in pregnancy, double code with W84',1,'T89');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF SEXUAL DYSFUNCTION FEMALE','FEAR OF SEXUAL DYSFUNCTION FEMALE','Z71.1','concern about/fear of sexual dysfunction in a patient without sexual dysfunction',NULL,'sexual dysfunction P07, P08',NULL,NULL,1,'X24');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF BREAST CANCER FEMALE','FEAR OF BREAST CANCER FEMALE','Z71.1','concern about/fear of female breast cancer in a patient without the disease/until the diagnosis is proven',NULL,'if patient has the disease, code the disease',NULL,NULL,1,'X26');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BENIGN NEOPLASM BREAST FEMALE','BENIGN NEOPLASM BREAST FEMALE','D24','characteristic histological appearance','fibroadenoma female breast','cystic disease of breast X88','lump in breast X19',NULL,1,'X79');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONDYLOMATA ACUMINATA FEMALE','CONDYLOMATA ACUMINATA FEMALE','A63.0','characteristic appearance of lesions, or characteristic histological appearance','venereal warts, human papilloma virus infection',NULL,NULL,NULL,1,'X91');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (NULL,'MALE GENITAL SYSTEM INCLUDING BREAST','MALE GENITAL SYSTEM INCLUDING BREAST',NULL,NULL,NULL,NULL,NULL,NULL,1,'Y');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'FEAR OF SEXUAL DYSFUNCTION MALE','FEAR OF SEXUAL DYSFUNCTION MALE','Z71.1','concern about/fear of sexual dysfunction in a patient without the condition',NULL,'if the patient has sexual dysfunction, code the condition',NULL,NULL,1,'Y24');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'BENIGN NEOPLASM URINARY TRACT','BENIGN NEOPLASM URINARY TRACT','D30','characteristic histologic appearance','bladder papilloma, polyp of urinary tract','prostatic hypertrophy Y85','neoplasm urinary tract NOS U79',NULL,1,'U78');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'SYMPTOM/COMPLAINT MUSCULOSKELETAL OTHER','SYMPT/COMPLT MUSCULOSKELETAL OTHER','R29.3, R29.8',NULL,'''growing pains'' in a child','clubbing of fingernails S22',NULL,NULL,1,'L29');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (7,'CONCUSSION','CONCUSSION','S06.0','trauma to the head with a temporary loss of consciousness and/or neurological sequella','late effect of concussion','psychological effect of concussion P02','other head injury N80',NULL,1,'N79');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (6,'Referral to other provider/nurse/therapist/social worker','Referral to non-MD provider',NULL,NULL,NULL,NULL,NULL,NULL,1,'P66');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (1,'deleted, amalgamated with R21',NULL,NULL,NULL,NULL,NULL,NULL,NULL,0,'R22');
INSERT INTO staging.icpc (COMPONENT, DESCRIPTION, SHORT, ICD_10, CRIT, INCL, EXCL, CONS, NOTE, icpc, CODE) VALUES (2,'Other diagnostic procedure','Other diagnostic procedure',NULL,NULL,NULL,NULL,NULL,NULL,1,'S43');

-- --------------------------------------------------------------
-- create data source

delete from ref.data_source
where
	name_short = 'ICPC'
		and
	version = '2e-3.0'
		and
	lang = 'en';

insert into ref.data_source (
	name_long,
	name_short,
	version,
	description,
	source,
	lang
) values (
	'International Classification of Primary Care',
	'ICPC',
	'2e-3.0',
	'The ICPC2 data which comes with GNUmed is intended for NON-COMMERCIAL USE ONLY !

Use in a commercial way requires getting a license from WONCA.

--------------------------------------------------------------------------------
Copyright notices from the WONCA pages:

(http://www.kith.no/templates/kith_WebPage____1110.aspx)

Policy on copyright, licensing and translations


The copyright of ICPC, both in hard copy and in electronic form, is owned by Wonca.

The non-commercial user is free to use ICPC-2e.

If ICPC-2e is to be used for commercial purposes or in national/local coding systems, it will be necessary to negotiate with
Wonca about user fees. In that case, please contact the CEO of Wonca (ceo@wonca.com.sg).

In the following the copyright and licensing policy as well as the translation policy related to the electronic version
(ICPC-2e) is stated:

Aims OF THE POLICY

 1. To allow the Wonca Classification Committee to promote, distribute, and support ICPC-2, and further develop it as the best
    classification for primary care.
 2. To maintain international comparability of versions of ICPC-2.
 3. To obtain feedback and maintain a clearing-house of international experiences with ICPC-2.
 4. To achieve recognition of Wonca''s initiative and expertise in classification.
 5. To promote understanding of appropriate links between ICPC-2 and other classification and coding systems, particularly
    ICD-10.
 6. To encourage use of ICPC-2 rather than inhibit it with restrictions.
 7. To obtain financial support to enable achievement of these aims and allow the work of the Wonca Classification Committee
    to continue and expand.

copyright and licensing Policy

 1. The electronic version of ICPC-2 should be made available in as many countries as possible.
 2. Versions involving additions, translations, or alterations should be made with input from and agreement of the Wonca
    Classification Committee if they are to be regarded as official Wonca versions.
 3. Wonca should licence appropriate organizations to promote and distribute electronic versions of ICPC-2 in countries,
    regions, and language groups.
 4. Licence fees may be charged through these organizations to the end users and collected by the distributors for Wonca. The
    fees will be set by negotiation and may be waived when there are advantages to Wonca by so doing, such as when use is for
    research or development.

Translation policy

Wonca is an international organization and wishes to promote versions of ICPC in languages other than English, which is the
working language of the Classification Committee.  ICPC (the first version) has already been translated into 19 languages, and
has been published as a book in some of these.  There are already several translations of ICPC-2 being undertaken.  The
committee encourages anyone wishing to promote, assist with, or undertake translations of ICPC-2 to contact them to arrange
cooperative work.

The Wonca policy on ICPC-2  translations is:

 1. Wonca encourages versions in languages other than English.
 2. These must include the whole book, not just the rubrics.
 3. There must be no changes to the rubrics. Any extensions must be clearly indicated as such, and approved by the Wonca
    Classification Committee (WICC) prior to publication.
 4. Translations must be prepared by named translators working in cooperation with the Wonca Classification Committee and to
    the standards that it sets, particularly in relation to the extent of back translation for checking which may be required.
 5. While Wonca will retain the copyright it will usually grant without fee the rights to translating organizations to retain
    royalties on their versions. This will require a formal agreement between Wonca and the organization or publisher
    concerned.

Last updated: December 18, 2006

--------------------------------------------------------------------------------
The following was taken from Intro.doc and Notice.doc.

Intro.doc
=========

INTRODUCTION

The classification presented here, ICPC-2-E, is part of a publication in Family
Practice, and is an electronic version of the revised and corrected chapters 10
and 11 of ICPC-2 (published as a book in 1998 by Oxford University Press). From
the moment of its publication (April 2000), this ‘ICPC-2-E’ serves as the
standard for the use of ICPC-2 as a classification, both in electronic systems
and in written form, formally replacing chapters 10 and 11 as printed in the
book. However, chapters 1-9 of the book remain indispensable in order to
understand the underlying principles and concepts of the classification, and
contain information on the additional use of the Severity of Illness Coding
(DUSOI/WONCA) and the Functional Status Assessment (COOP/WONCA charts).

When citing the correct version of ICPC-2/ICPC-2-E, reference should be made to
both the following publications:

1. ICPC-2. International Classification of Primary Care, second edition.
   Prepared by the International Classification Committee of WONCA. Oxford:
   Oxford University Press, 1998.
2. Okkes IM, Jamoulle M, Lamberts H, Bentzen N. ICPC-2-E. The electronic
   version of ICPC-2. Differences with the printed version and the consequences.
   Fam Pract 2000; 17: 101-6.

The user of this file is free to use ICPC-2-E, since it replaces chapters 10
and 11 of the book. As a consequence, the copyright remains with WONCA, and all
rights are reserved at the same conditions as apply to ICPC-2 (the book). The
file is for personal use only, and all enquiries concerning other (especially
commercial) use should go through the WONCA Secretariat. Please contact:
Professor Wes Fabb, Chief Executive Officer, World Organization of Family
Doctors  - WONCA, Locked Bag 11, Collins Street East Post Office, Melbourne
Victoria 8003 Australia. Phone: +61 3 9650 0235 Fax: +61 3 9650 0236.

Disclaimer
All reasonable precautions have been taken by the authors, editors, and
Publishers to verify the accuracy of this material at the time of going to
press. OUP accepts no liability for inaccuracies or omissions or any claim for
damage arising therefrom. Please inform the authors of any omissions or
inaccuracies.

Contact details:
Dr. I.M. Okkes
Academic Medical Center/University of Amsterdam
Division of Public Health, Department of General Practice
Meibergdreef 15, 1105 AZ AMSTERDAM, The Netherlands
Tel: +31 20 566 4660
e-mail: i.m.okkes@amc.uva.nl

Prof. N. Bentzen MD
Dept. of Community Medicine and General Practice
Medisinsk Teknisk Forskningssenter
N-7489 TRONDHEIM, Norway
Tel: +47 73 598 876
e-mail: Niels.Bentzen@medisin.ntnu.no

--------------------------------------------------------------------------------
Notice.doc
==========

Please note: the original Intro.doc stated that copyright for the ICPC-2 was
held by Oxford University Press. This was incorrect. The copyright for the
whole of the ICPC-2, including this electronic version of the revised and
corrected chapters 10 and 11 is held by WONCA. The copyright statement in the
"Intro.doc" has now been changed to reflect this.',
	'some data downloaded from http://www.kith.no/templates/kith_WebPage____1110.aspx, other parts typed in manually from other sources',
	'en'
);

-- --------------------------------------------------------------
-- insert data

delete from ref.icpc
where
	fk_data_source = (
		select pk from ref.data_source where name_short = 'ICPC' and version = '2e-3.0' and lang = 'en'
);


insert into ref.icpc (
	code,
	term,
	comment,
	short_description,
	icd10,
	criteria,
	inclusions,
	exclusions,
	see_also,
	fk_component,
	fk_chapter,
	fk_data_source
) select
	code,
	description,
	note,
	short,
	string_to_array(icd_10, ', '),
	crit,
	incl,
	string_to_array(excl, '; '),
	string_to_array(cons, '; '),
	component,
	substring(code from 1 for 1),
	(select pk from ref.data_source where name_short = 'ICPC' and version = '2e-3.0' and lang = 'en')
  from
	staging.icpc
  where
	character_length(code) > 2
;


-- delete staging data
delete from staging.icpc;
drop table staging.icpc cascade;

-- split excl/cons into string/code

-- --------------------------------------------------------------
select gm.log_script_insertion('$RCSfile: v15-ref-icpc2-data.sql,v $', '$Revision: 1.1 $');

-- ==============================================================
