/* -*- Mode: JS2; indent-tabs-mode: nil; js2-basic-offset: 4 -*- */
/* vim: set et ts=4 sw=4: */
/*
 * Copyright (c) 2017 Marcus Lundblad
 *
 * GNOME Maps is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * GNOME Maps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with GNOME Maps; if not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Marcus Lundblad <ml@update.uu.se>
 */

/*
 * Extended route types using HVT (Hierarchical Vehicle Type) codes from
 * the European TPEG standard.
 * https://support.google.com/transitpartners/answer/3520902
 */

/* when adding an additional constant here, make sure to edit the LAST_
 * constant for the corresponding block
 */

// rail services
var RAILWAY_SERVICE = 100;
var HIGH_SPEED_RAIL_SERVICE = 101;
var LONG_DISTANCE_TRAINS = 102;
var INTER_REGIONAL_RAIL_SERVICE = 103;
var CAR_TRANSPORT_RAIL_SERVICE = 104;
var SLEEPER_RAIL_SERVICE = 105;
var REGIONAL_RAIL_SERVICE = 106;
var TOURIST_RAILWAY_SERVICE = 107;
var RAIL_SHUTTLE = 108;
var SUBURBAN_RAILWAY = 109;
var REPLACEMENT_RAIL_SERVICE = 110;
var SPECIAL_RAIL_SERVICE = 111;
var LORRY_TRANSPORT_RAIL_SERVICE = 112;
var ALL_RAIL_SERVICES = 113;
var CROSS_COUNTRY_RAIL_SERVICE = 114;
var VEHICLE_TRANSPORT_RAIL_SERVICE = 115;
var RACK_AND_PINION_RAILWAY = 116;
var ADDITIONAL_RAIL_SERVICE = 117;
var LAST_RAIL_SERVICE = ADDITIONAL_RAIL_SERVICE;

// coach services
var COACH_SERVICE = 200;
var INTERNATIONAL_COACH_SERVICE = 201;
var NATIONAL_COACH_SERVICE = 202;
var SHUTTLE_COACH_SERVICE = 203;
var REGIONAL_COACH_SERVICE = 204;
var SPECIAL_COACH_SERVICE = 205;
var SIGHTSEEING_COACH_SERVICE = 206;
var TOURIST_COACH_SERVICE = 207;
var COMMUTER_COACH_SERVICE = 208;
var ALL_COACH_SERVICES = 209;
var LAST_COACH_SERVICE = ALL_COACH_SERVICES;

/// suburban railway services
var SUBURBAN_RAILWAY_SERVICE = 300;

// urban railway services
var URBAN_RAILWAY_SERVICE = 400;
var URBAN_METRO_SERVICE = 401;
var URBAN_UNDERGROUND_SERVICE = 402;
// this constant has the same name as 400 in the specification
var URBAN_RAILWAY_SERVICE_2 = 403;
var ALL_URBAN_RAILWAY_SERVICES = 404;
var MONORAIL = 405;
var LAST_URBAN_RAILWAY_SERVICE = MONORAIL;

// metro services
var METRO_SERVICE = 500;

// underground services
var UNDERGROUND_SERVICE = 600;

// bus services
var BUS_SERVICE = 700;
var REGIONAL_BUS_SERVICE = 701;
var EXPRESS_BUS_SERVICE = 702;
var STOPPING_BUS_SERVICE = 703;
var LOCAL_BUS_SERVICE = 704;
var NIGHT_BUS_SERVICE = 705;
var POST_BUS_SERVICE = 706;
var SPECIAL_NEEDS_BUS_SERVICE = 707;
var MOBILITY_BUS_SERVICE = 708;
var MOBILITY_BUS_SERVICE_FOR_REGISTERED_DISABLED = 709;
var SIGHTSEEING_BUS = 710;
var SHUTTLE_BUS = 711;
var SCHOOL_BUS = 712;
var SCHOOL_AND_PUBLIC_SERVICE_BUS_SERVICE = 713;
var RAIL_REPLACEMENT_BUS_SERVICE = 714;
var DEMAND_AND_RESPONSE_BUS_SERVICE = 715;
var ALL_BUS_SERVICES = 716;
var LAST_BUS_SERVICE = ALL_BUS_SERVICES;

// trolleybus services
var TROLLEYBUS_SERVICE = 800;

// tram services
var TRAM_SERVICE = 900;
var CITY_TRAM_SERVICE = 901;
var LOCAL_TRAM_SERVICE = 902;
var REGIONAL_TRAM_SERVICE = 903;
var SIGHTSEEING_TRAM_SERVICE = 904;
var SHUTTLE_TRAM_SERVICE = 905;
var ALL_TRAM_SERVICES = 906;
var LAST_TRAM_SERVICE = ALL_TRAM_SERVICES;

// water transport services
var WATER_TRANSPORT_SERVICE = 1000;
var INTERNATIONAL_CAR_FERRY_SERVICE = 1001;
var NATIONAL_CAR_FERRY_SERVICE = 1002;
var REGIONAL_CAR_FERRY_SERVICE = 1003;
var LOCAL_CAR_FERRY_SERVICE = 1004;
var INTERNATIONAL_PASSENGER_FERRY_SERVICE = 1005;
var NATIONAL_PASSENGER_FERRY_SERVICE = 1006;
var REGIONAL_PASSENGER_FERRY_SERVICE = 1007;
var LOCAL_PASSENGER_FERRY_SERVICE = 1008;
var POST_BOAT_SERVICE = 1009;
var TRAIN_FERRY_SERVICE = 1010;
var ROAD_LINK_FERRY_SERVICE = 1011;
var AIRPORT_LINK_FERRY_SERVICE = 1012;
var CAR_HIGH_SPEED_FERRY_SERVICE = 1013;
var PASSENGER_HIGH_SPEED_FERRY_SERVICE = 1014;
var SIGHTSEEING_BOAT_SERVICE = 1015;
var SCHOOL_BOAT = 1016;
var CABLE_DRAWN_BOAT_SERVICE = 1017;
var RIVER_BUS_SERVICE = 1018;
var SCHEDULED_FERRY_SERVICE = 1019;
var SHUTTLE_FERRY_SERVICE = 1020;
var ALL_WATER_TRANSPORT_SERVICE = 1021;
var LAST_WATER_TRANSPORT_SERVICE = ALL_WATER_TRANSPORT_SERVICE;

// air service
var AIR_SERVICE = 1100;
var INTERNATIONAL_AIR_SERVICE = 1101;
var DOMESTIC_AIR_SERVICE = 1102;
var INTERCONTINENTAL_AIR_SERVICE = 1103;
var DOMESTIC_SCHEDULED_AIR_SERVICE = 1104;
var SHUTTLE_AIR_SERVICE = 1105;
var INTERCONTINENTAL_CHARTER_AIR_SERVICE = 1106;
var INTERNATIONAL_CHARTER_AIR_SERVICE = 1107;
var ROUND_TRIP_CHARTER_AIR_SERVICE = 1108;
var SIGHTSEEING_AIR_SERVICE = 1109;
var HELICOPTER_AIR_SERVICE = 1110;
var DOMESTIC_CHARTER_AIR_SERVICE = 1111;
var SCHENGEN_AREA_AIR_SERVICE = 1112;
var AIRSHIP_SERVICE = 1113;
var ALL_AIR_SERVICES = 1114;
var LAST_AIR_SERVICE = ALL_AIR_SERVICES;

// ferry services
var FERRY_SERVICE = 1200;

// telecabin services
var TELECABIN_SERVICE = 1300;
var TELECABIN_SERVICES = 1301;
// renamed this to not be confused with the tram-like street level cable cars
var TELECABIN_CABLE_CAR_SERVICE = 1302;
var ELEVATOR_SERVICE = 1303;
var CHAIR_LIFT_SERVICE = 1304;
var DRAG_LIFT_SERVICE = 1305;
var SMALL_TELECABIN_SERVICE = 1306;
var ALL_TELECABIN_SERVICES = 1307;
var LAST_TELECABIN_SERVICE = ALL_TELECABIN_SERVICES;

// funicular services
var FUNICULAR_SERVICE = 1400;
var FUNICULAR_SERVICE_2 = 1401;
var ALL_FUNICULAR_SERVICES = 1402;
var LAST_FUNICULAR_SERVICE = ALL_FUNICULAR_SERVICES;

// taxi services
var TAXI_SERVICE = 1500;
var COMMUNAL_TAXI_SERVICE = 1501;
var WATER_TAXI_SERVICE = 1502;
var RAIL_TAXI_SERVICE = 1503;
var BIKE_TAXI_SERVICE = 1504;
var LICENSED_TAXI_SERVICE = 1505;
var PRIVATE_HIRE_SERVICE_VEHICLE = 1506;
var ALL_TAXI_SERVICES = 1507;
var LAST_TAXI_SERVICE = ALL_TAXI_SERVICES;

// self drive
var SELF_DRIVE = 1600;
var HIRE_CAR = 1601;
var HIRE_VAN = 1602;
var HIRE_MOTORBIKE = 1603;
var HIRE_CYCLE = 1604;
var LAST_SELF_DRIVE = HIRE_CYCLE;

// misc. service
var MISCELLANEOUS_SERVICE = 1700;
var CABLE_CAR = 1701;
var HORSE_DRAWN_CARRIAGE = 1702;
var LAST_MISCELLANEOUS_SERVCE = HORSE_DRAWN_CARRIAGE;

/**
 * returns the super type of a given HVT type code, or -1 if the supplied code
 * is not among the defined codes
 */
function supertypeOf(type) {
    if (type >= RAILWAY_SERVICE && type <= LAST_RAIL_SERVICE)
        return RAILWAY_SERVICE;
    else if (type >= COACH_SERVICE && type <= LAST_COACH_SERVICE)
        return COACH_SERVICE;
    else if (type == SUBURBAN_RAILWAY_SERVICE)
        return SUBURBAN_RAILWAY_SERVICE;
    else if (type >= URBAN_RAILWAY_SERVICE && type <= LAST_URBAN_RAILWAY_SERVICE)
        return URBAN_RAILWAY_SERVICE;
    else if (type == METRO_SERVICE)
        return METRO_SERVICE;
    else if (type == UNDERGROUND_SERVICE)
        return UNDERGROUND_SERVICE;
    else if (type >= BUS_SERVICE && type <= LAST_BUS_SERVICE)
        return BUS_SERVICE;
    else if (type == TROLLEYBUS_SERVICE)
        return TROLLEYBUS_SERVICE;
    else if (type >= TRAM_SERVICE && type <= LAST_TRAM_SERVICE)
        return TRAM_SERVICE;
    else if (type >= WATER_TRANSPORT_SERVICE &&
             type <= LAST_WATER_TRANSPORT_SERVICE)
        return WATER_TRANSPORT_SERVICE;
    else if (type >= AIR_SERVICE && type <= LAST_AIR_SERVICE)
        return AIR_SERVICE;
    else if (type == FERRY_SERVICE)
        return FERRY_SERVICE;
    else if (type >= TELECABIN_SERVICE && type <= LAST_TELECABIN_SERVICE)
        return TELECABIN_SERVICE;
    else if (type >= FUNICULAR_SERVICE && type <= LAST_FUNICULAR_SERVICE)
        return FUNICULAR_SERVICE;
    else if (type >= TAXI_SERVICE && type <= LAST_TAXI_SERVICE)
        return TAXI_SERVICE;
    else if (type >= SELF_DRIVE && type <= LAST_SELF_DRIVE)
        return SELF_DRIVE;
    else if (type >= MISCELLANEOUS_SERVICE && type <= LAST_MISCELLANEOUS_SERVCE)
        return MISCELLANEOUS_SERVICE;
    else
        return -1;
}
