////////////////////////////////////////////////////////
//
// GEM - Graphics Environment for Multimedia
//
// Implementation file
//
// Copyright (c) 2002-2011 IOhannes m zmölnig. forum::für::umläute. IEM. zmoelnig@iem.at
//      zmoelnig@iem.at
//  For information on usage and redistribution, and for a DISCLAIMER
//  *  OF ALL WARRANTIES, see the file, "GEM.LICENSE.TERMS"
//
//  this file has been generated...
////////////////////////////////////////////////////////

#include "GEMglDisable.h"
#include "Gem/Exception.h"

CPPEXTERN_NEW_WITH_GIMME ( GEMglDisable );
using namespace gem::utils::gl;

/////////////////////////////////////////////////////////
//
// GEMglViewport
//
/////////////////////////////////////////////////////////
// Constructor
//
GEMglDisable :: GEMglDisable (int argc, t_atom*argv) :
  cap(0)
{
  if(1==argc) {
    capMess(argv[0]);
  } else if(argc) {
    throw(GemException("invalid number of arguments"));
  }
  m_inlet[0] = inlet_new(this->x_obj, &this->x_obj->ob_pd, &s_float,
                         gensym("cap"));
}
/////////////////////////////////////////////////////////
// Destructor
//
GEMglDisable :: ~GEMglDisable ()
{
  inlet_free(m_inlet[0]);
}

/////////////////////////////////////////////////////////
// Render
//
void GEMglDisable :: render(GemState *state)
{
  glDisable (cap);
}

/////////////////////////////////////////////////////////
// Variables
//
void GEMglDisable :: capMess (t_atom arg)       // FUN
{
  cap = static_cast<GLenum>(getGLdefine(&arg));
  setModified();
}


/////////////////////////////////////////////////////////
// static member functions
//

void GEMglDisable :: obj_setupCallback(t_class *classPtr)
{
  class_addmethod(classPtr,
                  reinterpret_cast<t_method>(&GEMglDisable::capMessCallback),
                  gensym("cap"), A_GIMME, A_NULL);
};

void GEMglDisable :: capMessCallback (void* data, t_symbol*, int argc,
                                      t_atom*argv)
{
  if(argc==1) {
    GetMyClass(data)->capMess ( argv[0]);
  }
}
