from ConfigFormatLoader import ConfigFormatLoader
from ConfigLoader import ConfigLoader
import configvalues as conf
import errormessage
import values

import os



#
# Class for the config tree.
#
class Config:

    #
    # Constructor.
    #
    def __init__(self, configfile, formatfile):

        # there file where to store changes
        self.__configfile = configfile

        self.__format = {}

        self.__data = {}
        self.__offset = []

        # flag to indicate that the configuration has changed
        self.__changed_flag = 0


        # read the config format specification
        self.__format = ConfigFormatLoader().load(formatfile)




    #
    # Sets the given config value.
    #
    def set(self, path, value):

        dict = self.__data
        for p in self.__offset + path[:-1]:
            if (not dict.has_key(p)): dict[p] = {}
            dict = dict[p]
        #end for

        dict[path[-1]] = value
        self.__changed_flag = 1




    #
    # Returns the given config value.
    #
    def get(self, path):

        formatinfo = self.__format.get(tuple(self.__offset + path))
        if (formatinfo):
            vtype, default = formatinfo
        else:
            raise KeyError("Invalid key: " + str(path))

        dict = self.__data
        try:
            for p in self.__offset + path[:-1]:
                dict = dict[p]
            #end for
            value = dict[path[-1]]
            
        except KeyError:
            value = default

        if (value):
            if (vtype == conf.TYPE_INT): value = int(value)
            elif (vtype == conf.TYPE_BOOL): value = int(value)
            elif (vtype == conf.TYPE_FLOAT): value = float(value)
            elif (vtype == conf.TYPE_STRING): pass
        #end if

        return value



    #
    # Clears the given path.
    #
    def clear(self, path = []):

        dict = self.__data
        for p in self.__offset + path[:-1]:
            if (not dict.has_key(p)): dict[p] = {}
            dict = dict[p]
        #end for

        dict.clear()

        



    #
    # Loads the given configuration, or the default configuration if no
    # filename is given.
    #
    def load(self, filename = "", searchpaths = []):

        if (not filename): filename = self.__configfile
        
        searchpaths += [os.environ.get(values.DESKCALUSERHOME),
                        os.environ.get(values.DESKCALHOME)]

        # try to find the given file
        configfile = ""
        for p in searchpaths:
            fn = os.path.join(p, filename)
            if (os.path.exists(fn)):
                configfile = fn
        #end for

        if (not configfile):
            errormessage.error(_("Unable to find configuration file " \
                                 "%(filename)s.") % vars(), 1)


        self.set([conf.PATH], os.path.dirname(configfile))
        self.set([conf.INCLUDE_PATH], filename)
        cl = ConfigLoader(self)
        try:
            cl.load(configfile)
            self.__changed_flag = 1
        except:
            errormessage.error(_("Invalid configuration file " \
                                 "%(configfile)s.") % vars(), 1)






    #
    # Saves the current configuration to the default config file.
    #
    def save(self):

        # check whether we may save
        if (not self.__changed_flag or
            not self.get([conf.TEMPORARY, conf.SAVE_CHANGES])):
            return

        #userhomedir = os.environ.get(values.DESKCALUSERHOME)
        #filename = os.path.join(userhomedir, values.CONFIGFILE)
        filename = self.__configfile

        out = "<config>\n"
        out += self.__serialize(self.__data, 2)
        out += "</config>\n"

        #print "saving configuration"

        try:
            fd = open(filename, "w")
            fd.write(out)
            fd.close()
            self.__changed_flag = 0
        except:
            errormessage.error(_("Could not save configuration."))



    def __serialize(self, dict, indent):

        out = ""
        for key, value in dict.items():
            if (key in [conf.SKIN]):
                path = value[conf.INCLUDE_PATH]
                out += " " * indent
                out += "<%(key)s " \
                       "include=\"%(path)s\"/>\n" % vars()

            # don't serialize temporary settings
            elif (key == conf.TEMPORARY):
                pass
                
            elif (type(value) == type({})):
                out += " " * indent
                out += "<%(key)s>\n" % vars()
                out += self.__serialize(value, indent + 2)
                out += " " * indent
                out += "</%(key)s>\n" % vars()

            elif (key != conf.PATH):
                out += " " * indent
                out += "<%(key)s " \
                       "value=\"%(value)s\"/>\n" % vars()
        #end for

        return out
    


    
    #
    # Sets the path offset of paths for setting/getting values.
    #
    def set_offset(self, offset):

        self.__offset = offset
