'''OpenGL extension APPLE.vertex_array_object

This module customises the behaviour of the 
OpenGL.raw.GL.APPLE.vertex_array_object to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension introduces named vertex array objects which encapsulate
	vertex array state on the client side. The main purpose of these 
	objects is to keep pointers to static vertex data and provide a name 
	for different sets of static vertex data.  
	
	By extending vertex array range functionality this extension allows multiple
	vertex array ranges to exist at one time, including their complete sets of
	state, in manner analogous to texture objects. 
	
	GenVertexArraysAPPLE creates a list of n number of vertex array object
	names.  After creating a name, BindVertexArrayAPPLE associates the name with
	a vertex array object and selects this vertex array and its associated
	state as current.  To get back to the default vertex array and its
	associated state the client should bind to vertex array named 0.
	
	Once a client is done using a vertex array object it can be deleted with
	DeleteVertexArraysAPPLE.  The client is responsible for allocating and
	deallocating the memory used by the vertex array data, while the
	DeleteVertexArraysAPPLE command deletes vertex array object names and
	associated state only.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/APPLE/vertex_array_object.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.APPLE.vertex_array_object import *
from OpenGL.raw.GL.APPLE.vertex_array_object import _EXTENSION_NAME

def glInitVertexArrayObjectAPPLE():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION