/*
 * Decompiled with CFR 0.152.
 */
package colorspace;

import colorspace.ColorSpace;
import colorspace.ColorSpaceException;
import colorspace.ColorSpaceMapper;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;

public class Resampler
extends ColorSpaceMapper {
    private final int minCompSubsX;
    private final int minCompSubsY;
    private final int maxCompSubsX;
    private final int maxCompSubsY;
    final int wspan = 0;
    final int hspan = 0;

    public static BlkImgDataSrc createInstance(BlkImgDataSrc src, ColorSpace csMap) throws ColorSpaceException {
        return new Resampler(src, csMap);
    }

    protected Resampler(BlkImgDataSrc src, ColorSpace csMap) throws ColorSpaceException {
        super(src, csMap);
        int minX = src.getCompSubsX(0);
        int minY = src.getCompSubsY(0);
        int maxX = minX;
        int maxY = minY;
        for (int c = 1; c < this.ncomps; ++c) {
            minX = Math.min(minX, src.getCompSubsX(c));
            minY = Math.min(minY, src.getCompSubsY(c));
            maxX = Math.max(maxX, src.getCompSubsX(c));
            maxY = Math.max(maxY, src.getCompSubsY(c));
        }
        if (maxX != 1 && maxX != 2 || maxY != 1 && maxY != 2) {
            throw new ColorSpaceException("Upsampling by other than 2:1 not supported");
        }
        this.minCompSubsX = minX;
        this.minCompSubsY = minY;
        this.maxCompSubsX = maxX;
        this.maxCompSubsY = maxY;
    }

    public DataBlk getInternCompData(DataBlk outblk, int c) {
        if (this.src.getCompSubsX(c) == 1 && this.src.getCompSubsY(c) == 1) {
            return this.src.getInternCompData(outblk, c);
        }
        int wfactor = this.src.getCompSubsX(c);
        int hfactor = this.src.getCompSubsY(c);
        if (wfactor != 2 && wfactor != 1 || hfactor != 2 && hfactor != 1) {
            throw new IllegalArgumentException("Upsampling by other than 2:1 not supported");
        }
        int leftedgeOut = -1;
        int rightedgeOut = -1;
        int leftedgeIn = -1;
        int rightedgeIn = -1;
        int y0Out = outblk.uly;
        int y1Out = y0Out + outblk.h - 1;
        int x0Out = outblk.ulx;
        int x1Out = x0Out + outblk.w - 1;
        int y0In = y0Out / hfactor;
        int y1In = y1Out / hfactor;
        int x0In = x0Out / wfactor;
        int x1In = x1Out / wfactor;
        int reqW = x1In - x0In + 1;
        int reqH = y1In - y0In + 1;
        int kOut = -1;
        int kIn = -1;
        switch (outblk.getDataType()) {
            case 3: {
                DataBlkInt inblkInt = new DataBlkInt(x0In, y0In, reqW, reqH);
                inblkInt = (DataBlkInt)this.src.getInternCompData(inblkInt, c);
                this.dataInt[c] = inblkInt.getDataInt();
                int[] outdataInt = (int[])outblk.getData();
                if (outdataInt == null || outdataInt.length != outblk.w * outblk.h) {
                    outdataInt = new int[outblk.h * outblk.w];
                    outblk.setData(outdataInt);
                }
                for (int yOut = y0Out; yOut <= y1Out; ++yOut) {
                    int yIn = yOut / hfactor;
                    leftedgeIn = inblkInt.offset + (yIn - y0In) * inblkInt.scanw;
                    rightedgeIn = leftedgeIn + inblkInt.w;
                    leftedgeOut = outblk.offset + (yOut - y0Out) * outblk.scanw;
                    rightedgeOut = leftedgeOut + outblk.w;
                    kIn = leftedgeIn;
                    kOut = leftedgeOut;
                    if ((x0Out & 1) == 1) {
                        outdataInt[kOut++] = this.dataInt[c][kIn++];
                    }
                    if ((x1Out & 1) == 0) {
                        --rightedgeOut;
                    }
                    while (kOut < rightedgeOut) {
                        outdataInt[kOut++] = this.dataInt[c][kIn];
                        outdataInt[kOut++] = this.dataInt[c][kIn++];
                    }
                    if ((x1Out & 1) != 0) continue;
                    outdataInt[kOut++] = this.dataInt[c][kIn];
                }
                outblk.progressive = inblkInt.progressive;
                break;
            }
            case 4: {
                DataBlkFloat inblkFloat = new DataBlkFloat(x0In, y0In, reqW, reqH);
                inblkFloat = (DataBlkFloat)this.src.getInternCompData(inblkFloat, c);
                this.dataFloat[c] = inblkFloat.getDataFloat();
                float[] outdataFloat = (float[])outblk.getData();
                if (outdataFloat == null || outdataFloat.length != outblk.w * outblk.h) {
                    outdataFloat = new float[outblk.h * outblk.w];
                    outblk.setData(outdataFloat);
                }
                for (int yOut = y0Out; yOut <= y1Out; ++yOut) {
                    int yIn = yOut / hfactor;
                    leftedgeIn = inblkFloat.offset + (yIn - y0In) * inblkFloat.scanw;
                    rightedgeIn = leftedgeIn + inblkFloat.w;
                    leftedgeOut = outblk.offset + (yOut - y0Out) * outblk.scanw;
                    rightedgeOut = leftedgeOut + outblk.w;
                    kIn = leftedgeIn;
                    kOut = leftedgeOut;
                    if ((x0Out & 1) == 1) {
                        outdataFloat[kOut++] = this.dataFloat[c][kIn++];
                    }
                    if ((x1Out & 1) == 0) {
                        --rightedgeOut;
                    }
                    while (kOut < rightedgeOut) {
                        outdataFloat[kOut++] = this.dataFloat[c][kIn];
                        outdataFloat[kOut++] = this.dataFloat[c][kIn++];
                    }
                    if ((x1Out & 1) != 0) continue;
                    outdataFloat[kOut++] = this.dataFloat[c][kIn];
                }
                outblk.progressive = inblkFloat.progressive;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid source datablock type");
            }
        }
        return outblk;
    }

    public String toString() {
        StringBuffer rep = new StringBuffer("[Resampler: ncomps= " + this.ncomps);
        StringBuffer body = new StringBuffer("  ");
        for (int i = 0; i < this.ncomps; ++i) {
            body.append(eol);
            body.append("comp[");
            body.append(i);
            body.append("] xscale= ");
            body.append(this.imgdatasrc.getCompSubsX(i));
            body.append(", yscale= ");
            body.append(this.imgdatasrc.getCompSubsY(i));
        }
        rep.append(ColorSpace.indent("  ", body));
        return rep.append("]").toString();
    }

    public DataBlk getCompData(DataBlk outblk, int c) {
        return this.getInternCompData(outblk, c);
    }

    public int getCompImgHeight(int c) {
        return this.src.getCompImgHeight(c) * this.src.getCompSubsY(c);
    }

    public int getCompImgWidth(int c) {
        return this.src.getCompImgWidth(c) * this.src.getCompSubsX(c);
    }

    public int getCompSubsX(int c) {
        return 1;
    }

    public int getCompSubsY(int c) {
        return 1;
    }

    public int getTileCompHeight(int t, int c) {
        return this.src.getTileCompHeight(t, c) * this.src.getCompSubsY(c);
    }

    public int getTileCompWidth(int t, int c) {
        return this.src.getTileCompWidth(t, c) * this.src.getCompSubsX(c);
    }
}

