#include <vector>
#include <string>
#include <map>
std::map<std::string, std::vector<std::string> > functionHelp = {

{
{ "pgband" }, {
{ "read cursor position, with anchor" },
{ "Syntax" },
{ "      INTEGER FUNCTION PGBAND (MODE, POSN, XREF, YREF, X, Y, CH)" },
{ "      INTEGER MODE, POSN" },
{ "      REAL XREF, YREF, X, Y" },
{ "      CHARACTER*(*) CH" },
{ "" },
{ "Read the cursor position and a character typed by the user." },
{ "The position is returned in world coordinates.  PGBAND positions" },
{ "the cursor at the position specified (if POSN=1), allows the user to" },
{ "move the cursor using the mouse or arrow keys or whatever is available" },
{ "on the device. When he has positioned the cursor, the user types a" },
{ "single character on the keyboard; PGBAND then returns this" },
{ "character and the new cursor position (in world coordinates)." },
{ "" },
{ "Some interactive devices offer a selection of cursor types," },
{ "implemented as thin lines that move with the cursor, but without" },
{ "erasing underlying graphics. Of these types, some extend between" },
{ "a stationary anchor-point at XREF,YREF, and the position of the" },
{ "cursor, while others simply follow the cursor without changing shape" },
{ "or size. The cursor type is specified with one of the following MODE" },
{ "values. Cursor types that are not supported by a given device, are" },
{ "treated as MODE=0." },
{ "" },
{ "-- If MODE=0, the anchor point is ignored and the routine behaves" },
{ "like PGCURS." },
{ "-- If MODE=1, a straight line is drawn joining the anchor point " },
{ "and the cursor position." },
{ "-- If MODE=2, a hollow rectangle is extended as the cursor is moved," },
{ "with one vertex at the anchor point and the opposite vertex at the" },
{ "current cursor position; the edges of the rectangle are horizontal" },
{ "and vertical." },
{ "-- If MODE=3, two horizontal lines are extended across the width of" },
{ "the display, one drawn through the anchor point and the other" },
{ "through the moving cursor position. This could be used to select" },
{ "a Y-axis range when one end of the range is known." },
{ "-- If MODE=4, two vertical lines are extended over the height of" },
{ "the display, one drawn through the anchor point and the other" },
{ "through the moving cursor position. This could be used to select an" },
{ "X-axis range when one end of the range is known." },
{ "-- If MODE=5, a horizontal line is extended through the cursor" },
{ "position over the width of the display. This could be used to select" },
{ "an X-axis value such as the start of an X-axis range. The anchor point" },
{ "is ignored." },
{ "-- If MODE=6, a vertical line is extended through the cursor" },
{ "position over the height of the display. This could be used to select" },
{ "a Y-axis value such as the start of a Y-axis range. The anchor point" },
{ "is ignored." },
{ "-- If MODE=7, a cross-hair, centered on the cursor, is extended over" },
{ "the width and height of the display. The anchor point is ignored." },
{ "" },
{ "Returns:" },
{ " PGBAND          : 1 if the call was successful; 0 if the device" },
{ "                   has no cursor or some other error occurs." },
{ "Arguments:" },
{ " MODE   (input)  : display mode (0, 1, ..7: see above)." },
{ " POSN   (input)  : if POSN=1, PGBAND attempts to place the cursor" },
{ "                   at point (X,Y); if POSN=0, it leaves the cursor" },
{ "                   at its current position. (On some devices this" },
{ "                   request may be ignored.)" },
{ " XREF   (input)  : the world x-coordinate of the anchor point." },
{ " YREF   (input)  : the world y-coordinate of the anchor point." },
{ " X      (in/out) : the world x-coordinate of the cursor." },
{ " Y      (in/out) : the world y-coordinate of the cursor." },
{ " CH     (output) : the character typed by the user; if the device has" },
{ "                   no cursor or if some other error occurs, the value" },
{ "                   CHAR(0) [ASCII NUL character] is returned." },
{ "" },
{ "Note: The cursor coordinates (X,Y) may be changed by PGBAND even if" },
{ "the device has no cursor or if the user does not move the cursor." },
{ "Under these circumstances, the position returned in (X,Y) is that of" },
{ "the pixel nearest to the requested position." },
{ "" },
{ "" }
}
},
{
{ "pgbeg" }, {
{ "open a graphics device" },
{ "Syntax" },
{ "      INTEGER FUNCTION PGBEG (UNIT, FILE, NXSUB, NYSUB)" },
{ "      INTEGER       UNIT" },
{ "      CHARACTER*(*) FILE" },
{ "      INTEGER       NXSUB, NYSUB" },
{ "" },
{ "Note: new programs should use PGOPEN rather than PGBEG. PGOPEN" },
{ "is retained for compatibility with existing programs. Unlike PGOPEN," },
{ "PGBEG closes any graphics devices that are already open, so it " },
{ "cannot be used to open devices to be used in parallel." },
{ "" },
{ "PGBEG opens a graphical device or file and prepares it for" },
{ "subsequent plotting. A device must be opened with PGBEG or PGOPEN" },
{ "before any other calls to PGPLOT subroutines for the device." },
{ "" },
{ "If any device  is already open for PGPLOT output, it is closed before" },
{ "the new device is opened." },
{ "" },
{ "Returns:" },
{ " PGBEG         : a status return value. A value of 1 indicates" },
{ "                   successful completion, any other value indicates" },
{ "                   an error. In the event of error a message is" },
{ "                   written on the standard error unit.  " },
{ "                   To test the return value, call" },
{ "                   PGBEG as a function, eg IER=PGBEG(...); note" },
{ "                   that PGBEG must be declared INTEGER in the" },
{ "                   calling program. Some Fortran compilers allow" },
{ "                   you to use CALL PGBEG(...) and discard the" },
{ "                   return value, but this is not standard Fortran." },
{ "Arguments:" },
{ " UNIT  (input)   : this argument is ignored by PGBEG (use zero)." },
{ " FILE  (input)   : the \"device specification\" for the plot device." },
{ "                   (For explanation, see description of PGOPEN.)" },
{ " NXSUB  (input)  : the number of subdivisions of the view surface in" },
{ "                   X (&gt;0 or &lt;0)." },
{ " NYSUB  (input)  : the number of subdivisions of the view surface in" },
{ "                   Y (&gt;0)." },
{ "                   PGPLOT puts NXSUB x NYSUB graphs on each plot" },
{ "                   page or screen; when the view surface is sub-" },
{ "                   divided in this way, PGPAGE moves to the next" },
{ "                   panel, not the  next physical page. If" },
{ "                   NXSUB &gt; 0, PGPLOT uses the panels in row" },
{ "                   order; if &lt;0, PGPLOT uses them in column order." },
{ "" },
{ "" }
}
},
{
{ "pgcurs" }, {
{ "read cursor position" },
{ "Syntax" },
{ "      INTEGER FUNCTION PGCURS (X, Y, CH)" },
{ "      REAL X, Y" },
{ "      CHARACTER*(*) CH" },
{ "" },
{ "Read the cursor position and a character typed by the user." },
{ "The position is returned in world coordinates.  PGCURS positions" },
{ "the cursor at the position specified, allows the user to move the" },
{ "cursor using the joystick or arrow keys or whatever is available on" },
{ "the device. When he has positioned the cursor, the user types a" },
{ "single character on the keyboard; PGCURS then returns this" },
{ "character and the new cursor position (in world coordinates)." },
{ "" },
{ "Returns:" },
{ " PGCURS         : 1 if the call was successful; 0 if the device" },
{ "                   has no cursor or some other error occurs." },
{ "Arguments:" },
{ " X      (in/out) : the world x-coordinate of the cursor." },
{ " Y      (in/out) : the world y-coordinate of the cursor." },
{ " CH     (output) : the character typed by the user; if the device has" },
{ "                   no cursor or if some other error occurs, the value" },
{ "                   CHAR(0) [ASCII NUL character] is returned." },
{ "" },
{ "Note: The cursor coordinates (X,Y) may be changed by PGCURS even if" },
{ "the device has no cursor or if the user does not move the cursor." },
{ "Under these circumstances, the position returned in (X,Y) is that of" },
{ "the pixel nearest to the requested position." },
{ "" },
{ "" }
}
},
{
{ "pgopen" }, {
{ "open a graphics device" },
{ "Syntax" },
{ "      INTEGER FUNCTION PGOPEN (DEVICE)" },
{ "      CHARACTER*(*) DEVICE" },
{ "" },
{ "Open a graphics device for PGPLOT output. If the device is" },
{ "opened successfully, it becomes the selected device to which" },
{ "graphics output is directed until another device is selected" },
{ "with PGSLCT or the device is closed with PGCLOS." },
{ "" },
{ "The value returned by PGOPEN should be tested to ensure that" },
{ "the device was opened successfully, e.g.," },
{ "" },
{ "      ISTAT = PGOPEN('plot.ps/PS')" },
{ "      IF (ISTAT .LE. 0 ) STOP" },
{ "" },
{ "Note that PGOPEN must be declared INTEGER in the calling program." },
{ "" },
{ "The DEVICE argument is a character constant or variable; its value" },
{ "should be one of the following:" },
{ "" },
{ "(1) A complete device specification of the form 'device/type' or" },
{ "    'file/type', where 'type' is one of the allowed PGPLOT device" },
{ "    types (installation-dependent) and 'device' or 'file' is the " },
{ "    name of a graphics device or disk file appropriate for this type." },
{ "    The 'device' or 'file' may contain '/' characters; the final" },
{ "    '/' delimits the 'type'. If necessary to avoid ambiguity," },
{ "    the 'device' part of the string may be enclosed in double" },
{ "    quotation marks." },
{ "(2) A device specification of the form '/type', where 'type' is one" },
{ "    of the allowed PGPLOT device types. PGPLOT supplies a default" },
{ "    file or device name appropriate for this device type." },
{ "(3) A device specification with '/type' omitted; in this case" },
{ "    the type is taken from the environment variable PGPLOT_TYPE," },
{ "    if defined (e.g., setenv PGPLOT_TYPE PS). Because of possible" },
{ "    confusion with '/' in file-names, omitting the device type" },
{ "    in this way is not recommended." },
{ "(4) A blank string (' '); in this case, PGOPEN will use the value" },
{ "    of environment variable PGPLOT_DEV as the device specification," },
{ "    or '/NULL' if the environment variable is undefined." },
{ "(5) A single question mark, with optional trailing spaces ('?'); in" },
{ "    this case, PGPLOT will prompt the user to supply the device" },
{ "    specification, with a prompt string of the form" },
{ "        'Graphics device/type (? to see list, default XXX):'" },
{ "    where 'XXX' is the default (value of environment variable" },
{ "    PGPLOT_DEV)." },
{ "(6) A non-blank string in which the first character is a question" },
{ "    mark (e.g., '?Device: '); in this case, PGPLOT will prompt the" },
{ "    user to supply the device specification, using the supplied" },
{ "    string as the prompt (without the leading question mark but" },
{ "    including any trailing spaces)." },
{ "" },
{ "In cases (5) and (6), the device specification is read from the" },
{ "standard input. The user should respond to the prompt with a device" },
{ "specification of the form (1), (2), or (3). If the user types a " },
{ "question-mark in response to the prompt, a list of available device" },
{ "types is displayed and the prompt is re-issued. If the user supplies" },
{ "an invalid device specification, the prompt is re-issued. If the user" },
{ "responds with an end-of-file character, e.g., ctrl-D in UNIX, program" },
{ "execution is aborted; this  avoids the possibility of an infinite" },
{ "prompting loop.  A programmer should avoid use of PGPLOT-prompting" },
{ "if this behavior is not desirable." },
{ "" },
{ "The device type is case-insensitive (e.g., '/ps' and '/PS' are " },
{ "equivalent). The device or file name may be case-sensitive in some" },
{ "operating systems." },
{ "" },
{ "Examples of valid DEVICE arguments:" },
{ "" },
{ "(1)  'plot.ps/ps', 'dir/plot.ps/ps', '\"dir/plot.ps\"/ps', " },
{ "     'user:[tjp.plots]plot.ps/PS'" },
{ "(2)  '/ps'      (PGPLOT interprets this as 'pgplot.ps/ps')" },
{ "(3)  'plot.ps'  (if PGPLOT_TYPE is defined as 'ps', PGPLOT" },
{ "                 interprets this as 'plot.ps/ps')" },
{ "(4)  '   '      (if PGPLOT_DEV is defined)" },
{ "(5)  '?  '" },
{ "(6)  '?Device specification for PGPLOT: '" },
{ "" },
{ "[This routine was added to PGPLOT in Version 5.1.0. Older programs" },
{ "use PGBEG instead.]" },
{ "" },
{ "Returns:" },
{ " PGOPEN          : returns either a positive value, the" },
{ "                   identifier of the graphics device for use with" },
{ "                   PGSLCT, or a 0 or negative value indicating an" },
{ "                   error. In the event of error a message is" },
{ "                   written on the standard error unit." },
{ "Arguments:" },
{ " DEVICE  (input) : the 'device specification' for the plot device" },
{ "                   (see above)." },
{ "" },
{ "" }
}
},
{
{ "pgrnd" }, {
{ "find the smallest `round' number greater than x" },
{ "Syntax" },
{ "      REAL FUNCTION PGRND (X, NSUB)" },
{ "      REAL X" },
{ "      INTEGER NSUB" },
{ "" },
{ "Routine to find the smallest \"round\" number larger than x, a" },
{ "\"round\" number being 1, 2 or 5 times a power of 10. If X is negative," },
{ "PGRND(X) = -PGRND(ABS(X)). eg PGRND(8.7) = 10.0," },
{ "PGRND(-0.4) = -0.5.  If X is zero, the value returned is zero." },
{ "This routine is used by PGBOX for choosing  tick intervals." },
{ "" },
{ "Returns:" },
{ " PGRND         : the \"round\" number." },
{ "Arguments:" },
{ " X      (input)  : the number to be rounded." },
{ " NSUB   (output) : a suitable number of subdivisions for" },
{ "                   subdividing the \"nice\" number: 2 or 5." },
{ "" },
{ "" }
}
},
{
{ "pgunsa" }, {
{ "restore PGPLOT attributes" },
{ "Syntax" },
{ "      ENTRY PGUNSA" },
{ "" },
{ "This routine restores the PGPLOT attributes saved in the last call to" },
{ "PGSAVE. Usage: CALL PGUNSA (no arguments). See PGSAVE." },
{ "" },
{ "Arguments: none" },
{ "" },
{ "" }
}
},
{
{ "pgbegin" }, {
{ "non-standard alias for PGBEG" },
{ "Syntax" },
{ "      INTEGER FUNCTION PGBEGIN (UNIT, FILE, NXSUB, NYSUB)" },
{ "      INTEGER       UNIT" },
{ "      CHARACTER*(*) FILE" },
{ "      INTEGER       NXSUB, NYSUB" },
{ "" },
{ "See description of PGBEG.   " },
{ "" },
{ "" }
}
},
{
{ "pgcurse" }, {
{ "non-standard alias for PGCURS" },
{ "Syntax" },
{ "      INTEGER FUNCTION PGCURSE (X, Y, CH)" },
{ "      REAL X, Y" },
{ "      CHARACTER*1 CH" },
{ "" },
{ "See description of PGCURS." },
{ "" },
{ "" }
}
},
{
{ "sin" }, {
{ "Returns the trigonometric sine of its argument. The returned value will be real, complex, or a matrix, depending on the argument. By default, the argument is in radians. This can be changed by specifying the switch /deg." },
{ "Syntax" },
{ "result = sin(angle [, /deg])" },
{ "Arguments" },
{ "angle: a number (integer, real, complex) or a matrix, specifying the angle for which the sine is to be calculated. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "Switches" },
{ "/deg: The argument is in degrees" },
{ "Examples" },
{ "To find the sine of the angle 90 degrees, type:" },
{ "print sin(90, /deg)" },
{ "See also" },
{ "function cos" },
{ "function tan" },
{ "category trigonometry" }
}
},
{
{ "cos" }, {
{ "Returns the trigonometric cosine of its argument. The returned value will be real, complex, or a matrix, depending on the argument. By default, the argument is in radians. This can be changed by specifying the switch /deg." },
{ "Syntax" },
{ "result = cos(angle [, /deg])" },
{ "Arguments" },
{ "angle: a number (integer, real, complex) or a matrix, specifying the angle for which the cosine is to be calculated. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "Switches" },
{ "/deg: The argument is in degrees" },
{ "Examples" },
{ "To find the cosine of the angle 90 degrees, type:" },
{ "print cos(90, /deg)" },
{ "See also" },
{ "function sin" },
{ "function tan" },
{ "category trigonometry" }
}
},
{
{ "tan" }, {
{ "Returns the trigonometric tangent of its argument. The returned value will be real, complex, or a matrix, depending on the argument. By default, the argument is in radians. This can be changed by specifying the switch /deg." },
{ "Syntax" },
{ "result = tan(angle [, /deg])" },
{ "Arguments" },
{ "angle: a number (integer, real, complex) or a matrix, specifying the angle for which the tangent is to be calculated. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "Switches" },
{ "/deg: The argument is in degrees" },
{ "Examples" },
{ "To find the tangent of the angle 45 degrees, type:" },
{ "print tan(45, /deg)" },
{ "See also" },
{ "function sin" },
{ "function cos" },
{ "category trigonometry" }
}
},
{
{ "sinh" }, {
{ "Returns the hyperbolic sine of its argument. The returned value will be real, complex, or a matrix, depending on the argument. By default, the argument is in radians. This can be changed by specifying the switch /deg." },
{ "Syntax" },
{ "result = sinh(angle [, /deg])" },
{ "Arguments" },
{ "angle: a number (integer, real, complex) or a matrix, specifying the angle for which the hyperbolic sine is to be calculated. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "Switches" },
{ "/deg: The argument is in degrees" },
{ "Examples" },
{ "To find the hyperbolic sine of the angle 90 degrees, type:" },
{ "print sinh(90, /deg)" },
{ "See also" },
{ "function cosh" },
{ "function tanh" },
{ "category trigonometry" }
}
},
{
{ "cosh" }, {
{ "Returns the hyperbolic cosine of its argument. The returned value will be real, complex, or a matrix, depending on the argument. By default, the argument is in radians. This can be changed by specifying the switch /deg." },
{ "Syntax" },
{ "result = cosh(angle [, /deg])" },
{ "Arguments" },
{ "angle: a number (integer, real, complex) or a matrix, specifying the angle for which the hyperbolic cosine is to be calculated. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "Switches" },
{ "/deg: The argument is in degrees" },
{ "Examples" },
{ "To find the hyperbolic cosine of the angle 90 degrees, type:" },
{ "print cosh(90, /deg)" },
{ "See also" },
{ "function sinh" },
{ "function tanh" },
{ "category trigonometry" }
}
},
{
{ "tanh" }, {
{ "Returns the hyperbolic tangent of its argument. The returned value will be real, complex, or a matrix, depending on the argument. By default, the argument is in radians. This can be changed by specifying the switch /deg." },
{ "Syntax" },
{ "result = tanh(angle [, /deg])" },
{ "Arguments" },
{ "angle:a number (integer, real, complex) or a matrix, specifying the angle for which the hyperbolic tangent is to be calculated. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "Switches" },
{ "/deg: The argument is in degrees" },
{ "Examples" },
{ "To find the hyperbolic tangent of the angle 45 degrees, type:" },
{ "print tanh(45, /deg)" },
{ "See also" },
{ "function sinh" },
{ "function cosh" },
{ "category trigonometry" }
}
},
{
{ "asin" }, {
{ "Returns the arcus sine of its argument, which can be either real, complex or a matrix. The returned value's type is changed to complex if necessary (when the absolute value of the argument is greater than 1). By default, the returned value is in radians. This can be changed by specifying the switch /deg." },
{ "Syntax" },
{ "result = asin(X [, /deg])" },
{ "Arguments" },
{ "X: a number (integer, real, complex) or a matrix, specifying the sine of the angle to be returned. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "Switches" },
{ "/deg: The result will be in degrees" },
{ "Examples" },
{ "To find the angle (in degrees) whose sine is 0.5, type:" },
{ "print asin(0.5, /deg)" },
{ "See also" },
{ "function acos" },
{ "function atan" },
{ "category trigonometry" }
}
},
{
{ "acos" }, {
{ "Returns the arcus cosine of its argument, which can be either real, complex or a matrix. The returned value's type is changed to complex if necessary (when the absolute value of the argument is greater than 1). By default, the returned value is in radians. This can be changed by specifying the switch /deg." },
{ "Syntax" },
{ "result = acos(X [, /deg])" },
{ "Arguments" },
{ "X: a number (integer, real, complex) or a matrix, specifying the cosine of the angle to be returned. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "Switches" },
{ "/deg: The result will be in degrees" },
{ "Examples" },
{ "To find the angle (in degrees) whose cosine is 0.5, type:" },
{ "print acos(0.5, /deg)" },
{ "See also" },
{ "function asin" },
{ "function atan" },
{ "category trigonometry" }
}
},
{
{ "atan" }, {
{ "Returns the arcus tangent of its argument, which can be either real, complex" },
{ "or a matrix. The returned value has the same type as the argument. By default, the returned value is in radians. This can be changed by specifying the switch /deg." },
{ "Syntax" },
{ "result = atan(X [, Y] [, /deg])" },
{ "Arguments" },
{ "X: a number (integer, real, complex) or a matrix, specifying the tangent of the angle to be returned. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "Y: a real number. If given, returns atan(X / Y) for real numbers, quadrant correct." },
{ "Switches" },
{ "/deg: The result will be in degrees" },
{ "Examples" },
{ "To find the angle (in degrees) whose tangent is 0.5, type:" },
{ "print atan(0.5, /deg)" },
{ "See also" },
{ "function asin" },
{ "function acos" },
{ "category trigonometry" }
}
},
{
{ "asinh" }, {
{ "Returns the hyperbolic arcus sine of its argument, which can be either real, complex or a matrix. By default, the returned value is in radians. This can be changed by specifying the switch /deg." },
{ "Syntax" },
{ "result = asinh(X [, /deg])" },
{ "Arguments" },
{ "X: a number (integer, real, complex) or a matrix, specifying the hyperbolic sine of the angle to be returned. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "Switches" },
{ "/deg: The result will be in degrees" },
{ "Examples" },
{ "To find the angle (in degrees) whose hyperbolic sine is 0.5, type:" },
{ "print asinh(0.5, /deg)" },
{ "See also" },
{ "function acosh" },
{ "function atanh" },
{ "category trigonometry" }
}
},
{
{ "acosh" }, {
{ "Returns the hyperbolic arcus cosine of its argument, which can be either real, complex or a matrix. By default, the returned value is in radians. This can be changed by specifying the switch /deg." },
{ "Syntax" },
{ "result = acosh(X [, /deg])" },
{ "Arguments" },
{ "X: a number (integer, real, complex) or a matrix, specifying the hyperbolic cosine of the angle to be returned. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "Switches" },
{ "/deg: The result will be in degrees" },
{ "Examples" },
{ "To find the angle (in degrees) whose hyperbolic cosine is 0.5, type:" },
{ "print acosh(0.5, /deg)" },
{ "See also" },
{ "function asinh" },
{ "function atanh" },
{ "category trigonometry" }
}
},
{
{ "atanh" }, {
{ "Returns the hyperbolic arcus tangent of X, which can be either real, complex or a matrix. By default, the returned value is in radians. This can be changed by specifying the switch /deg." },
{ "Syntax" },
{ "result = atanh(X [, /deg])" },
{ "Arguments" },
{ "X: a number (integer, real, complex) or a matrix, specifying the hyperbolic tangent of the angle to be returned. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "Switches" },
{ "/deg: The result will be in degrees" },
{ "Examples" },
{ "To find the angle (in degrees) whose hyperbolic tangent is 0.5, type:" },
{ "print atanh(0.5, /deg)" },
{ "See also" },
{ "function acosh" },
{ "function asinh" },
{ "category trigonometry" }
}
},
{
{ "exp" }, {
{ "Returns the exponential function of X. The returned value will be real, complex, or a matrix, depending on the argument. " },
{ "Syntax" },
{ "result = exp(X)" },
{ "Arguments" },
{ "X: a number (integer, real, complex) or a matrix. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "See also" },
{ "function ln" }
}
},
{
{ "log" }, {
{ "Returns the logarithm of X. If no base is supplied, the logarithm to the base 10 is returned." },
{ "Syntax" },
{ "result = log(X [, base])" },
{ "Arguments" },
{ "X: The value whose logarithm is to be returned. This can be a number (integer, real, complex) or a matrix. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "base: If given, the logarithm of X to this base will be returned" },
{ "See also" },
{ "function ln" }
}
},
{
{ "ln" }, {
{ "Returns the logarithm of X to the base e (the natural logarithm)." },
{ "Syntax" },
{ "result = ln(X)" },
{ "Arguments" },
{ "X: The value whose logarithm is to be returned. This can be a number (integer, real, complex) or a matrix. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "See also" },
{ "function log" }
}
},
{
{ "sqrt" }, {
{ "Returns the square root of X." },
{ "Syntax" },
{ "result = sqrt(X)" },
{ "Arguments" },
{ "X: The value whose square root is to be returned. This can be a number (integer, real, complex) or a matrix. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." }
}
},
{
{ "erf" }, {
{ "Returns the error function of X." },
{ "Syntax" },
{ "result = erf(X)" },
{ "Arguments" },
{ "X: A real number." }
}
},
{
{ "bessel" }, {
{ "Returns the bessel function of X." },
{ "Syntax" },
{ "result = bessel(X, kind, order)" },
{ "Arguments" },
{ "X: A real number." },
{ "kind: An integer number (1 or 2), specifying the kind of the bessel function to be computed." },
{ "order: An integer number >= 0, specifying the order of the bessel function to be computed." }
}
},
{
{ "int" }, {
{ "Returns the integer part of X." },
{ "Syntax" },
{ "result = int(X)" },
{ "Arguments" },
{ "X: a real number." },
{ "Examples" },
{ "To print the integer part of the real number -6.7 which is -6, type:" },
{ "print int(-6.7)" },
{ "See also" },
{ "function round" }
}
},
{
{ "round" }, {
{ "Returns X rounded to the nearest integer." },
{ "Syntax" },
{ "result = round(X)" },
{ "Arguments" },
{ "X: a real number." },
{ "See also" },
{ "function int" }
}
},
{
{ "frac" }, {
{ "Returns the fractional part of X." },
{ "Syntax" },
{ "result = frax(X)" },
{ "Arguments" },
{ "X: a real number." }
}
},
{
{ "abs" }, {
{ "Returns the absolute value of X." },
{ "Syntax" },
{ "result = abs(X)" },
{ "Arguments" },
{ "X: The value whose absolute value is to be returned. This can be a number (integer, real, complex) or a matrix. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "See also" },
{ "function sign" },
{ "function arg" },
{ "function real" },
{ "function imag" }
}
},
{
{ "sign" }, {
{ "Returns the sign of X." },
{ "Syntax" },
{ "result = sign(X)" },
{ "Arguments" },
{ "X: a real number." },
{ "See also" },
{ "function abs" }
}
},
{
{ "rad2deg" }, {
{ "Returns X in radians converted to degrees. This is equivalent to X*180/pi." },
{ "Syntax" },
{ "result = rad2deg(X)" },
{ "Arguments" },
{ "X: The value which is to be converted to degrees. This can be any number (integer, real, complex) or a matrix." },
{ "See also" },
{ "function deg2rad" },
{ "category trigonometry" }
}
},
{
{ "deg2rad" }, {
{ "Returns X in degrees converted to radians. This is equivalent to X*pi/180." },
{ "Syntax" },
{ "result = deg2rad(X)" },
{ "Arguments" },
{ "X: The value which is to be converted to radians. This can be any number (integer, real, complex) or a matrix." },
{ "See also" },
{ "function rad2deg" },
{ "category trigonometry" }
}
},
{
{ "float" }, {
{ "Returns the string X converted to a real number." },
{ "Syntax" },
{ "result = float(X)" },
{ "Arguments" },
{ "X: A string." }
}
},
{
{ "strlen" }, {
{ "Returns the length of the string X." },
{ "Syntax" },
{ "result = strlen(X)" },
{ "Arguments" },
{ "X: A string." },
{ "See also" },
{ "function nelements" }
}
},
{
{ "min" }, {
{ "Returns the minimum value of an array or the minimum of two real numbers. Undefined values (INF and NaN) are ignored." },
{ "Syntax" },
{ "result = min(X [, ignore] [,/x | /y | /z | /xy | /xz | /yz])<br>" },
{ "result = min(a, b)" },
{ "Arguments" },
{ "X: A matrix." },
{ "ignore: An optional value which should be ignored." },
{ "a: A real number." },
{ "b: A real number" },
{ "Switches" },
{ "/x: Calculate the minimum along the first axis" },
{ "/y: Calculate the minimum along the second axis" },
{ "/z: Calculate the minimum along the third axis" },
{ "/xy: Calculate the minimum along the first and second axes" },
{ "/xz: Calculate the minimum along the first and third axes" },
{ "/yz: Calculate the minimum along the second and third axes" },
{ "Examples" },
{ "To get a 1D vector of the minima of all slices along a 3D cube:" },
{ "result = min(cube, /xy)" },
{ "See also" },
{ "function max" },
{ "function avg" },
{ "function total" },
{ "function median" },
{ "function stddev" },
{ "function meddev" },
{ "function variance" }
}
},
{
{ "max" }, {
{ "Returns the maximum value of an array or the maximum of two real numbers. Undefined values (INF and NaN) are ignored." },
{ "Syntax" },
{ "result = max(X [, ignore] [,/x | /y | /z | /xy | /xz | /yz])<br>" },
{ "result = max(a, b)" },
{ "Arguments" },
{ "X: A matrix." },
{ "ignore: An optional value which should be ignored." },
{ "a: A real number." },
{ "b: A real number." },
{ "Switches" },
{ "/x: Calculate the maximum along the first axis" },
{ "/y: Calculate the maximum along the second axis" },
{ "/z: Calculate the maximum along the third axis" },
{ "/xy: Calculate the maximum along the first and second axes" },
{ "/xz: Calculate the maximum along the first and third axes" },
{ "/yz: Calculate the maximum along the second and third axes" },
{ "Examples" },
{ "To get a 1D vector of the maxima of all slices along a 3D cube:" },
{ "result = max(cube, /xy)" },
{ "See also" },
{ "function min" },
{ "function avg" },
{ "function total" },
{ "function median" },
{ "function stddev" },
{ "function meddev" },
{ "function variance" }
}
},
{
{ "avg" }, {
{ "Returns the average value of X, optionally omitting a value. Undefined values (INF and NaN) are ignored." },
{ "Syntax" },
{ "result = avg(X [, omit [,/x | /y | /z | /xy | /xz | /yz]])" },
{ "Arguments" },
{ "X: A matrix." },
{ "omit: A value to be omitted when taking the average." },
{ "Switches" },
{ "/x: Calculate the average along the first axis" },
{ "/y: Calculate the average along the second axis" },
{ "/z: Calculate the average along the third axis" },
{ "/xy: Calculate the average along the first and second axes" },
{ "/xz: Calculate the average along the first and third axes" },
{ "/yz: Calculate the average along the second and third axes" },
{ "Examples" },
{ "Find the average of the values 0,1,2,3,4 (which is 2):" },
{ "print avg([0:4])<br>" },
{ "Calculate an average image of a 3D cube:" },
{ "result = avg(cube, /z)<br>" },
{ "This is the same as:" },
{ "result = cubeavg(cube)" },
{ "See also" },
{ "function max" },
{ "function min" },
{ "function total" },
{ "function median" },
{ "function stddev" },
{ "function meddev" },
{ "function cubeavg" },
{ "function variance" }
}
},
{
{ "total" }, {
{ "Returns the sum of all values in X. Undefined values (INF and NaN) are ignored." },
{ "Syntax" },
{ "result = total(X [, ignore] [,/x | /y | /z | /xy | /xz | /yz])" },
{ "Arguments" },
{ "X: A matrix." },
{ "ignore: An optional value which should be ignored." },
{ "Switches" },
{ "/x: Calculate the sum along the first axis" },
{ "/y: Calculate the sum along the second axis" },
{ "/z: Calculate the sum along the third axis" },
{ "/xy: Calculate the sum along the first and second axes" },
{ "/xz: Calculate the sum along the first and third axes" },
{ "/yz: Calculate the sum along the second and third axes" },
{ "Examples" },
{ "Calculate a sum image of a 3D cube:" },
{ "result = total(cube, /z)" },
{ "See also" },
{ "function max" },
{ "function min" },
{ "function avg" },
{ "function median" },
{ "function stddev" },
{ "function meddev" }
}
},
{
{ "median" }, {
{ "Returns the median value of X, optionally neglecting a value." },
{ "Syntax" },
{ "result = median(X [, omit] [,/x | /y | /z | /xy | /xz | /yz])" },
{ "Arguments" },
{ "X: A matrix." },
{ "omit: A value which should be omitted when taking the median." },
{ "Switches" },
{ "/x: Calculate the sum along the first axis" },
{ "/y: Calculate the sum along the second axis" },
{ "/z: Calculate the sum along the third axis" },
{ "/xy: Calculate the sum along the first and second axes" },
{ "/xz: Calculate the sum along the first and third axes" },
{ "/yz: Calculate the sum along the second and third axes" },
{ "Examples" },
{ "Calculate a median image of a 3D cube:" },
{ "result = median(cube, /z)<br>" },
{ "This is the same as:" },
{ "result = cubemedian(cube)" },
{ "See also" },
{ "function max" },
{ "function min" },
{ "function total" },
{ "function avg" },
{ "function stddev" },
{ "function meddev" },
{ "function cubemedian" }
}
},
{
{ "naxis" }, {
{ "Returns the number of axes in X." },
{ "Syntax" },
{ "result = naxis(X [, extension])" },
{ "Arguments" },
{ "X: A matrix or a file name" },
{ "extension: Integer number specifying which extension to read." },
{ "See also" },
{ "function nelements" },
{ "function naxis1" },
{ "function naxis2" },
{ "function naxis3" }
}
},
{
{ "naxis1" }, {
{ "Returns the length of axis #1 in X." },
{ "Syntax" },
{ "result = naxis1(X [, extension])" },
{ "Arguments" },
{ "X: A matrix or a file name" },
{ "extension: Integer number specifying which extension to read." },
{ "See also" },
{ "function nelements" },
{ "function naxis" },
{ "function naxis2" },
{ "function naxis3" }
}
},
{
{ "naxis2" }, {
{ "Returns the length of axis #2 in X." },
{ "Syntax" },
{ "result = naxis2(X [, extension])" },
{ "Arguments" },
{ "X: A matrix or a file name" },
{ "extension: Integer number specifying which extension to read." },
{ "See also" },
{ "function nelements" },
{ "function naxis" },
{ "function naxis1" },
{ "function naxis3" }
}
},
{
{ "naxis3" }, {
{ "Returns the length of axis #3 in X." },
{ "Syntax" },
{ "result = naxis3(X [, extension])" },
{ "Arguments" },
{ "X: A matrix or a file name" },
{ "extension: Integer number specifying which extension to read." },
{ "See also" },
{ "function nelements" },
{ "function naxis" },
{ "function naxis1" },
{ "function naxis2" }
}
},
{
{ "xmax" }, {
{ "Returns the x coordinate of the maximum in X." },
{ "Syntax" },
{ "result = xmax(X)" },
{ "Arguments" },
{ "X: A matrix." },
{ "See also" },
{ "function ymax" },
{ "function xmin" },
{ "function ymin" },
{ "function xcen" },
{ "function ycen" },
{ "function maxima" },
{ "function centroids" },
{ "procedure centroid" }
}
},
{
{ "ymax" }, {
{ "Returns the y coordinate of the maximum in X." },
{ "Syntax" },
{ "result = ymax(X)" },
{ "Arguments" },
{ "X: A matrix." },
{ "See also" },
{ "function xmax" },
{ "function xmin" },
{ "function ymin" },
{ "function xcen" },
{ "function ycen" },
{ "function maxima" },
{ "function centroids" },
{ "procedure centroid" }
}
},
{
{ "xmin" }, {
{ "Returns the x coordinate of the minimum in X." },
{ "Syntax" },
{ "result = xmin(X)" },
{ "Arguments" },
{ "X: A matrix." },
{ "See also" },
{ "function ymin" },
{ "function xmax" },
{ "function ymax" },
{ "function xcen" },
{ "function ycen" },
{ "function maxima" },
{ "function centroids" },
{ "procedure centroid" }
}
},
{
{ "ymin" }, {
{ "Returns the y coordinate of the minimum in X." },
{ "Syntax" },
{ "result = ymin(X)" },
{ "Arguments" },
{ "X: A matrix." },
{ "See also" },
{ "function xmin" },
{ "function xmax" },
{ "function ymax" },
{ "function xcen" },
{ "function ycen" },
{ "function maxima" },
{ "function centroids" },
{ "procedure centroid" }
}
},
{
{ "xcen" }, {
{ "Returns the x coordinate of the centroid in X." },
{ "Syntax" },
{ "result = xcen(X)" },
{ "Arguments" },
{ "X: A matrix." },
{ "See also" },
{ "function xmax" },
{ "function ymax" },
{ "function xmin" },
{ "function ymin" },
{ "function ycen" },
{ "function maxima" },
{ "function centroids" },
{ "procedure centroid" }
}
},
{
{ "ycen" }, {
{ "Returns the y coordinate of the centroid in X." },
{ "Syntax" },
{ "result = ycen(X)" },
{ "Arguments" },
{ "X: A matrix." },
{ "See also" },
{ "function xmax" },
{ "function ymax" },
{ "function xmin" },
{ "function ymin" },
{ "function xcen" },
{ "function maxima" },
{ "function centroids" },
{ "procedure centroid" }
}
},
{
{ "real" }, {
{ "Returns the real part of the complex number X." },
{ "Syntax" },
{ "result = real(X)" },
{ "Arguments" },
{ "X: The value whose real part is to be returned. This can be a number (integer, real, complex) or a matrix. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "See also" },
{ "function imag" },
{ "function arg" },
{ "function abs" },
{ "function complex" },
{ "function conj" }
}
},
{
{ "imag" }, {
{ "Returns the imaginary part of the complex number X. If X is not a complex number, 0 is returned." },
{ "Syntax" },
{ "result = imag(X)" },
{ "Arguments" },
{ "X: The value whose imaginary part is to be returned. This can be a number (integer, real, complex) or a matrix. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "See also" },
{ "function real" },
{ "function arg" },
{ "function abs" },
{ "function complex" },
{ "function conj" }
}
},
{
{ "arg" }, {
{ "Returns the argument of the complex number X (the angle of the polar representation of a complex number)." },
{ "Syntax" },
{ "result = arg(X)" },
{ "Arguments" },
{ "X: The value whose imaginary part is to be returned. This can be a number (integer, real, complex) or a matrix. If X is a matrix, a matrix of the same size is returned where each element represents the result of the operation." },
{ "See also" },
{ "function real" },
{ "function imag" },
{ "function abs" },
{ "function complex" },
{ "function conj" }
}
},
{
{ "jd" }, {
{ "Returns the Julian Date of given date. Hour, minute, and second default to 0." },
{ "Syntax" },
{ "result = jd(day, month, year [, hour [, minute [,second]]])" },
{ "Arguments" },
{ "day: An integer number." },
{ "month: An integer number. " },
{ "year: An integer number." },
{ "hour: An integer number." },
{ "minute: An integer number." },
{ "second: A real number." },
{ "See also" },
{ "function jdnumber" },
{ "function jdfraction" },
{ "function calday" },
{ "function now" }
}
},
{
{ "jdnumber" }, {
{ "Returns the integer part of the Julian Date of given date. Hour, minute, and second default to 0." },
{ "Syntax" },
{ "result = jdnumber(day, month, year [, hour [, minute [,second]]])" },
{ "Arguments" },
{ "day: An integer number." },
{ "month: An integer number. " },
{ "year: An integer number." },
{ "hour: An integer number." },
{ "minute: An integer number." },
{ "second: A real number." },
{ "See also" },
{ "function jd" },
{ "function jdfraction" },
{ "function calday" },
{ "function now" }
}
},
{
{ "jdfraction" }, {
{ "Returns the fractional part of the Julian Date of given date. Hour, minute, and second default to 0." },
{ "Syntax" },
{ "result = jdfraction(day, month, year [, hour [, minute [,second]]])" },
{ "Arguments" },
{ "day: An integer number." },
{ "month: An integer number. " },
{ "year: An integer number." },
{ "hour: An integer number." },
{ "minute: An integer number." },
{ "second: A real number." },
{ "See also" },
{ "function jd" },
{ "function jdnumber" },
{ "function calday" },
{ "function now" }
}
},
{
{ "upper" }, {
{ "Converts the string X to upper case." },
{ "Syntax" },
{ "result = upper(X)" },
{ "Arguments" },
{ "X: A string." },
{ "See also" },
{ "function lower" },
{ "procedure upper" }
}
},
{
{ "lower" }, {
{ "Converts the string X to lower case." },
{ "Syntax" },
{ "result = lower(X)" },
{ "Arguments" },
{ "X: A string." },
{ "See also" },
{ "function upper" },
{ "procedure lower" }
}
},
{
{ "string" }, {
{ "Converts the number X to a string." },
{ "Syntax" },
{ "result = string(X [,/time] [,/deg] [,/rad]" },
{ "Arguments" },
{ "X: Any number (integer, real, complex)." },
{ "Switches" },
{ "/time: Convert to hours, minutes, and seconds" },
{ "/deg: Convert to degrees, arcminutes, and arcseconds" },
{ "/rad: Same as /deg, but the argument is converted to degrees" }
}
},
{
{ "calday" }, {
{ "Returns a nicely formatted string telling the calendar date of given Julian Date JD. If JD_fraction is nonzero, it describes the fractional part." },
{ "Syntax" },
{ "result = calday(JD, JD_fraction)" },
{ "Arguments" },
{ "JD: The julian date" },
{ "JD_fraction: If nonzero, the calendar date for JD+JD_fraction will be returned" },
{ "Switches" },
{ "/mjd: The date given is a Modified Julian Date" },
{ "See also" },
{ "function jd" },
{ "function now" }
}
},
{
{ "header" }, {
{ "Returns the FITS header of X." },
{ "Syntax" },
{ "result = header(X [, extension])" },
{ "Arguments" },
{ "X: A matrix or a file name" },
{ "extension: Integer number specifying which extension to read." }
}
},
{
{ "dayofweek" }, {
{ "Returns the day of the week of specified (julian) date." },
{ "Syntax" },
{ "result = dayofweek(DAY, MONTH, YEAR)<br>" },
{ "result = dayofweek(JD [,JD_fraction])" },
{ "Arguments" },
{ "DAY: An integer number." },
{ "MONTH: An integer number." },
{ "YEAR: An integer number." },
{ "JD: Julian Date." },
{ "JD_fraction: A real number." },
{ "Examples" },
{ "A person who was born an Feb 14, 1970 was born on a Saturday:" },
{ "print dayofweek(14,2,1970)" },
{ "See also" },
{ "function calday" },
{ "function jd" }
}
},
{
{ "fits" }, {
{ "Creates an array (or a matrix) of size X x Y x Z. The arguments Y and Z are optional. The resulting matrix will be of type R4 (single precision)." },
{ "Syntax" },
{ "result = fits(X [, Y [, Z]])" },
{ "Arguments" },
{ "X: An integer number giving the length of the first dimension." },
{ "Y: An integer number giving the length of the second dimension." },
{ "Z: An integer number giving the length of the third dimension." },
{ "See also" },
{ "function bytearray" },
{ "function shortarray" },
{ "function longarray" },
{ "function floatarray" },
{ "function doublearray" },
{ "function complexarray" }
}
},
{
{ "gauss" }, {
{ "Creates an elliptical Gaussian. This is defined by respective FWHM1 and FWHM2, axis position angle (in degrees) and Gaussian center position (x, y) in the array. Optional keywords are naxis1, naxis2 which determine the size of the array. If not set, the size of the array is determined from global variables. If only one argument is given, return the value of a gauss as determined from exp(-4ln(2)*x^2)." },
{ "Syntax" },
{ "result = gauss(X0)<br>" },
{ "result = gauss(X, Y, FWHM1 [, FWHM2 [, ANGLE]] [, naxis1=value] [, naxis2 = value])" },
{ "Arguments" },
{ "X0: A 1D vector or single number where to evaluate the function exp(-4ln(2)*X^2)" },
{ "X: The center of the gaussian in the x-axes" },
{ "Y: The center of the gaussian in the y-axes" },
{ "FWHM1: Full-width at half maximum of the major axes" },
{ "FWHM2: Optional, full-width at half maximum of the minor axes" },
{ "ANGLE: Optional, position angle of the gaussian" },
{ "naxis1=value: Optional, the size of the resulting array in the first dimension" },
{ "naxis2=value: Optional, the size of the resulting array in the second dimension" },
{ "See also" },
{ "function quickgauss" }
}
},
{
{ "circle" }, {
{ "Creates a circle centered on X, Y with the respective radius. Optional keywords are naxis1, naxis2 which determine the size of the array. If not set, the size of the array is determined from global variables." },
{ "Syntax" },
{ "result = circle(X, Y, RADIUS [, naxis1=value] [, naxis2 = value])" },
{ "Arguments" },
{ "X: The center of the circle in the x-axes" },
{ "Y: The center of the circle in the y-axes" },
{ "RADIUS: The radius of the circle" },
{ "naxis1=value: Optional, the size of the resulting array in the first dimension" },
{ "naxis2=value: Optional, the size of the resulting array in the second dimension" },
{ "See also" },
{ "function ellipse" }
}
},
{
{ "ellipse" }, {
{ "Creates an ellipse. This is defined by respective RADIUS1 and RADIUS2, axis position angle (in degrees) and Ellipse center position (x, y) in the array. Optional keywords are naxis1, naxis2 which determine the size of the array. If not set, the size of the array is determined from global variables." },
{ "Syntax" },
{ "result = ellipse(X, Y, RADIUS1 [, RADIUS2 [, ANGLE]] [, naxis1=value] [, naxis2 = value])" },
{ "Arguments" },
{ "X: The center of the ellipse in the x-axes" },
{ "Y: The center of the ellipse in the y-axes" },
{ "RADIUS1: Radius of the major axes" },
{ "RADIUS2: Optional, radius of the minor axes" },
{ "ANGLE: Optional, position angle of the ellipse" },
{ "naxis1=value: Optional, the size of the resulting array in the first dimension" },
{ "naxis2=value: Optional, the size of the resulting array in the second dimension" },
{ "See also" },
{ "function circle" }
}
},
{
{ "rect" }, {
{ "Creates a rectangular filter. This is defined by: Respective width and height and center position (X, Y) in the array. Optional keywords are naxis1, naxis2 which determine the size of the array. If not set, the size of the array is determined from global variables." },
{ "Syntax" },
{ "result = rect(X, Y, WIDTH, HEIGHT [, naxis1=value] [, naxis2 = value])" },
{ "Arguments" },
{ "X: The center of the rectangle in the x-axes" },
{ "Y: The center of the rectangle in the y-axes" },
{ "WIDTH: The width of the rectangle" },
{ "HEIGHT: the height of the rectangle" },
{ "naxis1=value: Optional, the size of the resulting array in the first dimension" },
{ "naxis2=value: Optional, the size of the resulting array in the second dimension" }
}
},
{
{ "delta" }, {
{ "Creates a delta function. This is defined by: All values in the array 0 except for (x, y) which is set to value. If value is not set, 1 will be used. Optional keywords are naxis1, naxis2 which determine the size of the array. If not set, the size of the array is determined from global variables." },
{ "Syntax" },
{ "result = delta(X, Y [, VALUE] [, naxis1=value] [, naxis2 = value])" },
{ "Arguments" },
{ "X: The x-position of the nonzero pixel" },
{ "Y: The y-position of the nonzero pixel" },
{ "VALUE: Optional, the value of the nonzero pixel" },
{ "naxis1=value: Optional, the size of the resulting array in the first dimension" },
{ "naxis2=value: Optional, the size of the resulting array in the second dimension" }
}
},
{
{ "cosbell" }, {
{ "Creates a cosine bell filter. This is defined by: Center position (x, y), inner radius r1, and outer radius r2. Optional keywords are naxis1, naxis2 which determine the size of the array. If not set, the size of the array is determined from global variables." },
{ "Syntax" },
{ "result = cosbell(X, Y, RADIUS1, RADIUS2 [, naxis1=value] [, naxis2 = value])" },
{ "Arguments" },
{ "X: The center of the cosine bell filter in the x-axes" },
{ "Y: The center of the cosine bell filter in the y-axes" },
{ "RADIUS1: The inner radius where the filter is equal to 1" },
{ "RADIUS2: The outer radius where the filter is equal to 0" },
{ "naxis1=value: Optional, the size of the resulting array in the first dimension" },
{ "naxis2=value: Optional, the size of the resulting array in the second dimension" }
}
},
{
{ "chinhat" }, {
{ "Creates a chinese hat filter. This is defined by: Center position (x, y) and radius. Optional keywords are naxis1, naxis2 which determine the size of the array. If not set, the size of the array is determined from global variables." },
{ "Syntax" },
{ "result = chinhat(X, Y, RADIUS [, naxis1=value] [, naxis2 = value])" },
{ "Arguments" },
{ "X: The center of the chinese hat filter in the first dimension" },
{ "Y: The center of the chinese hat filter in the second dimension" },
{ "RADIUS: The radius of the chinese hat filter" },
{ "naxis1=value: Optional, the size of the resulting array in the first dimension" },
{ "naxis2=value: Optional, the size of the resulting array in the second dimension" }
}
},
{
{ "airy" }, {
{ "Creates an airy function at the center of the array. This is defined by: Telescope diameter [meters], pixel scale [arcsec/pixel], and wavelength [microns]. Optional keywords are naxis1, naxis2 which determine the size of the array. If not set, the size of the array is determined from global variables." },
{ "Syntax" },
{ "result = airy(DIAMETER, PIXELSCALE, WAVELENGTH [, naxis1=value] [, naxis2 = value])" },
{ "Arguments" },
{ "DIAMETER: The telescope diameter in meters" },
{ "PIXELSCALE: The size of a pixel in arcseconds" },
{ "WAVELENGTH: The observing wavelength in microns" },
{ "naxis1=value: Optional, the size of the resulting array in the first dimension" },
{ "naxis2=value: Optional, the size of the resulting array in the second dimension" }
}
},
{
{ "cubemedian" }, {
{ "Does a median of all images in X. The value reject can be used to exclude a value to be taken when calculating the median." },
{ "Syntax" },
{ "result = cubemedian(X [, reject])" },
{ "Arguments" },
{ "X: A matrix or a FITS file name. If a FITS file name is given, the global variable tmpmem determines how many bytes of data are read in at a time." },
{ "reject: Optional, a value which should be discarded." },
{ "See also" },
{ "function collapse" },
{ "Notes" },
{ "If reject is given and no pixel along the cube is different from reject, a value of 0 will be inserted." }
}
},
{
{ "cubeavg" }, {
{ "Does an average of all images in X. Optionally, a rejection value can be given" },
{ "which will not be used in the averaging process." },
{ "Syntax" },
{ "result = cubeavg(X [, reject])" },
{ "Arguments" },
{ "X: A matrix or a FITS file name. If a FITS file name is given, only one image is read into memory at a time thus saving memory." },
{ "reject: Optional, the value to disregard" },
{ "Notes" },
{ "If reject is given and no pixel along the cube is different from reject, a value of 0 will be inserted." }
}
},
{
{ "ssa" }, {
{ "Calculates the simple shift-and-add of all images in the x datacube. If x is a fits file, a memory saving method will be used to do the ssa. If x is a string, this points to a text file where an arbitrary amount of fits filenames is given as a list. The first image in each of these files will be used for the ssa. If sky, flat, dpl, mask are given, they will be used. An optional keyword method can be given: method = 0 : Shift the brightest pixel to xcen, ycen method = 1 : Integer shift the centroid to xcen, ycen method = 2 : Subpixel shift the centroid to xcen, ycen If method < 0, the same is done as if method were set to 0, but the brightest pixel is searched in a smoothed version of the image. The smoothing is done by convolving with a gaussian of fwhm the negative of method." },
{ "Syntax" },
{ "result = ssa(X, XCENTER, YCENTER, SKY, FLAT, DPL, MASK [, METHOD] [, /resize])" },
{ "Arguments" },
{ "X: A FITS datacube" },
{ "XCENTER: The pixel where to shift in the first dimension" },
{ "YCENTER: The pixel where to shift in the second dimension" },
{ "SKY: A sky to be subtracted" },
{ "FLAT: A flatfield to be multiplied" },
{ "DPL: A dead pixel list to be applied" },
{ "MASK: The peak pixel will be searched for in an image multiplied by this mask" },
{ "METHOD: Optional, controls how the SSA will be done:" },
{ "METHOD = 0: Shift the brightest pixel to XCENTER, YCENTER (default)" },
{ "METHOD = 1: Integer shift the centroid to XCENTER, YCENTER" },
{ "METHOD = 2: Subpixel shift the centroid to XCENTER, YCENTER" },
{ "METHOD < 0: the same is done as if METHOD were set to 0, but the brightest pixel is searched in a smoothed version of the image. The smoothing is done by convolving with a gaussian of fwhm the negative of method." },
{ "Switches" },
{ "/resize: The resulting images will be resized in the way, that in each direction the respective extend of MASK is added twice." }
}
},
{
{ "mosaic" }, {
{ "Make a mosaic of the images specified in the file pointed to by FNAME. The file formatis as follows: 3(4) Columns: Filename, xshift, yshift, (scale factor). Negative Shifts result in clipping of the image." },
{ "Syntax" },
{ "result = mosaic(FNAME)<br>" },
{ "result = mosaic(filename, xshift, yshift [, scale factor])" },
{ "Arguments" },
{ "FNAME: A string specifying the file name to use." }
}
},
{
{ "shift" }, {
{ "Shifts (and optionally wraps) X by specified values." },
{ "Syntax" },
{ "result = shift(X, xs, ys [, zs] [, /wrap])" },
{ "Arguments" },
{ "X: The array to be shifted" },
{ "xs: Shift vector in the first dimension" },
{ "ys: Shift vector in the second dimension" },
{ "zs: Shift vector in the third dimension" },
{ "Switches" },
{ "wrap: Pixels shifted off the array will be wrapped to the opposide side." },
{ "Notes" },
{ "If either shift vector is non-integer, a subpixel shift is applied and the array type changed to R4. Subpixel shift is only supported in 2 dimensions." }
}
},
{
{ "rotate" }, {
{ "Rotates X by ANGLE (in degrees, counterclockwise)" },
{ "Syntax" },
{ "result = rotate(X, ANGLE [, XCENTER, YCENTER])" },
{ "Arguments" },
{ "X: The matrix to be rotated" },
{ "ANGLE: Rotation angle in degrees. Rotation will we counterclockwise" },
{ "XCENTER: Optional, the center of the rotation in the first dimension (defaults to the center of X)." },
{ "YCENTER: Optional, the center of the rotation in the second dimension (defaults to the center of X)." }
}
},
{
{ "fft" }, {
{ "Calculates the fast fourier transform of X. If X is real, the forward transform is computed. If X is complex, the inverse transform is computed." },
{ "Syntax" },
{ "result = fft(X)" },
{ "Arguments" },
{ "X: A matrix." },
{ "Notes" },
{ "The fft function uses the FFTW (Fastest Fourier Transform in the West) library, which is not limited to any array size. Still, computing a fft is fastest for arrays of size 2^N (N being an integer number)." }
}
},
{
{ "reass" }, {
{ "Reassembles X." },
{ "Syntax" },
{ "result = reass(X)" },
{ "Arguments" },
{ "X: A matrix." }
}
},
{
{ "norm" }, {
{ "Normalizes X." },
{ "Syntax" },
{ "result = norm(X [, /unity] [, /total] [, /average])" },
{ "Arguments" },
{ "X: A matrix." },
{ "Switches" },
{ "/unity: All values are scaled to be between 0 and 1 (default)" },
{ "/total: The total flux in the resulting array will be 1" },
{ "/average: The average flux in the resulting array will be 1" }
}
},
{
{ "clip" }, {
{ "Clips values in X. If VALUE is not set, all values below low will be set to low, and all values above high will be set to high. If value is set, all values above low AND below high are set to value." },
{ "Syntax" },
{ "result = clip(X, LOW, HIGH [, VALUE])" },
{ "Arguments" },
{ "X: The matrix to be clipped" },
{ "LOW: All values below this value will be set to LOW" },
{ "HIGH: All values above this value will be set to HIGH. If HIGH < LOW, no upper clipping will be done" },
{ "VALUE: Optional, if given then all values above LOW and below HIGH will be set to this value (inclusive clipping)" }
}
},
{
{ "smooth" }, {
{ "Smooths X by multiplying with a gaussian of width FWHM in fourier space. The total flux is kept constant. This is equivalent to reass(fft(fft(X)*fft(gauss(naxis1(X)/2+1,naxis2(X)/2+1,FWHM))))" },
{ "Syntax" },
{ "result = smooth(X, FWHM [,/x | /y | /z | /xy])" },
{ "Arguments" },
{ "X: A matrix." },
{ "FWHM: The full width at half maximum of the gaussian used for smoothing." },
{ "Switches" },
{ "/x: Smooth along the first axis" },
{ "/y: Smooth along the second axis" },
{ "/z: Smooth along the third axis" },
{ "/xy: 2D Smooth along the first and second axes (default)" },
{ "Examples" },
{ "Smooth each spectrum in a 3D cube (if the spectra are along the 3rd dimension):" },
{ "result = smooth(cube, /z)" },
{ "See also" },
{ "function boxcar" }
}
},
{
{ "boxcar" }, {
{ "Computes a running boxcar with radius WIDTH. By default, the value is replaces by the average in the box. This can be changed by specifying one of the switches /minimum, /maximum, or /median." },
{ "Syntax" },
{ "result = boxcar(X, WIDTH [, /minimum | /maximum | /median] [,/x | /y | /z | /xy])" },
{ "Arguments" },
{ "X: A matrix." },
{ "WIDTH: An integer number specifying the radius of the box." },
{ "Switches" },
{ "/minimum: Each value is replaced with the minimum within a box with radius WIDTH" },
{ "/maximum: Each value is replaced with the maximum within a box with radius WIDTH" },
{ "/median: Each value is replaced with the median within a box with radius WIDTH" },
{ "/x: Boxcar along the first axis" },
{ "/y: Boxcar along the second axis" },
{ "/z: Boxcar along the third axis" },
{ "/xy: 2D boxcar along the first and second axes (default)" },
{ "See also" },
{ "function smooth" }
}
},
{
{ "3dexpand" }, {
{ "Replaces all values in the single images of a datacube by the average in the respective images." },
{ "Syntax" },
{ "result = 3dexpand(X)" },
{ "Arguments" },
{ "X: A matrix." }
}
},
{
{ "dpixcreate" }, {
{ "Creates a dead pixel list of X using a magic threshold. Boxsize defaults to 3 and gives the radius of the running boxcar used. NPASS defaults to 3 and gives the number of passes used." },
{ "Syntax" },
{ "result = dpixcreate(X, THRESHOLD [, BOXSIZE [, NPASS]])" },
{ "Arguments" },
{ "X: On this array the dead pixel list will be created" },
{ "THRESHOLD: Sensitivity of the algorithm (use 5 for a start)" },
{ "BOXSIZE: Optional, the size of the square box for comparing pixel values (default: 3)" },
{ "NPASS: Optional, number of iterations" }
}
},
{
{ "dpixapply" }, {
{ "Corrects dead pixels in X using DPL by interpolation. BOXSIZE defaults to 1 and gives the radius of the boxcar used. Each value where DPL is not 0 will be regarded as a dead pixel. Those are not used in the interpolation process." },
{ "Syntax" },
{ "        result = dpixapply(X, DPL [, BOXSIZE [, method = value]] [,/spiffik [,/bezier]])" },
{ "Arguments" },
{ "X: The array to be corrected for dead pixels" },
{ "DPL: A dead pixel list in which all non-zero pixels mark dead pixels in X" },
{ "BOXSIZE: Optional, gives the size of the averaging box for interpolation" },
{ "method = value: Optional, gives the type of correction:" },
{ "method = 0: Interpolation from boxcar average (default)" },
{ "method = 1: Interpolation along first dimension" },
{ "method = 2: Interpolation along second dimension" },
{ "Switches" },
{ "/spiffik : obsolete" },
{ "/bezier : obsolete" }
}
},
{
{ "flip" }, {
{ "Flips X by specified AXIS" },
{ "Syntax" },
{ "result = flip(X, AXIS)" },
{ "Arguments" },
{ "X: The array to be flipped" },
{ "AXIS: Which axis to flip: 1 = x, 2 = y" }
}
},
{
{ "enlarge" }, {
{ "Enlarges X by specified integer SCALE." },
{ "Syntax" },
{ "result = enlarge(X, SCALE [, method])" },
{ "Arguments" },
{ "X: The array to be enlarged" },
{ "SCALE: The resulting array will be SIZE times bigger than X" },
{ "method: Optional, determines how to enlarge:" },
{ "method = 0: Center original image (default)" },
{ "method = 1: Center original image, edge values are mean of edge" },
{ "method = 2: Blow up pixels" }
}
},
{
{ "resize" }, {
{ "Resizes X to the new axis lengths. The argument NAXIS3 is optional. If the new dimension is smaller than in X, the image will be clipped, else the image will be in the lower left corner." },
{ "Syntax" },
{ "result = resize(X, NAXIS1, NAXIS2 [, NAXIS3])" },
{ "Arguments" },
{ "X: A matrix." },
{ "NAXIS1: The new length in the first dimension." },
{ "NAXIS2: The new length in the second dimension." },
{ "NAXIS3: The new length in the third dimension." }
}
},
{
{ "wien" }, {
{ "Performs a wiener filtered deconvolution of X using PSF as dirty beam. HEIGHT gives the maximum of the delta function used as filter function and defaults to 1." },
{ "Syntax" },
{ "result = wien(X, PSF [, HEIGHT])" },
{ "Arguments" },
{ "X: A matrix." },
{ "PSF: A matrix." },
{ "HEIGHT: A real number." },
{ "See also" },
{ "function lucy" },
{ "function clean" },
{ "Notes" },
{ "The memory required for wiener deconvolution (in bytes) calculates as 33*(Number of pixels in the image)." }
}
},
{
{ "lucy" }, {
{ "Performs a lucy deconvolution of X using PSF as dirty beam and N iterations. THRESHOLD defaults to 0.000003." },
{ " " },
{ "LUCY DECONVOLUTION ALGORITHM. \"Lucy has shown that his iterative scheme is related to the maximum likelihood solution of the deconvolution problem and would converge to that solution after an infinite number of iterations.\"" },
{ " " },
{ "iteration number      : k" },
{ "dirty beam            : dbeam" },
{ "dirty map             : dmap" },
{ "estimated object      : o(k)" },
{ "reconvolved estimated" },
{ "object                : oc(k)" },
{ "correctin function    : t(k)" },
{ "multiplication        :  *" },
{ "convolution           : (*)" },
{ " " },
{ "start:    o(0) = dmap" },
{ " " },
{ "iteration:" },
{ "oc(k) = o(k) (*) dbeam" },
{ "t(k)  = (dmap/oc(k)) (*) dbeam" },
{ "o(k+1)= o(k) * t(k)" },
{ " " },
{ "Due to calculation of the quotient for t(k) the algorithm is sensitive to noise. Therefore a weighting function has been implemented which is unity if the dmap signal is larger than \"thresh\" and zero elsewhere. t(k) is only calculated in that area and hence the deconvolution is only effective there. Threshold equals input if positive. If input is negative thresh is determined via mean and rms in the area below abs(thresh). If thresh is zero thresh is determined in the area below -0.1 times the maximum flux in dmap. The redetermined threshold is mean value plus 3 times rms." },
{ " " },
{ "To check on convergence of algorithm the rms between input dmap and current lucy deconvolved map reconvolved with dbeam is calculated." },
{ " " },
{ "Syntax" },
{ "result = lucy(X, PSF, N [, THRESHOLD])" },
{ "Arguments" },
{ "X: A matrix." },
{ "PSF: A matrix." },
{ "N: An integer number." },
{ "THRESHOLD: A real number." },
{ "See also" },
{ "function clean" },
{ "function wien" },
{ "Notes" },
{ "The memory required for lucy deconvolution (in bytes) calculates as 44*(Number of pixels in the image)." }
}
},
{
{ "center" }, {
{ "Shifts the brightest pixel in X to the center." },
{ "Syntax" },
{ "result = center(X)" },
{ "Arguments" },
{ "X: A matrix." }
}
},
{
{ "3dnorm (obsolete)" }, {
{ "Normalizes a 3D datacube." },
{ "Syntax" },
{ "result = 3dnorm(X, filename)" },
{ "Arguments" },
{ "X: A matrix." },
{ "filename: Path to a file" }
}
},
{
{ "conj" }, {
{ "Returns the complex conjugate of X." },
{ "Syntax" },
{ "result = conj(X)" },
{ "Arguments" },
{ "X: A matrix or a complex number." },
{ "See also" },
{ "function complex" },
{ "function real" },
{ "function imag" },
{ "function arg" },
{ "function abs" }
}
},
{
{ "correl" }, {
{ "Returns the cross-correlation of X and Y." },
{ "Syntax" },
{ "result = correl(X, Y)" },
{ "Arguments" },
{ "X: A matrix." },
{ "Y: A matrix." }
}
},
{
{ "readfits" }, {
{ "Read specified FITS file into memory. The optional arguments x1, x2, y1, y2, z1, z2 can be used to read in a part of a FITS file. The combination 0, 0 specifies that the complete range of the respective axis should be read in." },
{ "Syntax" },
{ "result = readfits(FILENAME [, x1, x2 [, y1, y2 [, z1, z2]]])" },
{ "Arguments" },
{ "FILENAME: A string." },
{ "x1, x2: Range in first dimension, defaults to 0, 0" },
{ "y1, y2: Range in second dimension, defaults to 0, 0" },
{ "z1, z2: Range in third dimension, defaults to 0, 0" },
{ "Examples" },
{ "Read in the 150th to 160th slice of a datacube:" },
{ "subcube = readfits(\"cube.fits\", 0, 0, 0, 0, 150, 160)" },
{ "See also" },
{ "function readfitsextension" },
{ "function readfitsall" }
}
},
{
{ "3dspec" }, {
{ "Returns an average 3D spectrum of X (dispersion along the third dimension) using the mask Y (2-dim) or the center (x,y) with radii r1 and r2." },
{ "Syntax" },
{ "result = 3dspec(X, Y)<br>" },
{ "result = 3dspec(X, xcenter, ycenter [, r1 [, r2]])" },
{ "Arguments" },
{ "X: A three dimensional matrix." },
{ "Y: A two dimensional matrix." },
{ "xcenter: The central pixel of the spectrum in the first dimension." },
{ "ycenter: The central pixel of the spectrum in the second dimension." },
{ "r1: The radius of the circular aperture to be used." },
{ "r2: The scaled average of all values in the annulus defined by r1 and r2 will be subtracted from the spectrum (local sky subtraction)." }
}
},
{
{ "stddev" }, {
{ "Returns the standard deviation of X, optionally omitting a value." },
{ "Syntax" },
{ "result = stddev(X [, omit])" },
{ "Arguments" },
{ "X: A matrix." },
{ "omit: A value to be omitted when calculating the standard deviation." },
{ "Switches" },
{ "/x: Calculate the standard deviation along the first axis" },
{ "/y: Calculate the standard deviation along the second axis" },
{ "/z: Calculate the standard deviation along the third axis" },
{ "/xy: Calculate the standard deviation along the first and second axes" },
{ "/xz: Calculate the standard deviation along the first and third axes" },
{ "/yz: Calculate the standard deviation along the second and third axes" },
{ "Examples" },
{ "To get a 1D vector of the standard deviation of all slices along a 3D cube:" },
{ "v = stddev(cube, /xy)" },
{ "See also" },
{ "function max" },
{ "function min" },
{ "function avg" },
{ "function total" },
{ "function median" },
{ "function stddev" },
{ "function variance" },
{ "function meddev" }
}
},
{
{ "variance" }, {
{ "Returns the variance of X." },
{ "Syntax" },
{ "result = variance(X)" },
{ "Arguments" },
{ "X: A matrix." },
{ "Switches" },
{ "/x: Calculate the variance along the first axis" },
{ "/y: Calculate the variance along the second axis" },
{ "/z: Calculate the variance along the third axis" },
{ "/xy: Calculate the variance along the first and second axes" },
{ "/xz: Calculate the variance along the first and third axes" },
{ "/yz: Calculate the variance along the second and third axes" },
{ "Examples" },
{ "To get a 1D vector of the variance of all slices along a 3D cube:" },
{ "v = variance(cube, /xy)" },
{ "See also" },
{ "function max" },
{ "function min" },
{ "function avg" },
{ "function total" },
{ "function median" },
{ "function stddev" },
{ "function variance" },
{ "function meddev" }
}
},
{
{ "meddev" }, {
{ "Returns the median deviation from the median in X." },
{ "Syntax" },
{ "result = meddev(X)" },
{ "Arguments" },
{ "X: A matrix." },
{ "Switches" },
{ "/x: Calculate the median deviation along the first axis" },
{ "/y: Calculate the median deviation along the second axis" },
{ "/z: Calculate the median deviation along the third axis" },
{ "/xy: Calculate the median deviation along the first and second axes" },
{ "/xz: Calculate the median deviation along the first and third axes" },
{ "/yz: Calculate the median deviation along the second and third axes" },
{ "Examples" },
{ "To get a 1D vector of the median deviation of all slices along a 3D cube:" },
{ "v = meddev(cube, /xy)" },
{ "See also" },
{ "function max" },
{ "function min" },
{ "function avg" },
{ "function total" },
{ "function median" },
{ "function stddev" }
}
},
{
{ "saomark" }, {
{ "Interactively mark pixels in ds9 which are marked on the display. The resulting array will have a value of 1 in each marked pixel, a value of 0 elsewhere. Press any key to mark a point, press 'd' to delete an already marked point, press 'q' to quit. (Use ds9 v5.2 or newer!)" },
{ "Syntax" },
{ "result = saomark()" },
{ "Arguments" },
{ "none" }
}
},
{
{ "random" }, {
{ "Returns a random number between 0 and 1. If SEED is not set, a seed based on the current time is used." },
{ "Syntax" },
{ "result = random([SEED])" },
{ "Arguments" },
{ "SEED: An integer number." },
{ "See also" },
{ "function randomg" }
}
},
{
{ "import" }, {
{ "Imports a text file. If the first character in the file is numeric, the values in the file are written into a numerical array. The number of lines in the file then determine NAXIS2, the number of individual entries in the first line of the file determines NAXIS1. Else the text file will be written into a string array." },
{ "Syntax" },
{ "result = import(FILENAME [, /text] [, /number])" },
{ "Arguments" },
{ "FILENAME: A string." },
{ "Switches" },
{ "/text: Force to read into a string array" },
{ "/number: Force to read into a numerical array" }
}
},
{
{ "rebin" }, {
{ "Rebins X to the new axis lengths X1 and X2 using a bilinear interpolation. The aspect ratio is not preserved." },
{ "Syntax" },
{ "result = rebin(X, X1, X2)" },
{ "Arguments" },
{ "X: A matrix." },
{ "X1: An integer number." },
{ "X2: An integer number." }
}
},
{
{ "stringarray" }, {
{ "Returns a string array. If X is an integer number, a string array will have X entries which are all initialized to empty strings. If X is a string, the string array will initially have one element which is set to X." },
{ "Syntax" },
{ "result = stringarray(X)" },
{ "Arguments" },
{ "X: A positive integer number." }
}
},
{
{ "nelements" }, {
{ "Returns the number of elements in X. For a matrix, this is the total number of pixels, for a string, the number of characters, and for a stringarray, the number of strings." },
{ "Syntax" },
{ "result = nelements(X)" },
{ "Arguments" },
{ "X: A matrix, string, or string array." }
}
},
{
{ "ssastat" }, {
{ "Returns statistics for ssa. Arguments like ssa. The resulting array will be [xshift, yshift, min, max, flux, fwhm, flag]." },
{ "Syntax" },
{ "result = ssastat(X, XCENTER, YCENTER, SKY, FLAT, DPL, MASK [, METHOD])" },
{ "Arguments" },
{ "X: A FITS datacube" },
{ "XCENTER: The pixel where to shift in the first dimension" },
{ "YCENTER: The pixel where to shift in the second dimension" },
{ "SKY: A sky to be subtracted" },
{ "FLAT: A flatfield to be multiplied" },
{ "DPL: A dead pixel list to be applied" },
{ "MASK: The peak pixel will be searched for in an image multiplied by this mask" },
{ "METHOD: Optional, controls how the SSA will be done:" },
{ "METHOD = 0: Shift the brightest pixel to XCENTER, YCENTER (default)" },
{ "METHOD = 1: Integer shift the centroid to XCENTER, YCENTER" },
{ "METHOD = 2: Subpixel shift the centroid to XCENTER, YCENTER" },
{ "METHOD < 0: the same is done as if METHOD were set to 0, but the brightest pixel is searched in a smoothed version of the image. The smoothing is done by convolving with a gaussian of fwhm the negative of method." },
{ "See also" },
{ "function ssa" },
{ "function sssa" }
}
},
{
{ "sssa" }, {
{ "Calculates the simple shift-and-add of all images in X. If X is a FITS file, a memory saving method will be used to do the ssa." },
{ "Syntax" },
{ "result = sssa(X, STATS, SKY, FLAT, DPL, MASK [, METHOD])" },
{ "Arguments" },
{ "X: A FITS datacube" },
{ "STATS: An array created with the ssastat function. If its flag is not 1, the image will be skipped" },
{ "SKY: A sky to be subtracted" },
{ "FLAT: A flatfield to be multiplied" },
{ "DPL: A dead pixel list to be applied" },
{ "MASK: The peak pixel will be searched for in an image multiplied by this mask" },
{ "METHOD: Optional, controls how the SSA will be done:" },
{ "METHOD = 0: Shift the brightest pixel to XCENTER, YCENTER (default)" },
{ "METHOD = 1: Integer shift the centroid to XCENTER, YCENTER" },
{ "METHOD = 2: Subpixel shift the centroid to XCENTER, YCENTER" },
{ "See also" },
{ "function ssa" },
{ "function ssastat" }
}
},
{
{ "ssaselect" }, {
{ "Obsolete function" }
}
},
{
{ "maxentropy" }, {
{ "Maximum entropy deconvolution of X using PSF." },
{ "Syntax" },
{ "result = maxentropy(X, PSF, N [, MASK])" },
{ "Arguments" },
{ "X: A matrix." },
{ "PSF: A matrix." },
{ "N: An integer number." },
{ "MASK: An optional mask of image regions to be used." }
}
},
{
{ "cubeminimum" }, {
{ "Returns the minimum of each pixel along the 3rd axis if X is a cube." },
{ "Syntax" },
{ "result = cubeminimum(X)" },
{ "Arguments" },
{ "X: A matrix or a FITS file name. If a FITS file name is given, only one image is read into memory at a time thus saving memory." }
}
},
{
{ "cubemaximum" }, {
{ "Returns the maximum of each pixel along the 3rd axis if X is a cube." },
{ "Syntax" },
{ "result = cubemaximum(X)" },
{ "Arguments" },
{ "X: A matrix or a FITS file name. If a FITS file name is given, only one image is read into memory at a time thus saving memory." }
}
},
{
{ "fwhm" }, {
{ "Returns the second order moment of X centered at [XCENTER, YCENTER] within RADIUS, which corresponds to the FWHM at that location. The parameter RADIUS is optional. If skipped, a default of 5 pixels will be used." },
{ "Syntax" },
{ "result = fwhm(X, XCENTER, YCENTER [, RADIUS])" },
{ "Arguments" },
{ "X: A matrix." },
{ "XCENTER: An integer number." },
{ "YCENTER: An integer number." },
{ "RADIUS: An integer number." }
}
},
{
{ "setbitpix" }, {
{ "Change the pixel type of X." },
{ "Syntax" },
{ "result = setbitpix(X, BITPIX [, BSCALE [, BZERO]])" },
{ "Arguments" },
{ "X: The array whose pixel type is to be changed" },
{ "BITPIX: Desired pixel type:" },
{ "BITPIX = -128: Complex (note that this does not conform to FITS standard)" },
{ "BITPIX =  -64: Floating point, double precision" },
{ "BITPIX =  -32: Floating point, single precision" },
{ "BITPIX =    8: Unsigned char" },
{ "BITPIX =   16: Short" },
{ "BITPIX =   32: Long" },
{ "BITPIX =   64: Long Long" },
{ "BSCALE, BZERO: For integer BITPIX, optionally BSCALE and BZERO can be given. The value represented by each pixel is given by value * BSCALE + BZERO (the defaults are BSCALE = 1 and BZERO = 0)" },
{ "See also" },
{ "function getbitpix" }
}
},
{
{ "bytearray" }, {
{ "Returns an array with bitpix = 8 (all pixels are of type unsigned char). bscale will be set to 1.0, bzero to 0.0." },
{ "Syntax" },
{ "result = bytearray(X [, Y [, Z]])" },
{ "Arguments" },
{ "X: An integer number specifying the length of the first dimension." },
{ "Y: An integer number specifying the length of the second dimension." },
{ "Z: An integer number specifying the length of the third dimension." },
{ "See also" },
{ "function fits" },
{ "function shortarray" },
{ "function longarray" },
{ "function floatarray" },
{ "function doublearray" },
{ "function complexarray" }
}
},
{
{ "shortarray" }, {
{ "Returns an array with bitpix = 16 (all pixels are of type short). bscale will be set to 1.0, bzero to 0.0." },
{ "Syntax" },
{ "result = short(array(X [, Y [, Z]])" },
{ "Arguments" },
{ "X: An integer number specifying the length of the first dimension." },
{ "Y: An integer number specifying the length of the second dimension." },
{ "Z: An integer number specifying the length of the third dimension." },
{ "See also" },
{ "function fits" },
{ "function bytearray" },
{ "function longarray" },
{ "function floatarray" },
{ "function doublearray" },
{ "function complexarray" }
}
},
{
{ "longarray" }, {
{ "Returns an array with bitpix = 32 (all pixels are of type long). bscale will be set to 1.0, bzero to 0.0." },
{ "Syntax" },
{ "result = longarray(X [, Y [, Z]])" },
{ "Arguments" },
{ "X: An integer number specifying the length of the first dimension." },
{ "Y: An integer number specifying the length of the second dimension." },
{ "Z: An integer number specifying the length of the third dimension." },
{ "See also" },
{ "function fits" },
{ "function bytearray" },
{ "function shortarray" },
{ "function floatarray" },
{ "function doublearray" },
{ "function complexarray" }
}
},
{
{ "floatarray" }, {
{ "Returns an array with bitpix = -32 (all pixels are of type float)." },
{ "Syntax" },
{ "result = floatarray(X [, Y [, Z]])" },
{ "Arguments" },
{ "X: An integer number specifying the length of the first dimension." },
{ "Y: An integer number specifying the length of the second dimension." },
{ "Z: An integer number specifying the length of the third dimension." },
{ "See also" },
{ "function fits" },
{ "function bytearray" },
{ "function shortarray" },
{ "function longarray" },
{ "function doublearray" },
{ "function complexarray" }
}
},
{
{ "doublearray" }, {
{ "Returns an array with bitpix = -64 (all pixels are of type double)." },
{ "Syntax" },
{ "result = doublearray(X [, Y [, Z]])" },
{ "Arguments" },
{ "X: An integer number specifying the length of the first dimension." },
{ "Y: An integer number specifying the length of the second dimension." },
{ "Z: An integer number specifying the length of the third dimension." },
{ "See also" },
{ "function fits" },
{ "function bytearray" },
{ "function shortarray" },
{ "function longarray" },
{ "function floatarray" },
{ "function complexarray" }
}
},
{
{ "complexarray" }, {
{ "Returns an array with bitpix = -128 (all pixels are of type complex). !!! WARNING: bitpix = -128 does NOT conform to the FITS standard !!!" },
{ "Syntax" },
{ "result = complexarray(X [, Y [, Z]])" },
{ "Arguments" },
{ "X: An integer number specifying the length of the first dimension." },
{ "Y: An integer number specifying the length of the second dimension." },
{ "Z: An integer number specifying the length of the third dimension." },
{ "See also" },
{ "function fits" },
{ "function bytearray" },
{ "function shortarray" },
{ "function longarray" },
{ "function floatarray" },
{ "function doublearray" }
}
},
{
{ "shrink" }, {
{ "Shrinks X or the specified axis of X by specified FACTOR" },
{ "Syntax" },
{ "result = shrink(X, FACTOR [, AXIS])" },
{ "Arguments" },
{ "X: A matrix." },
{ "FACTOR: An integer number." },
{ "AXIS: optionally, which axis to shrink (1, 2, or 3)" }
}
},
{
{ "getfitskey" }, {
{ "Returns the value of specified FITS key in the header of X. The returned type can be either a string, an integer number or a real number. If the specified key does not exist, an empty string is returned." },
{ "Syntax" },
{ "result = getfitskey(X, KEY [, extension] [, /text])" },
{ "Arguments" },
{ "X: A matrix or a FITS file." },
{ "KEY: A string." },
{ "extension: Integer number specifying which extension to read." },
{ "Switches" },
{ "text: Return the fits key as a string." }
}
},
{
{ "polyfit" }, {
{ "Returns a N-th order polynomial fit to X. X must be 1-dimensional. The function returns a vector of size (N+1)*2. The fittet polynomial has the following form:" },
{ "f(x) = a0 + a1 * x + ... + aN * X^N" },
{ "The values a0, ..., aN are returned in the first N elements of the returned vector, their respective errors in the elements N+1...2*N." },
{ "Syntax" },
{ "result = polyfit(X, N [, CHISQ])" },
{ "Arguments" },
{ "X: A vector." },
{ "N: An integer number." },
{ "CHISQ: If set to a named variable, the variable is overwritten with the chi-squared of the fit." },
{ "See also" },
{ "function polyfitxy" },
{ "function polyfitxyerr" },
{ "function polyfit2d" },
{ "function polyfit2derr" }
}
},
{
{ "sprintf" }, {
{ "RETURNS X (either a real number or an integer) as a string using specified format string. The formatting is done like in the C printf function. The total length of the formatted string is limited to 256 characters." },
{ "Syntax" },
{ "result = sprintf(FORMAT, X)" }
}
},
{
{ "photometry" }, {
{ "Perform aperture photometry on X. This function returns a 3xn matrix with the following information: measured counts, normalized counts (Jansky), magnitude." },
{ "Syntax" },
{ "result = photometry(X, POSLIST, REFLIST, SEARCHBOX, RADIUS, [,/u | /b | /v | /r | /i | /j | /h | /k | /l | /m | /n])" },
{ "Arguments" },
{ "X: The image on which to do aperture photometry" },
{ "POSLIST: A 2xn matrix containing the positions of the stars" },
{ "REFLIST: A 1xm matrix containing magnitudes of reference stars (in the same order as in poslist), with a value > 20.0 if not to be used" },
{ "SEARCHBOX: Within a box with this radius the local maximum of the stars are searched" },
{ "RADIUS: The radius of the circular aperture used for photometry" },
{ "Switches" },
{ "/u: Do photometry for U-Band (epsilon = 3.274)" },
{ "/b: Do photometry for B-Band (epsilon = 3.674)" },
{ "/v: Do photometry for V-Band (epsilon = 3.581)" },
{ "/r: Do photometry for R-Band (epsilon = 3.479)" },
{ "/i: Do photometry for I-Band (epsilon = 3.386)" },
{ "/j: Do photometry for J-Band (epsilon = 3.248)" },
{ "/h: Do photometry for H-Band (epsilon = 3.08)" },
{ "/k: Do photometry for K-Band  (epsilon = 2.8) (default)" },
{ "/l: Do photometry for L-Band (epsilon = 2.49)" },
{ "/m: Do photometry for M-Band (epsilon = 2.26)" },
{ "/n: Do photometry for N-Band (epsilon = 1.63)" }
}
},
{
{ "transcoords" }, {
{ "Transform a set of coordinates from one image to another. The coordinate transformation matrix is described by a first order polynomial if the number of reference sources is <= 6, else a second order polynomial is used. The transformation function will be calculated using a least squares fit to given coordinates. Note that if either in REFSTARS or in IMSTARS a coordinate is exactly (-1, -1), this star will not be used to calculate the transformation matrix." },
{ "Syntax" },
{ "result = transcoords(MASTERLIST, REFSTARS, IMSTARS [, xerror, yerror][, /silent] [, /linear] [, /cubic] [, /rotation])" },
{ "Arguments" },
{ "MASTERLIST: A matrix 2xn with the coordinates to be transformed" },
{ "REFSTARS: A matrix 2xm (m >= 3) with positions of the reference stars in the reference frame (= masterlist)" },
{ "IMSTARS: A matrix 2xm (same size as REFSTARS) with the positions of the same stars in the image to be transformed." },
{ "xerror: If set to a named variable, the residual error of the coordinate transform in the first axis is returned." },
{ "yerror: If set to a named variable, the residual error of the coordinate transform in the second axis is returned." },
{ "Switches" },
{ "/silent: Printing of output is suppressed" },
{ "/linear: A 1st order polynomial is fitted (even when more than 6 reference sources are supplied)" },
{ "/cubic: A 3rd order polynomial is fitted (at least 10 reference sources)" },
{ "/rotation: A rotational transformation is fitted (at least 4 reference sources): x' = x0 + f*cos(a)*x - f*sin(a)*y, y' = y0 + f*sin(a)*x + f*cos(a)*y" },
{ "See also" },
{ "function transmatrix" },
{ "function transform" }
}
},
{
{ "findfile" }, {
{ "Returns all files that satisfy given PATTERN. All occurrences of a backslash are replaced by a slash. Also, a slash is appended to all directories. The search is started from the current directory and is done recursively through the directory structure." },
{ "Syntax" },
{ "result = findfile(PATTERN)" },
{ "Arguments" },
{ "PATTERN: A string." },
{ "Examples" },
{ "Find all text files (files with the suffix .txt) from the current working directory:" },
{ "print findfile(\"*.txt\")" },
{ "See also" },
{ "function dir" },
{ "function fileexists" }
}
},
{
{ "markpos" }, {
{ "Mark positions using ds9. The positions are returned as a 2xn matrix, where n denotes the number of positions marked. Pressing the key 'q' will quit marking positions. When typing numbers between 1 and 9 the values are stored at that specific position. This way values can be overwritten. (Use ds9 v5.2 or newer!)" },
{ "Syntax" },
{ "result = markpos(X [, int radius] [, /nocenter])" },
{ "Arguments" },
{ "X: The image to be displayed on saoimage" },
{ "radius: Optional, the radius around which the brightest pixel is searched for using centroid-method." },
{ "Switches" },
{ "nocenter: Has no effect when no radius is supplied. Returns the local maximum in the radius around the marked pixel." },
{ "See also" },
{ "function saomark" }
}
},
{
{ "lmst" }, {
{ "Calculate the local mean siderial time for given Julian date. If longitude is given (east negative), the local mean sidereal time for that location is returned, else the lmst for Greenwich (longitude 0). NOTE that timezones for given longitude are not taken into account, so always give jd in Universal Time." },
{ "Syntax" },
{ "result = lmst(JD [, LATITUDE])" },
{ "Arguments" },
{ "JD: A real number." },
{ "LATITUDE: A real number." },
{ "See also" },
{ "function jd" }
}
},
{
{ "wsa" }, {
{ "Compute weighted shift-and-add of the fits cube X (must be a file). The shift location is defined by xcen, ycen. thresh gives the fraction of the maximum pixel which will be regarded as a speckle. speckles determines the maximum number of speckles used (if there are more, then the image will be smoothed until it is not exceeded). smooth optionally gives the fwhm of a gaussian with which the image where speckles are searched for is smoothed. If bigmask is given, the centroid of mask will be shifted to the centroid of bigmask for each individual image." },
{ "Syntax" },
{ "result = wsa(X, XCENTER, YCENTER, THRESHOLD, SPECKLES, SMOOTH, SKY, FLAT, DPL, MASK [, BIGMASK])" },
{ "Arguments" },
{ "X: A FITS filename (enclosed in single quotes)." },
{ "XCENTER: An integer number specifying the shift position in the first dimension." },
{ "YCENTER: An integer number specifying the shift position in the second dimension." },
{ "THRESHOLD: A real number." },
{ "SPECKLES: An integer number." },
{ "SMOOTH: An integer number." },
{ "SKY: A matrix." },
{ "FLAT: A matrix." },
{ "DPL: A matrix." },
{ "MASK: A matrix." },
{ "BIGMASK: A matrix." }
}
},
{
{ "swsa" }, {
{ "Compute weighted shift-and-add of the fits cube X (must be a file). flags is a 1-dimensional array that has a value of zero for each image that is to be skipped. The shift location is defined by xcen, ycen. thresh gives the fraction of the maximum pixel which will be regarded as a speckle. speckles determines the maximum number of speckles used (if there are more, then the image will be smoothed until it is not exceeded). smooth optionally gives the fwhm of a gaussian with which the image where speckles are searched for is smoothed. If bigmask is given, the centroid of mask will be shifted to the centroid of bigmask for each individual image." },
{ "Syntax" },
{ "result = wsa(X, FLAGS, XCENTER, YCENTER, THRESHOLD, SPECKLES, SMOOTH, SKY, FLAT, DPL, MASK, BIGMASK)" },
{ "Arguments" },
{ "X: A FITS filename (enclosed in single quotes)." },
{ "FLAGS: A vector." },
{ "XCENTER: An integer number specifying the shift position in the first dimension." },
{ "YCENTER: An integer number specifying the shift position in the second dimension." },
{ "THRESHOLD: A real number." },
{ "SPECKLES: An integer number." },
{ "SMOOTH: An integer number." },
{ "SKY: A matrix." },
{ "FLAT: A matrix." },
{ "DPL: A matrix." },
{ "MASK: A matrix." },
{ "BIGMASK: A matrix." }
}
},
{
{ "centroids" }, {
{ "Returns a 2xn matrix with the centroids (in a RADIUS) on given POSITIONS in X." },
{ "Syntax" },
{ "result = centroids(X, POSITIONS, RADIUS)" },
{ "Arguments" },
{ "X: A matrix." },
{ "POSITIONS: A 2xn matrix with initial positions." },
{ "RADIUS: An integer number." },
{ "See also" },
{ "function maxima" },
{ "function gausspos" }
}
},
{
{ "maxima" }, {
{ "Refind local maxima in X given POSITIONS around RADIUS." },
{ "Syntax" },
{ "result = maxima(X, POSITIONS, RADIUS [, /circle, /box])" },
{ "Arguments" },
{ "X: A matrix." },
{ "POSITIONS: A 2xn matrix with initial positions." },
{ "RADIUS: An integer number." },
{ "Switches" },
{ "/circle: Local maxima are searched for within a circle with RADIUS" },
{ "/box: Local maxima are search for within a quadratic box with RADIUS" },
{ "See also" },
{ "function centroids" },
{ "function gausspos" }
}
},
{
{ "gausspos" }, {
{ "Returns a 2xn matrix with 2D gaussfits (in a RADIUS) on given POSITIONS in X." },
{ "Syntax" },
{ "result = gausspos(X, POSITIONS, RADIUS)" },
{ "Arguments" },
{ "X: A matrix." },
{ "POSITIONS: A 2xn matrix with initial positions." },
{ "RADIUS: An integer number." },
{ "See also" },
{ "function maxima" },
{ "function centroids" }
}
},
{
{ "fileexists" }, {
{ "Test for existence of a file. Returns 1 if the file exist, 0 otherwise." },
{ "Syntax" },
{ "result = fileexists(FILENAME)" },
{ "Arguments" },
{ "FILENAME: A string." },
{ "See also" },
{ "function findfile" },
{ "function dir" },
{ "function filesize" }
}
},
{
{ "filesize" }, {
{ "Return the length in bytes of a file. Returns -1 if the file does not exist." },
{ "Syntax" },
{ "result = filesize(FILENAME)" },
{ "Arguments" },
{ "FILENAME: A string." },
{ "See also" },
{ "function findfile" },
{ "function dir" },
{ "function fileexists" }
}
},
{
{ "dir" }, {
{ "Return a directory listing." },
{ "Syntax" },
{ "result = dir([DIRECTORY], [, /recursive])" },
{ "Arguments" },
{ "DIRECTORY: Optional, do a directory listing of specified directory, else of the current working directory" },
{ "Switches" },
{ "/recursive: Do a recursive listing" },
{ "Examples" },
{ "To print a recursive listing of the current directory, type" },
{ "print dir(\"\", /recursive)" },
{ "See also" },
{ "function findfile" },
{ "function filesize" },
{ "function fileexists" }
}
},
{
{ "polyfitxy" }, {
{ "Return an n-th order polynomial fit to the vectors X and Y, where y = f(x). If a variable is given as the 4th argument, it will be overwritten with the chi squared of the fit." },
{ "Syntax" },
{ "result = polyfitxy(X, Y, N [, CHISQ])" },
{ "Arguments" },
{ "X: A vector." },
{ "Y: A vector." },
{ "N: An integer number." },
{ "CHISQ: If set to a named variable, the variable is overwritten with the chi-squared of the fit." },
{ "See also" },
{ "function polyfit" },
{ "function polyfitxyerr" },
{ "function polyfit2d" },
{ "function polyfit2derr" }
}
},
{
{ "sort" }, {
{ "Returns an index list of X in ascending order." },
{ "Syntax" },
{ "result = sort(X [, /reverse])" },
{ "Arguments" },
{ "X: A matrix, a string or a string array." },
{ "Switches" },
{ "/reverse: The index list will be in descending order" },
{ "Examples" },
{ "To sort a directory listing in alphabetical order, type:" },
{ "list = dir(\"/tmp\"); list = list[sort(list)]" }
}
},
{
{ "char" }, {
{ "Returns the ASCII character which number is N. N is truncated to the range 0...255." },
{ "Syntax" },
{ "result = char(N)" },
{ "Arguments" },
{ "N: An integer number." },
{ "Examples" },
{ "To print out the ASCII character set, type:" },
{ "for (i = 32; i < 256; i++) print char(i)" }
}
},
{
{ "complex" }, {
{ "Returns a complex number generated of the two given values." },
{ "Syntax" },
{ "result = complex(r, i)" },
{ "Arguments" },
{ "r: The real part (either a real number or a matrix)" },
{ "i: the imaginary part (either a real number or a matrix)" },
{ "See also" },
{ "function real" },
{ "function imag" },
{ "function conj" },
{ "function arg" },
{ "function abs" }
}
},
{
{ "strpos" }, {
{ "Returns the position of a substring within a string, or -1 if the substring does not occur. If the first argument is a string array, a matrix with the same number of elements as the string is returned." },
{ "Syntax" },
{ "result = strpos(X, Y)" },
{ "Arguments" },
{ "X: A string or a string array" },
{ "Y: The substring to be searched for" },
{ "Switches" },
{ "/nocase: The search is done case-insensitive" }
}
},
{
{ "clean" }, {
{ "Performs \"cleaning\" of the input image. This iterative deconvolution algorithm" },
{ "searches for the global maximum in the image, shifts the psf to that position and subtracts a scaled psf (multiplied by the gain). The subtracted flux is added to a delta map at the position of the maximum (this is the clean map). Note that clean does not conserve the total flux in the image." },
{ "Syntax" },
{ "result = clean(IMAGE, PSF, N, GAIN [, variable SUB])" },
{ "Arguments" },
{ "IMAGE: input map to be cleaned (dirty map)" },
{ "PSF: Point spread function (dirty beam)" },
{ "N: Number of iterations" },
{ "GAIN: Loop gain factor" },
{ "SUB: Optional, the variable SUB will contain an image in which the sources are subtracted" },
{ "See also" },
{ "function lucy" },
{ "function wien" }
}
},
{
{ "collapse" }, {
{ "Collapse one axis of an array. All values along the specified axis will be summed up. The resulting array will have one dimension less than the input." },
{ "Syntax" },
{ "result = collapse(IMAGE, AXIS)" },
{ "Arguments" },
{ "IMAGE: A matrix." },
{ "AXIS: An integer number." },
{ "Examples" },
{ "Do a sum of all images in a datacube:" },
{ "s = collapse(cube, 3)" },
{ "This is exactly the same as:" },
{ "s = cubeavg(cube) * naxis3(cube)" },
{ "See also" },
{ "function cubeavg" }
}
},
{
{ "magnify" }, {
{ "Resize given array by the scaling factor. Each pixel in the resized array will be blown up and consequently contain scale^2 pixels. The optional argument smooth gives the fwhm of a gaussian with which the resultant array will we smoothed. The total flux in the array will be conserved." },
{ "Syntax" },
{ "result = magnify(IMAGE, scale [, fwhm])" },
{ "Arguments" },
{ "IMAGE: A matrix" },
{ "scale: An integer number." },
{ "fwhm: A real number." }
}
},
{
{ "wsastat" }, {
{ "Compute statistics for the weighted shift-and-add of the fits cube X (must be a file). The shift location is defined by xcen, ycen. thresh gives the fraction of the maximum pixel which will be regarded as a speckle. speckles determines the maximum number of speckles used (if there are more, then the image will be smoothed until it is not exceeded). smooth optionally gives the fwhm of a gaussian with which the image where speckles are searched for is smoothed. If bigmask is given, the centroid of mask will be shifted to the centroid of bigmask for each individual image." },
{ "Syntax" },
{ "result = wsastat(X, XCENTER, YCENTER, THRESHOLD, SPECKLES, SMOOTH, SKY, FLAT, DPL, MASK, BIGMASK)" },
{ "Arguments" },
{ "X: A FITS filename (enclosed in single quotes)." },
{ "XCENTER: An integer number specifying the shift position in the first dimension." },
{ "YCENTER: An integer number specifying the shift position in the second dimension." },
{ "THRESHOLD: A real number." },
{ "SPECKLES: An integer number." },
{ "SMOOTH: An integer number." },
{ "SKY: A matrix." },
{ "FLAT: A matrix." },
{ "DPL: A matrix." },
{ "MASK: A matrix." },
{ "BIGMASK: A matrix." }
}
},
{
{ "gaussfit" }, {
{ "Fit a one-dimensional gaussian to a vector. The gauss function is defined as G(x) = A + B*exp(-4ln2*(x-x0)^2/fwhm^2)." },
{ "Syntax" },
{ "result = gaussfit(X, Y, errors, estimate [, chisq])" },
{ "Arguments" },
{ "X: A vector containing the x values to be fit" },
{ "Y: A vector containing the y values to be fit" },
{ "errors: The errors in Y" },
{ "estimate: Initial estimate for the fit of the form [A, B, x0, fwhm]" },
{ "chisq: If set to a named variable, the variable is overwritten with the chi-squared of the fit." },
{ "Returns" },
{ "The returned vector contains the best-fit parameters in the form [A, B, x0, fwhm, d_A, d_B, d_x0, d_fwhm]" },
{ "See also" },
{ "function evalgaussfit" }
}
},
{
{ "gauss2dfit" }, {
{ "Fit a two-dimensional gaussian to a rectangular grid (i.e. an image)." },
{ "Syntax" },
{ "result = gauss2dfit(image, errors, estimate [, chisq])" },
{ "Arguments" },
{ "image: The image to be fit" },
{ "errors: The errors in the image values" },
{ "estimate: Initial estimate for the fit of the form [Offset,Max,x0,y0,fwhm1,fwhm2,angle]" },
{ "chisq: If set to a named variable, the variable is overwritten with the chi-squared of the fit." },
{ "Returns" },
{ "The returned vector contains the best-fit parameters in the form [Offset, Max, x0, y0, fwhm1, fwhm2, angle, d_Offset, d_Max, d_x0, d_y0, d_fwhm1, d_fwhm2, d_angle]" },
{ "See also" },
{ "function gauss2dsimplefit" },
{ "function multigauss2dfit" }
}
},
{
{ "polyfitxyerr" }, {
{ "Return an n-th order polynomial fit to the vectors X and Y, where y = f(x). The typical error of the dependent variables is given in ERROR. If a variable is given as the 4th argument, it will be overwritten with the chi squared of the fit." },
{ "Syntax" },
{ "result = polyfitxyerr(X, Y, N, ERROR [, CHISQ])" },
{ "Arguments" },
{ "X: A vector." },
{ "Y: A vector." },
{ "N: An integer number." },
{ "ERROR: The error of the Y-values. If this is a real number, all Y-values are assumed to have the same error. If ERROR is a vector, it must have the same length as X and Y and gives the error or each individual Y value." },
{ "CHISQ: If set to a named variable, the variable is overwritten with the chi-squared of the fit." },
{ "See also" },
{ "function polyfit" },
{ "function polyfitxy" },
{ "function polyfit2d" },
{ "function polyfit2derr" }
}
},
{
{ "psf" }, {
{ "Return the average (or median, minimum, maximum) of several stars in an image. The stars locations are given in the second argument." },
{ "Syntax" },
{ "result = psf(X, POSITIONS [, /median] [, /average] [, /minimum] [, /maximum])" },
{ "Arguments" },
{ "X: A matrix." },
{ "POSITIONS: A 2xn matrix giving the positions of the stars to be averaged." },
{ "Switches" },
{ "/median: Return the median of the stars (default)." },
{ "/average: Return the average of the stars." },
{ "/minimum: Return the minimum of the stars." },
{ "/maximum: Return the maximum of the stars." }
}
},
{
{ "pwd" }, {
{ "Return the absolute path of the current directory." },
{ "Syntax" },
{ "result = pwd()" },
{ "Arguments" },
{ "none" },
{ "Returns" },
{ "A string with the absolute path of the current directory." },
{ "See also" },
{ "function dir" },
{ "procedure cd" }
}
},
{
{ "quickgauss" }, {
{ "Create a circular gaussian." },
{ "Syntax" },
{ "result = quickgauss(X, Y, FWHM, speed [, naxis1=value] [, naxis2=value])" },
{ "Arguments" },
{ "X: The center of the gaussian in the x-axes" },
{ "Y: The center of the gaussian in the y-axes" },
{ "FWHM: Full-width at half maximum of the circular gaussian" },
{ "speed: The gaussian is calculated up to a distance of speed*FWHM from the center location" },
{ "naxis1=value: Optional, the size of the resulting array in the first dimension" },
{ "naxis2=value: Optional, the size of the resulting array in the second dimension" },
{ "Returns" },
{ "A two-dimensional circular gaussian." },
{ "See also" },
{ "function gauss" }
}
},
{
{ "getenv" }, {
{ "Return the content of an environment variable." },
{ "Syntax" },
{ "result = getenv(S)" },
{ "Arguments" },
{ "S: A string with the name of the environment variable." },
{ "Returns" },
{ "A string with the content of the environment variable. If the environment variable does not exist, an empty string is returned." },
{ "See also" },
{ "procedure setenv" }
}
},
{
{ "cblank" }, {
{ "Replace all undefined values (like NaN or Inf) by another value. If no value is specified, these values will be replace by 0.0." },
{ "Syntax" },
{ "result = cblank(ARRAY [, value])" },
{ "Arguments" },
{ "ARRAY: A matrix" },
{ "value: Optional, the value to be assigned (defaults to 0)" },
{ "See also" },
{ "procedure cblank" }
}
},
{
{ "now" }, {
{ "Return the julian date of the current system time. The timezone (and daylight saving time, if appropriate) are taken into account." },
{ "Syntax" },
{ "result = now()" },
{ "Arguments" },
{ "none" },
{ "See also" },
{ "function jd" },
{ "function calday" }
}
},
{
{ "polar" }, {
{ "Returns a complex number generated of the two given values in polar representation. This is equivalent to complex(a * cos(b), a * sin(b))." },
{ "Syntax" },
{ "result = polar(ampl, arg)" },
{ "Arguments" },
{ "ampl: The amplitude (either a real number or a matrix)" },
{ "arg: The argument (either a real number or a matrix)" },
{ "See also" },
{ "function complex" },
{ "function real" },
{ "function imag" },
{ "function conj" },
{ "function arg" },
{ "function abs" }
}
},
{
{ "transmatrix" }, {
{ "Compute the transformation matrix for two reference coordinate systems. It is described by a first order polynomial if the number of reference sources is <= 6, else a second order polynomial is used. The transformation function will be calculated using a least squares fit to given coordinates. Note that if either in REFSTARS or in IMSTARS a coordinate is exactly (-1, -1), this star will not be used to calculate the transformation matrix." },
{ "Syntax" },
{ "result = transmatrix(REFSTARS, IMSTARS [, xerror, yerror][, /silent] [, /linear] [, /cubic] [, /rotation])" },
{ "Arguments" },
{ "REFSTARS: A matrix 2xm (m >= 3) with positions of the reference stars in the reference frame (= masterlist)" },
{ "IMSTARS: A matrix 2xm (same size as REFSTARS) with the positions of the same stars in the image to be transformed." },
{ "xerror: If set to a named variable, the residual error of the coordinate transform in the first axis is returned." },
{ "yerror: If set to a named variable, the residual error of the coordinate transform in the second axis is returned." },
{ "Switches" },
{ "/silent: Printing of output is suppressed" },
{ "/linear: A 1st order polynomial is fitted (even when more than 6 reference sources are supplied)" },
{ "/cubic: A 3rd order polynomial is fitted (at least 10 reference sources)" },
{ "/rotation: A rotational transformation is fitted (at least 4 reference sources): x' = x0 + f*cos(a)*x - f*sin(a)*y, y' = y0 + f*sin(a)*x + f*cos(a)*y" },
{ "Returns" },
{ "For 1st and 2nd order polynomials: A matrix 2x6 which describes the coordinate transformation matrix:" },
{ "x' = result[1,1] + result[1,2]*x + result[1,3]*y + result[1,4]*xy + result[1,5]*x^2 + result[1,6]*y^2" },
{ "y' = result[2,1] + result[2,2]*x + result[2,3]*y + result[2,4]*xy + result[2,5]*x^2 + result[2,6]*y^2<br>" },
{ "For 3rd order polynomials: A matrix 2x10 which describes the coordinate transformation matrix:" },
{ "x' = result[1,1] + result[1,2]*x + result[1,3]*y + result[1,4]*xy + result[1,5]*x^2 + result[1,6]*y^2 + result[1,7]*x^2y + result[1,8]*xy^2 + result[1,9]*x^3 + result[1,10]*y^3" },
{ "y' = result[2,1] + result[2,2]*x + result[2,3]*y + result[2,4]*xy + result[2,5]*x^2 + result[2,6]*y^2 + result[2,7]*x^2y + result[2,8]*xy^2 + result[2,9]*x^3 + result[2,10]*y^3<br> " },
{ "For rotational transformation: A matrix 1x4 which describes the coordinate transformation matrix:" },
{ "x' = result[1] + result[3] * cos(result[4])*x - result[3] * sin(result[4])*y" },
{ "y' = result[2] + result[3] * sin(result[4])*x + result[3] * cos(result[4])*y" },
{ "See also" },
{ "function transcoords" },
{ "function transform" }
}
},
{
{ "transform" }, {
{ "Apply a transformation matrix to a set of coordinates." },
{ "Syntax" },
{ "result = transform(COORDS, TRANS)" },
{ "Arguments" },
{ "COORDS: A matrix 2xN with the initial coordinates." },
{ "TRANS: A matrix 2x6 which contains the coordinate transformation matrix." },
{ "Returns" },
{ "A matrix 2xN with the transformed coordinates." },
{ "See also" },
{ "function transcoords" },
{ "function transmatrix" }
}
},
{
{ "invert" }, {
{ "Return the inverse of a 2-dimensional, square matrix." },
{ "Syntax" },
{ "result = invert(X)" },
{ "Arguments" },
{ "X: A 2-dimensional, square matrix." },
{ "Returns" },
{ "The inverse of X." },
{ "Examples" },
{ "print X # invert(X), /values<" },
{ "will return a unity matrix" }
}
},
{
{ "transpose" }, {
{ "Return the matrix X transposed, i.e. rows and columns are interchanged." },
{ "Syntax" },
{ "result = transpose(X)" },
{ "Arguments" },
{ "X: A vector or a 2-dimensional matrix." }
}
},
{
{ "isvariable" }, {
{ "Check whether given variable name (as a string) exists in memory." },
{ "Syntax" },
{ "result = isvariable(S)" },
{ "Arguments" },
{ "S: A string with the variable name" },
{ "Returns" },
{ "1 if the variable exists, 0 otherwise" }
}
},
{
{ "pi" }, {
{ "Return the number PI. It will be computet as 2 * acos(0)." },
{ "Syntax" },
{ "result = pi()" },
{ "Arguments" },
{ "none" },
{ "Examples" },
{ "Print the number pi to 15 significant digits:" },
{ "DPUSER> print sprintf(\"%.15f\", pi())" },
{ "3.141592653589793" },
{ "See also" },
{ "category trigonometry" }
}
},
{
{ "convolve" }, {
{ "Convolve an image with a kernel. The resulting array is returned with bitpix -32." },
{ "Syntax" },
{ "result = convolve(a, b)" },
{ "Arguments" },
{ "a: The array to be convolved." },
{ "b: The kernel to convolve the image with." },
{ "Notes" },
{ "If a and b are of exactly the same size, the two are multiplied in fourier space. If b is smaller than a and a square matrix, a convolved with the kernel b is returned." }
}
},
{
{ "gammp" }, {
{ "Return the incomplete gamma function P(a, x)." },
{ "Syntax" },
{ "result = gammp(a, x)" },
{ "Arguments" },
{ "a: A number > 0" },
{ "x: A number > 0, the value where to evaluate the incomplete gamma function" }
}
},
{
{ "reform" }, {
{ "Resize an array without actually moving data. The number of new elements must exactly match the number of elements in the array to be resized. If no size arguments are given, all array axes with length 1 are removed." },
{ "Syntax" },
{ "result = reform(a, [n1 [, n2 [, n3]]])" },
{ "Arguments" },
{ "a: The array to be resized" },
{ "n1: New axis length" },
{ "n2: New axis length" },
{ "n3: New axis length" }
}
},
{
{ "find" }, {
{ "[This documentation is copied literally from IDL's astrolib]" },
{ " " },
{ "Find positive brightness perturbations (i.e stars) in an image. Also returns centroids and shape parameters (roundness & sharpness). Adapted from 1986 STSDAS version of DAOPHOT." },
{ "Syntax" },
{ "result = find(image, hmin, fwhm [, roundlim [, sharplim]] [, /silent])" },
{ "Arguments" },
{ "image: 2 dimensional image array for which one wishes to identify the stars present." },
{ "hmin: Threshold intensity for a point source - should generally be 3 or 4 sigma above background." },
{ "fwhm: FWHM to be used in the convolve filter." },
{ "sharplim: 2 element vector giving low and high cutoff for the sharpness statistic (Default: [0.2,1.0]). Change this default only if the stars have significantly larger or or smaller concentration than a Gaussian." },
{ "roundlim: 2 element vector giving low and high cutoff for the roundness statistic (Default: [-1.0,1.0]). Change this default only if the stars are significantly elongated." },
{ "Switches" },
{ "silent: Normally, FIND will write out each star that meets all selection criteria. If the SILENT keyword is set then this printout is suppressed." },
{ "Returns" },
{ "The find function returns an array of size 5xnstars with the following entries:<br>" },
{ "x: vector containing x position of all stars identified by FIND<br> " },
{ "y: vector containing y position of all stars identified by FIND<br>" },
{ "flux: vector containing flux of identified stars as determined by a gaussian fit. Fluxes are NOT converted to magnitudes.<br>" },
{ "sharp: vector containing sharpness statistic for identified stars<br>" },
{ "round: vector containing roundness statistic for identified stars" },
{ "Notes" },
{ "The sharpness statistic compares the central pixel to the mean of the surrounding pixels.   If this difference is greater than the originally estimated height of the Gaussian or less than 0.2 the height of the Gaussian (for the default values of SHARPLIM) then the star will be rejected." }
}
},
{
{ "histogram" }, {
{ "Create a histogram of given array." },
{ "Syntax" },
{ "result = histogram(a [, min [, max [, binsize]]] [, /reverse])" },
{ "Arguments" },
{ "a: 1D or 2D Array" },
{ "min: Datapoints with a value smaller than min are neglected." },
{ "max: Datapoints with a value greater than max are neglected." },
{ "binsize: Default is 1. Values between are rounded" },
{ "Switches" },
{ "/reverse: Create the reverse indices of a histogram" }
}
},
{
{ "meandev" }, {
{ "Calculate the mean deviation of given array, optionally omitting a value. This is defined as 1/sqrt(n-1)*stddev(a)." },
{ "Syntax" },
{ "result = meandev(a [, omit])" },
{ "Arguments" },
{ "a: The array which mean deviation from the average should be returned." },
{ "omit: An optional value which should be ignored." },
{ "See also" },
{ "function stddev" },
{ "function avg" }
}
},
{
{ "version" }, {
{ "Return the version string of the currently used DPUSER." },
{ "Syntax" },
{ "result = version()" },
{ "Arguments" },
{ "none" }
}
},
{
{ "spifficube (obsolete)" }, {
{ "Create a cube of a SPIFFI raw frame. The wavelength of each slitlet is shifted to one pixel accuracy. The wavelength scale is not being linearized." },
{ "Syntax" },
{ "result = spifficube(inframe, [HK], [K])" },
{ "Arguments" },
{ "inframe: A raw SPIFFI frame (1024 x 1024 pixels)" },
{ "Switches" },
{ "HK: The shift in wavelength scale is done for the HK grism." },
{ "K: The shift in wavelength scale is done for the K grism." },
{ "See also" },
{ "function spiffiuncube" },
{ "function spiffishift" }
}
},
{
{ "spiffiuncube (obsolete)" }, {
{ "Undo cube creation done with spifficube. The resulting frame will be 1024 x 1024 (as for spiffi raw data)." },
{ "Syntax" },
{ "result = spiffiuncube(incube, [HK], [K])" },
{ "Arguments" },
{ "incube: A SPIFFI cube created with spifficube" },
{ "Switches" },
{ "HK: The shift in wavelength scale is done for the HK grism." },
{ "K: The shift in wavelength scale is done for the K grism." },
{ "See also" },
{ "function spifficube" },
{ "function spiffishift" }
}
},
{
{ "spiffishift (obsolete)" }, {
{ "Shift slitlets of a raw SPIFFI frame so that the wavelength of each slitlet is shifted to one pixel accuracy. The wavelength scale is not being linearized." },
{ "Syntax" },
{ "result = spiffishift(inframe, [HK], [K])" },
{ "Arguments" },
{ "inframe: A raw SPIFFI frame (1024 x 1024 pixels)" },
{ "Switches" },
{ "HK: The shift in wavelength scale is done for the HK grism." },
{ "K: The shift in wavelength scale is done for the K grism." },
{ "See also" },
{ "function spifficube" },
{ "function spiffiuncube" }
}
},
{
{ "bezier (obsolete)" }, {
{ "xxx" },
{ "Syntax" },
{ "result = bezier(xxx [, xxx])" },
{ "Arguments" },
{ "xxx: xxx" },
{ "xxx: xxx" },
{ "See also" },
{ "function bezier1d" }
}
},
{
{ "bezier1d (obsolete)" }, {
{ "xxx" },
{ "Syntax" },
{ "result = bezier1d(xxx , xxx)" },
{ "Arguments" },
{ "xxx: xxx" },
{ "xxx: xxx" },
{ "See also" },
{ "function bezier" }
}
},
{
{ "moffat" }, {
{ "Create an elliptical moffat function." },
{ "Syntax" },
{ "result = moffat(x, y, power, fwhm1 [, fwhm2 [, angle]] [, naxis1=value] [, naxis2 = value])" },
{ "Arguments" },
{ "X: The center of the moffat in the x-axes" },
{ "Y: The center of the moffat in the y-axes" },
{ "power: The power index of the moffat function" },
{ "fwhm1: Full-width at half maximum of the major axes" },
{ "fwhm2: Optional, full-width at half maximum of the minor axes" },
{ "angle: Optional, position angle of the moffat" },
{ "naxis1=value: Optional, the size of the resulting array in the first dimension" },
{ "naxis2=value: Optional, the size of the resulting array in the second dimension" }
}
},
{
{ "readfitsextension" }, {
{ "Read specified FITS file extension into memory. The optional arguments x1, x2, y1, y2, z1, z2 can be used to read in a part of a FITS file. The combination 0, 0 specifies that the complete range of the respective axis should be read in." },
{ "Syntax" },
{ "result = readfitsextension(FILENAME, extension [, x1, x2 [, y1, y2 [, z1, z2]]])" },
{ "Arguments" },
{ "FILENAME: A string." },
{ "extension: Integer number specifying which extension to read." },
{ "x1, x2: Range in first dimension, defaults to 0, 0" },
{ "y1, y2: Range in second dimension, defaults to 0, 0" },
{ "z1, z2: Range in third dimension, defaults to 0, 0" },
{ "See also" },
{ "function readfits" },
{ "function readfitsall" }
}
},
{
{ "multigauss2dfit" }, {
{ "Fit a number of circular gaussians to an image. All gaussians have the save FWHM." },
{ "Syntax" },
{ "result = multigauss2dfit(image, errors, estimate [, chisq])" },
{ "Arguments" },
{ "image: The image to be fit" },
{ "errors: The errors in the image values" },
{ "estimate: Initial estimate for the fit of the form [Offset,fwhm,height_1,x_1,y_1,height_2,x_2,y_2,...,height_n,x_n,y_n]" },
{ "chisq: If set to a named variable, the variable is overwritten with the chi-squared of the fit." },
{ "Returns" },
{ "The returned vector contains the best-fit parameters in the form [Offset,fwhm,height_1,x_1,y_1,...,height_n,x_n,y_n,d_Offset,d_fwhm,d_height_1,d_x_1,d_y_1,...,d_height_n,d_x_n,d_y_n]" },
{ "See also" },
{ "function gauss2dfit" },
{ "function gauss2dsimplefit" }
}
},
{
{ "sincfit" }, {
{ "Fit a sinc function to a set of data points. The function fit is y(x)=A+B*sinc((x+phi)/width)" },
{ "Syntax" },
{ "result = sincfit(X, Y, errors, estimate [, chisq])" },
{ "Arguments" },
{ "X: A vector containing the x values to be fit" },
{ "Y: A vector containing the y values to be fit (in radians)" },
{ "errors: The errors in Y" },
{ "estimate: Initial estimate for the fit of the form [A,B,phi,width]" },
{ "chisq: If set to a named variable, the variable is overwritten with the chi-squared of the fit." },
{ "Returns" },
{ "The returned vector contains the best-fit parameters in the form [A,B,phi,width,d_A,d_B,d_phi,d_width]" }
}
},
{
{ "rebin1d" }, {
{ "Rebin a one-dimensional vector to new values." },
{ "Syntax" },
{ "result = rebin1d(spectrum, xstart, xend, xdelta [, xvalues])" },
{ "Arguments" },
{ "spectrum: A one-dimensional FITS. It should have the correct FITS keywords (CRVAL1, CRPIX1, and CDELT1) or the optional argument xvalues should be given." },
{ "xstart: The first channel in the rebinned data" },
{ "xend: The last channel in the rebinned data" },
{ "xdelta: The increment step size for the rebinned data" },
{ "xvalues: A vector of same length as spectrum with the corresponding x-values." },
{ "Returns" },
{ "The returned vector has the data rebinned with the appropritate FITS keywords set." },
{ "See also" },
{ "function interpol" }
}
},
{
{ "velmap" }, {
{ "Go through a datacube and fit a gaussian to a line. The arguments center and fwhm are used as initial estimate for the gauss-fit." },
{ "Syntax" },
{ "result = velmap(cube, center, fwhm [, threshold])" },
{ "Arguments" },
{ "cube: A datacube" },
{ "center: The approximate center (wavelength) of the line to fit" },
{ "fwhm: The approximate FWHM of the line to fit" },
{ "threshold: A lower limit under which no fit is attempted (given as percentage of peak flux)" },
{ "Returns" },
{ "A datacube with the following slices:<br>" },
{ "result[*,*,1]: fit background<br>" },
{ "result[*,*,2]: fit continuum<br>" },
{ "result[*,*,3]: fit line center<br>" },
{ "result[*,*,4]: fit line FWHM<br>" },
{ "result[*,*,5]: error in background fit<br>" },
{ "result[*,*,6]: error in continuum fit<br>" },
{ "result[*,*,7]: error in line center fit<br>" },
{ "result[*,*,8]: error in line FWHM fit<br>" },
{ "result[*,*,9]: chi squared of fit<br>" }
}
},
{
{ "fxcor" }, {
{ "Compute the cross-correlation of two spectra. The spectra will be rebinned to the lowest dispersion, continuum subtracted and normalised prior to the cross-correlation." },
{ "Syntax" },
{ "result = fxcor(template, spectrum)" },
{ "Arguments" },
{ "template: The template spectrum" },
{ "spectrum: The object spectrum" },
{ "Returns" },
{ "The cross-correlation of the two spectra" },
{ "See also" },
{ "function correlmap" }
}
},
{
{ "correlmap" }, {
{ "Compute the cross-correlation maximum of a datacube and a template spectrum." },
{ "Syntax" },
{ "result = correlmap(cube, template)" },
{ "Arguments" },
{ "cube: The datacube to be cross-correlated" },
{ "template: The template spectrum" },
{ "Returns" },
{ "A 2D-map with the maximum of the cross-correlation" },
{ "See also" },
{ "function fxcor" }
}
},
{
{ "longslit" }, {
{ "Create a pseudo-longslit from a datacube." },
{ "Syntax" },
{ "result = longslit(cube, x, y, theta, width [, opening_angle])" },
{ "Arguments" },
{ "cube: A datacube" },
{ "x: The x center for the longslit" },
{ "y: The y center for the longslit" },
{ "theta: The position angle, in degrees" },
{ "width: The width of the longslit, in pixels" },
{ "opening_angle: An opening angle of the pseudo-longslit, in degrees" },
{ "Returns" },
{ "A 2D longslit spectrum" },
{ "See also" },
{ "function twodcut" }
}
},
{
{ "evalvelmap" }, {
{ "Evaluate the result of velmap." },
{ "Syntax" },
{ "result = evalvelmap(fit, template)" },
{ "Arguments" },
{ "fit: The result of the velmap function" },
{ "template: A template cube which defines how big the resulting cube will be." },
{ "Returns" },
{ "The evaluated cube, with gaussians at the appropriate places along the third dimension." },
{ "See also" },
{ "function velmap" }
}
},
{
{ "sinfit" }, {
{ "Fit a sine curve to a set of data points. The function fit is y(x)=A+B*sin(x+phi)" },
{ "Syntax" },
{ "result = sinfit(X, Y, errors, estimate [, chisq])" },
{ "Arguments" },
{ "X: A vector containing the x values to be fit" },
{ "Y: A vector containing the y values to be fit (in radians)" },
{ "errors: The errors in Y" },
{ "estimate: Initial estimate for the fit of the form [A,B,phi]" },
{ "chisq: If set to a named variable, the variable is overwritten with the chi-squared of the fit." },
{ "Returns" },
{ "The returned vector contains the best-fit parameters in the form [A,B,phi,d_A,d_B,d_phi]" }
}
},
{
{ "indexbase" }, {
{ "Return the base index: 0 for C-notation, 1 for Fortran-notation" },
{ "Syntax" },
{ "result = indexbase()" },
{ "Arguments" },
{ "none" },
{ "Returns" },
{ "The index base" },
{ "See also" },
{ "procedure cnotation" },
{ "procedure fortrannotation" },
{ "procedure setindexbase" }
}
},
{
{ "voronoi" }, {
{ "Perform adaptive spatial binning of Integral-Field Spectroscopic (IFS) data to reach a chosen constant signal-to-noise ratio per bin. This method is required for the proper analysis of IFS observations, but can also be used for standard photometric imagery or any other two-dimensional data. Further information on VORONOI_2D_BINNING algorithm can be found in Cappellari M., Copin Y., 2003, MNRAS, 342, 345" },
{ "Syntax" },
{ "result = voronoi(signal, noise, target, targetSN [, /map])" },
{ "Arguments" },
{ "signal: A 2D map with the signal in each pixel" },
{ "noise: A 2D map specifying the noise in each pixel. Pixels with a noise value of zero will be neglected in the voronoi binning" },
{ "target: The image which should be binned (can be the same as the signal map)" },
{ "targetSN: The Signal/Noise value which should be reached" },
{ "Switches" },
{ "/map: Instead of applying the binning to an image, return a map with regions and their respective IDs" },
{ "Returns" },
{ "Either the binned image or the map of regions" },
{ "Notes" },
{ "The original IDL code was written by Michele Cappellari, Leiden Observatory, The Netherlands cappellari@strw.leidenuniv.nl. If you have found this software useful for your research, he would appreciate an acknowledgment to use of `the Voronoi 2D-binning method by Cappellari & Copin (2003)'." }
}
},
{
{ "gauss2dsimplefit" }, {
{ "Fit a two-dimensional gaussian to a rectangular grid (i.e. an image)." },
{ "Syntax" },
{ "result = gauss2dsimplefit(image, x, y, width [, chisq])" },
{ "Arguments" },
{ "image: The image to be fit" },
{ "x: The x-position of the fit center" },
{ "y: The x-position of the fit center" },
{ "width: The half-width of the fitting window" },
{ "chisq: If set to a named variable, the variable is overwritten with the chi-squared of the fit." },
{ "Returns" },
{ "The returned vector contains the best-fit parameters in the form [Offset,Max,x0,y0,fwhm1,fwhm2,angle,d_Offset,d_Max,d_x0,d_y0,d_fwhm1,d_fwhm2,d_angle]" },
{ "See also" },
{ "function gauss2dfit" },
{ "function multigauss2dfit" }
}
},
{
{ "transpoly" }, {
{ "Compute the transformation matrix for two reference coordinate systems, with errors. It is described by a second order polynomial. The number of reference sources must be >= 6. The transformation function will be calculated using a least squares fit to given coordinates. Note that if either in REFSTARS or in IMSTARS a coordinate is exactly (-1, -1), this star will not be used to calculate the transformation matrix." },
{ "Syntax" },
{ "result = transmatrix(REFSTARS, IMSTARS, ERRORS)" },
{ "Arguments" },
{ "REFSTARS: A matrix 2xm (m >= 6) with positions of the reference stars in the reference frame (= masterlist)" },
{ "IMSTARS: A matrix 2xm (same size as REFSTARS) with the positions of the same stars in the image to be transformed." },
{ "ERRORS: A matrix 2xm (same size as REFSTARS) with the errors of the positions in REFSTARS." },
{ "Returns" },
{ "A matrix 2x12 which describes the coordinate transformation matrix:" },
{ "x' = result[1,1] + result[2,1]*x + result[1,2]*y + result[2,2]*xy + result[1,3]*x^2 + result[2,3]*y^2" },
{ "y' = result[1,4] + result[2,4]*x + result[1,5]*y + result[2,5]*xy + result[1,6]*x^2 + result[2,6]*y^2<br>" },
{ "The remaining coordinates [1:2,7:12] are the errors of the respective elements of the transformation matrix." },
{ "See also" },
{ "function transcoords" },
{ "function transform" }
}
},
{
{ "strtrim" }, {
{ "Removes leading and/or trailing blank from the input String." },
{ "Syntax" },
{ "result = strtrim(str)" },
{ "Arguments" },
{ "str: A string" },
{ "Returns" },
{ "Returns a copy of the string with removed blanks." }
}
},
{
{ "right" }, {
{ "Tail of a string." },
{ "Syntax" },
{ "result = right(str, n)" },
{ "Arguments" },
{ "str: A text string" },
{ "n: An integer " },
{ "Returns" },
{ "Return the last n characters from string str." }
}
},
{
{ "ten" }, {
{ "Transforms hours:minutes:seconds into decimal notation" },
{ "Syntax" },
{ "result = ten(hh , mm, ss)" },
{ "Arguments" },
{ "hh: hours" },
{ "mm: minutes" },
{ "ss: seconds" },
{ "Returns" },
{ "A decimal value with hours as unit" },
{ "Examples" },
{ "Transform 1h, 29min, 60 sec to decimal:" },
{ "print = ten(1, 29, 60)" },
{ "      1.5" }
}
},
{
{ "primes" }, {
{ "Creates a vector of given length with prime numbers." },
{ "Syntax" },
{ "result = primes(n)" },
{ "Arguments" },
{ "n: The number of prime numbers to return" },
{ "Returns" },
{ "A vector of length n with the first n prime numbers." }
}
},
{
{ "twodcut" }, {
{ "Create a 2D-cut from an image." },
{ "Syntax" },
{ "result = twodcut(image, x, y, theta, width)" },
{ "Arguments" },
{ "image: An image" },
{ "x: The x center for the 2D-cut" },
{ "y: The y center for the 2D-cut" },
{ "theta: The position angle, in degrees" },
{ "width: The width of the cut, in pixels" },
{ "Returns" },
{ "A 1D spectrum" },
{ "See also" },
{ "function longslit" }
}
},
{
{ "simplifywhitespace" }, {
{ "Strip all whitespaces at the beginning and the end, and replace all multiple occurrences of whitespaces by one single space." },
{ "Syntax" },
{ "result = simplifywhitespace(s)" },
{ "Arguments" },
{ "s: The string to be simplified" }
}
},
{
{ "strsplit" }, {
{ "Split a string into a string array" },
{ "Syntax" },
{ "result = strsplit(s [, delimiter])" },
{ "Arguments" },
{ "s: The string to be split" },
{ "delimiter: A single character at which to split (defaults to ' ')" }
}
},
{
{ "sersic2dfit" }, {
{ "Fit a two-dimensional sersic function to a rectangular grid (i.e. an image).<br>" },
{ "The 2D sersic function is defined as I(x,y) = c + Ie * exp(-bn * (R/Re)^(1/n) - 1).<br>" },
{ "R is an elliptical equation: R = sqrt(xp^2 + (yp / q)^2).<br>" },
{ "xp and yp describe a rotation: xp = (x - x0) * cos(angle) + (y - y0) * sin(angle), yp = - (x - x0) * sin(angle) + (y - y0) * cos(angle) and bn = 1.9992 * n - 0.3271" },
{ "Syntax" },
{ "result = sersic2dfit(image, errors, estimate [, chisq])" },
{ "Arguments" },
{ "image: The image to be fit" },
{ "errors: The errors in the image values" },
{ "estimate: Initial estimate for the fit of the form [c, Ie, Re, x0, y0, angle, q, n]. If n is provided with a negative sign, it won't be fitted and assumed as fixed (with positive sign, of course)." },
{ "chisq: If set to a named variable, the variable is overwritten with the chi-squared of the fit." },
{ "Returns" },
{ "The returned vector contains the best-fit parameters in the form [c, Ie, Re, x0, y0, angle, q, n] or [c, Ie, Re, x0, y0, angle, q] if n was kept fixed." },
{ "See also" },
{ "function sersic2dsimplefit" }
}
},
{
{ "sersic2dsimplefit" }, {
{ "Fit a two-dimensional sersic function to a rectangular grid (i.e. an image) without any given estimates.<br>" },
{ "The 2D sersic function is defined as I(x,y) = c + Ie * exp(-bn * (R/Re)^(1/n) - 1).<br>" },
{ "R is an elliptical equation: R = sqrt(xp^2 + (yp / q)^2).<br>" },
{ "xp and yp describe a rotation: xp = (x - x0) * cos(angle) + (y - y0) * sin(angle), yp = - (x - x0) * sin(angle) + (y - y0) * cos(angle) and bn = 1.9992 * n - 0.3271." },
{ "Syntax" },
{ "result = sersic2dsimplefit(image, x_cen, y_cen, width [, chisq [, n]])" },
{ "Arguments" },
{ "image: The image to be fit" },
{ "x_cen: The x-position of the fit center" },
{ "y_cen: The x-position of the fit center" },
{ "width: The half-width of the fitting window" },
{ "chisq: If set to a named variable, the variable is overwritten with the chi-squared of the fit." },
{ "n: If n should be fixed and not fitted." },
{ "Returns" },
{ "The returned vector contains the best-fit parameters in the form [c, Ie, Re, x0, y0, angle, q, n] or [c, Ie, Re, x0, y0, angle, q] if n was kept fixed. Angle is in degrees. When the negative reciprocal value in q is returned, then the angle is also increased by 90 degrees." },
{ "See also" },
{ "function sersic2dfit" }
}
},
{
{ "sersicfit" }, {
{ "Fit a one-dimensional sersic function to a vector. The sersic function is defined as y(x) = c + Ie * exp(-bn * (x/Re)^(1/n) - 1), with bn = 1.9992 * n - 0.3271." },
{ "Syntax" },
{ "result = sersicfit(X, Y, errors, estimates [, chisq])" },
{ "Arguments" },
{ "X: A vector containing the x values to be fit" },
{ "Y: A vector containing the y values to be fit" },
{ "errors: The errors in Y" },
{ "estimate: Initial estimate for the fit of the form [c, Ie, Re, n]. If n is provided with a negative sign, it won't be fitted and assumed as fixed (with positive sign, of course)." },
{ "chisq: If set to a named variable, the variable is overwritten with the chi-squared of the fit." },
{ "Returns" },
{ "The returned vector contains the best-fit parameters in the form [c, Ie, Re, n] or [c, Ie, Re] if n was kept fixed. When the negative reciprocal value in q is returned, then the angle is also increased by 90 degrees." }
}
},
{
{ "sersic2d" }, {
{ "Creates a 2D sersic. The sersic function is defined as y(x) = exp(-bn * (x/Re)^(1/n) - 1), with bn = 1.9992 * n - 0.3271." },
{ "Syntax" },
{ "result = sersic2d(c, x0, y0, angle, q, n [, naxis1=value] [, naxis2 = value])" },
{ "Arguments" },
{ "Re: Effective radius that encloses half of the total light" },
{ "x0: x-position of center" },
{ "y0: y-position of center" },
{ "angle: angle in degrees" },
{ "q: diskiness" },
{ "n: shape of light model (0.5 = gaussian, 1 = exponential, 4 = de Vaucouleurs)" },
{ "Examples" },
{ "result = sersic2d(10,80,70,870,-2,1, naxis1=128, naxis2=128)" }
}
},
{
{ "randomg" }, {
{ "Returns a random number drawn from a Gaussian distribution centered on 0 with width SIGMA. If no SEED is given, a seed based on the current time is used." },
{ "Syntax" },
{ "result = randomg(SIGMA [, SEED])" },
{ "Arguments" },
{ "SIGMA: Width of the Gaussian profile from which the number is drawn (real number)." },
{ "SEED: Seed of the random number algorithm (integer number)." },
{ "Returns" },
{ "A random number" },
{ "See also" },
{ "function random" }
}
},
{
{ "poly" }, {
{ "Create a polynomial" },
{ "Syntax" },
{ "result = poly(x, c)" },
{ "Arguments" },
{ "x: An array or real number" },
{ "c: The coefficients of the polynomial" },
{ "Returns" },
{ "The polynomial of form c[1] + c[2]*x + c[3]*x^2 + ..." }
}
},
{
{ "polyfit2d" }, {
{ "Returns a 2D N-th order polynomial fit to X. X must be 2-dimensional. The function returns a vector of size sum(i+1)*2 (for i=0 to N). The fittet polynomial has the following form:" },
{ "for N=3: f(x,y) = a0 + a1*x + a2*y + a3*x^2 + a4*x*y + a5*y^2 + a6*x^3 + a7*x^2*y + a8*x*y^2 + a9*y^3" },
{ "The values a0, ..., a9 are returned in the first 10 elements of the returned vector, their respective errors in the elements 11...20." },
{ "Syntax" },
{ "result = polyfit2d(X, N [, CHISQ])" },
{ "Arguments" },
{ "X: A vector." },
{ "N: An integer number." },
{ "CHISQ: If set to a named variable, the variable is overwritten with the chi-squared of the fit." },
{ "See also" },
{ "function polyfit" },
{ "function polyfitxy" },
{ "function polyfitxyerr" },
{ "function polyfit2derr" }
}
},
{
{ "polyfit2derr" }, {
{ "Returns a 2D N-th order polynomial fit to X. X must be 2-dimensional. The function returns a vector of size sum(i+1)*2 (for i=0 to N). The fittet polynomial has the following form:" },
{ "for N=3: f(x,y) = a0 + a1*x + a2*y + a3*x^2 + a4*x*y + a5*y^2 + a6*x^3 + a7*x^2*y + a8*x*y^2 + a9*y^3" },
{ "The values a0, ..., a9 are returned in the first 10 elements of the returned vector, their respective errors in the elements 11...20." },
{ "Syntax" },
{ "result = polyfit2d(X, N, ERROR [, CHISQ])" },
{ "Arguments" },
{ "X: A vector." },
{ "N: An integer number." },
{ "ERROR: The error of the X-values. If this is a real number, all X-values are assumed to have the same error. If ERROR is a vector, it must have the same length as X and gives the error or each individual X value." },
{ "CHISQ: If set to a named variable, the variable is overwritten with the chi-squared of the fit." },
{ "See also" },
{ "function polyfit" },
{ "function polyfitxy" },
{ "function polyfitxyerr" },
{ "function polyfit2derr" }
}
},
{
{ "getbitpix" }, {
{ "Get the pixel type of X." },
{ "Syntax" },
{ "result = getbitpix(X)" },
{ "Arguments" },
{ "X: The array whose pixel type is to be output" },
{ "Returns" },
{ "-128: Complex (note that this does not conform to FITS standard)<br>" },
{ "-64: Floating point, double precision<br>" },
{ "-32: Floating point, single precision<br>" },
{ "8: Unsigned char<br>" },
{ "16: Short<br>" },
{ "32: Long" },
{ "64: Long Long" },
{ "See also" },
{ "function setbitpix" }
}
},
{
{ "isnan" }, {
{ "Returns a non-zero value if value is 'not-a-number' (NaN), and 0 otherwise." },
{ "Syntax" },
{ "result = isnan(a)" },
{ "Arguments" },
{ "a: The value to check" },
{ "See also" },
{ "function isinf" }
}
},
{
{ "isinf" }, {
{ "Returns -1 if value represents negative infinity, 1 if value represents positive infinity, and 0 otherwise." },
{ "If the value is complex and 'inf + -inf i' or '-inf + inf i' then -0.5 will be returned." },
{ "Syntax" },
{ "result = isinf(a)" },
{ "Arguments" },
{ "a: The value to check" },
{ "See also" },
{ "function isnan" }
}
},
{
{ "evalgaussfit" }, {
{ "Evaluate a gaussfit along a vector of x values." },
{ "Syntax" },
{ "result = evalgaussfit(X, fit)" },
{ "Arguments" },
{ "X: A vector of x values at which to evaluate the gaussian fit" },
{ "fit: The gaussian fit, as returned by the gaussfit function" },
{ "Returns" },
{ "A vectors, same length as X, with the gaussian evaluated at the X positions supplied." },
{ "See also" },
{ "function gaussfit" }
}
},
{
{ "polyroots" }, {
{ "Return the roots of a polynomial. The polynomial is defined as P(x) = P[1] + P[2]*x + P[3]*x^2 + ... + P[n]*x^(n-1)" },
{ "Syntax" },
{ "result = polyroots(P [, derivative])" },
{ "Arguments" },
{ "P: The polynomial" },
{ "derivative: Optional, if an integer number is given, the nth derivative is returned." },
{ "Returns" },
{ "A vector with the roots (or derivatives of) the polynomial" },
{ "Examples" },
{ "Calculate the roots of the polynomias 1 + x^2 = 0:" },
{ "print polyroots([1, 0, 1]), /values" }
}
},
{
{ "interpolate" }, {
{ "Returns the interpolated value of a given position (x,y). If x and y are integers the value at that position is returned without any interpolation." },
{ "Syntax" },
{ "result = interpolate(A, x, y [, kernel_size])" },
{ "Arguments" },
{ "A: A 2D-image." },
{ "x: An real number." },
{ "x: An real number." },
{ "kernel_size: Any integer number, default is 4. Remember that points near the image border can't be interpolated (border-size is half the kernel-size)" }
}
},
{
{ "radialprofile" }, {
{ "Returns a radial profile centered on (x,y)" },
{ "Syntax" },
{ "result = radialprofile(A, x, y)" },
{ "Arguments" },
{ "A: A 2D-image" },
{ "x: An integer number, the x center of the profile" },
{ "y: An integer number, the y center of the profile" },
{ "See also" },
{ "function ellipticalprofile" }
}
},
{
{ "ellipticalprofile" }, {
{ "Returns an elliptical profile centered on (x,y) with position angle a, aspect ratio r, and width w." },
{ "Syntax" },
{ "result = radialprofile(A, x, y, a, r, w)" },
{ "Arguments" },
{ "A: A 2D-image" },
{ "x: An integer number, the x center of the profile" },
{ "y: An integer number, the y center of the profile" },
{ "a: A real number denoting the angle of the ellipse" },
{ "r: A real number denoting the aspect ratio of the ellipse" },
{ "w: An integer number giving the width of single elements of the ellipse" },
{ "See also" },
{ "function radialprofile" }
}
},
{
{ "multigaussfit" }, {
{ "Fit multiple gaussians to a vector. The gauss function is defined as G(x) = SUM_i [A_i + B_i*exp(-4ln2*(x-x0_i)^2/fwhm_i^2)]." },
{ "Syntax" },
{ "result = multigaussfit(X, Y, errors, estimate [, chisq])" },
{ "Arguments" },
{ "X: A vector containing the x values to be fit" },
{ "Y: A vector containing the y values to be fit" },
{ "errors: The errors in Y" },
{ "estimate: Initial estimate for the fit of the form [A, B, x0, fwhm]" },
{ "chisq: If set to a named variable, the variable is overwritten with the chi-squared of the fit." },
{ "Returns" },
{ "The returned vector contains the best-fit parameters in the form [A1, B1, x01, fwhm1, A2, ..., d_A1, d_B1, d_x01, d_fwhm1, d_A2, ...]" },
{ "See also" },
{ "function gaussfit" }
}
},
{
{ "readfitsall" }, {
{ "Read a FITS file and all its extensions. The FITS will be stored in a variable to type dpuserTypeList." },
{ "Syntax" },
{ "result = readfitsall(filename)" },
{ "Arguments" },
{ "filename: A string pointing to the file to be read" },
{ "See also" },
{ "function readfits" },
{ "function readfitsextension" }
}
},
{
{ "cubequantile" }, {
{ "Does a quantile of all images in X." },
{ "Syntax" },
{ "result = cubequantile(X, quantile)" },
{ "Arguments" },
{ "X: A matrix or a FITS file name. If a FITS file name is given, the global variable tmpmem determines how many bytes of data are read in at a time." },
{ "quantile: The quantile to be returned (0...1)." },
{ "See also" },
{ "function cubemedian" }
}
},
{
{ "quantile" }, {
{ "Compute the quantile of X." },
{ "Syntax" },
{ "result = quantile(X, quantile)" },
{ "Arguments" },
{ "X: A matrix." },
{ "quantile: The quantile to be returned (0...1)." },
{ "See also" },
{ "function median" }
}
},
{
{ "sersic2dsmoothfit" }, {
{ "Fit a two-dimensional smoothed sersic function to a rectangular grid (i.e. an image).<br>" },
{ "The 2D sersic function is defined as I(x,y) = c + Ie * exp(-bn * (R/Re)^(1/n) - 1).<br>" },
{ "R is an elliptical equation: R = sqrt(xp^2 + (yp / q)^2).<br>" },
{ "xp and yp describe a rotation: xp = (x - x0) * cos(angle) + (y - y0) * sin(angle), yp = - (x - x0) * sin(angle) + (y - y0) * cos(angle) and bn = 1.9992 * n - 0.3271<br>" },
{ "The resulting 2D sersic function is then smoothed by convolving with a gaussian with a FWHM given by the smooth parameter." },
{ "Syntax" },
{ "result = sersic2dsmoothfit(image, errors, smooth, estimate [, chisq])" },
{ "Arguments" },
{ "image: The image to be fit" },
{ "errors: The errors in the image values" },
{ "smooth: The FWHM for the gaussian smoothing" },
{ "estimate: Initial estimate for the fit of the form [c, Ie, Re, x0, y0, angle, q, n]. If n is provided with a negative sign, it won't be fitted and assumed as fixed (with positive sign, of course)." },
{ "chisq: If set to a named variable, the variable is overwritten with the chi-squared of the fit." },
{ "Returns" },
{ "The returned vector contains the best-fit parameters in the form [c, Ie, Re, x0, y0, angle, q, n] or [c, Ie, Re, x0, y0, angle, q] if n was kept fixed." },
{ "See also" },
{ "function sersic2dfit" },
{ "function sersic2dsmoothsimplefit" }
}
},
{
{ "sersic2dsmoothsimplefit" }, {
{ "Fit a two-dimensional smoothed sersic function to a rectangular grid (i.e. an image).<br>" },
{ "The 2D sersic function is defined as I(x,y) = c + Ie * exp(-bn * (R/Re)^(1/n) - 1).<br>" },
{ "R is an elliptical equation: R = sqrt(xp^2 + (yp / q)^2).<br>" },
{ "xp and yp describe a rotation: xp = (x - x0) * cos(angle) + (y - y0) * sin(angle), yp = - (x - x0) * sin(angle) + (y - y0) * cos(angle) and bn = 1.9992 * n - 0.3271<br>" },
{ "The resulting 2D sersic function is then smoothed by convolving with a gaussian with a FWHM given by the smooth parameter." },
{ "Syntax" },
{ "result = sersic2dsmoothsimplefit(image, errors, x0, y0, width, smooth [, chisq])" },
{ "Arguments" },
{ "image: The image to be fit" },
{ "errors: The errors in the image values" },
{ "x0, y0: The center coordinates of the window to fit" },
{ "width: The width of the window to fit" },
{ "smooth: The FWHM for the gaussian smoothing" },
{ "chisq: If set to a named variable, the variable is overwritten with the chi-squared of the fit." },
{ "Returns" },
{ "The returned vector contains the best-fit parameters in the form [c, Ie, Re, x0, y0, angle, q, n] or [c, Ie, Re, x0, y0, angle, q] if n was kept fixed." },
{ "See also" },
{ "function sersic2dfit" },
{ "function sersic2dsmoothfit" }
}
},
{
{ "readfitsbintable" }, {
{ "Read a FITS binary table from disk file" },
{ "Syntax" },
{ "result = readfitsbintable(file, extension, column)" },
{ "Arguments" },
{ "file: The FITS file to be read" },
{ "extension: Which extension to read, either an integer number >= 1, or a string with the EXTNAME" },
{ "column: Which column to read, either an integer number >= 1, or a string with the Column Name" },
{ "Returns" },
{ "The column of the specified FITS binary table" }
}
},
{
{ "listfitsextensions" }, {
{ "List extension names of all extensions in a FITS file" },
{ "Syntax" },
{ "result = listfitsextensions(fname)" },
{ "Arguments" },
{ "fname: A string containing the FITS file name" },
{ "Returns" },
{ "A string array with all FITS extension names" }
}
},
{
{ "listtablecolumns" }, {
{ "List FITS binary table column names of specified extension in a FITS file" },
{ "Syntax" },
{ "result = listtablecolumns(fname, extension)" },
{ "Arguments" },
{ "fname: A string containing the FITS file name" },
{ "extension: Which extension to read, either an integer number >= 1, or a string with the EXTNAME" },
{ "Returns" },
{ "A string array with all FITS binary table column names" }
}
},
{
{ "interpol" }, {
{ "1D cubic spline interpolation." },
{ "Syntax" },
{ "result = interpol(y, x, x_new)" },
{ "Arguments" },
{ "y: The given y-values as array." },
{ "x: The given x-values as array. The arrays x and y must be of same length." },
{ "x_new: The new x-values as array." },
{ "Returns" },
{ "The new y-values at given points in x_new." },
{ "See also" },
{ "function rebin1d" }
}
},
{
{ "where" }, {
{ "Create a one-dimensional array of indices which satisfy a given expression." },
{ "Syntax" },
{ "result = where(array comparison scalar)" },
{ "Arguments" },
{ "array: An array of any dimension that is to be evaluated" },
{ "comparison: Any of the known comparison operators (==, !=, >, >=, <, <=)" },
{ "scalar: A scalar value" },
{ "Returns" },
{ "A one-dimensional vector of the indices in array which satisfied the comparison" },
{ "Examples" },
{ "Create a sine curve and set all negative values to 0:" },
{ "sine = sin([0:1000]/100)" },
{ "sine[where(sine < 0)] = 0" }
}
},
{
{ "list" }, {
{ "Create a FITS list" },
{ "Syntax" },
{ "result = list(arg1, ..., arg10)" },
{ "Arguments" },
{ "arg1...arg10: Up to 10 FITS or StringArray to be included in the list" },
{ "Returns" },
{ "A FITS list with copies of the given arguments" }
}
},
{
{ "straightlinefit" }, {
{ "Fit a straight line to data with errors in both coordinates" },
{ "Syntax" },
{ "result = straightlinefit(x, y, dx, dy [, chisq])" },
{ "Arguments" },
{ "x: the x values of the data to fit" },
{ "y: the y values of the data to fit" },
{ "dx: the errors in x" },
{ "dy: the errors in y" },
{ "chisq: If set to a named variable, the variable is overwritten with the chi-squared of the fit." },
{ "Returns" },
{ "The returned vector contains the best-fit parameters" }
}
},
{
{ "mpfit" }, {
{ "Fit a given function to data using MPFIT" },
{ "Syntax" },
{ "result = mpfit(x, y, err, estimate, function)" },
{ "Arguments" },
{ "x: The x-Values of the data" },
{ "y: the y-Values of the data" },
{ "err: The errors in y" },
{ "estimate: Initial estimate of the fit paramters" },
{ "function: A string describing the function to be fit" },
{ "Returns" },
{ "The best-fit parameters" }
}
},
{
{ "evalmpfit" }, {
{ "Evaluate a function at specified x values" },
{ "Syntax" },
{ "result = evalmpfit(x, parameters, function)" },
{ "Arguments" },
{ "x: The x-Values where to evaluate" },
{ "parameters: The parameters of the function to be evaluated" },
{ "function: A string describing the function to be evaluated" },
{ "Returns" },
{ "A vector of same length as x with the function evaluated" },
{ "Examples" },
{ "y = evalmpfit(([1:100]-50)/10, [2.3,.2,.1], \"a+b*x+c*x*x\")" }
}
},
{
{ "question" }, {
{ "Output a string (or pop up a dialog box on QFitsView) and expect Yes/No answer." },
{ "Syntax" },
{ "result = question(s)" },
{ "Arguments" },
{ "s: The string to output" },
{ "Returns" },
{ "If the answer starts with n or N, zero is returned. One otherwise." }
}
},
{
{ "nparams" }, {
{ "Return the number of parameters passed to a user defined function or procedure" },
{ "Syntax" },
{ "result = nparams()" },
{ "Examples" },
{ "Define a user written function that adds up a variable amount of values:" },
{ "function add,a,b,c {" },
{ "add = a" },
{ "if (nparams() > 1) add += b" },
{ "if (nparams() > 2) add += c" },
{ "}" },
{ "</code>" }
}
},
{
{ "double" }, {
{ "Return a value cast to double" },
{ "Syntax" },
{ "result = double(x)" },
{ "Arguments" },
{ "x: If of any numeric type, cast to double. If a complex number, the real part. If a string, interpreted as number. If a matrix, set the type to R8." }
}
},
{
{ "pyvar" }, {
{ "Copy a PYTHON variable to DPUSER" },
{ "Syntax" },
{ "result = pyvar(variable)" },
{ "Arguments" },
{ "variable: A string naming the PYTHON variable" },
{ "Returns" },
{ "A deep copy of the PYTHON variable" },
{ "Examples" },
{ "Create a variable within the PYTHON module, and then pass this back to DPUSER:" },
{ "python \"a=1\"" },
{ "hhh = pyvar(\"a\")" }
}
},
{
{ "mjd" }, {
{ "Returns the Modified Julian Date of given date. Hour, minute, and second default to 0." },
{ "Syntax" },
{ "result = mjd(day, month, year [, hour [, minute [,second]]])" },
{ "Arguments" },
{ "day: An integer number." },
{ "month: An integer number. " },
{ "year: An integer number." },
{ "hour: An integer number." },
{ "minute: An integer number." },
{ "second: A real number." },
{ "See also" },
{ "function jd" }
}
}
};

std::map<std::string, std::vector<std::string> > procedureHelp = {
{
{ "pgarro" }, {
{ "draw an arrow" },
{ "Syntax" },
{ "      SUBROUTINE PGARRO (X1, Y1, X2, Y2)" },
{ "      REAL X1, Y1, X2, Y2" },
{ "" },
{ "Draw an arrow from the point with world-coordinates (X1,Y1) to " },
{ "(X2,Y2). The size of the arrowhead at (X2,Y2) is determined by " },
{ "the current character size set by routine PGSCH. The default size " },
{ "is 1/40th of the smaller of the width or height of the view surface." },
{ "The appearance of the arrowhead (shape and solid or open) is" },
{ "controlled by routine PGSAH." },
{ "" },
{ "Arguments:" },
{ " X1, Y1 (input)  : world coordinates of the tail of the arrow." },
{ " X2, Y2 (input)  : world coordinates of the head of the arrow." },
{ "" },
{ "" }
}
},
{
{ "pgask" }, {
{ "control new page prompting" },
{ "Syntax" },
{ "      SUBROUTINE PGASK (FLAG)" },
{ "      LOGICAL FLAG" },
{ "" },
{ "Change the ``prompt state'' of PGPLOT. If the prompt state is" },
{ "ON, PGPAGE will type ``Type RETURN for next page:'' and will wait" },
{ "for the user to type a carriage-return before starting a new page." },
{ "The initial prompt state (after the device has been opened) is ON" },
{ "for interactive devices. Prompt state is always OFF for" },
{ "non-interactive devices." },
{ "" },
{ "Arguments:" },
{ " FLAG   (input)  : if .TRUE., and if the device is an interactive" },
{ "                   device, the prompt state will be set to ON. If" },
{ "                   .FALSE., the prompt state will be set to OFF." },
{ "" },
{ "" }
}
},
{
{ "pgaxis" }, {
{ "draw an axis" },
{ "Syntax" },
{ "      SUBROUTINE PGAXIS (OPT, X1, Y1, X2, Y2, V1, V2, STEP, NSUB," },
{ "     :                   DMAJL, DMAJR, FMIN, DISP, ORIENT)" },
{ "      CHARACTER*(*) OPT" },
{ "      REAL X1, Y1, X2, Y2, V1, V2, STEP, DMAJL, DMAJR, FMIN, DISP" },
{ "      REAL ORIENT" },
{ "      INTEGER NSUB" },
{ "" },
{ "Draw a labelled graph axis from world-coordinate position (X1,Y1) to" },
{ "(X2,Y2)." },
{ "" },
{ "Normally, this routine draws a standard LINEAR axis with equal" },
{ "subdivisions.   The quantity described by the axis runs from V1 to V2;" },
{ "this may be, but need not be, the same as X or Y. " },
{ "" },
{ "If the 'L' option is specified, the routine draws a LOGARITHMIC axis." },
{ "In this case, the quantity described by the axis runs from 10**V1 to" },
{ "10**V2. A logarithmic axis always has major, labeled, tick marks " },
{ "spaced by one or more decades. If the major tick marks are spaced" },
{ "by one decade (as specified by the STEP argument), then minor" },
{ "tick marks are placed at 2, 3, .., 9 times each power of 10;" },
{ "otherwise minor tick marks are spaced by one decade. If the axis" },
{ "spans less than two decades, numeric labels are placed at 1, 2, and" },
{ "5 times each power of ten." },
{ "" },
{ "If the axis spans less than one decade, or if it spans many decades," },
{ "it is preferable to use a linear axis labeled with the logarithm of" },
{ "the quantity of interest." },
{ "" },
{ "Arguments:" },
{ " OPT    (input)  : a string containing single-letter codes for" },
{ "                   various options. The options currently" },
{ "                   recognized are:" },
{ "                   L : draw a logarithmic axis" },
{ "                   N : write numeric labels" },
{ "                   1 : force decimal labelling, instead of automatic" },
{ "                       choice (see PGNUMB)." },
{ "                   2 : force exponential labelling, instead of" },
{ "                       automatic." },
{ " X1, Y1 (input)  : world coordinates of one endpoint of the axis." },
{ " X2, Y2 (input)  : world coordinates of the other endpoint of the axis." },
{ " V1     (input)  : axis value at first endpoint." },
{ " V2     (input)  : axis value at second endpoint." },
{ " STEP   (input)  : major tick marks are drawn at axis value 0.0 plus" },
{ "                   or minus integer multiples of STEP. If STEP=0.0," },
{ "                   a value is chosen automatically." },
{ " NSUB   (input)  : minor tick marks are drawn to divide the major" },
{ "                   divisions into NSUB equal subdivisions (ignored if" },
{ "                   STEP=0.0). If NSUB &lt;= 1, no minor tick marks are" },
{ "                   drawn. NSUB is ignored for a logarithmic axis." },
{ " DMAJL  (input)  : length of major tick marks drawn to left of axis" },
{ "                   (as seen looking from first endpoint to second), in" },
{ "                   units of the character height." },
{ " DMAJR  (input)  : length of major tick marks drawn to right of axis," },
{ "                   in units of the character height." },
{ " FMIN   (input)  : length of minor tick marks, as fraction of major." },
{ " DISP   (input)  : displacement of baseline of tick labels to" },
{ "                   right of axis, in units of the character height." },
{ " ORIENT (input)  : orientation of label text, in degrees; angle between" },
{ "                   baseline of text and direction of axis (0-360)." },
{ "" },
{ "" }
}
},
{
{ "pgbbuf" }, {
{ "begin batch of output (buffer)" },
{ "Syntax" },
{ "      SUBROUTINE PGBBUF" },
{ "" },
{ "Begin saving graphical output commands in an internal buffer; the" },
{ "commands are held until a matching PGEBUF call (or until the buffer" },
{ "is emptied by PGUPDT). This can greatly improve the efficiency of" },
{ "PGPLOT.  PGBBUF increments an internal counter, while PGEBUF" },
{ "decrements this counter and flushes the buffer to the output" },
{ "device when the counter drops to zero.  PGBBUF and PGEBUF calls" },
{ "should always be paired." },
{ "" },
{ "Arguments: none" },
{ "" },
{ "" }
}
},
{
{ "pgbin" }, {
{ "histogram of binned data" },
{ "Syntax" },
{ "      SUBROUTINE PGBIN (NBIN, X, DATA, CENTER)" },
{ "      INTEGER NBIN" },
{ "      REAL X(*), DATA(*)" },
{ "      LOGICAL CENTER" },
{ "" },
{ "Plot a histogram of NBIN values with X(1..NBIN) values along" },
{ "the ordinate, and DATA(1...NBIN) along the abscissa. Bin width is" },
{ "spacing between X values." },
{ "" },
{ "Arguments:" },
{ " NBIN   (input)  : number of values." },
{ " X      (input)  : abscissae of bins." },
{ " DATA   (input)  : data values of bins." },
{ " CENTER (input)  : if .TRUE., the X values denote the center of the" },
{ "                   bin; if .FALSE., the X values denote the lower" },
{ "                   edge (in X) of the bin." },
{ "" },
{ "" }
}
},
{
{ "pgbox" }, {
{ "draw labeled frame around viewport" },
{ "Syntax" },
{ "      SUBROUTINE PGBOX (XOPT, XTICK, NXSUB, YOPT, YTICK, NYSUB)" },
{ "      CHARACTER*(*) XOPT, YOPT" },
{ "      REAL XTICK, YTICK" },
{ "      INTEGER NXSUB, NYSUB" },
{ "" },
{ "Annotate the viewport with frame, axes, numeric labels, etc." },
{ "PGBOX is called by on the user's behalf by PGENV, but may also be" },
{ "called explicitly." },
{ "" },
{ "Arguments:" },
{ " XOPT   (input)  : string of options for X (horizontal) axis of" },
{ "                   plot. Options are single letters, and may be in" },
{ "                   any order (see below)." },
{ " XTICK  (input)  : world coordinate interval between major tick marks" },
{ "                   on X axis. If XTICK=0.0, the interval is chosen by" },
{ "                   PGBOX, so that there will be at least 3 major tick" },
{ "                   marks along the axis." },
{ " NXSUB  (input)  : the number of subintervals to divide the major" },
{ "                   coordinate interval into. If XTICK=0.0 or NXSUB=0," },
{ "                   the number is chosen by PGBOX." },
{ " YOPT   (input)  : string of options for Y (vertical) axis of plot." },
{ "                   Coding is the same as for XOPT." },
{ " YTICK  (input)  : like XTICK for the Y axis." },
{ " NYSUB  (input)  : like NXSUB for the Y axis." },
{ "" },
{ "Options (for parameters XOPT and YOPT):" },
{ " A : draw Axis (X axis is horizontal line Y=0, Y axis is vertical" },
{ "     line X=0)." },
{ " B : draw bottom (X) or left (Y) edge of frame." },
{ " C : draw top (X) or right (Y) edge of frame." },
{ " G : draw Grid of vertical (X) or horizontal (Y) lines." },
{ " I : Invert the tick marks; ie draw them outside the viewport" },
{ "     instead of inside." },
{ " L : label axis Logarithmically (see below)." },
{ " N : write Numeric labels in the conventional location below the" },
{ "     viewport (X) or to the left of the viewport (Y)." },
{ " P : extend (\"Project\") major tick marks outside the box (ignored if" },
{ "     option I is specified)." },
{ " M : write numeric labels in the unconventional location above the" },
{ "     viewport (X) or to the right of the viewport (Y)." },
{ " T : draw major Tick marks at the major coordinate interval." },
{ " S : draw minor tick marks (Subticks)." },
{ " V : orient numeric labels Vertically. This is only applicable to Y." },
{ "     The default is to write Y-labels parallel to the axis." },
{ " 1 : force decimal labelling, instead of automatic choice (see PGNUMB)." },
{ " 2 : force exponential labelling, instead of automatic." },
{ "" },
{ "To get a complete frame, specify BC in both XOPT and YOPT." },
{ "Tick marks, if requested, are drawn on the axes or frame" },
{ "or both, depending which are requested. If none of ABC is specified," },
{ "tick marks will not be drawn. When PGENV calls PGBOX, it sets both" },
{ "XOPT and YOPT according to the value of its parameter AXIS:" },
{ "-1: 'BC', 0: 'BCNST', 1: 'ABCNST', 2: 'ABCGNST'." },
{ "" },
{ "For a logarithmic axis, the major tick interval is always 1.0. The" },
{ "numeric label is 10**(x) where x is the world coordinate at the" },
{ "tick mark. If subticks are requested, 8 subticks are drawn between" },
{ "each major tick at equal logarithmic intervals." },
{ "" },
{ "To label an axis with time (days, hours, minutes, seconds) or" },
{ "angle (degrees, arcmin, arcsec), use routine PGTBOX." },
{ "" },
{ "" }
}
},
{
{ "pgcirc" }, {
{ "draw a circle, using fill-area attributes" },
{ "Syntax" },
{ "      SUBROUTINE PGCIRC (XCENT, YCENT, RADIUS)" },
{ "      REAL XCENT, YCENT, RADIUS" },
{ "" },
{ "Draw a circle. The action of this routine depends" },
{ "on the setting of the Fill-Area Style attribute. If Fill-Area Style" },
{ "is SOLID (the default), the interior of the circle is solid-filled" },
{ "using the current Color Index. If Fill-Area Style is HOLLOW, the" },
{ "outline of the circle is drawn using the current line attributes" },
{ "(color index, line-style, and line-width)." },
{ "" },
{ "Arguments:" },
{ " XCENT  (input)  : world x-coordinate of the center of the circle." },
{ " YCENT  (input)  : world y-coordinate of the center of the circle." },
{ " RADIUS (input)  : radius of circle (world coordinates)." },
{ "" },
{ "" }
}
},
{
{ "pgclos" }, {
{ "close the selected graphics device" },
{ "Syntax" },
{ "      SUBROUTINE PGCLOS" },
{ "" },
{ "Close the currently selected graphics device. After the device has" },
{ "been closed, either another open device must be selected with PGSLCT" },
{ "or another device must be opened with PGOPEN before any further" },
{ "plotting can be done. If the call to PGCLOS is omitted, some or all " },
{ "of the plot may be lost." },
{ "" },
{ "[This routine was added to PGPLOT in Version 5.1.0. Older programs" },
{ "use PGEND instead.]" },
{ "" },
{ "Arguments: none" },
{ "" },
{ "" }
}
},
{
{ "pgconb" }, {
{ "contour map of a 2D data array, with blanking" },
{ "Syntax" },
{ "      SUBROUTINE PGCONB (A, IDIM, JDIM, I1, I2, J1, J2, C, NC, TR, " },
{ "     1                   BLANK)" },
{ "      INTEGER IDIM, JDIM, I1, I2, J1, J2, NC" },
{ "      REAL    A(IDIM,JDIM), C(*), TR(6), BLANK" },
{ "" },
{ "Draw a contour map of an array. This routine is the same as PGCONS," },
{ "except that array elements that have the \"magic value\" defined by" },
{ "argument BLANK are ignored, making gaps in the contour map. The" },
{ "routine may be useful for data measured on most but not all of the" },
{ "points of a grid." },
{ "" },
{ "Arguments:" },
{ " A      (input)  : data array." },
{ " IDIM   (input)  : first dimension of A." },
{ " JDIM   (input)  : second dimension of A." },
{ " I1,I2  (input)  : range of first index to be contoured (inclusive)." },
{ " J1,J2  (input)  : range of second index to be contoured (inclusive)." },
{ " C      (input)  : array of contour levels (in the same units as the" },
{ "                   data in array A); dimension at least NC." },
{ " NC     (input)  : number of contour levels (less than or equal to" },
{ "                   dimension of C). The absolute value of this" },
{ "                   argument is used (for compatibility with PGCONT," },
{ "                   where the sign of NC is significant)." },
{ " TR     (input)  : array defining a transformation between the I,J" },
{ "                   grid of the array and the world coordinates. The" },
{ "                   world coordinates of the array point A(I,J) are" },
{ "                   given by:" },
{ "                     X = TR(1) + TR(2)*I + TR(3)*J" },
{ "                     Y = TR(4) + TR(5)*I + TR(6)*J" },
{ "                   Usually TR(3) and TR(5) are zero - unless the" },
{ "                   coordinate transformation involves a rotation" },
{ "                   or shear." },
{ " BLANK   (input) : elements of array A that are exactly equal to" },
{ "                   this value are ignored (blanked)." },
{ "" },
{ "" }
}
},
{
{ "pgconf" }, {
{ "fill between two contours" },
{ "Syntax" },
{ "      SUBROUTINE PGCONF (A, IDIM, JDIM, I1, I2, J1, J2, C1, C2, TR)" },
{ "      INTEGER IDIM, JDIM, I1, I2, J1, J2" },
{ "      REAL    A(IDIM,JDIM), C1, C2, TR(6)" },
{ "" },
{ "Shade the region between two contour levels of a function defined on" },
{ "the nodes of a rectangular grid. The routine uses the current fill" },
{ "attributes, hatching style (if appropriate), and color index." },
{ "" },
{ "If you want to both shade between contours and draw the contour" },
{ "lines, call this routine first (once for each pair of levels) and " },
{ "then CALL PGCONT (or PGCONS) to draw the contour lines on top of the" },
{ "shading." },
{ "" },
{ "Note 1: This routine is not very efficient: it generates a polygon" },
{ "fill command for each cell of the mesh that intersects the desired" },
{ "area, rather than consolidating adjacent cells into a single polygon." },
{ "" },
{ "Note 2: If both contours intersect all four edges of a particular" },
{ "mesh cell, the program behaves badly and may consider some parts" },
{ "of the cell to lie in more than one contour range." },
{ "" },
{ "Note 3: If a contour crosses all four edges of a cell, this" },
{ "routine may not generate the same contours as PGCONT or PGCONS" },
{ "(these two routines may not agree either). Such cases are always" },
{ "ambiguous and the routines use different approaches to resolving" },
{ "the ambiguity." },
{ "" },
{ "Arguments:" },
{ " A      (input)  : data array." },
{ " IDIM   (input)  : first dimension of A." },
{ " JDIM   (input)  : second dimension of A." },
{ " I1,I2  (input)  : range of first index to be contoured (inclusive)." },
{ " J1,J2  (input)  : range of second index to be contoured (inclusive)." },
{ " C1, C2 (input)  : contour levels; note that C1 must be less than C2." },
{ " TR     (input)  : array defining a transformation between the I,J" },
{ "                   grid of the array and the world coordinates. The" },
{ "                   world coordinates of the array point A(I,J) are" },
{ "                   given by:" },
{ "                     X = TR(1) + TR(2)*I + TR(3)*J" },
{ "                     Y = TR(4) + TR(5)*I + TR(6)*J" },
{ "                   Usually TR(3) and TR(5) are zero - unless the" },
{ "                   coordinate transformation involves a rotation" },
{ "                   or shear." },
{ "" },
{ "" }
}
},
{
{ "pgconl" }, {
{ "label contour map of a 2D data array " },
{ "Syntax" },
{ "      SUBROUTINE PGCONL (A, IDIM, JDIM, I1, I2, J1, J2, C, TR," },
{ "     1                   LABEL, INTVAL, MININT)" },
{ "      INTEGER IDIM, JDIM, I1, J1, I2, J2, INTVAL, MININT" },
{ "      REAL A(IDIM,JDIM), C, TR(6)" },
{ "      CHARACTER*(*) LABEL" },
{ "" },
{ "Label a contour map drawn with routine PGCONT. Routine PGCONT should" },
{ "be called first to draw the contour lines, then this routine should be" },
{ "called to add the labels. Labels are written at intervals along the" },
{ "contour lines, centered on the contour lines with lettering aligned" },
{ "in the up-hill direction. Labels are opaque, so a part of the under-" },
{ "lying contour line is obscured by the label. Labels use the current" },
{ "attributes (character height, line width, color index, character" },
{ "font)." },
{ "" },
{ "The first 9 arguments are the same as those supplied to PGCONT, and" },
{ "should normally be identical to those used with PGCONT. Note that" },
{ "only one contour level can be specified; tolabel more contours, call" },
{ "PGCONL for each level." },
{ "" },
{ "The Label is supplied as a character string in argument LABEL." },
{ "" },
{ "The spacing of labels along the contour is specified by parameters" },
{ "INTVAL and MININT. The routine follows the contour through the" },
{ "array, counting the number of cells that the contour crosses. The" },
{ "first label will be written in the MININT'th cell, and additional" },
{ "labels will be written every INTVAL cells thereafter. A contour" },
{ "that crosses less than MININT cells will not be labelled. Some" },
{ "experimentation may be needed to get satisfactory results; a good" },
{ "place to start is INTVAL=20, MININT=10." },
{ "" },
{ "Arguments:" },
{ " A      (input) : data array." },
{ " IDIM   (input) : first dimension of A." },
{ " JDIM   (input) : second dimension of A." },
{ " I1, I2 (input) : range of first index to be contoured (inclusive)." },
{ " J1, J2 (input) : range of second index to be contoured (inclusive)." },
{ " C      (input) : the level of the contour to be labelled (one of the" },
{ "                  values given to PGCONT)." },
{ " TR     (input) : array defining a transformation between the I,J" },
{ "                  grid of the array and the world coordinates." },
{ "                  The world coordinates of the array point A(I,J)" },
{ "                  are given by:" },
{ "                    X = TR(1) + TR(2)*I + TR(3)*J" },
{ "                    Y = TR(4) + TR(5)*I + TR(6)*J" },
{ "                  Usually TR(3) and TR(5) are zero - unless the" },
{ "                  coordinate transformation involves a rotation or" },
{ "                  shear." },
{ " LABEL  (input) : character strings to be used to label the specified" },
{ "                  contour. Leading and trailing blank spaces are" },
{ "                  ignored." },
{ " INTVAL (input) : spacing along the contour between labels, in" },
{ "                  grid cells." },
{ " MININT (input) : contours that cross less than MININT cells" },
{ "                  will not be labelled." },
{ "" },
{ "" }
}
},
{
{ "pgcons" }, {
{ "contour map of a 2D data array (fast algorithm)" },
{ "Syntax" },
{ "      SUBROUTINE PGCONS (A, IDIM, JDIM, I1, I2, J1, J2, C, NC, TR)" },
{ "      INTEGER IDIM, JDIM, I1, I2, J1, J2, NC" },
{ "      REAL    A(IDIM,JDIM), C(*), TR(6)" },
{ "" },
{ "Draw a contour map of an array. The map is truncated if" },
{ "necessary at the boundaries of the viewport.  Each contour line is" },
{ "drawn with the current line attributes (color index, style, and" },
{ "width).  This routine, unlike PGCONT, does not draw each contour as a" },
{ "continuous line, but draws the straight line segments composing each" },
{ "contour in a random order.  It is thus not suitable for use on pen" },
{ "plotters, and it usually gives unsatisfactory results with dashed or" },
{ "dotted lines.  It is, however, faster than PGCONT, especially if" },
{ "several contour levels are drawn with one call of PGCONS." },
{ "" },
{ "Arguments:" },
{ " A      (input)  : data array." },
{ " IDIM   (input)  : first dimension of A." },
{ " JDIM   (input)  : second dimension of A." },
{ " I1,I2  (input)  : range of first index to be contoured (inclusive)." },
{ " J1,J2  (input)  : range of second index to be contoured (inclusive)." },
{ " C      (input)  : array of contour levels (in the same units as the" },
{ "                   data in array A); dimension at least NC." },
{ " NC     (input)  : number of contour levels (less than or equal to" },
{ "                   dimension of C). The absolute value of this" },
{ "                   argument is used (for compatibility with PGCONT," },
{ "                   where the sign of NC is significant)." },
{ " TR     (input)  : array defining a transformation between the I,J" },
{ "                   grid of the array and the world coordinates. The" },
{ "                   world coordinates of the array point A(I,J) are" },
{ "                   given by:" },
{ "                     X = TR(1) + TR(2)*I + TR(3)*J" },
{ "                     Y = TR(4) + TR(5)*I + TR(6)*J" },
{ "                   Usually TR(3) and TR(5) are zero - unless the" },
{ "                   coordinate transformation involves a rotation" },
{ "                   or shear." },
{ "" },
{ "" }
}
},
{
{ "pgcont" }, {
{ "contour map of a 2D data array (contour-following)" },
{ "Syntax" },
{ "      SUBROUTINE PGCONT (A, IDIM, JDIM, I1, I2, J1, J2, C, NC, TR)" },
{ "      INTEGER IDIM, JDIM, I1, J1, I2, J2, NC" },
{ "      REAL A(IDIM,JDIM), C(*), TR(6)" },
{ "" },
{ "Draw a contour map of an array.  The map is truncated if" },
{ "necessary at the boundaries of the viewport.  Each contour line" },
{ "is drawn with the current line attributes (color index, style, and" },
{ "width); except that if argument NC is positive (see below), the line" },
{ "style is set by PGCONT to 1 (solid) for positive contours or 2" },
{ "(dashed) for negative contours." },
{ "" },
{ "Arguments:" },
{ " A      (input) : data array." },
{ " IDIM   (input) : first dimension of A." },
{ " JDIM   (input) : second dimension of A." },
{ " I1, I2 (input) : range of first index to be contoured (inclusive)." },
{ " J1, J2 (input) : range of second index to be contoured (inclusive)." },
{ " C      (input) : array of NC contour levels; dimension at least NC." },
{ " NC     (input) : +/- number of contour levels (less than or equal" },
{ "                  to dimension of C). If NC is positive, it is the" },
{ "                  number of contour levels, and the line-style is" },
{ "                  chosen automatically as described above. If NC is" },
{ "                  negative, it is minus the number of contour" },
{ "                  levels, and the current setting of line-style is" },
{ "                  used for all the contours." },
{ " TR     (input) : array defining a transformation between the I,J" },
{ "                  grid of the array and the world coordinates." },
{ "                  The world coordinates of the array point A(I,J)" },
{ "                  are given by:" },
{ "                    X = TR(1) + TR(2)*I + TR(3)*J" },
{ "                    Y = TR(4) + TR(5)*I + TR(6)*J" },
{ "                  Usually TR(3) and TR(5) are zero - unless the" },
{ "                  coordinate transformation involves a rotation or" },
{ "                  shear." },
{ "" },
{ "" }
}
},
{
{ "pgconx" }, {
{ "contour map of a 2D data array (non rectangular)" },
{ "Syntax" },
{ "      SUBROUTINE PGCONX (A, IDIM, JDIM, I1, I2, J1, J2, C, NC, PLOT)" },
{ "      INTEGER  IDIM, JDIM, I1, J1, I2, J2, NC" },
{ "      REAL     A(IDIM,JDIM), C(*)" },
{ "      EXTERNAL PLOT" },
{ "" },
{ "Draw a contour map of an array using a user-supplied plotting" },
{ "routine.  This routine should be used instead of PGCONT when the" },
{ "data are defined on a non-rectangular grid.  PGCONT permits only" },
{ "a linear transformation between the (I,J) grid of the array" },
{ "and the world coordinate system (x,y), but PGCONX permits any" },
{ "transformation to be used, the transformation being defined by a" },
{ "user-supplied subroutine. The nature of the contouring algorithm," },
{ "however, dictates that the transformation should maintain the" },
{ "rectangular topology of the grid, although grid-points may be" },
{ "allowed to coalesce.  As an example of a deformed rectangular" },
{ "grid, consider data given on the polar grid theta=0.1n(pi/2)," },
{ "for n=0,1,...,10, and r=0.25m, for m=0,1,..,4. This grid" },
{ "contains 55 points, of which 11 are coincident at the origin." },
{ "The input array for PGCONX should be dimensioned (11,5), and" },
{ "data values should be provided for all 55 elements.  PGCONX can" },
{ "also be used for special applications in which the height of the" },
{ "contour affects its appearance, e.g., stereoscopic views." },
{ "" },
{ "The map is truncated if necessary at the boundaries of the viewport." },
{ "Each contour line is drawn with the current line attributes (color" },
{ "index, style, and width); except that if argument NC is positive" },
{ "(see below), the line style is set by PGCONX to 1 (solid) for" },
{ "positive contours or 2 (dashed) for negative contours. Attributes" },
{ "for the contour lines can also be set in the user-supplied" },
{ "subroutine, if desired." },
{ "" },
{ "Arguments:" },
{ " A      (input) : data array." },
{ " IDIM   (input) : first dimension of A." },
{ " JDIM   (input) : second dimension of A." },
{ " I1, I2 (input) : range of first index to be contoured (inclusive)." },
{ " J1, J2 (input) : range of second index to be contoured (inclusive)." },
{ " C      (input) : array of NC contour levels; dimension at least NC." },
{ " NC     (input) : +/- number of contour levels (less than or equal" },
{ "                  to dimension of C). If NC is positive, it is the" },
{ "                  number of contour levels, and the line-style is" },
{ "                  chosen automatically as described above. If NC is" },
{ "                  negative, it is minus the number of contour" },
{ "                  levels, and the current setting of line-style is" },
{ "                  used for all the contours." },
{ " PLOT   (input) : the address (name) of a subroutine supplied by" },
{ "                  the user, which will be called by PGCONX to do" },
{ "                  the actual plotting. This must be declared" },
{ "                  EXTERNAL in the program unit calling PGCONX." },
{ "" },
{ "The subroutine PLOT will be called with four arguments:" },
{ "     CALL PLOT(VISBLE,X,Y,Z)" },
{ "where X,Y (input) are real variables corresponding to" },
{ "I,J indices of the array A. If  VISBLE (input, integer) is 1," },
{ "PLOT should draw a visible line from the current pen" },
{ "position to the world coordinate point corresponding to (X,Y);" },
{ "if it is 0, it should move the pen to (X,Y). Z is the value" },
{ "of the current contour level, and may be used by PLOT if desired." },
{ "Example:" },
{ "      SUBROUTINE PLOT (VISBLE,X,Y,Z)" },
{ "      REAL X, Y, Z, XWORLD, YWORLD" },
{ "      INTEGER VISBLE" },
{ "      XWORLD = X*COS(Y) ! this is the user-defined" },
{ "      YWORLD = X*SIN(Y) ! transformation" },
{ "      IF (VISBLE.EQ.0) THEN" },
{ "          CALL PGMOVE (XWORLD, YWORLD)" },
{ "      ELSE" },
{ "          CALL PGDRAW (XWORLD, YWORLD)" },
{ "      END IF" },
{ "      END" },
{ "" },
{ "" }
}
},
{
{ "pgctab" }, {
{ "install the color table to be used by PGIMAG" },
{ "Syntax" },
{ "      SUBROUTINE PGCTAB(L, R, G, B, NC, CONTRA, BRIGHT)" },
{ "      INTEGER NC" },
{ "      REAL    L(NC), R(NC), G(NC), B(NC), CONTRA, BRIGHT" },
{ "" },
{ "Use the given color table to change the color representations of" },
{ "all color indexes marked for use by PGIMAG. To change which" },
{ "color indexes are thus marked, call PGSCIR before calling PGCTAB" },
{ "or PGIMAG. On devices that can change the color representations" },
{ "of previously plotted graphics, PGCTAB will also change the colors" },
{ "of existing graphics that were plotted with the marked color" },
{ "indexes. This feature can then be combined with PGBAND to" },
{ "interactively manipulate the displayed colors of data previously" },
{ "plotted with PGIMAG." },
{ "" },
{ "Limitations:" },
{ " 1. Some devices do not propagate color representation changes" },
{ "    to previously drawn graphics." },
{ " 2. Some devices ignore requests to change color representations." },
{ " 3. The appearance of specific color representations on grey-scale" },
{ "    devices is device-dependent." },
{ "" },
{ "Notes:" },
{ " To reverse the sense of a color table, change the chosen contrast" },
{ " and brightness to -CONTRA and 1-BRIGHT." },
{ "" },
{ " In the following, the term 'color table' refers to the input" },
{ " L,R,G,B arrays, whereas 'color ramp' refers to the resulting" },
{ " ramp of colors that would be seen with PGWEDG." },
{ "" },
{ "Arguments:" },
{ " L      (input)  : An array of NC normalized ramp-intensity levels" },
{ "                   corresponding to the RGB primary color intensities" },
{ "                   in R(),G(),B(). Colors on the ramp are linearly" },
{ "                   interpolated from neighbouring levels." },
{ "                   Levels must be sorted in increasing order." },
{ "                    0.0 places a color at the beginning of the ramp." },
{ "                    1.0 places a color at the end of the ramp." },
{ "                   Colors outside these limits are legal, but will" },
{ "                   not be visible if CONTRA=1.0 and BRIGHT=0.5." },
{ " R      (input)  : An array of NC normalized red intensities." },
{ " G      (input)  : An array of NC normalized green intensities." },
{ " B      (input)  : An array of NC normalized blue intensities." },
{ " NC     (input)  : The number of color table entries." },
{ " CONTRA (input)  : The contrast of the color ramp (normally 1.0)." },
{ "                   Negative values reverse the direction of the ramp." },
{ " BRIGHT (input)  : The brightness of the color ramp. This is normally" },
{ "                   0.5, but can sensibly hold any value between 0.0" },
{ "                   and 1.0. Values at or beyond the latter two" },
{ "                   extremes, saturate the color ramp with the colors" },
{ "                   of the respective end of the color table." },
{ "" },
{ "" }
}
},
{
{ "pgdraw" }, {
{ "draw a line from the current pen position to a point" },
{ "Syntax" },
{ "      SUBROUTINE PGDRAW (X, Y)" },
{ "      REAL X, Y" },
{ "" },
{ "Draw a line from the current pen position to the point" },
{ "with world-coordinates (X,Y). The line is clipped at the edge of the" },
{ "current window. The new pen position is (X,Y) in world coordinates." },
{ "" },
{ "Arguments:" },
{ " X      (input)  : world x-coordinate of the end point of the line." },
{ " Y      (input)  : world y-coordinate of the end point of the line." },
{ "" },
{ "" }
}
},
{
{ "pgebuf" }, {
{ "end batch of output (buffer)" },
{ "Syntax" },
{ "      SUBROUTINE PGEBUF" },
{ "" },
{ "A call to PGEBUF marks the end of a batch of graphical output begun" },
{ "with the last call of PGBBUF.  PGBBUF and PGEBUF calls should always" },
{ "be paired. Each call to PGBBUF increments a counter, while each call" },
{ "to PGEBUF decrements the counter. When the counter reaches 0, the" },
{ "batch of output is written on the output device." },
{ "" },
{ "Arguments: none" },
{ "" },
{ "" }
}
},
{
{ "pgend" }, {
{ "close all open graphics devices" },
{ "Syntax" },
{ "      SUBROUTINE PGEND" },
{ "" },
{ "Close and release any open graphics devices. All devices must be" },
{ "closed by calling either PGCLOS (for each device) or PGEND before" },
{ "the program terminates. If a device is not closed properly, some" },
{ "or all of the graphical output may be lost." },
{ "" },
{ "Arguments: none" },
{ "" },
{ "" }
}
},
{
{ "pgenv" }, {
{ "set window and viewport and draw labeled frame" },
{ "Syntax" },
{ "      SUBROUTINE PGENV (XMIN, XMAX, YMIN, YMAX, JUST, AXIS)" },
{ "      REAL XMIN, XMAX, YMIN, YMAX" },
{ "      INTEGER JUST, AXIS" },
{ "" },
{ "Set PGPLOT \"Plotter Environment\".  PGENV establishes the scaling" },
{ "for subsequent calls to PGPT, PGLINE, etc.  The plotter is" },
{ "advanced to a new page or panel, clearing the screen if necessary." },
{ "If the \"prompt state\" is ON (see PGASK), confirmation" },
{ "is requested from the user before clearing the screen." },
{ "If requested, a box, axes, labels, etc. are drawn according to" },
{ "the setting of argument AXIS." },
{ "" },
{ "Arguments:" },
{ " XMIN   (input)  : the world x-coordinate at the bottom left corner" },
{ "                   of the viewport." },
{ " XMAX   (input)  : the world x-coordinate at the top right corner" },
{ "                   of the viewport (note XMAX may be less than XMIN)." },
{ " YMIN   (input)  : the world y-coordinate at the bottom left corner" },
{ "                   of the viewport." },
{ " YMAX   (input)  : the world y-coordinate at the top right corner" },
{ "                   of the viewport (note YMAX may be less than YMIN)." },
{ " JUST   (input)  : if JUST=1, the scales of the x and y axes (in" },
{ "                   world coordinates per inch) will be equal," },
{ "                   otherwise they will be scaled independently." },
{ " AXIS   (input)  : controls the plotting of axes, tick marks, etc:" },
{ "     AXIS = -2 : draw no box, axes or labels;" },
{ "     AXIS = -1 : draw box only;" },
{ "     AXIS =  0 : draw box and label it with coordinates;" },
{ "     AXIS =  1 : same as AXIS=0, but also draw the" },
{ "                 coordinate axes (X=0, Y=0);" },
{ "     AXIS =  2 : same as AXIS=1, but also draw grid lines" },
{ "                 at major increments of the coordinates;" },
{ "     AXIS = 10 : draw box and label X-axis logarithmically;" },
{ "     AXIS = 20 : draw box and label Y-axis logarithmically;" },
{ "     AXIS = 30 : draw box and label both axes logarithmically." },
{ "" },
{ "For other axis options, use routine PGBOX. PGENV can be persuaded to" },
{ "call PGBOX with additional axis options by defining an environment" },
{ "parameter PGPLOT_ENVOPT containing the required option codes. " },
{ "Examples:" },
{ "  PGPLOT_ENVOPT=P      ! draw Projecting tick marks" },
{ "  PGPLOT_ENVOPT=I      ! Invert the tick marks" },
{ "  PGPLOT_ENVOPT=IV     ! Invert tick marks and label y Vertically" },
{ "" },
{ "" }
}
},
{
{ "pgeras" }, {
{ "erase all graphics from current page" },
{ "Syntax" },
{ "      SUBROUTINE PGERAS" },
{ "" },
{ "Erase all graphics from the current page (or current panel, if" },
{ "the view surface has been divided into panels with PGSUBP)." },
{ "" },
{ "Arguments: none" },
{ "" },
{ "" }
}
},
{
{ "pgerr1" }, {
{ "horizontal or vertical error bar" },
{ "Syntax" },
{ "      SUBROUTINE PGERR1 (DIR, X, Y, E, T)" },
{ "      INTEGER DIR" },
{ "      REAL X, Y, E" },
{ "      REAL T" },
{ "" },
{ "Plot a single error bar in the direction specified by DIR." },
{ "This routine draws an error bar only; to mark the data point at" },
{ "the start of the error bar, an additional call to PGPT is required." },
{ "To plot many error bars, use PGERRB." },
{ "" },
{ "Arguments:" },
{ " DIR    (input)  : direction to plot the error bar relative to" },
{ "                   the data point. " },
{ "                   One-sided error bar:" },
{ "                     DIR is 1 for +X (X to X+E);" },
{ "                            2 for +Y (Y to Y+E);" },
{ "                            3 for -X (X to X-E);" },
{ "                            4 for -Y (Y to Y-E)." },
{ "                   Two-sided error bar:" },
{ "                     DIR is 5 for +/-X (X-E to X+E); " },
{ "                            6 for +/-Y (Y-E to Y+E)." },
{ " X      (input)  : world x-coordinate of the data." },
{ " Y      (input)  : world y-coordinate of the data." },
{ " E      (input)  : value of error bar distance to be added to the" },
{ "                   data position in world coordinates." },
{ " T      (input)  : length of terminals to be drawn at the ends" },
{ "                   of the error bar, as a multiple of the default" },
{ "                   length; if T = 0.0, no terminals will be drawn." },
{ "" },
{ "" }
}
},
{
{ "pgerrb" }, {
{ "horizontal or vertical error bar" },
{ "Syntax" },
{ "      SUBROUTINE PGERRB (DIR, N, X, Y, E, T)" },
{ "      INTEGER DIR, N" },
{ "      REAL X(*), Y(*), E(*)" },
{ "      REAL T" },
{ "" },
{ "Plot error bars in the direction specified by DIR." },
{ "This routine draws an error bar only; to mark the data point at" },
{ "the start of the error bar, an additional call to PGPT is required." },
{ "" },
{ "Arguments:" },
{ " DIR    (input)  : direction to plot the error bar relative to" },
{ "                   the data point. " },
{ "                   One-sided error bar:" },
{ "                     DIR is 1 for +X (X to X+E);" },
{ "                            2 for +Y (Y to Y+E);" },
{ "                            3 for -X (X to X-E);" },
{ "                            4 for -Y (Y to Y-E)." },
{ "                   Two-sided error bar:" },
{ "                     DIR is 5 for +/-X (X-E to X+E); " },
{ "                            6 for +/-Y (Y-E to Y+E)." },
{ " N      (input)  : number of error bars to plot." },
{ " X      (input)  : world x-coordinates of the data." },
{ " Y      (input)  : world y-coordinates of the data." },
{ " E      (input)  : value of error bar distance to be added to the" },
{ "                   data position in world coordinates." },
{ " T      (input)  : length of terminals to be drawn at the ends" },
{ "                   of the error bar, as a multiple of the default" },
{ "                   length; if T = 0.0, no terminals will be drawn." },
{ "" },
{ "Note: the dimension of arrays X, Y, and E must be greater" },
{ "than or equal to N. If N is 1, X, Y, and E may be scalar" },
{ "variables, or expressions." },
{ "" },
{ "" }
}
},
{
{ "pgerrx" }, {
{ "horizontal error bar" },
{ "Syntax" },
{ "      SUBROUTINE PGERRX (N, X1, X2, Y, T)" },
{ "      INTEGER N" },
{ "      REAL X1(*), X2(*), Y(*)" },
{ "      REAL T" },
{ "" },
{ "Plot horizontal error bars." },
{ "This routine draws an error bar only; to mark the data point in" },
{ "the middle of the error bar, an additional call to PGPT or" },
{ "PGERRY is required." },
{ "" },
{ "Arguments:" },
{ " N      (input)  : number of error bars to plot." },
{ " X1     (input)  : world x-coordinates of lower end of the" },
{ "                   error bars." },
{ " X2     (input)  : world x-coordinates of upper end of the" },
{ "                   error bars." },
{ " Y      (input)  : world y-coordinates of the data." },
{ " T      (input)  : length of terminals to be drawn at the ends" },
{ "                   of the error bar, as a multiple of the default" },
{ "                   length; if T = 0.0, no terminals will be drawn." },
{ "" },
{ "Note: the dimension of arrays X1, X2, and Y must be greater" },
{ "than or equal to N. If N is 1, X1, X2, and Y may be scalar" },
{ "variables, or expressions, eg:" },
{ "      CALL PGERRX(1,X-SIGMA,X+SIGMA,Y)" },
{ "" },
{ "" }
}
},
{
{ "pgerry" }, {
{ "vertical error bar" },
{ "Syntax" },
{ "      SUBROUTINE PGERRY (N, X, Y1, Y2, T)" },
{ "      INTEGER N" },
{ "      REAL X(*), Y1(*), Y2(*)" },
{ "      REAL T" },
{ "" },
{ "Plot vertical error bars." },
{ "This routine draws an error bar only; to mark the data point in" },
{ "the middle of the error bar, an additional call to PGPT or" },
{ "PGERRX is required." },
{ "" },
{ "Arguments:" },
{ " N      (input)  : number of error bars to plot." },
{ " X      (input)  : world x-coordinates of the data." },
{ " Y1     (input)  : world y-coordinates of top end of the" },
{ "                   error bars." },
{ " Y2     (input)  : world y-coordinates of bottom end of the" },
{ "                   error bars." },
{ " T      (input)  : length of terminals to be drawn at the ends" },
{ "                   of the error bar, as a multiple of the default" },
{ "                   length; if T = 0.0, no terminals will be drawn." },
{ "" },
{ "Note: the dimension of arrays X, Y1, and Y2 must be greater" },
{ "than or equal to N. If N is 1, X, Y1, and Y2 may be scalar" },
{ "variables or expressions, eg:" },
{ "      CALL PGERRY(1,X,Y+SIGMA,Y-SIGMA)" },
{ "" },
{ "" }
}
},
{
{ "pgetxt" }, {
{ "erase text from graphics display" },
{ "Syntax" },
{ "      SUBROUTINE PGETXT" },
{ "" },
{ "Some graphics terminals display text (the normal interactive dialog)" },
{ "on the same screen as graphics. This routine erases the text from the" },
{ "view surface without affecting the graphics. It does nothing on" },
{ "devices which do not display text on the graphics screen, and on" },
{ "devices which do not have this capability." },
{ "" },
{ "Arguments:" },
{ " None" },
{ "" },
{ "" }
}
},
{
{ "pgfunt" }, {
{ "function defined by X = F(T), Y = G(T)" },
{ "Syntax" },
{ "      SUBROUTINE PGFUNT (FX, FY, N, TMIN, TMAX, PGFLAG)" },
{ "      REAL FX, FY" },
{ "      EXTERNAL FX, FY" },
{ "      INTEGER N" },
{ "      REAL TMIN, TMAX" },
{ "      INTEGER PGFLAG" },
{ "" },
{ "Draw a curve defined by parametric equations X = FX(T), Y = FY(T)." },
{ "" },
{ "Arguments:" },
{ " FX     (external real function): supplied by the user, evaluates" },
{ "                   X-coordinate." },
{ " FY     (external real function): supplied by the user, evaluates" },
{ "                   Y-coordinate." },
{ " N      (input)  : the number of points required to define the" },
{ "                   curve. The functions FX and FY will each be" },
{ "                   called N+1 times." },
{ " TMIN   (input)  : the minimum value for the parameter T." },
{ " TMAX   (input)  : the maximum value for the parameter T." },
{ " PGFLAG (input)  : if PGFLAG = 1, the curve is plotted in the" },
{ "                   current window and viewport; if PGFLAG = 0," },
{ "                   PGENV is called automatically by PGFUNT to" },
{ "                   start a new plot with automatic scaling." },
{ "" },
{ "Note: The functions FX and FY must be declared EXTERNAL in the" },
{ "Fortran program unit that calls PGFUNT." },
{ "" },
{ "" }
}
},
{
{ "pgfunx" }, {
{ "function defined by Y = F(X)" },
{ "Syntax" },
{ "      SUBROUTINE PGFUNX (FY, N, XMIN, XMAX, PGFLAG)" },
{ "      REAL FY" },
{ "      EXTERNAL FY" },
{ "      INTEGER N" },
{ "      REAL XMIN, XMAX" },
{ "      INTEGER PGFLAG" },
{ "" },
{ "Draw a curve defined by the equation Y = FY(X), where FY is a" },
{ "user-supplied subroutine." },
{ "" },
{ "Arguments:" },
{ " FY     (external real function): supplied by the user, evaluates" },
{ "                   Y value at a given X-coordinate." },
{ " N      (input)  : the number of points required to define the" },
{ "                   curve. The function FY will be called N+1 times." },
{ "                   If PGFLAG=0 and N is greater than 1000, 1000" },
{ "                   will be used instead.  If N is less than 1," },
{ "                   nothing will be drawn." },
{ " XMIN   (input)  : the minimum value of X." },
{ " XMAX   (input)  : the maximum value of X." },
{ " PGFLAG (input)  : if PGFLAG = 1, the curve is plotted in the" },
{ "                   current window and viewport; if PGFLAG = 0," },
{ "                   PGENV is called automatically by PGFUNX to" },
{ "                   start a new plot with X limits (XMIN, XMAX)" },
{ "                   and automatic scaling in Y." },
{ "" },
{ "Note: The function FY must be declared EXTERNAL in the Fortran" },
{ "program unit that calls PGFUNX.  It has one argument, the" },
{ "x-coordinate at which the y value is required, e.g." },
{ "  REAL FUNCTION FY(X)" },
{ "  REAL X" },
{ "  FY = ....." },
{ "  END" },
{ "" },
{ "" }
}
},
{
{ "pgfuny" }, {
{ "function defined by X = F(Y)" },
{ "Syntax" },
{ "      SUBROUTINE PGFUNY (FX, N, YMIN, YMAX, PGFLAG)" },
{ "      REAL    FX" },
{ "      EXTERNAL FX" },
{ "      INTEGER N" },
{ "      REAL    YMIN, YMAX" },
{ "      INTEGER PGFLAG" },
{ "" },
{ "Draw a curve defined by the equation X = FX(Y), where FY is a" },
{ "user-supplied subroutine." },
{ "" },
{ "Arguments:" },
{ " FX     (external real function): supplied by the user, evaluates" },
{ "                   X value at a given Y-coordinate." },
{ " N      (input)  : the number of points required to define the" },
{ "                   curve. The function FX will be called N+1 times." },
{ "                   If PGFLAG=0 and N is greater than 1000, 1000" },
{ "                   will be used instead.  If N is less than 1," },
{ "                   nothing will be drawn." },
{ " YMIN   (input)  : the minimum value of Y." },
{ " YMAX   (input)  : the maximum value of Y." },
{ " PGFLAG (input)  : if PGFLAG = 1, the curve is plotted in the" },
{ "                   current window and viewport; if PGFLAG = 0," },
{ "                   PGENV is called automatically by PGFUNY to" },
{ "                   start a new plot with Y limits (YMIN, YMAX)" },
{ "                   and automatic scaling in X." },
{ "" },
{ "Note: The function FX must be declared EXTERNAL in the Fortran" },
{ "program unit that calls PGFUNY.  It has one argument, the" },
{ "y-coordinate at which the x value is required, e.g." },
{ "  REAL FUNCTION FX(Y)" },
{ "  REAL Y" },
{ "  FX = ....." },
{ "  END" },
{ "" },
{ "" }
}
},
{
{ "pggray" }, {
{ "gray-scale map of a 2D data array" },
{ "Syntax" },
{ "      SUBROUTINE PGGRAY (A, IDIM, JDIM, I1, I2, J1, J2," },
{ "     1                   FG, BG, TR)" },
{ "      INTEGER IDIM, JDIM, I1, I2, J1, J2" },
{ "      REAL    A(IDIM,JDIM), FG, BG, TR(6)" },
{ "" },
{ "Draw gray-scale map of an array in current window. The subsection" },
{ "of the array A defined by indices (I1:I2, J1:J2) is mapped onto" },
{ "the view surface world-coordinate system by the transformation" },
{ "matrix TR. The resulting quadrilateral region is clipped at the edge" },
{ "of the window and shaded with the shade at each point determined" },
{ "by the corresponding array value.  The shade is a number in the" },
{ "range 0 to 1 obtained by linear interpolation between the background" },
{ "level (BG) and the foreground level (FG), i.e.," },
{ "" },
{ "  shade = [A(i,j) - BG] / [FG - BG]" },
{ "" },
{ "The background level BG can be either less than or greater than the" },
{ "foreground level FG.  Points in the array that are outside the range" },
{ "BG to FG are assigned shade 0 or 1 as appropriate." },
{ "" },
{ "PGGRAY uses two different algorithms, depending how many color" },
{ "indices are available in the color index range specified for images." },
{ "(This range is set with routine PGSCIR, and the current or default" },
{ "range can be queried by calling routine PGQCIR)." },
{ "" },
{ "If 16 or more color indices are available, PGGRAY first assigns" },
{ "color representations to these color indices to give a linear ramp" },
{ "between the background color (color index 0) and the foreground color" },
{ "(color index 1), and then calls PGIMAG to draw the image using these" },
{ "color indices. In this mode, the shaded region is \"opaque\": every" },
{ "pixel is assigned a color." },
{ "" },
{ "If less than 16 color indices are available, PGGRAY uses only" },
{ "color index 1, and uses  a \"dithering\" algorithm to fill in pixels," },
{ "with the shade (computed as above) determining the faction of pixels" },
{ "that are filled. In this mode the shaded region is \"transparent\" and" },
{ "allows previously-drawn graphics to show through." },
{ "" },
{ "The transformation matrix TR is used to calculate the world" },
{ "coordinates of the center of the \"cell\" that represents each" },
{ "array element. The world coordinates of the center of the cell" },
{ "corresponding to array element A(I,J) are given by:" },
{ "" },
{ "         X = TR(1) + TR(2)*I + TR(3)*J" },
{ "         Y = TR(4) + TR(5)*I + TR(6)*J" },
{ "" },
{ "Usually TR(3) and TR(5) are zero -- unless the coordinate" },
{ "transformation involves a rotation or shear.  The corners of the" },
{ "quadrilateral region that is shaded by PGGRAY are given by" },
{ "applying this transformation to (I1-0.5,J1-0.5), (I2+0.5, J2+0.5)." },
{ "" },
{ "Arguments:" },
{ " A      (input)  : the array to be plotted." },
{ " IDIM   (input)  : the first dimension of array A." },
{ " JDIM   (input)  : the second dimension of array A." },
{ " I1, I2 (input)  : the inclusive range of the first index" },
{ "                   (I) to be plotted." },
{ " J1, J2 (input)  : the inclusive range of the second" },
{ "                   index (J) to be plotted." },
{ " FG     (input)  : the array value which is to appear with the" },
{ "                   foreground color (corresponding to color index 1)." },
{ " BG     (input)  : the array value which is to appear with the" },
{ "                   background color (corresponding to color index 0)." },
{ " TR     (input)  : transformation matrix between array grid and" },
{ "                   world coordinates." },
{ "" },
{ "" }
}
},
{
{ "pghi2d" }, {
{ "cross-sections through a 2D data array" },
{ "Syntax" },
{ "      SUBROUTINE PGHI2D (DATA, NXV, NYV, IX1, IX2, IY1, IY2, X, IOFF," },
{ "     1                   BIAS, CENTER, YLIMS)" },
{ "      INTEGER NXV, NYV, IX1, IX2, IY1, IY2" },
{ "      REAL    DATA(NXV,NYV)" },
{ "      REAL    X(IX2-IX1+1), YLIMS(IX2-IX1+1)" },
{ "      INTEGER IOFF" },
{ "      REAL    BIAS" },
{ "      LOGICAL CENTER" },
{ "" },
{ "Plot a series of cross-sections through a 2D data array." },
{ "Each cross-section is plotted as a hidden line histogram.  The plot" },
{ "can be slanted to give a pseudo-3D effect - if this is done, the" },
{ "call to PGENV may have to be changed to allow for the increased X" },
{ "range that will be needed." },
{ "" },
{ "Arguments:" },
{ " DATA   (input)  : the data array to be plotted." },
{ " NXV    (input)  : the first dimension of DATA." },
{ " NYV    (input)  : the second dimension of DATA." },
{ " IX1    (input)" },
{ " IX2    (input)" },
{ " IY1    (input)" },
{ " IY2    (input)  : PGHI2D plots a subset of the input array DATA." },
{ "                   This subset is delimited in the first (x)" },
{ "                   dimension by IX1 and IX2 and the 2nd (y) by IY1" },
{ "                   and IY2, inclusively. Note: IY2 &lt; IY1 is" },
{ "                   permitted, resulting in a plot with the" },
{ "                   cross-sections plotted in reverse Y order." },
{ "                   However, IX2 must be =&gt; IX1." },
{ " X      (input)  : the abscissae of the bins to be plotted. That is," },
{ "                   X(1) should be the X value for DATA(IX1,IY1), and" },
{ "                   X should have (IX2-IX1+1) elements.  The program" },
{ "                   has to assume that the X value for DATA(x,y) is" },
{ "                   the same for all y." },
{ " IOFF   (input)  : an offset in array elements applied to successive" },
{ "                   cross-sections to produce a slanted effect.  A" },
{ "                   plot with IOFF &gt; 0 slants to the right, one with" },
{ "                   IOFF &lt; 0 slants left." },
{ " BIAS   (input)  : a bias value applied to each successive cross-" },
{ "                   section in order to raise it above the previous" },
{ "                   cross-section.  This is in the same units as the" },
{ "                   data." },
{ " CENTER (input)  : if .true., the X values denote the center of the" },
{ "                   bins; if .false. the X values denote the lower" },
{ "                   edges (in X) of the bins." },
{ " YLIMS  (input)  : workspace.  Should be an array of at least" },
{ "                   (IX2-IX1+1) elements." },
{ "" },
{ "" }
}
},
{
{ "pghist" }, {
{ "histogram of unbinned data" },
{ "Syntax" },
{ "      SUBROUTINE PGHIST(N, DATA, DATMIN, DATMAX, NBIN, PGFLAG)" },
{ "      INTEGER N" },
{ "      REAL    DATA(*)" },
{ "      REAL    DATMIN, DATMAX" },
{ "      INTEGER NBIN, PGFLAG" },
{ "" },
{ "Draw a histogram of N values of a variable in array" },
{ "DATA(1...N) in the range DATMIN to DATMAX using NBIN bins.  Note" },
{ "that array elements which fall exactly on the boundary between" },
{ "two bins will be counted in the higher bin rather than the" },
{ "lower one; and array elements whose value is less than DATMIN or" },
{ "greater than or equal to DATMAX will not be counted at all." },
{ "" },
{ "Arguments:" },
{ " N      (input)  : the number of data values." },
{ " DATA   (input)  : the data values. Note: the dimension of array" },
{ "                   DATA must be greater than or equal to N. The" },
{ "                   first N elements of the array are used." },
{ " DATMIN (input)  : the minimum data value for the histogram." },
{ " DATMAX (input)  : the maximum data value for the histogram." },
{ " NBIN   (input)  : the number of bins to use: the range DATMIN to" },
{ "                   DATMAX is divided into NBIN equal bins and" },
{ "                   the number of DATA values in each bin is" },
{ "                   determined by PGHIST.  NBIN may not exceed 200." },
{ " PGFLAG (input)  : if PGFLAG = 1, the histogram is plotted in the" },
{ "                   current window and viewport; if PGFLAG = 0," },
{ "                   PGENV is called automatically by PGHIST to start" },
{ "                   a new plot (the x-limits of the window will be" },
{ "                   DATMIN and DATMAX; the y-limits will be chosen" },
{ "                   automatically." },
{ "                   IF PGFLAG = 2,3 the histogram will be in the same" },
{ "                   window and viewport but with a filled area style." },
{ "                   If pgflag=4,5 as for pgflag = 0,1, but simple" },
{ "                   line drawn as for PGBIN" },
{ "" },
{ "" },
{ "" }
}
},
{
{ "pgiden" }, {
{ "write username, date, and time at bottom of plot" },
{ "Syntax" },
{ "      SUBROUTINE PGIDEN" },
{ "" },
{ "Write username, date, and time at bottom of plot." },
{ "" },
{ "Arguments: none." },
{ "" },
{ "" }
}
},
{
{ "pgimag" }, {
{ "color image from a 2D data array" },
{ "Syntax" },
{ "      SUBROUTINE PGIMAG (A, IDIM, JDIM, I1, I2, J1, J2," },
{ "     1                   A1, A2, TR)" },
{ "      INTEGER IDIM, JDIM, I1, I2, J1, J2" },
{ "      REAL    A(IDIM,JDIM), A1, A2, TR(6)" },
{ "" },
{ "Draw a color image of an array in current window. The subsection" },
{ "of the array A defined by indices (I1:I2, J1:J2) is mapped onto" },
{ "the view surface world-coordinate system by the transformation" },
{ "matrix TR. The resulting quadrilateral region is clipped at the edge" },
{ "of the window. Each element of the array is represented in the image" },
{ "by a small quadrilateral, which is filled with a color specified by" },
{ "the corresponding array value." },
{ "" },
{ "The subroutine uses color indices in the range C1 to C2, which can" },
{ "be specified by calling PGSCIR before PGIMAG. The default values" },
{ "for C1 and C2 are device-dependent; these values can be determined by" },
{ "calling PGQCIR. Note that color representations should be assigned to" },
{ "color indices C1 to C2 by calling PGSCR before calling PGIMAG. On some" },
{ "devices (but not all), the color representation can be changed after" },
{ "the call to PGIMAG by calling PGSCR again." },
{ "" },
{ "Array values in the range A1 to A2 are mapped on to the range of" },
{ "color indices C1 to C2, with array values &lt;= A1 being given color" },
{ "index C1 and values &gt;= A2 being given color index C2. The mapping" },
{ "function for intermediate array values can be specified by" },
{ "calling routine PGSITF before PGIMAG; the default is linear." },
{ "" },
{ "On devices which have no available color indices (C1 &gt; C2)," },
{ "PGIMAG will return without doing anything. On devices with only" },
{ "one color index (C1=C2), all array values map to the same color" },
{ "which is rather uninteresting. An image is always \"opaque\"," },
{ "i.e., it obscures all graphical elements previously drawn in" },
{ "the region." },
{ "" },
{ "The transformation matrix TR is used to calculate the world" },
{ "coordinates of the center of the \"cell\" that represents each" },
{ "array element. The world coordinates of the center of the cell" },
{ "corresponding to array element A(I,J) are given by:" },
{ "" },
{ "         X = TR(1) + TR(2)*I + TR(3)*J" },
{ "         Y = TR(4) + TR(5)*I + TR(6)*J" },
{ "" },
{ "Usually TR(3) and TR(5) are zero -- unless the coordinate" },
{ "transformation involves a rotation or shear.  The corners of the" },
{ "quadrilateral region that is shaded by PGIMAG are given by" },
{ "applying this transformation to (I1-0.5,J1-0.5), (I2+0.5, J2+0.5)." },
{ "" },
{ "Arguments:" },
{ " A      (input)  : the array to be plotted." },
{ " IDIM   (input)  : the first dimension of array A." },
{ " JDIM   (input)  : the second dimension of array A." },
{ " I1, I2 (input)  : the inclusive range of the first index" },
{ "                   (I) to be plotted." },
{ " J1, J2 (input)  : the inclusive range of the second" },
{ "                   index (J) to be plotted." },
{ " A1     (input)  : the array value which is to appear with shade C1." },
{ " A2     (input)  : the array value which is to appear with shade C2." },
{ " TR     (input)  : transformation matrix between array grid and" },
{ "                   world coordinates." },
{ "" },
{ "" }
}
},
{
{ "pglab" }, {
{ "write labels for x-axis, y-axis, and top of plot" },
{ "Syntax" },
{ "      SUBROUTINE PGLAB (XLBL, YLBL, TOPLBL)" },
{ "      CHARACTER*(*) XLBL, YLBL, TOPLBL" },
{ "" },
{ "Write labels outside the viewport. This routine is a simple" },
{ "interface to PGMTXT, which should be used if PGLAB is inadequate." },
{ "" },
{ "Arguments:" },
{ " XLBL   (input) : a label for the x-axis (centered below the" },
{ "                  viewport)." },
{ " YLBL   (input) : a label for the y-axis (centered to the left" },
{ "                  of the viewport, drawn vertically)." },
{ " TOPLBL (input) : a label for the entire plot (centered above the" },
{ "                  viewport)." },
{ "" },
{ "" }
}
},
{
{ "pglcur" }, {
{ "draw a line using the cursor" },
{ "Syntax" },
{ "      SUBROUTINE PGLCUR (MAXPT, NPT, X, Y)" },
{ "      INTEGER MAXPT, NPT" },
{ "      REAL    X(*), Y(*)" },
{ "" },
{ "Interactive routine for user to enter a polyline by use of" },
{ "the cursor.  Routine allows user to Add and Delete vertices;" },
{ "vertices are joined by straight-line segments." },
{ "" },
{ "Arguments:" },
{ " MAXPT  (input)  : maximum number of points that may be accepted." },
{ " NPT    (in/out) : number of points entered; should be zero on" },
{ "                   first call." },
{ " X      (in/out) : array of x-coordinates (dimension at least MAXPT)." },
{ " Y      (in/out) : array of y-coordinates (dimension at least MAXPT)." },
{ "" },
{ "Notes:" },
{ "" },
{ "(1) On return from the program, cursor points are returned in" },
{ "the order they were entered. Routine may be (re-)called with points" },
{ "already defined in X,Y (# in NPT), and they will be plotted" },
{ "first, before editing." },
{ "" },
{ "(2) User commands: the user types single-character commands" },
{ "after positioning the cursor: the following are accepted:" },
{ "  A (Add)    - add point at current cursor location." },
{ "  D (Delete) - delete last-entered point." },
{ "  X (eXit)   - leave subroutine." },
{ "" },
{ "" }
}
},
{
{ "pgldev" }, {
{ "list available device types on standard output" },
{ "Syntax" },
{ "      SUBROUTINE PGLDEV" },
{ "" },
{ "Writes (to standard output) a list of all device types available in" },
{ "the current PGPLOT installation." },
{ "" },
{ "Arguments: none." },
{ "" },
{ "" }
}
},
{
{ "pglen" }, {
{ "find length of a string in a variety of units" },
{ "Syntax" },
{ "      SUBROUTINE PGLEN (UNITS, STRING, XL, YL)" },
{ "      REAL XL, YL" },
{ "      INTEGER UNITS" },
{ "      CHARACTER*(*) STRING" },
{ "" },
{ "Work out length of a string in x and y directions " },
{ "" },
{ "Input" },
{ " UNITS    :  0 =&gt; answer in normalized device coordinates" },
{ "             1 =&gt; answer in inches" },
{ "             2 =&gt; answer in mm" },
{ "             3 =&gt; answer in absolute device coordinates (dots)" },
{ "             4 =&gt; answer in world coordinates" },
{ "             5 =&gt; answer as a fraction of the current viewport size" },
{ "" },
{ " STRING   :  String of interest" },
{ "Output" },
{ " XL       :  Length of string in x direction" },
{ " YL       :  Length of string in y direction" },
{ "" },
{ "" },
{ "" }
}
},
{
{ "pgline" }, {
{ "draw a polyline (curve defined by line-segments)" },
{ "Syntax" },
{ "      SUBROUTINE PGLINE (N, XPTS, YPTS)" },
{ "      INTEGER  N" },
{ "      REAL     XPTS(*), YPTS(*)" },
{ "" },
{ "Primitive routine to draw a Polyline. A polyline is one or more" },
{ "connected straight-line segments.  The polyline is drawn using" },
{ "the current setting of attributes color-index, line-style, and" },
{ "line-width. The polyline is clipped at the edge of the window." },
{ "" },
{ "Arguments:" },
{ " N      (input)  : number of points defining the line; the line" },
{ "                   consists of (N-1) straight-line segments." },
{ "                   N should be greater than 1 (if it is 1 or less," },
{ "                   nothing will be drawn)." },
{ " XPTS   (input)  : world x-coordinates of the points." },
{ " YPTS   (input)  : world y-coordinates of the points." },
{ "" },
{ "The dimension of arrays X and Y must be greater than or equal to N." },
{ "The \"pen position\" is changed to (X(N),Y(N)) in world coordinates" },
{ "(if N &gt; 1)." },
{ "" },
{ "" }
}
},
{
{ "pgmove" }, {
{ "move pen (change current pen position)" },
{ "Syntax" },
{ "      SUBROUTINE PGMOVE (X, Y)" },
{ "      REAL X, Y" },
{ "" },
{ "Primitive routine to move the \"pen\" to the point with world" },
{ "coordinates (X,Y). No line is drawn." },
{ "" },
{ "Arguments:" },
{ " X      (input)  : world x-coordinate of the new pen position." },
{ " Y      (input)  : world y-coordinate of the new pen position." },
{ "" },
{ "" }
}
},
{
{ "pgmtxt" }, {
{ "write text at position relative to viewport" },
{ "Syntax" },
{ "      SUBROUTINE PGMTXT (SIDE, DISP, COORD, FJUST, TEXT)" },
{ "      CHARACTER*(*) SIDE, TEXT" },
{ "      REAL DISP, COORD, FJUST" },
{ "" },
{ "Write text at a position specified relative to the viewport (outside" },
{ "or inside).  This routine is useful for annotating graphs. It is used" },
{ "by routine PGLAB.  The text is written using the current values of" },
{ "attributes color-index, line-width, character-height, and" },
{ "character-font." },
{ "" },
{ "Arguments:" },
{ " SIDE   (input)  : must include one of the characters 'B', 'L', 'T'," },
{ "                   or 'R' signifying the Bottom, Left, Top, or Right" },
{ "                   margin of the viewport. If it includes 'LV' or" },
{ "                   'RV', the string is written perpendicular to the" },
{ "                   frame rather than parallel to it." },
{ " DISP   (input)  : the displacement of the character string from the" },
{ "                   specified edge of the viewport, measured outwards" },
{ "                   from the viewport in units of the character" },
{ "                   height. Use a negative value to write inside the" },
{ "                   viewport, a positive value to write outside." },
{ " COORD  (input)  : the location of the character string along the" },
{ "                   specified edge of the viewport, as a fraction of" },
{ "                   the length of the edge." },
{ " FJUST  (input)  : controls justification of the string parallel to" },
{ "                   the specified edge of the viewport. If" },
{ "                   FJUST = 0.0, the left-hand end of the string will" },
{ "                   be placed at COORD; if JUST = 0.5, the center of" },
{ "                   the string will be placed at COORD; if JUST = 1.0," },
{ "                   the right-hand end of the string will be placed at" },
{ "                   at COORD. Other values between 0 and 1 give inter-" },
{ "                   mediate placing, but they are not very useful." },
{ " TEXT   (input) :  the text string to be plotted. Trailing spaces are" },
{ "                   ignored when justifying the string, but leading" },
{ "                   spaces are significant." },
{ "" },
{ "" },
{ "" }
}
},
{
{ "pgncur" }, {
{ "mark a set of points using the cursor" },
{ "Syntax" },
{ "      SUBROUTINE PGNCUR (MAXPT, NPT, X, Y, SYMBOL)" },
{ "      INTEGER MAXPT, NPT" },
{ "      REAL    X(*), Y(*)" },
{ "      INTEGER SYMBOL" },
{ "" },
{ "Interactive routine for user to enter data points by use of" },
{ "the cursor.  Routine allows user to Add and Delete points.  The" },
{ "points are returned in order of increasing x-coordinate, not in the" },
{ "order they were entered." },
{ "" },
{ "Arguments:" },
{ " MAXPT  (input)  : maximum number of points that may be accepted." },
{ " NPT    (in/out) : number of points entered; should be zero on" },
{ "                   first call." },
{ " X      (in/out) : array of x-coordinates." },
{ " Y      (in/out) : array of y-coordinates." },
{ " SYMBOL (input)  : code number of symbol to use for marking" },
{ "                   entered points (see PGPT)." },
{ "" },
{ "Note (1): The dimension of arrays X and Y must be greater than or" },
{ "equal to MAXPT." },
{ "" },
{ "Note (2): On return from the program, cursor points are returned in" },
{ "increasing order of X. Routine may be (re-)called with points" },
{ "already defined in X,Y (number in NPT), and they will be plotted" },
{ "first, before editing." },
{ "" },
{ "Note (3): User commands: the user types single-character commands" },
{ "after positioning the cursor: the following are accepted:" },
{ "A (Add)    - add point at current cursor location." },
{ "D (Delete) - delete nearest point to cursor." },
{ "X (eXit)   - leave subroutine." },
{ "" },
{ "" }
}
},
{
{ "pgnumb" }, {
{ "convert a number into a plottable character string" },
{ "Syntax" },
{ "      SUBROUTINE PGNUMB (MM, PP, FORM, STRING, NC)" },
{ "      INTEGER MM, PP, FORM" },
{ "      CHARACTER*(*) STRING" },
{ "      INTEGER NC" },
{ "" },
{ "This routine converts a number into a decimal character" },
{ "representation. To avoid problems of floating-point roundoff, the" },
{ "number must be provided as an integer (MM) multiplied by a power of 10" },
{ "(10**PP).  The output string retains only significant digits of MM," },
{ "and will be in either integer format (123), decimal format (0.0123)," },
{ "or exponential format (1.23x10**5). Standard escape sequences \\u, \\d " },
{ "raise the exponent and \\x is used for the multiplication sign." },
{ "This routine is used by PGBOX to create numeric labels for a plot." },
{ "" },
{ "Formatting rules:" },
{ "  (a) Decimal notation (FORM=1):" },
{ "      - Trailing zeros to the right of the decimal sign are" },
{ "        omitted" },
{ "      - The decimal sign is omitted if there are no digits" },
{ "        to the right of it" },
{ "      - When the decimal sign is placed before the first digit" },
{ "        of the number, a zero is placed before the decimal sign" },
{ "      - The decimal sign is a period (.)" },
{ "      - No spaces are placed between digits (ie digits are not" },
{ "        grouped in threes as they should be)" },
{ "      - A leading minus (-) is added if the number is negative" },
{ "  (b) Exponential notation (FORM=2):" },
{ "      - The exponent is adjusted to put just one (non-zero)" },
{ "        digit before the decimal sign" },
{ "      - The mantissa is formatted as in (a), unless its value is" },
{ "        1 in which case it and the multiplication sign are omitted" },
{ "      - If the power of 10 is not zero and the mantissa is not" },
{ "        zero, an exponent of the form \\x10\\u[-]nnn is appended," },
{ "        where \\x is a multiplication sign (cross), \\u is an escape" },
{ "        sequence to raise the exponent, and as many digits nnn" },
{ "        are used as needed" },
{ "  (c) Automatic choice (FORM=0):" },
{ "        Decimal notation is used if the absolute value of the" },
{ "        number is less than 10000 or greater than or equal to" },
{ "        0.01. Otherwise exponential notation is used." },
{ "" },
{ "Arguments:" },
{ " MM     (input)" },
{ " PP     (input)  : the value to be formatted is MM*10**PP." },
{ " FORM   (input)  : controls how the number is formatted:" },
{ "                   FORM = 0 -- use either decimal or exponential" },
{ "                   FORM = 1 -- use decimal notation" },
{ "                   FORM = 2 -- use exponential notation" },
{ " STRING (output) : the formatted character string, left justified." },
{ "                   If the length of STRING is insufficient, a single" },
{ "                   asterisk is returned, and NC=1." },
{ " NC     (output) : the number of characters used in STRING:" },
{ "                   the string to be printed is STRING(1:NC)." },
{ "" },
{ "" }
}
},
{
{ "pgolin" }, {
{ "mark a set of points using the cursor" },
{ "Syntax" },
{ "      SUBROUTINE PGOLIN (MAXPT, NPT, X, Y, SYMBOL)" },
{ "      INTEGER MAXPT, NPT" },
{ "      REAL    X(*), Y(*)" },
{ "      INTEGER SYMBOL" },
{ "" },
{ "Interactive routine for user to enter data points by use of" },
{ "the cursor.  Routine allows user to Add and Delete points.  The" },
{ "points are returned in the order that they were entered (unlike" },
{ "PGNCUR)." },
{ "" },
{ "Arguments:" },
{ " MAXPT  (input)  : maximum number of points that may be accepted." },
{ " NPT    (in/out) : number of points entered; should be zero on" },
{ "                   first call." },
{ " X      (in/out) : array of x-coordinates." },
{ " Y      (in/out) : array of y-coordinates." },
{ " SYMBOL (input)  : code number of symbol to use for marking" },
{ "                   entered points (see PGPT)." },
{ "" },
{ "Note (1): The dimension of arrays X and Y must be greater than or" },
{ "equal to MAXPT." },
{ "" },
{ "Note (2): On return from the program, cursor points are returned in" },
{ "the order they were entered. Routine may be (re-)called with points" },
{ "already defined in X,Y (number in NPT), and they will be plotted" },
{ "first, before editing." },
{ "" },
{ "Note (3): User commands: the user types single-character commands" },
{ "after positioning the cursor: the following are accepted:" },
{ "A (Add)    - add point at current cursor location." },
{ "D (Delete) - delete the last point entered." },
{ "X (eXit)   - leave subroutine." },
{ "" },
{ "" }
}
},
{
{ "pgpage" }, {
{ "advance to new page" },
{ "Syntax" },
{ "      SUBROUTINE PGPAGE" },
{ "" },
{ "Advance plotter to a new page or panel, clearing the screen if" },
{ "necessary. If the \"prompt state\" is ON (see PGASK), confirmation is" },
{ "requested from the user before clearing the screen. If the view" },
{ "surface has been subdivided into panels with PGBEG or PGSUBP, then" },
{ "PGPAGE advances to the next panel, and if the current panel is the" },
{ "last on the page, PGPAGE clears the screen or starts a new sheet of" },
{ "paper.  PGPAGE does not change the PGPLOT window or the viewport" },
{ "(in normalized device coordinates); but note that if the size of the" },
{ "view-surface is changed externally (e.g., by a workstation window" },
{ "manager) the size of the viewport is changed in proportion." },
{ "" },
{ "Arguments: none" },
{ "" },
{ "" }
}
},
{
{ "pgpanl" }, {
{ "switch to a different panel on the view surface" },
{ "Syntax" },
{ "      SUBROUTINE PGPANL(IX, IY)" },
{ "      INTEGER IX, IY" },
{ "" },
{ "Start plotting in a different panel. If the view surface has been" },
{ "divided into panels by PGBEG or PGSUBP, this routine can be used to" },
{ "move to a different panel. Note that PGPLOT does not remember what" },
{ "viewport and window were in use in each panel; these should be reset" },
{ "if necessary after calling PGPANL. Nor does PGPLOT clear the panel:" },
{ "call PGERAS after calling PGPANL to do this." },
{ "" },
{ "Arguments:" },
{ " IX     (input)  : the horizontal index of the panel (in the range" },
{ "                   1 &lt;= IX &lt;= number of panels in horizontal" },
{ "                   direction)." },
{ " IY     (input)  : the vertical index of the panel (in the range" },
{ "                   1 &lt;= IY &lt;= number of panels in horizontal" },
{ "                   direction)." },
{ "" },
{ "" }
}
},
{
{ "pgpap" }, {
{ "change the size of the view surface " },
{ "Syntax" },
{ "      SUBROUTINE PGPAP (WIDTH, ASPECT)" },
{ "      REAL WIDTH, ASPECT" },
{ "" },
{ "This routine changes the size of the view surface (\"paper size\") to a" },
{ "specified width and aspect ratio (height/width), in so far as this is" },
{ "possible on the specific device. It is always possible to obtain a" },
{ "view surface smaller than the default size; on some devices (e.g.," },
{ "printers that print on roll or fan-feed paper) it is possible to " },
{ "obtain a view surface larger than the default." },
{ "" },
{ "This routine should be called either immediately after PGBEG or" },
{ "immediately before PGPAGE. The new size applies to all subsequent" },
{ "images until the next call to PGPAP." },
{ "" },
{ "Arguments:" },
{ " WIDTH  (input)  : the requested width of the view surface in inches;" },
{ "                   if WIDTH=0.0, PGPAP will obtain the largest view" },
{ "                   surface available consistent with argument ASPECT." },
{ "                   (1 inch = 25.4 mm.)" },
{ " ASPECT (input)  : the aspect ratio (height/width) of the view" },
{ "                   surface; e.g., ASPECT=1.0 gives a square view" },
{ "                   surface, ASPECT=0.618 gives a horizontal" },
{ "                   rectangle, ASPECT=1.618 gives a vertical rectangle." },
{ "" },
{ "" }
}
},
{
{ "pgpixl" }, {
{ "draw pixels" },
{ "Syntax" },
{ "      SUBROUTINE PGPIXL (IA, IDIM, JDIM, I1, I2, J1, J2, " },
{ "     1                   X1, X2, Y1, Y2)" },
{ "      INTEGER IDIM, JDIM, I1, I2, J1, J2" },
{ "      INTEGER IA(IDIM,JDIM)" },
{ "      REAL    X1, X2, Y1, Y2" },
{ "" },
{ "Draw lots of solid-filled (tiny) rectangles aligned with the" },
{ "coordinate axes. Best performance is achieved when output is" },
{ "directed to a pixel-oriented device and the rectangles coincide" },
{ "with the pixels on the device. In other cases, pixel output is" },
{ "emulated." },
{ "" },
{ "The subsection of the array IA defined by indices (I1:I2, J1:J2)" },
{ "is mapped onto world-coordinate rectangle defined by X1, X2, Y1" },
{ "and Y2. This rectangle is divided into (I2 - I1 + 1) * (J2 - J1 + 1)" },
{ "small rectangles. Each of these small rectangles is solid-filled" },
{ "with the color index specified by the corresponding element of " },
{ "IA." },
{ "" },
{ "On most devices, the output region is \"opaque\", i.e., it obscures" },
{ "all graphical elements previously drawn in the region. But on" },
{ "devices that do not have erase capability, the background shade" },
{ "is \"transparent\" and allows previously-drawn graphics to show" },
{ "through." },
{ "" },
{ "Arguments:" },
{ " IA     (input)  : the array to be plotted." },
{ " IDIM   (input)  : the first dimension of array A." },
{ " JDIM   (input)  : the second dimension of array A." },
{ " I1, I2 (input)  : the inclusive range of the first index" },
{ "                   (I) to be plotted." },
{ " J1, J2 (input)  : the inclusive range of the second" },
{ "                   index (J) to be plotted." },
{ " X1, Y1 (input)  : world coordinates of one corner of the output" },
{ "                   region" },
{ " X2, Y2 (input)  : world coordinates of the opposite corner of the" },
{ "                   output region" },
{ "" },
{ "" }
}
},
{
{ "pgpnts" }, {
{ "draw several graph markers, not all the same" },
{ "Syntax" },
{ "      SUBROUTINE PGPNTS (N, X, Y, SYMBOL, NS)" },
{ "      INTEGER N, NS" },
{ "      REAL X(*), Y(*)" },
{ "      INTEGER SYMBOL(*)" },
{ "" },
{ "Draw Graph Markers. Unlike PGPT, this routine can draw a different" },
{ "symbol at each point. The markers are drawn using the current values" },
{ "of attributes color-index, line-width, and character-height" },
{ "(character-font applies if the symbol number is &gt;31).  If the point" },
{ "to be marked lies outside the window, no marker is drawn.  The \"pen " },
{ "position\" is changed to (XPTS(N),YPTS(N)) in world coordinates" },
{ "(if N &gt; 0)." },
{ "" },
{ "Arguments:" },
{ " N      (input)  : number of points to mark." },
{ " X      (input)  : world x-coordinate of the points." },
{ " Y      (input)  : world y-coordinate of the points." },
{ " SYMBOL (input)  : code number of the symbol to be plotted at each" },
{ "                   point (see PGPT)." },
{ " NS     (input)  : number of values in the SYMBOL array.  If NS &lt;= N," },
{ "                   then the first NS points are drawn using the value" },
{ "                   of SYMBOL(I) at (X(I), Y(I)) and SYMBOL(1) for all" },
{ "                   the values of (X(I), Y(I)) where I &gt; NS." },
{ "" },
{ "Note: the dimension of arrays X and Y must be greater than or equal" },
{ "to N and the dimension of the array SYMBOL must be greater than or" },
{ "equal to NS.  If N is 1, X and Y may be scalars (constants or" },
{ "variables).  If NS is 1, then SYMBOL may be a scalar.  If N is" },
{ "less than 1, nothing is drawn." },
{ "" },
{ "" }
}
},
{
{ "pgpoly" }, {
{ "draw a polygon, using fill-area attributes" },
{ "Syntax" },
{ "      SUBROUTINE PGPOLY (N, XPTS, YPTS)" },
{ "      INTEGER N" },
{ "      REAL XPTS(*), YPTS(*)" },
{ "" },
{ "Fill-area primitive routine: shade the interior of a closed" },
{ "polygon in the current window.  The action of this routine depends" },
{ "on the setting of the Fill-Area Style attribute (see PGSFS)." },
{ "The polygon is clipped at the edge of the" },
{ "window. The pen position is changed to (XPTS(1),YPTS(1)) in world" },
{ "coordinates (if N &gt; 1).  If the polygon is not convex, a point is" },
{ "assumed to lie inside the polygon if a straight line drawn to" },
{ "infinity intersects and odd number of the polygon's edges." },
{ "" },
{ "Arguments:" },
{ " N      (input)  : number of points defining the polygon; the" },
{ "                   line consists of N straight-line segments," },
{ "                   joining points 1 to 2, 2 to 3,... N-1 to N, N to 1." },
{ "                   N should be greater than 2 (if it is 2 or less," },
{ "                   nothing will be drawn)." },
{ " XPTS   (input)  : world x-coordinates of the vertices." },
{ " YPTS   (input)  : world y-coordinates of the vertices." },
{ "                   Note: the dimension of arrays XPTS and YPTS must be" },
{ "                   greater than or equal to N." },
{ "" },
{ "" }
}
},
{
{ "pgpt" }, {
{ "draw several graph markers" },
{ "Syntax" },
{ "      SUBROUTINE PGPT (N, XPTS, YPTS, SYMBOL)" },
{ "      INTEGER N" },
{ "      REAL XPTS(*), YPTS(*)" },
{ "      INTEGER SYMBOL" },
{ "" },
{ "Primitive routine to draw Graph Markers (polymarker). The markers" },
{ "are drawn using the current values of attributes color-index," },
{ "line-width, and character-height (character-font applies if the symbol" },
{ "number is &gt;31).  If the point to be marked lies outside the window," },
{ "no marker is drawn.  The \"pen position\" is changed to" },
{ "(XPTS(N),YPTS(N)) in world coordinates (if N &gt; 0)." },
{ "" },
{ "Arguments:" },
{ " N      (input)  : number of points to mark." },
{ " XPTS   (input)  : world x-coordinates of the points." },
{ " YPTS   (input)  : world y-coordinates of the points." },
{ " SYMBOL (input)  : code number of the symbol to be drawn at each " },
{ "                   point:" },
{ "                   -1, -2  : a single dot (diameter = current" },
{ "                             line width)." },
{ "                   -3..-31 : a regular polygon with ABS(SYMBOL)" },
{ "                             edges (style set by current fill style)." },
{ "                   0..31   : standard marker symbols." },
{ "                   32..127 : ASCII characters (in current font)." },
{ "                             e.g. to use letter F as a marker, let" },
{ "                             SYMBOL = ICHAR('F'). " },
{ "                   &gt; 127  :  a Hershey symbol number." },
{ "" },
{ "Note: the dimension of arrays X and Y must be greater than or equal" },
{ "to N. If N is 1, X and Y may be scalars (constants or variables). If" },
{ "N is less than 1, nothing is drawn." },
{ "" },
{ "" }
}
},
{
{ "pgpt1" }, {
{ "draw one graph marker" },
{ "Syntax" },
{ "      SUBROUTINE PGPT1 (XPT, YPT, SYMBOL)" },
{ "      REAL XPT, YPT" },
{ "      INTEGER SYMBOL" },
{ "" },
{ "Primitive routine to draw a single Graph Marker at a specified point." },
{ "The marker is drawn using the current values of attributes" },
{ "color-index, line-width, and character-height (character-font applies" },
{ "if the symbol number is &gt;31).  If the point to be marked lies outside" },
{ "the window, no marker is drawn.  The \"pen position\" is changed to" },
{ "(XPT,YPT) in world coordinates." },
{ "" },
{ "To draw several markers with coordinates specified by X and Y" },
{ "arrays, use routine PGPT." },
{ "" },
{ "Arguments:" },
{ " XPT    (input)  : world x-coordinate of the point." },
{ " YPT    (input)  : world y-coordinate of the point." },
{ " SYMBOL (input)  : code number of the symbol to be drawn:" },
{ "                   -1, -2  : a single dot (diameter = current" },
{ "                             line width)." },
{ "                   -3..-31 : a regular polygon with ABS(SYMBOL)" },
{ "                             edges (style set by current fill style)." },
{ "                   0..31   : standard marker symbols." },
{ "                   32..127 : ASCII characters (in current font)." },
{ "                             e.g. to use letter F as a marker, let" },
{ "                             SYMBOL = ICHAR('F'). " },
{ "                   &gt; 127  :  a Hershey symbol number." },
{ "" },
{ "" }
}
},
{
{ "pgptxt" }, {
{ "write text at arbitrary position and angle" },
{ "Syntax" },
{ "      SUBROUTINE PGPTXT (X, Y, ANGLE, FJUST, TEXT)" },
{ "      REAL X, Y, ANGLE, FJUST" },
{ "      CHARACTER*(*) TEXT" },
{ "" },
{ "Primitive routine for drawing text. The text may be drawn at any" },
{ "angle with the horizontal, and may be centered or left- or right-" },
{ "justified at a specified position.  Routine PGTEXT provides a" },
{ "simple interface to PGPTXT for horizontal strings. Text is drawn" },
{ "using the current values of attributes color-index, line-width," },
{ "character-height, and character-font.  Text is NOT subject to" },
{ "clipping at the edge of the window." },
{ "" },
{ "Arguments:" },
{ " X      (input)  : world x-coordinate." },
{ " Y      (input)  : world y-coordinate. The string is drawn with the" },
{ "                   baseline of all the characters passing through" },
{ "                   point (X,Y); the positioning of the string along" },
{ "                   this line is controlled by argument FJUST." },
{ " ANGLE  (input)  : angle, in degrees, that the baseline is to make" },
{ "                   with the horizontal, increasing counter-clockwise" },
{ "                   (0.0 is horizontal)." },
{ " FJUST  (input)  : controls horizontal justification of the string." },
{ "                   If FJUST = 0.0, the string will be left-justified" },
{ "                   at the point (X,Y); if FJUST = 0.5, it will be" },
{ "                   centered, and if FJUST = 1.0, it will be right" },
{ "                   justified. [Other values of FJUST give other" },
{ "                   justifications.]" },
{ " TEXT   (input)  : the character string to be plotted." },
{ "" },
{ "" }
}
},
{
{ "pgqah" }, {
{ "inquire arrow-head style" },
{ "Syntax" },
{ "      SUBROUTINE PGQAH (FS, ANGLE, BARB)" },
{ "      INTEGER  FS" },
{ "      REAL ANGLE, BARB" },
{ "" },
{ "Query the style to be used for arrowheads drawn with routine PGARRO." },
{ "" },
{ "Argument:" },
{ " FS     (output) : FS = 1 =&gt; filled; FS = 2 =&gt; outline." },
{ " ANGLE  (output) : the acute angle of the arrow point, in degrees." },
{ " BARB   (output) : the fraction of the triangular arrow-head that" },
{ "                   is cut away from the back. " },
{ "" },
{ "" }
}
},
{
{ "pgqcf" }, {
{ "inquire character font" },
{ "Syntax" },
{ "      SUBROUTINE PGQCF (FONT)" },
{ "      INTEGER  FONT" },
{ "" },
{ "Query the current Character Font (set by routine PGSCF)." },
{ "" },
{ "Argument:" },
{ " FONT   (output)   : the current font number (in range 1-4)." },
{ "" },
{ "" }
}
},
{
{ "pgqch" }, {
{ "inquire character height" },
{ "Syntax" },
{ "      SUBROUTINE PGQCH (SIZE)" },
{ "      REAL SIZE" },
{ "" },
{ "Query the Character Size attribute (set by routine PGSCH)." },
{ "" },
{ "Argument:" },
{ " SIZE   (output) : current character size (dimensionless multiple of" },
{ "                   the default size)." },
{ "" },
{ "" }
}
},
{
{ "pgqci" }, {
{ "inquire color index" },
{ "Syntax" },
{ "      SUBROUTINE PGQCI (CI)" },
{ "      INTEGER  CI" },
{ "" },
{ "Query the Color Index attribute (set by routine PGSCI)." },
{ "" },
{ "Argument:" },
{ " CI     (output) : the current color index (in range 0-max). This is" },
{ "                   the color index actually in use, and may differ" },
{ "                   from the color index last requested by PGSCI if" },
{ "                   that index is not available on the output device." },
{ "" },
{ "" }
}
},
{
{ "pgqcir" }, {
{ "inquire color index range" },
{ "Syntax" },
{ "      SUBROUTINE PGQCIR(ICILO, ICIHI)" },
{ "      INTEGER   ICILO, ICIHI" },
{ "" },
{ "Query the color index range to be used for producing images with" },
{ "PGGRAY or PGIMAG, as set by routine PGSCIR or by device default." },
{ "" },
{ "Arguments:" },
{ " ICILO  (output) : the lowest color index to use for images" },
{ " ICIHI  (output) : the highest color index to use for images" },
{ "" },
{ "" }
}
},
{
{ "pgqclp" }, {
{ "inquire clipping status" },
{ "Syntax" },
{ "      SUBROUTINE PGQCLP(STATE)" },
{ "      INTEGER  STATE" },
{ "" },
{ "Query the current clipping status (set by routine PGSCLP)." },
{ "" },
{ "Argument:" },
{ " STATE  (output) : receives the clipping status (0 =&gt; disabled," },
{ "                   1 =&gt; enabled)." },
{ "" },
{ "" }
}
},
{
{ "pgqcol" }, {
{ "inquire color capability" },
{ "Syntax" },
{ "      SUBROUTINE PGQCOL (CI1, CI2)" },
{ "      INTEGER  CI1, CI2" },
{ "" },
{ "Query the range of color indices available on the current device." },
{ "" },
{ "Argument:" },
{ " CI1    (output) : the minimum available color index. This will be" },
{ "                   either 0 if the device can write in the" },
{ "                   background color, or 1 if not." },
{ " CI2    (output) : the maximum available color index. This will be" },
{ "                   1 if the device has no color capability, or a" },
{ "                   larger number (e.g., 3, 7, 15, 255)." },
{ "" },
{ "" }
}
},
{
{ "pgqcr" }, {
{ "inquire color representation" },
{ "Syntax" },
{ "      SUBROUTINE PGQCR (CI, CR, CG, CB)" },
{ "      INTEGER CI" },
{ "      REAL    CR, CG, CB" },
{ "" },
{ "Query the RGB colors associated with a color index." },
{ "" },
{ "Arguments:" },
{ " CI  (input)  : color index" },
{ " CR  (output) : red, green and blue intensities" },
{ " CG  (output)   in the range 0.0 to 1.0" },
{ " CB  (output)" },
{ "" },
{ "" }
}
},
{
{ "pgqcs" }, {
{ "inquire character height in a variety of units" },
{ "Syntax" },
{ "      SUBROUTINE PGQCS(UNITS, XCH, YCH)" },
{ "      INTEGER UNITS" },
{ "      REAL XCH, YCH" },
{ "" },
{ "Return the current PGPLOT character height in a variety of units." },
{ "This routine provides facilities that are not available via PGQCH." },
{ "Use PGQCS if the character height is required in units other than" },
{ "those used in PGSCH." },
{ "" },
{ "The PGPLOT \"character height\" is a dimension that scales with the" },
{ "size of the view surface and with the scale-factor specified with" },
{ "routine PGSCH. The default value is 1/40th of the height or width" },
{ "of the view surface (whichever is less); this value is then" },
{ "multiplied by the scale-factor supplied with PGSCH. Note that it" },
{ "is a nominal height only; the actual character size depends on the" },
{ "font and is usually somewhat smaller." },
{ "" },
{ "Arguments:" },
{ " UNITS  (input)  : Used to specify the units of the output value:" },
{ "                   UNITS = 0 : normalized device coordinates" },
{ "                   UNITS = 1 : inches" },
{ "                   UNITS = 2 : millimeters" },
{ "                   UNITS = 3 : pixels" },
{ "                   UNITS = 4 : world coordinates" },
{ "                   Other values give an error message, and are" },
{ "                   treated as 0." },
{ " XCH    (output) : The character height for text written with a" },
{ "                   vertical baseline." },
{ " YCH    (output) : The character height for text written with" },
{ "                   a horizontal baseline (the usual case)." },
{ "" },
{ "The character height is returned in both XCH and YCH." },
{ "" },
{ "If UNITS=1 or UNITS=2, XCH and YCH both receive the same value." },
{ "" },
{ "If UNITS=3, XCH receives the height in horizontal pixel units, and YCH" },
{ "receives the height in vertical pixel units; on devices for which the" },
{ "pixels are not square, XCH and YCH will be different." },
{ "" },
{ "If UNITS=4, XCH receives the height in horizontal world coordinates" },
{ "(as used for the x-axis), and YCH receives the height in vertical" },
{ "world coordinates (as used for the y-axis). Unless special care has" },
{ "been taken to achive equal world-coordinate scales on both axes, the" },
{ "values of XCH and YCH will be different." },
{ "" },
{ "If UNITS=0, XCH receives the character height as a fraction of the" },
{ "horizontal dimension of the view surface, and YCH receives the" },
{ "character height as a fraction of the vertical dimension of the view" },
{ "surface." },
{ "" },
{ "" }
}
},
{
{ "pgqdt" }, {
{ "inquire name of nth available device type" },
{ "Syntax" },
{ "      SUBROUTINE PGQDT(N, TYPE, TLEN, DESCR, DLEN, INTER)" },
{ "      INTEGER N" },
{ "      CHARACTER*(*) TYPE, DESCR" },
{ "      INTEGER TLEN, DLEN, INTER" },
{ "" },
{ "Return the name of the Nth available device type as a character" },
{ "string. The number of available types can be determined by calling" },
{ "PGQNDT. If the value of N supplied is outside the range from 1 to" },
{ "the number of available types, the routine returns DLEN=TLEN=0." },
{ "" },
{ "Arguments:" },
{ " N      (input)  : the number of the device type (1..maximum)." },
{ " TYPE   (output) : receives the character device-type code of the" },
{ "                   Nth device type. The argument supplied should be" },
{ "                   large enough for at least 8 characters. The first" },
{ "                   character in the string is a '/' character." },
{ " TLEN   (output) : receives the number of characters in TYPE," },
{ "                   excluding trailing blanks." },
{ " DESCR  (output) : receives a description of the device type. The" },
{ "                   argument supplied should be large enough for at" },
{ "                   least 64 characters." },
{ " DLEN   (output) : receives the number of characters in DESCR," },
{ "                   excluding trailing blanks." },
{ " INTER  (output) : receives 1 if the device type is an interactive" },
{ "                   one, 0 otherwise." },
{ "" },
{ "" }
}
},
{
{ "pgqfs" }, {
{ "inquire fill-area style" },
{ "Syntax" },
{ "      SUBROUTINE PGQFS (FS)" },
{ "      INTEGER  FS" },
{ "" },
{ "Query the current Fill-Area Style attribute (set by routine" },
{ "PGSFS)." },
{ "" },
{ "Argument:" },
{ " FS     (output) : the current fill-area style:" },
{ "                     FS = 1 =&gt; solid (default)" },
{ "                     FS = 2 =&gt; outline" },
{ "                     FS = 3 =&gt; hatched" },
{ "                     FS = 4 =&gt; cross-hatched" },
{ "" },
{ "" }
}
},
{
{ "pgqhs" }, {
{ "inquire hatching style" },
{ "Syntax" },
{ "      SUBROUTINE PGQHS (ANGLE, SEPN, PHASE)" },
{ "      REAL ANGLE, SEPN, PHASE" },
{ "" },
{ "Query the style to be used hatching (fill area with fill-style 3)." },
{ "" },
{ "Arguments:" },
{ " ANGLE  (output) : the angle the hatch lines make with the" },
{ "                   horizontal, in degrees, increasing " },
{ "                   counterclockwise (this is an angle on the" },
{ "                   view surface, not in world-coordinate space)." },
{ " SEPN   (output) : the spacing of the hatch lines. The unit spacing" },
{ "                   is 1 percent of the smaller of the height or" },
{ "                   width of the view surface." },
{ " PHASE  (output) : a real number between 0 and 1; the hatch lines" },
{ "                   are displaced by this fraction of SEPN from a" },
{ "                   fixed reference.  Adjacent regions hatched with the" },
{ "                   same PHASE have contiguous hatch lines." },
{ "" },
{ "" }
}
},
{
{ "pgqid" }, {
{ "inquire current device identifier" },
{ "Syntax" },
{ "      SUBROUTINE PGQID (ID)" },
{ "      INTEGER  ID" },
{ "" },
{ "This subroutine returns the identifier of the currently" },
{ "selected device, or 0 if no device is selected.  The identifier is" },
{ "assigned when PGOPEN is called to open the device, and may be used" },
{ "as an argument to PGSLCT.  Each open device has a different" },
{ "identifier." },
{ "" },
{ "[This routine was added to PGPLOT in Version 5.1.0.]" },
{ "" },
{ "Argument:" },
{ " ID     (output) : the identifier of the current device, or 0 if" },
{ "                   no device is currently selected." },
{ "" },
{ "" }
}
},
{
{ "pgqinf" }, {
{ "inquire PGPLOT general information" },
{ "Syntax" },
{ "      SUBROUTINE PGQINF (ITEM, VALUE, LENGTH)" },
{ "      CHARACTER*(*) ITEM, VALUE" },
{ "      INTEGER LENGTH" },
{ "" },
{ "This routine can be used to obtain miscellaneous information about" },
{ "the PGPLOT environment. Input is a character string defining the" },
{ "information required, and output is a character string containing the" },
{ "requested information." },
{ "" },
{ "The following item codes are accepted (note that the strings must" },
{ "match exactly, except for case, but only the first 8 characters are" },
{ "significant). For items marked *, PGPLOT must be in the OPEN state" },
{ "for the inquiry to succeed. If the inquiry is unsuccessful, either" },
{ "because the item code is not recognized or because the information" },
{ "is not available, a question mark ('?') is returned." },
{ "" },
{ "  'VERSION'     - version of PGPLOT software in use." },
{ "  'STATE'       - status of PGPLOT ('OPEN' if a graphics device" },
{ "                  is open for output, 'CLOSED' otherwise)." },
{ "  'USER'        - the username associated with the calling program." },
{ "  'NOW'         - current date and time (e.g., '17-FEB-1986 10:04')." },
{ "  'DEVICE'    * - current PGPLOT device or file." },
{ "  'FILE'      * - current PGPLOT device or file." },
{ "  'TYPE'      * - device-type of the current PGPLOT device." },
{ "  'DEV/TYPE'  * - current PGPLOT device and type, in a form which" },
{ "                  is acceptable as an argument for PGBEG." },
{ "  'HARDCOPY'  * - is the current device a hardcopy device? ('YES' or" },
{ "                  'NO')." },
{ "  'TERMINAL'  * - is the current device the user's interactive" },
{ "                  terminal? ('YES' or 'NO')." },
{ "  'CURSOR'    * - does the current device have a graphics cursor?" },
{ "                  ('YES' or 'NO')." },
{ "  'SCROLL'    * - does current device have rectangle-scroll" },
{ "                  capability ('YES' or 'NO'); see PGSCRL." },
{ "" },
{ "Arguments:" },
{ " ITEM  (input)  : character string defining the information to" },
{ "                  be returned; see above for a list of possible" },
{ "                  values." },
{ " VALUE (output) : returns a character-string containing the" },
{ "                  requested information, truncated to the length " },
{ "                  of the supplied string or padded on the right with " },
{ "                  spaces if necessary." },
{ " LENGTH (output): the number of characters returned in VALUE" },
{ "                  (excluding trailing blanks)." },
{ "" },
{ "" }
}
},
{
{ "pgqitf" }, {
{ "inquire image transfer function" },
{ "Syntax" },
{ "      SUBROUTINE PGQITF (ITF)" },
{ "      INTEGER  ITF" },
{ "" },
{ "Return the Image Transfer Function as set by default or by a previous" },
{ "call to PGSITF. The Image Transfer Function is used by routines" },
{ "PGIMAG, PGGRAY, and PGWEDG." },
{ "" },
{ "Argument:" },
{ " ITF    (output) : type of transfer function (see PGSITF)" },
{ "" },
{ "" }
}
},
{
{ "pgqls" }, {
{ "inquire line style" },
{ "Syntax" },
{ "      SUBROUTINE PGQLS (LS)" },
{ "      INTEGER  LS" },
{ "" },
{ "Query the current Line Style attribute (set by routine PGSLS)." },
{ "" },
{ "Argument:" },
{ " LS     (output) : the current line-style attribute (in range 1-5)." },
{ "" },
{ "" }
}
},
{
{ "pgqlw" }, {
{ "inquire line width" },
{ "Syntax" },
{ "      SUBROUTINE PGQLW (LW)" },
{ "      INTEGER  LW" },
{ "" },
{ "Query the current Line-Width attribute (set by routine PGSLW)." },
{ "" },
{ "Argument:" },
{ " LW     (output)  : the line-width (in range 1-201)." },
{ "" },
{ "" }
}
},
{
{ "pgqndt" }, {
{ "inquire number of available device types" },
{ "Syntax" },
{ "      SUBROUTINE PGQNDT(N)" },
{ "      INTEGER N" },
{ "" },
{ "Return the number of available device types. This routine is" },
{ "usually used in conjunction with PGQDT to get a list of the" },
{ "available device types." },
{ "" },
{ "Arguments:" },
{ " N      (output) : the number of available device types." },
{ "" },
{ "" }
}
},
{
{ "pgqpos" }, {
{ "inquire current pen position" },
{ "Syntax" },
{ "      SUBROUTINE PGQPOS (X, Y)" },
{ "      REAL X, Y" },
{ "" },
{ "Query the current \"pen\" position in world C coordinates (X,Y)." },
{ "" },
{ "Arguments:" },
{ " X      (output)  : world x-coordinate of the pen position." },
{ " Y      (output)  : world y-coordinate of the pen position." },
{ "" },
{ "" }
}
},
{
{ "pgqtbg" }, {
{ "inquire text background color index" },
{ "Syntax" },
{ "      SUBROUTINE PGQTBG (TBCI)" },
{ "      INTEGER  TBCI" },
{ "" },
{ "Query the current Text Background Color Index (set by routine" },
{ "PGSTBG)." },
{ "" },
{ "Argument:" },
{ " TBCI   (output) : receives the current text background color index." },
{ "" },
{ "" }
}
},
{
{ "pgqtxt" }, {
{ "find bounding box of text string" },
{ "Syntax" },
{ "      SUBROUTINE PGQTXT (X, Y, ANGLE, FJUST, TEXT, XBOX, YBOX)" },
{ "      REAL X, Y, ANGLE, FJUST" },
{ "      CHARACTER*(*) TEXT" },
{ "      REAL XBOX(4), YBOX(4)" },
{ "" },
{ "This routine returns a bounding box for a text string. Instead" },
{ "of drawing the string as routine PGPTXT does, it returns in XBOX" },
{ "and YBOX the coordinates of the corners of a rectangle parallel" },
{ "to the string baseline that just encloses the string. The four" },
{ "corners are in the order: lower left, upper left, upper right," },
{ "lower right (where left and right refer to the first and last" },
{ "characters in the string)." },
{ "" },
{ "If the string is blank or contains no drawable characters, all" },
{ "four elements of XBOX and YBOX are assigned the starting point" },
{ "of the string, (X,Y)." },
{ "" },
{ "Arguments:" },
{ " X, Y, ANGLE, FJUST, TEXT (input) : these arguments are the same as" },
{ "                   the corrresponding arguments in PGPTXT." },
{ " XBOX, YBOX (output) : arrays of dimension 4; on output, they" },
{ "                   contain the world coordinates of the bounding" },
{ "                   box in (XBOX(1), YBOX(1)), ..., (XBOX(4), YBOX(4))." },
{ "" },
{ "" }
}
},
{
{ "pgqvp" }, {
{ "inquire viewport size and position" },
{ "Syntax" },
{ "      SUBROUTINE PGQVP (UNITS, X1, X2, Y1, Y2)" },
{ "      INTEGER UNITS" },
{ "      REAL    X1, X2, Y1, Y2" },
{ "" },
{ "Inquiry routine to determine the current viewport setting." },
{ "The values returned may be normalized device coordinates, inches, mm," },
{ "or pixels, depending on the value of the input parameter CFLAG." },
{ "" },
{ "Arguments:" },
{ " UNITS  (input)  : used to specify the units of the output parameters:" },
{ "                   UNITS = 0 : normalized device coordinates" },
{ "                   UNITS = 1 : inches" },
{ "                   UNITS = 2 : millimeters" },
{ "                   UNITS = 3 : pixels" },
{ "                   Other values give an error message, and are" },
{ "                   treated as 0." },
{ " X1     (output) : the x-coordinate of the bottom left corner of the" },
{ "                   viewport." },
{ " X2     (output) : the x-coordinate of the top right corner of the" },
{ "                   viewport." },
{ " Y1     (output) : the y-coordinate of the bottom left corner of the" },
{ "                   viewport." },
{ " Y2     (output) : the y-coordinate of the top right corner of the" },
{ "                   viewport." },
{ "" },
{ "" }
}
},
{
{ "pgqvsz" }, {
{ "inquire size of view surface" },
{ "Syntax" },
{ "      SUBROUTINE PGQVSZ (UNITS, X1, X2, Y1, Y2)" },
{ "      INTEGER UNITS" },
{ "      REAL X1, X2, Y1, Y2" },
{ "" },
{ "This routine returns the dimensions of the view surface (the maximum" },
{ "plottable area) of the currently selected graphics device, in " },
{ "a variety of units. The size of the view surface is device-dependent" },
{ "and is established when the graphics device is opened. On some " },
{ "devices, it can be changed by calling PGPAP before starting a new" },
{ "page with PGPAGE. On some devices, the size can be changed (e.g.," },
{ "by a workstation window manager) outside PGPLOT, and PGPLOT detects" },
{ "the change when PGPAGE is used. Call this routine after PGPAGE to " },
{ "find the current size." },
{ "" },
{ "Note 1: the width and the height of the view surface in normalized" },
{ "device coordinates are both always equal to 1.0." },
{ "" },
{ "Note 2: when the device is divided into panels (see PGSUBP), the" },
{ "view surface is a single panel." },
{ "" },
{ "Arguments:" },
{ " UNITS  (input)  : 0,1,2,3 for output in normalized device coords, " },
{ "                   inches, mm, or device units (pixels)" },
{ " X1     (output) : always returns 0.0" },
{ " X2     (output) : width of view surface" },
{ " Y1     (output) : always returns 0.0" },
{ " Y2     (output) : height of view surface" },
{ "" },
{ "" }
}
},
{
{ "pgqwin" }, {
{ "inquire window boundary coordinates" },
{ "Syntax" },
{ "      SUBROUTINE PGQWIN (X1, X2, Y1, Y2)" },
{ "      REAL X1, X2, Y1, Y2" },
{ "" },
{ "Inquiry routine to determine the current window setting." },
{ "The values returned are world coordinates." },
{ "" },
{ "Arguments:" },
{ " X1     (output) : the x-coordinate of the bottom left corner" },
{ "                   of the window." },
{ " X2     (output) : the x-coordinate of the top right corner" },
{ "                   of the window." },
{ " Y1     (output) : the y-coordinate of the bottom left corner" },
{ "                   of the window." },
{ " Y2     (output) : the y-coordinate of the top right corner" },
{ "                   of the window." },
{ "" },
{ "" }
}
},
{
{ "pgrect" }, {
{ "draw a rectangle, using fill-area attributes" },
{ "Syntax" },
{ "      SUBROUTINE PGRECT (X1, X2, Y1, Y2)" },
{ "      REAL X1, X2, Y1, Y2" },
{ "" },
{ "This routine can be used instead of PGPOLY for the special case of" },
{ "drawing a rectangle aligned with the coordinate axes; only two" },
{ "vertices need be specified instead of four.  On most devices, it is" },
{ "faster to use PGRECT than PGPOLY for drawing rectangles.  The" },
{ "rectangle has vertices at (X1,Y1), (X1,Y2), (X2,Y2), and (X2,Y1)." },
{ "" },
{ "Arguments:" },
{ " X1, X2 (input) : the horizontal range of the rectangle." },
{ " Y1, Y2 (input) : the vertical range of the rectangle." },
{ "" },
{ "" }
}
},
{
{ "pgrnge" }, {
{ "choose axis limits" },
{ "Syntax" },
{ "      SUBROUTINE PGRNGE (X1, X2, XLO, XHI)" },
{ "      REAL X1, X2, XLO, XHI" },
{ "" },
{ "Choose plotting limits XLO and XHI which encompass the data" },
{ "range X1 to X2." },
{ "" },
{ "Arguments:" },
{ " X1, X2 (input)  : the data range (X1&lt;X2), ie, the min and max values" },
{ "                   to be plotted." },
{ " XLO, XHI (output) : suitable values to use as the extremes of a graph" },
{ "                   axis (XLO &lt;= X1, XHI &gt;= X2)." },
{ "" },
{ "" }
}
},
{
{ "pgsah" }, {
{ "set arrow-head style" },
{ "Syntax" },
{ "      SUBROUTINE PGSAH (FS, ANGLE, BARB)" },
{ "      INTEGER  FS" },
{ "      REAL ANGLE, BARB" },
{ "" },
{ "Set the style to be used for arrowheads drawn with routine PGARRO." },
{ "" },
{ "Argument:" },
{ " FS     (input)  : FS = 1 =&gt; filled; FS = 2 =&gt; outline." },
{ "                   Other values are treated as 2. Default 1." },
{ " ANGLE  (input)  : the acute angle of the arrow point, in degrees;" },
{ "                   angles in the range 20.0 to 90.0 give reasonable" },
{ "                   results. Default 45.0." },
{ " BARB   (input)  : the fraction of the triangular arrow-head that" },
{ "                   is cut away from the back. 0.0 gives a triangular" },
{ "                   wedge arrow-head; 1.0 gives an open &gt;. Values 0.3" },
{ "                   to 0.7 give reasonable results. Default 0.3." },
{ "" },
{ "" }
}
},
{
{ "pgsave" }, {
{ "save PGPLOT attributes" },
{ "Syntax" },
{ "      SUBROUTINE PGSAVE" },
{ "" },
{ "This routine saves the current PGPLOT attributes in a private storage" },
{ "area. They can be restored by calling PGUNSA (unsave). Attributes" },
{ "saved are: character font, character height, color index, fill-area" },
{ "style, line style, line width, pen position, arrow-head style, " },
{ "hatching style, and clipping state. Color representation is not saved." },
{ "" },
{ "Calls to PGSAVE and PGUNSA should always be paired. Up to 20 copies" },
{ "of the attributes may be saved. PGUNSA always retrieves the last-saved" },
{ "values (last-in first-out stack)." },
{ "" },
{ "Note that when multiple devices are in use, PGUNSA retrieves the" },
{ "values saved by the last PGSAVE call, even if they were for a" },
{ "different device." },
{ "" },
{ "Arguments: none" },
{ "" },
{ "" }
}
},
{
{ "pgscf" }, {
{ "set character font" },
{ "Syntax" },
{ "      SUBROUTINE PGSCF (FONT)" },
{ "      INTEGER  FONT" },
{ "" },
{ "Set the Character Font for subsequent text plotting. Four different" },
{ "fonts are available:" },
{ "  1: (default) a simple single-stroke font (\"normal\" font)" },
{ "  2: roman font" },
{ "  3: italic font" },
{ "  4: script font" },
{ "This call determines which font is in effect at the beginning of" },
{ "each text string. The font can be changed (temporarily) within a text" },
{ "string by using the escape sequences \\fn, \\fr, \\fi, and \\fs for fonts" },
{ "1, 2, 3, and 4, respectively." },
{ "" },
{ "Argument:" },
{ " FONT   (input)  : the font number to be used for subsequent text" },
{ "                   plotting (in range 1-4)." },
{ "" },
{ "" }
}
},
{
{ "pgsch" }, {
{ "set character height" },
{ "Syntax" },
{ "      SUBROUTINE PGSCH (SIZE)" },
{ "      REAL SIZE" },
{ "" },
{ "Set the character size attribute. The size affects all text and graph" },
{ "markers drawn later in the program. The default character size is" },
{ "1.0, corresponding to a character height about 1/40 the height of" },
{ "the view surface.  Changing the character size also scales the length" },
{ "of tick marks drawn by PGBOX and terminals drawn by PGERRX and PGERRY." },
{ "" },
{ "Argument:" },
{ " SIZE   (input)  : new character size (dimensionless multiple of" },
{ "                   the default size)." },
{ "" },
{ "" }
}
},
{
{ "pgsci" }, {
{ "set color index" },
{ "Syntax" },
{ "      SUBROUTINE PGSCI (CI)" },
{ "      INTEGER  CI" },
{ "" },
{ "Set the Color Index for subsequent plotting, if the output device" },
{ "permits this. The default color index is 1, usually white on a black" },
{ "background for video displays or black on a white background for" },
{ "printer plots. The color index is an integer in the range 0 to a" },
{ "device-dependent maximum. Color index 0 corresponds to the background" },
{ "color; lines may be \"erased\" by overwriting them with color index 0" },
{ "(if the device permits this)." },
{ "" },
{ "If the requested color index is not available on the selected device," },
{ "color index 1 will be substituted." },
{ "" },
{ "The assignment of colors to color indices can be changed with" },
{ "subroutine PGSCR (set color representation).  Color indices 0-15" },
{ "have predefined color representations (see the PGPLOT manual), but" },
{ "these may be changed with PGSCR.  Color indices above 15  have no" },
{ "predefined representations: if these indices are used, PGSCR must" },
{ "be called to define the representation." },
{ "" },
{ "Argument:" },
{ " CI     (input)  : the color index to be used for subsequent plotting" },
{ "                   on the current device (in range 0-max). If the" },
{ "                   index exceeds the device-dependent maximum, the" },
{ "                   default color index (1) is used." },
{ "" },
{ "" }
}
},
{
{ "pgscir" }, {
{ "set color index range" },
{ "Syntax" },
{ "      SUBROUTINE PGSCIR(ICILO, ICIHI)" },
{ "      INTEGER   ICILO, ICIHI" },
{ "" },
{ "Set the color index range to be used for producing images with" },
{ "PGGRAY or PGIMAG. If the range is not all within the range supported" },
{ "by the device, a smaller range will be used. The number of" },
{ "different colors available for images is ICIHI-ICILO+1." },
{ "" },
{ "Arguments:" },
{ " ICILO  (input)  : the lowest color index to use for images" },
{ " ICIHI  (input)  : the highest color index to use for images" },
{ "" },
{ "" }
}
},
{
{ "pgsclp" }, {
{ "enable or disable clipping at edge of viewport" },
{ "Syntax" },
{ "      SUBROUTINE PGSCLP(STATE)" },
{ "      INTEGER STATE" },
{ "" },
{ "Normally all PGPLOT primitives except text are ``clipped'' at the" },
{ "edge of the viewport: parts of the primitives that lie outside" },
{ "the viewport are not drawn. If clipping is disabled by calling this" },
{ "routine, primitives are visible wherever they lie on the view" },
{ "surface. The default (clipping enabled) is appropriate for almost" },
{ "all applications." },
{ "" },
{ "Argument:" },
{ " STATE  (input)  : 0 to disable clipping, or 1 to enable clipping." },
{ "" },
{ "25-Feb-1997 [TJP] - new routine." },
{ "" },
{ "" }
}
},
{
{ "pgscr" }, {
{ "set color representation" },
{ "Syntax" },
{ "      SUBROUTINE PGSCR (CI, CR, CG, CB)" },
{ "      INTEGER CI" },
{ "      REAL    CR, CG, CB" },
{ "" },
{ "Set color representation: i.e., define the color to be" },
{ "associated with a color index.  Ignored for devices which do not" },
{ "support variable color or intensity.  Color indices 0-15" },
{ "have predefined color representations (see the PGPLOT manual), but" },
{ "these may be changed with PGSCR.  Color indices 16-maximum have no" },
{ "predefined representations: if these indices are used, PGSCR must" },
{ "be called to define the representation. On monochrome output" },
{ "devices (e.g. VT125 terminals with monochrome monitors), the" },
{ "monochrome intensity is computed from the specified Red, Green, Blue" },
{ "intensities as 0.30*R + 0.59*G + 0.11*B, as in US color television" },
{ "systems, NTSC encoding.  Note that most devices do not have an" },
{ "infinite range of colors or monochrome intensities available;" },
{ "the nearest available color is used.  Examples: for black," },
{ "set CR=CG=CB=0.0; for white, set CR=CG=CB=1.0; for medium gray," },
{ "set CR=CG=CB=0.5; for medium yellow, set CR=CG=0.5, CB=0.0." },
{ "" },
{ "Argument:" },
{ " CI     (input)  : the color index to be defined, in the range 0-max." },
{ "                   If the color index greater than the device" },
{ "                   maximum is specified, the call is ignored. Color" },
{ "                   index 0 applies to the background color." },
{ " CR     (input)  : red, green, and blue intensities," },
{ " CG     (input)    in range 0.0 to 1.0." },
{ " CB     (input)" },
{ "" },
{ "" }
}
},
{
{ "pgscrl" }, {
{ "scroll window" },
{ "Syntax" },
{ "      SUBROUTINE PGSCRL (DX, DY)" },
{ "      REAL DX, DY" },
{ "" },
{ "This routine moves the window in world-coordinate space while" },
{ "leaving the viewport unchanged. On devices that have the" },
{ "capability, the pixels within the viewport are scrolled" },
{ "horizontally, vertically or both in such a way that graphics" },
{ "previously drawn in the window are shifted so that their world" },
{ "coordinates are unchanged." },
{ "" },
{ "If the old window coordinate range was (X1, X2, Y1, Y2), the new" },
{ "coordinate range will be approximately (X1+DX, X2+DX, Y1+DY, Y2+DY)." },
{ "The size and scale of the window are unchanged." },
{ "" },
{ "Thee window can only be shifted by a whole number of pixels" },
{ "(device coordinates). If DX and DY do not correspond to integral" },
{ "numbers of pixels, the shift will be slightly different from that" },
{ "requested. The new window-coordinate range, and hence the exact" },
{ "amount of the shift, can be determined by calling PGQWIN after this" },
{ "routine." },
{ "" },
{ "Pixels that are moved out of the viewport by this operation are" },
{ "lost completely; they cannot be recovered by scrolling back." },
{ "Pixels that are ``scrolled into'' the viewport are filled with" },
{ "the background color (color index 0)." },
{ "" },
{ "If the absolute value of DX is bigger than the width of the window," },
{ "or the aboslute value of DY is bigger than the height of the window," },
{ "the effect will be the same as zeroing all the pixels in the" },
{ "viewport." },
{ "" },
{ "Not all devices have the capability to support this routine." },
{ "It is only available on some interactive devices that have discrete" },
{ "pixels. To determine whether the current device has scroll capability," },
{ "call PGQINF." },
{ "" },
{ "Arguments:" },
{ " DX     (input)  : distance (in world coordinates) to shift the" },
{ "                   window horizontally (positive shifts window to the" },
{ "                   right and scrolls to the left)." },
{ " DY     (input)  : distance (in world coordinates) to shift the" },
{ "                   window vertically (positive shifts window up and" },
{ "                   scrolls down)." },
{ "" },
{ "" }
}
},
{
{ "pgscrn" }, {
{ "set color representation by name" },
{ "Syntax" },
{ "      SUBROUTINE PGSCRN(CI, NAME, IER)" },
{ "      INTEGER CI" },
{ "      CHARACTER*(*) NAME" },
{ "      INTEGER IER" },
{ "" },
{ "Set color representation: i.e., define the color to be" },
{ "associated with a color index.  Ignored for devices which do not" },
{ "support variable color or intensity.  This is an alternative to" },
{ "routine PGSCR. The color representation is defined by name instead" },
{ "of (R,G,B) components." },
{ "" },
{ "Color names are defined in an external file which is read the first" },
{ "time that PGSCRN is called. The name of the external file is" },
{ "found as follows:" },
{ "1. if environment variable (logical name) PGPLOT_RGB is defined," },
{ "   its value is used as the file name;" },
{ "2. otherwise, if environment variable PGPLOT_DIR is defined, a" },
{ "   file \"rgb.txt\" in the directory named by this environment" },
{ "   variable is used;" },
{ "3. otherwise, file \"rgb.txt\" in the current directory is used." },
{ "If all of these fail to find a file, an error is reported and" },
{ "the routine does nothing." },
{ "" },
{ "Each line of the file" },
{ "defines one color, with four blank- or tab-separated fields per" },
{ "line. The first three fields are the R, G, B components, which" },
{ "are integers in the range 0 (zero intensity) to 255 (maximum" },
{ "intensity). The fourth field is the color name. The color name" },
{ "may include embedded blanks. Example:" },
{ "" },
{ "255   0   0 red" },
{ "255 105 180 hot pink" },
{ "255 255 255 white" },
{ "  0   0   0 black" },
{ "" },
{ "Arguments:" },
{ " CI     (input)  : the color index to be defined, in the range 0-max." },
{ "                   If the color index greater than the device" },
{ "                   maximum is specified, the call is ignored. Color" },
{ "                   index 0 applies to the background color." },
{ " NAME   (input)  : the name of the color to be associated with" },
{ "                   this color index. This name must be in the" },
{ "                   external file. The names are not case-sensitive." },
{ "                   If the color is not listed in the file, the" },
{ "                   color representation is not changed." },
{ " IER    (output) : returns 0 if the routine was successful, 1" },
{ "                   if an error occurred (either the external file" },
{ "                   could not be read, or the requested color was" },
{ "                   not defined in the file)." },
{ "" },
{ "" }
}
},
{
{ "pgsfs" }, {
{ "set fill-area style" },
{ "Syntax" },
{ "      SUBROUTINE PGSFS (FS)" },
{ "      INTEGER  FS" },
{ "" },
{ "Set the Fill-Area Style attribute for subsequent area-fill by" },
{ "PGPOLY, PGRECT, or PGCIRC.  Four different styles are available: " },
{ "solid (fill polygon with solid color of the current color-index), " },
{ "outline (draw outline of polygon only, using current line attributes)," },
{ "hatched (shade interior of polygon with parallel lines, using" },
{ "current line attributes), or cross-hatched. The orientation and" },
{ "spacing of hatch lines can be specified with routine PGSHS (set" },
{ "hatch style)." },
{ "" },
{ "Argument:" },
{ " FS     (input)  : the fill-area style to be used for subsequent" },
{ "                   plotting:" },
{ "                     FS = 1 =&gt; solid (default)" },
{ "                     FS = 2 =&gt; outline" },
{ "                     FS = 3 =&gt; hatched" },
{ "                     FS = 4 =&gt; cross-hatched" },
{ "                   Other values give an error message and are" },
{ "                   treated as 2." },
{ "" },
{ "" }
}
},
{
{ "pgshls" }, {
{ "set color representation using HLS system" },
{ "Syntax" },
{ "      SUBROUTINE PGSHLS (CI, CH, CL, CS)" },
{ "      INTEGER CI" },
{ "      REAL    CH, CL, CS" },
{ "" },
{ "Set color representation: i.e., define the color to be" },
{ "associated with a color index.  This routine is equivalent to" },
{ "PGSCR, but the color is defined in the Hue-Lightness-Saturation" },
{ "model instead of the Red-Green-Blue model. Hue is represented" },
{ "by an angle in degrees, with red at 120, green at 240," },
{ "and blue at 0 (or 360). Lightness ranges from 0.0 to 1.0, with black" },
{ "at lightness 0.0 and white at lightness 1.0. Saturation ranges from" },
{ "0.0 (gray) to 1.0 (pure color). Hue is irrelevant when saturation" },
{ "is 0.0." },
{ "" },
{ "Examples:           H     L     S        R     G     B" },
{ "    black          any   0.0   0.0      0.0   0.0   0.0" },
{ "    white          any   1.0   0.0      1.0   1.0   1.0" },
{ "    medium gray    any   0.5   0.0      0.5   0.5   0.5" },
{ "    red            120   0.5   1.0      1.0   0.0   0.0" },
{ "    yellow         180   0.5   1.0      1.0   1.0   0.0" },
{ "    pink           120   0.7   0.8      0.94  0.46  0.46" },
{ "" },
{ "Reference: SIGGRAPH Status Report of the Graphic Standards Planning" },
{ "Committee, Computer Graphics, Vol.13, No.3, Association for" },
{ "Computing Machinery, New York, NY, 1979. See also: J. D. Foley et al," },
{ "``Computer Graphics: Principles and Practice'', second edition," },
{ "Addison-Wesley, 1990, section 13.3.5." },
{ "" },
{ "Argument:" },
{ " CI     (input)  : the color index to be defined, in the range 0-max." },
{ "                   If the color index greater than the device" },
{ "                   maximum is specified, the call is ignored. Color" },
{ "                   index 0 applies to the background color." },
{ " CH     (input)  : hue, in range 0.0 to 360.0." },
{ " CL     (input)  : lightness, in range 0.0 to 1.0." },
{ " CS     (input)  : saturation, in range 0.0 to 1.0." },
{ "" },
{ "" }
}
},
{
{ "pgshs" }, {
{ "set hatching style" },
{ "Syntax" },
{ "      SUBROUTINE PGSHS (ANGLE, SEPN, PHASE)" },
{ "      REAL ANGLE, SEPN, PHASE" },
{ "" },
{ "Set the style to be used for hatching (fill area with fill-style 3)." },
{ "The default style is ANGLE=45.0, SEPN=1.0, PHASE=0.0." },
{ "" },
{ "Arguments:" },
{ " ANGLE  (input)  : the angle the hatch lines make with the" },
{ "                   horizontal, in degrees, increasing " },
{ "                   counterclockwise (this is an angle on the" },
{ "                   view surface, not in world-coordinate space)." },
{ " SEPN   (input)  : the spacing of the hatch lines. The unit spacing" },
{ "                   is 1 percent of the smaller of the height or" },
{ "                   width of the view surface. This should not be" },
{ "                   zero." },
{ " PHASE  (input)  : a real number between 0 and 1; the hatch lines" },
{ "                   are displaced by this fraction of SEPN from a" },
{ "                   fixed reference.  Adjacent regions hatched with the" },
{ "                   same PHASE have contiguous hatch lines. To hatch" },
{ "                   a region with alternating lines of two colors," },
{ "                   fill the area twice, with PHASE=0.0 for one color" },
{ "                   and PHASE=0.5 for the other color." },
{ "" },
{ "" }
}
},
{
{ "pgsitf" }, {
{ "set image transfer function" },
{ "Syntax" },
{ "      SUBROUTINE PGSITF (ITF)" },
{ "      INTEGER  ITF" },
{ "" },
{ "Set the Image Transfer Function for subsequent images drawn by" },
{ "PGIMAG, PGGRAY, or PGWEDG. The Image Transfer Function is used" },
{ "to map array values into the available range of color indices" },
{ "specified with routine PGSCIR or (for PGGRAY on some devices)" },
{ "into dot density." },
{ "" },
{ "Argument:" },
{ " ITF    (input)  : type of transfer function:" },
{ "                     ITF = 0 : linear" },
{ "                     ITF = 1 : logarithmic" },
{ "                     ITF = 2 : square-root" },
{ "" },
{ "" }
}
},
{
{ "pgslct" }, {
{ "select an open graphics device" },
{ "Syntax" },
{ "      SUBROUTINE PGSLCT(ID)" },
{ "      INTEGER ID" },
{ "" },
{ "Select one of the open graphics devices and direct subsequent" },
{ "plotting to it. The argument is the device identifier returned by" },
{ "PGOPEN when the device was opened. If the supplied argument is not a" },
{ "valid identifier of an open graphics device, a warning message is" },
{ "issued and the current selection is unchanged." },
{ "" },
{ "[This routine was added to PGPLOT in Version 5.1.0.]" },
{ "" },
{ "Arguments:" },
{ "" },
{ "ID (input, integer): identifier of the device to be selected." },
{ "" },
{ "" }
}
},
{
{ "pgsls" }, {
{ "set line style" },
{ "Syntax" },
{ "      SUBROUTINE PGSLS (LS)" },
{ "      INTEGER  LS" },
{ "" },
{ "Set the line style attribute for subsequent plotting. This" },
{ "attribute affects line primitives only; it does not affect graph" },
{ "markers, text, or area fill." },
{ "Five different line styles are available, with the following codes:" },
{ "1 (full line), 2 (dashed), 3 (dot-dash-dot-dash), 4 (dotted)," },
{ "5 (dash-dot-dot-dot). The default is 1 (normal full line)." },
{ "" },
{ "Argument:" },
{ " LS     (input)  : the line-style code for subsequent plotting" },
{ "                   (in range 1-5)." },
{ "" },
{ "" }
}
},
{
{ "pgslw" }, {
{ "set line width" },
{ "Syntax" },
{ "      SUBROUTINE PGSLW (LW)" },
{ "      INTEGER  LW" },
{ "" },
{ "Set the line-width attribute. This attribute affects lines, graph" },
{ "markers, and text. The line width is specified in units of 1/200 " },
{ "(0.005) inch (about 0.13 mm) and must be an integer in the range" },
{ "1-201. On some devices, thick lines are generated by tracing each" },
{ "line with multiple strokes offset in the direction perpendicular to" },
{ "the line." },
{ "" },
{ "Argument:" },
{ " LW     (input)  : width of line, in units of 0.005 inch (0.13 mm)" },
{ "                   in range 1-201." },
{ "" },
{ "" }
}
},
{
{ "pgstbg" }, {
{ "set text background color index" },
{ "Syntax" },
{ "      SUBROUTINE PGSTBG (TBCI)" },
{ "      INTEGER  TBCI" },
{ "" },
{ "Set the Text Background Color Index for subsequent text. By default" },
{ "text does not obscure underlying graphics. If the text background" },
{ "color index is positive, however, text is opaque: the bounding box" },
{ "of the text is filled with the color specified by PGSTBG before" },
{ "drawing the text characters in the current color index set by PGSCI." },
{ "Use color index 0 to erase underlying graphics before drawing text." },
{ "" },
{ "Argument:" },
{ " TBCI   (input)  : the color index to be used for the background" },
{ "                   for subsequent text plotting:" },
{ "                     TBCI &lt; 0  =&gt; transparent (default)" },
{ "                     TBCI &gt;= 0 =&gt; text will be drawn on an opaque" },
{ "                   background with color index TBCI." },
{ "" },
{ "" }
}
},
{
{ "pgsubp" }, {
{ "subdivide view surface into panels" },
{ "Syntax" },
{ "      SUBROUTINE PGSUBP (NXSUB, NYSUB)" },
{ "      INTEGER NXSUB, NYSUB" },
{ "" },
{ "PGPLOT divides the physical surface of the plotting device (screen," },
{ "window, or sheet of paper) into NXSUB x NYSUB `panels'. When the " },
{ "view surface is sub-divided in this way, PGPAGE moves to the next" },
{ "panel, not the next physical page. The initial subdivision of the" },
{ "view surface is set in the call to PGBEG. When PGSUBP is called," },
{ "it forces the next call to PGPAGE to start a new physical page," },
{ "subdivided in the manner indicated. No plotting should be done" },
{ "between a call of PGSUBP and a call of PGPAGE (or PGENV, which calls" },
{ "PGPAGE)." },
{ "" },
{ "If NXSUB &gt; 0, PGPLOT uses the panels in row order; if &lt;0, " },
{ "PGPLOT uses them in column order, e.g.," },
{ "     " },
{ " NXSUB=3, NYSUB=2            NXSUB=-3, NYSUB=2   " },
{ "                                               " },
{ "+-----+-----+-----+         +-----+-----+-----+" },
{ "|  1  |  2  |  3  |         |  1  |  3  |  5  |" },
{ "+-----+-----+-----+         +-----+-----+-----+" },
{ "|  4  |  5  |  6  |         |  2  |  4  |  6  |" },
{ "+-----+-----+-----+         +-----+-----+-----+" },
{ "" },
{ "PGPLOT advances from one panels to the next when PGPAGE is called," },
{ "clearing the screen or starting a new page when the last panel has" },
{ "been used. It is also possible to jump from one panel to another" },
{ "in random order by calling PGPANL." },
{ "" },
{ "Arguments:" },
{ " NXSUB  (input)  : the number of subdivisions of the view surface in" },
{ "                   X (&gt;0 or &lt;0)." },
{ " NYSUB  (input)  : the number of subdivisions of the view surface in" },
{ "                   Y (&gt;0)." },
{ "" },
{ "" }
}
},
{
{ "pgsvp" }, {
{ "set viewport (normalized device coordinates)" },
{ "Syntax" },
{ "      SUBROUTINE PGSVP (XLEFT, XRIGHT, YBOT, YTOP)" },
{ "      REAL XLEFT, XRIGHT, YBOT, YTOP" },
{ "" },
{ "Change the size and position of the viewport, specifying" },
{ "the viewport in normalized device coordinates.  Normalized" },
{ "device coordinates run from 0 to 1 in each dimension. The" },
{ "viewport is the rectangle on the view surface \"through\"" },
{ "which one views the graph.  All the PG routines which plot lines" },
{ "etc. plot them within the viewport, and lines are truncated at" },
{ "the edge of the viewport (except for axes, labels etc drawn with" },
{ "PGBOX or PGLAB).  The region of world space (the coordinate" },
{ "space of the graph) which is visible through the viewport is" },
{ "specified by a call to PGSWIN.  It is legal to request a" },
{ "viewport larger than the view surface; only the part which" },
{ "appears on the view surface will be plotted." },
{ "" },
{ "Arguments:" },
{ " XLEFT  (input)  : x-coordinate of left hand edge of viewport, in NDC." },
{ " XRIGHT (input)  : x-coordinate of right hand edge of viewport," },
{ "                   in NDC." },
{ " YBOT   (input)  : y-coordinate of bottom edge of viewport, in NDC." },
{ " YTOP   (input)  : y-coordinate of top  edge of viewport, in NDC." },
{ "" },
{ "" }
}
},
{
{ "pgswin" }, {
{ "set window" },
{ "Syntax" },
{ "      SUBROUTINE PGSWIN (X1, X2, Y1, Y2)" },
{ "      REAL X1, X2, Y1, Y2" },
{ "" },
{ "Change the window in world coordinate space that is to be mapped on" },
{ "to the viewport.  Usually PGSWIN is called automatically by PGENV," },
{ "but it may be called directly by the user." },
{ "" },
{ "Arguments:" },
{ " X1     (input)  : the x-coordinate of the bottom left corner" },
{ "                   of the viewport." },
{ " X2     (input)  : the x-coordinate of the top right corner" },
{ "                   of the viewport (note X2 may be less than X1)." },
{ " Y1     (input)  : the y-coordinate of the bottom left corner" },
{ "                   of the viewport." },
{ " Y2     (input)  : the y-coordinate of the top right corner" },
{ "                   of the viewport (note Y2 may be less than Y1)." },
{ "" },
{ "" }
}
},
{
{ "pgtbox" }, {
{ "draw frame and write (DD) HH MM SS.S labelling" },
{ "Syntax" },
{ "      SUBROUTINE PGTBOX (XOPT, XTICK, NXSUB, YOPT, YTICK, NYSUB)" },
{ "" },
{ "      REAL XTICK, YTICK" },
{ "      INTEGER NXSUB, NYSUB" },
{ "      CHARACTER XOPT*(*), YOPT*(*)" },
{ "" },
{ "Draw a box and optionally label one or both axes with (DD) HH MM SS " },
{ "style numeric labels (useful for time or RA - DEC plots).   If this " },
{ "style of labelling is desired, then PGSWIN should have been called" },
{ "previously with the extrema in SECONDS of time." },
{ "" },
{ "In the seconds field, you can have at most 3 places after the decimal" },
{ "point, so that 1 ms is the smallest time interval you can time label." },
{ "" },
{ "Large numbers are coped with by fields of 6 characters long.  Thus " },
{ "you could have times with days or hours as big as 999999.  However, " },
{ "in practice, you might have trouble with labels overwriting  themselves" },
{ "with such large numbers unless you a) use a small time INTERVAL, " },
{ "b) use a small character size or c) choose your own sparse ticks in " },
{ "the call to PGTBOX.  " },
{ "" },
{ "PGTBOX will attempt, when choosing its own ticks, not to overwrite" },
{ "the labels, but this algorithm is not very bright and may fail." },
{ "" },
{ "Note that small intervals but large absolute times such as" },
{ "TMIN = 200000.0 s and TMAX=200000.1 s will cause the algorithm" },
{ "to fail.  This is inherent in PGPLOT's use of single precision" },
{ "and cannot be avoided.  In such cases, you should use relative" },
{ "times if possible." },
{ "" },
{ "PGTBOX's labelling philosophy is that the left-most or bottom tick of" },
{ "the axis contains a full label.  Thereafter, only changing fields are" },
{ "labelled.  Negative fields are given a '-' label, positive fields" },
{ "have none.   Axes that have the DD (or HH if the day field is not" },
{ "used) field on each major tick carry the sign on each field.  If the" },
{ "axis crosses zero, the zero tick will carry a full label and sign." },
{ "" },
{ "This labelling style can cause a little confusion with some special" },
{ "cases, but as long as you know its philosophy, the truth can be divined." },
{ "Consider an axis with TMIN=20s, TMAX=-20s.   The labels will look like" },
{ "" },
{ "       +----------+----------+----------+----------+" },
{ "    0h0m20s      10s      -0h0m0s      10s        20s" },
{ "" },
{ "Knowing that the left field always has a full label and that" },
{ "positive fields are unsigned, informs that time is decreasing" },
{ "from left to right, not vice versa.   This can become very " },
{ "unclear if you have used the 'F' option, but that is your problem !" },
{ "" },
{ "Exceptions to this labelling philosophy are when the finest time" },
{ "increment being displayed is hours (with option 'Y') or days.  " },
{ "Then all fields carry a label.  For example," },
{ "" },
{ "       +----------+----------+----------+----------+" },
{ "     -10h        -8h        -6h        -4h        -2h" },
{ "" },
{ "" },
{ "PGTBOX can be used in place of PGBOX; it calls PGBOX and only invokes " },
{ "time labelling if requested. Other options are passed intact to PGBOX." },
{ "" },
{ "Inputs:" },
{ " XOPT   :  X-options for PGTBOX.  Same as for PGBOX plus " },
{ "" },
{ "            'Z' for (DD) HH MM SS.S time labelling" },
{ "            'Y' means don't include the day field so that labels" },
{ "                are HH MM SS.S rather than DD HH MM SS.S   The hours" },
{ "                will accumulate beyond 24 if necessary in this case." },
{ "            'X' label the HH field as modulo 24.  Thus, a label" },
{ "                such as 25h 10m would come out as 1h 10m" },
{ "            'H' means superscript numbers with d, h, m, &amp; s  symbols" },
{ "            'D' means superscript numbers with    o, ', &amp; '' symbols " },
{ "            'F' causes the first label (left- or bottom-most) to" },
{ "                be omitted. Useful for sub-panels that abut each other." },
{ "                Care is needed because first label carries sign as well." },
{ "            'O' means omit leading zeros in numbers &lt; 10" },
{ "                E.g.  3h 3m 1.2s rather than 03h 03m 01.2s  Useful" },
{ "                to help save space on X-axes. The day field does not " },
{ "                use this facility." },
{ "" },
{ " YOPT   :  Y-options for PGTBOX.  See above." },
{ " XTICK  :  X-axis major tick increment.  0.0 for default. " },
{ " YTICK  :  Y-axis major tick increment.  0.0 for default. " },
{ "           If the 'Z' option is used then XTICK and/or YTICK must" },
{ "           be in seconds." },
{ " NXSUB  :  Number of intervals for minor ticks on X-axis. 0 for default" },
{ " NYSUB  :  Number of intervals for minor ticks on Y-axis. 0 for default" },
{ "" },
{ " The regular XOPT and YOPT axis options for PGBOX are" },
{ "" },
{ " A : draw Axis (X axis is horizontal line Y=0, Y axis is vertical" },
{ "     line X=0)." },
{ " B : draw bottom (X) or left (Y) edge of frame." },
{ " C : draw top (X) or right (Y) edge of frame." },
{ " G : draw Grid of vertical (X) or horizontal (Y) lines." },
{ " I : Invert the tick marks; ie draw them outside the viewport" },
{ "     instead of inside." },
{ " L : label axis Logarithmically (see below)." },
{ " N : write Numeric labels in the conventional location below the" },
{ "     viewport (X) or to the left of the viewport (Y)." },
{ " P : extend (\"Project\") major tick marks outside the box (ignored if" },
{ "     option I is specified)." },
{ " M : write numeric labels in the unconventional location above the" },
{ "     viewport (X) or to the right of the viewport (Y)." },
{ " T : draw major Tick marks at the major coordinate interval." },
{ " S : draw minor tick marks (Subticks)." },
{ " V : orient numeric labels Vertically. This is only applicable to Y." },
{ "     The default is to write Y-labels parallel to the axis." },
{ " 1 : force decimal labelling, instead of automatic choice (see PGNUMB)." },
{ " 2 : force exponential labelling, instead of automatic." },
{ "" },
{ "     The default is to write Y-labels parallel to the axis" },
{ " " },
{ "" },
{ "       ******************        EXCEPTIONS       *******************" },
{ "" },
{ "       Note that " },
{ "         1) PGBOX option 'L' (log labels) is ignored with option 'Z'" },
{ "         2) The 'O' option will be ignored for the 'V' option as it " },
{ "            makes it impossible to align the labels nicely" },
{ "         3) Option 'Y' is forced with option 'D'" },
{ "" },
{ "       ***************************************************************" },
{ "" },
{ "" },
{ "" },
{ "" }
}
},
{
{ "pgtext" }, {
{ "write text (horizontal, left-justified)" },
{ "Syntax" },
{ "      SUBROUTINE PGTEXT (X, Y, TEXT)" },
{ "      REAL X, Y" },
{ "      CHARACTER*(*) TEXT" },
{ "" },
{ "Write text. The bottom left corner of the first character is placed" },
{ "at the specified position, and the text is written horizontally." },
{ "This is a simplified interface to the primitive routine PGPTXT." },
{ "For non-horizontal text, use PGPTXT." },
{ "" },
{ "Arguments:" },
{ " X      (input)  : world x-coordinate of start of string." },
{ " Y      (input)  : world y-coordinate of start of string." },
{ " TEXT   (input)  : the character string to be plotted." },
{ "" },
{ "" }
}
},
{
{ "pgtick" }, {
{ "draw a single tick mark on an axis" },
{ "Syntax" },
{ "      SUBROUTINE PGTICK (X1, Y1, X2, Y2, V, TIKL, TIKR, DISP, " },
{ "     :                   ORIENT, STR)" },
{ "      REAL X1, Y1, X2, Y2, V, TIKL, TIKR, DISP, ORIENT" },
{ "      CHARACTER*(*) STR" },
{ "" },
{ "Draw and label single tick mark on a graph axis. The tick mark is" },
{ "a short line perpendicular to the direction of the axis (which is not" },
{ "drawn by this routine). The optional text label is drawn with its" },
{ "baseline parallel to the axis and reading in the same direction as" },
{ "the axis (from point 1 to point 2). Current line and text attributes" },
{ "are used." },
{ "" },
{ "Arguments:" },
{ " X1, Y1 (input)  : world coordinates of one endpoint of the axis." },
{ " X2, Y2 (input)  : world coordinates of the other endpoint of the axis." },
{ " V      (input)  : draw the tick mark at fraction V (0&lt;=V&lt;=1) along" },
{ "                   the line from (X1,Y1) to (X2,Y2)." },
{ " TIKL   (input)  : length of tick mark drawn to left of axis" },
{ "                   (as seen looking from first endpoint to second), in" },
{ "                   units of the character height." },
{ " TIKR   (input)  : length of major tick marks drawn to right of axis," },
{ "                   in units of the character height." },
{ " DISP   (input)  : displacement of label text to" },
{ "                   right of axis, in units of the character height." },
{ " ORIENT (input)  : orientation of label text, in degrees; angle between" },
{ "                   baseline of text and direction of axis (0-360)." },
{ " STR    (input)  : text of label (may be blank)." },
{ "" },
{ "" }
}
},
{
{ "pgupdt" }, {
{ "update display" },
{ "Syntax" },
{ "      SUBROUTINE PGUPDT" },
{ "" },
{ "Update the graphics display: flush any pending commands to the" },
{ "output device. This routine empties the buffer created by PGBBUF," },
{ "but it does not alter the PGBBUF/PGEBUF counter. The routine should" },
{ "be called when it is essential that the display be completely up to" },
{ "date (before interaction with the user, for example) but it is not" },
{ "known if output is being buffered." },
{ "" },
{ "Arguments: none" },
{ "" },
{ "" }
}
},
{
{ "pgvect" }, {
{ "vector map of a 2D data array, with blanking" },
{ "Syntax" },
{ "      SUBROUTINE PGVECT (A, B, IDIM, JDIM, I1, I2, J1, J2, C, NC, TR," },
{ "     1                   BLANK)" },
{ "      INTEGER IDIM, JDIM, I1, I2, J1, J2, NC" },
{ "      REAL    A(IDIM,JDIM), B(IDIM, JDIM), TR(6), BLANK, C" },
{ "" },
{ "Draw a vector map of two arrays.  This routine is similar to" },
{ "PGCONB in that array elements that have the \"magic value\" defined by" },
{ "the argument BLANK are ignored, making gaps in the vector map.  The" },
{ "routine may be useful for data measured on most but not all of the" },
{ "points of a grid. Vectors are displayed as arrows; the style of the" },
{ "arrowhead can be set with routine PGSAH, and the the size of the" },
{ "arrowhead is determined by the current character size, set by PGSCH." },
{ "" },
{ "Arguments:" },
{ " A      (input)  : horizontal component data array." },
{ " B      (input)  : vertical component data array." },
{ " IDIM   (input)  : first dimension of A and B." },
{ " JDIM   (input)  : second dimension of A and B." },
{ " I1,I2  (input)  : range of first index to be mapped (inclusive)." },
{ " J1,J2  (input)  : range of second index to be mapped (inclusive)." },
{ " C      (input)  : scale factor for vector lengths, if 0.0, C will be" },
{ "                   set so that the longest vector is equal to the" },
{ "                   smaller of TR(2)+TR(3) and TR(5)+TR(6)." },
{ " NC     (input)  : vector positioning code." },
{ "                   &lt;0 vector head positioned on coordinates" },
{ "                   &gt;0 vector base positioned on coordinates" },
{ "                   =0 vector centered on the coordinates" },
{ " TR     (input)  : array defining a transformation between the I,J" },
{ "                   grid of the array and the world coordinates. The" },
{ "                   world coordinates of the array point A(I,J) are" },
{ "                   given by:" },
{ "                     X = TR(1) + TR(2)*I + TR(3)*J" },
{ "                     Y = TR(4) + TR(5)*I + TR(6)*J" },
{ "                   Usually TR(3) and TR(5) are zero - unless the" },
{ "                   coordinate transformation involves a rotation" },
{ "                   or shear." },
{ " BLANK   (input) : elements of arrays A or B that are exactly equal to" },
{ "                   this value are ignored (blanked)." },
{ "" },
{ "" }
}
},
{
{ "pgvsiz" }, {
{ "set viewport (inches)" },
{ "Syntax" },
{ "      SUBROUTINE PGVSIZ (XLEFT, XRIGHT, YBOT, YTOP)" },
{ "      REAL XLEFT, XRIGHT, YBOT, YTOP" },
{ "" },
{ "Change the size and position of the viewport, specifying" },
{ "the viewport in physical device coordinates (inches).  The" },
{ "viewport is the rectangle on the view surface \"through\"" },
{ "which one views the graph.  All the PG routines which plot lines" },
{ "etc. plot them within the viewport, and lines are truncated at" },
{ "the edge of the viewport (except for axes, labels etc drawn with" },
{ "PGBOX or PGLAB).  The region of world space (the coordinate" },
{ "space of the graph) which is visible through the viewport is" },
{ "specified by a call to PGSWIN.  It is legal to request a" },
{ "viewport larger than the view surface; only the part which" },
{ "appears on the view surface will be plotted." },
{ "" },
{ "Arguments:" },
{ " XLEFT  (input)  : x-coordinate of left hand edge of viewport, in" },
{ "                   inches from left edge of view surface." },
{ " XRIGHT (input)  : x-coordinate of right hand edge of viewport, in" },
{ "                   inches from left edge of view surface." },
{ " YBOT   (input)  : y-coordinate of bottom edge of viewport, in" },
{ "                   inches from bottom of view surface." },
{ " YTOP   (input)  : y-coordinate of top  edge of viewport, in inches" },
{ "                   from bottom of view surface." },
{ "" },
{ "" }
}
},
{
{ "pgvstd" }, {
{ "set standard (default) viewport" },
{ "Syntax" },
{ "      SUBROUTINE PGVSTD" },
{ "" },
{ "Define the viewport to be the standard viewport.  The standard" },
{ "viewport is the full area of the view surface (or panel)," },
{ "less a margin of 4 character heights all round for labelling." },
{ "It thus depends on the current character size, set by PGSCH." },
{ "" },
{ "Arguments: none." },
{ "" },
{ "" }
}
},
{
{ "pgwedg" }, {
{ "annotate an image plot with a wedge" },
{ "Syntax" },
{ "      SUBROUTINE PGWEDG(SIDE, DISP, WIDTH, FG, BG, LABEL)" },
{ "      CHARACTER *(*) SIDE,LABEL" },
{ "      REAL DISP, WIDTH, FG, BG" },
{ "" },
{ "Plot an annotated grey-scale or color wedge parallel to a given axis" },
{ "of the the current viewport. This routine is designed to provide a" },
{ "brightness/color scale for an image drawn with PGIMAG or PGGRAY." },
{ "The wedge will be drawn with the transfer function set by PGSITF" },
{ "and using the color index range set by PGSCIR." },
{ "" },
{ "Arguments:" },
{ " SIDE   (input)  : The first character must be one of the characters" },
{ "                   'B', 'L', 'T', or 'R' signifying the Bottom, Left," },
{ "                   Top, or Right edge of the viewport." },
{ "                   The second character should be 'I' to use PGIMAG" },
{ "                   to draw the wedge, or 'G' to use PGGRAY." },
{ " DISP   (input)  : the displacement of the wedge from the specified" },
{ "                   edge of the viewport, measured outwards from the" },
{ "                   viewport in units of the character height. Use a" },
{ "                   negative value to write inside the viewport, a" },
{ "                   positive value to write outside." },
{ " WIDTH  (input)  : The total width of the wedge including annotation," },
{ "                   in units of the character height." },
{ " FG     (input)  : The value which is to appear with shade" },
{ "                   1 (\"foreground\"). Use the values of FG and BG" },
{ "                   that were supplied to PGGRAY or PGIMAG." },
{ " BG     (input)  : the value which is to appear with shade" },
{ "                   0 (\"background\")." },
{ " LABEL  (input)  : Optional units label. If no label is required" },
{ "                   use ' '." },
{ "" },
{ "" }
}
},
{
{ "pgwnad" }, {
{ "set window and adjust viewport to same aspect ratio" },
{ "Syntax" },
{ "      SUBROUTINE PGWNAD (X1, X2, Y1, Y2)" },
{ "      REAL X1, X2, Y1, Y2" },
{ "" },
{ "Change the window in world coordinate space that is to be mapped on" },
{ "to the viewport, and simultaneously adjust the viewport so that the" },
{ "world-coordinate scales are equal in x and y. The new viewport is" },
{ "the largest one that can fit within the previously set viewport" },
{ "while retaining the required aspect ratio." },
{ "" },
{ "Arguments:" },
{ " X1     (input)  : the x-coordinate of the bottom left corner" },
{ "                   of the viewport." },
{ " X2     (input)  : the x-coordinate of the top right corner" },
{ "                   of the viewport (note X2 may be less than X1)." },
{ " Y1     (input)  : the y-coordinate of the bottom left corner" },
{ "                   of the viewport." },
{ " Y2     (input)  : the y-coordinate of the top right corner of the" },
{ "                   viewport (note Y2 may be less than Y1)." },
{ "" },
{ "" }
}
},
{
{ "pgadvance" }, {
{ "non-standard alias for PGPAGE" },
{ "Syntax" },
{ "      SUBROUTINE PGADVANCE" },
{ "" },
{ "See description of PGPAGE." },
{ "" },
{ "" }
}
},
{
{ "pglabel" }, {
{ "non-standard alias for PGLAB" },
{ "Syntax" },
{ "      SUBROUTINE PGLABEL (XLBL, YLBL, TOPLBL)" },
{ "      CHARACTER*(*) XLBL, YLBL, TOPLBL" },
{ "" },
{ "See description of PGLAB." },
{ "" },
{ "" }
}
},
{
{ "pgmtext" }, {
{ "non-standard alias for PGMTXT" },
{ "Syntax" },
{ "      SUBROUTINE PGMTEXT (SIDE, DISP, COORD, FJUST, TEXT)" },
{ "      CHARACTER*(*) SIDE, TEXT" },
{ "      REAL DISP, COORD, FJUST" },
{ "" },
{ "See description of PGMTXT." },
{ "" },
{ "" }
}
},
{
{ "pgncurse" }, {
{ "non-standard alias for PGNCUR" },
{ "Syntax" },
{ "      SUBROUTINE PGNCURSE (MAXPT, NPT, X, Y, SYMBOL)" },
{ "      INTEGER MAXPT, NPT" },
{ "      REAL    X(*), Y(*)" },
{ "      INTEGER SYMBOL" },
{ "" },
{ "See description of PGNCUR." },
{ "" },
{ "" }
}
},
{
{ "pgpaper" }, {
{ "non-standard alias for PGPAP" },
{ "Syntax" },
{ "      SUBROUTINE PGPAPER (WIDTH, ASPECT)" },
{ "      REAL WIDTH, ASPECT" },
{ "" },
{ "See description of PGPAP." },
{ "" },
{ "" }
}
},
{
{ "pgpoint" }, {
{ "non-standard alias for PGPT" },
{ "Syntax" },
{ "      SUBROUTINE PGPOINT (N, XPTS, YPTS, SYMBOL)" },
{ "      INTEGER N" },
{ "      REAL XPTS(*), YPTS(*)" },
{ "      INTEGER SYMBOL" },
{ "" },
{ "See description of PGPT." },
{ "" },
{ "" }
}
},
{
{ "pgptext" }, {
{ "non-standard alias for PGPTXT" },
{ "Syntax" },
{ "      SUBROUTINE PGPTEXT (X, Y, ANGLE, FJUST, TEXT)" },
{ "      REAL X, Y, ANGLE, FJUST" },
{ "      CHARACTER*(*) TEXT" },
{ "" },
{ "See description of PGPTXT." },
{ "" },
{ "" }
}
},
{
{ "pgvport" }, {
{ "non-standard alias for PGSVP" },
{ "Syntax" },
{ "      SUBROUTINE PGVPORT (XLEFT, XRIGHT, YBOT, YTOP)" },
{ "      REAL XLEFT, XRIGHT, YBOT, YTOP" },
{ "" },
{ "See description of PGSVP." },
{ "" },
{ "" }
}
},
{
{ "pgvsize" }, {
{ "non-standard alias for PGVSIZ" },
{ "Syntax" },
{ "      SUBROUTINE PGVSIZE (XLEFT, XRIGHT, YBOT, YTOP)" },
{ "      REAL XLEFT, XRIGHT, YBOT, YTOP" },
{ "" },
{ "See description of PGVSIZ." },
{ "" },
{ "" }
}
},
{
{ "pgvstand" }, {
{ "non-standard alias for PGVSTD" },
{ "Syntax" },
{ "      SUBROUTINE PGVSTAND" },
{ "" },
{ "See description of PGVSTD." },
{ "" },
{ "" }
}
},
{
{ "pgwindow" }, {
{ "non-standard alias for PGSWIN" },
{ "Syntax" },
{ "      SUBROUTINE PGWINDOW (X1, X2, Y1, Y2)" },
{ "      REAL X1, X2, Y1, Y2" },
{ "" },
{ "See description of PGSWIN." }
}
},
{
{ "saomarkpoint" }, {
{ "Draws a marker in ds9 at specified x,y coordinates with size s. (Use ds9 v5.2 or newer!)" },
{ "Syntax" },
{ "saomarkpoint x, y, size, type" },
{ "Arguments" },
{ "x: X-axes coordinate of the center of the circle" },
{ "y: Y-axes coordinate of the center of the circle" },
{ "size: The size of the marker to be drawn" },
{ "type: Marker type, give one of the following (can be OR'ed)" },
{ "POINT: 2" },
{ "BOX: 4" },
{ "DIAMOND: 32" },
{ "CIRCLE: 64" },
{ "See also" },
{ "procedure sao" },
{ "procedure saomarklabel" },
{ "procedure saoclear" }
}
},
{
{ "saoclear" }, {
{ "Clear ds9 of all markers drawn.  (Use ds9 v5.2 or newer!)" },
{ "Syntax" },
{ "saoclear" },
{ "See also" },
{ "procedure sao" },
{ "procedure saomarkpoint" },
{ "procedure saomarklabel" }
}
},
{
{ "saomarklabel" }, {
{ "Draws a text label in ds9 at specified x,y coordinates. (Use ds9 v5.2 or newer!)" },
{ "Syntax" },
{ "saomarklabel x, y, label" },
{ "Arguments" },
{ "x: X-axes coordinate of the center of the circle" },
{ "y: Y-axes coordinate of the center of the circle" },
{ "label: A string to be printed next to the marker" },
{ "See also" },
{ "procedure sao" },
{ "procedure saomarkpoint" },
{ "procedure saoclear" }
}
},
{
{ "imexa" }, {
{ "Display X in ds9. Interactively, the following can be done pressing keys in the viewer:" },
{ "key  action" },
{ " c   contour plot" },
{ " s   isosurface" },
{ " h   horizontal cut" },
{ " v   vertical cut" },
{ " r   radial average" },
{ " i   increase window size" },
{ " d   decrease window size" },
{ " q   quit and return to dpuser" },
{ "(Use ds9 v5.2 or newer!)" },
{ "Syntax" },
{ "imexa X" },
{ "See also" },
{ "procedure sao" }
}
},
{
{ "writefits" }, {
{ "Writes the array X to disk as a FITS file with specified filename, optionally as an extension. If X is a Fits List, a multiple extension FITS file is written." },
{ "Syntax" },
{ "writefits FILENAME, X [, /ext]" },
{ "Arguments" },
{ "FILENAME: A string" },
{ "X: A matrix or a Fits List" },
{ "Switches" },
{ "/ext: If specified, the matrix is written as a FITS image extension. If the file FILENAME exists already, the extension is appended (in which case the original FITS file must not be compressed), else an empty primary HDU is written and the extension appended." }
}
},
{
{ "contour" }, {
{ "Draw a contour map of X. levels give the contour levels in percent of the maximum value." },
{ "Syntax" },
{ "contour fits X, fits levels [,title=string] [,xtitle=string] [,ytitle=string]" }
}
},
{
{ "display" }, {
{ "Displays a grayscale image of X. If min and max are set, the display of the image is clipped at these values. An optional keyword method can have 3 values:" },
{ "method = 0: linear scaling" },
{ "method = 1: log scaling" },
{ "method = 2: square root scaling" },
{ "Syntax" },
{ "display fits [, float min, float max]" }
}
},
{
{ "exec" }, {
{ "Execute cmd (which is given as a character string). Control is returned to DPUSER when cmd is finished." },
{ "Syntax" },
{ "exec cmd" },
{ "Arguments" },
{ "cmd: A string containing the command to be executed." },
{ "Examples" },
{ "Do a directory listing:" },
{ "exec \"dir\"" }
}
},
{
{ "sleep" }, {
{ "Sleep for the specified amount of seconds." },
{ "Syntax" },
{ "sleep seconds" },
{ "Arguments" },
{ "seconds: An integer number." }
}
},
{
{ "print" }, {
{ "prints the argument. Depending on the argument, the following happens:" },
{ "  integer, real number, complex number, string, string array: the value is printed." },
{ "  matrix: some statistics on the array are printed." },
{ "Syntax" },
{ "print argument" }
}
},
{
{ "mem" }, {
{ "Prints information on all local variables, user defined or compiled functions and procedures." },
{ "Syntax" },
{ "mem" }
}
},
{
{ "shift" }, {
{ "Shifts (and optionally wraps) X by specified values." },
{ "Syntax" },
{ "shift X, xs, ys [, zs] [, /wrap]" },
{ "Arguments" },
{ "X: The array to be shifted" },
{ "xs: Shift vector in the first dimension" },
{ "ys: Shift vector in the second dimension" },
{ "zs: Shift vector in the third dimension" },
{ "Switches" },
{ "wrap: Pixels shifted off the array will be wrapped to the opposide side." },
{ "Notes" },
{ "If either shift vector is non-integer, a subpixel shift is applied and the array type changed to R4. Subpixel shift is only supported in 2 dimensions." },
{ "See also" },
{ "function shift" }
}
},
{
{ "center" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "center X" },
{ "See also" },
{ "function center" }
}
},
{
{ "centroid" }, {
{ "Returns the centroid of X in the variables x, y, and z." },
{ "y and z are optional." },
{ "Syntax" },
{ "centroid X, VARIABLE x [, VARIABLE y [, VARIABLE z]]" }
}
},
{
{ "upper" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "upper X" },
{ "See also" },
{ "function upper" }
}
},
{
{ "lower" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "lower X" },
{ "See also" },
{ "function lower" }
}
},
{
{ "export" }, {
{ "Export what to fname. If what is a stringarray, each string in the array is printed as a separate line. If what is a fits, all values are printed as floating point numbers, separated by a single whitespace (\" \"). In this case, optionally a precision can be given (default: 2 decimal places)." },
{ "Syntax" },
{ "export string filename, stringarray|fits what [, int precision]" }
}
},
{
{ "replace" }, {
{ "replaces all occurrences of the string s by the string r." },
{ "Syntax" },
{ "replace string|stringarray where, string s, string r" }
}
},
{
{ "rotate" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "rotate X, angle [, xcen, ycen]" },
{ "See also" },
{ "function rotate" }
}
},
{
{ "fft" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "fft X" },
{ "See also" },
{ "function fft" }
}
},
{
{ "reass" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "reass X" },
{ "See also" },
{ "function reass" }
}
},
{
{ "norm" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "norm X [, /unity, /total, /average]" },
{ "See also" },
{ "function norm" }
}
},
{
{ "clip" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "clip X, low, high [, value]" },
{ "See also" },
{ "function clip" }
}
},
{
{ "smooth" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "smooth X, fwhm" },
{ "See also" },
{ "function smooth" }
}
},
{
{ "boxcar" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "boxcar X, width [, /average, /minimum, /maximum, /median]" },
{ "See also" },
{ "function boxcar" }
}
},
{
{ "flip" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "flip X, axis" },
{ "See also" },
{ "function flip" }
}
},
{
{ "enlarge" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "enlarge X, scale, method = 0" },
{ "See also" },
{ "function enlarge" }
}
},
{
{ "resize" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "resize X, naxis1, naxis2, naxis3" },
{ "See also" },
{ "function resize" }
}
},
{
{ "wien" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "wien X, PSF [, height]" },
{ "See also" },
{ "function wien" }
}
},
{
{ "lucy" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "lucy X, PSF, niter [, threshold]" },
{ "See also" },
{ "function lucy" }
}
},
{
{ "3dnorm" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "3dnorm X" },
{ "See also" },
{ "function 3dnorm" }
}
},
{
{ "correl" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "correl X, Y" },
{ "See also" },
{ "function correl" }
}
},
{
{ "rebin" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "rebin X, x1, x2" },
{ "See also" },
{ "function rebin" }
}
},
{
{ "ssaplot" }, {
{ "Plot ssa statistics. The first argument must be created with ssastat Optionally, a title can be given as second argument which will be printed above all plots." },
{ "Syntax" },
{ "ssaplot fits x [, string title]" },
{ "See also" },
{ "function ssastat" }
}
},
{
{ "freddy" }, {
{ "Draw an isometric plot of x." },
{ "Syntax" },
{ "freddy fits x, int xsize, int ysize, float scale, float angle" }
}
},
{
{ "surface" }, {
{ "Draw an isosurface of x. This is seen under the angle. If skip is specified and > 1, only every nth line is drawn." },
{ "Syntax" },
{ "surface fits x, float angle [, int skip]" }
}
},
{
{ "sbfint" }, {
{ "Initialises the software buffer for crystal-plotting. It should  be called just once per plot (buffer), after PGWINDOW but before any crystal-related routines." },
{ "Syntax" },
{ "sbfint RGB,IC,IBMODE,IBUF,MAXBUF" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "RGB:      R*4    I       3      The RGB values for the background." },
{ "IC:       I*4    I       -      The index for the background colour." },
{ "IBMODE:   I*4    I       -      Buffering mode for initialisation:" },
{ "                                 1 = Ordinary, default." },
{ "                                 2 = Will want to save later." },
{ "                                 3 = Initialise from saved buffers." },
{ "IBUF:     I*4    I       -      Software buffer to be used (>=1)." },
{ "MAXBUF:   I*4    O       -      Maximum number of buffers available." }
}
},
{
{ "sbfbkg" }, {
{ "Sets the shading for the background. This routine should be called after SBFINT, and COLINT or COLTAB, but before any objects are plotted." },
{ "Syntax" },
{ "sbfbkg IC1,IC2,ISHADE" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "IC1,IC2:  I*4    I       -      Lowest & highest colour-index to be" },
{ "                                used for the shading." },
{ "ISHADE:   I*4    I       -      Order of shading (IC1-->IC2 - IC1):" },
{ "                                  1 - Bottom to top." },
{ "                                  2 - Left to right." },
{ "                                  3 - Bottom-left to top-right." },
{ "                                  4 - Top-left to bottom-right." },
{ "                                  5 - Bottom, middle and top." },
{ "                                  6 - Left, middle and right." },
{ "                                  7 - Rectangular zoom to centre." },
{ "                                  8 - Elliptical zoom to centre." }
}
},
{
{ "sbfsav" }, {
{ "Save a rendered picture-buffer, and its Z-buffer, for subsequent use in re-initialisation with SBFINT." },
{ "Syntax" },
{ "sbfsav IBUF" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "IBUF:     I*4    I       -      Software buffer to be saved (>=1)." }
}
},
{
{ "sbfcls" }, {
{ "Closes the software buffer for crystal-plotting, by outputting it to the screen or writing out a postscript file (as appropriate)." },
{ "Syntax" },
{ "sbfcls IBUF" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "IBUF:     I*4    I       -      Software buffer to be output (>=1)." }
}
},
{
{ "colint" }, {
{ "Initialises a colour table for a geometrical object. In general, it is recommended that SHINE = 0.0 if DIFUSE > 0.0 and vice versa." },
{ "Syntax" },
{ "colint RGB,IC1,IC2,DIFUSE,SHINE,POLISH" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "RGB:      R*4    I       3      Red, green and blue intenisty for " },
{ "                                fully-lit non-shiny object (0-1)." },
{ "IC1,IC2:  I*4    I       -      Lowest & highest colour-index to be" },
{ "                                used for shading." },
{ "DIFUSE:   R*4    I       -      Diffusiveness of object (0-1)." },
{ "SHINE:    R*4    I       -      Whiteness of bright spot (0-1)." },
{ "POLISH:   R*4    I       -      Controls size of bright spot." }
}
},
{
{ "coltab" }, {
{ "Initialises a colour table for a \"grey-scale\" map." },
{ "Syntax" },
{ "coltab RGB,NCOL,ALFA,IC1,IC2" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "RGB:      R*4    I   3 X NCOL   Red, green and blue intenisty for " },
{ "                                the colour table." },
{ "NCOL:     I*4    I       -      No. of colours in the input table." },
{ "ALFA:     R*4    I       -      Contrast-factor (linear=1)." },
{ "IC1,IC2:  I*4    I       -      Lowest & highest colour-index to be" },
{ "                                used for the output." }
}
},
{
{ "colsrf" }, {
{ "Initialises a colour table for a 3-D surface rendering of a 2-D array of \"data\"." },
{ "Syntax" },
{ "colsrf RGB,NCOL,ALFA,IC1,IC2,NCBAND,DIFUSE,SHINE,POLISH" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "RGB:      R*4    I   3 X NCOL   Red, green and blue intenisty for " },
{ "                                the colour table." },
{ "NCOL:     I*4    I       -      No. of colours in the input table." },
{ "ALFA:     R*4    I       -      Contrast-factor (linear=1)." },
{ "IC1,IC2:  I*4    I       -      Lowest and highest colour-index to" },
{ "                                be used for the rendering." },
{ "NCBAND:   I*4    I       -      Number of colour-bands for the" },
{ "                                height, so that the number of shades" },
{ "                                per band = (IC2-IC1+1)/NCBAND." },
{ "DIFUSE:   R*4    I       -      Diffusiveness of object (0-1)." },
{ "SHINE:    R*4    I       -      Whiteness of bright spot (0-1)." },
{ "POLISH:   R*4    I       -      Controls size of bright spot." }
}
},
{
{ "sbball" }, {
{ "This subroutine plots a shiny or matt coloured ball. All (x,y,z) values are taken to be given in world coordinates. The z-component of the eye-poisition should be positive and that of the ball-centre should be negative (< -radius); the viewing-screen is fixed at z=0." },
{ "Syntax" },
{ "sbball EYE,CENTRE,RADIUS,IC1,IC2,LIGHT,LSHINE,X0,Y0,R0" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "EYE:      R*4    I       3      (x,y,z) coordinate of eye-position." },
{ "CENTRE:   R*4    I       3      (x,y,z) coordinate of ball-centre." },
{ "RADIUS:   R*4    I       -      Radius of ball." },
{ "IC1,IC2:  I*4    I       -      Lowest & highest colour-index to be" },
{ "                                used for shading." },
{ "LIGHT:    R*4    I       3      (x,y,z) direction of flood-light." },
{ "LSHINE:   L*1    I       -      Shiny ball if .TRUE., else diffuse." },
{ "X0,Y0:    R*4    O       -      Centre of projected ball." },
{ "R0:       R*4    O       -      Average radius of projected ball." }
}
},
{
{ "sbtbal" }, {
{ "This subroutine plots a semi-transparent shiny or matt coloured ball. All (x,y,z) values are taken to be given in world coordinates. The z-component of the eye-poisition should be positive and that of the ball-centre should be negative (< -radius); the viewing-screen is fixed at z=0." },
{ "Syntax" },
{ "sbtbal EYE,CENTRE,RADIUS,IC1,IC2,LIGHT,LSHINE,X0,Y0,R0,ITRANS" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "EYE:      R*4    I       3      (x,y,z) coordinate of eye-position." },
{ "CENTRE:   R*4    I       3      (x,y,z) coordinate of ball-centre." },
{ "RADIUS:   R*4    I       -      Radius of ball." },
{ "IC1,IC2:  I*4    I       -      Lowest & highest colour-index to be" },
{ "                                used for shading." },
{ "LIGHT:    R*4    I       3      (x,y,z) direction of flood-light." },
{ "LSHINE:   L*1    I       -      Shiny ball if .TRUE., else diffuse." },
{ "X0,Y0:    R*4    O       -      Centre of projected ball." },
{ "R0:       R*4    O       -      Average radius of projected ball." },
{ "ITRANS:   I*4    I       -      Level of transparency:" },
{ "                                     1 = 25%; 2 = 50%; 3 = 75%." }
}
},
{
{ "sbplan" }, {
{ "This subroutine plots a diffusively-lit coloured plane; the user must ensure that all the verticies lie in a flat plane, and that the bounding polygon be convex (so that the angle at any vertex <= 180 degs). All (x,y,z) values are taken to be given in world coordinates. The z-component of the eye-poisition should be positive and that of the vertices should be negative; the viewing-screen is fixed at z=0." },
{ "Syntax" },
{ "sbplan EYE,NV,VERT,IC1,IC2,LIGHT" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "EYE:      R*4    I       3      (x,y,z) coordinate of eye-position." },
{ "NV:       R*4    I       -      No. of verticies (>=3)." },
{ "VERT:     R*4    I     3 x NV   (x,y,z) coordinate of verticies." },
{ "IC1,IC2:  I*4    I       -      Lowest & highest colour-index to be" },
{ "                                used for the shading." },
{ "LIGHT:    R*4    I       3      (x,y,z) direction of flood-light." }
}
},
{
{ "sbplnt" }, {
{ "This subroutine plots a diffusively-lit, semi-transparent, coloured plane; the use must ensure that all the verticies lie in a flat plane, and that the bounding polygon be convex (so that the angle at any vertex <= 180 degs). All (x,y,z) values are taken to be given in world coordinates. The z-component of the eye-poisition should be positive and that of the vertices should be negative; the viewing-screen is fixed at z=0." },
{ "Syntax" },
{ "sbplnt EYE,NV,VERT,IC1,IC2,LIGHT,ITRANS" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "EYE:      R*4    I       3      (x,y,z) coordinate of eye-position." },
{ "NV:       R*4    I       -      No. of verticies (>=3)." },
{ "VERT:     R*4    I     3 x NV   (x,y,z) coordinate of verticies." },
{ "IC1,IC2:  I*4    I       -      Lowest & highest colour-index to be" },
{ "                                used for the shading." },
{ "LIGHT:    R*4    I       3      (x,y,z) direction of flood-light." },
{ "ITRANS:   I*4    I       -      Level of transparency:" },
{ "                                     1 = 25%; 2 = 50%; 3 = 75%." }
}
},
{
{ "sbrod" }, {
{ "This subroutine plots a diffusively-shaded coloured rod. All (x,y,z) values are taken to be given in world coordinates. The z-component of the eye-poisition should be positive and that of the rod-ends should be negative (< -radius); the viewing-screen is fixed at z=0." },
{ "Syntax" },
{ "sbrod EYE,END1,END2,RADIUS,IC1,IC2,LIGHT,NSIDES,LEND" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "EYE:      R*4    I       3      (x,y,z) coordinate of eye-position." },
{ "END1:     R*4    I       3      (x,y,z) coordinate of rod-end 1." },
{ "END2:     R*4    I       3      (x,y,z) coordinate of rod-end 2." },
{ "RADIUS:   R*4    I       -      Radius of cylinderical rod." },
{ "IC1,IC2:  I*4    I       -      Lowest & highest colour-index to be" },
{ "                                used for the shading." },
{ "LIGHT:    R*4    I       3      (x,y,z) direction of flood-light." },
{ "NSIDES:   I*4    I       -      The order of the polygon to be used" },
{ "                                for the cross-section of the rod." },
{ "LEND:     L*1    I       -      If true, plot the end of the rod." }
}
},
{
{ "sbcone" }, {
{ "This subroutine plots a diffusively-shaded coloured right-angular cone. All (x,y,z) values are taken to be given in world coordinates. The z-component of the eye-poisition should be positive and that of the base and appex of the cone should be negative (< -radius); the viewing-screen is fixed at z=0." },
{ "Syntax" },
{ "sbcone EYE,BASE,APEX,RADIUS,IC1,IC2,LIGHT,NSIDES" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "EYE:      R*4    I       3      (x,y,z) coordinate of eye-position." },
{ "BASE:     R*4    I       3      (x,y,z) coordinate of the centre of" },
{ "                                the base of the cone." },
{ "APEX:     R*4    I       3      (x,y,z) coordinate of the apex." },
{ "RADIUS:   R*4    I       -      Radius of the base of the cone." },
{ "IC1,IC2:  I*4    I       -      Lowest & highest colour-index to be" },
{ "                                used for the shading." },
{ "LIGHT:    R*4    I       3      (x,y,z) direction of flood-light." },
{ "NSIDES:   I*4    I       -      The order of the polygon to be used" },
{ "                                for the cross-section of the cone." }
}
},
{
{ "sbelip" }, {
{ "This subroutine plots a shiny or matt coloured elliptical ball. All (x,y,z) values are taken to be given in world coordinates. The z-component of the eye-poisition should be positive and that of the ball-centre should be negative (< -radius); the viewing-screen is fixed at z=0." },
{ "Syntax" },
{ "sbelip EYE,CENTRE,PAXES,IC1,IC2,LIGHT,LSHINE,ICLINE,ANGLIN,X0,Y0,R0" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "EYE:      R*4    I       3      (x,y,z) coordinate of eye-position." },
{ "CENTRE:   R*4    I       3      (x,y,z) coordinate of ball-centre." },
{ "PAXES:    R*4    I     3 x 3    Principal axes of the elliposid." },
{ "IC1,IC2:  I*4    I       -      Lowest & highest colour-index to be" },
{ "                                used for shading." },
{ "LIGHT:    R*4    I       3      (x,y,z) direction of flood-light." },
{ "LSHINE:   L*1    I       -      Shiny ball if .TRUE., else diffuse." },
{ "ICLINE:   I*4    I       -      If >=0, colour index for lines on" },
{ "                                surface of ellipsoid." },
{ "ANGLIN:   R*4    I       -      Width of lines: +/- degs." },
{ "X0,Y0:    R*4    O       -      Centre of projected ball." },
{ "R0:       R*4    O       -      Average radius of projected ball." }
}
},
{
{ "sbline" }, {
{ "This subroutine draws a straight line between two points. All (x,y,z) values are taken to be given in world coordinates. The z-component of the eye-poisition should be positive, while that of both the ends should be negative; the viewing-screen is fixed at z=0." },
{ "Syntax" },
{ "sbline EYE,END1,END2,ICOL,LDASH" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "EYE:      R*4    I       3      (x,y,z) coordinate of eye-position." },
{ "END1:     R*4    I       3      (x,y,z) coordinate of end-1." },
{ "END2:     R*4    I       3      (x,y,z) coordinate of end-2." },
{ "ICOL:     I*4    I       -      Colour-index for line." },
{ "LDASH:    L*1    I       -      Dashed line if .TRUE. (else cont.)." }
}
},
{
{ "sbtext" }, {
{ "Write a text string in 3-d perspective. All (x,y,z) values are taken to be given in world coordinates. The z-component of the eye-poisition should be positive and that of the text string should be negative; the viewing-screen is fixed at z=0." },
{ "Syntax" },
{ "sbtext EYE,TEXT,ICOL,PIVOT,FJUST,ORIENT,SIZE" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "EYE:      R*4    I       3      (x,y,z) coordinate of eye-position." },
{ "TEXT:     C*1    I       *      The text string to be written." },
{ "ICOL:     I*4    I       -      Colour index for text." },
{ "PIVOT:    R*4    I       3      (x,y,z) coordinate of pivot point." },
{ "FJUST:    R*4    I       -      Position of pivot along the text: " },
{ "                                0.0=left, 0.5=centre, 1.0=right." },
{ "ORIENT:   R*4    I     3 x 2    (x,y,z) for X-length and Y-height" },
{ "                                directions of the text." },
{ "SIZE:     R*4    I       -      Height of the reference symbol \"A\"." }
}
},
{
{ "sbsurf" }, {
{ "This subroutine plots an iso-surface through a unit-cell of density. All (x,y,z) values are taken to be given in world coordinates. The z-component of the eye-poisition should be positive and that of all the lattice-vertices should be negative; the viewing-screen is fixed at z=0." },
{ "Syntax" },
{ "sbsurf EYE,LATICE,DENS,N1,N2,N3,DSURF,IC1,IC2,LIGHT,LSHINE" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "EYE:      R*4    I       3      (x,y,z) coordinate of eye-position." },
{ "LATICE:   R*4    I     3 x 4    (x,y,z) coordinates of the origin" },
{ "                                and the a, b & C lattice-vertices." },
{ "DENS:     R*4    I     (N1+1)   The density at regular points within" },
{ "                     x (N2+1)   the unit cell, wrapped around so" },
{ "                     x (N3+1)   that DENS(0,J,K)=DENS(N1,J,K) etc.." },
{ "N1,N2,N3: I*4    I       -      The dimensions of the unit-cell grid." },
{ "DSURF:    R*4    I       -      Density for the iso-surface." },
{ "IC1,IC2:  I*4    I       -      Lowest & highest colour-index to be" },
{ "                                used for the shading." },
{ "LIGHT:    R*4    I       3      (x,y,z) direction of flood-light." },
{ "LSHINE:   L*1    I       -      Shiny surface if TRUE, else diffuse." }
}
},
{
{ "sbtsur" }, {
{ "This subroutine plots a semi-transparent iso-surface through a unit-cell of density. All (x,y,z) values are taken to be given in world coordinates. The z-component of the eye-poisition should be positive and that of all the lattice-vertices should be negative; the viewing-screen is fixed at z=0." },
{ "Syntax" },
{ "sbtsur EYE,LATICE,DENS,N1,N2,N3,DSURF,IC1,IC2,LIGHT,LSHINE,ITRANS" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "EYE:      R*4    I       3      (x,y,z) coordinate of eye-position." },
{ "LATICE:   R*4    I     3 x 4    (x,y,z) coordinates of the origin" },
{ "                                and the a, b & C lattice-vertices." },
{ "DENS:     R*4    I     (N1+1)   The density at regular points within" },
{ "                     x (N2+1)   the unit cell, wrapped around so" },
{ "                     x (N3+1)   that DENS(0,J,K)=DENS(N1,J,K) etc.." },
{ "N1,N2,N3: I*4    I       -      The dimensions of the unit-cell grid." },
{ "DSURF:    R*4    I       -      Density for the iso-surface." },
{ "IC1,IC2:  I*4    I       -      Lowest & highest colour-index to be" },
{ "                                used for the shading." },
{ "LIGHT:    R*4    I       3      (x,y,z) direction of flood-light." },
{ "LSHINE:   L*1    I       -      Shiny surface if TRUE, else diffuse." },
{ "ITRANS:   I*4    I       -      Level of transparency:" },
{ "                                     1 = 25%; 2 = 50%; 3 = 75%." }
}
},
{
{ "sbslic" }, {
{ "This subroutine plots a \"grey-scale\" slice through a unit-cell of density. All (x,y,z) values are taken to be given in world coordinates. The z-component of the eye-poisition should be positive and that of all the lattice-vertices should be negative; the viewing-screen is fixed at z=0." },
{ "Syntax" },
{ "sbslic EYE,LATICE,DENS,N1,N2,N3,DLOW,DHIGH,IC1,IC2,SLNORM,APOINT,ICEDGE" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "EYE:      R*4    I       3      (x,y,z) coordinate of eye-position." },
{ "LATICE:   R*4    I     3 x 4    (x,y,z) coordinates of the origin" },
{ "                                and the a, b & C lattice-vertices." },
{ "DENS:     R*4    I     (N1+1)   The density at regular points within" },
{ "                     x (N2+1)   the unit cell, wrapped around so" },
{ "                     x (N3+1)   that DENS(0,J,K)=DENS(N1,J,K) etc.." },
{ "N1,N2,N3: I*4    I       -      The dimensions of the unit-cell grid." },
{ "DLOW:     R*4    I       -      Density for the lowest colour-index." },
{ "DHIGH:    R*4    I       -      Density for the highest colour-index." },
{ "IC1,IC2:  I*4    I       -      Lowest & highest colour-index to be" },
{ "                                used for the shading." },
{ "SLNORM:   R*4    I       3      (x,y,z) direction of the normal to " },
{ "                                the slice to be \"grey-scaled\"." },
{ "APONIT:   R*4    I       3      (x,y,z) coordinate of a point within" },
{ "                                the slice to be \"grey-scaled\"." },
{ "ICEDGE:   I*4    I       -      If >=0, it's the colour-index for the" },
{ "                                boundary of the \"grey-scaled\" slice." }
}
},
{
{ "sbcpln" }, {
{ "This subroutine plots a diffusively-lit, semi-transparent, coloured plane through a unit cell. All (x,y,z) values are taken to be given in world coordinates. The z-component of the eye-poisition should be positive and that of all the lattice-vertices should be negative; the viewing-screen is fixed at z=0." },
{ "Syntax" },
{ "sbcpln EYE,LATICE,IC1,IC2,LIGHT,SLNORM,APOINT,ICEDGE,ITRANS" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "EYE:      R*4    I       3      (x,y,z) coordinate of eye-position." },
{ "LATICE:   R*4    I     3 x 4    (x,y,z) coordinates of the origin" },
{ "                                and the a, b & C lattice-vertices." },
{ "IC1,IC2:  I*4    I       -      Lowest & highest colour-index to be" },
{ "                                used for the shading." },
{ "LIGHT:    R*4    I       3      (x,y,z) direction of flood-light." },
{ "SLNORM:   R*4    I       3      (x,y,z) direction of normal to plane." },
{ "APONIT:   R*4    I       3      (x,y,z) coordinate of a point within" },
{ "                                the plane." },
{ "ICEDGE:   I*4    I       -      If >=0, it's the colour-index for" },
{ "                                the boundary of the plane." },
{ "ITRANS:   I*4    I       -      Level of transparency:" },
{ "                                  0 = 0%; 1 = 25%; 2 = 50%; 3 = 75%." }
}
},
{
{ "sb2srf" }, {
{ "This subroutine plots a 3-d surface given a 2-d unit-cell of density. All (x,y,z) values are taken to be given in world coordinates. The z-component of the eye-poisition should be positive and that of all the lattice-vertices should be negative; the viewing-screen is fixed at z=0." },
{ "Syntax" },
{ "sb2srf EYE,LATICE,DENS,N1,N2,DLOW,DHIGH,DVERT,IC1,IC2,NCBAND,LIGHT,LSHINE" },
{ "Arguments" },
{ "ARGUMENT  TYPE  I/O  DIMENSION  DESCRIPTION" },
{ "EYE:      R*4    I       3      (x,y,z) coordinate of eye-position." },
{ "LATICE:   R*4    I     3 x 3    (x,y,z) coordinates of the origin" },
{ "                                and the a and b lattice-vertices." },
{ "DENS:     R*4    I     (N1+1)   The density at regular points within" },
{ "                     x (N2+1)   the unit cell, wrapped around so" },
{ "                                that DENS(0,J)=DENS(N1,J) etc.." },
{ "N1,N2:    I*4    I       -      The dimensions of the unit-cell grid." },
{ "DLOW:     R*4    I       -      Lowest density to be plotted." },
{ "DHIGH:    R*4    I       -      Highest density to be plotted." },
{ "DVERT:    R*4    I       -      \"Vertical\" world-coordinate length" },
{ "                                corresponding to density-range." },
{ "IC1,IC2:  I*4    I       -      Lowest and highest colour-index to" },
{ "                                be used for the rendering." },
{ "NCBAND:   I*4    I       -      Number of colour-bands for the" },
{ "                                height, so that the number of shades" },
{ "                                per band = (IC2-IC1+1)/NCBAND." },
{ "LIGHT:    R*4    I       3      (x,y,z) direction of flood-light." },
{ "LSHINE:   L*1    I       -      Shiny surface if TRUE, else diffuse." }
}
},
{
{ "radialplot" }, {
{ "plots a radial average of x centered at [xcenter, ycenter] with a radius of r" },
{ "Syntax" },
{ "radialplot fits x, int xcenter, int ycenter, int r [,title=string] [,xtitle=string] [,ytitle=string]" }
}
},
{
{ "setfitskey" }, {
{ "add or change a FITS key in the header. value can be any of string, integer or double." },
{ "Syntax" },
{ "setfitskey fits x, string key, value, string comment" },
{ "See also" },
{ "function getfitskey" },
{ "procedure deletefitskey" }
}
},
{
{ "setbitpix" }, {
{ "Change pixel type of X." },
{ "Syntax" },
{ "setbitpix fits x, int bitpix, double bscale = 1.0, double bzero = 0.0" },
{ "See also" },
{ "function setbitpix" }
}
},
{
{ "cd" }, {
{ "change the current working directory." },
{ "Syntax" },
{ "cd string" }
}
},
{
{ "setwcs" }, {
{ "set WCS information in the FITS header." },
{ "Syntax" },
{ "setwcs fits, crpix1, crpix2, crval1, crval2, cdelt1 [, cdelt2]" }
}
},
{
{ "shrink" }, {
{ "See documentation for the function of the same name. The reason to supply this also as a procedure is that it can be used without creating a temporary copy of the argument in memory. X must be a named variable." },
{ "Syntax" },
{ "shrink X, factor [, axis]" },
{ "See also" },
{ "function shrink" }
}
},
{
{ "view" }, {
{ "Uses qtfitsview to display specified fits." },
{ "Syntax" },
{ "view X" }
}
},
{
{ "limits" }, {
{ "Returns the limits for which the array is non-zero in the given variables. At least xlow and xhigh must be given." },
{ "Syntax" },
{ "limits fits, xlow, xhigh [, ylow, yhigh, zlow, zhigh]" }
}
},
{
{ "printf" }, {
{ "Print the value (either a real number or an integer) using specified format string. The formatting is done like in the C printf function. The total length of the formatted string is limited to 256 characters." },
{ "Syntax" },
{ "printf format, value" }
}
},
{
{ "writebmp" }, {
{ "Write a bitmap (.bmp) file. If only red is given, this will be a grayscale image, else both green and blue must be given (which must be of the same size as red) and a color image will be written. The values in the fits are supposed to be scaled between 0 and 255." },
{ "Syntax" },
{ "writebmp filename, red [, green, blue]" },
{ "Arguments" },
{ "filename: A string giving the file name of the bitmap" },
{ "red: 2-dimensional array" },
{ "green: A 2-dimensional array of the same size as red" },
{ "blue: A 2-dimensional array of the same size as red" },
{ "Examples" },
{ "Write out a grayscale bitmap of a circular gaussian:" },
{ "writebmp \"gauss.bmp\", gauss(129,129,30)*255" }
}
},
{
{ "swapbytes" }, {
{ "Swap the bytes of given fits, which must be a variable." },
{ "Syntax" },
{ "swapbytes fits" }
}
},
{
{ "read" }, {
{ "Print prompt and read in up to 9 variables. The variables can be of integer, floating point or string type and must exist before the call." },
{ "Syntax" },
{ "read prompt, v1 [, v2, v3, v4, v5, v6, v7, v8, v9]" }
}
},
{
{ "shade" }, {
{ "Plot an image in a variety of ways - as provided by PGXTAL. This procedure asks for plot options interactively. Possible plots are contour, shaded surface, and colour plots with various colourtables." },
{ "Syntax" },
{ "shade fits" }
}
},
{
{ "cblank" }, {
{ "Replace all undefined values (like NaN or Inf) by another value. If no value is specified, 0.0 will be replaced." },
{ "Syntax" },
{ "cblank ARRAY [, value]" },
{ "Arguments" },
{ "ARRAY: A variable holding an array" },
{ "value: Optional, the value to be assigned (defaults to 0)" },
{ "See also" },
{ "function cblank" }
}
},
{
{ "cubemerge" }, {
{ "Merges several fits datacubes. All files must have the same array size (in the first two dimensions) and bitpix. The file name of the result must not be the same as any of the input names. The FITS header is copied from the first file and the NAXIS3 keyword is updated." },
{ "Syntax" },
{ "cubemerge result, cubes" },
{ "Arguments" },
{ "result: The filename where the datacube is written to" },
{ "cubes: A string array with the file names to be merged" }
}
},
{
{ "setenv" }, {
{ "Set or change an environment variable." },
{ "Syntax" },
{ "setenv VARIABLE, VALUE" },
{ "Arguments" },
{ "VARIABLE: A string with the name of the new environment variable" },
{ "VALUE: A string with the value of the new environment variable" },
{ "See also" },
{ "function getenv" }
}
},
{
{ "break" }, {
{ "Stop any currently running script or loop." },
{ "Syntax" },
{ "break" },
{ "Arguments" },
{ "none" }
}
},
{
{ "run" }, {
{ "Execute a script. This is equivalent to entering @script." },
{ "Syntax" },
{ "run S" },
{ "Arguments" },
{ "S: A string with the file name of the script to be executed." }
}
},
{
{ "echo" }, {
{ "Turn on or off echo mode. Echo mode determines if external scripts are echoed to the console." },
{ "Syntax" },
{ "echo mode" },
{ "Arguments" },
{ "mode: An integer number. 0 means echo off, any other number echo on." }
}
},
{
{ "precess" }, {
{ "Precess coordinates from one epoch to another." },
{ "Syntax" },
{ "precess RAh, RAm, RAs, DECd, DECm, DECs, fromepoch, toepoch" },
{ "Arguments" },
{ "RAh, RAm, RAs: Right Ascension of the object" },
{ "DECd, DECm, DECs: Declination of the object" },
{ "fromepoch: Epoch in which the coordinates are given" },
{ "toepoch: Epoch to which the coordinates should be precessed" }
}
},
{
{ "pwd" }, {
{ "Print current working directory" },
{ "Syntax" },
{ "pwd" },
{ "Arguments" },
{ "None" }
}
},
{
{ "dir" }, {
{ "Print directory listing." },
{ "Syntax" },
{ "dir [filter]" },
{ "Arguments" },
{ "filter: Print directory listing of files matching given pattern" }
}
},
{
{ "setindexbase" }, {
{ "Set the base for array indexing" },
{ "Syntax" },
{ "setindexbase base" },
{ "Arguments" },
{ "base: The index base, 0 for C-notation, 1 for Fortran-notation (the default)" },
{ "See also" },
{ "procedure cnotation" },
{ "procedure fortrannotation" },
{ "function indexbase" }
}
},
{
{ "fortrannotation" }, {
{ "Set the base for array indexing to 1 (the default for dpuser)" },
{ "Syntax" },
{ "fortrannotation" },
{ "Arguments" },
{ "none" },
{ "See also" },
{ "procedure setindexbase" },
{ "procedure cnotation" },
{ "function indexbase" }
}
},
{
{ "cnotation" }, {
{ "Set the base for array indexing to 0" },
{ "Syntax" },
{ "cnotation" },
{ "Arguments" },
{ "none" },
{ "See also" },
{ "procedure setindexbase" },
{ "procedure fortrannotation" },
{ "function indexbase" }
}
},
{
{ "userDialog" }, {
{ "Create a dialog box for QFitsView" },
{ "Syntax" },
{ "userDialog function, labels [, types [, values] ]" },
{ "Arguments" },
{ "title: A string with the dpuser function to be executed. This will be shown also as the caption of the dialog box." },
{ "labels: A string array with the description of the parameters to be entered" },
{ "types: Optional types of the arguments (as a string array): Can be either <b>int, real, fits</b>, or anything, in which case it will be treated as a string." },
{ "values: Optionally, default values for the entries can be given (as a string array)." },
{ "Examples" },
{ "Create a dialog box for the velmap function:" },
{ "userDialog \"myvelmap\", [\"cube\", \"wavelength center\", \"fwhm\"], [\"fits\", \"real\", \"real\"], [\"\", \"2.13\", \".001\"]" }
}
},
{
{ "compile" }, {
{ "Converts a dpuser-script into C-code, compiles it and links it at runtime into the running dpuser-session. Unlike with user defined functions or procedures, it is not allowed to compile a function with the same name as aalready compiled procedure and vice versa." },
{ "Syntax" },
{ "compile \"filename\"" },
{ "Arguments" },
{ "filename: The filename of the dpuser-script to convert" },
{ "Switches" },
{ "/c: Adds needed headers and forward declarations to existing C-code and links it on runtime. The general data type to use must be 'dpuserType'. Functions and procedures must begin like shown in the examples below." },
{ "/reset: Unloads all compiled functions and procedures. See example below." },
{ "Examples" },
{ "To compile c-code, functions must be defined as follows:" },
{ "extern \"C\" dpuserType funcName(dpuserType &a, ...) { ... }" },
{ "   ...;" },
{ "   return funcName;" },
{ "}" },
{ "<br>Procedures must be defined as follows:" },
{ "extern \"C\" void procName(dpuserType &a, ...) {" },
{ "   ...;" },
{ "   return;" },
{ "}" },
{ "<br>To unload all functions and procedures:" },
{ "compile \"\", /reset" }
}
},
{
{ "spec3d" }, {
{ "Draw an averaged spectrum of the cube multiplied by the mask." },
{ "Syntax" },
{ "spec3d cube, mask [,title=string] [,xtitle=string] [,ytitle=string]" },
{ "Arguments" },
{ "cube: A 3-dimensional matrix" },
{ "mask: A 2-dimensional matrix" }
}
},
{
{ "plot" }, {
{ "Plots the 1-dimensional vector y. If x is given, x versus y is plot, else the running number versus y is plot. ymin and ymax can be specified to set the plot range in the y axes. If symbol is given and >= -31, each point will be represented by a symbol, else the lines will be connected by a polyline. See \"help pgpt\" for a description of available symbols." },
{ "Syntax" },
{ "plot [x, ] y [,title=string] [,xtitle=string] [,ytitle=string] [,symbol=integer] [, ymin] [, ymax] [, /xlog] [, /ylog] [, /noclose]" },
{ "See also" },
{ "pgplot_pgpt" }
}
},
{
{ "free" }, {
{ "Release all memory taken by local variables." },
{ "Syntax" },
{ "free" }
}
},
{
{ "sao" }, {
{ "Uses ds9 to display X. ds9 v5.2 or newer needs to be running." },
{ "Syntax" },
{ "sao X [, min, max] [, /log, /zscale]" },
{ "Arguments" },
{ "X: A 2-dimensional matrix" },
{ "min, max: Minimum and maximum array value for display scaling" },
{ "Switches" },
{ "/log: display the image in logarithmic scaling." },
{ "/zscale: Use a display representation similar to IRAF's zscale." }
}
},
{
{ "cirrange" }, {
{ "Reduce a number to the range [0,360[ or [0,pi[." },
{ "Syntax" },
{ "cirrange VAR [, /deg, /rad]" },
{ "Arguments" },
{ "VAR: A named variable whose value should be reduced. This can be a real number or a vector/matrix." },
{ "Switches" },
{ "/deg: Reduce to [0,360[ (default)" },
{ "/rad: Reduce to [0,pi[" }
}
},
{
{ "swapaxes" }, {
{ "Swap axes of a 3D array" },
{ "Syntax" },
{ "swapaxes VAR, newx, newy, newz" },
{ "Arguments" },
{ "VAR: A named variable which contains a 3D FITS" },
{ "newx: Integer numer (1..3) which tells which axis shall become the X axis" },
{ "newy: Integer numer (1..3) which tells which axis shall become the Y axis" },
{ "newz: Integer numer (1..3) which tells which axis shall become the Z axis" },
{ "Notes" },
{ "The following FITS header keys are updated, if they exist:<br>" },
{ "CRVAL, CRPIX, CDELT, CD matrix, CTYPE, CUNIT" },
{ "Examples" },
{ "OSIRIS 3D data come in the format [lambda,x,y]. To convert this to [x,y,lambda]:" },
{ "swapaxes buffer, 2, 3, 1" }
}
},
{
{ "debug" }, {
{ "Turn on or off debug information." },
{ "Syntax" },
{ "debug mode" },
{ "Arguments" },
{ "mode: An integer number. 0 means debugging information off, any other number display debugging information." }
}
},
{
{ "copyheader" }, {
{ "Copy the FITS header from one matrix to another" },
{ "Syntax" },
{ "copyheader VAR, source" },
{ "Arguments" },
{ "VAR: A named variable of type fits which should receive the FITS header" },
{ "source: The matrix with the FITS header to be copied" }
}
},
{
{ "setfitstype" }, {
{ "Set the (FITS extension) type info of given fits to either image or bintable" },
{ "Syntax" },
{ "setfitstype VAR [, extension], [ /image, /bintable]" },
{ "Arguments" },
{ "VAR: A named variable which contains a FITS, a FITS list, or a string array" },
{ "extension: Optional in case of a FITS list, which element to set" },
{ "Switches" },
{ "/image: set the FITS type to image" },
{ "/bintable: set the FITS type to bintable" }
}
},
{
{ "watchdir" }, {
{ "Watch a directory and trigger an action when a new file matching given pattern is created (only available on QFitsView). The remove the watch, call the procedure with empty arguments" },
{ "Syntax" },
{ "watchdir directory, pattern, action" },
{ "Arguments" },
{ "directory: A string specifying the directory to watch" },
{ "pattern: A string, the file pattern to be matched" },
{ "action: A string, the dpuser script to be executed. The file name is marked as $$" },
{ "Examples" },
{ "To trigger reading the first extension of a FITS file when created in /tmp:" },
{ "watchdir \"/tmp\", \"*.fits\", \"hhh=readfitsextension($$, 1)\"" },
{ "Stop watching:" },
{ "watchdir \"\", \"\", \"\"" }
}
},
{
{ "message" }, {
{ "Print out a message on the terminal, or open a dialog box with the message in QFitsView" },
{ "Syntax" },
{ "message text [, /information | /warning | /critical]" },
{ "Arguments" },
{ "text: The message text to be displayed" },
{ "Switches" },
{ "the switch determines which icon to be displayed in the message box" }
}
},
{
{ "python" }, {
{ "Either enter PYTHON mode or execute given argument as PYTHON script" },
{ "Syntax" },
{ "python [script]" },
{ "Arguments" },
{ "script: A string with the script to execute" },
{ "Examples" },
{ "To print the integer number 10 using python:" },
{ "python \"print(10)\"" },
{ "To define a simple function as python module, callable then from DPUSER:" },
{ "python \"def add(a,b): return a+b\"" },
{ "print add(2,2)" }
}
},
{
{ "deletefitskey" }, {
{ "Delete a FITS key in the header." },
{ "Syntax" },
{ "deletefitskey fits x, string key" },
{ "See also" },
{ "function getfitskey" },
{ "procedure setfitskey" }
}
}
};
