This document aims to establish the necessary actions to update the xunit version in Arcade which then gets propagated into consuming repositories.

1. For security reasons, nuget packages need to be manually mirrored from nuget.org to the dotnet-public AzDO feed. [See the instructions](/Documentation/MirroringPackages.md). Mirror the following xunit packages: `xunit,xunit.console,xunit.runner.reporters,xunit.runner.utility,xunit.runner.console,xunit.runner.visualstudio` with version `latest`.
2. Update `XUnitVersion`, `XUnitAnalyzersVersion` and `XUnitRunnerVisualStudioVersion` properties in [Arcade SDK's DefaultVersions.props](/src/Microsoft.DotNet.Arcade.Sdk/tools/DefaultVersions.props) to the desired values. Make sure to use a coherent version of `xunit.analyzers`.
3. Update other hardcoded values of `XUnitVersion` inside the Arcade repository (i.e. in [SendingJobsToHelix.md](/Documentation/AzureDevOps/SendingJobsToHelix.md), [Directory.Packages.props](/Directory.Packages.props) and others).
4. Update Microsoft.DotNet.XUnitAssert which is an AOT compatible fork of the xunit.assert library by following [the instructions](/src/Microsoft.DotNet.XUnitAssert/README.md). It's likely that new XUnit versions introduce AOT incompatibilities which will cause the compiler (AOT analyzer) to fail. If you aren't sure how to resolve the errors, consult with @agocke's team who owns this library.
5. Submit a Pull request with these changes to [dotnet/arcade](https://github.com/dotnet/arcade) and tag @ViktorHofer as a reviewer.
6. Update the build from source compatible xunit/xunit fork in the [dotnet/source-build-externals](https://github.com/dotnet/source-build-externals) repository by following [the instructions](https://github.com/dotnet/source-build-externals?tab=readme-ov-file#updating-an-external-component-to-a-newer-version) and submit a Pull Request.
