// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

static class BaseTests
{
    public static (string templateFileName, Dictionary<string, string> templateData)[] ArmBaseInputs =
    {
        ("ScalarUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "LeadingZeroCount_Int32",                                                                                ["Isa"] = "ArmBase",                                ["Method"] = "LeadingZeroCount",                                                                                  ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "Int32",                                                                                                                                                          ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                        ["ValidateResult"] = "int expectedResult = 0; for (int index = 31; (((uint)data >> index) & 1) == 0; index--) { expectedResult++; } isUnexpectedResult = (expectedResult != result);" }),
        ("ScalarUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "LeadingZeroCount_UInt32",                                                                               ["Isa"] = "ArmBase",                                ["Method"] = "LeadingZeroCount",                                                                                  ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "UInt32",                                                                                                                                                         ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                       ["ValidateResult"] = "int expectedResult = 0; for (int index = 31; ((data >> index) & 1) == 0; index--) { expectedResult++; } isUnexpectedResult = (expectedResult != result);" }),
        ("ScalarUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "ReverseElementBits_Int32",                                                                              ["Isa"] = "ArmBase",                                ["Method"] = "ReverseElementBits",                                                                                ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "Int32",                                                                                                                                                          ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                        ["ValidateResult"] = "isUnexpectedResult = Helpers.ReverseElementBits(data) != result;" }),
        ("ScalarUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "ReverseElementBits_UInt32",                                                                             ["Isa"] = "ArmBase",                                ["Method"] = "ReverseElementBits",                                                                                ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                                                                                                                                         ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                       ["ValidateResult"] = "isUnexpectedResult = Helpers.ReverseElementBits(data) != result;" }),
    };

    public static (string templateFileName, Dictionary<string, string> templateData)[] ArmBase_Arm64Inputs =
    {
        ("ScalarUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "LeadingSignCount_Int32",                                                                                ["Isa"] = "ArmBase.Arm64",                          ["Method"] = "LeadingSignCount",                                                                                  ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "Int32",                                                                                                                                                          ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                        ["ValidateResult"] = "int expectedResult = 0; for (int index = 30; (((uint)data >> index) & 1) == (((uint)data >> 31) & 1); index--) { expectedResult++; } isUnexpectedResult = (expectedResult != result);" }),
        ("ScalarUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "LeadingSignCount_Int64",                                                                                ["Isa"] = "ArmBase.Arm64",                          ["Method"] = "LeadingSignCount",                                                                                  ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "Int64",                                                                                                                                                          ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                        ["ValidateResult"] = "int expectedResult = 0; for (int index = 62; (((ulong)data >> index) & 1) == (((ulong)data >> 63) & 1); index--) { expectedResult++; } isUnexpectedResult = (expectedResult != result);" }),
        ("ScalarUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "LeadingZeroCount_Int64",                                                                                ["Isa"] = "ArmBase.Arm64",                          ["Method"] = "LeadingZeroCount",                                                                                  ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "Int64",                                                                                                                                                          ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                        ["ValidateResult"] = "int expectedResult = 0; for (int index = 63; (((ulong)data >> index) & 1) == 0; index--) { expectedResult++; } isUnexpectedResult = (expectedResult != result);" }),
        ("ScalarUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "LeadingZeroCount_UInt64",                                                                               ["Isa"] = "ArmBase.Arm64",                          ["Method"] = "LeadingZeroCount",                                                                                  ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "UInt64",                                                                                                                                                         ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                       ["ValidateResult"] = "int expectedResult = 0; for (int index = 63; ((data >> index) & 1) == 0; index--) { expectedResult++; } isUnexpectedResult = (expectedResult != result);" }),
        ("ScalarBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyHigh_Int64",                                                                                    ["Isa"] = "ArmBase.Arm64",                          ["Method"] = "MultiplyHigh",                                                                                      ["RetBaseType"] = "Int64",                                    ["Op1BaseType"] = "Int64",                                   ["Op2BaseType"] = "Int64",                                                                                             ["NextValueOp1"] = "-TestLibrary.Generator.GetInt64()",        ["NextValueOp2"] = "-TestLibrary.Generator.GetInt64()",        ["ValidateResult"] = "isUnexpectedResult = Helpers.MultiplyHigh(left, right) != result;" }),
        ("ScalarBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyHigh_UInt64",                                                                                   ["Isa"] = "ArmBase.Arm64",                          ["Method"] = "MultiplyHigh",                                                                                      ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt64",                                  ["Op2BaseType"] = "UInt64",                                                                                            ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["ValidateResult"] = "isUnexpectedResult = Helpers.MultiplyHigh(left, right) != result;" }),
        ("ScalarUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "ReverseElementBits_Int64",                                                                              ["Isa"] = "ArmBase.Arm64",                          ["Method"] = "ReverseElementBits",                                                                                ["RetBaseType"] = "Int64",                                    ["Op1BaseType"] = "Int64",                                                                                                                                                          ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                        ["ValidateResult"] = "isUnexpectedResult = Helpers.ReverseElementBits(data) != result;" }),
        ("ScalarUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "ReverseElementBits_UInt64",                                                                             ["Isa"] = "ArmBase.Arm64",                          ["Method"] = "ReverseElementBits",                                                                                ["RetBaseType"] = "UInt64",                                   ["Op1BaseType"] = "UInt64",                                                                                                                                                         ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                       ["ValidateResult"] = "isUnexpectedResult = Helpers.ReverseElementBits(data) != result;" }),
    };

    public static (string templateFileName, Dictionary<string, string> templateData)[] Crc32Inputs =
    {
        ("ScalarBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ComputeCrc32_Byte",                                                                                     ["Isa"] = "Crc32",                                  ["Method"] = "ComputeCrc32",                                                                                      ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                                                                              ["NextValueOp1"] = "0xFFFFFFFF",                               ["NextValueOp2"] = "0x20",                                     ["ValidateResult"] = "uint expectedResult = 0x169330BA; isUnexpectedResult = (expectedResult != result);" }),
        ("ScalarBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ComputeCrc32_UInt16",                                                                                   ["Isa"] = "Crc32",                                  ["Method"] = "ComputeCrc32",                                                                                      ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt16",                                                                                            ["NextValueOp1"] = "0xFFFFFFFF",                               ["NextValueOp2"] = "0x2019",                                   ["ValidateResult"] = "uint expectedResult = 0x1E4864D0; isUnexpectedResult = (expectedResult != result);" }),
        ("ScalarBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ComputeCrc32_UInt32",                                                                                   ["Isa"] = "Crc32",                                  ["Method"] = "ComputeCrc32",                                                                                      ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32",                                                                                            ["NextValueOp1"] = "0xFFFFFFFF",                               ["NextValueOp2"] = "0x20191113",                               ["ValidateResult"] = "uint expectedResult = 0x219D9805; isUnexpectedResult = (expectedResult != result);" }),
        ("ScalarBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ComputeCrc32C_Byte",                                                                                    ["Isa"] = "Crc32",                                  ["Method"] = "ComputeCrc32C",                                                                                     ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "Byte",                                                                                              ["NextValueOp1"] = "0xFFFFFFFF",                               ["NextValueOp2"] = "0x20",                                     ["ValidateResult"] = "uint expectedResult = 0x8D3F2270; isUnexpectedResult = (expectedResult != result);" }),
        ("ScalarBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ComputeCrc32C_UInt16",                                                                                  ["Isa"] = "Crc32",                                  ["Method"] = "ComputeCrc32C",                                                                                     ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt16",                                                                                            ["NextValueOp1"] = "0xFFFFFFFF",                               ["NextValueOp2"] = "0x2019",                                   ["ValidateResult"] = "uint expectedResult = 0x9F50ACBD; isUnexpectedResult = (expectedResult != result);" }),
        ("ScalarBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ComputeCrc32C_UInt32",                                                                                  ["Isa"] = "Crc32",                                  ["Method"] = "ComputeCrc32C",                                                                                     ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt32",                                                                                            ["NextValueOp1"] = "0xFFFFFFFF",                               ["NextValueOp2"] = "0x20191113",                               ["ValidateResult"] = "uint expectedResult = 0x78F34758; isUnexpectedResult = (expectedResult != result);" }),
    };

    public static (string templateFileName, Dictionary<string, string> templateData)[] Crc32_Arm64Inputs =
    {
        ("ScalarBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ComputeCrc32_UInt64",                                                                                   ["Isa"] = "Crc32.Arm64",                            ["Method"] = "ComputeCrc32",                                                                                      ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt64",                                                                                            ["NextValueOp1"] = "0xFFFFFFFF",                               ["NextValueOp2"] = "0x20191113110219UL",                       ["ValidateResult"] = "uint expectedResult = 0xEFAAAB74; isUnexpectedResult = (expectedResult != result);" }),
        ("ScalarBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ComputeCrc32C_UInt64",                                                                                  ["Isa"] = "Crc32.Arm64",                            ["Method"] = "ComputeCrc32C",                                                                                     ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                  ["Op2BaseType"] = "UInt64",                                                                                            ["NextValueOp1"] = "0xFFFFFFFF",                               ["NextValueOp2"] = "0x20191113110219UL",                       ["ValidateResult"] = "uint expectedResult = 0x6295C71A; isUnexpectedResult = (expectedResult != result);" }),
    };
}
