#!/usr/bin/env bash
## Test for issue1290 - darcs diff --index
##
## Copyright (C) 2010 Eric Kow
##
## Permission is hereby granted, free of charge, to any person
## obtaining a copy of this software and associated documentation
## files (the "Software"), to deal in the Software without
## restriction, including without limitation the rights to use, copy,
## modify, merge, publish, distribute, sublicense, and/or sell copies
## of the Software, and to permit persons to whom the Software is
## furnished to do so, subject to the following conditions:
##
## The above copyright notice and this permission notice shall be
## included in all copies or substantial portions of the Software.
##
## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
## EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
## MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
## NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
## BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
## ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
## CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
## SOFTWARE.

. lib                           # Load some portability helpers.
rm -rf R                        # Another script may have left a mess.
darcs init      --repo R        # Create our test repos.

cd R
 echo '1' > f
 darcs record -lam 'one'
 echo '2' > f
 darcs record -lam 'two'
 echo '3' > f
 darcs record -lam 'three'
 echo '4' > f
 darcs record -lam 'four'
 # in the following outputs of `darcs diff`, we delete the
 # lines "diff -rN old-... new-..." since they can be different
 # if tests are run in parallel
 darcs diff --no-unified --from-patch one --to-patch two | sed /^diff/d > d1
 darcs diff --no-unified --index=3-4 |sed /^diff/d > d2 # the numbers go backwards
 diff -q d1 d2
cd ..
