/* $Id: hdrl_flat.h,v 1.2 2013-10-16 16:52:20 cgarcia Exp $
 *
 * This file is part of the HDRL
 * Copyright (C) 2013 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Author: cgarcia $
 * $Date: 2013-10-16 16:52:20 $
 * $Revision: 1.2 $
 * $Name: not supported by cvs2svn $
 */

#ifndef HDRL_FLAT_H
#define HDRL_FLAT_H

/*-----------------------------------------------------------------------------
                                Includes
 -----------------------------------------------------------------------------*/

#include "hdrl_collapse.h"
#include <cpl.h>

/*-----------------------------------------------------------------------------
                                Define
 -----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
                            Functions prototypes
 -----------------------------------------------------------------------------*/
CPL_BEGIN_DECLS

cpl_error_code hdrl_compute_flat_median_smooth(const cpl_imagelist *, 
        const cpl_imagelist *, hdrl_collapse_imagelist_to_image_t *, cpl_size, 
        cpl_image *, cpl_image *, cpl_image **, cpl_image **, cpl_image **);

cpl_error_code hdrl_compute_flat_gauss_smooth(const cpl_imagelist *, 
        const cpl_imagelist *, hdrl_collapse_imagelist_to_image_t *, cpl_size, 
        cpl_size, cpl_size, cpl_image *, cpl_image *, cpl_image **, 
        cpl_image **, cpl_image **);

cpl_error_code hdrl_compute_flat_median_step_fit(const cpl_imagelist *, 
        const cpl_imagelist *, hdrl_collapse_imagelist_to_image_t *, cpl_size, 
        cpl_size, cpl_size, cpl_size, int, int, cpl_image *, cpl_image *, 
        cpl_image **, cpl_image **, cpl_image **);
CPL_END_DECLS

/*-----------------------------------------------------------------------------
             Private declarations - must not be used outside of hdrl
 -----------------------------------------------------------------------------*/

#ifdef HDRL_USE_PRIVATE

#endif

#endif

