<?php

/**
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 *
 * Generated from xml/schema/CRM/Core/Cache.xml
 * DO NOT EDIT.  Generated by CRM_Core_CodeGen
 * (GenCodeChecksum:4d3ccecb7d91aa67b8c78c3c39933ae8)
 */

/**
 * Database access object for the Cache entity.
 */
class CRM_Core_DAO_Cache extends CRM_Core_DAO {

  /**
   * Static instance to hold the table name.
   *
   * @var string
   */
  public static $_tableName = 'civicrm_cache';

  /**
   * Should CiviCRM log any modifications to this table in the civicrm_log table.
   *
   * @var bool
   */
  public static $_log = FALSE;

  /**
   * Unique table ID
   *
   * @var int
   */
  public $id;

  /**
   * group name for cache element, useful in cleaning cache elements
   *
   * @var string
   */
  public $group_name;

  /**
   * Unique path name for cache element
   *
   * @var string
   */
  public $path;

  /**
   * data associated with this path
   *
   * @var longtext
   */
  public $data;

  /**
   * Component that this menu item belongs to
   *
   * @var int
   */
  public $component_id;

  /**
   * When was the cache item created
   *
   * @var timestamp
   */
  public $created_date;

  /**
   * When should the cache item expire
   *
   * @var timestamp
   */
  public $expired_date;

  /**
   * Class constructor.
   */
  public function __construct() {
    $this->__table = 'civicrm_cache';
    parent::__construct();
  }

  /**
   * Returns foreign keys and entity references.
   *
   * @return array
   *   [CRM_Core_Reference_Interface]
   */
  public static function getReferenceColumns() {
    if (!isset(Civi::$statics[__CLASS__]['links'])) {
      Civi::$statics[__CLASS__]['links'] = static::createReferenceColumns(__CLASS__);
      Civi::$statics[__CLASS__]['links'][] = new CRM_Core_Reference_Basic(self::getTableName(), 'component_id', 'civicrm_component', 'id');
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'links_callback', Civi::$statics[__CLASS__]['links']);
    }
    return Civi::$statics[__CLASS__]['links'];
  }

  /**
   * Returns all the column names of this table
   *
   * @return array
   */
  public static function &fields() {
    if (!isset(Civi::$statics[__CLASS__]['fields'])) {
      Civi::$statics[__CLASS__]['fields'] = [
        'id' => [
          'name' => 'id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Cache ID'),
          'description' => ts('Unique table ID'),
          'required' => TRUE,
          'where' => 'civicrm_cache.id',
          'table_name' => 'civicrm_cache',
          'entity' => 'Cache',
          'bao' => 'CRM_Core_BAO_Cache',
          'localizable' => 0,
        ],
        'group_name' => [
          'name' => 'group_name',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Group Name'),
          'description' => ts('group name for cache element, useful in cleaning cache elements'),
          'required' => TRUE,
          'maxlength' => 32,
          'size' => CRM_Utils_Type::MEDIUM,
          'where' => 'civicrm_cache.group_name',
          'table_name' => 'civicrm_cache',
          'entity' => 'Cache',
          'bao' => 'CRM_Core_BAO_Cache',
          'localizable' => 0,
        ],
        'path' => [
          'name' => 'path',
          'type' => CRM_Utils_Type::T_STRING,
          'title' => ts('Path'),
          'description' => ts('Unique path name for cache element'),
          'maxlength' => 255,
          'size' => CRM_Utils_Type::HUGE,
          'where' => 'civicrm_cache.path',
          'table_name' => 'civicrm_cache',
          'entity' => 'Cache',
          'bao' => 'CRM_Core_BAO_Cache',
          'localizable' => 0,
        ],
        'data' => [
          'name' => 'data',
          'type' => CRM_Utils_Type::T_LONGTEXT,
          'title' => ts('Data'),
          'description' => ts('data associated with this path'),
          'where' => 'civicrm_cache.data',
          'table_name' => 'civicrm_cache',
          'entity' => 'Cache',
          'bao' => 'CRM_Core_BAO_Cache',
          'localizable' => 0,
        ],
        'component_id' => [
          'name' => 'component_id',
          'type' => CRM_Utils_Type::T_INT,
          'title' => ts('Component ID'),
          'description' => ts('Component that this menu item belongs to'),
          'where' => 'civicrm_cache.component_id',
          'table_name' => 'civicrm_cache',
          'entity' => 'Cache',
          'bao' => 'CRM_Core_BAO_Cache',
          'localizable' => 0,
          'FKClassName' => 'CRM_Core_DAO_Component',
          'html' => [
            'type' => 'Select',
          ],
          'pseudoconstant' => [
            'table' => 'civicrm_component',
            'keyColumn' => 'id',
            'labelColumn' => 'name',
          ],
        ],
        'created_date' => [
          'name' => 'created_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Created Date'),
          'description' => ts('When was the cache item created'),
          'where' => 'civicrm_cache.created_date',
          'default' => 'CURRENT_TIMESTAMP',
          'table_name' => 'civicrm_cache',
          'entity' => 'Cache',
          'bao' => 'CRM_Core_BAO_Cache',
          'localizable' => 0,
        ],
        'expired_date' => [
          'name' => 'expired_date',
          'type' => CRM_Utils_Type::T_TIMESTAMP,
          'title' => ts('Expired Date'),
          'description' => ts('When should the cache item expire'),
          'required' => FALSE,
          'where' => 'civicrm_cache.expired_date',
          'default' => 'NULL',
          'table_name' => 'civicrm_cache',
          'entity' => 'Cache',
          'bao' => 'CRM_Core_BAO_Cache',
          'localizable' => 0,
        ],
      ];
      CRM_Core_DAO_AllCoreTables::invoke(__CLASS__, 'fields_callback', Civi::$statics[__CLASS__]['fields']);
    }
    return Civi::$statics[__CLASS__]['fields'];
  }

  /**
   * Return a mapping from field-name to the corresponding key (as used in fields()).
   *
   * @return array
   *   Array(string $name => string $uniqueName).
   */
  public static function &fieldKeys() {
    if (!isset(Civi::$statics[__CLASS__]['fieldKeys'])) {
      Civi::$statics[__CLASS__]['fieldKeys'] = array_flip(CRM_Utils_Array::collect('name', self::fields()));
    }
    return Civi::$statics[__CLASS__]['fieldKeys'];
  }

  /**
   * Returns the names of this table
   *
   * @return string
   */
  public static function getTableName() {
    return self::$_tableName;
  }

  /**
   * Returns if this table needs to be logged
   *
   * @return bool
   */
  public function getLog() {
    return self::$_log;
  }

  /**
   * Returns the list of fields that can be imported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &import($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getImports(__CLASS__, 'cache', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of fields that can be exported
   *
   * @param bool $prefix
   *
   * @return array
   */
  public static function &export($prefix = FALSE) {
    $r = CRM_Core_DAO_AllCoreTables::getExports(__CLASS__, 'cache', $prefix, []);
    return $r;
  }

  /**
   * Returns the list of indices
   *
   * @param bool $localize
   *
   * @return array
   */
  public static function indices($localize = TRUE) {
    $indices = [
      'UI_group_path_date' => [
        'name' => 'UI_group_path_date',
        'field' => [
          0 => 'group_name',
          1 => 'path',
          2 => 'created_date',
        ],
        'localizable' => FALSE,
        'unique' => TRUE,
        'sig' => 'civicrm_cache::1::group_name::path::created_date',
      ],
    ];
    return ($localize && !empty($indices)) ? CRM_Core_DAO_AllCoreTables::multilingualize(__CLASS__, $indices) : $indices;
  }

}
