//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Job/JobProgressAssistant.h
//! @brief     Defines class JobProgressAssistant
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_JOB_JOBPROGRESSASSISTANT_H
#define BORNAGAIN_GUI_VIEW_JOB_JOBPROGRESSASSISTANT_H

#include <QObject>

class MainWindow;
class JobModel;
class QProgressBar;

//! The JobProgressAssistant class helps JobView to visualize current progress.

class JobProgressAssistant : public QObject {
    Q_OBJECT
public:
    JobProgressAssistant(QProgressBar* proressBar, JobModel* jobModel);

private slots:
    void onGlobalProgress(int progress);

private:
    QProgressBar* m_progressBar;
};

#endif // BORNAGAIN_GUI_VIEW_JOB_JOBPROGRESSASSISTANT_H
