//
// BAGEL - Parallel electron correlation program.
// Filename: _eriroot_15.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// The BAGEL package is free software; you can redistribute it and/or modify
// it under the terms of the GNU Library General Public License as published by
// the Free Software Foundation; either version 3, or (at your option)
// any later version.
//
// The BAGEL package is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public License
// along with the BAGEL package; see COPYING.  If not, write to
// the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot15(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[15] = {4.045270430457533e-02,3.647206450514084e-01,1.016746068857496e+00,2.003718953133924e+00,3.336983205734510e+00,
    5.032805277625120e+00,7.113593769729874e+00,9.609817284304444e+00,1.256308236994850e+01,1.603128410807399e+01,2.009778533475592e+01,2.488931247515657e+01,
    3.061571740089946e+01,3.767847178420530e+01,4.710550861821894e+01};
  constexpr double aw[15] = {3.863948895418138e-01,2.801309308392126e-01,1.467358475408904e-01,5.514417687023432e-02,1.470382970482671e-02,
    2.737922473067643e-03,3.483101243186879e-04,2.938725228922982e-05,1.579094887324716e-06,5.108522450775959e-08,9.178580424378688e-10,8.106186297462897e-12,
    2.878607080548789e-14,2.810333602750870e-17,2.908254700131161e-21};
  constexpr double x[5760] = {  5.131568429400928e-03, -8.256196357589432e-05,  9.936955479904116e-07, -1.059573866833442e-08,  1.054645613946593e-10,
 -1.002544709169358e-12,  9.207625381239939e-15, -8.223487062409958e-17,  7.167397469311344e-19, -6.107678343465886e-21,  5.090986281287950e-23, -4.148435634707592e-25,
  4.588766276797283e-02, -7.236728143234322e-04,  8.362235640466309e-06, -8.313336325886091e-08,  7.406152200963195e-10, -5.941917138601663e-12,  4.200863740851781e-14,
 -2.433028308194579e-16,  8.421398760459940e-19,  4.242905242923270e-21, -1.283158348374167e-22,  1.714045645343626e-24,  1.258279089059138e-01, -1.905617627561940e-03,
  2.021945391407906e-05, -1.714957180388673e-07,  1.133547543780823e-09, -4.548253685346057e-12, -1.483124563061434e-14,  5.430554846197207e-16, -6.660553233971919e-18,
  5.339868799752374e-20, -2.331244680233715e-22, -1.111684896375380e-24,  2.418525070879780e-01, -3.442386356316855e-03,  3.178516198931688e-05, -1.979276200829037e-07,
  4.302612732837095e-10,  8.231220046259223e-12, -1.322705559979034e-13,  9.834663119847370e-16, -1.183846553897713e-18, -7.297362966155372e-20,  1.071851179940011e-21,
 -7.317419204324720e-24,  3.894228841359267e-01, -5.089604937838724e-03,  3.803110936475665e-05, -1.142472922500849e-07, -1.234851334393784e-09,  2.007506855086863e-11,
 -9.998433550436663e-14, -7.336505064394846e-16,  1.696490968443862e-17, -1.098766737542078e-19, -5.142617615891330e-22,  1.698470204698475e-23,  5.626973824139008e-01,
 -6.581375591940043e-03,  3.547507689429404e-05,  6.284208118089663e-08, -2.650942407861677e-09,  1.374160425193751e-11,  1.267643672842710e-13, -2.221098024403540e-15,
  4.570706455711336e-18,  1.920797296929759e-19, -2.005126004450715e-21, -4.929359695949881e-24,  7.547153893360296e-01, -7.671793859989656e-03,  2.351226292093068e-05,
  2.545210791910536e-07, -2.504903790104933e-09, -9.992693030630743e-12,  2.641052864532036e-13, -1.837725551809528e-16, -2.607010623082515e-17,  1.371428908805644e-19,
  2.245125175994405e-21, -2.596722694101373e-23,  9.576312224765698e-01, -8.175271523380481e-03,  4.792859851052441e-06,  3.619602612834925e-07, -6.066644727962699e-10,
 -2.860737750567920e-11,  8.034521566323148e-14,  2.725877281799227e-15, -1.092738649855296e-17, -2.851732249541385e-19,  1.508519032029418e-21,  3.147019851676435e-23,
  1.162997507352293e+00, -7.999309975354335e-03, -1.555550836260821e-05,  3.246956807044409e-07,  1.780364913059513e-09, -2.187612006772861e-11, -2.158761652956271e-13,
  1.590733385922065e-15,  2.659995857038013e-17, -1.020185323791844e-19, -3.270070597777658e-21,  2.875465545341805e-24,  1.362094873437289e+00, -7.163738950377611e-03,
 -3.166483113547852e-05,  1.596379326864726e-07,  2.921664602968841e-09,  3.677812153665456e-12, -2.388931889343882e-13, -1.781198045634754e-15,  1.354503804613174e-17,
  2.743894188823662e-19,  2.283032272805926e-22, -2.980194985058150e-23,  1.546300418558975e+00, -5.801889336918212e-03, -3.904736308317578e-05, -4.600796099135056e-08,
  2.097664191739486e-09,  2.140374550504494e-11,  9.277537951506506e-15, -1.906382629613957e-15, -1.866855883622371e-17,  1.945892480846360e-20,  2.178611787920945e-21,
  1.905445623376010e-23,  1.707481733442011e+00, -4.141785277737660e-03, -3.631115187999483e-05, -1.868155786307994e-07,  2.112135767395396e-10,  1.582945207770812e-11,
  1.644629805629377e-13,  5.518803400925977e-16, -8.630478928642422e-18, -1.595875273284288e-19, -1.119571657091161e-21,  2.400563050074407e-24,  1.838397046446361e+00,
 -2.469012270802226e-03, -2.575770819824469e-05, -2.045385983705260e-07, -1.108027212623221e-09, -8.008946744552982e-13,  7.180452771950105e-14,  1.060182742170117e-15,
  8.893765530820206e-18,  3.368104526135083e-20, -3.287523015494341e-22, -8.066457975049229e-24,  1.933077096781341e+00, -1.076843876930093e-03, -1.253768337931421e-05,
 -1.232177698531048e-07, -1.052915414073429e-09, -7.667186595460256e-12, -4.308518785735901e-14, -1.027508761402936e-16,  1.675565771972129e-18,  3.444595737695588e-20,
  4.116190494729142e-22,  3.735473644007222e-24,  1.987173709647824e+00, -2.123554069690216e-04, -2.619834733505751e-06, -2.847861264054503e-08, -2.869793287687684e-10,
 -2.737498081323513e-12, -2.494965182170197e-14, -2.179730014575891e-16, -1.823679003597148e-18, -1.453496075029075e-20, -1.090929811406217e-22, -7.529819529463572e-25,
  4.816453010758359e-03, -7.509375785431482e-05,  8.760464631069990e-07, -9.057444814331922e-09,  8.744956938233197e-11, -8.067908351589367e-13,  7.195701855703183e-15,
 -6.245729476660006e-17,  5.295111101532081e-19, -4.394112462939656e-21,  3.571653116728503e-23, -2.843260088330341e-25,  4.312072206852752e-02, -6.605725703847960e-04,
  7.431983928049359e-06, -7.218170718602679e-08,  6.313233583332731e-10, -5.012305299700575e-12,  3.559012308263054e-14, -2.147672808879974e-16,  9.186072751959991e-19,
  3.963787465724156e-22, -6.894058148603604e-23,  1.035203224166193e-24,  1.185163420222891e-01, -1.751792480795002e-03,  1.826727449840586e-05, -1.541012591921281e-07,
  1.040137445688000e-09, -4.744111422498710e-12, -2.333870508440110e-15,  3.588083303949380e-16, -4.913618722440753e-18,  4.354460588743102e-20, -2.502205728434161e-22,
  1.807386809856369e-25,  2.285766621157027e-01, -3.197477118171370e-03,  2.945623485926900e-05, -1.898896680310228e-07,  5.653398450989150e-10,  5.380743429443014e-12,
 -1.056034506474419e-13,  9.111955625906430e-16, -3.116587652320140e-18, -3.649785859725176e-20,  7.556460503268073e-22, -6.827431058600026e-24,  3.696638442835495e-01,
 -4.791146175833647e-03,  3.655440680974098e-05, -1.309292108175923e-07, -8.587089992396930e-10,  1.748652024749429e-11, -1.135413235341847e-13, -2.566851960339261e-16,
  1.280175340582358e-17, -1.174163456675798e-19,  8.995701373410757e-23,  1.051735025860627e-23,  5.369432680774907e-01, -6.295257755540493e-03,  3.598423941691174e-05,
  2.277018890457671e-08, -2.350613832315890e-09,  1.606001714411234e-11,  6.754905677813751e-14, -1.979891079796214e-15,  1.002121711408489e-17,  1.109424138626693e-19,
 -1.975897052693127e-21,  5.465655826734746e-24,  7.244227745964147e-01, -7.472173045399063e-03,  2.632055678655203e-05,  2.131847994826281e-07, -2.642254944412359e-09,
 -3.805058737320053e-12,  2.481326366879446e-13, -9.240134120580097e-16, -1.980465548650346e-17,  2.028152680344704e-19,  1.022768087633802e-21, -2.815523446783440e-23,
  9.250340418427991e-01, -8.119762241755882e-03,  9.059670644394274e-06,  3.478063420501590e-07, -1.153589624553984e-09, -2.581171723084230e-11,  1.503286837552127e-13,
  2.226092004626451e-15, -1.980534286513411e-17, -2.007086835149108e-19,  2.613836853974800e-21,  1.770824157149473e-23,  1.130776693805184e+00, -8.107719388895644e-03,
 -1.150354983130884e-05,  3.494166596205094e-07,  1.295119465650460e-09, -2.643075992290164e-11, -1.601478668368083e-13,  2.358509274294001e-15,  2.065464246840268e-17,
 -2.246618877402114e-19, -2.724387450424850e-21,  2.167141009927035e-23,  1.332946539462656e+00, -7.408596799750012e-03, -2.946732182606920e-05,  2.066455407249458e-07,
  2.934138600582144e-09, -2.596004413606839e-12, -2.812166791474898e-13, -1.190676782219710e-15,  2.324675939494485e-17,  2.546895712542017e-19, -1.264265057728973e-21,
 -3.671665146629007e-23,  1.522465455176427e+00, -6.115873541746730e-03, -3.938396967418136e-05, -9.027985490583790e-09,  2.523298221125787e-09,  2.091964431934916e-11,
 -5.223030534902109e-14, -2.474180597646299e-15, -1.620885546194954e-17,  1.220016034871481e-19,  2.900419364849012e-21,  1.241638727513498e-23,  1.690319530529194e+00,
 -4.441158712803245e-03, -3.852150734067173e-05, -1.806843678684926e-07,  5.683404834895177e-10,  1.992517769624656e-11,  1.751257388397044e-13,  1.754851736856680e-16,
 -1.513475464395361e-17, -1.998349298426725e-19, -8.251434022740709e-22,  1.168992789277562e-23,  1.828092902841306e+00, -2.685193729038592e-03, -2.831873827971417e-05,
 -2.222908589722309e-07, -1.104236954061741e-09,  1.311806243188444e-12,  1.056338318740595e-13,  1.360872313082497e-15,  9.771919530987583e-18,  1.208305849286283e-20,
 -7.867458656810911e-22, -1.294669742760744e-23,  1.928559333639346e+00, -1.183358213410608e-03, -1.412262120823810e-05, -1.413482027461066e-07, -1.216796014245903e-09,
 -8.728428766820565e-12, -4.500051180225278e-14, -2.577065961012457e-17,  3.254966067879643e-18,  5.457030089802481e-20,  6.040862027910241e-22,  5.034553021945950e-24,
  1.986280090324219e+00, -2.347634997983727e-04, -2.991046206468195e-06, -3.354301618477843e-08, -3.482478172512636e-10, -3.416638355685484e-12, -3.195496652546024e-14,
 -2.856138430787503e-16, -2.434077642792641e-18, -1.962880321454211e-20, -1.473537365312560e-22, -9.937206644194826e-25,  4.529438394123167e-03, -6.849752539605180e-05,
  7.752486510771019e-07, -7.778516967881192e-09,  7.290837727435208e-11, -6.533018103286638e-13,  5.662170425108461e-15, -4.779093587275728e-17,  3.942872021625631e-19,
 -3.187265909552758e-21,  2.526428180785739e-23, -1.964381603164510e-25,  4.059209047133081e-02, -6.044170280443801e-04,  6.623247252756484e-06, -6.283807760531820e-08,
  5.391489498989287e-10, -4.226986268890120e-12,  2.998699872305210e-14, -1.855953863980778e-16,  8.929079918818739e-19, -1.590980996152606e-21, -3.353254441799491e-23,
  6.074906943545552e-25,  1.117901266952634e-01, -1.612775442962838e-03,  1.651478021401263e-05, -1.382180471842400e-07,  9.454229369411774e-10, -4.695952320119156e-12,
  5.733508871391240e-15,  2.247512649620758e-16, -3.522299455936816e-18,  3.390124977318876e-20, -2.278654477242171e-22,  7.462508105442198e-25,  2.162438485839799e-01,
 -2.970780844672059e-03,  2.723495987363721e-05, -1.801125602445426e-07,  6.496137962054346e-10,  3.140133077907810e-12, -8.164544165309531e-14,  7.957092638574339e-16,
 -3.955557577539481e-18, -1.191152588947032e-20,  4.836934299059179e-22, -5.462505625656517e-24,  3.510738835451971e-01, -4.505203483656152e-03,  3.491187694041995e-05,
 -1.420204298750162e-07, -5.365878519285268e-10,  1.471771293396786e-11, -1.156191089022027e-13,  8.683300096869887e-17,  8.735086010360332e-18, -1.062979510756233e-19,
  4.255499535858521e-22,  4.979349048392842e-24,  5.123388455790288e-01, -6.006905345380101e-03,  3.604265785541183e-05, -1.220010030690220e-08, -2.017491113847092e-09,
  1.705534684298180e-11,  1.709662106073611e-14, -1.609969027116613e-15,  1.266886964754823e-17,  3.866776048484105e-20, -1.598466945240449e-21,  1.088375292737858e-23,
  6.949703937058829e-01, -7.252098144183886e-03,  2.862362773542783e-05,  1.706134796144733e-07, -2.661240592032394e-09,  1.775012114395994e-12,  2.145279375899047e-13,
 -1.435411269222916e-15, -1.205626941259309e-17,  2.200500385302301e-19, -1.227712819951121e-22, -2.296230341411121e-23,  8.927258879090303e-01, -8.030941809079513e-03,
  1.310625603165346e-05,  3.254348876871966e-07, -1.629092028862041e-09, -2.153340071786356e-11,  2.028514586205193e-13,  1.498116920772601e-15, -2.500670274395223e-17,
 -8.559801379277293e-20,  3.015584473425817e-21,  4.912979633555563e-25,  1.098188757909962e+00, -8.182664930341636e-03, -7.204274852082803e-06,  3.657245106952325e-07,
  7.337695858170104e-10, -2.941533594014039e-11, -8.620991423594779e-14,  2.871174043591200e-15,  1.087838353669791e-17, -3.099103739338953e-19, -1.436438655823853e-21,
  3.553167951935944e-23,  1.302857498620337e+00, -7.633624680867764e-03, -2.670882635644338e-05,  2.527999726259726e-07,  2.812494916829938e-09, -9.653167340368721e-12,
 -3.028506570968635e-13, -3.130090915607872e-16,  3.111545426555405e-17,  1.719161578604561e-19, -2.850550490160535e-21, -3.340554878775926e-23,  1.497372141532400e+00,
 -6.430661070980531e-03, -3.923654929358387e-05,  3.459927215390664e-08,  2.923261692179481e-09,  1.878106241474842e-11, -1.279438871803236e-13, -2.899350031297206e-15,
 -9.630869033947614e-18,  2.450802293927340e-19,  3.141908295214242e-21, -2.889048229010068e-24,  1.671925079595318e+00, -4.757817258646400e-03, -4.062126671566085e-05,
 -1.681739288680991e-07,  1.008960431039427e-09,  2.412558492310306e-11,  1.721388995190387e-13, -4.290826419909432e-16, -2.276620287353111e-17, -2.189055421478528e-19,
 -3.189231669177807e-23,  2.490143066369881e-23,  1.816881713818097e+00, -2.922710993170208e-03, -3.109088640967738e-05, -2.395974207102123e-07, -1.049378812864160e-09,
  4.339761962490322e-12,  1.481312348616022e-13,  1.673247965514992e-15,  9.488263382488607e-18, -3.242256567159675e-20, -1.479767779129430e-21, -1.858097539127873e-23,
  1.923588711160915e+00, -1.303468514052182e-03, -1.594156301009584e-05, -1.622721768539237e-07, -1.402153985482862e-09, -9.803336912802410e-12, -4.393265717523881e-14,
  1.149410004983794e-16,  5.711374322186658e-18,  8.355139352083089e-20,  8.541612348197587e-22,  6.286668142840415e-24,  1.985290489384104e+00, -2.604021358187874e-04,
 -3.429391979905883e-06, -3.970619884772562e-08, -4.249459624888750e-10, -4.289021236252920e-12, -4.115748088800602e-14, -3.760383431804704e-16, -3.258068664979760e-18,
 -2.647709871984463e-20, -1.970754177307150e-22, -1.269532160673262e-24,  4.267287849057941e-03, -6.265002113124697e-05,  6.884972052735808e-07, -6.709558362354242e-09,
  6.109981477664250e-11, -5.321411765616731e-13,  4.484713900686861e-15, -3.683029155019312e-17,  2.958310903861208e-19, -2.330332262505686e-21,  1.801558420425951e-23,
 -1.368155804349077e-25,  3.827581749321909e-02, -5.543068087409469e-04,  5.918280785313123e-06, -5.485061870172593e-08,  4.614016061323529e-10, -3.566490578864455e-12,
  2.518017059370417e-14, -1.581507412747922e-16,  8.171187599246325e-19, -2.484939071332498e-21, -1.308152233957456e-23,  3.434703482841972e-25,  1.055931105400587e-01,
 -1.487041592009668e-03,  1.494385446446471e-05, -1.238332317458410e-07,  8.533284055019627e-10, -4.494501840349872e-12,  1.061988093437299e-14,  1.298744539142264e-16,
 -2.457339664485250e-18,  2.551186119242762e-20, -1.904526922272990e-22,  9.074857540142567e-25,  2.047830509264909e-01, -2.761365755770647e-03,  2.513771976254409e-05,
 -1.693154699017943e-07,  6.945510676953347e-10,  1.433423632029600e-12, -6.117810462738518e-14,  6.655614466692301e-16, -4.089918878629117e-18,  3.081293473462168e-21,
  2.770612347709999e-22, -3.941874862458874e-24,  3.336006883071938e-01, -4.232850003005493e-03,  3.316534819388297e-05, -1.484004178900289e-07, -2.696365477935558e-10,
  1.200020698198178e-11, -1.098242352456234e-13,  3.087634757237138e-16,  5.255768193492952e-18, -8.616421007596927e-20,  5.528299825643101e-22,  1.091570703701098e-24,
  4.888862390716097e-01, -5.719672448666404e-03,  3.571386638294105e-05, -4.174329902863488e-08, -1.675691713338074e-09,  1.697139584014443e-11, -2.217993367089076e-14,
 -1.193655030847480e-15,  1.303133500299009e-17, -1.509848185265702e-20, -1.081860320680413e-21,  1.200602205593489e-23,  6.664319296414120e-01, -7.015639087925978e-03,
  3.041754904515069e-05,  1.285830201014364e-07, -2.577703676956629e-09,  6.405028560228519e-12,  1.701086363885603e-13, -1.697240417654435e-15, -4.443820937528433e-18,
  1.974425234888747e-19, -9.414410224041211e-22, -1.393736236230535e-23,  8.608358873395926e-01, -7.910944947362783e-03,  1.684176163884686e-05,  2.962011963291089e-07,
 -2.008154352895276e-09, -1.625404197405087e-11,  2.332972762077332e-13,  6.716332013065282e-16, -2.595517744099742e-17,  3.075426032284803e-20,  2.693819228970953e-21,
 -1.429975119551781e-23,  1.065370846921263e+00, -8.222590070890202e-03, -2.764841022090545e-06,  3.726738585738638e-07,  1.314426674281249e-10, -3.049095022651555e-11,
 -2.681445739820397e-15,  3.032873533751296e-15, -9.168875219699186e-19, -3.341805864156445e-19,  2.495350556790078e-22,  3.916289597186305e-23,  1.271915928886173e+00,
 -7.834413139324292e-03, -2.341288063038403e-05,  2.958595766358218e-07,  2.546640176075406e-09, -1.690937638258208e-11, -2.969173380745944e-13,  7.570331353995319e-16,
  3.493005282634134e-17,  3.221050027406281e-20, -4.021329467625256e-21, -1.788536255378439e-23,  1.471025500639128e+00, -6.742070249002121e-03, -3.852894652037561e-05,
  8.418147485330050e-08,  3.261458413531713e-09,  1.471040898114681e-11, -2.119442429425103e-13, -3.042731490201766e-15,  1.367228252173869e-18,  3.619400819919683e-19,
  2.535350555686470e-21, -2.554672588525417e-23,  1.652231526667970e+00, -5.090547201088944e-03, -4.252585858944215e-05, -1.479516580914229e-07,  1.531356104218385e-09,
  2.802319154933260e-11,  1.487525475696806e-13, -1.281533124256652e-15, -3.036602385015119e-17, -1.939081001795133e-19,  1.389161378072582e-21,  3.955187798131893e-23,
  1.804674813674500e+00, -3.183216258742604e-03, -3.406326090339048e-05, -2.554834282300652e-07, -9.230660309907337e-10,  8.489904193247913e-12,  1.989662753518060e-13,
  1.945080033003228e-15,  7.044431351948681e-18, -1.094921001179548e-19, -2.407676259570287e-21, -2.318502947312958e-23,  1.918106880877809e+00, -1.439186734702805e-03,
 -1.803008772200970e-05, -1.863309588994155e-07, -1.608384444657245e-09, -1.079541946517542e-11, -3.765320566130005e-14,  3.529818630190088e-16,  9.403251652218218e-18,
  1.234953544823851e-19,  1.147078311554458e-21,  6.819052081824286e-24,  1.984190820661615e+00, -2.898656411778178e-04, -3.949676099176914e-06, -4.724905067768758e-08,
 -5.215218688576901e-10, -5.415868761544653e-12, -5.330096719739016e-14, -4.971829056743673e-16, -4.367338579355799e-18, -3.555769875593358e-20, -2.588468072747832e-22,
 -1.527171786822073e-24,  4.027216235127296e-03, -5.744825566681215e-05,  6.135149036266663e-07, -5.811588172151747e-09,  5.145500824555128e-11, -4.358861158459886e-13,
  3.574313688829280e-15, -2.857785446304295e-17,  2.235811190974167e-19, -1.716986188668440e-21,  1.294784616076881e-23, -9.606105719519344e-26,  3.614928439462996e-02,
 -5.094731059212387e-04,  5.302116404118354e-06, -4.800745007899852e-08,  3.957712581947806e-10, -3.012436031889199e-12,  2.110400538225133e-14, -1.335089924700631e-16,
  7.213902218482091e-19, -2.758979799447397e-21, -1.779599987974620e-24,  1.837171893632234e-25,  9.987495330905437e-02, -1.373209382237291e-03,  1.353685671376638e-05,
 -1.108841623200970e-07,  7.662391885681423e-10, -4.204074624289213e-12,  1.328351820746220e-14,  6.454230625415841e-17, -1.666415913366717e-18,  1.869020686179067e-20,
 -1.509363444579437e-22,  8.672431457559089e-25,  1.941271924082717e-01, -2.568200531449018e-03,  2.317331534583424e-05, -1.580470092148325e-07,  7.099705439190721e-10,
  1.741596516049156e-13, -4.434458407379711e-14,  5.382835042124365e-16, -3.817529649915216e-18,  1.110611614864506e-20,  1.338695206828751e-22, -2.613152194066084e-24,
  3.171885747897526e-01, -3.974706452911305e-03,  3.136612308724406e-05, -1.509345341884186e-07, -5.520333132918033e-11,  9.484462552871940e-12, -9.925986392272173e-14,
  4.316307459925859e-16,  2.556216947088369e-18, -6.386531583780358e-20,  5.456398958029290e-22, -1.176810864815735e-24,  4.665751888919729e-01, -5.436395428493513e-03,
  3.506315879521539e-05, -6.587839073314550e-08, -1.344053797755096e-09,  1.608435510724425e-11, -4.989959023082283e-14, -7.926848387829893e-16,  1.183336841690355e-17,
 -4.814531875282069e-20, -5.825809202674843e-22,  1.037010168918643e-23,  6.388648510979489e-01, -6.766816750304885e-03,  3.171798692455987e-05,  8.857002202049904e-08,
 -2.412682583101447e-09,  9.907575513636627e-12,  1.216057012085476e-13, -1.734013828303492e-15,  1.864189385713343e-18,  1.503315803594539e-19, -1.346336618647197e-21,
 -4.671214785951924e-24,  8.294832858432843e-01, -7.762562119508178e-03,  2.019366440546807e-05,  2.617790251586079e-07, -2.276198692060538e-09, -1.052136004513741e-11,
  2.407817227649894e-13, -1.218420695957611e-16, -2.308834972772845e-17,  1.229255599470757e-19,  1.853896228375643e-21, -2.264003341412805e-23,  1.032464561910021e+00,
 -8.226830927798823e-03,  1.699806862721853e-06,  3.699235648867755e-07, -4.722051172120025e-10, -2.955054001849919e-11,  8.005256187141931e-14,  2.816265210691868e-15,
 -1.236507143338903e-17, -2.912812501582558e-19,  1.837463298294481e-21,  3.125963488098344e-23,  1.240227096475973e+00, -8.006850411273437e-03, -1.963047745135983e-05,
  3.335226209583238e-07,  2.139562613940369e-09, -2.365479163663123e-11, -2.601257357594126e-13,  1.861161138422433e-15,  3.306563326373215e-17, -1.375804454830423e-19,
 -4.288116771226259e-21,  6.708513173475237e-24,  1.443448433734435e+00, -7.045353572348425e-03, -3.719693378095617e-05,  1.384133823283825e-07,  3.497978050249153e-09,
  8.619010112650831e-12, -2.944447218486944e-13, -2.773564862445253e-15,  1.588533419111915e-17,  4.336155266619781e-19,  8.729713786119590e-22, -4.946576157116308e-23,
  1.631178325503158e+00, -5.437395433917224e-03, -4.413518292551661e-05, -1.187865302857215e-07,  2.124020858227306e-09,  3.104687578363579e-11,  9.831350070110235e-14,
 -2.350584236942487e-15, -3.589354058858732e-17, -9.995088173999453e-20,  3.383402396175497e-21,  4.965609829327951e-23,  1.791377184518402e+00, -3.468221940578208e-03,
 -3.721118102788820e-05, -2.686157261521711e-07, -7.009909902662854e-10,  1.393975751924989e-11,  2.558475835508823e-13,  2.086815137441826e-15,  1.118290544023217e-18,
 -2.266635673683398e-19, -3.449869057709432e-21, -2.294240680770112e-23,  1.912046851750610e+00, -1.592825511749943e-03, -2.042773738378597e-05, -2.138374489518266e-07,
 -1.832334681013648e-09, -1.154205343250494e-11, -2.282221666526953e-14,  7.344501595876478e-16,  1.474532599504787e-17,  1.751229615190349e-19,  1.422498403652012e-21,
  5.154322089278725e-24,  1.982964360634750e+00, -3.238815667460837e-04, -4.570544074592611e-06, -5.653447722052816e-08, -6.438459939087329e-10, -6.879195277226079e-12,
 -6.938611861630078e-14, -6.595518659818282e-16, -5.850441502098620e-18, -4.730285698689364e-20, -3.291209296687588e-22, -1.619355286109937e-24,  3.806816691990010e-03,
 -5.280573046719687e-05,  5.484422295360039e-07, -5.053647127492075e-09,  4.353425494712155e-11, -3.589500115271173e-13,  2.865673291285454e-15, -2.231999741761095e-17,
  1.701569791949733e-19, -1.274585992898218e-21,  9.376101190803488e-24, -6.799677961304703e-26,  3.419272342419633e-02, -4.692572887431418e-04,  4.762118617064999e-06,
 -4.213080534210490e-08,  3.402977917119271e-10, -2.548282288490623e-12,  1.767398867796997e-14, -1.120135705823323e-16,  6.224393666555669e-19, -2.700055885649905e-21,
  4.039728132791615e-24,  8.912734129317204e-26,  9.459056424706018e-02, -1.270034826278018e-03,  1.227708858283521e-05, -9.927915193530906e-08,  6.854634727899268e-10,
 -3.869027867347583e-12,  1.443741535234998e-14,  2.089005858443000e-17, -1.093341369848716e-18,  1.338275452530864e-20, -1.153485398030015e-22,  7.429432376210819e-25,
  1.842134242896085e-01, -2.390207239651166e-03,  2.134484945627259e-05, -1.467125591474475e-07,  7.039622071671569e-10, -7.226501120038223e-13, -3.091662935661573e-14,
  4.233480715546043e-16, -3.346045152488252e-18,  1.448494663193692e-20,  4.250275290565154e-23, -1.592730561830370e-24,  3.017801326979598e-01, -3.731023744721080e-03,
  2.955546120026335e-05, -1.504254586728331e-07,  1.116817855831992e-10,  7.254520250041369e-12, -8.634533173160901e-14,  4.807302901393959e-16,  6.338839507994829e-19,
 -4.345119554215761e-20,  4.676791724988652e-22, -2.198251772363783e-24,  4.453851265028384e-01, -5.159393912463990e-03,  3.415397502659172e-05, -8.488162219284539e-08,
 -1.035926577371501e-09,  1.466147124265364e-11, -6.708110233979976e-14, -4.454003250629467e-16,  9.783497529993548e-18, -6.311807101847391e-20, -1.869253315357364e-22,
  7.522760471606229e-24,  6.123108977925463e-01, -6.509461735008399e-03,  3.255621764221109e-05,  5.169456040419618e-08, -2.189223767415441e-09,  1.225484632125880e-11,
  7.462633401943089e-14, -1.598423181981409e-15,  6.278508445542734e-18,  9.466586624184227e-20, -1.385069363575950e-21,  2.438404590426351e-24,  7.987751386121197e-01,
 -7.589080501328472e-03,  2.311056393580894e-05,  2.239878028725239e-07, -2.429527035999377e-09, -4.862473804544114e-12,  2.277822969479198e-13, -7.775574653392049e-16,
 -1.757634917000997e-17,  1.763762276041855e-19,  8.120680527525021e-22, -2.357165316431132e-23,  9.996123097657589e-01, -8.195648690763684e-03,  6.074463796131908e-06,
  3.577704729631493e-07, -1.037886159325665e-09, -2.673684547760711e-11,  1.519075184071156e-13,  2.269429757015730e-15, -2.123544713847955e-17, -1.946159498887828e-19,
  2.877498371207691e-21,  1.511995405178617e-23,  1.207911726440002e+00, -8.147341246652093e-03, -1.543946548268462e-05,  3.636514514738189e-07,  1.608851989317782e-09,
 -2.915863086166348e-11, -1.941747664081302e-13,  2.807958236323725e-15,  2.516778542892662e-17, -2.953976643517066e-19, -3.414970604768952e-21,  3.232585007234046e-23,
  1.414683745121270e+00, -7.335323270100592e-03, -3.519579173997442e-05,  1.953509321389239e-07,  3.593759665641069e-09,  6.924132112704205e-13, -3.626194981843933e-13,
 -2.013332513062474e-15,  3.154835267494556e-17,  4.195702254083470e-19, -1.685187483020421e-21, -6.438387889444316e-23,  1.608714431808648e+00, -5.795553013637921e-03,
 -4.533587590974519e-05, -7.973124084129967e-08,  2.762541346634105e-09,  3.248452827771389e-11,  1.608710189049072e-14, -3.526316125940296e-15, -3.652454307846234e-17,
  7.934583019748720e-20,  5.555668246682988e-21,  4.595829480253767e-23,  1.776888264669780e+00, -3.778972158672434e-03, -4.049152970956190e-05, -2.772477625944248e-07,
 -3.560742389651034e-10,  2.077677435200613e-11,  3.133519361923821e-13,  1.963552518088041e-15, -9.749754371420577e-18, -3.825643051038800e-19, -4.263173875579529e-21,
 -1.155459575638140e-23,  1.905331727316275e+00, -1.767027701793733e-03, -2.317738347240049e-05, -2.450232627952878e-07, -2.066685607128172e-09, -1.178346478442879e-11,
  5.376542809785040e-15,  1.318517132386152e-15,  2.211599552388408e-17,  2.350846974033990e-19,  1.527295638926075e-21, -1.552395134327307e-24,  1.981591147239113e+00,
 -3.633457773675069e-04, -5.315618490819846e-06, -6.803384447608236e-08, -7.996947834917448e-10, -8.788894468892036e-12, -9.074947917933379e-14, -8.766894185081983e-16,
 -7.806940884703191e-18, -6.182343654409579e-20, -3.938738290131135e-22, -1.190809684834615e-24,  3.604000795777769e-03, -4.864944871350129e-05,  4.917523950017743e-07,
 -4.410996147520138e-09,  3.699540350954757e-11, -2.970980316979682e-13,  2.310529699304388e-15, -1.754221995474388e-17,  1.303594563403887e-19, -9.531350326470239e-22,
  6.837823172907359e-24, -4.854377348766112e-26,  3.238881197583785e-02, -4.330937862524499e-04,  4.287607510878283e-06, -3.707174597332921e-08,  2.933311120741017e-10,
 -2.159580910447982e-12,  1.480210992327652e-14, -9.361302986480547e-17,  5.289198264333321e-19, -2.478373070375008e-21,  6.648240712557456e-24,  3.448156589502941e-26,
  8.969956876312640e-02, -1.176402828734858e-03,  1.114905106224986e-05, -8.891182129416766e-08,  6.115766194887708e-10, -3.519049498456561e-12,  1.459895658373801e-14,
 -7.217495367081911e-18, -6.871231079294684e-19,  9.379875737999900e-21, -8.586223557885807e-23,  5.969052103547506e-25,  1.749832313345336e-01, -2.226300510326819e-03,
  1.965128207923892e-05, -1.356012842813997e-07,  6.829889136218665e-10, -1.334013132863954e-12, -2.048190303051886e-14,  3.248232559698587e-16, -2.808730252716135e-18,
  1.501481817277549e-20, -1.080111405478484e-23, -8.767678842725707e-25,  2.873175492936395e-01, -3.501759781508287e-03,  2.776551297440573e-05, -1.475858206667585e-07,
  2.371457744840333e-10,  5.344728684039406e-12, -7.281145371687695e-14,  4.794006032102279e-16, -6.180060078420521e-19, -2.678615802236781e-20,  3.640551662997032e-22,
 -2.412578582151516e-24,  4.252871942973120e-01, -4.890496503581406e-03,  3.304532971624013e-05, -9.920171679963209e-08, -7.596329996307285e-10,  1.293511129789752e-11,
 -7.551770006264631e-14, -1.695333019004073e-16,  7.448343778762874e-18, -6.486048801255148e-20,  7.833061331040740e-23,  4.583807332571772e-24,  5.867970637245867e-01,
 -6.247106937995488e-03,  3.297474979121186e-05,  1.871029636936176e-08, -1.929712419769122e-09,  1.353428479268312e-11,  3.312101441283395e-14, -1.353376929183647e-15,
  8.728413291690876e-18,  4.282835793148730e-20, -1.177259346491465e-21,  6.500473345146485e-24,  7.688046684008872e-01, -7.394110908974234e-03,  2.556291308378895e-05,
  1.846259337542774e-07, -2.474175174039971e-09,  2.855278348949949e-13,  1.991242547777684e-13, -1.234109220565463e-15, -1.088280146399489e-17,  1.892017769008294e-19,
 -1.356381172582296e-22, -1.879510192652099e-23,  9.669536465954198e-01, -8.130201554384564e-03,  1.025112328171674e-05,  3.371046351260658e-07, -1.531439538246809e-09,
 -2.241097729487534e-11,  2.050491240434848e-13,  1.500986533128431e-15, -2.605904511525326e-17, -7.165002650720862e-20,  3.137283915661286e-21, -3.111414509374047e-24,
  1.175103524978204e+00, -8.253009920368128e-03, -1.094118647470967e-05,  3.845027330467385e-07,  9.858713254306261e-10, -3.279503739802120e-11, -1.060454685003896e-13,
  3.419966561247850e-15,  1.247275737607797e-17, -3.976461249458135e-19, -1.573555306671196e-21,  4.922428148446868e-23,  1.384795543459902e+00, -7.606537362511121e-03,
 -3.250770138974405e-05,  2.524720756356418e-07,  3.516659672885857e-09, -8.559502589156621e-12, -4.027135750940372e-13, -7.807155369876568e-16,  4.475076470320358e-17,
  2.951580006967572e-19, -4.502966293492487e-21, -5.984945151939822e-23,  1.584801912037286e+00, -6.161266372609796e-03, -4.600603643099803e-05, -3.034797426440208e-08,
  3.407429645026460e-09,  3.155796881274974e-11, -9.825616923835696e-14, -4.602875466904323e-15, -2.923182827117087e-17,  3.360328067288146e-19,  7.083818922448635e-21,
  1.914770912074124e-23,  1.761103349087408e+00, -4.116274816104918e-03, -4.383760054821548e-05, -2.791941715292649e-07,  1.388785014834725e-10,  2.890779970313723e-11,
  3.616546337886382e-13,  1.397703858649674e-15, -2.665044704050694e-17, -5.559666153964567e-19, -4.187117244070036e-21,  1.872029925416970e-23,  1.897873339524968e+00,
 -1.964787821466048e-03, -2.632378083284445e-05, -2.799544805688532e-07, -2.297626135102377e-09, -1.112320039586357e-11,  5.355749464430260e-14,  2.173074803004910e-15,
  3.162779221121485e-17,  2.908601132653210e-19,  1.141656010735323e-21, -1.811484189523230e-23,  1.980047217944303e+00, -4.093680383526993e-04, -6.215003406637356e-06,
 -8.236240284134649e-08, -9.993959054121929e-10, -1.129184690156679e-11, -1.191510566808480e-13, -1.165244774428473e-15, -1.032558597492370e-17, -7.824927906929030e-20,
 -4.148731780066130e-22,  5.574455393063203e-25,  3.416949438073520e-03, -4.491752742904196e-05,  4.421852382018599e-07, -3.863751355273104e-09,  3.157049242006804e-11,
 -2.470980412660861e-13,  1.872943689130668e-15, -1.387084580244331e-17,  1.004952798540475e-19, -7.179977733955282e-22,  5.017396932791724e-24, -3.501218984176462e-26,
  3.072232956239047e-02, -4.004957453575537e-04,  3.869541192172979e-06, -3.270553699838267e-08,  2.534892273951862e-10, -1.833952220617462e-12,  1.240486809198801e-14,
 -7.806149584466884e-17,  4.447536065983396e-19, -2.192497449852541e-21,  7.421764736809852e-24,  3.590856167218061e-27,  8.516581291519484e-02, -1.091317064600837e-03,
  1.013855936843336e-05, -7.967071590182543e-08,  5.446714105422855e-10, -3.173294717288960e-12,  1.413535869883217e-14, -2.441663637084642e-17, -4.053219489467657e-19,
  6.428770811094975e-21, -6.270483360435220e-23,  4.581177468613560e-25,  1.663824035025482e-01, -2.075415528944139e-03,  1.808867466265095e-05, -1.249106962201928e-07,
  6.520793069052434e-10, -1.726099779374147e-12, -1.256488742175740e-14,  2.434430428715499e-16, -2.283850854568779e-18,  1.396390230836673e-20, -3.837449907370315e-23,
 -4.130574198742070e-25,  2.737436428779857e-01, -3.286647763867069e-03,  2.602048143650098e-05, -1.430267645973752e-07,  3.276378990032767e-10,  3.755302049796739e-12,
 -5.979122521799215e-14,  4.468006191531259e-16, -1.345413393803044e-18, -1.430314974738418e-20,  2.617344109274792e-22, -2.191717482572721e-24,  4.062461276373962e-01,
 -4.631083152990522e-03,  3.179019923020526e-05, -1.093858588111988e-07, -5.193093763362560e-10,  1.109052952067546e-11, -7.727243298690754e-14,  3.240675584421601e-17,
  5.211347369771733e-18, -5.845583137442651e-20,  2.242107938695902e-22,  2.157506182690073e-24,  5.623369403432079e-01, -5.982914936109935e-03,  3.302305968296894e-05,
 -9.968728120696874e-09, -1.653979113923159e-09,  1.390713070447310e-11, -6.927939487396053e-16, -1.057890804013374e-15,  9.496913034952518e-18,  2.012525969181787e-21,
 -8.543125681187910e-22,  7.780482556406528e-24,  7.396503154850655e-01, -7.181416475074332e-03,  2.754189938995797e-05,  1.453320966701660e-07, -2.423650685513675e-09,
  4.616715433086631e-12,  1.607014349056190e-13, -1.475918978369869e-15, -4.349430275907284e-18,  1.693544234147110e-19, -8.016771160322553e-22, -1.128273355847514e-23,
  9.346218475847743e-01, -8.032460360731521e-03,  1.413547050303031e-05,  3.092958021894395e-07, -1.927537045596897e-09, -1.708122578617286e-11,  2.351842313369216e-13,
  6.494920889512431e-16, -2.645574192528741e-17,  4.644476078144710e-20,  2.662785590099441e-21, -1.742687045569442e-23,  1.141945960442772e+00, -8.321865706515693e-03,
 -6.254512154837738e-06,  3.949243816754030e-07,  3.124518735033336e-10, -3.415947263849763e-11, -6.912106983105394e-15,  3.582262110288152e-15, -2.436186560697489e-18,
 -4.156076207950320e-19,  6.864664696167088e-22,  5.072975470998608e-23,  1.353869787581223e+00, -7.853540229479525e-03, -2.914780053907002e-05,  3.068395629459915e-07,
  3.247920747195269e-09, -1.831667583054912e-11, -4.032037942472947e-13,  7.817722548489809e-16,  5.155735439024378e-17,  6.904059572631130e-20, -6.596151214758508e-21,
 -3.157197966615600e-23,  1.559419813890675e+00, -6.529797634989649e-03, -4.602280960723144e-05,  2.904649051645658e-08,  4.004076578569957e-09,  2.756071182887943e-11,
 -2.380183242340883e-13, -5.289192996319395e-15, -1.195336830681591e-17,  6.224746991063852e-19,  6.854510859333425e-21, -3.335999883182085e-23,  1.743915744648503e+00,
 -4.480292103815516e-03, -4.715395984905594e-05, -2.718639453161886e-07,  8.064210407935139e-10,  3.794117669177211e-11,  3.856248830406971e-13,  1.947543761131177e-16,
 -4.935543667820573e-17, -6.927928222719395e-19, -2.259975092088130e-21,  7.275908164549108e-23,  1.889570827333176e+00, -2.189457179526179e-03, -2.991086003887980e-05,
 -3.184034999324619e-07, -2.501674695104002e-09, -8.983358097926778e-12,  1.301985009684545e-13,  3.359483019882940e-15,  4.265541533762381e-17,  3.122692082839558e-19,
 -3.124128353799881e-22, -5.135105055450367e-23,  1.978303638454765e+00, -4.633315276051570e-04, -7.307282163074849e-06, -1.003266051236692e-07, -1.256676292204998e-09,
 -1.458304695318549e-11, -1.568495236489850e-13, -1.543829381957725e-15, -1.342583546169623e-17, -9.325381651508588e-20, -3.009007255451908e-22,  5.341482223265780e-24,
  3.244072294169299e-03, -4.155727876604704e-05,  3.986954701065791e-07, -3.395842650054056e-09,  2.704836052120932e-11, -2.064671757634970e-13,  1.525955711247961e-15,
 -1.103265711434648e-17,  7.791651179709184e-20, -5.451016155852348e-22,  3.695355917101375e-24, -2.566699231882928e-26,  2.917986741186853e-02, -3.710430186147420e-04,
  3.500249740838136e-06, -2.892768089279450e-08,  2.196183173883112e-10, -1.560926702008941e-12,  1.040693848360286e-14, -6.503502191080404e-17,  3.711503230936292e-19,
 -1.898379740593397e-21,  7.154851767847374e-24, -1.427894712612083e-26,  8.095690957614550e-02, -1.013889338298308e-03,  9.232763873311100e-06, -7.144552421897777e-08,
  4.845358981483472e-10, -2.843518268432828e-12,  1.330166714334373e-14, -3.413087222575851e-17, -2.145168692661955e-19,  4.286508796003204e-21, -4.529810540893194e-23,
  3.358967234005862e-25,  1.583609137870536e-01, -1.936527198688431e-03,  1.665115960906428e-05, -1.147678130496543e-07,  6.150531165487288e-10, -1.953665488223765e-12,
 -6.698364222701031e-15,  1.780769703933115e-16, -1.812300308444138e-18,  1.215741078209669e-20, -4.997904050837935e-23, -1.416606134415347e-25,  2.610026422171815e-01,
 -3.085254857316358e-03,  2.433785084039460e-05, -1.372575170484915e-07,  3.893804760785539e-10,  2.465164545162787e-12, -4.794761705289651e-14,  3.973471543761167e-16,
 -1.694134211602009e-18, -5.652971701213013e-21,  1.736373599046049e-22, -1.801316622405926e-24,  3.882219468772241e-01, -4.382137126745321e-03,  3.043471018111354e-05,
 -1.160204640826447e-07, -3.158812947435147e-10,  9.263845393808289e-12, -7.433347765847559e-14,  1.673814759121241e-16,  3.286069688765903e-18, -4.814736519927682e-20,
  2.786623756431765e-22,  4.330068816175772e-25,  5.389322846068924e-01, -5.719637754440243e-03,  3.275380269737171e-05, -3.421761104978969e-08, -1.378225109754780e-09,
  1.356924087061847e-11, -2.609138197867341e-14, -7.587589951836823e-16,  9.036175488916397e-18, -2.540067460452246e-20, -5.213261047921446e-22,  7.111654597623571e-24,
  7.113754454132576e-01, -6.954756264094408e-03,  2.905690099921169e-05,  1.074876509361100e-07, -2.296153669378024e-09,  7.967304187179892e-12,  1.182946317103404e-13,
 -1.524575466356050e-15,  1.071269123624691e-18,  1.296287919867637e-19, -1.130298276877043e-21, -3.855848946941365e-24,  9.027409082849640e-01, -7.905078635463584e-03,
  1.765170919065381e-05,  2.760333823169009e-07, -2.211729599118715e-09, -1.131199930874365e-11,  2.419062262761150e-13, -1.514511614154732e-16, -2.307630240466721e-17,
  1.349890627632303e-19,  1.713600812553037e-21, -2.440643213844202e-23,  1.108588491332373e+00, -8.352912259421141e-03, -1.507906224330137e-06,  3.944828529376675e-07,
 -3.643750775124909e-10, -3.314406251723819e-11,  9.011282227686874e-14,  3.274411199929821e-15, -1.639272599709574e-17, -3.466614837585055e-19,  2.657454218009205e-21,
  3.663871131443686e-23,  1.322013787914736e+00, -8.071142106998760e-03, -2.516768909384569e-05,  3.553606566997500e-07,  2.787557820367941e-09, -2.754403795358218e-11,
 -3.582180404286529e-13,  2.418468765714885e-15,  4.907146327216556e-17, -2.100368729938863e-19, -7.026461605107124e-21,  1.362398858086488e-23,  1.532568055879797e+00,
 -6.895457147852659e-03, -4.527281452868261e-05,  9.716020606177976e-08,  4.486041609108484e-09,  2.005038560973239e-11, -3.877469687112810e-13, -5.264254029698727e-15,
  1.486244662547094e-17,  8.480057971340802e-19,  3.935452580693561e-21, -9.970014555519462e-23,  1.725219841025492e+00, -4.870292972734258e-03, -5.031224403417909e-05,
 -2.523894222308485e-07,  1.657214394822981e-09,  4.705965027076829e-11,  3.651351180450874e-13, -1.793655214929299e-15, -7.496828665068987e-17, -6.988629307139276e-19,
  2.476802362722663e-21,  1.437417429852885e-22,  1.880309249139744e+00, -2.444720264503374e-03, -3.397714751283957e-05, -3.596629650240308e-07, -2.641634397540399e-09,
 -4.565389561582727e-12,  2.450167205329376e-13,  4.896640401141586e-15,  5.299598911446399e-17,  2.397682902988714e-19, -3.724732754242418e-21, -1.079459290532860e-22,
  1.976325257452373e+00, -5.269708496229652e-04, -8.642172040812340e-06, -1.229868562110089e-07, -1.589746845414249e-09, -1.891788100405013e-11, -2.066093877611782e-13,
 -2.028883858791997e-15, -1.691954759864023e-17, -9.790009669385023e-20,  1.505721796465426e-22,  1.670498877139129e-23,  3.083974211068428e-03, -3.852365970218321e-05,
  3.604119029503951e-07, -2.994213968165853e-09,  2.326160701495153e-11, -1.732866300334374e-13,  1.249189039919869e-15, -8.826862545855958e-18,  6.070020088293450e-20,
 -4.178428600591640e-22,  2.712814151563746e-24, -1.944575908032403e-26,  2.774958214228036e-02, -3.443721006080661e-04,  3.173213040586524e-06, -2.565056121656550e-08,
  1.907566243252474e-10, -1.331731073923281e-12,  8.742344704857395e-15, -5.419790729596842e-17,  3.077731795550051e-19, -1.628611507219978e-21,  6.243052235055956e-24,
 -2.678402433388470e-26,  7.704382708838695e-02, -9.433290298299342e-04,  8.420111575430894e-06, -6.413090457037796e-08,  4.307770769171473e-10, -2.536391159936004e-12,
  1.227076228826827e-14, -3.884914242190960e-17, -8.955345558405368e-20,  2.737609978682109e-21, -3.293084634577469e-23,  2.281568198563726e-25,  1.508727333957324e-01,
 -1.808662500759327e-03,  1.533167759788740e-05, -1.052467018965756e-07,  5.747438747173900e-10, -2.060755281319098e-12, -2.461130277561455e-15,  1.266909742445912e-16,
 -1.411678923506841e-18,  1.008026482023345e-20, -5.295155418821139e-23, -1.383555808848876e-26,  2.490407508030199e-01, -2.897031140758561e-03,  2.272957570549884e-05,
 -1.306918562325099e-07,  4.280452268651293e-10,  1.441660569597717e-12, -3.760276831628196e-14,  3.410713758186052e-16, -1.790635174749168e-18, -1.737487105333120e-22,
  1.031742912324875e-22, -1.411358634813873e-24,  3.711714326615108e-01, -4.144300887282354e-03,  2.901794498649857e-05, -1.196874928913698e-07, -1.480099046881808e-10,
  7.546440373762391e-12, -6.841976878290633e-14,  2.469688891965162e-16,  1.754623252520568e-18, -3.698170062076915e-20,  2.716887764708916e-22, -6.590275576837957e-25,
  5.165746915287852e-01, -5.459604284737607e-03,  3.221970889526904e-05, -5.413880507327098e-08, -1.114658283415851e-09,  1.271980535303459e-11, -4.345117203027907e-14,
 -4.876710106533530e-16,  7.817746591519918e-18, -4.045239292209877e-20, -2.438611361721020e-22,  5.392745369604246e-24,  6.840286352529389e-01, -6.717753161751463e-03,
  3.013204078022105e-05,  7.216382493753537e-08, -2.111837450006307e-09,  1.030198555867083e-11,  7.672441375110653e-14, -1.424575537806716e-15,  4.899879448353382e-18,
  8.282205044503473e-20, -1.169826837962471e-21,  1.655312124595238e-24,  8.714231302196929e-01, -7.751232107890041e-03,  2.074533220989798e-05,  2.391483532257485e-07,
 -2.380666224674796e-09, -5.635670799390818e-12,  2.281399565971598e-13, -8.010415797866990e-16, -1.724582895727617e-17,  1.817007104687843e-19,  6.253356054612724e-22,
 -2.398704522365372e-23,  1.075182491295848e+00, -8.346188907894207e-03,  3.169495858863572e-06,  3.834972748605049e-07, -9.985552639378664e-10, -2.995115548048848e-11,
  1.727389266270392e-13,  2.573453378302732e-15, -2.662941340832696e-17, -2.146678515148702e-19,  3.769439185722186e-21,  1.306625010314176e-23,  1.289354555426566e+00,
 -8.254712867357872e-03, -2.065537747962703e-05,  3.951135274624200e-07,  2.157070294527541e-09, -3.516010432860140e-11, -2.700293987633619e-13,  3.815548095535722e-15,
  3.672366017470885e-17, -4.651368306163512e-19, -5.397973367788728e-21,  5.868200437861131e-23,  1.504271004817304e+00, -7.251728822879077e-03, -4.366477044987624e-05,
  1.715905327463376e-07,  4.782451383286545e-09,  9.058473142690051e-12, -5.237367607390682e-13, -4.279487480605701e-15,  4.700409017381137e-17,  9.001732388632618e-19,
 -1.708859680251699e-21, -1.515312650644461e-22,  1.704915226080398e+00, -5.284380336457017e-03, -5.314928184764151e-05, -2.178905528359718e-07,  2.680475705361036e-09,
  5.492690527935398e-11,  2.777587221067131e-13, -4.562478524158823e-15, -9.663703602182711e-17, -4.536062089577067e-19,  1.021838962681951e-20,  2.021941221465521e-22,
  1.869958378713568e+00, -2.734524409337650e-03, -3.854854233195634e-05, -4.022899221177851e-07, -2.662012915251990e-09,  3.158610401591067e-12,  4.068973623701473e-13,
  6.691283423886403e-15,  5.760322453594478e-17, -2.623441986705581e-20, -1.015362749176075e-20, -1.869802822486636e-22,  1.974069101598593e+00, -6.024746122699390e-04,
 -1.028404404667384e-05, -1.517395420081891e-07, -2.022621955373540e-09, -2.462256572653915e-11, -2.715096869886531e-13, -2.623762754818486e-15, -2.010578961142529e-17,
 -7.116282920900655e-20,  1.366493880752895e-21,  4.164792918259097e-23,  2.935427200477064e-03, -3.577801280624342e-05,  3.266051365320748e-07, -2.648205428011343e-09,
  2.007673844172731e-11, -1.460656172760619e-13,  1.027109227966054e-15, -7.105784724742423e-18,  4.741680454251544e-20, -3.251622241813720e-22,  1.949335941722440e-24,
 -1.556417163916486e-26,  2.642098637786868e-02, -3.201676900686902e-04,  2.882875564001103e-06, -2.280062880062824e-08,  1.661027725796598e-10, -1.139064901916618e-12,
  7.354200895325358e-15, -4.524156005154834e-17,  2.533229194439599e-19, -1.405881010858344e-21,  4.810187156472489e-24, -3.814565501514750e-26,  7.340051926968745e-02,
 -8.789330024936473e-04,  7.690272111308037e-06, -5.762866744047490e-08,  3.829048080361308e-10, -2.255187574162448e-12,  1.115597477455145e-14, -4.037435418516740e-17,
 -1.255939881417180e-20,  1.591758801588351e-21, -2.506794828408990e-23,  1.314345658675056e-25,  1.438756080374203e-01, -1.690907738902657e-03,  1.412252517628863e-05,
 -9.638261164950505e-08,  5.332004211197405e-10, -2.082038188184051e-12,  5.054225694253968e-16,  8.691442300734931e-17, -1.086928961392340e-18,  7.963323577147898e-21,
 -5.271533535687780e-23,  1.200468292139633e-26,  2.378065337464510e-01, -2.721349427510806e-03,  2.120316702625009e-05, -1.236583702310116e-07,  4.485939301700125e-10,
  6.473389758084201e-13, -2.885091018755051e-14,  2.843519352240527e-16, -1.736677483537067e-18,  2.807928758434785e-21,  4.812788367912554e-23, -1.106217423519767e-24,
  3.550493775545155e-01, -3.917931682722320e-03,  2.757218443251802e-05, -1.209349900232695e-07, -1.291387822742059e-11,  5.992535361254077e-12, -6.090415459480991e-14,
  2.838427794842941e-16,  6.099190514744491e-19, -2.690689486180439e-20,  2.275132169051266e-22, -1.283452355864367e-24,  4.952472721552539e-01, -5.204729518331581e-03,
  3.147123607320991e-05, -6.999898092329350e-08, -8.716563175644692e-10,  1.153998665438883e-11, -5.383344755914834e-14, -2.622579347560556e-16,  6.237614127839639e-18,
 -4.606163934226588e-20, -5.161639279943499e-23,  3.340351036881340e-24,  6.576444301470901e-01, -6.473791148595287e-03,  3.080235746063503e-05,  4.010958101842492e-08,
 -1.890512717918741e-09,  1.168486897270592e-11,  3.941644803382313e-14, -1.228895810444945e-15,  7.066678460516934e-18,  3.853940250920729e-20, -1.022827694031934e-21,
  4.611954647494652e-24,  8.407673792920661e-01, -7.574444546031100e-03,  2.338378924555446e-05,  2.004448116485960e-07, -2.440738987549130e-09, -4.856558245713671e-13,
  1.989908467440749e-13, -1.245410489612114e-15, -1.049699136963181e-17,  1.869501034502156e-19, -3.227843758789577e-22, -1.853305214896175e-23,  1.041877151906633e+00,
 -8.302740626864378e-03,  7.656626330108076e-06,  3.629761431260251e-07, -1.550808536191021e-09, -2.504311353922897e-11,  2.319156636793422e-13,  1.627445051061163e-15,
 -3.157210732861293e-17, -5.973451520264762e-20,  3.801315768276040e-21, -1.095675669463077e-23,  1.256036001748513e+00, -8.400459256493520e-03, -1.573117813352832e-05,
  4.236874185506154e-07,  1.398330460574846e-09, -4.024281870932736e-11, -1.495240175695012e-13,  4.686767395802668e-15,  1.680411228775391e-17, -6.199279508787055e-19,
 -2.153803669849775e-21,  8.428328905825638e-23,  1.474580342873961e+00, -7.591500670883405e-03, -4.114290553014151e-05,  2.488388512505462e-07,  4.829220840715179e-09,
 -4.750009527551395e-12, -6.178045384847070e-13, -2.283497779950162e-15,  7.651605847917668e-17,  6.930505656231288e-19, -8.671415928600369e-21, -1.545094096239787e-22,
  1.682911898589441e+00, -5.719218648066328e-03, -5.546935197622256e-05, -1.659023230209780e-07,  3.833469905083440e-09,  5.969885294543476e-11,  1.049262889140575e-13,
 -7.819464738143091e-15, -1.034136755331671e-16,  1.374905809810652e-19,  1.927757679194327e-20,  1.930832384457323e-22,  1.858371919227691e+00, -3.062938152101165e-03,
 -4.362758823134455e-05, -4.437787505139081e-07, -2.484948293736143e-09,  1.537661053366657e-11,  6.192582075523347e-13,  8.423518010229670e-15,  4.714162475744249e-17,
 -6.212526270376400e-19, -2.015971025650617e-20, -2.630313350526205e-22,  1.971482297153939e+00, -6.926204717753508e-04, -1.231655946403546e-05, -1.884214644913940e-07,
 -2.586570374333767e-09, -3.209497350786228e-11, -3.542681594812831e-13, -3.293292787612128e-15, -2.113132449694527e-17,  3.277300291704587e-20,  4.202988967135610e-21,
  9.316338416053080e-23,  2.797346995142318e-03, -3.328703834352919e-05,  2.966617957863711e-07, -2.349073457090730e-09,  1.738665847325192e-11, -1.236413906689382e-13,
  8.477299968942545e-16, -5.761978728676966e-18,  3.695739379519092e-20, -2.600117633412144e-22,  1.330297581134514e-24, -1.246181595957407e-26,  2.518477035556179e-02,
 -2.981556069322373e-04,  2.624492027437467e-06, -2.031605975170367e-08,  1.449884151127300e-10, -9.768947507702847e-13,  6.193562212938864e-15, -3.791131677037418e-17,
  2.057475452640306e-19, -1.249327435731715e-21,  2.987904105821309e-24, -4.168129046619467e-26,  7.000359446754714e-02, -8.200761868136523e-04,  7.034044611794345e-06,
 -5.184885770137599e-08,  3.403868870638848e-10, -2.001009095267493e-12,  1.002715940689644e-14, -4.004306719973365e-17,  2.787142783077059e-20,  6.815106563551653e-22,
 -2.092313607125362e-23,  6.719228714371607e-26,  1.373308129927763e-01, -1.582412028921002e-03,  1.301575116433457e-05, -8.818311198689819e-08,  4.918588393120058e-10,
 -2.044384770373649e-12,  2.492283593949616e-15,  5.631350489336191e-17, -8.380967424351802e-19,  5.863414067932444e-21, -5.226489532231433e-23,  1.751596545339993e-26,
  2.272511619379758e-01, -2.557536923007310e-03,  1.976264410567799e-05, -1.164123193414415e-07,  4.552293837857794e-10,  4.428396905767192e-14, -2.164977110707397e-14,
  2.306765139632069e-16, -1.611977556439939e-18,  3.835940551546250e-21,  5.233354336394779e-24, -8.317918557466474e-25,  3.398096211319518e-01, -3.703153993145727e-03,
  2.612343008914131e-05, -1.202594944408672e-07,  9.297140694153151e-11,  4.627577199637311e-12, -5.281708252043119e-14,  2.895014249823573e-16, -2.094567613116074e-19,
 -1.903129517654981e-20,  1.647483394396467e-22, -1.486184181297594e-24,  4.749262617589131e-01, -4.956539597461565e-03,  3.055495240635381e-05, -8.217139356654708e-08,
 -6.542613770542004e-10,  1.018088049595280e-11, -5.863285014320106e-14, -8.933121170843418e-17,  4.572455430267460e-18, -4.575009985605335e-20,  5.430173156320837e-23,
  1.585164713783119e-24,  6.322444494119424e-01, -6.225943209710176e-03,  3.111003089158474e-05,  1.177112998457635e-08, -1.650006019549112e-09,  1.224451781553335e-11,
  8.327940114578160e-15, -9.880379436294750e-16,  7.770186758969258e-18,  2.058490378122035e-21, -7.948251975087462e-22,  5.517666128807915e-24,  8.108580393734094e-01,
 -7.378415875821896e-03,  2.555530217897233e-05,  1.615623062484707e-07, -2.405689115358795e-09,  3.839801915028903e-12,  1.604020954036779e-13, -1.477590179304125e-15,
 -4.176172129144744e-18,  1.598952574694967e-19, -9.741119283471502e-22, -1.088584950700072e-23,  1.008815638469254e+00, -8.224522613498386e-03,  1.184795093845367e-05,
  3.344721503529103e-07, -1.992914727103715e-09, -1.904544854460287e-11,  2.632185645853978e-13,  6.107840019409689e-16, -3.115419228199191e-17,  7.705913648908010e-20,
  2.917550891843062e-21, -2.746345313919967e-23,  1.222215121107064e+00, -8.505653550414327e-03, -1.053975727805410e-05,  4.394723183548832e-07,  5.684428597209925e-10,
 -4.221691154823955e-11, -1.419732307242973e-14,  4.858146477178226e-15, -6.157748651913240e-18, -6.309729114816855e-19,  1.569450018744092e-21,  7.997308224115236e-23,
  1.443576803656782e+00, -7.907398643013227e-03, -3.769902555028679e-05,  3.245242742053004e-07,  4.582286608178905e-09, -2.004754764390059e-11, -6.442632338723486e-13,
  4.847214138054609e-16,  9.370385717836029e-17,  2.243688270154108e-19, -1.428897125154068e-20, -8.969725761700447e-23,  1.659136498115027e+00, -6.169802836906005e-03,
 -5.705254164620962e-05, -9.495921927584467e-08,  5.033002166351261e-09,  5.922607859380792e-11, -1.584540341044408e-13, -1.088561905803512e-14, -8.278449276069917e-17,
  1.049288655677515e-18,  2.533256565672180e-20,  5.837657017837961e-23,  1.845387481724822e+00, -3.433907115623882e-03, -4.917849816519518e-05, -4.801872179091014e-07,
 -2.008918397114280e-09,  3.321276967564720e-11,  8.716296695798849e-13,  9.395252096202920e-15,  7.377176605649284e-18, -1.667919259333695e-18, -3.216645313305431e-20,
 -2.596706226893702e-22,  1.968499368745685e+00, -8.009526717939516e-04, -1.484869582282394e-05, -2.354364516979837e-07, -3.321348728842951e-09, -4.177789237526066e-11,
 -4.554852044290530e-13, -3.908739056843746e-15, -1.571769954427072e-17,  3.078203466585241e-19,  1.027316421203756e-20,  1.930352250503688e-22,  2.668773338343656e-03,
 -3.102195134796274e-05,  2.700638666807732e-07, -2.089616661208378e-09,  1.510487290469985e-11, -1.051065646453886e-13,  7.016117160680977e-16, -4.719830777111570e-18,
  2.843538210737690e-20, -2.162833345573039e-22,  9.044586804602004e-25, -5.675787467972647e-27,  2.403264956156053e-02, -2.780968388793746e-04,  2.393998654265225e-06,
 -1.814481992031108e-08,  1.268546635531239e-10, -8.402842938173641e-13,  5.217603941313750e-15, -3.202722648993367e-17,  1.625319104763277e-19, -1.160027797985533e-21,
  1.757628706577468e-24, -1.854788438565726e-27,  6.683202072415033e-02, -7.662029483238057e-04,  6.443256112540339e-06, -4.671013270978238e-08,  3.026830022234103e-10,
 -1.773693920596978e-12,  8.921009931835701e-15, -3.891435507989078e-17,  3.807135928372755e-20, -9.172365969534664e-23, -1.726771020078826e-23,  1.355116712885771e-25,
  1.312028997856469e-01, -1.482388107279224e-03,  1.200343484126368e-05, -8.063673824535950e-08,  4.516821239613255e-10, -1.968498504371814e-12,  3.722466947585678e-15,
  3.247143100383435e-17, -6.641790851462127e-19,  3.823519383726972e-21, -4.822341563686024e-23,  2.320401789801078e-25,  2.173285438939428e-01, -2.404899844720656e-03,
  1.840934182468922e-05, -1.091477022606716e-07,  4.514127091792786e-10, -4.035047422771260e-13, -1.589232682548036e-14,  1.812786981991075e-16, -1.477808783164472e-18,
  3.444269248205378e-21, -2.057493765225541e-23, -2.363889453213774e-25,  3.254058847468249e-01, -3.499907119891275e-03,  2.469207999338172e-05, -1.180976783119119e-07,
  1.734969952368425e-10,  3.455891616321821e-12, -4.489953081017883e-14,  2.729849462419618e-16, -7.909981315274607e-19, -1.365440222130359e-20,  1.084828950376958e-22,
 -8.656030447095253e-25,  4.555825061182544e-01, -4.716207189076857e-03,  2.951255665753520e-05, -9.108766424227820e-08, -4.648391978426425e-10,  8.758706967077794e-12,
 -5.932958148918824e-14,  3.117184246535203e-17,  2.978592652323205e-18, -4.246202850747099e-20,  1.065550679250250e-22,  1.128052447774423e-24,  6.078387226433241e-01,
 -5.976928112403025e-03,  3.110097594627543e-05, -1.266788565074862e-08, -1.405213088598713e-09,  1.214036559135422e-11, -1.588590434662926e-14, -7.438611108040970e-16,
  7.331531916670119e-18, -2.476001466677367e-20, -5.416791063436098e-22,  6.178820902317568e-24,  7.817646249762172e-01, -7.166865690416195e-03,  2.726627656050802e-05,
  1.238805400076722e-07, -2.293804268920096e-09,  7.182910246573542e-12,  1.179656730973909e-13, -1.527438924951555e-15,  7.855850264799941e-19,  1.138198037827605e-19,
 -1.266180192067626e-21, -2.133919834775918e-24,  9.761317345020013e-01, -8.114253113900268e-03,  1.565884986346515e-05,  2.998853081064353e-07, -2.309834581002728e-09,
 -1.263232599978874e-11,  2.669266185300942e-13, -3.217528284043007e-16, -2.659208460973420e-17,  1.674405219980899e-19,  1.574257809070160e-21, -3.114711271777929e-23,
  1.188057404489965e+00, -8.568786383814291e-03, -5.239317244182130e-06,  4.418397706717820e-07, -2.684864881001834e-10, -4.096796872021273e-11,  1.157816017901465e-13,
  4.316257369544386e-15, -2.695718326236287e-17, -5.049420312415338e-19,  4.524717082336242e-21,  5.187079350563657e-23,  1.411370401125597e+00, -8.192203182888358e-03,
 -3.338076008345129e-05,  3.938038991716805e-07,  4.029579755272368e-09, -3.500480339877886e-11, -5.883195055391090e-13,  3.496318576815940e-15,  9.082986892803094e-17,
 -3.938826356648925e-19, -1.575227216631480e-20,  2.923397551669461e-23,  1.633539278219986e+00, -6.629324089400570e-03, -5.767075917388814e-05, -5.270136673625038e-09,
  6.153432875783424e-09,  5.150821172353579e-11, -4.932563274760774e-13, -1.273378715328597e-14, -2.677705121156099e-17,  2.043656533636207e-18,  2.245252309452335e-20,
 -2.052283220144687e-22,  1.830827808039425e+00, -3.850872202094776e-03, -5.510775494433113e-05, -5.057901431304465e-07, -1.114295028655945e-09,  5.725048815690914e-11,
  1.127085789445443e-12,  8.402215559507004e-15, -7.820996216871108e-17, -3.138248725635124e-18, -3.970299210272581e-20, -3.045561322045892e-23,  1.965038721543716e+00,
 -9.320141445239728e-04, -1.802238388618879e-05, -2.958945180330931e-07, -4.275326538850305e-09, -5.406617545374876e-11, -5.696311734617616e-13, -4.135867761590783e-15,
  5.211968562437064e-18,  9.343036168662413e-19,  2.234482272557765e-20,  3.711057278024095e-22,  2.548853340814265e-03, -2.895778752262595e-05,  2.463720093050529e-07,
 -1.863884016049107e-09,  1.316092560076408e-11, -8.975787685771072e-14,  5.810730990662392e-16, -3.927740488635580e-18,  2.127856585313713e-20, -1.806514044664027e-22,
  1.018463336773497e-24,  1.391105540935256e-26,  2.295723426034412e-02, -2.597825310340197e-04,  2.187905505740765e-06, -1.624308184967601e-08,  1.112314403746802e-10,
 -7.252733044157003e-13,  4.387482753886473e-15, -2.747906192626889e-17,  1.223200074279436e-19, -1.055829845048680e-21,  4.625073456725742e-24,  1.607985353832601e-25,
  6.386686382733417e-02, -7.168192782823713e-04,  5.910658126142397e-06, -4.213973077549054e-08,  2.692625907760800e-10, -1.572534685645343e-12,  7.847107116568374e-15,
 -3.786582331999375e-17,  2.452887232257531e-20, -5.738419699776600e-22, -3.782858421577438e-24,  5.595928192845574e-25,  1.254594434643430e-01, -1.390111293663649e-03,
  1.107787272483878e-05, -7.371966250335172e-08,  4.132672723210908e-10, -1.870536016596341e-12,  4.352318580589719e-15,  1.307810766070454e-17, -5.571436425446775e-19,
  2.292277968307027e-21, -2.190657642023259e-23,  1.124630312651204e-24,  2.079953711331252e-01, -2.262742155359351e-03,  1.714257606239519e-05, -1.020087522239168e-07,
  4.399124436464377e-10, -7.292459372868506e-13, -1.146108987850835e-14,  1.358147249999101e-16, -1.367794899586556e-18,  2.800660063647947e-21,  7.057030809319669e-25,
  1.470267980972096e-24,  3.117924272083477e-01, -3.307987092080043e-03,  2.329366176291517e-05, -1.148247908941565e-07,  2.324414650832955e-10,  2.466739998788892e-12,
 -3.767853318456808e-14,  2.406013302785537e-16, -1.208826232037406e-18, -9.515118263748698e-21,  1.169247705865456e-22,  1.690985464632214e-24,  4.371827940296770e-01,
 -4.484592567169245e-03,  2.838041150054061e-05, -9.720059131461105e-08, -3.037836741980275e-10,  7.354661088219749e-12, -5.734562927337818e-14,  1.029718440054983e-16,
  1.542528576252626e-18, -3.672506589838144e-20,  1.994975593017049e-22,  3.801725338022909e-24,  5.844271475668651e-01, -5.729092295795388e-03,  3.082198817427594e-05,
 -3.323616829767641e-08, -1.167772454374755e-09,  1.153471807145182e-11, -3.359004452810359e-14, -5.271257130992034e-16,  6.121836936367351e-18, -4.025140927453481e-20,
 -2.062051348048847e-22,  9.907213135512354e-24,  7.535419723056119e-01, -6.943401281171506e-03,  2.853783732870215e-05,  8.846831951264283e-08, -2.125269064319215e-09,
  9.507143007097008e-12,  7.609545581916541e-14, -1.446515480276095e-15,  3.977035322386746e-18,  6.445814077211251e-20, -1.114871099540582e-21,  9.890706996718067e-24,
  9.439471454580134e-01, -7.975233056916690e-03,  1.902850723318140e-05,  2.612501369821716e-07, -2.499620391104691e-09, -6.424413122636683e-12,  2.469821728016950e-13,
 -1.066656900498432e-15, -1.974065931430328e-17,  2.054933712824157e-19,  4.225992096765066e-22, -1.816152677767711e-23,  1.153731825977808e+00, -8.589626735337886e-03,
  1.054311275702624e-08,  4.311792260787145e-07, -1.050839185135890e-09, -3.685187283968932e-11,  2.220992539717104e-13,  3.201590678223887e-15, -4.141574832924307e-17,
 -2.879142585419767e-19,  6.106416456566833e-21,  2.209783465434586e-23,  1.378098896488710e+00, -8.439308633708955e-03, -2.829375714867936e-05,  4.519482223624309e-07,
  3.197842980132881e-09, -4.763861149754831e-11, -4.527032798419748e-13,  6.059277116408961e-15,  6.597904022611308e-17, -9.586839102472664e-19, -1.151868496304987e-20,
  1.616009560202711e-22,  1.606101309323357e+00, -7.089195887719130e-03, -5.711169276261248e-05,  1.006608566250023e-07,  7.036144302177604e-09,  3.536832360046783e-11,
 -8.496307548943384e-13, -1.226311879234750e-14,  5.998378559398182e-17,  2.673958870367313e-18,  7.021687144107414e-21, -4.815589105691845e-22,  1.814503854423820e+00,
 -4.316218315872941e-03, -6.124145967593830e-05, -5.129156085616301e-07,  3.183272943508609e-10,  8.672562105180461e-11,  1.308165818739320e-12,  3.791184675024823e-15,
 -2.187734688077231e-16, -4.601505545907825e-18, -2.888361887932948e-20,  5.987136936661344e-22,  1.960998062452106e+00, -1.091646240312310e-03, -2.202174501053549e-05,
 -3.737316988214174e-07, -5.502487157452621e-09, -6.907001337677632e-11, -6.766081864901500e-13, -3.222168359557475e-15,  5.953559347175136e-17,  2.229162210577224e-18,
  4.442037719584779e-20,  6.481680359751104e-22,  2.436827367589320e-03, -2.707282979859060e-05,  2.252119652263785e-07, -1.666948829096186e-09,  1.149669079615920e-11,
 -7.706058765744364e-14,  4.797173678985525e-16, -3.341222474347009e-18,  1.574916285225775e-20, -1.170808345626275e-22,  2.466341093623090e-24,  5.589461415527824e-26,
  2.195191745478106e-02, -2.430297664777312e-04,  2.003205897587721e-06, -1.457395533181631e-08,  9.771879053864368e-11, -6.287977820081707e-13,  3.667514238827500e-15,
 -2.411820372877273e-17,  9.016022382833692e-20, -6.365896809772488e-22,  1.904012872289677e-23,  5.313112160022906e-25,  6.109105495172828e-02, -6.714858064818551e-04,
  5.429824857181258e-06, -3.807326137557170e-08,  2.396097012546599e-10, -1.396857019620021e-12,  6.794886924869584e-15, -3.737822578556213e-17,  9.303133242879510e-21,
  2.059866217853036e-23,  4.094109560858996e-23,  1.578792701719027e-24,  1.200707965520442e-01, -1.304917252834745e-03,  1.023169451835208e-05, -6.740090728784184e-08,
  3.769206684709375e-10, -1.763627636078940e-12,  4.480806370167260e-15, -3.473399042618604e-18, -4.739386524620218e-19,  2.921583280460216e-21,  6.845923701057128e-23,
  3.192762133438230e-24,  1.992110984135756e-01, -2.130379510272464e-03,  1.596017623760666e-05, -9.510057253783941e-08,  4.228597386269979e-10, -9.635268631579808e-13,
 -8.254867480692948e-15,  9.384281428445650e-17, -1.242724515339465e-18,  5.048477449097509e-21,  1.385025684783351e-22,  5.146871036233733e-24,  2.989245445563606e-01,
 -3.127082722589506e-03,  2.193955360818267e-05, -1.107579736754941e-07,  2.732553006171985e-10,  1.638646960782220e-12, -3.152707359946055e-14,  1.975678353933708e-16,
 -1.436567298022784e-18, -1.906992973451688e-21,  3.054854184041850e-22,  7.449181079945338e-24,  4.196910205802438e-01, -4.262286834232794e-03,  2.718945590758943e-05,
 -1.009580974134176e-07, -1.701959884784820e-10,  6.017385720977211e-12, -5.395674030875482e-14,  1.331513070370676e-16,  4.207955278870072e-19, -2.351799988916530e-20,
  5.173544751352812e-22,  1.154606485339249e-23,  5.620009785496373e-01, -5.484412135747788e-03,  3.031850623759358e-05, -5.012341159133907e-08, -9.462266337343524e-10,
  1.057220706900607e-11, -4.583056648119468e-14, -3.550125403289990e-16,  4.651059506988937e-18, -3.729375757120195e-20,  4.291085001632769e-22,  2.019878550295974e-23,
  7.262308998495445e-01, -6.711415148083267e-03,  2.940199052455211e-05,  5.607089838143739e-08, -1.920061607919599e-09,  1.086364846698772e-11,  3.766856105020422e-14,
 -1.289587695264733e-15,  5.644564378938342e-18,  3.361242473024391e-20, -2.875122514246865e-22,  2.909042505663995e-23,  9.123695541962111e-01, -7.811152617220826e-03,
  2.192031781490732e-05,  2.205390189883776e-07, -2.571591693014570e-09, -9.196982676843046e-13,  2.094005041592344e-13, -1.577838847509327e-15, -1.216029506807069e-17,
  2.144753503116856e-19,  2.599957184226467e-22,  1.381365508657413e-23,  1.119405782515329e+00, -8.569185609061867e-03,  5.060505735200902e-06,  4.087867959205594e-07,
 -1.728119958215409e-09, -3.060336582930316e-11,  2.919770254678928e-13,  1.759212061941079e-15, -4.718949305067035e-17, -2.810719156596604e-20,  6.849208279933619e-21,
  1.751557081787251e-23,  1.343924437945241e+00, -8.643171306614140e-03, -2.259657225836676e-05,  4.949627471543657e-07,  2.151251740257471e-09, -5.626367857824107e-11,
 -2.592164471544086e-13,  7.545468978957994e-15,  2.519993526419026e-17, -1.243363735912683e-18, -1.950894613168502e-21,  2.661713692148684e-22,  1.576841151920475e+00,
 -7.539297875432689e-03, -5.520884546286812e-05,  2.176784857544725e-07,  7.513288643539297e-09,  1.116347977144380e-11, -1.151522416443590e-12, -8.793613737042608e-15,
  1.557725457195553e-16,  2.488847162518700e-18, -1.675783474524913e-20, -5.442389572172828e-22,  1.796220446357345e+00, -4.830540337381361e-03, -6.730306301478495e-05,
 -4.922205911285890e-07,  2.370635896168802e-09,  1.184448930801226e-10,  1.290194174240730e-12, -6.014990675838240e-15, -3.963339649269668e-16, -4.945781329871806e-18,
  1.930461302646593e-20,  1.639522498586601e-21,  1.956248467206783e+00, -1.287366849951509e-03, -2.708328051924298e-05, -4.737307128069633e-07, -7.052104595940020e-09,
 -8.608807887693070e-11, -7.252963925109613e-13,  3.714511064110714e-16,  1.795205642093091e-16,  4.672946031575855e-18,  8.013114013078130e-20,  9.680379832142426e-22,
  2.332017016959188e-03, -2.534813374251548e-05,  2.062633433931687e-07, -1.494736744925295e-09,  1.006331402781383e-11, -6.661614928558626e-14,  3.927535520193550e-16,
 -2.879852718056516e-18,  1.405317253271119e-20,  4.737103382656336e-23,  6.172773024953835e-24,  1.122202367170041e-25,  2.101077836430841e-02, -2.276780154602350e-04,
  1.837299308829939e-06, -1.310650383914151e-08,  8.596995654085700e-11, -5.485697642206130e-13,  3.030506948205638e-15, -2.139824364761597e-17,  8.792992616971456e-20,
  7.410197902062415e-22,  5.356916239520205e-23,  1.035440170906805e-24,  5.848918463683948e-02, -6.298116177518129e-04,  4.995054057437642e-06, -3.445449783222909e-08,
  2.132187899679716e-10, -1.246289379365980e-12,  5.755735939873595e-15, -3.659227020526566e-17,  6.000208921099632e-20,  3.460642311307872e-21,  1.414541002170459e-22,
  2.983627364721287e-24,  1.150098534347478e-01, -1.226199060852869e-03,  9.457922786388241e-06, -6.164657645187643e-08,  3.427072804078201e-10, -1.658845319676840e-12,
  4.192639501578950e-15, -1.610393846245839e-17, -2.780649887219685e-19,  9.303766430825645e-21,  2.716352521636930e-22,  6.029747004860217e-24,  1.909378759129380e-01,
 -2.007149440384666e-03,  1.485889535782394e-05, -8.849893020481602e-08,  4.017985364316560e-10, -1.134387472604697e-12, -6.146074144452107e-15,  5.858235681094774e-17,
 -8.934411928273643e-19,  1.658015192693926e-20,  4.748306997693931e-22,  1.011709117388142e-23,  2.867589368060951e-01, -2.956806118414309e-03,  2.063764368389341e-05,
 -1.061630291096070e-07,  2.988830757623735e-10,  9.432246214355052e-13, -2.662788085141124e-14,  1.536353848453128e-16, -1.185378883397283e-18,  1.917727085726920e-20,
  8.069109147436936e-22,  1.531954574218236e-23,  4.030691778579563e-01, -4.049654773277467e-03,  2.596536699584656e-05, -1.027875245258117e-07, -6.249075088893537e-11,
  4.768073012940757e-12, -5.013209348201392e-14,  1.382508242323885e-16,  9.858804862131112e-20,  1.060385081399278e-20,  1.271743169699781e-21,  2.276744156913119e-23,
  5.405442740546829e-01, -5.244511717370628e-03,  2.963296307219538e-05, -6.363433915067527e-08, -7.465047581883897e-10,  9.368733180263496e-12, -5.385412105450183e-14,
 -2.223491513026098e-16,  3.871394286254834e-18,  2.051071122221326e-21,  1.650425165976906e-21,  3.537158142458445e-23,  6.998592172904894e-01, -6.474013305058951e-03,
  2.989781188068764e-05,  2.712532063358554e-08, -1.696562805246975e-09,  1.135591172046372e-11,  4.271535458390125e-15, -1.088892667949354e-15,  7.020843199311668e-18,
  5.485388073489220e-20,  1.527880279082278e-21,  5.323654845595577e-23,  8.814914425838698e-01, -7.625903376098344e-03,  2.432014800139181e-05,  1.795037387038630e-07,
 -2.543504656908299e-09,  3.539037587016705e-12,  1.609588068957199e-13, -1.839485416520904e-15, -3.990941318542014e-18,  2.496997067655264e-19,  1.822181034653142e-21,
  5.735327820191246e-23,  1.085240354242667e+00, -8.509593818396345e-03,  9.781121242094503e-06,  3.766347607580544e-07, -2.267001717993758e-09, -2.317446027529573e-11,
  3.203293303834881e-13,  2.876927182568711e-16, -4.302820553239120e-17,  2.678455075036826e-19,  8.160555517778092e-21,  4.599241370497309e-23,  1.309028535733932e+00,
 -8.799687887774308e-03, -1.648852902215909e-05,  5.201155101462202e-07,  9.811747093807043e-10, -5.989977948815393e-11, -4.335127524054862e-14,  7.644785196404862e-15,
 -1.795852460418679e-17, -1.067775450810724e-18,  1.109152332430198e-20,  3.151557680321873e-22,  1.545820057187986e+00, -7.968469615458463e-03, -5.187312619683751e-05,
  3.381031003355425e-07,  7.443490919218140e-09, -1.878737702001289e-11, -1.315665523649743e-12, -2.548117111379465e-15,  2.280878960337253e-16,  1.406298217756994e-18,
 -3.498043272451105e-20, -2.180953960147278e-22,  1.775785188211864e+00, -5.391756046240264e-03, -7.289872861941054e-05, -4.337418917802841e-07,  5.027465270808983e-09,
  1.458000430879367e-10,  9.194267808010809e-13, -2.123673795009504e-14, -5.401471094905987e-16, -2.412243798233266e-18,  1.144223671135936e-19,  2.586791657979530e-21,
  1.950626775602194e+00, -1.528827266739485e-03, -3.350489030708191e-05, -6.012668256809618e-07, -8.942992946486816e-09, -1.025415429792633e-10, -6.042681970210645e-13,
  9.513449494709849e-15,  4.162482391029667e-16,  8.783042552581270e-18,  1.257504005095828e-19,  1.004769042356686e-21,  2.233814830334696e-03, -2.376713519912301e-05,
  1.892502003048809e-07, -1.343896616790536e-09,  8.818996718095037e-12, -5.810334551979735e-14,  3.190692398325668e-16, -2.344828383038014e-18,  2.149757532517076e-20,
  4.034967595454555e-22,  1.174675596106383e-23,  1.257141010752094e-25,  2.012849894138441e-02, -2.135861584838220e-04,  1.687924581581089e-06, -1.181500142742964e-08,
  7.567916087187836e-11, -4.826676848112629e-13,  2.478256694355776e-15, -1.764849841945978e-17,  1.650928052018603e-19,  3.888486842716316e-21,  1.048014925577751e-22,
  1.153719149976542e-24,  5.604731992671024e-02, -5.914488529818462e-04,  4.601269910175398e-06, -3.123524055835636e-08,  1.895931612642951e-10, -1.120068883525034e-12,
  4.786127182342418e-15, -3.131196004745677e-17,  3.206812740118724e-19,  1.200485207842016e-20,  2.884981787531294e-22,  3.307387294906817e-24,  1.102518271351252e-01,
 -1.153403984594305e-03,  8.749986187577090e-06, -5.642337460770937e-08,  3.104965171229738e-10, -1.564240359933277e-12,  3.685650748981417e-15, -1.699042383441766e-17,
  3.216759482548537e-19,  2.600345488941499e-20,  5.689854038048752e-22,  6.697729103960152e-24,  1.831404465132924e-01, -1.892418710746734e-03,  1.383470760038895e-05,
 -8.225916198863165e-08,  3.777547882070155e-10, -1.264734865646988e-12, -4.784792007464263e-15,  4.414350458602005e-17,  1.619521138106719e-19,  4.541287434185781e-20,
  9.772610938397636e-22,  1.137149667282430e-23,  2.752539626268411e-01, -2.796718283049723e-03,  1.939289399541305e-05, -1.012633105932567e-07,  3.116867987059272e-10,
  3.523859303990550e-13, -2.270077734488368e-14,  1.344010191459292e-16,  2.634591701853002e-19,  6.644575638901165e-20,  1.574138943586867e-21,  1.745580305497368e-23,
  3.872781778167061e-01, -3.846875806632562e-03,  2.472885638887430e-05, -1.030885261785608e-07,  2.115734229492896e-11,  3.612466713821184e-12, -4.607740797304570e-14,
  1.594409659627942e-16,  1.659150487592502e-18,  8.369390298408704e-20,  2.408120897023762e-21,  2.582800282341629e-23,  5.200352499153877e-01, -5.010691735611913e-03,
  2.880363726434994e-05, -7.415150268304423e-08, -5.724848199049495e-10,  8.016126989210059e-12, -5.822491584295688e-14, -8.129561583023820e-17,  5.537794004714306e-18,
  1.021134384267811e-19,  3.384423022532396e-21,  3.912502606359439e-23,  6.744429618469973e-01, -6.233973012045627e-03,  3.006793148006307e-05,  1.792950645653473e-09,
 -1.470748142978305e-09,  1.112031395911398e-11, -2.266301809395723e-14, -8.159364927094065e-16,  1.070602349829050e-17,  1.674345314071969e-19,  4.156493301043627e-21,
  5.999302058629025e-23,  8.513896257290274e-01, -7.423411190524145e-03,  2.623298384396656e-05,  1.395661413156086e-07, -2.438302819542740e-09,  6.778493875765929e-12,
  1.091487061303205e-13, -1.803732656796795e-15,  7.011411289096667e-18,  3.826841452797055e-19,  4.981840073603908e-21,  7.738118882489471e-23,  1.051386187602646e+00,
 -8.413915513064819e-03,  1.406916517372543e-05,  3.370726057320843e-07, -2.653717148709208e-09, -1.553421041571719e-11,  3.110326924895716e-13, -8.673855828179472e-16,
 -2.693571086575156e-17,  6.437575739537165e-19,  1.078051996594097e-20,  6.412759769365830e-23,  1.273605753199722e+00, -8.906454755776351e-03, -1.019247197683141e-05,
  5.262450012621159e-07, -2.103598351117481e-10, -5.846828709991210e-11,  1.576455775634027e-13,  6.567680749692145e-15, -4.510241080777653e-17, -3.520293651581737e-19,
  2.432959819674595e-20,  2.630639453208987e-22,  1.513144711079404e+00, -8.365240808202289e-03, -4.711930035454371e-05,  4.524684290697000e-07,  6.750629393153441e-09,
 -5.035791407285386e-11, -1.279205063938260e-12,  5.281637864810183e-15,  2.527100280095701e-16, -1.885379044357781e-20, -3.199137438479119e-20,  3.609670559116069e-22,
  1.753021051130718e+00, -5.994169758948058e-03, -7.752152150178310e-05, -3.290134946807955e-07,  8.105661972027819e-09,  1.587345300178974e-10,  7.737066728559215e-14,
 -3.880024203215963e-14, -5.166110159391566e-16,  4.476262692132430e-18,  2.273170560517224e-19,  2.192581764159924e-21,  1.943926046655806e+00, -1.828320099695059e-03,
 -4.164852785025523e-05, -7.614275797646998e-07, -1.110812024396936e-08, -1.120134767178480e-10, -9.650591445798789e-14,  2.893900262421195e-14,  8.318633253992114e-16,
  1.447738670189551e-17,  1.500323533737817e-19, -2.579711768995974e-22,  2.141675429933395e-03, -2.231532758555833e-05,  1.739330069449111e-07, -1.211693856814890e-09,
  7.728659663755641e-12, -5.113890164068536e-14,  2.659315592601946e-16, -1.324353608327129e-18,  4.558859243938767e-20,  9.561007396598120e-22,  1.477823273232666e-23,
 -2.862443674815163e-26,  1.930029127966825e-02, -2.006300106108605e-04,  1.553101242384887e-06, -1.067828535108521e-08,  6.658430880646674e-11, -4.283619203883904e-13,
  2.085390506666980e-15, -9.229841350974289e-18,  3.907155578099137e-19,  8.841988075704084e-21,  1.328306700955542e-22, -2.487121992681420e-25,  5.375284156361670e-02,
 -5.560880792388912e-04,  4.243928186666975e-06, -2.837499116927633e-08,  1.682774370851597e-10, -1.014077648969908e-12,  4.135392048518449e-15, -1.165873597879979e-17,
  9.898332852643936e-19,  2.573715855320314e-20,  3.697354490349931e-22, -6.559450977845171e-25,  1.057740389337099e-01, -1.086030309117228e-03,  8.101696163389843e-06,
 -5.170103079962264e-08,  2.800680284560979e-10, -1.479295222676941e-12,  3.529089621902557e-15,  1.317977832637026e-17,  1.726867221229781e-18,  5.321995562554411e-20,
  7.349620214357142e-22, -1.245375151973338e-24,  1.757860177705305e-01, -1.785588701145381e-03,  1.288300840175072e-05, -7.642322936880108e-08,  3.514223499827987e-10,
 -1.362349433405802e-12, -3.171536928190876e-15,  8.388836816072852e-17,  2.601429690902028e-18,  9.208379838883870e-20,  1.259744646399834e-21, -2.112745699246400e-24,
  2.643697999465719e-01, -2.646350641345835e-03,  1.820779649580725e-05, -9.624821239414610e-08,  3.136071486582458e-10, -1.436424086892920e-13, -1.836541277536294e-14,
  1.945775079927872e-16,  3.943917020452059e-18,  1.410416454849105e-19,  2.006318397380746e-21, -3.407444624509628e-24,  3.722785164463517e-01, -3.653982341280141e-03,
  2.349601927562250e-05, -1.022304305645848e-07,  8.275511629320928e-11,  2.569679822770685e-12, -4.027262990700245e-14,  2.812874656636105e-16,  6.635559431316848e-18,
  1.972509709214670e-19,  3.049637300422271e-21, -4.925285137574638e-24,  5.004475012610039e-01, -4.783965936463450e-03,  2.786390425843432e-05, -8.210496514980365e-08,
 -4.261990818767989e-10,  6.615846049226014e-12, -5.726364896873826e-14,  1.838359654235819e-16,  1.200106382287892e-17,  2.639388081685958e-19,  4.389415935529020e-21,
 -5.226153434726660e-24,  6.499877501993843e-01, -5.993726866643385e-03,  2.995547937743309e-05, -1.999630966064628e-08, -1.255403258552095e-09,  1.034779559157467e-11,
 -3.955057607668410e-14, -3.401843838059382e-16,  2.027394455478461e-17,  3.754833725299741e-19,  5.803388212065738e-21, -1.850472497058966e-24,  8.221253940747999e-01,
 -7.207500218125170e-03,  2.767858988391952e-05,  1.017636475081908e-07, -2.280437557684800e-09,  8.831622149835596e-12,  6.416653309512984e-14, -1.314402951497395e-15,
  2.509668307816682e-17,  6.373669043274810e-19,  7.194404553605874e-21, -7.602390743331188e-25,  1.017980202815365e+00, -8.285925541662740e-03,  1.785031469804549e-05,
  2.925235389372585e-07, -2.892122003350710e-09, -8.433753152862530e-12,  2.787845405307038e-13, -1.270550562760435e-15,  4.550629338425952e-18,  1.114634091873583e-18,
  1.202614426846412e-20, -3.946320029031084e-23,  1.237856653342793e+00, -8.962879227438353e-03, -3.935486091745494e-06,  5.137893979950229e-07, -1.327861595231186e-09,
 -5.264563067224032e-11,  3.208851904642511e-13,  5.129030814201682e-15, -3.795690520688164e-17,  7.952806232478565e-19,  3.112096398225011e-20, -2.558049000003044e-24,
  1.478966704697780e+00, -8.718727620573935e-03, -4.108008158604682e-05,  5.508197836630476e-07,  5.453131429243943e-09, -7.837893247671155e-11, -1.019745736800363e-12,
  1.315001092208912e-14,  2.340629744249503e-16, -8.526862438516367e-19, -7.602511721792527e-21,  6.370847479412786e-22,  1.727782451840825e+00, -6.627689868426281e-03,
 -8.058753299509101e-05, -1.742249182283100e-07,  1.120214169630671e-08,  1.459021408434609e-10, -1.202824987034315e-12, -5.084707284645047e-14, -1.744618769012446e-16,
  1.480518679941148e-17,  2.664168038019276e-19, -9.246415141366647e-22,  1.935884032247899e+00, -2.201247722888996e-03, -5.192547758837071e-05, -9.568693235685799e-07,
 -1.328818194123104e-08, -1.010766613119306e-10,  1.172669593950988e-12,  6.497665074463099e-14,  1.449294688770106e-15,  1.919342702684048e-17,  5.089382860179809e-20,
 -5.104008688246370e-21,  2.055107827069938e-03, -2.097999816686922e-05,  1.601019772686414e-07, -1.095879947593011e-09,  6.767702832334227e-12, -4.500096686089806e-14,
  2.552171991474589e-16,  7.906466658780151e-19,  8.937643692143977e-20,  1.410625269504612e-21,  4.544722883631176e-24, -4.964327611269093e-25,  1.852183403921632e-02,
 -1.887002811981634e-04,  1.431079831669146e-06, -9.678813301986139e-09,  5.850530957432939e-11, -3.796716921116374e-13,  2.056765889783142e-15,  9.314059464732786e-18,
  7.932368708247129e-19,  1.292514959451592e-20,  4.044299919385783e-23, -4.494047000241928e-24,  5.159429822846331e-02, -5.234543884701750e-04,  3.918930980888412e-06,
 -2.583944670857206e-08,  1.489844261886624e-10, -9.142123799009013e-13,  4.410944535939039e-15,  3.748022220622788e-17,  2.150801462223070e-18,  3.709403189907778e-20,
  1.109046535206136e-22, -1.264290615451348e-23,  1.015557201781935e-01, -1.023624428251075e-03,  7.507209563219755e-06, -4.745176522706958e-08,  2.513994952178621e-10,
 -1.381959454186723e-12,  4.998090419441961e-15,  1.043433743514787e-16,  4.108923689564774e-18,  7.579060513000869e-20,  2.184682539693867e-22, -2.531499945446999e-23,
  1.688441151229555e-01, -1.686099454903463e-03,  1.199875632955428e-05, -7.102157296381105e-08,  3.236672890033404e-10, -1.397476421292240e-12,  9.068134166934876e-16,
  2.291760846790399e-16,  6.716054229545694e-18,  1.308343782489749e-19,  3.788092920243194e-22, -4.321037014570993e-23,  2.540685272149850e-01, -2.505223245894405e-03,
  1.708275767466968e-05, -9.127525498068393e-08,  3.068634661743751e-10, -4.995499536910502e-13, -1.028237495961328e-14,  4.163753417534219e-16,  1.029752384762982e-17,
  2.030699572793696e-19,  6.292180911122491e-22, -6.744897611973176e-23,  3.580307903933971e-01, -3.470895158262156e-03,  2.227873303278438e-05, -1.005445138365238e-07,
  1.252760579874385e-10,  1.729013935277098e-12, -2.819691377312245e-14,  6.291170478145709e-16,  1.568482022245797e-17,  2.924268152215677e-19,  1.021154054692890e-21,
 -9.950269431959959e-23,  4.817510690073882e-01, -4.565102083638757e-03,  2.684186107177180e-05, -8.793763199332250e-08, -3.069426793245718e-10,  5.356631497997366e-12,
 -4.508092331155644e-14,  7.515503859272577e-16,  2.432769433470156e-17,  4.026802675019801e-19,  1.561308414886832e-21, -1.408189447201941e-22,  6.264901489108357e-01,
 -5.755368940715367e-03,  2.960166213857296e-05, -3.848043270784516e-08, -1.058273449707797e-09,  9.371633659000367e-12, -3.765447435910280e-14,  5.669918802132258e-16,
  3.755596462904434e-17,  5.606167297856646e-19,  2.063667827987938e-21, -1.928766952831543e-22,  7.937451273062988e-01, -6.981793209794879e-03,  2.868690192980356e-05,
  6.676278946891139e-08, -2.090820185351033e-09,  1.004385407639440e-11,  4.243520893202248e-14, -9.212230331679338e-17,  5.267736805325818e-17,  8.625863103342370e-19,
  2.153859917448585e-21, -2.636987927536485e-22,  9.851432129021893e-01, -8.129879065938220e-03,  2.107853352472766e-05,  2.452524280497134e-07, -2.996516423038447e-09,
 -2.113143325764986e-12,  2.519003465175059e-13, -3.980629306374724e-16,  5.219253925820915e-17,  1.477121299387723e-18,  3.487139877837983e-21, -3.985551054210963e-22,
  1.201980604958922e+00, -8.970139472418752e-03,  2.069249653510436e-06,  4.845855269595437e-07, -2.292695385837238e-09, -4.332340138683330e-11,  4.534670280737921e-13,
  4.603825902486679e-15,  1.169609583424711e-17,  1.883075255879227e-18,  1.870240457493975e-20, -6.299247359703391e-22,  1.443478302091904e+00, -9.019572765091015e-03,
 -3.400240316698194e-05,  6.243395505759893e-07,  3.674888323648263e-09, -9.761724655935174e-11, -5.514255402346895e-13,  2.013956177116324e-14,  2.037223550477803e-16,
 -7.142536999374032e-19,  9.486303971606711e-21, -5.747321389168695e-23,  1.699973628962161e+00, -7.277496790266902e-03, -8.151294651423141e-05,  2.629679642125224e-08,
  1.371527161965258e-08,  9.988129625819287e-11, -2.610806806555202e-12, -4.601383547875383e-14,  5.268451337239237e-16,  2.311789018859392e-17,  1.084065369796413e-19,
 -6.470476388576924e-21,  1.926170223174993e+00, -2.666335875733645e-03, -6.474339710787493e-05, -1.183402266756474e-06, -1.485110583788788e-08, -4.522101493324743e-11,
  3.744663342351372e-12,  1.222039089493644e-13,  2.097911448764040e-15,  1.389597907070875e-17, -4.002617990742670e-19, -1.671338490633455e-20,  1.973668690578481e-03,
 -1.975000994721980e-05,  1.475725306498895e-07, -9.944501089471270e-10,  5.932598699255353e-12, -3.824001818197245e-14,  3.249723597771930e-16,  4.443138132423595e-18,
  1.362518024308687e-19,  9.414459247612018e-22, -3.373817420020485e-23, -1.277088795837020e-24,  1.778921632985460e-02, -1.777008711461121e-04,  1.320309064801124e-06,
 -8.800647995851126e-09,  5.144327615742664e-11, -3.238819658591674e-13,  2.742316740608377e-15,  4.195513754176412e-17,  1.222628446972272e-18,  8.645337754229237e-21,
 -3.064677296673537e-22, -1.157769563568953e-23,  4.956127520023906e-02, -4.933040601395372e-04,  3.622576723347173e-06, -2.359570541348316e-08,  1.318892485346194e-10,
 -7.867472864776462e-13,  6.622952773874211e-15,  1.271215313025157e-16,  3.382905352957193e-18,  2.491891075339521e-20, -8.665911440823309e-22, -3.264549041720924e-23,
  9.757782531277880e-02, -9.657781079180501e-04,  6.961035179110801e-06, -4.364267627263508e-08,  2.252839965423774e-10, -1.209572227264658e-12,  1.016696940471725e-14,
  2.783521858194616e-16,  6.627670052250213e-18,  5.123173926822913e-20, -1.741639827175186e-21, -6.550696521060490e-23,  1.622864212779883e-01, -1.593432505947489e-03,
  1.117665814488300e-05, -6.606263550529840e-08,  2.965991712955257e-10, -1.270079824378813e-12,  1.103459315157037e-14,  5.175620031941260e-16,  1.107213282278213e-17,
  8.912227719840880e-20, -2.969255660424140e-21, -1.119399612308693e-22,  2.443141381871479e-01, -2.372859753598890e-03,  1.601655300507553e-05, -8.645405505307734e-08,
  2.955702205004819e-10, -5.624351736003989e-13,  7.081134673737662e-15,  8.602098510464732e-16,  1.708288702373510e-17,  1.394800949148761e-19, -4.596949175782039e-21,
 -1.747628067051297e-22,  3.444960794175488e-01, -3.297454932044403e-03,  2.108526650843860e-05, -9.829308851021871e-08,  1.548505209213672e-10,  1.330138862459088e-12,
 -1.977909383656023e-15,  1.296265489097920e-15,  2.550359184455155e-17,  2.022451013801603e-19, -6.695838365947591e-21, -2.581974292128101e-22,  4.639133396292074e-01,
 -4.354663887104001e-03,  2.576051168247812e-05, -9.204152896310138e-08, -2.084130659270064e-10,  4.628639078391219e-12, -1.096127390497367e-14,  1.758298161704231e-15,
  3.789804746237878e-17,  2.789212049200307e-19, -9.419927882036750e-21, -3.682906715106793e-22,  6.039389872766638e-01, -5.520676591322497e-03,  2.904435007601011e-05,
 -5.395436640179433e-08, -8.778104510880170e-10,  8.812952116732555e-12, -1.926976026224807e-15,  2.085929042842566e-15,  5.639298882993300e-17,  3.855584726827543e-19,
 -1.317423808266826e-20, -5.139048980382943e-22,  7.662812365885430e-01, -6.749646446537956e-03,  2.929415151283230e-05,  3.497493663673042e-08, -1.878861413062745e-09,
  1.125042375811639e-11,  6.807603538823820e-14,  2.077224858219459e-15,  8.138916033945592e-17,  5.940735171111171e-19, -1.887677743062119e-20, -7.126611178518237e-22,
  9.529784401466285e-01, -7.950294814368330e-03,  2.373356563403668e-05,  1.972987770748419e-07, -2.978041883682053e-09,  4.036513349942063e-12,  2.720763456457006e-13,
  2.105691628621585e-15,  1.021350455528578e-16,  1.095872028259331e-18, -2.713627163899977e-20, -1.023045147413768e-21,  1.166169021460409e+00, -8.931010769244055e-03,
  7.637622635659258e-06,  4.416074072309671e-07, -3.039391823832537e-09, -3.078484304139725e-11,  5.984437148539834e-13,  6.137160335822759e-15,  8.384961590862786e-17,
  1.806619783046126e-18, -2.968072648072726e-20, -1.604573228711609e-21,  1.406904633257544e+00, -9.260776167551728e-03, -2.622374072992015e-05,  6.670046447557895e-07,
  1.639591905928996e-09, -1.033696425428058e-10,  1.002505557769578e-13,  2.628929337949972e-14,  1.801520113365954e-16, -8.467271724677237e-19, -2.912839790759890e-20,
 -1.827786205507226e-21,  1.669566869731833e+00, -7.924479862253971e-03, -7.982691782126226e-05,  2.579239008009722e-07,  1.499511261105250e-08,  2.444964233727631e-11,
 -3.535799220212627e-12, -1.565710261150617e-14,  1.353786879507456e-15,  2.017885697115587e-17, -2.890640158143262e-19, -1.101241786857728e-20,  1.914373300982635e+00,
 -3.245156526805566e-03, -8.038044143076694e-05, -1.422067900983425e-06, -1.453901375702930e-08,  9.360828206907846e-11,  8.149655855305065e-12,  1.925211612391003e-13,
  2.088063094354222e-15, -2.177657151623912e-17, -1.509870472853087e-18, -3.376691277476090e-20,  1.896956438324843e-03, -1.861560476501524e-05,  1.361849306486753e-07,
 -9.051717197416762e-10,  5.258504448516827e-12, -2.843608242469679e-14,  5.129525873348735e-16,  8.960987077877848e-18,  1.301961357183005e-19, -1.757737487502513e-21,
 -1.058479483086520e-22, -1.889554923786557e-24,  1.709888807829737e-02, -1.675473039123857e-04,  1.219438953583441e-06, -8.025319117733518e-09,  4.574262136214561e-11,
 -2.393724956928168e-13,  4.488312180688466e-15,  8.256853783871934e-17,  1.171247694597606e-18, -1.585133809188356e-20, -9.603758196795278e-22, -1.713880246555836e-23,
  4.764427606157522e-02, -4.654212991530640e-04,  3.351602202166090e-06, -2.160128272654588e-08,  1.180977452337843e-10, -5.723376334935515e-13,  1.176699348382027e-14,
  2.398663147044165e-16,  3.255664371190570e-18, -4.426364749346562e-20, -2.711310011252855e-21, -4.836995236784720e-23,  9.382285681234204e-02, -9.121251351491131e-04,
  6.458203269406407e-06, -4.021530916587235e-08,  2.042927766639846e-10, -8.470027396076901e-13,  2.107517071262523e-14,  5.001363464572960e-16,  6.414393058840915e-18,
 -8.772710753894518e-20, -5.445429893919866e-21, -9.716997196278549e-23,  1.560866085242471e-01, -1.507111381865150e-03,  1.041160365626780e-05, -6.150019705445277e-08,
  2.752353824699751e-10, -7.894287874882837e-13,  3.074356969944961e-14,  8.894025593150573e-16,  1.076902984525173e-17, -1.481005487180304e-19, -9.301937837663348e-21,
 -1.662457745588206e-22,  2.350725060151936e-01, -2.248797478680800e-03,  1.500716293870911e-05, -8.179634304464565e-08,  2.883049513335128e-10, -3.872375912595131e-14,
  3.922522014854663e-14,  1.434726027118104e-15,  1.664931335049612e-17, -2.293893509287570e-19, -1.448906561499747e-20, -2.598798847273285e-22,  3.316362158688590e-01,
 -3.133446675593366e-03,  1.992152248831341e-05, -9.559117425162134e-08,  1.844150279437312e-10,  1.814710336681428e-12,  4.632613504042337e-14,  2.152075654043081e-15,
  2.479310436556111e-17, -3.390372918025500e-19, -2.132254710173215e-20, -3.846506949704688e-22,  4.468997863533186e-01, -4.153047439287003e-03,  2.463906614904224e-05,
 -9.463055821620510e-08, -1.137477839730645e-10,  5.099211677677363e-12,  5.603633037051021e-14,  3.023134540531461e-15,  3.663060350120123e-17, -4.883923896017305e-19,
 -3.032056974408093e-20, -5.505604269352245e-22,  5.823165706805686e-01, -5.291136871457418e-03,  2.831849964417206e-05, -6.656812817356610e-08, -6.961917915279207e-10,
  9.679478080437644e-12,  8.281941799635371e-14,  3.960794358629033e-15,  5.445961942952429e-17, -6.876826987139448e-19, -4.244172545028210e-20, -7.731175442646640e-22,
  7.397533172574527e-01, -6.514107690027264e-03,  2.954126009307908e-05,  6.827251870885188e-09, -1.631223004293471e-09,  1.388937756509203e-11,  1.644807427729258e-13,
  4.808561585355742e-15,  8.039124133903409e-17, -9.205474157645042e-19, -5.961873738767442e-20, -1.079641785166042e-21,  9.215708602260765e-01, -7.751757407002460e-03,
  2.581914389094105e-05,  1.506778018978761e-07, -2.825209128487869e-09,  1.166974563417720e-11,  3.806623653104640e-13,  5.696160246907144e-15,  1.094687094226184e-16,
 -1.075366984178676e-18, -8.530945966974210e-20, -1.538681108911801e-21,  1.130599520458637e+00, -8.849580755564827e-03,  1.262751397060679e-05,  3.888964743733418e-07,
 -3.495762919485092e-09, -1.400874934286385e-11,  8.151066496715549e-13,  9.476358276073964e-15,  1.078984164052097e-16, -1.071317642623499e-18, -1.200075380220689e-19,
 -2.374559632084316e-21,  1.369493066178844e+00, -9.438258885433459e-03, -1.812937363814890e-05,  6.770912182841716e-07, -3.409132997178986e-10, -9.151976093223026e-11,
  9.097859154544813e-13,  3.114860891696320e-14,  1.039385015257065e-16, -4.201220430628756e-18, -1.514362920869276e-19, -3.545286334496715e-21,  1.636617090755230e+00,
 -8.546629334155627e-03, -7.529127709040705e-05,  4.970936030930484e-07,  1.462778368575488e-08, -6.020751518320001e-11, -3.280006655189317e-12,  3.608732860164842e-14,
  1.752821224467783e-15, -1.245034706675631e-18, -7.727335373445653e-19, -9.678426153622616e-21,  1.899993213931970e+00, -3.960192996183442e-03, -9.873949071629990e-05,
 -1.627132968869676e-06, -1.024010660600589e-08,  3.602204051848051e-10,  1.425685369029378e-11,  2.320285204049711e-13, -1.698766093406049e-16, -1.146087263161052e-16,
 -3.135659633972321e-18, -3.323567880145137e-20,  1.824606153411673e-03, -1.756818167191230e-05,  1.258113365458982e-07, -8.248238203273323e-10,  4.835280638025401e-12,
 -1.273521599917439e-14,  8.059193419655455e-16,  1.113827175529925e-17, -2.864987199061373e-20, -7.546232841443832e-21, -1.763206661120532e-22, -8.486892654589073e-25,
  1.644761710010458e-02, -1.581648872498365e-04,  1.127389699269431e-06, -7.325031410202267e-09,  4.223820025386248e-11, -1.005033079152773e-13,  7.177867353360839e-15,
  1.020581025889766e-16, -2.664734633895829e-19, -6.837020788866050e-20, -1.599853467179969e-21, -7.711695559658320e-24,  4.583461914559882e-02, -4.396139786762161e-04,
  3.103402845677494e-06, -1.978548035350512e-08,  1.100706260327383e-10, -1.998851804289074e-13,  1.952918807726541e-14,  2.935386833635921e-16, -7.857299733597590e-19,
 -1.925397428552319e-19, -4.517622279277211e-21, -2.184506102835304e-23,  9.027470816713597e-02, -8.623353599403188e-04,  5.994775565344337e-06, -3.704953832405073e-08,
  1.936464239306504e-10, -1.545849374297588e-13,  3.713028497261055e-14,  6.046244812272410e-16, -1.660923430832421e-18, -3.856043387193162e-19, -9.078911143379639e-21,
 -4.414088178316858e-23,  1.502201791310639e-01, -1.426696592944063e-03,  9.699657353967295e-06, -5.717357331742506e-08,  2.690122891817070e-10,  2.783515615418739e-13,
  5.907595727775808e-14,  1.062853123058738e-15, -2.965925575975403e-18, -6.572883386557480e-19, -1.552980746832263e-20, -7.614719204152946e-23,  2.263113253228944e-01,
 -2.132587635496785e-03,  1.405346385387183e-05, -7.712390956380329e-08,  3.004609103981936e-10,  1.432774037860396e-12,  8.468939202229441e-14,  1.701555154090401e-15,
 -4.709997731469088e-18, -1.023569835120149e-18, -2.424846602118573e-20, -1.203673172072245e-22,  3.194139836745019e-01, -2.978609452759249e-03,  1.879358504890124e-05,
 -9.226787885604952e-08,  2.370998282615896e-10,  3.721309599013771e-12,  1.144933377511917e-13,  2.553019706636231e-15, -6.719780155254851e-18, -1.510146883388407e-18,
 -3.581374366899328e-20, -1.807414155076459e-22,  4.306745970543912e-01, -3.960499739181639e-03,  2.349626557732422e-05, -9.553071372890759e-08,  9.123006667824198e-12,
  7.566531910948339e-12,  1.525107035595309e-13,  3.633294086746063e-15, -8.452551609027790e-18, -2.157713698510804e-18, -5.114821522585698e-20, -2.633918069718193e-22,
  5.615998131989172e-01, -5.067957893985676e-03,  2.745969663970762e-05, -7.600965513596506e-08, -4.728697737714503e-10,  1.315866766828086e-11,  2.116795470167705e-13,
  4.914160626029759e-15, -8.833853009429658e-18, -3.028285059705593e-18, -7.184193386652488e-20, -3.778556125348381e-22,  7.141694690301545e-01, -6.277870841911440e-03,
  2.947658791677835e-05, -1.678509739466316e-08, -1.301749177003923e-09,  1.969391722850919e-11,  3.263376472800626e-13,  6.298829997297448e-15, -6.842831828187596e-18,
 -4.206190184518805e-18, -1.009201744183483e-19, -5.402765042840518e-22,  8.909873313414753e-01, -7.538718919508035e-03,  2.736553118398646e-05,  1.078986326438433e-07,
 -2.485738707490837e-09,  2.305280373887826e-11,  5.779189345136159e-13,  7.790256386347768e-15, -6.607468684495096e-18, -5.774664586157589e-18, -1.444621755559816e-19,
 -7.897184772927857e-22,  1.095431432621182e+00, -8.730858374555150e-03,  1.695313732725017e-05,  3.318821795240128e-07, -3.557091667910162e-09,  9.054220345467839e-12,
  1.115202754770325e-12,  1.118342770677935e-14, -4.170545882469515e-17, -7.863254971634490e-18, -2.120117181841479e-19, -1.282151078600194e-21,  1.331501116803223e+00,
 -9.551016134786630e-03, -1.009274513624355e-05,  6.584808401033354e-07, -1.881142497446472e-09, -5.903237000210918e-11,  1.795639006131441e-12,  3.057527898800449e-14,
 -1.943888030748088e-16, -1.336709112177308e-17, -2.981841074281333e-19, -2.270334727500628e-21,  1.601269156128498e+00, -9.121237444325494e-03, -6.797427078583569e-05,
  7.176826202224297e-07,  1.275002189350949e-08, -1.207372675887513e-10, -1.537798053094471e-12,  8.478621713687983e-14,  1.068678082991798e-15, -3.837700126791796e-17,
 -1.009907708362481e-18,  5.114190002040646e-22,  1.882445902908386e+00, -4.830317569742883e-03, -1.189442858540775e-04, -1.712608411589522e-06,  8.894914486316180e-10,
  7.749965769168061e-10,  1.987172681000856e-11,  1.342805298636600e-13, -6.779869333889821e-15, -2.538929167134811e-16, -3.242219172264352e-18,  4.839201998817541e-20,
  1.756285561943693e-03, -1.659997935015911e-05,  1.163729138512164e-07, -7.483455731856131e-10,  4.797477992109848e-12,  9.945298555832890e-15,  1.054282059668025e-15,
  4.502318545899890e-18, -4.264615899814043e-19, -1.419779987949593e-20, -1.186110936880069e-22,  4.335031222009555e-24,  1.583245518423278e-02, -1.494859696885076e-04,
  1.043510717256652e-06, -6.655020066786999e-09,  4.216602630581013e-11,  1.023709925845656e-13,  9.456861481897212e-15,  4.169455740337364e-17, -3.872600822345203e-18,
 -1.287419946314950e-19, -1.077368024377744e-21,  3.929381017665252e-23,  4.412435607117635e-02, -4.157066447886910e-04,  2.876501736992249e-06, -1.802821698685361e-08,
  1.113791995638823e-10,  3.569326656900847e-13,  2.610221714551638e-14,  1.223131720506087e-16, -1.095097552929313e-17, -3.631240545900756e-19, -3.048823211886107e-21,
  1.107323542842615e-22,  8.691854185176714e-02, -8.161027543406204e-04,  5.568841032875756e-06, -3.392205252442583e-08,  2.007425418087077e-10,  9.183185469340515e-13,
  5.072214786663648e-14,  2.586397130784695e-16, -2.204532041969145e-17, -7.287660993614461e-19, -6.147543670236476e-21,  2.218727878037563e-22,  1.446643466334041e-01,
 -1.351769522356362e-03,  9.039859387884151e-06, -5.273820274500379e-08,  2.910040309916127e-10,  2.016350156097505e-12,  8.308284013345090e-14,  4.682920892972766e-16,
 -3.776066582785219e-17, -1.245122103554135e-18, -1.056412505893443e-20,  3.780485025078247e-22,  2.180000880320883e-01, -2.023777174194775e-03,  1.315816698221086e-05,
 -7.196146662537495e-08,  3.530436889968774e-10,  3.979160193689701e-12,  1.233286304031381e-13,  7.720879915190770e-16, -5.896087291677041e-17, -1.943206655549275e-18,
 -1.659471985280366e-20,  5.874713336883514e-22,  3.077933307332206e-01, -2.832618396670017e-03,  1.771213552397938e-05, -8.770644719725076e-08,  3.444193026969149e-10,
  7.242377994061254e-12,  1.727920071796713e-13,  1.188439689963438e-15, -8.682662122388498e-17, -2.871837258787749e-18, -2.469757584108908e-20,  8.626387668137535e-22,
  4.152012985093129e-01, -3.777099648301819e-03,  2.235650183236264e-05, -9.394224774244646e-08,  2.047816457655314e-10,  1.233086506013934e-11,  2.359156354807800e-13,
  1.719959034278866e-15, -1.229635364123455e-16, -4.108578628757038e-18, -3.560865153025722e-20,  1.223023057763675e-21,  5.417614073569238e-01, -4.852035385532159e-03,
  2.651188736310344e-05, -8.114943479540039e-08, -1.484141463622644e-10,  1.973725151602206e-11,  3.249031237456821e-13,  2.324454746699124e-15, -1.697019893945005e-16,
 -5.778712658418447e-18, -5.060167270007209e-20,  1.700560080164436e-21,  6.895278788319623e-01, -6.043184910724387e-03,  2.916473356328374e-05, -3.397906410208304e-08,
 -8.160891194235125e-10,  2.944935405636689e-11,  4.712123603603692e-13,  2.865291183640906e-15, -2.312776286035603e-16, -8.086542228142574e-18, -7.212737959208385e-20,
  2.351506887752481e-21,  8.612776027356454e-01, -7.315251363528876e-03,  2.843953527073225e-05,  7.263974213237885e-08, -1.869400660773975e-09,  3.928367495874250e-11,
  7.537139827033275e-13,  3.116743656298166e-15, -3.193426572404020e-16, -1.136182156422919e-17, -1.053899339305051e-19,  3.281229058227845e-21,  1.060803137104446e+00,
 -8.580246745733017e-03,  2.060520495815883e-05,  2.779714274068493e-07, -3.085102383313422e-09,  3.910430523354139e-11,  1.355119187058785e-12,  3.641609323763271e-15,
 -4.800255070601382e-16, -1.617821693859810e-17, -1.605713671176112e-19,  4.676904431912432e-21,  1.293184793064057e+00, -9.600735831460244e-03, -2.402190548559846e-06,
  6.215507955411322e-07, -2.567321565317489e-09, -6.896634431979760e-12,  2.475264963785956e-12,  1.426144260016262e-14, -8.978328698952668e-16, -2.533660257991514e-17,
 -2.336977768007794e-19,  6.931094757193149e-21,  1.563755804683469e+00, -9.627307163156625e-03, -5.822192779548100e-05,  9.012173672589812e-07,  1.017205874510697e-08,
 -1.268406244018217e-10,  1.053440972424501e-12,  8.943297715728804e-14, -9.868786046805622e-16, -7.289694329583849e-17, -5.577897240648513e-19,  2.231396607537187e-20,
  1.861093477686118e+00, -5.862484615078109e-03, -1.388125801710975e-04, -1.547742857830058e-06,  2.129787431160137e-08,  1.263337099039812e-09,  1.908036378559068e-11,
 -2.467730790994918e-13, -1.727340051188651e-14, -2.880142157312972e-16,  3.029257405899444e-18,  2.499236389980435e-19,  1.691692610414343e-03, -1.570358758575995e-05,
  1.078643786942107e-07, -6.686110540104293e-10,  5.249567555664387e-12,  3.472571943255416e-14,  9.088180944502420e-16, -1.771488034210332e-17, -9.539440219208567e-19,
 -1.256017019807408e-20,  2.669685406247714e-22,  1.325677053059934e-23,  1.525071819421408e-02, -1.414456192819703e-04,  9.678062796626920e-07, -5.951564480054391e-09,
  4.648637098956616e-11,  3.248704061762301e-13,  8.159560392882877e-15, -1.599578571816867e-16, -8.657041080549633e-18, -1.139649527122744e-19,  2.419545705086083e-21,
  1.202684000492732e-22,  4.250622714174752e-02, -3.935289241593508e-04,  2.671202484329077e-06, -1.615471190284111e-08,  1.248017807946563e-10,  9.722698782633291e-13,
  2.256185612583731e-14, -4.474398444537345e-16, -2.445341369046978e-17, -3.218565338105597e-19,  6.816885722419002e-21,  3.395377320778558e-22,  8.374073368836268e-02,
 -7.731238517831450e-04,  5.181870600052323e-06, -3.049639357700686e-08,  2.313497219721885e-10,  2.117512159746892e-12,  4.395357752700455e-14, -8.872176980154470e-16,
 -4.916664373917033e-17, -6.471994734237752e-19,  1.365567556251109e-20,  6.822658805686034e-22,  1.393980148766375e-01, -1.281899148912148e-03,  8.436624142093354e-06,
 -4.764973169719931e-08,  3.514442484325421e-10,  3.987854588905853e-12,  7.221108163069416e-14, -1.493038493349617e-15, -8.414974820248774e-17, -1.108674277762317e-18,
  2.326492988523488e-20,  1.167223430666360e-21,  2.101101858172175e-01, -1.921862849756305e-03,  1.233167773838674e-05, -6.551262729439437e-08,  4.625891458437980e-10,
  6.917675115079761e-12,  1.074961600208229e-13, -2.290837131803742e-15, -1.314575170864410e-16, -1.736108710419760e-18,  3.615700056505732e-20,  1.823759534300257e-21,
  2.967397342757599e-01, -2.695025038763923e-03,  1.669824679866146e-05, -8.080724384272659e-08,  5.313870409065513e-10,  1.137478564043311e-11,  1.508472241655043e-13,
 -3.330045983872080e-15, -1.941453871372177e-16, -2.576658577741742e-18,  5.311716261598506e-20,  2.697255475940088e-21,  4.004435702525929e-01, -3.602680376841301e-03,
  2.125801029253497e-05, -8.837861537158640e-08,  5.090165825363846e-10,  1.798301626247474e-11,  2.056141295607837e-13, -4.707300621479776e-15, -2.768085558397060e-16,
 -3.706009082394855e-18,  7.536189842533532e-20,  3.859310982516110e-21,  5.227712747555915e-01, -4.643843018798587e-03,  2.553827366969268e-05, -7.993390131254530e-08,
  3.255564593802314e-10,  2.750085409219885e-11,  2.810494007149254e-13, -6.617273779693038e-15, -3.866589503684724e-16, -5.248989749677432e-18,  1.048259710841026e-19,
  5.427990719374708e-21,  6.658189432621712e-01, -5.811671196526758e-03,  2.870009770646316e-05, -4.170149115758303e-08, -1.130279859684324e-10,  4.060256934317061e-11,
  4.016864064984881e-13, -9.461551906920662e-15, -5.360916748893075e-16, -7.417489254881525e-18,  1.447078850752508e-19,  7.611672158162684e-21,  8.324765194433227e-01,
 -7.084690708645910e-03,  2.916088067903353e-05,  5.000140316730820e-08, -9.034156570249397e-10,  5.686748387038447e-11,  6.328590529412113e-13, -1.405518125199279e-14,
 -7.505480119366087e-16, -1.057652222552983e-17,  2.006586797366880e-19,  1.081416759926427e-20,  1.026831867406641e+00, -8.402830686019207e-03,  2.367622894204546e-05,
  2.366297666659767e-07, -1.980902652697883e-09,  7.054575553938036e-11,  1.148851264852362e-12, -2.169374053369207e-14, -1.100504206035099e-15, -1.535654860047917e-17,
  2.851239717874819e-19,  1.591219230609059e-20,  1.254789679787643e+00, -9.590806343789763e-03,  4.816065678570122e-06,  5.826640187459203e-07, -2.099373020487145e-09,
  5.316770391671415e-11,  2.327229959152065e-12, -2.998197333133030e-14, -1.860109775686855e-15, -2.358157461008887e-17,  4.563753856448111e-19,  2.510496329138071e-20,
  1.524387185543950e+00, -1.004723737006551e-02, -4.650796503972545e-05,  1.045804571155954e-06,  8.061795019717558e-09, -7.759834359471982e-11,  2.704028027256783e-12,
  1.402812694860269e-14, -3.691721412626245e-15, -6.617616688925057e-17,  1.138143311495579e-18,  5.524328601840454e-20,  1.835315803117282e+00, -7.039418586532541e-03,
 -1.544358672264375e-04, -9.835449854587435e-07,  5.022571266802866e-08,  1.567742055304274e-09,  3.181664091920192e-12, -9.171849209878490e-13, -2.232489267473160e-14,
  1.022722951556315e-16,  1.709201795995874e-17,  3.218193906562286e-19,  1.630555369474324e-03, -1.487127862687348e-05,  1.003711423914891e-07, -5.781118538240980e-10,
  6.102786175651997e-12,  4.682187727794196e-14, -6.071202728826358e-17, -5.217230735540082e-17, -1.059219103934808e-18,  1.108724646078819e-20,  9.131542244468589e-22,
  1.249682400404267e-23,  1.469998687543929e-02, -1.339756469062880e-04,  9.010934727399905e-07, -5.147289036579667e-09,  5.440473298250052e-11,  4.328019729025197e-13,
 -6.164790566735345e-16, -4.726743260598060e-16, -9.614152424249729e-18,  1.005079169235251e-19,  8.284723691788529e-21,  1.135090374490666e-22,  4.097367300590313e-02,
 -3.728991433894079e-04,  2.490048193013088e-06, -1.397886257759301e-08,  1.481541538516157e-10,  1.266942768220832e-12, -2.105442146491912e-15, -1.330872572716352e-15,
 -2.716778346849032e-17,  2.832894235645340e-19,  2.339158766582152e-20,  3.212315262665953e-22,  8.072892396824467e-02, -7.330662514921580e-04,  4.839675386306990e-06,
 -2.641055195627327e-08,  2.812451609323714e-10,  2.680307665432261e-12, -5.298648471527890e-15, -2.663900389007229e-15, -5.466213478972879e-17,  5.677441617753551e-19,
  4.701165518701843e-20,  6.478954731362464e-22,  1.344019264904193e-01, -1.216591170941494e-03,  7.901450133893485e-06, -4.131448017899315e-08,  4.434486507859832e-10,
  4.887188188743208e-12, -1.138347713691648e-14, -4.535216426842584e-15, -9.365969423879113e-17,  9.675236778299485e-19,  8.045187988081905e-20,  1.114174952065132e-21,
  2.026152547708896e-01, -1.826216929325625e-03,  1.159487296728107e-05, -5.689516761679572e-08,  6.188941014681554e-10,  8.208918734143609e-12, -2.196191606092997e-14,
 -7.046905927343694e-15, -1.465656144699032e-16,  1.503378248643358e-18,  1.257619397055861e-19,  1.752767967558651e-21,  2.862208929197562e-01, -2.565154919080500e-03,
  1.578759852645723e-05, -7.033361822458172e-08,  7.836148561778385e-10,  1.310932957657558e-11, -3.893542098057388e-14, -1.036288990066204e-14, -2.170175642506789e-16,
  2.206279166718385e-18,  1.861194435490100e-19,  2.614926838783931e-21,  3.863664934660275e-01, -3.436691239674532e-03,  2.025890110607077e-05, -7.715307317111706e-08,
  9.017561622495526e-10,  2.024154743601090e-11, -6.402160295239124e-14, -1.475411657253865e-14, -3.105888418368688e-16,  3.123243190696235e-18,  2.665413931994370e-19,
  3.782712410100044e-21,  5.045986226967073e-01, -4.443241344551331e-03,  2.462942118623684e-05, -7.004837787101347e-08,  9.201959724026169e-10,  3.049129040199040e-11,
 -9.715331196964635e-14, -2.069153690202740e-14, -4.361517732581555e-16,  4.329459641385154e-18,  3.752712777090407e-19,  5.393393685162722e-21,  6.430283322528535e-01,
 -5.584038309308485e-03,  2.821698763004399e-05, -3.661730883377181e-08,  7.631054758442209e-10,  4.493620018885960e-11, -1.314494879160997e-13, -2.905044782200547e-14,
 -6.088769596206155e-16,  5.958245933610681e-18,  5.267074093345248e-19,  7.692266327406764e-21,  8.046079035492736e-01, -6.849158400830232e-03,  2.971388383895513e-05,
  4.528439937266021e-08,  3.387055686981651e-10,  6.434813035642558e-11, -1.372346626724884e-13, -4.158721188086717e-14, -8.583198104719132e-16,  8.293505288460339e-18,
  7.483373467185393e-19,  1.115974980022514e-20,  9.936167395364791e-01, -8.202485804268966e-03,  2.637628361643872e-05,  2.174371482319775e-07, -3.657938261372844e-10,
  8.645443791672641e-11, -1.030974205293843e-14, -6.203345151099223e-14, -1.257832122552958e-15,  1.213056987704987e-17,  1.100640798238851e-18,  1.685448756412663e-20,
  1.216547116806283e+00, -9.524782382130592e-03,  1.165032523504045e-05,  5.602008004241635e-07, -5.829272895755800e-10,  9.162119381393926e-11,  5.657204391656828e-13,
 -9.714901275660184e-14, -2.077741684166564e-15,  2.033045970190171e-17,  1.763558895594325e-18,  2.739448649989405e-20,  1.483536558397516e+00, -1.036700510188058e-02,
 -3.322443764195250e-05,  1.165772870130014e-06,  7.113826138845413e-09, -2.309877760122160e-11,  1.177056041611246e-12, -1.282777443635819e-13, -4.612019883482007e-15,
  3.328023255235279e-17,  3.834359309683850e-18,  5.306104384901494e-20,  1.804634808341834e+00, -8.306093308355505e-03, -1.603957458713744e-04,  6.496475582276123e-08,
  7.988031432376631e-08,  1.263906365781193e-09, -3.087415505956952e-11, -1.418999115366027e-12, -3.906060530271432e-15,  9.489268115518890e-16,  2.069963847755391e-17,
 -2.978871499830135e-19,  1.572634690086092e-03, -1.409433096523186e-05,  9.404880625230410e-08, -4.736131630711784e-10,  6.889082417187039e-12,  2.464603784785799e-14,
 -1.881270116764384e-15, -7.191505932601944e-17,  7.223506300290488e-20,  5.176537604855167e-20,  8.881060756304923e-22, -1.910644315773037e-23,  1.417813231158102e-02,
 -1.269985429332117e-04,  8.448182448434633e-07, -4.213427376419475e-09,  6.168425700041591e-11,  2.302387943170295e-13, -1.711736643777839e-14, -6.519638388245904e-16,
  6.497146270424465e-19,  4.696955479230641e-19,  8.063572101882057e-21, -1.732745316601476e-22,  3.952091413304816e-02, -3.536076068577560e-04,  2.337313456106565e-06,
 -1.142267962600588e-08,  1.695268273868967e-10,  6.874060092107787e-13, -4.860368174415575e-14, -1.838023234443405e-15,  1.803133599056096e-18,  1.326417674521417e-18,
  2.280213659586762e-20, -4.888254707672363e-22,  7.787219971019956e-02, -6.955361661271712e-04,  4.551417867970734e-06, -2.151722786719495e-08,  3.266473248660018e-10,
  1.493335172843987e-12, -9.848047381677088e-14, -3.685813402508897e-15,  3.532707734068085e-18,  2.666481672226617e-18,  4.593501608480153e-20, -9.811708063580052e-22,
  1.296590247767163e-01, -1.155234951755277e-03,  7.451293633641202e-06, -3.350081858124305e-08,  5.266477409216048e-10,  2.807699344011528e-12, -1.702580957106921e-13,
 -6.289542660019073e-15,  5.849243306470954e-18,  4.564549590973949e-18,  7.886462398708629e-20, -1.676159056629047e-21,  1.954918344116591e-01, -1.736008651393110e-03,
  1.097666578326662e-05, -4.578368943541838e-08,  7.594284651997625e-10,  4.871700402839273e-12, -2.692365414765479e-13, -9.798424324309794e-15,  8.794581858771804e-18,
  7.137327566120325e-18,  1.238026521274191e-19, -2.614262554639241e-21,  2.762078555688479e-01, -2.441997947198675e-03,  1.502700942054278e-05, -5.586035218287856e-08,
  1.009411205358845e-09,  8.037299221302504e-12, -4.031741060079889e-13, -1.444716541773310e-14,  1.248805020949164e-17,  1.056507415411271e-17,  1.842006506538709e-19,
 -3.858191847880578e-21,  3.729383925068800e-01, -3.278048648315013e-03,  1.943229385097966e-05, -5.972837071441342e-08,  1.252685007555686e-09,  1.280830082727116e-11,
 -5.833088425729015e-13, -2.061401437830706e-14,  1.723281796266286e-17,  1.513148880095004e-17,  2.655475722603406e-19, -5.507180341800891e-21,  4.872148164855309e-01,
 -4.249273563678988e-03,  2.389629302970921e-05, -5.079574502935805e-08,  1.452644077642143e-09,  1.988673109623921e-11, -8.258200188735321e-13, -2.893808667552173e-14,
  2.376206544567947e-17,  2.130247536545221e-17,  3.769267116144589e-19, -7.725581260274547e-21,  6.211412477341969e-01, -5.359786805431997e-03,  2.787909831046300e-05,
 -1.770133741353133e-08,  1.554429933896523e-09,  3.017526232406630e-11, -1.153519854253871e-12, -4.057640250606738e-14,  3.380200419913558e-17,  2.989715046431523e-17,
  5.342920230090011e-19, -1.080591595587724e-20,  7.776903886093287e-01, -6.609087077947411e-03,  3.033049837099276e-05,  6.037440438776242e-08,  1.484357401256430e-09,
  4.447882804027402e-11, -1.595911546440434e-12, -5.782444406234458e-14,  5.119578147894883e-17,  4.251351791973650e-17,  7.680940717055214e-19, -1.532860768297868e-20,
  9.612453708223401e-01, -7.981009961251170e-03,  2.900563672286611e-05,  2.247397143901895e-07,  1.199536401667856e-09,  6.155150232029386e-11, -2.178093176011867e-12,
 -8.576879832819305e-14,  8.209024100953132e-17,  6.282142879723172e-17,  1.143791685753551e-18, -2.266320953999397e-20,  1.178676927346085e+00, -9.404709735826723e-03,
  1.837681027271307e-05,  5.652248555171182e-07,  1.130904722982392e-09,  6.625324837677303e-11, -2.867688809556790e-12, -1.366280217024806e-13,  1.049294391518634e-16,
  1.017800181792622e-16,  1.834555261376922e-18, -3.724998715653121e-20,  1.441628234960952e+00, -1.057494088095526e-02, -1.856651492563159e-05,  1.275937220294409e-06,
  6.566063482238756e-09, -5.237522066965818e-11, -4.070396411542786e-12, -2.240330449303760e-13, -3.341839947410725e-16,  2.041826516353288e-16,  3.687971421941731e-18,
 -8.616894487483680e-20,  1.768881836729651e+00, -9.562820491872900e-03, -1.512804336993649e-04,  1.491704988892308e-06,  9.460908561058236e-08,  6.832529867181283e-11,
 -6.631927536374351e-11, -8.814530386248452e-13,  3.924481695607437e-14,  1.216156440741976e-15, -1.391640097825119e-17, -1.157917476895578e-18,  1.517728823221245e-03,
 -1.336278188979037e-05,  8.903331295998291e-08, -3.625535496391840e-10,  6.776770088290829e-12, -4.249523154128774e-14, -3.546961091012151e-15, -3.537208054164764e-17,
  2.252717542524454e-18,  5.760807095819206e-20, -8.635835771427606e-22, -5.407326170883062e-23,  1.368335894027171e-02, -1.204252883166485e-04,  8.002420753329420e-07,
 -3.217908415341821e-09,  6.078717516621036e-11, -3.799431194042967e-13, -3.221764320943774e-14, -3.205301238033432e-16,  2.043817334506497e-17,  5.228844862009455e-19,
 -7.835589557266858e-21, -4.909746755698025e-22,  3.814307845155054e-02, -3.354107277188955e-04,  2.216718071436100e-06, -8.680409258992133e-09,  1.676808064811193e-10,
 -1.041145948979710e-12, -9.117187022602404e-14, -9.028266418274079e-16,  5.770718991199731e-17,  1.477624612198221e-18, -2.212709939827607e-20, -1.388470992852163e-21,
  7.516136959017861e-02, -6.600675355076197e-04,  4.325046263975136e-06, -1.621397599899996e-08,  3.249988907269890e-10, -1.997339350161195e-12, -1.838345784689678e-13,
 -1.807990834017965e-15,  1.159829146957581e-16,  2.973539123501150e-18, -4.448251164938202e-20, -2.797401963962728e-21,  1.251549652959024e-01, -1.097086856926293e-03,
  7.100817823165081e-06, -2.490461421416124e-08,  5.284926344172700e-10, -3.201922171860042e-12, -3.158871364107185e-13, -3.079575951679835e-15,  1.985034928727861e-16,
  5.097440506322411e-18, -7.615637666638150e-20, -4.803649449530251e-21,  1.887202448597892e-01, -1.650181703014213e-03,  1.050199841468392e-05, -3.329383724412827e-08,
  7.712951404296742e-10, -4.586508559807862e-12, -4.960657269081622e-13, -4.786698267814256e-15,  3.103647639420136e-16,  7.985296847667896e-18, -1.191268035373824e-19,
 -7.542939528176857e-21,  2.666764491531133e-01, -2.324180470477250e-03,  1.445682710549518e-05, -3.908135455764702e-08,  1.042503566803633e-09, -6.057011466458009e-12,
 -7.375286160198106e-13, -7.038396389228966e-15,  4.595075620809849e-16,  1.184747018367003e-17, -1.764881443741680e-19, -1.122782030810742e-20,  3.601330745786525e-01,
 -3.125102947623718e-03,  1.884128252256897e-05, -3.858479870931045e-08,  1.324778328166226e-09, -7.494689809412878e-12, -1.060206486684297e-12, -1.001115205627881e-14,
  6.585648288398120e-16,  1.701516344804670e-17, -2.531993260278069e-19, -1.619823184806381e-20,  4.705967896775661e-01, -4.060124391775311e-03,  2.343510742646072e-05,
 -2.571245346674976e-08,  1.590308609804154e-09, -8.780418062626985e-12, -1.494948696185361e-12, -1.400497017713052e-14,  9.285254218958331e-16,  2.403080881159935e-17,
 -3.576129428140808e-19, -2.302206280537028e-20,  6.001474635740702e-01, -5.137146645245961e-03,  2.782993082404336e-05,  1.012324639580104e-08,  1.794351391302105e-09,
 -9.910795684651281e-12, -2.091102159434466e-12, -1.956742503838093e-14,  1.306631110661903e-15,  3.383925258765592e-17, -5.049348109473382e-19, -3.271293961755887e-20,
  7.517445555869946e-01, -6.363089938194340e-03,  3.121865139655376e-05,  8.863235422652374e-08,  1.867355596166781e-09, -1.148659832472870e-11, -2.930838603871192e-12,
 -2.779624992029091e-14,  1.865367482562342e-15,  4.824271844760324e-17, -7.262489155862173e-19, -4.726067315587037e-20,  9.298030573108204e-01, -7.737779912757086e-03,
  3.184693805175661e-05,  2.501584713064660e-07,  1.724638214872428e-09, -1.690704793168057e-11, -4.156490425456452e-12, -4.114997779798000e-14,  2.765048372250922e-15,
  7.118655103254661e-17, -1.097338132234394e-18, -7.115672976532430e-20,  1.141395603241331e+00, -9.230186710830101e-03,  2.529625495576538e-05,  5.889339930021001e-07,
  1.475671860877623e-09, -4.431931893590156e-11, -6.021800043832726e-12, -6.546602997257692e-14,  4.426741405805562e-15,  1.134898822302097e-16, -1.862370122390703e-18,
 -1.170747928580340e-19,  1.399130738762857e+00, -1.066056648845870e-02, -2.682360645623801e-06,  1.365246934223126e-06,  4.059049766150795e-09, -2.189902558972652e-10,
 -9.246060348245434e-12, -9.971973169804510e-14,  8.208593822477427e-15,  2.170741174684433e-16, -4.234946723476609e-18, -2.402001457319098e-19,  1.728359159903701e+00,
 -1.067621611412117e-02, -1.245483043491634e-04,  2.924524569264673e-06,  7.894298474229549e-08, -1.643435827643016e-09, -6.817245004386806e-11,  8.701833023005636e-13,
  6.129929004813396e-14, -2.612596651324902e-16, -5.303087922693635e-17, -2.169077226139304e-19,  1.465677152623997e-03, -1.266617031862962e-05,  8.528969089885688e-08,
 -2.657185914510974e-10,  5.044368456847236e-12, -1.297962557115295e-13, -3.290056522965508e-15,  5.878271773251471e-17,  3.171744241368976e-18, -1.857657633055170e-20,
 -2.607543521501393e-21, -8.174138192545634e-24,  1.321423932497002e-02, -1.141621367306780e-04,  7.670711842984370e-07, -2.349644799638728e-09,  4.517368317955138e-11,
 -1.172752937033981e-12, -2.987495386111871e-14,  5.337949907821603e-16,  2.877948753010345e-17, -1.686924267292623e-19, -2.367363555857653e-20, -7.425307120768466e-23,
  3.683630461708368e-02, -3.180504140465009e-04,  2.127565013399012e-06, -6.287282153596638e-09,  1.241844214030088e-10, -3.283801128072186e-12, -8.449051123781276e-14,
  1.509855264377560e-15,  8.127670410483729e-17, -4.772029861661622e-19, -6.693504377333747e-20, -2.101581071141639e-22,  7.258918669805633e-02, -6.261616808521040e-04,
  4.159557251499537e-06, -1.158185543403074e-08,  2.393549033724722e-10, -6.516658156554521e-12, -1.702064627550334e-13,  3.042581218811549e-15,  1.634037924218634e-16,
 -9.620070067408850e-19, -1.348125687719407e-19, -4.238294257765992e-22,  1.208785312488221e-01, -1.041339615356464e-03,  6.849205321680835e-06, -1.738747506142119e-08,
  3.859769742193997e-10, -1.096163970578108e-11, -2.921141580203428e-13,  5.225209352833018e-15,  2.797621763646822e-16, -1.653741714406024e-18, -2.313892706257845e-19,
 -7.283699982212391e-22,  1.822853012166801e-01, -1.567565335517953e-03,  1.017132485191596e-05, -2.235625116386327e-08,  5.564095256529126e-10, -1.676113351661665e-11,
 -4.580414203847850e-13,  8.203439207650629e-15,  4.375616792641312e-16, -2.601793231638211e-18, -3.631035964031389e-19, -1.143701799590567e-21,  2.576084463912025e-01,
 -2.210133848378391e-03,  1.408071681882181e-05, -2.436488692045450e-08,  7.383997082181166e-10, -2.413907751128661e-11, -6.797777367582446e-13,  1.220193547332490e-14,
  6.479654413074131e-16, -3.885680626368108e-18, -5.400082723591331e-19, -1.699143337790635e-21,  3.479316729010551e-01, -2.975885068896488e-03,  1.849587549818742e-05,
 -2.001617559584102e-08,  9.120746720992135e-10, -3.345975028366682e-11, -9.751820629744619e-13,  1.757271015041040e-14,  9.285697940578925e-16, -5.637478171834678e-18,
 -7.781199633611809e-19, -2.437068677146812e-21,  4.547298763330010e-01, -3.873471562683359e-03,  2.326691864617122e-05, -3.685833142269755e-09,  1.044378409040922e-09,
 -4.535477074902591e-11, -1.371901586231128e-12,  2.488827248524003e-14,  1.308232623737465e-15, -8.089217682323478e-18, -1.104067854140651e-18, -3.416916448586044e-21,
  5.800455714415182e-01, -4.913566534681920e-03,  2.810801687735459e-05,  3.443156729082543e-08,  1.078357941233147e-09, -6.102927228638954e-11, -1.914146503611971e-12,
  3.513592977093466e-14,  1.837243686891121e-15, -1.168346011714366e-17, -1.565103446001563e-18, -4.713839630360650e-21,  7.267990921414913e-01, -6.108621500684008e-03,
  3.244115324475719e-05,  1.127249013729648e-07,  9.118001412101509e-10, -8.311565585968990e-11, -2.675268791754678e-12,  5.017255575341748e-14,  2.611122190170140e-15,
 -1.736748455246260e-17, -2.253317190874325e-18, -6.379670930439346e-21,  8.993810833403657e-01, -7.470589733975179e-03,  3.498510987188746e-05,  2.694417906031413e-07,
  3.557484823847104e-10, -1.185744285617511e-10, -3.779579250724456e-12,  7.399448539298397e-14,  3.834555439396233e-15, -2.753051916624377e-17, -3.374626601457044e-18,
 -8.172678608889415e-21,  1.104924766829339e+00, -8.999266616233377e-03,  3.244952252920362e-05,  5.973073265903966e-07, -9.083377867332680e-10, -1.918144310853234e-10,
 -5.416404427641631e-12,  1.175935646826148e-13,  6.025572901744329e-15, -4.989595446992996e-17, -5.499150579174190e-18, -7.592894975431188e-21,  1.356550332106514e+00,
 -1.061580292604753e-02,  1.390554524003666e-05,  1.382758188297783e-06, -2.587774205545536e-09, -4.391558708681305e-10, -7.531840131717242e-12,  2.362434944325278e-13,
  1.071934958761052e-14, -1.238795656415058e-16, -1.087017701520688e-17,  2.146067980346420e-20,  1.683910148029971e+00, -1.151377195825938e-02, -8.321640738348568e-05,
  3.847783742488549e-06,  3.274238728365253e-08, -2.788621743722238e-09, -2.059881410145318e-11,  2.291334572953609e-12,  1.720037184996251e-14, -1.942950171048318e-15,
 -1.675625956095012e-17,  1.660982606688324e-18,  1.416358557932972e-03, -1.199545681195898e-05,  8.248775880508695e-08, -2.093152868894279e-10,  1.846214891736553e-12,
 -1.788610973572761e-13, -4.629204650894722e-16,  1.304567775717483e-16,  7.989925927571656e-19, -1.017009142744539e-19, -8.970942848076040e-22,  7.779990571119473e-23,
  1.276970006095575e-02, -1.081280662616937e-04,  7.423300184490636e-07, -1.846644641205857e-09,  1.624982877760753e-11, -1.618347243886842e-12, -4.212073706153171e-15,
  1.183973072310943e-15,  7.237007941538487e-18, -9.232658298317234e-19, -8.136326473871694e-21,  7.066819315533383e-22,  3.559770648316628e-02, -3.013035209236981e-04,
  2.061566331492629e-06, -4.916636703571079e-09,  4.304020052846667e-11, -4.544350451283748e-12, -1.195788010021776e-14,  3.345036782317264e-15,  2.036381500586308e-17,
 -2.610067984341483e-18, -2.295589437505463e-20,  2.000072735306185e-21,  7.015028992987930e-02, -5.933872102347641e-04,  4.038636218750008e-06, -8.977967188703259e-09,
  7.785699757963639e-11, -9.056914061904954e-12, -2.421081670703095e-14,  6.728973176707290e-15,  4.070605517823824e-17, -5.255715747421932e-18, -4.607752405015016e-20,
  4.034586991269138e-21,  1.168215621390393e-01, -9.872944058077822e-04,  6.669317776462553e-06, -1.328000364846894e-08,  1.132529145651540e-10, -1.532270093108987e-11,
 -4.177311592826555e-14,  1.152884540323247e-14,  6.912054468084723e-17, -9.018050939895966e-18, -7.869064733741296e-20,  6.940127030350562e-21,  1.761762577832371e-01,
 -1.487145354326458e-03,  9.943745562327053e-06, -1.662828562566063e-08,  1.373122597348824e-10, -2.360031883910673e-11, -6.577213716020693e-14,  1.804577342284715e-14,
  1.068866307364273e-16, -1.414586948172812e-17, -1.226053407608673e-19,  1.092306094861660e-20,  2.489915795466024e-01, -2.098498496445846e-03,  1.384083370739433e-05,
 -1.714396114242535e-08,  1.311709604678019e-10, -3.428614944181410e-11, -9.766851684976964e-14,  2.674291948896507e-14,  1.558505343654911e-16, -2.102741165969498e-17,
 -1.805043495757620e-19,  1.630876118646871e-20,  3.363228194677492e-01, -2.828688816454979e-03,  1.831763101767168e-05, -1.182496477154010e-08,  6.447723966571610e-11,
 -4.799987163721549e-11, -1.391420064475008e-13,  3.834364062800746e-14,  2.186374625229620e-16, -3.028073945494438e-17, -2.563487718149641e-19,  2.362202814072677e-20,
  4.396082779877727e-01, -3.687308123681022e-03,  2.328805868344560e-05,  4.294138506312739e-09, -1.133137398923231e-10, -6.575475579894089e-11, -1.915356797275523e-13,
  5.401919182425015e-14,  2.989252817204904e-16, -4.293210600975540e-17, -3.560116295608338e-19,  3.374862585298092e-20,  5.608439242983090e-01, -4.686863236311699e-03,
  2.857753571690097e-05,  3.986941378748819e-08, -4.907976152850415e-10, -8.933066404253665e-11, -2.537439818796051e-13,  7.577546834340097e-14,  4.016240141586768e-16,
 -6.079834725516655e-17, -4.881587774608438e-19,  4.828917162495651e-20,  7.028923903610306e-01, -5.843579453487549e-03,  3.381691388519167e-05,  1.111607378433763e-07,
 -1.234666378192543e-09, -1.222068665545129e-10, -3.142067890694921e-13,  1.073355579650572e-13,  5.319639016521425e-16, -8.740413905160472e-17, -6.647887235475853e-19,
  7.043177544971646e-20,  8.700788277772636e-01, -7.177886697202701e-03,  3.816082062444065e-05,  2.521664548986598e-07, -2.690566201488917e-09, -1.723771950822094e-10,
 -3.169818827662239e-13,  1.564624911426676e-13,  6.872690545562856e-16, -1.305492499402805e-16, -8.963150557678463e-19,  1.074878251310283e-19,  1.069491505613115e+00,
 -8.711577166589055e-03,  3.938446027468950e-05,  5.464963162433099e-07, -5.677663501453012e-09, -2.636281930901400e-10,  1.880211133519353e-14,  2.425498175796339e-13,
  7.922578246756153e-16, -2.112661772213812e-16, -1.137247427255401e-18,  1.802639165683308e-19,  1.314412761265148e+00, -1.043960764441066e-02,  2.993621162764476e-05,
  1.264132901082426e-06, -1.247022475685646e-08, -5.087019339761535e-10,  2.668137191314124e-12,  4.341041704662919e-13, -9.829526233885244e-17, -4.070954501309954e-16,
 -5.981271354865940e-19,  3.733108502780862e-19,  1.636822928116439e+00, -1.199020698016952e-02, -3.576678041562632e-05,  3.920709898115598e-06, -2.273492727715775e-08,
 -2.516517658222584e-09,  4.067820048703946e-11,  1.739575418098948e-12, -4.698982488304005e-14, -1.179690587111225e-15,  4.798709399624310e-17,  7.521314329224309e-19,
  1.369680980021902e-03, -1.134536927279746e-05,  8.003662999358313e-08, -2.077477315727089e-10, -1.546000822906016e-12, -1.467060332323714e-13,  2.988556715702845e-15,
  9.750890095125329e-17, -2.651709806394619e-18, -6.789453911106169e-20,  2.340953786004988e-21,  4.523791546353283e-23,  1.234892775189723e-02, -1.022760842047033e-04,
  7.206754168762561e-07, -1.839736177205187e-09, -1.444096122741414e-11, -1.326837984333368e-12,  2.710484125776119e-14,  8.844266630097070e-16, -2.408044106420121e-17,
 -6.158228131415642e-19,  2.126584664513355e-20,  4.103952189797228e-22,  3.442511128387973e-02, -2.850421310964161e-04,  2.003736483573219e-06, -4.938652019952435e-09,
 -4.312678142837431e-11, -3.722479760628110e-12,  7.647838233719887e-14,  2.495693498823182e-15, -6.811865733006753e-17, -1.737781510749518e-18,  6.019991799725681e-20,
  1.158501585041345e-21,  6.784068882286033e-02, -5.615015366046282e-04,  3.932471459409667e-06, -9.148517229395701e-09, -9.382917033308304e-11, -7.408416556976156e-12,
  1.535569033832159e-13,  5.010792856245517e-15, -1.372998626093606e-16, -3.489263787843574e-18,  1.214759692338760e-19,  2.327341400602169e-21,  1.129780973267370e-01,
 -9.345695938918890e-04,  6.510842709756446e-06, -1.386374290659349e-08, -1.770899011412896e-10, -1.250789003677652e-11,  2.624749273752424e-13,  8.561605164321388e-15,
 -2.359033796325006e-16, -5.962529867887977e-18,  2.090522262662936e-19,  3.979597482885985e-21,  1.703855183246959e-01, -1.408391768584653e-03,  9.742006766972771e-06,
 -1.812052439130255e-08, -3.095960163754340e-10, -1.920908432192798e-11,  4.097693999313748e-13,  1.335111939286903e-14, -3.706903707045810e-16, -9.299986149438524e-18,
  3.292229226507238e-19,  6.211648594593592e-21,  2.408177181299457e-01, -1.988610727499777e-03,  1.362535722523830e-05, -2.040279819963933e-08, -5.174600224102260e-10,
 -2.779408018910492e-11,  6.056928918954198e-13,  1.968582547680111e-14, -5.522428980996623e-16, -1.371742888489127e-17,  4.919229534011694e-19,  9.168567194663904e-21,
  3.253001769084012e-01, -2.682770143204367e-03,  1.815065646975249e-05, -1.828867416066852e-08, -8.422283154680554e-10, -3.869083805873550e-11,  8.666997669834199e-13,
  2.803233372298673e-14, -7.974675329189480e-16, -1.954483014974277e-17,  7.131947692157433e-19,  1.306963694855231e-20,  4.252318065886816e-01, -3.500927359563631e-03,
  2.328591426039344e-05, -7.774357512662925e-09, -1.352452910038468e-09, -5.257185977976661e-11,  1.220459966429749e-12,  3.911984457818822e-14, -1.134555634561758e-15,
 -2.730040035364051e-17,  1.020140841743621e-18,  1.825233395420405e-20,  5.425563761930474e-01, -4.456597052162801e-03,  2.895079843184558e-05,  1.811399581076769e-08,
 -2.167674281909407e-09, -7.055812595655039e-11,  1.716935007246230e-12,  5.413501101558412e-14, -1.613671681536866e-15, -3.783153691591455e-17,  1.461755320234131e-18,
  2.524830071020734e-20,  6.800668752168673e-01, -5.568227590513839e-03,  3.495312377677646e-05,  7.246188586485446e-08, -3.513341395520843e-09, -9.469538230490702e-11,
  2.456111639803373e-12,  7.511386643513155e-14, -2.332792864811657e-15, -5.259597199130916e-17,  2.135529844686322e-18,  3.490492668257485e-20,  8.419956457692078e-01,
 -6.861485294131328e-03,  4.081747063596098e-05,  1.826017545309319e-07, -5.865056485368421e-09, -1.292832393280539e-10,  3.670842944396493e-12,  1.057607115747019e-13,
 -3.511120980277999e-15, -7.422294334712296e-17,  3.264136420446306e-18,  4.847682668108705e-20,  1.035314187558608e+00, -8.372203181730356e-03,  4.522968168229339e-05,
  4.157683297148458e-07, -1.041051671917185e-08, -1.857684116546586e-10,  6.049651417174255e-12,  1.529302620642508e-13, -5.755179640627698e-15, -1.072047982000868e-16,
  5.474060795848967e-18,  6.651351528198820e-20,  1.273223628939336e+00, -1.014356219471443e-02,  4.359509833086552e-05,  9.906536752849958e-07, -2.107675497964100e-08,
 -3.120954469578807e-10,  1.272230311163579e-11,  2.223292898237481e-13, -1.154102423053831e-14, -1.474734634761723e-16,  1.124647949601461e-17,  6.798632034775248e-20,
  1.588574550387668e+00, -1.209774305114333e-02,  7.647180181065424e-06,  3.220491685758369e-06, -6.035056942050939e-08, -1.150788966410865e-09,  6.477086176643565e-11,
 -4.804459339696421e-14, -5.290973479129372e-14,  7.571265269908872e-16,  3.494617820402355e-17, -1.091256464378966e-18,  1.325563449106127e-03, -1.071566248178795e-05,
  7.731311067366573e-08, -2.513258918961335e-10, -3.598289187789106e-12, -5.335531626887268e-14,  4.305953085944626e-15, -6.288860109629505e-18, -3.204828044075454e-18,
  3.557566985158590e-20,  2.131505034438582e-21, -4.778659432715614e-23,  1.195120652930213e-02, -9.660466859105817e-05,  6.964698160842437e-07, -2.241087533281099e-09,
 -3.298030309919353e-11, -4.802710178884114e-13,  3.904265466029600e-14, -5.773651171725601e-17, -2.907737566906269e-17,  3.235992932302808e-19,  1.933825384710082e-20,
 -4.344515949677287e-22,  3.331660412134656e-02, -2.692659373283013e-04,  1.938251686936812e-06, -6.105785245278547e-09, -9.501364479559971e-11, -1.334336581042168e-12,
  1.100991928715292e-13, -1.669746904244044e-16, -8.210336283141451e-17,  9.184821913829389e-19,  5.459851098374357e-20, -1.231850821132958e-21,  6.565685793519528e-02,
 -5.305161786736324e-04,  3.809547034545094e-06, -1.159725118421421e-08, -1.967046793995650e-10, -2.615202222110306e-12,  2.208516370981426e-13, -3.481401003403690e-16,
 -1.650130950398901e-16,  1.860989564757408e-18,  1.097151649050973e-19, -2.491956069902970e-21,  1.093428489339400e-01, -8.832129332606783e-04,  6.320512103049998e-06,
 -1.829194286794962e-08, -3.498573779410142e-10, -4.319944132148471e-12,  3.769443890750968e-13, -6.266133089028754e-16, -2.823666912489884e-16,  3.220970560896707e-18,
  1.876931554010185e-19, -4.303476765977256e-21,  1.649062938321398e-01, -1.331434913715702e-03,  9.484174660492379e-06, -2.551318359355499e-08, -5.730329541885680e-10,
 -6.438990580491338e-12,  5.871682862795535e-13, -1.045888514161996e-15, -4.412518739272328e-16,  5.111008822398784e-18,  2.931874765700160e-19, -6.808627208428714e-21,
  2.330794833250535e-01, -1.880764300102299e-03,  1.331547756757378e-05, -3.219230772282229e-08, -8.950474558719393e-10, -8.947917896427290e-12,  8.650292561772779e-13,
 -1.681092569673200e-15, -6.525170357039920e-16,  7.711882112696727e-18,  4.332863403493101e-19, -1.023417205945934e-20,  3.148577265354606e-01, -2.538722209658159e-03,
  1.782905376176920e-05, -3.661593731140216e-08, -1.361344753873168e-09, -1.179045234112242e-11,  1.231616298035666e-12, -2.666685829417950e-15, -9.329891696936308e-16,
  1.132162092522525e-17,  6.188970882341802e-19, -1.495069634486645e-20,  4.115994711172398e-01, -3.315449133468684e-03,  2.303406479872986e-05, -3.594366483076058e-08,
 -2.046203882487099e-09, -1.484138373305916e-11,  1.721136539227531e-12, -4.257262550122798e-15, -1.309651462168008e-15,  1.645617284308807e-17,  8.672924801260395e-19,
 -2.159281887343839e-20,  5.251936245226485e-01, -4.224801413555730e-03,  2.892188244601606e-05, -2.522069153954027e-08, -3.077909137443780e-09, -1.781955029440829e-11,
  2.392488178317252e-12, -6.974196438569900e-15, -1.828061565752913e-15,  2.407514699600549e-17,  1.207041477891884e-18, -3.132480247832047e-20,  6.583572127836382e-01,
 -5.286200312640534e-03,  3.543481335329774e-05,  4.847019548073939e-09, -4.696146993100329e-09, -2.006240239199639e-11,  3.356293302662410e-12, -1.200711911603554e-14,
 -2.570903090239631e-15,  3.615274617134212e-17,  1.688143990580618e-18, -4.649894291748552e-20,  8.152141946617335e-01, -6.527937361661830e-03,  4.237797597977542e-05,
  7.361846465612300e-08, -7.402470422432995e-09, -1.985562957748588e-11,  4.848720611637594e-12, -2.252500546887165e-14, -3.703882657987446e-15,  5.738406307876389e-17,
  2.403732144491089e-18, -7.256481086905948e-20,  1.002576349648117e+00, -7.993466028331002e-03,  4.912544677034523e-05,  2.284171083241604e-07, -1.244408036236926e-08,
 -1.199562156970275e-11,  7.486617425996899e-12, -4.924982209650327e-14, -5.606710363286836e-15,  1.017190290315037e-16,  3.529543704218646e-18, -1.249948078190397e-19,
  1.233413617309783e+00, -9.753342176339951e-03,  5.331123043984875e-05,  6.214137055110544e-07, -2.398625685682374e-08,  2.439494699670859e-11,  1.359006803055792e-11,
 -1.476509982384825e-13, -9.280505079595953e-15,  2.304270708847064e-16,  5.155377311413690e-18, -2.643442466096754e-19,  1.540525883048815e+00, -1.189961271703902e-02,
  4.000481962449954e-05,  2.151715880616717e-06, -6.878498995403375e-08,  2.286188924102563e-10,  4.516698690652512e-11, -1.134765219239482e-12, -1.270673996135913e-14,
  1.157502102620486e-15, -1.188162559713377e-17, -7.162461598508253e-19,  1.283917264177144e-03, -1.011024567001888e-05,  7.393411559612039e-08, -3.120687368590883e-10,
 -3.699324608431257e-12,  3.794271108411766e-14,  2.976833377886596e-15, -7.663561367150494e-17, -9.814465568799871e-19,  7.107772545836479e-20, -3.431611707183878e-22,
 -4.719756304638248e-23,  1.157574782735681e-02, -9.114986194334563e-05,  6.662529295100728e-07, -2.796963339888636e-09, -3.382805100304687e-11,  3.472675568011512e-13,
  2.696859052028399e-14, -6.955915979359106e-16, -8.883439684535084e-18,  6.450959798764982e-19, -3.136258161626039e-21, -4.281956105880170e-22,  3.227005034167817e-02,
 -2.540799685025391e-04,  1.855429258431617e-06, -7.702342887022675e-09, -9.701453972057438e-11,  9.977201281243930e-13,  7.591928764129343e-14, -1.965713966407721e-15,
 -2.496058576555599e-17,  1.822707426845291e-18, -8.987392235497521e-21, -1.208890739136369e-21,  6.359478609561166e-02, -5.006521346951115e-04,  3.650670558789238e-06,
 -1.488797391123721e-08, -1.995238070829180e-10,  2.057787118343938e-12,  1.518777256355421e-13, -3.955986304710472e-15, -4.977993360195941e-17,  3.667085233686663e-18,
 -1.847772441007307e-20, -2.429063865087294e-21,  1.059095961094691e-01, -8.336254818594767e-04,  6.066106878952236e-06, -2.411185134717483e-08, -3.518772470671767e-10,
  3.643790139028024e-12,  2.582303587480525e-13, -6.782561226504806e-15, -8.424518134762649e-17,  6.284112766883989e-18, -3.262479348503474e-20, -4.154922223916530e-21,
  1.597301351000106e-01, -1.256946983351086e-03,  9.121145564645579e-06, -3.498210032787202e-08, -5.705464085264953e-10,  5.940743305121523e-12,  4.001643044583331e-13,
 -1.062812990112734e-14, -1.296627379167616e-16,  9.839189491483910e-18, -5.311645050986765e-20, -6.488792246231355e-21,  2.257666744669458e-01, -1.776035672917866e-03,
  1.284085683834125e-05, -4.687092125278547e-08, -8.809595720557763e-10,  9.240198792966272e-12,  5.854700532224897e-13, -1.577691999964702e-14, -1.878272981238007e-16,
  1.458715200089057e-17, -8.275831929742457e-20, -9.585948554127647e-21,  3.049847860827751e-01, -2.398225468974591e-03,  1.725619197333485e-05, -5.875775906308421e-08,
 -1.322942831812865e-09,  1.401063490028155e-11,  8.259520089970159e-13, -2.267955489418581e-14, -2.611005849356857e-16,  2.092661131401155e-17, -1.263608951124377e-19,
 -1.368409616333521e-20,  3.987026901635961e-01, -3.133466972661146e-03,  2.240348346275472e-05, -6.892995473560829e-08, -1.961057322900846e-09,  2.103564274906662e-11,
  1.140014638271542e-12, -3.208014373377130e-14, -3.523720939206696e-16,  2.950352955489889e-17, -1.926155830374619e-19, -1.915672806524772e-20,  5.087540591949049e-01,
 -3.995481723573403e-03,  2.832166003301282e-05, -7.437093033586715e-08, -2.905706409476804e-09,  3.170728984388583e-11,  1.557721227377306e-12, -4.528636760041257e-14,
 -4.644688951440543e-16,  4.142308823021786e-17, -2.984331024760387e-19, -2.661404341521695e-20,  6.377779277888908e-01, -5.003769742761187e-03,  3.504240956593051e-05,
 -6.938714120463883e-08, -4.360706863146228e-09,  4.871879724116827e-11,  2.131607692350160e-12, -6.481089910872760e-14, -5.972483962130621e-16,  5.872579088143182e-17,
 -4.802505278372119e-19, -3.710207791055059e-20,  7.897832548959162e-01, -6.187384383594455e-03,  4.255703473151829e-05, -4.210097204194372e-08, -6.746209293261763e-09,
  7.795909431738892e-11,  2.962779672369768e-12, -9.614989608741998e-14, -7.341344712216288e-16,  8.559834702494232e-17, -8.287620077899165e-19, -5.249325113747565e-20,
  9.714011253163594e-01, -7.592841664833613e-03,  5.069347729717646e-05,  3.637216778971824e-08, -1.108666731277650e-08,  1.349421112077632e-10,  4.275789907717368e-12,
 -1.539901592941549e-13, -7.692024556248887e-16,  1.319940515977357e-16, -1.624572061612104e-18, -7.596915139474410e-20,  1.195291427938350e+00, -9.303405580421909e-03,
  5.853395928092062e-05,  2.573565470555040e-07, -2.070913650836326e-08,  2.759200217296155e-10,  6.699978339801627e-12, -2.941154211047237e-13,  7.332471181149459e-17,
  2.264186240786660e-16, -4.123145717248839e-18, -1.062696145626486e-19,  1.493705498906698e+00, -1.149432656296143e-02,  5.953321007472419e-05,  1.135454417434610e-06,
 -5.603606126267146e-08,  9.194577133839082e-10,  1.305054579997122e-11, -1.008553227101291e-12,  1.574918110817456e-14,  3.686163332222389e-16, -2.064600498880024e-17,
  2.106963526671675e-19,  };
  constexpr double w[5760] = {  2.019323539670034e-01, -1.867249031834874e-03,  1.902125520176500e-05, -2.033893032001173e-07,  2.209472206254764e-09,
 -2.398404028298345e-11,  2.582568085833147e-13, -2.751775069644884e-15,  2.899890755948508e-17, -3.023762405330050e-19,  3.121616446538537e-21, -3.192690820895434e-23,
  1.960668378383492e-01, -3.654605903850788e-03,  7.299831376272402e-05, -1.343208027929166e-06,  2.302405464642503e-08, -3.736442344643607e-10,  5.802449561832829e-12,
 -8.684328687287856e-14,  1.259036934364132e-15, -1.774906045889357e-17,  2.440269138128870e-19, -3.279319041474921e-21,  1.850224804543047e-01, -6.862035127890935e-03,
  2.143223259286033e-04, -5.684914732340789e-06,  1.349814571244656e-07, -2.948223385236059e-09,  6.022519290275826e-11, -1.163527899144599e-12,  2.143040484430004e-14,
 -3.785619034341501e-16,  6.443237848289260e-18, -1.060271951752526e-19,  1.700043356646938e-01, -1.086094045143676e-02,  4.874324106737936e-04, -1.762927067699007e-05,
  5.513421134720077e-07, -1.546026347139555e-08,  3.974101550159627e-10, -9.504337557011508e-12,  2.137192219990150e-13, -4.554192460957119e-15,  9.252299651310119e-17,
 -1.800067867030590e-18,  1.524627505709155e-01, -1.492965133537660e-02,  9.163367870021858e-04, -4.337405008623530e-05,  1.722832888807956e-06, -6.000860987304016e-08,
  1.882714213697755e-09, -5.416598968956192e-11,  1.447313550532891e-12, -3.625764231748900e-14,  8.578280293190073e-16, -1.926976653828917e-17,  1.338097563503383e-01,
 -1.842033508613512e-02,  1.481395948060974e-03, -8.864681296728261e-05,  4.341194781252697e-06, -1.829092002441232e-07,  6.836057097276422e-09, -2.313088260991198e-10,
  7.189721367061962e-12, -2.075254675900159e-13,  5.609180776617473e-15, -1.428339966915019e-16,  1.152059196039703e-01, -2.087254892832670e-02,  2.115580989114916e-03,
 -1.552008710654719e-04,  9.129362840838935e-06, -4.546532837561130e-07,  1.982081136621988e-08, -7.735976985646219e-10,  2.746821742938460e-11, -8.979980093324607e-13,
  2.728203099400280e-14, -7.754231777622346e-16,  9.745589287349474e-02, -2.205280356509647e-02,  2.719952657309729e-03, -2.378667237324817e-04,  1.641020311791089e-05,
 -9.457934544930916e-07,  4.718466407805016e-08, -2.087158993251286e-09,  8.328150900890297e-11, -3.036675534969031e-12,  1.022030047530874e-13, -3.197908773057209e-15,
  8.100535950384746e-02, -2.193090238579171e-02,  3.189244749595699e-03, -3.239909626415896e-04,  2.563675271030821e-05, -1.676425078966961e-06,  9.400566350653666e-08,
 -4.635556678244858e-09,  2.046995886321465e-10, -8.206238469653931e-12,  3.018648442226623e-13, -1.026629563899821e-14,  6.600410853212975e-02, -2.062097597137676e-02,
  3.436345177720562e-03, -3.958733347347407e-04,  3.517861456327753e-05, -2.561159625074624e-06,  1.586754672843892e-07, -8.585874413582585e-09,  4.134752218824007e-10,
 -1.797636721787112e-11,  7.134862726383476e-13, -2.605673697061040e-14,  5.239465061850912e-02, -1.831571167202332e-02,  3.408127531133457e-03, -4.353003868718839e-04,
  4.257675263442050e-05, -3.388967396668331e-06,  2.281473510058833e-07, -1.333971932471968e-08,  6.906621336777425e-10, -3.213353892510771e-11,  1.359047075679569e-12,
 -5.267506880465105e-14,  3.999595688445669e-02, -1.523268733207852e-02,  3.090678013645546e-03, -4.284406124092319e-04,  4.524313935389858e-05, -3.868294013327877e-06,
  2.784086142669439e-07, -1.732729572751962e-08,  9.510818473492589e-10, -4.673762544606300e-11,  2.080697431386615e-12, -8.460959266953203e-14,  2.856693642105171e-02,
 -1.158019043162333e-02,  2.506171444093561e-03, -3.694955826275698e-04,  4.134745577118165e-05, -3.732545671569015e-06,  2.826488820826991e-07, -1.844849595921632e-08,
  1.058763297534654e-09, -5.424720580403091e-11,  2.511395535320086e-12, -1.059321496618018e-13,  1.784698662082709e-02, -7.541802299157870e-03,  1.705290512987886e-03,
 -2.622422700324912e-04,  3.053760699956222e-05, -2.861781550218849e-06,  2.244453122545536e-07, -1.513902809206882e-08,  8.960073107272358e-10, -4.725272419509279e-11,
  2.247598903772277e-12, -9.723604726138166e-14,  7.587665316549379e-03, -3.279505811743833e-03,  7.595857215575279e-04, -1.195575810643577e-04,  1.423220388572534e-05,
 -1.361672323118527e-06,  1.088915748689011e-07, -7.480044898704031e-09,  4.503451651353040e-10, -2.413374544897203e-11,  1.165323929991533e-12, -5.112850744176441e-14,
  1.947530433153188e-01, -1.724275090944650e-03,  1.677788700261293e-05, -1.715628586735550e-07,  1.786034190618391e-09, -1.861487322624282e-11,  1.927193013274446e-13,
 -1.976376869070447e-15,  2.005994243908151e-17, -2.015768859091093e-19,  2.006337663434069e-21, -1.979219562779814e-23,  1.825224531733981e-01, -3.129353413395741e-03,
  5.886595396935723e-05, -1.027791628129211e-06,  1.676804536293721e-08, -2.595415349204464e-10,  3.850787323882715e-12, -5.514326175536078e-14,  7.658677190424713e-16,
 -1.035437525892935e-17,  1.366601212226529e-19, -1.764537321484764e-21,  1.606179500884767e-01, -5.387638385015488e-03,  1.573429034762688e-04, -3.928221555676553e-06,
  8.818502814068890e-08, -1.827288069374471e-09,  3.550649448602102e-11, -6.539371441075397e-13,  1.150327428748358e-14, -1.943827725205877e-16,  3.169378251667571e-18,
 -5.002679447929680e-20,  1.332041544204751e-01, -7.678252638339573e-03,  3.200673554206903e-04, -1.084151037850196e-05,  3.193925900091918e-07, -8.472392876894237e-09,
  2.067050384297734e-10, -4.704754040075597e-12,  1.009167505962122e-13, -2.055450088880174e-15,  3.998466598101354e-17, -7.460827951380271e-19,  1.046677870499864e-01,
 -9.289788670473989e-03,  5.283751756978004e-04, -2.338995458154750e-05,  8.743395666573150e-07, -2.879451180652282e-08,  8.573191469687294e-10, -2.347863181302901e-11,
  5.987248153664882e-13, -1.434724480141676e-14,  3.253480138814227e-16, -7.017853132197682e-18,  7.845563517326808e-02, -9.872815836647229e-03,  7.374872233737682e-04,
 -4.134858135369432e-05,  1.908917753443962e-06, -7.617876098363114e-08,  2.706892955492067e-09, -8.735793943990795e-11,  2.596869593846887e-12, -7.185775399465413e-14,
  1.865896660190279e-15, -4.573538353992234e-17,  5.653855857681196e-02, -9.467946998480574e-03,  8.967131204983254e-04, -6.192678714993016e-05,  3.448248054337301e-06,
 -1.632772490479994e-07,  6.792544437365235e-09, -2.537646687299270e-10,  8.647928396310726e-12, -2.719852513792456e-13,  7.966145548249795e-15, -2.187027972116835e-16,
  3.949723782275068e-02, -8.365484475933894e-03,  9.724156294324682e-04, -8.061581478923784e-05,  5.297073317795199e-06, -2.919004445060025e-07,  1.396932664616641e-08,
 -5.944150545415300e-10,  2.287252714781697e-11, -8.060208326691782e-13,  2.626920689201213e-14, -7.973995571658208e-16,  2.695999130618752e-02, -6.922119700337299e-03,
  9.583429551648840e-04, -9.308392308987387e-05,  7.068525802010925e-06, -4.449992714817198e-07,  2.409003709723204e-08, -1.149592352628462e-09,  4.923201924451493e-11,
 -1.917764977309349e-12,  6.866485315183771e-14, -2.276702262275644e-15,  1.809454827061338e-02, -5.430473873621691e-03,  8.708039620431851e-04, -9.681493489551951e-05,
  8.325752826587977e-06, -5.880407372067182e-07,  3.542035527062600e-08, -1.866991979036529e-09,  8.773578046425253e-11, -3.728023273503049e-12,  1.448199389975577e-13,
 -5.183315500440306e-15,  1.197529240569131e-02, -4.068922602259418e-03,  7.362036605930794e-04, -9.159937481806266e-05,  8.744146407008631e-06, -6.804785389270027e-07,
  4.485954269737892e-08, -2.572185847450602e-09,  1.307682532420388e-10, -5.981211968091008e-12,  2.489583315204233e-13, -9.506058044251687e-15,  7.782903363535605e-03,
 -2.910228793628661e-03,  5.795950360430346e-04, -7.894601387295969e-05,  8.201071105800532e-06, -6.905675028319279e-07,  4.899962127324061e-08, -3.009406704008081e-09,
  1.631506952042561e-10, -7.925141000486247e-12,  3.490099382546620e-13, -1.404883693983583e-14,  4.872407250706573e-03, -1.954662934711406e-03,  4.184797753193551e-04,
 -6.106577663834772e-05,  6.767631625685786e-06, -6.054325841457922e-07,  4.546099485175962e-08, -2.943901741964998e-09,  1.677076855647456e-10, -8.533490664590392e-12,
  3.925067264717134e-13, -1.645590371933886e-14,  2.765564961563295e-03, -1.163054376530757e-03,  2.616405533820158e-04, -4.003792440308375e-05,  4.640677110305434e-06,
 -4.329916052014380e-07,  3.381931884800748e-08, -2.272329908525578e-09,  1.339998513563306e-10, -7.042583414587409e-12,  3.339046721332913e-13, -1.440166866118986e-14,
  1.112832102685151e-03, -4.801710912106905e-04,  1.110111731439373e-04, -1.744147371148705e-05,  2.072637743100091e-06, -1.979709175123964e-07,  1.580639774731987e-08,
 -1.084136044553240e-09,  6.517717936472302e-11, -3.487972916095011e-12,  1.681975013649037e-13, -7.370324571624420e-15,  1.881120008480278e-01, -1.597827961123420e-03,
  1.487907176582898e-05, -1.457309762093925e-07,  1.455855251251537e-09, -1.458732671051323e-11,  1.453779788012481e-13, -1.436631043483739e-15,  1.406040939969192e-17,
 -1.363196841096459e-19,  1.309596162466379e-21, -1.247468506848837e-23,  1.708747395696646e-01, -2.703563168917112e-03,  4.798583172210262e-05, -7.964873290923034e-07,
  1.238931585297983e-08, -1.831915462928278e-10,  2.600573470948977e-12, -3.567950240670561e-14,  4.753268002693546e-16, -6.170468278466997e-18,  7.826839730019535e-20,
 -9.720483676510622e-22,  1.413168838796993e-01, -4.295968262914897e-03,  1.175986032549780e-04, -2.768878843089209e-06,  5.886810500925146e-08, -1.158946216597011e-09,
  2.145007353738763e-11, -3.770643133621809e-13,  6.341850647303980e-15, -1.026183514383179e-16,  1.604343129306898e-18, -2.431166091355122e-20,  1.068958981937212e-01,
 -5.562556784121917e-03,  2.158039727345198e-04, -6.856271063572530e-06,  1.905149696053816e-07, -4.786094666469414e-09,  1.109362871381206e-10, -2.405108333432332e-12,
  4.924839821389855e-14, -9.593954200084059e-16,  1.788059141934748e-17, -3.201438183995796e-19,  7.447100330591169e-02, -5.985159500662772e-03,  3.157205366608973e-04,
 -1.307960063157487e-05,  4.604048315630087e-07, -1.434311064678537e-08,  4.054265902797501e-10, -1.057224353721686e-11,  2.573609716577124e-13, -5.900103458889700e-15,
  1.282511161164039e-16, -2.656519047604956e-18,  4.822659896501896e-02, -5.534818743937439e-03,  3.837927315131036e-04, -2.015364695135021e-05,  8.768599452464166e-07,
 -3.313373982988930e-08,  1.119026900668286e-09, -3.443267072260070e-11,  9.785591852408978e-13, -2.594787330415589e-14,  6.470163555037219e-16, -1.525852426850847e-17,
  2.936484498344918e-02, -4.529493658048762e-03,  4.000902464586388e-04, -2.597240367539963e-05,  1.367322980951188e-06, -6.148979897654972e-08,  2.438504887094192e-09,
 -8.711525099731193e-11,  2.846557651805920e-12, -8.604569588254198e-14,  2.427319589603168e-15, -6.430935145354209e-17,  1.703709336626263e-02, -3.363313200633591e-03,
  3.673895766640859e-04, -2.880517935737217e-05,  1.799043200694177e-06, -9.461665708936931e-08,  4.336299178874435e-09, -1.772211980874290e-10,  6.566455101784247e-12,
 -2.233239238793966e-13,  7.038603240264066e-15, -2.070040018998192e-16,  9.556713001520108e-03, -2.316758613882823e-03,  3.043090225241637e-04, -2.817843783683063e-05,
  2.048291021217414e-06, -1.238627387065764e-07,  6.459847139586281e-09, -2.977491221015136e-10,  1.234418361648692e-11, -4.664417037282672e-13,  1.622985623700416e-14,
 -5.238421182224946e-16,  5.258942097205507e-03, -1.509874118846914e-03,  2.321689830874270e-04, -2.483558222135883e-05,  2.061331945032599e-06, -1.408985634668741e-07,
  8.233145061452789e-09, -4.218792202436582e-10,  1.930966586251147e-11, -8.005069375613283e-13,  3.038568448068262e-14, -1.064205371047123e-15,  2.874622947566014e-03,
 -9.461086396519822e-04,  1.659407517084380e-04, -2.005776396283072e-05,  1.864161690926942e-06, -1.415200223949520e-07,  9.117386125356425e-09, -5.117125189010124e-10,
  2.550125907772951e-11, -1.144858848483783e-12,  4.682837314175243e-14, -1.759091660116403e-15,  1.570734757189871e-03, -5.752266678673356e-04,  1.121874138439178e-04,
 -1.498298145960001e-05,  1.528206874934503e-06, -1.265105590700769e-07,  8.835731261068004e-09, -5.347291774664812e-10,  2.859411969181671e-11, -1.371270062995108e-12,
  5.966798844298933e-14, -2.375045670280212e-15,  8.504323033157399e-04, -3.371288308447576e-04,  7.129641708918528e-05, -1.028315118848440e-05,  1.127261048202791e-06,
 -9.982346415637542e-08,  7.424798039733758e-09, -4.765678557089556e-10,  2.692554331473671e-11, -1.359507736445609e-12,  6.208115496941279e-14, -2.585213316364227e-15,
  4.335086287760312e-04, -1.813103144070777e-04,  4.055146084955531e-05, -6.170940820091586e-06,  7.115030813704568e-07, -6.605881140328639e-08,  5.135776244426181e-09,
 -3.435801121186261e-10,  2.017867560966730e-11, -1.056475803393896e-12,  4.991011152949109e-14, -2.145422894093333e-15,  1.638928579023524e-04, -7.058459198788947e-05,
  1.628531570675213e-05, -2.553560266138847e-06,  3.028684744265387e-07, -2.887602721947810e-08,  2.301503524350450e-09, -1.575944678177543e-10,  9.459430472547812e-12,
 -5.054596953032336e-13,  2.433922432858250e-14, -1.065067443091540e-15,  1.819482098858893e-01, -1.485415486698193e-03,  1.326101330876327e-05, -1.245945083147920e-07,
  1.195985907144729e-09, -1.153431874815410e-11,  1.107799284508415e-13, -1.056089793888938e-15,  9.977299488993184e-18, -9.343400489423960e-20,  8.672547362635734e-22,
 -7.985759126588368e-24,  1.607721433826123e-01, -2.354796001407614e-03,  3.950657750376092e-05, -6.244889528484524e-07,  9.276785858075175e-09, -1.312328670681397e-10,
  1.784967502875837e-12, -2.349363364282429e-14,  3.005844245482965e-16, -3.751030496026216e-18,  4.577692933203023e-20, -5.474123943926084e-22,  1.258246455283366e-01,
 -3.473669655551976e-03,  8.934019346774375e-05, -1.987666482980795e-06,  4.008750841626528e-08, -7.509233558340373e-10,  1.325557049367897e-11, -2.226724249786056e-13,
  3.584779077920866e-15, -5.560153069398130e-17,  8.343029873608453e-19, -1.214807500218293e-20,  8.764208372466968e-02, -4.119842901111399e-03,  1.490722770011956e-04,
 -4.449203642670479e-06,  1.167639310226942e-07, -2.781241325552769e-09,  6.130910987687362e-11, -1.267232905070050e-12,  2.479109183008022e-14, -4.622469914868584e-16,
  8.259077726054394e-18, -1.419733469176333e-19,  5.473968536666995e-02, -3.980792144211074e-03,  1.949707013108688e-04, -7.565455530042066e-06,  2.509566845344353e-07,
 -7.400329951763179e-09,  1.986947071784302e-10, -4.935781247451227e-12,  1.147377267122461e-13, -2.517212124812197e-15,  5.246072810533675e-17, -1.043625265060043e-18,
  3.097687094573639e-02, -3.235631467868349e-03,  2.082225950097185e-04, -1.023973990372917e-05,  4.198421648394004e-07, -1.502044096995491e-08,  4.820953900774379e-10,
 -1.414136188621970e-11,  3.841376391601386e-13, -9.758548751391343e-15,  2.336004214097012e-16, -5.298607354292507e-18,  1.609800789106887e-02, -2.279815830570667e-03,
  1.875126216390013e-04, -1.142896362930108e-05,  5.683030098707009e-07, -2.425112118620801e-08,  9.160136929922755e-10, -3.126734704692185e-11,  9.788443300651857e-13,
 -2.841534318601516e-14,  7.714368883807979e-16, -1.970798730587023e-17,  7.811901124935595e-03, -1.431507306927748e-03,  1.465487577124974e-04, -1.084362663492582e-05,
  6.425500952753948e-07, -3.219949262375778e-08,  1.411095574181819e-09, -5.531212088005138e-11,  1.970800822879456e-12, -6.460405210768773e-14,  1.966628145476756e-15,
 -5.596998079735411e-17,  3.610371068061047e-03, -8.226476066506706e-04,  1.021697122560333e-04, -8.993867755484391e-06,  6.242734266002904e-07, -3.618149297328475e-08,
  1.814254510551618e-09, -8.061943245491267e-11,  3.230007984049743e-12, -1.181989370767635e-13,  3.990564249844677e-15, -1.251964947284964e-16,  1.624317412895789e-03,
 -4.441747435190337e-04,  6.525711062224245e-05, -6.695733304053158e-06,  5.349026253447058e-07, -3.529709065227512e-08,  1.996355388915908e-09, -9.924234203225396e-11,
  4.415758582564889e-12, -1.782828438587625e-13,  6.601489629894218e-15, -2.258881863416960e-16,  7.273016892317088e-04, -2.309932184169972e-04,  3.914377248784183e-05,
 -4.583053877859914e-06,  4.136145621516576e-07, -3.055915920156904e-08,  1.919868634759602e-09, -1.052636861824270e-10,  5.132863013012595e-12, -2.257987681198269e-13,
  9.061869843173889e-15, -3.344019939565272e-16,  3.299888613676082e-04, -1.180222171222114e-04,  2.248232272870487e-05, -2.937106842369349e-06,  2.935097066656987e-07,
 -2.384170241554761e-08,  1.636128344187077e-09, -9.741183469492963e-11,  5.130334715992049e-12, -2.425640837213479e-13,  1.041557770597995e-14, -4.094808153974792e-16,
  1.523313324294936e-04, -5.956865198744355e-05,  1.242290206334729e-05, -1.768238156574004e-06,  1.914619435712324e-07, -1.676131812370321e-08,  1.233463258691750e-09,
 -7.838852544758991e-11,  4.388047171740629e-12, -2.196521056524819e-13,  9.949596969700568e-15, -4.112130096882842e-16,  6.884520514271329e-05, -2.861251485463290e-05,
  6.357172222234484e-06, -9.612937773209427e-07,  1.101774653605386e-07, -1.017240577319788e-08,  7.867438448176555e-10, -5.237645803203916e-11,  3.062082798616114e-12,
 -1.596337127203576e-13,  7.511196379793410e-15, -3.216613939695787e-16,  2.424935591634965e-05, -1.042166437080208e-05,  2.399043653408441e-06, -3.753407812749444e-07,
  4.442343045390107e-08, -4.226860202569168e-09,  3.362465430284365e-10, -2.298233710610430e-11,  1.377095698409622e-12, -7.346288192781128e-14,  3.531867942017499e-15,
 -1.543208694232457e-16,  1.762096922375843e-01, -1.384999249507666e-03,  1.187352314926767e-05, -1.071692102456212e-07,  9.896655904276920e-10, -9.197253289161689e-12,
  8.521761525797206e-14, -7.845692981164088e-16,  7.161966556611904e-18, -6.485218114723085e-20,  5.821426507298469e-22, -5.187508366696791e-24,  1.519409205354331e-01,
 -2.066380953252748e-03,  3.282364022657816e-05, -4.949356273138106e-07,  7.032367525744404e-09, -9.531380801575379e-11,  1.243778146478188e-12, -1.572432432971613e-14,
  1.934369229799768e-16, -2.323083039830432e-18,  2.730536984123089e-20, -3.147177766890384e-22,  1.132223657712364e-01, -2.844491052128821e-03,  6.889170035590466e-05,
 -1.451037065605096e-06,  2.780526342893201e-08, -4.962877364312738e-10,  8.366316730262273e-12, -1.344614550395665e-13,  2.074261377949576e-15, -3.087040189058154e-17,
  4.449916852946250e-19, -6.231323860737730e-21,  7.324958114669892e-02, -3.112828712642142e-03,  1.052850515707868e-04, -2.956660239382658e-06,  7.338467777708978e-08,
 -1.659334547937288e-09,  3.482380171323774e-11, -6.868941938559046e-13,  1.284929566481770e-14, -2.294884796184915e-16,  3.933575217344326e-18, -6.495889590290846e-20,
  4.144447869766006e-02, -2.725679644082402e-03,  1.241196412614407e-04, -4.515573678455878e-06,  1.412777376776771e-07, -3.946390408359813e-09,  1.007114958585339e-10,
 -2.384506756512337e-12,  5.295674871289443e-14, -1.112231775583462e-15,  2.223084064795554e-17, -4.248433713648183e-19,  2.072324064984911e-02, -1.966487518398934e-03,
  1.174578123428868e-04, -5.410121840888694e-06,  2.090679305146924e-07, -7.082476918895137e-09,  2.160417050255109e-10, -6.041185411085582e-12,  1.568455742576799e-13,
 -3.816874036546526e-15,  8.770094288346280e-17, -1.912918849492373e-18,  9.288213271216941e-03, -1.204083583133129e-03,  9.210286645196026e-05, -5.266102575360341e-06,
  2.471501109810127e-07, -1.000102546142069e-08,  3.595731654930256e-10, -1.171981485159800e-11,  3.512891856746961e-13, -9.787130941422640e-15,  2.555461845092205e-16,
 -6.290963931090987e-18,  3.801143651023492e-03, -6.440012379156257e-04,  6.163785950787029e-05, -4.296037508392803e-06,  2.411372667962907e-07, -1.149734394993975e-08,
  4.811527770877130e-10, -1.806630596650474e-11,  6.182695938809471e-13, -1.951214641429313e-14,  5.730478602530201e-16, -1.576479414122722e-17,  1.453734724402952e-03,
 -3.099224905482545e-04,  3.627446427978135e-05, -3.027438091782737e-06,  2.001905644178534e-07, -1.109714886607824e-08,  5.339797231197772e-10, -2.283551255401862e-11,
  8.826845827265452e-13, -3.123265409204551e-14,  1.021609632889749e-15, -3.110970853299141e-17,  5.342426565959533e-04, -1.384998634194364e-04,  1.936980596859712e-05,
 -1.900339946222461e-06,  1.457182806204226e-07, -9.259996265720469e-09,  5.057930645073138e-10, -2.434276688866207e-11,  1.050910542859334e-12, -4.124817105188631e-14,
  1.487421713755233e-15, -4.964686992526941e-17,  1.946223035471000e-04, -5.940228535006406e-05,  9.691059303903054e-06, -1.095658276596462e-06,  9.575363797521953e-08,
 -6.868020367372644e-09,  4.198140300176458e-10, -2.243960596036713e-11,  1.068591996332688e-12, -4.598078287662457e-14,  1.807574608027438e-15, -6.542620322696636e-17,
  7.244819324826928e-05, -2.522516464324919e-05,  4.679686051023690e-06, -5.964662628906576e-07,  5.826243847530763e-08, -4.633962438377798e-09,  3.118597033000278e-10,
 -1.823437048883105e-11,  9.443060067419511e-13, -4.395214685311086e-14,  1.859843284291234e-15, -7.212597733061300e-17,  2.809186147457363e-05, -1.081435323186496e-05,
  2.219686292218547e-06, -3.112394266000143e-07,  3.323361697506109e-08, -2.871991497520172e-09,  2.088268905857089e-10, -1.312406333211033e-11,  7.270765373193769e-13,
 -3.604496774437248e-14,  1.618064021551357e-15, -6.631370122611638e-17,  1.109653565988626e-05, -4.578372248070640e-06,  1.009544509894326e-06, -1.515575104250137e-07,
  1.725324032540952e-08, -1.582904221713747e-09,  1.217034230471269e-10, -8.057786081182387e-12,  4.686672511780859e-13, -2.431561518729226e-14,  1.138978924542859e-15,
 -4.857113454207265e-17,  3.606485796245588e-06, -1.546302984894446e-06,  3.550525017359320e-07, -5.541232076454888e-08,  6.542857020596981e-09, -6.211547055886715e-10,
  4.930793968916110e-11, -3.363398295261951e-12,  2.011491687539897e-13, -1.071109795472353e-14,  5.140689798095657e-16, -2.242491284955834e-17,  1.708518892166284e-01,
 -1.294899290507011e-03,  1.067677095117476e-05, -9.270202685820400e-08,  8.245185892203583e-10, -7.391755084307330e-12,  6.613688927641278e-14, -5.886576416633540e-16,
  5.196810798190735e-18, -4.555180066413673e-20,  3.957279752845491e-22, -3.416923722251376e-24,  1.441654817031099e-01, -1.825770972594046e-03,  2.750148583964648e-05,
 -3.961841014271374e-07,  5.392247822679005e-09, -7.011739526098209e-11,  8.789438875048850e-13, -1.068599201369506e-14,  1.265376737620646e-16, -1.464030775991172e-18,
  1.659060959333178e-20, -1.844863670915005e-22,  1.028461547512246e-01, -2.356133524095773e-03,  5.385315105698767e-05, -1.075806383505360e-06,  1.961728046574813e-08,
 -3.340907746579138e-10,  5.385299858857986e-12, -8.290332933332084e-14,  1.226799258842280e-15, -1.753637936477322e-17,  2.430670975924382e-19, -3.276242712114532e-21,
  6.228331108539498e-02, -2.394763900610308e-03,  7.588594376864513e-05, -2.008380095950915e-06,  4.720910798233290e-08, -1.014568571874114e-09,  2.029321505792353e-11,
 -3.823574684236229e-13,  6.845267695949182e-15, -1.171977767791668e-16,  1.928529784058636e-18, -3.061498320616779e-20,  3.223178516326217e-02, -1.916287980345021e-03,
  8.126155055006351e-05, -2.774899916647931e-06,  8.196503164229447e-08, -2.170675978098634e-09,  5.269071466220901e-11, -1.189806564626761e-12,  2.525841156196587e-14,
 -5.080899467911954e-16,  9.743532737489134e-18, -1.789337003942852e-19,  1.439353602895172e-02, -1.238828540823115e-03,  6.870929346425077e-05, -2.965238186634004e-06,
  1.080359703013374e-07, -3.466452315548557e-09,  1.005145000488112e-10, -2.679786621101855e-12,  6.650262389902028e-14, -1.550317939572792e-15,  3.419098674890724e-17,
 -7.170879539612589e-19,  5.623422235455025e-03, -6.654377320027482e-04,  4.729648673948529e-05, -2.535270345924649e-06,  1.122495020879050e-07, -4.305323372980324e-09,
  1.472748854437684e-10, -4.581520804380682e-12,  1.314228336975306e-13, -3.512367035337608e-15,  8.815735781484633e-17, -2.090166064146890e-18,  1.958660759552215e-03,
 -3.056337542587602e-04,  2.729017028319479e-05, -1.788750961109252e-06,  9.497640592237899e-08, -4.303357018995531e-09,  1.717812988778954e-10, -6.171834286983418e-12,
  2.026540679757299e-13, -6.151078544506159e-15,  1.741118738284688e-16, -4.625566941017736e-18,  6.235999025891231e-04, -1.238208336456148e-04,  1.361484921121670e-05,
 -1.074576812108709e-06,  6.754628184497369e-08, -3.574227894522843e-09,  1.647500342689728e-10, -6.769208162828684e-12,  2.520504746747321e-13, -8.610779875696066e-15,
  2.724965405425033e-16, -8.043346964316511e-18,  1.873991053547180e-04, -4.583601537203229e-05,  6.079374217559770e-06, -5.685119314433576e-07,  4.172938353097323e-08,
 -2.547477206249236e-09,  1.340818860860171e-10, -6.234704215218175e-12,  2.606588740717504e-13, -9.928243266309692e-15,  3.480732950517327e-16, -1.131479874733765e-17,
  5.526388955667287e-05, -1.613700307518425e-05,  2.524950504588359e-06, -2.747567610118884e-07,  2.318534163869678e-08, -1.610256049679071e-09,  9.554188167597766e-11,
 -4.967838580655285e-12,  2.305774143951663e-13, -9.686871840351497e-15,  3.723760844820915e-16, -1.319914630371423e-17,  1.669023429878686e-05, -5.636956737821299e-06,
  1.015142055593139e-06, -1.258749259308585e-07,  1.198746053799468e-08, -9.313985383920502e-10,  6.134192540095329e-11, -3.515556076063385e-12,  1.787066812655317e-13,
 -8.175074216797579e-15,  3.403906444815025e-16, -1.300339524814943e-17,  5.352592455740846e-06, -2.023710353514433e-06,  4.078960472896162e-07, -5.622808696425762e-08,
  5.909883966765225e-09, -5.033169449239847e-10,  3.610552540136115e-11, -2.240851107166821e-12,  1.227074416320647e-13, -6.017751967866923e-15,  2.674269173348649e-16,
 -1.085762155131607e-17,  1.819039979074275e-06, -7.442378834643932e-07,  1.626821591000824e-07, -2.422128367510773e-08,  2.736104062317535e-09, -2.492256642488988e-10,
  1.903427122516764e-11, -1.252409551366024e-12,  7.242312060232923e-14, -3.737221341351650e-15,  1.741745372683148e-16, -7.392635649181471e-18,  5.394936774229478e-07,
 -2.306937567779440e-07,  5.281922352398882e-08, -8.220558401058119e-09,  9.680912560045985e-10, -9.167772818736890e-11,  7.260315544853237e-12, -4.941371364873427e-13,
  2.948968948378013e-14, -1.567173920508074e-15,  7.507248935375580e-17, -3.268964667241896e-18,  1.658363775112873e-01, -1.213721252800040e-03,  9.638886678716274e-06,
 -8.061145206512417e-08,  6.913123291048073e-10, -5.984879903895816e-12,  5.175631156673767e-14, -4.458136489646299e-16,  3.809081326520173e-18, -3.235883177281221e-20,
  2.721652806945770e-22, -2.281266168408135e-24,  1.372742505040387e-01, -1.623408837032046e-03,  2.322210816846996e-05, -3.200748569252185e-07,  4.178784195780326e-09,
 -5.220015935168874e-11,  6.293305561544726e-13, -7.366313641934873e-15,  8.405390400049879e-17, -9.378617280105140e-19,  1.025658655824094e-20, -1.101394783869102e-22,
  9.420842635628035e-02, -1.972076933757574e-03,  4.262700154854920e-05, -8.090782810538569e-07,  1.406058688945541e-08, -2.287855986882577e-10,  3.530613362534078e-12,
 -5.211961400486431e-14,  7.406190755908294e-16, -1.017827524737097e-17,  1.357799373177711e-19, -1.763110899053833e-21,  5.378208529902126e-02, -1.872624359671079e-03,
  5.572458709726792e-05, -1.392142877369148e-06,  3.103405045096746e-08, -6.346758185336188e-10,  1.211224333937606e-11, -2.182114264632747e-13,  3.742130816966752e-15,
 -6.146800481352513e-17,  9.717598191719806e-19, -1.483939439235356e-20,  2.568355109044332e-02, -1.379999555098367e-03,  5.459389616917164e-05, -1.751935391140079e-06,
  4.890780636865950e-08, -1.229088608798525e-09,  2.840075845777801e-11, -6.120663000336605e-13,  1.242796455969527e-14, -2.395662916892591e-16,  4.409775016530150e-18,
 -7.785123057791490e-20,  1.034768828054760e-02, -8.066284178978674e-04,  4.157403645198319e-05, -1.681987862498786e-06,  5.780663734079657e-08, -1.757503053738904e-09,
  4.845948110040500e-11, -1.232120619966448e-12,  2.923255516169986e-14, -6.529120044596777e-16,  1.382211722693731e-17, -2.787499432315155e-19,  3.561554172304179e-03,
 -3.837096988626249e-04,  2.532833542902396e-05, -1.272438210985564e-06,  5.313449450005242e-08, -1.931213585833473e-09,  6.283785405667886e-11, -1.865204664093914e-12,
  5.118804979927893e-14, -1.311857457631403e-15,  3.163935245682586e-17, -7.221852463900240e-19,  1.066202511998067e-03, -1.526706357559872e-04,  1.269458232347926e-05,
 -7.814509702712841e-07,  3.920580920215509e-08, -1.686410341479997e-09,  6.415127505257468e-11, -2.203446353345622e-12,  6.935739416956594e-14, -2.022927400829789e-15,
  5.514109163908240e-17, -1.413447498878564e-18,  2.846960433189658e-04, -5.241035299508129e-05,  5.397940221133595e-06, -4.019699437877601e-07,  2.397134643546679e-08,
 -1.208699745604023e-09,  5.328285270208151e-11, -2.100237561742404e-12,  7.522302304939252e-14, -2.477785399225318e-15,  7.576254352543528e-17, -2.164935653669227e-18,
  7.017628946062744e-05, -1.611348751422525e-05,  2.019289010338497e-06, -1.794394217736847e-07,  1.257426675326828e-08, -7.356819647363805e-10,  3.723130493613802e-11,
 -1.669306709893259e-12,  6.745999845839821e-14, -2.489140519478342e-15,  8.470349608416501e-17, -2.677428806212185e-18,  1.670183817982585e-05, -4.643111211742714e-06,
  6.940257697616648e-07, -7.244170444016507e-08,  5.884970671704529e-09, -3.947051959515102e-10,  2.267750008660417e-11, -1.144518251273887e-12,  5.166986499390957e-14,
 -2.115352852922472e-15,  7.937636737233048e-17, -2.750713126573056e-18,  4.051622843020620e-06, -1.321985460697235e-06,  2.302814674070024e-07, -2.769191794986925e-08,
  2.563987853621832e-09, -1.941252896919474e-10,  1.248346277648225e-11, -6.998094164596322e-13,  3.485210884221613e-14, -1.564250826604384e-15,  6.398558071630044e-17,
 -2.404235853671387e-18,  1.057938560475485e-06, -3.917519275198593e-07,  7.733955675676195e-08, -1.045678098053486e-08,  1.079594195784086e-09, -9.044063021675202e-11,
  6.389767981207231e-12, -3.910294816498574e-13,  2.113488407067832e-14, -1.024000712739104e-15,  4.499610257020715e-17, -1.807808231588583e-18,  3.040124483655687e-07,
 -1.231726977921985e-07,  2.665467574447005e-08, -3.930983006301106e-09,  4.401430683399073e-10, -3.976406720889012e-11,  3.013914726537643e-12, -1.969136208570163e-13,
  1.131249015001501e-14, -5.802015534491974e-16,  2.688708813921054e-17, -1.135161000098736e-18,  8.123254039918362e-08, -3.463046931581886e-08,  7.903298536981398e-09,
 -1.226194301713185e-09,  1.439747606975319e-10, -1.359624596394216e-11,  1.073905118172082e-12, -7.290862134040922e-14,  4.340937861888676e-15, -2.301807216965362e-16,
  1.100330255497223e-17, -4.781822191410700e-19,  1.611298422146207e-01, -1.140300150764137e-03,  8.734172806815125e-06, -7.044455478014367e-08,  5.830920156476963e-10,
 -4.879754022019076e-12,  4.081878820790357e-14, -3.406421169334406e-16,  2.818160065381595e-18, -2.323978640536669e-20,  1.891350265199575e-22, -1.544780133200997e-24,
  1.311293495580968e-01, -1.451933275329753e-03,  1.975040008706634e-05, -2.608107208213705e-07,  3.270561560676877e-09, -3.929595241660327e-11,  4.561682992515484e-13,
 -5.146196924812950e-15,  5.664223069252912e-17, -6.101001628890245e-19,  6.444953308062069e-21, -6.689570772100621e-23,  8.694563636729567e-02, -1.666392323689432e-03,
  3.413054481178508e-05, -6.165626594315687e-07,  1.022654412297645e-08, -1.591895205143930e-10,  2.354655621572146e-12, -3.336903973658861e-14,  4.558007653804366e-16,
 -6.028132820126162e-18,  7.746603044509964e-20, -9.698751230350045e-22,  4.708814134575191e-02, -1.486080759956528e-03,  4.162527515051429e-05, -9.832095423218586e-07,
  2.081470937911127e-08, -4.055744473691971e-10,  7.393040113859541e-12, -1.274798706624513e-13,  2.096029368998467e-15, -3.305889745925727e-17,  5.024941815505229e-19,
 -7.386515922837709e-21,  2.092049697513355e-02, -1.015691930939023e-03,  3.756041158551494e-05, -1.134139731020616e-06,  2.995643991711833e-08, -7.150843925783835e-10,
  1.574286420284056e-11, -3.240457758672075e-13,  6.297516545096179e-15, -1.163969455910298e-16,  2.057652701079138e-18, -3.493741423891171e-20,  7.677658162316575e-03,
 -5.413603687759342e-04,  2.595634881711544e-05, -9.851639183087309e-07,  3.195873574567369e-08, -9.211865146362119e-10,  2.416400793256969e-11, -5.861528476447886e-13,
  1.329940442173751e-14, -2.846622771557921e-16,  5.785709444435838e-18, -1.122093581505703e-19,  2.352374143967136e-03, -2.301868906683722e-04,  1.410924615455384e-05,
 -6.642504412326882e-07,  2.615992165673871e-08, -9.009488722288453e-10,  2.788188743744811e-11, -7.895816817926630e-13,  2.072754725693669e-14, -5.092904444416487e-16,
  1.180002298493875e-17, -2.592271638162783e-19,  6.114948875569244e-04, -8.006791034622023e-05,  6.190799654227189e-06, -3.575282196008121e-07,  1.693416954305796e-08,
 -6.909662030868212e-10,  2.502932165721869e-11, -8.212775620152766e-13,  2.476380541355455e-14, -6.935610116045534e-16,  1.819217449467891e-17, -4.496150895963685e-19,
  1.381223136589411e-04, -2.346951002649673e-05,  2.258075152152317e-06, -1.583216641164823e-07,  8.941466620898982e-09, -4.289410854426998e-10,  1.805779287568301e-11,
 -6.819064825753185e-13,  2.346275661513828e-14, -7.442370123505714e-16,  2.196109061629909e-17, -6.068106121232218e-19,  2.806650596845086e-05, -6.019042045025832e-06,
  7.100793575359788e-07, -5.978283943722897e-08,  3.989286436171425e-09, -2.231796984186659e-10,  1.083758603998931e-11, -4.676403234140840e-13,  1.823473881594725e-14,
 -6.506911089794860e-16,  2.145793485615971e-17, -6.585458166872952e-19,  5.386356064736144e-06, -1.418245820904381e-06,  2.016810148588003e-07, -2.012269208676839e-08,
  1.568971172083301e-09, -1.013480622343180e-10,  5.624665437347573e-12, -2.749178112866982e-13,  1.204708296038052e-14, -4.796986360433943e-16,  1.753898006908881e-17,
 -5.932183980943383e-19,  1.040795582546980e-06, -3.265965756987410e-07,  5.481521778110667e-08, -6.370949955251681e-09,  5.717955969752000e-10, -4.207269008223134e-11,
  2.635311788211177e-12, -1.441871108678679e-13,  7.021017707845446e-15, -3.085994214516628e-16,  1.237977785161438e-17, -4.568048704227175e-19,  2.178519105237686e-07,
 -7.875611907552614e-08,  1.518381310478604e-08, -2.008281844903219e-09,  2.031894086035686e-10, -1.670805117916324e-11,  1.160398480707666e-12, -6.989788296802853e-14,
  3.723069466428299e-15, -1.779555305036698e-16,  7.721731859643650e-18, -3.066280567925871e-19,  5.194731515753985e-08, -2.080794049791709e-08,  4.450687881865930e-09,
 -6.492250235866253e-10,  7.195757471009915e-11, -6.440168099862356e-12,  4.839163259422360e-13, -3.136385378579608e-14,  1.788469199046699e-15, -9.109680439900184e-17,
  4.194489490740282e-18, -1.760359649408190e-19,  1.232250858327030e-08, -5.234964523106161e-09,  1.190313932806143e-09, -1.840226977071986e-10,  2.153491587646153e-11,
 -2.027253530157181e-12,  1.596506128990812e-13, -1.080878405101824e-14,  6.418691291846922e-16, -3.395180071660027e-17,  1.619230076342319e-18, -7.021485318897496e-20,
  1.567032491354519e-01, -1.073656592708535e-03,  7.941758323807207e-06, -6.184568446071874e-08,  4.945704334387505e-10, -4.005092345845715e-12,  3.242725878410223e-14,
 -2.625102762536691e-16,  2.102775475590718e-18, -1.687750668931405e-20,  1.324607232458164e-22, -1.065433946987028e-24,  1.256189829784125e-01, -1.305615490794283e-03,
  1.691051134710523e-05, -2.142197951539068e-07,  2.583429788570335e-09, -2.989086521779922e-11,  3.344726549313818e-13, -3.640536371693135e-15,  3.868890486347039e-17,
 -4.026658447685574e-19,  4.112376739513492e-21, -4.129682896478259e-23,  8.078292834401071e-02, -1.420384837319520e-03,  2.761762029314523e-05, -4.756281998009578e-07,
  7.539928887172366e-09, -1.124226423023324e-10,  1.595722248242479e-12, -2.173201344269162e-14,  2.856296924709459e-16, -3.638677133767598e-18,  4.508423905136115e-20,
 -5.446857263907089e-22,  4.174235101867008e-02, -1.195170371632722e-03,  3.158550585292364e-05, -7.065156647275733e-07,  1.422338862903854e-08, -2.643707034208421e-10,
  4.608079420100625e-12, -7.612627435500403e-14,  1.201156992930418e-15, -1.820596277116803e-17,  2.662710942404554e-19, -3.770430246688750e-21,  1.738272259127004e-02,
 -7.624665568858433e-04,  2.641355438623403e-05, -7.514412700966743e-07,  1.880121354072963e-08, -4.267335501727888e-10,  8.958876517037877e-12, -1.762693322793384e-13,
  3.281029277891502e-15, -5.818408565599260e-17,  9.883710138205056e-19, -1.614825867819958e-20,  5.863299745559112e-03, -3.735247242406915e-04,  1.668310563762113e-05,
 -5.945263798434663e-07,  1.821846037776249e-08, -4.981894183400273e-10,  1.243936097950630e-11, -2.880139514789708e-13,  6.251949706665731e-15, -1.282820510048242e-16,
  2.503888910823804e-18, -4.670998719849538e-20,  1.615389184448083e-03, -1.432471797095527e-04,  8.155031335236234e-06, -3.598427590317656e-07,  1.336759236637720e-08,
 -4.362947542764928e-10,  1.284294078726022e-11, -3.469908602411214e-13,  8.712939111168026e-15, -2.052334618143395e-16,  4.567608547203357e-18, -9.655867932267980e-20,
  3.684484441821225e-04, -4.396816161437152e-05,  3.157784633346999e-06, -1.709581868726633e-07,  7.639727727190810e-09, -2.955318429165822e-10,  1.018845511883783e-11,
 -3.191940754749666e-13,  9.214630052860503e-15, -2.476727593812323e-16,  6.247846378693786e-18, -1.487917422999182e-19,  7.107464210162707e-05, -1.109824885046910e-05,
  9.951190274402099e-07, -6.557313000043532e-08,  3.501895998332547e-09, -1.596120436241840e-10,  6.408934981886905e-12, -2.315848993431014e-13,  7.646143884486865e-15,
 -2.333006428229511e-16,  6.636583959043972e-18, -1.771317594159882e-19,  1.198623795796222e-05, -2.388410658907475e-06,  2.643219687664364e-07, -2.102494328460064e-08,
  1.332804241457723e-09, -7.114630546787569e-11,  3.308615581194091e-12, -1.371498047359819e-13,  5.151417556902376e-15, -1.774927598970672e-16,  5.663627887783396e-18,
 -1.685167601718339e-19,  1.857610338440311e-06, -4.607221890808628e-07,  6.206824587177863e-08, -5.898969280954577e-09,  4.401070517671501e-10, -2.730589032866481e-11,
  1.460269721064913e-12, -6.896724838503577e-14,  2.927414045513406e-15, -1.131543324877985e-16,  4.023898334736327e-18, -1.326090279107173e-19,  2.841030562580936e-07,
 -8.530776535093976e-08,  1.373736229573780e-08, -1.537587647141231e-09,  1.333418583958813e-10, -9.507914229271680e-12,  5.786053541489423e-13, -3.082573109209770e-14,
  1.464478107343774e-15, -6.291296539214234e-17,  2.470632982368407e-18, -8.937470395751636e-20,  4.695968060360770e-08, -1.651204299522779e-08,  3.098417729052981e-09,
 -3.997031364796348e-10,  3.952562025141628e-11, -3.182710745754160e-12,  2.168267367422151e-13, -1.283110764139420e-14,  6.723348611727590e-16, -3.165261158585499e-17,
  1.354263101025013e-18, -5.308039241251770e-20,  9.105195871175759e-09, -3.598674029273945e-09,  7.593766227576367e-10, -1.093759653912195e-10,  1.198185987796073e-11,
 -1.060887176210647e-12,  7.892876820143855e-14, -5.068986430358273e-15,  2.866162611480475e-16, -1.448511230074029e-17,  6.621294621741457e-19, -2.760197614761654e-20,
  1.885178031377212e-09, -7.976638408609753e-10,  1.806050062563627e-10, -2.780868660102523e-11,  3.241888900123702e-12, -3.040986839271437e-13,  2.386867921193382e-14,
 -1.610935970478280e-15,  9.538417515229846e-17, -5.031513968879026e-18,  2.393434541169758e-19, -1.035349761017383e-20,  1.525311728461899e-01, -1.012962420706543e-03,
  7.244575969576433e-06, -5.453345630333269e-08,  4.216927958075894e-10, -3.307964958295077e-12,  2.593446389506857e-14, -2.040057634925397e-16,  1.580195583001420e-18,
 -1.241594724682144e-20,  9.284342129759406e-23, -7.590065323168465e-25,  1.206517439993015e-01, -1.179954020152732e-03,  1.456947891465449e-05, -1.772636066398925e-07,
  2.058299232133988e-09, -2.295918391769651e-11,  2.478983717503271e-13, -2.605916613223378e-15,  2.676344134761855e-17, -2.694120751080102e-19,  2.662047323210721e-21,
 -2.589106034217694e-23,  7.550980907503893e-02, -1.220381488073001e-03,  2.256593274170437e-05, -3.710858818890007e-07,  5.630027251617602e-09, -8.050408926916528e-11,
  1.097729845706104e-12, -1.438164937027235e-14,  1.820575894346760e-16, -2.235989320066645e-18,  2.673547544651603e-20, -3.119330361551178e-22,  3.741831955652877e-02,
 -9.728964243925734e-04,  2.431593538042685e-05, -5.158854962189951e-07,  9.889380507526504e-09, -1.755512486156328e-10,  2.929102109263908e-12, -4.640571120770039e-14,
  7.033005101479829e-16, -1.025270607859674e-17,  1.443959938721301e-19, -1.971004835894832e-21,  1.470481457997687e-02, -5.826936509615151e-04,  1.895325335244770e-05,
 -5.087038366229762e-07,  1.207089005868193e-08, -2.607762750267973e-10,  5.225637511439299e-12, -9.836105980966601e-14,  1.754894125977481e-15, -2.987840246685711e-17,
  4.880009610267934e-19, -7.676221230571836e-21,  4.597061971697789e-03, -2.643057176739363e-04,  1.101488048402322e-05, -3.689041336363779e-07,  1.068786200450622e-08,
 -2.774744008291305e-10,  6.599164848254665e-12, -1.459214751070474e-13,  3.031858485253882e-15, -5.966069231922773e-17,  1.118686965363375e-18, -2.007927274123259e-20,
  1.149911224963677e-03, -9.221212692117687e-05,  4.878671139440894e-06, -2.018342736423992e-07,  7.074892211596280e-09, -2.188923854554717e-10,  6.130146879077890e-12,
 -1.580408291712206e-13,  3.796231040427122e-15, -8.572734433714937e-17,  1.832648348870995e-18, -3.727873400812831e-20,  2.325417974097978e-04, -2.520973597205676e-05,
  1.680625183412191e-06, -8.525193685351448e-08,  3.593023009775978e-09, -1.317238087813510e-10,  4.320394148964941e-12, -1.291849153425144e-13,  3.569090502286538e-15,
 -9.202540510003783e-17,  2.231610810716489e-18, -5.118642306866632e-20,  3.870196485258476e-05, -5.529827796359138e-06,  4.611387945406523e-07, -2.851472160081767e-08,
  1.438154368944454e-09, -6.220851911249924e-11,  2.379938151273601e-12, -8.220867647205272e-14,  2.601985738892188e-15, -7.629672395953731e-17,  2.090323181491365e-18,
 -5.384124346334682e-20,  5.461835723203960e-06, -1.005964855525999e-06,  1.040914263817060e-07, -7.802276758515264e-09,  4.688237748508525e-10, -2.383268307123210e-11,
  1.059515303419331e-12, -4.212149141701495e-14,  1.521594837398037e-15, -5.054576550362483e-17,  1.558407940392744e-18, -4.489365299256419e-20,  6.861386871895954e-07,
 -1.593767129501190e-07,  2.025487706074720e-08, -1.827310729274866e-09,  1.300612437784702e-10, -7.730176956765737e-12,  3.973897338417514e-13, -1.809549832019786e-14,
  7.424788381355819e-16, -2.780609475733047e-17,  9.600068989430168e-19, -3.077365312516838e-20,  8.273227065711186e-08, -2.364028838833695e-08,  3.636078316602034e-09,
 -3.904260518416645e-10,  3.260640818628346e-11, -2.246413885756424e-12,  1.324613445287326e-13, -6.854852694238485e-15,  3.170246587247640e-16, -1.328365242150455e-17,
  5.096904685339394e-19, -1.804391266129056e-20,  1.065024178161279e-08, -3.626713612025944e-09,  6.598359986080736e-10, -8.274379792230092e-11,  7.973693469155067e-12,
 -6.270897894481309e-13,  4.180749918692901e-14, -2.425342534527668e-15,  1.247776271218780e-16, -5.775711619500373e-18,  2.432680113629640e-19, -9.397314736700760e-21,
  1.643372635937238e-09, -6.393564217639886e-10,  1.327991161645838e-10, -1.884855134360872e-11,  2.037125110137774e-12, -1.781502459924576e-13,  1.310440229275198e-14,
 -8.328444408103029e-16,  4.664015890382928e-17, -2.336237581699986e-18,  1.059160565364692e-19, -4.381781926466070e-21,  2.912338319721511e-10, -1.226526882656344e-10,
  2.763526353407668e-11, -4.235382777520511e-12,  4.916073349925721e-13, -4.592734261107910e-14,  3.591219801916710e-15, -2.415233861608784e-16,  1.425362715875892e-17,
 -7.495623891043171e-19,  3.555285193690677e-20, -1.533780834328097e-21,  1.485912474025621e-01, -9.575135360442385e-04,  6.628578222451580e-06, -4.828367180642249e-08,
  3.613229493418790e-10, -2.748758697684496e-12,  2.086778592389193e-14, -1.599358095343985e-16,  1.192597390103031e-18, -9.308241605220582e-21,  6.388952074179894e-23,
 -5.731666942256552e-25,  1.161523144272907e-01, -1.071379898800025e-03,  1.262574259216498e-05, -1.477042040484371e-07,  1.653165578919591e-09, -1.779671290347111e-11,
  1.855992404401934e-13, -1.886152267195767e-15,  1.873565174264214e-17, -1.826077457779732e-19,  1.746478454349418e-21, -1.647502262496563e-23,  7.096314705965623e-02,
 -1.056248482038332e-03,  1.860454136141366e-05, -2.925806147971353e-07,  4.253894601019665e-09, -5.840009894930660e-11,  7.658339009974563e-13, -9.661452917456815e-15,
  1.179124039756106e-16, -1.397342258146029e-18,  1.613835306878333e-20, -1.819581998300156e-22,  3.388005603451311e-02, -8.006855777703695e-04,  1.897009289410520e-05,
 -3.823240943236188e-07,  6.987920647694944e-09, -1.186070005960940e-10,  1.896396733499229e-12, -2.884077198434944e-14,  4.202187464828512e-16, -5.896722133774850e-18,
  8.003480662092388e-20, -1.053844537408038e-21,  1.264279376829957e-02, -4.525584603037635e-04,  1.385526443787621e-05, -3.513133236355878e-07,  7.915455294510096e-09,
 -1.629384878657162e-10,  3.119485427957811e-12, -5.622073951058384e-14,  9.621754282802306e-16, -1.573888905426427e-17,  2.473210784354898e-19, -3.747616961962124e-21,
  3.691651431754508e-03, -1.913590023460305e-04,  7.455436572472566e-06, -2.349035571799980e-07,  6.440462387739985e-09, -1.588746072957718e-10,  3.601586081093085e-12,
 -7.610427088780992e-14,  1.514337029482812e-15, -2.859138651505814e-17,  5.152330439626364e-19, -8.900987198192277e-21,  8.461175233173440e-04, -6.123379392730335e-05,
  3.013687087340460e-06, -1.169547654542393e-07,  3.870301757872112e-09, -1.135586845956064e-10,  3.026665138470092e-12, -7.447745508868155e-14,  1.711725208633517e-15,
 -3.706357988580038e-17,  7.611427034362000e-19, -1.489858584618865e-20,  1.532691000268591e-04, -1.504842561008023e-05,  9.309675677274025e-07, -4.423715138035467e-08,
  1.758095647327753e-09, -6.107377227326706e-11,  1.905413764831615e-12, -5.436589433587161e-14,  1.437100651422461e-15, -3.553568882694275e-17,  8.281280317281335e-19,
 -1.828819506977973e-20,  2.224270570506626e-05, -2.895936002810677e-06,  2.242282620135277e-07, -1.299515574740960e-08,  6.183592486717627e-10, -2.536152813064793e-11,
  9.236730846969428e-13, -3.047484377856671e-14,  9.239183591858032e-16, -2.601446050584700e-17,  6.858909350124840e-19, -1.703568808018365e-20,  2.652017301785047e-06,
 -4.491246157974519e-07,  4.331993026045116e-08, -3.052684430069395e-09,  1.735284983684047e-10, -8.385927896800198e-12,  3.558187972097762e-13, -1.354631588930578e-14,
  4.699614816645940e-16, -1.503102609526557e-17,  4.471960547315428e-19, -1.245678747438260e-20,  2.716777636932427e-07, -5.874863909517837e-08,  7.013824862819465e-09,
 -5.986117682449867e-10,  4.053011810265067e-11, -2.301706267531889e-12,  1.134798953822427e-13, -4.971514373167550e-15,  1.967935992828255e-16, -7.127315714883655e-18,
  2.384816910002183e-19, -7.423602854745727e-21,  2.579440108855864e-08, -6.971869193949250e-09,  1.019358555086826e-09, -1.045847899186854e-10,  8.382390726037631e-12,
 -5.562771348427276e-13,  3.169525710266379e-14, -1.589243393384553e-15,  7.138541906597623e-17, -2.911228241537349e-18,  1.089249812024661e-19, -3.766776314544861e-21,
  2.555000659179158e-09, -8.384230446189280e-10,  1.472660872897670e-10, -1.788497719371209e-11,  1.674087867498531e-12, -1.282160798413269e-13,  8.343517310489837e-15,
 -4.733898438522568e-16,  2.386171493704416e-17, -1.083859757242787e-18,  4.486080535887260e-20, -1.705161062143201e-21,  3.067860999897469e-10, -1.171507791260428e-10,
  2.388736422484683e-11, -3.332974599512280e-12,  3.546416447552889e-13, -3.057485651257640e-14,  2.219878481282870e-15, -1.394058601415989e-16,  7.721519798518177e-18,
 -3.828789396677371e-19,  1.719671025637049e-20, -7.053196573301220e-22,  4.550265786850980e-11, -1.905846381623095e-11,  4.269750696090262e-12, -6.508663618781644e-13,
  7.516906492308832e-14, -6.989904848423363e-15,  5.442107317214759e-16, -3.645378434214607e-17,  2.143324416323574e-18, -1.123204451835701e-19,  5.310228694068031e-21,
 -2.283933443289986e-22,  1.448637144042308e-01, -9.067082552478211e-04,  6.082131146896340e-06, -4.291654322060001e-08,  3.110143433535019e-10, -2.297651008663095e-12,
  1.687673295674590e-14, -1.266880182369417e-16,  8.977733883792253e-19, -7.219108454884518e-21,  4.145446382375715e-23, -4.493337908119475e-25,  1.120581822226372e-01,
 -9.770396618796837e-04,  1.100098789067644e-05, -1.238758180653066e-07,  1.337823349890965e-09, -1.391395527242067e-11,  1.402807807912977e-13, -1.379609420579715e-15,
  1.326241023225230e-17, -1.253252695188296e-19,  1.160059404127430e-21, -1.062950035349956e-23,  6.701511377929666e-02, -9.203816687577506e-04,  1.546640461863175e-05,
 -2.329485301419552e-07,  3.249801945114079e-09, -4.288234778458459e-11,  5.413807984558262e-13, -6.582650834209713e-15,  7.752962302022975e-17, -8.871477115932218e-19,
  9.907277375157509e-21, -1.080001512502593e-22,  3.095424295060310e-02, -6.655411533061964e-04,  1.498208443142307e-05, -2.872711207371004e-07,  5.012599454047523e-09,
 -8.144057806661078e-11,  1.249130870503171e-12, -1.825286604705402e-14,  2.559168449084082e-16, -3.459441700497826e-18,  4.528867158329610e-20, -5.756216802531795e-22,
  1.103028768031341e-02, -3.566500431117510e-04,  1.030370044718367e-05, -2.471471067703102e-07,  5.293838059550642e-09, -1.039442636949147e-10,  1.903129895303710e-12,
 -3.286883284674673e-14,  5.400300840046551e-16, -8.492908618517877e-18,  1.284863968825632e-19, -1.876603544018653e-21,  3.029838971555483e-03, -1.414532868041119e-04,
  5.163467644172927e-06, -1.532165439626592e-07,  3.979473383884355e-09, -9.335748650495508e-11,  2.018819306932954e-12, -4.079349275923041e-14,  7.778371032674323e-16,
 -1.409813808169216e-17,  2.442755753329370e-19, -4.063343022370133e-21,  6.417998923004373e-04, -4.183548818688233e-05,  1.917914809761661e-06, -6.986417501777920e-08,
  2.184043959321473e-09, -6.080424091390928e-11,  1.543041678573555e-12, -3.625449402883907e-14,  7.974967127312723e-16, -1.656124066713067e-17,  3.267759509737929e-19,
 -6.155760369904145e-21,  1.051791710417643e-04, -9.324792112813153e-06,  5.354205776912553e-07, -2.383200388777231e-08,  8.931804227344370e-10, -2.940144514835412e-11,
  8.725106225977774e-13, -2.375358682538778e-14,  6.007004599168979e-16, -1.424287034208355e-17,  3.189110535595914e-19, -6.779226516124408e-21,  1.345395998002541e-05,
 -1.589637590048276e-06,  1.141429353020344e-07, -6.194271418227825e-09,  2.778757310615974e-10, -1.079898474961452e-11,  3.741734486328569e-13, -1.178395327879169e-14,
  3.419879215145805e-16, -9.240424628526345e-18,  2.343043778510205e-19, -5.607873833468616e-21,  1.369605361857093e-06, -2.121615101885598e-07,  1.902407805307646e-08,
 -1.257748762679882e-09,  6.752107965418155e-11, -3.097241664923718e-12,  1.252526511327797e-13, -4.560380494456429e-15,  1.517537914951491e-16, -4.667427989958861e-18,
  1.338401952536150e-19, -3.600792100817641e-21,  1.153369040100966e-07, -2.307624864383689e-08,  2.577563523288042e-09, -2.074475307177389e-10,  1.332446117509063e-11,
 -7.212745240876237e-13,  3.402960888909426e-14, -1.431401508223477e-15,  5.455938444676249e-17, -1.907516897144870e-18,  6.175291646935265e-20, -1.863686031828148e-21,
  8.637224281481140e-09, -2.193885341895997e-09,  3.034163698716685e-10, -2.962386896730173e-11,  2.270639430574572e-12, -1.446961959035431e-13,  7.944168874845398e-15,
 -3.849678667958649e-16,  1.675520147568793e-17, -6.636148106020782e-19,  2.416307298358808e-20, -8.146915423374601e-22,  6.519551664562117e-10, -2.049912106132119e-10,
  3.459479944353555e-11, -4.052319941188095e-12,  3.671211761582087e-13, -2.729590733456249e-14,  1.728867290355646e-15, -9.569255277729579e-17,  4.714957865274943e-18,
 -2.097188648322011e-19,  8.513495200689920e-21, -3.178455118121091e-22,  5.954113692640543e-11, -2.223882339029690e-11,  4.437281985306365e-12, -6.069309845916016e-13,
  6.342182081231764e-14, -5.378569950842766e-15,  3.846961730074309e-16, -2.382958943307484e-17,  1.303414528666792e-18, -6.388931203922566e-20,  2.839191212142815e-21,
 -1.153141100306474e-22,  7.203683974110197e-12, -2.997666928684035e-12,  6.671090099368593e-13, -1.010550069409454e-13,  1.160324437210779e-14, -1.073199553448361e-15,
  8.314265135621233e-17, -5.543812572347633e-18,  3.245701566787225e-19, -1.694202810787857e-20,  7.980388321368890e-22, -3.420654870760177e-23,  1.413310488223982e-01,
 -8.600299594566321e-04,  5.595541681556397e-06, -3.828708126324116e-08,  2.688402079489715e-10, -1.932159850186654e-12,  1.369467098052589e-14, -1.018335912848003e-16,
  6.633633908947530e-19, -5.910903067182339e-21,  2.536840374531753e-23, -2.506595373986681e-25,  1.083171120813320e-01, -8.946339327014723e-04,  9.634284531126168e-06,
 -1.045262726699400e-07,  1.090313932404251e-09, -1.096667830323631e-11,  1.069739393657963e-13, -1.019283840701264e-15,  9.484482490051093e-18, -8.706568782405792e-20,
  7.798337934080289e-22, -6.920382910365432e-24,  6.356451289879470e-02, -8.070089015900651e-04,  1.295682782660872e-05, -1.871648899629433e-07,  2.508489842735636e-09,
 -3.184762117191237e-11,  3.874944899403017e-13, -4.544619938265031e-15,  5.171368309476175e-17, -5.716034673669465e-19,  6.180129092255089e-21, -6.520605824587237e-23,
  2.851173306810295e-02, -5.582240714953426e-04,  1.196712837677824e-05, -2.186296336989474e-07,  3.646517926750260e-09, -5.677270399947657e-11,  8.362116283683374e-13,
 -1.175065070589756e-14,  1.586915643594731e-16, -2.067858028540676e-18,  2.613407458945491e-20, -3.208853601816291e-22,  9.751606636680217e-03, -2.847868710825178e-04,
  7.784801566624777e-06, -1.768761766789215e-07,  3.606168082016219e-09, -6.761099201571703e-11,  1.185008281245854e-12, -1.962943587360433e-14,  3.098685053773742e-16,
 -4.688504923702250e-18,  6.833629420401981e-20, -9.626345534888775e-22,  2.536357294971802e-03, -1.065440645000651e-04,  3.652858918350993e-06, -1.021927846957722e-07,
  2.517087163593119e-09, -5.620906053281187e-11,  1.160433647106952e-12, -2.243890329459738e-14,  4.102662578163559e-16, -7.142384096648939e-18,  1.190511899059034e-19,
 -1.907665222621235e-21,  5.005663233677394e-04, -2.933246482911471e-05,  1.254767993178767e-06, -4.293554784945617e-08,  1.268920597212601e-09, -3.354127846080348e-11,
  8.108877098362208e-13, -1.819986935402757e-14,  3.833211630334403e-16, -7.636894329836626e-18,  1.448195246067122e-19, -2.626041556956834e-21,  7.492766983635737e-05,
 -5.980699580324752e-06,  3.189268875321855e-07, -1.329995452374221e-08,  4.701759211055588e-10, -1.466857982790916e-11,  4.141093612469465e-13, -1.075788938651977e-14,
  2.602755672898853e-16, -5.917283018189861e-18,  1.272919994622734e-19, -2.604335168721866e-21,  8.539402680961556e-06, -9.119599571612433e-07,  6.068049326172445e-08,
 -3.081494547528364e-09,  1.302604711713161e-10, -4.794536742305927e-12,  1.579756792854239e-13, -4.746842252799735e-15,  1.318094370151038e-16, -3.415963441166229e-18,
  8.325812464688264e-20, -1.919220295588169e-21,  7.505915287751671e-07, -1.058031493974076e-07,  8.799437871327841e-09, -5.448612400137559e-10,  2.758447674194971e-11,
 -1.199498497545307e-12,  4.617741496271054e-14, -1.606108775644199e-15,  5.120793398849435e-17, -1.512953512454773e-18,  4.177166324567915e-20, -1.084303703274749e-21,
  5.247310744590814e-08, -9.652630712528311e-09,  1.004865305701201e-09, -7.603504278706618e-11,  4.621322321196700e-12, -2.379167948430974e-13,  1.071976204983997e-14,
 -4.321207758791138e-16,  1.583177911213971e-17, -5.334381888616696e-19,  1.668164858310393e-20, -4.873545530604952e-22,  3.113794967234616e-09, -7.381033609549671e-10,
  9.607140540013446e-11, -8.889440660447490e-12,  6.493254870822664e-13, -3.961060877445606e-14,  2.089682044044262e-15, -9.761823952129959e-17,  4.107177877047642e-18,
 -1.576389661900581e-19,  5.574437873524410e-21, -1.828995978254981e-22,  1.779272553325027e-10, -5.325918434687081e-11,  8.590410199055607e-12, -9.662300965822616e-13,
  8.439741979088337e-14, -6.071101376364518e-15,  3.731419192955989e-16, -2.009334943257915e-17,  9.653689150507721e-19, -4.195261271518656e-20,  1.666881490269232e-21,
 -6.100901451578438e-23,  1.208456330202859e-11, -4.396123369319989e-12,  8.550819673684298e-13, -1.142753054040478e-13,  1.169332698395215e-14, -9.730034378768162e-16,
  6.840248933957071e-17, -4.171033708685958e-18,  2.248902897134228e-19, -1.087922944920025e-20,  4.776499680539542e-22, -1.918526931982447e-23,  1.158247923863711e-12,
 -4.782513572281370e-13,  1.055929972086581e-13, -1.587777357186866e-14,  1.810761302746915e-15, -1.664388863631175e-16,  1.282067696052220e-17, -8.503661605979696e-19,
  4.954423311381205e-20, -2.574513853934006e-21,  1.207649997167053e-22, -5.156386619911159e-24,  1.379776473363717e-01, -8.170331068763110e-04,  5.160685436779112e-06,
 -3.427785441388952e-08,  2.332643601019787e-10, -1.635495141655794e-12,  1.110983187025930e-14, -8.382945661801446e-17,  4.672701203117068e-19, -4.989759258935544e-21,
  2.477774984081178e-23,  3.176489783730093e-25,  1.048851786953527e-01, -8.222961610109495e-04,  8.477828141681540e-06, -8.870554591026702e-08,  8.945080712533514e-10,
 -8.710181985748836e-12,  8.225155496437950e-14, -7.604566530836384e-16,  6.845561933582259e-18, -6.116948455312071e-20,  5.328601794980846e-22, -4.455966164323070e-24,
  6.053046533225864e-02, -7.117012119197859e-04,  1.093217090324211e-05, -1.516595073399997e-07,  1.955120432153986e-09, -2.390518626161510e-11,  2.806295780965929e-13,
 -3.176406901531561e-15,  3.497208948380864e-17, -3.734305322075744e-19,  3.909966665785768e-21, -4.018180722643083e-23,  2.645498976780551e-02, -4.720691404588127e-04,
  9.659418071922613e-06, -1.683809170412369e-07,  2.687802128046657e-09, -4.014021542754642e-11,  5.683890311927201e-13, -7.686536921898569e-15,  1.001007092359393e-16,
 -1.258040085002953e-18,  1.535823816757862e-20, -1.825691918324727e-22,  8.724834269222681e-03, -2.301112189358472e-04,  5.968395715906316e-06, -1.286185358373847e-07,
  2.499022312811993e-09, -4.478476032384334e-11,  7.521617452413522e-13, -1.195960162636088e-14,  1.815551159503309e-16, -2.644669421802070e-18,  3.716067894085107e-20,
 -5.053451191528906e-22,  2.161725255255814e-03, -8.161836750560042e-05,  2.635464086546049e-06, -6.958931183473814e-08,  1.627285254285241e-09, -3.462297653811787e-11,
  6.830001583168523e-13, -1.264756869066533e-14,  2.218921296117254e-16, -3.712607506122943e-18,  5.956270233899878e-20, -9.199038472096825e-22,  4.004774126268503e-04,
 -2.105496281140816e-05,  8.422259741223424e-07, -2.709325162965056e-08,  7.576457014252092e-10, -1.902806187645178e-11,  4.385177071071266e-13, -9.406937674276527e-15,
  1.897900787037993e-16, -3.629000195151733e-18,  6.615981279205640e-20, -1.155142279769562e-21,  5.525192899860110e-05, -3.959029855718920e-06,  1.962883040374061e-07,
 -7.671811653155110e-09,  2.559325804224293e-10, -7.569998262175696e-12,  2.033594199242711e-13, -5.042148992637347e-15,  1.167240170135985e-16, -2.544684402682902e-18,
  5.259355639553395e-20, -1.035633511474624e-21,  5.670117531582534e-06, -5.451401998789878e-07,  3.360485159111435e-08, -1.596325687366946e-09,  6.357132567367638e-11,
 -2.215604766567667e-12,  6.940297961850614e-14, -1.989140052232082e-15,  5.283138876592166e-17, -1.312784739787054e-18,  3.074453297289125e-20, -6.822904699044506e-22,
  4.353632074802138e-07, -5.555434897482750e-08,  4.277630148376577e-09, -2.477200233351526e-10,  1.181343522268358e-11, -4.864779562131864e-13,  1.781114066619254e-14,
 -5.912401467981534e-16,  1.804489416165691e-17, -5.116842948398731e-19,  1.358993834867790e-20, -3.400613795042542e-22,  2.555325988992191e-08, -4.294117804631146e-09,
  4.151678482034137e-10, -2.945491789597264e-11,  1.690187016293345e-12, -8.259008122846778e-14,  3.547263018932131e-15, -1.367995124107887e-16,  4.809748118685800e-18,
 -1.559414053446533e-19,  4.703687768225639e-21, -1.328356717480352e-22,  1.210627105247642e-09, -2.658360281869056e-10,  3.240012118843563e-11, -2.829758924662307e-12,
  1.963036369876195e-13, -1.142890352358654e-14,  5.777867017202079e-16, -2.595437067906847e-17,  1.053195639601673e-18, -3.908851862607443e-20,  1.339715857358307e-21,
 -4.269439163416298e-23,  5.221413382708018e-11, -1.477093120500097e-11,  2.264028063963760e-12, -2.433621953265497e-13,  2.041112572000874e-14, -1.415450407507392e-15,
  8.414965589039846e-17, -4.395806629075373e-18,  2.053910377256248e-19, -8.699841224493233e-21,  3.375785612351927e-22, -1.208823385863752e-23,  2.582038068388351e-12,
 -9.101526124367263e-13,  1.718041859048234e-13, -2.234717944668219e-14,  2.231716696001338e-15, -1.816722203168016e-16,  1.252063835102487e-17, -7.498422102523245e-19,
  3.977059244307034e-20, -1.895247935871259e-21,  8.207219203019403e-23, -3.255122826962252e-24,  1.896814436515511e-13, -7.758961556939713e-14,  1.696990695379179e-14,
 -2.529496361922009e-15,  2.861763365066401e-16, -2.611320888902985e-17,  1.998126548538767e-18, -1.317249158369130e-19,  7.631695747966249e-21, -3.945311121018253e-22,
  1.841859423276853e-23, -7.829756829608330e-25,  1.347895671687732e-01, -7.773319081639297e-04,  4.770709951635457e-06, -3.079358636286609e-08,  2.030387477475321e-10,
 -1.395494363193671e-12,  8.946549475696972e-15, -7.151409537786059e-17,  3.116873584170893e-19, -3.394844736255615e-21,  6.457614846012960e-23,  1.638205813550506e-24,
  1.017252245519975e-01, -7.585006727470496e-04,  7.493814313037598e-06, -7.568660874794731e-08,  7.384398913731707e-10, -6.968801073125195e-12,  6.372180843886607e-14,
 -5.728677630654243e-16,  4.985048944997052e-18, -4.321486780188743e-20,  3.778516354177886e-22, -2.669109977958905e-24,  5.784775477893916e-02, -6.310258080893567e-04,
  9.285278858255546e-06, -1.238645826334156e-07,  1.537768232438381e-09, -1.812231255231858e-11,  2.055333599354142e-13, -2.245365383841752e-15,  2.396317404981850e-17,
 -2.475175016246056e-19,  2.491242321718392e-21, -2.562514355230374e-23,  2.470942427277124e-02, -4.022015340485994e-04,  7.872599048099898e-06, -1.311244990308767e-07,
  2.005685496959783e-09, -2.875755809193678e-11,  3.919649203998896e-13, -5.103482364335041e-15,  6.417395728630290e-17, -7.786276903838161e-19,  9.164464781265890e-21,
 -1.063390895830306e-22,  7.890985982815403e-03, -1.879202302971885e-04,  4.638213686581828e-06, -9.492199955191692e-08,  1.759775303381562e-09, -3.017349862798426e-11,
  4.861351657050330e-13, -7.424738320531670e-15,  1.084962534871935e-16, -1.522737758636969e-18,  2.062759259085927e-20, -2.714035001333497e-22,  1.872692539998577e-03,
 -6.347970492589407e-05,  1.936348165685190e-06, -4.830919564293302e-08,  1.073737865231992e-09, -2.178701658879363e-11,  4.110541660554376e-13, -7.294582225827053e-15,
  1.228945118419611e-16, -1.977470035431425e-18,  3.054894940983916e-20, -4.551161262948951e-22,  3.279310852829495e-04, -1.543715833263675e-05,  5.789167035335900e-07,
 -1.752217463586846e-08,  4.640876902425973e-10, -1.108273200588930e-11,  2.436462118134029e-13, -4.998344132246221e-15,  9.665296579962781e-17, -1.774545417697901e-18,
  3.111351754550615e-20, -5.232708084594427e-22,  4.205838502115199e-05, -2.697351102214257e-06,  1.245438987890228e-07, -4.564274254312538e-09,  1.437719721029598e-10,
 -4.033527820354775e-12,  1.031491013758425e-13, -2.441677219070084e-15,  5.409756912545224e-17, -1.131137863373126e-18,  2.246396452484001e-20, -4.257684860030405e-22,
  3.926525561937064e-06, -3.384951287332142e-07,  1.933811017426534e-08, -8.591654978191258e-10,  3.223337953007745e-11, -1.063686289755790e-12,  3.167435265455479e-14,
 -8.657916093591877e-16,  2.199139654409430e-17, -5.238401303200334e-19,  1.178491294392419e-20, -2.517141049797214e-22,  2.664835403487868e-07, -3.062300014305249e-08,
  2.180274150011311e-09, -1.179566447344288e-10,  5.294257503815084e-12, -2.063031531816673e-13,  7.178122218878858e-15, -2.272440148063089e-16,  6.634285167511029e-18,
 -1.804190523830331e-19,  4.606115811063777e-21, -1.110245227764106e-22,  1.329567602383940e-08, -2.027756738445141e-09,  1.815128577080377e-10, -1.204574782522818e-11,
  6.512934831537774e-13, -3.015375829541081e-14,  1.232569569842925e-15, -4.540618140448139e-17,  1.529812509799240e-18, -4.766046866632115e-20,  1.384756243682198e-21,
 -3.775302062178041e-23,  5.080451666330858e-10, -1.025426932879553e-10,  1.164529559044258e-11, -9.562904207691432e-13,  6.279673987627378e-14, -3.479270282839830e-15,
  1.681181028252697e-16, -7.244540650118517e-18,  2.828981662303402e-19, -1.013178579264247e-20,  3.359101021600306e-22, -1.037817245755758e-23,  1.655758285730652e-11,
 -4.390878477788693e-12,  6.356573382728551e-13, -6.497186039780811e-14,  5.210146430210803e-15, -3.470108694305148e-16,  1.988862671480155e-17, -1.004832017648221e-18,
  4.553547434074090e-20, -1.875230159017246e-21,  7.089773289663895e-23, -2.478515154515633e-24,  5.850935801822201e-13, -1.986056569293918e-13,  3.619100966711427e-14,
 -4.561304640552059e-15,  4.428556693105041e-16, -3.515006488558513e-17,  2.367884123743424e-18, -1.389108277750392e-19,  7.230625529535113e-21, -3.387214789341831e-22,
  1.443999844058319e-23, -5.645560807303567e-25,  3.175283546273124e-14, -1.284050708935325e-14,  2.776575590797576e-15, -4.095646281641664e-16,  4.589905034739978e-17,
 -4.152391978853901e-18,  3.152622680776443e-19, -2.063620048004544e-20,  1.187849867744614e-21, -6.104290968242950e-23,  2.834209289369921e-24, -1.198769273815678e-25,
  1.317543058445377e-01, -7.405911428152306e-04,  4.419793584854722e-06, -2.775724097309341e-08,  1.771192619241240e-10, -1.203769853585068e-12,  7.069951512744099e-15,
 -6.282264861016762e-17,  2.584651500016119e-19,  1.200603953678682e-21,  1.801719200673869e-22,  3.672108421872221e-24,  9.880564095171585e-02, -7.019923383584778e-04,
  6.652120830917043e-06, -6.490863224064572e-08,  6.131452633393459e-10, -5.615273705604010e-12,  4.970053152289471e-14, -4.355241578214968e-16,  3.677064986403674e-18,
 -3.001536199222918e-20,  2.921987412847962e-22, -1.287829142007455e-24,  5.546335855710467e-02, -5.622967090071531e-04,  7.935382192704244e-06, -1.019117614540691e-07,
  1.219972722170355e-09, -1.386490099563110e-11,  1.521842760787526e-13, -1.603912877168703e-15,  1.660054520420752e-17, -1.676310949414045e-19,  1.563155467622023e-21,
 -1.733012880460158e-23,  2.321733072036149e-02, -3.450097872596122e-04,  6.474203160324421e-06, -1.031683369135176e-07,  1.514129124351114e-09, -2.085669762390935e-11,
  2.740592641694358e-13, -3.435913562171541e-15,  4.174786453943500e-17, -4.913219590720496e-19,  5.508412004934153e-21, -6.386837133911572e-23,  7.206922486492675e-03,
 -1.549341874317057e-04,  3.650049595055891e-06, -7.102365643998010e-08,  1.257970114851685e-09, -2.065413221323039e-11,  3.196208412302735e-13, -4.691451009730552e-15,
  6.604237230552711e-17, -8.947671631463778e-19,  1.165467857360450e-20, -1.492394413166165e-22,  1.646456448120097e-03, -5.004565309921805e-05,  1.446901329658474e-06,
 -3.414151390003567e-08,  7.221517975061098e-10, -1.398653343593305e-11,  2.526395693747639e-13, -4.299400989168424e-15,  6.960649630969430e-17, -1.078175976622662e-18,
  1.603561113287989e-20, -2.308212479940149e-22,  2.742717735521325e-04, -1.153565191189588e-05,  4.068012094121556e-07, -1.159427011488991e-08,  2.911556911658216e-10,
 -6.616606567287907e-12,  1.388722001157398e-13, -2.726160313784539e-15,  5.055374791165380e-17, -8.917396505625835e-19,  1.504090013476204e-20, -2.438058613703588e-22,
  3.296289874118272e-05, -1.886338798388286e-06,  8.129230862901359e-08, -2.794933578384051e-09,  8.319075736906592e-11, -2.214962151356417e-12,  5.394850323574324e-14,
 -1.219675901079087e-15,  2.587163282877277e-17, -5.189803758123592e-19,  9.905389881997156e-21, -1.807403196992981e-22,  2.827198465922180e-06, -2.176469683307746e-07,
  1.153478144913578e-08, -4.793245376482455e-10,  1.694523953623395e-11, -5.295254350823080e-13,  1.499090359966080e-14, -3.908059280856774e-16,  9.492937705438598e-18,
 -2.167496521768767e-19,  4.683629711618703e-21, -9.626577921289018e-23,  1.715961064350044e-07, -1.766467654134146e-08,  1.162185674334394e-09, -5.869454082211955e-11,
  2.478037327401081e-12, -9.132511284129602e-14,  3.018178628066616e-15, -9.107598546895498e-17,  2.542012601968782e-18, -6.626119072694523e-20,  1.625145402088952e-21,
 -3.770989035139590e-23,  7.373993876897652e-09, -1.013891786170406e-09,  8.381364057932265e-11, -5.192227194838232e-12,  2.640861302988984e-13, -1.156750192425210e-14,
  4.493854055790538e-16, -1.579317503806536e-17,  5.092526895437285e-19, -1.522666575101163e-20,  4.256375681188885e-22, -1.118952989542452e-23,  2.301133696362202e-10,
 -4.234603234009381e-11,  4.460102955421219e-12, -3.431181578187830e-13,  2.126367123632395e-14, -1.118149489087527e-15,  5.151506357041254e-17, -2.124758950960479e-18,
  7.967808903117284e-20, -2.748222461737112e-21,  8.797276059328861e-23, -2.630329087203516e-24,  5.697996730344415e-12, -1.403814963372588e-12,  1.907227591649852e-13,
 -1.844169572544130e-14,  1.407805564542249e-15, -8.971108357190782e-17,  4.940102068684749e-18, -2.406538089445500e-19,  1.054737811807935e-20, -4.212151522006082e-22,
  1.547962241788379e-23, -5.271450868904716e-25,  1.417494816229658e-13, -4.598917752616115e-14,  8.040591908457080e-15, -9.768924584246134e-16,  9.180657920569781e-17,
 -7.077855543471124e-18,  4.644976839202462e-19, -2.661386361863894e-20,  1.355969721740426e-21, -6.229480971150736e-23,  2.608818084254506e-24, -1.003493618047341e-25,
  5.457991718539783e-15, -2.176094481072749e-15,  4.640640908021283e-16, -6.759510795663707e-17,  7.489837370524675e-18, -6.707136312027245e-19,  5.045608594046798e-20,
 -3.275301436051295e-21,  1.871080435216558e-22, -9.549138130684969e-24,  4.405680399696779e-25, -1.852676389515549e-26,  1.288606140936777e-01, -7.065187379949045e-04,
  4.102943926255667e-06, -2.510729693308246e-08,  1.546033792850944e-10, -1.054166696171519e-12,  5.445120489550908e-15, -5.212001711527935e-17,  4.752775317521924e-19,
  1.215606481832327e-20,  3.768929632743551e-22,  4.882816243909304e-24,  9.609939717671143e-02, -6.517323443553037e-04,  5.928572264368551e-06, -5.593586131594998e-08,
  5.118449140662049e-10, -4.556420968748741e-12,  3.900627184421626e-14, -3.329830804906253e-16,  2.796060605015772e-18, -1.916047201908196e-20,  2.566712807401516e-22,
 -4.579258085723749e-25,  5.333383476317587e-02, -5.033934404362618e-04,  6.821011159275865e-06, -8.442639050318075e-08,  9.758492807973568e-10, -1.069654520424331e-11,
  1.138824372310582e-13, -1.158574156564746e-15,  1.152265681889409e-17, -1.187251325203357e-19,  9.188794841269239e-22, -1.223610528836007e-23,  2.193358039612465e-02,
 -2.977859314260484e-04,  5.368848453681033e-06, -8.195215860260641e-08,  1.155692700765330e-09, -1.529773153275855e-11,  1.941715493344121e-13, -2.345450007619816e-15,
  2.742471788122298e-17, -3.190790766426795e-19,  3.280467754620698e-21, -3.944912228322617e-23,  6.640633561994317e-03, -1.288296502835096e-04,  2.906136736131596e-06,
 -5.382472827410133e-08,  9.120749270823491e-10, -1.434758895703152e-11,  2.135787023531099e-13, -3.014963267139488e-15,  4.084693598266796e-17, -5.377588846007640e-19,
  6.668263207729598e-21, -8.393497294219191e-23,  1.467081247782767e-03, -3.993211529682426e-05,  1.098263916295144e-06, -2.453230990957528e-08,  4.944668672420009e-10,
 -9.147970186331202e-12,  1.583845244279184e-13, -2.586680894492008e-15,  4.024980781392693e-17, -6.015779490040244e-19,  8.595974215907833e-21, -1.198718779766190e-22,
  2.338567042563790e-04, -8.767570268269778e-06,  2.917768005239318e-07, -7.836353859358378e-09,  1.868024329265685e-10, -4.042838645349852e-12,  8.108213001563790e-14,
 -1.524121363959749e-15,  2.711600724065289e-17, -4.599987535909734e-19,  7.462879549945252e-21, -1.166936097562813e-22,  2.653382477356841e-05, -1.350490450451736e-06,
  5.447731377983677e-08, -1.758051765447992e-09,  4.949200751918905e-11, -1.251327854263681e-12,  2.904603222306686e-14, -6.274841636502493e-16,  1.274765532199537e-17,
 -2.454395447393365e-19,  4.502804704513146e-21, -7.912205552506770e-23,  2.110324345327646e-06, -1.444613139343844e-07,  7.114607148803264e-09, -2.765606302193215e-10,
  9.217131839044555e-12, -2.728244812409323e-13,  7.344749887483084e-15, -1.826443821942666e-16,  4.243091675266096e-18, -9.287078911137538e-20,  1.927455711316648e-21,
 -3.812065609256145e-23,  1.158677966005890e-07, -1.062746623139515e-08,  6.461922273494216e-10, -3.044831096324920e-11,  1.208897456786942e-12, -4.212308623453248e-14,
  1.321874351770032e-15, -3.800814634631645e-17,  1.013812400669609e-18, -2.531954935385433e-20,  5.963157623310246e-22, -1.331415257613643e-23,  4.347086550469511e-09,
 -5.351849053628664e-10,  4.077963551192458e-11, -2.354368933544863e-12,  1.124992071244307e-13, -4.656457964031375e-15,  1.717356110816363e-16, -5.751624115033981e-18,
  1.773118530891460e-19, -5.082882593187791e-21,  1.365584493931509e-22, -3.458117670013649e-24,  1.123867276421248e-10, -1.869712872510958e-11,  1.818681315961901e-12,
 -1.306420640704904e-13,  7.619666688346712e-15, -3.793643226468170e-16,  1.662802498260562e-17, -6.550947451946536e-19,  2.354529233387855e-20, -7.806869592520785e-22,
  2.408632992983937e-23, -6.957693629501068e-25,  2.135112826837966e-12, -4.839226995816492e-13,  6.130017892545614e-14, -5.578471203738364e-15,  4.036340534295956e-16,
 -2.451622782496167e-17,  1.292704767274300e-18, -6.053254526756645e-20,  2.558656539181934e-21, -9.883154850568518e-23,  3.521927885531882e-24, -1.165687316323264e-25,
  3.703064044359129e-14, -1.138105124203399e-14,  1.895741099415315e-15, -2.207454391884415e-16,  1.998213439237657e-17, -1.490023434536591e-18,  9.490955356916099e-20,
 -5.293652676302363e-21,  2.632242504390365e-22, -1.182820677247992e-23,  4.854518240606291e-25, -1.833217488762529e-26,  9.688369130819624e-16, -3.794830356743998e-16,
  7.955703758757985e-17, -1.141187287269912e-17,  1.247327046647895e-18, -1.103439257731017e-19,  8.210663159370246e-21, -5.277687779829419e-22,  2.988292755220311e-23,
 -1.512829983362788e-24,  6.928612181683137e-26, -2.894151770604712e-27,  1.260983354003799e-01, -6.748598432372635e-04,  3.815824269841047e-06, -2.279566808152600e-08,
  1.347196753926029e-10, -9.387590838361657e-13,  4.287550754618765e-15, -2.660214827620691e-17,  1.232040455464683e-18,  3.099535693932646e-20,  5.391615822458055e-22,
  1.225878129258025e-24,  9.358326164537357e-02, -6.068560760912132e-04,  5.303628324886380e-06, -4.842750143991844e-08,  4.293725975265864e-10, -3.722609629831980e-12,
  3.084559754675611e-14, -2.526011129142655e-16,  2.286465768757187e-18, -9.292822948547697e-21,  2.338825242311576e-22, -8.640290570787893e-25,  5.142333521656061e-02,
 -4.526277327215109e-04,  5.894968885756403e-06, -7.038607483670359e-08,  7.868219360691306e-10, -8.314701947629525e-12,  8.600684208720810e-14, -8.521133193449773e-16,
  7.792772013034455e-18, -9.136220096163572e-20,  4.857549504796358e-22, -7.169375378154578e-24,  2.082252495610321e-02, -2.584762105814581e-04,  4.487035732722245e-06,
 -6.567618494216758e-08,  8.914902783700971e-10, -1.133630438408575e-11,  1.392208126949700e-13, -1.629404628458118e-15,  1.792877512025453e-17, -2.174567624560790e-19,
  1.918698803864321e-21, -2.312727121214713e-23,  6.168046071030020e-03, -1.079361903188173e-04,  2.339159443304478e-06, -4.127489449489816e-08,  6.702377081891733e-10,
 -1.010323727121623e-11,  1.448777783911614e-13, -1.972592764863191e-15,  2.551283314773245e-17, -3.326668132262682e-19,  3.851392908482230e-21, -4.731073920041568e-23,
  1.323233649352030e-03, -3.220173538157768e-05,  8.459148754101634e-07, -1.790022340312525e-08,  3.443283142366674e-10, -6.088193885210653e-12,  1.011530598836124e-13,
 -1.587935430584765e-15,  2.369247253679059e-17, -3.438749603773102e-19,  4.697359766279563e-21, -6.340745101371118e-23,  2.029237046554133e-04, -6.764214269928950e-06,
  2.133120160449724e-07, -5.401561134709581e-09,  1.223972497881241e-10, -2.524386231277097e-12,  4.842432329959529e-14, -8.724858968855154e-16,  1.488726712455363e-17,
 -2.434174302132834e-19,  3.795104210217696e-21, -5.725857657234535e-23,  2.188666276899867e-05, -9.872791577731151e-07,  3.741420777607938e-08, -1.133753979538642e-09,
  3.022098484127602e-11, -7.260336721954334e-13,  1.607241179574474e-14, -3.319972433590181e-16,  6.460855864666191e-18, -1.194960012326842e-19,  2.107277740026860e-21,
 -3.566830049785126e-23,  1.628355882159108e-06, -9.867241009054730e-08,  4.527520966292057e-09, -1.646585363992099e-10,  5.177035393407524e-12, -1.452045153675669e-13,
  3.718697208167258e-15, -8.823705289371538e-17,  1.960742582034297e-18, -4.114916596718098e-20,  8.202739584484532e-22, -1.561119175957703e-23,  8.177493436658186e-08,
 -6.645017031305035e-09,  3.737984580724626e-10, -1.642717329604246e-11,  6.133745716128842e-13, -2.020505320667062e-14,  6.020006766496405e-16, -1.649082880618420e-17,
  4.202717675955398e-19, -1.005404735172379e-20,  2.273077074325994e-22, -4.881778651172964e-24,  2.715306619811579e-09, -2.972121451250979e-10,  2.085336264507033e-11,
 -1.120538051156377e-12,  5.025483790208608e-14, -1.963832653755591e-15,  6.870095817336416e-17, -2.190815769297532e-18,  6.451606905506047e-20, -1.771628083281528e-21,
  4.570684535133567e-23, -1.113973710974182e-24,  5.907997612294987e-11, -8.807434054524886e-12,  7.883546559146798e-13, -5.272484678496176e-14,  2.887336567103443e-15,
 -1.358181882722517e-16,  5.652603641259735e-18, -2.123285209082228e-19,  7.301731291103187e-21, -2.323465910673942e-22,  6.898118013333692e-24, -1.922132255768296e-25,
  8.730953517418083e-13, -1.801189314389066e-13,  2.113742336058679e-14, -1.801260435432473e-15,  1.230136270665408e-16, -7.095516608797622e-18,  3.570700666635832e-19,
 -1.602398023285845e-20,  6.514206236774915e-22, -2.427456626392059e-23,  8.367978886880549e-25, -2.685807966867469e-26,  1.052271784555090e-14, -3.031365663875361e-15,
  4.772596304178381e-16, -5.292194915017007e-17,  4.589533554724004e-18, -3.294790020289444e-19,  2.028688314056331e-20, -1.097537498091177e-21,  5.309114582837886e-23,
 -2.326754755123399e-24,  9.334218969628875e-26, -3.452342394234579e-27,  1.788848494927650e-16, -6.850928904960954e-17,  1.406133917531379e-17, -1.979428432943205e-18,
  2.127942320485060e-19, -1.855032403454762e-20,  1.362411762807256e-21, -8.655671815904459e-23,  4.849773464601334e-24, -2.432054551980077e-25,  1.104331319000186e-26,
 -4.577080364897445e-28,  1.234582666407260e-01, -6.453921888658264e-04,  3.554607404059741e-06, -2.078492219784738e-08,  1.169411131741532e-10, -8.391618009344641e-13,
  4.291830027081689e-15,  3.476713641140365e-17,  2.721081939746049e-18,  5.038848282951664e-20,  3.268698464510526e-22, -1.306158076287975e-23,  9.123717263839745e-02,
 -5.666401886041092e-04,  4.761385226442468e-06, -4.211519411847599e-08,  3.617920943329449e-10, -3.059168359745716e-12,  2.475910197611636e-14, -1.830872438794847e-16,
  2.106138581820586e-18, -1.285944680652709e-21,  1.471404732626413e-22, -3.526965516882053e-24,  4.970208079417546e-02, -4.086444457047825e-04,  5.120725455946556e-06,
 -5.902276611201443e-08,  6.393701266219181e-10, -6.511587231970917e-12,  6.516813081791774e-14, -6.521146213134107e-16,  4.796316050281448e-18, -7.610626015648200e-20,
  3.381526434990186e-22,  1.255510138637805e-24,  1.985574230690102e-02, -2.255060205271069e-04,  3.777570919316984e-06, -5.305903860344781e-08,  6.947878376013993e-10,
 -8.484402750645402e-12,  1.005480597396730e-13, -1.167855368606447e-15,  1.127641927687709e-17, -1.566683149603423e-19,  1.231719334318058e-21, -7.822408848708535e-24,
  5.770829533197483e-03, -9.103602152173246e-05,  1.902099751292589e-06, -3.199593984547732e-08,  4.989031868598913e-10, -7.206802389685387e-12,  9.946520978544587e-14,
 -1.321678188294177e-15,  1.587713147955658e-17, -2.128058729963353e-19,  2.309179458634941e-21, -2.418661400839172e-23,  1.206721945077285e-03, -2.620843615105855e-05,
  6.605388844605770e-07, -1.324688836673902e-08,  2.436382799036719e-10, -4.118660039969877e-12,  6.567414688110641e-14, -9.964052505902796e-16,  1.411781623759848e-17,
 -2.016151123962338e-19,  2.632835515267584e-21, -3.338065243203647e-23,  1.789117336577029e-04, -5.287165475218953e-06,  1.587612969614308e-07, -3.791393476320513e-09,
  8.179987466182957e-11, -1.608685100951277e-12,  2.953030229396049e-14, -5.113050449486079e-16,  8.342885722916214e-18, -1.320710145239827e-19,  1.978936809337324e-21,
 -2.863137657161796e-23,  1.846031228199051e-05, -7.351471297503864e-07,  2.629135750693485e-08, -7.482112234245861e-10,  1.891049066685952e-11, -4.319455565295675e-13,
  9.124590137054237e-15, -1.804515069593321e-16,  3.361875919203692e-18, -5.982374023316047e-20,  1.014311657239564e-21, -1.652171608323294e-23,  1.295324673611083e-06,
 -6.914061166860608e-08,  2.966464348279448e-09, -1.009375138634630e-10,  2.996873646125590e-12, -7.968509164279534e-14,  1.942176729274973e-15, -4.399883379063307e-17,
  9.351865036189740e-19, -1.882804716177863e-20,  3.605397594238018e-22, -6.602174936184570e-24,  6.012781221057778e-08, -4.302588909838022e-09,  2.243924680560929e-10,
 -9.194371537385729e-12,  3.229863182387267e-13, -1.005898696245016e-14,  2.845634298962085e-16, -7.426929703976366e-18,  1.808188878236484e-19, -4.143245897274188e-21,
  8.990631382218060e-23, -1.856840482864107e-24,  1.790937815589711e-09, -1.729935347474810e-10,  1.117712149958016e-11, -5.583945492276921e-13,  2.349256369898022e-14,
 -8.661764600470726e-16,  2.872465590111514e-17, -8.716614794836257e-19,  2.450419063241117e-20, -6.441588703540553e-22,  1.594788314487279e-23, -3.738175931293859e-25,
  3.334342306359433e-11, -4.412989378471762e-12,  3.625142034271373e-13, -2.251680254174048e-14,  1.155505702196272e-15, -5.126262880006476e-17,  2.022470414778184e-18,
 -7.232006637285155e-20,  2.375951819662585e-21, -7.245186822287027e-23,  2.066918510964939e-24, -5.547862070250786e-26,  3.899972564885502e-13, -7.239571946120790e-14,
  7.823309245049121e-15, -6.213310234059639e-16,  3.989261691555542e-17, -2.177637217353113e-18,  1.042615462635520e-19, -4.471214968846346e-21,  1.743534787604837e-22,
 -6.252403708092589e-24,  2.080099471948032e-25, -6.459985871301875e-27,  3.280106207031283e-15, -8.747767380344845e-16,  1.290478768438061e-16, -1.353294449830753e-17,
  1.117887247237109e-18, -7.687903672292145e-20,  4.555924424595526e-21, -2.381561865879086e-22,  1.116848632395613e-23, -4.758859357707467e-25,  1.860806258703653e-26,
 -6.723372074857549e-28,  3.467209182501433e-17, -1.290070156017482e-17,  2.578388783977778e-18, -3.546297476680603e-19,  3.735881636067254e-20, -3.199350150915469e-21,
  2.313127494512252e-22, -1.449220598723922e-23,  8.019446858897543e-25, -3.976847028307271e-26,  1.787658147226936e-27, -7.342026904245909e-29,  1.209320352220986e-01,
 -6.179224346428187e-04,  3.315880345085477e-06, -1.904200364169721e-08,  1.013249495918971e-10, -7.129056967148192e-13,  6.766519392752498e-15,  1.518492753279685e-16,
  4.567595846771732e-18,  4.472454348410975e-20, -8.113988603278010e-22, -4.054516698363793e-23,  8.904372634478118e-02, -5.304766769352054e-04,  4.288816036258157e-06,
 -3.678530786950236e-08,  3.061749672431381e-10, -2.518862556991545e-12,  2.057520117503840e-14, -1.156792978242455e-16,  2.115970371805163e-18,  9.595913755368447e-23,
 -1.171264660561366e-22, -8.861372589331374e-24,  4.814518201660865e-02, -3.703472013283263e-04,  4.469793136883965e-06, -4.975564636124870e-08,  5.233789877123548e-10,
 -5.151750899490692e-12,  4.866604463276371e-14, -5.395410350004099e-16,  2.345659058053822e-18, -5.784827286262787e-20,  6.730354809949968e-22,  1.468472876275395e-23,
  1.901037767738770e-02, -1.976554016227382e-04,  3.202358346294512e-06, -4.317927085512095e-08,  5.467724403974227e-10, -6.427755812366839e-12,  7.211741824151814e-14,
 -8.881154832795904e-16,  6.486115919688935e-18, -1.092023897805671e-19,  1.272543372504313e-21,  1.010762647077682e-23,  5.434865478066170e-03, -7.722949719710898e-05,
  1.561674751630089e-06, -2.504850884367285e-08,  3.759100693148056e-10, -5.212796356756350e-12,  6.853613610695744e-14, -9.201117745433576e-16,  9.671978075513834e-18,
 -1.363188868077585e-19,  1.641886598294726e-21, -6.764728871765754e-24,  1.111536009980229e-03, -2.149945371862984e-05,  5.225007093402945e-07, -9.930669009005957e-09,
  1.750048387225520e-10, -2.832266954619747e-12,  4.313847615522701e-14, -6.429577920118381e-16,  8.454514519519815e-18, -1.199757464230101e-19,  1.573306128405444e-21,
 -1.624139800676384e-23,  1.600435820448255e-04, -4.179029583374272e-06,  1.201682607305124e-07, -2.705853796915458e-09,  5.569288438270113e-11, -1.045490644088818e-12,
  1.833279482190878e-14, -3.072830885177372e-16,  4.755683348738033e-18, -7.319439564330195e-20,  1.068143226005714e-21, -1.434466558904982e-23,  1.589000538057012e-05,
 -5.561737300984232e-07,  1.887747016852297e-08, -5.043783750690622e-10,  1.210751632988956e-11, -2.631721161366109e-13,  5.302859836816868e-15, -1.007279282565702e-16,
  1.792110580809972e-18, -3.073594145431453e-20,  5.027817647178047e-22, -7.827001325522941e-24,  1.059563971936855e-06, -4.954527275607051e-08,  1.997511881821231e-09,
 -6.356972549747511e-11,  1.784645782178099e-12, -4.501406158001950e-14,  1.044253615202589e-15, -2.261765230468810e-17,  4.595722519896078e-19, -8.882419209131504e-21,
  1.635357675912086e-22, -2.877903365047566e-24,  4.591549167499226e-08, -2.874114274194341e-09,  1.394614755467444e-10, -5.325448016877789e-12,  1.761309314997819e-13,
 -5.187531427650210e-15,  1.393481167157106e-16, -3.466559645015537e-18,  8.061303571586844e-20, -1.769440226356537e-21,  3.685431091054244e-23, -7.317335402480143e-25,
  1.242908003942248e-09, -1.050983169978240e-10,  6.261971166464424e-12, -2.905856311919475e-13,  1.146682750937809e-14, -3.987652121571746e-16,  1.253083307719797e-17,
 -3.617245422781017e-19,  9.702568569124708e-21, -2.440544588634260e-22,  5.795338055693086e-24, -1.305709509640014e-25,  2.013945471963649e-11, -2.343052255642560e-12,
  1.763840042270718e-13, -1.015342116640872e-14,  4.875508528613808e-16, -2.037049695468221e-17,  7.608349278885755e-19, -2.586589971800986e-20,  8.108008900964059e-22,
 -2.366387338525366e-23,  6.478906320615139e-25, -1.673088518253357e-26,  1.902216593828147e-13, -3.138209377129720e-14,  3.106336566474277e-15, -2.289295684065433e-16,
  1.376966076786898e-17, -7.091082037419357e-19,  3.220913339971581e-20, -1.316485302298941e-21,  4.911992638678057e-23, -1.691154672247966e-24,  5.417795548173910e-26,
 -1.624587402547476e-27,  1.130197353349794e-15, -2.750495904370601e-16,  3.766930957778370e-17, -3.708839162858947e-18,  2.900707981526150e-19, -1.901157053864177e-20,
  1.079429090037739e-21, -5.430032117678887e-23,  2.459700089692334e-24, -1.015632423345991e-25,  3.859215483158333e-27, -1.358442167750344e-28,  7.136592604442251e-18,
 -2.557462116399663e-18,  4.942748680770850e-19, -6.604851186016463e-20,  6.786886636366321e-21, -5.687755032215811e-22,  4.035004173304737e-23, -2.486067670774362e-24,
  1.355412771921217e-25, -6.632943063118376e-27,  2.946347092529693e-28, -1.197204092281402e-29,  1.185119899393557e-01, -5.922828655200850e-04,  3.096666261511204e-06,
 -1.752428696414570e-08,  8.912574235485127e-11, -4.818045478591657e-13,  1.323898050087576e-14,  3.134560451616206e-16,  5.078168325677408e-18, -3.268333084655186e-20,
 -3.270519799063604e-21, -6.886150347057031e-23,  8.698775774718517e-02, -4.978522230994260e-04,  3.875206920510539e-06, -3.226366039050618e-08,  2.605127759993312e-10,
 -2.056324689689759e-12,  1.827324717576967e-14, -4.969020744088297e-17,  1.924422781222897e-18, -1.420234571373044e-20, -6.392830665419725e-22, -1.441468149345614e-23,
  4.673171961470059e-02, -3.368422114969446e-04,  3.919761456383262e-06, -4.214740854987024e-08,  4.308366031169795e-10, -4.158272000275709e-12,  3.434234735702458e-14,
 -4.910757447446903e-16,  9.435191411358414e-19, -1.365229758040283e-20,  1.635800504118031e-21,  2.796671718054510e-23,  1.826790997956682e-02, -1.739696173723371e-04,
  2.732737375396878e-06, -3.537338738482878e-08,  4.336184228097914e-10, -4.975144458806043e-12,  4.964164924827815e-14, -7.324404763613902e-16,  3.627470955062463e-18,
 -4.407050257313906e-20,  2.104901461434953e-21,  2.637829880156032e-23,  5.149165182868250e-03, -6.584356400303625e-05,  1.294006526051218e-06, -1.978680797839287e-08,
  2.861791272980340e-10, -3.846203641435665e-12,  4.645658648736543e-14, -6.767734808536687e-16,  5.914278187868330e-18, -7.235090040357381e-20,  1.650983308184922e-21,
  6.076158738417958e-24,  1.033205427391739e-03, -1.775248673692479e-05,  4.184305625008312e-07, -7.533119764424850e-09,  1.273970499703884e-10, -1.985993069978074e-12,
  2.835352461802400e-14, -4.305590277145561e-16,  5.127726265636027e-18, -6.792967942272147e-20,  1.102659494959094e-21, -6.122632585463300e-24,  1.450639812163200e-04,
 -3.333863212542926e-06,  9.242463506905224e-08, -1.960784643169400e-09,  3.856555058417987e-11, -6.937216338364894e-13,  1.151571572437579e-14, -1.900911999172594e-16,
  2.761291999433170e-18, -4.056933789607519e-20,  6.163175479261336e-22, -6.994258412725009e-24,  1.393319041777372e-05, -4.264303110497515e-07,  1.383359138741959e-08,
 -3.467049172883966e-10,  7.917918477275693e-12, -1.641663996850210e-13,  3.143219910021214e-15, -5.778664741473319e-17,  9.779901724742514e-19, -1.609215309072589e-20,
  2.587451863244268e-22, -3.762510377993520e-24,  8.891168390964782e-07, -3.619163481462021e-08,  1.380179012526818e-09, -4.104474299959828e-11,  1.091169896269634e-12,
 -2.614547024726082e-14,  5.765221918174609e-16, -1.197683930928604e-17,  2.323749322161431e-19, -4.308107222807437e-21,  7.661837993179497e-23, -1.289354815433008e-24,
  3.630423255582190e-08, -1.972985739656608e-09,  8.955049240891068e-11, -3.184070458579647e-12,  9.925100974293450e-14, -2.766497832755065e-15,  7.053703844365968e-17,
 -1.674520990723083e-18,  3.718223323292695e-20, -7.817367061306980e-22,  1.564313280762803e-23, -2.982929092051790e-25,  9.043414640985262e-10, -6.634649428773076e-11,
  3.657415639340922e-12, -1.574812363230147e-13,  5.830445028990956e-15, -1.912389718202544e-16,  5.692365039089631e-18, -1.563209600151928e-19,  3.999232885729189e-21,
 -9.622321410284174e-23,  2.191075148392064e-24, -4.742403464759086e-26,  1.297097524145504e-11, -1.312286597487581e-12,  9.055229983274497e-14, -4.821824823994739e-15,
  2.164419032793872e-16, -8.508059081311575e-18,  3.005127949054984e-19, -9.703823452828574e-21,  2.899252109640038e-22, -8.090438533377886e-24,  2.123665880509188e-25,
 -5.270571938396789e-27,  1.011433508227161e-13, -1.463100414359825e-14,  1.321236740405570e-15, -9.000597498551649e-17,  5.056212950818900e-18, -2.449736099923100e-19,
  1.052966585763383e-20, -4.092245571539421e-22,  1.457685603855915e-23, -4.808031047856721e-25,  1.480180833550044e-26, -4.277077065346836e-28,  4.331431330609182e-16,
 -9.461298206772612e-17,  1.191769610057175e-17, -1.093617777090595e-18,  8.049468147739119e-20, -5.001729613669048e-21,  2.708343837128700e-22, -1.305695179533457e-23,
  5.691729585873839e-25, -2.269667696853830e-26,  8.354676901456739e-28, -2.856788028562628e-29,  1.582579347569232e-18, -5.397726511510813e-19,  9.997076225503866e-20,
 -1.288679249129699e-20,  1.284216894441908e-21, -1.048189899750993e-22,  7.267252405101179e-24, -4.388304967233707e-25,  2.350380773402744e-26, -1.132190020866397e-27,
  4.958812621774625e-29, -1.989684760311645e-30,  1.161911067112542e-01, -5.683270631045383e-04,  2.894677718043955e-06, -1.615480968839516e-08,  8.346444231220754e-11,
 -4.252488741248845e-14,  2.389879553862483e-14,  4.258273720638826e-16,  8.025331872526371e-19, -2.246260666353099e-19, -6.198639470309919e-21, -4.965439585532253e-23,
  8.505599623607935e-02, -4.683313366287031e-04,  3.511771225890300e-06, -2.840099549658817e-08,  2.236923795178368e-10, -1.628184161583990e-12,  1.762468058783047e-14,
 -2.490264380032085e-18,  7.972974271081674e-19, -5.255194085549110e-20, -1.252304134158405e-21, -1.052329279246355e-23,  4.544402119553567e-02, -3.073960604914719e-04,
  3.452740841308215e-06, -3.587917855793418e-08,  3.548171132677585e-10, -3.495586803724064e-12,  2.104539757842262e-14, -4.536438499743762e-16,  1.934173959893236e-18,
  7.679766965769848e-20,  2.834722381200221e-21,  2.012407478680960e-23,  1.761322395857980e-02, -1.536948721142263e-04,  2.346791673612865e-06, -2.917353247612009e-08,
  3.444322275048877e-10, -4.017554507376517e-12,  3.064946635053652e-14, -6.231256093788877e-16,  3.848745003345354e-18,  6.423344306604439e-20,  3.265561288524113e-21,
  1.948487247115031e-23,  4.905093877393307e-03, -5.636892102169565e-05,  1.081679028726746e-06, -1.576883948954428e-08,  2.189717340894629e-10, -2.939191274001739e-12,
  2.985942559802744e-14, -5.158136934813336e-16,  4.577833421892464e-18,  4.284934892998467e-22,  1.987000856447743e-21,  5.584068023166745e-24,  9.683630721604385e-04,
 -1.473477757315654e-05,  3.390617980332757e-07, -5.779344232283914e-09,  9.359283720858991e-11, -1.433600743468328e-12,  1.828562685666780e-14, -2.975084110500977e-16,
  3.426652228629144e-18, -2.762608512590805e-20,  9.376398382343336e-22, -2.756262063764866e-24,  1.330718345922807e-04, -2.679059170957700e-06,  7.218375154798899e-08,
 -1.441360551946875e-09,  2.707021519013633e-11, -4.724230546963996e-13,  7.241492182606350e-15, -1.208623264030035e-16,  1.682177406914002e-18, -2.082384754248472e-20,
  3.957630348707928e-22, -3.582467269724581e-24,  1.242519904952988e-05, -3.304751403791654e-07,  1.033681604930023e-08, -2.426788038322273e-10,  5.274144941347389e-12,
 -1.050801104139833e-13,  1.888820239026769e-15, -3.404389994277086e-17,  5.513881710718735e-19, -8.382821571473571e-21,  1.404774801368985e-22, -1.859332492887704e-24,
  7.636859060070744e-07, -2.685891945634312e-08,  9.772948523241370e-10, -2.711806449326887e-11,  6.832658907709357e-13, -1.561749596518898e-14,  3.256117529561003e-16,
 -6.526125695444519e-18,  1.211030480199369e-19, -2.131451638251105e-21,  3.722487365974961e-23, -5.941475548194023e-25,  2.963634319195258e-08, -1.386098754793407e-09,
  5.930341926979234e-11, -1.960531326840233e-12,  5.765054267274051e-14, -1.524042975628804e-15,  3.680955313502961e-17, -8.358961727253904e-19,  1.772991663695767e-20,
 -3.561916260215267e-22,  6.875048904580138e-24, -1.256413171653071e-25,  6.874140612799379e-10, -4.330930288512449e-11,  2.221671616595678e-12, -8.863327289281832e-14,
  3.080368728125335e-15, -9.536851046409843e-17,  2.686747162188605e-18, -7.023508083912445e-20,  1.713585606521299e-21, -3.941222522534211e-23,  8.610220588954573e-25,
 -1.789039786232721e-26,  8.872997306590572e-12, -7.712223648122123e-13,  4.890935204964025e-14, -2.404642929977141e-15,  1.008538309593189e-16, -3.727935435742068e-18,
  1.244055118607868e-19, -3.813402351623443e-21,  1.085093532016282e-22, -2.892636564459546e-24,  7.274233016429270e-26, -1.733454510367819e-27,  5.846198976917407e-14,
 -7.305355822267597e-15,  6.006164633648522e-16, -3.769006119243563e-17,  1.972678089722084e-18, -8.971727728248748e-20,  3.641299009848711e-21, -1.342886518805160e-22,
  4.557709253153906e-24, -1.437473058480257e-25,  4.244769538549299e-27, -1.179809120351169e-28,  1.854301842259835e-16, -3.567315717525821e-17,  4.096833224690868e-18,
 -3.478932464803873e-19,  2.395837246847183e-20, -1.404273485859403e-21,  7.219120380833915e-23, -3.321859348540283e-24,  1.388310587661770e-25, -5.328161354788115e-27,
  1.893959878088496e-28, -6.272588655181180e-30,  3.847925665023725e-19, -1.228938088651903e-19,  2.156278149824063e-20, -2.657723608606943e-21,  2.550434291294771e-22,
 -2.015682062210631e-23,  1.359156030011829e-24, -8.010634117328131e-26,  4.200134743637450e-27, -1.985516417959754e-28,  8.552032591609185e-30, -3.380664619353543e-31,
  1.139629177813046e-01, -5.459222121117634e-04,  2.708916428664879e-06, -1.479102560747645e-08,  8.929223806673773e-11,  6.677681199510634e-13,  3.460826529169499e-14,
  2.717645988389110e-16, -1.198999675396408e-17, -4.825848186836943e-19, -5.533774071141088e-21,  1.114812674794838e-22,  8.323678357660820e-02, -4.415418957974704e-04,
  3.191433597583725e-06, -2.505944206352981e-08,  1.953591402199091e-10, -1.205255489763169e-12,  1.755525432990893e-14, -1.746184597637354e-17, -2.050303664402115e-18,
 -1.050643565972602e-19, -1.135443058044307e-21,  2.239406655808420e-23,  4.426708343329844e-02, -2.814049798642687e-04,  3.054023540072833e-06, -3.073810764323565e-08,
  2.889773445767139e-10, -3.132560932557377e-12,  9.787953445598287e-15, -3.246614148483519e-16,  6.830920758594871e-18,  1.933559301680223e-19,  2.489638643512429e-21,
 -4.947025272721618e-23,  1.703390045176321e-02, -1.362330580503926e-04,  2.027237127155154e-06, -2.427110397124790e-08,  2.701081299250709e-10, -3.474354641189024e-12,
  1.545952016907750e-14, -4.368730402940769e-16,  8.591514592637850e-18,  1.968169165912843e-19,  2.832576581602318e-21, -5.394750443518852e-23,  4.695805111365052e-03,
 -4.841707052991157e-05,  9.116478122522145e-07, -1.270123276513122e-08,  1.662719348165462e-10, -2.378756472476772e-12,  1.758031866825885e-14, -3.536090457880726e-16,
  6.025941231114574e-18,  7.794335029560886e-20,  1.640051355259237e-21, -2.882785776786141e-23,  9.144429662259695e-04, -1.227627180690166e-05,  2.778184188127362e-07,
 -4.490009134607484e-09,  6.869568231157512e-11, -1.082984746629859e-12,  1.139097929898353e-14, -1.968274054543868e-16,  3.067656272136464e-18,  6.127550365412889e-21,
  6.922311576935644e-22, -1.076679038516943e-23,  1.234105135706863e-04, -2.164073395323078e-06,  5.720205669655027e-08, -1.075430921563705e-09,  1.911446806567144e-11,
 -3.337448962473923e-13,  4.518368000981934e-15, -7.625971481218048e-17,  1.182309903679733e-18, -7.884315750751314e-21,  2.513875103987672e-22, -3.563274384832006e-24,
  1.125207700253653e-05, -2.581398215127207e-07,  7.868807542935959e-09, -1.729337271085364e-10,  3.557898557157798e-12, -6.943704006037357e-14,  1.144142250092183e-15,
 -2.028515753496574e-17,  3.337446618708232e-19, -4.116023481707029e-21,  7.817673828303700e-23, -1.124225125887787e-24,  6.700601831125778e-07, -2.017763874654178e-08,
  7.083868533046523e-10, -1.831507838684636e-11,  4.362575684531000e-13, -9.619445347633120e-15,  1.873860145407969e-16, -3.635430322076489e-18,  6.589283538768078e-20,
 -1.057350208420155e-21,  1.865076565655594e-23, -2.931694079343334e-25,  2.491123580480748e-08, -9.921359501877530e-10,  4.044184675258134e-11, -1.240909178728597e-12,
  3.439536021371413e-14, -8.675511668561884e-16,  1.974362677781536e-17, -4.298233118221930e-19,  8.765037029802463e-21, -1.663644769310272e-22,  3.124156445667613e-24,
 -5.504693127968124e-26,  5.440043133765770e-10, -2.907758353808233e-11,  1.400602303867778e-12, -5.167470111929839e-14,  1.685741928073123e-15, -4.939584015225589e-17,
  1.314307641578987e-18, -3.273835916264972e-20,  7.628616170484770e-22, -1.672638911359056e-23,  3.512985105485806e-25, -7.009477357720400e-27,  6.420299329014890e-12,
 -4.727059811217633e-13,  2.771611495501104e-14, -1.255531750717094e-15,  4.918594123097106e-17, -1.710442836045337e-18,  5.386633638613647e-20, -1.567154434345828e-21,
  4.245650036722962e-23, -1.080083181901691e-24,  2.601525673014974e-26, -5.948300094791455e-28,  3.659604083734424e-14, -3.883824892354319e-15,  2.909872291041356e-16,
 -1.676709194504892e-17,  8.161391171512406e-19, -3.478683586672772e-20,  1.330663232365523e-21, -4.649332120072816e-23,  1.501039925130126e-24, -4.519265872206646e-26,
  1.278050879684611e-27, -3.411380790184331e-29,  8.884780585019284e-17, -1.473046717883730e-17,  1.531479477937051e-18, -1.195434618191039e-19,  7.661912273385314e-21,
 -4.216368684538753e-22,  2.049147923465023e-23, -8.964896503211175e-25,  3.579247535352438e-26, -1.317651120890398e-27,  4.508800081885700e-29, -1.442083584737237e-30,
  1.047098785910676e-19, -3.062640670624403e-20,  5.019166003394430e-21, -5.852112239027887e-22,  5.362185953717438e-23, -4.075130539550645e-24,  2.656994673625473e-25,
 -1.521006794529930e-26,  7.774324599977647e-28, -3.593630654658008e-29,  1.517419350355499e-30, -5.893575514753918e-32,  1.118214834845489e-01, -5.249352452912124e-04,
  2.540587805651854e-06, -1.320878862442321e-08,  1.112732303851504e-10,  1.529074389356561e-12,  3.401045700902430e-14, -4.178517323516587e-16, -3.136786959367370e-17,
 -5.163120691090631e-19,  6.272461870935688e-21,  4.383928550737793e-22,  8.151984720146861e-02, -4.171618273406281e-04,  2.908752576797130e-06, -2.210399159728132e-08,
  1.753736097588538e-10, -8.009516732406643e-13,  1.553303699976350e-14, -1.493575905149021e-16, -6.247204135398046e-18, -1.121646331218662e-19,  1.289134336749281e-21,
  9.104116004856050e-23,  4.318809657219932e-02, -2.583743106778133e-04,  2.710874743541090e-06, -2.660547475583473e-08,  2.280958987815300e-10, -2.975062366075715e-12,
  4.905700731955645e-15,  1.804112556129663e-17,  1.471631603649064e-17,  2.108787870023507e-19, -2.654040740366728e-21, -1.896826801071283e-22,  1.651965631148184e-02,
 -1.211118727249914e-04,  1.759676664722139e-06, -2.048862119652358e-08,  2.035311863487484e-10, -3.211877861374399e-12,  8.258699031287449e-15, -3.373411809191160e-17,
  1.677621160580233e-17,  2.212942629069635e-19, -2.731883182947885e-21, -2.053672274344809e-22,  4.515817151228497e-03, -4.169180300116302e-05,  7.736912307050148e-07,
 -1.040149541867486e-08,  1.222391016224588e-10, -2.050888643478904e-12,  1.087099182018880e-14, -1.068622291786378e-16,  9.527655255622358e-18,  9.798924057629292e-20,
 -1.190548000953455e-21, -1.033715724866446e-22,  8.694660530483763e-04, -1.025211777978140e-05,  2.298618098799443e-07, -3.550971900376897e-09,  4.938221666924693e-11,
 -8.642763384083699e-13,  7.318489868618396e-15, -9.103113942451706e-17,  3.623467604378596e-18,  1.879993446105835e-20, -2.135187843489667e-22, -3.164716954801858e-23,
  1.155944354630483e-04, -1.753350805006512e-06,  4.592888394099737e-08, -8.177584825161134e-10,  1.337222968083346e-11, -2.468532884433801e-13,  2.881965367787099e-15,
 -4.137404981412984e-17,  1.035224643003997e-18, -1.712525684488924e-21,  3.430063680699210e-23, -6.635511472936928e-24,  1.033351389491703e-05, -2.026191588604716e-07,
  6.093686664887822e-09, -1.257982778159629e-10,  2.403472243104217e-12, -4.770428545151721e-14,  7.071588460498577e-16, -1.146619787724031e-17,  2.303669588232149e-19,
 -1.939209506710722e-21,  3.061806759489291e-23, -1.120044290144873e-24,  5.994419266915986e-07, -1.528419548440720e-08,  5.248441886084289e-10, -1.266044424335773e-11,
  2.816951927975259e-13, -6.136013176178367e-15,  1.102857802155251e-16, -2.014388491718108e-18,  3.855446517336249e-20, -5.266743959771862e-22,  8.696067272041581e-24,
 -1.797592273079747e-25,  2.150711012953367e-08, -7.199789104688531e-10,  2.835375741899493e-11, -8.072308619950395e-13,  2.095108540110011e-14, -5.112066787349211e-16,
  1.088279007606850e-17, -2.251213490060758e-19,  4.540325910405774e-21, -7.941274444268021e-23,  1.431193657553389e-24, -2.616054258114098e-26,  4.467370280157045e-10,
 -1.995994373860445e-11,  9.145415455027646e-13, -3.116062742051520e-14,  9.512141048822481e-16, -2.656655898901721e-17,  6.651975808096406e-19, -1.575579868686254e-20,
  3.536268627339059e-22, -7.334971818313864e-24,  1.479540451950936e-25, -2.874234706878766e-27,  4.893468755103478e-12, -3.000717865945880e-13,  1.643522889198285e-14,
 -6.845415767041956e-16,  2.501425067010522e-17, -8.205310020799993e-19,  2.434265489898103e-20, -6.718279090057283e-22,  1.735548289256591e-23, -4.204126361685846e-25,
  9.698095875069266e-27, -2.130284512406908e-28,  2.469784847143881e-14, -2.182218775341424e-15,  1.497826049950140e-16, -7.900826812240031e-18,  3.570712734956948e-19,
 -1.425666679378011e-20,  5.130779905921246e-22, -1.696306790136129e-23,  5.203979748011032e-25, -1.493253957703289e-26,  4.039308768712915e-28, -1.034106583805091e-29,
  4.761788204206294e-17, -6.634509722998637e-18,  6.220454342594034e-19, -4.435961872934030e-20,  2.633866138651235e-21, -1.355338817616856e-22,  6.203012377684870e-24,
 -2.571090339927452e-25,  9.773717145256647e-27, -3.440400106196778e-28,  1.129908167497367e-29, -3.480113665419754e-31,  3.261229856867631e-20, -8.477615914235510e-21,
  1.276498727755543e-21, -1.390440929127993e-22,  1.204616239321861e-23, -8.732807571403268e-25,  5.468740136927409e-26, -3.023392537955219e-27,  1.499121809404351e-28,
 -6.747325750796819e-30,  2.782805200618492e-31, -1.058527827706982e-32,  1.097614341617359e-01, -5.052117147792580e-04,  2.393901209381530e-06, -1.114562892666698e-08,
  1.484200491104184e-10,  2.077085723831863e-12,  6.051758377577085e-15, -1.628046771773966e-15, -4.009528230583044e-17,  1.895786832702194e-19,  2.971279869233809e-20,
  5.166657534418938e-22,  7.989612592335364e-02, -3.949061914123501e-04,  2.659872570091286e-06, -1.940778194320539e-08,  1.626131631037232e-10, -5.040935324977553e-13,
  8.066936164979684e-15, -3.950287902288664e-16, -8.238080823771302e-18,  3.495268978389629e-20,  6.243340557883899e-21,  1.117577223502457e-22,  4.219603299445131e-02,
 -2.379068089453132e-04,  2.411566382238313e-06, -2.342434501473900e-08,  1.701136348730923e-10, -2.792211274617839e-12,  1.289407955234539e-14,  5.715842797946319e-16,
  1.809342006414645e-17, -9.118401839168534e-20, -1.272016397885316e-20, -2.198234856809870e-22,  1.606187832319009e-02, -1.079673616957920e-04,  1.531269183099797e-06,
 -1.773439998230931e-08,  1.415396732824456e-10, -2.958215319954368e-12,  1.576337299156299e-14,  5.895543840020551e-16,  2.027332250416210e-17, -1.010947244149181e-19,
 -1.371706000796435e-20, -2.428708326691661e-22,  4.360681428101690e-03, -3.597132355501663e-05,  6.592993654219300e-07, -8.759997078108736e-09,  8.377791615928647e-11,
 -1.788750025779690e-12,  1.255473192726221e-14,  2.352385853312590e-16,  1.093723854717730e-17, -5.709788313363115e-20, -6.742691474698881e-21, -1.240404855877109e-22,
  8.318828018090460e-04, -8.571493007436987e-06,  1.914495455753725e-07, -2.890221373170214e-09,  3.371658699987675e-11, -7.056240495310512e-13,  6.465463818216244e-15,
  3.104342416796706e-17,  3.762635850419079e-18, -2.245074242771886e-20, -1.904532437488048e-21, -3.810991529451206e-23,  1.092584136780812e-04, -1.421887379705334e-06,
  3.724785072446184e-08, -6.398685401737784e-10,  9.052089583141576e-12, -1.879071317663314e-13,  2.176306222935109e-15, -9.594635242682788e-18,  9.199125438852384e-19,
 -6.984362503179161e-21, -3.069463308551759e-22, -7.661182472753748e-24,  9.611809866278364e-06, -1.593212416304414e-07,  4.786079023637886e-09, -9.414820634254609e-11,
  1.597153609714090e-12, -3.381060640180825e-14,  4.799270739659404e-16, -5.074310991322812e-18,  1.703188012835597e-19, -1.738751167372543e-21, -2.062541070475322e-23,
 -1.097657963940802e-24,  5.458374045614684e-07, -1.162500034231413e-08,  3.963308666730612e-10, -9.008143105147452e-12,  1.815286045366674e-13, -4.042060715980850e-15,
  6.869858160268037e-17, -1.031419925150858e-18,  2.408803837682201e-20, -3.220561003680704e-22,  1.885591710145102e-24, -1.292394210818771e-25,  1.902663028977948e-08,
 -5.268916197030305e-10,  2.038165218861177e-11, -5.414935444447127e-13,  1.290316038187149e-14, -3.115398443012610e-16,  6.250761457739701e-18, -1.165046201954768e-19,
  2.474745071232904e-21, -4.092205664332083e-23,  5.809286509494385e-25, -1.392046942583544e-26,  3.794800277183902e-10, -1.391599786739717e-11,  6.168458837106425e-13,
 -1.945419069476084e-14,  5.495004810446577e-16, -1.482561736264642e-17,  3.496610528408782e-19, -7.732432469021704e-21,  1.711613855074967e-22, -3.360992225436300e-24,
  6.237518312560329e-26, -1.253750145046300e-27,  3.912307119999007e-12, -1.957127693838886e-13,  1.016826947659119e-14, -3.892784311157877e-16,  1.319562212683630e-17,
 -4.109851825880461e-19,  1.147497357990599e-20, -2.988991234011493e-22,  7.413613266137574e-24, -1.706526678547255e-25,  3.742755611963162e-27, -7.991056820123734e-29,
  1.787821640816898e-14, -1.284080989227666e-15,  8.163765874615049e-17, -3.932751361626093e-18,  1.645667431388162e-19, -6.164528089623514e-21,  2.083940814251827e-22,
 -6.507882345562728e-24,  1.897964752345314e-25, -5.181457326216946e-27,  1.338424080641486e-28, -3.287643141004059e-30,  2.845498569406745e-17, -3.234454904095962e-18,
  2.739054696424889e-19, -1.774721856713646e-20,  9.722329836057242e-22, -4.664405261264434e-23,  2.003430526740590e-24, -7.842900827168173e-26,  2.830630448663314e-27,
 -9.499257201844484e-29,  2.986089923391164e-30, -8.833874162411915e-32,  1.188118423486533e-20, -2.638637400338276e-21,  3.588369585638055e-22, -3.601497840820139e-23,
  2.918585210548041e-24, -2.000465754960218e-25,  1.194227361605206e-26, -6.335387132662487e-28,  3.030511425691079e-29, -1.321707150772404e-30,  5.301875288590025e-32,
 -1.967816438897693e-33,  1.077781037687440e-01, -4.865520035913500e-04,  2.275750151562816e-06, -8.448621439945624e-09,  1.870321730584066e-10,  1.545759689012445e-12,
 -5.462375809359912e-14, -2.537995728235717e-15, -8.021512885966272e-18,  1.635872552500025e-18,  3.538082255528819e-20, -4.687448138362571e-22,  7.835764562151049e-02,
 -3.745152722225753e-04,  2.442279927639209e-06, -1.688037013972355e-08,  1.534293611919917e-10, -4.699149241557700e-13, -6.105256810771892e-15, -5.826813621941988e-16,
 -1.624720114373120e-18,  3.433239231271987e-19,  7.686783293058812e-21, -9.170524173383834e-23,  4.128127047455245e-02, -2.196964789157619e-04,  2.145034297248662e-06,
 -2.112592477052078e-08,  1.189715141399852e-10, -2.232213879534669e-12,  3.572148938705515e-14,  9.852908952900043e-16,  4.031121947070672e-18, -7.075275526437256e-19,
 -1.497147933555513e-20,  2.064313999618829e-22,  1.565321000016636e-02, -9.653429063150306e-05,  1.330176688879707e-06, -1.591567660982075e-08,  8.784504779144044e-11,
 -2.316084460224143e-12,  3.995164543085095e-14,  1.057872500809344e-15,  4.933396695267829e-18, -7.722986331235238e-19, -1.648771853916100e-20,  2.151530952001684e-22,
  4.226707900824870e-03, -3.109721957217375e-05,  5.611022749896757e-07, -7.686472500298286e-09,  5.173838519213106e-11, -1.372834212430932e-12,  2.330976747444398e-14,
  4.918516814367671e-16,  3.078032475475806e-18, -3.913380324077137e-19, -8.310273268089907e-21,  1.026318318623676e-22,  8.004519706953639e-04, -7.170471719506901e-06,
  1.595666440701406e-07, -2.454699849348326e-09,  2.129122527265108e-11, -5.277595459723600e-13,  8.777999985375016e-15,  1.211749088773583e-16,  1.284292630476911e-18,
 -1.193038459265777e-19, -2.454159538201489e-21,  2.809514802668337e-23,  1.041213221447390e-04, -1.152423500285065e-06,  3.032348894764301e-08, -5.222977639321762e-10,
  5.810349601048087e-12, -1.359046069094586e-13,  2.261803414845913e-15,  1.290650010854960e-17,  3.852738247305883e-19, -2.367255739622464e-20, -4.390706357386270e-22,
  4.452387349254952e-24,  9.044497330629472e-06, -1.251648213669335e-07,  3.789232424398009e-09, -7.341566149902533e-11,  1.027525337380781e-12, -2.344708179516073e-14,
  4.031230481844775e-16, -8.651246887798687e-19,  8.355192323972448e-20, -3.248051552590298e-21, -4.438703624718130e-23,  3.387156991813755e-25,  5.050563656175753e-07,
 -8.842973266635984e-09,  3.032589683241323e-10, -6.669218347802684e-12,  1.152415673056616e-13, -2.663192031084995e-15,  4.891353865399187e-17, -4.412315925997253e-19,
  1.270989801289669e-20, -3.336018854365855e-22, -1.585135648784083e-24, -8.113938690870580e-27,  1.720840793066788e-08, -3.867459257647142e-10,  1.494054173869976e-11,
 -3.777025620649688e-13,  7.949282146163055e-15, -1.929461298232556e-16,  3.901646594943584e-18, -5.744174115834157e-20,  1.295883804884800e-21, -2.732443175328793e-23,
  1.656051212952168e-25, -4.678222815764130e-27,  3.323916840553614e-10, -9.785465182063225e-12,  4.276625515154520e-13, -1.264208337387573e-14,  3.221488350465899e-16,
 -8.509887789093470e-18,  1.945302048244809e-19, -3.801817483199874e-21,  8.412960028629941e-23, -1.718924456820878e-24,  2.503609094040372e-26, -5.153208785224471e-28,
  3.266914001498609e-12, -1.300026437681039e-13,  6.534173686011471e-15, -2.313697183349168e-16,  7.169743706464435e-18, -2.140003057066932e-19,  5.675429064210862e-21,
 -1.367973308753224e-22,  3.287093648547313e-24, -7.340172057753970e-26,  1.471249401220145e-27, -3.086478759149642e-29,  1.380194658401854e-14, -7.828583329166847e-16,
  4.691098066073308e-17, -2.065762877901576e-18,  7.946141133976675e-20, -2.804803663001081e-21,  8.915832015446170e-23, -2.614792674635153e-24,  7.269808307825644e-26,
 -1.891302157507236e-27,  4.630184232487256e-29, -1.094898967684665e-30,  1.884833884113288e-17, -1.687634495805812e-18,  1.302794211997485e-19, -7.638207793233656e-21,
  3.842789085807337e-22, -1.716985737027367e-23,  6.902168312477038e-25, -2.543749682212407e-26,  8.700328035661798e-28, -2.776565971646104e-29,  8.329486842372649e-31,
 -2.362390278524707e-32,  5.149331296983302e-21, -9.292306449794987e-22,  1.125300762088421e-22, -1.025884941351058e-23,  7.690355218739015e-25, -4.938342584384200e-26,
  2.787925796352286e-27, -1.409400194009982e-28,  6.464736597438557e-30, -2.717494008489867e-31,  1.055242959345043e-32, -3.805669189825206e-34,  1.058677398510356e-01,
 -4.686988960644357e-04,  2.193045672086588e-06, -5.303916709233727e-09,  1.991933163919271e-10, -5.843255398487198e-13, -1.188539583488039e-13, -1.648027974027657e-15,
  6.706768539380078e-17,  2.170564426638830e-18, -1.918443486531448e-20, -1.854402685268958e-21,  7.689743597991201e-02, -3.557463511794181e-04,  2.254093717990401e-06,
 -1.451413603435224e-08,  1.412691498781593e-10, -8.048627141716872e-13, -2.094267835100483e-14, -3.915565030633473e-16,  1.437209006078142e-17,  4.692121761446733e-19,
 -3.709601558682846e-21, -3.967747770798207e-22,  4.043524118698425e-02, -2.035209325322704e-04,  1.901647622067220e-06, -1.952364872835150e-08,  8.509751592177468e-11,
 -1.056267374068442e-12,  6.062492643458840e-14,  6.210499689027911e-16, -2.819572255955308e-17, -9.255718845115353e-19,  8.517881235215194e-21,  7.910836746319440e-22,
  1.528717565170681e-02, -8.663606768634363e-05,  1.146289325769238e-06, -1.481860893722696e-08,  5.347980677923670e-11, -1.013497352767710e-12,  6.686763496444051e-14,
  6.754093826977836e-16, -3.044509731603503e-17, -1.023429368297480e-18,  8.880070391272827e-21,  8.660266982926747e-22,  4.110729880732043e-03, -2.696514502062299e-05,
  4.730367514091794e-07, -7.043219878845100e-09,  3.098655802954768e-11, -6.519763539160447e-13,  3.596933483098471e-14,  3.163147440704905e-16, -1.488816043194946e-17,
 -5.226092350300411e-19,  4.277583711516288e-21,  4.357246867435941e-22,  7.741438119724435e-04, -6.006694902297840e-06,  1.318461906060308e-07, -2.185854879403971e-09,
  1.312257263414125e-11, -2.762779326215975e-13,  1.198934313015970e-14,  7.902678369552922e-17, -4.175392447375803e-18, -1.595095993640072e-19,  1.213027945157533e-21,
  1.294194121021105e-22,  9.995909311623249e-05, -9.335122058505730e-07,  2.453393803460703e-08, -4.479907350327937e-10,  3.667829943086798e-12, -7.678384307639461e-14,
  2.647563671685506e-15,  8.968355647692784e-18, -6.787519891615544e-19, -3.106275257153711e-20,  2.167145990917538e-22,  2.386375400453998e-23,  8.599238027991166e-06,
 -9.812767509923509e-08,  2.993101975924443e-09, -6.020540998132422e-11,  6.544341542007307e-13, -1.387944011977254e-14,  3.966969163722694e-16, -3.311850747214015e-19,
 -5.492717841519173e-20, -3.976258519320060e-21,  2.594753314300157e-23,  2.714611183418690e-24,  4.740691711574197e-07, -6.709329953363091e-09,  2.327306374845141e-10,
 -5.191200540497762e-12,  7.290522978766583e-14, -1.603050485009698e-15,  4.037322250776073e-17, -2.361563668809851e-19, -1.319072343695737e-25, -3.460978199180688e-22,
  2.375975465513285e-24,  1.798899496937565e-25,  1.587447205069145e-08, -2.834517452204918e-10,  1.105906235470455e-11, -2.767714690443862e-13,  4.916981825341288e-15,
 -1.147908146035654e-16,  2.733666499377391e-18, -3.064704378344810e-20,  4.106848368812315e-22, -2.165056022920170e-23,  1.945743152119076e-25,  5.582664076549239e-27,
  2.992401577798489e-10, -6.894807076319940e-12,  3.020018157938639e-13, -8.627008789455081e-15,  1.913675247043015e-16, -4.865551892985854e-18,  1.176341015990100e-19,
 -1.941463150398595e-21,  3.622141695522888e-23, -1.018578832708287e-24,  1.340319414216420e-26, -4.802843123146188e-29,  2.836244035693511e-12, -8.716772349991120e-14,
  4.325660608863971e-15, -1.446093186844444e-16,  3.993944954460353e-18, -1.139603871862535e-19,  2.988360236576651e-21, -6.472817536989528e-23,  1.444997681931450e-24,
 -3.446659506041687e-26,  6.233225598308716e-28, -1.036045627549567e-29,  1.128980410813034e-14, -4.887283918394627e-16,  2.821738898838755e-17, -1.147746274578855e-18,
  3.996460524229508e-20, -1.332830518859736e-21,  4.036725408203543e-23, -1.097198896340927e-24,  2.891065361837020e-26, -7.329370904359550e-28,  1.678236746213968e-29,
 -3.720585520204878e-31,  1.372105498840758e-17, -9.287674407705886e-19,  6.654773555127859e-20, -3.532357039258446e-21,  1.618812061684401e-22, -6.741288055175153e-24,
  2.537313940987565e-25, -8.757934016538762e-27,  2.834388999402743e-28, -8.607355199348965e-30,  2.452685265481698e-31, -6.648981228865514e-33,  2.672839802286765e-21,
 -3.689634530267955e-22,  3.957563004698871e-23, -3.233841015654689e-24,  2.217469696134085e-25, -1.322774316865383e-26,  7.006130324089916e-28, -3.350787474068542e-29,
  1.464657732339265e-30, -5.900727287047964e-32,  2.206620745972958e-33, -7.697705358989294e-35,  1.040277038802764e-01, -4.513568904185852e-04,  2.147603023765595e-06,
 -2.375786420823131e-09,  1.567717052083590e-10, -3.685127796488159e-12, -1.251920169145760e-13,  1.440726254328301e-15,  1.120406144531703e-16, -1.427788478465462e-19,
 -8.770871835400857e-20, -6.525304987177175e-22,  7.550946539395946e-02, -3.383732696382301e-04,  2.092858721314978e-06, -1.241252655405457e-08,  1.195859133482742e-10,
 -1.373357998214505e-12, -2.333340942390844e-14,  2.754543137640137e-16,  2.439298944833967e-17, -1.634863445180915e-20, -1.883598629022241e-20, -1.584241256599083e-22,
  3.965013125463073e-02, -1.892228114411939e-04,  1.675103092805067e-06, -1.824831596701042e-08,  7.928716462303283e-11,  4.787087171110601e-13,  6.123787966197708e-14,
 -6.808174949607025e-16, -4.717215187418946e-17,  6.969741073353262e-20,  3.738967166139912e-20,  2.637001161895440e-22,  1.495786504241738e-02, -7.816345133718241e-05,
  9.732255465930630e-07, -1.403384403003921e-08,  5.009145227360937e-11,  6.784491482834050e-13,  6.752505628757479e-14, -7.451160445518243e-16, -5.183400096226183e-17,
  5.615089500830339e-20,  4.105367267851455e-20,  3.115166700961228e-22,  4.009913592813200e-03, -2.351117319254382e-05,  3.912199005959453e-07, -6.603007949739014e-09,
  2.695241817862180e-11,  2.484743153799402e-13,  3.578353015341062e-14, -3.903117677189543e-16, -2.602828264127604e-17,  1.677153113857983e-20,  2.074135630516095e-20,
  1.677917219137355e-22,  7.520650627837980e-04, -5.053593028648968e-06,  1.067452628922400e-07, -2.004045809984969e-09,  1.055527206226562e-11,  1.823197227275714e-14,
  1.160086157718712e-14, -1.257833266977176e-16, -7.666282168367597e-18, -1.303196932066916e-22,  6.208987400343252e-21,  5.402588761201313e-23,  9.658482308533992e-05,
 -7.578406868943617e-07,  1.947076694003627e-08, -3.981094562143153e-10,  2.771226102406104e-12, -1.360434352552674e-14,  2.450667887818569e-15, -2.686134555691400e-17,
 -1.383400125202667e-18, -1.578935554358751e-21,  1.164520036312139e-21,  1.098640631066523e-23,  8.250269027090138e-06, -7.691248451929499e-08,  2.325957270885306e-09,
 -5.144618321838613e-11,  4.697592445759820e-13, -4.787674652228085e-15,  3.441388845485749e-16, -3.934904051888463e-18, -1.494918247859682e-19, -5.069961654992714e-22,
  1.381732937240234e-22,  1.409515437100706e-24,  4.505862100861584e-07, -5.078938497209005e-09,  1.765412106362678e-10, -4.230944247747115e-12,  4.995303877862768e-14,
 -7.238891703172192e-16,  3.211469892930083e-17, -4.004999310809990e-19, -8.693488807126167e-21, -8.225369928988567e-23,  1.032149790392879e-23,  1.095226619234330e-25,
  1.489826101750900e-08, -2.070795503883249e-10,  8.144868314108985e-12, -2.131752201576391e-13,  3.212596208661807e-15, -5.864793103500398e-17,  1.956324482080870e-18,
 -2.790406826976028e-20, -1.572969864059589e-22, -7.870810126466826e-24,  4.881438068445222e-25,  4.577457910977833e-27,  2.759021936851466e-10, -4.847319635912527e-12,
  2.140889120590051e-13, -6.206745903743337e-15,  1.184319805225973e-16, -2.593879767416023e-18,  7.472588606863152e-20, -1.264961310369324e-21,  9.381215606779417e-24,
 -4.560759406078657e-25,  1.551258931732734e-26,  5.665427498561841e-29,  2.547127263262452e-12, -5.856795907531481e-14,  2.909690147507533e-15, -9.557838909035738e-17,
  2.307845711823586e-18, -5.975603817540246e-20,  1.666934648775765e-21, -3.422262283275199e-23,  5.722920432534057e-25, -1.561042291876875e-26,  3.741810903061269e-28,
 -2.838188609929284e-30,  9.712190998495709e-15, -3.089398196667584e-16,  1.754726611286960e-17, -6.777633560599663e-19,  2.095916651624116e-20, -6.485604713860652e-22,
  1.939943138773847e-23, -4.906725827325723e-25,  1.155147535761216e-26, -2.958703713683651e-28,  6.846441262569475e-30, -1.245304638755099e-31,  1.085322208451134e-17,
 -5.303541711902866e-19,  3.613229000594396e-20, -1.758033137452990e-21,  7.237753612815680e-23, -2.799991132828753e-24,  9.968942852014126e-26, -3.205808080498546e-27,
  9.710430842818834e-29, -2.830606800570465e-30,  7.692072458029484e-32, -1.953776753791256e-33,  1.648988641007185e-21, -1.627069563562097e-22,  1.559923904524109e-23,
 -1.132677985565157e-24,  7.017023083935317e-26, -3.861168015172582e-27,  1.906677380670346e-28, -8.561643653579842e-30,  3.543433279888570e-31, -1.361311878762402e-32,
  4.876095530938764e-34, -1.636640279172831e-35,  1.022565090036517e-01, -4.342540273494614e-04,  2.131237076663839e-06, -5.996079914364710e-10,  5.827467150635217e-11,
 -5.829819730491798e-12, -4.030427906672673e-14,  4.267542852641339e-15,  4.555856111053066e-17, -3.262664466831037e-18, -4.480391296408714e-20,  2.450257464637884e-21,
  7.418855764602632e-02, -3.221959396789280e-04,  1.954394538359430e-06, -1.074516596282629e-08,  8.757763920410528e-11, -1.758459339498663e-12, -5.837070449727310e-15,
  8.998084286388091e-16,  1.044050960080811e-17, -7.013736241478762e-19, -1.026011962857066e-20,  5.228569756995456e-22,  3.891868679189147e-02, -1.766751375349664e-04,
  1.464284661050987e-06, -1.683269142731681e-08,  1.011807256483923e-10,  1.561844436978929e-12,  2.348961429675245e-14, -1.863139274414076e-15, -1.866223001146230e-17,
  1.387986270133455e-18,  1.860654579761741e-20, -1.046781651817232e-21,  1.465973753028744e-02, -7.103609176984943e-05,  8.103339812747868e-07, -1.304610465644125e-08,
  7.725777113394452e-11,  1.874635674951321e-12,  2.602868070269870e-14, -2.054378955460178e-15, -2.103260500859951e-17,  1.521920367318208e-18,  2.121425110663459e-20,
 -1.144731642437177e-21,  3.921637788957562e-03, -2.069037159650899e-05,  3.148722824899441e-07, -6.090696141876760e-09,  3.916196551868150e-11,  8.884110193878222e-13,
  1.444449364525784e-14, -1.052440746778408e-15, -1.077285340419962e-17,  7.661677782140247e-19,  1.110219427677148e-20, -5.757153878628060e-22,  7.334105113616180e-04,
 -4.292836013178899e-06,  8.376661665565069e-08, -1.818795811521740e-09,  1.328195641693085e-11,  2.284196958050810e-13,  4.992843628833489e-15, -3.226072406796495e-16,
 -3.243336516068990e-18,  2.275393381738966e-19,  3.470747080984750e-21, -1.711444182872333e-22,  9.383579735724945e-05, -6.204315757832422e-07,  1.495995364938142e-08,
 -3.530940016019738e-10,  3.001508926062024e-12,  3.146266721333622e-14,  1.136182594496472e-15, -6.284962011639328e-17, -5.999832751988150e-19,  4.192112411036128e-20,
  6.873698718840006e-22, -3.172141064714946e-23,  7.976098687856897e-06, -6.065105539328226e-08,  1.751868281746687e-09, -4.429431980384130e-11,  4.449534910898717e-13,
  1.631678470335428e-15,  1.721325335638928e-16, -7.909190560741953e-18, -6.665887060016257e-20,  4.770676668494466e-21,  8.720003956609631e-23, -3.681100303045464e-24,
  4.327916118730667e-07, -3.856956404168739e-09,  1.302114599410232e-10, -3.510024589268255e-12,  4.211118507731059e-14, -1.189035552167251e-16,  1.715404203009182e-17,
 -6.430510984573822e-19, -4.004861642538975e-21,  3.210954643131000e-22,  7.031722244831484e-24, -2.624639438295336e-25,  1.418519471035679e-08, -1.513531270189963e-10,
  5.863975761823867e-12, -1.688841636126929e-13,  2.442328090945142e-15, -2.176235525399637e-17,  1.089924118798642e-18, -3.355135173547944e-20, -7.848349674098757e-23,
  1.139151594680846e-23,  3.558037404071722e-25, -1.116117030353992e-26,  2.595076316795091e-10, -3.403686116918199e-12,  1.495493395802704e-13, -4.640996347753103e-15,
  8.174636275194707e-17, -1.202409773069835e-18,  4.190217572087040e-20, -1.107322249259341e-21,  4.017739023809909e-24,  1.310657955891726e-25,  1.128507088774270e-26,
 -2.796640547477430e-28,  2.352928947111175e-12, -3.932865985971078e-14,  1.951091685962445e-15, -6.633439167678101e-17,  1.444021169835194e-18, -2.960083144166155e-20,
  8.998280483782319e-22, -2.225072293225824e-23,  2.498457787240868e-25, -3.222011482904655e-27,  2.312797517815629e-28, -4.551888064350930e-30,  8.712608501165793e-15,
 -1.962354238210350e-16,  1.106888360779950e-17, -4.249185738492853e-19,  1.171121498822187e-20, -3.142527870510446e-22,  9.558217956794161e-24, -2.475197851024940e-25,
  4.770035975804616e-27, -1.047734307069047e-28,  3.154563137710080e-30, -6.109998145265114e-32,  9.199398732911309e-18, -3.095356631282924e-19,  2.048678216810798e-20,
 -9.432242013094395e-22,  3.451334909068618e-23, -1.209909379099742e-24,  4.153966896454958e-26, -1.269530890854494e-27,  3.481848985749846e-29, -9.574778880392026e-31,
  2.617237079420351e-32, -6.257636513642820e-34,  1.182505906444655e-21, -7.777670478690121e-23,  6.822811489822971e-24, -4.422741832267012e-25,  2.438712035837279e-26,
 -1.227028366359738e-27,  5.642550339762053e-29, -2.365368112305596e-30,  9.183767408020365e-32, -3.348925172008152e-33,  1.146611964589503e-34, -3.679084845479829e-36,
  1.005535576359852e-01, -4.172260553346734e-04,  2.125733170740527e-06, -6.104171645304883e-10, -5.795200989116767e-11, -5.313729434711188e-12,  8.080334931611145e-14,
  3.731168433516431e-15, -7.556738512447311e-17, -2.687855899905718e-18,  6.922585626186279e-20,  1.880087618142755e-21,  7.293025766473490e-02, -3.070554083404710e-04,
  1.832699111983427e-06, -9.623960399321829e-09,  5.313802063347856e-11, -1.583404729153235e-12,  1.996117535302937e-14,  8.005995205380752e-16, -1.600386035065965e-17,
 -5.969738818236808e-19,  1.474304470155716e-20,  4.253107483474371e-22,  3.823417763507759e-02, -1.657388261030576e-04,  1.273085720813538e-06, -1.495160265661205e-08,
  1.336876664961461e-10,  1.480996710335252e-12, -2.906877419546104e-14, -1.615385347648421e-15,  3.256008253988363e-17,  1.128626667720193e-18, -2.958600215911919e-20,
 -7.844161658038524e-22,  1.438760058225288e-02, -6.515564915132976e-05,  6.624894354055015e-07, -1.149633816960941e-08,  1.161726466860718e-10,  1.786833404312081e-12,
 -3.213462054359357e-14, -1.795134494629841e-15,  3.564109764225003e-17,  1.261138152871070e-18, -3.230345486128748e-20, -8.871973534522601e-22,  3.843468276267359e-03,
 -1.845167332956241e-05,  2.461625322721708e-07, -5.313497419119340e-09,  5.792362731013934e-11,  8.697167350932036e-13, -1.540732474678660e-14, -9.248868993502520e-16,
  1.801443021524906e-17,  6.465799692375100e-19, -1.621069804132539e-20, -4.605475533778256e-22,  7.174467968074709e-04, -3.706018837013711e-06,  6.337930650801485e-08,
 -1.566405712561851e-09,  1.829067329682743e-11,  2.362506262411761e-13, -4.164970897867099e-15, -2.849471691727208e-16,  5.408372550649137e-18,  1.966135844125512e-19,
 -4.800167132919932e-21, -1.424016550437462e-22,  9.156781919101353e-05, -5.168296621303794e-07,  1.103484790293479e-08, -2.991724761162273e-10,  3.756059528661292e-12,
  3.695340985442531e-14, -6.453300693624873e-16, -5.567142597164151e-17,  1.021165964962748e-18,  3.741489932337180e-20, -8.828896894064057e-22, -2.775354944039733e-23,
  7.758333491627035e-06, -4.863765451568019e-08,  1.264644584303170e-09, -3.676696670373492e-11,  5.004480910747838e-13,  3.038314246693333e-15, -5.064232084139279e-17,
 -6.983233061517339e-18,  1.226598659524739e-19,  4.462673596456713e-21, -1.007713520447000e-22, -3.433213207103880e-24,  4.191964855168899e-07, -2.972357998042113e-09,
  9.211079436167424e-11, -2.839132826984162e-12,  4.236716689497754e-14,  7.423381312798439e-17, -6.708772880150040e-19, -5.582544570493962e-19,  9.323351747213652e-21,
  3.241348683989332e-22, -6.905235842895351e-24, -2.650914060944134e-25,  1.366167455618641e-08, -1.119088797497613e-10,  4.061197085895069e-12, -1.321865410330649e-13,
  2.192979886625307e-15, -6.711477990657813e-18,  1.900708707745019e-19, -2.789387492505920e-20,  4.444030109878391e-22,  1.342955842630745e-23, -2.633518779767059e-25,
 -1.235541619911325e-26,  2.479623268448133e-10, -2.409347883633333e-12,  1.010604375986251e-13, -3.480998939504349e-15,  6.534601756473577e-17, -5.475029518384985e-19,
  1.386442366541157e-20, -8.448240208640744e-22,  1.324263643820895e-23,  2.732515631250781e-25, -4.593103947529425e-27, -3.322133469507281e-28,  2.222293940569627e-12,
 -2.654956205405702e-14,  1.277427797661173e-15, -4.698921206528328e-17,  1.021911485517599e-18, -1.463170767331872e-20,  3.815270340627875e-22, -1.476358530629371e-23,
  2.456136506971228e-25,  1.396042662490062e-27, -4.098057090678469e-30, -4.959593535133867e-30,  8.076431562683481e-15, -1.253022531149635e-16,  6.921330933540428e-18,
 -2.774388117834200e-19,  7.235877731667337e-21, -1.535128303481868e-22,  4.342259256942945e-24, -1.358352178650586e-25,  2.666416600717288e-27, -2.746501416360495e-29,
  8.376754382671105e-31, -4.250377491911121e-32,  8.228567685765641e-18, -1.830677040506134e-19,  1.182996161685877e-20, -5.405954795659704e-22,  1.794346412600829e-23,
 -5.393949344985903e-25,  1.758545427605059e-26, -5.492573123773839e-28,  1.394069342693197e-29, -3.167374761708994e-31,  8.587871719667080e-33, -2.413264889186699e-34,
  9.543467960328057e-22, -3.926880612787990e-23,  3.235455656103295e-24, -1.925379147674081e-25,  9.361815755157542e-27, -4.216454539927971e-28,  1.806723718257742e-29,
 -7.125407375239591e-31,  2.570432556127863e-32, -8.751089293079199e-34,  2.866772339948521e-35, -8.872844774058472e-37,  9.891858690108202e-02, -4.002724921924001e-04,
  2.109762171820782e-06, -2.252806469046979e-09, -1.380836705947915e-10, -2.461375272802228e-12,  1.413409508365378e-13,  4.033281562599487e-16, -1.114002705634064e-16,
  7.568042286811509e-19,  7.876905941994410e-20, -1.331545452792731e-21,  7.173064528129032e-02, -2.928435168004928e-04,  1.721369961462292e-06, -8.994695564312495e-09,
  2.771010314050935e-11, -9.083142942321168e-13,  3.294001117382709e-14,  8.254936338771471e-17, -2.428888680604723e-17,  1.541439293795253e-19,  1.746929723167321e-20,
 -2.823055213091716e-22,  3.759050929293474e-02, -1.562335157250846e-04,  1.107319123693963e-06, -1.262641611698810e-08,  1.534013679369028e-10,  3.864662018634034e-13,
 -5.550423719262882e-14, -1.947703919311733e-16,  4.732722454389620e-17, -3.300545958040400e-19, -3.312717696600485e-20,  5.702162913901858e-22,  1.413675185267024e-02,
 -6.037358906076300e-05,  5.366893847625322e-07, -9.407919068204658e-09,  1.409325833232780e-10,  5.729516271423024e-13, -6.169429040685683e-14, -2.269200394635317e-16,
  5.252062684805733e-17, -3.530218145263849e-19, -3.701955106751570e-20,  6.212002765239656e-22,  3.773220132126340e-03, -1.672051243118526e-05,  1.884494276979384e-07,
 -4.275063455644594e-09,  6.993174772414192e-11,  2.706203041628889e-13, -3.078946938973464e-14, -1.270875196123963e-16,  2.683820413963987e-17, -1.741123402500029e-19,
 -1.899757451973834e-20,  3.111361104235569e-22,  7.035251817126488e-04, -3.268884773653204e-06,  4.647026298409087e-08, -1.243677976116126e-09,  2.149307071809282e-11,
  6.509214959324539e-14, -8.971650988539796e-15, -4.383576222253939e-17,  8.151813040885819e-18, -5.057154890847095e-20, -5.789111319938209e-21,  9.193448897857921e-23,
  8.965582766308203e-05, -4.418411220723807e-07,  7.825764311089590e-09, -2.344548782701592e-10,  4.237312955517099e-12,  7.408117160307304e-15, -1.602842384797931e-15,
 -9.877770534543276e-18,  1.556707818038476e-18, -9.119633364319733e-21, -1.106592450183470e-21,  1.687369657254459e-23,  7.581420260565589e-06, -4.014529317632962e-08,
  8.731164437617285e-10, -2.839662439739066e-11,  5.360243102649998e-13,  3.502226798686152e-17, -1.738875234626807e-16, -1.470527373907215e-18,  1.883313563331106e-19,
 -1.027854521548930e-21, -1.332464774692164e-22,  1.923931112745405e-24,  4.085814339788620e-07, -2.360142507582415e-09,  6.214180427208187e-11, -2.154847950587442e-12,
  4.263627838795078e-14, -8.729868929347222e-17, -1.085146988332901e-17, -1.427940036784303e-19,  1.422156015846303e-20, -7.175682778371271e-23, -9.882138669080139e-24,
  1.323074073356355e-25,  1.326980124871987e-08, -8.517754142590694e-11,  2.681212676268035e-12, -9.815665435417059e-14,  2.050969487433992e-15, -9.562479809737845e-18,
 -3.384960722949874e-19, -8.756133202821278e-21,  6.504537992273192e-22, -3.097740977676842e-24, -4.304088368822995e-25,  5.153933383354006e-27,  2.397014459187966e-10,
 -1.750929038250172e-12,  6.523919738358496e-14, -2.512066026977200e-15,  5.608684669461296e-17, -4.435018648701633e-19, -2.765951212432082e-21, -3.211572546830225e-22,
  1.727550522147435e-23, -8.615516499440358e-26, -1.010428045345369e-26,  9.974328157084928e-29,  2.133329749277480e-12, -1.832730089119041e-14,  8.032709669321820e-16,
 -3.260625173520787e-17,  7.921130787564414e-19, -9.511301916583063e-21,  8.343073444077159e-23, -6.476720558726750e-24,  2.531312782881342e-25, -1.668132139568488e-27,
 -1.070068475573690e-28,  6.063892452338532e-31,  7.667388742195100e-15, -8.148281284855303e-17,  4.200594737672181e-18, -1.816942784444086e-19,  4.946222976581664e-21,
 -8.605987818277778e-23,  1.612548978027289e-24, -6.293415484472587e-26,  1.921043777955616e-27, -2.112135864746880e-29, -2.420169636681485e-31, -5.269854731954882e-33,
  7.650460266804804e-18, -1.101895525359064e-19,  6.771310260636440e-21, -3.213090939829885e-22,  1.035334744180363e-23, -2.600970874710484e-25,  7.107762922585059e-27,
 -2.364708811668924e-28,  6.700177639812236e-30, -1.280495850372739e-31,  2.084240967648453e-33, -7.068516856244824e-35,  8.373144931424934e-22, -2.059638118929463e-23,
  1.606574803213490e-24, -9.207145918963180e-26,  4.029545080118453e-27, -1.572534507420449e-28,  6.118164996052854e-30, -2.318578660792222e-31,  7.960671463368673e-33,
 -2.470175996426011e-34,  7.417881874450839e-36, -2.244640740830031e-37,  9.735102545563595e-02, -3.835426408053864e-04,  2.068439108102468e-06, -4.674554826073038e-09,
 -1.543812974418831e-10,  7.070056392694398e-13,  1.103466433436613e-13, -2.260611584270375e-15, -4.557139749571763e-17,  2.351369846062195e-18, -1.584390204924244e-21,
 -1.709172642671910e-21,  7.058613870609967e-02, -2.794978690759438e-04,  1.615632007369569e-06, -8.654397369823846e-09,  1.721971788476102e-11, -1.686306050062981e-13,
  2.599097912550800e-14, -5.019298929856334e-16, -1.008422576607896e-17,  5.148451076465558e-19, -1.075514132468634e-22, -3.804253869821249e-22,  3.698239181945287e-02,
 -1.479391857741912e-04,  9.705511580648134e-07, -1.018153155180742e-08,  1.481771236639348e-10, -8.586122336777308e-13, -4.301938862230838e-14,  9.347319936933485e-16,
  1.929636060855249e-17, -9.950504404279031e-19,  8.622672369542619e-22,  7.178682850166728e-22,  1.390318413514812e-02, -5.649296986736817e-05,  4.374432504541071e-07,
 -7.140756659623282e-09,  1.379698694958041e-10, -8.144068889457016e-13, -4.808735882043895e-14,  1.031589481287726e-15,  2.164499269007846e-17, -1.104778877306886e-18,
  6.678189668093693e-22,  8.040406309824713e-22,  3.709055436601273e-03, -1.539894743965077e-05,  1.439113119350680e-07, -3.152589012766224e-09,  6.812688606859751e-11,
 -4.242112171476673e-13, -2.412059856972081e-14,  5.186555346569617e-16,  1.119015755916160e-17, -5.639807237180609e-19,  2.037408280099421e-22,  4.135562230014163e-22,
  6.911069352374951e-04, -2.950950201030149e-06,  3.361458782741159e-08, -9.009954973256456e-10,  2.068244496756115e-11, -1.385190199685587e-13, -7.082084944264771e-15,
  1.533343013287198e-16,  3.451497322114434e-18, -1.708984350495281e-19,  1.068120750465422e-23,  1.264026584264676e-22,  8.799748159640425e-05, -3.893386888618531e-07,
  5.417179737710946e-09, -1.675619801572802e-10,  4.005224406710158e-12, -2.931403345203508e-14, -1.281604173525648e-15,  2.803266966970217e-17,  6.727909308904399e-19,
 -3.248511230298374e-20, -1.012078869013851e-23,  2.426416609213661e-23,  7.432854826834135e-06, -3.437904318786240e-08,  5.830935323306039e-10, -2.004388742384445e-11,
  4.949135811214647e-13, -4.017137657409359e-15, -1.423434223880878e-16,  3.156242199364672e-18,  8.364767405743830e-20, -3.896152746177531e-21, -3.003468604829276e-24,
  2.940041894968737e-24,  3.999874419822101e-07, -1.955071507017857e-09,  4.027165524312200e-11, -1.501274326487586e-12,  3.820896912489727e-14, -3.490340360606194e-16,
 -9.322476177151622e-18,  2.104084934904860e-19,  6.546330595031874e-21, -2.895076510454656e-22, -3.787732863867818e-25,  2.202602825423296e-25,  1.296529506751850e-08,
 -6.789914826965290e-11,  1.692353933666345e-12, -6.735595184520189e-14,  1.769955097483218e-15, -1.848320895573136e-17, -3.290990244612866e-19,  7.600669463293478e-21,
  3.131846753601051e-22, -1.284875023191633e-23, -2.392228552762533e-26,  9.771281755735927e-27,  2.335712456442053e-10, -1.335047381740050e-12,  4.016856844232838e-14,
 -1.691238779649652e-15,  4.612612829189307e-17, -5.606592138413313e-19, -4.963473294456078e-21,  1.181433827710676e-22,  8.753696400893752e-24, -3.225797955312615e-25,
 -7.084313119821488e-28,  2.386898835673630e-28,  2.070680509689698e-12, -1.326477137255181e-14,  4.819828256892800e-16, -2.139162782701469e-17,  6.116173384742713e-19,
 -8.852036852965308e-21,  1.264881261701373e-24, -3.334167637881519e-26,  1.337738040462779e-25, -4.266734887187398e-27, -6.671236634685203e-30,  2.829783296905899e-30,
  7.396599274439290e-15, -5.537365745074749e-17,  2.443755493396905e-18, -1.147053584436439e-19,  3.501972240884212e-21, -6.232847102802050e-23,  5.834391996470401e-25,
 -1.541776537722716e-26,  1.008223731647201e-27, -2.743989816668420e-29,  5.491515277985307e-32,  1.231527326054322e-32,  7.297142109114409e-18, -6.897050823229533e-20,
  3.762670340640863e-21, -1.898677191738737e-22,  6.429804156113376e-24, -1.485367641720916e-25,  2.883966077962888e-27, -8.397629099434154e-29,  3.112381339791050e-30,
 -7.862652180177753e-32,  8.974901040141753e-34, -2.801396350746910e-37,  7.749230116032913e-22, -1.126353689467915e-23,  8.056298712234824e-25, -4.655894191712934e-26,
  1.947049472971234e-27, -6.609859518949019e-29,  2.174304110346982e-30, -7.703680837611342e-32,  2.676015711168752e-33, -8.063007941548732e-35,  2.105280893968042e-36,
 -5.464867427415361e-38,  };
  int offset = -15;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 15;
    if (std::isnan(t)) {
      fill_n(rr+offset, 15, 0.5);
      fill_n(ww+offset, 15, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 15; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;

      const double t2 = t * 2.0;
      for (int j=1; j <=15; ++j) {
        const int boxof = it*180+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
