------------------------------------------------------------------------------
--                                                                          --
--                     ASIS UTILITY LIBRARY COMPONENTS                      --
--                                                                          --
--                ASIS_UL.SOURCE_TABLE.PROCESSING.FINALIZE                  --
--                                                                          --
--                           (gnatsync version)                             --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                    Copyright (C) 2007-2008, AdaCore                      --
--                                                                          --
-- GNATSYNC  is  free  software;  you  can redistribute it and/or modify it --
-- under terms of the  GNU  General Public License as published by the Free --
-- Software Foundation;  either version 2, or ( at your option)  any  later --
-- version.  GNATCHECK  is  distributed in the hope that it will be useful, --
-- but  WITHOUT  ANY  WARRANTY;   without  even  the  implied  warranty  of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General --
-- Public License for more details.  You should have received a copy of the --
-- GNU  General Public License distributed with GNAT; see file  COPYING. If --
-- not,  write to the  Free Software Foundation,  51 Franklin Street, Fifth --
-- Floor, Boston, MA 02110-1301, USA.                                       --
--                                                                          --
-- GNATSYNC is maintained by AdaCore (http://www.adacore.com).              --
--                                                                          --
------------------------------------------------------------------------------

with ASIS_UL.Output;

with Gnatsync.Global_Info.Data; use Gnatsync.Global_Info.Data;
with Gnatsync.Threads;          use Gnatsync.Threads;

separate (ASIS_UL.Source_Table.Processing)
procedure Finalize is
begin

   Transitive_Closure;

   Compute_Task_Global_References;

   if Debug_Mode then
      Print_Global_Structure;
      Print_Threads_Debug_Info;
   end if;

   Generate_Report;
   ASIS_UL.Output.Close_Report_File;

   if Tool_Failures > 0 or else Debug_Mode then
      Info ("Total tool failures :" & Tool_Failures'Img);
   end if;

end Finalize;
