/*
 * Copyright (c) 2020, ARM Limited and Contributors. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <common/debug.h>
#include <drivers/console.h>
#include <lib/mmio.h>

#include <devapc.h>
#include <mtk_apusys_apc.h>

/* Infra_ao */
static const struct APC_INFRA_PERI_DOM_16 INFRA_AO_SYS0_Devices[] = {

/* 0 */
DAPC_INFRA_AO_SYS0_ATTR("MFG_S_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("MFG_S_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("MFG_S_S-2",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("MFG_S_S-3",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("MFG_S_S-4",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("MFG_S_S-5",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("MFG_S_S-6",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("MFG_S_S-7",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("MFG_S_S-8",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("APU_S_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 10 */
DAPC_INFRA_AO_SYS0_ATTR("APU_S_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("APU_S_S-2",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("APU_S_S-3",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("APU_S_S-4",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("APU_S_S-5",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("MCUSYS_CFGREG_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("MCUSYS_CFGREG_APB_S-1",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("MCUSYS_CFGREG_APB_S-2",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("MCUSYS_CFGREG_APB_S-3",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("MCUSYS_CFGREG_APB_S-4",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 20 */
DAPC_INFRA_AO_SYS0_ATTR("L3C_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("L3C_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS0_ATTR("PCIE_AXI_S",
			NO_PROTECTION, NO_PROTECTION, FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

};

static const struct APC_INFRA_PERI_DOM_4 INFRA_AO_SYS1_Devices[] = {

/* 0 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-2",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-3",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-4",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-5",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-6",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-7",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-8",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-9",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 10 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-10",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-11",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-12",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-13",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-14",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-15",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-16",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-17",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-18",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-19",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 20 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-20",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-21",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-22",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-23",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-24",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-25",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-26",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-27",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-28",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-29",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 30 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-30",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-31",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-32",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-33",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-34",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-35",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-36",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-37",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-38",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-39",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 40 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-100",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-101",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-102",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-103",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-104",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-105",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-106",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-107",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-108",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-109",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 50 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-110",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-111",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-112",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-113",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-114",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-115",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-116",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-117",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-118",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-119",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 60 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-120",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-121",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-122",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-123",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-124",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-125",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-126",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-127",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-128",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-129",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 70 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-130",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-131",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-132",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-133",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-134",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-135",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-136",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-137",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-138",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-139",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 80 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-140",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-141",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-142",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-143",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-200",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     NO_PROTECTION),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-201",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     NO_PROTECTION),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-202",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-203",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     NO_PROTECTION),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-204",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-205",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 90 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-206",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-207",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-300",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-301",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-302",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     NO_PROTECTION),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-303",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-304",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-305",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-306",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-307",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 100 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-400",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-401",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-402",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-403",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-404",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-405",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-406",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-407",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-408",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-409",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 110 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-410",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-411",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-412",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-413",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-414",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-415",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-416",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-417",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-418",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-419",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 120 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-420",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-421",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-422",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-423",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-424",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-425",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-426",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-427",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-428",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-429",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 130 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-430",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-431",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-432",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-433",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-434",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-435",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-436",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-437",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-438",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-439",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 140 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-440",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-441",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-442",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-443",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-444",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-445",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-446",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-447",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-448",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-449",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 150 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-450",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-451",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-452",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-453",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-454",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-455",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-456",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-457",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-458",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-459",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 160 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-460",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-461",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-462",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-463",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-464",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-465",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-466",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-467",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-468",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-469",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 170 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-470",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-471",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-472",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-473",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-474",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-475",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-476",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-477",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-478",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-479",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 180 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-480",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-481",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-482",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-483",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-484",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-485",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-486",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-487",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-488",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-489",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 190 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-490",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-491",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-492",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-493",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-494",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-495",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-496",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-497",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-498",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-499",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 200 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-500",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-501",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-502",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-503",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-504",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-505",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-506",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-507",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-508",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-509",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 210 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-510",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-511",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-512",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-513",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-514",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-515",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-516",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-517",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-518",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-519",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 220 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-520",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-521",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-522",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-523",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-524",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-525",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-526",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-527",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-528",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-529",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 230 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-530",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-531",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-532",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-533",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-534",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-535",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-536",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-537",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-538",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-539",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 240 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-540",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-541",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-542",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-543",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-544",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-545",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-546",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-547",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-548",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-549",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 250 */
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-550",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-551",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-552",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-553",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-554",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS1_ATTR("MM_S_S-555",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

};

static const struct APC_INFRA_PERI_DOM_4 INFRA_AO_SYS2_Devices[] = {

/* 0 */
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-556",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-557",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-558",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-559",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-560",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-561",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-562",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-563",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-564",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-565",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 10 */
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-566",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-567",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-568",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-569",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-570",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-571",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-572",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-573",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-574",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-575",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 20 */
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-576",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-577",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-578",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-579",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-580",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-581",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-582",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-583",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-584",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-585",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 30 */
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-586",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-587",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-588",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-589",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-590",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-591",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-592",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-593",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-594",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-595",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 40 */
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-600",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-601",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-602",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-603",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-604",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-605",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-606",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-607",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-608",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-609",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 50 */
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-610",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-611",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-700",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-701",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-702",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-703",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-704",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-705",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-706",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-707",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 60 */
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-708",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-709",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-710",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-711",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-712",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-713",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-714",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-715",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-716",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_INFRA_AO_SYS2_ATTR("MM_S_S-717",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

};

/* Peri_ao */
static const struct APC_INFRA_PERI_DOM_16 PERI_AO_SYS0_Devices[] = {

/* 0 */
DAPC_PERI_AO_SYS0_ATTR("SPM_APB_S",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("SPM_APB_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("SPM_APB_S-2",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("SPM_APB_S-3",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("SPM_APB_S-4",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("APMIXEDSYS_APB_S",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, NO_PROTECTION,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("APMIXEDSYS_APB_S-1",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("TOPCKGEN_APB_S",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, NO_PROTECTION,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("INFRACFG_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("INFRACFG_AO_MEM_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 10 */
DAPC_PERI_AO_SYS0_ATTR("PERICFG_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("GPIO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     NO_PROTECTION,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("TOPRGU_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("RESERVED_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DEVICE_APC_INFRA_AO_APB_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("BCRM_INFRA_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DEBUG_CTRL_INFRA_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DEVICE_APC_PERI_AO_APB_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("BCRM_PERI_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DEBUG_CTRL_PERI_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 20 */
DAPC_PERI_AO_SYS0_ATTR("AP_CIRQ_EINT_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("PMIC_WRAP_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DEVICE_APC_AO_MM_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("KP_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("TOP_MISC_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DVFSRC_APB_S",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("MBIST_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DPMAIF_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DEVICE_MPU_AO_APB_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("SYS_TIMER_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 30 */
DAPC_PERI_AO_SYS0_ATTR("MODEM_TEMP_SHARE_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DEVICE_APC_AO_MD_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("PMIF1_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("PMICSPI_MST_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("TIA_APB_S",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("TOPCKGEN_INFRA_CFG_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRM_DEBUG_TOP_APB_S",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-2",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 40 */
DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-3",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-4",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-5",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-6",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-7",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-8",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-9",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("PWR_MD32_S-10",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("AUDIO_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("AUDIO_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 50 */
DAPC_PERI_AO_SYS0_ATTR("SSUSB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("SSUSB_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("SSUSB_S-2",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("UFS_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("UFS_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("UFS_S-2",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("UFS_S-3",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DEBUGSYS_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_MD32_S0_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_MD32_S0_APB_S-1",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 60 */
DAPC_PERI_AO_SYS0_ATTR("DRAMC_MD32_S1_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_MD32_S1_APB_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("NOR_AXI_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("PCIE_AHB_S",
			NO_PROTECTION, NO_PROTECTION, FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH0_TOP0_APB_S",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH0_TOP1_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH0_TOP2_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH0_TOP3_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH0_TOP4_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH0_TOP5_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 70 */
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH0_TOP6_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH1_TOP0_APB_S",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH1_TOP1_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH1_TOP2_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH1_TOP3_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH1_TOP4_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH1_TOP5_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH1_TOP6_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH2_TOP0_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH2_TOP1_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 80 */
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH2_TOP2_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH2_TOP3_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH2_TOP4_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH2_TOP5_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH2_TOP6_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH3_TOP0_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH3_TOP1_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH3_TOP2_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH3_TOP3_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH3_TOP4_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 90 */
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH3_TOP5_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DRAMC_CH3_TOP6_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("CCIF2_AP_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("CCIF2_MD_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("CCIF3_AP_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("CCIF3_MD_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("CCIF4_AP_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("CCIF4_MD_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("INFRA_BUS_TRACE_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("CCIF5_AP_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 100 */
DAPC_PERI_AO_SYS0_ATTR("CCIF5_MD_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("SSC_INFRA_APB0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("SSC_INFRA_APB1_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("SSC_INFRA_APB2_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS0_ATTR("DEVICE_MPU_ACP_APB_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

};

static const struct APC_INFRA_PERI_DOM_8 PERI_AO_SYS1_Devices[] = {

/* 0 */
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-2",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-3",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-4",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-5",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-6",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-7",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-8",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-9",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 10 */
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-10",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-11",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-12",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-13",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-14",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-15",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-16",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-17",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-18",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-19",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 20 */
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-20",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-21",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("TINSYS_S-22",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-2",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-3",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-4",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-5",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-6",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 30 */
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-7",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-8",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-9",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-10",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-11",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-12",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-13",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-14",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-15",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-16",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 40 */
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-17",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-18",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-19",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-20",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-21",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-22",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-23",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-24",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-25",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-26",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 50 */
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-27",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-28",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-29",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-30",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-31",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-32",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-33",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-34",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-35",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-36",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 60 */
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-37",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-38",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-39",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-40",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-41",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO_SYS1_ATTR("MD_AP_S-42",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

};

static const struct APC_INFRA_PERI_DOM_4 PERI_AO_SYS2_Devices[] = {

/* 0 */
DAPC_PERI_AO_SYS2_ATTR("CONN_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

};

/* Peri_ao2 */
static const struct APC_INFRA_PERI_DOM_16 PERI_AO2_SYS0_Devices[] = {

/* 0 */
DAPC_PERI_AO2_SYS0_ATTR("EFUSE_DEBUG_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("APXGPT_APB_S",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("SEJ_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("AES_TOP0_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("SECURITY_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("DEVICE_APC_PERI_AO2_APB_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BCRM_PERI_AO2_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("DEBUG_CTRL_PERI_AO2_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("SPMI_MST_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("DEBUG_CTRL_FMEM_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 10 */
DAPC_PERI_AO2_SYS0_ATTR("BCRM_FMEM_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("DEVICE_APC_FMEM_AO_APB_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("PWM_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("GCE_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("GCE_APB_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("GCE_APB_S-2",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("GCE_APB_S-3",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("DPMAIF_PDN_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("DPMAIF_PDN_APB_S-1",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("DPMAIF_PDN_APB_S-2",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 20 */
DAPC_PERI_AO2_SYS0_ATTR("DPMAIF_PDN_APB_S-3",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_APB0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_APB1_S",
			NO_PROTECTION, FORBIDDEN,     SEC_RW_NS_R,   FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_APB2_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_APB3_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_APB4_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_APB5_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_APB6_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_APB7_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_APB8_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 30 */
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_APB9_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_APB10_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_APB11_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_APB12_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_APB13_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_APB14_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_APB15_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_WEST_APB0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_WEST_APB1_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_WEST_APB2_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 40 */
DAPC_PERI_AO2_SYS0_ATTR("BND_WEST_APB3_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_WEST_APB4_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_WEST_APB5_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_WEST_APB6_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_WEST_APB7_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_NORTH_APB0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_NORTH_APB1_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_NORTH_APB2_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_NORTH_APB3_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_NORTH_APB4_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 50 */
DAPC_PERI_AO2_SYS0_ATTR("BND_NORTH_APB5_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_NORTH_APB6_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_NORTH_APB7_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_NORTH_APB8_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_NORTH_APB9_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_NORTH_APB10_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_NORTH_APB11_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_NORTH_APB12_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_NORTH_APB13_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_NORTH_APB14_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 60 */
DAPC_PERI_AO2_SYS0_ATTR("BND_NORTH_APB15_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_SOUTH_APB0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_SOUTH_APB1_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_SOUTH_APB2_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_SOUTH_APB3_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_SOUTH_APB4_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_SOUTH_APB5_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_SOUTH_APB6_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_SOUTH_APB7_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_SOUTH_APB8_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 70 */
DAPC_PERI_AO2_SYS0_ATTR("BND_SOUTH_APB9_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_SOUTH_APB10_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_SOUTH_APB11_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_SOUTH_APB12_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_SOUTH_APB13_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_SOUTH_APB14_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_SOUTH_APB15_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_NORTH_APB0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_NORTH_APB1_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_NORTH_APB2_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 80 */
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_NORTH_APB3_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_NORTH_APB4_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_NORTH_APB5_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_NORTH_APB6_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BND_EAST_NORTH_APB7_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("SYS_CIRQ_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("EFUSE_DEBUG_PDN_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("DEVICE_APC_INFRA_PDN_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("DEBUG_TRACKER_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("CCIF0_AP_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 90 */
DAPC_PERI_AO2_SYS0_ATTR("CCIF0_MD_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("CCIF1_AP_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("CCIF1_MD_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("MBIST_PDN_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("INFRACFG_PDN_APB_S",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("TRNG_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("DX_CC_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("CQ_DMA_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("SRAMROM_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("INFRACFG_MEM_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 100 */
DAPC_PERI_AO2_SYS0_ATTR("RESERVED_DVFS_PROC_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("SYS_CIRQ1_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("SYS_CIRQ2_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("DEBUG_TRACKER_APB1_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("EMI_APB_S",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("EMI_MPU_APB_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("DEVICE_MPU_PDN_APB_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("APDMA_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("DEBUG_TRACKER_APB2_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BCRM_INFRA_PDN_APB_S",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 110 */
DAPC_PERI_AO2_SYS0_ATTR("BCRM_PERI_PDN_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BCRM_PERI_PDN2_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("DEVICE_APC_PERI_PDN_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("DEVICE_APC_PERI_PDN2_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_AO2_SYS0_ATTR("BCRM_FMEM_PDN_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

};

/* Peri_par_ao */
static const struct APC_INFRA_PERI_DOM_16 PERI_PAR_AO_SYS0_Devices[] = {

/* 0 */
DAPC_PERI_PAR_AO_SYS0_ATTR("AUXADC_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("UART0_APB_S",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("UART1_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("UART2_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("IIC_P2P_REMAP_APB4_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("SPI0_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("PTP_THERM_CTRL_APB_S",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("BTIF_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("DISP_PWM_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("SPI1_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 10 */
DAPC_PERI_PAR_AO_SYS0_ATTR("SPI2_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("SPI3_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("IIC_P2P_REMAP_APB0_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("IIC_P2P_REMAP_APB1_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("SPI4_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("SPI5_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("IIC_P2P_REMAP_APB2_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("IIC_P2P_REMAP_APB3_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("SPI6_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("SPI7_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

/* 20 */
DAPC_PERI_PAR_AO_SYS0_ATTR("BCRM_PERI_PAR_PDN_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("DEVICE_APC_PERI_PAR_PDN_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("PTP_THERM_CTRL2_APB_S",
			NO_PROTECTION, FORBIDDEN,     NO_PROTECTION, FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("NOR_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("DEVICE_APC_PERI_PAR_AO_APB_S",
			SEC_RW_ONLY,   FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("DEBUG_CTRL_PERI_PAR_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),
DAPC_PERI_PAR_AO_SYS0_ATTR("BCRM_PERI_PAR_AO_APB_S",
			NO_PROTECTION, FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN,
			FORBIDDEN,     FORBIDDEN,     FORBIDDEN,     FORBIDDEN),

};

static void set_module_apc(enum DEVAPC_SLAVE_TYPE slave_type,
		uint32_t module, enum DOMAIN_ID domain_id,
		enum DEVAPC_PERM_TYPE perm)
{
	uint32_t apc_register_index;
	uint32_t apc_set_index;
	uintptr_t base = 0, reg;
	uint32_t clr_bit;
	uint32_t set_bit;

	apc_register_index = module / MOD_NO_IN_1_DEVAPC;
	apc_set_index = module % MOD_NO_IN_1_DEVAPC;

	clr_bit = (0x3U << (apc_set_index * 2));
	set_bit = (uint32_t)perm << (apc_set_index * 2);

	/* infra_ao */
	if ((slave_type == SLAVE_TYPE_INFRA_AO_SYS0) &&
		(module < SLAVE_NUM_INFRA_AO_SYS0) &&
		(domain_id < (uint32_t)DOM_NUM_INFRA_AO_SYS0)) {
		base = DEVAPC_INFRA_AO_SYS0_D0_APC_0;

	} else if ((slave_type == SLAVE_TYPE_INFRA_AO_SYS1) &&
		(module < SLAVE_NUM_INFRA_AO_SYS1) &&
		(domain_id < (uint32_t)DOM_NUM_INFRA_AO_SYS1)) {
		base = DEVAPC_INFRA_AO_SYS1_D0_APC_0;

	} else if ((slave_type == SLAVE_TYPE_INFRA_AO_SYS2) &&
		(module < SLAVE_NUM_INFRA_AO_SYS2) &&
		(domain_id < (uint32_t)DOM_NUM_INFRA_AO_SYS2)) {
		base = DEVAPC_INFRA_AO_SYS2_D0_APC_0;
	/* peri_ao */
	} else if ((slave_type == SLAVE_TYPE_PERI_AO_SYS0) &&
		(module < SLAVE_NUM_PERI_AO_SYS0) &&
		(domain_id < (uint32_t)DOM_NUM_PERI_AO_SYS0)) {
		base = DEVAPC_PERI_AO_SYS0_D0_APC_0;

	} else if ((slave_type == SLAVE_TYPE_PERI_AO_SYS1) &&
		(module < SLAVE_NUM_PERI_AO_SYS1) &&
		(domain_id <= (uint32_t)DOM_NUM_PERI_AO_SYS1)) {
		base = DEVAPC_PERI_AO_SYS1_D0_APC_0;

	} else if ((slave_type == SLAVE_TYPE_PERI_AO_SYS2) &&
		(module < SLAVE_NUM_PERI_AO_SYS2) &&
		(domain_id < (uint32_t)DOM_NUM_PERI_AO_SYS2)) {
		base = DEVAPC_PERI_AO_SYS2_D0_APC_0;
	/* peri_ao2 */
	} else if ((slave_type == SLAVE_TYPE_PERI_AO2_SYS0) &&
		(module < SLAVE_NUM_PERI_AO2_SYS0) &&
		(domain_id < (uint32_t)DOM_NUM_PERI_AO2_SYS0)) {
		base = DEVAPC_PERI_AO2_SYS0_D0_APC_0;

	/* peri_par_ao */
	} else if ((slave_type == SLAVE_TYPE_PERI_PAR_AO_SYS0) &&
		(module < SLAVE_NUM_PERI_PAR_AO_SYS0) &&
		(domain_id < (uint32_t)DOM_NUM_PERI_PAR_AO_SYS0)) {
		base = DEVAPC_PERI_PAR_AO_SYS0_D0_APC_0;

	} else {
		ERROR("[DEVAPC] %s: %s, %s:0x%x, %s:0x%x, %s:0x%x\n",
				__func__, "out of boundary",
				"slave_type", slave_type,
				"module", module,
				"domain_id", domain_id);
	}

	if (base != 0U) {
		reg = base + domain_id * 0x40 + apc_register_index * 4;
		mmio_clrsetbits_32(reg, clr_bit, set_bit);
	}
}

static void dump_infra_ao_apc(void)
{
	int reg_num;
	int d, i;

	reg_num = (SLAVE_NUM_INFRA_AO_SYS0 - 1) / MOD_NO_IN_1_DEVAPC;
	for (d = 0; d < DOM_NUM_INFRA_AO_SYS0; d++) {
		for (i = 0; i <= reg_num; i++) {
			INFO("[DEVAPC] (INFRA_AO_SYS0)D%d_APC_%d: 0x%x\n",
					d, i, devapc_readl(
					DEVAPC_INFRA_AO_SYS0_D0_APC_0 +
					d * 0x40 + i * 4)
			);
		}
	}

	reg_num = (SLAVE_NUM_INFRA_AO_SYS1 - 1) / MOD_NO_IN_1_DEVAPC;
	for (d = 0; d < DOM_NUM_INFRA_AO_SYS1; d++) {
		for (i = 0; i <= reg_num; i++) {
			INFO("[DEVAPC] (INFRA_AO_SYS1)D%d_APC_%d: 0x%x\n",
					d, i, devapc_readl(
					DEVAPC_INFRA_AO_SYS1_D0_APC_0 +
					d * 0x40 + i * 4)
			);
		}
	}

	reg_num = (SLAVE_NUM_INFRA_AO_SYS2 - 1) / MOD_NO_IN_1_DEVAPC;
	for (d = 0; d < DOM_NUM_INFRA_AO_SYS2; d++) {
		for (i = 0; i <= reg_num; i++) {
			INFO("[DEVAPC] (INFRA_AO_SYS2)D%d_APC_%d: 0x%x\n",
					d, i, devapc_readl(
					DEVAPC_INFRA_AO_SYS2_D0_APC_0 +
					d * 0x40 + i * 4)
			);
		}
	}

	INFO("[DEVAPC] (INFRA_AO)MAS_SEC_0: 0x%x\n",
		devapc_readl(DEVAPC_INFRA_AO_MAS_SEC_0));
}

static void dump_peri_ao_apc(void)
{
	int reg_num;
	int d, i;

	reg_num = (SLAVE_NUM_PERI_AO_SYS0 - 1) / MOD_NO_IN_1_DEVAPC;
	for (d = 0; d < DOM_NUM_PERI_AO_SYS0; d++) {
		for (i = 0; i <= reg_num; i++) {
			INFO("[DEVAPC] (PERI_AO_SYS0)D%d_APC_%d: 0x%x\n",
					d, i, devapc_readl(
					DEVAPC_PERI_AO_SYS0_D0_APC_0 +
					d * 0x40 + i * 4)
			);
		}
	}

	reg_num = (SLAVE_NUM_PERI_AO_SYS1 - 1) / MOD_NO_IN_1_DEVAPC;
	for (d = 0; d < DOM_NUM_PERI_AO_SYS1; d++) {
		for (i = 0; i <= reg_num; i++) {
			INFO("[DEVAPC] (PERI_AO_SYS1)D%d_APC_%d: 0x%x\n",
					d, i, devapc_readl(
					DEVAPC_PERI_AO_SYS1_D0_APC_0 +
					d * 0x40 + i * 4)
			);
		}
	}

	reg_num = (SLAVE_NUM_PERI_AO_SYS2 - 1) / MOD_NO_IN_1_DEVAPC;
	for (d = 0; d < DOM_NUM_PERI_AO_SYS2; d++) {
		for (i = 0; i <= reg_num; i++) {
			INFO("[DEVAPC] (PERI_AO_SYS2)D%d_APC_%d: 0x%x\n",
					d, i, devapc_readl(
					DEVAPC_PERI_AO_SYS2_D0_APC_0 +
					d * 0x40 + i * 4)
			);
		}
	}

	INFO("[DEVAPC] (PERI_AO)MAS_SEC_0: 0x%x\n",
		devapc_readl(DEVAPC_PERI_AO_MAS_SEC_0));
}

static void dump_peri_ao2_apc(void)
{
	int reg_num;
	int d, i;

	reg_num = (SLAVE_NUM_PERI_AO2_SYS0 - 1) / MOD_NO_IN_1_DEVAPC;
	for (d = 0; d < DOM_NUM_PERI_AO2_SYS0; d++) {
		for (i = 0; i <= reg_num; i++) {
			INFO("[DEVAPC] (PERI_AO2_SYS0)D%d_APC_%d: 0x%x\n",
					d, i, devapc_readl(
					DEVAPC_PERI_AO2_SYS0_D0_APC_0 +
					d * 0x40 + i * 4)
			);
		}
	}
}

static void dump_peri_par_ao_apc(void)
{
	int reg_num;
	int d, i;

	reg_num = (SLAVE_NUM_PERI_PAR_AO_SYS0 - 1) / MOD_NO_IN_1_DEVAPC;
	for (d = 0; d < DOM_NUM_PERI_PAR_AO_SYS0; d++) {
		for (i = 0; i <= reg_num; i++) {
			INFO("[DEVAPC] (PERI_PAR_AO_SYS0)D%d_APC_%d: 0x%x\n",
					d, i, devapc_readl(
					DEVAPC_PERI_PAR_AO_SYS0_D0_APC_0 +
					d * 0x40 + i * 4)
			);
		}
	}

	INFO("[DEVAPC] (PERI_PAR_AO)MAS_SEC_0: 0x%x\n",
		devapc_readl(DEVAPC_PERI_PAR_AO_MAS_SEC_0));
}

static void set_infra_ao_apc(void)
{
	uint32_t infra_ao_size;
	uint32_t i;

	infra_ao_size = ARRAY_SIZE(INFRA_AO_SYS0_Devices);

	for (i = 0; i < infra_ao_size; i++) {
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS0, i, DOMAIN_0,
				INFRA_AO_SYS0_Devices[i].d0_permission);		/* APMCU */
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS0, i, DOMAIN_1,
				INFRA_AO_SYS0_Devices[i].d1_permission);
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS0, i, DOMAIN_2,
				INFRA_AO_SYS0_Devices[i].d2_permission);
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS0, i, DOMAIN_3,
				INFRA_AO_SYS0_Devices[i].d3_permission);
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS0, i, DOMAIN_4,
				INFRA_AO_SYS0_Devices[i].d4_permission);
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS0, i, DOMAIN_5,
				INFRA_AO_SYS0_Devices[i].d5_permission);
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS0, i, DOMAIN_6,
				INFRA_AO_SYS0_Devices[i].d6_permission);
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS0, i, DOMAIN_7,
				INFRA_AO_SYS0_Devices[i].d7_permission);
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS0, i, DOMAIN_8,
				INFRA_AO_SYS0_Devices[i].d8_permission);
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS0, i, DOMAIN_9,
				INFRA_AO_SYS0_Devices[i].d9_permission);
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS0, i, DOMAIN_10,
				INFRA_AO_SYS0_Devices[i].d10_permission);
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS0, i, DOMAIN_11,
				INFRA_AO_SYS0_Devices[i].d11_permission);
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS0, i, DOMAIN_12,
				INFRA_AO_SYS0_Devices[i].d12_permission);
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS0, i, DOMAIN_13,
				INFRA_AO_SYS0_Devices[i].d13_permission);
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS0, i, DOMAIN_14,
				INFRA_AO_SYS0_Devices[i].d14_permission);
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS0, i, DOMAIN_15,
				INFRA_AO_SYS0_Devices[i].d15_permission);
	}

	infra_ao_size = ARRAY_SIZE(INFRA_AO_SYS1_Devices);

	for (i = 0; i < infra_ao_size; i++) {
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS1, i, DOMAIN_0,
				INFRA_AO_SYS1_Devices[i].d0_permission);		/* APMCU */
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS1, i, DOMAIN_1,
				INFRA_AO_SYS1_Devices[i].d1_permission);
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS1, i, DOMAIN_2,
				INFRA_AO_SYS1_Devices[i].d2_permission);
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS1, i, DOMAIN_3,
				INFRA_AO_SYS1_Devices[i].d3_permission);
	}

	infra_ao_size = ARRAY_SIZE(INFRA_AO_SYS2_Devices);

	for (i = 0; i < infra_ao_size; i++) {
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS2, i, DOMAIN_0,
				INFRA_AO_SYS2_Devices[i].d0_permission);		/* APMCU */
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS2, i, DOMAIN_1,
				INFRA_AO_SYS2_Devices[i].d1_permission);
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS2, i, DOMAIN_2,
				INFRA_AO_SYS2_Devices[i].d2_permission);
		set_module_apc(SLAVE_TYPE_INFRA_AO_SYS2, i, DOMAIN_3,
				INFRA_AO_SYS2_Devices[i].d3_permission);
	}
}

static void set_peri_ao_apc(void)
{
	uint32_t peri_ao_size;
	uint32_t i;

	peri_ao_size = ARRAY_SIZE(PERI_AO_SYS0_Devices);

	for (i = 0; i < peri_ao_size; i++) {
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS0, i, DOMAIN_0,
				PERI_AO_SYS0_Devices[i].d0_permission);			/* APMCU */
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS0, i, DOMAIN_1,
				PERI_AO_SYS0_Devices[i].d1_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS0, i, DOMAIN_2,
				PERI_AO_SYS0_Devices[i].d2_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS0, i, DOMAIN_3,
				PERI_AO_SYS0_Devices[i].d3_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS0, i, DOMAIN_4,
				PERI_AO_SYS0_Devices[i].d4_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS0, i, DOMAIN_5,
				PERI_AO_SYS0_Devices[i].d5_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS0, i, DOMAIN_6,
				PERI_AO_SYS0_Devices[i].d6_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS0, i, DOMAIN_7,
				PERI_AO_SYS0_Devices[i].d7_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS0, i, DOMAIN_8,
				PERI_AO_SYS0_Devices[i].d8_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS0, i, DOMAIN_9,
				PERI_AO_SYS0_Devices[i].d9_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS0, i, DOMAIN_10,
				PERI_AO_SYS0_Devices[i].d10_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS0, i, DOMAIN_11,
				PERI_AO_SYS0_Devices[i].d11_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS0, i, DOMAIN_12,
				PERI_AO_SYS0_Devices[i].d12_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS0, i, DOMAIN_13,
				PERI_AO_SYS0_Devices[i].d13_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS0, i, DOMAIN_14,
				PERI_AO_SYS0_Devices[i].d14_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS0, i, DOMAIN_15,
				PERI_AO_SYS0_Devices[i].d15_permission);
	}

	peri_ao_size = ARRAY_SIZE(PERI_AO_SYS1_Devices);

	for (i = 0; i < peri_ao_size; i++) {
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS1, i, DOMAIN_0,
				PERI_AO_SYS1_Devices[i].d0_permission);			/* APMCU */
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS1, i, DOMAIN_1,
				PERI_AO_SYS1_Devices[i].d1_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS1, i, DOMAIN_2,
				PERI_AO_SYS1_Devices[i].d2_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS1, i, DOMAIN_3,
				PERI_AO_SYS1_Devices[i].d3_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS1, i, DOMAIN_4,
				PERI_AO_SYS1_Devices[i].d4_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS1, i, DOMAIN_5,
				PERI_AO_SYS1_Devices[i].d5_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS1, i, DOMAIN_6,
				PERI_AO_SYS1_Devices[i].d6_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS1, i, DOMAIN_7,
				PERI_AO_SYS1_Devices[i].d7_permission);
	}

	peri_ao_size = ARRAY_SIZE(PERI_AO_SYS2_Devices);

	for (i = 0; i < peri_ao_size; i++) {
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS2, i, DOMAIN_0,
				PERI_AO_SYS2_Devices[i].d0_permission);			/* APMCU */
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS2, i, DOMAIN_1,
				PERI_AO_SYS2_Devices[i].d1_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS2, i, DOMAIN_2,
				PERI_AO_SYS2_Devices[i].d2_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO_SYS2, i, DOMAIN_3,
				PERI_AO_SYS2_Devices[i].d3_permission);
	}
}

static void set_peri_ao2_apc(void)
{
	uint32_t peri_ao2_size;
	uint32_t i;

	peri_ao2_size = ARRAY_SIZE(PERI_AO2_SYS0_Devices);

	for (i = 0; i < peri_ao2_size; i++) {
		set_module_apc(SLAVE_TYPE_PERI_AO2_SYS0, i, DOMAIN_0,
				PERI_AO2_SYS0_Devices[i].d0_permission);		/* APMCU */
		set_module_apc(SLAVE_TYPE_PERI_AO2_SYS0, i, DOMAIN_1,
				PERI_AO2_SYS0_Devices[i].d1_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO2_SYS0, i, DOMAIN_2,
				PERI_AO2_SYS0_Devices[i].d2_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO2_SYS0, i, DOMAIN_3,
				PERI_AO2_SYS0_Devices[i].d3_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO2_SYS0, i, DOMAIN_4,
				PERI_AO2_SYS0_Devices[i].d4_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO2_SYS0, i, DOMAIN_5,
				PERI_AO2_SYS0_Devices[i].d5_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO2_SYS0, i, DOMAIN_6,
				PERI_AO2_SYS0_Devices[i].d6_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO2_SYS0, i, DOMAIN_7,
				PERI_AO2_SYS0_Devices[i].d7_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO2_SYS0, i, DOMAIN_8,
				PERI_AO2_SYS0_Devices[i].d8_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO2_SYS0, i, DOMAIN_9,
				PERI_AO2_SYS0_Devices[i].d9_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO2_SYS0, i, DOMAIN_10,
				PERI_AO2_SYS0_Devices[i].d10_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO2_SYS0, i, DOMAIN_11,
				PERI_AO2_SYS0_Devices[i].d11_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO2_SYS0, i, DOMAIN_12,
				PERI_AO2_SYS0_Devices[i].d12_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO2_SYS0, i, DOMAIN_13,
				PERI_AO2_SYS0_Devices[i].d13_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO2_SYS0, i, DOMAIN_14,
				PERI_AO2_SYS0_Devices[i].d14_permission);
		set_module_apc(SLAVE_TYPE_PERI_AO2_SYS0, i, DOMAIN_15,
				PERI_AO2_SYS0_Devices[i].d15_permission);
	}
}

static void set_peri_par_ao_apc(void)
{
	uint32_t peri_par_ao_size;
	uint32_t i;

	peri_par_ao_size = ARRAY_SIZE(PERI_PAR_AO_SYS0_Devices);

	for (i = 0; i < peri_par_ao_size; i++) {
		set_module_apc(SLAVE_TYPE_PERI_PAR_AO_SYS0, i, DOMAIN_0,
				PERI_PAR_AO_SYS0_Devices[i].d0_permission);		/* APMCU */
		set_module_apc(SLAVE_TYPE_PERI_PAR_AO_SYS0, i, DOMAIN_1,
				PERI_PAR_AO_SYS0_Devices[i].d1_permission);
		set_module_apc(SLAVE_TYPE_PERI_PAR_AO_SYS0, i, DOMAIN_2,
				PERI_PAR_AO_SYS0_Devices[i].d2_permission);
		set_module_apc(SLAVE_TYPE_PERI_PAR_AO_SYS0, i, DOMAIN_3,
				PERI_PAR_AO_SYS0_Devices[i].d3_permission);
		set_module_apc(SLAVE_TYPE_PERI_PAR_AO_SYS0, i, DOMAIN_4,
				PERI_PAR_AO_SYS0_Devices[i].d4_permission);
		set_module_apc(SLAVE_TYPE_PERI_PAR_AO_SYS0, i, DOMAIN_5,
				PERI_PAR_AO_SYS0_Devices[i].d5_permission);
		set_module_apc(SLAVE_TYPE_PERI_PAR_AO_SYS0, i, DOMAIN_6,
				PERI_PAR_AO_SYS0_Devices[i].d6_permission);
		set_module_apc(SLAVE_TYPE_PERI_PAR_AO_SYS0, i, DOMAIN_7,
				PERI_PAR_AO_SYS0_Devices[i].d7_permission);
		set_module_apc(SLAVE_TYPE_PERI_PAR_AO_SYS0, i, DOMAIN_8,
				PERI_PAR_AO_SYS0_Devices[i].d8_permission);
		set_module_apc(SLAVE_TYPE_PERI_PAR_AO_SYS0, i, DOMAIN_9,
				PERI_PAR_AO_SYS0_Devices[i].d9_permission);
		set_module_apc(SLAVE_TYPE_PERI_PAR_AO_SYS0, i, DOMAIN_10,
				PERI_PAR_AO_SYS0_Devices[i].d10_permission);
		set_module_apc(SLAVE_TYPE_PERI_PAR_AO_SYS0, i, DOMAIN_11,
				PERI_PAR_AO_SYS0_Devices[i].d11_permission);
		set_module_apc(SLAVE_TYPE_PERI_PAR_AO_SYS0, i, DOMAIN_12,
				PERI_PAR_AO_SYS0_Devices[i].d12_permission);
		set_module_apc(SLAVE_TYPE_PERI_PAR_AO_SYS0, i, DOMAIN_13,
				PERI_PAR_AO_SYS0_Devices[i].d13_permission);
		set_module_apc(SLAVE_TYPE_PERI_PAR_AO_SYS0, i, DOMAIN_14,
				PERI_PAR_AO_SYS0_Devices[i].d14_permission);
		set_module_apc(SLAVE_TYPE_PERI_PAR_AO_SYS0, i, DOMAIN_15,
				PERI_PAR_AO_SYS0_Devices[i].d15_permission);
	}
}

static void set_extra_apc(void)
{
#ifdef MTK_DEBUGSYS_LOCK
	/* Block debugsys to avoid privilege escalation (user load only) */
	set_module_apc(SLAVE_TYPE_PERI_AO_SYS0, DEVAPC_DEBUGSYS_INDEX,
			DOMAIN_0, SEC_RW_NS_R);
#endif
}

void devapc_init(void)
{
	/* Initial Permission */
	set_infra_ao_apc();
	set_peri_ao_apc();
	set_peri_ao2_apc();
	set_peri_par_ao_apc();

	/* Extra Permission */
	set_extra_apc();

	/* Dump Permission */
	dump_infra_ao_apc();
	dump_peri_ao_apc();
	dump_peri_ao2_apc();
	dump_peri_par_ao_apc();

	/* Setup APUSYS Permission */
	set_apusys_apc();

	INFO("[DEVAPC] %s done\n", __func__);
}
