Occitan and French (`apertium-oci-fra`)
===============================================================================

This is an Apertium language pair for translating between Occitan and
French. What you can use this language package for:

* Translating between Occitan and French
* Morphological analysis of Occitan and French
* Part-of-speech tagging of Occitan and French

For information on the latter two points, see subheading "For more
information" below

Requirements
===============================================================================

You will need the following software installed:

* lttoolbox (>= 3.3.0)
* apertium (>= 3.3.0)
* vislcg3 (>= 0.9.9.10297)
* apertium-oci
* apertium-fra

If this does not make any sense, we recommend you look at: www.apertium.org

Compiling
===============================================================================

Given the requirements being installed, you should be able to just run:

$ ./configure
$ make
# make install

You can use ./autogen.sh instead of ./configure you're compiling from
SVN. If you installed any prerequisite language packages using a --prefix
to ./configure, make sure to give the same --prefix to ./configure here.

Testing
===============================================================================

If you are in the source directory after running make, the following
commands should work:

$  echo "TODO test sentence 1" | apertium -d . oci-fra
TODO test translated sentence 1

$ echo "TODO test sentence 2" | apertium -d . fra-oci
TODO test translated sentence 2

After installing somewhere in $PATH, you should be able to do e.g.

$  echo "TODO test sentence 1" | apertium oci-fra
TODO test translated sentence 1

Files and data
===============================================================================

* apertium-oci-fra.oci-fra.dix  - Bilingual dictionary
* apertium-oci-fra.oci-fra.t1x  - Chunking rules for translating into Occitan
* apertium-oci-fra.fra-oci.t1x  - Chunking rules for translating into French
* apertium-oci-fra.oci-fra.t2x  - Interchunk rules for translating into Occitan
* apertium-oci-fra.fra-oci.t2x  - Interchunk rules for translating into French
* apertium-oci-fra.oci-fra.t3x  - Postchunk rules for translating into Occitan
* apertium-oci-fra.fra-oci.t3x  - Postchunk rules for translating into French
* apertium-oci-fra.oci-fra.lrx  - Lexical selection rules for translating into Occitan
* apertium-oci-fra.fra-oci.lrx  - Lexical selection rules for translating into French
* modes.xml                     - Translation modes

For more information
===============================================================================

* http://wiki.apertium.org/wiki/Installation
* http://wiki.apertium.org/wiki/apertium-oci-fra
* http://wiki.apertium.org/wiki/Using_an_lttoolbox_dictionary

Help and support
===============================================================================

If you need help using this language pair or data, you can contact:

* Mailing list: apertium-stuff@lists.sourceforge.net
* IRC: #apertium on irc.freenode.net

See also the file AUTHORS included in this distribution.
