!{\src2tex{textfont=tt}}
!!****f* ABINIT/pre_scatter
!!
!! NAME
!!  pre_scatter
!!
!! FUNCTION
!!  Scatters data among FFT processors.
!!
!! COPYRIGHT
!!  Copyright (C) 2007-2014 ABINIT group (?,YP)
!!  This file is distributed under the terms of the
!!  GNU General Public License, see ~abinit/COPYING
!!  or http://www.gnu.org/copyleft/gpl.txt .
!!  For the initials of contributors, see
!!  ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  n1,n2,n3= FFT grid dimensions
!!  n4= n3/mpi_enreg%nproc_fft
!!  array_allgather= data to scatter among FFT procs
!!
!! OUTPUT
!!  array= scattered data
!!
!! SIDE EFFECTS
!!  mpi_enreg= information about MPI parallelization
!!
!! PARENTS
!!      fresid
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

#include "abi_common.h"


subroutine pre_scatter(array,array_allgather,n1,n2,n3,n4,mpi_enreg)

 use defs_basis
 use m_profiling
 use defs_abitypes

!This section has been created automatically by the script Abilint (TD).
!Do not modify the following lines by hand.
#undef ABI_FUNC
#define ABI_FUNC 'pre_scatter'
!End of the abilint section

 implicit none

!Arguments ------------------------------------
 integer,intent(in) :: n1,n2,n3,n4
 real(dp),intent(out) :: array(n1,n2,n4,1)
 real(dp),intent(in) :: array_allgather(n1,n2,n3,1)
 type(mpi_type),intent(inout) :: mpi_enreg

! *********************************************************************

!Perform the reverse operation
 array(:,:,:,:)=array_allgather(:,:,&
& n3/mpi_enreg%nproc_fft*mpi_enreg%me_fft+1:n3/mpi_enreg%nproc_fft*(mpi_enreg%me_fft+1),:)

end subroutine pre_scatter
!!***
