#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2025 Aryan Karamtoth <spaciouscoder78@disroot.org>
# SPDX-FileCopyrightText: © 2025 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# BioShock
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251004.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='bioshock'
GAME_NAME='BioShock'

ARCHIVE_BASE_0_NAME='setup_bioshock_1.1_(25450).exe'
ARCHIVE_BASE_0_MD5='47da4b5d7bdd75aa689f016c7a893979'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_bioshock_1.1_(25450)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='b52c0e3fa73d4d3d7bdf50dc3aa86282'
ARCHIVE_BASE_0_SIZE='5922554'
ARCHIVE_BASE_0_VERSION='1.0-gog25450'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/bioshock_remastered'

CONTENT_PATH_DEFAULT='.'
## d3dx9_33.dll and d3dx10_33.dll should not be included, to avoid a crash before reaching the game menu.
CONTENT_GAME_BIN_FILES='
Builds/Release/binkw32.dll
Builds/Release/gdf.dll
Builds/Release/xinput1_3.dll
Builds/Release/bioshock.exe
Builds/Release/setres.exe
Builds/Release/bioshock.ico
Builds/Release/shadercache.pcs
Builds/Release/shadercache.pcs10
Builds/Release/bioshock-mce.png
Builds/Release/bioshocksaveimage.png
Builds/Release/shaders.spk
Builds/Release/dfe
Builds/Release/*.ini
Builds/Release/*.u'
CONTENT_GAME_DATA_FILES='
Content'
CONTENT_DOC_DATA_FILES='
bioshock patch readme_november 2007_*.txt
readme.txt'

WINE_PERSISTENT_DIRECTORIES='
users/${USER}/AppData/Roaming/Bioshock'
## Work around a crash before reaching the game menu:
##
## 0170:err:d3dcompiler:D3DCompile2 Failed to compile shader, vkd3d result -4.
## 0170:err:d3dcompiler:D3DCompile2 Shader log:
## 0170:err:d3dcompiler:D3DCompile2     StandardInputs.hlsl:6:32: E4000: syntax error, unexpected T_TEXT, expecting T_NEWLINE
## 0170:err:d3dcompiler:D3DCompile2     StandardInputs.hlsl: W4305: Unterminated #if block.
##
## cf. https://bugs.winehq.org/show_bug.cgi?id=48730
## (WINE 10.0)
WINE_WINETRICKS_VERBS='d3dcompiler_47'


APP_MAIN_EXE='builds/release/bioshock.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## Run the game binary from its parent directory, to avoid a game crash when trying to play the first logo video.
game_exec_line() {
	cat <<- 'EOF'
	cd builds/release
	$(wine_command) bioshock.exe "$@"
	EOF
}

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
