/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.export.naming;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.jmx.export.naming.ObjectNamingStrategy;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.util.CollectionUtils;

public class KeyNamingStrategy
implements ObjectNamingStrategy,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Properties mappings;
    private Resource[] mappingLocations;
    private Properties mergedMappings;

    public void setMappings(Properties mappings) {
        this.mappings = mappings;
    }

    public void setMappingLocation(Resource location) {
        this.mappingLocations = new Resource[]{location};
    }

    public void setMappingLocations(Resource[] mappingLocations) {
        this.mappingLocations = mappingLocations;
    }

    public void afterPropertiesSet() throws IOException {
        this.mergedMappings = new Properties();
        CollectionUtils.mergePropertiesIntoMap((Properties)this.mappings, (Map)this.mergedMappings);
        if (this.mappingLocations != null) {
            for (int i = 0; i < this.mappingLocations.length; ++i) {
                Resource location = this.mappingLocations[i];
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("Loading JMX object name mappings file from " + location));
                }
                PropertiesLoaderUtils.fillProperties((Properties)this.mergedMappings, (Resource)location);
            }
        }
    }

    public ObjectName getObjectName(Object managedBean, String beanKey) throws MalformedObjectNameException {
        String objectName = null;
        if (this.mergedMappings != null) {
            objectName = this.mergedMappings.getProperty(beanKey);
        }
        if (objectName == null) {
            objectName = beanKey;
        }
        return ObjectNameManager.getInstance(objectName);
    }
}

