/*################################################################################
# Linux Management Providers (LMP), DHCP provider package
# Copyright (C) 2009 Khahramon NURIDDINOV, qahramon0786@gmail.com,TUIT
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################*/

#include "OpenDRIM_DHCPSettingDataAccess.h"

int DHCP_OpenDRIM_DHCPSettingData_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int DHCP_OpenDRIM_DHCPSettingData_unload(string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return OK;
}

int DHCP_OpenDRIM_DHCPSettingData_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_DHCPSettingData>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	vector<string> ethernet_names;
	int errorCode;
	
	errorCode=dhcp_ethernet_names(ethernet_names,errorMessage);
	
	if(errorCode!=OK)
		return errorCode;
	
	for(int i=0;i<ethernet_names.size();i++)
	{
		OpenDRIM_DHCPSettingData instance;
		instance.setInstanceID(ethernet_names[i]);
		if(discriminant=="ei")
			CF_assert(DHCP_OpenDRIM_DHCPSettingData_populate(instance,errorMessage));
		result.push_back(instance);
	}
	_L_;
	return OK;
}

int DHCP_OpenDRIM_DHCPSettingData_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_DHCPSettingData& instance, const char** properties, string& errorMessage) {
	_E_;
	vector<string> ethernet_names;
	vector<string>::size_type index;
	
	CF_assert(dhcp_ethernet_names(ethernet_names,errorMessage));
	
	if(!CF_foundInList(instance.InstanceID,ethernet_names,index))
	{
		errorMessage = "Invalid path";
		return NOT_FOUND;
	}
	
	CF_assert(DHCP_OpenDRIM_DHCPSettingData_populate(instance,errorMessage));
	
	_L_;
	return OK;
}

int DHCP_OpenDRIM_DHCPSettingData_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPSettingData& newInstance, const OpenDRIM_DHCPSettingData& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DHCP_OpenDRIM_DHCPSettingData_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPSettingData& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DHCP_OpenDRIM_DHCPSettingData_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_DHCPSettingData& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int DHCP_OpenDRIM_DHCPSettingData_populate(OpenDRIM_DHCPSettingData& instance, string& errorMessage) {
	_E_;
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] InstanceID     [KEY]
	 * [X] AddressOrigin
	 * [X] ElementName
	 */
	
	instance.setAddressOrigin(4);
	instance.setElementName(instance.InstanceID+" DHCP Setting");
	_L_;
	return OK;
}

