/*###############################################################################
# Linux Management Providers (LMP), CPU provider package
# Copyright (C) 2007 Frederic Desmons, ETRI <desmons@etri.re.kr ,desmons_frederic@yahoo.fr>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Rakhimov Rustam, TUIT <rusyasoft@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
###############################################################################*/

#include "OpenDRIM_AssociatedProcessorCoreCacheMemoryAccess.h"
#include <SMBIOS.h>

int CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_load(const CMPIBroker* broker, string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(CPU_CIM_Memory_load(broker, errorMessage));
	CF_assert(CPU_CIM_LogicalElement_load(broker, errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_unload(string& errorMessage) {
	_E_;
	/*
	 * for Direct Invocation
	 */
	/*
	CF_assert(CPU_CIM_Memory_unload(errorMessage));
	CF_assert(CPU_CIM_LogicalElement_unload(errorMessage));
	*/
	// TODO
	_L_;
	return OK;
}

int CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_isAssociated(const Instance& Antecedent, const Instance& Dependent, bool& isAssociated, string& errorMessage) {
	_E_;
	// Determine if the association can be established or not
	isAssociated=false;
	string core_instance_id;
	string memory_device_id;
	Dependent.getProperty("InstanceID", core_instance_id);
	Antecedent.getProperty("DeviceID", memory_device_id);

	// processor core InstanceID must contain 2 numerical values seperated by ':'
	vector<string> core_instance_id_elements;
	CF_splitText(core_instance_id_elements, core_instance_id, ':');
	if (core_instance_id_elements.size() != 2)
		return OK;
	if (!CF_isNumber(core_instance_id_elements[0]) || !CF_isNumber(core_instance_id_elements[1]))
		return OK;
	unsigned int first_core_instance_id_element = atoll(core_instance_id_elements[0].c_str());
	unsigned int second_core_instance_id_element = atoll(core_instance_id_elements[1].c_str());

	// memory DeviceID must contain 3 numerical values seperated by ':'
	vector<string> memory_device_id_elements;
	CF_splitText(memory_device_id_elements, memory_device_id, ':');
	if (memory_device_id_elements.size() != 3)
		return OK;
	if (!CF_isNumber(memory_device_id_elements[0]) || !CF_isNumber(memory_device_id_elements[1]) || memory_device_id_elements[2][0]!='L')
		return OK;
	unsigned int first_memory_device_id_element = atoll(memory_device_id_elements[0].c_str());
	unsigned int second_memory_device_id_element = atoll(memory_device_id_elements[1].c_str());
	
	// the first element and the second element of the memory DeviceID must match the core InstanceID
	if (first_memory_device_id_element == first_core_instance_id_element && second_memory_device_id_element == second_core_instance_id_element)
		isAssociated = true;
	_L_;
	return OK;
}

int CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_AssociatedProcessorCoreCacheMemory>& result, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> subjects;
	// Only get the instance names
	CF_assert(CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_enumerateAntecedents(broker, ctx, subjects, NULL, true, errorMessage));
	// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
	// CF_assert(CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_enumerateAntecedents(broker, ctx, subjects, NULL, false, errorMessage));
	vector<Instance>::iterator c = subjects.begin();
	vector<Instance>::iterator end = subjects.end();
	for (; c != end; ++c) {
		bool leftToRight = true;
		vector<Instance> associatedInstances;
		CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_associator(broker, ctx,
			(*c).getObjectpath().getHdl(), (*c),
			Antecedent_classnames[0], Dependent_classnames[0],
			Antecedent_role.c_str(), Dependent_role.c_str(), NULL,
			associatedInstances, leftToRight, errorMessage, "an");

		string ref_discriminant = discriminant == "ein" ? "rn" : "r";
		CF_assert(CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_referenceAntecedentToDependent(broker, ctx, (*c), associatedInstances, result, NULL, errorMessage, ref_discriminant));
	}
	_L_;
	return OK;
}

int CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_AssociatedProcessorCoreCacheMemory& instance, const char** properties, string& errorMessage) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	Objectpath Antecedent_objectpath;
	instance.getAntecedent(Antecedent_objectpath);
	Instance Antecedent_instance;
	CF_assert(CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_getAntecedent(broker, ctx, Antecedent_objectpath, Antecedent_instance, NULL, errorMessage));
	
	Objectpath Dependent_objectpath;
	instance.getDependent(Dependent_objectpath);
	Instance Dependent_instance;
	CF_assert(CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_getDependent(broker, ctx, Dependent_objectpath, Dependent_instance, NULL, errorMessage));

	bool isAssociated = false;
	CF_assert(CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_isAssociated(Antecedent_instance, Dependent_instance, isAssociated, errorMessage));
	if (!isAssociated)
	{
		if(errorMessage.empty())
			errorMessage = "No instance";
		
		return NOT_FOUND;
	}
	CF_assert(CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_populate(instance, errorMessage));
	_L_;
	return OK;
}

int CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AssociatedProcessorCoreCacheMemory& newInstance, const OpenDRIM_AssociatedProcessorCoreCacheMemory& oldInstance, const char** properties, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AssociatedProcessorCoreCacheMemory& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_AssociatedProcessorCoreCacheMemory& instance, string& errorMessage) {
	_E_;
	// TODO
	_L_;
	return NOT_SUPPORTED;
}

int CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_associatorAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const char** properties, vector<Instance>& Dependent_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> Dependent_instances;
	if (discriminant=="a")
		CF_assert(CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_enumerateDependents(broker, ctx, Dependent_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_enumerateDependents(broker, ctx, Dependent_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_enumerateDependents(broker, ctx, Dependent_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<Dependent_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_isAssociated(Antecedent_instance, Dependent_instances[i], isAssociated, errorMessage));
		if (isAssociated)
			Dependent_associatedInstances.push_back(Dependent_instances[i]);
	}
	_L_;
	return OK;
}

int CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_associatorDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const char** properties, vector<Instance>& Antecedent_associatedInstances, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	vector<Instance> Antecedent_instances;
	if (discriminant=="a")
		CF_assert(CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_enumerateAntecedents(broker, ctx, Antecedent_instances, properties, false, errorMessage));
	if (discriminant=="an") {
		// Only get the instance names
		CF_assert(CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_enumerateAntecedents(broker, ctx, Antecedent_instances, properties, true, errorMessage));
		// OR get the full instances IF we need the content of the instance to evaluate the association condition OR to set the reference properties
		// CF_assert(CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_enumerateAntecedents(broker, ctx, Antecedent_instances, properties, false, errorMessage));
	}

	for (size_t i=0; i<Antecedent_instances.size(); i++) {
		bool isAssociated = false;
		CF_assert(CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_isAssociated(Antecedent_instances[i], Dependent_instance, isAssociated, errorMessage));
		if (isAssociated)
			Antecedent_associatedInstances.push_back(Antecedent_instances[i]);
	}
	_L_;
	return OK;
}

int CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_referenceAntecedentToDependent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Antecedent_instance, const vector<Instance>& Dependent_instances, vector<OpenDRIM_AssociatedProcessorCoreCacheMemory>& OpenDRIM_AssociatedProcessorCoreCacheMemory_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < Dependent_instances.size(); i++) {
		OpenDRIM_AssociatedProcessorCoreCacheMemory instance;
		instance.setAntecedent(((Instance) Antecedent_instance).getObjectpath());
		instance.setDependent(((Instance) Dependent_instances[i]).getObjectpath());
			
		if (discriminant == "r") {
			CF_assert(CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_populate(instance, errorMessage));
		}
		
		OpenDRIM_AssociatedProcessorCoreCacheMemory_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_referenceDependentToAntecedent(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& Dependent_instance, const vector<Instance>& Antecedent_instances, vector<OpenDRIM_AssociatedProcessorCoreCacheMemory>& OpenDRIM_AssociatedProcessorCoreCacheMemory_instances, const char** properties, string& errorMessage, const string& discriminant) {
	_E_;
	/*
	 * The following code has been generated for your convenience.
	 * Feel free to modify/delete.
	 */
	for (size_t i=0; i < Antecedent_instances.size(); i++) {
		OpenDRIM_AssociatedProcessorCoreCacheMemory instance;
		instance.setAntecedent(((Instance) Antecedent_instances[i]).getObjectpath());
		instance.setDependent(((Instance) Dependent_instance).getObjectpath());
			
		if (discriminant == "r") {
			CF_assert(CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_populate(instance, errorMessage));
		}
		
		OpenDRIM_AssociatedProcessorCoreCacheMemory_instances.push_back(instance);
	}
	_L_;
	return OK;
}

int CPU_OpenDRIM_AssociatedProcessorCoreCacheMemory_populate(OpenDRIM_AssociatedProcessorCoreCacheMemory& instance, string& errorMessage) {
	_E_;
	
	/*
	 * Properties to fill from profile
	 * + Mandatory:
	 * [X] Level
	 * [X] WritePolicy
	 * [X] CacheType
	 * [X] ReadPolicy
	 * [X] Associativity
	 */
	
	Objectpath Antecedent;
	instance.getAntecedent(Antecedent);
	string memory_device_id;
	Antecedent.getKey("DeviceID", memory_device_id);

	// memory DeviceID must contain 3 numerical values seperated by ':'
	vector<string> memory_device_id_elements;
	CF_splitText(memory_device_id_elements, memory_device_id, ':');
	if (memory_device_id_elements.size() != 3)
		return OK;
	if (!CF_isNumber(memory_device_id_elements[0]) || !CF_isNumber(memory_device_id_elements[1]) || memory_device_id_elements[2][0]!='L')
		return OK;
	unsigned int processor_id = atoll(memory_device_id_elements[0].c_str());
	unsigned int level = atoll(memory_device_id_elements[2].substr(1).c_str());

	// get info from SMBIOS
	vector<_processor_information> SMBIOS_processors_information;
	int errorCode = SMBIOS_getProcessorsInformation(SMBIOS_processors_information, errorMessage);
	// if we cannot get info from SMBIOS, we'll just use info from cpuinfo
	bool use_SMBIOS = false;
	if (errorCode == OK)
		use_SMBIOS = true;

	if (!use_SMBIOS)
		return OK;

	if (processor_id >= SMBIOS_processors_information.size())
		return OK;

	if (level == 1) {
		if (!SMBIOS_processors_information[processor_id].has_l1_cache)
			return OK;
		instance.setWritePolicy(SMBIOS_processors_information[processor_id].l1_cache.operational_mode);
		instance.setCacheType(SMBIOS_processors_information[processor_id].l1_cache.system_cache_type);
		instance.setReadPolicy(0); // unknown
		instance.setAssociativity(SMBIOS_processors_information[processor_id].l1_cache.associativity);
		// smbios gives a wrong level information so we'd rather rely on the cache handles
		//instance.setLevel(SMBIOS_processors_information[processor_id].l1_cache.cache_level);
		instance.setLevel(3);
	}

	if (level == 2) {
		if (!SMBIOS_processors_information[processor_id].has_l2_cache)
			return OK;
		instance.setWritePolicy(SMBIOS_processors_information[processor_id].l2_cache.operational_mode);
		instance.setCacheType(SMBIOS_processors_information[processor_id].l2_cache.system_cache_type);
		instance.setReadPolicy(0); // unknown
		instance.setAssociativity(SMBIOS_processors_information[processor_id].l2_cache.associativity);
		// smbios gives a wrong level information so we'd rather rely on the cache handles
		//instance.setLevel(SMBIOS_processors_information[processor_id].l2_cache.cache_level);
		instance.setLevel(4);
	}
	_L_;
	return OK;
}

