      SUBROUTINE ECTLOC(*,ECT,BUF,IELEM)
C*****
C ECTLOC IS A SPECIAL PURPOSE VERSION OF SUBROUTINE LOCATE.  ITS
C PURPOSE IS TO PASS THE ECT FILE SEQUENTIALLY POSITIONING EACH LOGICAL
C RECORD AFTER THE 3-WORD HEADER AND PROVIDING A POINTER TO THE
C APPROPRIATE ENTRY IN THE ELEM TABLE IN /GPTA1/. PLOTEL
C ELEMENTS ARE IGNORED.
C     NOTE---THE ECT FILE MUST BE OPEN ON EACH CALL.
C
C  ARGUMENTS
C
C     ECT   ---INPUT ---EINO FILE NAME OF THE ECT
C     BUF   ---IN/OUT---ADDRESS OF A 3-WORD ARRAY INTO WHICH
C                       THE FIRST 3 WORDS OF THE RECORD ARE READ
C     IELEM ---OUTPUT---POINTER TO 1ST WORD OF ENTRY IN ELEM
C                       TABLE IN /GPTA1/
C
C NON-STANDARD RETURN---GIVEN WHEN EOF HIT. ECT IS CLOSED BEFORE RETURN.
C*****
      INTEGER ECT , BUF(3), ELEM, PLOTEL
C
      COMMON/ GPTA1 / NELEM, LAST, INCR, ELEM(1)
C
      DATA PLOTEL/ 4HPLOT /
C
C READ A 3-WORD RECORD HEADER. IF NOT 3 WORDS, TRY NEXT RECORD
C
   10 CONTINUE
      CALL READ(*90,*10,ECT,BUF,3,0,NREAD)
C
C SEARCH FOR MATCH OF FIRST WORD OF RECORD WITH ECT-ID WORD IN /GPTA1/
C IF FOUND AND NOT PLOTEL, RETURN POINTER.
C
      DO 20 I=1,LAST,INCR
      IF( BUF(1) .EQ. ELEM(I+3) ) GO TO 30
   20 CONTINUE
   25 CALL FWDREC(*90,ECT)
      GO TO 10
   30 IF( ELEM(I).EQ.PLOTEL ) GO TO 25
      IELEM = I
      RETURN
C
C EOF ENCOUNTERED--CLOSE FILE AND RETURN.
C
   90 CALL CLOSE( ECT, 1 )
      IELEM = 0
      RETURN 1
      END
