# Generated by Django 2.1.3 on 2018-12-19 07:57
from django.conf import settings
from django.db import migrations


def add_oauth_apps(apps, schema_editor):
    # We can't import the Person model directly as it may be a newer
    # version than this migration expects. We use the historical version.
    User = apps.get_model(settings.AUTH_USER_MODEL)
    Application = apps.get_model('oauth2_provider', 'application')

    user = User.objects.get(username='admin')

    oauth2_apps = [
        {
            "user": user,
            "client_type": "public",
            "authorization_grant_type": "password",
            "client_id": settings.OAUTH2_CLIENT_ID,
            "client_secret": settings.OAUTH2_CLIENT_SECRET,
            "redirect_uris": settings.OAUTH2_REDIRECT_URL,
            "name": settings.OAUTH2_APP_NAME
        }
    ]

    for app in oauth2_apps:
        Application.objects.get_or_create(client_id=app['client_id'], defaults=app)


class Migration(migrations.Migration):
    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('oauth2_provider', '0002_auto_20190406_1805'),
        ('users', '0001_create_admin_user'),
    ]

    operations = [
        migrations.RunPython(add_oauth_apps)
    ]
