/*
    LIB - a librarian for compatible OBJ/LIB files
    Copyright (C) 1995,1996  Steffen Kaiser

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $Id: CONFIG.H 3.3 1999/02/17 05:18:08 ska Rel ska $
   $Locker: ska $	$Name: v3_2 $	$State: Rel $

	Configuration values.

*/

#ifndef __CONFIG_H
#define __CONFIG_H

#include "dbug.h"
#ifdef _MICROC_
#include <fmemory.h>
#endif

#define MINPAGESIZE 10		/* minimal size of a page */

#define STD_PAGEINFO 100	/* Default value for the "/I" option. */

#define PAGEINFO_COUNTER 500	/* Enable the counter when at least this
								Amount of page sizes has to be tested. */

#define PAGECALCSKIP 20		/* pretend this amount of byte are empty on each
								page while calculating the minimum amount of
								pages for the library directory. This
								will minimize the retries to build the
								directory with increasing dirpage amount. */

/* must be greater than or equal 1024 */
#define COPYBUF 4096		/* Buffer size while copying a module of the
								library. Despite of that all-purpose
								short-time temporary buffer. */

/*#define NOT_CIRULAR			 There are 2 definitions how the shift is
								to be made while creating the hash values
								of the directory entries. Circular
								(shift in, shifted out bit), or not. */

#define CONST_RESTART 16	/* How to increase the page size, if it failed
								to generate a better one. If the library
								couldn't be created because of missing
								pages. */

/* The following macros define a function name of
				void fct(char *)
	that will upper-case a string. To use strupr() can conflict with
	non-7 bit environments, usually any non-English speaking one.  The
	upper-case function must not extend the string length!
*/
#define fnameupr(s) upStr(s, 4)	/* for upper-casing file names */
#define nameupr(s) upStr(s, 2)	/* for upper-casing symbol names */

/* What to do if a library error is encountered.
	All of these macros must syntactically describe a complete statement,
	either single (with the trailing ';') or compound (with '{',& '}').

	chkEmptyMod	is performed for a record, which has an ill-formed record len
		Not encountered till now.

	chkBadCrc	id performed for a record, which CRC does not match
		The libraries of Borland C/C++ v4.52 have an ill-formed CRC byte
		for most comment records. Former versions had correct (?) CRC
		bytes.
*/

#define chkEmptyMod()	error(E_emptyMod, modType, modName);
//#define chkBadCrc()		error(E_badCrc, modType, modName);
/* Handle the ill-formed CRCs on comment records */
#define chkBadCrc()	{ if(modType != NR_LIB_COMMENT) \
						error(E_badCrc, modType, modName); }

/* DSequalSS controls, if both segments are the same. Borland C compiler
	has a switch to set this, but it is not available by a macro.
	Therefore, the macro is evaluated fromout the memory model.
*/
#ifdef _MICROC_
#define DSequalSS
#else	/* protect the #if from Micro-C preprocessor */
	#if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__)
	#define DSequalSS
	#endif
#endif

/* chkHeap() is performed each time, the heap shall be checked for
	leaks etc.
	If no debug (NODEBUG) is defined, the macro is empty.
	The macro must describe a syntactically complete statement.
*/
#define chkHeap()
#ifndef NDEBUG
#ifndef _MICROC_
#undef chkHeap()
#define chkHeap()	{ assert(heapcheck() != _HEAPCORRUPT);	\
					assert(coreleft() > 4 * 1024); }
#endif
#endif

#endif
