/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.shared.http;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.params.HttpParams;

public class HttpMethodConfiguration {
    public static final int DEFAULT_CONNECTION_TIMEOUT = 60000;
    private static final String COERCE_PATTERN = "%(\\w+),(.+)";
    private Boolean useDefaultHeaders;
    private Properties headers = new Properties();
    private Properties params = new Properties();
    private int connectionTimeout = 60000;

    public boolean isUseDefaultHeaders() {
        return this.useDefaultHeaders == null ? true : this.useDefaultHeaders;
    }

    public HttpMethodConfiguration setUseDefaultHeaders(boolean useDefaultHeaders) {
        this.useDefaultHeaders = useDefaultHeaders;
        return this;
    }

    public Boolean getUseDefaultHeaders() {
        return this.useDefaultHeaders;
    }

    public HttpMethodConfiguration addHeader(String header, String value) {
        this.headers.setProperty(header, value);
        return this;
    }

    public Properties getHeaders() {
        return this.headers;
    }

    public HttpMethodConfiguration setHeaders(Properties headers) {
        this.headers = headers;
        return this;
    }

    public HttpMethodConfiguration addParam(String param, String value) {
        this.params.setProperty(param, value);
        return this;
    }

    public Properties getParams() {
        return this.params;
    }

    public HttpMethodConfiguration setParams(Properties params) {
        this.params = params;
        return this;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public HttpMethodConfiguration setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public HttpMethodParams asMethodParams(HttpMethodParams defaults) {
        if (!this.hasParams()) {
            return null;
        }
        HttpMethodParams p = new HttpMethodParams();
        p.setDefaults((HttpParams)defaults);
        this.fillParams(p);
        return p;
    }

    private boolean hasParams() {
        return this.connectionTimeout >= 1 || this.params != null;
    }

    private void fillParams(HttpMethodParams p) {
        if (!this.hasParams()) {
            return;
        }
        if (this.connectionTimeout > 0) {
            p.setSoTimeout(this.connectionTimeout);
        }
        if (this.params != null) {
            Pattern coercePattern = Pattern.compile(COERCE_PATTERN);
            Iterator<Map.Entry<Object, Object>> it = this.params.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                Matcher matcher = coercePattern.matcher(value);
                if (matcher.matches()) {
                    char type = matcher.group(1).charAt(0);
                    value = matcher.group(2);
                    switch (type) {
                        case 'i': {
                            p.setIntParameter(key, Integer.parseInt(value));
                            break;
                        }
                        case 'd': {
                            p.setDoubleParameter(key, Double.parseDouble(value));
                            break;
                        }
                        case 'l': {
                            p.setLongParameter(key, Long.parseLong(value));
                            break;
                        }
                        case 'b': {
                            p.setBooleanParameter(key, Boolean.valueOf(value).booleanValue());
                            break;
                        }
                        case 'c': {
                            int i;
                            String[] entries = value.split(",");
                            ArrayList<String> collection = new ArrayList<String>();
                            for (i = 0; i < entries.length; ++i) {
                                collection.add(entries[i].trim());
                            }
                            p.setParameter(key, collection);
                            break;
                        }
                        case 'm': {
                            int idx;
                            int i;
                            String[] entries = value.split(",");
                            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                            for (i = 0; i < entries.length && (idx = entries[i].indexOf("=>")) >= 1; ++i) {
                                String mapKey = entries[i].substring(0, idx);
                                String mapVal = entries[i].substring(idx + 1, entries[i].length());
                                map.put(mapKey.trim(), mapVal.trim());
                            }
                            p.setParameter(key, map);
                            break;
                        }
                    }
                    continue;
                }
                p.setParameter(key, (Object)value);
            }
        }
    }

    public Header[] asRequestHeaders() {
        if (this.headers == null) {
            return null;
        }
        Header[] result = new Header[this.headers.size()];
        int index = 0;
        Iterator<Map.Entry<Object, Object>> it = this.headers.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Header header = new Header(key, value);
            result[index++] = header;
        }
        return result;
    }

    private HttpMethodConfiguration copy() {
        HttpMethodConfiguration copy = new HttpMethodConfiguration();
        copy.setConnectionTimeout(this.getConnectionTimeout());
        if (this.getHeaders() != null) {
            copy.setHeaders(this.getHeaders());
        }
        if (this.getParams() != null) {
            copy.setParams(this.getParams());
        }
        copy.setUseDefaultHeaders(this.isUseDefaultHeaders());
        return copy;
    }

    public static HttpMethodConfiguration merge(HttpMethodConfiguration defaults, HttpMethodConfiguration base, HttpMethodConfiguration local) {
        HttpMethodConfiguration result = HttpMethodConfiguration.merge(defaults, base);
        return HttpMethodConfiguration.merge(result, local);
    }

    public static HttpMethodConfiguration merge(HttpMethodConfiguration base, HttpMethodConfiguration local) {
        if (base == null && local == null) {
            return null;
        }
        if (base == null) {
            return local;
        }
        if (local == null) {
            return base;
        }
        HttpMethodConfiguration result = base.copy();
        if (local.getConnectionTimeout() != 60000) {
            result.setConnectionTimeout(local.getConnectionTimeout());
        }
        if (local.getHeaders() != null) {
            result.getHeaders().putAll((Map<?, ?>)local.getHeaders());
        }
        if (local.getParams() != null) {
            result.getParams().putAll((Map<?, ?>)local.getParams());
        }
        if (local.getUseDefaultHeaders() != null) {
            result.setUseDefaultHeaders(local.isUseDefaultHeaders());
        }
        return result;
    }
}

