; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature
; RUN: opt < %s -passes=ipsccp -S | FileCheck %s

define internal i32 @f1(i32 %x) {
; CHECK-LABEL: define {{[^@]+}}@f1
; CHECK-SAME: (i32 [[X:%.*]]) {
; CHECK-NEXT:    ret i32 undef
;
  %cmp = icmp sgt i32 %x, 300
  %res = select i1 %cmp, i32 1, i32 2
  ret i32 %res
}

; %res is a constant range [0, 2) from a PHI node.
define i32 @caller1(i1 %cmp) {
; CHECK-LABEL: define {{[^@]+}}@caller1
; CHECK-SAME: (i1 [[CMP:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[CMP]], label [[IF_TRUE:%.*]], label [[END:%.*]]
; CHECK:       if.true:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[RES:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ 1, [[IF_TRUE]] ]
; CHECK-NEXT:    [[CALL1:%.*]] = tail call i32 @f1(i32 [[RES]])
; CHECK-NEXT:    ret i32 2
;


entry:
  br i1 %cmp, label %if.true, label %end

if.true:
  br label %end

end:
  %res = phi i32 [ 0, %entry], [ 1, %if.true ]
  %call1 = tail call i32 @f1(i32 %res)
  ret i32 %call1
}

define internal i32 @f2(i32 %x, i32 %y, i32 %z, i1 %cmp.1, i1 %cmp.2) {
; CHECK-LABEL: define {{[^@]+}}@f2
; CHECK-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]], i32 [[Z:%.*]], i1 [[CMP_1:%.*]], i1 [[CMP_2:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[CMP_1]], label [[IF_TRUE_1:%.*]], label [[END:%.*]]
; CHECK:       if.true.1:
; CHECK-NEXT:    br i1 [[CMP_2]], label [[IF_TRUE_2:%.*]], label [[END]]
; CHECK:       if.true.2:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ [[X]], [[ENTRY:%.*]] ], [ [[Y]], [[IF_TRUE_1]] ], [ [[Z]], [[IF_TRUE_2]] ]
; CHECK-NEXT:    [[C_1:%.*]] = icmp sgt i32 [[P]], 5
; CHECK-NEXT:    [[C_2:%.*]] = icmp eq i32 [[P]], 0
; CHECK-NEXT:    [[C_3:%.*]] = icmp slt i32 [[P]], 0
; CHECK-NEXT:    [[V_1:%.*]] = select i1 [[C_1]], i32 10, i32 100
; CHECK-NEXT:    [[V_2:%.*]] = select i1 [[C_2]], i32 20, i32 200
; CHECK-NEXT:    [[V_3:%.*]] = select i1 [[C_3]], i32 30, i32 300
; CHECK-NEXT:    [[R_1:%.*]] = add nuw nsw i32 [[V_1]], [[V_2]]
; CHECK-NEXT:    [[R_2:%.*]] = add nuw nsw i32 [[R_1]], [[V_3]]
; CHECK-NEXT:    [[R_3:%.*]] = add nuw nsw i32 [[R_2]], 400
; CHECK-NEXT:    [[R_4:%.*]] = add nuw nsw i32 [[R_3]], 50
; CHECK-NEXT:    [[R_5:%.*]] = add nuw nsw i32 [[R_4]], 60
; CHECK-NEXT:    [[R_6:%.*]] = add nuw nsw i32 [[R_4]], 700
; CHECK-NEXT:    ret i32 [[R_6]]
;



entry:
  br i1 %cmp.1, label %if.true.1, label %end

if.true.1:
  br i1 %cmp.2, label %if.true.2, label %end

if.true.2:
  br label %end

end:
  %p = phi i32 [ %x, %entry ], [ %y, %if.true.1 ], [ %z, %if.true.2 ]
  %c.1 = icmp sgt i32 %p, 5
  %c.2 = icmp eq i32 %p, 0
  %c.3 = icmp slt i32 %p, 0
  %c.4 = icmp sgt i32 %p, 10
  %c.5 = icmp sle i32 %p, 10
  %c.6 = icmp sgt i32 %p, -11
  %c.7 = icmp slt i32 %p, -11
  %v.1 = select i1 %c.1, i32 10, i32 100
  %v.2 = select i1 %c.2, i32 20, i32 200
  %v.3 = select i1 %c.3, i32 30, i32 300
  %v.4 = select i1 %c.4, i32 40, i32 400
  %v.5 = select i1 %c.5, i32 50, i32 500
  %v.6 = select i1 %c.6, i32 60, i32 600
  %v.7 = select i1 %c.7, i32 70, i32 700
  %r.1 = add i32 %v.1, %v.2
  %r.2 = add i32 %r.1, %v.3
  %r.3 = add i32 %r.2, %v.4
  %r.4 = add i32 %r.3, %v.5
  %r.5 = add i32 %r.4, %v.6
  %r.6 = add i32 %r.4, %v.7
  ret i32 %r.6
}

define i32 @caller2(i1 %cmp.1, i1 %cmp.2) {
; CHECK-LABEL: define {{[^@]+}}@caller2
; CHECK-SAME: (i1 [[CMP_1:%.*]], i1 [[CMP_2:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[CMP_1]], label [[IF_TRUE:%.*]], label [[END:%.*]]
; CHECK:       if.true:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[P1:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ 1, [[IF_TRUE]] ]
; CHECK-NEXT:    [[P2:%.*]] = phi i32 [ 1, [[ENTRY]] ], [ -10, [[IF_TRUE]] ]
; CHECK-NEXT:    [[P3:%.*]] = phi i32 [ 1, [[ENTRY]] ], [ 10, [[IF_TRUE]] ]
; CHECK-NEXT:    [[CALL1:%.*]] = tail call i32 @f2(i32 [[P1]], i32 [[P2]], i32 [[P3]], i1 [[CMP_1]], i1 [[CMP_2]])
; CHECK-NEXT:    ret i32 [[CALL1]]
;



entry:
  br i1 %cmp.1, label %if.true, label %end

if.true:
  br label %end

end:
  %p1 = phi i32 [ 0, %entry], [ 1, %if.true ]
  %p2 = phi i32 [ 1, %entry], [ -10, %if.true ]
  %p3 = phi i32 [ 1, %entry], [ 10, %if.true ]
  %call1 = tail call i32 @f2(i32 %p1, i32 %p2, i32 %p3, i1 %cmp.1, i1 %cmp.2)
  ret i32 %call1
}

define internal i32 @f3(i32 %x, i32 %y, i1 %cmp.1) {
; CHECK-LABEL: define {{[^@]+}}@f3
; CHECK-SAME: (i32 [[X:%.*]], i32 [[Y:%.*]], i1 [[CMP_1:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[CMP_1]], label [[IF_TRUE_1:%.*]], label [[END:%.*]]
; CHECK:       if.true.1:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[P:%.*]] = phi i32 [ [[X]], [[ENTRY:%.*]] ], [ [[Y]], [[IF_TRUE_1]] ]
; CHECK-NEXT:    [[C_1:%.*]] = icmp sgt i32 [[P]], 5
; CHECK-NEXT:    [[C_2:%.*]] = icmp eq i32 [[P]], 0
; CHECK-NEXT:    [[C_3:%.*]] = icmp slt i32 [[P]], 0
; CHECK-NEXT:    [[C_4:%.*]] = icmp sgt i32 [[P]], 10
; CHECK-NEXT:    [[C_5:%.*]] = icmp sle i32 [[P]], 10
; CHECK-NEXT:    [[C_6:%.*]] = icmp sgt i32 [[P]], -11
; CHECK-NEXT:    [[C_7:%.*]] = icmp slt i32 [[P]], -11
; CHECK-NEXT:    [[V_1:%.*]] = select i1 [[C_1]], i32 10, i32 100
; CHECK-NEXT:    [[V_2:%.*]] = select i1 [[C_2]], i32 20, i32 200
; CHECK-NEXT:    [[V_3:%.*]] = select i1 [[C_3]], i32 30, i32 300
; CHECK-NEXT:    [[V_4:%.*]] = select i1 [[C_4]], i32 40, i32 400
; CHECK-NEXT:    [[V_5:%.*]] = select i1 [[C_5]], i32 50, i32 500
; CHECK-NEXT:    [[V_6:%.*]] = select i1 [[C_6]], i32 60, i32 600
; CHECK-NEXT:    [[V_7:%.*]] = select i1 [[C_7]], i32 70, i32 700
; CHECK-NEXT:    [[R_1:%.*]] = add nuw nsw i32 [[V_1]], [[V_2]]
; CHECK-NEXT:    [[R_2:%.*]] = add nuw nsw i32 [[R_1]], [[V_3]]
; CHECK-NEXT:    [[R_3:%.*]] = add nuw nsw i32 [[R_2]], [[V_4]]
; CHECK-NEXT:    [[R_4:%.*]] = add nuw nsw i32 [[R_3]], [[V_5]]
; CHECK-NEXT:    [[R_5:%.*]] = add nuw nsw i32 [[R_4]], [[V_6]]
; CHECK-NEXT:    [[R_6:%.*]] = add nuw nsw i32 [[R_4]], [[V_7]]
; CHECK-NEXT:    ret i32 [[R_6]]
;


entry:
  br i1 %cmp.1, label %if.true.1, label %end

if.true.1:
  br label %end

end:
  %p = phi i32 [ %x, %entry ], [ %y, %if.true.1 ]
  %c.1 = icmp sgt i32 %p, 5
  %c.2 = icmp eq i32 %p, 0
  %c.3 = icmp slt i32 %p, 0
  %c.4 = icmp sgt i32 %p, 10
  %c.5 = icmp sle i32 %p, 10
  %c.6 = icmp sgt i32 %p, -11
  %c.7 = icmp slt i32 %p, -11
  %v.1 = select i1 %c.1, i32 10, i32 100
  %v.2 = select i1 %c.2, i32 20, i32 200
  %v.3 = select i1 %c.3, i32 30, i32 300
  %v.4 = select i1 %c.4, i32 40, i32 400
  %v.5 = select i1 %c.5, i32 50, i32 500
  %v.6 = select i1 %c.6, i32 60, i32 600
  %v.7 = select i1 %c.7, i32 70, i32 700
  %r.1 = add i32 %v.1, %v.2
  %r.2 = add i32 %r.1, %v.3
  %r.3 = add i32 %r.2, %v.4
  %r.4 = add i32 %r.3, %v.5
  %r.5 = add i32 %r.4, %v.6
  %r.6 = add i32 %r.4, %v.7
  ret i32 %r.6
}

define i32 @caller3(i32 %y, i1 %cmp.1) {
; CHECK-LABEL: define {{[^@]+}}@caller3
; CHECK-SAME: (i32 [[Y:%.*]], i1 [[CMP_1:%.*]]) {
; CHECK-NEXT:  entry:
; CHECK-NEXT:    br i1 [[CMP_1]], label [[IF_TRUE:%.*]], label [[END:%.*]]
; CHECK:       if.true:
; CHECK-NEXT:    br label [[END]]
; CHECK:       end:
; CHECK-NEXT:    [[P1:%.*]] = phi i32 [ 0, [[ENTRY:%.*]] ], [ 5, [[IF_TRUE]] ]
; CHECK-NEXT:    [[CALL1:%.*]] = tail call i32 @f3(i32 [[P1]], i32 [[Y]], i1 [[CMP_1]])
; CHECK-NEXT:    ret i32 [[CALL1]]
;


entry:
  br i1 %cmp.1, label %if.true, label %end

if.true:
  br label %end

end:
  %p1 = phi i32 [ 0, %entry], [ 5, %if.true ]
  %call1 = tail call i32 @f3(i32 %p1, i32 %y, i1 %cmp.1)
  ret i32 %call1
}
