# Dependencies and Licenses

There are

- External dependencies as linkable libraries or externally installed headers, and
- Internal dependencies as the part of code from external libraries
  backported/copied in main repo.

Both these dependencies are listed here:

## Internal dependencies

- [nostd::variant](https://github.com/open-telemetry/opentelemetry-cpp/blob/v1.0.0-rc1/api/include/opentelemetry/nostd/absl/types/variant.h):
  This is backported from [Abseil C++
  libraries](https://github.com/abseil/abseil-cpp) and used as default variant
  implementation. License: `Apache License 2.0`
- [TraceLoggingDynamic](https://github.com/open-telemetry/opentelemetry-cpp/blob/v1.0.0-rc1/exporters/etw/include/opentelemetry/exporters/etw/TraceLoggingDynamic.h):
  Dynamic TraceLogging Provider API for C++ used by ETW exporter. License: `MIT
  License`

## External dependencies

- [API](https://github.com/open-telemetry/opentelemetry-cpp/tree/v1.0.0-rc1/api)
  &
  [SDK](https://github.com/open-telemetry/opentelemetry-cpp/tree/v1.0.0-rc1/sdk):
  - Uses Standard C++ library for latest features (std::string_view,
    std::variant, std::span, std::shared_ptr, std::unique_ptr) with  C++14/17/20
    compiler if `WITH_STL` cmake option is enabled or `HAVE_CPP_STDLIB` macro is
    defined. License: `GNU General Public License`
    - For C++11/14/17 compilers, fallback to gsl::span if [GSL C++
      library](https://github.com/microsoft/GSL) is installed. License: `MIT
      License`
  - Uses Abseil C++ Library for `absl::variant` as default `nostd::variant` if
    `WITH_ABSEIL` cmake option or
    `--@io_opentelemetry_cpp/api:with_abseil=true` (aka
    `--//api:with_abseil=true`) bazel option is enabled. License: `Apache
    License 2.0`

- [OTLP/HTTP+JSON](https://github.com/open-telemetry/opentelemetry-cpp/tree/v1.0.0-rc1/exporters/otlp)
  exporter:
  - [protobuf](https://github.com/protocolbuffers/protobuf):  Library to
    serialize structured data.
    - OTLP messages are constructed as protobuf payloads.
    - `protoc` compiler is used to generate C++ stubs for proto files provided
      by `opentelemetry-proto`.
    - `libprotobuf` library is used for generating serialised trace/metrics/log
      data to be sent to opentelemetry collector.
    - License: The library is licensed
      [here](https://github.com/protocolbuffers/protobuf/blob/master/LICENSE).
      The  code generated by protoc compiler is owned by the owner of `.proto`
      file.
  - [libcurl](https://curl.se/libcurl/) : the multiprotocol file transfer
    library.
    - Export connects with opentelemetry collector over HTTP protocol using
      libcurl library
    - License: Inspired by `MIT/X` but not same.
      <https://curl.se/docs/copyright.html>
  - [nlohmann/json](https://github.com/nlohmann/json): JSON for Modern C++.
    - protobuf serialized otlp messages are encoded in JSON format using this
      library.
    - License: `MIT License`

- [OTLP/gRPC](https://github.com/open-telemetry/opentelemetry-cpp/tree/v1.0.0-rc1/exporters/otlp)
  exporter:
  - `protobuf`  OTLP messages are constructed as protobuf payloads.
  - [gRPC](https://github.com/grpc/grpc): An RPC library and framework
    - Exporter communicates with OTLP collector using gRPC transport mechanism.
    - License: `Apache License 2.0`

- [Zipkin](https://github.com/open-telemetry/opentelemetry-cpp/tree/v1.0.0-rc1/exporters/zipkin)
  exporter:
  - `libcurl` for connecting with Zipkin server over HTTP protocol.
  - `nlohmann/json` for encoding Zipkin messages.

- [Jaeger](https://github.com/open-telemetry/opentelemetry-cpp/tree/v1.0.0-rc1/exporters/jaeger)
  exporter:
  - [Thrift](https://github.com/apache/thrift) - Serialization and RPC
    framework.
    - `thrift` compiler to generate C++ stubs for IDL data model for Jaeger.
    - `libthrift`  library to generate serialised trace/metrics/log data to be
      sent to remote Jaeger service.
    - License: `Apache License 2.0`

- [ETW](https://github.com/open-telemetry/opentelemetry-cpp/tree/v1.0.0-rc1/exporters/etw)
  exporter:
  - `nlohmann/json` for generating MessagePack serialization for message to be
    transmitted to ETW.

- [Prometheus](https://github.com/open-telemetry/opentelemetry-cpp/tree/v1.0.0-rc1/exporters/prometheus)
  exporter:
  - [`prometheus-cpp`](https://github.com/jupp0r/prometheus-cpp) Prometheus
    Client Library for Modern C++
    - License: `MIT License`

- [ElasticSearch](https://github.com/open-telemetry/opentelemetry-cpp/tree/v1.0.0-rc1/exporters/elasticsearch)
  exporter:
  - `libcurl` for connecting with Elasticsearch server over HTTP protocol.
  - `nlohmann/json` for encoding Elastic Search messages.

- [Zpages](https://github.com/open-telemetry/opentelemetry-cpp/tree/v1.0.0-rc1/ext/src/zpages):
  - None
