#!/bin/bash
#
# wxAstroCapture Preinstall script
#
# adds the wxWidgets repository server to /etc/apt/sources.list (only if this file existst)
# gathers the wxWidgets Public Key to vaildate incomming packages
#
# it will add: "deb http://apt.wxwidgets.org/ ${DISTRIB}-wx main"
# and the public key: "http://apt.wxwidgets.org/key.asc"
#
#  NOTE: the script requires super user rights to write and install
#        use sudo to make it work
#
#

DEBSOURCES=/etc/apt/sources.list
WXPUBKEY="53B087BC"
APP=wxAstroCapture
# init some
DISTRIB=unknown
NOCURL=0
NOGDEBI=0
NOREPADD=0
NOROOT=0

check_Distrib()
{
	cat ${DEBSOURCES} | grep -i $1 > /dev/null
	return $?
}

check_Repository()
{
	echo "Info: checking the repository now"
	cat ${DEBSOURCES} | grep -i "deb http://apt.wxwidgets.org/" >/dev/null
	if [ $? = 0 ]; then
		echo "Info: checking the public key now"
		apt-key list  | grep -i ${WXPUBKEY} >/dev/null 
		return $?
	fi
	return -1
}

add_Repository()
{
	# check if the line exists
	cat ${DEBSOURCES} | grep -i "deb http://apt.wxwidgets.org/" >/dev/null
	if [ $? != 0 ]; then
		if [ $NOROOT = 1 ]; then
			echo "Info: cannot add repository entry - not in sudo mode"
			return -1
		fi
		if [ ! -w "${DEBSOURCES}" ]; then
			# cannot write !!
			echo "Info: cannot add repository entry - cannot write to ${DEBSOURCES} ?!"
			return -1
		fi

		echo "#"  >> ${DEBSOURCES}
		echo "## wxWidgets Binary archive"  >> ${DEBSOURCES}
        echo "deb http://apt.wxwidgets.org/ ${DISTRIB}-wx main"  >> ${DEBSOURCES}
		echo "#"  >> ${DEBSOURCES}
		return $?
	fi
	return 0
}

add_PublicKey()
{
	# check if the key exists
	apt-key list | grep -i ${WXPUBKEY} >/dev/null
	if [ $? != 0 ]; then
		if [ $NOROOT = 1 ]; then
			echo "Info: cannot install public key - not in sudo mode"
			return -1
		fi
		if [ $NOCURL = 1 ]; then
			echo "Info: cannot install public key - curl program not at hand"
			return 1
		fi

		curl "http://apt.wxwidgets.org/key.asc" | apt-key add -
		return $?
	fi
}

add_Curl()
{
	echo "Info: Checking for curl "
	dpkg-query -s curl | grep -e Package -e Version
	dpkg-query -s curl | grep -e Status | grep  "install ok installed"
	if [ $? = 0 ]; then
		echo "Info: curl seems already installed"
	else
		if [ $NOROOT = 1 ]; then
			echo "Info: cannot install - not in sudo mode"
			return -1
		fi
		echo "Info: installing  curl"
		apt-get --yes install curl
		if [ $? != 0 ]; then
		# attempt with --yes failed trying pure
			echo "Info: failed to install - trying with user help now" 
			apt-get install curl
			return $?
		fi
	fi
	return 0
}

add_Gdebi()
{
	echo "Info: Checking for Gdebi "
	dpkg-query -s gdebi | grep -e Package -e Version
	dpkg-query -s gdebi | grep -e Status | grep  "install ok installed"
	if [ $? = 0 ]; then
		echo "Info: Gdebi seems already installed"
	else
		if [ $NOROOT = 1 ]; then
			echo "Info: cannot install - not in sudo mode"
			return -1
		fi
		echo "Info: installing  Gdebi"
		apt-get --yes install gdebi
		if [ $? != 0 ]; then
		# attempt with --yes failed trying pure
			echo "Info: failed to install - trying with user help now" 
			apt-get install gdebi
			return $?
		fi
	fi
	return 0
}


# MAIN
{
	echo " "
	echo "$0: $APP install helper "
	echo " "

# sanity
	if [ "$USER" != "root" ]; then
		NOROOT=1
		echo "NOTE: $0 does not run with sudo permission"
		echo " limited functionality only - try sudo $0 !"
		echo " "
	fi

# check if we have the apt sources file in place
	if [ ! -f "/etc/apt/sources.list" ]; then
		echo "Error Exit: Could not find the apt installer file"
		echo " either apt is not setup or it is not a debian distribution"
		exit -1
	fi

	if [ ! -x  "`which dpkg`" ]; then
		echo "Info: Could not find the dpkg executable"
		echo " either dpkg is not installed or it is not a debian distribution"
	fi

	if [ ! -x  "`which apt-get`" ]; then
		echo "Info: Could not find the apt executable"
		echo " either apt is not installed or it is not a debian distribution"
	fi

# checking distribs
	for DIS in edgy etch dapper feisty gutsy hardy unknown ;do
		check_Distrib $DIS
		if [ $? = 0 ]; then
			break
		fi
	done
	if [ $DIS = "unknown" ]; then
		echo "Error Exit: cannot get the distribution"
		echo " this script works only for: (k)ubuntu - edgy etch, dapper, feisty, gutsy, hardy"
		exit -1
	fi
	DISTRIB=$DIS
	echo "Info: distrib determined as - ${DISTRIB}"


# repository stuff
	check_Repository
	if [ $? = 0 ]; then
		echo "Info: the wxWidgets repository entry seems already to exist"
	else
	# add the useful things
		add_Curl
		if [ ! -x "`which curl`" ]; then
			echo "Info: Could not find the curl executable"
			echo " curl install has failed - we cannot install the public key via script"
			echo " you may get curl manually with sudo apt-get install curl"
			NOCURL=1
		fi
	
		add_Gdebi
		if [ ! -x "`which gdebi`" ]; then
			echo "Info: Could not find the gdebi executable"
			echo " gdebi install has failed - Gdebi is not at hand now"
			echo " you may get gdebi manually with sudo apt-get install gdebi"
			NOGDEBI=1
		fi

		add_Repository
		if [ $? = 0 ]; then
			echo "Info: entry ok in ${DEBSOURCES}"
		else
			echo "Error Exit: cannot write to ${DEBSOURCES}"
			echo "Run script with sudo i.e."
			echo "sudo $0 $@"
			exit -1
		fi
		add_PublicKey
		if [ $? = 0 ]; then
			echo "Info: public key of wxWidgets repository ok"
		else
			echo "Error Exit: cannot find and-or add public key"
			exit -1
		fi
		echo "Info: updating the package index (may take a while)"
		apt-get update > /dev/null
		echo "Info: finished updating the package index"
	fi

	echo "Info: The ${APP} prerequisites should be met"
	echo " "
	echo " you may do the following now:"
	echo " find the debian package (wxastrocapture_n.n-n_i386.deb)"
	echo " rightclick - Open With - Gdebi package installer"
	echo " if you are ready click Install Package"
	echo " "

	exit 0	
} 
