/**
 * MouseList.java
 *
 * Created on Jul 3, 2006
 */
package events;

/**
 * Cette interface represente un objet qui ecoute des events de la souris
 * avec des informations des coordonees complexes.
 *
 * @author Nicolae
 */
public interface MouseList {
	
	/**
	 * Apelee quand la souris survole le point <code>(re, im)</code>.
	 *
	 * @param re partie reele.
	 * @param im partie imaginaire.
	 */
	public void move(double re, double im);	

	/**
	 * Appelee lors d'un click gauche au point <code>(re, im)</code>.
	 *
	 * @param re partie reele.
	 * @param im partie imaginaire.
	 */
	public void click(double re, double im);

	/**
	 * Appelee lors d'un click droite au point <code>(re, im)</code>.
	 *
	 * @param re partie reele.
	 * @param im partie imaginaire.
	 */
	public void rclick(double re, double im);	
	
	/**
	 * Appelee quand la souris sort de la zone.
	 */
	public void exit();
}
