/* valathrowstatement.c generated by valac, the Vala compiler
 * generated from valathrowstatement.vala, do not modify */

/* valathrowstatement.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaThrowStatementPrivate {
	ValaExpression* _error_expression;
};

static gint ValaThrowStatement_private_offset;
static gpointer vala_throw_statement_parent_class = NULL;
static ValaStatementIface * vala_throw_statement_vala_statement_parent_iface = NULL;

static void vala_throw_statement_real_accept (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_throw_statement_real_accept_children (ValaCodeNode* base,
                                                ValaCodeVisitor* visitor);
static void vala_throw_statement_real_replace_expression (ValaCodeNode* base,
                                                   ValaExpression* old_node,
                                                   ValaExpression* new_node);
static void vala_throw_statement_real_get_error_types (ValaCodeNode* base,
                                                ValaCollection* collection,
                                                ValaSourceReference* source_reference);
static gboolean vala_throw_statement_real_check (ValaCodeNode* base,
                                          ValaCodeContext* context);
static void vala_throw_statement_real_emit (ValaCodeNode* base,
                                     ValaCodeGenerator* codegen);
static void vala_throw_statement_real_get_defined_variables (ValaCodeNode* base,
                                                      ValaCollection* collection);
static void vala_throw_statement_real_get_used_variables (ValaCodeNode* base,
                                                   ValaCollection* collection);
static void vala_throw_statement_finalize (ValaCodeNode * obj);
static GType vala_throw_statement_get_type_once (void);

static inline gpointer
vala_throw_statement_get_instance_private (ValaThrowStatement* self)
{
	return G_STRUCT_MEMBER_P (self, ValaThrowStatement_private_offset);
}

ValaExpression*
vala_throw_statement_get_error_expression (ValaThrowStatement* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_expression;
	result = _tmp0_;
	return result;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

void
vala_throw_statement_set_error_expression (ValaThrowStatement* self,
                                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_error_expression);
	self->priv->_error_expression = _tmp0_;
	_tmp1_ = self->priv->_error_expression;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_error_expression;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}

/**
 * Creates a new throw statement.
 *
 * @param error_expression the error expression
 * @param source_reference reference to source code
 * @return                 newly created throw statement
 */
ValaThrowStatement*
vala_throw_statement_construct (GType object_type,
                                ValaExpression* error_expression,
                                ValaSourceReference* source_reference)
{
	ValaThrowStatement* self = NULL;
	g_return_val_if_fail (error_expression != NULL, NULL);
	self = (ValaThrowStatement*) vala_code_node_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_throw_statement_set_error_expression (self, error_expression);
	return self;
}

ValaThrowStatement*
vala_throw_statement_new (ValaExpression* error_expression,
                          ValaSourceReference* source_reference)
{
	return vala_throw_statement_construct (VALA_TYPE_THROW_STATEMENT, error_expression, source_reference);
}

static void
vala_throw_statement_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaThrowStatement * self;
	self = (ValaThrowStatement*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_throw_statement (visitor, self);
}

static void
vala_throw_statement_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor)
{
	ValaThrowStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaThrowStatement*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_throw_statement_get_error_expression (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp2_ = vala_throw_statement_get_error_expression (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
		_tmp4_ = vala_throw_statement_get_error_expression (self);
		_tmp5_ = _tmp4_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp5_);
	}
}

static void
vala_throw_statement_real_replace_expression (ValaCodeNode* base,
                                              ValaExpression* old_node,
                                              ValaExpression* new_node)
{
	ValaThrowStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaThrowStatement*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_throw_statement_get_error_expression (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_throw_statement_set_error_expression (self, new_node);
	}
}

static void
vala_throw_statement_real_get_error_types (ValaCodeNode* base,
                                           ValaCollection* collection,
                                           ValaSourceReference* source_reference)
{
	ValaThrowStatement * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* error_type = NULL;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	self = (ValaThrowStatement*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	if (source_reference == NULL) {
		ValaSourceReference* _tmp2_;
		ValaSourceReference* _tmp3_;
		_tmp2_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		source_reference = _tmp3_;
	}
	_tmp4_ = vala_throw_statement_get_error_expression (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_expression_get_value_type (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_data_type_copy (_tmp7_);
	error_type = _tmp8_;
	_tmp9_ = error_type;
	vala_code_node_set_source_reference ((ValaCodeNode*) _tmp9_, source_reference);
	_tmp10_ = error_type;
	vala_collection_add (collection, _tmp10_);
	_vala_code_node_unref0 (error_type);
}

static gboolean
vala_throw_statement_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context)
{
	ValaThrowStatement * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaProfile _tmp4_;
	ValaProfile _tmp5_;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	ValaSourceReference* _tmp10_;
	ValaSourceReference* _tmp11_;
	ValaErrorType* _tmp12_;
	ValaErrorType* _tmp13_;
	ValaExpression* _tmp14_;
	ValaExpression* _tmp15_;
	ValaDataType* _tmp16_;
	ValaDataType* _tmp17_;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	gboolean _tmp49_;
	gboolean _tmp50_;
	gboolean result = FALSE;
	self = (ValaThrowStatement*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_profile (context);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == VALA_PROFILE_POSIX) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "`throws' is not supported in POSIX profile");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp8_ = vala_throw_statement_get_error_expression (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_error_type_new (NULL, NULL, _tmp11_);
	_tmp13_ = _tmp12_;
	vala_expression_set_target_type (_tmp9_, (ValaDataType*) _tmp13_);
	_vala_code_node_unref0 (_tmp13_);
	_tmp14_ = vala_throw_statement_get_error_expression (self);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_expression_get_target_type (_tmp15_);
	_tmp17_ = _tmp16_;
	vala_data_type_set_value_owned (_tmp17_, TRUE);
	_tmp18_ = vala_throw_statement_get_error_expression (self);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		ValaExpression* _tmp20_;
		ValaExpression* _tmp21_;
		ValaExpression* _tmp22_;
		ValaExpression* _tmp23_;
		ValaDataType* _tmp24_;
		ValaDataType* _tmp25_;
		gboolean _tmp30_ = FALSE;
		ValaProfile _tmp31_;
		ValaProfile _tmp32_;
		_tmp20_ = vala_throw_statement_get_error_expression (self);
		_tmp21_ = _tmp20_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp21_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp22_ = vala_throw_statement_get_error_expression (self);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_expression_get_value_type (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp25_ == NULL) {
			ValaExpression* _tmp26_;
			ValaExpression* _tmp27_;
			ValaSourceReference* _tmp28_;
			ValaSourceReference* _tmp29_;
			_tmp26_ = vala_throw_statement_get_error_expression (self);
			_tmp27_ = _tmp26_;
			_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp27_);
			_tmp29_ = _tmp28_;
			vala_report_error (_tmp29_, "invalid error expression");
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp31_ = vala_code_context_get_profile (context);
		_tmp32_ = _tmp31_;
		if (_tmp32_ == VALA_PROFILE_GOBJECT) {
			ValaExpression* _tmp33_;
			ValaExpression* _tmp34_;
			ValaDataType* _tmp35_;
			ValaDataType* _tmp36_;
			_tmp33_ = vala_throw_statement_get_error_expression (self);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_expression_get_value_type (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp30_ = !VALA_IS_ERROR_TYPE (_tmp36_);
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			ValaExpression* _tmp37_;
			ValaExpression* _tmp38_;
			ValaSourceReference* _tmp39_;
			ValaSourceReference* _tmp40_;
			ValaExpression* _tmp41_;
			ValaExpression* _tmp42_;
			ValaDataType* _tmp43_;
			ValaDataType* _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			_tmp37_ = vala_throw_statement_get_error_expression (self);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = vala_throw_statement_get_error_expression (self);
			_tmp42_ = _tmp41_;
			_tmp43_ = vala_expression_get_value_type (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_code_node_to_string ((ValaCodeNode*) _tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strdup_printf ("`%s' is not an error type", _tmp46_);
			_tmp48_ = _tmp47_;
			vala_report_error (_tmp40_, _tmp48_);
			_g_free0 (_tmp48_);
			_g_free0 (_tmp46_);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	_tmp49_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp50_ = _tmp49_;
	result = !_tmp50_;
	return result;
}

static void
vala_throw_statement_real_emit (ValaCodeNode* base,
                                ValaCodeGenerator* codegen)
{
	ValaThrowStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaThrowStatement*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_throw_statement_get_error_expression (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp2_ = vala_throw_statement_get_error_expression (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
		_tmp4_ = vala_throw_statement_get_error_expression (self);
		_tmp5_ = _tmp4_;
		vala_code_visitor_visit_end_full_expression ((ValaCodeVisitor*) codegen, _tmp5_);
	}
	vala_code_visitor_visit_throw_statement ((ValaCodeVisitor*) codegen, self);
}

static void
vala_throw_statement_real_get_defined_variables (ValaCodeNode* base,
                                                 ValaCollection* collection)
{
	ValaThrowStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaThrowStatement*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_throw_statement_get_error_expression (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
}

static void
vala_throw_statement_real_get_used_variables (ValaCodeNode* base,
                                              ValaCollection* collection)
{
	ValaThrowStatement * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaThrowStatement*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_throw_statement_get_error_expression (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
}

static void
vala_throw_statement_class_init (ValaThrowStatementClass * klass,
                                 gpointer klass_data)
{
	vala_throw_statement_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_throw_statement_finalize;
	g_type_class_adjust_private_offset (klass, &ValaThrowStatement_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_throw_statement_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_throw_statement_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_throw_statement_real_replace_expression;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_throw_statement_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_throw_statement_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_throw_statement_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_throw_statement_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_throw_statement_real_get_used_variables;
}

static void
vala_throw_statement_vala_statement_interface_init (ValaStatementIface * iface,
                                                    gpointer iface_data)
{
	vala_throw_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}

static void
vala_throw_statement_instance_init (ValaThrowStatement * self,
                                    gpointer klass)
{
	self->priv = vala_throw_statement_get_instance_private (self);
}

static void
vala_throw_statement_finalize (ValaCodeNode * obj)
{
	ValaThrowStatement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_THROW_STATEMENT, ValaThrowStatement);
	_vala_code_node_unref0 (self->priv->_error_expression);
	VALA_CODE_NODE_CLASS (vala_throw_statement_parent_class)->finalize (obj);
}

/**
 * Represents a throw statement in the source code.
 */
static GType
vala_throw_statement_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ValaThrowStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_throw_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaThrowStatement), 0, (GInstanceInitFunc) vala_throw_statement_instance_init, NULL };
	static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_throw_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType vala_throw_statement_type_id;
	vala_throw_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaThrowStatement", &g_define_type_info, 0);
	g_type_add_interface_static (vala_throw_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	ValaThrowStatement_private_offset = g_type_add_instance_private (vala_throw_statement_type_id, sizeof (ValaThrowStatementPrivate));
	return vala_throw_statement_type_id;
}

GType
vala_throw_statement_get_type (void)
{
	static volatile gsize vala_throw_statement_type_id__volatile = 0;
	if (g_once_init_enter (&vala_throw_statement_type_id__volatile)) {
		GType vala_throw_statement_type_id;
		vala_throw_statement_type_id = vala_throw_statement_get_type_once ();
		g_once_init_leave (&vala_throw_statement_type_id__volatile, vala_throw_statement_type_id);
	}
	return vala_throw_statement_type_id__volatile;
}

