/*******************************************************************************
 * Part of "Intel(R) Active Management Technology (Intel(R) AMT)
 *                   User Notification Service (UNS)"
 *
 * Copyright (c) 2007 Intel Corp.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions, and the following disclaimer,
 *    without modification.
 * 2. Redistributions in binary form must reproduce at minimum a disclaimer
 *    substantially similar to the "NO WARRANTY" disclaimer below
 *    ("Disclaimer") and any redistribution must be conditioned upon
 *    including a substantially similar Disclaimer requirement for further
 *    binary redistribution.
 * 3. Neither the names of the above-listed copyright holders nor the names
 *    of any contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * Alternatively, this software may be distributed under the terms of the
 * GNU General Public License ("GPL") version 2 as published by the Free
 * Software Foundation.
 *
 * NO WARRANTY
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES.
 *******************************************************************************/

//----------------------------------------------------------------------------
//
//  File:       AMTVersn.h
//
//  Contents:   definitions for Host interface usage demonstration.
//
//----------------------------------------------------------------------------

#ifndef AMTVersn_H
#define AMTVersn_H

#include <string.h>
#include <stdio.h>
#include "PTHICommand.h"


//typedef UINT8 AMT_UUID[16];
#define MAX_TRIES 3

typedef unsigned short TCHAR;

/*
* Error codes
*/
static const PT_STATUS PT_STATUS_SUCCESS                          = 0;
static const PT_STATUS PT_STATUS_INTERNAL_ERROR                   = 0x0001;
static const PT_STATUS PT_STATUS_NOT_READY                        = 0x0002;
static const PT_STATUS PT_STATUS_INVALID_PT_MODE                  = 0x0003;
static const PT_STATUS PT_STATUS_INVALID_MESSAGE_LENGTH           = 0x0004;
static const PT_STATUS PT_STATUS_TABLE_FINGERPRINT_NOT_AVAILABLE  = 0x0005;
static const PT_STATUS PT_STATUS_INTEGRITY_CHECK_FAILED           = 0x0006;
static const PT_STATUS PT_STATUS_UNSUPPORTED_ISVS_VERSION         = 0x0007;
static const PT_STATUS PT_STATUS_APPLICATION_NOT_REGISTERED       = 0x0008;
static const PT_STATUS PT_STATUS_INVALID_REGISTRATION_DATA        = 0x0009;
static const PT_STATUS PT_STATUS_APPLICATION_DOES_NOT_EXIST       = 0x000a;
static const PT_STATUS PT_STATUS_NOT_ENOUGH_STORAGE               = 0x000b;
static const PT_STATUS PT_STATUS_INVALID_NAME                     = 0x000c;
static const PT_STATUS PT_STATUS_BLOCK_DOES_NOT_EXIST             = 0x000d;
static const PT_STATUS PT_STATUS_INVALID_BYTE_OFFSET              = 0x000e;
static const PT_STATUS PT_STATUS_INVALID_BYTE_COUNT               = 0x000f;
static const PT_STATUS PT_STATUS_NOT_PERMITTED                    = 0x0010;
static const PT_STATUS PT_STATUS_NOT_OWNER                        = 0x0011;
static const PT_STATUS PT_STATUS_BLOCK_LOCKED_BY_OTHER            = 0x0012;
static const PT_STATUS PT_STATUS_BLOCK_NOT_LOCKED                 = 0x0013;
static const PT_STATUS PT_STATUS_INVALID_GROUP_PERMISSIONS        = 0x0014;
static const PT_STATUS PT_STATUS_GROUP_DOES_NOT_EXIST             = 0x0015;
static const PT_STATUS PT_STATUS_INVALID_MEMBER_COUNT             = 0x0016;
static const PT_STATUS PT_STATUS_MAX_LIMIT_REACHED                = 0x0017;
static const PT_STATUS PT_STATUS_INVALID_AUTH_TYPE                = 0x0018;
static const PT_STATUS PT_STATUS_AUTHENTICATION_FAILED            = 0x0019;
static const PT_STATUS PT_STATUS_INVALID_DHCP_MODE                = 0x001a;
static const PT_STATUS PT_STATUS_INVALID_IP_ADDRESS               = 0x001b;
static const PT_STATUS PT_STATUS_INVALID_DOMAIN_NAME              = 0x001c;

static const PT_STATUS PT_STATUS_REQUEST_UNEXPECTED               = 0x001e;
static const PT_STATUS PT_STATUS_INVALID_TABLE_TYPE               = 0x001f;
static const PT_STATUS PT_STATUS_INVALID_PROVISIONING_MODE        = 0x0020;
static const PT_STATUS PT_STATUS_UNSUPPORTED_OBJECT               = 0x0021;
static const PT_STATUS PT_STATUS_INVALID_TIME                     = 0x0022;
static const PT_STATUS PT_STATUS_INVALID_INDEX                    = 0x0023;
static const PT_STATUS PT_STATUS_INVALID_PARAMETER                = 0x0024;

static const PT_STATUS PT_STATUS_FLASH_WRITE_LIMIT_EXCEEDED       = 0x0026;
static const PT_STATUS PT_STATUS_VALUES_NOT_EQUIVALENT			  = 0x1501;

static const PT_STATUS PT_STATUS_NETWORK_IF_ERROR_BASE            = 0x0800;
static const PT_STATUS PT_STATUS_SDK_DEFINED_ERROR_BASE           = 0x1000;

static const PT_STATUS PTSDK_STATUS_INTERNAL_ERROR                = 0x1000;
static const PT_STATUS PTSDK_STATUS_NOT_INITIALIZED               = 0x1001;
static const PT_STATUS PTSDK_STATUS_LIB_VERSION_UNSUPPORTED       = 0x1002;
static const PT_STATUS PTSDK_STATUS_INVALID_PARAM                 = 0x1003;
static const PT_STATUS PTSDK_STATUS_RESOURCES                     = 0x1004;
static const PT_STATUS PTSDK_STATUS_HARDWARE_ACCESS_ERROR         = 0x1005;
static const PT_STATUS PTSDK_STATUS_REQUESTOR_NOT_REGISTERED      = 0x1006;
static const PT_STATUS PTSDK_STATUS_NETWORK_ERROR                 = 0x1007;
static const PT_STATUS PTSDK_STATUS_PARAM_BUFFER_TOO_SHORT        = 0x1008;
static const PT_STATUS PTSDK_STATUS_COM_NOT_INITIALIZED_IN_THREAD = 0x1009;
static const PT_STATUS PTSDK_STATUS_URL_REQUIRED				  = 0x100a;

typedef enum _HARD_SKU
{
    HARD_SKU_AMT = 0,
    HARD_SKU_ASF = 1,
    HARD_SKU_FSC = 2,
    HARD_SKU_CB = 3,
    HARD_SKU_CRYPTO = 4,
} HARD_SKU;

typedef enum _ME_LAST_RESET_REASON
{
    ME_RESET_REASON_POWER_UP = 0,
    ME_RESET_REASON_FW_RESET = 1,
    ME_RESET_REASON_GLOBAL_SYSTEM_RESET = 2,
    ME_RESET_REASON_UNKOWN = 3,
} ME_LAST_RESET_REASON;

#pragma pack (1)
typedef struct _AMT_UUID
{
    UINT8 UUID[16];
} AMT_UUID;


typedef struct _STATE_GET_AMT_STATE_REQUEST
{
	PTHI_MESSAGE_HEADER	Header;
	AMT_UUID	StateVariableIdentifier;
} STATE_GET_AMT_STATE_REQUEST;

typedef struct _STATE_DATA
{
    UINT8 LinkStatus; // (0  down; 1  up).
    UINT8 HardSKU;  // UINT8 (TBD).
    UINT8 CryptoFuse; // (0 -  disabled; 1  enabled)
    UINT8 FlashProtaction; // (0  disabled; 1  enabled)
    UINT8 LastMEResetReason; // UINT8 (TBD)
} STATE_DATA;

typedef struct _STATE_GET_AMT_STATE_RESPONSE
{
	PTHI_MESSAGE_HEADER	Header;
	PT_STATUS	Status;
	AMT_UUID	StateDataIdentifier;
	UINT32	    ByteCount;
	STATE_DATA	StateData;
} STATE_GET_AMT_STATE_RESPONSE;


/* =================================================================================
						2.1 CHANGES START HERE
===================================================================================*/

typedef struct _STATE_GET_FW_UPDATE_COUNTERS_REQUEST
{
	PTHI_MESSAGE_HEADER	Header;
} STATE_GET_FW_UPDATE_COUNTERS_REQUEST;

typedef struct _STATE_GET_FW_UPDATE_COUNTERS_RESPONSE
{
	PTHI_MESSAGE_HEADER	Header;
	PT_STATUS	Status;
	UINT32 	OverrideCounter;
	UINT32 	OverrideQualifier;
} STATE_GET_FW_UPDATE_COUNTERS_RESPONSE;

typedef struct _STATE_GET_FLASH_DESCRIPTOR_OVERRIDE_REQUEST
{
	PTHI_MESSAGE_HEADER	Header;
} STATE_GET_FLASH_DESCRIPTOR_OVERRIDE_REQUEST;

typedef struct _STATE_GET_FLASH_DESCRIPTOR_OVERRIDE_RESPONSE
{
	PTHI_MESSAGE_HEADER	Header;
	PT_STATUS	Status;
	UINT32 	FlashDescriptorOverride;
} STATE_GET_FLASH_DESCRIPTOR_OVERRIDE_RESPONSE;

/* =================================================================================
						2.1 CHANGES END HERE
===================================================================================*/


typedef struct _CFG_GET_END_OF_BIOS_STATE_RESPONSE
{
	PTHI_MESSAGE_HEADER	Header;
	PT_STATUS	Status;
	UINT8	BiosMode;
} CFG_GET_END_OF_BIOS_STATE_RESPONSE;

typedef struct _CFG_GET_MAC_ADDRESSES_RESPONSE
{
	PTHI_MESSAGE_HEADER	Header;
	PT_STATUS	Status;
	UINT8	DedicatedMacAddress[6];
	UINT8	HostMacAddress[6];
} CFG_GET_MAC_ADDRESSES_RESPONSE;

#pragma pack ()
/*======================================================
struct AMT_COMUNICATION
{
	HANDLE  pHandle;
	HECI_CLIENT mProperties;
	DWORD  nBytes;
	int AmtConnect();
	int AmtWriteData(PCHAR command,ULONG command_size);
	int AmtReadData(BYTE * &ReadBuffer);
	int AmtHeciVersion(HECI_VERSION * &HeciVerBuf);
	int AmtDisConnect();
};
=================================================*/
struct MAC_ADDRESSES
{
	UINT8 DedicatedMacAddress[6];
	UINT8 HostMacAddress[6];
};
/*
* Constants
*/
const int DEDICATED_DEF = 1;
const int HOST_DEF = 2;
const UINT8 ENDOFPOST_BiosMode_Pre_Boot_mode = 0;
const UINT8 ENDOFPOST_BiosMode_In_Boot_Mode = 1;
const UINT8 ENDOFPOST_BiosMode_Post_Boot_Mode = 2;

const UINT32 AMT_STATE_REQUEST         = 0x01000001;
const UINT32 AMT_STATE_RESPONSE        = 0x01800001;


const AMT_UUID AMT_UUID_LINK_STATE =
    {0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x00,
     0x00, 0x00, 0x00, 0x01};

const STATE_GET_AMT_STATE_REQUEST GET_AMT_STATE =
{
    {
        {MAJOR_VERSION,MINOR_VERSION},0,{AMT_STATE_REQUEST},sizeof(AMT_UUID)
    },
    AMT_UUID_LINK_STATE
};
/*
const UINT32 ENDOFPOST_STATE_REQUEST    = 0x04000020;
const UINT32 ENDOFPOST_STATE_RESPONSE   = 0x04800020;

const PTHI_MESSAGE_HEADER GET_ENDOFPOST_STATE_HEADER =
{
    {MAJOR_VERSION,MINOR_VERSION},0,{ENDOFPOST_STATE_REQUEST},0
};
*/
const UINT32 MAC_ADRESSES_REQUEST    = 0x04000025;
const UINT32 MAC_ADRESSES_RESPONSE   = 0x04800025;

const PTHI_MESSAGE_HEADER GET_MAC_ADRESSES_HEADER =
{
    {MAJOR_VERSION,MINOR_VERSION},0,{MAC_ADRESSES_REQUEST},0
};


/* =================================================================================
						2.1 CHANGES START HERE
===================================================================================*/

const UINT32 FW_UPDATE_COUNTERS_REQUEST    = 0x01000002;
const UINT32 FW_UPDATE_COUNTERS_RESPONSE   = 0x01800002;

const PTHI_MESSAGE_HEADER GET_FW_UPDATE_COUNTERS_HEADER =
{
    {MAJOR_VERSION,MINOR_VERSION},0,{FW_UPDATE_COUNTERS_REQUEST},0
};
const UINT32 FLASH_DESCRIPTOR_OVERRIDE_REQUEST    = 0x01000000;
const UINT32 FLASH_DESCRIPTOR_OVERRIDE_RESPONSE   = 0x01800000;

const PTHI_MESSAGE_HEADER GET_FLASH_DESCRIPTOR_OVERRIDE_HEADER =
{
    {MAJOR_VERSION,MINOR_VERSION},0,{FLASH_DESCRIPTOR_OVERRIDE_REQUEST},0
};

/* =================================================================================
						2.1 CHANGES END HERE
===================================================================================*/

/*
* Function prototypes
*/
PT_STATUS VerifyResponseHeader(const UINT32 command,
                                const PTHI_MESSAGE_HEADER *response_header,
                                ULONG response_size/*,ULONG expected_size*/);
PT_STATUS VerifyCodeVersions(const CFG_GET_CODE_VERSIONS_RESPONSE *response);
bool VerifyBoolean(PT_BOOLEAN val);
void DisplayCodeVersions(const CODE_VERSIONS *versions);
void DisplayHeciVersions(const HECI_VERSION *hecversions);
//PT_STATUS GetCodeVersions(AMT_COMUNICATION &AmtComunication, CODE_VERSIONS *codeVersions, HECI_VERSION *heciversion);

PT_STATUS VerifyAmtState(const STATE_GET_AMT_STATE_RESPONSE *response);
void DisplayAmtState(const STATE_DATA *state);
//PT_STATUS GetAmtState(AMT_COMUNICATION &AmtComunication, STATE_DATA *state);

/* =================================================================================
						2.1 CHANGES START HERE
===================================================================================*/

PT_STATUS VerifyFWUpdateCounters(const STATE_GET_FW_UPDATE_COUNTERS_RESPONSE *response);
void DisplayFWUpdateCounters(UINT32 OverrideCounter, UINT32 OverrideQualifier, UINT32 flag);
//PT_STATUS GetFWUpdateCounters(AMT_COMUNICATION &AmtComunication,UINT32 *OverrideCounter, UINT32 *OverrideQualifier);

PT_STATUS VerifyFlashDescriptorOverride(const STATE_GET_FLASH_DESCRIPTOR_OVERRIDE_RESPONSE *response);
void DisplayFlashDescriptorOverride(UINT32 FlashDescriptorOverride);
//PT_STATUS GetFlashDescriptorOverride(AMT_COMUNICATION &AmtComunication,UINT32 *FlashDescriptorOverride);

//UINT32 IsAMT2_0(AMT_COMUNICATION AmtComunication);

/* =================================================================================
						2.1 CHANGES END HERE
===================================================================================*/

PT_STATUS VerifyProvisioningState(const CFG_GET_PROVISIONING_STATE_RESPONSE *response);
void DisplayProvisioningState(const AMT_PROVISIONING_STATE *state);
//PT_STATUS GetProvisioningState(AMT_COMUNICATION &AmtComunication, AMT_PROVISIONING_STATE *state);

PT_STATUS VerifyProvisioningMode(const CFG_GET_PROVISIONING_MODE_RESPONSE *response);
void DisplayProvisioningMode(const PT_BOOLEAN *legacy);
//PT_STATUS GetProvisioningMode(AMT_COMUNICATION &AmtComunication, PT_BOOLEAN *legacy);

/* $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
						2.5 CHANGES START HERE
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

//PT_STATUS GetKedronInfo(CHAR * HWVersion, CHAR * DriverVersion);
PT_STATUS VerifyKedronDriver(CHAR * SubKeyToOpen);
void DisplayKedronInfo(CHAR * HWVersion, CHAR * DriverVersion);

//PT_STATUS GetUNSVersion(VS_FIXEDFILEINFO *fileQuerInfo);
//void DisplayUNSVersion(VS_FIXEDFILEINFO *fileInfo);

/* $$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
						2.5 CHANGES END HERE
$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$*/

//PT_STATUS GetLMSVersion(VS_FIXEDFILEINFO *fileQuerInfo);
//void DisplayLMSVersion(VS_FIXEDFILEINFO *fileInfo);

//PT_STATUS GetEndOfPostState(AMT_COMUNICATION &AmtComunication, UINT8  *BiosModeState);
PT_STATUS VerifyEndOfPostState(const CFG_GET_END_OF_BIOS_STATE_RESPONSE *response);
void DisplayBiosModeState(UINT8 BiosModeState);

//PT_STATUS GetMacAddresses(AMT_COMUNICATION &AmtComunication,MAC_ADDRESSES *macadresses);
PT_STATUS VerifyGetMacAddresses(const CFG_GET_MAC_ADDRESSES_RESPONSE *response);
void DisplayMacAddresses(MAC_ADDRESSES macadresses);

//PT_STATUS GetReqValue(AMT_COMUNICATION &AmtComunication,char* featName,char* inputValue);
PT_STATUS GetReqFeature(PTHICommand &command,char* featName);
void DisplayMeDataVersion();
#endif // AMTVersn_H



