/*PROTECTED REGION ID(TangoAccessControl::main.cpp) ENABLED START*/
static const char *RcsId = "$Id: main.cpp 22232 2013-03-08 12:31:49Z pascal_verdier $";
//=============================================================================
//
// file :        TangoAccessControl.cpp
//
// description : C++ source for the TangoAccessControl device server main.
//               The main rule is to initialise (and create) the Tango
//               system and to create the DServerClass singleton.
//                The main should be the same for every Tango device server.
//
// project :     Tango Access Control Management.
//
//
// Copyright (C) :      2004,2005,2006,2007,2008,2009,2010,2011,2012,2013
//						European Synchrotron Radiation Facility
//                      BP 220, Grenoble 38043
//                      FRANCE
//
// This file is part of Tango.
//
// Tango is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// Tango is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with Tango.  If not, see <http://www.gnu.org/licenses/>.
//
//
// $Author: pascal_verdier $
//
// $Revision: 22232 $
// $Date: 2013-03-08 13:31:49 +0100 (Fri, 08 Mar 2013) $
//
// SVN only:
// $HeadURL:  $
//
// CVS only:
// $Source$
// $Log$
//
//=============================================================================
//                This file is generated by POGO
//        (Program Obviously used to Generate tango Object)
//=============================================================================



#include <tango.h>


int main(int argc,char *argv[])
{

	Tango::Util *tg = NULL;
	try
	{
		// Initialise the device server
		//----------------------------------------
		tg = Tango::Util::init(argc,argv);

		// Create the device server singleton 
		//	which will create everything
		//----------------------------------------
		tg->server_init(false);

		// Run the endless loop
		//----------------------------------------
		cout << "Ready to accept request" << endl;
		tg->server_run();
	}
	catch (bad_alloc)
	{
		cout << "Can't allocate memory to store device object !!!" << endl;
		cout << "Exiting" << endl;
	}
	catch (CORBA::Exception &e)
	{
		Tango::Except::print_exception(e);
		
		cout << "Received a CORBA_Exception" << endl;
		cout << "Exiting" << endl;
	}
	tg->server_cleanup();
	return(0);
}


/*PROTECTED REGION END*/	//	TangoAccessControl::main.cpp
