/*
 *   Copyright (C) 2008, 2009 Nicolas Vion <nico@yojik.eu>
 *
 *   This file is part of Swac-scan.
 * 
 *   Swac-scan is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *   
 *   Swac-scan is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *   
 *   You should have received a copy of the GNU General Public License
 *   along with Swac-scan.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <iostream>
#include <FLAC++/metadata.h>

#include "flac.hh"

bool TagFlac::extract_from_file(std::string const path, bool const ignore_standards_fields) {
	Tag::extract_from_file(path);

	FLAC__StreamMetadata *metadata;
	FLAC__metadata_get_tags(path.c_str(), &metadata);  	

	if (metadata == NULL) {
		std::cerr << "ERROR: Unable to read flac file." << std::endl;
		return false;
	}

	if (metadata->type == FLAC__METADATA_TYPE_VORBIS_COMMENT) {
		unsigned int i;
		for (i = 0; i < metadata->data.vorbis_comment.num_comments; i++)
			add_vector((const char*) metadata->data.vorbis_comment.comments[i].entry, ignore_standards_fields);
	}

	FLAC__metadata_object_delete(metadata);
	return true;
}


