3.5 Kawałki Sampli

# Kawałki Sampli

Ta sekcja sfinalizuje nasze odkrywanie odtwarzacza sampli dostępnego 
w Sonic Pi. Zróbym szybkie podsumowanie. Do tej pory wiemy już 
w jaki sposób uruchamiać sample:

```
sample :loop_amen
```

Następnie dowiedzieliśmy się w jaki sposób można zmieniać parametry 
sampli, np. w jaki sposób możemy zagrac wybraną próbke w tempie 
równym połowie normalnego: 

```
sample :loop_amen, rate: 0.5
```

Kolejną rzeczą jakiej się nauczyliśmy była umiejętność stopniowego 
wchodzenia sampla (spróbujmy zrobić to dla sampla zagranego w połowie 
jego normalnego tempa):

```
sample :loop_amen, rate: 0.5, attack: 1
```

Dowiedzieliśmy się również, że za pomocą podania konkretnych krótkich 
wartości dla parametrów podtrzymania `sustain:` oraz ataku możemy 
uzyskać perkusyjne brzmienie:

```
sample :loop_amen, rate: 2, attack: 0.01, sustain: 0, release: 0.35
```

Jednakże, czy nie było by fajnie gdybyśmy nie musieli zawsze zaczynać 
odtwarzania sampla od jego początku? Czy nie było by fajnie gdybyśmy 
nie musieli też zawsze kończyć odtwarzania sampla dopiero w momencie 
jego końca?

## Wybór momentu startu

Możliwe jest wybranie bezwzględnego momentu startu, od którego uruchomimy 
sampel za pomocą podania liczby o wielkości od 0 do 1, gdzie 0 to początek 
sampla, 1 oznacza koniec sampla, a 0.5 to połowa sampla. Spróbujmy zagrać 
tylko drugą połowę sampla amen break:

```
sample :loop_amen, start: 0.5
```

A teraz spróbujmy zagrać ostatnią ćwiartke sampla: 

```
sample :loop_amen, start: 0.75
```

## Wybór momentu zakończenia

Analogicznie, jest również możliwy wybór bezwzględnego momentu końca 
odtwarzania sampla za pomocą wartości pomiędzy 0 a 1. Spróbujmy skończyć 
sampel amen break w połowie czasu:

```
sample :loop_amen, finish: 0.5
```

## Ustawianie startu i zakończenia

Nic nam nie stoi na przeszkodzie, abyśmy połączyli oba powyższe parametry 
aby zagrać wybrane kawałki z danego sampla. Co powiesz na wycięcie tylko 
małego kawałka ze środka:

```
sample :loop_amen, start: 0.4, finish: 0.6
```

Co się stanie jeśli ustawimy moment startu tak aby znajdował się 
po momencie końca?

```
sample :loop_amen, start: 0.6, finish: 0.4
```

Świetnie! Wybrany kawałek jest odtwarzany od końca!

## Łączenie z tempem

Możemy teraz połączyć tę nową możliwość odtwarzania wybrancyh części dźwięku 
z naszym startym dobrym znajomym parametrem tempa `rate:`. Na przykład, możemy 
zagrać bardzo mały kawałek ze środka sampla amen break w bardzo wolnym tempie: 

```
sample :loop_amen, start: 0.5, finish: 0.7, rate: 0.2
```

## Łączenie z obwiedniami

Na sam koniec, możemy połączyć wszytkie powyższe możliwości z naszą obwiednią 
ADSR aby wyprodukować bardzo ciekawe rezultaty:

```
sample :loop_amen, start: 0.5, finish: 0.8, rate: -0.2, attack: 0.3, release: 1
```

A teraz idź i spróbuj pobawić się zmieniając sample wykorzystując cały ten kram...
