/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright (c) 2003-2012 by AG-Software 											 *
 * All Rights Reserved.																 *
 * Contact information for AG-Software is available at http://www.ag-software.de	 *
 *																					 *
 * Licence:																			 *
 * The agsXMPP SDK is released under a dual licence									 *
 * agsXMPP can be used under either of two licences									 *
 * 																					 *
 * A commercial licence which is probably the most appropriate for commercial 		 *
 * corporate use and closed source projects. 										 *
 *																					 *
 * The GNU Public License (GPL) is probably most appropriate for inclusion in		 *
 * other open source projects.														 *
 *																					 *
 * See README.html for details.														 *
 *																					 *
 * For general enquiries visit our website at:										 *
 * http://www.ag-software.de														 *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

using agsXMPP.Xml.Dom;

namespace agsXMPP.protocol.extensions.chatstates
{
    /// <summary>
    /// User has not been actively participating in the chat session.
    /// User has not interacted with the chat interface for an intermediate period of time (e.g., 30 seconds).
    /// </summary>
    public class Inactive : Element
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="Inactive"/> class.
        /// </summary>
        public Inactive()
        {
            TagName    = Chatstate.inactive.ToString();
            Namespace  = Uri.CHATSTATES;
        }
    }
}