/*--------------------------------------------------------------------*//*:Ignore this sentence.
Copyright (C) 1999, 2001, 2005 SIL International. All rights reserved.

Distributable under the terms of the GNU Lesser General Public License, as specified in the LICENSING.txt file.

File: PangoGrFont.h
Responsibility: Daniel Glassey
Last reviewed: Not yet.

Description:
    A Font is an object that represents a font-family + bold + italic setting, that contains
	Graphite tables.
----------------------------------------------------------------------------------------------*/
#ifndef PANGOGRFONT_INCLUDED
#define PANGOGRFONT_INCLUDED
#include <graphite/GrClient.h>
#include <graphite/GrDebug.h>
#include "FreetypeFont.h"
#include <pango/pangofc-font.h>
//:End Ignore


namespace gr
{

enum 
{
        kMaxFaceLength = 32
};

/*-----------------------------------------------------------------------------
	Stock implementation of an Xft font class. 
------------------------------------------------------------------------------*/
/** 
* An implementation of the Graphite gr::Font class for Xft fonts for use on
* systems using X. Freetype is used to retrieve font information.
* If you are using Freetype directly, without Xft, you can pass in a FT_Face
* directly.
*/
class PangoGrFont : public FreetypeFont
{
public:
  /**
  * The main user constructor. Constructs the font from the supplied XftFont.
  * @param xftFont the XftFont pointer to initialise from (must not be null)
  */
  PangoGrFont(PangoFcFont * l_pFont);
  
  /**
  * Alternative user constructor. Constructs the font from the supplied FT_Face.
  * @param ftFace the FT_Face handle to initialise from (must not be null)
  */
  //PangoGrFont(FT_Face ftFace);
  
  /**
  * Destructor - cleans up the tables that it has allocated if all other copies
  * of this font have been deleted.
  */
  virtual ~PangoGrFont();
  
  /**
  * Returns a copy of the recipient. Specifically needed to store the Font 
  * in a segment. 
  * @internal
  */
  virtual gr::Font * copyThis();
  
  /**
  * Copy constructor - note the tables are shared between the copy and the
  * original font for efficiency reasons. 
  * The last copy to be deleted will delete the tables.
  * @param font the XftGrFont object to copy from.
  * @internal
  */
  PangoGrFont(PangoGrFont & font);
  /**
  * Returns true if the given arguments specify a font that contains Graphite
  * tables—specfically an “Silf” table.
  * @param xftFont XftFont pointer
  * @return true if this font has the silf table
  */
  static bool FontHasGraphiteTables(PangoFcFont * xftFont);
  
  //bool bold() {return m_fBold;};
  //bool italic() {return m_fItalic;};
  const char *facename() {return m_stFace;};
  
  bool operator!=(PangoGrFont & font);

  virtual FT_Face lockFace(void);
  virtual void unlockFace(void);

private:
  /** Default constructor is not used */
  PangoGrFont();

  PangoFcFont *m_fcFont;
  long m_cref;
  char m_stFace[kMaxFaceLength];
  bool m_locked;
};


} // namespace gr

#endif


