 /****************************************************************************
 **
 ** Copyright (C) 2005-2007 Trolltech ASA. All rights reserved.
 **
 ** This file is part of the example classes of the Qt Toolkit.
 **
 ** This file may be used under the terms of the GNU General Public
 ** License version 2.0 as published by the Free Software Foundation
 ** and appearing in the file LICENSE.GPL included in the packaging of
 ** this file.  Please review the following information to ensure GNU
 ** General Public Licensing requirements will be met:
 ** http://trolltech.com/products/qt/licenses/licensing/opensource/
 **
 ** If you are unsure which license is appropriate for your use, please
 ** review the following information:
 ** http://trolltech.com/products/qt/licenses/licensing/licensingoverview
 ** or contact the sales department at sales@trolltech.com.
 **
 ** In addition, as a special exception, Trolltech gives you certain
 ** additional rights. These rights are described in the Trolltech GPL
 ** Exception version 1.0, which can be found at
 ** http://www.trolltech.com/products/qt/gplexception/ and in the file
 ** GPL_EXCEPTION.txt in this package.
 **
 ** In addition, as a special exception, Trolltech, as the sole copyright
 ** holder for Qt Designer, grants users of the Qt/Eclipse Integration
 ** plug-in the right for the Qt/Eclipse Integration to link to
 ** functionality provided by Qt Designer and its related libraries.
 **
 ** Trolltech reserves all rights not expressly granted herein.
 **
 ** Trolltech ASA (c) 2007
 **
 ** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 ** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 **
 ****************************************************************************/

#include <QtGui>

#include "highlighter.h"

 Highlighter::Highlighter(QTextDocument *parent)
     : QSyntaxHighlighter(parent){
 }

 Highlighter::Highlighter(QString FileName, QTextDocument *parent)
     : QSyntaxHighlighter(parent){
   //    setEditStyle();
     printf("Highlighter\n");
       loadHighlightPatterns(FileName);
 }

void Highlighter::highlightSearch(const QString &find){
  HighlightingRule rule;
  rule.format.setBackground(Qt::yellow);
  rule.format.setFontWeight(QFont::Black);//
  findRule.clear();
  QString f=find;
  f.replace(".*",".+");
  if ((f=="^")||(f=="$"))return;
  if (!f.isEmpty()){
  rule.pattern = QRegularExpression(f, QRegularExpression::CaseInsensitiveOption);

  findRule.append( rule);
  }
//  printf("suchSuch\n");
  rehighlight();
}

void Highlighter::highlightError(const QStringList fnd){
  findRule.clear();
  HighlightingRule rule;
  rule.format.setFontWeight(QFont::Black);
  rule.format.setForeground(Qt::yellow);
  rule.format.setFontUnderline(true);
  rule.format.setUnderlineStyle(QTextCharFormat::WaveUnderline);
  rule.format.setUnderlineColor(Qt::red);
  rule.format.setBackground(QColor(Qt::red).lighter(100));
  QString f="";
  for (int i=0;i<fnd.size();i++){
      f=fnd.at(i);
      if (!f.isEmpty()){
    rule.pattern = QRegularExpression(f, QRegularExpression::CaseInsensitiveOption);//fixedString was in QRegExp

	findRule.append( rule);
      }
  }
//  printf("suchSuch\n");
  rehighlight();
}

void Highlighter::highlightDupl(const CEnvironment &dupls){
    findRule.clear();
    if (dupls.size()==0){rehighlight();return;}
  HighlightingRule rule;
  rule.format.setBackground(QColor("orange"));
  rule.format.setForeground(Qt::blue);
  rule.format.setFontWeight(QFont::Black);//
  findRule.clear();
  QString f="";
  for (int i=0;i<dupls.size();i++){
      f=dupls.at(i).orginalLine;
  if (!f.isEmpty()){
  rule.pattern = QRegularExpression(f, QRegularExpression::CaseInsensitiveOption);

  findRule.append( rule);
  }
  }
//  printf("suchSuch\n");
  rehighlight();
}

void Highlighter::highlightBlock(const QString &text) {    
    //QElapsedTimer stech;
    //stech.start();
  foreach (HighlightingRule rule, highlightingRules) {
    if (rule.Comment) continue;
    QRegularExpressionMatchIterator matchIterator = rule.pattern.globalMatch(text);
    while (matchIterator.hasNext()) {
        QRegularExpressionMatch match = matchIterator.next();
        setFormat(match.capturedStart(), match.capturedLength(), rule.format);
    }
  }
  foreach (HighlightingRule rule, highlightingRules) {
    if (!rule.Comment) continue;
    QRegularExpressionMatchIterator matchIterator = rule.pattern.globalMatch(text);
    while (matchIterator.hasNext()) {
        QRegularExpressionMatch match = matchIterator.next();
        setFormat(match.capturedStart(), match.capturedLength(), rule.format);
    }
  }
  setCurrentBlockState(0);
  if (!outputstyle) {
  int startIndex = 0;
  if (previousBlockState() != 1){
    startIndex = text.indexOf(commentStartExpression);
  }
  QTextCharFormat fmt = format(startIndex);
  if (fmt.foreground()==Qt::blue) startIndex=-1;
  while (startIndex >= 0) {
    QRegularExpressionMatch match = commentEndExpression.match(text, startIndex);
    int endIndex = match.capturedStart();
    int commentLength = 0;
    if (endIndex == -1) {
        setCurrentBlockState(1);
        commentLength = text.length() - startIndex;
    } else {
        commentLength = endIndex - startIndex
                        + match.capturedLength();
    }
    setFormat(startIndex, commentLength, multiLineCommentFormat);
    startIndex = text.indexOf(commentStartExpression, startIndex + commentLength);
    fmt = format(startIndex);
    if (fmt.foreground()==Qt::blue) startIndex=-1;
    if (fmt.underlineStyle()) startIndex=-1;
  }
  foreach (HighlightingRule rule, highlightingRules) {
    if (!rule.Comment) continue;
    QRegularExpressionMatchIterator matchIterator = rule.pattern.globalMatch(text);
    while (matchIterator.hasNext()) {
        QRegularExpressionMatch match = matchIterator.next();
        setFormat(match.capturedStart(), match.capturedLength(), rule.format);
    }
  }
  }
/*
  rule.pattern =  QRegularExpression("\\b[0-9]{2,}\\.[0-9]+\\b");
  rule.format = numberFormat;

  expression = QRegularExpression(rule.pattern);
  index = text.indexOf(expression);
  while (index >= 0) {
    int length = expression.matchedLength();
    setFormat(index, length, rule.format);
    index = text.indexOf(expression, index + length);
  } */
  foreach (HighlightingRule rule, findRule) {
    QRegularExpressionMatchIterator matchIterator = rule.pattern.globalMatch(text);
    while (matchIterator.hasNext()) {
        QRegularExpressionMatch match = matchIterator.next();
        setFormat(match.capturedStart(), match.capturedLength(), rule.format);
    }
  }
//  printf("hi blo\n");
  //fprintf(stderr,"hiliblo %dms\n",stech.elapsed());
}

void Highlighter::loadHighlightPatterns(QString FileName){
    QElapsedTimer stech;
    stech.start();
  //int group=1;  
  highlightingRules.clear();
  outputstyle=true;
  //fprintf(stderr,"loadHighlightPatterns %s\n",FileName.toStdString().c_str());
  QSettings *pat = new QSettings(FileName,QSettings::IniFormat);
  /*foreach(HighlightingRule rule, highlightingRules){  
    pat->beginGroup(QString("%1").arg(group));
    pat->setValue("Pattern"     ,rule.pattern.pattern());
    pat->setValue("Color"           ,rule.format.foreground().color().name());
    pat->setValue("Background"      ,rule.format.background().color().name());
    pat->setValue("Weight"          ,rule.format.fontWeight());
    pat->setValue("Underlined"      ,rule.format.fontUnderline());
    pat->setValue("UnderlineStyle"  ,rule.format.underlineStyle());
    pat->setValue("UnderlineColor"  ,rule.format.underlineColor().name());
    pat->setValue("Overlined"       ,rule.format.fontOverline());
    pat->setValue("CaseSensitive"   ,rule.pattern.caseSensitivity()); 
    pat->endGroup();
    group++;
    }*/
  static HighlightingRule rule;
  QStringList groups = pat->childGroups();
  static QRegularExpression Dplus = QRegularExpression("\\D+");
  foreach (QString grp,groups){
    if (!grp.contains(Dplus)){
      pat->beginGroup(grp);
      rule.pattern.setPattern(pat->value("Pattern","").toString());
      rule.pattern.setPatternOptions( QRegularExpression::CaseInsensitiveOption);
      rule.format.setForeground(QColor(pat->value("Color"           ,"#000000").toString()));
      rule.format.setBackground(QColor(pat->value("Background"      ,"#ffffff").toString()));
      rule.format.setFontWeight(pat->value("Weight"          ,50).toInt());
      rule.format.setFontUnderline(pat->value("Underlined"      ,"false").toBool());
      rule.format.setUnderlineStyle((QTextCharFormat::UnderlineStyle) pat->value("UnderlineStyle"  ,"1").toInt());
      rule.format.setUnderlineColor(QColor(pat->value("UnderlineColor"  ,rule.format.foreground().color().name()).toString()));
      rule.format.setFontOverline(pat->value("Overlined"       ,"false").toBool());
      rule.Comment=pat->value("Comment","false").toBool();
      //rule.pattern.setPatternOptions(static_cast<QRegularExpression::PatternOptions>(pat->value("CaseSensitive"   ,0).toInt()));
      pat->endGroup();
      highlightingRules.append(rule);
    }else{
      pat->beginGroup(grp);
      multiLineCommentFormat.setForeground(QColor(pat->value("MultilineColor" ,"#000000").toString()));
      multiLineCommentFormat.setBackground(QColor(pat->value("MultilineBackground" ,"#eefffe").toString()));
      multiLineCommentFormat.setFontUnderline(pat->value("MultilineUnderlined"      ,"false").toBool());
      commentStartExpression.setPattern(pat->value("MultilineStart","=\\s*$").toString());
      commentEndExpression.setPattern(pat->value("MultilineiEnd","^ [^=]*$").toString());
      outputstyle=false;
    }
  }
  fprintf(stderr,"finished loadHighlightPatterns %s outputstyle=%s  %dms\n",FileName.toStdString().c_str(),(outputstyle)?"true":"false",stech.elapsed());
}
